"""**Document Loaders**  are classes to load Documents.

**Document Loaders** are usually used to load a lot of Documents in a single run.

**Class hierarchy:**

.. code-block::

    BaseLoader --> <name>Loader  # Examples: TextLoader, UnstructuredFileLoader

**Main helpers:**

.. code-block::

    Document, <name>TextSplitter
"""

from typing import TYPE_CHECKING, Any

from langchain._api import create_importer

if TYPE_CHECKING:
    from aibaba_ai_community.document_loaders import (
        AcreomLoader,
        AirbyteCDKLoader,
        AirbyteGongLoader,
        AirbyteHubspotLoader,
        AirbyteJSONLoader,
        AirbyteSalesforceLoader,
        AirbyteShopifyLoader,
        AirbyteStripeLoader,
        AirbyteTypeformLoader,
        AirbyteZendeskSupportLoader,
        AirtableLoader,
        AmazonTextractPDFLoader,
        ApifyDatasetLoader,
        ArcGISLoader,
        ArxivLoader,
        AssemblyAIAudioTranscriptLoader,
        AsyncChromiumLoader,
        AsyncHtmlLoader,
        AZLyricsLoader,
        AzureAIDataLoader,
        AzureBlobStorageContainerLoader,
        AzureBlobStorageFileLoader,
        BibtexLoader,
        BigQueryLoader,
        BiliBiliLoader,
        BlackboardLoader,
        BlockchainDocumentLoader,
        BraveSearchLoader,
        BrowserlessLoader,
        BSHTMLLoader,
        ChatGPTLoader,
        CollegeConfidentialLoader,
        ConcurrentLoader,
        ConfluenceLoader,
        CoNLLULoader,
        CouchbaseLoader,
        CSVLoader,
        CubeSemanticLoader,
        DatadogLogsLoader,
        DataFrameLoader,
        DiffbotLoader,
        DirectoryLoader,
        DiscordChatLoader,
        DocugamiLoader,
        DocusaurusLoader,
        Docx2txtLoader,
        DropboxLoader,
        DuckDBLoader,
        EtherscanLoader,
        EverNoteLoader,
        FacebookChatLoader,
        FaunaLoader,
        FigmaFileLoader,
        FileSystemBlobLoader,
        GCSDirectoryLoader,
        GCSFileLoader,
        GeoDataFrameLoader,
        GitbookLoader,
        GithubFileLoader,
        GitHubIssuesLoader,
        GitLoader,
        GoogleApiClient,
        GoogleApiYoutubeLoader,
        GoogleDriveLoader,
        GoogleSpeechToTextLoader,
        GutenbergLoader,
        HNLoader,
        HuggingFaceDatasetLoader,
        IFixitLoader,
        ImageCaptionLoader,
        IMSDbLoader,
        IuguLoader,
        JoplinLoader,
        JSONLoader,
        LakeFSLoader,
        LarkSuiteDocLoader,
        MastodonTootsLoader,
        MathpixPDFLoader,
        MaxComputeLoader,
        MergedDataLoader,
        MHTMLLoader,
        ModernTreasuryLoader,
        MongodbLoader,
        MWDumpLoader,
        NewsURLLoader,
        NotebookLoader,
        NotionDBLoader,
        NotionDirectoryLoader,
        OBSDirectoryLoader,
        OBSFileLoader,
        ObsidianLoader,
        OneDriveFileLoader,
        OneDriveLoader,
        OnlinePDFLoader,
        OpenCityDataLoader,
        OutlookMessageLoader,
        PagedPDFSplitter,
        PDFMinerLoader,
        PDFMinerPDFasHTMLLoader,
        PDFPlumberLoader,
        PlaywrightURLLoader,
        PolarsDataFrameLoader,
        PsychicLoader,
        PubMedLoader,
        PyMuPDFLoader,
        PyPDFDirectoryLoader,
        PyPDFium2Loader,
        PyPDFLoader,
        PySparkDataFrameLoader,
        PythonLoader,
        ReadTheDocsLoader,
        RecursiveUrlLoader,
        RedditPostsLoader,
        RoamLoader,
        RocksetLoader,
        RSSFeedLoader,
        S3DirectoryLoader,
        S3FileLoader,
        SeleniumURLLoader,
        SharePointLoader,
        SitemapLoader,
        SlackDirectoryLoader,
        SnowflakeLoader,
        SpreedlyLoader,
        SRTLoader,
        StripeLoader,
        TelegramChatApiLoader,
        TelegramChatFileLoader,
        TelegramChatLoader,
        TencentCOSDirectoryLoader,
        TencentCOSFileLoader,
        TensorflowDatasetLoader,
        TextLoader,
        ToMarkdownLoader,
        TomlLoader,
        TrelloLoader,
        TwitterTweetLoader,
        UnstructuredAPIFileIOLoader,
        UnstructuredAPIFileLoader,
        UnstructuredCSVLoader,
        UnstructuredEmailLoader,
        UnstructuredEPubLoader,
        UnstructuredExcelLoader,
        UnstructuredFileIOLoader,
        UnstructuredFileLoader,
        UnstructuredHTMLLoader,
        UnstructuredImageLoader,
        UnstructuredMarkdownLoader,
        UnstructuredODTLoader,
        UnstructuredOrgModeLoader,
        UnstructuredPDFLoader,
        UnstructuredPowerPointLoader,
        UnstructuredRSTLoader,
        UnstructuredRTFLoader,
        UnstructuredTSVLoader,
        UnstructuredURLLoader,
        UnstructuredWordDocumentLoader,
        UnstructuredXMLLoader,
        WeatherDataLoader,
        WebBaseLoader,
        WhatsAppChatLoader,
        WikipediaLoader,
        XorbitsLoader,
        YoutubeAudioLoader,
        YoutubeLoader,
        YuqueLoader,
    )

from aibaba_ai_core.document_loaders import Blob, BlobLoader

# For backwards compatibility
_old_to_new_name = {
    "PagedPDFSplitter": "PyPDFLoader",
    "TelegramChatLoader": "TelegramChatFileLoader",
}

# Create a way to dynamically look up deprecated imports.
# Used to consolidate logic for raising deprecation warnings and
# handling optional imports.
DEPRECATED_LOOKUP = {
    "AcreomLoader": "aibaba_ai_community.document_loaders",
    "AsyncHtmlLoader": "aibaba_ai_community.document_loaders",
    "AsyncChromiumLoader": "aibaba_ai_community.document_loaders",
    "AZLyricsLoader": "aibaba_ai_community.document_loaders",
    "AirbyteCDKLoader": "aibaba_ai_community.document_loaders",
    "AirbyteGongLoader": "aibaba_ai_community.document_loaders",
    "AirbyteJSONLoader": "aibaba_ai_community.document_loaders",
    "AirbyteHubspotLoader": "aibaba_ai_community.document_loaders",
    "AirbyteSalesforceLoader": "aibaba_ai_community.document_loaders",
    "AirbyteShopifyLoader": "aibaba_ai_community.document_loaders",
    "AirbyteStripeLoader": "aibaba_ai_community.document_loaders",
    "AirbyteTypeformLoader": "aibaba_ai_community.document_loaders",
    "AirbyteZendeskSupportLoader": "aibaba_ai_community.document_loaders",
    "AirtableLoader": "aibaba_ai_community.document_loaders",
    "AmazonTextractPDFLoader": "aibaba_ai_community.document_loaders",
    "ApifyDatasetLoader": "aibaba_ai_community.document_loaders",
    "ArcGISLoader": "aibaba_ai_community.document_loaders",
    "ArxivLoader": "aibaba_ai_community.document_loaders",
    "AssemblyAIAudioTranscriptLoader": "aibaba_ai_community.document_loaders",
    "AzureAIDataLoader": "aibaba_ai_community.document_loaders",
    "AzureBlobStorageContainerLoader": "aibaba_ai_community.document_loaders",
    "AzureBlobStorageFileLoader": "aibaba_ai_community.document_loaders",
    "BSHTMLLoader": "aibaba_ai_community.document_loaders",
    "BibtexLoader": "aibaba_ai_community.document_loaders",
    "BigQueryLoader": "aibaba_ai_community.document_loaders",
    "BiliBiliLoader": "aibaba_ai_community.document_loaders",
    "BlackboardLoader": "aibaba_ai_community.document_loaders",
    "Blob": "aibaba_ai_community.document_loaders",
    "BlobLoader": "aibaba_ai_community.document_loaders",
    "BlockchainDocumentLoader": "aibaba_ai_community.document_loaders",
    "BraveSearchLoader": "aibaba_ai_community.document_loaders",
    "BrowserlessLoader": "aibaba_ai_community.document_loaders",
    "CSVLoader": "aibaba_ai_community.document_loaders",
    "ChatGPTLoader": "aibaba_ai_community.document_loaders",
    "CoNLLULoader": "aibaba_ai_community.document_loaders",
    "CollegeConfidentialLoader": "aibaba_ai_community.document_loaders",
    "ConcurrentLoader": "aibaba_ai_community.document_loaders",
    "ConfluenceLoader": "aibaba_ai_community.document_loaders",
    "CouchbaseLoader": "aibaba_ai_community.document_loaders",
    "CubeSemanticLoader": "aibaba_ai_community.document_loaders",
    "DataFrameLoader": "aibaba_ai_community.document_loaders",
    "DatadogLogsLoader": "aibaba_ai_community.document_loaders",
    "DiffbotLoader": "aibaba_ai_community.document_loaders",
    "DirectoryLoader": "aibaba_ai_community.document_loaders",
    "DiscordChatLoader": "aibaba_ai_community.document_loaders",
    "DocugamiLoader": "aibaba_ai_community.document_loaders",
    "DocusaurusLoader": "aibaba_ai_community.document_loaders",
    "Docx2txtLoader": "aibaba_ai_community.document_loaders",
    "DropboxLoader": "aibaba_ai_community.document_loaders",
    "DuckDBLoader": "aibaba_ai_community.document_loaders",
    "EtherscanLoader": "aibaba_ai_community.document_loaders",
    "EverNoteLoader": "aibaba_ai_community.document_loaders",
    "FacebookChatLoader": "aibaba_ai_community.document_loaders",
    "FaunaLoader": "aibaba_ai_community.document_loaders",
    "FigmaFileLoader": "aibaba_ai_community.document_loaders",
    "FileSystemBlobLoader": "aibaba_ai_community.document_loaders",
    "GCSDirectoryLoader": "aibaba_ai_community.document_loaders",
    "GCSFileLoader": "aibaba_ai_community.document_loaders",
    "GeoDataFrameLoader": "aibaba_ai_community.document_loaders",
    "GitHubIssuesLoader": "aibaba_ai_community.document_loaders",
    "GitLoader": "aibaba_ai_community.document_loaders",
    "GithubFileLoader": "aibaba_ai_community.document_loaders",
    "GitbookLoader": "aibaba_ai_community.document_loaders",
    "GoogleApiClient": "aibaba_ai_community.document_loaders",
    "GoogleApiYoutubeLoader": "aibaba_ai_community.document_loaders",
    "GoogleSpeechToTextLoader": "aibaba_ai_community.document_loaders",
    "GoogleDriveLoader": "aibaba_ai_community.document_loaders",
    "GutenbergLoader": "aibaba_ai_community.document_loaders",
    "HNLoader": "aibaba_ai_community.document_loaders",
    "HuggingFaceDatasetLoader": "aibaba_ai_community.document_loaders",
    "IFixitLoader": "aibaba_ai_community.document_loaders",
    "IMSDbLoader": "aibaba_ai_community.document_loaders",
    "ImageCaptionLoader": "aibaba_ai_community.document_loaders",
    "IuguLoader": "aibaba_ai_community.document_loaders",
    "JSONLoader": "aibaba_ai_community.document_loaders",
    "JoplinLoader": "aibaba_ai_community.document_loaders",
    "LarkSuiteDocLoader": "aibaba_ai_community.document_loaders",
    "LakeFSLoader": "aibaba_ai_community.document_loaders",
    "MHTMLLoader": "aibaba_ai_community.document_loaders",
    "MWDumpLoader": "aibaba_ai_community.document_loaders",
    "MastodonTootsLoader": "aibaba_ai_community.document_loaders",
    "MathpixPDFLoader": "aibaba_ai_community.document_loaders",
    "MaxComputeLoader": "aibaba_ai_community.document_loaders",
    "MergedDataLoader": "aibaba_ai_community.document_loaders",
    "ModernTreasuryLoader": "aibaba_ai_community.document_loaders",
    "MongodbLoader": "aibaba_ai_community.document_loaders",
    "NewsURLLoader": "aibaba_ai_community.document_loaders",
    "NotebookLoader": "aibaba_ai_community.document_loaders",
    "NotionDBLoader": "aibaba_ai_community.document_loaders",
    "NotionDirectoryLoader": "aibaba_ai_community.document_loaders",
    "OBSDirectoryLoader": "aibaba_ai_community.document_loaders",
    "OBSFileLoader": "aibaba_ai_community.document_loaders",
    "ObsidianLoader": "aibaba_ai_community.document_loaders",
    "OneDriveFileLoader": "aibaba_ai_community.document_loaders",
    "OneDriveLoader": "aibaba_ai_community.document_loaders",
    "OnlinePDFLoader": "aibaba_ai_community.document_loaders",
    "OpenCityDataLoader": "aibaba_ai_community.document_loaders",
    "OutlookMessageLoader": "aibaba_ai_community.document_loaders",
    "PagedPDFSplitter": "aibaba_ai_community.document_loaders",
    "PDFMinerLoader": "aibaba_ai_community.document_loaders",
    "PDFMinerPDFasHTMLLoader": "aibaba_ai_community.document_loaders",
    "PDFPlumberLoader": "aibaba_ai_community.document_loaders",
    "PlaywrightURLLoader": "aibaba_ai_community.document_loaders",
    "PolarsDataFrameLoader": "aibaba_ai_community.document_loaders",
    "PsychicLoader": "aibaba_ai_community.document_loaders",
    "PubMedLoader": "aibaba_ai_community.document_loaders",
    "PyMuPDFLoader": "aibaba_ai_community.document_loaders",
    "PyPDFDirectoryLoader": "aibaba_ai_community.document_loaders",
    "PyPDFium2Loader": "aibaba_ai_community.document_loaders",
    "PyPDFLoader": "aibaba_ai_community.document_loaders",
    "PySparkDataFrameLoader": "aibaba_ai_community.document_loaders",
    "PythonLoader": "aibaba_ai_community.document_loaders",
    "ReadTheDocsLoader": "aibaba_ai_community.document_loaders",
    "RecursiveUrlLoader": "aibaba_ai_community.document_loaders",
    "RedditPostsLoader": "aibaba_ai_community.document_loaders",
    "RSSFeedLoader": "aibaba_ai_community.document_loaders",
    "RoamLoader": "aibaba_ai_community.document_loaders",
    "RocksetLoader": "aibaba_ai_community.document_loaders",
    "S3DirectoryLoader": "aibaba_ai_community.document_loaders",
    "S3FileLoader": "aibaba_ai_community.document_loaders",
    "SRTLoader": "aibaba_ai_community.document_loaders",
    "SeleniumURLLoader": "aibaba_ai_community.document_loaders",
    "SharePointLoader": "aibaba_ai_community.document_loaders",
    "SitemapLoader": "aibaba_ai_community.document_loaders",
    "SlackDirectoryLoader": "aibaba_ai_community.document_loaders",
    "SnowflakeLoader": "aibaba_ai_community.document_loaders",
    "SpreedlyLoader": "aibaba_ai_community.document_loaders",
    "StripeLoader": "aibaba_ai_community.document_loaders",
    "TelegramChatLoader": "aibaba_ai_community.document_loaders",
    "TelegramChatApiLoader": "aibaba_ai_community.document_loaders",
    "TelegramChatFileLoader": "aibaba_ai_community.document_loaders",
    "TensorflowDatasetLoader": "aibaba_ai_community.document_loaders",
    "TencentCOSDirectoryLoader": "aibaba_ai_community.document_loaders",
    "TencentCOSFileLoader": "aibaba_ai_community.document_loaders",
    "TextLoader": "aibaba_ai_community.document_loaders",
    "ToMarkdownLoader": "aibaba_ai_community.document_loaders",
    "TomlLoader": "aibaba_ai_community.document_loaders",
    "TrelloLoader": "aibaba_ai_community.document_loaders",
    "TwitterTweetLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredAPIFileIOLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredAPIFileLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredCSVLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredEPubLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredEmailLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredExcelLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredFileIOLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredFileLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredHTMLLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredImageLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredMarkdownLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredODTLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredOrgModeLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredPDFLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredPowerPointLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredRSTLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredRTFLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredTSVLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredURLLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredWordDocumentLoader": "aibaba_ai_community.document_loaders",
    "UnstructuredXMLLoader": "aibaba_ai_community.document_loaders",
    "WeatherDataLoader": "aibaba_ai_community.document_loaders",
    "WebBaseLoader": "aibaba_ai_community.document_loaders",
    "WhatsAppChatLoader": "aibaba_ai_community.document_loaders",
    "WikipediaLoader": "aibaba_ai_community.document_loaders",
    "XorbitsLoader": "aibaba_ai_community.document_loaders",
    "YoutubeAudioLoader": "aibaba_ai_community.document_loaders",
    "YoutubeLoader": "aibaba_ai_community.document_loaders",
    "YuqueLoader": "aibaba_ai_community.document_loaders",
}

_import_attribute = create_importer(__package__, deprecated_lookups=DEPRECATED_LOOKUP)


def __getattr__(name: str) -> Any:
    """Look up attributes dynamically."""
    return _import_attribute(name)


__all__ = [
    "AcreomLoader",
    "AsyncHtmlLoader",
    "AsyncChromiumLoader",
    "AZLyricsLoader",
    "AcreomLoader",
    "AirbyteCDKLoader",
    "AirbyteGongLoader",
    "AirbyteJSONLoader",
    "AirbyteHubspotLoader",
    "AirbyteSalesforceLoader",
    "AirbyteShopifyLoader",
    "AirbyteStripeLoader",
    "AirbyteTypeformLoader",
    "AirbyteZendeskSupportLoader",
    "AirtableLoader",
    "AmazonTextractPDFLoader",
    "ApifyDatasetLoader",
    "ArcGISLoader",
    "ArxivLoader",
    "AssemblyAIAudioTranscriptLoader",
    "AsyncHtmlLoader",
    "AzureAIDataLoader",
    "AzureBlobStorageContainerLoader",
    "AzureBlobStorageFileLoader",
    "BSHTMLLoader",
    "BibtexLoader",
    "BigQueryLoader",
    "BiliBiliLoader",
    "BlackboardLoader",
    "Blob",
    "BlobLoader",
    "BlockchainDocumentLoader",
    "BraveSearchLoader",
    "BrowserlessLoader",
    "CSVLoader",
    "ChatGPTLoader",
    "CoNLLULoader",
    "CollegeConfidentialLoader",
    "ConcurrentLoader",
    "ConfluenceLoader",
    "CouchbaseLoader",
    "CubeSemanticLoader",
    "DataFrameLoader",
    "DatadogLogsLoader",
    "DiffbotLoader",
    "DirectoryLoader",
    "DiscordChatLoader",
    "DocugamiLoader",
    "DocusaurusLoader",
    "Docx2txtLoader",
    "DropboxLoader",
    "DuckDBLoader",
    "EtherscanLoader",
    "EverNoteLoader",
    "FacebookChatLoader",
    "FaunaLoader",
    "FigmaFileLoader",
    "FileSystemBlobLoader",
    "GCSDirectoryLoader",
    "GCSFileLoader",
    "GeoDataFrameLoader",
    "GithubFileLoader",
    "GitHubIssuesLoader",
    "GitLoader",
    "GitbookLoader",
    "GoogleApiClient",
    "GoogleApiYoutubeLoader",
    "GoogleSpeechToTextLoader",
    "GoogleDriveLoader",
    "GutenbergLoader",
    "HNLoader",
    "HuggingFaceDatasetLoader",
    "IFixitLoader",
    "IMSDbLoader",
    "ImageCaptionLoader",
    "IuguLoader",
    "JSONLoader",
    "JoplinLoader",
    "LarkSuiteDocLoader",
    "LakeFSLoader",
    "MHTMLLoader",
    "MWDumpLoader",
    "MastodonTootsLoader",
    "MathpixPDFLoader",
    "MaxComputeLoader",
    "MergedDataLoader",
    "ModernTreasuryLoader",
    "MongodbLoader",
    "NewsURLLoader",
    "NotebookLoader",
    "NotionDBLoader",
    "NotionDirectoryLoader",
    "OBSDirectoryLoader",
    "OBSFileLoader",
    "ObsidianLoader",
    "OneDriveFileLoader",
    "OneDriveLoader",
    "OnlinePDFLoader",
    "OpenCityDataLoader",
    "OutlookMessageLoader",
    "PDFMinerLoader",
    "PDFMinerPDFasHTMLLoader",
    "PDFPlumberLoader",
    "PlaywrightURLLoader",
    "PolarsDataFrameLoader",
    "PsychicLoader",
    "PubMedLoader",
    "PyMuPDFLoader",
    "PyPDFDirectoryLoader",
    "PagedPDFSplitter",
    "PyPDFLoader",
    "PyPDFium2Loader",
    "PySparkDataFrameLoader",
    "PythonLoader",
    "RSSFeedLoader",
    "ReadTheDocsLoader",
    "RecursiveUrlLoader",
    "RedditPostsLoader",
    "RoamLoader",
    "RocksetLoader",
    "S3DirectoryLoader",
    "S3FileLoader",
    "SRTLoader",
    "SeleniumURLLoader",
    "SharePointLoader",
    "SitemapLoader",
    "SlackDirectoryLoader",
    "SnowflakeLoader",
    "SpreedlyLoader",
    "StripeLoader",
    "TelegramChatApiLoader",
    "TelegramChatFileLoader",
    "TelegramChatLoader",
    "TensorflowDatasetLoader",
    "TencentCOSDirectoryLoader",
    "TencentCOSFileLoader",
    "TextLoader",
    "ToMarkdownLoader",
    "TomlLoader",
    "TrelloLoader",
    "TwitterTweetLoader",
    "UnstructuredAPIFileIOLoader",
    "UnstructuredAPIFileLoader",
    "UnstructuredCSVLoader",
    "UnstructuredEPubLoader",
    "UnstructuredEmailLoader",
    "UnstructuredExcelLoader",
    "UnstructuredFileIOLoader",
    "UnstructuredFileLoader",
    "UnstructuredHTMLLoader",
    "UnstructuredImageLoader",
    "UnstructuredMarkdownLoader",
    "UnstructuredODTLoader",
    "UnstructuredOrgModeLoader",
    "UnstructuredPDFLoader",
    "UnstructuredPowerPointLoader",
    "UnstructuredRSTLoader",
    "UnstructuredRTFLoader",
    "UnstructuredTSVLoader",
    "UnstructuredURLLoader",
    "UnstructuredWordDocumentLoader",
    "UnstructuredXMLLoader",
    "WeatherDataLoader",
    "WebBaseLoader",
    "WhatsAppChatLoader",
    "WikipediaLoader",
    "XorbitsLoader",
    "YoutubeAudioLoader",
    "YoutubeLoader",
    "YuqueLoader",
]
