"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageInstallation = void 0;
const child_process_1 = require("child_process");
const util_1 = require("./util");
/**
 * Package installation
 */
class PackageInstallation {
    static detect(module) {
        try {
            // Check local version first
            const version = util_1.tryGetModuleVersionFromRequire(module);
            if (version) {
                return {
                    isLocal: true,
                    version,
                };
            }
            // Fallback to a global version
            const proc = child_process_1.spawnSync(module, ['--version']);
            if (proc.status === 0 && !proc.error) {
                return {
                    isLocal: false,
                    version: proc.stdout.toString().trim(),
                };
            }
            return undefined;
        }
        catch (err) {
            return undefined;
        }
    }
}
exports.PackageInstallation = PackageInstallation;
//# sourceMappingURL=data:application/json;base64,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