from office365.entity import Entity


class IntelligenceProfile(Entity):
    """
    The Microsoft Defender Threat Intelligence Profiles (Intel Profiles) API provides the most up-to-date threat actor
    infrastructure visibility in the industry today, enabling threat intelligence and security operations (SecOps)
    teams to streamline their advanced threat hunting and analysis workflows. These teams have historically
    struggled to obtain visibility into the full extent of nation state and cybercriminal adversary infrastructures,
    creating blind spots in detection and response automation, hunting, and analytics. Sophisticated security
    professionals can use Microsoft Intelligence Profile APIs, along with the indicators and other associated markers,
    to automate defense of their organizations and track potentially malicious activity targeting their organization
    or industry. Users of the Microsoft Defender Threat Intelligence Profiles APIs have access to detailed threat
    actor intel profiles, including background information and interpretation guidance.
    """
