# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplianceTrafficShapingUplinkSelectionArgs', 'ApplianceTrafficShapingUplinkSelection']

@pulumi.input_type
class ApplianceTrafficShapingUplinkSelectionArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 active_active_auto_vpn_enabled: Optional[pulumi.Input[bool]] = None,
                 default_uplink: Optional[pulumi.Input[str]] = None,
                 failover_and_failback: Optional[pulumi.Input['ApplianceTrafficShapingUplinkSelectionFailoverAndFailbackArgs']] = None,
                 load_balancing_enabled: Optional[pulumi.Input[bool]] = None,
                 vpn_traffic_uplink_preferences: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreferenceArgs']]]] = None,
                 wan_traffic_uplink_preferences: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreferenceArgs']]]] = None):
        """
        The set of arguments for constructing a ApplianceTrafficShapingUplinkSelection resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[bool] active_active_auto_vpn_enabled: Whether active-active AutoVPN is enabled
        :param pulumi.Input[str] default_uplink: The default uplink. Must be one of: 'wan1' or 'wan2'
        :param pulumi.Input['ApplianceTrafficShapingUplinkSelectionFailoverAndFailbackArgs'] failover_and_failback: WAN failover and failback
        :param pulumi.Input[bool] load_balancing_enabled: Whether load balancing is enabled
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreferenceArgs']]] vpn_traffic_uplink_preferences: Uplink preference rules for VPN traffic
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreferenceArgs']]] wan_traffic_uplink_preferences: Uplink preference rules for WAN traffic
        """
        pulumi.set(__self__, "network_id", network_id)
        if active_active_auto_vpn_enabled is not None:
            pulumi.set(__self__, "active_active_auto_vpn_enabled", active_active_auto_vpn_enabled)
        if default_uplink is not None:
            pulumi.set(__self__, "default_uplink", default_uplink)
        if failover_and_failback is not None:
            pulumi.set(__self__, "failover_and_failback", failover_and_failback)
        if load_balancing_enabled is not None:
            pulumi.set(__self__, "load_balancing_enabled", load_balancing_enabled)
        if vpn_traffic_uplink_preferences is not None:
            pulumi.set(__self__, "vpn_traffic_uplink_preferences", vpn_traffic_uplink_preferences)
        if wan_traffic_uplink_preferences is not None:
            pulumi.set(__self__, "wan_traffic_uplink_preferences", wan_traffic_uplink_preferences)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="activeActiveAutoVpnEnabled")
    def active_active_auto_vpn_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether active-active AutoVPN is enabled
        """
        return pulumi.get(self, "active_active_auto_vpn_enabled")

    @active_active_auto_vpn_enabled.setter
    def active_active_auto_vpn_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active_active_auto_vpn_enabled", value)

    @property
    @pulumi.getter(name="defaultUplink")
    def default_uplink(self) -> Optional[pulumi.Input[str]]:
        """
        The default uplink. Must be one of: 'wan1' or 'wan2'
        """
        return pulumi.get(self, "default_uplink")

    @default_uplink.setter
    def default_uplink(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_uplink", value)

    @property
    @pulumi.getter(name="failoverAndFailback")
    def failover_and_failback(self) -> Optional[pulumi.Input['ApplianceTrafficShapingUplinkSelectionFailoverAndFailbackArgs']]:
        """
        WAN failover and failback
        """
        return pulumi.get(self, "failover_and_failback")

    @failover_and_failback.setter
    def failover_and_failback(self, value: Optional[pulumi.Input['ApplianceTrafficShapingUplinkSelectionFailoverAndFailbackArgs']]):
        pulumi.set(self, "failover_and_failback", value)

    @property
    @pulumi.getter(name="loadBalancingEnabled")
    def load_balancing_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether load balancing is enabled
        """
        return pulumi.get(self, "load_balancing_enabled")

    @load_balancing_enabled.setter
    def load_balancing_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "load_balancing_enabled", value)

    @property
    @pulumi.getter(name="vpnTrafficUplinkPreferences")
    def vpn_traffic_uplink_preferences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreferenceArgs']]]]:
        """
        Uplink preference rules for VPN traffic
        """
        return pulumi.get(self, "vpn_traffic_uplink_preferences")

    @vpn_traffic_uplink_preferences.setter
    def vpn_traffic_uplink_preferences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreferenceArgs']]]]):
        pulumi.set(self, "vpn_traffic_uplink_preferences", value)

    @property
    @pulumi.getter(name="wanTrafficUplinkPreferences")
    def wan_traffic_uplink_preferences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreferenceArgs']]]]:
        """
        Uplink preference rules for WAN traffic
        """
        return pulumi.get(self, "wan_traffic_uplink_preferences")

    @wan_traffic_uplink_preferences.setter
    def wan_traffic_uplink_preferences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreferenceArgs']]]]):
        pulumi.set(self, "wan_traffic_uplink_preferences", value)


@pulumi.input_type
class _ApplianceTrafficShapingUplinkSelectionState:
    def __init__(__self__, *,
                 active_active_auto_vpn_enabled: Optional[pulumi.Input[bool]] = None,
                 default_uplink: Optional[pulumi.Input[str]] = None,
                 failover_and_failback: Optional[pulumi.Input['ApplianceTrafficShapingUplinkSelectionFailoverAndFailbackArgs']] = None,
                 load_balancing_enabled: Optional[pulumi.Input[bool]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 vpn_traffic_uplink_preferences: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreferenceArgs']]]] = None,
                 wan_traffic_uplink_preferences: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreferenceArgs']]]] = None):
        """
        Input properties used for looking up and filtering ApplianceTrafficShapingUplinkSelection resources.
        :param pulumi.Input[bool] active_active_auto_vpn_enabled: Whether active-active AutoVPN is enabled
        :param pulumi.Input[str] default_uplink: The default uplink. Must be one of: 'wan1' or 'wan2'
        :param pulumi.Input['ApplianceTrafficShapingUplinkSelectionFailoverAndFailbackArgs'] failover_and_failback: WAN failover and failback
        :param pulumi.Input[bool] load_balancing_enabled: Whether load balancing is enabled
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreferenceArgs']]] vpn_traffic_uplink_preferences: Uplink preference rules for VPN traffic
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreferenceArgs']]] wan_traffic_uplink_preferences: Uplink preference rules for WAN traffic
        """
        if active_active_auto_vpn_enabled is not None:
            pulumi.set(__self__, "active_active_auto_vpn_enabled", active_active_auto_vpn_enabled)
        if default_uplink is not None:
            pulumi.set(__self__, "default_uplink", default_uplink)
        if failover_and_failback is not None:
            pulumi.set(__self__, "failover_and_failback", failover_and_failback)
        if load_balancing_enabled is not None:
            pulumi.set(__self__, "load_balancing_enabled", load_balancing_enabled)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if vpn_traffic_uplink_preferences is not None:
            pulumi.set(__self__, "vpn_traffic_uplink_preferences", vpn_traffic_uplink_preferences)
        if wan_traffic_uplink_preferences is not None:
            pulumi.set(__self__, "wan_traffic_uplink_preferences", wan_traffic_uplink_preferences)

    @property
    @pulumi.getter(name="activeActiveAutoVpnEnabled")
    def active_active_auto_vpn_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether active-active AutoVPN is enabled
        """
        return pulumi.get(self, "active_active_auto_vpn_enabled")

    @active_active_auto_vpn_enabled.setter
    def active_active_auto_vpn_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active_active_auto_vpn_enabled", value)

    @property
    @pulumi.getter(name="defaultUplink")
    def default_uplink(self) -> Optional[pulumi.Input[str]]:
        """
        The default uplink. Must be one of: 'wan1' or 'wan2'
        """
        return pulumi.get(self, "default_uplink")

    @default_uplink.setter
    def default_uplink(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_uplink", value)

    @property
    @pulumi.getter(name="failoverAndFailback")
    def failover_and_failback(self) -> Optional[pulumi.Input['ApplianceTrafficShapingUplinkSelectionFailoverAndFailbackArgs']]:
        """
        WAN failover and failback
        """
        return pulumi.get(self, "failover_and_failback")

    @failover_and_failback.setter
    def failover_and_failback(self, value: Optional[pulumi.Input['ApplianceTrafficShapingUplinkSelectionFailoverAndFailbackArgs']]):
        pulumi.set(self, "failover_and_failback", value)

    @property
    @pulumi.getter(name="loadBalancingEnabled")
    def load_balancing_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether load balancing is enabled
        """
        return pulumi.get(self, "load_balancing_enabled")

    @load_balancing_enabled.setter
    def load_balancing_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "load_balancing_enabled", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="vpnTrafficUplinkPreferences")
    def vpn_traffic_uplink_preferences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreferenceArgs']]]]:
        """
        Uplink preference rules for VPN traffic
        """
        return pulumi.get(self, "vpn_traffic_uplink_preferences")

    @vpn_traffic_uplink_preferences.setter
    def vpn_traffic_uplink_preferences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreferenceArgs']]]]):
        pulumi.set(self, "vpn_traffic_uplink_preferences", value)

    @property
    @pulumi.getter(name="wanTrafficUplinkPreferences")
    def wan_traffic_uplink_preferences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreferenceArgs']]]]:
        """
        Uplink preference rules for WAN traffic
        """
        return pulumi.get(self, "wan_traffic_uplink_preferences")

    @wan_traffic_uplink_preferences.setter
    def wan_traffic_uplink_preferences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreferenceArgs']]]]):
        pulumi.set(self, "wan_traffic_uplink_preferences", value)


class ApplianceTrafficShapingUplinkSelection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_active_auto_vpn_enabled: Optional[pulumi.Input[bool]] = None,
                 default_uplink: Optional[pulumi.Input[str]] = None,
                 failover_and_failback: Optional[pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionFailoverAndFailbackArgs']]] = None,
                 load_balancing_enabled: Optional[pulumi.Input[bool]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 vpn_traffic_uplink_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreferenceArgs']]]]] = None,
                 wan_traffic_uplink_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreferenceArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceTrafficShapingUplinkSelection:ApplianceTrafficShapingUplinkSelection example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active_active_auto_vpn_enabled: Whether active-active AutoVPN is enabled
        :param pulumi.Input[str] default_uplink: The default uplink. Must be one of: 'wan1' or 'wan2'
        :param pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionFailoverAndFailbackArgs']] failover_and_failback: WAN failover and failback
        :param pulumi.Input[bool] load_balancing_enabled: Whether load balancing is enabled
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreferenceArgs']]]] vpn_traffic_uplink_preferences: Uplink preference rules for VPN traffic
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreferenceArgs']]]] wan_traffic_uplink_preferences: Uplink preference rules for WAN traffic
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceTrafficShapingUplinkSelectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceTrafficShapingUplinkSelection:ApplianceTrafficShapingUplinkSelection example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceTrafficShapingUplinkSelectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceTrafficShapingUplinkSelectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_active_auto_vpn_enabled: Optional[pulumi.Input[bool]] = None,
                 default_uplink: Optional[pulumi.Input[str]] = None,
                 failover_and_failback: Optional[pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionFailoverAndFailbackArgs']]] = None,
                 load_balancing_enabled: Optional[pulumi.Input[bool]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 vpn_traffic_uplink_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreferenceArgs']]]]] = None,
                 wan_traffic_uplink_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreferenceArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceTrafficShapingUplinkSelectionArgs.__new__(ApplianceTrafficShapingUplinkSelectionArgs)

            __props__.__dict__["active_active_auto_vpn_enabled"] = active_active_auto_vpn_enabled
            __props__.__dict__["default_uplink"] = default_uplink
            __props__.__dict__["failover_and_failback"] = failover_and_failback
            __props__.__dict__["load_balancing_enabled"] = load_balancing_enabled
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["vpn_traffic_uplink_preferences"] = vpn_traffic_uplink_preferences
            __props__.__dict__["wan_traffic_uplink_preferences"] = wan_traffic_uplink_preferences
        super(ApplianceTrafficShapingUplinkSelection, __self__).__init__(
            'meraki:networks/applianceTrafficShapingUplinkSelection:ApplianceTrafficShapingUplinkSelection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_active_auto_vpn_enabled: Optional[pulumi.Input[bool]] = None,
            default_uplink: Optional[pulumi.Input[str]] = None,
            failover_and_failback: Optional[pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionFailoverAndFailbackArgs']]] = None,
            load_balancing_enabled: Optional[pulumi.Input[bool]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            vpn_traffic_uplink_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreferenceArgs']]]]] = None,
            wan_traffic_uplink_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreferenceArgs']]]]] = None) -> 'ApplianceTrafficShapingUplinkSelection':
        """
        Get an existing ApplianceTrafficShapingUplinkSelection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active_active_auto_vpn_enabled: Whether active-active AutoVPN is enabled
        :param pulumi.Input[str] default_uplink: The default uplink. Must be one of: 'wan1' or 'wan2'
        :param pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionFailoverAndFailbackArgs']] failover_and_failback: WAN failover and failback
        :param pulumi.Input[bool] load_balancing_enabled: Whether load balancing is enabled
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreferenceArgs']]]] vpn_traffic_uplink_preferences: Uplink preference rules for VPN traffic
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreferenceArgs']]]] wan_traffic_uplink_preferences: Uplink preference rules for WAN traffic
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceTrafficShapingUplinkSelectionState.__new__(_ApplianceTrafficShapingUplinkSelectionState)

        __props__.__dict__["active_active_auto_vpn_enabled"] = active_active_auto_vpn_enabled
        __props__.__dict__["default_uplink"] = default_uplink
        __props__.__dict__["failover_and_failback"] = failover_and_failback
        __props__.__dict__["load_balancing_enabled"] = load_balancing_enabled
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["vpn_traffic_uplink_preferences"] = vpn_traffic_uplink_preferences
        __props__.__dict__["wan_traffic_uplink_preferences"] = wan_traffic_uplink_preferences
        return ApplianceTrafficShapingUplinkSelection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeActiveAutoVpnEnabled")
    def active_active_auto_vpn_enabled(self) -> pulumi.Output[bool]:
        """
        Whether active-active AutoVPN is enabled
        """
        return pulumi.get(self, "active_active_auto_vpn_enabled")

    @property
    @pulumi.getter(name="defaultUplink")
    def default_uplink(self) -> pulumi.Output[str]:
        """
        The default uplink. Must be one of: 'wan1' or 'wan2'
        """
        return pulumi.get(self, "default_uplink")

    @property
    @pulumi.getter(name="failoverAndFailback")
    def failover_and_failback(self) -> pulumi.Output['outputs.ApplianceTrafficShapingUplinkSelectionFailoverAndFailback']:
        """
        WAN failover and failback
        """
        return pulumi.get(self, "failover_and_failback")

    @property
    @pulumi.getter(name="loadBalancingEnabled")
    def load_balancing_enabled(self) -> pulumi.Output[bool]:
        """
        Whether load balancing is enabled
        """
        return pulumi.get(self, "load_balancing_enabled")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="vpnTrafficUplinkPreferences")
    def vpn_traffic_uplink_preferences(self) -> pulumi.Output[Sequence['outputs.ApplianceTrafficShapingUplinkSelectionVpnTrafficUplinkPreference']]:
        """
        Uplink preference rules for VPN traffic
        """
        return pulumi.get(self, "vpn_traffic_uplink_preferences")

    @property
    @pulumi.getter(name="wanTrafficUplinkPreferences")
    def wan_traffic_uplink_preferences(self) -> pulumi.Output[Sequence['outputs.ApplianceTrafficShapingUplinkSelectionWanTrafficUplinkPreference']]:
        """
        Uplink preference rules for WAN traffic
        """
        return pulumi.get(self, "wan_traffic_uplink_preferences")

