from collections import Counter, OrderedDict
from collections.abc import Iterable, Sequence
from typing import Any

from rest_framework.compat import coreapi
from rest_framework.fields import Field
from rest_framework.request import Request
from rest_framework.urlpatterns import _AnyURL
from rest_framework.views import APIView

from .generators import BaseSchemaGenerator as BaseSchemaGenerator
from .inspectors import ViewInspector as ViewInspector

def common_path(paths: Iterable[str]) -> str: ...
def is_custom_action(action: str) -> bool: ...
def distribute_links(obj: Any) -> None: ...

INSERT_INTO_COLLISION_FMT: str

class LinkNode(OrderedDict):
    links: list[Any]
    methods_counter: Counter
    def __init__(self) -> None: ...
    def get_available_key(self, preferred_key: str) -> str: ...

def insert_into(target: LinkNode, keys: Sequence[str], value: Any) -> None: ...

class SchemaGenerator(BaseSchemaGenerator):
    default_mapping: dict[str, str]
    coerce_method_names: dict[str, str] | None
    def __init__(
        self,
        urlconf: str | None = ...,
        title: str | None = ...,
        description: str | None = ...,
        version: str | None = ...,
        patterns: Sequence[_AnyURL] | None = ...,
        url: str | None = ...,
        endpoints: Sequence[tuple[str, str, Any]] | None = ...,
    ) -> None: ...
    def get_links(self, request: Request | None = ...) -> LinkNode | None: ...
    def get_schema(self, request: Request | None = ..., public: bool = ...) -> coreapi.Document | None: ...
    def get_keys(self, subpath: Any, method: Any, view: APIView) -> list[str]: ...
    def determine_path_prefix(self, paths: list[str]) -> str: ...

def field_to_schema(field: Field): ...

class AutoSchema(ViewInspector):
    def __init__(self, manual_fields: list[coreapi.Field] | None = ...) -> None: ...
    def get_link(self, path: str, method: str, base_url: str) -> coreapi.Link: ...
    def get_path_fields(self, path: str, method: str) -> list[coreapi.Field]: ...
    def get_serializer_fields(self, path: str, method: str) -> list[coreapi.Field]: ...
    def get_pagination_fields(self, path: str, method: str) -> dict[str, Any]: ...
    def get_filter_fields(self, path: str, method: str) -> list[dict[str, Any]]: ...
    def get_manual_fields(self, path: str, method: str) -> list[coreapi.Field]: ...
    @staticmethod
    def update_fields(fields: list[coreapi.Field], update_with: list[coreapi.Field]) -> list[coreapi.Field]: ...
    def get_encoding(self, path: str, method: str) -> str: ...

class ManualSchema(ViewInspector):
    def __init__(self, fields: list[coreapi.Field], description: str = ..., encoding: str | None = ...) -> None: ...
    def get_link(self, path: str, method: str, base_url: str) -> coreapi.Link: ...

def is_enabled() -> bool: ...
