"""
This module contains callback lists


--------------------

This script shows the most simple example of adding a handler.

```../examples/bpy.app.handlers.py```


--------------------

By default handlers are freed when loading new files, in some cases you may
wan't the handler stay running across multiple files (when the handler is
part of an addon for example).

For this the bpy.app.handlers.persistent decorator needs to be used.

```../examples/bpy.app.handlers.1.py```

"""

import typing
import collections.abc
import typing_extensions
import bpy.types

frame_change_post: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on frame change for playback and rendering (after)
"""

frame_change_pre: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on frame change for playback and rendering (before)
"""

game_post: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on ending the game engine
"""

game_pre: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on starting the game engine
"""

load_post: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on loading a new blend file (after)
"""

load_pre: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on loading a new blend file (before)
"""

persistent: typing.Any
""" Function decorator for callback functions not to be removed when loading new files
"""

render_cancel: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on canceling a render job
"""

render_complete: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on completion of render job
"""

render_init: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on initialization of a render job
"""

render_post: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on render (after)
"""

render_pre: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on render (before)
"""

render_stats: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on printing render statistics
"""

render_write: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on writing a render frame (directly after the frame is written)
"""

save_post: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on saving a blend file (after)
"""

save_pre: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on saving a blend file (before)
"""

scene_update_post: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on updating the scenes data (after)
"""

scene_update_pre: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on updating the scenes data (before)
"""

version_update: list[collections.abc.Callable[[bpy.types.Scene], None]]
""" on ending the versioning code
"""
