# -*- coding: utf-8 -*-

"""
“Commons Clause” License Condition Copyright Pirxcy/Oli 2019-2020 / 2020-202

The Software is provided to you by the Licensor under the
License, as defined below, subject to the following condition.

Without limiting other conditions in the License, the grant
of rights under the License will not include, and the License
does not grant to you, the right to Sell the Software.

For purposes of the foregoing, “Sell” means practicing any or
all of the rights granted to you under the License to provide
to third parties, for a fee or other consideration (including
without limitation fees for hosting or consulting/ support
services related to the Software), a product or service whose
value derives, entirely or substantially, from the functionality
of the Software. Any license notice or attribution required by
the License must also include this Commons Clause License
Condition notice.

Software: PirxcyBot (PB-bot)

License: Apache 2.0
"""

__name__ = "PirxcyPackage"
__author__ = "Pirxcy"
__version__ = "5.2"


try:

    import fortnitepy

    from fortnitepy.errors import *

    import BenBotAsync

    import asyncio

    import time as delay

    import datetime

    import json

    import aiohttp

    import time

    import logging

    import functools

    import sys

    import os

    import random

    from colorama import init

    init(autoreset=True)

    from colorama import Fore, Back, Style

except ModuleNotFoundError:

    print(Fore.RED + f'[FORTNITEPY] [N/A] [ERROR] Failed to import 1 or more modules, run "INSTALL PACKAGES.bat".')

    exit()

def debugOn():

    logger = logging.getLogger('fortnitepy.xmpp')

    logger.setLevel(level=logging.DEBUG)

    handler = logging.StreamHandler(sys.stdout)

    handler.setFormatter(logging.Formatter('%(asctime)s:%(levelname)s:%(name)s: %(message)s'))

    logger.addHandler(handler)



def getTime():

    time = datetime.datetime.now().strftime('%H:%M:%S')

    return time



with open('config.json') as f:

    print(f' [PirxcyBotV5.1] [{getTime()}] Loading config.')

    data = json.load(f)

    print(f' [PirxcyBotV5.1] [{getTime()}] Config loaded.')

    

debug = 'False'

if debug == 'True':

    print(f' [PirxcyBotV5.1] [{getTime()}] Debug logging is on.')

    debugOn()

else:

    print(f' [PirxcyBotV5.1] [{getTime()}] Debug logging is off.')





def get_device_auth_details():

    if os.path.isfile('auths.json'):

        with open('auths.json', 'r') as fp:

            return json.load(fp)

    return {}



def store_device_auth_details(email, details):

    existing = get_device_auth_details()

    existing[email] = details



    with open('auths.json', 'w') as fp:

        json.dump(existing, fp)



device_auth_details = get_device_auth_details().get(data['email'], {})

client = fortnitepy.Client(

    auth=fortnitepy.AdvancedAuth(

        email=data['email'],

        password=data['password'],

        prompt_authorization_code=True,

        delete_existing_device_auths=True,

        **device_auth_details

    ),

    status=data['status'],

    platform=fortnitepy.Platform(data['platform'])

)



@client.event
@client.command()

async def event_device_auth_generate(details, email):

    store_device_auth_details(email, details)



@client.event
@client.command()

async def event_ready():

    print(Fore.GREEN + ' [PirxcyBotV5.1] [' + getTime() + '] Client ready as {0.user.display_name}.'.format(client))
    print(color.YELLOW + f'══════════════════════════════════════════════════════════════')


    member = client.party.me



    await member.edit_and_keep(

        functools.partial(

            fortnitepy.ClientPartyMember.set_outfit,

            asset=data['cid']

        ),

        functools.partial(

            fortnitepy.ClientPartyMember.set_backpack,

            asset=data['bid']

        ),

        functools.partial(

            fortnitepy.ClientPartyMember.set_pickaxe,

            asset=data['pid']

        ),

        functools.partial(

            fortnitepy.ClientPartyMember.set_banner,

            icon=data['banner'],

            color=data['banner_color'],

            season_level=data['level']

        ),

        functools.partial(

            fortnitepy.ClientPartyMember.set_battlepass_info,

            has_purchased=True,

            level=data['bp_tier']

        )

    )



@client.event
@client.command()

async def event_party_invite(invite):

    if data['joinoninvite'].lower() == 'true':

        if invite.sender.display_name not in data['BlockList']:

            try:

                await invite.accept()

                print(Fore.CYAN + f' [PirxcyBotV5.1] [{getTime()}] Accepted party invite from {invite.sender.display_name}')

            except Exception as e:

                pass

        elif invite.sender.display_name in data['BlockList']:

            print(Fore.RED + f' [PirxcyBotV5.1] [{getTime()}] Never accepted party invite from' + Fore.RED + f' {invite.sender.display_name}')

    if data['joinoninvite'].lower() == 'false':

        if invite.sender.display_name in data['FullAccess']:

            await invite.accept()

            print(Fore.BLUE + f' [PirxcyBotV5.1] [{getTime()}] Accepted party invite from {invite.sender.display_name}')

        else:

            print(Fore.RED + f' [PirxcyBotV5.1] [{getTime()}] Never accepted party invite from {invite.sender.display_name}')

            await invite.sender.send(f"I can't join you right now.")



@client.event
@client.command()

async def event_friend_request(request):

    if data['friendaccept'].lower() == 'true':

        if request.display_name not in data['BlockList']:

            try:

                await request.accept()

                print(color.CYAN + f" [PirxcyBotV5.1] [{getTime()}] Accepted friend request from: {request.display_name}")

            except Exception as e:

                pass

        elif request.display_name in data['BlockList']:

             print(color.RED + f" [PirxcyBotV5.1] [{getTime()}] Never Accepted friend reqest from: " + Fore.RED + f"{request.display_name}")

    if data['friendaccept'].lower() == 'false':

        if request.display_name in data['FullAccess']:

            try:

                await request.accept()

                print(color.CYAN + f" [PirxcyBotV5.1] [{getTime()}] Accepted friend request from: {request.display_name}")

            except Exception as e:

                pass

        else:

            print(color.RED + f" [PirxcyBotV5.1] [{getTime()}] Never accepted friend request from: {request.display_name}")



@client.event
@client.command()

async def event_party_member_join(member):

    if client.user.display_name != member.display_name:

         print(color.PURPLE + f" [PirxcyBotV5.1] [{getTime()}] {member.display_name} has joined the lobby.")


@client.event
@client.command()
async def event_party_member_join(member: fortnitepy.PartyMember) -> None:
    delay.sleep(1)
    await client.party.send(f'Hey! {member.display_name} u lookin kinda fresh this is a lobby bot made by Pirxcy to get a lobby bot. Of ur own join the discord -> discord.gg/wxEBMTZ ')

@client.event

async def event_friend_message(message):

    args = message.content.split()

    split = args[1:]

    joinedArguments = " ".join(split)

    print(' [PirxcyBotV5.1] [' + getTime() + '] {0.author.display_name}: {0.content}'.format(message))



    if "!skin" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            try:

                cosmetic = await BenBotAsync.get_cosmetic(

                    lang="en",

                    searchLang="en",

                    matchMethod="contains",

                    name=joinedArguments,

                    backendType="AthenaCharacter"

                )

                await client.party.me.set_outfit(asset=cosmetic.id)

                await message.reply('Skin set to ' + f'{cosmetic.name}')

            except BenBotAsync.exceptions.NotFound:

                await message.reply(f'Could not find a skin named: {joinedArguments}')

                

        

    if "!backpack" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            if len(args) == 1:

                await client.party.me.set_backpack(asset='none')

                await message.reply('Backpack set to None')

            else:

                try:

                    cosmetic = await BenBotAsync.get_cosmetic(

                        lang="en",

                        searchLang="en",

                        matchMethod="contains",

                        name=joinedArguments,

                        backendType="AthenaBackpack"

                    )

                    await client.party.me.set_backpack(asset=cosmetic.id)

                    await message.reply('Backpack set to ' + f'{cosmetic.name}')

                except BenBotAsync.exceptions.NotFound:

                    await message.reply(f'Could not find a backpack named: {joinedArguments}')



    if "!random" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            if len(args) == 1:

                skins = await BenBotAsync.get_cosmetics(

                    lang="en",

                    searchLang="en",

                    backendType="AthenaCharacter"

                )

                skin = random.choice(skins)



                backpacks = await BenBotAsync.get_cosmetics(

                    lang="en",

                    searchLang="en",

                    backendType="AthenaBackpack"

                )

                backpack = random.choice(backpacks)



                pickaxes = await BenBotAsync.get_cosmetics(

                    lang="en",

                    searchLang="en",

                    backendType="AthenaPickaxe"

                )

                pickaxe = random.choice(pickaxes)



                await client.party.me.set_outfit(

                    asset=skin.id

                )



                await client.party.me.set_backpack(

                    asset=backpack.id

                )



                await client.party.me.set_pickaxe(

                    asset=pickaxe.id

                )



                await message.reply(f'Loadout set to: {skin.name}, {backpack.name}, {pickaxe.name}')

            if len(args) == 2:

                if args[1].lower() == 'skin':

                    skins = await BenBotAsync.get_cosmetics(

                    lang="en",

                    searchLang="en",

                    backendType="AthenaCharacter"

                    )

                    skin = random.choice(skins)



                    await client.party.me.set_outfit(

                        asset=skin.id

                    )



                    await message.reply(f"Skin set to: {skin.name}")



                if args[1].lower() == 'backpack':

                    backpacks = await BenBotAsync.get_cosmetics(

                    lang="en",

                    searchLang="en",

                    backendType="AthenaBackpack"

                    )

                    backpack = random.choice(backpacks)



                    await client.party.me.set_backpack(

                        asset=backpack.id

                    )



                    await message.reply(f"Backpack set to: {backpack.name}")



                if args[1].lower() == 'emote':

                    emotes = await BenBotAsync.get_cosmetics(

                    lang="de",

                    searchLang="en",

                    backendType="AthenaDance"

                    )

                    emote = random.choice(emotes)



                    await client.party.me.set_emote(

                        asset=emote.id

                    )



                    await message.reply(f"Emote set to: {emote.name}")



                if args[1].lower() == 'pickaxe':

                    pickaxes = await BenBotAsync.get_cosmetics(

                    lang="en",

                    searchLang="en",

                    backendType="AthenaPickaxe"

                    )

                    pickaxe = random.choice(pickaxes)



                    await client.party.me.set_pickaxe(

                        asset=pickaxe.id

                    )



                    await message.reply(f"Pickaxe set to: {pickaxe.name}")

        

    if "!cid" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            try:

                cosmetic = await BenBotAsync.get_cosmetic(

                    lang="en",

                    searchLang="en",

                    matchMethod="contains",

                    name=joinedArguments,

                    backendType="AthenaCharacter"

                )

                await message.reply(f'The CID for {cosmetic.name} is: ' + f'{cosmetic.id}')

                print(f" [PirxcyBotV5.1] [{getTime()}] CID for {cosmetic.name}: {cosmetic.id}")

            except BenBotAsync.exceptions.NotFound:

                await message.reply(f'Could not find a cid for the skin: {joinedArguments}')

    

    if "!bid" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            try:

                cosmetic = await BenBotAsync.get_cosmetic(

                    lang="en",

                    searchLang="en",

                    matchMethod="contains",

                    name=joinedArguments,

                    backendType="AthenaBackpack"

                )

                await message.reply(f'The BID for {cosmetic.name} is: ' + f'{cosmetic.id}')

                print(f" [PirxcyBotV5.1] [{getTime()}] BID for {cosmetic.name}: {cosmetic.id}")

            except BenBotAsync.exceptions.NotFound:

                await message.reply(f'Could not find a bid for the backpack: {joinedArguments}')

    

    if "!eid" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            try:

                cosmetic = await BenBotAsync.get_cosmetic(

                    lang="en",

                    searchLang="en",

                    matchMethod="contains",

                    name=joinedArguments,

                    backendType="AthenaDance"

                )

                await message.reply(f'The EID for {cosmetic.name} is: ' + f'{cosmetic.id}')

                print(f" [PirxcyBotV5.1] [{getTime()}] EID for {cosmetic.name}: {cosmetic.id}")

            except BenBotAsync.exceptions.NotFound:

                await message.reply(f'Could not find a eid for the emote: {joinedArguments}')



    if "!pid" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            try:

                cosmetic = await BenBotAsync.get_cosmetic(

                    lang="en",

                    searchLang="en",

                    matchMethod="contains",

                    name=joinedArguments,

                    backendType="AthenaPickaxe"

                )

                await message.reply(f'The PID for {cosmetic.name} is: ' + f'{cosmetic.id}')

                print(f" [PirxcyBotV5.1] [{getTime()}] PID for {cosmetic.name}: {cosmetic.id}")

            except BenBotAsync.exceptions.NotFound:

                await message.reply(f'Could not find a pid for the pickaxe: {joinedArguments}')



    if "!emote" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            try:

                cosmetic = await BenBotAsync.get_cosmetic(

                    lang="en",

                    searchLang="en",

                    matchMethod="contains",

                    name=joinedArguments,

                    backendType="AthenaDance"

                )

                await client.party.me.clear_emote()

                await client.party.me.set_emote(asset=cosmetic.id)

                await message.reply('Emote set to ' + f'{cosmetic.name}')

            except BenBotAsync.exceptions.NotFound:

                await message.reply(f'Could not find an emote named: {joinedArguments}')

    

    if "!pickaxe" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            try:

                cosmetic = await BenBotAsync.get_cosmetic(

                    lang="en",

                    searchLang="en",

                    matchMethod="contains",

                    name=joinedArguments,

                    backendType="AthenaPickaxe"

                )

                await client.party.me.set_pickaxe(asset=cosmetic.id)

                await message.reply('Pickaxe set to ' + f'{cosmetic.name}')

            except BenBotAsync.exceptions.NotFound:

                await message.reply(f'Could not find a pickaxe named: {joinedArguments}')



    if "!point" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await client.party.me.clear_emote()

            if len(args) == 1:

                await client.party.me.set_emote(asset="/Game/Athena/Items/Cosmetics/Dances/EID_IceKing.EID_IceKing")

                await message.reply('Doing emote: Point It Out')

            else:

                if len(args) == 2:

                    if args[1].lower() == 'random':

                        pickaxes = await BenBotAsync.get_cosmetics(

                        lang="en",

                        searchLang="en",

                        backendType="AthenaPickaxe"

                        )

                        pickaxe = random.choice(pickaxes)



                        await client.party.me.set_pickaxe(

                            asset=pickaxe.id

                        )



                        await client.party.me.clear_emote()

                        await client.party.me.set_emote(asset="/Game/Athena/Items/Cosmetics/Dances/EID_IceKing.EID_IceKing")



                        await message.reply(f"Pointing with: {pickaxe.name}")

                    else:

                        try:

                            cosmetic = await BenBotAsync.get_cosmetic(

                                lang="en",

                                searchLang="en",

                                matchMethod="contains",

                                name=joinedArguments,

                                backendType="AthenaPickaxe"

                            )

                            await client.party.me.set_pickaxe(asset=cosmetic.id)

                            await client.party.me.clear_emote()

                            await client.party.me.set_emote(asset="/Game/Athena/Items/Cosmetics/Dances/EID_IceKing.EID_IceKing")

                            await message.reply('Pointing with: ' + f'{cosmetic.name}')

                        except BenBotAsync.exceptions.NotFound:

                            await message.reply(f'Could not find a pickaxe named: {joinedArguments}')



    if "!pet" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            try:

                cosmetic = await BenBotAsync.get_cosmetic(

                    lang="en",

                    searchLang="en",

                    matchMethod="contains",

                    name=joinedArguments,

                    backendType="AthenaPet"

                )

                await client.party.me.set_pet(asset=cosmetic.id)

                await message.reply('Pet set to ' + f'{cosmetic.name}')

            except BenBotAsync.exceptions.NotFound:

                await message.reply(f'Could not find a pet named: {joinedArguments}')



    if "!emoji" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            try:

                cosmetic = await BenBotAsync.get_cosmetic(

                    lang="en",

                    searchLang="en",

                    matchMethod="contains",

                    name=joinedArguments,

                    backendType="AthenaEmoji"

                )

                await client.party.me.set_emoji(asset=cosmetic.id)

                await message.reply('Emoji set to ' + f'{cosmetic.name}')

            except BenBotAsync.exceptions.NotFound:

                await message.reply(f'Could not find an emoji named: {joinedArguments}')



    if "!purpleskull" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            try:

                variants = client.party.me.create_variants(

                   clothing_color=1

                )



                await client.party.me.set_outfit(

                    asset='CID_030_Athena_Commando_M_Halloween',

                    variants=variants

                )



                await message.reply('Skin set to Purple Skull Trooper!')

                print(f" [PirxcyBotV5.1] [{getTime()}] Client's Skin set to Purple Skull Trooper")

            except Exception as e:

                pass



    if "!pinkghoul" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            try:

                variants = client.party.me.create_variants(

                   material=3

                )



                await client.party.me.set_outfit(

                    asset='CID_029_Athena_Commando_F_Halloween',

                    variants=variants

                )



                await message.reply('Skin set to Pink Ghoul Trooper!')

                print(f" [PirxcyBotV5.1] [{getTime()}] Client's Skin set to Pink Ghoul Trooper")

            except Exception as e:

                pass

               

    if "!goldpeely" in args[0].lower():

        await client.party.me.set_outfit(

            asset='CID_701_Athena_Commando_M_BananaAgent',

            variants=client.party.me.create_variants(

                progressive=4

                ),

            enlightenment=(2, 350)

        )



        await message.reply(f'Skin set to Golden Peely')



    if "!brainiacghoul" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            try:

                variants = client.party.me.create_variants(

                   material=2

                )



                await client.party.me.set_outfit(

                    asset='CID_029_Athena_Commando_F_Halloween',

                    variants=variants

                )



                await message.reply('Skin set to Brainiac Ghoul Trooper!')

                print(f" [PirxcyBotV5.1] [{getTime()}] Client's Skin set to Brainiac Ghoul Trooper")

            except Exception as e:

                pass



    if "!purpleportal" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            variants = client.party.me.create_variants(

                item='AthenaBackpack',

                particle_config='Particle',

                particle=1

            )



            await client.party.me.set_backpack(

                asset='BID_105_GhostPortal',

                variants=variants

            )



            await message.reply('Backpack set to Purple Ghost Portal!')

            print(f" [PirxcyBotV5.1] [{getTime()}] Client's Backpack set to Purple Ghost Portal")



    if "!banner" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            if len(args) == 1:

                await message.reply('You need to specify which banner, color & level you want to set the banner as.')

            if len(args) == 2:

                await client.party.me.set_banner(icon=args[1], color=data['banner_color'], season_level=data['level'])

            if len(args) == 3:

                await client.party.me.set_banner(icon=args[1], color=args[2], season_level=data['level'])

            if len(args) == 4:

                await client.party.me.set_banner(icon=args[1], color=args[2], season_level=args[3])



            await message.reply(f'Banner set to; {args[1]} {args[2]} {args[3]}')

            print(f" [PYBOT] [{getTime()}] Banner set to; {args[1]} {args[2]} {args[3]}")



    if "CID_" in args[0]:

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await client.party.me.set_outfit(

                asset=args[0]

            )

            await message.reply(f'Skin set to {args[0]}')

            print(f' [PirxcyBotV5.1] [{getTime()}] Skin set to ' + args[0])



    if "!variants" in args[0]:

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            args3 = int(args[3])



            if 'CID' in args[1]:

                variants = client.party.me.create_variants(**{args[2]: args3})

                await client.party.me.set_outfit(

                    asset=args[1],

                    variants=variants

                )

            elif 'BID' in args[1]:

                variants = client.party.me.create_variants(item='AthenaBackpack', **{args[2]: args3})

                await client.party.me.set_backpack(

                    asset=args[1],

                    variants=variants

                )

            elif 'PICKAXE_ID' in args[1]:

                variants = client.party.me.create_variants(item='AthenaPickaxe', **{args[2]: args3})

                await client.party.me.set_pickaxe(

                    asset=args[1],

                    variants=variants

                )



            await message.reply(f'Set variants of {args[1]} to {args[2]} {args[3]}.')

            print(f' [PirxcyBotV5.1] [{getTime()}] Set variants of {args[1]} to {args[2]} {args[3]}.')



    if "!checkeredrenegade" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            variants = client.party.me.create_variants(

               material=2

            )



            await client.party.me.set_outfit(

                asset='CID_028_Athena_Commando_F',

                variants=variants

            )



            await message.reply('Skin set to Checkered Renegade!')

            print(f" [PirxcyBotV5.1] [{getTime()}] Client's Skin set to Checkered Renegade")



    if "!mintyelf" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            variants = client.party.me.create_variants(

                   material=2

                )



            await client.party.me.set_outfit(

                asset='CID_051_Athena_Commando_M_HolidayElf',

                variants=variants

                )



            await message.reply('Skin set to Minty Elf!')

            print(f" [PirxcyBotV5.1] [{getTime()}] Client's Skin set to Minty Elf")



    if "EID_" in args[0]:

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await client.party.me.clear_emote()

            await client.party.me.set_emote(

                asset=args[0]

            )

            await message.reply('Emote set to ' + args[0] + '!')

        

    if "!stop" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await client.party.me.clear_emote()

            await message.reply('Stopped emoting.')



    if "BID_" in args[0]:

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await client.party.me.set_backpack(

                asset=args[0]

            )



            await message.reply('Backbling set to ' + message.content + '!')



    if "help" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await message.reply('List of all commands coming soon.')



    if "Pickaxe_" in args[0]:

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await client.party.me.set_pickaxe(

                    asset=args[0]

            )



            await message.reply('Pickaxe set to ' + args[0] + '!')



    if "PetCarrier_" in args[0]:

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await client.party.me.set_backpack(

                    asset="/Game/Athena/Items/Cosmetics/PetCarriers/" + args[0] + "." + args[0]

            )



    if "Emoji_" in args[0]:

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await client.party.me.set_emote(asset='EID_ClearEmote')

            await client.party.me.set_emote(

                    asset="/Game/Athena/Items/Cosmetics/Dances/Emoji/" + args[0] + "." + args[0]

            )



    if "!ready" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await client.party.me.set_ready(fortnitepy.ReadyState.READY)

            await message.reply('Now Ready!')



    if ("!unready" in args[0].lower()) or ("!sitin" in args[0].lower()):

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await client.party.me.set_ready(fortnitepy.ReadyState.NOT_READY)

            await message.reply('Now Unready!')



    if "!sitout" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await client.party.me.set_ready(fortnitepy.ReadyState.SITTING_OUT)

            await message.reply('Now Sitting Out!')

    

    if "!bp" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await client.party.me.set_battlepass_info(has_purchased=True, level=args[1], self_boost_xp='0', friend_boost_xp='0')

    

    if "!level" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            await client.party.me.set_banner(icon=client.party.me.banner[0], color=client.party.me.banner[1], season_level=args[1])

    

    if "!reset" in args[0].lower():

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            variants = client.party.me.create_variants(**{data['variants-type']: data['variants']})

            await client.party.me.set_outfit(asset=data['cid'], variants=variants)

            await client.party.me.set_backpack(asset=data['bid'])

            await client.party.me.set_banner(icon=data['banner'], color=data['banner_color'], season_level=data['level'])

            await client.party.me.set_pickaxe(asset=data['pid'])

            await client.party.me.set_battlepass_info(has_purchased=True, level=data['bp_tier'], self_boost_xp='0', friend_boost_xp='0')

            await message.reply(f"Reset to default cosmetic loadout.")



    if "!echo" in args[0].lower():

        if message.author.display_name in data['FullAccess']:

            await client.party.send(joinedArguments)

            print(f' [PirxcyBotV5.1] [{getTime()}] ' + color.GREEN + 'Sent Message:' + color.END + f' {joinedArguments}')

        else:

            if message.author.display_name not in data['FullAccess']:

                await message.reply(f"You don't have access to this command!")



    if "!admin" in args[0].lower():

        if message.author.display_name in data['FullAccess']:

            if len(args) == 1:

                await message.reply('Please specify if you want to add or remove a user from the admin list')

                print(f' [PirxcyBotV5.1] [{getTime()}] Please specify if you want to add or remove a user from the admin list, using ' + color.GREEN + '!admin add ' + color.END + 'or ' + color.GREEN + '!admin remove' + color.END)

            if len(args) == 2:

                if args[1].lower() == 'add':

                    await message.reply('You are already an admin')

                elif args[1].lower() == 'remove':

                    await message.reply('Are you sure you want to be removed as an admin?')

                    res = await client.wait_for('friend_message')

                    content = res.content.lower()

                    user = await client.fetch_profile(message.author.id, cache=False, raw=False)

                    if content == "yes":

                        data['FullAccess'].remove(user.display_name)

                        with open('config.json', 'w') as f:

                            json.dump(data, f, indent=4)

                            print(f" [PirxcyBotV5.1] [{getTime()}] Removed " + color.GREEN + f"{user.display_name}" + color.END + " as an admin")

                            await message.reply(f"You were removed as an admin.")

                    elif content == "no":

                            await message.reply(f"You were kept as an admin.")

                    else:

                        await message.reply(f'Not a correct response, try "yes" or "no"')

                else:

                    await message.reply('Invalid usage, try !admin add <username> or !admin remove <username>')

            if len(args) >= 3:

                joinedArgumentsAdmin = " ".join(args[2:])

                user = await client.fetch_profile(joinedArgumentsAdmin)

                try:

                    if args[1].lower() == 'add':

                        if user.display_name not in data['FullAccess']:

                            data['FullAccess'].append(f"{user.display_name}")

                            with open('config.json', 'w') as f:

                                json.dump(data, f, indent=4)

                                print(f" [PirxcyBotV5.1] [{getTime()}] Added " + color.GREEN + f"{user.display_name}" + color.END + " as an admin")

                                await message.reply(f"Added {user.display_name} as an admin.")

                        elif user.display_name in data['FullAccess']:               

                            print(f" [V] [{getTime()}]" + color.GREEN + f" {user.display_name}" + color.END + " is already an admin")

                            await message.reply(f"{user.display_name} is already an admin.")

                    elif args[1].lower() == 'remove':

                        if user.display_name in data['FullAccess']:

                            data['FullAccess'].remove(user.display_name)

                            with open('config.json', 'w') as f:

                                json.dump(data, f, indent=4)

                                print(f" [PirxcyBotV5.1] [{getTime()}] Removed " + color.GREEN + f"{user.display_name}" + color.END + " as an admin")

                                await message.reply(f"Removed {user.display_name} as an admin.")

                        elif user.display_name not in data['FullAccess']:

                            print(f" [PirxcyBotV5.1] [{getTime()}]" + color.GREEN + f" {user.display_name}" + color.END + " is not an admin")

                            await message.reply(f"{user.display_name} is not an admin.")

                except AttributeError:

                    pass

                    print(f" [PirxcyBotV5.1] [{getTime()}] Can't find user: " + color.GREEN + f"{joinedArgumentsAdmin}" + color.END)

                    await message.reply(f"I couldn't find an Epic account with the name: {joinedArgumentsAdmin}.")

        if message.author.display_name not in data['FullAccess']:

            if len(args) >= 3 and args[1].lower() == 'add':

                await message.reply(f"Password?")

                res = await client.wait_for('friend_message')

                content = res.content.lower()

                joinedArgumentsAdmin = " ".join(args[2:])

                user = await client.fetch_profile(joinedArgumentsAdmin)

                if content in data['AdminPassword']:

                    if user.display_name not in data['FullAccess']:

                        data['FullAccess'].append(f"{user.display_name}")

                        with open('config.json', 'w') as f:

                            json.dump(data, f, indent=4)

                            await message.reply(f"Correct. Added {user.display_name} as an admin.")

                            print(f" [PirxcyBotV5.1] [{getTime()}] Added " + color.GREEN + f"{user.display_name}" + color.END + " as an admin")

                    elif user.display_name in data['FullAccess']:

                        print(f" [PirxcyBotV5.1] [{getTime()}]" + color.GREEN + f" {user.display_name}" + color.END + " is already an admin")

                        await message.reply(f"{user.display_name} is already an admin.")

                else:

                    await message.reply(f"Incorrect Password")

            elif len(args) == 2 and args[1].lower() == 'add':

                await message.reply('Password?')

                res = await client.wait_for('friend_message')

                content = res.content.lower()

                user = await client.fetch_profile(message.author.id, cache=False, raw=False)

                if content in data['AdminPassword']:

                    data['FullAccess'].append(f"{user.display_name}")

                    with open('config.json', 'w') as f:

                        json.dump(data, f, indent=4)

                        await message.reply(f"Correct! You were added as an admin.")

                        print(f" [PirxcyBotV5.1] [{getTime()}] Added " + color.GREEN + f"{user.display_name}" + color.END + " as an admin")

                else:

                    await message.reply(f"Incorrect Password")

            else:

                await message.reply(f"You don't have access to this command!")



    if "!blocklist" in args[0].lower():

        if message.author.display_name in data['FullAccess']:

            if len(args) == 1:

                await message.reply('Please specify if you want to add or remove a user from the block list')

                print(f' [PirxcyBotV5.1] [{getTime()}] Please specify if you want to add or remove a user from the admin list, using ' + color.GREEN + '!admin add ' + color.END + 'or ' + color.GREEN + '!admin remove' + color.END)

            if len(args) == 2:

                if args[1].lower() == 'add' or args[1].lower() == 'remove':

                    await message.reply('Please specify the name of the user you want to add/remove from the block list')

                    print(f' [PirxcyBotV5.1] [{getTime()}] Please specify the name of the user you want to add/remove from the block list')

                else:

                    await message.reply('Invalid usage, try !blocklist add <username> or !blocklist remove <username>')

                    print(f' [PirxcyBotV5.1] [{getTime()}] Invalid usage, try ' + color.GREEN + '!BlockList add <username> ' + color.END + 'or ' + color.GREEN + '!BlockList remove <username>' + color.END)

            if len(args) >= 3:

                joinedArgumentsAdmin = " ".join(args[2:])

                user = await client.fetch_profile(joinedArgumentsAdmin)

                if args[1].lower() == 'add':

                    if user.display_name not in data['FullAccess'] and user.display_name not in data['BlockList']:

                        data['BlockList'].append(f"{user.display_name}")

                        with open('config.json', 'w') as f:

                            json.dump(data, f, indent=4)

                            await message.reply(f"Added {user.display_name} to the blocked list.")

                            print(f" [PirxcyBotV5.1] [{getTime()}] Added " + color.GREEN + f"{user.display_name}" + color.END + " to the blocked list.")

                    elif user.display_name in data['FullAccess']:

                        await message.reply(f"{user.display_name} can not be added to the blocked list.")

                        print(f" [PirxcyBotV5.1] [{getTime()}]" + color.GREEN + f" {user.display_name}" + color.END + " cannot be added to the blocked list.")

                    elif user.display_name in data['BlockList']:               

                        await message.reply(f"{user.display_name} is already on the blocked list.")

                        print(f" [PirxcyBotV5.1] [{getTime()}]" + color.GREEN + f" {user.display_name}" + color.END + " is already on the blocked list.")

                elif args[1].lower() == 'remove':

                    if user.display_name in data['BlockList']:

                        data['BlockList'].remove(user.display_name)

                        with open('config.json', 'w') as f:

                            json.dump(data, f, indent=4)

                            print(f" [PirxcyBotV5.1] [{getTime()}] Removed " + color.GREEN + f"{user.display_name}" + color.END + " from the blocked list.")

                    elif user.display_name not in data['BlockList']:

                        print(f" [PirxcyBotV5.1] [{getTime()}]" + color.GREEN + f" {user.display_name}" + color.END + " is not on the blocked list.")

        if message.author.display_name not in data['FullAccess']:

            if len(args) >= 3 and args[1].lower() == 'add':

                await message.reply(f"Password?")

                res = await client.wait_for('friend_message')

                content = res.content.lower()

                joinedArgumentsAdmin = " ".join(args[2:])

                user = await client.fetch_profile(joinedArgumentsAdmin)

                if content in data['AdminPassword']:

                    if user.display_name not in data['BlockList']:

                        data['BlockList'].append(f"{user.display_name}")

                        with open('config.json', 'w') as f:

                            json.dump(data, f, indent=4)

                            await message.reply(f"Correct. Added {user.display_name} to the blocked list.")

                            print(f" [PirxcyBotV5.1] [{getTime()}] Added " + color.GREEN + f"{user.display_name}" + color.END + " to the blocked list.")

                    elif user.display_name in data['BlockList']:

                        print(f" [PirxcyBotV5.1] [{getTime()}]" + color.GREEN + f" {user.display_name}" + color.END + " is already on the blocked list.")

                        await message.reply(f"{user.display_name} is already on the blocked list.")

                elif args[1].lower() == 'remove':

                    await message.reply(f"Password?")

                    res = await client.wait_for('friend_message')

                    content = res.content.lower()

                    joinedArgumentsAdmin = " ".join(args[2:])

                    user = await client.fetch_profile(joinedArgumentsAdmin)

                    if content in data['AdminPassword']:

                        if user.display_name in data['BlockList']:

                            data['BlockList'].remove(user.display_name)

                            with open('config.json', 'w') as f:

                                json.dump(data, f, indent=4)

                                print(f" [PirxcyBotV5.1] [{getTime()}] Removed " + color.GREEN + f"{user.display_name}" + color.END + " from the blocked list.")

                        elif user.display_name not in data['BlockList']:

                            print(f" [PirxcyBotV5.1] [{getTime()}]" + color.GREEN + f" {user.display_name}" + color.END + " is not on the blocked list.")

            else:

                await message.reply(f"You don't have access to this command!")



    if "!status" in args[0].lower():

        if message.author.display_name in data['FullAccess']:

            await client.set_status(joinedArguments)

            await message.reply(f'Status set to {joinedArguments}')

            print(f' [PirxcyBotV5.1] [{getTime()}] Status set to {joinedArguments}.')

        else:

            if message.author.display_name not in data['FullAccess']:

                await message.reply(f"You don't have access to this command!")

            

    if "!leave" in args[0].lower():

        if message.author.display_name in data['FullAccess']:

            await client.party.me.set_emote('EID_Snap')

            delay.sleep(2)

            await client.party.me.leave()

            await message.reply('Bye!')

            print(Fore.GREEN + f' [PirxcyBotV5.1] [{getTime()}] Left the party as I was requested.')

        else:

            if message.author.display_name not in data['FullAccess']:

                await message.reply(f"You don't have access to this command!")



    if "!kick" in args[0].lower() and message.author.display_name in data['FullAccess']:

        user = await client.fetch_profile(joinedArguments)

        member = client.party.members.get(user.id)

        if member is None:

            await message.reply("Couldn't find that user, are you sure they're in the party?")

        else:

            try:

                await member.kick()

                await message.reply(f"Kicked user: {member.display_name}.")

                print(Fore.GREEN + f" [PirxcyBotV5.1] [{getTime()}] Kicked user: {member.display_name}")

            except Exception as e:

                pass

                await message.reply(f"Couldn't kick {member.display_name}, as I'm not party leader.")

                print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] Failed to kick member as I don't have the required permissions." + Fore.WHITE)

        if message.author.display_name not in data['FullAccess']:

            await message.reply(f"You don't have access to this command!")



    if "!join" in args[0] and message.author.display_name in data['FullAccess']:

        if len(args) != 1:

            user = await client.fetch_profile(joinedArguments)

            friend = client.get_friend(user.id)

        if len(args) == 1:

            user = await client.fetch_profile(message.author.id, cache=False, raw=False)

            friend = client.get_friend(user.id)

        if friend is None:

            await message.reply(f"Unable to invite that user, are you sure the bot has them added?")

            print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] Unable to join user: {joinedArguments}, are you sure the bot has them added?" + Fore.WHITE)

        if message.author.display_name not in data['FullAccess']:

            await message.reply(f"You don't have access to this command!")

        else:

            try:

                await friend.join_party()

                await message.reply(f"Joining {friend.display_name}'s party.")

            except Exception as e:

                await message.reply(f"Can not join user's party.")



    if "!invite" in args[0].lower():

        if len(args) != 1:

            user = await client.fetch_profile(joinedArguments)

            friend = client.get_friend(user.id)

        if len(args) == 1:

            user = await client.fetch_profile(message.author.id, cache=False, raw=False)

            friend = client.get_friend(user.id)

        if friend is None:

            await message.reply(f"Unable to invite that user, are you sure the bot has them added?")

            print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] Unable to invite user: {joinedArguments}, are you sure the bot has them added?" + Fore.WHITE)

        else:

            try:

                await friend.invite()

                await message.reply(f"Invited user: {friend.display_name}.")

                print(Fore.GREEN + f" [PYBOT] [{getTime()}] Invited user: {friend.display_name}")

            except Exception as e:

                pass

                await message.reply(f"Something went wrong trying to invite {friend.display_name}")

                print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] Something went wrong while trying to invite {friend.display_name}" + Fore.WHITE)           



    if "!add" in args[0].lower() and message.author.display_name in data['FullAccess']:

        user = await client.fetch_profile(joinedArguments)

        friends = client.friends

        if user is None:

            await message.reply(f"I can't find a player with the name of {joinedArguments}.")

            print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] Unable to find a player with the name {joinedArguments}")

        else:

            try:

                if (user.id in friends):

                    await message.reply(f"I already have {user.display_name} as a friend.")

                    print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] You already have {user.display_name} added as a friend.")

                else: 

                    await client.add_friend(user.id)

                    await message.reply(f"Sent a friend request to {user.display_name}")

                    print(Fore.GREEN + f" [PirxcyBotV5.1] [{getTime()}] {client.user.display_name} sent a friend request to {user.display_name}" + Fore.WHITE)

            except Exception as e:

                pass

                print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] Something went wrong adding {joinedArguments}" + Fore.WHITE)

        if message.author.display_name not in data['FullAccess']:

            await message.reply(f"You don't have access to this command!")



    if "!remove" in args[0].lower() and message.author.display_name in data['FullAccess']:

        user = await client.fetch_profile(joinedArguments)

        friends = client.friends

        if user is None:

            await message.reply(f"I can't find a player with the name of {joinedArguments}.")

            print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] Unable to find a player with the name {joinedArguments}")

        else:

            try:

                if (user.id in friends):

                    await client.remove_or_decline_friend(user.id)

                    await message.reply(f"Sucessfully removed {user.display_name} as a friend.")

                    print(Fore.GREEN + f" [PirxcyBotV5.1] [{getTime()}] {client.user.display_name} removed {user.display_name} as a friend.")

                else: 

                    await message.reply(f"I don't have {user.display_name} as a friend.")

                    print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] {client.user.display_name} tried removing {user.display_name} as a friend, but the client doesn't have the friend added." + Fore.WHITE)

            except Exception as e:

                pass

                print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] Something went wrong removing {joinedArguments} as a friend." + Fore.WHITE)

        if message.author.display_name not in data['FullAccess']:

            await message.reply(f"You don't have access to this command!")



    if "!showfriends" in args[0].lower() and message.author.display_name in data['FullAccess']:

        friends = client.friends

        onlineFriends = []

        offlineFriends = []

        try:

            for f in friends:

                friend = client.get_friend(f)

                if friend.is_online():

                    onlineFriends.append(friend.display_name)

                else:

                    offlineFriends.append(friend.display_name)

            print(f" [PirxcyBotV5.1] [{getTime()}] " + Fore.WHITE + "Friends List: " + Fore.GREEN + f"{len(onlineFriends)} Online " + Fore.WHITE + "/" + Fore.LIGHTBLACK_EX + f" {len(offlineFriends)} Offline " + Fore.WHITE + "/" + Fore.LIGHTWHITE_EX + f" {len(onlineFriends) + len(offlineFriends)} Total")

            for x in onlineFriends:

                if x is not None:

                    print(Fore.GREEN + " " + x + Fore.WHITE)

            for x in offlineFriends:

                if x is not None:

                    print(Fore.LIGHTBLACK_EX + " " + x + Fore.WHITE)

        except Exception as e:

            pass

        await message.reply("Check the command window for the list of my friends.")   

        if message.author.display_name not in data['FullAccess']:

            await message.reply(f"You don't have access to this command!")



    if "!members" in args[0].lower() and message.author.display_name in data['FullAccess']:

            members = client.party.members

            partyMembers = []

            for m in members:

                member = client.get_user(m)

                partyMembers.append(member.display_name)

            print(f" [PirxcyBotV5.1] [{getTime()}] " + Fore.WHITE + "There are " + Fore.LIGHTWHITE_EX + f"{len(partyMembers)} members in client's party:")

            await message.reply(f"There are {len(partyMembers)} members in {client.user.display_name}'s party:")

            for x in partyMembers:

                if x is not None:

                    print(Fore.GREEN + " " + x + Fore.WHITE)

                    await message.reply(x)



    if "!promote" in args[0].lower() and message.author.display_name in data['FullAccess']:

        if len(args) != 1:

            user = await client.fetch_profile(joinedArguments)

            member = client.party.members.get(user.id)

        if len(args) == 1:

            user = await client.fetch_profile(message.author.display_name)

            member = client.party.members.get(user.id)

        if member is None:

            await message.reply("Couldn't find that user, are you sure they're in the party?")

        else:

            try:

                await member.promote()

                await message.reply(f"Promoted user: {member.display_name}.")

                print(Fore.GREEN + f" [PirxcyBotV5.1] [{getTime()}] Promoted user: {member.display_name}")

            except Exception as e:

                pass

                await message.reply(f"Couldn't promote {member.display_name}, as I'm not party leader.")

                print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] Failed to promote member as I don't have the required permissions." + Fore.WHITE)

        if message.author.display_name not in data['FullAccess']:

            await message.reply(f"You don't have access to this command!")



    if "Playlist_" in args[0]:

        try:

            await client.party.set_playlist(playlist=args[0])

        except Exception as e:

            pass

            await message.reply(f"Couldn't set gamemode to {args[0]}, as I'm not party leader.")

            print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] Failed to set gamemode as I don't have the required permissions." + Fore.WHITE)



    if "!platform" in args[0] and message.author.display_name in data['FullAccess']:

        await message.reply('Setting platform to ' + args[1] + '.')

        party_id = client.party.id

        await client.party.me.leave()

        client.platform = fortnitepy.Platform(args[1])

        await message.reply('Platform set to ' + str(client.platform) + '.')

        try:

            await client.join_to_party(party_id, check_private=True)

        except Exception as e:

            pass

            await message.reply('Failed to join back as party is set to private.')

        else:

            if message.author.display_name not in data['FullAccess']:

                await message.reply(f"You don't have access to this command!")



    if args[0] == "!id":

        if message.author.display_name in data['BlockList']:

            await message.reply("You don't have access to this command!")

        else:

            user = await client.fetch_profile(joinedArguments, cache=False, raw=False)

            try:

                await message.reply(f"{joinedArguments}'s Epic ID is: {user.id}")

                print(Fore.GREEN + f" [PirxcyBotV5.1] [{getTime()}] {joinedArguments}'s Epic ID is: {user.id}")

            except AttributeError:

                await message.reply(f"I couldn't find an Epic account with the name: {joinedArguments}.")

                print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] I couldn't find an Epic account with the name: {joinedArguments}.")



try:

    client.run()

except fortnitepy.AuthException as e:

    print(Fore.RED + f" [PirxcyBotV5.1] [{getTime()}] [ERROR] {e}")

