# Security Policy

Thank you for helping keep **{{ general.slug }}** package and its users safe.
We take security issues seriously and appreciate responsible disclosures.

## Reporting a Vulnerability

> [!NOTE]
> **Please do NOT open public issues for security reports.**
> Use one of the private channels below so we can coordinate a safe disclosure.

| Channel                      | How it works                                                                                                                  |
| ---------------------------- | ----------------------------------------------------------------------------------------------------------------------------- |
| **GitHub Security Advisory** | 1. Navigate to the repository's **“Security → Advisories”** tab<br>2. Click **“Report a vulnerability”** and fill in the form |

Include the following, if possible:

1. A **concise description** of the issue and its impact.
2. **Reproduction steps** or a proof-of-concept script.
3. Any **mitigation** ideas you've identified.

## Our Disclosure Process

1. **Acknowledge** report within 24–48 hours.
2. **Triage & validate** the issue; request additional info if needed.
3. **Fix & prepare**: develop a patch and regression tests.
4. **Coordinate release**:
    - Agree on a disclosure date with the reporter (usually ≤ 30 days).
    - Publish a CVE (if applicable) and a new PyPI release.
    - Post a security advisory and update CHANGELOG.
5. **Credit** the reporter (optional & with consent).

## Responsible Disclosure

We kindly ask you to:

- Allow us reasonable time to remediate before any public disclosure.
- Avoid violating user privacy, destroying data, or disrupting production services while researching.
- Test only on your own instances or in minimal, isolated cases.

We are committed to keeping this project and its users safe and will strive to resolve all legitimate reports swiftly and transparently.

_Thank you for keeping the **{{ general.slug }}** package community secure!_