# Generated by Django 4.2.23 on 2025-07-03 12:04

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields
import djangoldp_becknld.models.transaction


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="Address",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "urlid",
                    djangoldp.fields.LDPUrlField(
                        blank=True, db_index=True, null=True, unique=True
                    ),
                ),
                (
                    "is_backlink",
                    models.BooleanField(
                        default=False,
                        help_text="set automatically to indicate the Model is a backlink",
                    ),
                ),
                (
                    "allow_create_backlink",
                    models.BooleanField(
                        default=True,
                        help_text="set to False to disable backlink creation after Model save",
                    ),
                ),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                (
                    "name",
                    models.CharField(blank=True, default="", max_length=254, null=True),
                ),
                ("steet_address", models.CharField(max_length=254)),
                ("address_locality", models.CharField(max_length=254)),
                ("address_region", models.CharField(max_length=254)),
                ("address_country", models.CharField(max_length=254)),
                ("postal_code", models.CharField(max_length=254)),
            ],
            options={
                "verbose_name": "Address",
                "verbose_name_plural": "Addresses",
                "abstract": False,
                "default_permissions": {"change", "control", "delete", "view", "add"},
                "rdf_type": "schema:deliveryAddress",
                "serializer_fields": [
                    "@id",
                    "creation_date",
                    "update_date",
                    "name",
                    "steet_address",
                    "address_locality",
                    "address_region",
                    "address_country",
                    "postal_code",
                ],
                "nested_fields": [],
                "depth": 0,
                "inherit_permissions": ["delivery_method", "invoice"],
                "disable_url": True,
            },
        ),
        migrations.CreateModel(
            name="DeliveryMethod",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "urlid",
                    djangoldp.fields.LDPUrlField(
                        blank=True, db_index=True, null=True, unique=True
                    ),
                ),
                (
                    "is_backlink",
                    models.BooleanField(
                        default=False,
                        help_text="set automatically to indicate the Model is a backlink",
                    ),
                ),
                (
                    "allow_create_backlink",
                    models.BooleanField(
                        default=True,
                        help_text="set to False to disable backlink creation after Model save",
                    ),
                ),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                ("contact_point", models.CharField(max_length=24)),
                (
                    "delivery_address",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="delivery_method",
                        to="djangoldp_becknld.address",
                    ),
                ),
            ],
            options={
                "verbose_name": "Delivery Method",
                "verbose_name_plural": "Delivery Methods",
                "abstract": False,
                "default_permissions": {"change", "control", "delete", "view", "add"},
                "rdf_type": "schema:ParcelDelivery",
                "serializer_fields": [
                    "@id",
                    "creation_date",
                    "update_date",
                    "delivery_address",
                    "contact_point",
                ],
                "nested_fields": ["delivery_address"],
                "depth": 0,
                "inherit_permissions": "offer",
                "disable_url": True,
            },
        ),
        migrations.CreateModel(
            name="DeliveryOption",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "urlid",
                    djangoldp.fields.LDPUrlField(
                        blank=True, db_index=True, null=True, unique=True
                    ),
                ),
                (
                    "is_backlink",
                    models.BooleanField(
                        default=False,
                        help_text="set automatically to indicate the Model is a backlink",
                    ),
                ),
                (
                    "allow_create_backlink",
                    models.BooleanField(
                        default=True,
                        help_text="set to False to disable backlink creation after Model save",
                    ),
                ),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                (
                    "name",
                    models.CharField(blank=True, default="", max_length=254, null=True),
                ),
            ],
            options={
                "verbose_name": "Delivery Option",
                "verbose_name_plural": "Delivery Options",
                "abstract": False,
                "default_permissions": {"change", "control", "delete", "view", "add"},
                "rdf_type": "schema:ParcelDelivery",
                "serializer_fields": ["@id", "creation_date", "update_date", "name"],
                "nested_fields": [],
                "depth": 0,
                "disable_url": True,
            },
        ),
        migrations.CreateModel(
            name="Invoice",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "urlid",
                    djangoldp.fields.LDPUrlField(
                        blank=True, db_index=True, null=True, unique=True
                    ),
                ),
                (
                    "is_backlink",
                    models.BooleanField(
                        default=False,
                        help_text="set automatically to indicate the Model is a backlink",
                    ),
                ),
                (
                    "allow_create_backlink",
                    models.BooleanField(
                        default=True,
                        help_text="set to False to disable backlink creation after Model save",
                    ),
                ),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                (
                    "name",
                    models.CharField(blank=True, default="", max_length=254, null=True),
                ),
                ("email", models.EmailField(max_length=254)),
                ("telephone", models.CharField(max_length=24)),
                (
                    "billing_address",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="invoice",
                        to="djangoldp_becknld.address",
                    ),
                ),
            ],
            options={
                "verbose_name": "Invoice",
                "verbose_name_plural": "Invoices",
                "abstract": False,
                "default_permissions": {"change", "control", "delete", "view", "add"},
                "rdf_type": "schema:Invoice",
                "serializer_fields": [
                    "@id",
                    "creation_date",
                    "update_date",
                    "name",
                    "billing_address",
                    "email",
                    "telephone",
                ],
                "nested_fields": ["billing_address"],
                "depth": 0,
                "inherit_permissions": "offer",
                "disable_url": True,
            },
        ),
        migrations.CreateModel(
            name="Item",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "urlid",
                    djangoldp.fields.LDPUrlField(
                        blank=True, db_index=True, null=True, unique=True
                    ),
                ),
                (
                    "is_backlink",
                    models.BooleanField(
                        default=False,
                        help_text="set automatically to indicate the Model is a backlink",
                    ),
                ),
                (
                    "allow_create_backlink",
                    models.BooleanField(
                        default=True,
                        help_text="set to False to disable backlink creation after Model save",
                    ),
                ),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                ("item_id", models.URLField()),
                ("unitary_price", models.FloatField()),
                ("unit_text", models.CharField(max_length=254)),
            ],
            options={
                "verbose_name": "Item",
                "verbose_name_plural": "Items",
                "abstract": False,
                "default_permissions": {"change", "control", "delete", "view", "add"},
                "rdf_type": "internal:Item",
                "serializer_fields": [
                    "@id",
                    "creation_date",
                    "update_date",
                    "item",
                    "unitary_price",
                    "unit_text",
                ],
                "nested_fields": [],
                "depth": 0,
                "disable_url": True,
            },
        ),
        migrations.CreateModel(
            name="Offer",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "urlid",
                    djangoldp.fields.LDPUrlField(
                        blank=True, db_index=True, null=True, unique=True
                    ),
                ),
                (
                    "is_backlink",
                    models.BooleanField(
                        default=False,
                        help_text="set automatically to indicate the Model is a backlink",
                    ),
                ),
                (
                    "allow_create_backlink",
                    models.BooleanField(
                        default=True,
                        help_text="set to False to disable backlink creation after Model save",
                    ),
                ),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                (
                    "payment_status",
                    models.CharField(
                        choices=[
                            (
                                "schema:PaymentAutomaticallyApplied",
                                "PaymentAutomaticallyApplied",
                            ),
                            ("schema:PaymentComplete", "PaymentComplete"),
                            ("schema:PaymentDeclined", "PaymentDeclined"),
                            ("schema:PaymentDue", "PaymentDue"),
                            ("schema:PaymentPastDue", "PaymentPastDue"),
                        ],
                        max_length=36,
                    ),
                ),
                (
                    "billing_address",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="offer",
                        to="djangoldp_becknld.invoice",
                    ),
                ),
                (
                    "delivery_method",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="offer",
                        to="djangoldp_becknld.deliverymethod",
                    ),
                ),
            ],
            options={
                "verbose_name": "Offer",
                "verbose_name_plural": "Offers",
                "abstract": False,
                "default_permissions": {"change", "control", "delete", "view", "add"},
                "rdf_type": "schema:Offer",
                "serializer_fields": [
                    "@id",
                    "creation_date",
                    "update_date",
                    "price_specification",
                    "delivery_method",
                    "billing_address",
                    "payment_option",
                    "payment_status",
                ],
                "nested_fields": [
                    "price_specification",
                    "delivery_method",
                    "billing_address",
                    "payment_option",
                ],
                "depth": 0,
                "disable_url": True,
            },
        ),
        migrations.CreateModel(
            name="Order",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "urlid",
                    djangoldp.fields.LDPUrlField(
                        blank=True, db_index=True, null=True, unique=True
                    ),
                ),
                (
                    "is_backlink",
                    models.BooleanField(
                        default=False,
                        help_text="set automatically to indicate the Model is a backlink",
                    ),
                ),
                (
                    "allow_create_backlink",
                    models.BooleanField(
                        default=True,
                        help_text="set to False to disable backlink creation after Model save",
                    ),
                ),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                (
                    "order_number",
                    models.CharField(
                        default=djangoldp_becknld.models.transaction.tidgen,
                        max_length=36,
                    ),
                ),
                (
                    "responded_offer",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="related_order",
                        to="djangoldp_becknld.offer",
                    ),
                ),
            ],
            options={
                "verbose_name": "Order",
                "verbose_name_plural": "Orders",
                "abstract": False,
                "default_permissions": {"change", "control", "delete", "view", "add"},
                "rdf_type": "schema:Order",
                "serializer_fields": [
                    "@id",
                    "creation_date",
                    "update_date",
                    "transaction_id",
                    "order_number",
                    "ordered_items",
                ],
                "nested_fields": ["ordered_items"],
                "depth": 0,
                "inherit_permissions": "transaction",
                "disable_url": True,
            },
        ),
        migrations.CreateModel(
            name="PaymentOption",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "urlid",
                    djangoldp.fields.LDPUrlField(
                        blank=True, db_index=True, null=True, unique=True
                    ),
                ),
                (
                    "is_backlink",
                    models.BooleanField(
                        default=False,
                        help_text="set automatically to indicate the Model is a backlink",
                    ),
                ),
                (
                    "allow_create_backlink",
                    models.BooleanField(
                        default=True,
                        help_text="set to False to disable backlink creation after Model save",
                    ),
                ),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                (
                    "name",
                    models.CharField(blank=True, default="", max_length=254, null=True),
                ),
            ],
            options={
                "verbose_name": "Payment Option",
                "verbose_name_plural": "Payment Options",
                "abstract": False,
                "default_permissions": {"change", "control", "delete", "view", "add"},
                "rdf_type": "schema:PaymentMethod",
                "serializer_fields": ["@id", "creation_date", "update_date", "name"],
                "nested_fields": [],
                "depth": 0,
                "disable_url": True,
            },
        ),
        migrations.CreateModel(
            name="PriceSpecification",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "urlid",
                    djangoldp.fields.LDPUrlField(
                        blank=True, db_index=True, null=True, unique=True
                    ),
                ),
                (
                    "is_backlink",
                    models.BooleanField(
                        default=False,
                        help_text="set automatically to indicate the Model is a backlink",
                    ),
                ),
                (
                    "allow_create_backlink",
                    models.BooleanField(
                        default=True,
                        help_text="set to False to disable backlink creation after Model save",
                    ),
                ),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                ("price_currency", models.CharField(max_length=3)),
                ("price", models.FloatField()),
            ],
            options={
                "verbose_name": "Price Specification",
                "verbose_name_plural": "Price Specifications",
                "abstract": False,
                "default_permissions": {"change", "control", "delete", "view", "add"},
                "rdf_type": "schema:PriceSpecification",
                "serializer_fields": [
                    "@id",
                    "creation_date",
                    "update_date",
                    "price_currency",
                    "price",
                ],
                "nested_fields": [],
                "depth": 0,
                "inherit_permissions": "offer",
                "disable_url": True,
            },
        ),
        migrations.CreateModel(
            name="QuantitativeValue",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "urlid",
                    djangoldp.fields.LDPUrlField(
                        blank=True, db_index=True, null=True, unique=True
                    ),
                ),
                (
                    "is_backlink",
                    models.BooleanField(
                        default=False,
                        help_text="set automatically to indicate the Model is a backlink",
                    ),
                ),
                (
                    "allow_create_backlink",
                    models.BooleanField(
                        default=True,
                        help_text="set to False to disable backlink creation after Model save",
                    ),
                ),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                ("value", models.FloatField()),
                ("unit_text", models.CharField(max_length=254)),
            ],
            options={
                "verbose_name": "Quantitative Value",
                "verbose_name_plural": "Quantitative Values",
                "abstract": False,
                "default_permissions": {"change", "control", "delete", "view", "add"},
                "rdf_type": "schema:QuantitativeValue",
                "serializer_fields": [
                    "@id",
                    "creation_date",
                    "update_date",
                    "value",
                    "unit_text",
                ],
                "nested_fields": [],
                "depth": 0,
                "inherit_permissions": "specification_offer",
                "disable_url": True,
            },
        ),
        migrations.CreateModel(
            name="Transaction",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "urlid",
                    djangoldp.fields.LDPUrlField(
                        blank=True, db_index=True, null=True, unique=True
                    ),
                ),
                (
                    "is_backlink",
                    models.BooleanField(
                        default=False,
                        help_text="set automatically to indicate the Model is a backlink",
                    ),
                ),
                (
                    "allow_create_backlink",
                    models.BooleanField(
                        default=True,
                        help_text="set to False to disable backlink creation after Model save",
                    ),
                ),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                (
                    "transaction_id",
                    models.SlugField(
                        default=djangoldp_becknld.models.transaction.tidgen,
                        max_length=36,
                    ),
                ),
                ("bap_uri", models.URLField(blank=True, null=True)),
                ("bpp_uri", models.URLField(blank=True, null=True)),
                (
                    "creator",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="created_transactions",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "initiators",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="transactions",
                        to="auth.group",
                    ),
                ),
            ],
            options={
                "verbose_name": "Transaction",
                "verbose_name_plural": "Transactions",
                "ordering": ["transaction_id"],
                "abstract": False,
                "default_permissions": {"change", "control", "delete", "view", "add"},
                "lookup_field": "transaction_id",
                "rdf_type": "becknld:Transaction",
                "auto_author": "creator",
                "serializer_fields": [
                    "@id",
                    "creation_date",
                    "update_date",
                    "transaction_id",
                    "bap_inbox",
                    "bap_outbox",
                    "bpp_uri",
                    "bap_uri",
                ],
                "nested_fields": [],
                "depth": 4,
                "permission_roles": {
                    "initiators": {
                        "add_author": True,
                        "perms": ["view", "change", "control", "delete"],
                    }
                },
            },
        ),
        migrations.CreateModel(
            name="PriceComponent",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "urlid",
                    djangoldp.fields.LDPUrlField(
                        blank=True, db_index=True, null=True, unique=True
                    ),
                ),
                (
                    "is_backlink",
                    models.BooleanField(
                        default=False,
                        help_text="set automatically to indicate the Model is a backlink",
                    ),
                ),
                (
                    "allow_create_backlink",
                    models.BooleanField(
                        default=True,
                        help_text="set to False to disable backlink creation after Model save",
                    ),
                ),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                (
                    "name",
                    models.CharField(blank=True, default="", max_length=254, null=True),
                ),
                ("price", models.FloatField()),
                (
                    "specification_offer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="price_components",
                        to="djangoldp_becknld.pricespecification",
                    ),
                ),
            ],
            options={
                "verbose_name": "Price Component",
                "verbose_name_plural": "Price Components",
                "abstract": False,
                "default_permissions": {"change", "control", "delete", "view", "add"},
                "rdf_type": "schema:UnitPriceSpecification",
                "serializer_fields": [
                    "@id",
                    "creation_date",
                    "update_date",
                    "name",
                    "price",
                ],
                "nested_fields": [],
                "depth": 0,
                "inherit_permissions": "specification_offer",
                "disable_url": True,
            },
        ),
        migrations.CreateModel(
            name="OrderItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "urlid",
                    djangoldp.fields.LDPUrlField(
                        blank=True, db_index=True, null=True, unique=True
                    ),
                ),
                (
                    "is_backlink",
                    models.BooleanField(
                        default=False,
                        help_text="set automatically to indicate the Model is a backlink",
                    ),
                ),
                (
                    "allow_create_backlink",
                    models.BooleanField(
                        default=True,
                        help_text="set to False to disable backlink creation after Model save",
                    ),
                ),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                ("item_offered", models.URLField()),
                (
                    "order",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="ordered_items",
                        to="djangoldp_becknld.order",
                    ),
                ),
                (
                    "order_quantity",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djangoldp_becknld.quantitativevalue",
                    ),
                ),
            ],
            options={
                "verbose_name": "Order Item",
                "verbose_name_plural": "Order Items",
                "abstract": False,
                "default_permissions": {"change", "control", "delete", "view", "add"},
                "rdf_type": "schema:OrderItem",
                "serializer_fields": [
                    "@id",
                    "creation_date",
                    "update_date",
                    "item_offered",
                    "order_quantity",
                ],
                "nested_fields": ["order_quantity"],
                "depth": 0,
                "inherit_permissions": "order",
                "disable_url": True,
            },
        ),
        migrations.AddField(
            model_name="order",
            name="transaction",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="orders",
                to="djangoldp_becknld.transaction",
            ),
        ),
        migrations.AddField(
            model_name="offer",
            name="payment_option",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="djangoldp_becknld.paymentoption",
            ),
        ),
        migrations.AddField(
            model_name="offer",
            name="price_specification",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="offer",
                to="djangoldp_becknld.pricespecification",
            ),
        ),
    ]
