"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageClass = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Storage class to move an object to
 */
class StorageClass {
    constructor(value) {
        this.value = value;
    }
    toString() { return this.value; }
}
exports.StorageClass = StorageClass;
_a = JSII_RTTI_SYMBOL_1;
StorageClass[_a] = { fqn: "@aws-cdk/aws-s3.StorageClass", version: "1.166.1" };
/**
 * Storage class for data that is accessed less frequently, but requires rapid
 * access when needed.
 *
 * Has lower availability than Standard storage.
 */
StorageClass.INFREQUENT_ACCESS = new StorageClass('STANDARD_IA');
/**
 * Infrequent Access that's only stored in one availability zone.
 *
 * Has lower availability than standard InfrequentAccess.
 */
StorageClass.ONE_ZONE_INFREQUENT_ACCESS = new StorageClass('ONEZONE_IA');
/**
 * Storage class for long-term archival that can take between minutes and
 * hours to access.
 *
 * Use for archives where portions of the data might need to be retrieved in
 * minutes. Data stored in the GLACIER storage class has a minimum storage
 * duration period of 90 days and can be accessed in as little as 1-5 minutes
 * using expedited retrieval. If you delete an object before the 90-day
 * minimum, you are charged for 90 days.
 */
StorageClass.GLACIER = new StorageClass('GLACIER');
/**
 * Storage class for long-term archival that can be accessed in a few milliseconds.
 *
 * It is ideal for data that is accessed once or twice per quarter, and
 * that requires immediate access. Data stored in the GLACIER_IR storage class
 * has a minimum storage duration period of 90 days and can be accessed in
 * as milliseconds. If you delete an object before the 90-day minimum,
 * you are charged for 90 days.
 */
StorageClass.GLACIER_INSTANT_RETRIEVAL = new StorageClass('GLACIER_IR');
/**
 * Use for archiving data that rarely needs to be accessed. Data stored in the
 * DEEP_ARCHIVE storage class has a minimum storage duration period of 180
 * days and a default retrieval time of 12 hours. If you delete an object
 * before the 180-day minimum, you are charged for 180 days. For pricing
 * information, see Amazon S3 Pricing.
 */
StorageClass.DEEP_ARCHIVE = new StorageClass('DEEP_ARCHIVE');
/**
 * The INTELLIGENT_TIERING storage class is designed to optimize storage costs
 * by automatically moving data to the most cost-effective storage access
 * tier, without performance impact or operational overhead.
 * INTELLIGENT_TIERING delivers automatic cost savings by moving data on a
 * granular object level between two access tiers, a frequent access tier and
 * a lower-cost infrequent access tier, when access patterns change. The
 * INTELLIGENT_TIERING storage class is ideal if you want to optimize storage
 * costs automatically for long-lived data when access patterns are unknown or
 * unpredictable.
 */
StorageClass.INTELLIGENT_TIERING = new StorageClass('INTELLIGENT_TIERING');
//# sourceMappingURL=data:application/json;base64,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