webpackJsonp([12],{

/***/ 50:
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),

/***/ 51:
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getElement = (function (fn) {
	var memo = {};

	return function(selector) {
		if (typeof memo[selector] === "undefined") {
			var styleTarget = fn.call(this, selector);
			// Special case to return head of iframe instead of iframe itself
			if (styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[selector] = styleTarget;
		}
		return memo[selector]
	};
})(function (target) {
	return document.querySelector(target)
});

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(52);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
	if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	options.attrs.type = "text/css";

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	options.attrs.type = "text/css";
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),

/***/ 52:
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ }),

/***/ 637:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(638);

/***/ }),

/***/ 638:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(639);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(51)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!../../node_modules/css-loader/index.js!../../node_modules/sass-loader/lib/loader.js!./app.scss", function() {
			var newContent = require("!!../../node_modules/css-loader/index.js!../../node_modules/sass-loader/lib/loader.js!./app.scss");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ }),

/***/ 639:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(50)(false);
// imports


// module
exports.push([module.i, "/*!\n * Bootstrap v4.0.0 (https://getbootstrap.com)\n * Copyright 2011-2018 The Bootstrap Authors\n * Copyright 2011-2018 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n */\n:root {\n  --blue: #00acec;\n  --indigo: #6610f2;\n  --purple: #6f42c1;\n  --pink: #d50089;\n  --red: #dc3545;\n  --orange: #fd7e14;\n  --yellow: #ffc107;\n  --green: #28a745;\n  --teal: #20c997;\n  --cyan: #17a2b8;\n  --white: #fff;\n  --gray: #868e96;\n  --gray-dark: #343a40;\n  --primary: #00acec;\n  --secondary: #868e96;\n  --success: #28a745;\n  --info: #d50089;\n  --warning: #ffc107;\n  --danger: #dc3545;\n  --light: #f8f9fa;\n  --dark: #343a40;\n  --breakpoint-xs: 0;\n  --breakpoint-sm: 576px;\n  --breakpoint-md: 768px;\n  --breakpoint-lg: 992px;\n  --breakpoint-xl: 1200px;\n  --breakpoint-xxl: 1440px;\n  --font-family-sans-serif: \"Roboto\", \"Helvetica Neue\", Arial, sans-serif;\n  --font-family-monospace: SFMono-Regular, Menlo, Monaco, Consolas, \"Liberation Mono\", \"Courier New\", monospace; }\n\n*,\n*::before,\n*::after {\n  box-sizing: border-box; }\n\nhtml {\n  font-family: sans-serif;\n  line-height: 1.15;\n  -webkit-text-size-adjust: 100%;\n  -ms-text-size-adjust: 100%;\n  -ms-overflow-style: scrollbar;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0); }\n\n@-ms-viewport {\n  width: device-width; }\n\narticle, aside, dialog, figcaption, figure, footer, header, hgroup, main, nav, section {\n  display: block; }\n\nbody {\n  margin: 0;\n  font-family: \"Roboto\", \"Helvetica Neue\", Arial, sans-serif;\n  font-size: 1rem;\n  font-weight: 400;\n  line-height: 1.5;\n  color: #212529;\n  text-align: left;\n  background-color: #fff; }\n\n[tabindex=\"-1\"]:focus {\n  outline: 0 !important; }\n\nhr {\n  box-sizing: content-box;\n  height: 0;\n  overflow: visible; }\n\nh1, h2, h3, h4, h5, h6 {\n  margin-top: 0;\n  margin-bottom: 0.5rem; }\n\np {\n  margin-top: 0;\n  margin-bottom: 1rem; }\n\nabbr[title],\nabbr[data-original-title] {\n  text-decoration: underline;\n  text-decoration: underline dotted;\n  cursor: help;\n  border-bottom: 0; }\n\naddress {\n  margin-bottom: 1rem;\n  font-style: normal;\n  line-height: inherit; }\n\nol,\nul,\ndl {\n  margin-top: 0;\n  margin-bottom: 1rem; }\n\nol ol,\nul ul,\nol ul,\nul ol {\n  margin-bottom: 0; }\n\ndt {\n  font-weight: 700; }\n\ndd {\n  margin-bottom: .5rem;\n  margin-left: 0; }\n\nblockquote {\n  margin: 0 0 1rem; }\n\ndfn {\n  font-style: italic; }\n\nb,\nstrong {\n  font-weight: bolder; }\n\nsmall {\n  font-size: 80%; }\n\nsub,\nsup {\n  position: relative;\n  font-size: 75%;\n  line-height: 0;\n  vertical-align: baseline; }\n\nsub {\n  bottom: -.25em; }\n\nsup {\n  top: -.5em; }\n\na {\n  color: #00acec;\n  text-decoration: none;\n  background-color: transparent;\n  -webkit-text-decoration-skip: objects; }\n  a:hover {\n    color: #0074a0;\n    text-decoration: underline; }\n\na:not([href]):not([tabindex]) {\n  color: inherit;\n  text-decoration: none; }\n  a:not([href]):not([tabindex]):hover, a:not([href]):not([tabindex]):focus {\n    color: inherit;\n    text-decoration: none; }\n  a:not([href]):not([tabindex]):focus {\n    outline: 0; }\n\npre,\ncode,\nkbd,\nsamp {\n  font-family: monospace, monospace;\n  font-size: 1em; }\n\npre {\n  margin-top: 0;\n  margin-bottom: 1rem;\n  overflow: auto;\n  -ms-overflow-style: scrollbar; }\n\nfigure {\n  margin: 0 0 1rem; }\n\nimg {\n  vertical-align: middle;\n  border-style: none; }\n\nsvg:not(:root) {\n  overflow: hidden; }\n\ntable {\n  border-collapse: collapse; }\n\ncaption {\n  padding-top: 0.75rem;\n  padding-bottom: 0.75rem;\n  color: #868e96;\n  text-align: left;\n  caption-side: bottom; }\n\nth {\n  text-align: inherit; }\n\nlabel {\n  display: inline-block;\n  margin-bottom: .5rem; }\n\nbutton {\n  border-radius: 0; }\n\nbutton:focus {\n  outline: 1px dotted;\n  outline: 5px auto -webkit-focus-ring-color; }\n\ninput,\nbutton,\nselect,\noptgroup,\ntextarea {\n  margin: 0;\n  font-family: inherit;\n  font-size: inherit;\n  line-height: inherit; }\n\nbutton,\ninput {\n  overflow: visible; }\n\nbutton,\nselect {\n  text-transform: none; }\n\nbutton,\nhtml [type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"] {\n  -webkit-appearance: button; }\n\nbutton::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner {\n  padding: 0;\n  border-style: none; }\n\ninput[type=\"radio\"],\ninput[type=\"checkbox\"] {\n  box-sizing: border-box;\n  padding: 0; }\n\ninput[type=\"date\"],\ninput[type=\"time\"],\ninput[type=\"datetime-local\"],\ninput[type=\"month\"] {\n  -webkit-appearance: listbox; }\n\ntextarea {\n  overflow: auto;\n  resize: vertical; }\n\nfieldset {\n  min-width: 0;\n  padding: 0;\n  margin: 0;\n  border: 0; }\n\nlegend {\n  display: block;\n  width: 100%;\n  max-width: 100%;\n  padding: 0;\n  margin-bottom: .5rem;\n  font-size: 1.5rem;\n  line-height: inherit;\n  color: inherit;\n  white-space: normal; }\n\nprogress {\n  vertical-align: baseline; }\n\n[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button {\n  height: auto; }\n\n[type=\"search\"] {\n  outline-offset: -2px;\n  -webkit-appearance: none; }\n\n[type=\"search\"]::-webkit-search-cancel-button,\n[type=\"search\"]::-webkit-search-decoration {\n  -webkit-appearance: none; }\n\n::-webkit-file-upload-button {\n  font: inherit;\n  -webkit-appearance: button; }\n\noutput {\n  display: inline-block; }\n\nsummary {\n  display: list-item;\n  cursor: pointer; }\n\ntemplate {\n  display: none; }\n\n[hidden] {\n  display: none !important; }\n\nh1, h2, h3, h4, h5, h6,\n.h1, .h2, .h3, .h4, .h5, .h6 {\n  margin-bottom: 0.5rem;\n  font-family: inherit;\n  font-weight: 500;\n  line-height: 1.2;\n  color: inherit; }\n\nh1, .h1 {\n  font-size: 2.5rem; }\n\nh2, .h2 {\n  font-size: 2rem; }\n\nh3, .h3 {\n  font-size: 1.75rem; }\n\nh4, .h4 {\n  font-size: 1.5rem; }\n\nh5, .h5 {\n  font-size: 1.25rem; }\n\nh6, .h6 {\n  font-size: 1rem; }\n\n.lead {\n  font-size: 1.25rem;\n  font-weight: 300; }\n\n.display-1 {\n  font-size: 6rem;\n  font-weight: 300;\n  line-height: 1.2; }\n\n.display-2 {\n  font-size: 5.5rem;\n  font-weight: 300;\n  line-height: 1.2; }\n\n.display-3 {\n  font-size: 4.5rem;\n  font-weight: 300;\n  line-height: 1.2; }\n\n.display-4 {\n  font-size: 3.5rem;\n  font-weight: 300;\n  line-height: 1.2; }\n\nhr {\n  margin-top: 1rem;\n  margin-bottom: 1rem;\n  border: 0;\n  border-top: 1px solid rgba(0, 0, 0, 0.1); }\n\nsmall,\n.small {\n  font-size: 80%;\n  font-weight: 400; }\n\nmark,\n.mark {\n  padding: 0.2em;\n  background-color: #fcf8e3; }\n\n.list-unstyled {\n  padding-left: 0;\n  list-style: none; }\n\n.list-inline {\n  padding-left: 0;\n  list-style: none; }\n\n.list-inline-item {\n  display: inline-block; }\n  .list-inline-item:not(:last-child) {\n    margin-right: 0.5rem; }\n\n.initialism {\n  font-size: 90%;\n  text-transform: uppercase; }\n\n.blockquote {\n  margin-bottom: 1rem;\n  font-size: 1.25rem; }\n\n.blockquote-footer {\n  display: block;\n  font-size: 80%;\n  color: #868e96; }\n  .blockquote-footer::before {\n    content: \"\\2014   \\A0\"; }\n\n.img-fluid {\n  max-width: 100%;\n  height: auto; }\n\n.img-thumbnail {\n  padding: 0.25rem;\n  background-color: #fff;\n  border: 1px solid #dee2e6;\n  border-radius: 0.1875rem;\n  max-width: 100%;\n  height: auto; }\n\n.figure {\n  display: inline-block; }\n\n.figure-img {\n  margin-bottom: 0.5rem;\n  line-height: 1; }\n\n.figure-caption {\n  font-size: 90%;\n  color: #868e96; }\n\ncode,\nkbd,\npre,\nsamp {\n  font-family: SFMono-Regular, Menlo, Monaco, Consolas, \"Liberation Mono\", \"Courier New\", monospace; }\n\ncode {\n  font-size: 87.5%;\n  color: #d50089;\n  word-break: break-word; }\n  a > code {\n    color: inherit; }\n\nkbd {\n  padding: 0.2rem 0.4rem;\n  font-size: 87.5%;\n  color: #fff;\n  background-color: #212529;\n  border-radius: 0.2rem; }\n  kbd kbd {\n    padding: 0;\n    font-size: 100%;\n    font-weight: 700; }\n\npre {\n  display: block;\n  font-size: 87.5%;\n  color: #212529; }\n  pre code {\n    font-size: inherit;\n    color: inherit;\n    word-break: normal; }\n\n.pre-scrollable {\n  max-height: 340px;\n  overflow-y: scroll; }\n\n.container {\n  width: 100%;\n  padding-right: 15px;\n  padding-left: 15px;\n  margin-right: auto;\n  margin-left: auto; }\n  @media (min-width: 576px) {\n    .container {\n      max-width: 540px; } }\n  @media (min-width: 768px) {\n    .container {\n      max-width: 720px; } }\n  @media (min-width: 992px) {\n    .container {\n      max-width: 960px; } }\n  @media (min-width: 1200px) {\n    .container {\n      max-width: 1140px; } }\n  @media (min-width: 1440px) {\n    .container {\n      max-width: 1360px; } }\n\n.container-fluid {\n  width: 100%;\n  padding-right: 15px;\n  padding-left: 15px;\n  margin-right: auto;\n  margin-left: auto; }\n\n.row {\n  display: flex;\n  flex-wrap: wrap;\n  margin-right: -15px;\n  margin-left: -15px; }\n\n.no-gutters {\n  margin-right: 0;\n  margin-left: 0; }\n  .no-gutters > .col,\n  .no-gutters > [class*=\"col-\"] {\n    padding-right: 0;\n    padding-left: 0; }\n\n.col-1, .col-2, .col-3, .col-4, .col-5, .col-6, .col-7, .col-8, .col-9, .col-10, .col-11, .col-12, .col,\n.col-auto, .col-sm-1, .col-sm-2, .col-sm-3, .col-sm-4, .col-sm-5, .col-sm-6, .col-sm-7, .col-sm-8, .col-sm-9, .col-sm-10, .col-sm-11, .col-sm-12, .col-sm,\n.col-sm-auto, .col-md-1, .col-md-2, .col-md-3, .col-md-4, .col-md-5, .col-md-6, .col-md-7, .col-md-8, .col-md-9, .col-md-10, .col-md-11, .col-md-12, .col-md,\n.col-md-auto, .col-lg-1, .col-lg-2, .col-lg-3, .col-lg-4, .col-lg-5, .col-lg-6, .col-lg-7, .col-lg-8, .col-lg-9, .col-lg-10, .col-lg-11, .col-lg-12, .col-lg,\n.col-lg-auto, .col-xl-1, .col-xl-2, .col-xl-3, .col-xl-4, .col-xl-5, .col-xl-6, .col-xl-7, .col-xl-8, .col-xl-9, .col-xl-10, .col-xl-11, .col-xl-12, .col-xl,\n.col-xl-auto, .col-xxl-1, .col-xxl-2, .col-xxl-3, .col-xxl-4, .col-xxl-5, .col-xxl-6, .col-xxl-7, .col-xxl-8, .col-xxl-9, .col-xxl-10, .col-xxl-11, .col-xxl-12, .col-xxl,\n.col-xxl-auto {\n  position: relative;\n  width: 100%;\n  min-height: 1px;\n  padding-right: 15px;\n  padding-left: 15px; }\n\n.col {\n  flex-basis: 0;\n  flex-grow: 1;\n  max-width: 100%; }\n\n.col-auto {\n  flex: 0 0 auto;\n  width: auto;\n  max-width: none; }\n\n.col-1 {\n  flex: 0 0 8.33333%;\n  max-width: 8.33333%; }\n\n.col-2 {\n  flex: 0 0 16.66667%;\n  max-width: 16.66667%; }\n\n.col-3 {\n  flex: 0 0 25%;\n  max-width: 25%; }\n\n.col-4 {\n  flex: 0 0 33.33333%;\n  max-width: 33.33333%; }\n\n.col-5 {\n  flex: 0 0 41.66667%;\n  max-width: 41.66667%; }\n\n.col-6 {\n  flex: 0 0 50%;\n  max-width: 50%; }\n\n.col-7 {\n  flex: 0 0 58.33333%;\n  max-width: 58.33333%; }\n\n.col-8 {\n  flex: 0 0 66.66667%;\n  max-width: 66.66667%; }\n\n.col-9 {\n  flex: 0 0 75%;\n  max-width: 75%; }\n\n.col-10 {\n  flex: 0 0 83.33333%;\n  max-width: 83.33333%; }\n\n.col-11 {\n  flex: 0 0 91.66667%;\n  max-width: 91.66667%; }\n\n.col-12 {\n  flex: 0 0 100%;\n  max-width: 100%; }\n\n.order-first {\n  order: -1; }\n\n.order-last {\n  order: 13; }\n\n.order-0 {\n  order: 0; }\n\n.order-1 {\n  order: 1; }\n\n.order-2 {\n  order: 2; }\n\n.order-3 {\n  order: 3; }\n\n.order-4 {\n  order: 4; }\n\n.order-5 {\n  order: 5; }\n\n.order-6 {\n  order: 6; }\n\n.order-7 {\n  order: 7; }\n\n.order-8 {\n  order: 8; }\n\n.order-9 {\n  order: 9; }\n\n.order-10 {\n  order: 10; }\n\n.order-11 {\n  order: 11; }\n\n.order-12 {\n  order: 12; }\n\n.offset-1 {\n  margin-left: 8.33333%; }\n\n.offset-2 {\n  margin-left: 16.66667%; }\n\n.offset-3 {\n  margin-left: 25%; }\n\n.offset-4 {\n  margin-left: 33.33333%; }\n\n.offset-5 {\n  margin-left: 41.66667%; }\n\n.offset-6 {\n  margin-left: 50%; }\n\n.offset-7 {\n  margin-left: 58.33333%; }\n\n.offset-8 {\n  margin-left: 66.66667%; }\n\n.offset-9 {\n  margin-left: 75%; }\n\n.offset-10 {\n  margin-left: 83.33333%; }\n\n.offset-11 {\n  margin-left: 91.66667%; }\n\n@media (min-width: 576px) {\n  .col-sm {\n    flex-basis: 0;\n    flex-grow: 1;\n    max-width: 100%; }\n  .col-sm-auto {\n    flex: 0 0 auto;\n    width: auto;\n    max-width: none; }\n  .col-sm-1 {\n    flex: 0 0 8.33333%;\n    max-width: 8.33333%; }\n  .col-sm-2 {\n    flex: 0 0 16.66667%;\n    max-width: 16.66667%; }\n  .col-sm-3 {\n    flex: 0 0 25%;\n    max-width: 25%; }\n  .col-sm-4 {\n    flex: 0 0 33.33333%;\n    max-width: 33.33333%; }\n  .col-sm-5 {\n    flex: 0 0 41.66667%;\n    max-width: 41.66667%; }\n  .col-sm-6 {\n    flex: 0 0 50%;\n    max-width: 50%; }\n  .col-sm-7 {\n    flex: 0 0 58.33333%;\n    max-width: 58.33333%; }\n  .col-sm-8 {\n    flex: 0 0 66.66667%;\n    max-width: 66.66667%; }\n  .col-sm-9 {\n    flex: 0 0 75%;\n    max-width: 75%; }\n  .col-sm-10 {\n    flex: 0 0 83.33333%;\n    max-width: 83.33333%; }\n  .col-sm-11 {\n    flex: 0 0 91.66667%;\n    max-width: 91.66667%; }\n  .col-sm-12 {\n    flex: 0 0 100%;\n    max-width: 100%; }\n  .order-sm-first {\n    order: -1; }\n  .order-sm-last {\n    order: 13; }\n  .order-sm-0 {\n    order: 0; }\n  .order-sm-1 {\n    order: 1; }\n  .order-sm-2 {\n    order: 2; }\n  .order-sm-3 {\n    order: 3; }\n  .order-sm-4 {\n    order: 4; }\n  .order-sm-5 {\n    order: 5; }\n  .order-sm-6 {\n    order: 6; }\n  .order-sm-7 {\n    order: 7; }\n  .order-sm-8 {\n    order: 8; }\n  .order-sm-9 {\n    order: 9; }\n  .order-sm-10 {\n    order: 10; }\n  .order-sm-11 {\n    order: 11; }\n  .order-sm-12 {\n    order: 12; }\n  .offset-sm-0 {\n    margin-left: 0; }\n  .offset-sm-1 {\n    margin-left: 8.33333%; }\n  .offset-sm-2 {\n    margin-left: 16.66667%; }\n  .offset-sm-3 {\n    margin-left: 25%; }\n  .offset-sm-4 {\n    margin-left: 33.33333%; }\n  .offset-sm-5 {\n    margin-left: 41.66667%; }\n  .offset-sm-6 {\n    margin-left: 50%; }\n  .offset-sm-7 {\n    margin-left: 58.33333%; }\n  .offset-sm-8 {\n    margin-left: 66.66667%; }\n  .offset-sm-9 {\n    margin-left: 75%; }\n  .offset-sm-10 {\n    margin-left: 83.33333%; }\n  .offset-sm-11 {\n    margin-left: 91.66667%; } }\n\n@media (min-width: 768px) {\n  .col-md {\n    flex-basis: 0;\n    flex-grow: 1;\n    max-width: 100%; }\n  .col-md-auto {\n    flex: 0 0 auto;\n    width: auto;\n    max-width: none; }\n  .col-md-1 {\n    flex: 0 0 8.33333%;\n    max-width: 8.33333%; }\n  .col-md-2 {\n    flex: 0 0 16.66667%;\n    max-width: 16.66667%; }\n  .col-md-3 {\n    flex: 0 0 25%;\n    max-width: 25%; }\n  .col-md-4 {\n    flex: 0 0 33.33333%;\n    max-width: 33.33333%; }\n  .col-md-5 {\n    flex: 0 0 41.66667%;\n    max-width: 41.66667%; }\n  .col-md-6 {\n    flex: 0 0 50%;\n    max-width: 50%; }\n  .col-md-7 {\n    flex: 0 0 58.33333%;\n    max-width: 58.33333%; }\n  .col-md-8 {\n    flex: 0 0 66.66667%;\n    max-width: 66.66667%; }\n  .col-md-9 {\n    flex: 0 0 75%;\n    max-width: 75%; }\n  .col-md-10 {\n    flex: 0 0 83.33333%;\n    max-width: 83.33333%; }\n  .col-md-11 {\n    flex: 0 0 91.66667%;\n    max-width: 91.66667%; }\n  .col-md-12 {\n    flex: 0 0 100%;\n    max-width: 100%; }\n  .order-md-first {\n    order: -1; }\n  .order-md-last {\n    order: 13; }\n  .order-md-0 {\n    order: 0; }\n  .order-md-1 {\n    order: 1; }\n  .order-md-2 {\n    order: 2; }\n  .order-md-3 {\n    order: 3; }\n  .order-md-4 {\n    order: 4; }\n  .order-md-5 {\n    order: 5; }\n  .order-md-6 {\n    order: 6; }\n  .order-md-7 {\n    order: 7; }\n  .order-md-8 {\n    order: 8; }\n  .order-md-9 {\n    order: 9; }\n  .order-md-10 {\n    order: 10; }\n  .order-md-11 {\n    order: 11; }\n  .order-md-12 {\n    order: 12; }\n  .offset-md-0 {\n    margin-left: 0; }\n  .offset-md-1 {\n    margin-left: 8.33333%; }\n  .offset-md-2 {\n    margin-left: 16.66667%; }\n  .offset-md-3 {\n    margin-left: 25%; }\n  .offset-md-4 {\n    margin-left: 33.33333%; }\n  .offset-md-5 {\n    margin-left: 41.66667%; }\n  .offset-md-6 {\n    margin-left: 50%; }\n  .offset-md-7 {\n    margin-left: 58.33333%; }\n  .offset-md-8 {\n    margin-left: 66.66667%; }\n  .offset-md-9 {\n    margin-left: 75%; }\n  .offset-md-10 {\n    margin-left: 83.33333%; }\n  .offset-md-11 {\n    margin-left: 91.66667%; } }\n\n@media (min-width: 992px) {\n  .col-lg {\n    flex-basis: 0;\n    flex-grow: 1;\n    max-width: 100%; }\n  .col-lg-auto {\n    flex: 0 0 auto;\n    width: auto;\n    max-width: none; }\n  .col-lg-1 {\n    flex: 0 0 8.33333%;\n    max-width: 8.33333%; }\n  .col-lg-2 {\n    flex: 0 0 16.66667%;\n    max-width: 16.66667%; }\n  .col-lg-3 {\n    flex: 0 0 25%;\n    max-width: 25%; }\n  .col-lg-4 {\n    flex: 0 0 33.33333%;\n    max-width: 33.33333%; }\n  .col-lg-5 {\n    flex: 0 0 41.66667%;\n    max-width: 41.66667%; }\n  .col-lg-6 {\n    flex: 0 0 50%;\n    max-width: 50%; }\n  .col-lg-7 {\n    flex: 0 0 58.33333%;\n    max-width: 58.33333%; }\n  .col-lg-8 {\n    flex: 0 0 66.66667%;\n    max-width: 66.66667%; }\n  .col-lg-9 {\n    flex: 0 0 75%;\n    max-width: 75%; }\n  .col-lg-10 {\n    flex: 0 0 83.33333%;\n    max-width: 83.33333%; }\n  .col-lg-11 {\n    flex: 0 0 91.66667%;\n    max-width: 91.66667%; }\n  .col-lg-12 {\n    flex: 0 0 100%;\n    max-width: 100%; }\n  .order-lg-first {\n    order: -1; }\n  .order-lg-last {\n    order: 13; }\n  .order-lg-0 {\n    order: 0; }\n  .order-lg-1 {\n    order: 1; }\n  .order-lg-2 {\n    order: 2; }\n  .order-lg-3 {\n    order: 3; }\n  .order-lg-4 {\n    order: 4; }\n  .order-lg-5 {\n    order: 5; }\n  .order-lg-6 {\n    order: 6; }\n  .order-lg-7 {\n    order: 7; }\n  .order-lg-8 {\n    order: 8; }\n  .order-lg-9 {\n    order: 9; }\n  .order-lg-10 {\n    order: 10; }\n  .order-lg-11 {\n    order: 11; }\n  .order-lg-12 {\n    order: 12; }\n  .offset-lg-0 {\n    margin-left: 0; }\n  .offset-lg-1 {\n    margin-left: 8.33333%; }\n  .offset-lg-2 {\n    margin-left: 16.66667%; }\n  .offset-lg-3 {\n    margin-left: 25%; }\n  .offset-lg-4 {\n    margin-left: 33.33333%; }\n  .offset-lg-5 {\n    margin-left: 41.66667%; }\n  .offset-lg-6 {\n    margin-left: 50%; }\n  .offset-lg-7 {\n    margin-left: 58.33333%; }\n  .offset-lg-8 {\n    margin-left: 66.66667%; }\n  .offset-lg-9 {\n    margin-left: 75%; }\n  .offset-lg-10 {\n    margin-left: 83.33333%; }\n  .offset-lg-11 {\n    margin-left: 91.66667%; } }\n\n@media (min-width: 1200px) {\n  .col-xl {\n    flex-basis: 0;\n    flex-grow: 1;\n    max-width: 100%; }\n  .col-xl-auto {\n    flex: 0 0 auto;\n    width: auto;\n    max-width: none; }\n  .col-xl-1 {\n    flex: 0 0 8.33333%;\n    max-width: 8.33333%; }\n  .col-xl-2 {\n    flex: 0 0 16.66667%;\n    max-width: 16.66667%; }\n  .col-xl-3 {\n    flex: 0 0 25%;\n    max-width: 25%; }\n  .col-xl-4 {\n    flex: 0 0 33.33333%;\n    max-width: 33.33333%; }\n  .col-xl-5 {\n    flex: 0 0 41.66667%;\n    max-width: 41.66667%; }\n  .col-xl-6 {\n    flex: 0 0 50%;\n    max-width: 50%; }\n  .col-xl-7 {\n    flex: 0 0 58.33333%;\n    max-width: 58.33333%; }\n  .col-xl-8 {\n    flex: 0 0 66.66667%;\n    max-width: 66.66667%; }\n  .col-xl-9 {\n    flex: 0 0 75%;\n    max-width: 75%; }\n  .col-xl-10 {\n    flex: 0 0 83.33333%;\n    max-width: 83.33333%; }\n  .col-xl-11 {\n    flex: 0 0 91.66667%;\n    max-width: 91.66667%; }\n  .col-xl-12 {\n    flex: 0 0 100%;\n    max-width: 100%; }\n  .order-xl-first {\n    order: -1; }\n  .order-xl-last {\n    order: 13; }\n  .order-xl-0 {\n    order: 0; }\n  .order-xl-1 {\n    order: 1; }\n  .order-xl-2 {\n    order: 2; }\n  .order-xl-3 {\n    order: 3; }\n  .order-xl-4 {\n    order: 4; }\n  .order-xl-5 {\n    order: 5; }\n  .order-xl-6 {\n    order: 6; }\n  .order-xl-7 {\n    order: 7; }\n  .order-xl-8 {\n    order: 8; }\n  .order-xl-9 {\n    order: 9; }\n  .order-xl-10 {\n    order: 10; }\n  .order-xl-11 {\n    order: 11; }\n  .order-xl-12 {\n    order: 12; }\n  .offset-xl-0 {\n    margin-left: 0; }\n  .offset-xl-1 {\n    margin-left: 8.33333%; }\n  .offset-xl-2 {\n    margin-left: 16.66667%; }\n  .offset-xl-3 {\n    margin-left: 25%; }\n  .offset-xl-4 {\n    margin-left: 33.33333%; }\n  .offset-xl-5 {\n    margin-left: 41.66667%; }\n  .offset-xl-6 {\n    margin-left: 50%; }\n  .offset-xl-7 {\n    margin-left: 58.33333%; }\n  .offset-xl-8 {\n    margin-left: 66.66667%; }\n  .offset-xl-9 {\n    margin-left: 75%; }\n  .offset-xl-10 {\n    margin-left: 83.33333%; }\n  .offset-xl-11 {\n    margin-left: 91.66667%; } }\n\n@media (min-width: 1440px) {\n  .col-xxl {\n    flex-basis: 0;\n    flex-grow: 1;\n    max-width: 100%; }\n  .col-xxl-auto {\n    flex: 0 0 auto;\n    width: auto;\n    max-width: none; }\n  .col-xxl-1 {\n    flex: 0 0 8.33333%;\n    max-width: 8.33333%; }\n  .col-xxl-2 {\n    flex: 0 0 16.66667%;\n    max-width: 16.66667%; }\n  .col-xxl-3 {\n    flex: 0 0 25%;\n    max-width: 25%; }\n  .col-xxl-4 {\n    flex: 0 0 33.33333%;\n    max-width: 33.33333%; }\n  .col-xxl-5 {\n    flex: 0 0 41.66667%;\n    max-width: 41.66667%; }\n  .col-xxl-6 {\n    flex: 0 0 50%;\n    max-width: 50%; }\n  .col-xxl-7 {\n    flex: 0 0 58.33333%;\n    max-width: 58.33333%; }\n  .col-xxl-8 {\n    flex: 0 0 66.66667%;\n    max-width: 66.66667%; }\n  .col-xxl-9 {\n    flex: 0 0 75%;\n    max-width: 75%; }\n  .col-xxl-10 {\n    flex: 0 0 83.33333%;\n    max-width: 83.33333%; }\n  .col-xxl-11 {\n    flex: 0 0 91.66667%;\n    max-width: 91.66667%; }\n  .col-xxl-12 {\n    flex: 0 0 100%;\n    max-width: 100%; }\n  .order-xxl-first {\n    order: -1; }\n  .order-xxl-last {\n    order: 13; }\n  .order-xxl-0 {\n    order: 0; }\n  .order-xxl-1 {\n    order: 1; }\n  .order-xxl-2 {\n    order: 2; }\n  .order-xxl-3 {\n    order: 3; }\n  .order-xxl-4 {\n    order: 4; }\n  .order-xxl-5 {\n    order: 5; }\n  .order-xxl-6 {\n    order: 6; }\n  .order-xxl-7 {\n    order: 7; }\n  .order-xxl-8 {\n    order: 8; }\n  .order-xxl-9 {\n    order: 9; }\n  .order-xxl-10 {\n    order: 10; }\n  .order-xxl-11 {\n    order: 11; }\n  .order-xxl-12 {\n    order: 12; }\n  .offset-xxl-0 {\n    margin-left: 0; }\n  .offset-xxl-1 {\n    margin-left: 8.33333%; }\n  .offset-xxl-2 {\n    margin-left: 16.66667%; }\n  .offset-xxl-3 {\n    margin-left: 25%; }\n  .offset-xxl-4 {\n    margin-left: 33.33333%; }\n  .offset-xxl-5 {\n    margin-left: 41.66667%; }\n  .offset-xxl-6 {\n    margin-left: 50%; }\n  .offset-xxl-7 {\n    margin-left: 58.33333%; }\n  .offset-xxl-8 {\n    margin-left: 66.66667%; }\n  .offset-xxl-9 {\n    margin-left: 75%; }\n  .offset-xxl-10 {\n    margin-left: 83.33333%; }\n  .offset-xxl-11 {\n    margin-left: 91.66667%; } }\n\n.table {\n  width: 100%;\n  max-width: 100%;\n  margin-bottom: 1rem;\n  background-color: transparent; }\n  .table th,\n  .table td {\n    padding: 0.75rem;\n    vertical-align: top;\n    border-top: 1px solid #dee2e6; }\n  .table thead th {\n    vertical-align: bottom;\n    border-bottom: 2px solid #dee2e6; }\n  .table tbody + tbody {\n    border-top: 2px solid #dee2e6; }\n  .table .table {\n    background-color: #fff; }\n\n.table-sm th,\n.table-sm td {\n  padding: 0.3rem; }\n\n.table-bordered {\n  border: 1px solid #dee2e6; }\n  .table-bordered th,\n  .table-bordered td {\n    border: 1px solid #dee2e6; }\n  .table-bordered thead th,\n  .table-bordered thead td {\n    border-bottom-width: 2px; }\n\n.table-striped tbody tr:nth-of-type(odd) {\n  background-color: rgba(0, 0, 0, 0.05); }\n\n.table-hover tbody tr:hover {\n  background-color: rgba(0, 0, 0, 0.075); }\n\n.table-primary,\n.table-primary > th,\n.table-primary > td {\n  background-color: #b8e8fa; }\n\n.table-hover .table-primary:hover {\n  background-color: #a0e0f8; }\n  .table-hover .table-primary:hover > td,\n  .table-hover .table-primary:hover > th {\n    background-color: #a0e0f8; }\n\n.table-secondary,\n.table-secondary > th,\n.table-secondary > td {\n  background-color: #dddfe2; }\n\n.table-hover .table-secondary:hover {\n  background-color: #cfd2d6; }\n  .table-hover .table-secondary:hover > td,\n  .table-hover .table-secondary:hover > th {\n    background-color: #cfd2d6; }\n\n.table-success,\n.table-success > th,\n.table-success > td {\n  background-color: #c3e6cb; }\n\n.table-hover .table-success:hover {\n  background-color: #b1dfbb; }\n  .table-hover .table-success:hover > td,\n  .table-hover .table-success:hover > th {\n    background-color: #b1dfbb; }\n\n.table-info,\n.table-info > th,\n.table-info > td {\n  background-color: #f3b8de; }\n\n.table-hover .table-info:hover {\n  background-color: #efa2d4; }\n  .table-hover .table-info:hover > td,\n  .table-hover .table-info:hover > th {\n    background-color: #efa2d4; }\n\n.table-warning,\n.table-warning > th,\n.table-warning > td {\n  background-color: #ffeeba; }\n\n.table-hover .table-warning:hover {\n  background-color: #ffe8a1; }\n  .table-hover .table-warning:hover > td,\n  .table-hover .table-warning:hover > th {\n    background-color: #ffe8a1; }\n\n.table-danger,\n.table-danger > th,\n.table-danger > td {\n  background-color: #f5c6cb; }\n\n.table-hover .table-danger:hover {\n  background-color: #f1b0b7; }\n  .table-hover .table-danger:hover > td,\n  .table-hover .table-danger:hover > th {\n    background-color: #f1b0b7; }\n\n.table-light,\n.table-light > th,\n.table-light > td {\n  background-color: #fdfdfe; }\n\n.table-hover .table-light:hover {\n  background-color: #ececf6; }\n  .table-hover .table-light:hover > td,\n  .table-hover .table-light:hover > th {\n    background-color: #ececf6; }\n\n.table-dark,\n.table-dark > th,\n.table-dark > td {\n  background-color: #c6c8ca; }\n\n.table-hover .table-dark:hover {\n  background-color: #b9bbbe; }\n  .table-hover .table-dark:hover > td,\n  .table-hover .table-dark:hover > th {\n    background-color: #b9bbbe; }\n\n.table-active,\n.table-active > th,\n.table-active > td {\n  background-color: rgba(0, 0, 0, 0.075); }\n\n.table-hover .table-active:hover {\n  background-color: rgba(0, 0, 0, 0.075); }\n  .table-hover .table-active:hover > td,\n  .table-hover .table-active:hover > th {\n    background-color: rgba(0, 0, 0, 0.075); }\n\n.table .thead-dark th {\n  color: #fff;\n  background-color: #212529;\n  border-color: #32383e; }\n\n.table .thead-light th {\n  color: #495057;\n  background-color: #e9ecef;\n  border-color: #dee2e6; }\n\n.table-dark {\n  color: #fff;\n  background-color: #212529; }\n  .table-dark th,\n  .table-dark td,\n  .table-dark thead th {\n    border-color: #32383e; }\n  .table-dark.table-bordered {\n    border: 0; }\n  .table-dark.table-striped tbody tr:nth-of-type(odd) {\n    background-color: rgba(255, 255, 255, 0.05); }\n  .table-dark.table-hover tbody tr:hover {\n    background-color: rgba(255, 255, 255, 0.075); }\n\n@media (max-width: 575.98px) {\n  .table-responsive-sm {\n    display: block;\n    width: 100%;\n    overflow-x: auto;\n    -webkit-overflow-scrolling: touch;\n    -ms-overflow-style: -ms-autohiding-scrollbar; }\n    .table-responsive-sm > .table-bordered {\n      border: 0; } }\n\n@media (max-width: 767.98px) {\n  .table-responsive-md {\n    display: block;\n    width: 100%;\n    overflow-x: auto;\n    -webkit-overflow-scrolling: touch;\n    -ms-overflow-style: -ms-autohiding-scrollbar; }\n    .table-responsive-md > .table-bordered {\n      border: 0; } }\n\n@media (max-width: 991.98px) {\n  .table-responsive-lg {\n    display: block;\n    width: 100%;\n    overflow-x: auto;\n    -webkit-overflow-scrolling: touch;\n    -ms-overflow-style: -ms-autohiding-scrollbar; }\n    .table-responsive-lg > .table-bordered {\n      border: 0; } }\n\n@media (max-width: 1199.98px) {\n  .table-responsive-xl {\n    display: block;\n    width: 100%;\n    overflow-x: auto;\n    -webkit-overflow-scrolling: touch;\n    -ms-overflow-style: -ms-autohiding-scrollbar; }\n    .table-responsive-xl > .table-bordered {\n      border: 0; } }\n\n@media (max-width: 1439.98px) {\n  .table-responsive-xxl {\n    display: block;\n    width: 100%;\n    overflow-x: auto;\n    -webkit-overflow-scrolling: touch;\n    -ms-overflow-style: -ms-autohiding-scrollbar; }\n    .table-responsive-xxl > .table-bordered {\n      border: 0; } }\n\n.table-responsive {\n  display: block;\n  width: 100%;\n  overflow-x: auto;\n  -webkit-overflow-scrolling: touch;\n  -ms-overflow-style: -ms-autohiding-scrollbar; }\n  .table-responsive > .table-bordered {\n    border: 0; }\n\n.form-control {\n  display: block;\n  width: 100%;\n  padding: 0.5rem 1rem;\n  font-size: 1rem;\n  line-height: 1.5;\n  color: #495057;\n  background-color: #f8f8f8;\n  background-clip: padding-box;\n  border: 1px solid #ced4da;\n  border-radius: 0.1875rem;\n  transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out; }\n  .form-control::-ms-expand {\n    background-color: transparent;\n    border: 0; }\n  .form-control:focus {\n    color: #495057;\n    background-color: #f8f8f8;\n    border-color: #00acec;\n    outline: 0;\n    box-shadow: 0 0 0 0; }\n  .form-control::placeholder {\n    color: #868e96;\n    opacity: 1; }\n  .form-control:disabled, .form-control[readonly] {\n    background-color: #e9ecef;\n    opacity: 1; }\n\nselect.form-control:not([size]):not([multiple]) {\n  height: calc(2.5rem + 2px); }\n\nselect.form-control:focus::-ms-value {\n  color: #495057;\n  background-color: #f8f8f8; }\n\n.form-control-file,\n.form-control-range {\n  display: block;\n  width: 100%; }\n\n.col-form-label {\n  padding-top: calc(0.5rem + 1px);\n  padding-bottom: calc(0.5rem + 1px);\n  margin-bottom: 0;\n  font-size: inherit;\n  line-height: 1.5; }\n\n.col-form-label-lg {\n  padding-top: calc(0.5rem + 1px);\n  padding-bottom: calc(0.5rem + 1px);\n  font-size: 1rem;\n  line-height: 1.5; }\n\n.col-form-label-sm {\n  padding-top: calc(0.375rem + 1px);\n  padding-bottom: calc(0.375rem + 1px);\n  font-size: 0.75rem;\n  line-height: 1.25; }\n\n.form-control-plaintext {\n  display: block;\n  width: 100%;\n  padding-top: 0.5rem;\n  padding-bottom: 0.5rem;\n  margin-bottom: 0;\n  line-height: 1.5;\n  background-color: transparent;\n  border: solid transparent;\n  border-width: 1px 0; }\n  .form-control-plaintext.form-control-sm, .input-group-sm > .form-control-plaintext.form-control,\n  .input-group-sm > .input-group-prepend > .form-control-plaintext.input-group-text,\n  .input-group-sm > .input-group-append > .form-control-plaintext.input-group-text,\n  .input-group-sm > .input-group-prepend > .form-control-plaintext.btn,\n  .input-group-sm > .input-group-append > .form-control-plaintext.btn, .form-control-plaintext.form-control-lg, .input-group-lg > .form-control-plaintext.form-control,\n  .input-group-lg > .input-group-prepend > .form-control-plaintext.input-group-text,\n  .input-group-lg > .input-group-append > .form-control-plaintext.input-group-text,\n  .input-group-lg > .input-group-prepend > .form-control-plaintext.btn,\n  .input-group-lg > .input-group-append > .form-control-plaintext.btn {\n    padding-right: 0;\n    padding-left: 0; }\n\n.form-control-sm, .input-group-sm > .form-control,\n.input-group-sm > .input-group-prepend > .input-group-text,\n.input-group-sm > .input-group-append > .input-group-text,\n.input-group-sm > .input-group-prepend > .btn,\n.input-group-sm > .input-group-append > .btn {\n  padding: 0.375rem 0.75rem;\n  font-size: 0.75rem;\n  line-height: 1.25;\n  border-radius: 0.2rem; }\n\nselect.form-control-sm:not([size]):not([multiple]), .input-group-sm > select.form-control:not([size]):not([multiple]),\n.input-group-sm > .input-group-prepend > select.input-group-text:not([size]):not([multiple]),\n.input-group-sm > .input-group-append > select.input-group-text:not([size]):not([multiple]),\n.input-group-sm > .input-group-prepend > select.btn:not([size]):not([multiple]),\n.input-group-sm > .input-group-append > select.btn:not([size]):not([multiple]) {\n  height: calc(1.6875rem + 2px); }\n\n.form-control-lg, .input-group-lg > .form-control,\n.input-group-lg > .input-group-prepend > .input-group-text,\n.input-group-lg > .input-group-append > .input-group-text,\n.input-group-lg > .input-group-prepend > .btn,\n.input-group-lg > .input-group-append > .btn {\n  padding: 0.5rem 1rem;\n  font-size: 1rem;\n  line-height: 1.5;\n  border-radius: 0.3rem; }\n\nselect.form-control-lg:not([size]):not([multiple]), .input-group-lg > select.form-control:not([size]):not([multiple]),\n.input-group-lg > .input-group-prepend > select.input-group-text:not([size]):not([multiple]),\n.input-group-lg > .input-group-append > select.input-group-text:not([size]):not([multiple]),\n.input-group-lg > .input-group-prepend > select.btn:not([size]):not([multiple]),\n.input-group-lg > .input-group-append > select.btn:not([size]):not([multiple]) {\n  height: calc(2.5rem + 2px); }\n\n.form-group {\n  margin-bottom: 1rem; }\n\n.form-text {\n  display: block;\n  margin-top: 0.25rem; }\n\n.form-row {\n  display: flex;\n  flex-wrap: wrap;\n  margin-right: -5px;\n  margin-left: -5px; }\n  .form-row > .col,\n  .form-row > [class*=\"col-\"] {\n    padding-right: 5px;\n    padding-left: 5px; }\n\n.form-check {\n  position: relative;\n  display: block;\n  padding-left: 1.25rem; }\n\n.form-check-input {\n  position: absolute;\n  margin-top: 0.3rem;\n  margin-left: -1.25rem; }\n  .form-check-input:disabled ~ .form-check-label {\n    color: #868e96; }\n\n.form-check-label {\n  margin-bottom: 0; }\n\n.form-check-inline {\n  display: inline-flex;\n  align-items: center;\n  padding-left: 0;\n  margin-right: 0.75rem; }\n  .form-check-inline .form-check-input {\n    position: static;\n    margin-top: 0;\n    margin-right: 0.3125rem;\n    margin-left: 0; }\n\n.valid-feedback {\n  display: none;\n  width: 100%;\n  margin-top: 0.25rem;\n  font-size: 80%;\n  color: #28a745; }\n\n.valid-tooltip {\n  position: absolute;\n  top: 100%;\n  z-index: 5;\n  display: none;\n  max-width: 100%;\n  padding: .5rem;\n  margin-top: .1rem;\n  font-size: .875rem;\n  line-height: 1;\n  color: #fff;\n  background-color: rgba(40, 167, 69, 0.8);\n  border-radius: .2rem; }\n\n.was-validated .form-control:valid, .form-control.is-valid, .was-validated\n.custom-select:valid,\n.custom-select.is-valid {\n  border-color: #28a745; }\n  .was-validated .form-control:valid:focus, .form-control.is-valid:focus, .was-validated\n  .custom-select:valid:focus,\n  .custom-select.is-valid:focus {\n    border-color: #28a745;\n    box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25); }\n  .was-validated .form-control:valid ~ .valid-feedback,\n  .was-validated .form-control:valid ~ .valid-tooltip, .form-control.is-valid ~ .valid-feedback,\n  .form-control.is-valid ~ .valid-tooltip, .was-validated\n  .custom-select:valid ~ .valid-feedback,\n  .was-validated\n  .custom-select:valid ~ .valid-tooltip,\n  .custom-select.is-valid ~ .valid-feedback,\n  .custom-select.is-valid ~ .valid-tooltip {\n    display: block; }\n\n.was-validated .form-check-input:valid ~ .form-check-label, .form-check-input.is-valid ~ .form-check-label {\n  color: #28a745; }\n\n.was-validated .form-check-input:valid ~ .valid-feedback,\n.was-validated .form-check-input:valid ~ .valid-tooltip, .form-check-input.is-valid ~ .valid-feedback,\n.form-check-input.is-valid ~ .valid-tooltip {\n  display: block; }\n\n.was-validated .custom-control-input:valid ~ .custom-control-label, .custom-control-input.is-valid ~ .custom-control-label {\n  color: #28a745; }\n  .was-validated .custom-control-input:valid ~ .custom-control-label::before, .custom-control-input.is-valid ~ .custom-control-label::before {\n    background-color: #71dd8a; }\n\n.was-validated .custom-control-input:valid ~ .valid-feedback,\n.was-validated .custom-control-input:valid ~ .valid-tooltip, .custom-control-input.is-valid ~ .valid-feedback,\n.custom-control-input.is-valid ~ .valid-tooltip {\n  display: block; }\n\n.was-validated .custom-control-input:valid:checked ~ .custom-control-label::before, .custom-control-input.is-valid:checked ~ .custom-control-label::before {\n  background-color: #34ce57; }\n\n.was-validated .custom-control-input:valid:focus ~ .custom-control-label::before, .custom-control-input.is-valid:focus ~ .custom-control-label::before {\n  box-shadow: 0 0 0 1px #fff, 0 0 0 0.2rem rgba(40, 167, 69, 0.25); }\n\n.was-validated .custom-file-input:valid ~ .custom-file-label, .custom-file-input.is-valid ~ .custom-file-label {\n  border-color: #28a745; }\n  .was-validated .custom-file-input:valid ~ .custom-file-label::before, .custom-file-input.is-valid ~ .custom-file-label::before {\n    border-color: inherit; }\n\n.was-validated .custom-file-input:valid ~ .valid-feedback,\n.was-validated .custom-file-input:valid ~ .valid-tooltip, .custom-file-input.is-valid ~ .valid-feedback,\n.custom-file-input.is-valid ~ .valid-tooltip {\n  display: block; }\n\n.was-validated .custom-file-input:valid:focus ~ .custom-file-label, .custom-file-input.is-valid:focus ~ .custom-file-label {\n  box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25); }\n\n.invalid-feedback {\n  display: none;\n  width: 100%;\n  margin-top: 0.25rem;\n  font-size: 80%;\n  color: #dc3545; }\n\n.invalid-tooltip {\n  position: absolute;\n  top: 100%;\n  z-index: 5;\n  display: none;\n  max-width: 100%;\n  padding: .5rem;\n  margin-top: .1rem;\n  font-size: .875rem;\n  line-height: 1;\n  color: #fff;\n  background-color: rgba(220, 53, 69, 0.8);\n  border-radius: .2rem; }\n\n.was-validated .form-control:invalid, .form-control.is-invalid, .was-validated\n.custom-select:invalid,\n.custom-select.is-invalid {\n  border-color: #dc3545; }\n  .was-validated .form-control:invalid:focus, .form-control.is-invalid:focus, .was-validated\n  .custom-select:invalid:focus,\n  .custom-select.is-invalid:focus {\n    border-color: #dc3545;\n    box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25); }\n  .was-validated .form-control:invalid ~ .invalid-feedback,\n  .was-validated .form-control:invalid ~ .invalid-tooltip, .form-control.is-invalid ~ .invalid-feedback,\n  .form-control.is-invalid ~ .invalid-tooltip, .was-validated\n  .custom-select:invalid ~ .invalid-feedback,\n  .was-validated\n  .custom-select:invalid ~ .invalid-tooltip,\n  .custom-select.is-invalid ~ .invalid-feedback,\n  .custom-select.is-invalid ~ .invalid-tooltip {\n    display: block; }\n\n.was-validated .form-check-input:invalid ~ .form-check-label, .form-check-input.is-invalid ~ .form-check-label {\n  color: #dc3545; }\n\n.was-validated .form-check-input:invalid ~ .invalid-feedback,\n.was-validated .form-check-input:invalid ~ .invalid-tooltip, .form-check-input.is-invalid ~ .invalid-feedback,\n.form-check-input.is-invalid ~ .invalid-tooltip {\n  display: block; }\n\n.was-validated .custom-control-input:invalid ~ .custom-control-label, .custom-control-input.is-invalid ~ .custom-control-label {\n  color: #dc3545; }\n  .was-validated .custom-control-input:invalid ~ .custom-control-label::before, .custom-control-input.is-invalid ~ .custom-control-label::before {\n    background-color: #efa2a9; }\n\n.was-validated .custom-control-input:invalid ~ .invalid-feedback,\n.was-validated .custom-control-input:invalid ~ .invalid-tooltip, .custom-control-input.is-invalid ~ .invalid-feedback,\n.custom-control-input.is-invalid ~ .invalid-tooltip {\n  display: block; }\n\n.was-validated .custom-control-input:invalid:checked ~ .custom-control-label::before, .custom-control-input.is-invalid:checked ~ .custom-control-label::before {\n  background-color: #e4606d; }\n\n.was-validated .custom-control-input:invalid:focus ~ .custom-control-label::before, .custom-control-input.is-invalid:focus ~ .custom-control-label::before {\n  box-shadow: 0 0 0 1px #fff, 0 0 0 0.2rem rgba(220, 53, 69, 0.25); }\n\n.was-validated .custom-file-input:invalid ~ .custom-file-label, .custom-file-input.is-invalid ~ .custom-file-label {\n  border-color: #dc3545; }\n  .was-validated .custom-file-input:invalid ~ .custom-file-label::before, .custom-file-input.is-invalid ~ .custom-file-label::before {\n    border-color: inherit; }\n\n.was-validated .custom-file-input:invalid ~ .invalid-feedback,\n.was-validated .custom-file-input:invalid ~ .invalid-tooltip, .custom-file-input.is-invalid ~ .invalid-feedback,\n.custom-file-input.is-invalid ~ .invalid-tooltip {\n  display: block; }\n\n.was-validated .custom-file-input:invalid:focus ~ .custom-file-label, .custom-file-input.is-invalid:focus ~ .custom-file-label {\n  box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25); }\n\n.form-inline {\n  display: flex;\n  flex-flow: row wrap;\n  align-items: center; }\n  .form-inline .form-check {\n    width: 100%; }\n  @media (min-width: 576px) {\n    .form-inline label {\n      display: flex;\n      align-items: center;\n      justify-content: center;\n      margin-bottom: 0; }\n    .form-inline .form-group {\n      display: flex;\n      flex: 0 0 auto;\n      flex-flow: row wrap;\n      align-items: center;\n      margin-bottom: 0; }\n    .form-inline .form-control {\n      display: inline-block;\n      width: auto;\n      vertical-align: middle; }\n    .form-inline .form-control-plaintext {\n      display: inline-block; }\n    .form-inline .input-group {\n      width: auto; }\n    .form-inline .form-check {\n      display: flex;\n      align-items: center;\n      justify-content: center;\n      width: auto;\n      padding-left: 0; }\n    .form-inline .form-check-input {\n      position: relative;\n      margin-top: 0;\n      margin-right: 0.25rem;\n      margin-left: 0; }\n    .form-inline .custom-control {\n      align-items: center;\n      justify-content: center; }\n    .form-inline .custom-control-label {\n      margin-bottom: 0; } }\n\n.btn {\n  display: inline-block;\n  font-weight: 500;\n  text-align: center;\n  white-space: nowrap;\n  vertical-align: middle;\n  user-select: none;\n  border: 1px solid transparent;\n  padding: 0.5rem 1rem;\n  font-size: 1rem;\n  line-height: 1.5;\n  border-radius: 0.1875rem;\n  transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out; }\n  .btn:hover, .btn:focus {\n    text-decoration: none; }\n  .btn:focus, .btn.focus {\n    outline: 0;\n    box-shadow: 0 0 0 0; }\n  .btn.disabled, .btn:disabled {\n    opacity: 0.65; }\n  .btn:not(:disabled):not(.disabled) {\n    cursor: pointer; }\n  .btn:not(:disabled):not(.disabled):active, .btn:not(:disabled):not(.disabled).active {\n    background-image: none; }\n\na.btn.disabled,\nfieldset:disabled a.btn {\n  pointer-events: none; }\n\n.btn-primary {\n  color: #fff;\n  background-color: #00acec;\n  border-color: #00acec; }\n  .btn-primary:hover {\n    color: #fff;\n    background-color: #0090c6;\n    border-color: #0087b9; }\n  .btn-primary:focus, .btn-primary.focus {\n    box-shadow: 0 0 0 0.2rem rgba(0, 172, 236, 0.5); }\n  .btn-primary.disabled, .btn-primary:disabled {\n    color: #fff;\n    background-color: #00acec;\n    border-color: #00acec; }\n  .btn-primary:not(:disabled):not(.disabled):active, .btn-primary:not(:disabled):not(.disabled).active,\n  .show > .btn-primary.dropdown-toggle {\n    color: #fff;\n    background-color: #0087b9;\n    border-color: #007eac; }\n    .btn-primary:not(:disabled):not(.disabled):active:focus, .btn-primary:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-primary.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(0, 172, 236, 0.5); }\n\n.btn-secondary {\n  color: #fff;\n  background-color: #868e96;\n  border-color: #868e96; }\n  .btn-secondary:hover {\n    color: #fff;\n    background-color: #727b84;\n    border-color: #6c757d; }\n  .btn-secondary:focus, .btn-secondary.focus {\n    box-shadow: 0 0 0 0.2rem rgba(134, 142, 150, 0.5); }\n  .btn-secondary.disabled, .btn-secondary:disabled {\n    color: #fff;\n    background-color: #868e96;\n    border-color: #868e96; }\n  .btn-secondary:not(:disabled):not(.disabled):active, .btn-secondary:not(:disabled):not(.disabled).active,\n  .show > .btn-secondary.dropdown-toggle {\n    color: #fff;\n    background-color: #6c757d;\n    border-color: #666e76; }\n    .btn-secondary:not(:disabled):not(.disabled):active:focus, .btn-secondary:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-secondary.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(134, 142, 150, 0.5); }\n\n.btn-success {\n  color: #fff;\n  background-color: #28a745;\n  border-color: #28a745; }\n  .btn-success:hover {\n    color: #fff;\n    background-color: #218838;\n    border-color: #1e7e34; }\n  .btn-success:focus, .btn-success.focus {\n    box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.5); }\n  .btn-success.disabled, .btn-success:disabled {\n    color: #fff;\n    background-color: #28a745;\n    border-color: #28a745; }\n  .btn-success:not(:disabled):not(.disabled):active, .btn-success:not(:disabled):not(.disabled).active,\n  .show > .btn-success.dropdown-toggle {\n    color: #fff;\n    background-color: #1e7e34;\n    border-color: #1c7430; }\n    .btn-success:not(:disabled):not(.disabled):active:focus, .btn-success:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-success.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.5); }\n\n.btn-info {\n  color: #fff;\n  background-color: #d50089;\n  border-color: #d50089; }\n  .btn-info:hover {\n    color: #fff;\n    background-color: #af0070;\n    border-color: #a20068; }\n  .btn-info:focus, .btn-info.focus {\n    box-shadow: 0 0 0 0.2rem rgba(213, 0, 137, 0.5); }\n  .btn-info.disabled, .btn-info:disabled {\n    color: #fff;\n    background-color: #d50089;\n    border-color: #d50089; }\n  .btn-info:not(:disabled):not(.disabled):active, .btn-info:not(:disabled):not(.disabled).active,\n  .show > .btn-info.dropdown-toggle {\n    color: #fff;\n    background-color: #a20068;\n    border-color: #950060; }\n    .btn-info:not(:disabled):not(.disabled):active:focus, .btn-info:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-info.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(213, 0, 137, 0.5); }\n\n.btn-warning {\n  color: #212529;\n  background-color: #ffc107;\n  border-color: #ffc107; }\n  .btn-warning:hover {\n    color: #212529;\n    background-color: #e0a800;\n    border-color: #d39e00; }\n  .btn-warning:focus, .btn-warning.focus {\n    box-shadow: 0 0 0 0.2rem rgba(255, 193, 7, 0.5); }\n  .btn-warning.disabled, .btn-warning:disabled {\n    color: #212529;\n    background-color: #ffc107;\n    border-color: #ffc107; }\n  .btn-warning:not(:disabled):not(.disabled):active, .btn-warning:not(:disabled):not(.disabled).active,\n  .show > .btn-warning.dropdown-toggle {\n    color: #212529;\n    background-color: #d39e00;\n    border-color: #c69500; }\n    .btn-warning:not(:disabled):not(.disabled):active:focus, .btn-warning:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-warning.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(255, 193, 7, 0.5); }\n\n.btn-danger {\n  color: #fff;\n  background-color: #dc3545;\n  border-color: #dc3545; }\n  .btn-danger:hover {\n    color: #fff;\n    background-color: #c82333;\n    border-color: #bd2130; }\n  .btn-danger:focus, .btn-danger.focus {\n    box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.5); }\n  .btn-danger.disabled, .btn-danger:disabled {\n    color: #fff;\n    background-color: #dc3545;\n    border-color: #dc3545; }\n  .btn-danger:not(:disabled):not(.disabled):active, .btn-danger:not(:disabled):not(.disabled).active,\n  .show > .btn-danger.dropdown-toggle {\n    color: #fff;\n    background-color: #bd2130;\n    border-color: #b21f2d; }\n    .btn-danger:not(:disabled):not(.disabled):active:focus, .btn-danger:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-danger.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.5); }\n\n.btn-light {\n  color: #212529;\n  background-color: #f8f9fa;\n  border-color: #f8f9fa; }\n  .btn-light:hover {\n    color: #212529;\n    background-color: #e2e6ea;\n    border-color: #dae0e5; }\n  .btn-light:focus, .btn-light.focus {\n    box-shadow: 0 0 0 0.2rem rgba(248, 249, 250, 0.5); }\n  .btn-light.disabled, .btn-light:disabled {\n    color: #212529;\n    background-color: #f8f9fa;\n    border-color: #f8f9fa; }\n  .btn-light:not(:disabled):not(.disabled):active, .btn-light:not(:disabled):not(.disabled).active,\n  .show > .btn-light.dropdown-toggle {\n    color: #212529;\n    background-color: #dae0e5;\n    border-color: #d3d9df; }\n    .btn-light:not(:disabled):not(.disabled):active:focus, .btn-light:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-light.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(248, 249, 250, 0.5); }\n\n.btn-dark {\n  color: #fff;\n  background-color: #343a40;\n  border-color: #343a40; }\n  .btn-dark:hover {\n    color: #fff;\n    background-color: #23272b;\n    border-color: #1d2124; }\n  .btn-dark:focus, .btn-dark.focus {\n    box-shadow: 0 0 0 0.2rem rgba(52, 58, 64, 0.5); }\n  .btn-dark.disabled, .btn-dark:disabled {\n    color: #fff;\n    background-color: #343a40;\n    border-color: #343a40; }\n  .btn-dark:not(:disabled):not(.disabled):active, .btn-dark:not(:disabled):not(.disabled).active,\n  .show > .btn-dark.dropdown-toggle {\n    color: #fff;\n    background-color: #1d2124;\n    border-color: #171a1d; }\n    .btn-dark:not(:disabled):not(.disabled):active:focus, .btn-dark:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-dark.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(52, 58, 64, 0.5); }\n\n.btn-outline-primary {\n  color: #00acec;\n  background-color: transparent;\n  background-image: none;\n  border-color: #00acec; }\n  .btn-outline-primary:hover {\n    color: #fff;\n    background-color: #00acec;\n    border-color: #00acec; }\n  .btn-outline-primary:focus, .btn-outline-primary.focus {\n    box-shadow: 0 0 0 0.2rem rgba(0, 172, 236, 0.5); }\n  .btn-outline-primary.disabled, .btn-outline-primary:disabled {\n    color: #00acec;\n    background-color: transparent; }\n  .btn-outline-primary:not(:disabled):not(.disabled):active, .btn-outline-primary:not(:disabled):not(.disabled).active,\n  .show > .btn-outline-primary.dropdown-toggle {\n    color: #fff;\n    background-color: #00acec;\n    border-color: #00acec; }\n    .btn-outline-primary:not(:disabled):not(.disabled):active:focus, .btn-outline-primary:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-outline-primary.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(0, 172, 236, 0.5); }\n\n.btn-outline-secondary {\n  color: #868e96;\n  background-color: transparent;\n  background-image: none;\n  border-color: #868e96; }\n  .btn-outline-secondary:hover {\n    color: #fff;\n    background-color: #868e96;\n    border-color: #868e96; }\n  .btn-outline-secondary:focus, .btn-outline-secondary.focus {\n    box-shadow: 0 0 0 0.2rem rgba(134, 142, 150, 0.5); }\n  .btn-outline-secondary.disabled, .btn-outline-secondary:disabled {\n    color: #868e96;\n    background-color: transparent; }\n  .btn-outline-secondary:not(:disabled):not(.disabled):active, .btn-outline-secondary:not(:disabled):not(.disabled).active,\n  .show > .btn-outline-secondary.dropdown-toggle {\n    color: #fff;\n    background-color: #868e96;\n    border-color: #868e96; }\n    .btn-outline-secondary:not(:disabled):not(.disabled):active:focus, .btn-outline-secondary:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-outline-secondary.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(134, 142, 150, 0.5); }\n\n.btn-outline-success {\n  color: #28a745;\n  background-color: transparent;\n  background-image: none;\n  border-color: #28a745; }\n  .btn-outline-success:hover {\n    color: #fff;\n    background-color: #28a745;\n    border-color: #28a745; }\n  .btn-outline-success:focus, .btn-outline-success.focus {\n    box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.5); }\n  .btn-outline-success.disabled, .btn-outline-success:disabled {\n    color: #28a745;\n    background-color: transparent; }\n  .btn-outline-success:not(:disabled):not(.disabled):active, .btn-outline-success:not(:disabled):not(.disabled).active,\n  .show > .btn-outline-success.dropdown-toggle {\n    color: #fff;\n    background-color: #28a745;\n    border-color: #28a745; }\n    .btn-outline-success:not(:disabled):not(.disabled):active:focus, .btn-outline-success:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-outline-success.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.5); }\n\n.btn-outline-info {\n  color: #d50089;\n  background-color: transparent;\n  background-image: none;\n  border-color: #d50089; }\n  .btn-outline-info:hover {\n    color: #fff;\n    background-color: #d50089;\n    border-color: #d50089; }\n  .btn-outline-info:focus, .btn-outline-info.focus {\n    box-shadow: 0 0 0 0.2rem rgba(213, 0, 137, 0.5); }\n  .btn-outline-info.disabled, .btn-outline-info:disabled {\n    color: #d50089;\n    background-color: transparent; }\n  .btn-outline-info:not(:disabled):not(.disabled):active, .btn-outline-info:not(:disabled):not(.disabled).active,\n  .show > .btn-outline-info.dropdown-toggle {\n    color: #fff;\n    background-color: #d50089;\n    border-color: #d50089; }\n    .btn-outline-info:not(:disabled):not(.disabled):active:focus, .btn-outline-info:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-outline-info.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(213, 0, 137, 0.5); }\n\n.btn-outline-warning {\n  color: #ffc107;\n  background-color: transparent;\n  background-image: none;\n  border-color: #ffc107; }\n  .btn-outline-warning:hover {\n    color: #212529;\n    background-color: #ffc107;\n    border-color: #ffc107; }\n  .btn-outline-warning:focus, .btn-outline-warning.focus {\n    box-shadow: 0 0 0 0.2rem rgba(255, 193, 7, 0.5); }\n  .btn-outline-warning.disabled, .btn-outline-warning:disabled {\n    color: #ffc107;\n    background-color: transparent; }\n  .btn-outline-warning:not(:disabled):not(.disabled):active, .btn-outline-warning:not(:disabled):not(.disabled).active,\n  .show > .btn-outline-warning.dropdown-toggle {\n    color: #212529;\n    background-color: #ffc107;\n    border-color: #ffc107; }\n    .btn-outline-warning:not(:disabled):not(.disabled):active:focus, .btn-outline-warning:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-outline-warning.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(255, 193, 7, 0.5); }\n\n.btn-outline-danger {\n  color: #dc3545;\n  background-color: transparent;\n  background-image: none;\n  border-color: #dc3545; }\n  .btn-outline-danger:hover {\n    color: #fff;\n    background-color: #dc3545;\n    border-color: #dc3545; }\n  .btn-outline-danger:focus, .btn-outline-danger.focus {\n    box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.5); }\n  .btn-outline-danger.disabled, .btn-outline-danger:disabled {\n    color: #dc3545;\n    background-color: transparent; }\n  .btn-outline-danger:not(:disabled):not(.disabled):active, .btn-outline-danger:not(:disabled):not(.disabled).active,\n  .show > .btn-outline-danger.dropdown-toggle {\n    color: #fff;\n    background-color: #dc3545;\n    border-color: #dc3545; }\n    .btn-outline-danger:not(:disabled):not(.disabled):active:focus, .btn-outline-danger:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-outline-danger.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.5); }\n\n.btn-outline-light {\n  color: #f8f9fa;\n  background-color: transparent;\n  background-image: none;\n  border-color: #f8f9fa; }\n  .btn-outline-light:hover {\n    color: #212529;\n    background-color: #f8f9fa;\n    border-color: #f8f9fa; }\n  .btn-outline-light:focus, .btn-outline-light.focus {\n    box-shadow: 0 0 0 0.2rem rgba(248, 249, 250, 0.5); }\n  .btn-outline-light.disabled, .btn-outline-light:disabled {\n    color: #f8f9fa;\n    background-color: transparent; }\n  .btn-outline-light:not(:disabled):not(.disabled):active, .btn-outline-light:not(:disabled):not(.disabled).active,\n  .show > .btn-outline-light.dropdown-toggle {\n    color: #212529;\n    background-color: #f8f9fa;\n    border-color: #f8f9fa; }\n    .btn-outline-light:not(:disabled):not(.disabled):active:focus, .btn-outline-light:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-outline-light.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(248, 249, 250, 0.5); }\n\n.btn-outline-dark {\n  color: #343a40;\n  background-color: transparent;\n  background-image: none;\n  border-color: #343a40; }\n  .btn-outline-dark:hover {\n    color: #fff;\n    background-color: #343a40;\n    border-color: #343a40; }\n  .btn-outline-dark:focus, .btn-outline-dark.focus {\n    box-shadow: 0 0 0 0.2rem rgba(52, 58, 64, 0.5); }\n  .btn-outline-dark.disabled, .btn-outline-dark:disabled {\n    color: #343a40;\n    background-color: transparent; }\n  .btn-outline-dark:not(:disabled):not(.disabled):active, .btn-outline-dark:not(:disabled):not(.disabled).active,\n  .show > .btn-outline-dark.dropdown-toggle {\n    color: #fff;\n    background-color: #343a40;\n    border-color: #343a40; }\n    .btn-outline-dark:not(:disabled):not(.disabled):active:focus, .btn-outline-dark:not(:disabled):not(.disabled).active:focus,\n    .show > .btn-outline-dark.dropdown-toggle:focus {\n      box-shadow: 0 0 0 0.2rem rgba(52, 58, 64, 0.5); }\n\n.btn-link {\n  font-weight: 400;\n  color: #00acec;\n  background-color: transparent; }\n  .btn-link:hover {\n    color: #0074a0;\n    text-decoration: underline;\n    background-color: transparent;\n    border-color: transparent; }\n  .btn-link:focus, .btn-link.focus {\n    text-decoration: underline;\n    border-color: transparent;\n    box-shadow: none; }\n  .btn-link:disabled, .btn-link.disabled {\n    color: #868e96; }\n\n.btn-lg, .btn-group-lg > .btn {\n  padding: 0.5rem 1rem;\n  font-size: 1rem;\n  line-height: 1.5;\n  border-radius: 0.3rem; }\n\n.btn-sm, .btn-group-sm > .btn {\n  padding: 0.375rem 0.75rem;\n  font-size: 0.75rem;\n  line-height: 1.25;\n  border-radius: 0.125rem; }\n\n.btn-block {\n  display: block;\n  width: 100%; }\n  .btn-block + .btn-block {\n    margin-top: 0.625rem; }\n\ninput[type=\"submit\"].btn-block,\ninput[type=\"reset\"].btn-block,\ninput[type=\"button\"].btn-block {\n  width: 100%; }\n\n.fade {\n  opacity: 0;\n  transition: opacity 0.15s linear; }\n  .fade.show {\n    opacity: 1; }\n\n.collapse {\n  display: none; }\n  .collapse.show {\n    display: block; }\n\ntr.collapse.show {\n  display: table-row; }\n\ntbody.collapse.show {\n  display: table-row-group; }\n\n.collapsing {\n  position: relative;\n  height: 0;\n  overflow: hidden;\n  transition: height 0.35s ease; }\n\n.dropup,\n.dropdown {\n  position: relative; }\n\n.dropdown-toggle::after {\n  display: inline-block;\n  width: 0;\n  height: 0;\n  margin-left: 0.255em;\n  vertical-align: 0.255em;\n  content: \"\";\n  border-top: 0.3em solid;\n  border-right: 0.3em solid transparent;\n  border-bottom: 0;\n  border-left: 0.3em solid transparent; }\n\n.dropdown-toggle:empty::after {\n  margin-left: 0; }\n\n.dropdown-menu {\n  position: absolute;\n  top: 100%;\n  left: 0;\n  z-index: 1000;\n  display: none;\n  float: left;\n  min-width: 12rem;\n  padding: 0 0;\n  margin: 0.125rem 0 0;\n  font-size: 1rem;\n  color: #212529;\n  text-align: left;\n  list-style: none;\n  background-color: #fff;\n  background-clip: padding-box;\n  border: 0 solid rgba(0, 0, 0, 0.15);\n  border-radius: 0.1875rem; }\n\n.dropup .dropdown-menu {\n  margin-top: 0;\n  margin-bottom: 0.125rem; }\n\n.dropup .dropdown-toggle::after {\n  display: inline-block;\n  width: 0;\n  height: 0;\n  margin-left: 0.255em;\n  vertical-align: 0.255em;\n  content: \"\";\n  border-top: 0;\n  border-right: 0.3em solid transparent;\n  border-bottom: 0.3em solid;\n  border-left: 0.3em solid transparent; }\n\n.dropup .dropdown-toggle:empty::after {\n  margin-left: 0; }\n\n.dropright .dropdown-menu {\n  margin-top: 0;\n  margin-left: 0.125rem; }\n\n.dropright .dropdown-toggle::after {\n  display: inline-block;\n  width: 0;\n  height: 0;\n  margin-left: 0.255em;\n  vertical-align: 0.255em;\n  content: \"\";\n  border-top: 0.3em solid transparent;\n  border-bottom: 0.3em solid transparent;\n  border-left: 0.3em solid; }\n\n.dropright .dropdown-toggle:empty::after {\n  margin-left: 0; }\n\n.dropright .dropdown-toggle::after {\n  vertical-align: 0; }\n\n.dropleft .dropdown-menu {\n  margin-top: 0;\n  margin-right: 0.125rem; }\n\n.dropleft .dropdown-toggle::after {\n  display: inline-block;\n  width: 0;\n  height: 0;\n  margin-left: 0.255em;\n  vertical-align: 0.255em;\n  content: \"\"; }\n\n.dropleft .dropdown-toggle::after {\n  display: none; }\n\n.dropleft .dropdown-toggle::before {\n  display: inline-block;\n  width: 0;\n  height: 0;\n  margin-right: 0.255em;\n  vertical-align: 0.255em;\n  content: \"\";\n  border-top: 0.3em solid transparent;\n  border-right: 0.3em solid;\n  border-bottom: 0.3em solid transparent; }\n\n.dropleft .dropdown-toggle:empty::after {\n  margin-left: 0; }\n\n.dropleft .dropdown-toggle::before {\n  vertical-align: 0; }\n\n.dropdown-divider {\n  height: 0;\n  margin: 0.5rem 0;\n  overflow: hidden;\n  border-top: 1px solid #e9ecef; }\n\n.dropdown-item {\n  display: block;\n  width: 100%;\n  padding: 1rem 1rem;\n  clear: both;\n  font-weight: 400;\n  color: #212529;\n  text-align: inherit;\n  white-space: nowrap;\n  background-color: transparent;\n  border: 0; }\n  .dropdown-item:hover, .dropdown-item:focus {\n    color: #16181b;\n    text-decoration: none;\n    background-color: #eff4f6; }\n  .dropdown-item.active, .dropdown-item:active {\n    color: #fff;\n    text-decoration: none;\n    background-color: #00acec; }\n  .dropdown-item.disabled, .dropdown-item:disabled {\n    color: #868e96;\n    background-color: transparent; }\n\n.dropdown-menu.show {\n  display: block; }\n\n.dropdown-header {\n  display: block;\n  padding: 0 1rem;\n  margin-bottom: 0;\n  font-size: 0.75rem;\n  color: #868e96;\n  white-space: nowrap; }\n\n.btn-group,\n.btn-group-vertical {\n  position: relative;\n  display: inline-flex;\n  vertical-align: middle; }\n  .btn-group > .btn,\n  .btn-group-vertical > .btn {\n    position: relative;\n    flex: 0 1 auto; }\n    .btn-group > .btn:hover,\n    .btn-group-vertical > .btn:hover {\n      z-index: 1; }\n    .btn-group > .btn:focus, .btn-group > .btn:active, .btn-group > .btn.active,\n    .btn-group-vertical > .btn:focus,\n    .btn-group-vertical > .btn:active,\n    .btn-group-vertical > .btn.active {\n      z-index: 1; }\n  .btn-group .btn + .btn,\n  .btn-group .btn + .btn-group,\n  .btn-group .btn-group + .btn,\n  .btn-group .btn-group + .btn-group,\n  .btn-group-vertical .btn + .btn,\n  .btn-group-vertical .btn + .btn-group,\n  .btn-group-vertical .btn-group + .btn,\n  .btn-group-vertical .btn-group + .btn-group {\n    margin-left: -1px; }\n\n.btn-toolbar {\n  display: flex;\n  flex-wrap: wrap;\n  justify-content: flex-start; }\n  .btn-toolbar .input-group {\n    width: auto; }\n\n.btn-group > .btn:first-child {\n  margin-left: 0; }\n\n.btn-group > .btn:not(:last-child):not(.dropdown-toggle),\n.btn-group > .btn-group:not(:last-child) > .btn {\n  border-top-right-radius: 0;\n  border-bottom-right-radius: 0; }\n\n.btn-group > .btn:not(:first-child),\n.btn-group > .btn-group:not(:first-child) > .btn {\n  border-top-left-radius: 0;\n  border-bottom-left-radius: 0; }\n\n.dropdown-toggle-split {\n  padding-right: 0.75rem;\n  padding-left: 0.75rem; }\n  .dropdown-toggle-split::after {\n    margin-left: 0; }\n\n.btn-sm + .dropdown-toggle-split, .btn-group-sm > .btn + .dropdown-toggle-split {\n  padding-right: 0.5625rem;\n  padding-left: 0.5625rem; }\n\n.btn-lg + .dropdown-toggle-split, .btn-group-lg > .btn + .dropdown-toggle-split {\n  padding-right: 0.75rem;\n  padding-left: 0.75rem; }\n\n.btn-group-vertical {\n  flex-direction: column;\n  align-items: flex-start;\n  justify-content: center; }\n  .btn-group-vertical .btn,\n  .btn-group-vertical .btn-group {\n    width: 100%; }\n  .btn-group-vertical > .btn + .btn,\n  .btn-group-vertical > .btn + .btn-group,\n  .btn-group-vertical > .btn-group + .btn,\n  .btn-group-vertical > .btn-group + .btn-group {\n    margin-top: -1px;\n    margin-left: 0; }\n  .btn-group-vertical > .btn:not(:last-child):not(.dropdown-toggle),\n  .btn-group-vertical > .btn-group:not(:last-child) > .btn {\n    border-bottom-right-radius: 0;\n    border-bottom-left-radius: 0; }\n  .btn-group-vertical > .btn:not(:first-child),\n  .btn-group-vertical > .btn-group:not(:first-child) > .btn {\n    border-top-left-radius: 0;\n    border-top-right-radius: 0; }\n\n.btn-group-toggle > .btn,\n.btn-group-toggle > .btn-group > .btn {\n  margin-bottom: 0; }\n  .btn-group-toggle > .btn input[type=\"radio\"],\n  .btn-group-toggle > .btn input[type=\"checkbox\"],\n  .btn-group-toggle > .btn-group > .btn input[type=\"radio\"],\n  .btn-group-toggle > .btn-group > .btn input[type=\"checkbox\"] {\n    position: absolute;\n    clip: rect(0, 0, 0, 0);\n    pointer-events: none; }\n\n.input-group {\n  position: relative;\n  display: flex;\n  flex-wrap: wrap;\n  align-items: stretch;\n  width: 100%; }\n  .input-group > .form-control,\n  .input-group > .custom-select,\n  .input-group > .custom-file {\n    position: relative;\n    flex: 1 1 auto;\n    width: 1%;\n    margin-bottom: 0; }\n    .input-group > .form-control:focus,\n    .input-group > .custom-select:focus,\n    .input-group > .custom-file:focus {\n      z-index: 3; }\n    .input-group > .form-control + .form-control,\n    .input-group > .form-control + .custom-select,\n    .input-group > .form-control + .custom-file,\n    .input-group > .custom-select + .form-control,\n    .input-group > .custom-select + .custom-select,\n    .input-group > .custom-select + .custom-file,\n    .input-group > .custom-file + .form-control,\n    .input-group > .custom-file + .custom-select,\n    .input-group > .custom-file + .custom-file {\n      margin-left: -1px; }\n  .input-group > .form-control:not(:last-child),\n  .input-group > .custom-select:not(:last-child) {\n    border-top-right-radius: 0;\n    border-bottom-right-radius: 0; }\n  .input-group > .form-control:not(:first-child),\n  .input-group > .custom-select:not(:first-child) {\n    border-top-left-radius: 0;\n    border-bottom-left-radius: 0; }\n  .input-group > .custom-file {\n    display: flex;\n    align-items: center; }\n    .input-group > .custom-file:not(:last-child) .custom-file-label,\n    .input-group > .custom-file:not(:last-child) .custom-file-label::before {\n      border-top-right-radius: 0;\n      border-bottom-right-radius: 0; }\n    .input-group > .custom-file:not(:first-child) .custom-file-label,\n    .input-group > .custom-file:not(:first-child) .custom-file-label::before {\n      border-top-left-radius: 0;\n      border-bottom-left-radius: 0; }\n\n.input-group-prepend,\n.input-group-append {\n  display: flex; }\n  .input-group-prepend .btn,\n  .input-group-append .btn {\n    position: relative;\n    z-index: 2; }\n  .input-group-prepend .btn + .btn,\n  .input-group-prepend .btn + .input-group-text,\n  .input-group-prepend .input-group-text + .input-group-text,\n  .input-group-prepend .input-group-text + .btn,\n  .input-group-append .btn + .btn,\n  .input-group-append .btn + .input-group-text,\n  .input-group-append .input-group-text + .input-group-text,\n  .input-group-append .input-group-text + .btn {\n    margin-left: -1px; }\n\n.input-group-prepend {\n  margin-right: -1px; }\n\n.input-group-append {\n  margin-left: -1px; }\n\n.input-group-text {\n  display: flex;\n  align-items: center;\n  padding: 0.5rem 1rem;\n  margin-bottom: 0;\n  font-size: 1rem;\n  font-weight: 400;\n  line-height: 1.5;\n  color: #495057;\n  text-align: center;\n  white-space: nowrap;\n  background-color: #e9ecef;\n  border: 1px solid #ced4da;\n  border-radius: 0.1875rem; }\n  .input-group-text input[type=\"radio\"],\n  .input-group-text input[type=\"checkbox\"] {\n    margin-top: 0; }\n\n.input-group > .input-group-prepend > .btn,\n.input-group > .input-group-prepend > .input-group-text,\n.input-group > .input-group-append:not(:last-child) > .btn,\n.input-group > .input-group-append:not(:last-child) > .input-group-text,\n.input-group > .input-group-append:last-child > .btn:not(:last-child):not(.dropdown-toggle),\n.input-group > .input-group-append:last-child > .input-group-text:not(:last-child) {\n  border-top-right-radius: 0;\n  border-bottom-right-radius: 0; }\n\n.input-group > .input-group-append > .btn,\n.input-group > .input-group-append > .input-group-text,\n.input-group > .input-group-prepend:not(:first-child) > .btn,\n.input-group > .input-group-prepend:not(:first-child) > .input-group-text,\n.input-group > .input-group-prepend:first-child > .btn:not(:first-child),\n.input-group > .input-group-prepend:first-child > .input-group-text:not(:first-child) {\n  border-top-left-radius: 0;\n  border-bottom-left-radius: 0; }\n\n.custom-control {\n  position: relative;\n  display: block;\n  min-height: 1.5rem;\n  padding-left: 1.5rem; }\n\n.custom-control-inline {\n  display: inline-flex;\n  margin-right: 1rem; }\n\n.custom-control-input {\n  position: absolute;\n  z-index: -1;\n  opacity: 0; }\n  .custom-control-input:checked ~ .custom-control-label::before {\n    color: #fff;\n    background-color: #00acec; }\n  .custom-control-input:focus ~ .custom-control-label::before {\n    box-shadow: 0 0 0 1px #fff, 0 0 0 0; }\n  .custom-control-input:active ~ .custom-control-label::before {\n    color: #fff;\n    background-color: #a0e5ff; }\n  .custom-control-input:disabled ~ .custom-control-label {\n    color: #868e96; }\n    .custom-control-input:disabled ~ .custom-control-label::before {\n      background-color: #e9ecef; }\n\n.custom-control-label {\n  margin-bottom: 0; }\n  .custom-control-label::before {\n    position: absolute;\n    top: 0.25rem;\n    left: 0;\n    display: block;\n    width: 1rem;\n    height: 1rem;\n    pointer-events: none;\n    content: \"\";\n    user-select: none;\n    background-color: transparent; }\n  .custom-control-label::after {\n    position: absolute;\n    top: 0.25rem;\n    left: 0;\n    display: block;\n    width: 1rem;\n    height: 1rem;\n    content: \"\";\n    background-repeat: no-repeat;\n    background-position: center center;\n    background-size: 50% 50%; }\n\n.custom-checkbox .custom-control-label::before {\n  border-radius: 2px; }\n\n.custom-checkbox .custom-control-input:checked ~ .custom-control-label::before {\n  background-color: #00acec; }\n\n.custom-checkbox .custom-control-input:checked ~ .custom-control-label::after {\n  background-image: url(\"data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3E%3Cpath fill='%23fff' d='M6.564.75l-3.59 3.612-1.538-1.55L0 4.26 2.974 7.25 8 2.193z'/%3E%3C/svg%3E\"); }\n\n.custom-checkbox .custom-control-input:indeterminate ~ .custom-control-label::before {\n  background-color: #00acec; }\n\n.custom-checkbox .custom-control-input:indeterminate ~ .custom-control-label::after {\n  background-image: url(\"data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 4 4'%3E%3Cpath stroke='%23fff' d='M0 2h4'/%3E%3C/svg%3E\"); }\n\n.custom-checkbox .custom-control-input:disabled:checked ~ .custom-control-label::before {\n  background-color: rgba(0, 172, 236, 0.5); }\n\n.custom-checkbox .custom-control-input:disabled:indeterminate ~ .custom-control-label::before {\n  background-color: rgba(0, 172, 236, 0.5); }\n\n.custom-radio .custom-control-label::before {\n  border-radius: 50%; }\n\n.custom-radio .custom-control-input:checked ~ .custom-control-label::before {\n  background-color: #00acec; }\n\n.custom-radio .custom-control-input:checked ~ .custom-control-label::after {\n  background-image: url(\"data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3E%3Ccircle r='3' fill='%23fff'/%3E%3C/svg%3E\"); }\n\n.custom-radio .custom-control-input:disabled:checked ~ .custom-control-label::before {\n  background-color: rgba(0, 172, 236, 0.5); }\n\n.custom-select {\n  display: inline-block;\n  width: 100%;\n  height: calc(2.5rem + 2px);\n  padding: 0.375rem 1.75rem 0.375rem 0.75rem;\n  line-height: 1.5;\n  color: #495057;\n  vertical-align: middle;\n  background: #fff url(\"data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 4 5'%3E%3Cpath fill='%23343a40' d='M2 0L0 2h4zm0 5L0 3h4z'/%3E%3C/svg%3E\") no-repeat right 0.75rem center;\n  background-size: 8px 10px;\n  border: 1px solid #ced4da;\n  border-radius: 0.1875rem;\n  appearance: none; }\n  .custom-select:focus {\n    border-color: #00acec;\n    outline: 0;\n    box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.075), 0 0 5px rgba(0, 172, 236, 0.5); }\n    .custom-select:focus::-ms-value {\n      color: #495057;\n      background-color: #f8f8f8; }\n  .custom-select[multiple], .custom-select[size]:not([size=\"1\"]) {\n    height: auto;\n    padding-right: 0.75rem;\n    background-image: none; }\n  .custom-select:disabled {\n    color: #868e96;\n    background-color: #e9ecef; }\n  .custom-select::-ms-expand {\n    opacity: 0; }\n\n.custom-select-sm {\n  height: calc(1.6875rem + 2px);\n  padding-top: 0.375rem;\n  padding-bottom: 0.375rem;\n  font-size: 75%; }\n\n.custom-select-lg {\n  height: calc(2.5rem + 2px);\n  padding-top: 0.375rem;\n  padding-bottom: 0.375rem;\n  font-size: 125%; }\n\n.custom-file {\n  position: relative;\n  display: inline-block;\n  width: 100%;\n  height: calc(2.5rem + 2px);\n  margin-bottom: 0; }\n\n.custom-file-input {\n  position: relative;\n  z-index: 2;\n  width: 100%;\n  height: calc(2.5rem + 2px);\n  margin: 0;\n  opacity: 0; }\n  .custom-file-input:focus ~ .custom-file-control {\n    border-color: #00acec;\n    box-shadow: 0 0 0 0; }\n    .custom-file-input:focus ~ .custom-file-control::before {\n      border-color: #00acec; }\n  .custom-file-input:lang(en) ~ .custom-file-label::after {\n    content: \"Browse\"; }\n\n.custom-file-label {\n  position: absolute;\n  top: 0;\n  right: 0;\n  left: 0;\n  z-index: 1;\n  height: calc(2.5rem + 2px);\n  padding: 0.5rem 1rem;\n  line-height: 1.5;\n  color: #495057;\n  background-color: #f8f8f8;\n  border: 1px solid #ced4da;\n  border-radius: 0.1875rem; }\n  .custom-file-label::after {\n    position: absolute;\n    top: 0;\n    right: 0;\n    bottom: 0;\n    z-index: 3;\n    display: block;\n    height: calc(calc(2.5rem + 2px) - 1px * 2);\n    padding: 0.5rem 1rem;\n    line-height: 1.5;\n    color: #495057;\n    content: \"Browse\";\n    background-color: #e9ecef;\n    border-left: 1px solid #ced4da;\n    border-radius: 0 0.1875rem 0.1875rem 0; }\n\n.nav {\n  display: flex;\n  flex-wrap: wrap;\n  padding-left: 0;\n  margin-bottom: 0;\n  list-style: none; }\n\n.nav-link {\n  display: block;\n  padding: 0.5rem 1rem; }\n  .nav-link:hover, .nav-link:focus {\n    text-decoration: none; }\n  .nav-link.disabled {\n    color: #868e96; }\n\n.nav-tabs {\n  border-bottom: 1px solid #dee2e6; }\n  .nav-tabs .nav-item {\n    margin-bottom: -1px; }\n  .nav-tabs .nav-link {\n    border: 1px solid transparent;\n    border-top-left-radius: 0.1875rem;\n    border-top-right-radius: 0.1875rem; }\n    .nav-tabs .nav-link:hover, .nav-tabs .nav-link:focus {\n      border-color: #e9ecef #e9ecef #dee2e6; }\n    .nav-tabs .nav-link.disabled {\n      color: #868e96;\n      background-color: transparent;\n      border-color: transparent; }\n  .nav-tabs .nav-link.active,\n  .nav-tabs .nav-item.show .nav-link {\n    color: #495057;\n    background-color: #fff;\n    border-color: #dee2e6 #dee2e6 #fff; }\n  .nav-tabs .dropdown-menu {\n    margin-top: -1px;\n    border-top-left-radius: 0;\n    border-top-right-radius: 0; }\n\n.nav-pills .nav-link {\n  border-radius: 0.1875rem; }\n\n.nav-pills .nav-link.active,\n.nav-pills .show > .nav-link {\n  color: #fff;\n  background-color: #00acec; }\n\n.nav-fill .nav-item {\n  flex: 1 1 auto;\n  text-align: center; }\n\n.nav-justified .nav-item {\n  flex-basis: 0;\n  flex-grow: 1;\n  text-align: center; }\n\n.tab-content > .tab-pane {\n  display: none; }\n\n.tab-content > .active {\n  display: block; }\n\n.navbar {\n  position: relative;\n  display: flex;\n  flex-wrap: wrap;\n  align-items: center;\n  justify-content: space-between;\n  padding: 0.5rem 1rem; }\n  .navbar > .container,\n  .navbar > .container-fluid {\n    display: flex;\n    flex-wrap: wrap;\n    align-items: center;\n    justify-content: space-between; }\n\n.navbar-brand {\n  display: inline-block;\n  padding-top: 0.5rem;\n  padding-bottom: 0.5rem;\n  margin-right: 1rem;\n  font-size: 1rem;\n  line-height: inherit;\n  white-space: nowrap; }\n  .navbar-brand:hover, .navbar-brand:focus {\n    text-decoration: none; }\n\n.navbar-nav {\n  display: flex;\n  flex-direction: column;\n  padding-left: 0;\n  margin-bottom: 0;\n  list-style: none; }\n  .navbar-nav .nav-link {\n    padding-right: 0;\n    padding-left: 0; }\n  .navbar-nav .dropdown-menu {\n    position: static;\n    float: none; }\n\n.navbar-text {\n  display: inline-block;\n  padding-top: 0.5rem;\n  padding-bottom: 0.5rem; }\n\n.navbar-collapse {\n  flex-basis: 100%;\n  flex-grow: 1;\n  align-items: center; }\n\n.navbar-toggler {\n  padding: 0.25rem 0.75rem;\n  font-size: 1rem;\n  line-height: 1;\n  background-color: transparent;\n  border: 1px solid transparent;\n  border-radius: 0.1875rem; }\n  .navbar-toggler:hover, .navbar-toggler:focus {\n    text-decoration: none; }\n  .navbar-toggler:not(:disabled):not(.disabled) {\n    cursor: pointer; }\n\n.navbar-toggler-icon {\n  display: inline-block;\n  width: 1.5em;\n  height: 1.5em;\n  vertical-align: middle;\n  content: \"\";\n  background: no-repeat center center;\n  background-size: 100% 100%; }\n\n@media (max-width: 575.98px) {\n  .navbar-expand-sm > .container,\n  .navbar-expand-sm > .container-fluid {\n    padding-right: 0;\n    padding-left: 0; } }\n\n@media (min-width: 576px) {\n  .navbar-expand-sm {\n    flex-flow: row nowrap;\n    justify-content: flex-start; }\n    .navbar-expand-sm .navbar-nav {\n      flex-direction: row; }\n      .navbar-expand-sm .navbar-nav .dropdown-menu {\n        position: absolute; }\n      .navbar-expand-sm .navbar-nav .dropdown-menu-right {\n        right: 0;\n        left: auto; }\n      .navbar-expand-sm .navbar-nav .nav-link {\n        padding-right: 0.5rem;\n        padding-left: 0.5rem; }\n    .navbar-expand-sm > .container,\n    .navbar-expand-sm > .container-fluid {\n      flex-wrap: nowrap; }\n    .navbar-expand-sm .navbar-collapse {\n      display: flex !important;\n      flex-basis: auto; }\n    .navbar-expand-sm .navbar-toggler {\n      display: none; }\n    .navbar-expand-sm .dropup .dropdown-menu {\n      top: auto;\n      bottom: 100%; } }\n\n@media (max-width: 767.98px) {\n  .navbar-expand-md > .container,\n  .navbar-expand-md > .container-fluid {\n    padding-right: 0;\n    padding-left: 0; } }\n\n@media (min-width: 768px) {\n  .navbar-expand-md {\n    flex-flow: row nowrap;\n    justify-content: flex-start; }\n    .navbar-expand-md .navbar-nav {\n      flex-direction: row; }\n      .navbar-expand-md .navbar-nav .dropdown-menu {\n        position: absolute; }\n      .navbar-expand-md .navbar-nav .dropdown-menu-right {\n        right: 0;\n        left: auto; }\n      .navbar-expand-md .navbar-nav .nav-link {\n        padding-right: 0.5rem;\n        padding-left: 0.5rem; }\n    .navbar-expand-md > .container,\n    .navbar-expand-md > .container-fluid {\n      flex-wrap: nowrap; }\n    .navbar-expand-md .navbar-collapse {\n      display: flex !important;\n      flex-basis: auto; }\n    .navbar-expand-md .navbar-toggler {\n      display: none; }\n    .navbar-expand-md .dropup .dropdown-menu {\n      top: auto;\n      bottom: 100%; } }\n\n@media (max-width: 991.98px) {\n  .navbar-expand-lg > .container,\n  .navbar-expand-lg > .container-fluid {\n    padding-right: 0;\n    padding-left: 0; } }\n\n@media (min-width: 992px) {\n  .navbar-expand-lg {\n    flex-flow: row nowrap;\n    justify-content: flex-start; }\n    .navbar-expand-lg .navbar-nav {\n      flex-direction: row; }\n      .navbar-expand-lg .navbar-nav .dropdown-menu {\n        position: absolute; }\n      .navbar-expand-lg .navbar-nav .dropdown-menu-right {\n        right: 0;\n        left: auto; }\n      .navbar-expand-lg .navbar-nav .nav-link {\n        padding-right: 0.5rem;\n        padding-left: 0.5rem; }\n    .navbar-expand-lg > .container,\n    .navbar-expand-lg > .container-fluid {\n      flex-wrap: nowrap; }\n    .navbar-expand-lg .navbar-collapse {\n      display: flex !important;\n      flex-basis: auto; }\n    .navbar-expand-lg .navbar-toggler {\n      display: none; }\n    .navbar-expand-lg .dropup .dropdown-menu {\n      top: auto;\n      bottom: 100%; } }\n\n@media (max-width: 1199.98px) {\n  .navbar-expand-xl > .container,\n  .navbar-expand-xl > .container-fluid {\n    padding-right: 0;\n    padding-left: 0; } }\n\n@media (min-width: 1200px) {\n  .navbar-expand-xl {\n    flex-flow: row nowrap;\n    justify-content: flex-start; }\n    .navbar-expand-xl .navbar-nav {\n      flex-direction: row; }\n      .navbar-expand-xl .navbar-nav .dropdown-menu {\n        position: absolute; }\n      .navbar-expand-xl .navbar-nav .dropdown-menu-right {\n        right: 0;\n        left: auto; }\n      .navbar-expand-xl .navbar-nav .nav-link {\n        padding-right: 0.5rem;\n        padding-left: 0.5rem; }\n    .navbar-expand-xl > .container,\n    .navbar-expand-xl > .container-fluid {\n      flex-wrap: nowrap; }\n    .navbar-expand-xl .navbar-collapse {\n      display: flex !important;\n      flex-basis: auto; }\n    .navbar-expand-xl .navbar-toggler {\n      display: none; }\n    .navbar-expand-xl .dropup .dropdown-menu {\n      top: auto;\n      bottom: 100%; } }\n\n@media (max-width: 1439.98px) {\n  .navbar-expand-xxl > .container,\n  .navbar-expand-xxl > .container-fluid {\n    padding-right: 0;\n    padding-left: 0; } }\n\n@media (min-width: 1440px) {\n  .navbar-expand-xxl {\n    flex-flow: row nowrap;\n    justify-content: flex-start; }\n    .navbar-expand-xxl .navbar-nav {\n      flex-direction: row; }\n      .navbar-expand-xxl .navbar-nav .dropdown-menu {\n        position: absolute; }\n      .navbar-expand-xxl .navbar-nav .dropdown-menu-right {\n        right: 0;\n        left: auto; }\n      .navbar-expand-xxl .navbar-nav .nav-link {\n        padding-right: 0.5rem;\n        padding-left: 0.5rem; }\n    .navbar-expand-xxl > .container,\n    .navbar-expand-xxl > .container-fluid {\n      flex-wrap: nowrap; }\n    .navbar-expand-xxl .navbar-collapse {\n      display: flex !important;\n      flex-basis: auto; }\n    .navbar-expand-xxl .navbar-toggler {\n      display: none; }\n    .navbar-expand-xxl .dropup .dropdown-menu {\n      top: auto;\n      bottom: 100%; } }\n\n.navbar-expand {\n  flex-flow: row nowrap;\n  justify-content: flex-start; }\n  .navbar-expand > .container,\n  .navbar-expand > .container-fluid {\n    padding-right: 0;\n    padding-left: 0; }\n  .navbar-expand .navbar-nav {\n    flex-direction: row; }\n    .navbar-expand .navbar-nav .dropdown-menu {\n      position: absolute; }\n    .navbar-expand .navbar-nav .dropdown-menu-right {\n      right: 0;\n      left: auto; }\n    .navbar-expand .navbar-nav .nav-link {\n      padding-right: 0.5rem;\n      padding-left: 0.5rem; }\n  .navbar-expand > .container,\n  .navbar-expand > .container-fluid {\n    flex-wrap: nowrap; }\n  .navbar-expand .navbar-collapse {\n    display: flex !important;\n    flex-basis: auto; }\n  .navbar-expand .navbar-toggler {\n    display: none; }\n  .navbar-expand .dropup .dropdown-menu {\n    top: auto;\n    bottom: 100%; }\n\n.navbar-light .navbar-brand {\n  color: rgba(0, 0, 0, 0.9); }\n  .navbar-light .navbar-brand:hover, .navbar-light .navbar-brand:focus {\n    color: rgba(0, 0, 0, 0.9); }\n\n.navbar-light .navbar-nav .nav-link {\n  color: rgba(0, 0, 0, 0.5); }\n  .navbar-light .navbar-nav .nav-link:hover, .navbar-light .navbar-nav .nav-link:focus {\n    color: rgba(0, 0, 0, 0.7); }\n  .navbar-light .navbar-nav .nav-link.disabled {\n    color: rgba(0, 0, 0, 0.3); }\n\n.navbar-light .navbar-nav .show > .nav-link,\n.navbar-light .navbar-nav .active > .nav-link,\n.navbar-light .navbar-nav .nav-link.show,\n.navbar-light .navbar-nav .nav-link.active {\n  color: rgba(0, 0, 0, 0.9); }\n\n.navbar-light .navbar-toggler {\n  color: rgba(0, 0, 0, 0.5);\n  border-color: rgba(0, 0, 0, 0.1); }\n\n.navbar-light .navbar-toggler-icon {\n  background-image: url(\"data:image/svg+xml;charset=utf8,%3Csvg viewBox='0 0 30 30' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath stroke='rgba(0, 0, 0, 0.5)' stroke-width='2' stroke-linecap='round' stroke-miterlimit='10' d='M4 7h22M4 15h22M4 23h22'/%3E%3C/svg%3E\"); }\n\n.navbar-light .navbar-text {\n  color: rgba(0, 0, 0, 0.5); }\n  .navbar-light .navbar-text a {\n    color: rgba(0, 0, 0, 0.9); }\n    .navbar-light .navbar-text a:hover, .navbar-light .navbar-text a:focus {\n      color: rgba(0, 0, 0, 0.9); }\n\n.navbar-dark .navbar-brand {\n  color: #fff; }\n  .navbar-dark .navbar-brand:hover, .navbar-dark .navbar-brand:focus {\n    color: #fff; }\n\n.navbar-dark .navbar-nav .nav-link {\n  color: rgba(255, 255, 255, 0.5); }\n  .navbar-dark .navbar-nav .nav-link:hover, .navbar-dark .navbar-nav .nav-link:focus {\n    color: rgba(255, 255, 255, 0.75); }\n  .navbar-dark .navbar-nav .nav-link.disabled {\n    color: rgba(255, 255, 255, 0.25); }\n\n.navbar-dark .navbar-nav .show > .nav-link,\n.navbar-dark .navbar-nav .active > .nav-link,\n.navbar-dark .navbar-nav .nav-link.show,\n.navbar-dark .navbar-nav .nav-link.active {\n  color: #fff; }\n\n.navbar-dark .navbar-toggler {\n  color: rgba(255, 255, 255, 0.5);\n  border-color: rgba(255, 255, 255, 0.1); }\n\n.navbar-dark .navbar-toggler-icon {\n  background-image: url(\"data:image/svg+xml;charset=utf8,%3Csvg viewBox='0 0 30 30' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath stroke='rgba(255, 255, 255, 0.5)' stroke-width='2' stroke-linecap='round' stroke-miterlimit='10' d='M4 7h22M4 15h22M4 23h22'/%3E%3C/svg%3E\"); }\n\n.navbar-dark .navbar-text {\n  color: rgba(255, 255, 255, 0.5); }\n  .navbar-dark .navbar-text a {\n    color: #fff; }\n    .navbar-dark .navbar-text a:hover, .navbar-dark .navbar-text a:focus {\n      color: #fff; }\n\n.card {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  min-width: 0;\n  word-wrap: break-word;\n  background-color: #fff;\n  background-clip: border-box;\n  border: 1px solid rgba(0, 0, 0, 0.125);\n  border-radius: 0.1875rem; }\n  .card > hr {\n    margin-right: 0;\n    margin-left: 0; }\n  .card > .list-group:first-child .list-group-item:first-child {\n    border-top-left-radius: 0.1875rem;\n    border-top-right-radius: 0.1875rem; }\n  .card > .list-group:last-child .list-group-item:last-child {\n    border-bottom-right-radius: 0.1875rem;\n    border-bottom-left-radius: 0.1875rem; }\n\n.card-body {\n  flex: 1 1 auto;\n  padding: 1.25rem; }\n\n.card-title {\n  margin-bottom: 0.75rem; }\n\n.card-subtitle {\n  margin-top: -0.375rem;\n  margin-bottom: 0; }\n\n.card-text:last-child {\n  margin-bottom: 0; }\n\n.card-link:hover {\n  text-decoration: none; }\n\n.card-link + .card-link {\n  margin-left: 1.25rem; }\n\n.card-header {\n  padding: 0.75rem 1.25rem;\n  margin-bottom: 0;\n  background-color: rgba(0, 0, 0, 0.03);\n  border-bottom: 1px solid rgba(0, 0, 0, 0.125); }\n  .card-header:first-child {\n    border-radius: calc(0.1875rem - 1px) calc(0.1875rem - 1px) 0 0; }\n  .card-header + .list-group .list-group-item:first-child {\n    border-top: 0; }\n\n.card-footer {\n  padding: 0.75rem 1.25rem;\n  background-color: rgba(0, 0, 0, 0.03);\n  border-top: 1px solid rgba(0, 0, 0, 0.125); }\n  .card-footer:last-child {\n    border-radius: 0 0 calc(0.1875rem - 1px) calc(0.1875rem - 1px); }\n\n.card-header-tabs {\n  margin-right: -0.625rem;\n  margin-bottom: -0.75rem;\n  margin-left: -0.625rem;\n  border-bottom: 0; }\n\n.card-header-pills {\n  margin-right: -0.625rem;\n  margin-left: -0.625rem; }\n\n.card-img-overlay {\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  padding: 1.25rem; }\n\n.card-img {\n  width: 100%;\n  border-radius: calc(0.1875rem - 1px); }\n\n.card-img-top {\n  width: 100%;\n  border-top-left-radius: calc(0.1875rem - 1px);\n  border-top-right-radius: calc(0.1875rem - 1px); }\n\n.card-img-bottom {\n  width: 100%;\n  border-bottom-right-radius: calc(0.1875rem - 1px);\n  border-bottom-left-radius: calc(0.1875rem - 1px); }\n\n.card-deck {\n  display: flex;\n  flex-direction: column; }\n  .card-deck .card {\n    margin-bottom: 15px; }\n  @media (min-width: 576px) {\n    .card-deck {\n      flex-flow: row wrap;\n      margin-right: -15px;\n      margin-left: -15px; }\n      .card-deck .card {\n        display: flex;\n        flex: 1 0 0%;\n        flex-direction: column;\n        margin-right: 15px;\n        margin-bottom: 0;\n        margin-left: 15px; } }\n\n.card-group {\n  display: flex;\n  flex-direction: column; }\n  .card-group > .card {\n    margin-bottom: 15px; }\n  @media (min-width: 576px) {\n    .card-group {\n      flex-flow: row wrap; }\n      .card-group > .card {\n        flex: 1 0 0%;\n        margin-bottom: 0; }\n        .card-group > .card + .card {\n          margin-left: 0;\n          border-left: 0; }\n        .card-group > .card:first-child {\n          border-top-right-radius: 0;\n          border-bottom-right-radius: 0; }\n          .card-group > .card:first-child .card-img-top,\n          .card-group > .card:first-child .card-header {\n            border-top-right-radius: 0; }\n          .card-group > .card:first-child .card-img-bottom,\n          .card-group > .card:first-child .card-footer {\n            border-bottom-right-radius: 0; }\n        .card-group > .card:last-child {\n          border-top-left-radius: 0;\n          border-bottom-left-radius: 0; }\n          .card-group > .card:last-child .card-img-top,\n          .card-group > .card:last-child .card-header {\n            border-top-left-radius: 0; }\n          .card-group > .card:last-child .card-img-bottom,\n          .card-group > .card:last-child .card-footer {\n            border-bottom-left-radius: 0; }\n        .card-group > .card:only-child {\n          border-radius: 0.1875rem; }\n          .card-group > .card:only-child .card-img-top,\n          .card-group > .card:only-child .card-header {\n            border-top-left-radius: 0.1875rem;\n            border-top-right-radius: 0.1875rem; }\n          .card-group > .card:only-child .card-img-bottom,\n          .card-group > .card:only-child .card-footer {\n            border-bottom-right-radius: 0.1875rem;\n            border-bottom-left-radius: 0.1875rem; }\n        .card-group > .card:not(:first-child):not(:last-child):not(:only-child) {\n          border-radius: 0; }\n          .card-group > .card:not(:first-child):not(:last-child):not(:only-child) .card-img-top,\n          .card-group > .card:not(:first-child):not(:last-child):not(:only-child) .card-img-bottom,\n          .card-group > .card:not(:first-child):not(:last-child):not(:only-child) .card-header,\n          .card-group > .card:not(:first-child):not(:last-child):not(:only-child) .card-footer {\n            border-radius: 0; } }\n\n.card-columns .card {\n  margin-bottom: 0.75rem; }\n\n@media (min-width: 576px) {\n  .card-columns {\n    column-count: 3;\n    column-gap: 1.25rem; }\n    .card-columns .card {\n      display: inline-block;\n      width: 100%; } }\n\n.breadcrumb {\n  display: flex;\n  flex-wrap: wrap;\n  padding: 0.75rem 1rem;\n  margin-bottom: 1rem;\n  list-style: none;\n  background-color: #e9ecef;\n  border-radius: 0.1875rem; }\n\n.breadcrumb-item + .breadcrumb-item::before {\n  display: inline-block;\n  padding-right: 0.5rem;\n  padding-left: 0.5rem;\n  color: #868e96;\n  content: \"/\"; }\n\n.breadcrumb-item + .breadcrumb-item:hover::before {\n  text-decoration: underline; }\n\n.breadcrumb-item + .breadcrumb-item:hover::before {\n  text-decoration: none; }\n\n.breadcrumb-item.active {\n  color: #868e96; }\n\n.pagination {\n  display: flex;\n  padding-left: 0;\n  list-style: none;\n  border-radius: 0.1875rem; }\n\n.page-link {\n  position: relative;\n  display: block;\n  padding: 0.5rem 0.75rem;\n  margin-left: -1px;\n  line-height: 1.25;\n  color: #00acec;\n  background-color: #fff;\n  border: 1px solid #dee2e6; }\n  .page-link:hover {\n    color: #0074a0;\n    text-decoration: none;\n    background-color: #e9ecef;\n    border-color: #dee2e6; }\n  .page-link:focus {\n    z-index: 2;\n    outline: 0;\n    box-shadow: 0 0 0 0; }\n  .page-link:not(:disabled):not(.disabled) {\n    cursor: pointer; }\n\n.page-item:first-child .page-link {\n  margin-left: 0;\n  border-top-left-radius: 0.1875rem;\n  border-bottom-left-radius: 0.1875rem; }\n\n.page-item:last-child .page-link {\n  border-top-right-radius: 0.1875rem;\n  border-bottom-right-radius: 0.1875rem; }\n\n.page-item.active .page-link {\n  z-index: 1;\n  color: #fff;\n  background-color: #00acec;\n  border-color: #00acec; }\n\n.page-item.disabled .page-link {\n  color: #868e96;\n  pointer-events: none;\n  cursor: auto;\n  background-color: #fff;\n  border-color: #dee2e6; }\n\n.pagination-lg .page-link {\n  padding: 0.75rem 1.5rem;\n  font-size: 1rem;\n  line-height: 1.5; }\n\n.pagination-lg .page-item:first-child .page-link {\n  border-top-left-radius: 0.3rem;\n  border-bottom-left-radius: 0.3rem; }\n\n.pagination-lg .page-item:last-child .page-link {\n  border-top-right-radius: 0.3rem;\n  border-bottom-right-radius: 0.3rem; }\n\n.pagination-sm .page-link {\n  padding: 0.25rem 0.5rem;\n  font-size: 0.75rem;\n  line-height: 1.25; }\n\n.pagination-sm .page-item:first-child .page-link {\n  border-top-left-radius: 0.2rem;\n  border-bottom-left-radius: 0.2rem; }\n\n.pagination-sm .page-item:last-child .page-link {\n  border-top-right-radius: 0.2rem;\n  border-bottom-right-radius: 0.2rem; }\n\n.badge {\n  display: inline-block;\n  padding: 0.25em 0.4em;\n  font-size: 0.8125rem;\n  font-weight: 400;\n  line-height: 1;\n  text-align: center;\n  white-space: nowrap;\n  vertical-align: baseline;\n  border-radius: 0.1875rem; }\n  .badge:empty {\n    display: none; }\n\n.btn .badge {\n  position: relative;\n  top: -1px; }\n\n.badge-pill {\n  padding-right: 0.6em;\n  padding-left: 0.6em;\n  border-radius: 10rem; }\n\n.badge-primary {\n  color: #fff;\n  background-color: #00acec; }\n  .badge-primary[href]:hover, .badge-primary[href]:focus {\n    color: #fff;\n    text-decoration: none;\n    background-color: #0087b9; }\n\n.badge-secondary {\n  color: #fff;\n  background-color: #868e96; }\n  .badge-secondary[href]:hover, .badge-secondary[href]:focus {\n    color: #fff;\n    text-decoration: none;\n    background-color: #6c757d; }\n\n.badge-success {\n  color: #fff;\n  background-color: #28a745; }\n  .badge-success[href]:hover, .badge-success[href]:focus {\n    color: #fff;\n    text-decoration: none;\n    background-color: #1e7e34; }\n\n.badge-info {\n  color: #fff;\n  background-color: #d50089; }\n  .badge-info[href]:hover, .badge-info[href]:focus {\n    color: #fff;\n    text-decoration: none;\n    background-color: #a20068; }\n\n.badge-warning {\n  color: #212529;\n  background-color: #ffc107; }\n  .badge-warning[href]:hover, .badge-warning[href]:focus {\n    color: #212529;\n    text-decoration: none;\n    background-color: #d39e00; }\n\n.badge-danger {\n  color: #fff;\n  background-color: #dc3545; }\n  .badge-danger[href]:hover, .badge-danger[href]:focus {\n    color: #fff;\n    text-decoration: none;\n    background-color: #bd2130; }\n\n.badge-light {\n  color: #212529;\n  background-color: #f8f9fa; }\n  .badge-light[href]:hover, .badge-light[href]:focus {\n    color: #212529;\n    text-decoration: none;\n    background-color: #dae0e5; }\n\n.badge-dark {\n  color: #fff;\n  background-color: #343a40; }\n  .badge-dark[href]:hover, .badge-dark[href]:focus {\n    color: #fff;\n    text-decoration: none;\n    background-color: #1d2124; }\n\n.jumbotron {\n  padding: 2rem 1rem;\n  margin-bottom: 2rem;\n  background-color: #e9ecef;\n  border-radius: 0.3rem; }\n  @media (min-width: 576px) {\n    .jumbotron {\n      padding: 4rem 2rem; } }\n\n.jumbotron-fluid {\n  padding-right: 0;\n  padding-left: 0;\n  border-radius: 0; }\n\n.alert {\n  position: relative;\n  padding: 0.75rem 1.25rem;\n  margin-bottom: 1rem;\n  border: 1px solid transparent;\n  border-radius: 0.1875rem; }\n\n.alert-heading {\n  color: inherit; }\n\n.alert-link {\n  font-weight: 700; }\n\n.alert-dismissible {\n  padding-right: 4rem; }\n  .alert-dismissible .close {\n    position: absolute;\n    top: 0;\n    right: 0;\n    padding: 0.75rem 1.25rem;\n    color: inherit; }\n\n.alert-primary {\n  color: #00597b;\n  background-color: #cceefb;\n  border-color: #b8e8fa; }\n  .alert-primary hr {\n    border-top-color: #a0e0f8; }\n  .alert-primary .alert-link {\n    color: #003448; }\n\n.alert-secondary {\n  color: #464a4e;\n  background-color: #e7e8ea;\n  border-color: #dddfe2; }\n  .alert-secondary hr {\n    border-top-color: #cfd2d6; }\n  .alert-secondary .alert-link {\n    color: #2e3133; }\n\n.alert-success {\n  color: #155724;\n  background-color: #d4edda;\n  border-color: #c3e6cb; }\n  .alert-success hr {\n    border-top-color: #b1dfbb; }\n  .alert-success .alert-link {\n    color: #0b2e13; }\n\n.alert-info {\n  color: #6f0047;\n  background-color: #f7cce7;\n  border-color: #f3b8de; }\n  .alert-info hr {\n    border-top-color: #efa2d4; }\n  .alert-info .alert-link {\n    color: #3c0026; }\n\n.alert-warning {\n  color: #856404;\n  background-color: #fff3cd;\n  border-color: #ffeeba; }\n  .alert-warning hr {\n    border-top-color: #ffe8a1; }\n  .alert-warning .alert-link {\n    color: #533f03; }\n\n.alert-danger {\n  color: #721c24;\n  background-color: #f8d7da;\n  border-color: #f5c6cb; }\n  .alert-danger hr {\n    border-top-color: #f1b0b7; }\n  .alert-danger .alert-link {\n    color: #491217; }\n\n.alert-light {\n  color: #818182;\n  background-color: #fefefe;\n  border-color: #fdfdfe; }\n  .alert-light hr {\n    border-top-color: #ececf6; }\n  .alert-light .alert-link {\n    color: #686868; }\n\n.alert-dark {\n  color: #1b1e21;\n  background-color: #d6d8d9;\n  border-color: #c6c8ca; }\n  .alert-dark hr {\n    border-top-color: #b9bbbe; }\n  .alert-dark .alert-link {\n    color: #040505; }\n\n@keyframes progress-bar-stripes {\n  from {\n    background-position: 1rem 0; }\n  to {\n    background-position: 0 0; } }\n\n.progress {\n  display: flex;\n  height: 1rem;\n  overflow: hidden;\n  font-size: 0.75rem;\n  background-color: #e9ecef;\n  border-radius: 0.1875rem; }\n\n.progress-bar {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  color: #fff;\n  text-align: center;\n  background-color: #00acec;\n  transition: width 0.6s ease; }\n\n.progress-bar-striped {\n  background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);\n  background-size: 1rem 1rem; }\n\n.progress-bar-animated {\n  animation: progress-bar-stripes 1s linear infinite; }\n\n.media {\n  display: flex;\n  align-items: flex-start; }\n\n.media-body {\n  flex: 1; }\n\n.list-group {\n  display: flex;\n  flex-direction: column;\n  padding-left: 0;\n  margin-bottom: 0; }\n\n.list-group-item-action {\n  width: 100%;\n  color: #495057;\n  text-align: inherit; }\n  .list-group-item-action:hover, .list-group-item-action:focus {\n    color: #495057;\n    text-decoration: none;\n    background-color: #f8f9fa; }\n  .list-group-item-action:active {\n    color: #212529;\n    background-color: #e9ecef; }\n\n.list-group-item {\n  position: relative;\n  display: block;\n  padding: 0.75rem 1.25rem;\n  margin-bottom: -1px;\n  background-color: #fff;\n  border: 1px solid rgba(0, 0, 0, 0.125); }\n  .list-group-item:first-child {\n    border-top-left-radius: 0.1875rem;\n    border-top-right-radius: 0.1875rem; }\n  .list-group-item:last-child {\n    margin-bottom: 0;\n    border-bottom-right-radius: 0.1875rem;\n    border-bottom-left-radius: 0.1875rem; }\n  .list-group-item:hover, .list-group-item:focus {\n    z-index: 1;\n    text-decoration: none; }\n  .list-group-item.disabled, .list-group-item:disabled {\n    color: #868e96;\n    background-color: #fff; }\n  .list-group-item.active {\n    z-index: 2;\n    color: #fff;\n    background-color: #00acec;\n    border-color: #00acec; }\n\n.list-group-flush .list-group-item {\n  border-right: 0;\n  border-left: 0;\n  border-radius: 0; }\n\n.list-group-flush:first-child .list-group-item:first-child {\n  border-top: 0; }\n\n.list-group-flush:last-child .list-group-item:last-child {\n  border-bottom: 0; }\n\n.list-group-item-primary {\n  color: #00597b;\n  background-color: #b8e8fa; }\n  .list-group-item-primary.list-group-item-action:hover, .list-group-item-primary.list-group-item-action:focus {\n    color: #00597b;\n    background-color: #a0e0f8; }\n  .list-group-item-primary.list-group-item-action.active {\n    color: #fff;\n    background-color: #00597b;\n    border-color: #00597b; }\n\n.list-group-item-secondary {\n  color: #464a4e;\n  background-color: #dddfe2; }\n  .list-group-item-secondary.list-group-item-action:hover, .list-group-item-secondary.list-group-item-action:focus {\n    color: #464a4e;\n    background-color: #cfd2d6; }\n  .list-group-item-secondary.list-group-item-action.active {\n    color: #fff;\n    background-color: #464a4e;\n    border-color: #464a4e; }\n\n.list-group-item-success {\n  color: #155724;\n  background-color: #c3e6cb; }\n  .list-group-item-success.list-group-item-action:hover, .list-group-item-success.list-group-item-action:focus {\n    color: #155724;\n    background-color: #b1dfbb; }\n  .list-group-item-success.list-group-item-action.active {\n    color: #fff;\n    background-color: #155724;\n    border-color: #155724; }\n\n.list-group-item-info {\n  color: #6f0047;\n  background-color: #f3b8de; }\n  .list-group-item-info.list-group-item-action:hover, .list-group-item-info.list-group-item-action:focus {\n    color: #6f0047;\n    background-color: #efa2d4; }\n  .list-group-item-info.list-group-item-action.active {\n    color: #fff;\n    background-color: #6f0047;\n    border-color: #6f0047; }\n\n.list-group-item-warning {\n  color: #856404;\n  background-color: #ffeeba; }\n  .list-group-item-warning.list-group-item-action:hover, .list-group-item-warning.list-group-item-action:focus {\n    color: #856404;\n    background-color: #ffe8a1; }\n  .list-group-item-warning.list-group-item-action.active {\n    color: #fff;\n    background-color: #856404;\n    border-color: #856404; }\n\n.list-group-item-danger {\n  color: #721c24;\n  background-color: #f5c6cb; }\n  .list-group-item-danger.list-group-item-action:hover, .list-group-item-danger.list-group-item-action:focus {\n    color: #721c24;\n    background-color: #f1b0b7; }\n  .list-group-item-danger.list-group-item-action.active {\n    color: #fff;\n    background-color: #721c24;\n    border-color: #721c24; }\n\n.list-group-item-light {\n  color: #818182;\n  background-color: #fdfdfe; }\n  .list-group-item-light.list-group-item-action:hover, .list-group-item-light.list-group-item-action:focus {\n    color: #818182;\n    background-color: #ececf6; }\n  .list-group-item-light.list-group-item-action.active {\n    color: #fff;\n    background-color: #818182;\n    border-color: #818182; }\n\n.list-group-item-dark {\n  color: #1b1e21;\n  background-color: #c6c8ca; }\n  .list-group-item-dark.list-group-item-action:hover, .list-group-item-dark.list-group-item-action:focus {\n    color: #1b1e21;\n    background-color: #b9bbbe; }\n  .list-group-item-dark.list-group-item-action.active {\n    color: #fff;\n    background-color: #1b1e21;\n    border-color: #1b1e21; }\n\n.close {\n  float: right;\n  font-size: 1.5rem;\n  font-weight: 700;\n  line-height: 1;\n  color: #000;\n  text-shadow: 0 1px 0 #fff;\n  opacity: .5; }\n  .close:hover, .close:focus {\n    color: #000;\n    text-decoration: none;\n    opacity: .75; }\n  .close:not(:disabled):not(.disabled) {\n    cursor: pointer; }\n\nbutton.close {\n  padding: 0;\n  background-color: transparent;\n  border: 0;\n  -webkit-appearance: none; }\n\n.modal-open {\n  overflow: hidden; }\n\n.modal {\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 1050;\n  display: none;\n  overflow: hidden;\n  outline: 0; }\n  .modal-open .modal {\n    overflow-x: hidden;\n    overflow-y: auto; }\n\n.modal-dialog {\n  position: relative;\n  width: auto;\n  margin: 0.5rem;\n  pointer-events: none; }\n  .modal.fade .modal-dialog {\n    transition: transform 0.3s ease-out;\n    transform: translate(0, -25%); }\n  .modal.show .modal-dialog {\n    transform: translate(0, 0); }\n\n.modal-dialog-centered {\n  display: flex;\n  align-items: center;\n  min-height: calc(100% - (0.5rem * 2)); }\n\n.modal-content {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  width: 100%;\n  pointer-events: auto;\n  background-color: transparent;\n  background-clip: padding-box;\n  border: 0px solid rgba(0, 0, 0, 0.2);\n  border-radius: 0.3rem;\n  outline: 0; }\n\n.modal-backdrop {\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 1040;\n  background-color: #fff; }\n  .modal-backdrop.fade {\n    opacity: 0; }\n  .modal-backdrop.show {\n    opacity: 0.95; }\n\n.modal-header {\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n  padding: 1rem;\n  border-bottom: 0px solid #e9ecef;\n  border-top-left-radius: 0.3rem;\n  border-top-right-radius: 0.3rem; }\n  .modal-header .close {\n    padding: 1rem;\n    margin: -1rem -1rem -1rem auto; }\n\n.modal-title {\n  margin-bottom: 0;\n  line-height: 1.5; }\n\n.modal-body {\n  position: relative;\n  flex: 1 1 auto;\n  padding: 1rem; }\n\n.modal-footer {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  padding: 1rem;\n  border-top: 0px solid #e9ecef; }\n  .modal-footer > :not(:first-child) {\n    margin-left: .25rem; }\n  .modal-footer > :not(:last-child) {\n    margin-right: .25rem; }\n\n.modal-scrollbar-measure {\n  position: absolute;\n  top: -9999px;\n  width: 50px;\n  height: 50px;\n  overflow: scroll; }\n\n@media (min-width: 576px) {\n  .modal-dialog {\n    max-width: 500px;\n    margin: 1.75rem auto; }\n  .modal-dialog-centered {\n    min-height: calc(100% - (1.75rem * 2)); }\n  .modal-sm {\n    max-width: 300px; } }\n\n@media (min-width: 992px) {\n  .modal-lg {\n    max-width: 800px; } }\n\n.tooltip {\n  position: absolute;\n  z-index: 1070;\n  display: block;\n  margin: 0;\n  font-family: \"Roboto\", \"Helvetica Neue\", Arial, sans-serif;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 1.5;\n  text-align: left;\n  text-align: start;\n  text-decoration: none;\n  text-shadow: none;\n  text-transform: none;\n  letter-spacing: normal;\n  word-break: normal;\n  word-spacing: normal;\n  white-space: normal;\n  line-break: auto;\n  font-size: 0.75rem;\n  word-wrap: break-word;\n  opacity: 0; }\n  .tooltip.show {\n    opacity: 0.9; }\n  .tooltip .arrow {\n    position: absolute;\n    display: block;\n    width: 0.8rem;\n    height: 0.4rem; }\n    .tooltip .arrow::before {\n      position: absolute;\n      content: \"\";\n      border-color: transparent;\n      border-style: solid; }\n\n.bs-tooltip-top, .bs-tooltip-auto[x-placement^=\"top\"] {\n  padding: 0.4rem 0; }\n  .bs-tooltip-top .arrow, .bs-tooltip-auto[x-placement^=\"top\"] .arrow {\n    bottom: 0; }\n    .bs-tooltip-top .arrow::before, .bs-tooltip-auto[x-placement^=\"top\"] .arrow::before {\n      top: 0;\n      border-width: 0.4rem 0.4rem 0;\n      border-top-color: #000; }\n\n.bs-tooltip-right, .bs-tooltip-auto[x-placement^=\"right\"] {\n  padding: 0 0.4rem; }\n  .bs-tooltip-right .arrow, .bs-tooltip-auto[x-placement^=\"right\"] .arrow {\n    left: 0;\n    width: 0.4rem;\n    height: 0.8rem; }\n    .bs-tooltip-right .arrow::before, .bs-tooltip-auto[x-placement^=\"right\"] .arrow::before {\n      right: 0;\n      border-width: 0.4rem 0.4rem 0.4rem 0;\n      border-right-color: #000; }\n\n.bs-tooltip-bottom, .bs-tooltip-auto[x-placement^=\"bottom\"] {\n  padding: 0.4rem 0; }\n  .bs-tooltip-bottom .arrow, .bs-tooltip-auto[x-placement^=\"bottom\"] .arrow {\n    top: 0; }\n    .bs-tooltip-bottom .arrow::before, .bs-tooltip-auto[x-placement^=\"bottom\"] .arrow::before {\n      bottom: 0;\n      border-width: 0 0.4rem 0.4rem;\n      border-bottom-color: #000; }\n\n.bs-tooltip-left, .bs-tooltip-auto[x-placement^=\"left\"] {\n  padding: 0 0.4rem; }\n  .bs-tooltip-left .arrow, .bs-tooltip-auto[x-placement^=\"left\"] .arrow {\n    right: 0;\n    width: 0.4rem;\n    height: 0.8rem; }\n    .bs-tooltip-left .arrow::before, .bs-tooltip-auto[x-placement^=\"left\"] .arrow::before {\n      left: 0;\n      border-width: 0.4rem 0 0.4rem 0.4rem;\n      border-left-color: #000; }\n\n.tooltip-inner {\n  max-width: 200px;\n  padding: 0.25rem 0.5rem;\n  color: #fff;\n  text-align: center;\n  background-color: #000;\n  border-radius: 0.1875rem; }\n\n.popover {\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: 1060;\n  display: block;\n  max-width: 276px;\n  font-family: \"Roboto\", \"Helvetica Neue\", Arial, sans-serif;\n  font-style: normal;\n  font-weight: 400;\n  line-height: 1.5;\n  text-align: left;\n  text-align: start;\n  text-decoration: none;\n  text-shadow: none;\n  text-transform: none;\n  letter-spacing: normal;\n  word-break: normal;\n  word-spacing: normal;\n  white-space: normal;\n  line-break: auto;\n  font-size: 0.75rem;\n  word-wrap: break-word;\n  background-color: #fff;\n  background-clip: padding-box;\n  border: 1px solid rgba(0, 0, 0, 0.2);\n  border-radius: 0.3rem; }\n  .popover .arrow {\n    position: absolute;\n    display: block;\n    width: 1rem;\n    height: 0.5rem;\n    margin: 0 0.3rem; }\n    .popover .arrow::before, .popover .arrow::after {\n      position: absolute;\n      display: block;\n      content: \"\";\n      border-color: transparent;\n      border-style: solid; }\n\n.bs-popover-top, .bs-popover-auto[x-placement^=\"top\"] {\n  margin-bottom: 0.5rem; }\n  .bs-popover-top .arrow, .bs-popover-auto[x-placement^=\"top\"] .arrow {\n    bottom: calc((0.5rem + 1px) * -1); }\n  .bs-popover-top .arrow::before, .bs-popover-auto[x-placement^=\"top\"] .arrow::before,\n  .bs-popover-top .arrow::after,\n  .bs-popover-auto[x-placement^=\"top\"] .arrow::after {\n    border-width: 0.5rem 0.5rem 0; }\n  .bs-popover-top .arrow::before, .bs-popover-auto[x-placement^=\"top\"] .arrow::before {\n    bottom: 0;\n    border-top-color: rgba(0, 0, 0, 0.25); }\n  \n  .bs-popover-top .arrow::after,\n  .bs-popover-auto[x-placement^=\"top\"] .arrow::after {\n    bottom: 1px;\n    border-top-color: #fff; }\n\n.bs-popover-right, .bs-popover-auto[x-placement^=\"right\"] {\n  margin-left: 0.5rem; }\n  .bs-popover-right .arrow, .bs-popover-auto[x-placement^=\"right\"] .arrow {\n    left: calc((0.5rem + 1px) * -1);\n    width: 0.5rem;\n    height: 1rem;\n    margin: 0.3rem 0; }\n  .bs-popover-right .arrow::before, .bs-popover-auto[x-placement^=\"right\"] .arrow::before,\n  .bs-popover-right .arrow::after,\n  .bs-popover-auto[x-placement^=\"right\"] .arrow::after {\n    border-width: 0.5rem 0.5rem 0.5rem 0; }\n  .bs-popover-right .arrow::before, .bs-popover-auto[x-placement^=\"right\"] .arrow::before {\n    left: 0;\n    border-right-color: rgba(0, 0, 0, 0.25); }\n  \n  .bs-popover-right .arrow::after,\n  .bs-popover-auto[x-placement^=\"right\"] .arrow::after {\n    left: 1px;\n    border-right-color: #fff; }\n\n.bs-popover-bottom, .bs-popover-auto[x-placement^=\"bottom\"] {\n  margin-top: 0.5rem; }\n  .bs-popover-bottom .arrow, .bs-popover-auto[x-placement^=\"bottom\"] .arrow {\n    top: calc((0.5rem + 1px) * -1); }\n  .bs-popover-bottom .arrow::before, .bs-popover-auto[x-placement^=\"bottom\"] .arrow::before,\n  .bs-popover-bottom .arrow::after,\n  .bs-popover-auto[x-placement^=\"bottom\"] .arrow::after {\n    border-width: 0 0.5rem 0.5rem 0.5rem; }\n  .bs-popover-bottom .arrow::before, .bs-popover-auto[x-placement^=\"bottom\"] .arrow::before {\n    top: 0;\n    border-bottom-color: rgba(0, 0, 0, 0.25); }\n  \n  .bs-popover-bottom .arrow::after,\n  .bs-popover-auto[x-placement^=\"bottom\"] .arrow::after {\n    top: 1px;\n    border-bottom-color: #fff; }\n  .bs-popover-bottom .popover-header::before, .bs-popover-auto[x-placement^=\"bottom\"] .popover-header::before {\n    position: absolute;\n    top: 0;\n    left: 50%;\n    display: block;\n    width: 1rem;\n    margin-left: -0.5rem;\n    content: \"\";\n    border-bottom: 1px solid #f7f7f7; }\n\n.bs-popover-left, .bs-popover-auto[x-placement^=\"left\"] {\n  margin-right: 0.5rem; }\n  .bs-popover-left .arrow, .bs-popover-auto[x-placement^=\"left\"] .arrow {\n    right: calc((0.5rem + 1px) * -1);\n    width: 0.5rem;\n    height: 1rem;\n    margin: 0.3rem 0; }\n  .bs-popover-left .arrow::before, .bs-popover-auto[x-placement^=\"left\"] .arrow::before,\n  .bs-popover-left .arrow::after,\n  .bs-popover-auto[x-placement^=\"left\"] .arrow::after {\n    border-width: 0.5rem 0 0.5rem 0.5rem; }\n  .bs-popover-left .arrow::before, .bs-popover-auto[x-placement^=\"left\"] .arrow::before {\n    right: 0;\n    border-left-color: rgba(0, 0, 0, 0.25); }\n  \n  .bs-popover-left .arrow::after,\n  .bs-popover-auto[x-placement^=\"left\"] .arrow::after {\n    right: 1px;\n    border-left-color: #fff; }\n\n.popover-header {\n  padding: 0.5rem 0.75rem;\n  margin-bottom: 0;\n  font-size: 1rem;\n  color: inherit;\n  background-color: #f7f7f7;\n  border-bottom: 1px solid #ebebeb;\n  border-top-left-radius: calc(0.3rem - 1px);\n  border-top-right-radius: calc(0.3rem - 1px); }\n  .popover-header:empty {\n    display: none; }\n\n.popover-body {\n  padding: 0.5rem 0.75rem;\n  color: #212529; }\n\n.carousel {\n  position: relative; }\n\n.carousel-inner {\n  position: relative;\n  width: 100%;\n  overflow: hidden; }\n\n.carousel-item {\n  position: relative;\n  display: none;\n  align-items: center;\n  width: 100%;\n  transition: transform 0.6s ease;\n  backface-visibility: hidden;\n  perspective: 1000px; }\n\n.carousel-item.active,\n.carousel-item-next,\n.carousel-item-prev {\n  display: block; }\n\n.carousel-item-next,\n.carousel-item-prev {\n  position: absolute;\n  top: 0; }\n\n.carousel-item-next.carousel-item-left,\n.carousel-item-prev.carousel-item-right {\n  transform: translateX(0); }\n  @supports (transform-style: preserve-3d) {\n    .carousel-item-next.carousel-item-left,\n    .carousel-item-prev.carousel-item-right {\n      transform: translate3d(0, 0, 0); } }\n\n.carousel-item-next,\n.active.carousel-item-right {\n  transform: translateX(100%); }\n  @supports (transform-style: preserve-3d) {\n    .carousel-item-next,\n    .active.carousel-item-right {\n      transform: translate3d(100%, 0, 0); } }\n\n.carousel-item-prev,\n.active.carousel-item-left {\n  transform: translateX(-100%); }\n  @supports (transform-style: preserve-3d) {\n    .carousel-item-prev,\n    .active.carousel-item-left {\n      transform: translate3d(-100%, 0, 0); } }\n\n.carousel-control-prev,\n.carousel-control-next {\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  width: 15%;\n  color: #fff;\n  text-align: center;\n  opacity: 0.5; }\n  .carousel-control-prev:hover, .carousel-control-prev:focus,\n  .carousel-control-next:hover,\n  .carousel-control-next:focus {\n    color: #fff;\n    text-decoration: none;\n    outline: 0;\n    opacity: .9; }\n\n.carousel-control-prev {\n  left: 0; }\n\n.carousel-control-next {\n  right: 0; }\n\n.carousel-control-prev-icon,\n.carousel-control-next-icon {\n  display: inline-block;\n  width: 20px;\n  height: 20px;\n  background: transparent no-repeat center center;\n  background-size: 100% 100%; }\n\n.carousel-control-prev-icon {\n  background-image: url(\"data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='%23fff' viewBox='0 0 8 8'%3E%3Cpath d='M5.25 0l-4 4 4 4 1.5-1.5-2.5-2.5 2.5-2.5-1.5-1.5z'/%3E%3C/svg%3E\"); }\n\n.carousel-control-next-icon {\n  background-image: url(\"data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='%23fff' viewBox='0 0 8 8'%3E%3Cpath d='M2.75 0l-1.5 1.5 2.5 2.5-2.5 2.5 1.5 1.5 4-4-4-4z'/%3E%3C/svg%3E\"); }\n\n.carousel-indicators {\n  position: absolute;\n  right: 0;\n  bottom: 10px;\n  left: 0;\n  z-index: 15;\n  display: flex;\n  justify-content: center;\n  padding-left: 0;\n  margin-right: 15%;\n  margin-left: 15%;\n  list-style: none; }\n  .carousel-indicators li {\n    position: relative;\n    flex: 0 1 auto;\n    width: 30px;\n    height: 3px;\n    margin-right: 3px;\n    margin-left: 3px;\n    text-indent: -999px;\n    background-color: rgba(255, 255, 255, 0.5); }\n    .carousel-indicators li::before {\n      position: absolute;\n      top: -10px;\n      left: 0;\n      display: inline-block;\n      width: 100%;\n      height: 10px;\n      content: \"\"; }\n    .carousel-indicators li::after {\n      position: absolute;\n      bottom: -10px;\n      left: 0;\n      display: inline-block;\n      width: 100%;\n      height: 10px;\n      content: \"\"; }\n  .carousel-indicators .active {\n    background-color: #fff; }\n\n.carousel-caption {\n  position: absolute;\n  right: 15%;\n  bottom: 20px;\n  left: 15%;\n  z-index: 10;\n  padding-top: 20px;\n  padding-bottom: 20px;\n  color: #fff;\n  text-align: center; }\n\n.align-baseline {\n  vertical-align: baseline !important; }\n\n.align-top {\n  vertical-align: top !important; }\n\n.align-middle {\n  vertical-align: middle !important; }\n\n.align-bottom {\n  vertical-align: bottom !important; }\n\n.align-text-bottom {\n  vertical-align: text-bottom !important; }\n\n.align-text-top {\n  vertical-align: text-top !important; }\n\n.bg-primary {\n  background-color: #00acec !important; }\n\na.bg-primary:hover, a.bg-primary:focus,\nbutton.bg-primary:hover,\nbutton.bg-primary:focus {\n  background-color: #0087b9 !important; }\n\n.bg-secondary {\n  background-color: #868e96 !important; }\n\na.bg-secondary:hover, a.bg-secondary:focus,\nbutton.bg-secondary:hover,\nbutton.bg-secondary:focus {\n  background-color: #6c757d !important; }\n\n.bg-success {\n  background-color: #28a745 !important; }\n\na.bg-success:hover, a.bg-success:focus,\nbutton.bg-success:hover,\nbutton.bg-success:focus {\n  background-color: #1e7e34 !important; }\n\n.bg-info {\n  background-color: #d50089 !important; }\n\na.bg-info:hover, a.bg-info:focus,\nbutton.bg-info:hover,\nbutton.bg-info:focus {\n  background-color: #a20068 !important; }\n\n.bg-warning {\n  background-color: #ffc107 !important; }\n\na.bg-warning:hover, a.bg-warning:focus,\nbutton.bg-warning:hover,\nbutton.bg-warning:focus {\n  background-color: #d39e00 !important; }\n\n.bg-danger {\n  background-color: #dc3545 !important; }\n\na.bg-danger:hover, a.bg-danger:focus,\nbutton.bg-danger:hover,\nbutton.bg-danger:focus {\n  background-color: #bd2130 !important; }\n\n.bg-light {\n  background-color: #f8f9fa !important; }\n\na.bg-light:hover, a.bg-light:focus,\nbutton.bg-light:hover,\nbutton.bg-light:focus {\n  background-color: #dae0e5 !important; }\n\n.bg-dark {\n  background-color: #343a40 !important; }\n\na.bg-dark:hover, a.bg-dark:focus,\nbutton.bg-dark:hover,\nbutton.bg-dark:focus {\n  background-color: #1d2124 !important; }\n\n.bg-white {\n  background-color: #fff !important; }\n\n.bg-transparent {\n  background-color: transparent !important; }\n\n.border {\n  border: 1px solid #dee2e6 !important; }\n\n.border-top {\n  border-top: 1px solid #dee2e6 !important; }\n\n.border-right {\n  border-right: 1px solid #dee2e6 !important; }\n\n.border-bottom {\n  border-bottom: 1px solid #dee2e6 !important; }\n\n.border-left {\n  border-left: 1px solid #dee2e6 !important; }\n\n.border-0 {\n  border: 0 !important; }\n\n.border-top-0 {\n  border-top: 0 !important; }\n\n.border-right-0 {\n  border-right: 0 !important; }\n\n.border-bottom-0 {\n  border-bottom: 0 !important; }\n\n.border-left-0 {\n  border-left: 0 !important; }\n\n.border-primary {\n  border-color: #00acec !important; }\n\n.border-secondary {\n  border-color: #868e96 !important; }\n\n.border-success {\n  border-color: #28a745 !important; }\n\n.border-info {\n  border-color: #d50089 !important; }\n\n.border-warning {\n  border-color: #ffc107 !important; }\n\n.border-danger {\n  border-color: #dc3545 !important; }\n\n.border-light {\n  border-color: #f8f9fa !important; }\n\n.border-dark {\n  border-color: #343a40 !important; }\n\n.border-white {\n  border-color: #fff !important; }\n\n.rounded {\n  border-radius: 0.1875rem !important; }\n\n.rounded-top {\n  border-top-left-radius: 0.1875rem !important;\n  border-top-right-radius: 0.1875rem !important; }\n\n.rounded-right {\n  border-top-right-radius: 0.1875rem !important;\n  border-bottom-right-radius: 0.1875rem !important; }\n\n.rounded-bottom {\n  border-bottom-right-radius: 0.1875rem !important;\n  border-bottom-left-radius: 0.1875rem !important; }\n\n.rounded-left {\n  border-top-left-radius: 0.1875rem !important;\n  border-bottom-left-radius: 0.1875rem !important; }\n\n.rounded-circle {\n  border-radius: 50% !important; }\n\n.rounded-0 {\n  border-radius: 0 !important; }\n\n.clearfix::after {\n  display: block;\n  clear: both;\n  content: \"\"; }\n\n.d-none {\n  display: none !important; }\n\n.d-inline {\n  display: inline !important; }\n\n.d-inline-block {\n  display: inline-block !important; }\n\n.d-block {\n  display: block !important; }\n\n.d-table {\n  display: table !important; }\n\n.d-table-row {\n  display: table-row !important; }\n\n.d-table-cell {\n  display: table-cell !important; }\n\n.d-flex {\n  display: flex !important; }\n\n.d-inline-flex {\n  display: inline-flex !important; }\n\n@media (min-width: 576px) {\n  .d-sm-none {\n    display: none !important; }\n  .d-sm-inline {\n    display: inline !important; }\n  .d-sm-inline-block {\n    display: inline-block !important; }\n  .d-sm-block {\n    display: block !important; }\n  .d-sm-table {\n    display: table !important; }\n  .d-sm-table-row {\n    display: table-row !important; }\n  .d-sm-table-cell {\n    display: table-cell !important; }\n  .d-sm-flex {\n    display: flex !important; }\n  .d-sm-inline-flex {\n    display: inline-flex !important; } }\n\n@media (min-width: 768px) {\n  .d-md-none {\n    display: none !important; }\n  .d-md-inline {\n    display: inline !important; }\n  .d-md-inline-block {\n    display: inline-block !important; }\n  .d-md-block {\n    display: block !important; }\n  .d-md-table {\n    display: table !important; }\n  .d-md-table-row {\n    display: table-row !important; }\n  .d-md-table-cell {\n    display: table-cell !important; }\n  .d-md-flex {\n    display: flex !important; }\n  .d-md-inline-flex {\n    display: inline-flex !important; } }\n\n@media (min-width: 992px) {\n  .d-lg-none {\n    display: none !important; }\n  .d-lg-inline {\n    display: inline !important; }\n  .d-lg-inline-block {\n    display: inline-block !important; }\n  .d-lg-block {\n    display: block !important; }\n  .d-lg-table {\n    display: table !important; }\n  .d-lg-table-row {\n    display: table-row !important; }\n  .d-lg-table-cell {\n    display: table-cell !important; }\n  .d-lg-flex {\n    display: flex !important; }\n  .d-lg-inline-flex {\n    display: inline-flex !important; } }\n\n@media (min-width: 1200px) {\n  .d-xl-none {\n    display: none !important; }\n  .d-xl-inline {\n    display: inline !important; }\n  .d-xl-inline-block {\n    display: inline-block !important; }\n  .d-xl-block {\n    display: block !important; }\n  .d-xl-table {\n    display: table !important; }\n  .d-xl-table-row {\n    display: table-row !important; }\n  .d-xl-table-cell {\n    display: table-cell !important; }\n  .d-xl-flex {\n    display: flex !important; }\n  .d-xl-inline-flex {\n    display: inline-flex !important; } }\n\n@media (min-width: 1440px) {\n  .d-xxl-none {\n    display: none !important; }\n  .d-xxl-inline {\n    display: inline !important; }\n  .d-xxl-inline-block {\n    display: inline-block !important; }\n  .d-xxl-block {\n    display: block !important; }\n  .d-xxl-table {\n    display: table !important; }\n  .d-xxl-table-row {\n    display: table-row !important; }\n  .d-xxl-table-cell {\n    display: table-cell !important; }\n  .d-xxl-flex {\n    display: flex !important; }\n  .d-xxl-inline-flex {\n    display: inline-flex !important; } }\n\n@media print {\n  .d-print-none {\n    display: none !important; }\n  .d-print-inline {\n    display: inline !important; }\n  .d-print-inline-block {\n    display: inline-block !important; }\n  .d-print-block {\n    display: block !important; }\n  .d-print-table {\n    display: table !important; }\n  .d-print-table-row {\n    display: table-row !important; }\n  .d-print-table-cell {\n    display: table-cell !important; }\n  .d-print-flex {\n    display: flex !important; }\n  .d-print-inline-flex {\n    display: inline-flex !important; } }\n\n.embed-responsive {\n  position: relative;\n  display: block;\n  width: 100%;\n  padding: 0;\n  overflow: hidden; }\n  .embed-responsive::before {\n    display: block;\n    content: \"\"; }\n  .embed-responsive .embed-responsive-item,\n  .embed-responsive iframe,\n  .embed-responsive embed,\n  .embed-responsive object,\n  .embed-responsive video {\n    position: absolute;\n    top: 0;\n    bottom: 0;\n    left: 0;\n    width: 100%;\n    height: 100%;\n    border: 0; }\n\n.embed-responsive-21by9::before {\n  padding-top: 42.85714%; }\n\n.embed-responsive-16by9::before {\n  padding-top: 56.25%; }\n\n.embed-responsive-4by3::before {\n  padding-top: 75%; }\n\n.embed-responsive-1by1::before {\n  padding-top: 100%; }\n\n.flex-row {\n  flex-direction: row !important; }\n\n.flex-column {\n  flex-direction: column !important; }\n\n.flex-row-reverse {\n  flex-direction: row-reverse !important; }\n\n.flex-column-reverse {\n  flex-direction: column-reverse !important; }\n\n.flex-wrap {\n  flex-wrap: wrap !important; }\n\n.flex-nowrap {\n  flex-wrap: nowrap !important; }\n\n.flex-wrap-reverse {\n  flex-wrap: wrap-reverse !important; }\n\n.justify-content-start {\n  justify-content: flex-start !important; }\n\n.justify-content-end {\n  justify-content: flex-end !important; }\n\n.justify-content-center {\n  justify-content: center !important; }\n\n.justify-content-between {\n  justify-content: space-between !important; }\n\n.justify-content-around {\n  justify-content: space-around !important; }\n\n.align-items-start {\n  align-items: flex-start !important; }\n\n.align-items-end {\n  align-items: flex-end !important; }\n\n.align-items-center {\n  align-items: center !important; }\n\n.align-items-baseline {\n  align-items: baseline !important; }\n\n.align-items-stretch {\n  align-items: stretch !important; }\n\n.align-content-start {\n  align-content: flex-start !important; }\n\n.align-content-end {\n  align-content: flex-end !important; }\n\n.align-content-center {\n  align-content: center !important; }\n\n.align-content-between {\n  align-content: space-between !important; }\n\n.align-content-around {\n  align-content: space-around !important; }\n\n.align-content-stretch {\n  align-content: stretch !important; }\n\n.align-self-auto {\n  align-self: auto !important; }\n\n.align-self-start {\n  align-self: flex-start !important; }\n\n.align-self-end {\n  align-self: flex-end !important; }\n\n.align-self-center {\n  align-self: center !important; }\n\n.align-self-baseline {\n  align-self: baseline !important; }\n\n.align-self-stretch {\n  align-self: stretch !important; }\n\n@media (min-width: 576px) {\n  .flex-sm-row {\n    flex-direction: row !important; }\n  .flex-sm-column {\n    flex-direction: column !important; }\n  .flex-sm-row-reverse {\n    flex-direction: row-reverse !important; }\n  .flex-sm-column-reverse {\n    flex-direction: column-reverse !important; }\n  .flex-sm-wrap {\n    flex-wrap: wrap !important; }\n  .flex-sm-nowrap {\n    flex-wrap: nowrap !important; }\n  .flex-sm-wrap-reverse {\n    flex-wrap: wrap-reverse !important; }\n  .justify-content-sm-start {\n    justify-content: flex-start !important; }\n  .justify-content-sm-end {\n    justify-content: flex-end !important; }\n  .justify-content-sm-center {\n    justify-content: center !important; }\n  .justify-content-sm-between {\n    justify-content: space-between !important; }\n  .justify-content-sm-around {\n    justify-content: space-around !important; }\n  .align-items-sm-start {\n    align-items: flex-start !important; }\n  .align-items-sm-end {\n    align-items: flex-end !important; }\n  .align-items-sm-center {\n    align-items: center !important; }\n  .align-items-sm-baseline {\n    align-items: baseline !important; }\n  .align-items-sm-stretch {\n    align-items: stretch !important; }\n  .align-content-sm-start {\n    align-content: flex-start !important; }\n  .align-content-sm-end {\n    align-content: flex-end !important; }\n  .align-content-sm-center {\n    align-content: center !important; }\n  .align-content-sm-between {\n    align-content: space-between !important; }\n  .align-content-sm-around {\n    align-content: space-around !important; }\n  .align-content-sm-stretch {\n    align-content: stretch !important; }\n  .align-self-sm-auto {\n    align-self: auto !important; }\n  .align-self-sm-start {\n    align-self: flex-start !important; }\n  .align-self-sm-end {\n    align-self: flex-end !important; }\n  .align-self-sm-center {\n    align-self: center !important; }\n  .align-self-sm-baseline {\n    align-self: baseline !important; }\n  .align-self-sm-stretch {\n    align-self: stretch !important; } }\n\n@media (min-width: 768px) {\n  .flex-md-row {\n    flex-direction: row !important; }\n  .flex-md-column {\n    flex-direction: column !important; }\n  .flex-md-row-reverse {\n    flex-direction: row-reverse !important; }\n  .flex-md-column-reverse {\n    flex-direction: column-reverse !important; }\n  .flex-md-wrap {\n    flex-wrap: wrap !important; }\n  .flex-md-nowrap {\n    flex-wrap: nowrap !important; }\n  .flex-md-wrap-reverse {\n    flex-wrap: wrap-reverse !important; }\n  .justify-content-md-start {\n    justify-content: flex-start !important; }\n  .justify-content-md-end {\n    justify-content: flex-end !important; }\n  .justify-content-md-center {\n    justify-content: center !important; }\n  .justify-content-md-between {\n    justify-content: space-between !important; }\n  .justify-content-md-around {\n    justify-content: space-around !important; }\n  .align-items-md-start {\n    align-items: flex-start !important; }\n  .align-items-md-end {\n    align-items: flex-end !important; }\n  .align-items-md-center {\n    align-items: center !important; }\n  .align-items-md-baseline {\n    align-items: baseline !important; }\n  .align-items-md-stretch {\n    align-items: stretch !important; }\n  .align-content-md-start {\n    align-content: flex-start !important; }\n  .align-content-md-end {\n    align-content: flex-end !important; }\n  .align-content-md-center {\n    align-content: center !important; }\n  .align-content-md-between {\n    align-content: space-between !important; }\n  .align-content-md-around {\n    align-content: space-around !important; }\n  .align-content-md-stretch {\n    align-content: stretch !important; }\n  .align-self-md-auto {\n    align-self: auto !important; }\n  .align-self-md-start {\n    align-self: flex-start !important; }\n  .align-self-md-end {\n    align-self: flex-end !important; }\n  .align-self-md-center {\n    align-self: center !important; }\n  .align-self-md-baseline {\n    align-self: baseline !important; }\n  .align-self-md-stretch {\n    align-self: stretch !important; } }\n\n@media (min-width: 992px) {\n  .flex-lg-row {\n    flex-direction: row !important; }\n  .flex-lg-column {\n    flex-direction: column !important; }\n  .flex-lg-row-reverse {\n    flex-direction: row-reverse !important; }\n  .flex-lg-column-reverse {\n    flex-direction: column-reverse !important; }\n  .flex-lg-wrap {\n    flex-wrap: wrap !important; }\n  .flex-lg-nowrap {\n    flex-wrap: nowrap !important; }\n  .flex-lg-wrap-reverse {\n    flex-wrap: wrap-reverse !important; }\n  .justify-content-lg-start {\n    justify-content: flex-start !important; }\n  .justify-content-lg-end {\n    justify-content: flex-end !important; }\n  .justify-content-lg-center {\n    justify-content: center !important; }\n  .justify-content-lg-between {\n    justify-content: space-between !important; }\n  .justify-content-lg-around {\n    justify-content: space-around !important; }\n  .align-items-lg-start {\n    align-items: flex-start !important; }\n  .align-items-lg-end {\n    align-items: flex-end !important; }\n  .align-items-lg-center {\n    align-items: center !important; }\n  .align-items-lg-baseline {\n    align-items: baseline !important; }\n  .align-items-lg-stretch {\n    align-items: stretch !important; }\n  .align-content-lg-start {\n    align-content: flex-start !important; }\n  .align-content-lg-end {\n    align-content: flex-end !important; }\n  .align-content-lg-center {\n    align-content: center !important; }\n  .align-content-lg-between {\n    align-content: space-between !important; }\n  .align-content-lg-around {\n    align-content: space-around !important; }\n  .align-content-lg-stretch {\n    align-content: stretch !important; }\n  .align-self-lg-auto {\n    align-self: auto !important; }\n  .align-self-lg-start {\n    align-self: flex-start !important; }\n  .align-self-lg-end {\n    align-self: flex-end !important; }\n  .align-self-lg-center {\n    align-self: center !important; }\n  .align-self-lg-baseline {\n    align-self: baseline !important; }\n  .align-self-lg-stretch {\n    align-self: stretch !important; } }\n\n@media (min-width: 1200px) {\n  .flex-xl-row {\n    flex-direction: row !important; }\n  .flex-xl-column {\n    flex-direction: column !important; }\n  .flex-xl-row-reverse {\n    flex-direction: row-reverse !important; }\n  .flex-xl-column-reverse {\n    flex-direction: column-reverse !important; }\n  .flex-xl-wrap {\n    flex-wrap: wrap !important; }\n  .flex-xl-nowrap {\n    flex-wrap: nowrap !important; }\n  .flex-xl-wrap-reverse {\n    flex-wrap: wrap-reverse !important; }\n  .justify-content-xl-start {\n    justify-content: flex-start !important; }\n  .justify-content-xl-end {\n    justify-content: flex-end !important; }\n  .justify-content-xl-center {\n    justify-content: center !important; }\n  .justify-content-xl-between {\n    justify-content: space-between !important; }\n  .justify-content-xl-around {\n    justify-content: space-around !important; }\n  .align-items-xl-start {\n    align-items: flex-start !important; }\n  .align-items-xl-end {\n    align-items: flex-end !important; }\n  .align-items-xl-center {\n    align-items: center !important; }\n  .align-items-xl-baseline {\n    align-items: baseline !important; }\n  .align-items-xl-stretch {\n    align-items: stretch !important; }\n  .align-content-xl-start {\n    align-content: flex-start !important; }\n  .align-content-xl-end {\n    align-content: flex-end !important; }\n  .align-content-xl-center {\n    align-content: center !important; }\n  .align-content-xl-between {\n    align-content: space-between !important; }\n  .align-content-xl-around {\n    align-content: space-around !important; }\n  .align-content-xl-stretch {\n    align-content: stretch !important; }\n  .align-self-xl-auto {\n    align-self: auto !important; }\n  .align-self-xl-start {\n    align-self: flex-start !important; }\n  .align-self-xl-end {\n    align-self: flex-end !important; }\n  .align-self-xl-center {\n    align-self: center !important; }\n  .align-self-xl-baseline {\n    align-self: baseline !important; }\n  .align-self-xl-stretch {\n    align-self: stretch !important; } }\n\n@media (min-width: 1440px) {\n  .flex-xxl-row {\n    flex-direction: row !important; }\n  .flex-xxl-column {\n    flex-direction: column !important; }\n  .flex-xxl-row-reverse {\n    flex-direction: row-reverse !important; }\n  .flex-xxl-column-reverse {\n    flex-direction: column-reverse !important; }\n  .flex-xxl-wrap {\n    flex-wrap: wrap !important; }\n  .flex-xxl-nowrap {\n    flex-wrap: nowrap !important; }\n  .flex-xxl-wrap-reverse {\n    flex-wrap: wrap-reverse !important; }\n  .justify-content-xxl-start {\n    justify-content: flex-start !important; }\n  .justify-content-xxl-end {\n    justify-content: flex-end !important; }\n  .justify-content-xxl-center {\n    justify-content: center !important; }\n  .justify-content-xxl-between {\n    justify-content: space-between !important; }\n  .justify-content-xxl-around {\n    justify-content: space-around !important; }\n  .align-items-xxl-start {\n    align-items: flex-start !important; }\n  .align-items-xxl-end {\n    align-items: flex-end !important; }\n  .align-items-xxl-center {\n    align-items: center !important; }\n  .align-items-xxl-baseline {\n    align-items: baseline !important; }\n  .align-items-xxl-stretch {\n    align-items: stretch !important; }\n  .align-content-xxl-start {\n    align-content: flex-start !important; }\n  .align-content-xxl-end {\n    align-content: flex-end !important; }\n  .align-content-xxl-center {\n    align-content: center !important; }\n  .align-content-xxl-between {\n    align-content: space-between !important; }\n  .align-content-xxl-around {\n    align-content: space-around !important; }\n  .align-content-xxl-stretch {\n    align-content: stretch !important; }\n  .align-self-xxl-auto {\n    align-self: auto !important; }\n  .align-self-xxl-start {\n    align-self: flex-start !important; }\n  .align-self-xxl-end {\n    align-self: flex-end !important; }\n  .align-self-xxl-center {\n    align-self: center !important; }\n  .align-self-xxl-baseline {\n    align-self: baseline !important; }\n  .align-self-xxl-stretch {\n    align-self: stretch !important; } }\n\n.float-left {\n  float: left !important; }\n\n.float-right {\n  float: right !important; }\n\n.float-none {\n  float: none !important; }\n\n@media (min-width: 576px) {\n  .float-sm-left {\n    float: left !important; }\n  .float-sm-right {\n    float: right !important; }\n  .float-sm-none {\n    float: none !important; } }\n\n@media (min-width: 768px) {\n  .float-md-left {\n    float: left !important; }\n  .float-md-right {\n    float: right !important; }\n  .float-md-none {\n    float: none !important; } }\n\n@media (min-width: 992px) {\n  .float-lg-left {\n    float: left !important; }\n  .float-lg-right {\n    float: right !important; }\n  .float-lg-none {\n    float: none !important; } }\n\n@media (min-width: 1200px) {\n  .float-xl-left {\n    float: left !important; }\n  .float-xl-right {\n    float: right !important; }\n  .float-xl-none {\n    float: none !important; } }\n\n@media (min-width: 1440px) {\n  .float-xxl-left {\n    float: left !important; }\n  .float-xxl-right {\n    float: right !important; }\n  .float-xxl-none {\n    float: none !important; } }\n\n.position-static {\n  position: static !important; }\n\n.position-relative {\n  position: relative !important; }\n\n.position-absolute {\n  position: absolute !important; }\n\n.position-fixed {\n  position: fixed !important; }\n\n.position-sticky {\n  position: sticky !important; }\n\n.fixed-top {\n  position: fixed;\n  top: 0;\n  right: 0;\n  left: 0;\n  z-index: 1030; }\n\n.fixed-bottom {\n  position: fixed;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 1030; }\n\n@supports (position: sticky) {\n  .sticky-top {\n    position: sticky;\n    top: 0;\n    z-index: 1020; } }\n\n.sr-only {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  padding: 0;\n  overflow: hidden;\n  clip: rect(0, 0, 0, 0);\n  white-space: nowrap;\n  clip-path: inset(50%);\n  border: 0; }\n\n.sr-only-focusable:active, .sr-only-focusable:focus {\n  position: static;\n  width: auto;\n  height: auto;\n  overflow: visible;\n  clip: auto;\n  white-space: normal;\n  clip-path: none; }\n\n.w-25 {\n  width: 25% !important; }\n\n.w-50 {\n  width: 50% !important; }\n\n.w-75 {\n  width: 75% !important; }\n\n.w-100 {\n  width: 100% !important; }\n\n.h-25 {\n  height: 25% !important; }\n\n.h-50 {\n  height: 50% !important; }\n\n.h-75 {\n  height: 75% !important; }\n\n.h-100 {\n  height: 100% !important; }\n\n.mw-100 {\n  max-width: 100% !important; }\n\n.mh-100 {\n  max-height: 100% !important; }\n\n.m-0 {\n  margin: 0 !important; }\n\n.mt-0,\n.my-0 {\n  margin-top: 0 !important; }\n\n.mr-0,\n.mx-0 {\n  margin-right: 0 !important; }\n\n.mb-0,\n.my-0 {\n  margin-bottom: 0 !important; }\n\n.ml-0,\n.mx-0 {\n  margin-left: 0 !important; }\n\n.m-1 {\n  margin: 0.25rem !important; }\n\n.mt-1,\n.my-1 {\n  margin-top: 0.25rem !important; }\n\n.mr-1,\n.mx-1 {\n  margin-right: 0.25rem !important; }\n\n.mb-1,\n.my-1 {\n  margin-bottom: 0.25rem !important; }\n\n.ml-1,\n.mx-1 {\n  margin-left: 0.25rem !important; }\n\n.m-2 {\n  margin: 0.5rem !important; }\n\n.mt-2,\n.my-2 {\n  margin-top: 0.5rem !important; }\n\n.mr-2,\n.mx-2 {\n  margin-right: 0.5rem !important; }\n\n.mb-2,\n.my-2 {\n  margin-bottom: 0.5rem !important; }\n\n.ml-2,\n.mx-2 {\n  margin-left: 0.5rem !important; }\n\n.m-3 {\n  margin: 1rem !important; }\n\n.mt-3,\n.my-3 {\n  margin-top: 1rem !important; }\n\n.mr-3,\n.mx-3 {\n  margin-right: 1rem !important; }\n\n.mb-3,\n.my-3 {\n  margin-bottom: 1rem !important; }\n\n.ml-3,\n.mx-3 {\n  margin-left: 1rem !important; }\n\n.m-4 {\n  margin: 1.5rem !important; }\n\n.mt-4,\n.my-4 {\n  margin-top: 1.5rem !important; }\n\n.mr-4,\n.mx-4 {\n  margin-right: 1.5rem !important; }\n\n.mb-4,\n.my-4 {\n  margin-bottom: 1.5rem !important; }\n\n.ml-4,\n.mx-4 {\n  margin-left: 1.5rem !important; }\n\n.m-5 {\n  margin: 3rem !important; }\n\n.mt-5,\n.my-5 {\n  margin-top: 3rem !important; }\n\n.mr-5,\n.mx-5 {\n  margin-right: 3rem !important; }\n\n.mb-5,\n.my-5 {\n  margin-bottom: 3rem !important; }\n\n.ml-5,\n.mx-5 {\n  margin-left: 3rem !important; }\n\n.p-0 {\n  padding: 0 !important; }\n\n.pt-0,\n.py-0 {\n  padding-top: 0 !important; }\n\n.pr-0,\n.px-0 {\n  padding-right: 0 !important; }\n\n.pb-0,\n.py-0 {\n  padding-bottom: 0 !important; }\n\n.pl-0,\n.px-0 {\n  padding-left: 0 !important; }\n\n.p-1 {\n  padding: 0.25rem !important; }\n\n.pt-1,\n.py-1 {\n  padding-top: 0.25rem !important; }\n\n.pr-1,\n.px-1 {\n  padding-right: 0.25rem !important; }\n\n.pb-1,\n.py-1 {\n  padding-bottom: 0.25rem !important; }\n\n.pl-1,\n.px-1 {\n  padding-left: 0.25rem !important; }\n\n.p-2 {\n  padding: 0.5rem !important; }\n\n.pt-2,\n.py-2 {\n  padding-top: 0.5rem !important; }\n\n.pr-2,\n.px-2 {\n  padding-right: 0.5rem !important; }\n\n.pb-2,\n.py-2 {\n  padding-bottom: 0.5rem !important; }\n\n.pl-2,\n.px-2 {\n  padding-left: 0.5rem !important; }\n\n.p-3 {\n  padding: 1rem !important; }\n\n.pt-3,\n.py-3 {\n  padding-top: 1rem !important; }\n\n.pr-3,\n.px-3 {\n  padding-right: 1rem !important; }\n\n.pb-3,\n.py-3 {\n  padding-bottom: 1rem !important; }\n\n.pl-3,\n.px-3 {\n  padding-left: 1rem !important; }\n\n.p-4 {\n  padding: 1.5rem !important; }\n\n.pt-4,\n.py-4 {\n  padding-top: 1.5rem !important; }\n\n.pr-4,\n.px-4 {\n  padding-right: 1.5rem !important; }\n\n.pb-4,\n.py-4 {\n  padding-bottom: 1.5rem !important; }\n\n.pl-4,\n.px-4 {\n  padding-left: 1.5rem !important; }\n\n.p-5 {\n  padding: 3rem !important; }\n\n.pt-5,\n.py-5 {\n  padding-top: 3rem !important; }\n\n.pr-5,\n.px-5 {\n  padding-right: 3rem !important; }\n\n.pb-5,\n.py-5 {\n  padding-bottom: 3rem !important; }\n\n.pl-5,\n.px-5 {\n  padding-left: 3rem !important; }\n\n.m-auto {\n  margin: auto !important; }\n\n.mt-auto,\n.my-auto {\n  margin-top: auto !important; }\n\n.mr-auto,\n.mx-auto {\n  margin-right: auto !important; }\n\n.mb-auto,\n.my-auto {\n  margin-bottom: auto !important; }\n\n.ml-auto,\n.mx-auto {\n  margin-left: auto !important; }\n\n@media (min-width: 576px) {\n  .m-sm-0 {\n    margin: 0 !important; }\n  .mt-sm-0,\n  .my-sm-0 {\n    margin-top: 0 !important; }\n  .mr-sm-0,\n  .mx-sm-0 {\n    margin-right: 0 !important; }\n  .mb-sm-0,\n  .my-sm-0 {\n    margin-bottom: 0 !important; }\n  .ml-sm-0,\n  .mx-sm-0 {\n    margin-left: 0 !important; }\n  .m-sm-1 {\n    margin: 0.25rem !important; }\n  .mt-sm-1,\n  .my-sm-1 {\n    margin-top: 0.25rem !important; }\n  .mr-sm-1,\n  .mx-sm-1 {\n    margin-right: 0.25rem !important; }\n  .mb-sm-1,\n  .my-sm-1 {\n    margin-bottom: 0.25rem !important; }\n  .ml-sm-1,\n  .mx-sm-1 {\n    margin-left: 0.25rem !important; }\n  .m-sm-2 {\n    margin: 0.5rem !important; }\n  .mt-sm-2,\n  .my-sm-2 {\n    margin-top: 0.5rem !important; }\n  .mr-sm-2,\n  .mx-sm-2 {\n    margin-right: 0.5rem !important; }\n  .mb-sm-2,\n  .my-sm-2 {\n    margin-bottom: 0.5rem !important; }\n  .ml-sm-2,\n  .mx-sm-2 {\n    margin-left: 0.5rem !important; }\n  .m-sm-3 {\n    margin: 1rem !important; }\n  .mt-sm-3,\n  .my-sm-3 {\n    margin-top: 1rem !important; }\n  .mr-sm-3,\n  .mx-sm-3 {\n    margin-right: 1rem !important; }\n  .mb-sm-3,\n  .my-sm-3 {\n    margin-bottom: 1rem !important; }\n  .ml-sm-3,\n  .mx-sm-3 {\n    margin-left: 1rem !important; }\n  .m-sm-4 {\n    margin: 1.5rem !important; }\n  .mt-sm-4,\n  .my-sm-4 {\n    margin-top: 1.5rem !important; }\n  .mr-sm-4,\n  .mx-sm-4 {\n    margin-right: 1.5rem !important; }\n  .mb-sm-4,\n  .my-sm-4 {\n    margin-bottom: 1.5rem !important; }\n  .ml-sm-4,\n  .mx-sm-4 {\n    margin-left: 1.5rem !important; }\n  .m-sm-5 {\n    margin: 3rem !important; }\n  .mt-sm-5,\n  .my-sm-5 {\n    margin-top: 3rem !important; }\n  .mr-sm-5,\n  .mx-sm-5 {\n    margin-right: 3rem !important; }\n  .mb-sm-5,\n  .my-sm-5 {\n    margin-bottom: 3rem !important; }\n  .ml-sm-5,\n  .mx-sm-5 {\n    margin-left: 3rem !important; }\n  .p-sm-0 {\n    padding: 0 !important; }\n  .pt-sm-0,\n  .py-sm-0 {\n    padding-top: 0 !important; }\n  .pr-sm-0,\n  .px-sm-0 {\n    padding-right: 0 !important; }\n  .pb-sm-0,\n  .py-sm-0 {\n    padding-bottom: 0 !important; }\n  .pl-sm-0,\n  .px-sm-0 {\n    padding-left: 0 !important; }\n  .p-sm-1 {\n    padding: 0.25rem !important; }\n  .pt-sm-1,\n  .py-sm-1 {\n    padding-top: 0.25rem !important; }\n  .pr-sm-1,\n  .px-sm-1 {\n    padding-right: 0.25rem !important; }\n  .pb-sm-1,\n  .py-sm-1 {\n    padding-bottom: 0.25rem !important; }\n  .pl-sm-1,\n  .px-sm-1 {\n    padding-left: 0.25rem !important; }\n  .p-sm-2 {\n    padding: 0.5rem !important; }\n  .pt-sm-2,\n  .py-sm-2 {\n    padding-top: 0.5rem !important; }\n  .pr-sm-2,\n  .px-sm-2 {\n    padding-right: 0.5rem !important; }\n  .pb-sm-2,\n  .py-sm-2 {\n    padding-bottom: 0.5rem !important; }\n  .pl-sm-2,\n  .px-sm-2 {\n    padding-left: 0.5rem !important; }\n  .p-sm-3 {\n    padding: 1rem !important; }\n  .pt-sm-3,\n  .py-sm-3 {\n    padding-top: 1rem !important; }\n  .pr-sm-3,\n  .px-sm-3 {\n    padding-right: 1rem !important; }\n  .pb-sm-3,\n  .py-sm-3 {\n    padding-bottom: 1rem !important; }\n  .pl-sm-3,\n  .px-sm-3 {\n    padding-left: 1rem !important; }\n  .p-sm-4 {\n    padding: 1.5rem !important; }\n  .pt-sm-4,\n  .py-sm-4 {\n    padding-top: 1.5rem !important; }\n  .pr-sm-4,\n  .px-sm-4 {\n    padding-right: 1.5rem !important; }\n  .pb-sm-4,\n  .py-sm-4 {\n    padding-bottom: 1.5rem !important; }\n  .pl-sm-4,\n  .px-sm-4 {\n    padding-left: 1.5rem !important; }\n  .p-sm-5 {\n    padding: 3rem !important; }\n  .pt-sm-5,\n  .py-sm-5 {\n    padding-top: 3rem !important; }\n  .pr-sm-5,\n  .px-sm-5 {\n    padding-right: 3rem !important; }\n  .pb-sm-5,\n  .py-sm-5 {\n    padding-bottom: 3rem !important; }\n  .pl-sm-5,\n  .px-sm-5 {\n    padding-left: 3rem !important; }\n  .m-sm-auto {\n    margin: auto !important; }\n  .mt-sm-auto,\n  .my-sm-auto {\n    margin-top: auto !important; }\n  .mr-sm-auto,\n  .mx-sm-auto {\n    margin-right: auto !important; }\n  .mb-sm-auto,\n  .my-sm-auto {\n    margin-bottom: auto !important; }\n  .ml-sm-auto,\n  .mx-sm-auto {\n    margin-left: auto !important; } }\n\n@media (min-width: 768px) {\n  .m-md-0 {\n    margin: 0 !important; }\n  .mt-md-0,\n  .my-md-0 {\n    margin-top: 0 !important; }\n  .mr-md-0,\n  .mx-md-0 {\n    margin-right: 0 !important; }\n  .mb-md-0,\n  .my-md-0 {\n    margin-bottom: 0 !important; }\n  .ml-md-0,\n  .mx-md-0 {\n    margin-left: 0 !important; }\n  .m-md-1 {\n    margin: 0.25rem !important; }\n  .mt-md-1,\n  .my-md-1 {\n    margin-top: 0.25rem !important; }\n  .mr-md-1,\n  .mx-md-1 {\n    margin-right: 0.25rem !important; }\n  .mb-md-1,\n  .my-md-1 {\n    margin-bottom: 0.25rem !important; }\n  .ml-md-1,\n  .mx-md-1 {\n    margin-left: 0.25rem !important; }\n  .m-md-2 {\n    margin: 0.5rem !important; }\n  .mt-md-2,\n  .my-md-2 {\n    margin-top: 0.5rem !important; }\n  .mr-md-2,\n  .mx-md-2 {\n    margin-right: 0.5rem !important; }\n  .mb-md-2,\n  .my-md-2 {\n    margin-bottom: 0.5rem !important; }\n  .ml-md-2,\n  .mx-md-2 {\n    margin-left: 0.5rem !important; }\n  .m-md-3 {\n    margin: 1rem !important; }\n  .mt-md-3,\n  .my-md-3 {\n    margin-top: 1rem !important; }\n  .mr-md-3,\n  .mx-md-3 {\n    margin-right: 1rem !important; }\n  .mb-md-3,\n  .my-md-3 {\n    margin-bottom: 1rem !important; }\n  .ml-md-3,\n  .mx-md-3 {\n    margin-left: 1rem !important; }\n  .m-md-4 {\n    margin: 1.5rem !important; }\n  .mt-md-4,\n  .my-md-4 {\n    margin-top: 1.5rem !important; }\n  .mr-md-4,\n  .mx-md-4 {\n    margin-right: 1.5rem !important; }\n  .mb-md-4,\n  .my-md-4 {\n    margin-bottom: 1.5rem !important; }\n  .ml-md-4,\n  .mx-md-4 {\n    margin-left: 1.5rem !important; }\n  .m-md-5 {\n    margin: 3rem !important; }\n  .mt-md-5,\n  .my-md-5 {\n    margin-top: 3rem !important; }\n  .mr-md-5,\n  .mx-md-5 {\n    margin-right: 3rem !important; }\n  .mb-md-5,\n  .my-md-5 {\n    margin-bottom: 3rem !important; }\n  .ml-md-5,\n  .mx-md-5 {\n    margin-left: 3rem !important; }\n  .p-md-0 {\n    padding: 0 !important; }\n  .pt-md-0,\n  .py-md-0 {\n    padding-top: 0 !important; }\n  .pr-md-0,\n  .px-md-0 {\n    padding-right: 0 !important; }\n  .pb-md-0,\n  .py-md-0 {\n    padding-bottom: 0 !important; }\n  .pl-md-0,\n  .px-md-0 {\n    padding-left: 0 !important; }\n  .p-md-1 {\n    padding: 0.25rem !important; }\n  .pt-md-1,\n  .py-md-1 {\n    padding-top: 0.25rem !important; }\n  .pr-md-1,\n  .px-md-1 {\n    padding-right: 0.25rem !important; }\n  .pb-md-1,\n  .py-md-1 {\n    padding-bottom: 0.25rem !important; }\n  .pl-md-1,\n  .px-md-1 {\n    padding-left: 0.25rem !important; }\n  .p-md-2 {\n    padding: 0.5rem !important; }\n  .pt-md-2,\n  .py-md-2 {\n    padding-top: 0.5rem !important; }\n  .pr-md-2,\n  .px-md-2 {\n    padding-right: 0.5rem !important; }\n  .pb-md-2,\n  .py-md-2 {\n    padding-bottom: 0.5rem !important; }\n  .pl-md-2,\n  .px-md-2 {\n    padding-left: 0.5rem !important; }\n  .p-md-3 {\n    padding: 1rem !important; }\n  .pt-md-3,\n  .py-md-3 {\n    padding-top: 1rem !important; }\n  .pr-md-3,\n  .px-md-3 {\n    padding-right: 1rem !important; }\n  .pb-md-3,\n  .py-md-3 {\n    padding-bottom: 1rem !important; }\n  .pl-md-3,\n  .px-md-3 {\n    padding-left: 1rem !important; }\n  .p-md-4 {\n    padding: 1.5rem !important; }\n  .pt-md-4,\n  .py-md-4 {\n    padding-top: 1.5rem !important; }\n  .pr-md-4,\n  .px-md-4 {\n    padding-right: 1.5rem !important; }\n  .pb-md-4,\n  .py-md-4 {\n    padding-bottom: 1.5rem !important; }\n  .pl-md-4,\n  .px-md-4 {\n    padding-left: 1.5rem !important; }\n  .p-md-5 {\n    padding: 3rem !important; }\n  .pt-md-5,\n  .py-md-5 {\n    padding-top: 3rem !important; }\n  .pr-md-5,\n  .px-md-5 {\n    padding-right: 3rem !important; }\n  .pb-md-5,\n  .py-md-5 {\n    padding-bottom: 3rem !important; }\n  .pl-md-5,\n  .px-md-5 {\n    padding-left: 3rem !important; }\n  .m-md-auto {\n    margin: auto !important; }\n  .mt-md-auto,\n  .my-md-auto {\n    margin-top: auto !important; }\n  .mr-md-auto,\n  .mx-md-auto {\n    margin-right: auto !important; }\n  .mb-md-auto,\n  .my-md-auto {\n    margin-bottom: auto !important; }\n  .ml-md-auto,\n  .mx-md-auto {\n    margin-left: auto !important; } }\n\n@media (min-width: 992px) {\n  .m-lg-0 {\n    margin: 0 !important; }\n  .mt-lg-0,\n  .my-lg-0 {\n    margin-top: 0 !important; }\n  .mr-lg-0,\n  .mx-lg-0 {\n    margin-right: 0 !important; }\n  .mb-lg-0,\n  .my-lg-0 {\n    margin-bottom: 0 !important; }\n  .ml-lg-0,\n  .mx-lg-0 {\n    margin-left: 0 !important; }\n  .m-lg-1 {\n    margin: 0.25rem !important; }\n  .mt-lg-1,\n  .my-lg-1 {\n    margin-top: 0.25rem !important; }\n  .mr-lg-1,\n  .mx-lg-1 {\n    margin-right: 0.25rem !important; }\n  .mb-lg-1,\n  .my-lg-1 {\n    margin-bottom: 0.25rem !important; }\n  .ml-lg-1,\n  .mx-lg-1 {\n    margin-left: 0.25rem !important; }\n  .m-lg-2 {\n    margin: 0.5rem !important; }\n  .mt-lg-2,\n  .my-lg-2 {\n    margin-top: 0.5rem !important; }\n  .mr-lg-2,\n  .mx-lg-2 {\n    margin-right: 0.5rem !important; }\n  .mb-lg-2,\n  .my-lg-2 {\n    margin-bottom: 0.5rem !important; }\n  .ml-lg-2,\n  .mx-lg-2 {\n    margin-left: 0.5rem !important; }\n  .m-lg-3 {\n    margin: 1rem !important; }\n  .mt-lg-3,\n  .my-lg-3 {\n    margin-top: 1rem !important; }\n  .mr-lg-3,\n  .mx-lg-3 {\n    margin-right: 1rem !important; }\n  .mb-lg-3,\n  .my-lg-3 {\n    margin-bottom: 1rem !important; }\n  .ml-lg-3,\n  .mx-lg-3 {\n    margin-left: 1rem !important; }\n  .m-lg-4 {\n    margin: 1.5rem !important; }\n  .mt-lg-4,\n  .my-lg-4 {\n    margin-top: 1.5rem !important; }\n  .mr-lg-4,\n  .mx-lg-4 {\n    margin-right: 1.5rem !important; }\n  .mb-lg-4,\n  .my-lg-4 {\n    margin-bottom: 1.5rem !important; }\n  .ml-lg-4,\n  .mx-lg-4 {\n    margin-left: 1.5rem !important; }\n  .m-lg-5 {\n    margin: 3rem !important; }\n  .mt-lg-5,\n  .my-lg-5 {\n    margin-top: 3rem !important; }\n  .mr-lg-5,\n  .mx-lg-5 {\n    margin-right: 3rem !important; }\n  .mb-lg-5,\n  .my-lg-5 {\n    margin-bottom: 3rem !important; }\n  .ml-lg-5,\n  .mx-lg-5 {\n    margin-left: 3rem !important; }\n  .p-lg-0 {\n    padding: 0 !important; }\n  .pt-lg-0,\n  .py-lg-0 {\n    padding-top: 0 !important; }\n  .pr-lg-0,\n  .px-lg-0 {\n    padding-right: 0 !important; }\n  .pb-lg-0,\n  .py-lg-0 {\n    padding-bottom: 0 !important; }\n  .pl-lg-0,\n  .px-lg-0 {\n    padding-left: 0 !important; }\n  .p-lg-1 {\n    padding: 0.25rem !important; }\n  .pt-lg-1,\n  .py-lg-1 {\n    padding-top: 0.25rem !important; }\n  .pr-lg-1,\n  .px-lg-1 {\n    padding-right: 0.25rem !important; }\n  .pb-lg-1,\n  .py-lg-1 {\n    padding-bottom: 0.25rem !important; }\n  .pl-lg-1,\n  .px-lg-1 {\n    padding-left: 0.25rem !important; }\n  .p-lg-2 {\n    padding: 0.5rem !important; }\n  .pt-lg-2,\n  .py-lg-2 {\n    padding-top: 0.5rem !important; }\n  .pr-lg-2,\n  .px-lg-2 {\n    padding-right: 0.5rem !important; }\n  .pb-lg-2,\n  .py-lg-2 {\n    padding-bottom: 0.5rem !important; }\n  .pl-lg-2,\n  .px-lg-2 {\n    padding-left: 0.5rem !important; }\n  .p-lg-3 {\n    padding: 1rem !important; }\n  .pt-lg-3,\n  .py-lg-3 {\n    padding-top: 1rem !important; }\n  .pr-lg-3,\n  .px-lg-3 {\n    padding-right: 1rem !important; }\n  .pb-lg-3,\n  .py-lg-3 {\n    padding-bottom: 1rem !important; }\n  .pl-lg-3,\n  .px-lg-3 {\n    padding-left: 1rem !important; }\n  .p-lg-4 {\n    padding: 1.5rem !important; }\n  .pt-lg-4,\n  .py-lg-4 {\n    padding-top: 1.5rem !important; }\n  .pr-lg-4,\n  .px-lg-4 {\n    padding-right: 1.5rem !important; }\n  .pb-lg-4,\n  .py-lg-4 {\n    padding-bottom: 1.5rem !important; }\n  .pl-lg-4,\n  .px-lg-4 {\n    padding-left: 1.5rem !important; }\n  .p-lg-5 {\n    padding: 3rem !important; }\n  .pt-lg-5,\n  .py-lg-5 {\n    padding-top: 3rem !important; }\n  .pr-lg-5,\n  .px-lg-5 {\n    padding-right: 3rem !important; }\n  .pb-lg-5,\n  .py-lg-5 {\n    padding-bottom: 3rem !important; }\n  .pl-lg-5,\n  .px-lg-5 {\n    padding-left: 3rem !important; }\n  .m-lg-auto {\n    margin: auto !important; }\n  .mt-lg-auto,\n  .my-lg-auto {\n    margin-top: auto !important; }\n  .mr-lg-auto,\n  .mx-lg-auto {\n    margin-right: auto !important; }\n  .mb-lg-auto,\n  .my-lg-auto {\n    margin-bottom: auto !important; }\n  .ml-lg-auto,\n  .mx-lg-auto {\n    margin-left: auto !important; } }\n\n@media (min-width: 1200px) {\n  .m-xl-0 {\n    margin: 0 !important; }\n  .mt-xl-0,\n  .my-xl-0 {\n    margin-top: 0 !important; }\n  .mr-xl-0,\n  .mx-xl-0 {\n    margin-right: 0 !important; }\n  .mb-xl-0,\n  .my-xl-0 {\n    margin-bottom: 0 !important; }\n  .ml-xl-0,\n  .mx-xl-0 {\n    margin-left: 0 !important; }\n  .m-xl-1 {\n    margin: 0.25rem !important; }\n  .mt-xl-1,\n  .my-xl-1 {\n    margin-top: 0.25rem !important; }\n  .mr-xl-1,\n  .mx-xl-1 {\n    margin-right: 0.25rem !important; }\n  .mb-xl-1,\n  .my-xl-1 {\n    margin-bottom: 0.25rem !important; }\n  .ml-xl-1,\n  .mx-xl-1 {\n    margin-left: 0.25rem !important; }\n  .m-xl-2 {\n    margin: 0.5rem !important; }\n  .mt-xl-2,\n  .my-xl-2 {\n    margin-top: 0.5rem !important; }\n  .mr-xl-2,\n  .mx-xl-2 {\n    margin-right: 0.5rem !important; }\n  .mb-xl-2,\n  .my-xl-2 {\n    margin-bottom: 0.5rem !important; }\n  .ml-xl-2,\n  .mx-xl-2 {\n    margin-left: 0.5rem !important; }\n  .m-xl-3 {\n    margin: 1rem !important; }\n  .mt-xl-3,\n  .my-xl-3 {\n    margin-top: 1rem !important; }\n  .mr-xl-3,\n  .mx-xl-3 {\n    margin-right: 1rem !important; }\n  .mb-xl-3,\n  .my-xl-3 {\n    margin-bottom: 1rem !important; }\n  .ml-xl-3,\n  .mx-xl-3 {\n    margin-left: 1rem !important; }\n  .m-xl-4 {\n    margin: 1.5rem !important; }\n  .mt-xl-4,\n  .my-xl-4 {\n    margin-top: 1.5rem !important; }\n  .mr-xl-4,\n  .mx-xl-4 {\n    margin-right: 1.5rem !important; }\n  .mb-xl-4,\n  .my-xl-4 {\n    margin-bottom: 1.5rem !important; }\n  .ml-xl-4,\n  .mx-xl-4 {\n    margin-left: 1.5rem !important; }\n  .m-xl-5 {\n    margin: 3rem !important; }\n  .mt-xl-5,\n  .my-xl-5 {\n    margin-top: 3rem !important; }\n  .mr-xl-5,\n  .mx-xl-5 {\n    margin-right: 3rem !important; }\n  .mb-xl-5,\n  .my-xl-5 {\n    margin-bottom: 3rem !important; }\n  .ml-xl-5,\n  .mx-xl-5 {\n    margin-left: 3rem !important; }\n  .p-xl-0 {\n    padding: 0 !important; }\n  .pt-xl-0,\n  .py-xl-0 {\n    padding-top: 0 !important; }\n  .pr-xl-0,\n  .px-xl-0 {\n    padding-right: 0 !important; }\n  .pb-xl-0,\n  .py-xl-0 {\n    padding-bottom: 0 !important; }\n  .pl-xl-0,\n  .px-xl-0 {\n    padding-left: 0 !important; }\n  .p-xl-1 {\n    padding: 0.25rem !important; }\n  .pt-xl-1,\n  .py-xl-1 {\n    padding-top: 0.25rem !important; }\n  .pr-xl-1,\n  .px-xl-1 {\n    padding-right: 0.25rem !important; }\n  .pb-xl-1,\n  .py-xl-1 {\n    padding-bottom: 0.25rem !important; }\n  .pl-xl-1,\n  .px-xl-1 {\n    padding-left: 0.25rem !important; }\n  .p-xl-2 {\n    padding: 0.5rem !important; }\n  .pt-xl-2,\n  .py-xl-2 {\n    padding-top: 0.5rem !important; }\n  .pr-xl-2,\n  .px-xl-2 {\n    padding-right: 0.5rem !important; }\n  .pb-xl-2,\n  .py-xl-2 {\n    padding-bottom: 0.5rem !important; }\n  .pl-xl-2,\n  .px-xl-2 {\n    padding-left: 0.5rem !important; }\n  .p-xl-3 {\n    padding: 1rem !important; }\n  .pt-xl-3,\n  .py-xl-3 {\n    padding-top: 1rem !important; }\n  .pr-xl-3,\n  .px-xl-3 {\n    padding-right: 1rem !important; }\n  .pb-xl-3,\n  .py-xl-3 {\n    padding-bottom: 1rem !important; }\n  .pl-xl-3,\n  .px-xl-3 {\n    padding-left: 1rem !important; }\n  .p-xl-4 {\n    padding: 1.5rem !important; }\n  .pt-xl-4,\n  .py-xl-4 {\n    padding-top: 1.5rem !important; }\n  .pr-xl-4,\n  .px-xl-4 {\n    padding-right: 1.5rem !important; }\n  .pb-xl-4,\n  .py-xl-4 {\n    padding-bottom: 1.5rem !important; }\n  .pl-xl-4,\n  .px-xl-4 {\n    padding-left: 1.5rem !important; }\n  .p-xl-5 {\n    padding: 3rem !important; }\n  .pt-xl-5,\n  .py-xl-5 {\n    padding-top: 3rem !important; }\n  .pr-xl-5,\n  .px-xl-5 {\n    padding-right: 3rem !important; }\n  .pb-xl-5,\n  .py-xl-5 {\n    padding-bottom: 3rem !important; }\n  .pl-xl-5,\n  .px-xl-5 {\n    padding-left: 3rem !important; }\n  .m-xl-auto {\n    margin: auto !important; }\n  .mt-xl-auto,\n  .my-xl-auto {\n    margin-top: auto !important; }\n  .mr-xl-auto,\n  .mx-xl-auto {\n    margin-right: auto !important; }\n  .mb-xl-auto,\n  .my-xl-auto {\n    margin-bottom: auto !important; }\n  .ml-xl-auto,\n  .mx-xl-auto {\n    margin-left: auto !important; } }\n\n@media (min-width: 1440px) {\n  .m-xxl-0 {\n    margin: 0 !important; }\n  .mt-xxl-0,\n  .my-xxl-0 {\n    margin-top: 0 !important; }\n  .mr-xxl-0,\n  .mx-xxl-0 {\n    margin-right: 0 !important; }\n  .mb-xxl-0,\n  .my-xxl-0 {\n    margin-bottom: 0 !important; }\n  .ml-xxl-0,\n  .mx-xxl-0 {\n    margin-left: 0 !important; }\n  .m-xxl-1 {\n    margin: 0.25rem !important; }\n  .mt-xxl-1,\n  .my-xxl-1 {\n    margin-top: 0.25rem !important; }\n  .mr-xxl-1,\n  .mx-xxl-1 {\n    margin-right: 0.25rem !important; }\n  .mb-xxl-1,\n  .my-xxl-1 {\n    margin-bottom: 0.25rem !important; }\n  .ml-xxl-1,\n  .mx-xxl-1 {\n    margin-left: 0.25rem !important; }\n  .m-xxl-2 {\n    margin: 0.5rem !important; }\n  .mt-xxl-2,\n  .my-xxl-2 {\n    margin-top: 0.5rem !important; }\n  .mr-xxl-2,\n  .mx-xxl-2 {\n    margin-right: 0.5rem !important; }\n  .mb-xxl-2,\n  .my-xxl-2 {\n    margin-bottom: 0.5rem !important; }\n  .ml-xxl-2,\n  .mx-xxl-2 {\n    margin-left: 0.5rem !important; }\n  .m-xxl-3 {\n    margin: 1rem !important; }\n  .mt-xxl-3,\n  .my-xxl-3 {\n    margin-top: 1rem !important; }\n  .mr-xxl-3,\n  .mx-xxl-3 {\n    margin-right: 1rem !important; }\n  .mb-xxl-3,\n  .my-xxl-3 {\n    margin-bottom: 1rem !important; }\n  .ml-xxl-3,\n  .mx-xxl-3 {\n    margin-left: 1rem !important; }\n  .m-xxl-4 {\n    margin: 1.5rem !important; }\n  .mt-xxl-4,\n  .my-xxl-4 {\n    margin-top: 1.5rem !important; }\n  .mr-xxl-4,\n  .mx-xxl-4 {\n    margin-right: 1.5rem !important; }\n  .mb-xxl-4,\n  .my-xxl-4 {\n    margin-bottom: 1.5rem !important; }\n  .ml-xxl-4,\n  .mx-xxl-4 {\n    margin-left: 1.5rem !important; }\n  .m-xxl-5 {\n    margin: 3rem !important; }\n  .mt-xxl-5,\n  .my-xxl-5 {\n    margin-top: 3rem !important; }\n  .mr-xxl-5,\n  .mx-xxl-5 {\n    margin-right: 3rem !important; }\n  .mb-xxl-5,\n  .my-xxl-5 {\n    margin-bottom: 3rem !important; }\n  .ml-xxl-5,\n  .mx-xxl-5 {\n    margin-left: 3rem !important; }\n  .p-xxl-0 {\n    padding: 0 !important; }\n  .pt-xxl-0,\n  .py-xxl-0 {\n    padding-top: 0 !important; }\n  .pr-xxl-0,\n  .px-xxl-0 {\n    padding-right: 0 !important; }\n  .pb-xxl-0,\n  .py-xxl-0 {\n    padding-bottom: 0 !important; }\n  .pl-xxl-0,\n  .px-xxl-0 {\n    padding-left: 0 !important; }\n  .p-xxl-1 {\n    padding: 0.25rem !important; }\n  .pt-xxl-1,\n  .py-xxl-1 {\n    padding-top: 0.25rem !important; }\n  .pr-xxl-1,\n  .px-xxl-1 {\n    padding-right: 0.25rem !important; }\n  .pb-xxl-1,\n  .py-xxl-1 {\n    padding-bottom: 0.25rem !important; }\n  .pl-xxl-1,\n  .px-xxl-1 {\n    padding-left: 0.25rem !important; }\n  .p-xxl-2 {\n    padding: 0.5rem !important; }\n  .pt-xxl-2,\n  .py-xxl-2 {\n    padding-top: 0.5rem !important; }\n  .pr-xxl-2,\n  .px-xxl-2 {\n    padding-right: 0.5rem !important; }\n  .pb-xxl-2,\n  .py-xxl-2 {\n    padding-bottom: 0.5rem !important; }\n  .pl-xxl-2,\n  .px-xxl-2 {\n    padding-left: 0.5rem !important; }\n  .p-xxl-3 {\n    padding: 1rem !important; }\n  .pt-xxl-3,\n  .py-xxl-3 {\n    padding-top: 1rem !important; }\n  .pr-xxl-3,\n  .px-xxl-3 {\n    padding-right: 1rem !important; }\n  .pb-xxl-3,\n  .py-xxl-3 {\n    padding-bottom: 1rem !important; }\n  .pl-xxl-3,\n  .px-xxl-3 {\n    padding-left: 1rem !important; }\n  .p-xxl-4 {\n    padding: 1.5rem !important; }\n  .pt-xxl-4,\n  .py-xxl-4 {\n    padding-top: 1.5rem !important; }\n  .pr-xxl-4,\n  .px-xxl-4 {\n    padding-right: 1.5rem !important; }\n  .pb-xxl-4,\n  .py-xxl-4 {\n    padding-bottom: 1.5rem !important; }\n  .pl-xxl-4,\n  .px-xxl-4 {\n    padding-left: 1.5rem !important; }\n  .p-xxl-5 {\n    padding: 3rem !important; }\n  .pt-xxl-5,\n  .py-xxl-5 {\n    padding-top: 3rem !important; }\n  .pr-xxl-5,\n  .px-xxl-5 {\n    padding-right: 3rem !important; }\n  .pb-xxl-5,\n  .py-xxl-5 {\n    padding-bottom: 3rem !important; }\n  .pl-xxl-5,\n  .px-xxl-5 {\n    padding-left: 3rem !important; }\n  .m-xxl-auto {\n    margin: auto !important; }\n  .mt-xxl-auto,\n  .my-xxl-auto {\n    margin-top: auto !important; }\n  .mr-xxl-auto,\n  .mx-xxl-auto {\n    margin-right: auto !important; }\n  .mb-xxl-auto,\n  .my-xxl-auto {\n    margin-bottom: auto !important; }\n  .ml-xxl-auto,\n  .mx-xxl-auto {\n    margin-left: auto !important; } }\n\n.text-justify {\n  text-align: justify !important; }\n\n.text-nowrap {\n  white-space: nowrap !important; }\n\n.text-truncate {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap; }\n\n.text-left {\n  text-align: left !important; }\n\n.text-right {\n  text-align: right !important; }\n\n.text-center {\n  text-align: center !important; }\n\n@media (min-width: 576px) {\n  .text-sm-left {\n    text-align: left !important; }\n  .text-sm-right {\n    text-align: right !important; }\n  .text-sm-center {\n    text-align: center !important; } }\n\n@media (min-width: 768px) {\n  .text-md-left {\n    text-align: left !important; }\n  .text-md-right {\n    text-align: right !important; }\n  .text-md-center {\n    text-align: center !important; } }\n\n@media (min-width: 992px) {\n  .text-lg-left {\n    text-align: left !important; }\n  .text-lg-right {\n    text-align: right !important; }\n  .text-lg-center {\n    text-align: center !important; } }\n\n@media (min-width: 1200px) {\n  .text-xl-left {\n    text-align: left !important; }\n  .text-xl-right {\n    text-align: right !important; }\n  .text-xl-center {\n    text-align: center !important; } }\n\n@media (min-width: 1440px) {\n  .text-xxl-left {\n    text-align: left !important; }\n  .text-xxl-right {\n    text-align: right !important; }\n  .text-xxl-center {\n    text-align: center !important; } }\n\n.text-lowercase {\n  text-transform: lowercase !important; }\n\n.text-uppercase {\n  text-transform: uppercase !important; }\n\n.text-capitalize {\n  text-transform: capitalize !important; }\n\n.font-weight-light {\n  font-weight: 300 !important; }\n\n.font-weight-normal {\n  font-weight: 400 !important; }\n\n.font-weight-bold {\n  font-weight: 700 !important; }\n\n.font-italic {\n  font-style: italic !important; }\n\n.text-white {\n  color: #fff !important; }\n\n.text-primary {\n  color: #00acec !important; }\n\na.text-primary:hover, a.text-primary:focus {\n  color: #0087b9 !important; }\n\n.text-secondary {\n  color: #868e96 !important; }\n\na.text-secondary:hover, a.text-secondary:focus {\n  color: #6c757d !important; }\n\n.text-success {\n  color: #28a745 !important; }\n\na.text-success:hover, a.text-success:focus {\n  color: #1e7e34 !important; }\n\n.text-info {\n  color: #d50089 !important; }\n\na.text-info:hover, a.text-info:focus {\n  color: #a20068 !important; }\n\n.text-warning {\n  color: #ffc107 !important; }\n\na.text-warning:hover, a.text-warning:focus {\n  color: #d39e00 !important; }\n\n.text-danger {\n  color: #dc3545 !important; }\n\na.text-danger:hover, a.text-danger:focus {\n  color: #bd2130 !important; }\n\n.text-light {\n  color: #f8f9fa !important; }\n\na.text-light:hover, a.text-light:focus {\n  color: #dae0e5 !important; }\n\n.text-dark {\n  color: #343a40 !important; }\n\na.text-dark:hover, a.text-dark:focus {\n  color: #1d2124 !important; }\n\n.text-muted {\n  color: #868e96 !important; }\n\n.text-hide {\n  font: 0/0 a;\n  color: transparent;\n  text-shadow: none;\n  background-color: transparent;\n  border: 0; }\n\n.visible {\n  visibility: visible !important; }\n\n.invisible {\n  visibility: hidden !important; }\n\n@media print {\n  *,\n  *::before,\n  *::after {\n    text-shadow: none !important;\n    box-shadow: none !important; }\n  a:not(.btn) {\n    text-decoration: underline; }\n  abbr[title]::after {\n    content: \" (\" attr(title) \")\"; }\n  pre {\n    white-space: pre-wrap !important; }\n  pre,\n  blockquote {\n    border: 1px solid #999;\n    page-break-inside: avoid; }\n  thead {\n    display: table-header-group; }\n  tr,\n  img {\n    page-break-inside: avoid; }\n  p,\n  h2,\n  h3 {\n    orphans: 3;\n    widows: 3; }\n  h2,\n  h3 {\n    page-break-after: avoid; }\n  @page {\n    size: a3; }\n  body {\n    min-width: 992px !important; }\n  .container {\n    min-width: 992px !important; }\n  .navbar {\n    display: none; }\n  .badge {\n    border: 1px solid #000; }\n  .table {\n    border-collapse: collapse !important; }\n    .table td,\n    .table th {\n      background-color: #fff !important; }\n  .table-bordered th,\n  .table-bordered td {\n    border: 1px solid #ddd !important; } }\n\n.btn {\n  position: relative;\n  text-transform: uppercase;\n  letter-spacing: 0.04rem;\n  white-space: normal;\n  padding: 0.5rem 1rem;\n  font-size: 0.75rem;\n  line-height: 1.2rem;\n  border-radius: 0.1875rem;\n  transition: padding .2s ease-out; }\n  .btn.disabled, .btn:disabled {\n    opacity: .4;\n    cursor: not-allowed; }\n\n.btn-lg, .btn-group-lg > .btn {\n  padding: 0.5rem 1rem;\n  font-size: 1rem;\n  line-height: 1.5;\n  border-radius: 0.3rem; }\n\n.btn-sm, .btn-group-sm > .btn {\n  padding: 0.375rem 0.75rem;\n  font-size: 0.75rem;\n  line-height: 1.25;\n  border-radius: 0.125rem; }\n\n.btn-responsive {\n  padding: 0.375rem 0.75rem;\n  font-size: 0.75rem;\n  line-height: 1.25;\n  border-radius: 0.125rem; }\n  @media only screen and (min-width: 1440px) {\n    .btn-responsive {\n      padding: 0.5rem 1rem;\n      font-size: 0.75rem;\n      line-height: 1.2rem;\n      border-radius: 0.1875rem; } }\n\n.btn-outline-primary {\n  color: #00acec;\n  background-color: transparent;\n  background-image: none;\n  border-color: #00acec; }\n  .btn-outline-primary:hover {\n    color: #fff;\n    background-color: #00acec;\n    border-color: #00acec; }\n  .btn-outline-primary:focus, .btn-outline-primary.focus {\n    box-shadow: 0 0 0 0.2rem rgba(0, 172, 236, 0.5); }\n  .btn-outline-primary.disabled, .btn-outline-primary:disabled {\n    color: #00acec;\n    background-color: transparent;\n    opacity: .4;\n    cursor: not-allowed; }\n  .btn-outline-primary:not([disabled]):not(.disabled):active, .btn-outline-primary:not([disabled]):not(.disabled).active,\n  .show > .btn-outline-primary.dropdown-toggle {\n    color: #fff;\n    background-color: #00acec;\n    border-color: #00acec;\n    box-shadow: 0 0 0 0.2rem rgba(0, 172, 236, 0.5); }\n\n.btn-outline-secondary {\n  color: #868e96;\n  background-color: transparent;\n  background-image: none;\n  border-color: #868e96; }\n  .btn-outline-secondary:hover {\n    color: white;\n    background-color: #868e96;\n    border-color: #868e96; }\n  .btn-outline-secondary:focus, .btn-outline-secondary.focus {\n    box-shadow: 0 0 0 0.2rem rgba(134, 142, 150, 0.5); }\n  .btn-outline-secondary.disabled, .btn-outline-secondary:disabled {\n    color: #868e96;\n    background-color: transparent;\n    opacity: .4;\n    cursor: not-allowed; }\n  .btn-outline-secondary:not([disabled]):not(.disabled):active, .btn-outline-secondary:not([disabled]):not(.disabled).active,\n  .show > .btn-outline-secondary.dropdown-toggle {\n    color: white;\n    background-color: #868e96;\n    border-color: #868e96;\n    box-shadow: 0 0 0 0.2rem rgba(134, 142, 150, 0.5); }\n\n.btn-outline-success {\n  color: #28a745;\n  background-color: transparent;\n  background-image: none;\n  border-color: #28a745; }\n  .btn-outline-success:hover {\n    color: #fff;\n    background-color: #28a745;\n    border-color: #28a745; }\n  .btn-outline-success:focus, .btn-outline-success.focus {\n    box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.5); }\n  .btn-outline-success.disabled, .btn-outline-success:disabled {\n    color: #28a745;\n    background-color: transparent;\n    opacity: .4;\n    cursor: not-allowed; }\n  .btn-outline-success:not([disabled]):not(.disabled):active, .btn-outline-success:not([disabled]):not(.disabled).active,\n  .show > .btn-outline-success.dropdown-toggle {\n    color: #fff;\n    background-color: #28a745;\n    border-color: #28a745;\n    box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.5); }\n\n.btn-outline-info {\n  color: #d50089;\n  background-color: transparent;\n  background-image: none;\n  border-color: #d50089; }\n  .btn-outline-info:hover {\n    color: #fff;\n    background-color: #d50089;\n    border-color: #d50089; }\n  .btn-outline-info:focus, .btn-outline-info.focus {\n    box-shadow: 0 0 0 0.2rem rgba(213, 0, 137, 0.5); }\n  .btn-outline-info.disabled, .btn-outline-info:disabled {\n    color: #d50089;\n    background-color: transparent;\n    opacity: .4;\n    cursor: not-allowed; }\n  .btn-outline-info:not([disabled]):not(.disabled):active, .btn-outline-info:not([disabled]):not(.disabled).active,\n  .show > .btn-outline-info.dropdown-toggle {\n    color: #fff;\n    background-color: #d50089;\n    border-color: #d50089;\n    box-shadow: 0 0 0 0.2rem rgba(213, 0, 137, 0.5); }\n\n.btn-outline-warning {\n  color: #ffc107;\n  background-color: transparent;\n  background-image: none;\n  border-color: #ffc107; }\n  .btn-outline-warning:hover {\n    color: #fff;\n    background-color: #ffc107;\n    border-color: #ffc107; }\n  .btn-outline-warning:focus, .btn-outline-warning.focus {\n    box-shadow: 0 0 0 0.2rem rgba(255, 193, 7, 0.5); }\n  .btn-outline-warning.disabled, .btn-outline-warning:disabled {\n    color: #ffc107;\n    background-color: transparent;\n    opacity: .4;\n    cursor: not-allowed; }\n  .btn-outline-warning:not([disabled]):not(.disabled):active, .btn-outline-warning:not([disabled]):not(.disabled).active,\n  .show > .btn-outline-warning.dropdown-toggle {\n    color: #fff;\n    background-color: #ffc107;\n    border-color: #ffc107;\n    box-shadow: 0 0 0 0.2rem rgba(255, 193, 7, 0.5); }\n\n.btn-outline-danger {\n  color: #dc3545;\n  background-color: transparent;\n  background-image: none;\n  border-color: #dc3545; }\n  .btn-outline-danger:hover {\n    color: #fff;\n    background-color: #dc3545;\n    border-color: #dc3545; }\n  .btn-outline-danger:focus, .btn-outline-danger.focus {\n    box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.5); }\n  .btn-outline-danger.disabled, .btn-outline-danger:disabled {\n    color: #dc3545;\n    background-color: transparent;\n    opacity: .4;\n    cursor: not-allowed; }\n  .btn-outline-danger:not([disabled]):not(.disabled):active, .btn-outline-danger:not([disabled]):not(.disabled).active,\n  .show > .btn-outline-danger.dropdown-toggle {\n    color: #fff;\n    background-color: #dc3545;\n    border-color: #dc3545;\n    box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.5); }\n\n.btn-outline-light {\n  color: #f8f9fa;\n  background-color: transparent;\n  background-image: none;\n  border-color: #f8f9fa; }\n  .btn-outline-light:hover {\n    color: #212529;\n    background-color: #f8f9fa;\n    border-color: #f8f9fa; }\n  .btn-outline-light:focus, .btn-outline-light.focus {\n    box-shadow: 0 0 0 0.2rem rgba(248, 249, 250, 0.5); }\n  .btn-outline-light.disabled, .btn-outline-light:disabled {\n    color: #f8f9fa;\n    background-color: transparent;\n    opacity: .4;\n    cursor: not-allowed; }\n  .btn-outline-light:not([disabled]):not(.disabled):active, .btn-outline-light:not([disabled]):not(.disabled).active,\n  .show > .btn-outline-light.dropdown-toggle {\n    color: #212529;\n    background-color: #f8f9fa;\n    border-color: #f8f9fa;\n    box-shadow: 0 0 0 0.2rem rgba(248, 249, 250, 0.5); }\n\n.btn-outline-dark {\n  color: #343a40;\n  background-color: transparent;\n  background-image: none;\n  border-color: #343a40; }\n  .btn-outline-dark:hover {\n    color: #fff;\n    background-color: #343a40;\n    border-color: #343a40; }\n  .btn-outline-dark:focus, .btn-outline-dark.focus {\n    box-shadow: 0 0 0 0.2rem rgba(52, 58, 64, 0.5); }\n  .btn-outline-dark.disabled, .btn-outline-dark:disabled {\n    color: #343a40;\n    background-color: transparent;\n    opacity: .4;\n    cursor: not-allowed; }\n  .btn-outline-dark:not([disabled]):not(.disabled):active, .btn-outline-dark:not([disabled]):not(.disabled).active,\n  .show > .btn-outline-dark.dropdown-toggle {\n    color: #fff;\n    background-color: #343a40;\n    border-color: #343a40;\n    box-shadow: 0 0 0 0.2rem rgba(52, 58, 64, 0.5); }\n\n.form-control {\n  padding: 0.345rem 1rem;\n  min-height: 2.5rem; }\n  .form-control:focus {\n    color: #495057;\n    background-color: #f8f8f8;\n    border-color: #00acec;\n    outline: 0;\n    box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.15), 0 0 0 0; }\n\n.input-group .form-control {\n  flex: 1 1 auto; }\n\n.custom-control.custom-checkbox {\n  margin-bottom: 0.3rem; }\n\n.custom-control-label {\n  color: #444; }\n  .custom-control-label:hover {\n    color: #868e96; }\n  .custom-control-label::before {\n    border-width: 1px;\n    border-style: solid;\n    border-color: #868e96; }\n\n.custom-control-input:checked ~ .custom-control-label::before {\n  border-color: #00acec; }\n\n.custom-control.ui-dark .custom-control-label {\n  color: #adb5bd;\n  font-weight: 300;\n  font-size: 0.8rem; }\n\n.custom-control.ui-dark .custom-control-input:checked ~ .custom-control-label {\n  color: #e9ecef; }\n\n.modal-header .close i {\n  color: #000;\n  opacity: .5; }\n\n.modal-title {\n  font-weight: 700; }\n\n.modal.fade .modal-dialog {\n  transform: translate(0, 0); }\n\n.modal-footer > :not(:first-child) {\n  margin-left: 10px; }\n\n.modal-footer > :not(:last-child) {\n  margin-right: 10px; }\n\n.badge--top-right {\n  position: relative; }\n  .badge--top-right .badge {\n    font-size: 0.6875rem;\n    line-height: 1.2;\n    position: absolute;\n    top: 5px;\n    right: 7px; }\n\n.badge--small {\n  font-size: 0.6875rem; }\n\n.dropdown-menu {\n  font-size: 0.875rem;\n  margin-top: 0px;\n  border-radius: 0px;\n  box-shadow: 0px 2px 12px rgba(0, 0, 0, 0.3); }\n  .dropdown-menu [class^=\"icon--\"], .dropdown-menu [class*=\" icon--\"] {\n    vertical-align: middle; }\n\n.dropdown-item [class^=\"icon--\"], .dropdown-item [class*=\" icon--\"] {\n  margin-right: 1rem; }\n\n.dropdown-item:focus {\n  color: #16181b;\n  background-color: #eff4f6 !important; }\n\n.dropdown-item:active, .dropdown-item:hover {\n  color: #fff !important;\n  background-color: #00acec !important; }\n  .dropdown-item:active [class^=\"icon--\"], .dropdown-item:active [class*=\" icon--\"], .dropdown-item:hover [class^=\"icon--\"], .dropdown-item:hover [class*=\" icon--\"] {\n    color: white !important; }\n\n.no-touch .dropdown-item:hover, .no-touch .dropdown-item:focus {\n  color: #16181b !important;\n  background-color: #eff4f6 !important; }\n  .no-touch .dropdown-item:hover [class^=\"icon--\"], .no-touch .dropdown-item:hover [class*=\" icon--\"], .no-touch .dropdown-item:focus [class^=\"icon--\"], .no-touch .dropdown-item:focus [class*=\" icon--\"] {\n    color: #00acec !important; }\n\n.no-touch .dropdown-item:active {\n  color: #fff !important;\n  background-color: #00acec !important; }\n  .no-touch .dropdown-item:active [class^=\"icon--\"], .no-touch .dropdown-item:active [class*=\" icon--\"] {\n    color: white !important; }\n\n.dropdown-menu-right {\n  right: 0;\n  left: auto !important;\n  transform: initial !important;\n  top: 100% !important; }\n\n.dropdown-header {\n  font-size: 1rem;\n  color: #444;\n  font-weight: 500;\n  padding: 1rem;\n  border-bottom: 1px solid #e7e7e7; }\n\n.navbar-brand span.breadcrumb-item {\n  font-size: 0.8125rem;\n  line-height: 1.1; }\n  @media only screen and (min-width: 576px) {\n    .navbar-brand span.breadcrumb-item {\n      font-size: 1rem; } }\n\n.navbar-brand a.breadcrumb-item {\n  font-weight: 300; }\n  .navbar-brand a.breadcrumb-item:hover {\n    text-decoration: none;\n    cursor: default; }\n  @media only screen and (min-width: 576px) {\n    .navbar-brand a.breadcrumb-item {\n      letter-spacing: -.1rem; } }\n\n.navbar-brand .breadcrumb-item + .breadcrumb-item::before {\n  padding: 0;\n  display: none; }\n  @media only screen and (min-width: 576px) {\n    .navbar-brand .breadcrumb-item + .breadcrumb-item::before {\n      padding: 0 0.5rem;\n      display: inline-block; } }\n\n.breadcrumb-item.active {\n  color: #9ba4ad; }\n\n.list-group-item--link {\n  padding: 0; }\n  .list-group-item--link a {\n    display: block;\n    padding: 0.75rem 1.25rem; }\n    .list-group-item--link a:hover {\n      text-decoration: none;\n      background-color: #eff4f6; }\n    .list-group-item--link a [class^=\"svg-icon--\"] {\n      float: right;\n      opacity: 0.5; }\n\n.card--inside-dropdown {\n  border: none;\n  box-shadow: none;\n  min-width: 16rem; }\n  .card--inside-dropdown .card-footer {\n    border-top: none; }\n\n.card.card--home {\n  flex-basis: 100%;\n  border-radius: 0;\n  border: none;\n  box-shadow: 0px 1px 5px rgba(0, 0, 0, 0.2); }\n  .card.card--home:hover {\n    box-shadow: 0px 1px 9px rgba(0, 0, 0, 0.4);\n    cursor: pointer; }\n  .card.card--home.no-hover {\n    pointer-events: none; }\n  .card.card--home h1.card-title {\n    font-size: 3.125rem;\n    font-weight: 900;\n    line-height: 1.4; }\n  .card.card--home h2.card-title {\n    font-size: 1.625rem;\n    font-weight: 900;\n    line-height: 1.4; }\n  .card.card--home h3.card-title {\n    font-size: 1.25rem;\n    font-weight: 900;\n    line-height: 1.4; }\n  .card.card--home h4.card-title {\n    font-size: 1rem;\n    font-weight: 900;\n    line-height: 1.4; }\n  .card.card--home h5.card-title {\n    font-size: 0.875rem;\n    font-weight: 900;\n    line-height: 1.4; }\n  .card.card--home h1.card-title, .card.card--home h2.card-title {\n    color: #3e4557; }\n  .card.card--home .card-header,\n  .card.card--home .card-footer {\n    background-color: white; }\n  .card.card--home .card-body {\n    padding: 1rem 1.25rem; }\n    .card.card--home .card-body .wire-articles__item__meta {\n      margin: 10px 0; }\n    .card.card--home .card-body .wire-articles__item__text {\n      flex-grow: 1; }\n    .card.card--home .card-body.card-body--one-column {\n      display: flex;\n      flex-direction: column;\n      justify-content: flex-start; }\n    .card.card--home .card-body.card-body--two-columns {\n      display: flex;\n      flex-direction: column;\n      padding: 0; }\n      @media only screen and (min-width: 576px) {\n        .card.card--home .card-body.card-body--two-columns {\n          flex-direction: row; } }\n    .card.card--home .card-body.card-body--green-border {\n      border-left: 4px solid #7ed321; }\n    .card.card--home .card-body .card-body__sidebar {\n      flex: 0 0 45%;\n      padding: 1rem;\n      display: flex;\n      align-items: center; }\n      @media only screen and (min-width: 768px) {\n        .card.card--home .card-body .card-body__sidebar {\n          flex: 0 0 35%; } }\n      @media only screen and (min-width: 992px) {\n        .card.card--home .card-body .card-body__sidebar {\n          flex: 0 0 50%; } }\n      @media only screen and (min-width: 1200px) {\n        .card.card--home .card-body .card-body__sidebar {\n          flex: 0 0 40%; } }\n      @media only screen and (min-width: 1440px) {\n        .card.card--home .card-body .card-body__sidebar {\n          flex: 0 0 35%; } }\n    .card.card--home .card-body .card-body__content {\n      padding: 1rem; }\n  .card.card--home .card-footer .wire-articles__item__icon {\n    margin-right: 5px; }\n    @media only screen and (min-width: 1440px) {\n      .card.card--home .card-footer .wire-articles__item__icon {\n        margin-right: 7px; } }\n  .card.card--home .card-text {\n    font-size: 1rem;\n    line-height: 1.5; }\n    .card.card--home .card-text.small {\n      font-size: 0.875rem;\n      font-weight: 300; }\n    .card.card--home .card-text.tiny {\n      font-size: 0.8125rem;\n      font-weight: 300; }\n\n@media only screen and (min-width: 768px) {\n  .card.card--horizontal {\n    flex-direction: row; } }\n\n.card.card--horizontal .card-image-left {\n  max-width: 100%;\n  overflow: hidden;\n  flex: 1 0 auto;\n  align-items: stretch;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  background-color: #2d2d2d; }\n  @media only screen and (min-width: 768px) {\n    .card.card--horizontal .card-image-left {\n      max-width: 50%; } }\n  @media only screen and (min-width: 992px) {\n    .card.card--horizontal .card-image-left {\n      max-width: 45%; } }\n  .card.card--horizontal .card-image-left img {\n    flex: 1 1 100%;\n    object-fit: cover;\n    width: 100%;\n    height: 100%; }\n\n.card.card--gallery:hover {\n  box-shadow: 0px 1px 10px rgba(0, 0, 0, 0.7); }\n\n.card.card--gallery .card-body {\n  position: absolute;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  color: white;\n  background: -moz-linear-gradient(top, rgba(0, 0, 0, 0) 0%, rgba(0, 0, 0, 0.65) 100%);\n  background: -webkit-linear-gradient(top, rgba(0, 0, 0, 0) 0%, rgba(0, 0, 0, 0.65) 100%);\n  background: linear-gradient(to bottom, rgba(0, 0, 0, 0) 0%, rgba(0, 0, 0, 0.65) 100%); }\n\n.card.card--gallery .wire-articles__item__meta-info,\n.card.card--gallery .wire-articles__item__meta-info .bold {\n  color: white; }\n\n.card.card--gallery .card-img-top {\n  min-height: 300px;\n  height: 100%;\n  object-fit: cover; }\n\n.carousel {\n  margin: -1.5rem -1.4375rem 1.5rem -1.4375rem; }\n  @media only screen and (min-width: 768px) {\n    .carousel {\n      margin: -1.5rem -1.9375rem 1.5rem -1.9375rem; } }\n  @media only screen and (min-width: 992px) {\n    .carousel {\n      margin: -1.5rem -2.4375rem 1.5rem -2.4375rem; } }\n\n.carousel-item {\n  height: 200px;\n  background-size: cover;\n  background-position: 50% 0; }\n  @media only screen and (min-width: 768px) {\n    .carousel-item {\n      height: 500px; } }\n\n.carousel-caption {\n  text-align: left;\n  left: 10%;\n  right: 10%;\n  bottom: 0; }\n  @media only screen and (min-width: 768px) {\n    .carousel-caption {\n      bottom: 20px; } }\n  @media only screen and (min-width: 1200px) {\n    .carousel-caption {\n      left: 5%;\n      right: 5%; } }\n  .carousel-caption h3 {\n    font-size: 24px;\n    text-align: left;\n    font-weight: 500; }\n    @media only screen and (min-width: 768px) {\n      .carousel-caption h3 {\n        font-size: 48px; } }\n\n.carousel-overlay {\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  right: 0;\n  left: 0;\n  background: -moz-linear-gradient(bottom, rgba(0, 0, 0, 0.6) 0%, rgba(0, 0, 0, 0) 50%);\n  background: -webkit-linear-gradient(bottom, rgba(0, 0, 0, 0.6) 0%, rgba(0, 0, 0, 0) 50%);\n  background: linear-gradient(to top, rgba(0, 0, 0, 0.6) 0%, rgba(0, 0, 0, 0) 50%); }\n\n.carousel-control-next,\n.carousel-control-prev {\n  width: 50px;\n  height: 100px;\n  top: 50%;\n  margin-top: -50px;\n  background-color: rgba(0, 0, 0, 0.5); }\n\n.carousel-control-next {\n  border-top-left-radius: 50px;\n  border-bottom-left-radius: 50px;\n  padding-left: 10px; }\n\n.carousel-control-prev {\n  border-top-right-radius: 50px;\n  border-bottom-right-radius: 50px;\n  padding-right: 10px; }\n\n.carousel-control-next-icon,\n.carousel-control-prev-icon {\n  width: 13px;\n  height: 21px;\n  background-image: url(\"/static/icon-arrow-white.svg\"); }\n\n.carousel-control-prev-icon {\n  transform: rotate(180deg); }\n\nhtml {\n  -webkit-tap-highlight-color: transparent;\n  height: 100%; }\n\nbody {\n  color: #444;\n  background-color: #f8f8f8;\n  overflow: hidden;\n  height: 100%; }\n\nh3.home-section-heading {\n  font-size: 1.25rem;\n  font-weight: 700;\n  color: #006f99;\n  margin-bottom: 1rem; }\n\n.form-alert {\n  width: 450px;\n  max-width: 100%;\n  margin-right: auto;\n  margin-left: auto; }\n\n.col-fixed-60 {\n  width: 60px;\n  background: #00acec;\n  position: fixed;\n  height: 100%;\n  z-index: 1; }\n\n.col-offset-120 {\n  padding-left: 120px;\n  z-index: 0; }\n\n.nav-tabs .nav-link {\n  border-radius: 0; }\n\nlabel {\n  color: #676c7b;\n  font-size: 14px;\n  margin-bottom: 0.3rem; }\n\n.alertify-notifier .ajs-message {\n  border: none; }\n\n.alertify-notifier .ajs-message.ajs-visible {\n  font-size: 0.875rem;\n  font-weight: 300;\n  letter-spacing: 0.2px;\n  text-shadow: none; }\n\n.alertify-notifier .ajs-message.ajs-success {\n  background: #d50089; }\n\n.alertify-notifier .ajs-message.ajs-error {\n  background: #cc0000; }\n\n.table {\n  font-size: 13px;\n  background-color: white; }\n  .table thead th {\n    font-weight: 400;\n    vertical-align: top;\n    color: #777; }\n  .table tr {\n    outline: 1px solid transparent;\n    border-bottom: 1px solid #e9ecef; }\n  .table td {\n    padding: 1rem .75rem;\n    border-bottom: none; }\n    .table td.name {\n      font-size: 14px;\n      font-weight: 700;\n      line-height: 120%; }\n\n.table-hover tbody tr:hover {\n  background-color: transparent;\n  outline: 1px solid #c9c9c9;\n  cursor: pointer; }\n\n.table-hover tbody tr.table--selected {\n  outline: 1px solid #00acec; }\n\ntr.table--selected {\n  outline: 1px solid #00acec; }\n\n.newsroomWrap {\n  position: absolute;\n  top: 0px;\n  right: 0;\n  left: 0;\n  bottom: 0;\n  display: flex;\n  flex-direction: column; }\n\nbody.print {\n  color: #000;\n  background-color: #fff; }\n\n.sidenav {\n  flex: 0 0 56px;\n  background-color: #00acec;\n  position: relative; }\n\n.sidenav:after {\n  position: absolute;\n  display: block;\n  width: 7px;\n  z-index: 80;\n  content: \"\";\n  top: 0;\n  bottom: 0px;\n  right: 0;\n  background-image: linear-gradient(to left, rgba(0, 0, 0, 0.12) 0, transparent 100%); }\n\n.sidenav-icons {\n  margin: 0 0 0 6px;\n  padding: 0px;\n  list-style-type: none;\n  display: flex; }\n  @media only screen and (min-width: 576px) {\n    .sidenav-icons {\n      display: block;\n      margin: 0; } }\n  .sidenav-icons li a, .sidenav-icons li span {\n    display: block;\n    height: 56px;\n    padding: 0 10px;\n    line-height: 56px;\n    text-align: center; }\n    .sidenav-icons li a i, .sidenav-icons li span i {\n      vertical-align: middle; }\n  .sidenav-icons .active i {\n    color: #fff; }\n\n.sidenav-icons__item--admin {\n  position: absolute;\n  bottom: 0;\n  left: auto;\n  right: 0; }\n  @media only screen and (min-width: 576px) {\n    .sidenav-icons__item--admin {\n      left: 0; } }\n\n.sidenav-icons__item--report {\n  position: absolute;\n  bottom: 40px;\n  left: auto;\n  right: 0; }\n  @media only screen and (min-width: 576px) {\n    .sidenav-icons__item--report {\n      left: 0; } }\n\n.content-header {\n  position: relative; }\n\n.navbar {\n  height: 56px; }\n  .navbar.main {\n    padding: 0px;\n    color: #969696;\n    background-color: #2d2d2d;\n    box-shadow: 0px 0px 2px rgba(0, 0, 0, 0.3);\n    z-index: 1007;\n    flex: 0 0 auto; }\n  .navbar .notif {\n    width: 56px;\n    height: 56px;\n    display: flex;\n    justify-content: center;\n    align-items: center; }\n    .navbar .notif .badge {\n      top: -7px;\n      right: -7px; }\n    .navbar .notif:hover .notif__circle {\n      background: #4a4a4a; }\n  .navbar .notif__circle {\n    background: #000;\n    width: 33px;\n    height: 33px;\n    border-radius: 100%;\n    display: flex;\n    justify-content: center;\n    align-items: center; }\n  .navbar .notif__list {\n    position: absolute;\n    top: 44px;\n    right: 0px;\n    background: #f8f8f8;\n    box-shadow: 0px 2px 12px rgba(0, 0, 0, 0.3);\n    min-width: 300px;\n    overflow: auto;\n    max-height: calc(100vh - 56px); }\n    @media only screen and (min-width: 576px) {\n      .navbar .notif__list {\n        min-width: 420px; } }\n  .navbar .notif__list__header {\n    background: #fff;\n    border-bottom: 1px solid #e7e7e7;\n    padding: 1rem 0; }\n  .navbar .notif__list__header-headline {\n    font-size: 1rem;\n    color: #444;\n    font-weight: 700; }\n  .navbar .notif__list__item {\n    background: #fff;\n    box-shadow: 0px 1px 5px rgba(0, 0, 0, 0.2);\n    border: 2px solid transparent;\n    padding: 10px 12px;\n    margin: 10px; }\n    .navbar .notif__list__item:hover {\n      border: 2px solid #f5f5f5; }\n    .navbar .notif__list__item .close {\n      width: 18px;\n      height: 18px;\n      background-color: #bbb;\n      border-radius: 100%;\n      color: white;\n      font-size: 1.1rem;\n      font-weight: 400;\n      text-shadow: none;\n      padding-left: 1px; }\n      .navbar .notif__list__item .close:focus {\n        outline: 0; }\n  .navbar .notif__list__headline {\n    font-size: 0.875rem;\n    color: #444;\n    font-weight: 700;\n    line-height: 1.4;\n    margin-bottom: 6px; }\n  .navbar .notif__list__info {\n    font-size: 0.75rem;\n    color: #9a9a9a;\n    margin-bottom: 6px; }\n\n.navbar__logo {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  padding: 0 0.5rem;\n  max-width: 160px; }\n  @media only screen and (min-width: 576px) {\n    .navbar__logo {\n      max-width: 224px;\n      padding: 0 0.5rem 0 1rem; } }\n  .navbar__logo img {\n    max-width: 100%; }\n\n.navbar-brand {\n  margin-left: 2rem;\n  opacity: 1;\n  line-height: 1.2rem;\n  font-size: 1.125rem;\n  font-weight: 400; }\n  @media only screen and (min-width: 576px) {\n    .navbar-brand {\n      line-height: inherit;\n      font-size: 1.75rem; } }\n  .navbar-brand nav {\n    display: flex;\n    flex-direction: column; }\n    @media only screen and (min-width: 576px) {\n      .navbar-brand nav {\n        flex-direction: row;\n        align-items: center; } }\n\nnav.search {\n  width: 100%; }\n\n.header-profile {\n  display: flex;\n  flex-direction: column;\n  width: 56px;\n  height: 56px;\n  background: rgba(0, 0, 0, 0.7);\n  padding: 9px; }\n  .header-profile:hover {\n    cursor: default; }\n    .header-profile:hover .header-profile__avatar {\n      background: #475166; }\n  .show .header-profile {\n    position: relative;\n    background: #F7F7F7;\n    z-index: 1002; }\n  @media only screen and (min-width: 576px) {\n    .header-profile {\n      margin-left: 4px; } }\n\n.header-profile__avatar {\n  background: #333a4a;\n  color: #fff;\n  border-radius: 50%;\n  margin: 0;\n  flex: 1;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center; }\n\n.header-profile__characters {\n  font-size: 0.875rem; }\n\n.card {\n  background-color: #fff;\n  outline: none; }\n\narticle.list {\n  cursor: pointer; }\n\n.footer {\n  z-index: 10;\n  height: 30px;\n  color: #333;\n  background-color: #e6e6e6;\n  box-shadow: 0px 0px 2px rgba(0, 0, 0, 0.3);\n  font-size: 11px;\n  flex-shrink: 0;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  margin: 0;\n  transition: margin 0.2s ease-in-out; }\n  .footer--home {\n    margin-bottom: -30px; }\n  .footer a {\n    margin: 0 10px; }\n\n.contentWrap, .settingsWrap, .settings-inner, .flex-row, .flex-col {\n  display: flex;\n  flex-grow: 1;\n  overflow-y: auto; }\n\n.settings-inner {\n  flex-direction: column; }\n  @media only screen and (min-width: 768px) {\n    .settings-inner {\n      flex-direction: row; } }\n\n.profile-container {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1010;\n  display: flex;\n  flex-grow: 1;\n  overflow-y: auto; }\n\n.flex-col {\n  overflow-x: auto; }\n\n.content {\n  flex: 1;\n  display: flex;\n  flex-direction: column;\n  overflow-y: auto;\n  position: relative; }\n\n.content-bar {\n  background: #fff;\n  box-shadow: 1px 1px 1px rgba(0, 0, 0, 0.15);\n  padding: 0px;\n  z-index: 102; }\n\n.content-bar__dropdown-btn {\n  position: relative;\n  background-color: #fff;\n  color: #7f7f7f;\n  padding: 17px 20px;\n  border-radius: 0px;\n  z-index: 1001 !important; }\n\n.show .content-bar__dropdown-btn {\n  box-shadow: 0px -7px 12px rgba(0, 0, 0, 0.3); }\n\n.content-bar__menu {\n  font-size: 0.94rem;\n  width: 56px;\n  height: 56px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  background-color: #fff;\n  cursor: pointer;\n  z-index: 1002;\n  border-left: 1px solid #ebebeb; }\n\n.show .content-bar__menu {\n  box-shadow: 0px -7px 12px rgba(0, 0, 0, 0.3);\n  z-index: 1002; }\n\n.content-bar__menu--nav {\n  background: #ededed;\n  flex-shrink: 0;\n  border: none; }\n  .content-bar__menu--nav .icon--close-thin {\n    display: none; }\n\n.content-bar__menu--nav--open {\n  background: #717b96;\n  border: none; }\n  .content-bar__menu--nav--open .icon--hamburger {\n    display: none; }\n  .content-bar__menu--nav--open .icon--close-thin {\n    display: block; }\n\n.content-bar__menu + .dropdown-menu {\n  z-index: 1001; }\n\n.content-bar--side-padding {\n  padding: 0 10px; }\n  @media only screen and (min-width: 576px) {\n    .content-bar--side-padding {\n      padding: 0 20px; } }\n\n.side-navigation {\n  width: auto;\n  overflow-y: auto;\n  border-right: 1px solid #c9c9c9;\n  border-bottom: 1px solid #c9c9c9;\n  background-color: white; }\n  .side-navigation ul {\n    list-style: none;\n    margin: 0;\n    padding: 0;\n    display: flex; }\n    @media only screen and (min-width: 768px) {\n      .side-navigation ul {\n        flex-direction: column; } }\n    .side-navigation ul li {\n      flex-grow: 1;\n      display: flex; }\n      @media only screen and (min-width: 576px) {\n        .side-navigation ul li {\n          flex-direction: column; } }\n  @media only screen and (min-width: 768px) {\n    .side-navigation {\n      width: 220px; } }\n\n.side-navigation__btn {\n  display: block;\n  font-size: 11px;\n  font-weight: 500;\n  letter-spacing: 1px;\n  color: #444;\n  text-transform: uppercase;\n  line-height: 150%;\n  text-decoration: none;\n  background-color: rgba(94, 169, 200, 0);\n  padding: 16px;\n  transition: background-color .2s ease-out,color .1s ease-out;\n  text-align: center; }\n  .side-navigation__btn:hover {\n    background-color: #f1f1f1;\n    color: #444;\n    text-decoration: none; }\n  .side-navigation__btn.active {\n    background-color: #f1f1f1;\n    color: #00acec; }\n  @media only screen and (min-width: 576px) {\n    .side-navigation__btn {\n      padding: 20px; } }\n  @media only screen and (min-width: 768px) {\n    .side-navigation__btn {\n      text-align: left; } }\n\n.list-items-container {\n  display: flex;\n  flex-direction: column;\n  padding: 20px;\n  flex: 1;\n  overflow: auto; }\n\n.list-item {\n  background-color: #ccc; }\n\n.list-item__preview {\n  width: 100%;\n  display: flex;\n  flex-direction: column;\n  flex-shrink: 0;\n  overflow: hidden;\n  overflow-y: auto;\n  background-color: white;\n  position: fixed;\n  top: 56px;\n  left: 0;\n  bottom: 0;\n  border: none;\n  z-index: 81; }\n  @media only screen and (min-width: 992px) {\n    .list-item__preview {\n      width: 420px;\n      border-left: 2px solid #9a9a9a;\n      position: static;\n      z-index: auto; } }\n  .list-item__preview form {\n    display: flex;\n    flex-direction: column;\n    flex: 1;\n    overflow: hidden;\n    overflow-y: auto; }\n  .list-item__preview .tab-content {\n    display: flex;\n    flex-direction: column;\n    flex: 1;\n    overflow: hidden;\n    overflow-y: auto; }\n  .list-item__preview .tab-pane {\n    display: flex;\n    flex-direction: column;\n    flex: 1;\n    overflow: hidden;\n    overflow-y: auto; }\n  .list-item__preview .nav-tabs .nav-item .nav-link {\n    font-size: 12px;\n    color: #9b9b9b;\n    text-transform: uppercase;\n    letter-spacing: 0.1em;\n    padding: 1rem 1.6rem; }\n    .list-item__preview .nav-tabs .nav-item .nav-link.active, .list-item__preview .nav-tabs .nav-item .nav-link.active:hover {\n      font-weight: 500;\n      color: #444;\n      border-color: #ddd #ddd #fff #ddd; }\n    .list-item__preview .nav-tabs .nav-item .nav-link:hover {\n      border-color: transparent;\n      color: #444; }\n  .list-item__preview .nav-tabs .nav-item:first-child .nav-link.active, .list-item__preview .nav-tabs .nav-item:first-child .nav-link.active:hover {\n    border-color: #ddd #ddd #fff transparent; }\n  .list-item__preview table tr:first-child td {\n    border-top: none; }\n\n.list-item__preview-header {\n  padding: 20px 45px 20px 20px;\n  display: flex;\n  justify-content: space-between;\n  position: relative; }\n  .list-item__preview-header h3 {\n    font-size: 20px;\n    font-weight: 500;\n    margin-bottom: 0;\n    line-height: 1.4; }\n  .list-item__preview-header .icon-button {\n    position: absolute;\n    top: 10px;\n    right: 10px; }\n\n.list-item__preview-form {\n  display: flex;\n  flex-direction: column;\n  flex: 1;\n  overflow: hidden;\n  overflow-y: auto;\n  padding: 20px; }\n\n.list-item__preview-footer {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  padding: 15px;\n  border-top: 1px solid #ddd; }\n  .list-item__preview-footer .btn {\n    padding: 0.4rem 0.6rem;\n    flex: 1 0 auto; }\n    @media only screen and (min-width: 576px) {\n      .list-item__preview-footer .btn {\n        padding: 0.5rem 1rem;\n        flex: 0 1 auto; } }\n    .list-item__preview-footer .btn + .btn {\n      margin-left: 12px; }\n  @media only screen and (min-width: 576px) {\n    .list-item__preview-footer {\n      padding: 20px; } }\n\n.search {\n  flex-wrap: nowrap;\n  flex: 1 1 0%; }\n  @media only screen and (min-width: 576px) {\n    .search {\n      flex: 1 1 auto; } }\n  @media only screen and (min-width: 992px) {\n    .search {\n      flex-wrap: wrap; } }\n  .search + .content-bar__right {\n    margin-left: 0; }\n    @media only screen and (min-width: 576px) {\n      .search + .content-bar__right {\n        margin-left: 10px; } }\n\n.search__form {\n  flex: 0 1 auto;\n  margin: 0 10px; }\n  .search__form form {\n    flex: 1 1 auto; }\n  .search__form input {\n    background: #fff; }\n    .search__form input:focus {\n      background: #fff;\n      box-shadow: inset 0 0px 2px rgba(0, 0, 0, 0.15); }\n  @media only screen and (min-width: 576px) {\n    .search__form {\n      flex: 1 1 auto; } }\n\n@media only screen and (min-width: 576px) {\n  .searchForm--active .search__form__buttons {\n    display: block; } }\n\n.searchForm--active .search__form__buttons > * {\n  margin: 0px 10px; }\n\n.search__input {\n  color: #d5d5d5;\n  font-weight: 500;\n  border: 0px;\n  padding: 0; }\n  .search__input::-webkit-input-placeholder {\n    /* Chrome/Opera/Safari */\n    color: #d5d5d5; }\n  .search__input::-moz-placeholder {\n    /* Firefox 19+ */\n    color: #d5d5d5; }\n  .search__input:-ms-input-placeholder {\n    /* IE 10+ */\n    color: #d5d5d5; }\n  .search__input:-moz-placeholder {\n    /* Firefox 18- */\n    color: #d5d5d5; }\n\n.search__form__buttons {\n  display: none; }\n\n.search__icon {\n  margin: 0 6px;\n  order: 1; }\n  @media only screen and (min-width: 576px) {\n    .search__icon {\n      margin: 0 10px;\n      order: 0; } }\n\n.form-inline .nav-link {\n  padding: 0;\n  font-size: 0.8125rem; }\n  @media only screen and (min-width: 576px) {\n    .form-inline .nav-link {\n      padding: 0.5rem 0.5rem; } }\n  @media only screen and (min-width: 992px) {\n    .form-inline .nav-link {\n      padding: 0.5rem 1rem;\n      font-size: 1rem; } }\n  .form-inline .nav-link + .nav-link {\n    margin-left: 10px; }\n    @media only screen and (min-width: 576px) {\n      .form-inline .nav-link + .nav-link {\n        margin-left: 0; } }\n\n.content-bar__right {\n  display: flex;\n  border-left: 1px solid #ebebeb; }\n\n.content-bar__sort {\n  font-size: 0.89rem;\n  align-items: center;\n  padding-left: 10px; }\n\n.content-bar__sort .content-bar__dropdown-btn {\n  font-size: 0.89rem;\n  color: #444;\n  padding: 17px 20px; }\n\n.multi-action-bar {\n  display: none;\n  align-items: center;\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  z-index: 2;\n  height: 56px;\n  padding: 0 16px;\n  background-color: #d9f2fc;\n  box-shadow: 0 1px 4px 0 rgba(0, 0, 0, 0.2);\n  z-index: 1003; }\n  .multi-action-bar .btn + .btn {\n    margin-left: 10px; }\n\n.multi-action-bar--open {\n  display: flex;\n  animation: dropOut 0.3s cubic-bezier(0.695, 0.105, 0.285, 1.275) 1; }\n\n@keyframes dropOut {\n  0% {\n    transform: translateY(-48px); }\n  100% {\n    transform: translateY(0); } }\n\n.multi-action-bar__count {\n  font-size: 0.875rem;\n  flex: 1 1 auto;\n  margin-left: 20px;\n  display: none; }\n  @media only screen and (min-width: 576px) {\n    .multi-action-bar__count {\n      display: block; } }\n\n.multi-action-bar__icons {\n  margin-left: auto; }\n\n.multi-action-bar__icon {\n  margin-left: 20px; }\n  .multi-action-bar__icon:hover {\n    text-decoration: none; }\n\n.content-main {\n  display: flex;\n  overflow-y: auto;\n  flex-grow: 1; }\n  .content-main .row + .row {\n    margin-top: 20px; }\n\n.search-results-info {\n  font-size: 0.875rem;\n  line-height: 1.2;\n  display: flex;\n  margin-right: 20px;\n  width: auto;\n  min-height: 28px;\n  padding-bottom: 0;\n  padding-top: 0; }\n  @media only screen and (min-width: 768px) {\n    .search-results-info {\n      margin-right: 40px;\n      padding-top: 0.3rem;\n      min-height: 48px; } }\n\n.search-results-info__num {\n  font-size: 2rem;\n  font-weight: 300;\n  line-height: 1.4;\n  margin-right: 10px;\n  transition: all 0.2s ease; }\n  @media only screen and (min-width: 992px) {\n    .search-results-info__num {\n      margin-bottom: 0; } }\n\n.search-results-info__text {\n  color: #6e6e6e;\n  margin-top: 6px; }\n  .search-results-info__text b {\n    color: #444; }\n\n.wire-column--3 {\n  opacity: 1;\n  transition: opacity .2s ease-in;\n  transition-delay: .1s;\n  flex-grow: 1;\n  display: flex;\n  flex-direction: row;\n  overflow-x: hidden;\n  overflow-y: auto; }\n\n.wire-column__nav, .wire-column__preview {\n  width: 0;\n  transition: all .1s ease-out;\n  display: flex;\n  flex-direction: column;\n  overflow-x: hidden; }\n\n.wire-column__nav {\n  width: 0;\n  position: fixed;\n  top: 168px;\n  bottom: 0;\n  z-index: 101; }\n  @media only screen and (min-width: 576px) {\n    .wire-column__nav {\n      position: static; } }\n\n.wire-column__nav--open, .wire-column__preview--open {\n  flex-shrink: 0; }\n\n.wire-column__nav--open {\n  width: 100%; }\n  @media only screen and (min-width: 992px) {\n    .wire-column__nav--open {\n      width: 220px; } }\n  @media only screen and (min-width: 1200px) {\n    .wire-column__nav--open {\n      width: 260px; } }\n  @media only screen and (min-width: 1440px) {\n    .wire-column__nav--open {\n      width: 320px; } }\n\n.wire-column__preview {\n  position: fixed;\n  right: 0;\n  top: 56px;\n  left: 100%;\n  z-index: 1001;\n  width: 320px; }\n  @media only screen and (min-width: 992px) {\n    .wire-column__preview {\n      position: static;\n      top: auto;\n      width: 0;\n      z-index: 101; } }\n\n.wire-column__preview--open {\n  width: 100%;\n  right: 0;\n  left: 0;\n  bottom: 0;\n  border: 0; }\n  @media only screen and (min-width: 992px) {\n    .wire-column__preview--open {\n      width: 340px;\n      position: static;\n      border-left: 2px solid #919191; } }\n  @media only screen and (min-width: 1200px) {\n    .wire-column__preview--open {\n      width: 380px; } }\n  @media only screen and (min-width: 1440px) {\n    .wire-column__preview--open {\n      width: 480px; } }\n\n.wire-column__nav__items, .wire-column__preview__items {\n  opacity: 0;\n  transition: all .1s ease-out;\n  transition-delay: 0;\n  padding: 10px 20px; }\n\n.wire-column__nav--open .wire-column__nav__items, .wire-column__preview--open .wire-column__preview__items {\n  opacity: 1;\n  transition: all .1s ease-out;\n  transition-delay: .2s; }\n\n.wire-column__nav {\n  background: #3e4557; }\n\n.wire-column__nav__items {\n  display: flex;\n  flex-direction: column;\n  flex: 1 1 auto;\n  padding: 10px 0px 0px 0px;\n  position: relative; }\n  .wire-column__nav__items .nav {\n    flex: 0 0 44px;\n    margin-left: 0px;\n    margin-right: 0px;\n    border-bottom: 1px solid #323847; }\n  .wire-column__nav__items .tab-content {\n    display: flex;\n    flex-direction: column;\n    overflow: auto; }\n    .wire-column__nav__items .tab-content .tab-pane {\n      padding: 20px; }\n      .wire-column__nav__items .tab-content .tab-pane #reset-filter-buffer {\n        height: 80px; }\n      .wire-column__nav__items .tab-content .tab-pane .filter-button {\n        position: absolute;\n        left: 0;\n        right: 15px;\n        padding: 10px 20px 0 20px;\n        background: #3e4557;\n        opacity: 0.8; }\n        .wire-column__nav__items .tab-content .tab-pane .filter-button.reset {\n          bottom: 0; }\n        .wire-column__nav__items .tab-content .tab-pane .filter-button.search {\n          bottom: 50px;\n          border-top: 1px solid #323847; }\n  .wire-column__nav__items .btn {\n    margin-bottom: 12px; }\n\n.wire-column__nav__tab a {\n  color: #8b8f9a; }\n  .wire-column__nav__tab a.active {\n    color: #fff;\n    border-bottom: 3px solid #00acec; }\n  @media only screen and (min-width: 992px) {\n    .wire-column__nav__tab a {\n      padding: .5rem .4rem; } }\n  @media only screen and (min-width: 1440px) {\n    .wire-column__nav__tab a {\n      padding: .5rem 1rem; } }\n\n.wire-column__main {\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1;\n  flex-shrink: 1;\n  width: 50%;\n  overflow: auto;\n  margin-left: 0px;\n  transition: margin-left .1s ease-out; }\n\n.wire-column__main--left-margin {\n  margin-left: 260px; }\n\n.wire-column__main-header {\n  flex-shrink: 0;\n  height: 36px;\n  transition: all .2s ease;\n  z-index: 10; }\n  @media only screen and (min-width: 992px) {\n    .wire-column__main-header {\n      height: 42px; } }\n  .wire-column__main-header--small {\n    background: white;\n    box-shadow: 0 2px 3px rgba(0, 0, 0, 0.2);\n    height: 36px; }\n    @media only screen and (min-width: 576px) {\n      .wire-column__main-header--small .btn-sm, .wire-column__main-header--small .btn-group-sm > .btn {\n        padding: 0.1875rem 0.75rem;\n        transition: padding .2s ease-out; } }\n    @media only screen and (min-width: 576px) {\n      .wire-column__main-header--small .search-results-info__num {\n        font-size: 1.625rem;\n        transition: all .2s ease;\n        margin-top: 3px; } }\n    @media only screen and (min-width: 576px) {\n      .wire-column__main-header--small .search-results-info {\n        line-height: 1;\n        transition: all .2s ease; } }\n  .wire-column__main-header + .wire-articles--list {\n    padding-top: 4px; }\n\n.flex-grid__item {\n  background: #fff; }\n\n.wire-column__nav__divider {\n  width: 38px;\n  border-bottom: 4px dotted #5b6170;\n  display: block;\n  margin: 20px auto; }\n\n.wire-column__nav__group {\n  color: #fff;\n  margin-bottom: 20px; }\n\n.wire-column__info {\n  color: #8b8f9a; }\n\n.wire-button__notif {\n  position: absolute;\n  top: -10px;\n  right: -10px;\n  display: block;\n  color: #fff;\n  background: #d50089;\n  border-radius: 100%;\n  width: 20px;\n  height: 20px;\n  line-height: 1.3rem; }\n\n.wire-articles {\n  margin-top: 10px; }\n\n.wire-articles__item {\n  flex-grow: 1;\n  background: #fff;\n  box-shadow: 0px 1px 5px rgba(0, 0, 0, 0.2);\n  padding: 16px 25px;\n  border: 4px solid transparent;\n  outline: 1px solid transparent;\n  transition: all .2s ease-out; }\n  .no-touch .wire-articles__item:hover {\n    border: 4px solid #f5f5f5; }\n\n.wire-articles__item--open {\n  outline: 1px solid #00aceb; }\n\n.wire-articles__item--visited .wire-articles__item-headline,\n.wire-articles__item--visited .wire-articles__item__text {\n  color: #9a9a9a; }\n\n.wire-articles__item--visited .wire-articles__item__meta-info,\n.wire-articles__item--visited .wire-articles__item__meta-info .bold {\n  color: #9a9a9a; }\n\n.wire-articles__item--visited .wire-articles__item__meta-info .bold {\n  font-weight: 500; }\n\n.wire-articles__item--visited .wire-articles__item-image figure img {\n  -webkit-filter: grayscale(100%);\n  /* Safari 6.0 - 9.0 */\n  filter: grayscale(100%); }\n\n.wire-articles__item--visited .icon--gray-light {\n  color: #dedede !important; }\n\n.wire-articles__item--visited .wire-articles__item-actions .btn-group:hover > span > [class^=\"icon--\"], .wire-articles__item--visited .wire-articles__item-actions .btn-group:hover [class*=\" icon--\"] {\n  color: #444 !important; }\n\n.wire-articles__item.wire-articles__item--selected {\n  border: 4px solid #e6f7fd;\n  outline: 1px solid #00aceb; }\n\n.wire-articles__item-wrap {\n  display: flex;\n  flex-direction: column;\n  margin-bottom: 15px;\n  cursor: pointer;\n  outline: none; }\n\n.wire-articles--list {\n  padding-top: 20px;\n  margin-top: 0;\n  overflow: auto;\n  flex-grow: 1; }\n\n.wire-articles__item--list {\n  display: flex;\n  flex-direction: column;\n  padding: 12px; }\n  @media only screen and (min-width: 576px) {\n    .wire-articles__item--list {\n      padding: 12px 10px 6px 15px; } }\n  @media only screen and (min-width: 768px) {\n    .wire-articles__item--list {\n      flex-direction: row;\n      padding: 12px 20px; } }\n\n.wire-articles--grid .wire-articles__item--grid {\n  display: flex;\n  flex-direction: column;\n  padding: 0;\n  border: none; }\n\n.wire-articles--grid .wire-articles__item:hover {\n  border: none; }\n\n.wire-articles--grid .wire-articles__item-text {\n  order: 2 !important;\n  padding: 16px 16px 6px;\n  flex-basis: auto; }\n\n.wire-articles--grid .wire-articles__item-image {\n  order: 1 !important;\n  position: relative; }\n  .wire-articles--grid .wire-articles__item-image figure {\n    margin: 0 !important; }\n    .wire-articles--grid .wire-articles__item-image figure img {\n      max-width: 100% !important;\n      width: 100% !important; }\n  .wire-articles--grid .wire-articles__item-image .wire-articles__item-select {\n    position: absolute;\n    top: 10px;\n    left: 10px; }\n\n.wire-articles--grid .wire-articles__versions__time {\n  line-height: 1.2;\n  font-size: 1.4rem; }\n\n.wire-articles--grid .wire-articles__item-actions {\n  order: 3 !important;\n  flex-direction: row !important;\n  justify-content: flex-end !important;\n  margin: 0 10px 4px 0; }\n\n.wire-articles--grid .wire-articles__versions__item {\n  padding: 16px;\n  align-items: flex-start;\n  flex-wrap: wrap;\n  cursor: pointer; }\n\n.wire-articles--grid .wire-articles__item-select {\n  width: 24px;\n  opacity: 1;\n  margin-right: 10px; }\n\n.wire-articles--grid .wire-articles__versions__name {\n  margin-top: 4px; }\n  .wire-articles--grid .wire-articles__versions__name h5 {\n    font-size: .875rem; }\n\n.wire-articles--list-compact .wire-articles__item-wrap {\n  margin-bottom: 10px; }\n\n.wire-articles--list-compact .wire-articles__item--list {\n  padding: 10px; }\n  @media only screen and (min-width: 768px) {\n    .wire-articles--list-compact .wire-articles__item--list {\n      padding: 4px 10px; } }\n\n.wire-articles--list-compact .wire-articles__item-text {\n  flex-direction: column;\n  flex-basis: auto; }\n  @media only screen and (min-width: 768px) {\n    .wire-articles--list-compact .wire-articles__item-text {\n      flex-direction: row;\n      align-items: center; } }\n\n.wire-articles--list-compact .wire-articles__item-headline {\n  display: flex;\n  font-size: 0.875rem;\n  margin-right: 20px;\n  margin-bottom: 6px; }\n  .wire-articles--list-compact .wire-articles__item-headline label {\n    margin-bottom: 0px; }\n  @media only screen and (min-width: 768px) {\n    .wire-articles--list-compact .wire-articles__item-headline {\n      align-items: center;\n      margin-bottom: 0; } }\n\n@media only screen and (min-width: 768px) {\n  .wire-articles--list-compact .wire-articles__item__versions-btn {\n    margin-left: auto;\n    align-self: center; } }\n\n.wire-articles--list-compact .wire-articles__item-actions {\n  flex-direction: row;\n  align-items: center; }\n  .wire-articles--list-compact .wire-articles__item-actions > * {\n    margin-bottom: 0px; }\n  .wire-articles--list-compact .wire-articles__item-actions > .icon-button {\n    height: 32px; }\n  .wire-articles--list-compact .wire-articles__item-actions > .btn-group {\n    order: 1; }\n\n.wire-articles--list-compact .wire-articles__item__icons {\n  margin-right: 2px; }\n  @media only screen and (min-width: 768px) {\n    .wire-articles--list-compact .wire-articles__item__icons {\n      margin-right: 6px; } }\n\n.wire-articles--list-compact .wire-articles__item-select {\n  margin-right: 6px; }\n  @media only screen and (min-width: 768px) {\n    .wire-articles--list-compact .wire-articles__item-select {\n      margin-right: 10px; } }\n\n.wire-articles__one-side-pane .wire-articles__item--list {\n  flex-direction: column;\n  padding: 12px; }\n  @media only screen and (min-width: 576px) {\n    .wire-articles__one-side-pane .wire-articles__item--list {\n      padding: 12px 15px 6px 15px; } }\n  @media only screen and (min-width: 992px) {\n    .wire-articles__one-side-pane .wire-articles__item--list {\n      flex-direction: row; } }\n  @media only screen and (min-width: 1200px) {\n    .wire-articles__one-side-pane .wire-articles__item--list {\n      padding: 12px 20px; } }\n\n.wire-articles__one-side-pane .wire-articles__item-image {\n  order: 1; }\n  .wire-articles__one-side-pane .wire-articles__item-image figure {\n    margin-left: 0px;\n    margin-bottom: 20px; }\n    @media only screen and (min-width: 992px) {\n      .wire-articles__one-side-pane .wire-articles__item-image figure {\n        margin-left: 12px;\n        margin-bottom: 0px; } }\n    .wire-articles__one-side-pane .wire-articles__item-image figure img {\n      max-width: none;\n      width: 100%; }\n      @media only screen and (min-width: 992px) {\n        .wire-articles__one-side-pane .wire-articles__item-image figure img {\n          max-width: 160px;\n          width: auto; } }\n  @media only screen and (min-width: 992px) {\n    .wire-articles__one-side-pane .wire-articles__item-image {\n      order: 0; } }\n\n.wire-articles__one-side-pane .wire-articles__item-text {\n  order: 2; }\n  @media only screen and (min-width: 992px) {\n    .wire-articles__one-side-pane .wire-articles__item-text {\n      order: 0; } }\n\n.wire-articles__one-side-pane .wire-articles__item-actions {\n  order: 3;\n  flex-direction: row;\n  justify-content: flex-end; }\n  @media only screen and (min-width: 992px) {\n    .wire-articles__one-side-pane .wire-articles__item-actions {\n      order: 0;\n      flex-direction: column;\n      justify-content: flex-start; } }\n\n@media only screen and (min-width: 992px) {\n  .wire-articles__one-side-pane .wire-articles__item-headline {\n    line-height: 1; } }\n\n@media only screen and (min-width: 1200px) {\n  .wire-articles__one-side-pane .wire-articles__item-headline {\n    line-height: 1.2; } }\n\n@media only screen and (min-width: 992px) {\n  .wire-articles__one-side-pane .icon-button {\n    width: 32px; } }\n\n@media only screen and (min-width: 1200px) {\n  .wire-articles__one-side-pane .icon-button {\n    width: 38px; } }\n\n.wire-articles__one-side-pane .wire-articles--list-compact .wire-articles__item--list {\n  padding: 4px 10px; }\n\n.wire-articles__one-side-pane .wire-articles--list-compact .wire-articles__item-actions {\n  flex-direction: row; }\n\n.wire-articles__two-side-panes .wire-articles__item-wrap {\n  flex-grow: 1; }\n\n.wire-articles__two-side-panes .wire-articles__item--list {\n  flex-direction: column;\n  padding: 12px 10px 6px 15px; }\n  @media only screen and (min-width: 1200px) {\n    .wire-articles__two-side-panes .wire-articles__item--list {\n      flex-direction: row; } }\n  @media only screen and (min-width: 1440px) {\n    .wire-articles__two-side-panes .wire-articles__item--list {\n      padding: 12px 20px; } }\n\n.wire-articles__two-side-panes .wire-articles__item-image {\n  order: 1; }\n  .wire-articles__two-side-panes .wire-articles__item-image figure {\n    margin-left: 0px;\n    margin-bottom: 20px; }\n    @media only screen and (min-width: 1200px) {\n      .wire-articles__two-side-panes .wire-articles__item-image figure {\n        margin-left: 12px;\n        margin-bottom: 0px; } }\n    .wire-articles__two-side-panes .wire-articles__item-image figure img {\n      max-width: none;\n      width: 100%; }\n      @media only screen and (min-width: 1200px) {\n        .wire-articles__two-side-panes .wire-articles__item-image figure img {\n          max-width: 160px;\n          width: auto; } }\n  @media only screen and (min-width: 1200px) {\n    .wire-articles__two-side-panes .wire-articles__item-image {\n      order: 0; } }\n\n.wire-articles__two-side-panes .wire-articles__item-text {\n  order: 2;\n  flex-basis: auto; }\n  @media only screen and (min-width: 1200px) {\n    .wire-articles__two-side-panes .wire-articles__item-text {\n      order: 0; } }\n\n.wire-articles__two-side-panes .wire-articles__item__text {\n  font-size: 0.8125rem; }\n  @media only screen and (min-width: 1440px) {\n    .wire-articles__two-side-panes .wire-articles__item__text {\n      font-size: 0.875rem; } }\n\n.wire-articles__two-side-panes .wire-articles__item-actions {\n  order: 3;\n  flex-direction: row;\n  justify-content: flex-end; }\n  @media only screen and (min-width: 1200px) {\n    .wire-articles__two-side-panes .wire-articles__item-actions {\n      order: 0;\n      flex-direction: column;\n      justify-content: flex-start; } }\n\n.wire-articles__two-side-panes .wire-articles__item-headline {\n  margin-right: 0; }\n  @media only screen and (min-width: 1200px) {\n    .wire-articles__two-side-panes .wire-articles__item-headline {\n      line-height: 1; } }\n  @media only screen and (min-width: 1440px) {\n    .wire-articles__two-side-panes .wire-articles__item-headline {\n      line-height: 1.2;\n      margin-right: 20px; } }\n\n.wire-articles__two-side-panes .icon-button {\n  width: 38px; }\n  @media only screen and (min-width: 1200px) {\n    .wire-articles__two-side-panes .icon-button {\n      width: 32px; } }\n  @media only screen and (min-width: 1440px) {\n    .wire-articles__two-side-panes .icon-button {\n      width: 38px; } }\n\n.wire-articles__two-side-panes .search-results-info {\n  margin-right: 10px;\n  transition: all .2s ease; }\n  @media only screen and (min-width: 1200px) {\n    .wire-articles__two-side-panes .search-results-info {\n      margin-right: 20px; } }\n  @media only screen and (min-width: 1440px) {\n    .wire-articles__two-side-panes .search-results-info {\n      margin-right: 40px; } }\n\n.wire-articles__two-side-panes .wire-articles--list-compact .wire-articles__item--list {\n  padding: 4px 10px; }\n\n.wire-articles__two-side-panes .wire-articles--list-compact .wire-articles__item-actions {\n  flex-direction: row; }\n\n.wire-articles__two-side-panes .wire-articles--list-compact .wire-articles__item__meta {\n  margin: 0 10px;\n  flex-shrink: 0; }\n\n.wire-articles__two-side-panes .wire-articles--list-compact .wire-articles__item-text {\n  flex-direction: column;\n  align-items: flex-start; }\n  @media only screen and (min-width: 1200px) {\n    .wire-articles__two-side-panes .wire-articles--list-compact .wire-articles__item-text {\n      flex-direction: row;\n      align-items: center; } }\n\n.wire-articles__two-side-panes .wire-articles--list-compact .wire-articles__item__versions-btn {\n  margin-left: 0;\n  align-self: flex-start; }\n  @media only screen and (min-width: 1200px) {\n    .wire-articles__two-side-panes .wire-articles--list-compact .wire-articles__item__versions-btn {\n      margin-left: auto;\n      align-self: center; } }\n\n.wire-articles__item-text {\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1;\n  flex-basis: 100%;\n  order: 2; }\n  @media only screen and (min-width: 768px) {\n    .wire-articles__item-text {\n      order: 0; } }\n\n.wire-articles__item-headline {\n  font-size: 1rem;\n  font-weight: 700;\n  margin-bottom: 4px; }\n\n.wire-articles__item-select {\n  width: 24px;\n  opacity: 1;\n  margin-right: 10px;\n  display: inline-block;\n  transition: all .2s ease-out; }\n  @media only screen and (min-width: 1200px) {\n    .wire-articles__item-select {\n      width: 0;\n      opacity: 0;\n      margin-right: 0; } }\n  .wire-articles__item-select img {\n    opacity: 0;\n    margin-top: -1px; }\n\n.wire-articles__item:hover .wire-articles__item-select,\n.wire-articles__item--selected .wire-articles__item-select {\n  width: 24px;\n  opacity: 1;\n  margin-right: 10px; }\n  .wire-articles__item:hover .wire-articles__item-select img,\n  .wire-articles__item--selected .wire-articles__item-select img {\n    opacity: 1;\n    transition: all .2s ease-out;\n    transition-delay: 0.2s; }\n\n.wire-articles__item-selected .wire-articles__item-select {\n  width: 24px;\n  opacity: 1;\n  margin-right: 10px; }\n\n.wire-articles__item__meta {\n  display: flex;\n  align-items: center;\n  margin-bottom: 4px; }\n\n.wire-articles__item__meta--align-top {\n  align-items: flex-start; }\n  .wire-articles__item__meta--align-top .wire-articles__item__icons {\n    margin-top: 3px; }\n\n.wire-articles__item__icons {\n  display: flex; }\n\n.wire-articles__item__icon {\n  margin-right: 7px; }\n\n.wire-articles__item__divider {\n  height: 30px;\n  border-right: 1px dotted #c4c4c4;\n  margin: 0px 7px; }\n\n.wire-articles__item__meta-info {\n  font-size: 0.8125rem;\n  color: #747474;\n  line-height: 1.2;\n  display: flex;\n  flex-direction: column; }\n  .wire-articles__item__meta-info .bold {\n    color: #444;\n    font-weight: 500; }\n  .wire-articles__item__meta-info .blue-text {\n    color: #00acec;\n    cursor: pointer; }\n  @media only screen and (min-width: 992px) {\n    .wire-articles__item__meta-info {\n      line-height: 1.3; } }\n\n.wire-articles__item__text {\n  font-size: 0.875rem;\n  font-weight: 300;\n  margin: 5px 0 0;\n  line-height: 1.3; }\n  .wire-articles__item__text p {\n    margin: 0px; }\n\n.wire-articles__item__versions-btn {\n  font-size: 0.8125rem;\n  color: #00acec;\n  margin-top: 4px; }\n\n.wire-articles__item-image {\n  position: relative;\n  order: 1; }\n  .wire-articles__item-image figure {\n    margin-left: 0px;\n    margin-bottom: 20px; }\n    @media only screen and (min-width: 768px) {\n      .wire-articles__item-image figure {\n        margin-left: 12px;\n        margin-bottom: 0px; } }\n    .wire-articles__item-image figure img {\n      max-width: none;\n      width: 100%; }\n      @media only screen and (min-width: 768px) {\n        .wire-articles__item-image figure img {\n          max-width: 160px;\n          width: auto; } }\n  @media only screen and (min-width: 768px) {\n    .wire-articles__item-image {\n      order: 0; } }\n\n.wire-articles__item-image-icon {\n  position: absolute;\n  top: 5px;\n  right: 5px;\n  opacity: 0.8; }\n\n.wire-articles__item-actions {\n  margin-left: 10px;\n  display: flex;\n  flex-direction: row;\n  align-items: flex-end;\n  justify-content: flex-end;\n  order: 3; }\n  @media only screen and (min-width: 768px) {\n    .wire-articles__item-actions {\n      order: 0;\n      flex-direction: column;\n      justify-content: flex-start; } }\n  .wire-articles__item-actions > * {\n    margin-bottom: 3px; }\n  .wire-articles__item-actions .btn-group:hover > span > [class^=\"icon--\"], .wire-articles__item-actions .btn-group:hover [class*=\" icon--\"] {\n    color: #444; }\n\n.wire-articles__item--open + .wire-articles__versions, .wire-articles__item--selected + .wire-articles__versions {\n  outline: 1px solid #00aceb; }\n\n.wire-articles__versions {\n  flex-direction: column;\n  background: #fafafa;\n  box-shadow: 0px 1px 5px rgba(0, 0, 0, 0.2);\n  transition: all .2s ease-out;\n  z-index: 0; }\n\n.wire-articles__versions__item {\n  display: flex;\n  align-items: center;\n  padding: 12px;\n  border-bottom: 1px dotted #cacaca; }\n  @media only screen and (min-width: 992px) {\n    .wire-articles__versions__item {\n      padding: 5px 20px; } }\n\n.wire-articles__versions__item:last-child {\n  border-bottom: 0px; }\n\n.wire-articles__versions__wrap {\n  display: flex;\n  align-items: center; }\n\n.wire-articles__versions__wrap > * {\n  margin-right: 20px; }\n\n.wire-articles__versions__time {\n  font-size: 1.4rem;\n  color: #b6b6b6;\n  font-weight: 400;\n  margin-right: 10px; }\n  @media only screen and (min-width: 992px) {\n    .wire-articles__versions__time {\n      font-size: 2.25rem;\n      font-weight: 300; } }\n\n.wire-articles__versions__name h5 {\n  font-size: 0.9375rem;\n  color: #707070;\n  margin-bottom: 0px; }\n\n.wire-column__preview {\n  background: #fff; }\n\n.wire-column__preview__items {\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1;\n  overflow-x: auto;\n  padding: 0px; }\n\n.wire-column__preview__mobile-bar {\n  display: flex;\n  height: 56px;\n  flex-shrink: 0;\n  padding: 10px 15px;\n  box-shadow: 1px 1px 1px rgba(0, 0, 0, 0.15);\n  background-color: white; }\n  @media only screen and (min-width: 992px) {\n    .wire-column__preview__mobile-bar {\n      display: none; } }\n\n.wire-column__preview__top-bar {\n  font-size: 0.8125rem;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 10px 10px 5px 20px;\n  flex-shrink: 0; }\n  @media only screen and (min-width: 1200px) {\n    .wire-column__preview__top-bar {\n      padding: 15px 10px 20px 20px; } }\n\n.wire-column__preview__date {\n  color: #747474;\n  line-height: 1rem;\n  font-size: .8125rem; }\n  @media only screen and (min-width: 1200px) {\n    .wire-column__preview__date {\n      font-size: .8125rem; } }\n\n.wire-column__preview__buttons {\n  display: flex; }\n\n.wire-column__preview__content {\n  flex-grow: 1;\n  overflow: auto;\n  padding: 10px 20px; }\n  .wire-column__preview__content p {\n    margin: 20px 0; }\n  .wire-column__preview__content img {\n    max-width: 100%; }\n\n.wire-column__preview__slug {\n  font-size: 0.875rem;\n  font-weight: 500;\n  color: #1d5b7d;\n  display: inline-block;\n  margin-bottom: 5px; }\n\n.wire-column__preview__headline {\n  font-size: 1.5rem;\n  font-weight: 700;\n  line-height: 1.4; }\n\n.wire-column__preview__author {\n  color: #626262;\n  font-size: 0.9375rem;\n  font-weight: 300; }\n  .wire-column__preview__author .bold {\n    color: #222222;\n    font-weight: 500; }\n\n.wire-column__preview__image {\n  position: relative;\n  margin-left: -20px;\n  margin-right: -20px; }\n  .wire-column__preview__image img {\n    width: 100%;\n    height: auto; }\n\n.wire-column__preview__image-icon {\n  position: absolute;\n  top: 5px;\n  right: 5px;\n  opacity: 0.8; }\n\n.wire-column__preview__caption {\n  font-size: 0.8125rem;\n  color: #7c7c7c;\n  margin: 10px 20px; }\n\n.wire-column__preview-image-link {\n  font-size: 0.8125rem;\n  margin: 0px 20px;\n  display: flex;\n  align-items: flex-end; }\n  @media only screen and (min-width: 992px) {\n    .wire-column__preview-image-link {\n      margin: 10px 20px; } }\n\n.wire-column__preview-image-link .logo {\n  display: inline-block;\n  width: 74px;\n  height: 16px;\n  background: transparent url(/static/logo-aap-photos.png) 0 0 no-repeat;\n  padding: 2px 0; }\n  @media only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2 / 1), only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min-device-pixel-ratio: 2) {\n    .wire-column__preview-image-link .logo {\n      background: transparent url(/static/logo-aap-photos-x2.png) 0 0 no-repeat;\n      background-size: 74px 16px; } }\n\n.wire-column__preview-image-link a {\n  margin: 0 8px; }\n\n.wire-column__preview__lead, .wire-column__preview__text {\n  font-size: 0.9375rem;\n  color: #222222;\n  line-height: 1.55; }\n\n.wire-column__preview__text {\n  color: #444444;\n  font-weight: 300; }\n\n.wire-column__preview__tags {\n  display: flex;\n  flex-wrap: wrap;\n  border-top: 1px dotted #cacaca;\n  margin-top: 0;\n  padding-top: 3px; }\n\n.column__preview__tags__box-headline {\n  font-size: 0.875rem;\n  color: #222222;\n  font-weight: 700;\n  margin-bottom: 5px; }\n\n.wire-column__preview__tags__headline {\n  font-size: 0.6875rem;\n  color: #4D4D4D;\n  text-transform: uppercase;\n  letter-spacing: 0.3px;\n  margin-bottom: 5px;\n  display: block; }\n\n.wire-column__preview__tag {\n  font-size: 0.8125rem;\n  background: #EDEDED;\n  color: #444444;\n  white-space: nowrap;\n  display: inline-block;\n  padding: 5px 20px;\n  margin-bottom: 5px;\n  border-radius: 2px;\n  margin-right: 10px; }\n  .wire-column__preview__tag:hover {\n    color: #444444;\n    background: #e2e1e1;\n    text-decoration: none; }\n\n.wire-column__preview__versions {\n  display: flex;\n  flex-direction: column;\n  margin: 20px 0px; }\n\n.wire-column__preview__versions__box-headline {\n  font-size: 0.875rem;\n  color: #222222;\n  font-weight: 700;\n  margin-bottom: 5px; }\n\n.wire-column__preview__versions__item {\n  align-items: center;\n  padding: 10px 0px;\n  border-top: 1px dotted #cacaca;\n  cursor: pointer; }\n\n.wire-column__preview__versions__wrap {\n  display: flex;\n  align-items: center; }\n\n.wire-column__preview__versions__time {\n  font-size: 2.25rem;\n  color: #b6b6b6;\n  font-weight: 300;\n  line-height: 36px;\n  margin-right: 15px; }\n\n.wire-column__preview__versions__meta {\n  font-size: 0.8125rem;\n  color: #747474;\n  line-height: 1.4;\n  display: flex;\n  flex-direction: column; }\n  .wire-column__preview__versions__meta .bold {\n    color: #444;\n    font-weight: 700; }\n\n.wire-column__preview__item__meta-info {\n  display: flex;\n  flex-direction: column; }\n\n.wire-column__preview__versions__headline {\n  font-size: 0.875rem;\n  color: #707070;\n  line-height: 1.3;\n  margin-top: 5px;\n  margin-bottom: 0px; }\n\n.content--item-detail {\n  display: flex;\n  flex: 1;\n  flex-direction: column;\n  overflow-y: auto; }\n\n.content--item-detail .wire-column__preview__buttons {\n  margin-right: 15px; }\n\n.content--item-detail .wire-column__preview__content {\n  max-width: 980px;\n  width: 100%;\n  padding: 0px 20px;\n  background: #fff;\n  box-shadow: 0px 1px 5px rgba(0, 0, 0, 0.2);\n  flex: 1;\n  align-self: center;\n  overflow: initial; }\n  @media only screen and (min-width: 992px) {\n    .content--item-detail .wire-column__preview__content {\n      padding: 0 30px; } }\n\n.content--item-detail .wire-column__preview__headline {\n  line-height: 1.2; }\n  @media only screen and (min-width: 992px) {\n    .content--item-detail .wire-column__preview__headline {\n      line-height: 1.4; } }\n\n.content--item-detail .wire-column__preview__image {\n  margin-bottom: 0;\n  overflow: hidden; }\n  .content--item-detail .wire-column__preview__image > span {\n    display: block;\n    background-color: #2d2d2d; }\n  .content--item-detail .wire-column__preview__image img {\n    display: block;\n    width: auto;\n    max-height: 500px;\n    margin: 0 auto; }\n  @media only screen and (min-width: 992px) {\n    .content--item-detail .wire-column__preview__image {\n      margin-left: -30px;\n      margin-right: -30px; } }\n\n@media only screen and (min-width: 992px) {\n  .content--item-detail .wire-column__preview__caption {\n    float: left;\n    margin: 10px 30px; } }\n\n@media only screen and (min-width: 992px) {\n  .content--item-detail .wire-column__preview-image-link {\n    float: right;\n    margin: 10px 30px; } }\n\n.wire-column__preview__content--item-detal-wrap {\n  overflow: auto;\n  display: flex;\n  flex-direction: column;\n  flex: 1; }\n\n.wire-column__preview__content--item-detail-text-wrap {\n  display: flex;\n  flex-direction: column;\n  margin: 30px 0 20px 0; }\n  @media only screen and (min-width: 992px) {\n    .wire-column__preview__content--item-detail-text-wrap {\n      flex-direction: row; } }\n\n.wire-column__preview__content--item-detail-item-text {\n  order: 2;\n  flex: 1 1 100%;\n  overflow: auto; }\n  @media only screen and (min-width: 992px) {\n    .wire-column__preview__content--item-detail-item-text {\n      margin: 0px 40px 0px 10px; } }\n\n.wire-column__preview__content--item-detail-preformatted-wrap {\n  display: flex;\n  flex-direction: column;\n  margin: 30px 0 20px 0; }\n\n.wire-column__preview__content--item-detail-item-preformatted {\n  order: 2;\n  flex: 1 1 100%; }\n  @media only screen and (min-width: 992px) {\n    .wire-column__preview__content--item-detail-item-preformatted {\n      margin: 0px 40px 0px 10px; } }\n\n.content--item-detail .wire-column__preview__lead, .content--item-detail .wire-column__preview__text {\n  font-size: 1rem; }\n\n.content--item-detail .wire-column__preview__headline {\n  font-size: 2.125rem; }\n\n.content--item-detail .wire-articles__item__meta {\n  order: 1;\n  flex-direction: row; }\n  @media only screen and (min-width: 992px) {\n    .content--item-detail .wire-articles__item__meta {\n      flex-direction: column;\n      flex: 1 0 110px;\n      align-items: flex-start;\n      padding-top: 6px; } }\n\n.content--item-detail .wire-articles__item__meta-info {\n  margin-top: 10px; }\n\n.wire-column__preview__content--item-detail-info-wrap {\n  order: 3;\n  flex: 1 0 auto;\n  margin-bottom: 20px; }\n  @media only screen and (min-width: 992px) {\n    .wire-column__preview__content--item-detail-info-wrap {\n      flex: 1 0 260px;\n      margin-bottom: 0; } }\n\n.content--item-detail .wire-column__preview__tags {\n  border-top: 0px;\n  margin-top: 0px;\n  flex-direction: column; }\n\n.content--item-detail .column__preview__tags__column {\n  border-top: 1px dotted #cacaca;\n  padding: 10px 0px; }\n\n.profileWrap {\n  display: flex;\n  flex-grow: 1;\n  flex-direction: column;\n  background: #fff;\n  overflow-y: auto; }\n  @media only screen and (min-width: 768px) {\n    .profileWrap {\n      flex-direction: row; } }\n\n.profile-side-navigation {\n  width: auto;\n  padding: 20px;\n  overflow: hidden;\n  overflow-y: auto;\n  background: #3e4557;\n  display: flex;\n  flex-direction: column; }\n  @media only screen and (min-width: 768px) {\n    .profile-side-navigation {\n      width: 300px;\n      display: block;\n      padding: 30px 40px; } }\n\n.profile__group {\n  text-align: center;\n  margin-bottom: 16px;\n  margin-right: 30px;\n  min-width: 140px;\n  display: flex; }\n  @media only screen and (min-width: 768px) {\n    .profile__group {\n      display: block;\n      margin-right: 0;\n      margin-bottom: 40px;\n      min-width: auto; } }\n\n.profile__avatar.initials {\n  width: 10%;\n  min-width: 60px;\n  max-width: 128px;\n  margin: 0 auto;\n  border-radius: 100%;\n  background: #e9ecf3;\n  color: #3e4658;\n  border: 2px solid #c5cad6;\n  display: flex;\n  justify-content: center;\n  align-items: center; }\n  .profile__avatar.initials:after {\n    content: \"\";\n    display: table;\n    padding-bottom: 100%; }\n  @media only screen and (min-width: 768px) {\n    .profile__avatar.initials {\n      width: 100%;\n      margin: 0 auto 20px auto; } }\n\n.profile__characters {\n  font-size: 2.125rem; }\n\n.profile__name-container {\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1;\n  justify-content: center;\n  align-items: flex-start;\n  margin-left: 20px; }\n  @media only screen and (min-width: 768px) {\n    .profile__name-container {\n      align-items: stretch;\n      margin-left: 0; } }\n\n.profile__name {\n  font-size: 1rem;\n  margin-bottom: 2px; }\n\n.profile__info {\n  font-size: 0.8125rem;\n  color: #9a9a9a; }\n\n.profile__group.profile__group--dark-bck .profile__avatar.initials {\n  border: 2px solid #8b8f9a;\n  background: #333a4a;\n  color: #fff; }\n\n.profile__group.profile__group--dark-bck .profile__name {\n  color: #fff; }\n\n.profile__group.profile__group--dark-bck .profile__info {\n  color: #9296a0; }\n\n.profile-side-navigation__items {\n  display: flex; }\n  @media only screen and (min-width: 768px) {\n    .profile-side-navigation__items {\n      display: block; } }\n  .profile-side-navigation__items .btn-block {\n    padding: 0.2rem 0.4rem;\n    line-height: 1rem;\n    display: flex;\n    flex-direction: column;\n    justify-content: center; }\n    .profile-side-navigation__items .btn-block + .btn-block {\n      margin-top: 0;\n      margin-left: 10px; }\n    @media only screen and (min-width: 768px) {\n      .profile-side-navigation__items .btn-block {\n        padding: 0.5rem 1rem;\n        line-height: 1.2rem; }\n        .profile-side-navigation__items .btn-block + .btn-block {\n          margin-top: 0.625rem;\n          margin-left: 0; } }\n\n.profile-content {\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1; }\n  .profile-content > .row {\n    display: flex;\n    align-content: flex-start;\n    overflow: auto; }\n\n.profile-content__footer {\n  display: flex;\n  flex-shrink: 0;\n  padding: 15px 0px; }\n  .profile-content__footer > input + input {\n    margin-left: 20px; }\n  .profile-content__footer .btn {\n    padding: 0.4rem 0.6rem;\n    flex-grow: 1; }\n    @media only screen and (min-width: 768px) {\n      .profile-content__footer .btn {\n        padding: 0.5rem 1rem;\n        flex-grow: 0; } }\n\n.profile__mobile-close {\n  position: fixed;\n  top: 6px;\n  right: 4px;\n  width: 38px;\n  height: 38px; }\n\n.modal-forgot-password {\n  font-size: 0.875rem;\n  margin-top: 4px;\n  float: right; }\n\n.simple-card-wrap {\n  margin-bottom: 20px; }\n\n.simple-card {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  background: #fff;\n  box-shadow: 0px 1px 5px rgba(0, 0, 0, 0.2);\n  padding: 6px 15px 10px 15px;\n  border: 4px solid transparent;\n  outline: 1px solid transparent;\n  transition: all .2s ease-out; }\n  .simple-card:hover {\n    border: 4px solid #f5f5f5;\n    outline: 1px solid #c6c6c6; }\n  .simple-card p {\n    font-size: 14px;\n    margin-bottom: auto; }\n  @media only screen and (min-width: 768px) {\n    .simple-card {\n      padding: 10px 25px 16px 25px; } }\n\n.simple-card__header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between; }\n\n.simple-card__headline {\n  flex: 1 1 auto;\n  color: #5f94a7;\n  font-weight: 700;\n  margin: 8px 0px;\n  padding-right: 15px; }\n\n.simple-card__icons {\n  display: flex;\n  flex: 0 0 auto;\n  max-width: 0px;\n  overflow: hidden;\n  transition: max-width 0.2s; }\n  .simple-card__icons > .icon-button {\n    opacity: 0; }\n\n.simple-card .simple-card__icons {\n  max-width: 400px;\n  padding-left: 15px; }\n  .simple-card .simple-card__icons > .icon-button {\n    opacity: 1;\n    transition: opacity 0.2s;\n    transition-delay: 0.2s; }\n\n.simple-card__header-with-icons .simple-card__headline {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap; }\n\n.simple-card__date {\n  font-size: 0.8125rem;\n  margin-top: 10px; }\n  .simple-card__date span {\n    color: #747474; }\n\n.button__reset-styles {\n  background: transparent;\n  border: none;\n  padding: 0px;\n  cursor: pointer; }\n  .button__reset-styles:focus {\n    outline: none; }\n\n.button-pill {\n  font-size: 0.75rem;\n  background: #f3f3f3;\n  padding-right: 1em;\n  padding-left: 1em;\n  border-radius: 10rem;\n  border: none; }\n  .button-pill:hover {\n    background: #e2e2e2; }\n\n.modal, .modal-backdrop {\n  position: absolute; }\n\n.date-round {\n  width: 100%;\n  min-width: 110px;\n  max-width: 180px;\n  margin: 0 auto;\n  border-radius: 100%;\n  background: #f1f1f1;\n  color: #9a9a9a;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  padding: 6px; }\n  .date-round:after {\n    content: \"\";\n    display: table;\n    padding-bottom: 100%; }\n  @media only screen and (min-width: 576px) {\n    .date-round {\n      max-width: 180px; } }\n\n.date-round__wrapper {\n  display: flex;\n  flex-direction: column;\n  align-items: center; }\n\n.date-round__number {\n  font-size: 48px;\n  font-weight: 300;\n  color: #7ed321;\n  line-height: 1.1;\n  letter-spacing: -.1rem; }\n\n.date-round__number--small {\n  font-size: 14px;\n  font-weight: 500;\n  color: #7ed321; }\n\n.date-round__month {\n  font-size: 13px;\n  font-weight: 500; }\n\n.date-round__month--big {\n  font-size: 18px; }\n\n.date-round__day {\n  font-size: 11px;\n  text-transform: uppercase; }\n\n.toggle-background.react-toggle--checked .react-toggle-track {\n  background-color: #00acec !important; }\n\n.react-toggle-track {\n  width: 42px !important;\n  height: 22px !important;\n  background-color: #cccccc !important; }\n\n.react-toggle-thumb {\n  width: 18px !important;\n  height: 18px !important;\n  border: none !important;\n  top: 2px !important;\n  left: 2px !important; }\n\n.react-toggle--checked .react-toggle-thumb {\n  left: 22px !important;\n  border-color: none !important; }\n\n#copy-area {\n  position: absolute;\n  top: 0;\n  left: -1000px; }\n\n@font-face {\n  font-family: \"aap_newsroom_icons\";\n  src: url(\"/static/fonts/aap_newsroom_icons.eot\");\n  src: url(\"/static/fonts/aap_newsroom_icons.eot?#iefix\") format(\"embedded-opentype\"), url(\"/static/fonts/aap_newsroom_icons.woff\") format(\"woff\"), url(\"/static/fonts/aap_newsroom_icons.ttf\") format(\"truetype\"), url(\"/static/fonts/aap_newsroom_icons.svg#aap_newsroom_icons\") format(\"svg\");\n  font-style: normal;\n  font-weight: normal; }\n\n[class^=\"icon--\"], [class*=\" icon--\"] {\n  display: inline-block;\n  width: 24px;\n  height: 24px;\n  line-height: 24px;\n  font-family: 'aap_newsroom_icons';\n  font-size: 24px;\n  color: #00acec;\n  speak: none;\n  font-style: normal;\n  font-weight: normal;\n  font-variant: normal;\n  text-transform: none;\n  /* use !important to prevent issues with browser extensions that change fonts */\n  font-family: 'aap_newsroom_icons' !important;\n  speak: none;\n  font-style: normal;\n  font-weight: normal;\n  font-variant: normal;\n  text-transform: none;\n  line-height: 1;\n  /* Better Font Rendering =========== */\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale; }\n  [class^=\"icon--\"].icon--gray-light, [class*=\" icon--\"].icon--gray-light {\n    color: #c9c9c9; }\n  [class^=\"icon--\"].icon--gray, [class*=\" icon--\"].icon--gray {\n    color: #9a9a9a; }\n  [class^=\"icon--\"].icon--mid-blue, [class*=\" icon--\"].icon--mid-blue {\n    color: #006f98; }\n  [class^=\"icon--\"].icon--white, [class*=\" icon--\"].icon--white {\n    color: #fff; }\n  [class^=\"icon--\"].icon--pink, [class*=\" icon--\"].icon--pink {\n    color: #d50089; }\n\n.icon--alert:before {\n  content: \"\\E600\"; }\n\n.icon--bookmark:before {\n  content: \"\\E601\"; }\n\n.icon--bookmark-add:before {\n  content: \"\\E602\"; }\n\n.icon--calendar:before {\n  content: \"\\E603\"; }\n\n.icon--check:before {\n  content: \"\\E604\"; }\n\n.icon--close-thin:before {\n  content: \"\\E605\"; }\n\n.icon--close-large:before {\n  content: \"\\E606\"; }\n\n.icon--cog:before {\n  content: \"\\E607\"; }\n\n.icon--copy:before {\n  content: \"\\E608\"; }\n\n.icon--dashboard:before {\n  content: \"\\E609\"; }\n\n.icon--download:before {\n  content: \"\\E60A\"; }\n\n.icon--edit:before {\n  content: \"\\E60B\"; }\n\n.icon--grid-view:before {\n  content: \"\\E60C\"; }\n\n.icon--hamburger:before {\n  content: \"\\E60D\"; }\n\n.icon--list-view-compact:before {\n  content: \"\\E60E\"; }\n\n.icon--list-view:before {\n  content: \"\\E60F\"; }\n\n.icon--more:before {\n  content: \"\\E610\"; }\n\n.icon--personal:before {\n  content: \"\\E611\"; }\n\n.icon--photo:before {\n  content: \"\\E612\"; }\n\n.icon--print:before {\n  content: \"\\E613\"; }\n\n.icon--resize:before {\n  content: \"\\E614\"; }\n\n.icon--search:before {\n  content: \"\\E615\"; }\n\n.icon--settings:before {\n  content: \"\\E616\"; }\n\n.icon--share:before {\n  content: \"\\E617\"; }\n\n.icon--sort:before {\n  content: \"\\E618\"; }\n\n.icon--text:before {\n  content: \"\\E619\"; }\n\n.icon--trash:before {\n  content: \"\\E61A\"; }\n\n.icon--bookmark-remove:before {\n  content: \"\\E61B\"; }\n\n.icon--refresh:before {\n  content: \"\\E61C\"; }\n\n.icon--detach:before {\n  content: \"\\E61D\"; }\n\n.icon--report:before {\n  content: \"\\E61E\"; }\n\n.icon--home:before {\n  content: \"\\E61F\"; }\n\n[class^=\"svg-icon--\"], [class*=\" svg-icon--\"] {\n  display: inline-block;\n  width: 18px;\n  height: 18px;\n  line-height: 18px; }\n\n.svg-icon--arrow-right {\n  background-image: url(\"/static/arrow-right-black.svg\"); }\n\n.svg-icon--external-link-blue {\n  background-image: url(\"/static/icon-external-link-blue.svg\"); }\n\n.circle-checkbox .css-checkbox {\n  display: none; }\n  .circle-checkbox .css-checkbox:checked + i {\n    background: #00acec;\n    border-color: #00acec;\n    opacity: 1; }\n    .circle-checkbox .css-checkbox:checked + i:hover:after {\n      opacity: 1; }\n    .circle-checkbox .css-checkbox:checked + i:after {\n      opacity: 1;\n      border-color: white; }\n  .circle-checkbox .css-checkbox + i {\n    box-sizing: border-box; }\n    .circle-checkbox .css-checkbox + i:before, .circle-checkbox .css-checkbox + i:after {\n      box-sizing: border-box; }\n  .circle-checkbox .css-checkbox + i {\n    position: relative;\n    display: inline-block;\n    top: -1px;\n    width: 24px;\n    height: 24px;\n    margin: 0;\n    vertical-align: middle;\n    border: 2px solid rgba(200, 200, 200, 0.4);\n    z-index: 100;\n    transition: background 200ms ease;\n    border-radius: 10em;\n    background-color: rgba(200, 200, 200, 0.1);\n    font-size: 24px;\n    cursor: pointer; }\n    .circle-checkbox .css-checkbox + i:hover:after {\n      opacity: 1; }\n    .circle-checkbox .css-checkbox + i:after {\n      content: '';\n      opacity: 0;\n      transform: translateZ(1px) rotate(-45deg);\n      outline: 1px solid transparent;\n      position: absolute;\n      top: 18%;\n      left: 16%;\n      width: 1rem;\n      height: .5rem;\n      border: 0.16rem solid rgba(200, 200, 200, 0.8);\n      border-top: none;\n      border-right: none;\n      background: rgba(0, 0, 0, 0); }\n\n.icon-button {\n  display: inline-flex;\n  display: -webkit-inline-flex;\n  justify-content: center;\n  -webkit-justify-content: center;\n  align-items: center;\n  -webkit-align-items: center;\n  width: 34px;\n  height: 38px;\n  cursor: pointer;\n  border-style: solid;\n  border-color: transparent;\n  border-width: 1px;\n  border-radius: 0.1875rem;\n  transition: border-color .15s;\n  background-color: transparent;\n  padding: 0 !important; }\n  @media only screen and (min-width: 1200px) {\n    .icon-button {\n      width: 38px; } }\n  @media only screen and (min-width: 1440px) {\n    .icon-button {\n      width: 42px; } }\n  .icon-button:hover {\n    border-color: #00acec; }\n  .icon-button:focus {\n    outline: 0;\n    box-shadow: 0 0 0 2px rgba(0, 172, 236, 0.4); }\n  .icon-button:active {\n    box-shadow: inset 0 1px 0 0 #00acec; }\n  .icon-button--gray-light:hover {\n    border-color: #c9c9c9; }\n  .icon-button--gray-light:focus {\n    outline: 0;\n    box-shadow: 0 0 0 2px rgba(0, 0, 0, 0.12); }\n  .icon-button--gray-light:active {\n    box-shadow: inset 0 1px 0 0 #c9c9c9; }\n\n.box-shadow--z1 {\n  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1), 0 0 1px rgba(0, 0, 0, 0.08) !important;\n  transition: box-shadow 0.3s ease-out; }\n  .box-shadow--z1.btn:active {\n    box-shadow: none !important;\n    transition: box-shadow 0.4s ease-out; }\n\n.box-shadow--z2 {\n  box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1), 0 2px 4px rgba(0, 0, 0, 0.16) !important;\n  transition: box-shadow 0.3s ease-out; }\n  .box-shadow--z2.btn:active {\n    box-shadow: none !important;\n    transition: box-shadow 0.4s ease-out; }\n\n.box-shadow--z3 {\n  box-shadow: 0 1px 6px rgba(0, 0, 0, 0.1), 0 3px 8px rgba(0, 0, 0, 0.24) !important;\n  transition: box-shadow 0.3s ease-out; }\n  .box-shadow--z3.btn:active {\n    box-shadow: none !important;\n    transition: box-shadow 0.4s ease-out; }\n\n.box-shadow--z4 {\n  box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2), 0 6px 16px rgba(0, 0, 0, 0.3) !important;\n  transition: box-shadow 0.3s ease-out; }\n  .box-shadow--z4.btn:active {\n    box-shadow: none !important;\n    transition: box-shadow 0.4s ease-out; }\n\n.overflow-auto {\n  overflow: auto !important; }\n\n.overflow-hidden {\n  overflow: hidden !important; }\n\n.overflow-visible {\n  overflow: visible !important; }\n\n.wire-articles__item-headline,\n.wire-articles__item__text,\n.wire-column__preview__headline,\n.wire-column__preview__lead,\n.wire-column__preview__text,\n.wire-articles__versions__headline,\n.wire-column__preview__versions__headline,\nh1.card-title,\nh2.card-title,\nh3.card-title,\nh4.card-title,\nh5.card-title {\n  font-family: \"Merriweather\", serif; }\n", ""]);

// exports


/***/ })

},[637]);