from .__pytransform import pyarmor_runtime

"""
# MixtureMapping

[![Documentation](https://github.com/VK/dash-express-components/workflows/Publish%20release/badge.svg)](https://vk.github.io/mixturemapping-doc)
[![PyPI version](https://badge.fury.io/py/mixturemapping.svg)](https://badge.fury.io/py/mixturemapping)

Train Gaussian Mixture Mappings


## Provides:
  1. Layers to build tensorflow models to map Gaussian mixtures
  2. Tools to compute yield values of Gaussian mixtures in complex binning schemes

## Example
  
    import mixturemapping as mm  
    import tensorflow as tf

    inMeans = tf.keras.Input(shape=(mixN, inputMixM), name="Means", dtype=dataType)
    inStdDevs = tf.keras.Input(shape=(mixN, inputMixM), name="StdDevs", dtype=dataType)
    inWeight = tf.keras.Input(shape=(mixN), name="Weights", dtype=dataType)

    mapModel = tf.keras.Sequential()
    mapModel.add( tf.keras.layers.Dense(40, activation="relu", kernel_regularizer=regularizers.l2(0.001)) )
    mapModel.add( tf.keras.layers.Dense(40, activation="relu", kernel_regularizer=regularizers.l2(0.001)) )
    mapModel.add( tf.keras.layers.Dense(outputMixM))
    y = mapModel(inMeans)

    deltaModel = tf.keras.Sequential()
    deltaModel.add( tf.keras.layers.Dense(40, activation="relu", kernel_regularizer=regularizers.l2(0.001)) )
    deltaModel.add( tf.keras.layers.Dense(40, activation="relu", kernel_regularizer=regularizers.l2(0.001)) )
    deltaModel.add( tf.keras.layers.Dense(outputMixM))
    yDelta = deltaModel(inMeans)

    covALayer = mm.layers.TrainableCovMatrix(outputMixM, name="CovA")
    covA = covALayer(inMeans)

    mapLayer = mm.layers.GeneralMapping(outputMixM, name="Mapping", dtype=dataType)
    newDist = mapLayer({'means': inMeans, 'y':y, 'yDelta':yDelta, 'stdDevs': inStdDevs, 'weights': inWeight, 'covA': covA})

    distLayer = mm.layers.Distribution(dtype=dataType, regularize_cov_epsilon=0.95)
    dist = distLayer(newDist)

### Developement
```
$ py -m venv env
$ .\env\Scripts\activate
$ pip install -r requirements.txt
```


"""


pyarmor_runtime()
__pyarmor__(__name__, __file__, b'\x50\x59\x41\x52\x4d\x4f\x52\x00\x00\x03\x08\x00\x55\x0d\x0d\x0a\x08\x2d\xa0\x01\x00\x00\x00\x00\x01\x00\x00\x00\x40\x00\x00\x00\xe4\x07\x00\x00\x00\x00\x00\x18\xb2\x95\xc6\xa9\xa3\xb0\x4c\x28\xb5\xb5\xcc\x8e\xf4\x17\x81\x65\x00\x00\x00\x00\x00\x00\x00\x00\xde\x66\x8a\x79\xc7\x9b\xbc\xfb\x3e\xb1\xa6\xdb\xc1\x62\x8f\x23\x18\x42\xf3\xc7\x7a\x62\x18\x89\xf9\x4a\x52\x2b\x4a\xe4\x42\x3e\x87\x8f\x01\x15\x3d\x39\x78\x51\x1f\x9a\x65\x36\x2e\xdc\x1a\x49\x49\x83\xd9\x4b\x56\x3f\xb1\x7d\x3d\x98\x4e\x1c\x42\xee\x94\xc5\xe3\x6a\x68\x06\x73\x19\xf5\x1b\x3b\x27\x25\xf9\x03\x8c\x86\xc6\x19\x2a\x6b\x67\x73\x5e\xf0\xe3\x98\x3a\x14\xd6\x2f\x2d\x49\x4d\xe0\x47\xdf\xef\xde\x3a\x19\x11\xd0\x5c\x66\x24\x56\x0c\xf8\xef\x7d\xf0\x17\x55\xb0\xbd\xf8\x9b\x4c\xd2\x9a\x25\x44\x4e\x51\xd1\xdb\x09\x16\x91\x47\xcb\x28\x37\x17\x0c\xa6\xc1\x75\xac\xaf\x83\xd7\xb0\x5e\x04\x92\xdc\xb3\xc6\x3f\xfb\xc5\x84\xb2\x8c\x80\xf4\xfd\xc2\x6f\x31\xe3\x8f\x1a\x6c\x19\x5e\x11\xad\x1a\xe7\xaa\x1a\x11\x72\x8f\xef\x4f\xdc\x1c\xff\xc3\x32\x90\x05\x0f\x81\xdb\x92\x38\x24\xd6\xf1\x73\x93\xd6\x7f\xb4\xe2\x59\x0a\xbb\xd8\x97\x7d\xc0\x7d\xc2\x16\xcb\xba\x52\xf2\x95\x8f\xb8\x2f\x75\x91\xa8\x5c\x75\x04\xb3\xd1\x91\xc1\x99\xe9\xc2\xff\x10\x40\xe2\xbe\xf4\x82\xb3\xd9\x30\x8f\xa2\x6b\xbf\xbb\x48\xe3\xa9\x4d\xd9\x01\xc3\x32\x0a\xef\xdb\x36\xf1\xa8\x08\xe9\xf0\x39\x00\x02\xa7\x27\xbd\x76\x06\x08\x67\xad\x0b\xeb\xf0\xb0\xfc\x06\xad\x73\xd1\xb8\x8f\x41\xb9\x41\x2b\xf6\xd2\x25\xb1\x12\x1c\x51\xe6\xf7\xe6\x3e\xc6\x45\x8b\x16\xc5\x6d\xd1\x0a\x53\x58\xe5\x4a\x69\xf4\xe8\x4c\xd7\x5c\x55\xc4\xd9\xaf\x0f\xf1\x06\x47\x21\x3f\x04\xe8\x85\xf6\x3a\x7f\x5d\x25\x63\x95\x70\xde\x2d\x79\x4c\x67\x7f\xca\xcb\x79\xab\x7e\xaf\x4c\xa7\x99\xc8\x78\x40\x1a\xb1\x93\x6e\x78\x00\x40\x64\x14\x28\x22\x1c\xf4\x19\x36\xde\x81\xfb\x66\xeb\x36\xdc\x02\x6d\x42\x0a\x8f\x37\xe7\xa7\x45\x76\x2b\x5e\x80\x31\x20\x7a\xa0\x8f\x64\x19\x67\xf8\x20\x4e\x8a\xa8\x53\x76\xa8\x06\x62\xba\xba\x0d\x58\x1d\xb9\xfc\x60\x04\xd5\x8f\x50\xe7\x36\x43\x9a\x78\x4d\xba\x4e\x53\x34\xd1\x87\x57\x1f\x8f\x47\xbe\x87\x10\x3a\xd8\x85\xca\x4e\x79\xc5\xd2\x16\x22\xb7\xff\x37\x58\xb7\xf9\x75\x29\x10\xc6\xa7\x78\x27\x8d\xb9\x19\x82\xa4\x7e\x73\x6c\x57\xaa\x1c\x5f\xd5\x7b\x96\xba\x70\x70\xfb\xb4\x98\x90\x2d\x96\x37\x3c\x25\x1d\xe3\xd5\x06\x23\xaa\xd3\xff\x77\xf0\x39\xd0\x6a\x5b\xa9\x7f\x58\x77\x11\xcf\x60\xed\x19\xff\xa3\x65\x72\xd4\x71\xae\xda\xcc\xae\x38\xa0\x8b\xa6\x9d\x6a\x6d\x02\x22\xb2\xde\x18\x2a\x16\x0a\x86\xcb\xf6\x1a\xeb\xf6\x36\xc4\xfe\x44\x5d\xcd\x50\x47\xd4\x6a\x43\x9d\x25\x39\xda\xcf\xfe\x41\xc1\x32\x0f\x46\x35\x5f\x32\x6f\xf5\x37\x65\x50\xb9\x73\x11\x1e\x6a\x44\xf2\x14\x0a\x8b\x94\xd6\x7f\x89\x0f\x53\xb7\x9c\x1a\x8e\x53\x87\x31\xed\x7f\x81\x3e\xfa\x9e\x00\x4e\x4b\xeb\x19\xec\x1b\xf1\x6b\xa9\x2d\xae\x4d\x9e\x93\x9a\x5c\xf7\xed\x03\xaa\x3c\xf1\xae\x7a\xd7\xee\x2a\x9b\x7a\xbc\xe2\x41\x10\xc9\xb9\xcc\xf1\x10\x45\x7b\x65\x1b\x30\x0b\xbf\x0b\x47\x2a\xce\x16\xa1\xdd\xc2\x80\xed\xe0\x38\x80\xc6\xa1\x99\x3f\xac\x22\x67\xb6\x8a\x2f\x7e\x1b\x6f\xce\xb1\x55\xad\xd6\x4e\x82\x0a\xca\x2f\x69\xdc\xfc\xba\xed\xca\xb8\xf8\x20\x48\x8f\x45\x79\x05\x78\x9c\x72\x82\xea\xb3\x0b\xa3\x90\x66\xa4\xb2\x90\xc8\x5a\xd5\x96\x9e\xee\x83\x6e\x02\xa1\x8c\xf8\x2f\x34\x91\x1d\x5d\x71\x0c\xf1\x09\xa1\xf9\x0b\x04\xe5\x90\x01\x8c\x7a\xcc\x41\xa1\x41\xa9\x01\xc1\xe1\x40\x2a\xeb\xf8\x12\x31\x4b\xce\x98\x75\x88\x0f\x53\x93\x96\x41\x0b\x67\x55\xfb\x8d\xaa\x2c\x8d\x5c\xa9\x69\xf8\xae\x45\x82\x94\xab\x1f\x0e\xae\x78\x3d\x4a\x21\x84\x33\x4f\xaf\x4b\x98\x34\x97\xaf\x6e\x4f\xd6\x22\x5c\xc0\xf1\xfc\xe8\xc7\x71\x02\xba\xe5\xfd\x79\xcf\x33\xe1\x22\x71\xba\x83\x87\x04\xea\xd8\x6c\xdf\x68\xfe\xc0\xdc\xf5\x90\x41\x66\xea\x27\xf1\xf0\xf8\x25\xa4\x46\x85\x7c\xf7\x58\xb3\xaa\x8b\x8f\x55\x13\xd4\x70\xf4\xe2\x15\xd4\x05\x20\xf1\x8c\xf2\xc5\x0b\xc7\xf8\x52\x1c\x7f\x9c\x35\x05\x40\xf1\x09\xfc\xda\x2f\xc3\x17\x8f\x07\xf2\xcb\x3d\x98\x13\xd2\xfa\x70\x24\x4d\x78\x9f\x0c\x25\x68\x03\x8e\x0f\x44\xa6\x34\x59\xc5\x90\xb7\x51\x23\xc7\x5b\x98\x26\xc8\x65\x46\x54\x3b\xe6\x51\x27\xfb\xc0\x97\x22\x3e\x39\x19\xef\xff\xb9\xa6\xdd\x5f\xa1\xae\x73\xa7\x29\x0c\xcf\x10\xfb\x13\x54\x0c\xdb\xda\x60\x73\x95\x10\x02\xb1\x45\x79\xc8\xf7\x99\x10\x58\x46\xb6\xb5\x59\x23\x68\x4c\x2b\x18\xfb\x45\x2e\xbb\x26\xeb\xc2\x65\x41\xec\x2e\x3b\xfa\x28\xb0\xf6\x1a\x65\x98\xfc\x3c\xed\x07\xe4\x20\x6a\x59\x9f\x3f\x83\x76\x60\x23\xa6\xe8\x1f\x5d\x63\x1c\x80\x84\x25\xa7\x99\x12\x24\x29\xf8\x34\x06\x97\x82\x5f\x85\xfa\x1b\x6e\xdc\xd8\x21\x95\xd6\x95\x3e\x50\x5c\x29\x77\x45\x2b\xac\xf8\x96\xa1\xef\xa8\xc7\x97\xee\x55\x3c\x3b\xed\xb9\x32\x71\xe1\x2a\xc9\x8f\x2f\x83\x48\x9e\x4e\xe8\x29\xea\x64\xeb\xc6\x4b\xc9\xd0\xd2\x90\xbf\xb2\x90\x16\x8b\x7a\x04\x89\x05\xfa\x61\x3f\x26\x47\xca\xc3\x49\xb7\xa5\x0c\xf7\xdd\x23\x27\xdd\x9c\xa4\x5f\xf2\x92\x59\xa5\x0f\x09\x4a\x99\xe5\x9c\xe4\xf9\x2b\x7f\xae\xe2\x73\xf3\x29\x6f\x29\x75\xd0\x54\x5f\x10\x22\xc0\xd8\x7a\x84\x3f\x7a\x4c\x99\x5d\x6e\x16\x0a\xdb\x98\x80\xa0\x87\x00\xb0\x0f\xe9\xc2\x36\x44\x1f\xe1\xfd\xc7\xf9\x74\x10\x00\xf1\x3c\x79\x91\x0e\x70\x89\xfd\x11\x80\xd1\x68\x8a\x54\xae\xae\x9f\x90\x81\x94\x18\x37\xc8\x38\xc7\x47\xfd\x83\xd6\xab\x1d\xd8\x36\x69\xb5\xce\x59\xd9\xc4\x5a\xe2\xa1\x7b\xe3\xf4\xea\xb1\x83\x21\xf1\x12\xe0\xb7\x83\xc2\xe5\x89\xba\x2f\x09\xd7\xe7\xa9\x57\x71\xca\x8d\x39\xdb\x98\x26\xc7\x76\x75\x51\x96\x22\x38\x71\xe6\x22\xbd\x36\xe5\x10\x91\x65\xc5\xc6\x47\x9c\x10\xfd\x65\x64\xbe\xfc\xe7\xf2\x70\xba\xdd\xb3\xd8\x08\x1a\xba\xb0\x02\x5b\x08\x75\x37\xbe\xee\x45\x23\xa6\x5a\xaf\xac\x57\x8f\x33\xa3\x07\x52\xfd\x69\x8e\xd5\x41\xc4\x39\x5d\x7f\xce\x31\x94\x30\x64\x1c\xbb\xc9\x27\x30\xa6\x50\x04\x28\xd3\xd4\x52\x34\x33\x0f\xe3\xb2\x99\x6d\x55\xb0\x4c\x8b\x0f\x50\x30\xdd\xd1\xfa\xe0\xb2\xbd\xe2\x44\xfc\xbe\x98\xd3\x75\x4a\x63\xbd\xf6\xed\x1b\x22\x5d\x35\x4b\x4c\x48\x56\x33\x0a\x1f\x78\x29\xac\xd8\x24\x33\xf4\x50\x8c\xab\x9e\x5a\x66\x31\xe5\x27\x36\x8d\xf5\x68\x86\x78\xbb\xa3\x62\x44\xa7\x1d\x8e\xc8\xa5\x64\x50\x22\xe3\x68\x87\x35\x81\xaa\xfe\xf9\x09\xa6\xfc\x6c\xcc\x28\x62\x2f\x2f\x82\xbb\xcf\x2c\xad\xee\x6a\x27\x60\xc4\xfe\x92\x38\x34\x00\x9d\x94\xf6\x0b\x17\xb2\xc9\x1e\x85\x5c\x6e\x44\xc5\x1d\x7a\x6a\x3b\x2b\x88\xcc\xa9\xd1\x9c\x32\xf0\x44\xc2\x07\x44\x52\xb2\x89\x4c\x5c\x3d\x30\x52\x9e\x45\x87\xa7\xbb\xee\xf5\x24\x8a\x06\xef\x02\xd2\xfe\x53\x8d\x38\xa7\xa7\x25\xdf\xe2\x16\x93\xf2\x15\x53\xf6\x9a\xd8\x80\xcf\x43\xee\x1e\xc0\x34\x1f\xdd\x77\x97\xb6\x24\x49\xa5\xf5\x5c\x73\x52\xe1\xe9\xcb\x88\xd6\xc6\x6b\x86\xf3\x25\x13\x02\xba\x50\xf7\x51\x4a\x48\x44\x74\x69\x28\x7f\xb0\x6b\xf8\x46\x01\x4e\xab\x0d\xe3\x02\x92\xaa\xe3\x7b\x0b\xa4\x5e\x34\x3e\x10\x7c\x99\xa1\x15\xbe\x95\x0d\x08\x2a\x08\x0e\x63\x03\xf8\x4b\x6e\x9d\x3f\x7e\xfc\x76\x5e\xc8\x47\x2e\x37\x80\x05\x6a\x28\x51\xe3\xdc\x39\x5a\x94\x44\x92\x8d\x07\x9b\xa5\x14\x31\x39\x91\x10\x6e\x67\xb4\x71\x94\xc0\x18\x05\xd2\x1c\x9d\xe6\x5b\x9b\xcb\x34\x5c\xd9\x81\x8c\x1f\x05\xf2\xc8\x82\x56\x9c\x4c\xc4\x14\x6e\x03\xaa\x84\x35\x54\x1f\x95\xf1\xe1\xeb\x24\xca\x16\x60\x9b\x49\xe8\xd4\x7a\xcd\x9a\x7a\x23\xaf\xbe\xc2\x13\x9e\x34\xec\x4f\x3f\x74\xc9\x04\x94\x57\x3a\x41\xcd\x69\x2a\xf7\x79\x63\x6d\x94\x92\x23\x95\x38\x9c\x92\xe4\xe2\xca\x30\xc2\x6b\xc6\xd0\x19\xc1\x33\x36\x84\xa2\x91\x10\x21\x09\xf5\x32\xdf\x01\xaa\xb3\xdc\xc5\xc2\x17\x02\x9c\x06\x33\x17\xdd\x5c\x98\x50\x98\x93\xef\xc3\xc5\x72\x4d\xaa\x78\xea\xa8\x2d\xa9\x92\x36\x25\x86\x70\xb4\x0b\xbc\xf5\xe7\x7a\xbe\x50\xe8\x45\xea\xe4\x20\xdc\x1d\x79\xc4\x53\x6e\x2a\x66\xc9\x7e\xe7\x3f\x78\x21\x8b\x13\x06\x5f\x65\xfb\xe8\xeb\x10\x38\x8e\x2b\x7b\x22\xb8\x50\x80\x90\xc0\xca\x6f\xf0\x34\x34\xfc\x7f\xc7\xf6\x5f\xd5\xbb\xa9\x02\x63\x6d\x88\x66\x9f\xe3\x37\x3f\x23\x1b\x9e\xf7\xad\x25\x94\xc1\xa8\x22\x93\x91\x28\xa6\x65\x66\x0a\xe0\x38\xf4\x0a\x0d\xdb\xe9\xdf\x5a\xce\x4f\x46\xce\x52\xd6\x6e\x61\x21\x39\x67\x11\x7d\xb0\xbf\xcc\xfa\xc6\xcc\x9c\xb0\xbf\xcc\x7e\x74\x12\x38\xd9\xe7\x3d\x91\x04\x43\x50\xd3\x7a\xc0\x05\x14\x26\x4a\x23\xe0\x0b\x8b\xf7\xff\x12\xd1\xb6\x79\x95\x49\x9b\x95\x38\x92\x0c\x22\x55\xd7\xd4\xd9\x72\x93\x47\x6e\xab\x3c\x1d\xb1\x8f\x12\xb8\x16\x0c\xf0\x3d\x5d\x25\xce\x7c\x0c\x39\x85\xf4\x05\xdc\x10\x24\x48\xa1\x19\x5f\x59\x24\x54\x2c\x17\xe1\x01\xac\xf9\x26\x08\xea\x61\x09\x95\x13\x94\x3b\x31\x08\xd9\x52\xef\x72\xd7\x3c\x7d\x79\xbd\xcb\x72\xa8\xec\x82\x5d\x1d\x54\xab\x38\xed\x64\x1e\x16\xd0\xfa\xe8\xe8\xec\xfc\x29\xb3\xaf\x98\xf4\xa0\x9d\x40\x42\x63\xd0\xe4\x53\xc3\x8c\xf7\xe9\x9d\x3d\x6a\x04\xfb\x78\x77\xd1\x23\xab\xfb\xa4\x8d\xe0\xf6\x0f\x4f\x02\x09\xf9', 2)

# cleanup
del pyarmor_runtime

