import typing
import bl_operators.anim
import bl_operators.assets
import bl_operators.clip
import bl_operators.constraint
import bl_operators.file
import bl_operators.freestyle
import bl_operators.node
import bl_operators.object
import bl_operators.presets
import bl_operators.spreadsheet
import bl_operators.userpref
import bl_operators.view3d
import bl_operators.wm
import bl_ui
import bl_ui.anim
import bl_ui.asset_shelf
import bl_ui.generic_ui_list
import bl_ui.node_add_menu
import bl_ui.node_add_menu_compositor
import bl_ui.node_add_menu_geometry
import bl_ui.node_add_menu_shader
import bl_ui.node_add_menu_texture
import bl_ui.properties_collection
import bl_ui.properties_constraint
import bl_ui.properties_data_armature
import bl_ui.properties_data_bone
import bl_ui.properties_data_camera
import bl_ui.properties_data_curve
import bl_ui.properties_data_curves
import bl_ui.properties_data_empty
import bl_ui.properties_data_gpencil
import bl_ui.properties_data_grease_pencil
import bl_ui.properties_data_lattice
import bl_ui.properties_data_light
import bl_ui.properties_data_lightprobe
import bl_ui.properties_data_mesh
import bl_ui.properties_data_metaball
import bl_ui.properties_data_modifier
import bl_ui.properties_data_pointcloud
import bl_ui.properties_data_shaderfx
import bl_ui.properties_data_speaker
import bl_ui.properties_data_volume
import bl_ui.properties_freestyle
import bl_ui.properties_grease_pencil_common
import bl_ui.properties_mask_common
import bl_ui.properties_material
import bl_ui.properties_material_gpencil
import bl_ui.properties_object
import bl_ui.properties_output
import bl_ui.properties_paint_common
import bl_ui.properties_particle
import bl_ui.properties_physics_cloth
import bl_ui.properties_physics_common
import bl_ui.properties_physics_dynamicpaint
import bl_ui.properties_physics_field
import bl_ui.properties_physics_fluid
import bl_ui.properties_physics_geometry_nodes
import bl_ui.properties_physics_rigidbody
import bl_ui.properties_physics_rigidbody_constraint
import bl_ui.properties_physics_softbody
import bl_ui.properties_render
import bl_ui.properties_scene
import bl_ui.properties_texture
import bl_ui.properties_view_layer
import bl_ui.properties_workspace
import bl_ui.properties_world
import bl_ui.space_clip
import bl_ui.space_console
import bl_ui.space_dopesheet
import bl_ui.space_filebrowser
import bl_ui.space_graph
import bl_ui.space_image
import bl_ui.space_info
import bl_ui.space_nla
import bl_ui.space_node
import bl_ui.space_outliner
import bl_ui.space_properties
import bl_ui.space_sequencer
import bl_ui.space_spreadsheet
import bl_ui.space_statusbar
import bl_ui.space_text
import bl_ui.space_time
import bl_ui.space_toolsystem_common
import bl_ui.space_toolsystem_toolbar
import bl_ui.space_topbar
import bl_ui.space_userpref
import bl_ui.space_view3d
import bl_ui.space_view3d_toolbar
import bpy
import mathutils

GenericType = typing.TypeVar("GenericType")

class bpy_prop_array(typing.Generic[GenericType]):
    def foreach_get(self, attr, seq):
        """

        :param attr:
        :type attr:
        :param seq:
        :type seq:
        """
        ...

    def foreach_set(self, attr, seq):
        """

        :param attr:
        :type attr:
        :param seq:
        :type seq:
        """
        ...

    def __getitem__(self, key: typing.Union[int, str]) -> GenericType:
        """

        :param key:
        :type key: typing.Union[int, str]
        :rtype: GenericType
        """
        ...

    def __setitem__(self, key: typing.Union[int, str], value: GenericType):
        """

        :param key:
        :type key: typing.Union[int, str]
        :param value:
        :type value: GenericType
        """
        ...

    def __delitem__(self, key: typing.Union[int, str]) -> GenericType:
        """

        :param key:
        :type key: typing.Union[int, str]
        :rtype: GenericType
        """
        ...

    def __iter__(self) -> typing.Iterator[GenericType]:
        """

        :rtype: typing.Iterator[GenericType]
        """
        ...

    def __next__(self) -> GenericType:
        """

        :rtype: GenericType
        """
        ...

    def __len__(self) -> int:
        """

        :rtype: int
        """
        ...

class bpy_struct(typing.Generic[GenericType]):
    """built-in base class for all classes in bpy.types."""

    id_data: typing.Any
    """ The `bpy.types.ID` object this datablock is from or None, (not available for all data types)"""

    def as_pointer(self) -> int:
        """Returns the memory address which holds a pointer to Blender's internal data

        :rtype: int
        :return: int (memory address).
        """
        ...

    def driver_add(
        self, path: typing.Optional[str], index: typing.Optional[int] = -1
    ) -> "FCurve":
        """Adds driver(s) to the given property

        :param path: path to the property to drive, analogous to the fcurve's data path.
        :type path: typing.Optional[str]
        :param index: array index of the property drive. Defaults to -1 for all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :rtype: 'FCurve'
        :return: The driver(s) added.
        """
        ...

    def driver_remove(
        self, path: typing.Optional[str], index: typing.Optional[int] = -1
    ) -> bool:
        """Remove driver(s) from the given property

        :param path: path to the property to drive, analogous to the fcurve's data path.
        :type path: typing.Optional[str]
        :param index: array index of the property drive. Defaults to -1 for all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :rtype: bool
        :return: Success of driver removal.
        """
        ...

    def get(
        self, key: typing.Optional[str], default: typing.Optional[typing.Any] = None
    ):
        """Returns the value of the custom property assigned to key or default
        when not found (matches Python's dictionary function of the same name).

                :param key: The key associated with the custom property.
                :type key: typing.Optional[str]
                :param default: Optional argument for the value to return if
        key is not found.
                :type default: typing.Optional[typing.Any]
        """
        ...

    def id_properties_clear(self):
        """

        :return: Remove the parent group for an RNA struct's custom IDProperties.
        """
        ...

    def id_properties_ensure(self) -> typing.Any:
        """

        :rtype: typing.Any
        :return: the parent group for an RNA struct's custom IDProperties.
        """
        ...

    def id_properties_ui(self, key) -> typing.Any:
        """

        :param key: String name of the property.
        :type key:
        :rtype: typing.Any
        :return: Return an object used to manage an IDProperty's UI data.
        """
        ...

    def is_property_hidden(self, property) -> bool:
        """Check if a property is hidden.

        :param property:
        :type property:
        :rtype: bool
        :return: True when the property is hidden.
        """
        ...

    def is_property_overridable_library(self, property) -> bool:
        """Check if a property is overridable.

        :param property:
        :type property:
        :rtype: bool
        :return: True when the property is overridable.
        """
        ...

    def is_property_readonly(self, property) -> bool:
        """Check if a property is readonly.

        :param property:
        :type property:
        :rtype: bool
        :return: True when the property is readonly (not writable).
        """
        ...

    def is_property_set(self, property, ghost: typing.Optional[bool] = True) -> bool:
        """Check if a property is set, use for testing operator properties.

                :param property:
                :type property:
                :param ghost: Used for operators that re-run with previous settings.
        In this case the property is not marked as set,
        yet the value from the previous execution is used.

        In rare cases you may want to set this option to false.
                :type ghost: typing.Optional[bool]
                :rtype: bool
                :return: True when the property has been set.
        """
        ...

    def items(self) -> typing.Any:
        """Returns the items of this objects custom properties (matches Python's
        dictionary function of the same name).

                :rtype: typing.Any
                :return: custom property key, value pairs.
        """
        ...

    def keyframe_delete(
        self,
        data_path: typing.Optional[str],
        index: typing.Optional[int] = -1,
        frame: typing.Optional[float] = None,
        group: typing.Optional[str] = "",
    ) -> bool:
        """Remove a keyframe from this properties fcurve.

        :param data_path: path to the property to remove a key, analogous to the fcurve's data path.
        :type data_path: typing.Optional[str]
        :param index: array index of the property to remove a key. Defaults to -1 removing all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :param frame: The frame on which the keyframe is deleted, defaulting to the current frame.
        :type frame: typing.Optional[float]
        :param group: The name of the group the F-Curve should be added to if it doesn't exist yet.
        :type group: typing.Optional[str]
        :rtype: bool
        :return: Success of keyframe deletion.
        """
        ...

    def keyframe_insert(
        self,
        data_path: typing.Optional[str],
        index: typing.Optional[int] = -1,
        frame: typing.Optional[float] = None,
        group: typing.Optional[str] = "",
        options=None(),
    ) -> bool:
        """Insert a keyframe on the property given, adding fcurves and animation data when necessary.This is the most simple example of inserting a keyframe from python.Note that when keying data paths which contain nested properties this must be
        done from the `ID` subclass, in this case the `Armature` rather
        than the bone.

                :param data_path: path to the property to key, analogous to the fcurve's data path.
                :type data_path: typing.Optional[str]
                :param index: array index of the property to key.
        Defaults to -1 which will key all indices or a single channel if the property is not an array.
                :type index: typing.Optional[int]
                :param frame: The frame on which the keyframe is inserted, defaulting to the current frame.
                :type frame: typing.Optional[float]
                :param group: The name of the group the F-Curve should be added to if it doesn't exist yet.
                :type group: typing.Optional[str]
                :param options: Optional set of flags:

        INSERTKEY_NEEDED Only insert keyframes where they're needed in the relevant F-Curves.

        INSERTKEY_VISUAL Insert keyframes based on 'visual transforms'.

        INSERTKEY_XYZ_TO_RGB Color for newly added transformation F-Curves (Location, Rotation, Scale) is based on the transform axis.

        INSERTKEY_REPLACE Only replace already existing keyframes.

        INSERTKEY_AVAILABLE Only insert into already existing F-Curves.

        INSERTKEY_CYCLE_AWARE Take cyclic extrapolation into account (Cycle-Aware Keying option).
                :type options:
                :rtype: bool
                :return: Success of keyframe insertion.
        """
        ...

    def keys(self) -> typing.Any:
        """Returns the keys of this objects custom properties (matches Python's
        dictionary function of the same name).

                :rtype: typing.Any
                :return: custom property keys.
        """
        ...

    def path_from_id(self, property: typing.Optional[str] = "") -> str:
        """Returns the data path from the ID to this object (string).

                :param property: Optional property name which can be used if the path is
        to a property of this object.
                :type property: typing.Optional[str]
                :rtype: str
                :return: The path from `bpy.types.bpy_struct.id_data`
        to this struct and property (when given).
        """
        ...

    def path_resolve(
        self, path: typing.Optional[str], coerce: typing.Optional[bool] = True
    ):
        """Returns the property from the path, raise an exception when not found.

                :param path: path which this property resolves.
                :type path: typing.Optional[str]
                :param coerce: optional argument, when True, the property will be converted
        into its Python representation.
                :type coerce: typing.Optional[bool]
        """
        ...

    def pop(
        self, key: typing.Optional[str], default: typing.Optional[typing.Any] = None
    ):
        """Remove and return the value of the custom property assigned to key or default
        when not found (matches Python's dictionary function of the same name).

                :param key: The key associated with the custom property.
                :type key: typing.Optional[str]
                :param default: Optional argument for the value to return if
        key is not found.
                :type default: typing.Optional[typing.Any]
        """
        ...

    def property_overridable_library_set(self, property, overridable) -> bool:
        """Define a property as overridable or not (only for custom properties!).

        :param property:
        :type property:
        :param overridable:
        :type overridable:
        :rtype: bool
        :return: True when the overridable status of the property was successfully set.
        """
        ...

    def property_unset(self, property):
        """Unset a property, will use default value afterward.

        :param property:
        :type property:
        """
        ...

    def type_recast(self) -> "bpy_struct":
        """Return a new instance, this is needed because types
        such as textures can be changed at runtime.

                :rtype: 'bpy_struct'
                :return: a new instance of this object with the type initialized again.
        """
        ...

    def values(self) -> typing.Any:
        """Returns the values of this objects custom properties (matches Python's
        dictionary function of the same name).

                :rtype: typing.Any
                :return: custom property values.
        """
        ...

    def __getitem__(self, key: typing.Union[int, str]) -> typing.Any:
        """

        :param key:
        :type key: typing.Union[int, str]
        :rtype: typing.Any
        """
        ...

    def __setitem__(self, key: typing.Union[int, str], value: typing.Any):
        """

        :param key:
        :type key: typing.Union[int, str]
        :param value:
        :type value: typing.Any
        """
        ...

    def __delitem__(self, key: typing.Union[int, str]) -> typing.Any:
        """

        :param key:
        :type key: typing.Union[int, str]
        :rtype: typing.Any
        """
        ...

class bpy_prop_collection(typing.Generic[GenericType]):
    """built-in class used for all collections."""

    def find(self, key: typing.Optional[str]) -> int:
        """Returns the index of a key in a collection or -1 when not found
        (matches Python's string find function of the same name).

                :param key: The identifier for the collection member.
                :type key: typing.Optional[str]
                :rtype: int
                :return: index of the key.
        """
        ...

    def foreach_get(self, attr, seq):
        """This is a function to give fast access to attributes within a collection.Only works for 'basic type' properties (bool, int and float)!
        Multi-dimensional arrays (like array of vectors) will be flattened into seq.

                :param attr:
                :type attr:
                :param seq:
                :type seq:
        """
        ...

    def foreach_set(self, attr, seq):
        """This is a function to give fast access to attributes within a collection.Only works for 'basic type' properties (bool, int and float)!
        seq must be uni-dimensional, multi-dimensional arrays (like array of vectors) will be re-created from it.

                :param attr:
                :type attr:
                :param seq:
                :type seq:
        """
        ...

    def get(
        self, key: typing.Optional[str], default: typing.Optional[typing.Any] = None
    ):
        """Returns the value of the item assigned to key or default when not found
        (matches Python's dictionary function of the same name).

                :param key: The identifier for the collection member.
                :type key: typing.Optional[str]
                :param default: Optional argument for the value to return if
        key is not found.
                :type default: typing.Optional[typing.Any]
        """
        ...

    def items(self) -> typing.List:
        """Return the identifiers of collection members
        (matching Python's dict.items() functionality).

                :rtype: typing.List
                :return: (key, value) pairs for each member of this collection.
        """
        ...

    def keys(self) -> typing.List[str]:
        """Return the identifiers of collection members
        (matching Python's dict.keys() functionality).

                :rtype: typing.List[str]
                :return: the identifiers for each member of this collection.
        """
        ...

    def values(self) -> typing.List:
        """Return the values of collection
        (matching Python's dict.values() functionality).

                :rtype: typing.List
                :return: the members of this collection.
        """
        ...

    def __getitem__(self, key: typing.Union[int, str]) -> GenericType:
        """

        :param key:
        :type key: typing.Union[int, str]
        :rtype: GenericType
        """
        ...

    def __setitem__(self, key: typing.Union[int, str], value: GenericType):
        """

        :param key:
        :type key: typing.Union[int, str]
        :param value:
        :type value: GenericType
        """
        ...

    def __delitem__(self, key: typing.Union[int, str]) -> GenericType:
        """

        :param key:
        :type key: typing.Union[int, str]
        :rtype: GenericType
        """
        ...

    def __iter__(self) -> typing.Iterator[GenericType]:
        """

        :rtype: typing.Iterator[GenericType]
        """
        ...

    def __next__(self) -> GenericType:
        """

        :rtype: GenericType
        """
        ...

    def __len__(self) -> int:
        """

        :rtype: int
        """
        ...

class Depsgraph:
    ids: bpy_prop_collection["ID"]
    """ All evaluated data-blocks

    :type: bpy_prop_collection['ID']
    """

    mode: typing.Union[int, str]
    """ Evaluation mode

    :type: typing.Union[int, str]
    """

    object_instances: bpy_prop_collection["DepsgraphObjectInstance"]
    """ All object instances to display or render (Warning: Only use this as an iterator, never as a sequence, and do not keep any references to its items)

    :type: bpy_prop_collection['DepsgraphObjectInstance']
    """

    objects: bpy_prop_collection["Object"]
    """ Evaluated objects in the dependency graph

    :type: bpy_prop_collection['Object']
    """

    scene: "Scene"
    """ Original scene dependency graph is built for

    :type: 'Scene'
    """

    scene_eval: "Scene"
    """ Scene at its evaluated state

    :type: 'Scene'
    """

    updates: bpy_prop_collection["DepsgraphUpdate"]
    """ Updates to data-blocks

    :type: bpy_prop_collection['DepsgraphUpdate']
    """

    view_layer: "ViewLayer"
    """ Original view layer dependency graph is built for

    :type: 'ViewLayer'
    """

    view_layer_eval: "ViewLayer"
    """ View layer at its evaluated state

    :type: 'ViewLayer'
    """

    def debug_relations_graphviz(self, filepath: typing.Union[str, typing.Any]):
        """debug_relations_graphviz

        :param filepath: File Name, Output path for the graphviz debug file
        :type filepath: typing.Union[str, typing.Any]
        """
        ...

    def debug_stats_gnuplot(
        self,
        filepath: typing.Union[str, typing.Any],
        output_filepath: typing.Union[str, typing.Any],
    ):
        """debug_stats_gnuplot

        :param filepath: File Name, Output path for the gnuplot debug file
        :type filepath: typing.Union[str, typing.Any]
        :param output_filepath: Output File Name, File name where gnuplot script will save the result
        :type output_filepath: typing.Union[str, typing.Any]
        """
        ...

    def debug_tag_update(self):
        """debug_tag_update"""
        ...

    def debug_stats(self) -> typing.Union[str, typing.Any]:
        """Report the number of elements in the Dependency Graph

        :rtype: typing.Union[str, typing.Any]
        :return: result
        """
        ...

    def update(self):
        """Re-evaluate any modified data-blocks, for example for animation or modifiers. This invalidates all references to evaluated data-blocks from this dependency graph."""
        ...

    def id_eval_get(self, id: typing.Optional["ID"]) -> "ID":
        """id_eval_get

        :param id: Original ID to get evaluated complementary part for
        :type id: typing.Optional['ID']
        :rtype: 'ID'
        :return: Evaluated ID for the given original one
        """
        ...

    def id_type_updated(self, id_type: typing.Optional[typing.Union[int, str]]) -> bool:
        """id_type_updated

        :param id_type: ID Type
        :type id_type: typing.Optional[typing.Union[int, str]]
        :rtype: bool
        :return: Updated, True if any datablock with this type was added, updated or removed
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FileHandler:
    """Extends functionality to operators that manages files, such as adding drag and drop support"""

    bl_file_extensions: typing.Union[str, typing.Any]
    """ Formatted string of file extensions supported by the file handler, each extension should start with a "." and be separated by ";".
For Example: ".blend;.ble"

    :type: typing.Union[str, typing.Any]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the file handler gets a custom ID, otherwise it takes the name of the class used to define the file handler (for example, if the class name is "OBJECT_FH_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_FH_hello")

    :type: typing.Union[str, typing.Any]
    """

    bl_import_operator: typing.Union[str, typing.Any]
    """ Operator that can handle import files with the extensions given in bl_file_extensions

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ The file handler label

    :type: typing.Union[str, typing.Any]
    """

    def poll_drop(self, context: typing.Optional["Context"]) -> bool:
        """If this method returns True, can be used to handle the drop of a drag-and-drop action

        :param context:
        :type context: typing.Optional['Context']
        :rtype: bool
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class HydraRenderEngine:
    """Base class from USD Hydra based renderers"""

    def get_render_settings(self, engine_type):
        """Provide render settings for HdRenderDelegate.

        :param engine_type:
        :type engine_type:
        """
        ...

    def render(self, depsgraph):
        """

        :param depsgraph:
        :type depsgraph:
        """
        ...

    def update(self, data, depsgraph):
        """

        :param data:
        :type data:
        :param depsgraph:
        :type depsgraph:
        """
        ...

    def view_draw(self, context, depsgraph):
        """

        :param context:
        :type context:
        :param depsgraph:
        :type depsgraph:
        """
        ...

    def view_update(self, context, depsgraph):
        """

        :param context:
        :type context:
        :param depsgraph:
        :type depsgraph:
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Image:
    """Image data-block referencing an external or packed image"""

    alpha_mode: typing.Union[int, str]
    """ Representation of alpha in the image file, to convert to and from when saving and loading the image

    :type: typing.Union[int, str]
    """

    bindcode: int
    """ OpenGL bindcode

    :type: int
    """

    channels: int
    """ Number of channels in pixels buffer

    :type: int
    """

    colorspace_settings: "ColorManagedInputColorspaceSettings"
    """ Input color space settings

    :type: 'ColorManagedInputColorspaceSettings'
    """

    depth: int
    """ Image bit depth

    :type: int
    """

    display_aspect: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Display Aspect for this image, does not affect rendering

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    file_format: typing.Union[int, str]
    """ Format used for re-saving this file

    :type: typing.Union[int, str]
    """

    filepath: typing.Union[str, typing.Any]
    """ Image/Movie file name

    :type: typing.Union[str, typing.Any]
    """

    filepath_raw: typing.Union[str, typing.Any]
    """ Image/Movie file name (without data refreshing)

    :type: typing.Union[str, typing.Any]
    """

    frame_duration: int
    """ Duration (in frames) of the image (1 when not a video/sequence)

    :type: int
    """

    generated_color: bpy_prop_array[float]
    """ Fill color for the generated image

    :type: bpy_prop_array[float]
    """

    generated_height: int
    """ Generated image height

    :type: int
    """

    generated_type: typing.Union[int, str]
    """ Generated image type

    :type: typing.Union[int, str]
    """

    generated_width: int
    """ Generated image width

    :type: int
    """

    has_data: typing.Union[bool, typing.Any]
    """ True if the image data is loaded into memory

    :type: typing.Union[bool, typing.Any]
    """

    is_dirty: typing.Union[bool, typing.Any]
    """ Image has changed and is not saved

    :type: typing.Union[bool, typing.Any]
    """

    is_float: typing.Union[bool, typing.Any]
    """ True if this image is stored in floating-point buffer

    :type: typing.Union[bool, typing.Any]
    """

    is_multiview: typing.Union[bool, typing.Any]
    """ Image has more than one view

    :type: typing.Union[bool, typing.Any]
    """

    is_stereo_3d: typing.Union[bool, typing.Any]
    """ Image has left and right views

    :type: typing.Union[bool, typing.Any]
    """

    packed_file: "PackedFile"
    """ First packed file of the image

    :type: 'PackedFile'
    """

    packed_files: bpy_prop_collection["ImagePackedFile"]
    """ Collection of packed images

    :type: bpy_prop_collection['ImagePackedFile']
    """

    pixels: float
    """ Image buffer pixels in floating-point values

    :type: float
    """

    render_slots: bpy_prop_collection["RenderSlot"]
    """ Render slots of the image

    :type: bpy_prop_collection['RenderSlot']
    """

    resolution: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ X/Y pixels per meter, for the image buffer

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    seam_margin: int
    """ Margin to take into account when fixing UV seams during painting. Higher number would improve seam-fixes for mipmaps, but decreases performance

    :type: int
    """

    size: bpy_prop_array[int]
    """ Width and height of the image buffer in pixels, zero when image data can't be loaded

    :type: bpy_prop_array[int]
    """

    source: typing.Union[int, str]
    """ Where the image comes from

    :type: typing.Union[int, str]
    """

    stereo_3d_format: "Stereo3dFormat"
    """ Settings for stereo 3d

    :type: 'Stereo3dFormat'
    """

    tiles: bpy_prop_collection["UDIMTile"]
    """ Tiles of the image

    :type: bpy_prop_collection['UDIMTile']
    """

    type: typing.Union[int, str]
    """ How to generate the image

    :type: typing.Union[int, str]
    """

    use_deinterlace: bool
    """ Deinterlace movie file on load

    :type: bool
    """

    use_generated_float: bool
    """ Generate floating-point buffer

    :type: bool
    """

    use_half_precision: bool
    """ Use 16 bits per channel to lower the memory usage during rendering

    :type: bool
    """

    use_multiview: bool
    """ Use Multiple Views (when available)

    :type: bool
    """

    use_view_as_render: bool
    """ Apply render part of display transformation when displaying this image on the screen

    :type: bool
    """

    views_format: typing.Union[int, str]
    """ Mode to load image views

    :type: typing.Union[int, str]
    """

    def save_render(
        self,
        filepath: typing.Union[str, typing.Any],
        scene: typing.Optional["Scene"] = None,
        quality: typing.Optional[typing.Any] = 0,
    ):
        """Save image to a specific path using a scenes render settings

        :param filepath: Output path
        :type filepath: typing.Union[str, typing.Any]
        :param scene: Scene to take image parameters from
        :type scene: typing.Optional['Scene']
        :param quality: Quality, Quality for image formats that support lossy compression, uses default quality if not specified
        :type quality: typing.Optional[typing.Any]
        """
        ...

    def save(
        self,
        filepath: typing.Union[str, typing.Any] = "",
        quality: typing.Optional[typing.Any] = 0,
    ):
        """Save image

        :param filepath: Output path, uses image data-block filepath if not specified
        :type filepath: typing.Union[str, typing.Any]
        :param quality: Quality, Quality for image formats that support lossy compression, uses default quality if not specified
        :type quality: typing.Optional[typing.Any]
        """
        ...

    def pack(
        self,
        data: typing.Union[str, typing.Any] = "",
        data_len: typing.Optional[typing.Any] = 0,
    ):
        """Pack an image as embedded data into the .blend file

        :param data: data, Raw data (bytes, exact content of the embedded file)
        :type data: typing.Union[str, typing.Any]
        :param data_len: data_len, length of given data (mandatory if data is provided)
        :type data_len: typing.Optional[typing.Any]
        """
        ...

    def unpack(self, method: typing.Optional[typing.Any] = "USE_LOCAL"):
        """Save an image packed in the .blend file to disk

        :param method: method, How to unpack
        :type method: typing.Optional[typing.Any]
        """
        ...

    def reload(self):
        """Reload the image from its source path"""
        ...

    def update(self):
        """Update the display image from the floating-point buffer"""
        ...

    def scale(
        self,
        width: typing.Optional[int],
        height: typing.Optional[int],
        frame: typing.Optional[typing.Any] = 0,
        tile_index: typing.Optional[typing.Any] = 0,
    ):
        """Scale the buffer of the image, in pixels

        :param width: Width
        :type width: typing.Optional[int]
        :param height: Height
        :type height: typing.Optional[int]
        :param frame: Frame, Frame (for image sequences)
        :type frame: typing.Optional[typing.Any]
        :param tile_index: Tile, Tile index (for tiled images)
        :type tile_index: typing.Optional[typing.Any]
        """
        ...

    def gl_touch(
        self,
        frame: typing.Optional[typing.Any] = 0,
        layer_index: typing.Optional[typing.Any] = 0,
        pass_index: typing.Optional[typing.Any] = 0,
    ) -> int:
        """Delay the image from being cleaned from the cache due inactivity

        :param frame: Frame, Frame of image sequence or movie
        :type frame: typing.Optional[typing.Any]
        :param layer_index: Layer, Index of layer that should be loaded
        :type layer_index: typing.Optional[typing.Any]
        :param pass_index: Pass, Index of pass that should be loaded
        :type pass_index: typing.Optional[typing.Any]
        :rtype: int
        :return: Error, OpenGL error value
        """
        ...

    def gl_load(
        self,
        frame: typing.Optional[typing.Any] = 0,
        layer_index: typing.Optional[typing.Any] = 0,
        pass_index: typing.Optional[typing.Any] = 0,
    ) -> int:
        """Load the image into an OpenGL texture. On success, image.bindcode will contain the OpenGL texture bindcode. Colors read from the texture will be in scene linear color space and have premultiplied or straight alpha matching the image alpha mode

        :param frame: Frame, Frame of image sequence or movie
        :type frame: typing.Optional[typing.Any]
        :param layer_index: Layer, Index of layer that should be loaded
        :type layer_index: typing.Optional[typing.Any]
        :param pass_index: Pass, Index of pass that should be loaded
        :type pass_index: typing.Optional[typing.Any]
        :rtype: int
        :return: Error, OpenGL error value
        """
        ...

    def gl_free(self):
        """Free the image from OpenGL graphics memory"""
        ...

    def filepath_from_user(
        self, image_user: typing.Optional["ImageUser"] = None
    ) -> typing.Union[str, typing.Any]:
        """Return the absolute path to the filepath of an image frame specified by the image user

        :param image_user: Image user of the image to get filepath for
        :type image_user: typing.Optional['ImageUser']
        :rtype: typing.Union[str, typing.Any]
        :return: File Path, The resulting filepath from the image and its user
        """
        ...

    def buffers_free(self):
        """Free the image buffers from memory"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Menu:
    """Editor menu containing buttons"""

    bl_description: str
    """ 

    :type: str
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the menu gets a custom ID, otherwise it takes the name of the class used to define the menu (for example, if the class name is "OBJECT_MT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_MT_hello")

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ The menu label

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Options for this menu type

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    bl_owner_id: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_translation_context: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    layout: "UILayout"
    """ Defines the structure of the menu in the UI

    :type: 'UILayout'
    """

    def poll(self, context: typing.Optional["Context"]) -> bool:
        """If this method returns a non-null output, then the menu can be drawn

        :param context:
        :type context: typing.Optional['Context']
        :rtype: bool
        """
        ...

    def draw(self, context: typing.Optional["Context"]):
        """Draw UI elements into the menu UI layout

        :param context:
        :type context: typing.Optional['Context']
        """
        ...

    def draw_preset(self, _context):
        """Define these on the subclass:
        - preset_operator (string)
        - preset_subdir (string)Optionally:
        - preset_add_operator (string)
        - preset_extensions (set of strings)
        - preset_operator_defaults (dict of keyword args)

                :param _context:
                :type _context:
        """
        ...

    def path_menu(
        self,
        searchpaths: typing.Optional[typing.List[str]],
        operator: typing.Optional[str],
        *,
        props_default: typing.Optional[typing.Dict] = None,
        prop_filepath: typing.Optional[str] = "filepath",
        filter_ext: typing.Optional[typing.Callable] = None,
        filter_path=None,
        display_name: typing.Optional[typing.Callable] = None,
        add_operator=None,
    ):
        """Populate a menu from a list of paths.

                :param searchpaths: Paths to scan.
                :type searchpaths: typing.Optional[typing.List[str]]
                :param operator: The operator id to use with each file.
                :type operator: typing.Optional[str]
                :param *:
                :type *:
                :param props_default: Properties to assign to each operator.
                :type props_default: typing.Optional[typing.Dict]
                :param prop_filepath: Optional operator filepath property (defaults to "filepath").
                :type prop_filepath: typing.Optional[str]
                :param filter_ext: Optional callback that takes the file extensions.

        Returning false excludes the file from the list.
                :type filter_ext: typing.Optional[typing.Callable]
                :param filter_path:
                :type filter_path:
                :param display_name: Optional callback that takes the full path, returns the name to display.
                :type display_name: typing.Optional[typing.Callable]
                :param add_operator:
                :type add_operator:
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

    def append(self, draw_func):
        """

        :param draw_func:
        :type draw_func:
        """
        ...

    def prepend(self, draw_func):
        """

        :param draw_func:
        :type draw_func:
        """
        ...

    def remove(self, draw_func):
        """

        :param draw_func:
        :type draw_func:
        """
        ...

class Mesh:
    """Mesh data-block defining geometric surfaces"""

    animation_data: "AnimData"
    """ Animation data for this data-block

    :type: 'AnimData'
    """

    attributes: bpy_prop_collection["Attribute"]
    """ Geometry attributes

    :type: bpy_prop_collection['Attribute']
    """

    auto_texspace: bool
    """ Adjust active object's texture space automatically when transforming object

    :type: bool
    """

    color_attributes: bpy_prop_collection["Attribute"]
    """ Geometry color attributes

    :type: bpy_prop_collection['Attribute']
    """

    corner_normals: bpy_prop_collection["MeshNormalValue"]
    """ The "slit" normal direction of each face corner, influenced by vertex normals, sharp faces, sharp edges, and custom normals. May be empty

    :type: bpy_prop_collection['MeshNormalValue']
    """

    cycles: typing.Any
    """ Cycles mesh settings

    :type: typing.Any
    """

    edges: bpy_prop_collection["MeshEdge"]
    """ Edges of the mesh

    :type: bpy_prop_collection['MeshEdge']
    """

    has_custom_normals: typing.Union[bool, typing.Any]
    """ True if there are custom split normals data in this mesh

    :type: typing.Union[bool, typing.Any]
    """

    is_editmode: typing.Union[bool, typing.Any]
    """ True when used in editmode

    :type: typing.Union[bool, typing.Any]
    """

    loop_triangle_polygons: bpy_prop_collection["ReadOnlyInteger"]
    """ The face index for each loop triangle

    :type: bpy_prop_collection['ReadOnlyInteger']
    """

    loop_triangles: bpy_prop_collection["MeshLoopTriangle"]
    """ Tessellation of mesh polygons into triangles

    :type: bpy_prop_collection['MeshLoopTriangle']
    """

    loops: bpy_prop_collection["MeshLoop"]
    """ Loops of the mesh (face corners)

    :type: bpy_prop_collection['MeshLoop']
    """

    materials: bpy_prop_collection["Material"]
    """ 

    :type: bpy_prop_collection['Material']
    """

    normals_domain: typing.Union[int, str]
    """ The attribute domain that gives enough information to represent the mesh's normals

    :type: typing.Union[int, str]
    """

    polygon_normals: bpy_prop_collection["MeshNormalValue"]
    """ The normal direction of each face, defined by the winding order and position of its vertices

    :type: bpy_prop_collection['MeshNormalValue']
    """

    polygons: bpy_prop_collection["MeshPolygon"]
    """ Polygons of the mesh

    :type: bpy_prop_collection['MeshPolygon']
    """

    remesh_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    remesh_voxel_adaptivity: float
    """ Reduces the final face count by simplifying geometry where detail is not needed, generating triangles. A value greater than 0 disables Fix Poles

    :type: float
    """

    remesh_voxel_size: float
    """ Size of the voxel in object space used for volume evaluation. Lower values preserve finer details

    :type: float
    """

    shape_keys: "Key"
    """ 

    :type: 'Key'
    """

    skin_vertices: bpy_prop_collection["MeshSkinVertexLayer"]
    """ All skin vertices

    :type: bpy_prop_collection['MeshSkinVertexLayer']
    """

    texco_mesh: "Mesh"
    """ Derive texture coordinates from another mesh

    :type: 'Mesh'
    """

    texspace_location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Texture space location

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    texspace_size: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Texture space size

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    texture_mesh: "Mesh"
    """ Use another mesh for texture indices (vertex indices must be aligned)

    :type: 'Mesh'
    """

    total_edge_sel: int
    """ Selected edge count in editmode

    :type: int
    """

    total_face_sel: int
    """ Selected face count in editmode

    :type: int
    """

    total_vert_sel: int
    """ Selected vertex count in editmode

    :type: int
    """

    use_auto_texspace: bool
    """ Adjust active object's texture space automatically when transforming object

    :type: bool
    """

    use_mirror_topology: bool
    """ Use topology based mirroring (for when both sides of mesh have matching, unique topology)

    :type: bool
    """

    use_mirror_vertex_groups: bool
    """ Mirror the left/right vertex groups when painting. The symmetry axis is determined by the symmetry settings

    :type: bool
    """

    use_mirror_x: bool
    """ Enable symmetry in the X axis

    :type: bool
    """

    use_mirror_y: bool
    """ Enable symmetry in the Y axis

    :type: bool
    """

    use_mirror_z: bool
    """ Enable symmetry in the Z axis

    :type: bool
    """

    use_paint_bone_selection: bool
    """ Bone selection during painting

    :type: bool
    """

    use_paint_mask: bool
    """ Face selection masking for painting

    :type: bool
    """

    use_paint_mask_vertex: bool
    """ Vertex selection masking for painting

    :type: bool
    """

    use_remesh_fix_poles: bool
    """ Produces fewer poles and a better topology flow

    :type: bool
    """

    use_remesh_preserve_attributes: bool
    """ Transfer all attributes to the new mesh

    :type: bool
    """

    use_remesh_preserve_volume: bool
    """ Projects the mesh to preserve the volume and details of the original mesh

    :type: bool
    """

    uv_layer_clone: "MeshUVLoopLayer"
    """ UV loop layer to be used as cloning source

    :type: 'MeshUVLoopLayer'
    """

    uv_layer_clone_index: int
    """ Clone UV loop layer index

    :type: int
    """

    uv_layer_stencil: "MeshUVLoopLayer"
    """ UV loop layer to mask the painted area

    :type: 'MeshUVLoopLayer'
    """

    uv_layer_stencil_index: int
    """ Mask UV loop layer index

    :type: int
    """

    uv_layers: bpy_prop_collection["MeshUVLoopLayer"]
    """ All UV loop layers

    :type: bpy_prop_collection['MeshUVLoopLayer']
    """

    vertex_colors: bpy_prop_collection["MeshLoopColorLayer"]
    """ Legacy vertex color layers. Deprecated, use color attributes instead

    :type: bpy_prop_collection['MeshLoopColorLayer']
    """

    vertex_normals: bpy_prop_collection["MeshNormalValue"]
    """ The normal direction of each vertex, defined as the average of the surrounding face normals

    :type: bpy_prop_collection['MeshNormalValue']
    """

    vertices: bpy_prop_collection["MeshVertex"]
    """ Vertices of the mesh

    :type: bpy_prop_collection['MeshVertex']
    """

    edge_creases: typing.Any
    """ Edge crease values for subdivision surface, corresponding to the "crease_edge" attribute.(readonly)"""

    edge_keys: typing.Any
    """ (readonly)"""

    vertex_creases: typing.Any
    """ Vertex crease values for subdivision surface, corresponding to the "crease_vert" attribute.(readonly)"""

    vertex_paint_mask: typing.Any
    """ Mask values for sculpting and painting, corresponding to the ".sculpt_mask" attribute.(readonly)"""

    def transform(
        self,
        matrix: typing.Optional[
            typing.Union[
                "mathutils.Matrix",
                typing.List[typing.List[float]],
                typing.Tuple[
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                ],
            ]
        ],
        shape_keys: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ):
        """Transform mesh vertices by a matrix (Warning: inverts normals if matrix is negative)

        :param matrix: Matrix
        :type matrix: typing.Optional[typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]]
        :param shape_keys: Transform Shape Keys
        :type shape_keys: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def flip_normals(self):
        """Invert winding of all polygons (clears tessellation, does not handle custom normals)"""
        ...

    def set_sharp_from_angle(self, angle: typing.Optional[typing.Any] = 3.14159):
        """Reset and fill the "sharp_edge" attribute based on the angle of faces neighboring manifold edges

        :param angle: Angle, Angle between faces beyond which edges are marked sharp
        :type angle: typing.Optional[typing.Any]
        """
        ...

    def split_faces(self):
        """Split faces based on the edge angle"""
        ...

    def calc_tangents(self, uvmap: typing.Union[str, typing.Any] = ""):
        """Compute tangents and bitangent signs, to be used together with the split normals to get a complete tangent space for normal mapping (split normals are also computed if not yet present)

        :param uvmap: Name of the UV map to use for tangent space computation
        :type uvmap: typing.Union[str, typing.Any]
        """
        ...

    def free_tangents(self):
        """Free tangents"""
        ...

    def calc_loop_triangles(self):
        """Calculate loop triangle tessellation (supports editmode too)"""
        ...

    def calc_smooth_groups(
        self, use_bitflags: typing.Optional[typing.Union[bool, typing.Any]] = False
    ):
        """Calculate smooth groups from sharp edges

                :param use_bitflags: Produce bitflags groups instead of simple numeric values
                :type use_bitflags: typing.Optional[typing.Union[bool, typing.Any]]
                :return: poly_groups, Smooth Groups, int array of 1 items in [-inf, inf]

        groups, Total number of groups, int in [0, inf]
        """
        ...

    def normals_split_custom_set(
        self,
        normals: typing.Optional[
            typing.Union[
                typing.List[typing.List[float]],
                typing.Tuple[
                    typing.Tuple[float], typing.Tuple[float], typing.Tuple[float]
                ],
            ]
        ],
    ):
        """Define custom split normals of this mesh (use zero-vectors to keep auto ones)

        :param normals: Normals
        :type normals: typing.Optional[typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float], typing.Tuple[float], typing.Tuple[float]]]]
        """
        ...

    def normals_split_custom_set_from_vertices(
        self,
        normals: typing.Optional[
            typing.Union[
                typing.List[typing.List[float]],
                typing.Tuple[
                    typing.Tuple[float], typing.Tuple[float], typing.Tuple[float]
                ],
            ]
        ],
    ):
        """Define custom split normals of this mesh, from vertices' normals (use zero-vectors to keep auto ones)

        :param normals: Normals
        :type normals: typing.Optional[typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float], typing.Tuple[float], typing.Tuple[float]]]]
        """
        ...

    def update(
        self,
        calc_edges: typing.Optional[typing.Union[bool, typing.Any]] = False,
        calc_edges_loose: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ):
        """update

        :param calc_edges: Calculate Edges, Force recalculation of edges
        :type calc_edges: typing.Optional[typing.Union[bool, typing.Any]]
        :param calc_edges_loose: Calculate Loose Edges, Calculate the loose state of each edge
        :type calc_edges_loose: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def update_gpu_tag(self):
        """update_gpu_tag"""
        ...

    def unit_test_compare(
        self,
        mesh: typing.Optional["Mesh"] = None,
        threshold: typing.Optional[typing.Any] = 7.1526e-06,
    ) -> typing.Union[str, typing.Any]:
        """unit_test_compare

        :param mesh: Mesh to compare to
        :type mesh: typing.Optional['Mesh']
        :param threshold: Threshold, Comparison tolerance threshold
        :type threshold: typing.Optional[typing.Any]
        :rtype: typing.Union[str, typing.Any]
        :return: Return value, String description of result of comparison
        """
        ...

    def clear_geometry(self):
        """Remove all geometry from the mesh. Note that this does not free shape keys or materials"""
        ...

    def validate(
        self,
        verbose: typing.Optional[typing.Union[bool, typing.Any]] = False,
        clean_customdata: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ) -> bool:
        """Validate geometry, return True when the mesh has had invalid geometry corrected/removed

        :param verbose: Verbose, Output information about the errors found
        :type verbose: typing.Optional[typing.Union[bool, typing.Any]]
        :param clean_customdata: Clean Custom Data, Remove temp/cached custom-data layers, like e.g. normals...
        :type clean_customdata: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: bool
        :return: Result
        """
        ...

    def validate_material_indices(self) -> bool:
        """Validate material indices of polygons, return True when the mesh has had invalid indices corrected (to default 0)

        :rtype: bool
        :return: Result
        """
        ...

    def count_selected_items(self) -> bpy_prop_array[int]:
        """Return the number of selected items (vert, edge, face)

        :rtype: bpy_prop_array[int]
        :return: Result
        """
        ...

    def edge_creases_ensure(self): ...
    def edge_creases_remove(self): ...
    def from_pydata(
        self,
        vertices: typing.Optional[typing.List],
        edges: typing.Optional[typing.List],
        faces: typing.Optional[typing.List],
        shade_flat=True,
    ):
        """Make a mesh from a list of vertices/edges/faces
        Until we have a nicer way to make geometry, use this.

                :param vertices: float triplets each representing (X, Y, Z)
        eg: [(0.0, 1.0, 0.5), ...].
                :type vertices: typing.Optional[typing.List]
                :param edges: int pairs, each pair contains two indices to the
        vertices argument. eg: [(1, 2), ...]

        When an empty iterable is passed in, the edges are inferred from the polygons.
                :type edges: typing.Optional[typing.List]
                :param faces: iterator of faces, each faces contains three or more indices to
        the vertices argument. eg: [(5, 6, 8, 9), (1, 2, 3), ...]
                :type faces: typing.Optional[typing.List]
                :param shade_flat:
                :type shade_flat:
        """
        ...

    def shade_flat(self):
        """Render and display faces uniform, using face normals,
        setting the "sharp_face" attribute true for every face

        """
        ...

    def shade_smooth(self):
        """Render and display faces smooth, using interpolated vertex normals,
        removing the "sharp_face" attribute

        """
        ...

    def vertex_creases_ensure(self): ...
    def vertex_creases_remove(self): ...
    def vertex_paint_mask_ensure(self): ...
    def vertex_paint_mask_remove(self): ...
    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeTree:
    """Node tree consisting of linked nodes used for shading, textures and compositing"""

    animation_data: "AnimData"
    """ Animation data for this data-block

    :type: 'AnimData'
    """

    bl_description: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_icon: typing.Union[int, str]
    """ The node tree icon

    :type: typing.Union[int, str]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ The node tree label

    :type: typing.Union[str, typing.Any]
    """

    grease_pencil: "GreasePencil"
    """ Grease Pencil data-block

    :type: 'GreasePencil'
    """

    interface: "NodeTreeInterface"
    """ Interface declaration for this node tree

    :type: 'NodeTreeInterface'
    """

    links: bpy_prop_collection["NodeLink"]
    """ 

    :type: bpy_prop_collection['NodeLink']
    """

    nodes: bpy_prop_collection["Node"]
    """ 

    :type: bpy_prop_collection['Node']
    """

    type: typing.Union[int, str]
    """ Node Tree type (deprecated, bl_idname is the actual node tree type identifier)

    :type: typing.Union[int, str]
    """

    view_center: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ The current location (offset) of the view for this Node Tree

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    def interface_update(self, context: "Context"):
        """Updated node group interface

        :param context:
        :type context: 'Context'
        """
        ...

    def contains_tree(self, sub_tree: "NodeTree") -> bool:
        """Check if the node tree contains another. Used to avoid creating recursive node groups

        :param sub_tree: Node Tree, Node tree for recursive check
        :type sub_tree: 'NodeTree'
        :rtype: bool
        :return: contained
        """
        ...

    def poll(self, context: "Context") -> bool:
        """Check visibility in the editor

        :param context:
        :type context: 'Context'
        :rtype: bool
        """
        ...

    def update(self):
        """Update on editor changes"""
        ...

    def get_from_context(self, context: "Context"):
        """Get a node tree from the context

                :param context:
                :type context: 'Context'
                :return: result_1, Active node tree from context, `NodeTree`

        result_2, ID data-block that owns the node tree, `ID`

        result_3, Original ID data-block selected from the context, `ID`
        """
        ...

    def valid_socket_type(self, idname: typing.Union[str, typing.Any]) -> bool:
        """Check if the socket type is valid for the node tree

        :param idname: Socket Type, Identifier of the socket type
        :type idname: typing.Union[str, typing.Any]
        :rtype: bool
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Object:
    """Object data-block defining an object in a scene"""

    active_material: "Material"
    """ Active material being displayed

    :type: 'Material'
    """

    active_material_index: int
    """ Index of active material slot

    :type: int
    """

    active_shape_key: "ShapeKey"
    """ Current shape key

    :type: 'ShapeKey'
    """

    active_shape_key_index: int
    """ Current shape key index

    :type: int
    """

    add_rest_position_attribute: bool
    """ Add a "rest_position" attribute that is a copy of the position attribute before shape keys and modifiers are evaluated

    :type: bool
    """

    animation_data: "AnimData"
    """ Animation data for this data-block

    :type: 'AnimData'
    """

    animation_visualization: "AnimViz"
    """ Animation data for this data-block

    :type: 'AnimViz'
    """

    bound_box: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float, float, float, float, float],
            typing.Tuple[float, float, float, float, float, float, float, float],
            typing.Tuple[float, float, float, float, float, float, float, float],
        ],
    ]
    """ Object's bounding box in object-space coordinates, all values are -1.0 when not available

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float, float, float, float, float], typing.Tuple[float, float, float, float, float, float, float, float], typing.Tuple[float, float, float, float, float, float, float, float]]]
    """

    collision: "CollisionSettings"
    """ Settings for using the object as a collider in physics simulation

    :type: 'CollisionSettings'
    """

    color: bpy_prop_array[float]
    """ Object color and alpha, used when the Object Color mode is enabled

    :type: bpy_prop_array[float]
    """

    constraints: bpy_prop_collection["Constraint"]
    """ Constraints affecting the transformation of the object

    :type: bpy_prop_collection['Constraint']
    """

    cycles: typing.Any
    """ Cycles object settings

    :type: typing.Any
    """

    data: "ID"
    """ Object data

    :type: 'ID'
    """

    delta_location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Extra translation added to the location of the object

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    delta_rotation_euler: typing.Union[
        "mathutils.Euler", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Extra rotation added to the rotation of the object (when using Euler rotations)

    :type: typing.Union['mathutils.Euler', typing.List[float], typing.Tuple[float, float, float]]
    """

    delta_rotation_quaternion: typing.Union[
        "mathutils.Quaternion",
        typing.List[float],
        typing.Tuple[float, float, float, float],
    ]
    """ Extra rotation added to the rotation of the object (when using Quaternion rotations)

    :type: typing.Union['mathutils.Quaternion', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    delta_scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Extra scaling added to the scale of the object

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    dimensions: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Absolute bounding box dimensions of the object.
Warning: Assigning to it or its members multiple consecutive times will not work correctly, as this needs up-to-date evaluated data

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    display: "ObjectDisplay"
    """ Object display settings for 3D viewport

    :type: 'ObjectDisplay'
    """

    display_bounds_type: typing.Union[int, str]
    """ Object boundary display type

    :type: typing.Union[int, str]
    """

    display_type: typing.Union[int, str]
    """ How to display object in viewport

    :type: typing.Union[int, str]
    """

    empty_display_size: float
    """ Size of display for empties in the viewport

    :type: float
    """

    empty_display_type: typing.Union[int, str]
    """ Viewport display style for empties

    :type: typing.Union[int, str]
    """

    empty_image_depth: typing.Union[int, str]
    """ Determine which other objects will occlude the image

    :type: typing.Union[int, str]
    """

    empty_image_offset: bpy_prop_array[float]
    """ Origin offset distance

    :type: bpy_prop_array[float]
    """

    empty_image_side: typing.Union[int, str]
    """ Show front/back side

    :type: typing.Union[int, str]
    """

    field: "FieldSettings"
    """ Settings for using the object as a field in physics simulation

    :type: 'FieldSettings'
    """

    grease_pencil_modifiers: bpy_prop_collection["GpencilModifier"]
    """ Modifiers affecting the data of the grease pencil object

    :type: bpy_prop_collection['GpencilModifier']
    """

    hide_probe_plane: bool
    """ Globally disable in planar light probes

    :type: bool
    """

    hide_probe_sphere: bool
    """ Globally disable in spherical light probes

    :type: bool
    """

    hide_probe_volume: bool
    """ Globally disable in volume probes

    :type: bool
    """

    hide_render: bool
    """ Globally disable in renders

    :type: bool
    """

    hide_select: bool
    """ Disable selection in viewport

    :type: bool
    """

    hide_viewport: bool
    """ Globally disable in viewports

    :type: bool
    """

    image_user: "ImageUser"
    """ Parameters defining which layer, pass and frame of the image is displayed

    :type: 'ImageUser'
    """

    instance_collection: "Collection"
    """ Instance an existing collection

    :type: 'Collection'
    """

    instance_faces_scale: float
    """ Scale the face instance objects

    :type: float
    """

    instance_type: typing.Union[int, str]
    """ If not None, object instancing method to use

    :type: typing.Union[int, str]
    """

    is_from_instancer: typing.Union[bool, typing.Any]
    """ Object comes from a instancer

    :type: typing.Union[bool, typing.Any]
    """

    is_from_set: typing.Union[bool, typing.Any]
    """ Object comes from a background set

    :type: typing.Union[bool, typing.Any]
    """

    is_holdout: bool
    """ Render objects as a holdout or matte, creating a hole in the image with zero alpha, to fill out in compositing with real footage or another render

    :type: bool
    """

    is_instancer: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    is_shadow_catcher: bool
    """ Only render shadows and reflections on this object, for compositing renders into real footage. Objects with this setting are considered to already exist in the footage, objects without it are synthetic objects being composited into it

    :type: bool
    """

    light_linking: "ObjectLightLinking"
    """ Light linking settings

    :type: 'ObjectLightLinking'
    """

    lightgroup: typing.Union[str, typing.Any]
    """ Lightgroup that the object belongs to

    :type: typing.Union[str, typing.Any]
    """

    lineart: "ObjectLineArt"
    """ Line art settings for the object

    :type: 'ObjectLineArt'
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of the object

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    lock_location: typing.List[bool]
    """ Lock editing of location when transforming

    :type: typing.List[bool]
    """

    lock_rotation: typing.List[bool]
    """ Lock editing of rotation when transforming

    :type: typing.List[bool]
    """

    lock_rotation_w: bool
    """ Lock editing of 'angle' component of four-component rotations when transforming

    :type: bool
    """

    lock_rotations_4d: bool
    """ Lock editing of four component rotations by components (instead of as Eulers)

    :type: bool
    """

    lock_scale: typing.List[bool]
    """ Lock editing of scale when transforming

    :type: typing.List[bool]
    """

    material_slots: bpy_prop_collection["MaterialSlot"]
    """ Material slots in the object

    :type: bpy_prop_collection['MaterialSlot']
    """

    matrix_basis: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Matrix access to location, rotation and scale (including deltas), before constraints and parenting are applied

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_local: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Parent relative transformation matrix.
Warning: Only takes into account object parenting, so e.g. in case of bone parenting you get a matrix relative to the Armature object, not to the actual parent bone

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_parent_inverse: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Inverse of object's parent matrix at time of parenting

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_world: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Worldspace transformation matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    mode: typing.Any
    """ Object interaction mode

    :type: typing.Any
    """

    modifiers: bpy_prop_collection["Modifier"]
    """ Modifiers affecting the geometric data of the object

    :type: bpy_prop_collection['Modifier']
    """

    motion_path: "MotionPath"
    """ Motion Path for this element

    :type: 'MotionPath'
    """

    parent: "Object"
    """ Parent object

    :type: 'Object'
    """

    parent_bone: typing.Union[str, typing.Any]
    """ Name of parent bone in case of a bone parenting relation

    :type: typing.Union[str, typing.Any]
    """

    parent_type: typing.Union[int, str]
    """ Type of parent relation

    :type: typing.Union[int, str]
    """

    parent_vertices: bpy_prop_array[int]
    """ Indices of vertices in case of a vertex parenting relation

    :type: bpy_prop_array[int]
    """

    particle_systems: bpy_prop_collection["ParticleSystem"]
    """ Particle systems emitted from the object

    :type: bpy_prop_collection['ParticleSystem']
    """

    pass_index: int
    """ Index number for the "Object Index" render pass

    :type: int
    """

    pose: "Pose"
    """ Current pose for armatures

    :type: 'Pose'
    """

    rigid_body: "RigidBodyObject"
    """ Settings for rigid body simulation

    :type: 'RigidBodyObject'
    """

    rigid_body_constraint: "RigidBodyConstraint"
    """ Constraint constraining rigid bodies

    :type: 'RigidBodyConstraint'
    """

    rotation_axis_angle: bpy_prop_array[float]
    """ Angle of Rotation for Axis-Angle rotation representation

    :type: bpy_prop_array[float]
    """

    rotation_euler: typing.Union[
        "mathutils.Euler", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Rotation in Eulers

    :type: typing.Union['mathutils.Euler', typing.List[float], typing.Tuple[float, float, float]]
    """

    rotation_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    rotation_quaternion: typing.Union[
        "mathutils.Quaternion",
        typing.List[float],
        typing.Tuple[float, float, float, float],
    ]
    """ Rotation in Quaternions

    :type: typing.Union['mathutils.Quaternion', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scaling of the object

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    shader_effects: bpy_prop_collection["ShaderFx"]
    """ Effects affecting display of object

    :type: bpy_prop_collection['ShaderFx']
    """

    show_all_edges: bool
    """ Display all edges for mesh objects

    :type: bool
    """

    show_axis: bool
    """ Display the object's origin and axes

    :type: bool
    """

    show_bounds: bool
    """ Display the object's bounds

    :type: bool
    """

    show_empty_image_only_axis_aligned: bool
    """ Only display the image when it is aligned with the view axis

    :type: bool
    """

    show_empty_image_orthographic: bool
    """ Display image in orthographic mode

    :type: bool
    """

    show_empty_image_perspective: bool
    """ Display image in perspective mode

    :type: bool
    """

    show_in_front: bool
    """ Make the object display in front of others

    :type: bool
    """

    show_instancer_for_render: bool
    """ Make instancer visible when rendering

    :type: bool
    """

    show_instancer_for_viewport: bool
    """ Make instancer visible in the viewport

    :type: bool
    """

    show_name: bool
    """ Display the object's name

    :type: bool
    """

    show_only_shape_key: bool
    """ Only show the active shape key at full value

    :type: bool
    """

    show_texture_space: bool
    """ Display the object's texture space

    :type: bool
    """

    show_transparent: bool
    """ Display material transparency in the object

    :type: bool
    """

    show_wire: bool
    """ Display the object's wireframe over solid shading

    :type: bool
    """

    soft_body: "SoftBodySettings"
    """ Settings for soft body simulation

    :type: 'SoftBodySettings'
    """

    track_axis: typing.Union[int, str]
    """ Axis that points in the 'forward' direction (applies to Instance Vertices when Align to Vertex Normal is enabled)

    :type: typing.Union[int, str]
    """

    type: typing.Any
    """ Type of object

    :type: typing.Any
    """

    up_axis: typing.Union[int, str]
    """ Axis that points in the upward direction (applies to Instance Vertices when Align to Vertex Normal is enabled)

    :type: typing.Union[int, str]
    """

    use_camera_lock_parent: bool
    """ View Lock 3D viewport camera transformation affects the object's parent instead

    :type: bool
    """

    use_dynamic_topology_sculpting: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    use_empty_image_alpha: bool
    """ Use alpha blending instead of alpha test (can produce sorting artifacts)

    :type: bool
    """

    use_grease_pencil_lights: bool
    """ Lights affect grease pencil object

    :type: bool
    """

    use_instance_faces_scale: bool
    """ Scale instance based on face size

    :type: bool
    """

    use_instance_vertices_rotation: bool
    """ Rotate instance according to vertex normal

    :type: bool
    """

    use_mesh_mirror_x: bool
    """ Enable mesh symmetry in the X axis

    :type: bool
    """

    use_mesh_mirror_y: bool
    """ Enable mesh symmetry in the Y axis

    :type: bool
    """

    use_mesh_mirror_z: bool
    """ Enable mesh symmetry in the Z axis

    :type: bool
    """

    use_shape_key_edit_mode: bool
    """ Display shape keys in edit mode (for meshes only)

    :type: bool
    """

    use_simulation_cache: bool
    """ Cache frames during simulation nodes playback

    :type: bool
    """

    vertex_groups: bpy_prop_collection["VertexGroup"]
    """ Vertex groups of the object

    :type: bpy_prop_collection['VertexGroup']
    """

    visible_camera: bool
    """ Object visibility to camera rays

    :type: bool
    """

    visible_diffuse: bool
    """ Object visibility to diffuse rays

    :type: bool
    """

    visible_glossy: bool
    """ Object visibility to glossy rays

    :type: bool
    """

    visible_shadow: bool
    """ Object visibility to shadow rays

    :type: bool
    """

    visible_transmission: bool
    """ Object visibility to transmission rays

    :type: bool
    """

    visible_volume_scatter: bool
    """ Object visibility to volume scattering rays

    :type: bool
    """

    children: typing.Tuple["Object"]
    """ All the children of this object.(readonly)

    :type: typing.Tuple['Object']
    """

    children_recursive: typing.Tuple["Object"]
    """ A list of all children from this object.(readonly)

    :type: typing.Tuple['Object']
    """

    users_collection: typing.Tuple["Collection"]
    """ The collections this object is in.(readonly)

    :type: typing.Tuple['Collection']
    """

    users_scene: typing.Tuple["Scene"]
    """ The scenes this object is in.(readonly)

    :type: typing.Tuple['Scene']
    """

    def select_get(self, view_layer: typing.Optional["ViewLayer"] = None) -> bool:
        """Test if the object is selected. The selection state is per view layer

        :param view_layer: Use this instead of the active view layer
        :type view_layer: typing.Optional['ViewLayer']
        :rtype: bool
        :return: Object selected
        """
        ...

    def select_set(
        self,
        state: typing.Optional[bool],
        view_layer: typing.Optional["ViewLayer"] = None,
    ):
        """Select or deselect the object. The selection state is per view layer

        :param state: Selection state to define
        :type state: typing.Optional[bool]
        :param view_layer: Use this instead of the active view layer
        :type view_layer: typing.Optional['ViewLayer']
        """
        ...

    def hide_get(self, view_layer: typing.Optional["ViewLayer"] = None) -> bool:
        """Test if the object is hidden for viewport editing. This hiding state is per view layer

        :param view_layer: Use this instead of the active view layer
        :type view_layer: typing.Optional['ViewLayer']
        :rtype: bool
        :return: Object hidden
        """
        ...

    def hide_set(
        self,
        state: typing.Optional[bool],
        view_layer: typing.Optional["ViewLayer"] = None,
    ):
        """Hide the object for viewport editing. This hiding state is per view layer

        :param state: Hide state to define
        :type state: typing.Optional[bool]
        :param view_layer: Use this instead of the active view layer
        :type view_layer: typing.Optional['ViewLayer']
        """
        ...

    def visible_get(
        self,
        view_layer: typing.Optional["ViewLayer"] = None,
        viewport: typing.Optional["SpaceView3D"] = None,
    ) -> bool:
        """Test if the object is visible in the 3D viewport, taking into account all visibility settings

        :param view_layer: Use this instead of the active view layer
        :type view_layer: typing.Optional['ViewLayer']
        :param viewport: Use this instead of the active 3D viewport
        :type viewport: typing.Optional['SpaceView3D']
        :rtype: bool
        :return: Object visible
        """
        ...

    def holdout_get(self, view_layer: typing.Optional["ViewLayer"] = None) -> bool:
        """Test if object is masked in the view layer

        :param view_layer: Use this instead of the active view layer
        :type view_layer: typing.Optional['ViewLayer']
        :rtype: bool
        :return: Object holdout
        """
        ...

    def indirect_only_get(
        self, view_layer: typing.Optional["ViewLayer"] = None
    ) -> bool:
        """Test if object is set to contribute only indirectly (through shadows and reflections) in the view layer

        :param view_layer: Use this instead of the active view layer
        :type view_layer: typing.Optional['ViewLayer']
        :rtype: bool
        :return: Object indirect only
        """
        ...

    def local_view_get(self, viewport: typing.Optional["SpaceView3D"]) -> bool:
        """Get the local view state for this object

        :param viewport: Viewport in local view
        :type viewport: typing.Optional['SpaceView3D']
        :rtype: bool
        :return: Object local view state
        """
        ...

    def local_view_set(
        self, viewport: typing.Optional["SpaceView3D"], state: typing.Optional[bool]
    ):
        """Set the local view state for this object

        :param viewport: Viewport in local view
        :type viewport: typing.Optional['SpaceView3D']
        :param state: Local view state to define
        :type state: typing.Optional[bool]
        """
        ...

    def visible_in_viewport_get(self, viewport: typing.Optional["SpaceView3D"]) -> bool:
        """Check for local view and local collections for this viewport and object

        :param viewport: Viewport in local collections
        :type viewport: typing.Optional['SpaceView3D']
        :rtype: bool
        :return: Object viewport visibility
        """
        ...

    def convert_space(
        self,
        pose_bone: typing.Optional["PoseBone"] = None,
        matrix: typing.Optional[typing.Any] = (
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
        ),
        from_space: typing.Optional[typing.Any] = "WORLD",
        to_space: typing.Optional[typing.Any] = "WORLD",
    ) -> typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]:
        """Convert (transform) the given matrix from one space to another

                :param pose_bone: Bone to use to define spaces (may be None, in which case only the two 'WORLD' and 'LOCAL' spaces are usable)
                :type pose_bone: typing.Optional['PoseBone']
                :param matrix: The matrix to transform
                :type matrix: typing.Optional[typing.Any]
                :param from_space: The space in which 'matrix' is currently

        WORLD
        World Space -- The most global space in Blender.

        POSE
        Pose Space -- The pose space of a bone (its armature's object space).

        LOCAL_WITH_PARENT
        Local With Parent -- The rest pose local space of a bone (this matrix includes parent transforms).

        LOCAL
        Local Space -- The local space of an object/bone.
                :type from_space: typing.Optional[typing.Any]
                :param to_space: The space to which you want to transform 'matrix'

        WORLD
        World Space -- The most global space in Blender.

        POSE
        Pose Space -- The pose space of a bone (its armature's object space).

        LOCAL_WITH_PARENT
        Local With Parent -- The rest pose local space of a bone (this matrix includes parent transforms).

        LOCAL
        Local Space -- The local space of an object/bone.
                :type to_space: typing.Optional[typing.Any]
                :rtype: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
                :return: The transformed matrix
        """
        ...

    def calc_matrix_camera(
        self,
        depsgraph: typing.Optional["Depsgraph"],
        x: typing.Optional[typing.Any] = 1,
        y: typing.Optional[typing.Any] = 1,
        scale_x: typing.Optional[typing.Any] = 1.0,
        scale_y: typing.Optional[typing.Any] = 1.0,
    ) -> typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]:
        """Generate the camera projection matrix of this object (mostly useful for Camera and Light types)

        :param depsgraph: Depsgraph to get evaluated data from
        :type depsgraph: typing.Optional['Depsgraph']
        :param x: Width of the render area
        :type x: typing.Optional[typing.Any]
        :param y: Height of the render area
        :type y: typing.Optional[typing.Any]
        :param scale_x: Width scaling factor
        :type scale_x: typing.Optional[typing.Any]
        :param scale_y: Height scaling factor
        :type scale_y: typing.Optional[typing.Any]
        :rtype: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
        :return: The camera projection matrix
        """
        ...

    def camera_fit_coords(
        self, depsgraph: typing.Optional["Depsgraph"], coordinates: typing.Any
    ):
        """Compute the coordinate (and scale for ortho cameras) given object should be to 'see' all given coordinates

                :param depsgraph: Depsgraph to get evaluated data from
                :type depsgraph: typing.Optional['Depsgraph']
                :param coordinates: Coordinates to fit in
                :type coordinates: typing.Any
                :return: co_return, The location to aim to be able to see all given points, `mathutils.Vector` of 3 items in [-inf, inf]

        scale_return, The ortho scale to aim to be able to see all given points (if relevant), float in [-inf, inf]
        """
        ...

    def crazyspace_eval(
        self, depsgraph: typing.Optional["Depsgraph"], scene: typing.Optional["Scene"]
    ):
        """Compute orientation mapping between vertices of an original object and object with shape keys and deforming modifiers applied.The evaluation is to be freed with the crazyspace_eval_free function

        :param depsgraph: Dependency Graph, Evaluated dependency graph
        :type depsgraph: typing.Optional['Depsgraph']
        :param scene: Scene, Scene of the object
        :type scene: typing.Optional['Scene']
        """
        ...

    def crazyspace_displacement_to_deformed(
        self,
        vertex_index: typing.Optional[typing.Any] = 0,
        displacement: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]:
        """Convert displacement vector from non-deformed object space to deformed object space

        :param vertex_index: vertex_index
        :type vertex_index: typing.Optional[typing.Any]
        :param displacement: displacement
        :type displacement: typing.Optional[typing.Any]
        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
        :return: displacement_deformed
        """
        ...

    def crazyspace_displacement_to_original(
        self,
        vertex_index: typing.Optional[typing.Any] = 0,
        displacement: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]:
        """Free evaluated state of crazyspace

        :param vertex_index: vertex_index
        :type vertex_index: typing.Optional[typing.Any]
        :param displacement: displacement
        :type displacement: typing.Optional[typing.Any]
        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
        :return: displacement_original
        """
        ...

    def crazyspace_eval_clear(self):
        """crazyspace_eval_clear"""
        ...

    def to_mesh(
        self,
        preserve_all_data_layers: typing.Optional[
            typing.Union[bool, typing.Any]
        ] = False,
        depsgraph: typing.Optional["Depsgraph"] = None,
    ) -> "Mesh":
        """Create a Mesh data-block from the current state of the object. The object owns the data-block. To force free it use to_mesh_clear(). The result is temporary and cannot be used by objects from the main database

        :param preserve_all_data_layers: Preserve all data layers in the mesh, like UV maps and vertex groups. By default Blender only computes the subset of data layers needed for viewport display and rendering, for better performance
        :type preserve_all_data_layers: typing.Optional[typing.Union[bool, typing.Any]]
        :param depsgraph: Dependency Graph, Evaluated dependency graph which is required when preserve_all_data_layers is true
        :type depsgraph: typing.Optional['Depsgraph']
        :rtype: 'Mesh'
        :return: Mesh created from object
        """
        ...

    def to_mesh_clear(self):
        """Clears mesh data-block created by to_mesh()"""
        ...

    def to_curve(
        self,
        depsgraph: typing.Optional["Depsgraph"],
        apply_modifiers: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "Curve":
        """Create a Curve data-block from the current state of the object. This only works for curve and text objects. The object owns the data-block. To force free it, use to_curve_clear(). The result is temporary and cannot be used by objects from the main database

        :param depsgraph: Dependency Graph, Evaluated dependency graph
        :type depsgraph: typing.Optional['Depsgraph']
        :param apply_modifiers: Apply the deform modifiers on the control points of the curve. This is only supported for curve objects
        :type apply_modifiers: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'Curve'
        :return: Curve created from object
        """
        ...

    def to_curve_clear(self):
        """Clears curve data-block created by to_curve()"""
        ...

    def find_armature(self) -> "Object":
        """Find armature influencing this object as a parent or via a modifier

        :rtype: 'Object'
        :return: Armature object influencing this object or nullptr
        """
        ...

    def shape_key_add(
        self,
        name: typing.Union[str, typing.Any] = "Key",
        from_mix: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ) -> "ShapeKey":
        """Add shape key to this object

        :param name: Unique name for the new keyblock
        :type name: typing.Union[str, typing.Any]
        :param from_mix: Create new shape from existing mix of shapes
        :type from_mix: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'ShapeKey'
        :return: New shape keyblock
        """
        ...

    def shape_key_remove(self, key: "ShapeKey"):
        """Remove a Shape Key from this object

        :param key: Keyblock to be removed
        :type key: 'ShapeKey'
        """
        ...

    def shape_key_clear(self):
        """Remove all Shape Keys from this object"""
        ...

    def ray_cast(
        self,
        origin: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
        direction: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
        distance: typing.Optional[typing.Any] = 1.70141e38,
        depsgraph: typing.Optional["Depsgraph"] = None,
    ):
        """Cast a ray onto evaluated geometry, in object space (using context's or provided depsgraph to get evaluated mesh if needed)

                :param origin: Origin of the ray, in object space
                :type origin: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
                :param direction: Direction of the ray, in object space
                :type direction: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
                :param distance: Maximum distance
                :type distance: typing.Optional[typing.Any]
                :param depsgraph: Depsgraph to use to get evaluated data, when called from original object (only needed if current Context's depsgraph is not suitable)
                :type depsgraph: typing.Optional['Depsgraph']
                :return: result, Whether the ray successfully hit the geometry, boolean

        location, The hit location of this ray cast, `mathutils.Vector` of 3 items in [-inf, inf]

        normal, The face normal at the ray cast hit location, `mathutils.Vector` of 3 items in [-inf, inf]

        index, The face index, -1 when original data isn't available, int in [-inf, inf]
        """
        ...

    def closest_point_on_mesh(
        self,
        origin: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
        distance: typing.Optional[typing.Any] = 1.84467e19,
        depsgraph: typing.Optional["Depsgraph"] = None,
    ):
        """Find the nearest point on evaluated geometry, in object space (using context's or provided depsgraph to get evaluated mesh if needed)

                :param origin: Point to find closest geometry from (in object space)
                :type origin: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
                :param distance: Maximum distance
                :type distance: typing.Optional[typing.Any]
                :param depsgraph: Depsgraph to use to get evaluated data, when called from original object (only needed if current Context's depsgraph is not suitable)
                :type depsgraph: typing.Optional['Depsgraph']
                :return: result, Whether closest point on geometry was found, boolean

        location, The location on the object closest to the point, `mathutils.Vector` of 3 items in [-inf, inf]

        normal, The face normal at the closest point, `mathutils.Vector` of 3 items in [-inf, inf]

        index, The face index, -1 when original data isn't available, int in [-inf, inf]
        """
        ...

    def is_modified(
        self, scene: "Scene", settings: typing.Optional[typing.Union[int, str]]
    ) -> bool:
        """Determine if this object is modified from the base mesh data

                :param scene: Scene in which to check the object
                :type scene: 'Scene'
                :param settings: Modifier settings to apply

        PREVIEW
        Preview -- Apply modifier preview settings.

        RENDER
        Render -- Apply modifier render settings.
                :type settings: typing.Optional[typing.Union[int, str]]
                :rtype: bool
                :return: Whether the object is modified
        """
        ...

    def is_deform_modified(
        self, scene: "Scene", settings: typing.Optional[typing.Union[int, str]]
    ) -> bool:
        """Determine if this object is modified by a deformation from the base mesh data

                :param scene: Scene in which to check the object
                :type scene: 'Scene'
                :param settings: Modifier settings to apply

        PREVIEW
        Preview -- Apply modifier preview settings.

        RENDER
        Render -- Apply modifier render settings.
                :type settings: typing.Optional[typing.Union[int, str]]
                :rtype: bool
                :return: Whether the object is deform-modified
        """
        ...

    def update_from_editmode(self) -> bool:
        """Load the objects edit-mode data into the object data

        :rtype: bool
        :return: Success
        """
        ...

    def cache_release(self):
        """Release memory used by caches associated with this object. Intended to be used by render engines only"""
        ...

    def generate_gpencil_strokes(
        self,
        grease_pencil_object: "Object",
        use_collections: typing.Optional[typing.Union[bool, typing.Any]] = True,
        scale_thickness: typing.Optional[typing.Any] = 1.0,
        sample: typing.Optional[typing.Any] = 0.0,
    ) -> bool:
        """Convert a curve object to grease pencil strokes.

        :param grease_pencil_object: Grease Pencil object used to create new strokes
        :type grease_pencil_object: 'Object'
        :param use_collections: Use Collections
        :type use_collections: typing.Optional[typing.Union[bool, typing.Any]]
        :param scale_thickness: Thickness scaling factor
        :type scale_thickness: typing.Optional[typing.Any]
        :param sample: Sample distance, zero to disable
        :type sample: typing.Optional[typing.Any]
        :rtype: bool
        :return: Result
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Operator:
    """Storage of an operator being executed, or registered after execution"""

    bl_cursor_pending: typing.Union[int, str]
    """ Cursor to use when waiting for the user to select a location to activate the operator (when bl_options has DEPENDS_ON_CURSOR set)

    :type: typing.Union[int, str]
    """

    bl_description: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Options for this operator type

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    bl_translation_context: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_undo_group: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    has_reports: typing.Union[bool, typing.Any]
    """ Operator has a set of reports (warnings and errors) from last execution

    :type: typing.Union[bool, typing.Any]
    """

    layout: "UILayout"
    """ 

    :type: 'UILayout'
    """

    macros: bpy_prop_collection["Macro"]
    """ 

    :type: bpy_prop_collection['Macro']
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    options: "OperatorOptions"
    """ Runtime options

    :type: 'OperatorOptions'
    """

    properties: "OperatorProperties"
    """ 

    :type: 'OperatorProperties'
    """

    bl_property: typing.Any
    """ The name of a property to use as this operators primary property.
Currently this is only used to select the default property when
expanding an operator into a menu.
:type: string"""

    def report(
        self,
        type: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]],
        message: typing.Union[str, typing.Any],
    ):
        """report

        :param type: Type
        :type type: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]]
        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        """
        ...

    def is_repeat(self) -> bool:
        """is_repeat

        :rtype: bool
        :return: result
        """
        ...

    def poll(self, context: "Context") -> bool:
        """Test if the operator can be called or not

        :param context:
        :type context: 'Context'
        :rtype: bool
        """
        ...

    def execute(
        self, context: "Context"
    ) -> typing.Union[typing.Set[int], typing.Set[str]]:
        """Execute the operator

        :param context:
        :type context: 'Context'
        :rtype: typing.Union[typing.Set[int], typing.Set[str]]
        :return: result
        """
        ...

    def check(self, context: "Context") -> bool:
        """Check the operator settings, return True to signal a change to redraw

        :param context:
        :type context: 'Context'
        :rtype: bool
        :return: result
        """
        ...

    def invoke(
        self, context: "Context", event: "Event"
    ) -> typing.Union[typing.Set[int], typing.Set[str]]:
        """Invoke the operator

        :param context:
        :type context: 'Context'
        :param event:
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[int], typing.Set[str]]
        :return: result
        """
        ...

    def modal(
        self, context: "Context", event: "Event"
    ) -> typing.Union[typing.Set[int], typing.Set[str]]:
        """Modal operator function

        :param context:
        :type context: 'Context'
        :param event:
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[int], typing.Set[str]]
        :return: result
        """
        ...

    def draw(self, context: "Context"):
        """Draw function for the operator

        :param context:
        :type context: 'Context'
        """
        ...

    def cancel(self, context: "Context"):
        """Called when the operator is canceled

        :param context:
        :type context: 'Context'
        """
        ...

    def description(self, context: "Context", properties: "OperatorProperties") -> str:
        """Compute a description string that depends on parameters

        :param context:
        :type context: 'Context'
        :param properties:
        :type properties: 'OperatorProperties'
        :rtype: str
        :return: result
        """
        ...

    def as_keywords(self, *, ignore=()):
        """Return a copy of the properties as a dictionary

        :param *:
        :type *:
        :param ignore:
        :type ignore:
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

    def poll_message_set(self, message: typing.Optional[str], *args):
        """Set the message to show in the tool-tip when poll fails.When message is callable, additional user defined positional arguments are passed to the message function.

        :param message: The message or a function that returns the message.
        :type message: typing.Optional[str]
        :param *args:
        :type *args:
        """
        ...

class Panel:
    """Panel containing UI elements"""

    bl_category: typing.Union[str, typing.Any]
    """ The category (tab) in which the panel will be displayed, when applicable

    :type: typing.Union[str, typing.Any]
    """

    bl_context: typing.Union[str, typing.Any]
    """ The context in which the panel belongs to. (TODO: explain the possible combinations bl_context/bl_region_type/bl_space_type)

    :type: typing.Union[str, typing.Any]
    """

    bl_description: str
    """ The panel tooltip

    :type: str
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the panel gets a custom ID, otherwise it takes the name of the class used to define the panel. For example, if the class name is "OBJECT_PT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_PT_hello"

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ The panel label, shows up in the panel header at the right of the triangle used to collapse the panel

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Options for this panel type

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    bl_order: int
    """ Panels with lower numbers are default ordered before panels with higher numbers

    :type: int
    """

    bl_owner_id: typing.Union[str, typing.Any]
    """ The ID owning the data displayed in the panel, if any

    :type: typing.Union[str, typing.Any]
    """

    bl_parent_id: typing.Union[str, typing.Any]
    """ If this is set, the panel becomes a sub-panel

    :type: typing.Union[str, typing.Any]
    """

    bl_region_type: typing.Union[int, str]
    """ The region where the panel is going to be used in

    :type: typing.Union[int, str]
    """

    bl_space_type: typing.Union[int, str]
    """ The space where the panel is going to be used in

    :type: typing.Union[int, str]
    """

    bl_translation_context: typing.Union[str, typing.Any]
    """ Specific translation context, only define when the label needs to be disambiguated from others using the exact same label

    :type: typing.Union[str, typing.Any]
    """

    bl_ui_units_x: int
    """ When set, defines popup panel width

    :type: int
    """

    custom_data: "Constraint"
    """ Panel data

    :type: 'Constraint'
    """

    is_popover: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    layout: "UILayout"
    """ Defines the structure of the panel in the UI

    :type: 'UILayout'
    """

    text: typing.Union[str, typing.Any]
    """ XXX todo

    :type: typing.Union[str, typing.Any]
    """

    use_pin: bool
    """ Show the panel on all tabs

    :type: bool
    """

    def poll(self, context: "Context") -> bool:
        """If this method returns a non-null output, then the panel can be drawn

        :param context:
        :type context: 'Context'
        :rtype: bool
        """
        ...

    def draw(self, context: "Context"):
        """Draw UI elements into the panel UI layout

        :param context:
        :type context: 'Context'
        """
        ...

    def draw_header(self, context: "Context"):
        """Draw UI elements into the panel's header UI layout

        :param context:
        :type context: 'Context'
        """
        ...

    def draw_header_preset(self, context: "Context"):
        """Draw UI elements for presets in the panel's header

        :param context:
        :type context: 'Context'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PropertyGroup:
    """Group of ID properties"""

    name: typing.Union[str, typing.Any]
    """ Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RenderEngine:
    """Render engine"""

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_use_alembic_procedural: bool
    """ Support loading Alembic data at render time

    :type: bool
    """

    bl_use_custom_freestyle: bool
    """ Handles freestyle rendering on its own, instead of delegating it to EEVEE

    :type: bool
    """

    bl_use_eevee_viewport: bool
    """ Uses EEVEE for viewport shading in Material Preview shading mode

    :type: bool
    """

    bl_use_gpu_context: bool
    """ Enable OpenGL context for the render method, for engines that render using OpenGL

    :type: bool
    """

    bl_use_image_save: bool
    """ Save images/movie to disk while rendering an animation. Disabling image saving is only supported when bl_use_postprocess is also disabled

    :type: bool
    """

    bl_use_materialx: bool
    """ Use MaterialX for exporting materials to Hydra

    :type: bool
    """

    bl_use_postprocess: bool
    """ Apply compositing on render results

    :type: bool
    """

    bl_use_preview: bool
    """ Render engine supports being used for rendering previews of materials, lights and worlds

    :type: bool
    """

    bl_use_shading_nodes_custom: bool
    """ Don't expose Cycles and EEVEE shading nodes in the node editor user interface, so separate nodes can be used instead

    :type: bool
    """

    bl_use_spherical_stereo: bool
    """ Support spherical stereo camera models

    :type: bool
    """

    bl_use_stereo_viewport: bool
    """ Support rendering stereo 3D viewport

    :type: bool
    """

    camera_override: "Object"
    """ 

    :type: 'Object'
    """

    is_animation: bool
    """ 

    :type: bool
    """

    is_preview: bool
    """ 

    :type: bool
    """

    layer_override: typing.List[bool]
    """ 

    :type: typing.List[bool]
    """

    render: "RenderSettings"
    """ 

    :type: 'RenderSettings'
    """

    resolution_x: int
    """ 

    :type: int
    """

    resolution_y: int
    """ 

    :type: int
    """

    temporary_directory: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    use_highlight_tiles: bool
    """ 

    :type: bool
    """

    def update(
        self,
        data: typing.Optional["BlendData"] = None,
        depsgraph: typing.Optional["Depsgraph"] = None,
    ):
        """Export scene data for render

        :param data:
        :type data: typing.Optional['BlendData']
        :param depsgraph:
        :type depsgraph: typing.Optional['Depsgraph']
        """
        ...

    def render(self, depsgraph: typing.Optional["Depsgraph"]):
        """Render scene into an image

        :param depsgraph:
        :type depsgraph: typing.Optional['Depsgraph']
        """
        ...

    def render_frame_finish(self):
        """Perform finishing operations after all view layers in a frame were rendered"""
        ...

    def draw(
        self,
        context: typing.Optional["Context"],
        depsgraph: typing.Optional["Depsgraph"],
    ):
        """Draw render image

        :param context:
        :type context: typing.Optional['Context']
        :param depsgraph:
        :type depsgraph: typing.Optional['Depsgraph']
        """
        ...

    def bake(
        self,
        depsgraph: typing.Optional["Depsgraph"],
        object: typing.Optional["Object"],
        pass_type: typing.Optional[typing.Union[int, str]],
        pass_filter: typing.Optional[int],
        width: typing.Optional[int],
        height: typing.Optional[int],
    ):
        """Bake passes

        :param depsgraph:
        :type depsgraph: typing.Optional['Depsgraph']
        :param object:
        :type object: typing.Optional['Object']
        :param pass_type: Pass, Pass to bake
        :type pass_type: typing.Optional[typing.Union[int, str]]
        :param pass_filter: Pass Filter, Filter to combined, diffuse, glossy and transmission passes
        :type pass_filter: typing.Optional[int]
        :param width: Width, Image width
        :type width: typing.Optional[int]
        :param height: Height, Image height
        :type height: typing.Optional[int]
        """
        ...

    def view_update(
        self,
        context: typing.Optional["Context"],
        depsgraph: typing.Optional["Depsgraph"],
    ):
        """Update on data changes for viewport render

        :param context:
        :type context: typing.Optional['Context']
        :param depsgraph:
        :type depsgraph: typing.Optional['Depsgraph']
        """
        ...

    def view_draw(
        self,
        context: typing.Optional["Context"],
        depsgraph: typing.Optional["Depsgraph"],
    ):
        """Draw viewport render

        :param context:
        :type context: typing.Optional['Context']
        :param depsgraph:
        :type depsgraph: typing.Optional['Depsgraph']
        """
        ...

    def update_script_node(self, node: typing.Optional["Node"] = None):
        """Compile shader script node

        :param node:
        :type node: typing.Optional['Node']
        """
        ...

    def update_render_passes(
        self,
        scene: typing.Optional["Scene"] = None,
        renderlayer: typing.Optional["ViewLayer"] = None,
    ):
        """Update the render passes that will be generated

        :param scene:
        :type scene: typing.Optional['Scene']
        :param renderlayer:
        :type renderlayer: typing.Optional['ViewLayer']
        """
        ...

    def tag_redraw(self):
        """Request redraw for viewport rendering"""
        ...

    def tag_update(self):
        """Request update call for viewport rendering"""
        ...

    def begin_result(
        self,
        x: typing.Optional[int],
        y: typing.Optional[int],
        w: typing.Optional[int],
        h: typing.Optional[int],
        layer: typing.Union[str, typing.Any] = "",
        view: typing.Union[str, typing.Any] = "",
    ) -> "RenderResult":
        """Create render result to write linear floating-point render layers and passes

        :param x: X
        :type x: typing.Optional[int]
        :param y: Y
        :type y: typing.Optional[int]
        :param w: Width
        :type w: typing.Optional[int]
        :param h: Height
        :type h: typing.Optional[int]
        :param layer: Layer, Single layer to get render result for
        :type layer: typing.Union[str, typing.Any]
        :param view: View, Single view to get render result for
        :type view: typing.Union[str, typing.Any]
        :rtype: 'RenderResult'
        :return: Result
        """
        ...

    def update_result(self, result: typing.Optional["RenderResult"]):
        """Signal that pixels have been updated and can be redrawn in the user interface

        :param result: Result
        :type result: typing.Optional['RenderResult']
        """
        ...

    def end_result(
        self,
        result: typing.Optional["RenderResult"],
        cancel: typing.Optional[typing.Union[bool, typing.Any]] = False,
        highlight: typing.Optional[typing.Union[bool, typing.Any]] = False,
        do_merge_results: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ):
        """All pixels in the render result have been set and are final

        :param result: Result
        :type result: typing.Optional['RenderResult']
        :param cancel: Cancel, Don't mark tile as done, don't merge results unless forced
        :type cancel: typing.Optional[typing.Union[bool, typing.Any]]
        :param highlight: Highlight, Don't mark tile as done yet
        :type highlight: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_merge_results: Merge Results, Merge results even if cancel=true
        :type do_merge_results: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def add_pass(
        self,
        name: typing.Union[str, typing.Any],
        channels: typing.Optional[int],
        chan_id: typing.Union[str, typing.Any],
        layer: typing.Union[str, typing.Any] = "",
    ):
        """Add a pass to the render layer

        :param name: Name, Name of the Pass, without view or channel tag
        :type name: typing.Union[str, typing.Any]
        :param channels: Channels
        :type channels: typing.Optional[int]
        :param chan_id: Channel IDs, Channel names, one character per channel
        :type chan_id: typing.Union[str, typing.Any]
        :param layer: Layer, Single layer to add render pass to
        :type layer: typing.Union[str, typing.Any]
        """
        ...

    def get_result(self) -> "RenderResult":
        """Get final result for non-pixel operations

        :rtype: 'RenderResult'
        :return: Result
        """
        ...

    def test_break(self) -> bool:
        """Test if the render operation should been canceled, this is a fast call that should be used regularly for responsiveness

        :rtype: bool
        :return: Break
        """
        ...

    def pass_by_index_get(
        self, layer: typing.Union[str, typing.Any], index: typing.Optional[int]
    ) -> "RenderPass":
        """pass_by_index_get

        :param layer: Layer, Name of render layer to get pass for
        :type layer: typing.Union[str, typing.Any]
        :param index: Index, Index of pass to get
        :type index: typing.Optional[int]
        :rtype: 'RenderPass'
        :return: Index, Index of pass to get
        """
        ...

    def active_view_get(self) -> typing.Union[str, typing.Any]:
        """active_view_get

        :rtype: typing.Union[str, typing.Any]
        :return: View, Single view active
        """
        ...

    def active_view_set(self, view: typing.Union[str, typing.Any]):
        """active_view_set

        :param view: View, Single view to set as active
        :type view: typing.Union[str, typing.Any]
        """
        ...

    def camera_shift_x(
        self,
        camera: typing.Optional["Object"],
        use_spherical_stereo: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> float:
        """camera_shift_x

        :param camera:
        :type camera: typing.Optional['Object']
        :param use_spherical_stereo: Spherical Stereo
        :type use_spherical_stereo: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: float
        :return: Shift X
        """
        ...

    def camera_model_matrix(
        self,
        camera: typing.Optional["Object"],
        use_spherical_stereo: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]:
        """camera_model_matrix

        :param camera:
        :type camera: typing.Optional['Object']
        :param use_spherical_stereo: Spherical Stereo
        :type use_spherical_stereo: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
        :return: Model Matrix, Normalized camera model matrix
        """
        ...

    def use_spherical_stereo(self, camera: typing.Optional["Object"]) -> bool:
        """use_spherical_stereo

        :param camera:
        :type camera: typing.Optional['Object']
        :rtype: bool
        :return: Spherical Stereo
        """
        ...

    def update_stats(
        self, stats: typing.Union[str, typing.Any], info: typing.Union[str, typing.Any]
    ):
        """Update and signal to redraw render status text

        :param stats: Stats
        :type stats: typing.Union[str, typing.Any]
        :param info: Info
        :type info: typing.Union[str, typing.Any]
        """
        ...

    def frame_set(self, frame: typing.Optional[int], subframe: typing.Optional[float]):
        """Evaluate scene at a different frame (for motion blur)

        :param frame: Frame
        :type frame: typing.Optional[int]
        :param subframe: Subframe
        :type subframe: typing.Optional[float]
        """
        ...

    def update_progress(self, progress: typing.Optional[float]):
        """Update progress percentage of render

        :param progress: Percentage of render that's done
        :type progress: typing.Optional[float]
        """
        ...

    def update_memory_stats(
        self,
        memory_used: typing.Optional[typing.Any] = 0.0,
        memory_peak: typing.Optional[typing.Any] = 0.0,
    ):
        """Update memory usage statistics

        :param memory_used: Current memory usage in megabytes
        :type memory_used: typing.Optional[typing.Any]
        :param memory_peak: Peak memory usage in megabytes
        :type memory_peak: typing.Optional[typing.Any]
        """
        ...

    def report(
        self,
        type: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]],
        message: typing.Union[str, typing.Any],
    ):
        """Report info, warning or error messages

        :param type: Type
        :type type: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]]
        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        """
        ...

    def error_set(self, message: typing.Union[str, typing.Any]):
        """Set error message displaying after the render is finished

        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        """
        ...

    def bind_display_space_shader(self, scene: typing.Optional["Scene"]):
        """Bind GLSL fragment shader that converts linear colors to display space colors using scene color management settings

        :param scene:
        :type scene: typing.Optional['Scene']
        """
        ...

    def unbind_display_space_shader(self):
        """Unbind GLSL display space shader, must always be called after binding the shader"""
        ...

    def support_display_space_shader(self, scene: typing.Optional["Scene"]) -> bool:
        """Test if GLSL display space shader is supported for the combination of graphics card and scene settings

        :param scene:
        :type scene: typing.Optional['Scene']
        :rtype: bool
        :return: Supported
        """
        ...

    def get_preview_pixel_size(self, scene: typing.Optional["Scene"]) -> int:
        """Get the pixel size that should be used for preview rendering

        :param scene:
        :type scene: typing.Optional['Scene']
        :rtype: int
        :return: Pixel Size
        """
        ...

    def free_blender_memory(self):
        """Free Blender side memory of render engine"""
        ...

    def tile_highlight_set(
        self,
        x: typing.Optional[int],
        y: typing.Optional[int],
        width: typing.Optional[int],
        height: typing.Optional[int],
        highlight: typing.Optional[bool],
    ):
        """Set highlighted state of the given tile

        :param x: X
        :type x: typing.Optional[int]
        :param y: Y
        :type y: typing.Optional[int]
        :param width: Width
        :type width: typing.Optional[int]
        :param height: Height
        :type height: typing.Optional[int]
        :param highlight: Highlight
        :type highlight: typing.Optional[bool]
        """
        ...

    def tile_highlight_clear_all(self):
        """The temp directory used by Blender"""
        ...

    def register_pass(
        self,
        scene: typing.Optional["Scene"],
        view_layer: typing.Optional["ViewLayer"],
        name: typing.Union[str, typing.Any],
        channels: typing.Optional[int],
        chanid: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ):
        """Register a render pass that will be part of the render with the current settings

        :param scene:
        :type scene: typing.Optional['Scene']
        :param view_layer:
        :type view_layer: typing.Optional['ViewLayer']
        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :param channels: Channels
        :type channels: typing.Optional[int]
        :param chanid: Channel IDs
        :type chanid: typing.Union[str, typing.Any]
        :param type: Type
        :type type: typing.Optional[typing.Union[int, str]]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class UIList:
    """UI list containing the elements of a collection"""

    bitflag_filter_item: int
    """ The value of the reserved bitflag 'FILTER_ITEM' (in filter_flags values)

    :type: int
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the uilist gets a custom ID, otherwise it takes the name of the class used to define the uilist (for example, if the class name is "OBJECT_UL_vgroups", and bl_idname is not set by the script, then bl_idname = "OBJECT_UL_vgroups")

    :type: typing.Union[str, typing.Any]
    """

    filter_name: typing.Union[str, typing.Any]
    """ Only show items matching this name (use '*' as wildcard)

    :type: typing.Union[str, typing.Any]
    """

    layout_type: typing.Any
    """ 

    :type: typing.Any
    """

    list_id: typing.Union[str, typing.Any]
    """ Identifier of the list, if any was passed to the "list_id" parameter of "template_list()"

    :type: typing.Union[str, typing.Any]
    """

    use_filter_invert: bool
    """ Invert filtering (show hidden items, and vice versa)

    :type: bool
    """

    use_filter_show: bool
    """ Show filtering options

    :type: bool
    """

    use_filter_sort_alpha: bool
    """ Sort items by their name

    :type: bool
    """

    use_filter_sort_lock: bool
    """ Lock the order of shown items (user cannot change it)

    :type: bool
    """

    use_filter_sort_reverse: bool
    """ Reverse the order of shown items

    :type: bool
    """

    def draw_item(
        self,
        context: typing.Optional["Context"],
        layout: "UILayout",
        data: typing.Optional[typing.Any],
        item: typing.Optional[typing.Any],
        icon: typing.Optional[int],
        active_data: typing.Any,
        active_property: str,
        index: typing.Optional[typing.Any] = 0,
        flt_flag: typing.Optional[typing.Any] = 0,
    ):
        """Draw an item in the list (NOTE: when you define your own draw_item function, you may want to check given 'item' is of the right type...)

        :param context:
        :type context: typing.Optional['Context']
        :param layout: Layout to draw the item
        :type layout: 'UILayout'
        :param data: Data from which to take Collection property
        :type data: typing.Optional[typing.Any]
        :param item: Item of the collection property
        :type item: typing.Optional[typing.Any]
        :param icon: Icon of the item in the collection
        :type icon: typing.Optional[int]
        :param active_data: Data from which to take property for the active element
        :type active_data: typing.Any
        :param active_property: Identifier of property in active_data, for the active element
        :type active_property: str
        :param index: Index of the item in the collection
        :type index: typing.Optional[typing.Any]
        :param flt_flag: The filter-flag result for this item
        :type flt_flag: typing.Optional[typing.Any]
        """
        ...

    def draw_filter(self, context: typing.Optional["Context"], layout: "UILayout"):
        """Draw filtering options

        :param context:
        :type context: typing.Optional['Context']
        :param layout: Layout to draw the item
        :type layout: 'UILayout'
        """
        ...

    def filter_items(
        self,
        context: typing.Optional["Context"],
        data: typing.Optional[typing.Any],
        property: typing.Union[str, typing.Any],
    ):
        """Filter and/or re-order items of the collection (output filter results in filter_flags, and reorder results in filter_neworder arrays)

                :param context:
                :type context: typing.Optional['Context']
                :param data: Data from which to take Collection property
                :type data: typing.Optional[typing.Any]
                :param property: Identifier of property in data, for the collection
                :type property: typing.Union[str, typing.Any]
                :return: filter_flags, An array of filter flags, one for each item in the collection (NOTE: FILTER_ITEM bit is reserved, it defines whether the item is shown or not), int array of 1 items in [0, inf]

        filter_neworder, An array of indices, one for each item in the collection, mapping the org index to the new one, int array of 1 items in [0, inf]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class USDHook:
    """Defines callback functions to extend USD IO"""

    bl_description: typing.Union[str, typing.Any]
    """ A short description of the USD hook

    :type: typing.Union[str, typing.Any]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AOV(bpy_struct):
    is_valid: bool
    """ Is the name of the AOV conflicting

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Name of the AOV

    :type: typing.Union[str, typing.Any]
    """

    type: typing.Union[int, str]
    """ Data type of the AOV

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AOVs(bpy_struct):
    """Collection of AOVs"""

    def add(self) -> "AOV":
        """add

        :rtype: 'AOV'
        :return: Newly created AOV
        """
        ...

    def remove(self, aov: "AOV"):
        """Remove an AOV

        :param aov: AOV to remove
        :type aov: 'AOV'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ActionFCurves(bpy_struct):
    """Collection of action F-Curves"""

    def new(
        self,
        data_path: typing.Union[str, typing.Any],
        index: typing.Optional[typing.Any] = 0,
        action_group: typing.Union[str, typing.Any] = "",
    ) -> "FCurve":
        """Add an F-Curve to the action

        :param data_path: Data Path, F-Curve data path to use
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, Array index
        :type index: typing.Optional[typing.Any]
        :param action_group: Action Group, Acton group to add this F-Curve into
        :type action_group: typing.Union[str, typing.Any]
        :rtype: 'FCurve'
        :return: Newly created F-Curve
        """
        ...

    def find(
        self,
        data_path: typing.Union[str, typing.Any],
        index: typing.Optional[typing.Any] = 0,
    ) -> "FCurve":
        """Find an F-Curve. Note that this function performs a linear scan of all F-Curves in the action.

        :param data_path: Data Path, F-Curve data path
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, Array index
        :type index: typing.Optional[typing.Any]
        :rtype: 'FCurve'
        :return: The found F-Curve, or None if it doesn't exist
        """
        ...

    def remove(self, fcurve: "FCurve"):
        """Remove F-Curve

        :param fcurve: F-Curve to remove
        :type fcurve: 'FCurve'
        """
        ...

    def clear(self):
        """Remove all F-Curves"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ActionGroup(bpy_struct):
    """Groups of F-Curves"""

    channels: bpy_prop_collection["FCurve"]
    """ F-Curves in this group

    :type: bpy_prop_collection['FCurve']
    """

    color_set: typing.Union[int, str]
    """ Custom color set to use

    :type: typing.Union[int, str]
    """

    colors: "ThemeBoneColorSet"
    """ Copy of the colors associated with the group's color set

    :type: 'ThemeBoneColorSet'
    """

    is_custom_color_set: typing.Union[bool, typing.Any]
    """ Color set is user-defined instead of a fixed theme color set

    :type: typing.Union[bool, typing.Any]
    """

    lock: bool
    """ Action group is locked

    :type: bool
    """

    mute: bool
    """ Action group is muted

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    select: bool
    """ Action group is selected

    :type: bool
    """

    show_expanded: bool
    """ Action group is expanded except in graph editor

    :type: bool
    """

    show_expanded_graph: bool
    """ Action group is expanded in graph editor

    :type: bool
    """

    use_pin: bool
    """ 

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ActionGroups(bpy_struct):
    """Collection of action groups"""

    def new(self, name: typing.Union[str, typing.Any]) -> "ActionGroup":
        """Create a new action group and add it to the action

        :param name: New name for the action group
        :type name: typing.Union[str, typing.Any]
        :rtype: 'ActionGroup'
        :return: Newly created action group
        """
        ...

    def remove(self, action_group: "ActionGroup"):
        """Remove action group

        :param action_group: Action group to remove
        :type action_group: 'ActionGroup'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ActionPoseMarkers(bpy_struct):
    """Collection of timeline markers"""

    active: "TimelineMarker"
    """ Active pose marker for this action

    :type: 'TimelineMarker'
    """

    active_index: int
    """ Index of active pose marker

    :type: int
    """

    def new(self, name: typing.Union[str, typing.Any]) -> "TimelineMarker":
        """Add a pose marker to the action

        :param name: New name for the marker (not unique)
        :type name: typing.Union[str, typing.Any]
        :rtype: 'TimelineMarker'
        :return: Newly created marker
        """
        ...

    def remove(self, marker: "TimelineMarker"):
        """Remove a timeline marker

        :param marker: Timeline marker to remove
        :type marker: 'TimelineMarker'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Addon(bpy_struct):
    """Python add-ons to be loaded automatically"""

    module: typing.Union[str, typing.Any]
    """ Module name

    :type: typing.Union[str, typing.Any]
    """

    preferences: "AddonPreferences"
    """ 

    :type: 'AddonPreferences'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AddonPreferences(bpy_struct):
    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    layout: "UILayout"
    """ 

    :type: 'UILayout'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Addons(bpy_struct):
    """Collection of add-ons"""

    def new(self) -> "Addon":
        """Add a new add-on

        :rtype: 'Addon'
        :return: Add-on data
        """
        ...

    def remove(self, addon: "Addon"):
        """Remove add-on

        :param addon: Add-on to remove
        :type addon: 'Addon'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AnimData(bpy_struct):
    """Animation data for data-block"""

    action: "Action"
    """ Active Action for this data-block

    :type: 'Action'
    """

    action_blend_type: typing.Union[int, str]
    """ Method used for combining Active Action's result with result of NLA stack

    :type: typing.Union[int, str]
    """

    action_extrapolation: typing.Union[int, str]
    """ Action to take for gaps past the Active Action's range (when evaluating with NLA)

    :type: typing.Union[int, str]
    """

    action_influence: float
    """ Amount the Active Action contributes to the result of the NLA stack

    :type: float
    """

    action_tweak_storage: "Action"
    """ Slot to temporarily hold the main action while in tweak mode

    :type: 'Action'
    """

    drivers: bpy_prop_collection["FCurve"]
    """ The Drivers/Expressions for this data-block

    :type: bpy_prop_collection['FCurve']
    """

    nla_tracks: bpy_prop_collection["NlaTrack"]
    """ NLA Tracks (i.e. Animation Layers)

    :type: bpy_prop_collection['NlaTrack']
    """

    use_nla: bool
    """ NLA stack is evaluated when evaluating this block

    :type: bool
    """

    use_pin: bool
    """ 

    :type: bool
    """

    use_tweak_mode: bool
    """ Whether to enable or disable tweak mode in NLA

    :type: bool
    """

    def nla_tweak_strip_time_to_scene(
        self,
        frame: typing.Optional[float],
        invert: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> float:
        """Convert a time value from the local time of the tweaked strip to scene time, exactly as done by built-in key editing tools. Returns the input time unchanged if not tweaking.

        :param frame: Input time
        :type frame: typing.Optional[float]
        :param invert: Invert, Convert scene time to action time
        :type invert: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: float
        :return: Converted time
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AnimDataDrivers(bpy_struct):
    """Collection of Driver F-Curves"""

    def new(
        self,
        data_path: typing.Union[str, typing.Any],
        index: typing.Optional[typing.Any] = 0,
    ) -> "FCurve":
        """new

        :param data_path: Data Path, F-Curve data path to use
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, Array index
        :type index: typing.Optional[typing.Any]
        :rtype: 'FCurve'
        :return: Newly Driver F-Curve
        """
        ...

    def remove(self, driver: "FCurve"):
        """remove

        :param driver:
        :type driver: 'FCurve'
        """
        ...

    def from_existing(self, src_driver: typing.Optional["FCurve"] = None) -> "FCurve":
        """Add a new driver given an existing one

        :param src_driver: Existing Driver F-Curve to use as template for a new one
        :type src_driver: typing.Optional['FCurve']
        :rtype: 'FCurve'
        :return: New Driver F-Curve
        """
        ...

    def find(
        self,
        data_path: typing.Union[str, typing.Any],
        index: typing.Optional[typing.Any] = 0,
    ) -> "FCurve":
        """Find a driver F-Curve. Note that this function performs a linear scan of all driver F-Curves.

        :param data_path: Data Path, F-Curve data path
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, Array index
        :type index: typing.Optional[typing.Any]
        :rtype: 'FCurve'
        :return: The found F-Curve, or None if it doesn't exist
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AnimViz(bpy_struct):
    """Settings for the visualization of motion"""

    motion_path: "AnimVizMotionPaths"
    """ Motion Path settings for visualization

    :type: 'AnimVizMotionPaths'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AnimVizMotionPaths(bpy_struct):
    """Motion Path settings for animation visualization"""

    bake_location: typing.Union[int, str]
    """ When calculating Bone Paths, use Head or Tips

    :type: typing.Union[int, str]
    """

    frame_after: int
    """ Number of frames to show after the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    """

    frame_before: int
    """ Number of frames to show before the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    """

    frame_end: int
    """ End frame of range of paths to display/calculate (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    """

    frame_start: int
    """ Starting frame of range of paths to display/calculate (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    """

    frame_step: int
    """ Number of frames between paths shown (not for 'On Keyframes' Onion-skinning method)

    :type: int
    """

    has_motion_paths: typing.Union[bool, typing.Any]
    """ Are there any bone paths that will need updating (read-only)

    :type: typing.Union[bool, typing.Any]
    """

    range: typing.Union[int, str]
    """ Type of range to calculate for Motion Paths

    :type: typing.Union[int, str]
    """

    show_frame_numbers: bool
    """ Show frame numbers on Motion Paths

    :type: bool
    """

    show_keyframe_action_all: bool
    """ For bone motion paths, search whole Action for keyframes instead of in group with matching name only (is slower)

    :type: bool
    """

    show_keyframe_highlight: bool
    """ Emphasize position of keyframes on Motion Paths

    :type: bool
    """

    show_keyframe_numbers: bool
    """ Show frame numbers of Keyframes on Motion Paths

    :type: bool
    """

    type: typing.Union[int, str]
    """ Type of range to show for Motion Paths

    :type: typing.Union[int, str]
    """

    use_camera_space_bake: bool
    """ Motion path points will be baked into the camera space of the active camera. This means they will only look right when looking through that camera. Switching cameras using markers is not supported

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AnyType(bpy_struct):
    """RNA type used for pointers to any possible data"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Area(bpy_struct):
    """Area in a subdivided screen, containing an editor"""

    height: int
    """ Area height

    :type: int
    """

    regions: bpy_prop_collection["Region"]
    """ Regions this area is subdivided in

    :type: bpy_prop_collection['Region']
    """

    show_menus: bool
    """ Show menus in the header

    :type: bool
    """

    spaces: bpy_prop_collection["Space"]
    """ Spaces contained in this area, the first being the active space (NOTE: Useful for example to restore a previously used 3D view space in a certain area to get the old view orientation)

    :type: bpy_prop_collection['Space']
    """

    type: typing.Union[int, str]
    """ Current editor type for this area

    :type: typing.Union[int, str]
    """

    ui_type: typing.Union[int, str]
    """ Current editor type for this area

    :type: typing.Union[int, str]
    """

    width: int
    """ Area width

    :type: int
    """

    x: int
    """ The window relative vertical location of the area

    :type: int
    """

    y: int
    """ The window relative horizontal location of the area

    :type: int
    """

    def tag_redraw(self):
        """tag_redraw"""
        ...

    def header_text_set(self, text: typing.Optional[str]):
        """Set the header status text

        :param text: Text, New string for the header, None clears the text
        :type text: typing.Optional[str]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AreaSpaces(bpy_struct):
    """Collection of spaces"""

    active: "Space"
    """ Space currently being displayed in this area

    :type: 'Space'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ArmatureBones(bpy_struct):
    """Collection of armature bones"""

    active: "Bone"
    """ Armature's active bone

    :type: 'Bone'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ArmatureConstraintTargets(bpy_struct):
    """Collection of target bones and weights"""

    def new(self) -> "ConstraintTargetBone":
        """Add a new target to the constraint

        :rtype: 'ConstraintTargetBone'
        :return: New target bone
        """
        ...

    def remove(self, target: "ConstraintTargetBone"):
        """Delete target from the constraint

        :param target: Target to remove
        :type target: 'ConstraintTargetBone'
        """
        ...

    def clear(self):
        """Delete all targets from object"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ArmatureEditBones(bpy_struct):
    """Collection of armature edit bones"""

    active: "EditBone"
    """ Armatures active edit bone

    :type: 'EditBone'
    """

    def new(self, name: typing.Union[str, typing.Any]) -> "EditBone":
        """Add a new bone

        :param name: New name for the bone
        :type name: typing.Union[str, typing.Any]
        :rtype: 'EditBone'
        :return: Newly created edit bone
        """
        ...

    def remove(self, bone: "EditBone"):
        """Remove an existing bone from the armature

        :param bone: EditBone to remove
        :type bone: 'EditBone'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetCatalogPath(bpy_struct):
    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetLibraryCollection(bpy_struct):
    """Collection of user asset libraries"""

    def new(
        self,
        name: typing.Union[str, typing.Any] = "",
        directory: typing.Union[str, typing.Any] = "",
    ) -> "UserAssetLibrary":
        """Add a new Asset Library

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :param directory: Directory
        :type directory: typing.Union[str, typing.Any]
        :rtype: 'UserAssetLibrary'
        :return: Newly added asset library
        """
        ...

    def remove(self, library: "UserAssetLibrary"):
        """Remove an Asset Library

        :param library:
        :type library: 'UserAssetLibrary'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetLibraryReference(bpy_struct):
    """Identifier to refer to the asset library"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetMetaData(bpy_struct):
    """Additional data stored for an asset data-block"""

    active_tag: int
    """ Index of the tag set for editing

    :type: int
    """

    author: typing.Union[str, typing.Any]
    """ Name of the creator of the asset

    :type: typing.Union[str, typing.Any]
    """

    catalog_id: typing.Union[str, typing.Any]
    """ Identifier for the asset's catalog, used by Blender to look up the asset's catalog path. Must be a UUID according to RFC4122

    :type: typing.Union[str, typing.Any]
    """

    catalog_simple_name: typing.Union[str, typing.Any]
    """ Simple name of the asset's catalog, for debugging and data recovery purposes

    :type: typing.Union[str, typing.Any]
    """

    copyright: typing.Union[str, typing.Any]
    """ Copyright notice for this asset. An empty copyright notice does not necessarily indicate that this is copyright-free. Contact the author if any clarification is needed

    :type: typing.Union[str, typing.Any]
    """

    description: typing.Union[str, typing.Any]
    """ A description of the asset to be displayed for the user

    :type: typing.Union[str, typing.Any]
    """

    license: typing.Union[str, typing.Any]
    """ The type of license this asset is distributed under. An empty license name does not necessarily indicate that this is free of licensing terms. Contact the author if any clarification is needed

    :type: typing.Union[str, typing.Any]
    """

    tags: bpy_prop_collection["AssetTag"]
    """ Custom tags (name tokens) for the asset, used for filtering and general asset management

    :type: bpy_prop_collection['AssetTag']
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetRepresentation(bpy_struct):
    """Information about an entity that makes it possible for the asset system to deal with the entity as asset"""

    full_library_path: typing.Union[str, typing.Any]
    """ Absolute path to the .blend file containing this asset

    :type: typing.Union[str, typing.Any]
    """

    full_path: typing.Union[str, typing.Any]
    """ Absolute path to the .blend file containing this asset extended with the path of the asset inside the file

    :type: typing.Union[str, typing.Any]
    """

    id_type: typing.Any
    """ The type of the data-block, if the asset represents one ('NONE' otherwise)

    :type: typing.Any
    """

    local_id: "ID"
    """ The local data-block this asset represents; only valid if that is a data-block in this file

    :type: 'ID'
    """

    metadata: "AssetMetaData"
    """ Additional information about the asset

    :type: 'AssetMetaData'
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetShelf(bpy_struct):
    """Regions for quick access to assets"""

    asset_library_reference: typing.Union[int, str]
    """ Choose the asset library to display assets from

    :type: typing.Union[int, str]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the asset gets a custom ID, otherwise it takes the name of the class used to define the asset (for example, if the class name is "OBJECT_AST_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_AST_hello")

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Options for this asset shelf type

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    bl_space_type: typing.Union[int, str]
    """ The space where the asset shelf is going to be used in

    :type: typing.Union[int, str]
    """

    preview_size: int
    """ Size of the asset preview thumbnails in pixels

    :type: int
    """

    search_filter: typing.Union[str, typing.Any]
    """ Filter assets by name

    :type: typing.Union[str, typing.Any]
    """

    show_names: bool
    """ Show the asset name together with the preview. Otherwise only the preview will be visible

    :type: bool
    """

    def poll(self, context: typing.Optional["Context"]) -> bool:
        """If this method returns a non-null output, the asset shelf will be visible

        :param context:
        :type context: typing.Optional['Context']
        :rtype: bool
        """
        ...

    def asset_poll(self, asset: typing.Optional["AssetRepresentation"]) -> bool:
        """Determine if an asset should be visible in the asset shelf. If this method returns a non-null output, the asset will be visible

        :param asset:
        :type asset: typing.Optional['AssetRepresentation']
        :rtype: bool
        """
        ...

    def draw_context_menu(
        self,
        context: typing.Optional["Context"],
        asset: typing.Optional["AssetRepresentation"],
        layout: typing.Optional["UILayout"],
    ):
        """Draw UI elements into the context menu UI layout displayed on right click

        :param context:
        :type context: typing.Optional['Context']
        :param asset:
        :type asset: typing.Optional['AssetRepresentation']
        :param layout:
        :type layout: typing.Optional['UILayout']
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetTag(bpy_struct):
    """User defined tag (name token)"""

    name: typing.Union[str, typing.Any]
    """ The identifier that makes up this tag

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetTags(bpy_struct):
    """Collection of custom asset tags"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        skip_if_exists: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "AssetTag":
        """Add a new tag to this asset

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :param skip_if_exists: Skip if Exists, Do not add a new tag if one of the same type already exists
        :type skip_if_exists: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'AssetTag'
        :return: New tag
        """
        ...

    def remove(self, tag: "AssetTag"):
        """Remove an existing tag from this asset

        :param tag: Removed tag
        :type tag: 'AssetTag'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetWeakReference(bpy_struct):
    """Weak reference to some asset"""

    asset_library_identifier: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    asset_library_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    relative_asset_identifier: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Attribute(bpy_struct):
    """Geometry attribute"""

    data_type: typing.Any
    """ Type of data stored in attribute

    :type: typing.Any
    """

    domain: typing.Any
    """ Domain of the Attribute

    :type: typing.Any
    """

    is_internal: typing.Union[bool, typing.Any]
    """ The attribute is meant for internal use by Blender

    :type: typing.Union[bool, typing.Any]
    """

    is_required: typing.Union[bool, typing.Any]
    """ Whether the attribute can be removed or renamed

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Name of the Attribute

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AttributeGroup(bpy_struct):
    """Group of geometry attributes"""

    active: "Attribute"
    """ Active attribute

    :type: 'Attribute'
    """

    active_color: "Attribute"
    """ Active color attribute for display and editing

    :type: 'Attribute'
    """

    active_color_index: int
    """ Active color attribute index

    :type: int
    """

    active_color_name: typing.Union[str, typing.Any]
    """ The name of the active color attribute for display and editing

    :type: typing.Union[str, typing.Any]
    """

    active_index: int
    """ Active attribute index

    :type: int
    """

    default_color_name: typing.Union[str, typing.Any]
    """ The name of the default color attribute used as a fallback for rendering

    :type: typing.Union[str, typing.Any]
    """

    render_color_index: int
    """ The index of the color attribute used as a fallback for rendering

    :type: int
    """

    def new(
        self,
        name: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
        domain: typing.Optional[typing.Union[int, str]],
    ) -> "Attribute":
        """Add attribute to geometry

        :param name: Name, Name of geometry attribute
        :type name: typing.Union[str, typing.Any]
        :param type: Type, Attribute type
        :type type: typing.Optional[typing.Union[int, str]]
        :param domain: Domain, Type of element that attribute is stored on
        :type domain: typing.Optional[typing.Union[int, str]]
        :rtype: 'Attribute'
        :return: New geometry attribute
        """
        ...

    def remove(self, attribute: "Attribute"):
        """Remove attribute from geometry

        :param attribute: Geometry Attribute
        :type attribute: 'Attribute'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BakeSettings(bpy_struct):
    """Bake data for a Scene data-block"""

    cage_extrusion: float
    """ Inflate the active object by the specified distance for baking. This helps matching to points nearer to the outside of the selected object meshes

    :type: float
    """

    cage_object: "Object"
    """ Object to use as cage instead of calculating the cage from the active object with cage extrusion

    :type: 'Object'
    """

    filepath: typing.Union[str, typing.Any]
    """ Image filepath to use when saving externally

    :type: typing.Union[str, typing.Any]
    """

    height: int
    """ Vertical dimension of the baking map

    :type: int
    """

    image_settings: "ImageFormatSettings"
    """ 

    :type: 'ImageFormatSettings'
    """

    margin: int
    """ Extends the baked result as a post process filter

    :type: int
    """

    margin_type: typing.Union[int, str]
    """ Algorithm to extend the baked result

    :type: typing.Union[int, str]
    """

    max_ray_distance: float
    """ The maximum ray distance for matching points between the active and selected objects. If zero, there is no limit

    :type: float
    """

    normal_b: typing.Union[int, str]
    """ Axis to bake in blue channel

    :type: typing.Union[int, str]
    """

    normal_g: typing.Union[int, str]
    """ Axis to bake in green channel

    :type: typing.Union[int, str]
    """

    normal_r: typing.Union[int, str]
    """ Axis to bake in red channel

    :type: typing.Union[int, str]
    """

    normal_space: typing.Union[int, str]
    """ Choose normal space for baking

    :type: typing.Union[int, str]
    """

    pass_filter: typing.Any
    """ Passes to include in the active baking pass

    :type: typing.Any
    """

    save_mode: typing.Union[int, str]
    """ Where to save baked image textures

    :type: typing.Union[int, str]
    """

    target: typing.Union[int, str]
    """ Where to output the baked map

    :type: typing.Union[int, str]
    """

    use_automatic_name: bool
    """ Automatically name the output file with the pass type (external only)

    :type: bool
    """

    use_cage: bool
    """ Cast rays to active object from a cage

    :type: bool
    """

    use_clear: bool
    """ Clear Images before baking (internal only)

    :type: bool
    """

    use_pass_color: bool
    """ Color the pass

    :type: bool
    """

    use_pass_diffuse: bool
    """ Add diffuse contribution

    :type: bool
    """

    use_pass_direct: bool
    """ Add direct lighting contribution

    :type: bool
    """

    use_pass_emit: bool
    """ Add emission contribution

    :type: bool
    """

    use_pass_glossy: bool
    """ Add glossy contribution

    :type: bool
    """

    use_pass_indirect: bool
    """ Add indirect lighting contribution

    :type: bool
    """

    use_pass_transmission: bool
    """ Add transmission contribution

    :type: bool
    """

    use_selected_to_active: bool
    """ Bake shading on the surface of selected objects to the active object

    :type: bool
    """

    use_split_materials: bool
    """ Split external images per material (external only)

    :type: bool
    """

    view_from: typing.Union[int, str]
    """ Source of reflection ray directions

    :type: typing.Union[int, str]
    """

    width: int
    """ Horizontal dimension of the baking map

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BezierSplinePoint(bpy_struct):
    """Bézier curve point with two handles"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Coordinates of the control point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_left: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Coordinates of the first handle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_left_type: typing.Union[int, str]
    """ Handle types

    :type: typing.Union[int, str]
    """

    handle_right: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Coordinates of the second handle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_right_type: typing.Union[int, str]
    """ Handle types

    :type: typing.Union[int, str]
    """

    hide: bool
    """ Visibility status

    :type: bool
    """

    radius: float
    """ Radius for beveling

    :type: float
    """

    select_control_point: bool
    """ Control point selection status

    :type: bool
    """

    select_left_handle: bool
    """ Handle 1 selection status

    :type: bool
    """

    select_right_handle: bool
    """ Handle 2 selection status

    :type: bool
    """

    tilt: float
    """ Tilt in 3D View

    :type: float
    """

    weight_softbody: float
    """ Softbody goal weight

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendData(bpy_struct):
    """Main data structure representing a .blend file and all its data-blocks"""

    actions: bpy_prop_collection["Action"]
    """ Action data-blocks

    :type: bpy_prop_collection['Action']
    """

    armatures: bpy_prop_collection["Armature"]
    """ Armature data-blocks

    :type: bpy_prop_collection['Armature']
    """

    brushes: bpy_prop_collection["Brush"]
    """ Brush data-blocks

    :type: bpy_prop_collection['Brush']
    """

    cache_files: bpy_prop_collection["CacheFile"]
    """ Cache Files data-blocks

    :type: bpy_prop_collection['CacheFile']
    """

    cameras: bpy_prop_collection["Camera"]
    """ Camera data-blocks

    :type: bpy_prop_collection['Camera']
    """

    collections: bpy_prop_collection["Collection"]
    """ Collection data-blocks

    :type: bpy_prop_collection['Collection']
    """

    curves: bpy_prop_collection["Curve"]
    """ Curve data-blocks

    :type: bpy_prop_collection['Curve']
    """

    filepath: typing.Union[str, typing.Any]
    """ Path to the .blend file

    :type: typing.Union[str, typing.Any]
    """

    fonts: bpy_prop_collection["VectorFont"]
    """ Vector font data-blocks

    :type: bpy_prop_collection['VectorFont']
    """

    grease_pencils: bpy_prop_collection["GreasePencil"]
    """ Grease Pencil data-blocks

    :type: bpy_prop_collection['GreasePencil']
    """

    grease_pencils_v3: bpy_prop_collection["GreasePencilv3"]
    """ Grease Pencil v3 data-blocks

    :type: bpy_prop_collection['GreasePencilv3']
    """

    hair_curves: bpy_prop_collection["Curves"]
    """ Hair curve data-blocks

    :type: bpy_prop_collection['Curves']
    """

    images: bpy_prop_collection["Image"]
    """ Image data-blocks

    :type: bpy_prop_collection['Image']
    """

    is_dirty: typing.Union[bool, typing.Any]
    """ Have recent edits been saved to disk

    :type: typing.Union[bool, typing.Any]
    """

    is_saved: typing.Union[bool, typing.Any]
    """ Has the current session been saved to disk as a .blend file

    :type: typing.Union[bool, typing.Any]
    """

    lattices: bpy_prop_collection["Lattice"]
    """ Lattice data-blocks

    :type: bpy_prop_collection['Lattice']
    """

    libraries: bpy_prop_collection["Library"]
    """ Library data-blocks

    :type: bpy_prop_collection['Library']
    """

    lightprobes: bpy_prop_collection["LightProbe"]
    """ Light Probe data-blocks

    :type: bpy_prop_collection['LightProbe']
    """

    lights: bpy_prop_collection["Light"]
    """ Light data-blocks

    :type: bpy_prop_collection['Light']
    """

    linestyles: bpy_prop_collection["FreestyleLineStyle"]
    """ Line Style data-blocks

    :type: bpy_prop_collection['FreestyleLineStyle']
    """

    masks: bpy_prop_collection["Mask"]
    """ Masks data-blocks

    :type: bpy_prop_collection['Mask']
    """

    materials: bpy_prop_collection["Material"]
    """ Material data-blocks

    :type: bpy_prop_collection['Material']
    """

    meshes: bpy_prop_collection["Mesh"]
    """ Mesh data-blocks

    :type: bpy_prop_collection['Mesh']
    """

    metaballs: bpy_prop_collection["MetaBall"]
    """ Metaball data-blocks

    :type: bpy_prop_collection['MetaBall']
    """

    movieclips: bpy_prop_collection["MovieClip"]
    """ Movie Clip data-blocks

    :type: bpy_prop_collection['MovieClip']
    """

    node_groups: bpy_prop_collection["NodeTree"]
    """ Node group data-blocks

    :type: bpy_prop_collection['NodeTree']
    """

    objects: bpy_prop_collection["Object"]
    """ Object data-blocks

    :type: bpy_prop_collection['Object']
    """

    paint_curves: bpy_prop_collection["PaintCurve"]
    """ Paint Curves data-blocks

    :type: bpy_prop_collection['PaintCurve']
    """

    palettes: bpy_prop_collection["Palette"]
    """ Palette data-blocks

    :type: bpy_prop_collection['Palette']
    """

    particles: bpy_prop_collection["ParticleSettings"]
    """ Particle data-blocks

    :type: bpy_prop_collection['ParticleSettings']
    """

    pointclouds: bpy_prop_collection["PointCloud"]
    """ Point cloud data-blocks

    :type: bpy_prop_collection['PointCloud']
    """

    scenes: bpy_prop_collection["Scene"]
    """ Scene data-blocks

    :type: bpy_prop_collection['Scene']
    """

    screens: bpy_prop_collection["Screen"]
    """ Screen data-blocks

    :type: bpy_prop_collection['Screen']
    """

    shape_keys: bpy_prop_collection["Key"]
    """ Shape Key data-blocks

    :type: bpy_prop_collection['Key']
    """

    sounds: bpy_prop_collection["Sound"]
    """ Sound data-blocks

    :type: bpy_prop_collection['Sound']
    """

    speakers: bpy_prop_collection["Speaker"]
    """ Speaker data-blocks

    :type: bpy_prop_collection['Speaker']
    """

    texts: bpy_prop_collection["Text"]
    """ Text data-blocks

    :type: bpy_prop_collection['Text']
    """

    textures: bpy_prop_collection["Texture"]
    """ Texture data-blocks

    :type: bpy_prop_collection['Texture']
    """

    use_autopack: bool
    """ Automatically pack all external data into .blend file

    :type: bool
    """

    version: bpy_prop_array[int]
    """ File format version the .blend file was saved with

    :type: bpy_prop_array[int]
    """

    volumes: bpy_prop_collection["Volume"]
    """ Volume data-blocks

    :type: bpy_prop_collection['Volume']
    """

    window_managers: bpy_prop_collection["WindowManager"]
    """ Window manager data-blocks

    :type: bpy_prop_collection['WindowManager']
    """

    workspaces: bpy_prop_collection["WorkSpace"]
    """ Workspace data-blocks

    :type: bpy_prop_collection['WorkSpace']
    """

    worlds: bpy_prop_collection["World"]
    """ World data-blocks

    :type: bpy_prop_collection['World']
    """

    def batch_remove(self, ids):
        """Remove (delete) several IDs at once.WARNING: Considered experimental feature currently.Note that this function is quicker than individual calls to `remove()` (from `bpy.types.BlendData`
        ID collections), but less safe/versatile (it can break Blender, e.g. by removing all scenes...).

                :param ids: Iterables of IDs (types can be mixed).
                :type ids:
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

    def orphans_purge(self):
        """Remove (delete) all IDs with no user.

        :return: The number of deleted IDs.
        """
        ...

    def temp_data(
        self, filepath: typing.Optional[typing.Union[bytes, str]] = None
    ) -> "BlendData":
        """A context manager that temporarily creates blender file data.

        :param filepath: The file path for the newly temporary data. When None, the path of the currently open file is used.
        :type filepath: typing.Optional[typing.Union[bytes, str]]
        :rtype: 'BlendData'
        :return: Blend file data which is freed once the context exists.
        """
        ...

    def user_map(
        self,
        subset: typing.Optional[typing.Sequence],
        key_types: typing.Optional[typing.Set[str]],
        value_types: typing.Optional[typing.Set[str]],
    ) -> typing.Dict:
        """Returns a mapping of all ID data-blocks in current bpy.data to a set of all datablocks using them.For list of valid set members for key_types & value_types, see: `bpy.types.KeyingSetPath.id_type`.

        :param subset: When passed, only these data-blocks and their users will be included as keys/values in the map.
        :type subset: typing.Optional[typing.Sequence]
        :param key_types: Filter the keys mapped by ID types.
        :type key_types: typing.Optional[typing.Set[str]]
        :param value_types: Filter the values in the set by ID types.
        :type value_types: typing.Optional[typing.Set[str]]
        :rtype: typing.Dict
        :return: dictionary of `bpy.types.ID` instances, with sets of ID's as their values.
        """
        ...

class BlendDataActions(bpy_struct):
    """Collection of actions"""

    def new(self, name: typing.Union[str, typing.Any]) -> "Action":
        """Add a new action to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Action'
        :return: New action data-block
        """
        ...

    def remove(
        self,
        action: "Action",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove an action from the current blendfile

        :param action: Action to remove
        :type action: 'Action'
        :param do_unlink: Unlink all usages of this action before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this action
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this action
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataArmatures(bpy_struct):
    """Collection of armatures"""

    def new(self, name: typing.Union[str, typing.Any]) -> "Armature":
        """Add a new armature to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Armature'
        :return: New armature data-block
        """
        ...

    def remove(
        self,
        armature: "Armature",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove an armature from the current blendfile

        :param armature: Armature to remove
        :type armature: 'Armature'
        :param do_unlink: Unlink all usages of this armature before deleting it (WARNING: will also delete objects instancing that armature data)
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this armature data
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this armature data
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataBrushes(bpy_struct):
    """Collection of brushes"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        mode: typing.Optional[typing.Any] = "TEXTURE_PAINT",
    ) -> "Brush":
        """Add a new brush to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param mode: Paint Mode for the new brush
        :type mode: typing.Optional[typing.Any]
        :rtype: 'Brush'
        :return: New brush data-block
        """
        ...

    def remove(
        self,
        brush: "Brush",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a brush from the current blendfile

        :param brush: Brush to remove
        :type brush: 'Brush'
        :param do_unlink: Unlink all usages of this brush before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this brush
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this brush
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def create_gpencil_data(self, brush: "Brush"):
        """Add grease pencil brush settings

        :param brush: Brush
        :type brush: 'Brush'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataCacheFiles(bpy_struct):
    """Collection of cache files"""

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataCameras(bpy_struct):
    """Collection of cameras"""

    def new(self, name: typing.Union[str, typing.Any]) -> "Camera":
        """Add a new camera to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Camera'
        :return: New camera data-block
        """
        ...

    def remove(
        self,
        camera: "Camera",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a camera from the current blendfile

        :param camera: Camera to remove
        :type camera: 'Camera'
        :param do_unlink: Unlink all usages of this camera before deleting it (WARNING: will also delete objects instancing that camera data)
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this camera
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this camera
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataCollections(bpy_struct):
    """Collection of collections"""

    def new(self, name: typing.Union[str, typing.Any]) -> "Collection":
        """Add a new collection to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Collection'
        :return: New collection data-block
        """
        ...

    def remove(
        self,
        collection: "Collection",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a collection from the current blendfile

        :param collection: Collection to remove
        :type collection: 'Collection'
        :param do_unlink: Unlink all usages of this collection before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this collection
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this collection
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataCurves(bpy_struct):
    """Collection of curves"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ) -> "Curve":
        """Add a new curve to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param type: Type, The type of curve to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'Curve'
        :return: New curve data-block
        """
        ...

    def remove(
        self,
        curve: "Curve",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a curve from the current blendfile

        :param curve: Curve to remove
        :type curve: 'Curve'
        :param do_unlink: Unlink all usages of this curve before deleting it (WARNING: will also delete objects instancing that curve data)
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this curve data
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this curve data
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataFonts(bpy_struct):
    """Collection of fonts"""

    def load(
        self,
        filepath: typing.Union[str, typing.Any],
        check_existing: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "VectorFont":
        """Load a new font into the main database

        :param filepath: path of the font to load
        :type filepath: typing.Union[str, typing.Any]
        :param check_existing: Using existing data-block if this file is already loaded
        :type check_existing: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'VectorFont'
        :return: New font data-block
        """
        ...

    def remove(
        self,
        vfont: "VectorFont",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a font from the current blendfile

        :param vfont: Font to remove
        :type vfont: 'VectorFont'
        :param do_unlink: Unlink all usages of this font before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this font
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this font
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataGreasePencils(bpy_struct):
    """Collection of grease pencils"""

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def new(self, name: typing.Union[str, typing.Any]) -> "GreasePencil":
        """Add a new grease pencil datablock to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'GreasePencil'
        :return: New grease pencil data-block
        """
        ...

    def remove(
        self,
        grease_pencil: "GreasePencil",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a grease pencil instance from the current blendfile

        :param grease_pencil: Grease Pencil to remove
        :type grease_pencil: 'GreasePencil'
        :param do_unlink: Unlink all usages of this grease pencil before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this grease pencil
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this grease pencil
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataGreasePencilsV3(bpy_struct):
    """Collection of grease pencils"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataHairCurves(bpy_struct):
    """Collection of hair curves"""

    def new(self, name: typing.Union[str, typing.Any]) -> "Curves":
        """Add a new hair to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Curves'
        :return: New curves data-block
        """
        ...

    def remove(
        self,
        curves: "Curves",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a curves data-block from the current blendfile

        :param curves: Curves data-block to remove
        :type curves: 'Curves'
        :param do_unlink: Unlink all usages of this curves before deleting it (WARNING: will also delete objects instancing that curves data)
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this curves data
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this curves data
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataImages(bpy_struct):
    """Collection of images"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        width: typing.Optional[int],
        height: typing.Optional[int],
        alpha: typing.Optional[typing.Union[bool, typing.Any]] = False,
        float_buffer: typing.Optional[typing.Union[bool, typing.Any]] = False,
        stereo3d: typing.Optional[typing.Union[bool, typing.Any]] = False,
        is_data: typing.Optional[typing.Union[bool, typing.Any]] = False,
        tiled: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "Image":
        """Add a new image to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param width: Width of the image
        :type width: typing.Optional[int]
        :param height: Height of the image
        :type height: typing.Optional[int]
        :param alpha: Alpha, Use alpha channel
        :type alpha: typing.Optional[typing.Union[bool, typing.Any]]
        :param float_buffer: Float Buffer, Create an image with floating-point color
        :type float_buffer: typing.Optional[typing.Union[bool, typing.Any]]
        :param stereo3d: Stereo 3D, Create left and right views
        :type stereo3d: typing.Optional[typing.Union[bool, typing.Any]]
        :param is_data: Is Data, Create image with non-color data color space
        :type is_data: typing.Optional[typing.Union[bool, typing.Any]]
        :param tiled: Tiled, Create a tiled image
        :type tiled: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'Image'
        :return: New image data-block
        """
        ...

    def load(
        self,
        filepath: typing.Union[str, typing.Any],
        check_existing: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "Image":
        """Load a new image into the main database

        :param filepath: Path of the file to load
        :type filepath: typing.Union[str, typing.Any]
        :param check_existing: Using existing data-block if this file is already loaded
        :type check_existing: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'Image'
        :return: New image data-block
        """
        ...

    def remove(
        self,
        image: "Image",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove an image from the current blendfile

        :param image: Image to remove
        :type image: 'Image'
        :param do_unlink: Unlink all usages of this image before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this image
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this image
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataLattices(bpy_struct):
    """Collection of lattices"""

    def new(self, name: typing.Union[str, typing.Any]) -> "Lattice":
        """Add a new lattice to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Lattice'
        :return: New lattice data-block
        """
        ...

    def remove(
        self,
        lattice: "Lattice",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a lattice from the current blendfile

        :param lattice: Lattice to remove
        :type lattice: 'Lattice'
        :param do_unlink: Unlink all usages of this lattice before deleting it (WARNING: will also delete objects instancing that lattice data)
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this lattice data
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this lattice data
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataLibraries(bpy_struct):
    """Collection of libraries"""

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def remove(
        self,
        library: "Library",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a library from the current blendfile

        :param library: Library to remove
        :type library: 'Library'
        :param do_unlink: Unlink all usages of this library before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this library
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this library
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

    def load(
        self,
        filepath: typing.Optional[typing.Union[bytes, str]],
        link: typing.Optional[bool] = False,
        relative: typing.Optional[bool] = False,
        assets_only: typing.Optional[bool] = False,
        create_liboverrides: typing.Optional[bool] = False,
        reuse_liboverrides: typing.Optional[bool] = False,
        create_liboverrides_runtime: typing.Optional[bool] = False,
    ):
        """Returns a context manager which exposes 2 library objects on entering.
        Each object has attributes matching bpy.data which are lists of strings to be linked.

                :param filepath: The path to a blend file.
                :type filepath: typing.Optional[typing.Union[bytes, str]]
                :param link: When False reference to the original file is lost.
                :type link: typing.Optional[bool]
                :param relative: When True the path is stored relative to the open blend file.
                :type relative: typing.Optional[bool]
                :param assets_only: If True, only list data-blocks marked as assets.
                :type assets_only: typing.Optional[bool]
                :param create_liboverrides: If True and link is True, liboverrides will
        be created for linked data.
                :type create_liboverrides: typing.Optional[bool]
                :param reuse_liboverrides: If True and create_liboverride is True,
        search for existing liboverride first.
                :type reuse_liboverrides: typing.Optional[bool]
                :param create_liboverrides_runtime: If True and create_liboverride is True,
        create (or search for existing) runtime liboverride.
                :type create_liboverrides_runtime: typing.Optional[bool]
        """
        ...

    def write(
        self,
        filepath: typing.Optional[typing.Union[bytes, str]],
        datablocks: typing.Optional[typing.Set],
        path_remap: typing.Optional[str] = False,
        fake_user: typing.Optional[bool] = False,
        compress: typing.Optional[bool] = False,
    ):
        """Write data-blocks into a blend file.

                :param filepath: The path to write the blend-file.
                :type filepath: typing.Optional[typing.Union[bytes, str]]
                :param datablocks: set of data-blocks (`bpy.types.ID` instances).
                :type datablocks: typing.Optional[typing.Set]
                :param path_remap: Optionally remap paths when writing the file:

        NONE No path manipulation (default).

        RELATIVE Remap paths that are already relative to the new location.

        RELATIVE_ALL Remap all paths to be relative to the new location.

        ABSOLUTE Make all paths absolute on writing.
                :type path_remap: typing.Optional[str]
                :param fake_user: When True, data-blocks will be written with fake-user flag enabled.
                :type fake_user: typing.Optional[bool]
                :param compress: When True, write a compressed blend file.
                :type compress: typing.Optional[bool]
        """
        ...

class BlendDataLights(bpy_struct):
    """Collection of lights"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ) -> "Light":
        """Add a new light to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param type: Type, The type of light to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'Light'
        :return: New light data-block
        """
        ...

    def remove(
        self,
        light: "Light",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a light from the current blendfile

        :param light: Light to remove
        :type light: 'Light'
        :param do_unlink: Unlink all usages of this light before deleting it (WARNING: will also delete objects instancing that light data)
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this light data
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this light data
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataLineStyles(bpy_struct):
    """Collection of line styles"""

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def new(self, name: typing.Union[str, typing.Any]) -> "FreestyleLineStyle":
        """Add a new line style instance to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'FreestyleLineStyle'
        :return: New line style data-block
        """
        ...

    def remove(
        self,
        linestyle: "FreestyleLineStyle",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a line style instance from the current blendfile

        :param linestyle: Line style to remove
        :type linestyle: 'FreestyleLineStyle'
        :param do_unlink: Unlink all usages of this line style before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this line style
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this line style
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataMasks(bpy_struct):
    """Collection of masks"""

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def new(self, name: typing.Union[str, typing.Any]) -> "Mask":
        """Add a new mask with a given name to the main database

        :param name: Mask, Name of new mask data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Mask'
        :return: New mask data-block
        """
        ...

    def remove(
        self,
        mask: "Mask",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a mask from the current blendfile

        :param mask: Mask to remove
        :type mask: 'Mask'
        :param do_unlink: Unlink all usages of this mask before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this mask
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this mask
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataMaterials(bpy_struct):
    """Collection of materials"""

    def new(self, name: typing.Union[str, typing.Any]) -> "Material":
        """Add a new material to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Material'
        :return: New material data-block
        """
        ...

    def create_gpencil_data(self, material: "Material"):
        """Add grease pencil material settings

        :param material: Material
        :type material: 'Material'
        """
        ...

    def remove_gpencil_data(self, material: "Material"):
        """Remove grease pencil material settings

        :param material: Material
        :type material: 'Material'
        """
        ...

    def remove(
        self,
        material: "Material",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a material from the current blendfile

        :param material: Material to remove
        :type material: 'Material'
        :param do_unlink: Unlink all usages of this material before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this material
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this material
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataMeshes(bpy_struct):
    """Collection of meshes"""

    def new(self, name: typing.Union[str, typing.Any]) -> "Mesh":
        """Add a new mesh to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Mesh'
        :return: New mesh data-block
        """
        ...

    def new_from_object(
        self,
        object: "Object",
        preserve_all_data_layers: typing.Optional[
            typing.Union[bool, typing.Any]
        ] = False,
        depsgraph: typing.Optional["Depsgraph"] = None,
    ) -> "Mesh":
        """Add a new mesh created from given object (undeformed geometry if object is original, and final evaluated geometry, with all modifiers etc., if object is evaluated)

        :param object: Object to create mesh from
        :type object: 'Object'
        :param preserve_all_data_layers: Preserve all data layers in the mesh, like UV maps and vertex groups. By default Blender only computes the subset of data layers needed for viewport display and rendering, for better performance
        :type preserve_all_data_layers: typing.Optional[typing.Union[bool, typing.Any]]
        :param depsgraph: Dependency Graph, Evaluated dependency graph which is required when preserve_all_data_layers is true
        :type depsgraph: typing.Optional['Depsgraph']
        :rtype: 'Mesh'
        :return: Mesh created from object, remove it if it is only used for export
        """
        ...

    def remove(
        self,
        mesh: "Mesh",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a mesh from the current blendfile

        :param mesh: Mesh to remove
        :type mesh: 'Mesh'
        :param do_unlink: Unlink all usages of this mesh before deleting it (WARNING: will also delete objects instancing that mesh data)
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this mesh data
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this mesh data
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataMetaBalls(bpy_struct):
    """Collection of metaballs"""

    def new(self, name: typing.Union[str, typing.Any]) -> "MetaBall":
        """Add a new metaball to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'MetaBall'
        :return: New metaball data-block
        """
        ...

    def remove(
        self,
        metaball: "MetaBall",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a metaball from the current blendfile

        :param metaball: Metaball to remove
        :type metaball: 'MetaBall'
        :param do_unlink: Unlink all usages of this metaball before deleting it (WARNING: will also delete objects instancing that metaball data)
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this metaball data
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this metaball data
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataMovieClips(bpy_struct):
    """Collection of movie clips"""

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def remove(
        self,
        clip: "MovieClip",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a movie clip from the current blendfile.

        :param clip: Movie clip to remove
        :type clip: 'MovieClip'
        :param do_unlink: Unlink all usages of this movie clip before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this movie clip
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this movie clip
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def load(
        self,
        filepath: typing.Union[str, typing.Any],
        check_existing: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "MovieClip":
        """Add a new movie clip to the main database from a file (while check_existing is disabled for consistency with other load functions, behavior with multiple movie-clips using the same file may incorrectly generate proxies)

        :param filepath: path for the data-block
        :type filepath: typing.Union[str, typing.Any]
        :param check_existing: Using existing data-block if this file is already loaded
        :type check_existing: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'MovieClip'
        :return: New movie clip data-block
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataNodeTrees(bpy_struct):
    """Collection of node trees"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ) -> "NodeTree":
        """Add a new node tree to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param type: Type, The type of node_group to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'NodeTree'
        :return: New node tree data-block
        """
        ...

    def remove(
        self,
        tree: "NodeTree",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a node tree from the current blendfile

        :param tree: Node tree to remove
        :type tree: 'NodeTree'
        :param do_unlink: Unlink all usages of this node tree before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this node tree
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this node tree
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataObjects(bpy_struct):
    """Collection of objects"""

    def new(
        self, name: typing.Union[str, typing.Any], object_data: typing.Optional["ID"]
    ) -> "Object":
        """Add a new object to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param object_data: Object data or None for an empty object
        :type object_data: typing.Optional['ID']
        :rtype: 'Object'
        :return: New object data-block
        """
        ...

    def remove(
        self,
        object: "Object",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove an object from the current blendfile

        :param object: Object to remove
        :type object: 'Object'
        :param do_unlink: Unlink all usages of this object before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this object
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this object
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataPaintCurves(bpy_struct):
    """Collection of paint curves"""

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataPalettes(bpy_struct):
    """Collection of palettes"""

    def new(self, name: typing.Union[str, typing.Any]) -> "Palette":
        """Add a new palette to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Palette'
        :return: New palette data-block
        """
        ...

    def remove(
        self,
        palette: "Palette",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a palette from the current blendfile

        :param palette: Palette to remove
        :type palette: 'Palette'
        :param do_unlink: Unlink all usages of this palette before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this palette
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this palette
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataParticles(bpy_struct):
    """Collection of particle settings"""

    def new(self, name: typing.Union[str, typing.Any]) -> "ParticleSettings":
        """Add a new particle settings instance to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'ParticleSettings'
        :return: New particle settings data-block
        """
        ...

    def remove(
        self,
        particle: "ParticleSettings",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a particle settings instance from the current blendfile

        :param particle: Particle Settings to remove
        :type particle: 'ParticleSettings'
        :param do_unlink: Unlink all usages of those particle settings before deleting them
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this particle settings
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this particle settings
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataPointClouds(bpy_struct):
    """Collection of point clouds"""

    def new(self, name: typing.Union[str, typing.Any]) -> "PointCloud":
        """Add a new point cloud to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'PointCloud'
        :return: New point cloud data-block
        """
        ...

    def remove(
        self,
        pointcloud: "PointCloud",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a point cloud from the current blendfile

        :param pointcloud: Point cloud to remove
        :type pointcloud: 'PointCloud'
        :param do_unlink: Unlink all usages of this point cloud before deleting it (WARNING: will also delete objects instancing that point cloud data)
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this point cloud data
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this point cloud data
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataProbes(bpy_struct):
    """Collection of light probes"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ) -> "LightProbe":
        """Add a new light probe to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param type: Type, The type of light probe to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'LightProbe'
        :return: New light probe data-block
        """
        ...

    def remove(
        self,
        lightprobe: "LightProbe",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a light probe from the current blendfile

        :param lightprobe: Light probe to remove
        :type lightprobe: 'LightProbe'
        :param do_unlink: Unlink all usages of this light probe before deleting it (WARNING: will also delete objects instancing that light probe data)
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this light probe
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this light probe
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataScenes(bpy_struct):
    """Collection of scenes"""

    def new(self, name: typing.Union[str, typing.Any]) -> "Scene":
        """Add a new scene to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Scene'
        :return: New scene data-block
        """
        ...

    def remove(
        self,
        scene: "Scene",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a scene from the current blendfile

        :param scene: Scene to remove
        :type scene: 'Scene'
        :param do_unlink: Unlink all usages of this scene before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataScreens(bpy_struct):
    """Collection of screens"""

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataSounds(bpy_struct):
    """Collection of sounds"""

    def load(
        self,
        filepath: typing.Union[str, typing.Any],
        check_existing: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "Sound":
        """Add a new sound to the main database from a file

        :param filepath: path for the data-block
        :type filepath: typing.Union[str, typing.Any]
        :param check_existing: Using existing data-block if this file is already loaded
        :type check_existing: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'Sound'
        :return: New text data-block
        """
        ...

    def remove(
        self,
        sound: "Sound",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a sound from the current blendfile

        :param sound: Sound to remove
        :type sound: 'Sound'
        :param do_unlink: Unlink all usages of this sound before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this sound
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this sound
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataSpeakers(bpy_struct):
    """Collection of speakers"""

    def new(self, name: typing.Union[str, typing.Any]) -> "Speaker":
        """Add a new speaker to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Speaker'
        :return: New speaker data-block
        """
        ...

    def remove(
        self,
        speaker: "Speaker",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a speaker from the current blendfile

        :param speaker: Speaker to remove
        :type speaker: 'Speaker'
        :param do_unlink: Unlink all usages of this speaker before deleting it (WARNING: will also delete objects instancing that speaker data)
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this speaker data
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this speaker data
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataTexts(bpy_struct):
    """Collection of texts"""

    def new(self, name: typing.Union[str, typing.Any]) -> "Text":
        """Add a new text to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Text'
        :return: New text data-block
        """
        ...

    def remove(
        self,
        text: "Text",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a text from the current blendfile

        :param text: Text to remove
        :type text: 'Text'
        :param do_unlink: Unlink all usages of this text before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this text
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this text
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def load(
        self,
        filepath: typing.Union[str, typing.Any],
        internal: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "Text":
        """Add a new text to the main database from a file

        :param filepath: path for the data-block
        :type filepath: typing.Union[str, typing.Any]
        :param internal: Make internal, Make text file internal after loading
        :type internal: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'Text'
        :return: New text data-block
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataTextures(bpy_struct):
    """Collection of textures"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ) -> "Texture":
        """Add a new texture to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :param type: Type, The type of texture to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'Texture'
        :return: New texture data-block
        """
        ...

    def remove(
        self,
        texture: "Texture",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a texture from the current blendfile

        :param texture: Texture to remove
        :type texture: 'Texture'
        :param do_unlink: Unlink all usages of this texture before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this texture
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this texture
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataVolumes(bpy_struct):
    """Collection of volumes"""

    def new(self, name: typing.Union[str, typing.Any]) -> "Volume":
        """Add a new volume to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Volume'
        :return: New volume data-block
        """
        ...

    def remove(
        self,
        volume: "Volume",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a volume from the current blendfile

        :param volume: Volume to remove
        :type volume: 'Volume'
        :param do_unlink: Unlink all usages of this volume before deleting it (WARNING: will also delete objects instancing that volume data)
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this volume data
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this volume data
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataWindowManagers(bpy_struct):
    """Collection of window managers"""

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataWorkSpaces(bpy_struct):
    """Collection of workspaces"""

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendDataWorlds(bpy_struct):
    """Collection of worlds"""

    def new(self, name: typing.Union[str, typing.Any]) -> "World":
        """Add a new world to the main database

        :param name: New name for the data-block
        :type name: typing.Union[str, typing.Any]
        :rtype: 'World'
        :return: New world data-block
        """
        ...

    def remove(
        self,
        world: "World",
        do_unlink: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_id_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
        do_ui_user: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove a world from the current blendfile

        :param world: World to remove
        :type world: 'World'
        :param do_unlink: Unlink all usages of this world before deleting it
        :type do_unlink: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_id_user: Decrement user counter of all datablocks used by this world
        :type do_id_user: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_ui_user: Make sure interface does not reference this world
        :type do_ui_user: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def tag(self, value: typing.Optional[bool]):
        """tag

        :param value: Value
        :type value: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlenderRNA(bpy_struct):
    """Blender RNA structure definitions"""

    structs: bpy_prop_collection["Struct"]
    """ 

    :type: bpy_prop_collection['Struct']
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoidRule(bpy_struct):
    name: typing.Union[str, typing.Any]
    """ Boid rule name

    :type: typing.Union[str, typing.Any]
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    use_in_air: bool
    """ Use rule when boid is flying

    :type: bool
    """

    use_on_land: bool
    """ Use rule when boid is on land

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoidSettings(bpy_struct):
    """Settings for boid physics"""

    accuracy: float
    """ Accuracy of attack

    :type: float
    """

    active_boid_state: "BoidRule"
    """ 

    :type: 'BoidRule'
    """

    active_boid_state_index: int
    """ 

    :type: int
    """

    aggression: float
    """ Boid will fight this times stronger enemy

    :type: float
    """

    air_acc_max: float
    """ Maximum acceleration in air (relative to maximum speed)

    :type: float
    """

    air_ave_max: float
    """ Maximum angular velocity in air (relative to 180 degrees)

    :type: float
    """

    air_personal_space: float
    """ Radius of boids personal space in air (% of particle size)

    :type: float
    """

    air_speed_max: float
    """ Maximum speed in air

    :type: float
    """

    air_speed_min: float
    """ Minimum speed in air (relative to maximum speed)

    :type: float
    """

    bank: float
    """ Amount of rotation around velocity vector on turns

    :type: float
    """

    health: float
    """ Initial boid health when born

    :type: float
    """

    height: float
    """ Boid height relative to particle size

    :type: float
    """

    land_acc_max: float
    """ Maximum acceleration on land (relative to maximum speed)

    :type: float
    """

    land_ave_max: float
    """ Maximum angular velocity on land (relative to 180 degrees)

    :type: float
    """

    land_jump_speed: float
    """ Maximum speed for jumping

    :type: float
    """

    land_personal_space: float
    """ Radius of boids personal space on land (% of particle size)

    :type: float
    """

    land_smooth: float
    """ How smoothly the boids land

    :type: float
    """

    land_speed_max: float
    """ Maximum speed on land

    :type: float
    """

    land_stick_force: float
    """ How strong a force must be to start effecting a boid on land

    :type: float
    """

    pitch: float
    """ Amount of rotation around side vector

    :type: float
    """

    range: float
    """ Maximum distance from which a boid can attack

    :type: float
    """

    states: bpy_prop_collection["BoidState"]
    """ 

    :type: bpy_prop_collection['BoidState']
    """

    strength: float
    """ Maximum caused damage on attack per second

    :type: float
    """

    use_climb: bool
    """ Allow boids to climb goal objects

    :type: bool
    """

    use_flight: bool
    """ Allow boids to move in air

    :type: bool
    """

    use_land: bool
    """ Allow boids to move on land

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoidState(bpy_struct):
    """Boid state for boid physics"""

    active_boid_rule: "BoidRule"
    """ 

    :type: 'BoidRule'
    """

    active_boid_rule_index: int
    """ 

    :type: int
    """

    falloff: float
    """ 

    :type: float
    """

    name: typing.Union[str, typing.Any]
    """ Boid state name

    :type: typing.Union[str, typing.Any]
    """

    rule_fuzzy: float
    """ 

    :type: float
    """

    rules: bpy_prop_collection["BoidRule"]
    """ 

    :type: bpy_prop_collection['BoidRule']
    """

    ruleset_type: typing.Union[int, str]
    """ How the rules in the list are evaluated

    :type: typing.Union[int, str]
    """

    volume: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Bone(bpy_struct):
    """Bone in an Armature data-block"""

    bbone_curveinx: float
    """ X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveinz: float
    """ Z-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutx: float
    """ X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutz: float
    """ Z-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_custom_handle_end: "Bone"
    """ Bone that serves as the end handle for the B-Bone curve

    :type: 'Bone'
    """

    bbone_custom_handle_start: "Bone"
    """ Bone that serves as the start handle for the B-Bone curve

    :type: 'Bone'
    """

    bbone_easein: float
    """ Length of first Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_easeout: float
    """ Length of second Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_handle_type_end: typing.Union[int, str]
    """ Selects how the end handle of the B-Bone is computed

    :type: typing.Union[int, str]
    """

    bbone_handle_type_start: typing.Union[int, str]
    """ Selects how the start handle of the B-Bone is computed

    :type: typing.Union[int, str]
    """

    bbone_handle_use_ease_end: bool
    """ Multiply the B-Bone Ease Out channel by the local Y scale value of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    """

    bbone_handle_use_ease_start: bool
    """ Multiply the B-Bone Ease In channel by the local Y scale value of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    """

    bbone_handle_use_scale_end: typing.List[bool]
    """ Multiply B-Bone Scale Out channels by the local scale values of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    """

    bbone_handle_use_scale_start: typing.List[bool]
    """ Multiply B-Bone Scale In channels by the local scale values of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    """

    bbone_mapping_mode: typing.Union[int, str]
    """ Selects how the vertices are mapped to B-Bone segments based on their position

    :type: typing.Union[int, str]
    """

    bbone_rollin: float
    """ Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    """

    bbone_rollout: float
    """ Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    """

    bbone_scalein: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale factors for the start of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bbone_scaleout: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale factors for the end of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bbone_segments: int
    """ Number of subdivisions of bone (for B-Bones only)

    :type: int
    """

    bbone_x: float
    """ B-Bone X size

    :type: float
    """

    bbone_z: float
    """ B-Bone Z size

    :type: float
    """

    children: bpy_prop_collection["Bone"]
    """ Bones which are children of this bone

    :type: bpy_prop_collection['Bone']
    """

    collections: bpy_prop_collection["BoneCollection"]
    """ Bone Collections that contain this bone

    :type: bpy_prop_collection['BoneCollection']
    """

    color: "BoneColor"
    """ 

    :type: 'BoneColor'
    """

    envelope_distance: float
    """ Bone deformation distance (for Envelope deform only)

    :type: float
    """

    envelope_weight: float
    """ Bone deformation weight (for Envelope deform only)

    :type: float
    """

    head: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of head end of the bone relative to its parent

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    head_local: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of head end of the bone relative to armature

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    head_radius: float
    """ Radius of head of bone (for Envelope deform only)

    :type: float
    """

    hide: bool
    """ Bone is not visible when it is not in Edit Mode (i.e. in Object or Pose Modes)

    :type: bool
    """

    hide_select: bool
    """ Bone is able to be selected

    :type: bool
    """

    inherit_scale: typing.Union[int, str]
    """ Specifies how the bone inherits scaling from the parent bone

    :type: typing.Union[int, str]
    """

    length: float
    """ Length of the bone

    :type: float
    """

    matrix: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
        ],
    ]
    """ 3×3 bone matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]]]
    """

    matrix_local: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ 4×4 bone matrix relative to armature

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    parent: "Bone"
    """ Parent bone (in same Armature)

    :type: 'Bone'
    """

    select: bool
    """ 

    :type: bool
    """

    select_head: bool
    """ 

    :type: bool
    """

    select_tail: bool
    """ 

    :type: bool
    """

    show_wire: bool
    """ Bone is always displayed in wireframe regardless of viewport shading mode (useful for non-obstructive custom bone shapes)

    :type: bool
    """

    tail: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of tail end of the bone relative to its parent

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    tail_local: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of tail end of the bone relative to armature

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    tail_radius: float
    """ Radius of tail of bone (for Envelope deform only)

    :type: float
    """

    use_connect: typing.Union[bool, typing.Any]
    """ When bone has a parent, bone's head is stuck to the parent's tail

    :type: typing.Union[bool, typing.Any]
    """

    use_cyclic_offset: bool
    """ When bone doesn't have a parent, it receives cyclic offset effects (Deprecated)

    :type: bool
    """

    use_deform: bool
    """ Enable Bone to deform geometry

    :type: bool
    """

    use_endroll_as_inroll: bool
    """ Add Roll Out of the Start Handle bone to the Roll In value

    :type: bool
    """

    use_envelope_multiply: bool
    """ When deforming bone, multiply effects of Vertex Group weights with Envelope influence

    :type: bool
    """

    use_inherit_rotation: bool
    """ Bone inherits rotation or scale from parent bone

    :type: bool
    """

    use_local_location: bool
    """ Bone location is set in local space

    :type: bool
    """

    use_relative_parent: bool
    """ Object children will use relative transform, like deform

    :type: bool
    """

    use_scale_easing: bool
    """ Multiply the final easing values by the Scale In/Out Y factors

    :type: bool
    """

    basename: typing.Any
    """ The name of this bone before any '.' character(readonly)"""

    center: typing.Any
    """ The midpoint between the head and the tail.(readonly)"""

    children_recursive: typing.Any
    """ A list of all children from this bone.(readonly)"""

    children_recursive_basename: typing.Any
    """ Returns a chain of children with the same base name as this bone.
Only direct chains are supported, forks caused by multiple children
with matching base names will terminate the function
and not be returned.(readonly)"""

    parent_recursive: typing.Any
    """ A list of parents, starting with the immediate parent(readonly)"""

    vector: typing.Any
    """ The direction this bone is pointing.
Utility function for (tail - head)(readonly)"""

    x_axis: typing.Any
    """ Vector pointing down the x-axis of the bone.(readonly)"""

    y_axis: typing.Any
    """ Vector pointing down the y-axis of the bone.(readonly)"""

    z_axis: typing.Any
    """ Vector pointing down the z-axis of the bone.(readonly)"""

    def evaluate_envelope(
        self,
        point: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
    ) -> float:
        """Calculate bone envelope at given point

        :param point: Point, Position in 3d space to evaluate
        :type point: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
        :rtype: float
        :return: Factor, Envelope factor
        """
        ...

    def convert_local_to_pose(
        self,
        matrix: typing.Optional[
            typing.Union[
                "mathutils.Matrix",
                typing.List[typing.List[float]],
                typing.Tuple[
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                ],
            ]
        ],
        matrix_local: typing.Optional[
            typing.Union[
                "mathutils.Matrix",
                typing.List[typing.List[float]],
                typing.Tuple[
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                ],
            ]
        ],
        parent_matrix: typing.Optional[typing.Any] = (
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
        ),
        parent_matrix_local: typing.Optional[typing.Any] = (
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
        ),
        invert: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]:
        """Transform a matrix from Local to Pose space (or back), taking into account options like Inherit Scale and Local Location. Unlike Object.convert_space, this uses custom rest and pose matrices provided by the caller. If the parent matrices are omitted, the bone is assumed to have no parent.This method enables conversions between Local and Pose space for bones in
        the middle of updating the armature without having to update dependencies
        after each change, by manually carrying updated matrices in a recursive walk.

                :param matrix: The matrix to transform
                :type matrix: typing.Optional[typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]]
                :param matrix_local: The custom rest matrix of this bone (Bone.matrix_local)
                :type matrix_local: typing.Optional[typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]]
                :param parent_matrix: The custom pose matrix of the parent bone (PoseBone.matrix)
                :type parent_matrix: typing.Optional[typing.Any]
                :param parent_matrix_local: The custom rest matrix of the parent bone (Bone.matrix_local)
                :type parent_matrix_local: typing.Optional[typing.Any]
                :param invert: Convert from Pose to Local space
                :type invert: typing.Optional[typing.Union[bool, typing.Any]]
                :rtype: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
                :return: The transformed matrix
        """
        ...

    def MatrixFromAxisRoll(
        self, axis: typing.Any, roll: typing.Optional[float]
    ) -> typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
        ],
    ]:
        """Convert the axis + roll representation to a matrix

        :param axis: The main axis of the bone (tail - head)
        :type axis: typing.Any
        :param roll: The roll of the bone
        :type roll: typing.Optional[float]
        :rtype: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]]]
        :return: The resulting orientation matrix
        """
        ...

    def AxisRollFromMatrix(
        self, matrix: typing.Any, axis: typing.Optional[typing.Any] = (0.0, 0.0, 0.0)
    ):
        """Convert a rotational matrix to the axis + roll representation. Note that the resulting value of the roll may not be as expected if the matrix has shear or negative determinant.

                :param matrix: The orientation matrix of the bone
                :type matrix: typing.Any
                :param axis: The optional override for the axis (finds closest approximation for the matrix)
                :type axis: typing.Optional[typing.Any]
                :return: result_axis, The main axis of the bone, `mathutils.Vector` of 3 items in [-inf, inf]

        result_roll, The roll of the bone, float in [-inf, inf]
        """
        ...

    def parent_index(self, parent_test):
        """The same as 'bone in other_bone.parent_recursive'
        but saved generating a list.

                :param parent_test:
                :type parent_test:
        """
        ...

    def translate(self, vec):
        """Utility function to add vec to the head and tail of this bone

        :param vec:
        :type vec:
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoneCollection(bpy_struct):
    """Bone collection in an Armature data-block"""

    bones: bpy_prop_collection["Bone"]
    """ Bones assigned to this bone collection. In armature edit mode this will always return an empty list of bones, as the bone collection memberships are only synchronized when exiting edit mode

    :type: bpy_prop_collection['Bone']
    """

    child_number: int
    """ Index of this collection into its parent's list of children. Note that finding this index requires a scan of all the bone collections, so do access this with care

    :type: int
    """

    children: bpy_prop_collection["BoneCollection"]
    """ 

    :type: bpy_prop_collection['BoneCollection']
    """

    index: int
    """ Index of this bone collection in the armature.collections_all array. Note that finding this index requires a scan of all the bone collections, so do access this with care

    :type: int
    """

    is_editable: typing.Union[bool, typing.Any]
    """ This collection is owned by a local Armature, or was added via a library override in the current blend file

    :type: typing.Union[bool, typing.Any]
    """

    is_expanded: bool
    """ This bone collection is expanded in the bone collections tree view

    :type: bool
    """

    is_local_override: typing.Union[bool, typing.Any]
    """ This collection was added via a library override in the current blend file

    :type: typing.Union[bool, typing.Any]
    """

    is_solo: bool
    """ Show only this bone collection, and others also marked as 'solo'

    :type: bool
    """

    is_visible: bool
    """ Bones in this collection will be visible in pose/object mode

    :type: bool
    """

    is_visible_ancestors: typing.Union[bool, typing.Any]
    """ True when all of the ancestors of this bone collection are marked as visible; always True for root bone collections

    :type: typing.Union[bool, typing.Any]
    """

    is_visible_effectively: typing.Union[bool, typing.Any]
    """ Whether this bone collection is effectively visible in the viewport. This is True when this bone collection and all of its ancestors are visible, or when it is marked as 'solo'

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Unique within the Armature

    :type: typing.Union[str, typing.Any]
    """

    parent: "BoneCollection"
    """ Parent bone collection. Note that accessing this requires a scan of all the bone collections to find the parent

    :type: 'BoneCollection'
    """

    bones_recursive: typing.Any
    """ A set of all bones assigned to this bone collection and its child collections.(readonly)"""

    def assign(self, bone: typing.Optional[typing.Any]) -> bool:
        """Assign the given bone to this collection

        :param bone: Bone to assign to this collection. This must be a Bone, PoseBone, or EditBone
        :type bone: typing.Optional[typing.Any]
        :rtype: bool
        :return: Assigned, Whether the bone was actually assigned; will be false if the bone was already member of the collection
        """
        ...

    def unassign(self, bone: typing.Optional[typing.Any]) -> bool:
        """Remove the given bone from this collection

        :param bone: Bone to remove from this collection. This must be a Bone, PoseBone, or EditBone
        :type bone: typing.Optional[typing.Any]
        :rtype: bool
        :return: Unassigned, Whether the bone was actually removed; will be false if the bone was not a member of the collection to begin with
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoneCollectionMemberships(bpy_struct):
    """The Bone Collections that contain this Bone"""

    def clear(self):
        """Remove this bone from all bone collections"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoneCollections(bpy_struct):
    """The Bone Collections of this Armature"""

    active: "BoneCollection"
    """ Armature's active bone collection

    :type: 'BoneCollection'
    """

    active_index: int
    """ The index of the Armature's active bone collection; -1 when there is no active collection. Note that this is indexing the underlying array of bone collections, which may not be in the order you expect. Root collections are listed first, and siblings are always sequential. Apart from that, bone collections can be in any order, and thus incrementing or decrementing this index can make the active bone collection jump around in unexpected ways. For a more predictable interface, use active or active_name

    :type: int
    """

    active_name: typing.Union[str, typing.Any]
    """ The name of the Armature's active bone collection; empty when there is no active collection

    :type: typing.Union[str, typing.Any]
    """

    is_solo_active: typing.Union[bool, typing.Any]
    """ Read-only flag that indicates there is at least one bone collection marked as 'solo'

    :type: typing.Union[bool, typing.Any]
    """

    def new(
        self,
        name: typing.Union[str, typing.Any],
        parent: typing.Optional["BoneCollection"] = None,
    ) -> "BoneCollection":
        """Add a new empty bone collection to the armature

        :param name: Name, Name of the new collection. Blender will ensure it is unique within the collections of the Armature
        :type name: typing.Union[str, typing.Any]
        :param parent: Parent Collection, If not None, the new bone collection becomes a child of this collection
        :type parent: typing.Optional['BoneCollection']
        :rtype: 'BoneCollection'
        :return: Newly created bone collection
        """
        ...

    def remove(self, bone_collection: typing.Optional["BoneCollection"]):
        """Remove the bone collection from the armature. If this bone collection has any children, they will be reassigned to their grandparent; in other words, the children will take the place of the removed bone collection

        :param bone_collection: Bone Collection, The bone collection to remove
        :type bone_collection: typing.Optional['BoneCollection']
        """
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move a bone collection to a different position in the collection list. This can only be used to reorder siblings, and not to change parent-child relationships

        :param from_index: From Index, Index to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index
        :type to_index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoneColor(bpy_struct):
    """Theme color or custom color of a bone"""

    custom: "ThemeBoneColorSet"
    """ The custom bone colors, used when palette is 'CUSTOM'

    :type: 'ThemeBoneColorSet'
    """

    is_custom: typing.Union[bool, typing.Any]
    """ A color palette is user-defined, instead of using a theme-defined one

    :type: typing.Union[bool, typing.Any]
    """

    palette: typing.Union[int, str]
    """ Color palette to use

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoolAttributeValue(bpy_struct):
    """Bool value in geometry attribute"""

    value: bool
    """ 

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushCapabilities(bpy_struct):
    """Read-only indications of supported operations"""

    has_overlay: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_random_texture_angle: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_smooth_stroke: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_spacing: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushCapabilitiesImagePaint(bpy_struct):
    """Read-only indications of supported operations"""

    has_accumulate: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_color: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_radius: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_space_attenuation: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushCapabilitiesSculpt(bpy_struct):
    """Read-only indications of which brush operations are supported by the current sculpt tool"""

    has_accumulate: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_auto_smooth: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_color: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_direction: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_gravity: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_height: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_jitter: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_normal_weight: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_persistence: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_pinch_factor: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_plane_offset: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_rake_factor: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_random_texture_angle: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_sculpt_plane: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_secondary_color: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_smooth_stroke: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_space_attenuation: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_strength_pressure: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_tilt: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_topology_rake: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushCapabilitiesVertexPaint(bpy_struct):
    """Read-only indications of supported operations"""

    has_color: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushCapabilitiesWeightPaint(bpy_struct):
    """Read-only indications of supported operations"""

    has_weight: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushCurvesSculptSettings(bpy_struct):
    add_amount: int
    """ Number of curves added by the Add brush

    :type: int
    """

    curve_length: float
    """ Length of newly added curves when it is not interpolated from other curves

    :type: float
    """

    curve_parameter_falloff: "CurveMapping"
    """ Falloff that is applied from the tip to the root of each curve

    :type: 'CurveMapping'
    """

    curve_radius: float
    """ Radius of newly added curves when it is not interpolated from other curves

    :type: float
    """

    density_add_attempts: int
    """ How many times the Density brush tries to add a new curve

    :type: int
    """

    density_mode: typing.Union[int, str]
    """ Determines whether the brush adds or removes curves

    :type: typing.Union[int, str]
    """

    minimum_distance: float
    """ Goal distance between curve roots for the Density brush

    :type: float
    """

    minimum_length: float
    """ Avoid shrinking curves shorter than this length

    :type: float
    """

    points_per_curve: int
    """ Number of control points in a newly added curve

    :type: int
    """

    use_length_interpolate: bool
    """ Use length of the curves in close proximity

    :type: bool
    """

    use_point_count_interpolate: bool
    """ Use the number of points from the curves in close proximity

    :type: bool
    """

    use_radius_interpolate: bool
    """ Use radius of the curves in close proximity

    :type: bool
    """

    use_shape_interpolate: bool
    """ Use shape of the curves in close proximity

    :type: bool
    """

    use_uniform_scale: bool
    """ Grow or shrink curves by changing their size uniformly instead of using trimming or extrapolation

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushGpencilSettings(bpy_struct):
    """Settings for grease pencil brush"""

    active_smooth_factor: float
    """ Amount of smoothing while drawing

    :type: float
    """

    angle: float
    """ Direction of the stroke at which brush gives maximal thickness (0° for horizontal)

    :type: float
    """

    angle_factor: float
    """ Reduce brush thickness by this factor when stroke is perpendicular to 'Angle' direction

    :type: float
    """

    aspect: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    brush_draw_mode: typing.Union[int, str]
    """ Preselected mode when using this brush

    :type: typing.Union[int, str]
    """

    caps_type: typing.Union[int, str]
    """ The shape of the start and end of the stroke

    :type: typing.Union[int, str]
    """

    curve_jitter: "CurveMapping"
    """ Curve used for the jitter effect

    :type: 'CurveMapping'
    """

    curve_random_hue: "CurveMapping"
    """ Curve used for modulating effect

    :type: 'CurveMapping'
    """

    curve_random_pressure: "CurveMapping"
    """ Curve used for modulating effect

    :type: 'CurveMapping'
    """

    curve_random_saturation: "CurveMapping"
    """ Curve used for modulating effect

    :type: 'CurveMapping'
    """

    curve_random_strength: "CurveMapping"
    """ Curve used for modulating effect

    :type: 'CurveMapping'
    """

    curve_random_uv: "CurveMapping"
    """ Curve used for modulating effect

    :type: 'CurveMapping'
    """

    curve_random_value: "CurveMapping"
    """ Curve used for modulating effect

    :type: 'CurveMapping'
    """

    curve_sensitivity: "CurveMapping"
    """ Curve used for the sensitivity

    :type: 'CurveMapping'
    """

    curve_strength: "CurveMapping"
    """ Curve used for the strength

    :type: 'CurveMapping'
    """

    dilate: int
    """ Number of pixels to expand or contract fill area

    :type: int
    """

    eraser_mode: typing.Union[int, str]
    """ Eraser Mode

    :type: typing.Union[int, str]
    """

    eraser_strength_factor: float
    """ Amount of erasing for strength

    :type: float
    """

    eraser_thickness_factor: float
    """ Amount of erasing for thickness

    :type: float
    """

    extend_stroke_factor: float
    """ Strokes end extension for closing gaps, use zero to disable

    :type: float
    """

    fill_direction: typing.Union[int, str]
    """ Direction of the fill

    :type: typing.Union[int, str]
    """

    fill_draw_mode: typing.Union[int, str]
    """ Mode to draw boundary limits

    :type: typing.Union[int, str]
    """

    fill_extend_mode: typing.Union[int, str]
    """ Types of stroke extensions used for closing gaps

    :type: typing.Union[int, str]
    """

    fill_factor: float
    """ Factor for fill boundary accuracy, higher values are more accurate but slower

    :type: float
    """

    fill_layer_mode: typing.Union[int, str]
    """ Layers used as boundaries

    :type: typing.Union[int, str]
    """

    fill_simplify_level: int
    """ Number of simplify steps (large values reduce fill accuracy)

    :type: int
    """

    fill_threshold: float
    """ Threshold to consider color transparent for filling

    :type: float
    """

    gpencil_paint_icon: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    gpencil_sculpt_icon: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    gpencil_vertex_icon: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    gpencil_weight_icon: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    hardness: float
    """ Gradient from the center of Dot and Box strokes (set to 1 for a solid stroke)

    :type: float
    """

    input_samples: int
    """ Generate intermediate points for very fast mouse movements. Set to 0 to disable

    :type: int
    """

    material: "Material"
    """ Material used for strokes drawn using this brush

    :type: 'Material'
    """

    material_alt: "Material"
    """ Material used for secondary uses for this brush

    :type: 'Material'
    """

    outline_thickness_factor: float
    """ Thickness of the outline stroke relative to current brush thickness

    :type: float
    """

    pen_jitter: float
    """ Jitter factor for new strokes

    :type: float
    """

    pen_smooth_factor: float
    """ Amount of smoothing to apply after finish newly created strokes, to reduce jitter/noise

    :type: float
    """

    pen_smooth_steps: int
    """ Number of times to smooth newly created strokes

    :type: int
    """

    pen_strength: float
    """ Color strength for new strokes (affect alpha factor of color)

    :type: float
    """

    pen_subdivision_steps: int
    """ Number of times to subdivide newly created strokes, for less jagged strokes

    :type: int
    """

    pin_draw_mode: bool
    """ Pin the mode to the brush

    :type: bool
    """

    random_hue_factor: float
    """ Random factor to modify original hue

    :type: float
    """

    random_pressure: float
    """ Randomness factor for pressure in new strokes

    :type: float
    """

    random_saturation_factor: float
    """ Random factor to modify original saturation

    :type: float
    """

    random_strength: float
    """ Randomness factor strength in new strokes

    :type: float
    """

    random_value_factor: float
    """ Random factor to modify original value

    :type: float
    """

    show_fill: bool
    """ Show transparent lines to use as boundary for filling

    :type: bool
    """

    show_fill_boundary: bool
    """ Show help lines for filling to see boundaries

    :type: bool
    """

    show_fill_extend: bool
    """ Show help lines for stroke extension

    :type: bool
    """

    show_lasso: bool
    """ Do not display fill color while drawing the stroke

    :type: bool
    """

    simplify_factor: float
    """ Factor of Simplify using adaptive algorithm

    :type: float
    """

    use_active_layer_only: bool
    """ Only edit the active layer of the object

    :type: bool
    """

    use_collide_strokes: bool
    """ Check if extend lines collide with strokes

    :type: bool
    """

    use_default_eraser: bool
    """ Use this brush when enable eraser with fast switch key

    :type: bool
    """

    use_edit_position: bool
    """ The brush affects the position of the point

    :type: bool
    """

    use_edit_strength: bool
    """ The brush affects the color strength of the point

    :type: bool
    """

    use_edit_thickness: bool
    """ The brush affects the thickness of the point

    :type: bool
    """

    use_edit_uv: bool
    """ The brush affects the UV rotation of the point

    :type: bool
    """

    use_fill_limit: bool
    """ Fill only visible areas in viewport

    :type: bool
    """

    use_jitter_pressure: bool
    """ Use tablet pressure for jitter

    :type: bool
    """

    use_keep_caps_eraser: bool
    """ Keep the caps as they are and don't flatten them when erasing

    :type: bool
    """

    use_material_pin: bool
    """ Keep material assigned to brush

    :type: bool
    """

    use_occlude_eraser: bool
    """ Erase only strokes visible and not occluded

    :type: bool
    """

    use_pressure: bool
    """ Use tablet pressure

    :type: bool
    """

    use_random_press_hue: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_radius: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_sat: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_strength: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_uv: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_val: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_settings_outline: bool
    """ Convert stroke to perimeter

    :type: bool
    """

    use_settings_postprocess: bool
    """ Additional post processing options for new strokes

    :type: bool
    """

    use_settings_random: bool
    """ Random brush settings

    :type: bool
    """

    use_settings_stabilizer: bool
    """ Draw lines with a delay to allow smooth strokes. Press Shift key to override while drawing

    :type: bool
    """

    use_strength_pressure: bool
    """ Use tablet pressure for color strength

    :type: bool
    """

    use_stroke_random_hue: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_radius: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_sat: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_strength: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_uv: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_val: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_trim: bool
    """ Trim intersecting stroke ends

    :type: bool
    """

    uv_random: float
    """ Random factor for auto-generated UV rotation

    :type: float
    """

    vertex_color_factor: float
    """ Factor used to mix vertex color to get final color

    :type: float
    """

    vertex_mode: typing.Union[int, str]
    """ Defines how vertex color affect to the strokes

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ByteColorAttributeValue(bpy_struct):
    """Color value in geometry attribute"""

    color: bpy_prop_array[float]
    """ RGBA color in scene linear color space

    :type: bpy_prop_array[float]
    """

    color_srgb: bpy_prop_array[float]
    """ RGBA color in sRGB color space

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ByteIntAttributeValue(bpy_struct):
    """8-bit value in geometry attribute"""

    value: int
    """ 

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CacheFileLayer(bpy_struct):
    """Layer of the cache, used to load or override data from the first the first layer"""

    filepath: typing.Union[str, typing.Any]
    """ Path to the archive

    :type: typing.Union[str, typing.Any]
    """

    hide_layer: bool
    """ Do not load data from this layer

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CacheFileLayers(bpy_struct):
    """Collection of cache layers"""

    active: "CacheFileLayer"
    """ Active layer of the CacheFile

    :type: 'CacheFileLayer'
    """

    def new(self, filepath: typing.Union[str, typing.Any]) -> "CacheFileLayer":
        """Add a new layer

        :param filepath: File path to the archive used as a layer
        :type filepath: typing.Union[str, typing.Any]
        :rtype: 'CacheFileLayer'
        :return: Newly created layer
        """
        ...

    def remove(self, layer: "CacheFileLayer"):
        """Remove an existing layer from the cache file

        :param layer: Layer to remove
        :type layer: 'CacheFileLayer'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CacheObjectPath(bpy_struct):
    """Path of an object inside of an Alembic archive"""

    path: typing.Union[str, typing.Any]
    """ Object path

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CacheObjectPaths(bpy_struct):
    """Collection of object paths"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CameraBackgroundImage(bpy_struct):
    """Image and settings for display in the 3D View background"""

    alpha: float
    """ Image opacity to blend the image against the background color

    :type: float
    """

    clip: "MovieClip"
    """ Movie clip displayed and edited in this space

    :type: 'MovieClip'
    """

    clip_user: "MovieClipUser"
    """ Parameters defining which frame of the movie clip is displayed

    :type: 'MovieClipUser'
    """

    display_depth: typing.Union[int, str]
    """ Display under or over everything

    :type: typing.Union[int, str]
    """

    frame_method: typing.Union[int, str]
    """ How the image fits in the camera frame

    :type: typing.Union[int, str]
    """

    image: "Image"
    """ Image displayed and edited in this space

    :type: 'Image'
    """

    image_user: "ImageUser"
    """ Parameters defining which layer, pass and frame of the image is displayed

    :type: 'ImageUser'
    """

    is_override_data: typing.Union[bool, typing.Any]
    """ In a local override camera, whether this background image comes from the linked reference camera, or is local to the override

    :type: typing.Union[bool, typing.Any]
    """

    offset: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    rotation: float
    """ Rotation for the background image (ortho view only)

    :type: float
    """

    scale: float
    """ Scale the background image

    :type: float
    """

    show_background_image: bool
    """ Show this image as background

    :type: bool
    """

    show_expanded: bool
    """ Show the details in the user interface

    :type: bool
    """

    show_on_foreground: bool
    """ Show this image in front of objects in viewport

    :type: bool
    """

    source: typing.Union[int, str]
    """ Data source used for background

    :type: typing.Union[int, str]
    """

    use_camera_clip: bool
    """ Use movie clip from active scene camera

    :type: bool
    """

    use_flip_x: bool
    """ Flip the background image horizontally

    :type: bool
    """

    use_flip_y: bool
    """ Flip the background image vertically

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CameraBackgroundImages(bpy_struct):
    """Collection of background images"""

    def new(self) -> "CameraBackgroundImage":
        """Add new background image

        :rtype: 'CameraBackgroundImage'
        :return: Image displayed as viewport background
        """
        ...

    def remove(self, image: "CameraBackgroundImage"):
        """Remove background image

        :param image: Image displayed as viewport background
        :type image: 'CameraBackgroundImage'
        """
        ...

    def clear(self):
        """Remove all background images"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CameraDOFSettings(bpy_struct):
    """Depth of Field settings"""

    aperture_blades: int
    """ Number of blades in aperture for polygonal bokeh (at least 3)

    :type: int
    """

    aperture_fstop: float
    """ F-Stop ratio (lower numbers give more defocus, higher numbers give a sharper image)

    :type: float
    """

    aperture_ratio: float
    """ Distortion to simulate anamorphic lens bokeh

    :type: float
    """

    aperture_rotation: float
    """ Rotation of blades in aperture

    :type: float
    """

    focus_distance: float
    """ Distance to the focus point for depth of field

    :type: float
    """

    focus_object: "Object"
    """ Use this object to define the depth of field focal point

    :type: 'Object'
    """

    focus_subtarget: typing.Union[str, typing.Any]
    """ Use this armature bone to define the depth of field focal point

    :type: typing.Union[str, typing.Any]
    """

    use_dof: bool
    """ Use Depth of Field

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CameraStereoData(bpy_struct):
    """Stereoscopy settings for a Camera data-block"""

    convergence_distance: float
    """ The converge point for the stereo cameras (often the distance between a projector and the projection screen)

    :type: float
    """

    convergence_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    interocular_distance: float
    """ Set the distance between the eyes - the stereo plane distance / 30 should be fine

    :type: float
    """

    pivot: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    pole_merge_angle_from: float
    """ Angle at which interocular distance starts to fade to 0

    :type: float
    """

    pole_merge_angle_to: float
    """ Angle at which interocular distance is 0

    :type: float
    """

    use_pole_merge: bool
    """ Fade interocular distance to 0 after the given cutoff angle

    :type: bool
    """

    use_spherical_stereo: bool
    """ Render every pixel rotating the camera around the middle of the interocular distance

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ChannelDriverVariables(bpy_struct):
    """Collection of channel driver Variables"""

    def new(self) -> "DriverVariable":
        """Add a new variable for the driver

        :rtype: 'DriverVariable'
        :return: Newly created Driver Variable
        """
        ...

    def remove(self, variable: "DriverVariable"):
        """Remove an existing variable from the driver

        :param variable: Variable to remove from the driver
        :type variable: 'DriverVariable'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ChildParticle(bpy_struct):
    """Child particle interpolated from simulated or edited particles"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ClothCollisionSettings(bpy_struct):
    """Cloth simulation settings for self collision and collision with other objects"""

    collection: "Collection"
    """ Limit colliders to this Collection

    :type: 'Collection'
    """

    collision_quality: int
    """ How many collision iterations should be done. (higher is better quality but slower)

    :type: int
    """

    damping: float
    """ Amount of velocity lost on collision

    :type: float
    """

    distance_min: float
    """ Minimum distance between collision objects before collision response takes effect

    :type: float
    """

    friction: float
    """ Friction force if a collision happened (higher = less movement)

    :type: float
    """

    impulse_clamp: float
    """ Clamp collision impulses to avoid instability (0.0 to disable clamping)

    :type: float
    """

    self_distance_min: float
    """ Minimum distance between cloth faces before collision response takes effect

    :type: float
    """

    self_friction: float
    """ Friction with self contact

    :type: float
    """

    self_impulse_clamp: float
    """ Clamp collision impulses to avoid instability (0.0 to disable clamping)

    :type: float
    """

    use_collision: bool
    """ Enable collisions with other objects

    :type: bool
    """

    use_self_collision: bool
    """ Enable self collisions

    :type: bool
    """

    vertex_group_object_collisions: typing.Union[str, typing.Any]
    """ Triangles with all vertices in this group are not used during object collisions

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_self_collisions: typing.Union[str, typing.Any]
    """ Triangles with all vertices in this group are not used during self collisions

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ClothSettings(bpy_struct):
    """Cloth simulation settings for an object"""

    air_damping: float
    """ Air has normally some thickness which slows falling things down

    :type: float
    """

    bending_damping: float
    """ Amount of damping in bending behavior

    :type: float
    """

    bending_model: typing.Union[int, str]
    """ Physical model for simulating bending forces

    :type: typing.Union[int, str]
    """

    bending_stiffness: float
    """ How much the material resists bending

    :type: float
    """

    bending_stiffness_max: float
    """ Maximum bending stiffness value

    :type: float
    """

    collider_friction: float
    """ 

    :type: float
    """

    compression_damping: float
    """ Amount of damping in compression behavior

    :type: float
    """

    compression_stiffness: float
    """ How much the material resists compression

    :type: float
    """

    compression_stiffness_max: float
    """ Maximum compression stiffness value

    :type: float
    """

    density_strength: float
    """ Influence of target density on the simulation

    :type: float
    """

    density_target: float
    """ Maximum density of hair

    :type: float
    """

    effector_weights: "EffectorWeights"
    """ 

    :type: 'EffectorWeights'
    """

    fluid_density: float
    """ Density (kg/l) of the fluid contained inside the object, used to create a hydrostatic pressure gradient simulating the weight of the internal fluid, or buoyancy from the surrounding fluid if negative

    :type: float
    """

    goal_default: float
    """ Default Goal (vertex target position) value, when no Vertex Group used

    :type: float
    """

    goal_friction: float
    """ Goal (vertex target position) friction

    :type: float
    """

    goal_max: float
    """ Goal maximum, vertex group weights are scaled to match this range

    :type: float
    """

    goal_min: float
    """ Goal minimum, vertex group weights are scaled to match this range

    :type: float
    """

    goal_spring: float
    """ Goal (vertex target position) spring stiffness

    :type: float
    """

    gravity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Gravity or external force vector

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    internal_compression_stiffness: float
    """ How much the material resists compression

    :type: float
    """

    internal_compression_stiffness_max: float
    """ Maximum compression stiffness value

    :type: float
    """

    internal_friction: float
    """ 

    :type: float
    """

    internal_spring_max_diversion: float
    """ How much the rays used to connect the internal points can diverge from the vertex normal

    :type: float
    """

    internal_spring_max_length: float
    """ The maximum length an internal spring can have during creation. If the distance between internal points is greater than this, no internal spring will be created between these points. A length of zero means that there is no length limit

    :type: float
    """

    internal_spring_normal_check: bool
    """ Require the points the internal springs connect to have opposite normal directions

    :type: bool
    """

    internal_tension_stiffness: float
    """ How much the material resists stretching

    :type: float
    """

    internal_tension_stiffness_max: float
    """ Maximum tension stiffness value

    :type: float
    """

    mass: float
    """ The mass of each vertex on the cloth material

    :type: float
    """

    pin_stiffness: float
    """ Pin (vertex target position) spring stiffness

    :type: float
    """

    pressure_factor: float
    """ Ambient pressure (kPa) that balances out between the inside and outside of the object when it has the target volume

    :type: float
    """

    quality: int
    """ Quality of the simulation in steps per frame (higher is better quality but slower)

    :type: int
    """

    rest_shape_key: "ShapeKey"
    """ Shape key to use the rest spring lengths from

    :type: 'ShapeKey'
    """

    sewing_force_max: float
    """ Maximum sewing force

    :type: float
    """

    shear_damping: float
    """ Amount of damping in shearing behavior

    :type: float
    """

    shear_stiffness: float
    """ How much the material resists shearing

    :type: float
    """

    shear_stiffness_max: float
    """ Maximum shear scaling value

    :type: float
    """

    shrink_max: float
    """ Max amount to shrink cloth by

    :type: float
    """

    shrink_min: float
    """ Factor by which to shrink cloth

    :type: float
    """

    target_volume: float
    """ The mesh volume where the inner/outer pressure will be the same. If set to zero the change in volume will not affect pressure

    :type: float
    """

    tension_damping: float
    """ Amount of damping in stretching behavior

    :type: float
    """

    tension_stiffness: float
    """ How much the material resists stretching

    :type: float
    """

    tension_stiffness_max: float
    """ Maximum tension stiffness value

    :type: float
    """

    time_scale: float
    """ Cloth speed is multiplied by this value

    :type: float
    """

    uniform_pressure_force: float
    """ The uniform pressure that is constantly applied to the mesh, in units of Pressure Scale. Can be negative

    :type: float
    """

    use_dynamic_mesh: bool
    """ Make simulation respect deformations in the base mesh

    :type: bool
    """

    use_internal_springs: bool
    """ Simulate an internal volume structure by creating springs connecting the opposite sides of the mesh

    :type: bool
    """

    use_pressure: bool
    """ Simulate pressure inside a closed cloth mesh

    :type: bool
    """

    use_pressure_volume: bool
    """ Use the Target Volume parameter as the initial volume, instead of calculating it from the mesh itself

    :type: bool
    """

    use_sewing_springs: bool
    """ Pulls loose edges together

    :type: bool
    """

    vertex_group_bending: typing.Union[str, typing.Any]
    """ Vertex group for fine control over bending stiffness

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_intern: typing.Union[str, typing.Any]
    """ Vertex group for fine control over the internal spring stiffness

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_mass: typing.Union[str, typing.Any]
    """ Vertex Group for pinning of vertices

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_pressure: typing.Union[str, typing.Any]
    """ Vertex Group for where to apply pressure. Zero weight means no pressure while a weight of one means full pressure. Faces with a vertex that has zero weight will be excluded from the volume calculation

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_shear_stiffness: typing.Union[str, typing.Any]
    """ Vertex group for fine control over shear stiffness

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_shrink: typing.Union[str, typing.Any]
    """ Vertex Group for shrinking cloth

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_structural_stiffness: typing.Union[str, typing.Any]
    """ Vertex group for fine control over structural stiffness

    :type: typing.Union[str, typing.Any]
    """

    voxel_cell_size: float
    """ Size of the voxel grid cells for interaction effects

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ClothSolverResult(bpy_struct):
    """Result of cloth solver iteration"""

    avg_error: float
    """ Average error during substeps

    :type: float
    """

    avg_iterations: float
    """ Average iterations during substeps

    :type: float
    """

    max_error: float
    """ Maximum error during substeps

    :type: float
    """

    max_iterations: int
    """ Maximum iterations during substeps

    :type: int
    """

    min_error: float
    """ Minimum error during substeps

    :type: float
    """

    min_iterations: int
    """ Minimum iterations during substeps

    :type: int
    """

    status: typing.Any
    """ Status of the solver iteration

    :type: typing.Any
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CollectionChild(bpy_struct):
    """Child collection with its collection related settings"""

    light_linking: "CollectionLightLinking"
    """ Light linking settings of the collection object

    :type: 'CollectionLightLinking'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CollectionChildren(bpy_struct):
    """Collection of child collections"""

    def link(self, child: "Collection"):
        """Add this collection as child of this collection

        :param child: Collection to add
        :type child: 'Collection'
        """
        ...

    def unlink(self, child: typing.Optional["Collection"]):
        """Remove this child collection from a collection

        :param child: Collection to remove
        :type child: typing.Optional['Collection']
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CollectionLightLinking(bpy_struct):
    """Light linking settings of objects and children collections of a collection"""

    link_state: typing.Union[int, str]
    """ Light or shadow receiving state of the object or collection

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CollectionObject(bpy_struct):
    """Object of a collection with its collection related settings"""

    light_linking: "CollectionLightLinking"
    """ Light linking settings of the collection

    :type: 'CollectionLightLinking'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CollectionObjects(bpy_struct):
    """Collection of collection objects"""

    def link(self, object: "Object"):
        """Add this object to a collection

        :param object: Object to add
        :type object: 'Object'
        """
        ...

    def unlink(self, object: typing.Optional["Object"]):
        """Remove this object from a collection

        :param object: Object to remove
        :type object: typing.Optional['Object']
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CollisionSettings(bpy_struct):
    """Collision settings for object in physics simulation"""

    absorption: float
    """ How much of effector force gets lost during collision with this object (in percent)

    :type: float
    """

    cloth_friction: float
    """ Friction for cloth collisions

    :type: float
    """

    damping: float
    """ Amount of damping during collision

    :type: float
    """

    damping_factor: float
    """ Amount of damping during particle collision

    :type: float
    """

    damping_random: float
    """ Random variation of damping

    :type: float
    """

    friction_factor: float
    """ Amount of friction during particle collision

    :type: float
    """

    friction_random: float
    """ Random variation of friction

    :type: float
    """

    permeability: float
    """ Chance that the particle will pass through the mesh

    :type: float
    """

    stickiness: float
    """ Amount of stickiness to surface collision

    :type: float
    """

    thickness_inner: float
    """ Inner face thickness (only used by softbodies)

    :type: float
    """

    thickness_outer: float
    """ Outer face thickness

    :type: float
    """

    use: bool
    """ Enable this object as a collider for physics systems

    :type: bool
    """

    use_culling: bool
    """ Cloth collision acts with respect to the collider normals (improves penetration recovery)

    :type: bool
    """

    use_normal: bool
    """ Cloth collision impulses act in the direction of the collider normals (more reliable in some cases)

    :type: bool
    """

    use_particle_kill: bool
    """ Kill collided particles

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorManagedDisplaySettings(bpy_struct):
    """Color management specific to display device"""

    display_device: typing.Union[int, str]
    """ Display device name

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorManagedInputColorspaceSettings(bpy_struct):
    """Input color space settings"""

    is_data: bool
    """ Treat image as non-color data without color management, like normal or displacement maps

    :type: bool
    """

    name: typing.Union[int, str]
    """ Color space in the image file, to convert to and from when saving and loading the image

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorManagedSequencerColorspaceSettings(bpy_struct):
    """Input color space settings"""

    name: typing.Union[int, str]
    """ Color space that the sequencer operates in

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorManagedViewSettings(bpy_struct):
    """Color management settings used for displaying images on the display"""

    curve_mapping: "CurveMapping"
    """ Color curve mapping applied before display transform

    :type: 'CurveMapping'
    """

    exposure: float
    """ Exposure (stops) applied before display transform

    :type: float
    """

    gamma: float
    """ Amount of gamma modification applied after display transform

    :type: float
    """

    look: typing.Union[int, str]
    """ Additional transform applied before view transform for artistic needs

    :type: typing.Union[int, str]
    """

    use_curve_mapping: bool
    """ Use RGB curved for pre-display transformation

    :type: bool
    """

    use_hdr_view: bool
    """ Enable high dynamic range display in rendered viewport, uncapping display brightness. This requires a monitor with HDR support and a view transform designed for HDR. 'Filmic' and 'AgX' do not generate HDR colors

    :type: bool
    """

    view_transform: typing.Union[int, str]
    """ View used when converting image to a display space

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorMapping(bpy_struct):
    """Color mapping settings"""

    blend_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Blend color to mix with texture output color

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    blend_factor: float
    """ 

    :type: float
    """

    blend_type: typing.Union[int, str]
    """ Mode used to mix with texture output color

    :type: typing.Union[int, str]
    """

    brightness: float
    """ Adjust the brightness of the texture

    :type: float
    """

    color_ramp: "ColorRamp"
    """ 

    :type: 'ColorRamp'
    """

    contrast: float
    """ Adjust the contrast of the texture

    :type: float
    """

    saturation: float
    """ Adjust the saturation of colors in the texture

    :type: float
    """

    use_color_ramp: bool
    """ Toggle color ramp operations

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorRamp(bpy_struct):
    """Color ramp mapping a scalar value to a color"""

    color_mode: typing.Union[int, str]
    """ Set color mode to use for interpolation

    :type: typing.Union[int, str]
    """

    elements: bpy_prop_collection["ColorRampElement"]
    """ 

    :type: bpy_prop_collection['ColorRampElement']
    """

    hue_interpolation: typing.Union[int, str]
    """ Set color interpolation

    :type: typing.Union[int, str]
    """

    interpolation: typing.Union[int, str]
    """ Set interpolation between color stops

    :type: typing.Union[int, str]
    """

    def evaluate(self, position: typing.Optional[float]) -> bpy_prop_array[float]:
        """Evaluate Color Ramp

        :param position: Position, Evaluate Color Ramp at position
        :type position: typing.Optional[float]
        :rtype: bpy_prop_array[float]
        :return: Color, Color at given position
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorRampElement(bpy_struct):
    """Element defining a color at a position in the color ramp"""

    alpha: float
    """ Set alpha of selected color stop

    :type: float
    """

    color: bpy_prop_array[float]
    """ Set color of selected color stop

    :type: bpy_prop_array[float]
    """

    position: float
    """ Set position of selected color stop

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorRampElements(bpy_struct):
    """Collection of Color Ramp Elements"""

    def new(self, position: typing.Optional[float]) -> "ColorRampElement":
        """Add element to Color Ramp

        :param position: Position, Position to add element
        :type position: typing.Optional[float]
        :rtype: 'ColorRampElement'
        :return: New element
        """
        ...

    def remove(self, element: "ColorRampElement"):
        """Delete element from Color Ramp

        :param element: Element to remove
        :type element: 'ColorRampElement'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CompositorNodeOutputFileFileSlots(bpy_struct):
    """Collection of File Output node slots"""

    def new(self, name: typing.Union[str, typing.Any]) -> "NodeSocket":
        """Add a file slot to this node

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'NodeSocket'
        :return: New socket
        """
        ...

    def remove(self, socket: typing.Optional["NodeSocket"]):
        """Remove a file slot from this node

        :param socket: The socket to remove
        :type socket: typing.Optional['NodeSocket']
        """
        ...

    def clear(self):
        """Remove all file slots from this node"""
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move a file slot to another position

        :param from_index: From Index, Index of the socket to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index for the socket
        :type to_index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CompositorNodeOutputFileLayerSlots(bpy_struct):
    """Collection of File Output node slots"""

    def new(self, name: typing.Union[str, typing.Any]) -> "NodeSocket":
        """Add a file slot to this node

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'NodeSocket'
        :return: New socket
        """
        ...

    def remove(self, socket: typing.Optional["NodeSocket"]):
        """Remove a file slot from this node

        :param socket: The socket to remove
        :type socket: typing.Optional['NodeSocket']
        """
        ...

    def clear(self):
        """Remove all file slots from this node"""
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move a file slot to another position

        :param from_index: From Index, Index of the socket to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index for the socket
        :type to_index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ConsoleLine(bpy_struct):
    """Input line for the interactive console"""

    body: typing.Union[str, typing.Any]
    """ Text in the line

    :type: typing.Union[str, typing.Any]
    """

    current_character: int
    """ 

    :type: int
    """

    type: typing.Union[int, str]
    """ Console line type when used in scrollback

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Constraint(bpy_struct):
    """Constraint modifying the transformation of objects and bones"""

    active: bool
    """ Constraint is the one being edited

    :type: bool
    """

    enabled: bool
    """ Use the results of this constraint

    :type: bool
    """

    error_location: float
    """ Amount of residual error in Blender space unit for constraints that work on position

    :type: float
    """

    error_rotation: float
    """ Amount of residual error in radians for constraints that work on orientation

    :type: float
    """

    influence: float
    """ Amount of influence constraint will have on the final solution

    :type: float
    """

    is_override_data: typing.Union[bool, typing.Any]
    """ In a local override object, whether this constraint comes from the linked reference object, or is local to the override

    :type: typing.Union[bool, typing.Any]
    """

    is_valid: typing.Union[bool, typing.Any]
    """ Constraint has valid settings and can be evaluated

    :type: typing.Union[bool, typing.Any]
    """

    mute: bool
    """ Enable/Disable Constraint

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Constraint name

    :type: typing.Union[str, typing.Any]
    """

    owner_space: typing.Union[int, str]
    """ Space that owner is evaluated in

    :type: typing.Union[int, str]
    """

    show_expanded: bool
    """ Constraint's panel is expanded in UI

    :type: bool
    """

    space_object: "Object"
    """ Object for Custom Space

    :type: 'Object'
    """

    space_subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target_space: typing.Union[int, str]
    """ Space that target is evaluated in

    :type: typing.Union[int, str]
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ConstraintTarget(bpy_struct):
    """Target object for multi-target constraints"""

    subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target: "Object"
    """ Target object

    :type: 'Object'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ConstraintTargetBone(bpy_struct):
    """Target bone for multi-target constraints"""

    subtarget: typing.Union[str, typing.Any]
    """ Target armature bone

    :type: typing.Union[str, typing.Any]
    """

    target: "Object"
    """ Target armature

    :type: 'Object'
    """

    weight: float
    """ Blending weight of this bone

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Context(bpy_struct):
    """Current windowmanager and data context"""

    area: "Area"
    """ 

    :type: 'Area'
    """

    asset: "AssetRepresentation"
    """ 

    :type: 'AssetRepresentation'
    """

    blend_data: "BlendData"
    """ 

    :type: 'BlendData'
    """

    collection: "Collection"
    """ 

    :type: 'Collection'
    """

    engine: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    gizmo_group: "GizmoGroup"
    """ 

    :type: 'GizmoGroup'
    """

    layer_collection: "LayerCollection"
    """ 

    :type: 'LayerCollection'
    """

    mode: typing.Any
    """ 

    :type: typing.Any
    """

    preferences: "Preferences"
    """ 

    :type: 'Preferences'
    """

    region: "Region"
    """ 

    :type: 'Region'
    """

    region_data: "RegionView3D"
    """ 

    :type: 'RegionView3D'
    """

    scene: "Scene"
    """ 

    :type: 'Scene'
    """

    screen: "Screen"
    """ 

    :type: 'Screen'
    """

    space_data: "Space"
    """ The current space, may be None in background-mode, when the cursor is outside the window or when using menu-search

    :type: 'Space'
    """

    tool_settings: "ToolSettings"
    """ 

    :type: 'ToolSettings'
    """

    view_layer: "ViewLayer"
    """ 

    :type: 'ViewLayer'
    """

    window: "Window"
    """ 

    :type: 'Window'
    """

    window_manager: "WindowManager"
    """ 

    :type: 'WindowManager'
    """

    workspace: "WorkSpace"
    """ 

    :type: 'WorkSpace'
    """

    texture_slot: "TextureSlot"
    """ 

    :type: 'TextureSlot'
    """

    world: "World"
    """ 

    :type: 'World'
    """

    object: "Object"
    """ 

    :type: 'Object'
    """

    mesh: "Mesh"
    """ 

    :type: 'Mesh'
    """

    armature: "Armature"
    """ 

    :type: 'Armature'
    """

    lattice: "Lattice"
    """ 

    :type: 'Lattice'
    """

    curve: "Curve"
    """ 

    :type: 'Curve'
    """

    meta_ball: "MetaBall"
    """ 

    :type: 'MetaBall'
    """

    light: "Light"
    """ 

    :type: 'Light'
    """

    speaker: "Speaker"
    """ 

    :type: 'Speaker'
    """

    lightprobe: "LightProbe"
    """ 

    :type: 'LightProbe'
    """

    camera: "Camera"
    """ 

    :type: 'Camera'
    """

    material: "Material"
    """ 

    :type: 'Material'
    """

    material_slot: "MaterialSlot"
    """ 

    :type: 'MaterialSlot'
    """

    texture: "Texture"
    """ 

    :type: 'Texture'
    """

    texture_user: "ID"
    """ 

    :type: 'ID'
    """

    texture_user_property: "Property"
    """ 

    :type: 'Property'
    """

    texture_node: "Node"
    """ 

    :type: 'Node'
    """

    bone: "Bone"
    """ 

    :type: 'Bone'
    """

    edit_bone: "EditBone"
    """ 

    :type: 'EditBone'
    """

    pose_bone: "PoseBone"
    """ 

    :type: 'PoseBone'
    """

    particle_system: "ParticleSystem"
    """ 

    :type: 'ParticleSystem'
    """

    particle_system_editable: "ParticleSystem"
    """ 

    :type: 'ParticleSystem'
    """

    particle_settings: "ParticleSettings"
    """ 

    :type: 'ParticleSettings'
    """

    cloth: "ClothModifier"
    """ 

    :type: 'ClothModifier'
    """

    soft_body: "SoftBodyModifier"
    """ 

    :type: 'SoftBodyModifier'
    """

    fluid: typing.Any
    """ 

    :type: typing.Any
    """

    collision: "CollisionModifier"
    """ 

    :type: 'CollisionModifier'
    """

    brush: "Brush"
    """ 

    :type: 'Brush'
    """

    dynamic_paint: "DynamicPaintModifier"
    """ 

    :type: 'DynamicPaintModifier'
    """

    line_style: "FreestyleLineStyle"
    """ 

    :type: 'FreestyleLineStyle'
    """

    gpencil: "GreasePencil"
    """ 

    :type: 'GreasePencil'
    """

    grease_pencil: "GreasePencilv3"
    """ 

    :type: 'GreasePencilv3'
    """

    curves: "Curves"
    """ 

    :type: 'Curves'
    """

    pointcloud: "PointCloud"
    """ 

    :type: 'PointCloud'
    """

    volume: "Volume"
    """ 

    :type: 'Volume'
    """

    edit_movieclip: "MovieClip"
    """ 

    :type: 'MovieClip'
    """

    edit_mask: "Mask"
    """ 

    :type: 'Mask'
    """

    active_file: "FileSelectEntry"
    """ 

    :type: 'FileSelectEntry'
    """

    selected_files: typing.List["FileSelectEntry"]
    """ 

    :type: typing.List['FileSelectEntry']
    """

    asset_library_reference: "AssetLibraryReference"
    """ 

    :type: 'AssetLibraryReference'
    """

    selected_assets: typing.List["AssetRepresentation"]
    """ 

    :type: typing.List['AssetRepresentation']
    """

    id: "ID"
    """ 

    :type: 'ID'
    """

    selected_ids: typing.List["ID"]
    """ 

    :type: typing.List['ID']
    """

    edit_image: "Image"
    """ 

    :type: 'Image'
    """

    selected_nodes: typing.List["Node"]
    """ 

    :type: typing.List['Node']
    """

    active_node: "Node"
    """ 

    :type: 'Node'
    """

    visible_objects: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    selectable_objects: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    selected_objects: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    editable_objects: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    selected_editable_objects: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    objects_in_mode: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    objects_in_mode_unique_data: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    visible_bones: typing.List["EditBone"]
    """ 

    :type: typing.List['EditBone']
    """

    editable_bones: typing.List["EditBone"]
    """ 

    :type: typing.List['EditBone']
    """

    selected_bones: typing.List["EditBone"]
    """ 

    :type: typing.List['EditBone']
    """

    selected_editable_bones: typing.List["EditBone"]
    """ 

    :type: typing.List['EditBone']
    """

    visible_pose_bones: typing.List["PoseBone"]
    """ 

    :type: typing.List['PoseBone']
    """

    selected_pose_bones: typing.List["PoseBone"]
    """ 

    :type: typing.List['PoseBone']
    """

    selected_pose_bones_from_active_object: typing.List["PoseBone"]
    """ 

    :type: typing.List['PoseBone']
    """

    active_bone: "EditBone"
    """ 

    :type: 'EditBone'
    """

    active_pose_bone: "PoseBone"
    """ 

    :type: 'PoseBone'
    """

    active_object: "Object"
    """ 

    :type: 'Object'
    """

    edit_object: "Object"
    """ 

    :type: 'Object'
    """

    sculpt_object: "Object"
    """ 

    :type: 'Object'
    """

    vertex_paint_object: "Object"
    """ 

    :type: 'Object'
    """

    weight_paint_object: "Object"
    """ 

    :type: 'Object'
    """

    image_paint_object: "Object"
    """ 

    :type: 'Object'
    """

    particle_edit_object: "Object"
    """ 

    :type: 'Object'
    """

    pose_object: "Object"
    """ 

    :type: 'Object'
    """

    active_sequence_strip: "Sequence"
    """ 

    :type: 'Sequence'
    """

    sequences: typing.List["Sequence"]
    """ 

    :type: typing.List['Sequence']
    """

    selected_sequences: typing.List["Sequence"]
    """ 

    :type: typing.List['Sequence']
    """

    selected_editable_sequences: typing.List["Sequence"]
    """ 

    :type: typing.List['Sequence']
    """

    active_nla_track: "NlaTrack"
    """ 

    :type: 'NlaTrack'
    """

    active_nla_strip: "NlaStrip"
    """ 

    :type: 'NlaStrip'
    """

    selected_nla_strips: typing.List["NlaStrip"]
    """ 

    :type: typing.List['NlaStrip']
    """

    selected_movieclip_tracks: typing.List["MovieTrackingTrack"]
    """ 

    :type: typing.List['MovieTrackingTrack']
    """

    gpencil_data: "GreasePencil"
    """ 

    :type: 'GreasePencil'
    """

    gpencil_data_owner: "ID"
    """ 

    :type: 'ID'
    """

    annotation_data: "GreasePencil"
    """ 

    :type: 'GreasePencil'
    """

    annotation_data_owner: "ID"
    """ 

    :type: 'ID'
    """

    visible_gpencil_layers: typing.List["GPencilLayer"]
    """ 

    :type: typing.List['GPencilLayer']
    """

    editable_gpencil_layers: typing.List["GPencilLayer"]
    """ 

    :type: typing.List['GPencilLayer']
    """

    editable_gpencil_strokes: typing.List["GPencilStroke"]
    """ 

    :type: typing.List['GPencilStroke']
    """

    active_gpencil_layer: typing.List["GPencilLayer"]
    """ 

    :type: typing.List['GPencilLayer']
    """

    active_gpencil_frame: typing.List["GreasePencilLayer"]
    """ 

    :type: typing.List['GreasePencilLayer']
    """

    active_annotation_layer: "GPencilLayer"
    """ 

    :type: 'GPencilLayer'
    """

    active_operator: "Operator"
    """ 

    :type: 'Operator'
    """

    active_action: "Action"
    """ 

    :type: 'Action'
    """

    selected_visible_actions: typing.List["Action"]
    """ 

    :type: typing.List['Action']
    """

    selected_editable_actions: typing.List["Action"]
    """ 

    :type: typing.List['Action']
    """

    visible_fcurves: typing.List["FCurve"]
    """ 

    :type: typing.List['FCurve']
    """

    editable_fcurves: typing.List["FCurve"]
    """ 

    :type: typing.List['FCurve']
    """

    selected_visible_fcurves: typing.List["FCurve"]
    """ 

    :type: typing.List['FCurve']
    """

    selected_editable_fcurves: typing.List["FCurve"]
    """ 

    :type: typing.List['FCurve']
    """

    active_editable_fcurve: "FCurve"
    """ 

    :type: 'FCurve'
    """

    selected_editable_keyframes: typing.List["Keyframe"]
    """ 

    :type: typing.List['Keyframe']
    """

    ui_list: "UIList"
    """ 

    :type: 'UIList'
    """

    property: typing.Union["AnyType", int, str]
    """ Get the property associated with a hovered button.
Returns a tuple of the data-block, data path to the property, and array index.

    :type: typing.Union['AnyType', int, str]
    """

    edit_text: "Text"
    """ 

    :type: 'Text'
    """

    def evaluated_depsgraph_get(self) -> "Depsgraph":
        """Get the dependency graph for the current scene and view layer, to access to data-blocks with animation and modifiers applied. If any data-blocks have been edited, the dependency graph will be updated. This invalidates all references to evaluated data-blocks from the dependency graph.

        :rtype: 'Depsgraph'
        :return: Evaluated dependency graph
        """
        ...

    def copy(self): ...
    def path_resolve(
        self, path: typing.Optional[str], coerce: typing.Optional[bool] = True
    ):
        """Returns the property from the path, raise an exception when not found.

        :param path: patch which this property resolves.
        :type path: typing.Optional[str]
        :param coerce: optional argument, when True, the property will be converted into its Python representation.
        :type coerce: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

    def temp_override(
        self,
        window: typing.Optional["Window"],
        area: typing.Optional["Area"],
        region: typing.Optional["Region"],
        **keywords,
    ) -> "bpy.context":
        """Context manager to temporarily override members in the context.Overriding the context can be used to temporarily activate another window / area & region,
        as well as other members such as the active_object or bone.Notes:Overriding the context can be useful to set the context after loading files
        (which would otherwise by None). For example:This example shows how it's possible to add an object to the scene in another window.

                :param window: Window override or None.
                :type window: typing.Optional['Window']
                :param area: Area override or None.
                :type area: typing.Optional['Area']
                :param region: Region override or None.
                :type region: typing.Optional['Region']
                :param **keywords: Additional keywords override context members.
                :type **keywords:
                :rtype: 'bpy.context'
                :return: The context manager .
        """
        ...

class CryptomatteEntry(bpy_struct):
    encoded_hash: float
    """ 

    :type: float
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveMap(bpy_struct):
    """Curve in a curve mapping"""

    points: bpy_prop_collection["CurveMapPoint"]
    """ 

    :type: bpy_prop_collection['CurveMapPoint']
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveMapPoint(bpy_struct):
    """Point of a curve used for a curve mapping"""

    handle_type: typing.Union[int, str]
    """ Curve interpolation at this point: Bézier or vector

    :type: typing.Union[int, str]
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ X/Y coordinates of the curve point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    select: bool
    """ Selection state of the curve point

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveMapPoints(bpy_struct):
    """Collection of Curve Map Points"""

    def new(
        self, position: typing.Optional[float], value: typing.Optional[float]
    ) -> "CurveMapPoint":
        """Add point to CurveMap

        :param position: Position, Position to add point
        :type position: typing.Optional[float]
        :param value: Value, Value of point
        :type value: typing.Optional[float]
        :rtype: 'CurveMapPoint'
        :return: New point
        """
        ...

    def remove(self, point: "CurveMapPoint"):
        """Delete point from CurveMap

        :param point: PointElement to remove
        :type point: 'CurveMapPoint'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveMapping(bpy_struct):
    """Curve mapping to map color, vector and scalar values to other values using a user defined curve"""

    black_level: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ For RGB curves, the color that black is mapped to

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    clip_max_x: float
    """ 

    :type: float
    """

    clip_max_y: float
    """ 

    :type: float
    """

    clip_min_x: float
    """ 

    :type: float
    """

    clip_min_y: float
    """ 

    :type: float
    """

    curves: bpy_prop_collection["CurveMap"]
    """ 

    :type: bpy_prop_collection['CurveMap']
    """

    extend: typing.Union[int, str]
    """ Extrapolate the curve or extend it horizontally

    :type: typing.Union[int, str]
    """

    tone: typing.Union[int, str]
    """ Tone of the curve

    :type: typing.Union[int, str]
    """

    use_clip: bool
    """ Force the curve view to fit a defined boundary

    :type: bool
    """

    white_level: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ For RGB curves, the color that white is mapped to

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def update(self):
        """Update curve mapping after making changes"""
        ...

    def reset_view(self):
        """Reset the curve mapping grid to its clipping size"""
        ...

    def initialize(self):
        """Initialize curve"""
        ...

    def evaluate(self, curve: "CurveMap", position: typing.Optional[float]) -> float:
        """Evaluate curve at given location

        :param curve: curve, Curve to evaluate
        :type curve: 'CurveMap'
        :param position: Position, Position to evaluate curve at
        :type position: typing.Optional[float]
        :rtype: float
        :return: Value, Value of curve at given location
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurvePaintSettings(bpy_struct):
    corner_angle: float
    """ Angles above this are considered corners

    :type: float
    """

    curve_type: typing.Union[int, str]
    """ Type of curve to use for new strokes

    :type: typing.Union[int, str]
    """

    depth_mode: typing.Union[int, str]
    """ Method of projecting depth

    :type: typing.Union[int, str]
    """

    error_threshold: int
    """ Allow deviation for a smoother, less precise line

    :type: int
    """

    fit_method: typing.Union[int, str]
    """ Curve fitting method

    :type: typing.Union[int, str]
    """

    radius_max: float
    """ Radius to use when the maximum pressure is applied (or when a tablet isn't used)

    :type: float
    """

    radius_min: float
    """ Minimum radius when the minimum pressure is applied (also the minimum when tapering)

    :type: float
    """

    radius_taper_end: float
    """ Taper factor for the radius of each point along the curve

    :type: float
    """

    radius_taper_start: float
    """ Taper factor for the radius of each point along the curve

    :type: float
    """

    surface_offset: float
    """ Offset the stroke from the surface

    :type: float
    """

    surface_plane: typing.Union[int, str]
    """ Plane for projected stroke

    :type: typing.Union[int, str]
    """

    use_corners_detect: bool
    """ Detect corners and use non-aligned handles

    :type: bool
    """

    use_offset_absolute: bool
    """ Apply a fixed offset (don't scale by the radius)

    :type: bool
    """

    use_pressure_radius: bool
    """ Map tablet pressure to curve radius

    :type: bool
    """

    use_stroke_endpoints: bool
    """ Use the start of the stroke for the depth

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurvePoint(bpy_struct):
    """Curve control point"""

    index: int
    """ Index of this point

    :type: int
    """

    position: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    radius: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveProfile(bpy_struct):
    """Profile Path editor used to build a profile path"""

    points: bpy_prop_collection["CurveProfilePoint"]
    """ Profile control points

    :type: bpy_prop_collection['CurveProfilePoint']
    """

    preset: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    segments: bpy_prop_collection["CurveProfilePoint"]
    """ Segments sampled from control points

    :type: bpy_prop_collection['CurveProfilePoint']
    """

    use_clip: bool
    """ Force the path view to fit a defined boundary

    :type: bool
    """

    use_sample_even_lengths: bool
    """ Sample edges with even lengths

    :type: bool
    """

    use_sample_straight_edges: bool
    """ Sample edges with vector handles

    :type: bool
    """

    def update(self):
        """Refresh internal data, remove doubles and clip points"""
        ...

    def reset_view(self):
        """Reset the curve profile grid to its clipping size"""
        ...

    def initialize(self, totsegments: typing.Any):
        """Set the number of display segments and fill tables

        :param totsegments: The number of segment values to initialize the segments table with
        :type totsegments: typing.Any
        """
        ...

    def evaluate(
        self, length_portion: typing.Optional[float]
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]:
        """Evaluate the at the given portion of the path length

        :param length_portion: Length Portion, Portion of the path length to travel before evaluation
        :type length_portion: typing.Optional[float]
        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
        :return: Location, The location at the given portion of the profile
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveProfilePoint(bpy_struct):
    """Point of a path used to define a profile"""

    handle_type_1: typing.Union[int, str]
    """ Path interpolation at this point

    :type: typing.Union[int, str]
    """

    handle_type_2: typing.Union[int, str]
    """ Path interpolation at this point

    :type: typing.Union[int, str]
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ X/Y coordinates of the path point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    select: bool
    """ Selection state of the path point

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveProfilePoints(bpy_struct):
    """Collection of Profile Points"""

    def add(
        self, x: typing.Optional[float], y: typing.Optional[float]
    ) -> "CurveProfilePoint":
        """Add point to the profile

        :param x: X Position, X Position for new point
        :type x: typing.Optional[float]
        :param y: Y Position, Y Position for new point
        :type y: typing.Optional[float]
        :rtype: 'CurveProfilePoint'
        :return: New point
        """
        ...

    def remove(self, point: "CurveProfilePoint"):
        """Delete point from the profile

        :param point: Point to remove
        :type point: 'CurveProfilePoint'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveSlice(bpy_struct):
    """A single curve from a curves data-block"""

    first_point_index: int
    """ The index of this curve's first control point

    :type: int
    """

    index: int
    """ Index of this curve

    :type: int
    """

    points: bpy_prop_collection["CurvePoint"]
    """ Control points of the curve

    :type: bpy_prop_collection['CurvePoint']
    """

    points_length: int
    """ Number of control points in the curve

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveSplines(bpy_struct):
    """Collection of curve splines"""

    active: "Spline"
    """ Active curve spline

    :type: 'Spline'
    """

    def new(self, type: typing.Optional[typing.Union[int, str]]) -> "Spline":
        """Add a new spline to the curve

        :param type: type for the new spline
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'Spline'
        :return: The newly created spline
        """
        ...

    def remove(self, spline: "Spline"):
        """Remove a spline from a curve

        :param spline: The spline to remove
        :type spline: 'Spline'
        """
        ...

    def clear(self):
        """Remove all splines from a curve"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DashGpencilModifierSegment(bpy_struct):
    """Configuration for a single dash segment"""

    dash: int
    """ The number of consecutive points from the original stroke to include in this segment

    :type: int
    """

    gap: int
    """ The number of points skipped after this segment

    :type: int
    """

    material_index: int
    """ Use this index on generated segment. -1 means using the existing material

    :type: int
    """

    name: typing.Union[str, typing.Any]
    """ Name of the dash segment

    :type: typing.Union[str, typing.Any]
    """

    opacity: float
    """ The factor to apply to the original point's opacity for the new points

    :type: float
    """

    radius: float
    """ The factor to apply to the original point's radius for the new points

    :type: float
    """

    use_cyclic: bool
    """ Enable cyclic on individual stroke dashes

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DepsgraphObjectInstance(bpy_struct):
    """Extended information about dependency graph object iterator (Warning: All data here is 'evaluated' one, not original .blend IDs)"""

    instance_object: "Object"
    """ Evaluated object which is being instanced by this iterator

    :type: 'Object'
    """

    is_instance: typing.Union[bool, typing.Any]
    """ Denotes if the object is generated by another object

    :type: typing.Union[bool, typing.Any]
    """

    matrix_world: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Generated transform matrix in world space

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    object: "Object"
    """ Evaluated object the iterator points to

    :type: 'Object'
    """

    orco: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Generated coordinates in parent object space

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    parent: "Object"
    """ If the object is an instance, the parent object that generated it

    :type: 'Object'
    """

    particle_system: "ParticleSystem"
    """ Evaluated particle system that this object was instanced from

    :type: 'ParticleSystem'
    """

    persistent_id: bpy_prop_array[int]
    """ Persistent identifier for inter-frame matching of objects with motion blur

    :type: bpy_prop_array[int]
    """

    random_id: int
    """ Random id for this instance, typically for randomized shading

    :type: int
    """

    show_particles: typing.Union[bool, typing.Any]
    """ Particles part of the object should be visible in the render

    :type: typing.Union[bool, typing.Any]
    """

    show_self: typing.Union[bool, typing.Any]
    """ The object geometry itself should be visible in the render

    :type: typing.Union[bool, typing.Any]
    """

    uv: bpy_prop_array[float]
    """ UV coordinates in parent object space

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DepsgraphUpdate(bpy_struct):
    """Information about ID that was updated"""

    id: "ID"
    """ Updated data-block

    :type: 'ID'
    """

    is_updated_geometry: typing.Union[bool, typing.Any]
    """ Object geometry is updated

    :type: typing.Union[bool, typing.Any]
    """

    is_updated_shading: typing.Union[bool, typing.Any]
    """ Object shading is updated

    :type: typing.Union[bool, typing.Any]
    """

    is_updated_transform: typing.Union[bool, typing.Any]
    """ Object transformation is updated

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DisplaySafeAreas(bpy_struct):
    """Safe areas used in 3D view and the sequencer"""

    action: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Safe area for general elements

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    action_center: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Safe area for general elements in a different aspect ratio

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    title: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Safe area for text and graphics

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    title_center: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Safe area for text and graphics in a different aspect ratio

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DopeSheet(bpy_struct):
    """Settings for filtering the channels shown in animation editors"""

    filter_collection: "Collection"
    """ Collection that included object should be a member of

    :type: 'Collection'
    """

    filter_fcurve_name: typing.Union[str, typing.Any]
    """ F-Curve live filtering string

    :type: typing.Union[str, typing.Any]
    """

    filter_text: typing.Union[str, typing.Any]
    """ Live filtering string

    :type: typing.Union[str, typing.Any]
    """

    show_armatures: bool
    """ Include visualization of armature related animation data

    :type: bool
    """

    show_cache_files: bool
    """ Include visualization of cache file related animation data

    :type: bool
    """

    show_cameras: bool
    """ Include visualization of camera related animation data

    :type: bool
    """

    show_curves: bool
    """ Include visualization of curve related animation data

    :type: bool
    """

    show_datablock_filters: bool
    """ Show options for whether channels related to certain types of data are included

    :type: bool
    """

    show_driver_fallback_as_error: bool
    """ Include drivers that relied on any fallback values for their evaluation in the Only Show Errors filter, even if the driver evaluation succeeded

    :type: bool
    """

    show_expanded_summary: bool
    """ Collapse summary when shown, so all other channels get hidden (Dope Sheet editors only)

    :type: bool
    """

    show_gpencil: bool
    """ Include visualization of Grease Pencil related animation data and frames

    :type: bool
    """

    show_hair_curves: bool
    """ Include visualization of hair related animation data

    :type: bool
    """

    show_hidden: bool
    """ Include channels from objects/bone that are not visible

    :type: bool
    """

    show_lattices: bool
    """ Include visualization of lattice related animation data

    :type: bool
    """

    show_lights: bool
    """ Include visualization of light related animation data

    :type: bool
    """

    show_linestyles: bool
    """ Include visualization of Line Style related Animation data

    :type: bool
    """

    show_materials: bool
    """ Include visualization of material related animation data

    :type: bool
    """

    show_meshes: bool
    """ Include visualization of mesh related animation data

    :type: bool
    """

    show_metaballs: bool
    """ Include visualization of metaball related animation data

    :type: bool
    """

    show_missing_nla: bool
    """ Include animation data-blocks with no NLA data (NLA editor only)

    :type: bool
    """

    show_modifiers: bool
    """ Include visualization of animation data related to data-blocks linked to modifiers

    :type: bool
    """

    show_movieclips: bool
    """ Include visualization of movie clip related animation data

    :type: bool
    """

    show_nodes: bool
    """ Include visualization of node related animation data

    :type: bool
    """

    show_only_errors: bool
    """ Only include F-Curves and drivers that are disabled or have errors

    :type: bool
    """

    show_only_selected: bool
    """ Only include channels relating to selected objects and data

    :type: bool
    """

    show_particles: bool
    """ Include visualization of particle related animation data

    :type: bool
    """

    show_pointclouds: bool
    """ Include visualization of point cloud related animation data

    :type: bool
    """

    show_scenes: bool
    """ Include visualization of scene related animation data

    :type: bool
    """

    show_shapekeys: bool
    """ Include visualization of shape key related animation data

    :type: bool
    """

    show_speakers: bool
    """ Include visualization of speaker related animation data

    :type: bool
    """

    show_summary: bool
    """ Display an additional 'summary' line (Dope Sheet editors only)

    :type: bool
    """

    show_textures: bool
    """ Include visualization of texture related animation data

    :type: bool
    """

    show_transforms: bool
    """ Include visualization of object-level animation data (mostly transforms)

    :type: bool
    """

    show_volumes: bool
    """ Include visualization of volume related animation data

    :type: bool
    """

    show_worlds: bool
    """ Include visualization of world related animation data

    :type: bool
    """

    source: "ID"
    """ ID-Block representing source data, usually ID_SCE (i.e. Scene)

    :type: 'ID'
    """

    use_datablock_sort: bool
    """ Alphabetically sorts data-blocks - mainly objects in the scene (disable to increase viewport speed)

    :type: bool
    """

    use_filter_invert: bool
    """ Invert filter search

    :type: bool
    """

    use_multi_word_filter: bool
    """ Perform fuzzy/multi-word matching.
Warning: May be slow

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Driver(bpy_struct):
    """Driver for the value of a setting based on an external value"""

    expression: typing.Union[str, typing.Any]
    """ Expression to use for Scripted Expression

    :type: typing.Union[str, typing.Any]
    """

    is_simple_expression: typing.Union[bool, typing.Any]
    """ The scripted expression can be evaluated without using the full Python interpreter

    :type: typing.Union[bool, typing.Any]
    """

    is_valid: bool
    """ Driver could not be evaluated in past, so should be skipped

    :type: bool
    """

    type: typing.Union[int, str]
    """ Driver type

    :type: typing.Union[int, str]
    """

    use_self: bool
    """ Include a 'self' variable in the name-space, so drivers can easily reference the data being modified (object, bone, etc...)

    :type: bool
    """

    variables: bpy_prop_collection["DriverVariable"]
    """ Properties acting as inputs for this driver

    :type: bpy_prop_collection['DriverVariable']
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DriverTarget(bpy_struct):
    """Source of input values for driver variables"""

    bone_target: typing.Union[str, typing.Any]
    """ Name of PoseBone to use as target

    :type: typing.Union[str, typing.Any]
    """

    context_property: typing.Union[int, str]
    """ Type of a context-dependent data-block to access property from

    :type: typing.Union[int, str]
    """

    data_path: typing.Union[str, typing.Any]
    """ RNA Path (from ID-block) to property used

    :type: typing.Union[str, typing.Any]
    """

    fallback_value: float
    """ The value to use if the data path can't be resolved

    :type: float
    """

    id: "ID"
    """ ID-block that the specific property used can be found from (id_type property must be set first)

    :type: 'ID'
    """

    id_type: typing.Union[int, str]
    """ Type of ID-block that can be used

    :type: typing.Union[int, str]
    """

    is_fallback_used: typing.Union[bool, typing.Any]
    """ Indicates that the most recent variable evaluation used the fallback value

    :type: typing.Union[bool, typing.Any]
    """

    rotation_mode: typing.Union[int, str]
    """ Mode for calculating rotation channel values

    :type: typing.Union[int, str]
    """

    transform_space: typing.Union[int, str]
    """ Space in which transforms are used

    :type: typing.Union[int, str]
    """

    transform_type: typing.Union[int, str]
    """ Driver variable type

    :type: typing.Union[int, str]
    """

    use_fallback_value: bool
    """ Use the fallback value if the data path can't be resolved, instead of failing to evaluate the driver

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DriverVariable(bpy_struct):
    """Variable from some source/target for driver relationship"""

    is_name_valid: typing.Union[bool, typing.Any]
    """ Is this a valid name for a driver variable

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Name to use in scripted expressions/functions (no spaces or dots are allowed, and must start with a letter)

    :type: typing.Union[str, typing.Any]
    """

    targets: bpy_prop_collection["DriverTarget"]
    """ Sources of input data for evaluating this variable

    :type: bpy_prop_collection['DriverTarget']
    """

    type: typing.Union[int, str]
    """ Driver variable type

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DynamicPaintBrushSettings(bpy_struct):
    """Brush settings"""

    invert_proximity: bool
    """ Proximity falloff is applied inside the volume

    :type: bool
    """

    paint_alpha: float
    """ Paint alpha

    :type: float
    """

    paint_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of the paint

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    paint_distance: float
    """ Maximum distance from brush to mesh surface to affect paint

    :type: float
    """

    paint_ramp: "ColorRamp"
    """ Color ramp used to define proximity falloff

    :type: 'ColorRamp'
    """

    paint_source: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    paint_wetness: float
    """ Paint wetness, visible in wetmap (some effects only affect wet paint)

    :type: float
    """

    particle_system: "ParticleSystem"
    """ The particle system to paint with

    :type: 'ParticleSystem'
    """

    proximity_falloff: typing.Union[int, str]
    """ Proximity falloff type

    :type: typing.Union[int, str]
    """

    ray_direction: typing.Union[int, str]
    """ Ray direction to use for projection (if brush object is located in that direction it's painted)

    :type: typing.Union[int, str]
    """

    smooth_radius: float
    """ Smooth falloff added after solid radius

    :type: float
    """

    smudge_strength: float
    """ Smudge effect strength

    :type: float
    """

    solid_radius: float
    """ Radius that will be painted solid

    :type: float
    """

    use_absolute_alpha: bool
    """ Only increase alpha value if paint alpha is higher than existing

    :type: bool
    """

    use_negative_volume: bool
    """ Negate influence inside the volume

    :type: bool
    """

    use_paint_erase: bool
    """ Erase / remove paint instead of adding it

    :type: bool
    """

    use_particle_radius: bool
    """ Use radius from particle settings

    :type: bool
    """

    use_proximity_project: bool
    """ Brush is projected to canvas from defined direction within brush proximity

    :type: bool
    """

    use_proximity_ramp_alpha: bool
    """ Only read color ramp alpha

    :type: bool
    """

    use_smudge: bool
    """ Make this brush to smudge existing paint as it moves

    :type: bool
    """

    use_velocity_alpha: bool
    """ Multiply brush influence by velocity color ramp alpha

    :type: bool
    """

    use_velocity_color: bool
    """ Replace brush color by velocity color ramp

    :type: bool
    """

    use_velocity_depth: bool
    """ Multiply brush intersection depth (displace, waves) by velocity ramp alpha

    :type: bool
    """

    velocity_max: float
    """ Velocity considered as maximum influence (Blender units per frame)

    :type: float
    """

    velocity_ramp: "ColorRamp"
    """ Color ramp used to define brush velocity effect

    :type: 'ColorRamp'
    """

    wave_clamp: float
    """ Maximum level of surface intersection used to influence waves (use 0.0 to disable)

    :type: float
    """

    wave_factor: float
    """ Multiplier for wave influence of this brush

    :type: float
    """

    wave_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DynamicPaintCanvasSettings(bpy_struct):
    """Dynamic Paint canvas settings"""

    canvas_surfaces: bpy_prop_collection["DynamicPaintSurface"]
    """ Paint surface list

    :type: bpy_prop_collection['DynamicPaintSurface']
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DynamicPaintSurface(bpy_struct):
    """A canvas surface layer"""

    brush_collection: "Collection"
    """ Only use brush objects from this collection

    :type: 'Collection'
    """

    brush_influence_scale: float
    """ Adjust influence brush objects have on this surface

    :type: float
    """

    brush_radius_scale: float
    """ Adjust radius of proximity brushes or particles for this surface

    :type: float
    """

    color_dry_threshold: float
    """ The wetness level when colors start to shift to the background

    :type: float
    """

    color_spread_speed: float
    """ How fast colors get mixed within wet paint

    :type: float
    """

    depth_clamp: float
    """ Maximum level of depth intersection in object space (use 0.0 to disable)

    :type: float
    """

    displace_factor: float
    """ Strength of displace when applied to the mesh

    :type: float
    """

    displace_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    dissolve_speed: int
    """ Approximately in how many frames should dissolve happen

    :type: int
    """

    drip_acceleration: float
    """ How much surface acceleration affects dripping

    :type: float
    """

    drip_velocity: float
    """ How much surface velocity affects dripping

    :type: float
    """

    dry_speed: int
    """ Approximately in how many frames should drying happen

    :type: int
    """

    effect_ui: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    effector_weights: "EffectorWeights"
    """ 

    :type: 'EffectorWeights'
    """

    frame_end: int
    """ Simulation end frame

    :type: int
    """

    frame_start: int
    """ Simulation start frame

    :type: int
    """

    frame_substeps: int
    """ Do extra frames between scene frames to ensure smooth motion

    :type: int
    """

    image_fileformat: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    image_output_path: typing.Union[str, typing.Any]
    """ Directory to save the textures

    :type: typing.Union[str, typing.Any]
    """

    image_resolution: int
    """ Output image resolution

    :type: int
    """

    init_color: bpy_prop_array[float]
    """ Initial color of the surface

    :type: bpy_prop_array[float]
    """

    init_color_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    init_layername: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    init_texture: "Texture"
    """ 

    :type: 'Texture'
    """

    is_active: bool
    """ Toggle whether surface is processed or ignored

    :type: bool
    """

    is_cache_user: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Surface name

    :type: typing.Union[str, typing.Any]
    """

    output_name_a: typing.Union[str, typing.Any]
    """ Name used to save output from this surface

    :type: typing.Union[str, typing.Any]
    """

    output_name_b: typing.Union[str, typing.Any]
    """ Name used to save output from this surface

    :type: typing.Union[str, typing.Any]
    """

    point_cache: "PointCache"
    """ 

    :type: 'PointCache'
    """

    shrink_speed: float
    """ How fast shrink effect moves on the canvas surface

    :type: float
    """

    spread_speed: float
    """ How fast spread effect moves on the canvas surface

    :type: float
    """

    surface_format: typing.Union[int, str]
    """ Surface Format

    :type: typing.Union[int, str]
    """

    surface_type: typing.Union[int, str]
    """ Surface Type

    :type: typing.Union[int, str]
    """

    use_antialiasing: bool
    """ Use 5× multisampling to smooth paint edges

    :type: bool
    """

    use_dissolve: bool
    """ Enable to make surface changes disappear over time

    :type: bool
    """

    use_dissolve_log: bool
    """ Use logarithmic dissolve (makes high values to fade faster than low values)

    :type: bool
    """

    use_drip: bool
    """ Process drip effect (drip wet paint to gravity direction)

    :type: bool
    """

    use_dry_log: bool
    """ Use logarithmic drying (makes high values to dry faster than low values)

    :type: bool
    """

    use_drying: bool
    """ Enable to make surface wetness dry over time

    :type: bool
    """

    use_incremental_displace: bool
    """ New displace is added cumulatively on top of existing

    :type: bool
    """

    use_output_a: bool
    """ Save this output layer

    :type: bool
    """

    use_output_b: bool
    """ Save this output layer

    :type: bool
    """

    use_premultiply: bool
    """ Multiply color by alpha (recommended for Blender input)

    :type: bool
    """

    use_shrink: bool
    """ Process shrink effect (shrink paint areas)

    :type: bool
    """

    use_spread: bool
    """ Process spread effect (spread wet paint around surface)

    :type: bool
    """

    use_wave_open_border: bool
    """ Pass waves through mesh edges

    :type: bool
    """

    uv_layer: typing.Union[str, typing.Any]
    """ UV map name

    :type: typing.Union[str, typing.Any]
    """

    wave_damping: float
    """ Wave damping factor

    :type: float
    """

    wave_smoothness: float
    """ Limit maximum steepness of wave slope between simulation points (use higher values for smoother waves at expense of reduced detail)

    :type: float
    """

    wave_speed: float
    """ Wave propagation speed

    :type: float
    """

    wave_spring: float
    """ Spring force that pulls water level back to zero

    :type: float
    """

    wave_timescale: float
    """ Wave time scaling factor

    :type: float
    """

    def output_exists(self, object: "Object", index: typing.Optional[int]) -> bool:
        """Checks if surface output layer of given name exists

        :param object:
        :type object: 'Object'
        :param index: Index
        :type index: typing.Optional[int]
        :rtype: bool
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DynamicPaintSurfaces(bpy_struct):
    """Collection of Dynamic Paint Canvas surfaces"""

    active: "DynamicPaintSurface"
    """ Active Dynamic Paint surface being displayed

    :type: 'DynamicPaintSurface'
    """

    active_index: int
    """ 

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class EQCurveMappingData(bpy_struct):
    """EQCurveMappingData"""

    curve_mapping: "CurveMapping"
    """ 

    :type: 'CurveMapping'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class EditBone(bpy_struct):
    """Edit mode bone in an armature data-block"""

    bbone_curveinx: float
    """ X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveinz: float
    """ Z-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutx: float
    """ X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutz: float
    """ Z-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_custom_handle_end: "EditBone"
    """ Bone that serves as the end handle for the B-Bone curve

    :type: 'EditBone'
    """

    bbone_custom_handle_start: "EditBone"
    """ Bone that serves as the start handle for the B-Bone curve

    :type: 'EditBone'
    """

    bbone_easein: float
    """ Length of first Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_easeout: float
    """ Length of second Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_handle_type_end: typing.Union[int, str]
    """ Selects how the end handle of the B-Bone is computed

    :type: typing.Union[int, str]
    """

    bbone_handle_type_start: typing.Union[int, str]
    """ Selects how the start handle of the B-Bone is computed

    :type: typing.Union[int, str]
    """

    bbone_handle_use_ease_end: bool
    """ Multiply the B-Bone Ease Out channel by the local Y scale value of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    """

    bbone_handle_use_ease_start: bool
    """ Multiply the B-Bone Ease In channel by the local Y scale value of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    """

    bbone_handle_use_scale_end: typing.List[bool]
    """ Multiply B-Bone Scale Out channels by the local scale values of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    """

    bbone_handle_use_scale_start: typing.List[bool]
    """ Multiply B-Bone Scale In channels by the local scale values of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    """

    bbone_mapping_mode: typing.Union[int, str]
    """ Selects how the vertices are mapped to B-Bone segments based on their position

    :type: typing.Union[int, str]
    """

    bbone_rollin: float
    """ Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    """

    bbone_rollout: float
    """ Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    """

    bbone_scalein: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale factors for the start of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bbone_scaleout: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale factors for the end of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bbone_segments: int
    """ Number of subdivisions of bone (for B-Bones only)

    :type: int
    """

    bbone_x: float
    """ B-Bone X size

    :type: float
    """

    bbone_z: float
    """ B-Bone Z size

    :type: float
    """

    collections: bpy_prop_collection["BoneCollection"]
    """ Bone Collections that contain this bone

    :type: bpy_prop_collection['BoneCollection']
    """

    color: "BoneColor"
    """ 

    :type: 'BoneColor'
    """

    envelope_distance: float
    """ Bone deformation distance (for Envelope deform only)

    :type: float
    """

    envelope_weight: float
    """ Bone deformation weight (for Envelope deform only)

    :type: float
    """

    head: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of head end of the bone

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    head_radius: float
    """ Radius of head of bone (for Envelope deform only)

    :type: float
    """

    hide: bool
    """ Bone is not visible when in Edit Mode

    :type: bool
    """

    hide_select: bool
    """ Bone is able to be selected

    :type: bool
    """

    inherit_scale: typing.Union[int, str]
    """ Specifies how the bone inherits scaling from the parent bone

    :type: typing.Union[int, str]
    """

    length: float
    """ Length of the bone. Changing moves the tail end

    :type: float
    """

    lock: bool
    """ Bone is not able to be transformed when in Edit Mode

    :type: bool
    """

    matrix: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Matrix combining location and rotation of the bone (head position, direction and roll), in armature space (does not include/support bone's length/size)

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    parent: "EditBone"
    """ Parent edit bone (in same Armature)

    :type: 'EditBone'
    """

    roll: float
    """ Bone rotation around head-tail axis

    :type: float
    """

    select: bool
    """ 

    :type: bool
    """

    select_head: bool
    """ 

    :type: bool
    """

    select_tail: bool
    """ 

    :type: bool
    """

    show_wire: bool
    """ Bone is always displayed in wireframe regardless of viewport shading mode (useful for non-obstructive custom bone shapes)

    :type: bool
    """

    tail: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of tail end of the bone

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    tail_radius: float
    """ Radius of tail of bone (for Envelope deform only)

    :type: float
    """

    use_connect: bool
    """ When bone has a parent, bone's head is stuck to the parent's tail

    :type: bool
    """

    use_cyclic_offset: bool
    """ When bone doesn't have a parent, it receives cyclic offset effects (Deprecated)

    :type: bool
    """

    use_deform: bool
    """ Enable Bone to deform geometry

    :type: bool
    """

    use_endroll_as_inroll: bool
    """ Add Roll Out of the Start Handle bone to the Roll In value

    :type: bool
    """

    use_envelope_multiply: bool
    """ When deforming bone, multiply effects of Vertex Group weights with Envelope influence

    :type: bool
    """

    use_inherit_rotation: bool
    """ Bone inherits rotation or scale from parent bone

    :type: bool
    """

    use_local_location: bool
    """ Bone location is set in local space

    :type: bool
    """

    use_relative_parent: bool
    """ Object children will use relative transform, like deform

    :type: bool
    """

    use_scale_easing: bool
    """ Multiply the final easing values by the Scale In/Out Y factors

    :type: bool
    """

    basename: typing.Any
    """ The name of this bone before any '.' character(readonly)"""

    center: typing.Any
    """ The midpoint between the head and the tail.(readonly)"""

    children: typing.Any
    """ A list of all the bones children.(readonly)"""

    children_recursive: typing.Any
    """ A list of all children from this bone.(readonly)"""

    children_recursive_basename: typing.Any
    """ Returns a chain of children with the same base name as this bone.
Only direct chains are supported, forks caused by multiple children
with matching base names will terminate the function
and not be returned.(readonly)"""

    parent_recursive: typing.Any
    """ A list of parents, starting with the immediate parent(readonly)"""

    vector: typing.Any
    """ The direction this bone is pointing.
Utility function for (tail - head)(readonly)"""

    x_axis: typing.Any
    """ Vector pointing down the x-axis of the bone.(readonly)"""

    y_axis: typing.Any
    """ Vector pointing down the y-axis of the bone.(readonly)"""

    z_axis: typing.Any
    """ Vector pointing down the z-axis of the bone.(readonly)"""

    def align_roll(
        self,
        vector: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
    ):
        """Align the bone to a local-space roll so the Z axis points in the direction of the vector given

        :param vector: Vector
        :type vector: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
        """
        ...

    def align_orientation(self, other):
        """Align this bone to another by moving its tail and settings its roll
        the length of the other bone is not used.

                :param other:
                :type other:
        """
        ...

    def parent_index(self, parent_test):
        """The same as 'bone in other_bone.parent_recursive'
        but saved generating a list.

                :param parent_test:
                :type parent_test:
        """
        ...

    def transform(
        self,
        matrix: typing.Optional[
            typing.Union["mathutils.Matrix", typing.Sequence[float]]
        ],
        *,
        scale: typing.Optional[bool] = True,
        roll: typing.Optional[bool] = True,
    ):
        """Transform the the bones head, tail, roll and envelope
        (when the matrix has a scale component).

                :param matrix: 3x3 or 4x4 transformation matrix.
                :type matrix: typing.Optional[typing.Union['mathutils.Matrix', typing.Sequence[float]]]
                :param *:
                :type *:
                :param scale: Scale the bone envelope by the matrix.
                :type scale: typing.Optional[bool]
                :param roll: Correct the roll to point in the same relative
        direction to the head and tail.
                :type roll: typing.Optional[bool]
        """
        ...

    def translate(self, vec):
        """Utility function to add vec to the head and tail of this bone

        :param vec:
        :type vec:
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class EffectorWeights(bpy_struct):
    """Effector weights for physics simulation"""

    all: float
    """ All effector's weight

    :type: float
    """

    apply_to_hair_growing: bool
    """ Use force fields when growing hair

    :type: bool
    """

    boid: float
    """ Boid effector weight

    :type: float
    """

    charge: float
    """ Charge effector weight

    :type: float
    """

    collection: "Collection"
    """ Limit effectors to this collection

    :type: 'Collection'
    """

    curve_guide: float
    """ Curve guide effector weight

    :type: float
    """

    drag: float
    """ Drag effector weight

    :type: float
    """

    force: float
    """ Force effector weight

    :type: float
    """

    gravity: float
    """ Global gravity weight

    :type: float
    """

    harmonic: float
    """ Harmonic effector weight

    :type: float
    """

    lennardjones: float
    """ Lennard-Jones effector weight

    :type: float
    """

    magnetic: float
    """ Magnetic effector weight

    :type: float
    """

    smokeflow: float
    """ Fluid Flow effector weight

    :type: float
    """

    texture: float
    """ Texture effector weight

    :type: float
    """

    turbulence: float
    """ Turbulence effector weight

    :type: float
    """

    vortex: float
    """ Vortex effector weight

    :type: float
    """

    wind: float
    """ Wind effector weight

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class EnumPropertyItem(bpy_struct):
    """Definition of a choice in an RNA enum property"""

    description: typing.Union[str, typing.Any]
    """ Description of the item's purpose

    :type: typing.Union[str, typing.Any]
    """

    icon: typing.Any
    """ Icon of the item

    :type: typing.Any
    """

    identifier: typing.Union[str, typing.Any]
    """ Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Human readable name

    :type: typing.Union[str, typing.Any]
    """

    value: int
    """ Value of the item

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Event(bpy_struct):
    """Window Manager Event"""

    alt: typing.Union[bool, typing.Any]
    """ True when the Alt/Option key is held

    :type: typing.Union[bool, typing.Any]
    """

    ascii: typing.Union[str, typing.Any]
    """ Single ASCII character for this event

    :type: typing.Union[str, typing.Any]
    """

    ctrl: typing.Union[bool, typing.Any]
    """ True when the Ctrl key is held

    :type: typing.Union[bool, typing.Any]
    """

    direction: typing.Any
    """ The direction (only applies to drag events)

    :type: typing.Any
    """

    is_consecutive: typing.Union[bool, typing.Any]
    """ Part of a trackpad or NDOF motion, interrupted by cursor motion, button or key press events

    :type: typing.Union[bool, typing.Any]
    """

    is_mouse_absolute: typing.Union[bool, typing.Any]
    """ The last motion event was an absolute input

    :type: typing.Union[bool, typing.Any]
    """

    is_repeat: typing.Union[bool, typing.Any]
    """ The event is generated by holding a key down

    :type: typing.Union[bool, typing.Any]
    """

    is_tablet: typing.Union[bool, typing.Any]
    """ The event has tablet data

    :type: typing.Union[bool, typing.Any]
    """

    mouse_prev_press_x: int
    """ The window relative horizontal location of the last press event

    :type: int
    """

    mouse_prev_press_y: int
    """ The window relative vertical location of the last press event

    :type: int
    """

    mouse_prev_x: int
    """ The window relative horizontal location of the mouse

    :type: int
    """

    mouse_prev_y: int
    """ The window relative vertical location of the mouse

    :type: int
    """

    mouse_region_x: int
    """ The region relative horizontal location of the mouse

    :type: int
    """

    mouse_region_y: int
    """ The region relative vertical location of the mouse

    :type: int
    """

    mouse_x: int
    """ The window relative horizontal location of the mouse

    :type: int
    """

    mouse_y: int
    """ The window relative vertical location of the mouse

    :type: int
    """

    oskey: typing.Union[bool, typing.Any]
    """ True when the Cmd key is held

    :type: typing.Union[bool, typing.Any]
    """

    pressure: float
    """ The pressure of the tablet or 1.0 if no tablet present

    :type: float
    """

    shift: typing.Union[bool, typing.Any]
    """ True when the Shift key is held

    :type: typing.Union[bool, typing.Any]
    """

    tilt: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ The pressure of the tablet or zeroes if no tablet present

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    type_prev: typing.Any
    """ 

    :type: typing.Any
    """

    unicode: typing.Union[str, typing.Any]
    """ Single unicode character for this event

    :type: typing.Union[str, typing.Any]
    """

    value: typing.Any
    """ The type of event, only applies to some

    :type: typing.Any
    """

    value_prev: typing.Any
    """ The type of event, only applies to some

    :type: typing.Any
    """

    xr: "XrEventData"
    """ XR event data

    :type: 'XrEventData'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FCurve(bpy_struct):
    """F-Curve defining values of a period of time"""

    array_index: int
    """ Index to the specific property affected by F-Curve if applicable

    :type: int
    """

    auto_smoothing: typing.Union[int, str]
    """ Algorithm used to compute automatic handles

    :type: typing.Union[int, str]
    """

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of the F-Curve in the Graph Editor

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    color_mode: typing.Union[int, str]
    """ Method used to determine color of F-Curve in Graph Editor

    :type: typing.Union[int, str]
    """

    data_path: typing.Union[str, typing.Any]
    """ RNA Path to property affected by F-Curve

    :type: typing.Union[str, typing.Any]
    """

    driver: "Driver"
    """ Channel Driver (only set for Driver F-Curves)

    :type: 'Driver'
    """

    extrapolation: typing.Union[int, str]
    """ Method used for evaluating value of F-Curve outside first and last keyframes

    :type: typing.Union[int, str]
    """

    group: "ActionGroup"
    """ Action Group that this F-Curve belongs to

    :type: 'ActionGroup'
    """

    hide: bool
    """ F-Curve and its keyframes are hidden in the Graph Editor graphs

    :type: bool
    """

    is_empty: typing.Union[bool, typing.Any]
    """ True if the curve contributes no animation due to lack of keyframes or useful modifiers, and should be deleted

    :type: typing.Union[bool, typing.Any]
    """

    is_valid: bool
    """ False when F-Curve could not be evaluated in past, so should be skipped when evaluating

    :type: bool
    """

    keyframe_points: bpy_prop_collection["Keyframe"]
    """ User-editable keyframes

    :type: bpy_prop_collection['Keyframe']
    """

    lock: bool
    """ F-Curve's settings cannot be edited

    :type: bool
    """

    modifiers: bpy_prop_collection["FModifier"]
    """ Modifiers affecting the shape of the F-Curve

    :type: bpy_prop_collection['FModifier']
    """

    mute: bool
    """ Disable F-Curve evaluation

    :type: bool
    """

    sampled_points: bpy_prop_collection["FCurveSample"]
    """ Sampled animation data

    :type: bpy_prop_collection['FCurveSample']
    """

    select: bool
    """ F-Curve is selected for editing

    :type: bool
    """

    def evaluate(self, frame: typing.Optional[float]) -> float:
        """Evaluate F-Curve

        :param frame: Frame, Evaluate F-Curve at given frame
        :type frame: typing.Optional[float]
        :rtype: float
        :return: Value, Value of F-Curve specific frame
        """
        ...

    def update(self):
        """Ensure keyframes are sorted in chronological order and handles are set correctly"""
        ...

    def range(
        self,
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]:
        """Get the time extents for F-Curve

        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
        :return: Range, Min/Max values
        """
        ...

    def update_autoflags(self, data: typing.Any):
        """Update FCurve flags set automatically from affected property (currently, integer/discrete flags set when the property is not a float)

        :param data: Data, Data containing the property controlled by given FCurve
        :type data: typing.Any
        """
        ...

    def convert_to_samples(
        self, start: typing.Optional[int], end: typing.Optional[int]
    ):
        """Convert current FCurve from keyframes to sample points, if necessary

        :param start: Start Frame
        :type start: typing.Optional[int]
        :param end: End Frame
        :type end: typing.Optional[int]
        """
        ...

    def convert_to_keyframes(
        self, start: typing.Optional[int], end: typing.Optional[int]
    ):
        """Convert current FCurve from sample points to keyframes (linear interpolation), if necessary

        :param start: Start Frame
        :type start: typing.Optional[int]
        :param end: End Frame
        :type end: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FCurveKeyframePoints(bpy_struct):
    """Collection of keyframe points"""

    def insert(
        self,
        frame: typing.Optional[float],
        value: typing.Optional[float],
        options: typing.Optional[typing.Any] = {},
        keyframe_type: typing.Optional[typing.Any] = "KEYFRAME",
    ) -> "Keyframe":
        """Add a keyframe point to a F-Curve

                :param frame: X Value of this keyframe point
                :type frame: typing.Optional[float]
                :param value: Y Value of this keyframe point
                :type value: typing.Optional[float]
                :param options: Keyframe options

        REPLACE
        Replace -- Don't add any new keyframes, but just replace existing ones.

        NEEDED
        Needed -- Only adds keyframes that are needed.

        FAST
        Fast -- Fast keyframe insertion to avoid recalculating the curve each time.
                :type options: typing.Optional[typing.Any]
                :param keyframe_type: Type of keyframe to insert
                :type keyframe_type: typing.Optional[typing.Any]
                :rtype: 'Keyframe'
                :return: Newly created keyframe
        """
        ...

    def add(self, count: typing.Optional[int]):
        """Add a keyframe point to a F-Curve

        :param count: Number, Number of points to add to the spline
        :type count: typing.Optional[int]
        """
        ...

    def remove(
        self,
        keyframe: "Keyframe",
        fast: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ):
        """Remove keyframe from an F-Curve

        :param keyframe: Keyframe to remove
        :type keyframe: 'Keyframe'
        :param fast: Fast, Fast keyframe removal to avoid recalculating the curve each time
        :type fast: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def clear(self):
        """Remove all keyframes from an F-Curve"""
        ...

    def sort(self):
        """Ensure all keyframe points are chronologically sorted"""
        ...

    def deduplicate(self):
        """Ensure there are no duplicate keys. Assumes that the points have already been sorted"""
        ...

    def handles_recalc(self):
        """Update handles after modifications to the keyframe points, to update things like auto-clamping"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FCurveModifiers(bpy_struct):
    """Collection of F-Curve Modifiers"""

    active: "FModifier"
    """ Active F-Curve Modifier

    :type: 'FModifier'
    """

    def new(self, type: typing.Optional[typing.Union[int, str]]) -> "FModifier":
        """Add a constraint to this object

        :param type: Constraint type to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'FModifier'
        :return: New fmodifier
        """
        ...

    def remove(self, modifier: "FModifier"):
        """Remove a modifier from this F-Curve

        :param modifier: Removed modifier
        :type modifier: 'FModifier'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FCurveSample(bpy_struct):
    """Sample point for F-Curve"""

    co: typing.Union["mathutils.Vector", typing.List[float], typing.Tuple[float, float]]
    """ Point coordinates

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    select: bool
    """ Selection status

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FFmpegSettings(bpy_struct):
    """FFmpeg related settings for the scene"""

    audio_bitrate: int
    """ Audio bitrate (kb/s)

    :type: int
    """

    audio_channels: typing.Union[int, str]
    """ Audio channel count

    :type: typing.Union[int, str]
    """

    audio_codec: typing.Union[int, str]
    """ FFmpeg audio codec to use

    :type: typing.Union[int, str]
    """

    audio_mixrate: int
    """ Audio sample rate (samples/s)

    :type: int
    """

    audio_volume: float
    """ Audio volume

    :type: float
    """

    buffersize: int
    """ Rate control: buffer size (kb)

    :type: int
    """

    codec: typing.Union[int, str]
    """ FFmpeg codec to use for video output

    :type: typing.Union[int, str]
    """

    constant_rate_factor: typing.Union[int, str]
    """ Constant Rate Factor (CRF); tradeoff between video quality and file size

    :type: typing.Union[int, str]
    """

    ffmpeg_preset: typing.Union[int, str]
    """ Tradeoff between encoding speed and compression ratio

    :type: typing.Union[int, str]
    """

    format: typing.Union[int, str]
    """ Output file container

    :type: typing.Union[int, str]
    """

    gopsize: int
    """ Distance between key frames, also known as GOP size; influences file size and seekability

    :type: int
    """

    max_b_frames: int
    """ Maximum number of B-frames between non-B-frames; influences file size and seekability

    :type: int
    """

    maxrate: int
    """ Rate control: max rate (kbit/s)

    :type: int
    """

    minrate: int
    """ Rate control: min rate (kbit/s)

    :type: int
    """

    muxrate: int
    """ Mux rate (bits/second)

    :type: int
    """

    packetsize: int
    """ Mux packet size (byte)

    :type: int
    """

    use_autosplit: bool
    """ Autosplit output at 2GB boundary

    :type: bool
    """

    use_lossless_output: bool
    """ Use lossless output for video streams

    :type: bool
    """

    use_max_b_frames: bool
    """ Set a maximum number of B-frames

    :type: bool
    """

    video_bitrate: int
    """ Video bitrate (kbit/s)

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FModifier(bpy_struct):
    """Modifier for values of F-Curve"""

    active: bool
    """ F-Curve modifier will show settings in the editor

    :type: bool
    """

    blend_in: float
    """ Number of frames from start frame for influence to take effect

    :type: float
    """

    blend_out: float
    """ Number of frames from end frame for influence to fade out

    :type: float
    """

    frame_end: float
    """ Frame that modifier's influence ends (if Restrict Frame Range is in use)

    :type: float
    """

    frame_start: float
    """ Frame that modifier's influence starts (if Restrict Frame Range is in use)

    :type: float
    """

    influence: float
    """ Amount of influence F-Curve Modifier will have when not fading in/out

    :type: float
    """

    is_valid: typing.Union[bool, typing.Any]
    """ F-Curve Modifier has invalid settings and will not be evaluated

    :type: typing.Union[bool, typing.Any]
    """

    mute: bool
    """ Enable F-Curve modifier evaluation

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ F-Curve Modifier name

    :type: typing.Union[str, typing.Any]
    """

    show_expanded: bool
    """ F-Curve Modifier's panel is expanded in UI

    :type: bool
    """

    type: typing.Any
    """ F-Curve Modifier Type

    :type: typing.Any
    """

    use_influence: bool
    """ F-Curve Modifier's effects will be tempered by a default factor

    :type: bool
    """

    use_restricted_range: bool
    """ F-Curve Modifier is only applied for the specified frame range to help mask off effects in order to chain them

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FModifierEnvelopeControlPoint(bpy_struct):
    """Control point for envelope F-Modifier"""

    frame: float
    """ Frame this control-point occurs on

    :type: float
    """

    max: float
    """ Upper bound of envelope at this control-point

    :type: float
    """

    min: float
    """ Lower bound of envelope at this control-point

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FModifierEnvelopeControlPoints(bpy_struct):
    """Control points defining the shape of the envelope"""

    def add(self, frame: typing.Optional[float]) -> "FModifierEnvelopeControlPoint":
        """Add a control point to a FModifierEnvelope

        :param frame: Frame to add this control-point
        :type frame: typing.Optional[float]
        :rtype: 'FModifierEnvelopeControlPoint'
        :return: Newly created control-point
        """
        ...

    def remove(self, point: "FModifierEnvelopeControlPoint"):
        """Remove a control-point from an FModifierEnvelope

        :param point: Control-point to remove
        :type point: 'FModifierEnvelopeControlPoint'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FieldSettings(bpy_struct):
    """Field settings for an object in physics simulation"""

    apply_to_location: bool
    """ Affect particle's location

    :type: bool
    """

    apply_to_rotation: bool
    """ Affect particle's dynamic rotation

    :type: bool
    """

    distance_max: float
    """ Maximum distance for the field to work

    :type: float
    """

    distance_min: float
    """ Minimum distance for the field's falloff

    :type: float
    """

    falloff_power: float
    """ How quickly strength falls off with distance from the force field

    :type: float
    """

    falloff_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    flow: float
    """ Convert effector force into air flow velocity

    :type: float
    """

    guide_clump_amount: float
    """ Amount of clumping

    :type: float
    """

    guide_clump_shape: float
    """ Shape of clumping

    :type: float
    """

    guide_free: float
    """ Guide-free time from particle life's end

    :type: float
    """

    guide_kink_amplitude: float
    """ The amplitude of the offset

    :type: float
    """

    guide_kink_axis: typing.Union[int, str]
    """ Which axis to use for offset

    :type: typing.Union[int, str]
    """

    guide_kink_frequency: float
    """ The frequency of the offset (1/total length)

    :type: float
    """

    guide_kink_shape: float
    """ Adjust the offset to the beginning/end

    :type: float
    """

    guide_kink_type: typing.Union[int, str]
    """ Type of periodic offset on the curve

    :type: typing.Union[int, str]
    """

    guide_minimum: float
    """ The distance from which particles are affected fully

    :type: float
    """

    harmonic_damping: float
    """ Damping of the harmonic force

    :type: float
    """

    inflow: float
    """ Inwards component of the vortex force

    :type: float
    """

    linear_drag: float
    """ Drag component proportional to velocity

    :type: float
    """

    noise: float
    """ Amount of noise for the force strength

    :type: float
    """

    quadratic_drag: float
    """ Drag component proportional to the square of velocity

    :type: float
    """

    radial_falloff: float
    """ Radial falloff power (real gravitational falloff = 2)

    :type: float
    """

    radial_max: float
    """ Maximum radial distance for the field to work

    :type: float
    """

    radial_min: float
    """ Minimum radial distance for the field's falloff

    :type: float
    """

    rest_length: float
    """ Rest length of the harmonic force

    :type: float
    """

    seed: int
    """ Seed of the noise

    :type: int
    """

    shape: typing.Union[int, str]
    """ Which direction is used to calculate the effector force

    :type: typing.Union[int, str]
    """

    size: float
    """ Size of the turbulence

    :type: float
    """

    source_object: "Object"
    """ Select domain object of the smoke simulation

    :type: 'Object'
    """

    strength: float
    """ Strength of force field

    :type: float
    """

    texture: "Texture"
    """ Texture to use as force

    :type: 'Texture'
    """

    texture_mode: typing.Union[int, str]
    """ How the texture effect is calculated (RGB and Curl need a RGB texture, else Gradient will be used instead)

    :type: typing.Union[int, str]
    """

    texture_nabla: float
    """ Defines size of derivative offset used for calculating gradient and curl

    :type: float
    """

    type: typing.Union[int, str]
    """ Type of field

    :type: typing.Union[int, str]
    """

    use_2d_force: bool
    """ Apply force only in 2D

    :type: bool
    """

    use_absorption: bool
    """ Force gets absorbed by collision objects

    :type: bool
    """

    use_global_coords: bool
    """ Use effector/global coordinates for turbulence

    :type: bool
    """

    use_gravity_falloff: bool
    """ Multiply force by 1/distance²

    :type: bool
    """

    use_guide_path_add: bool
    """ Based on distance/falloff it adds a portion of the entire path

    :type: bool
    """

    use_guide_path_weight: bool
    """ Use curve weights to influence the particle influence along the curve

    :type: bool
    """

    use_max_distance: bool
    """ Use a maximum distance for the field to work

    :type: bool
    """

    use_min_distance: bool
    """ Use a minimum distance for the field's falloff

    :type: bool
    """

    use_multiple_springs: bool
    """ Every point is affected by multiple springs

    :type: bool
    """

    use_object_coords: bool
    """ Use object/global coordinates for texture

    :type: bool
    """

    use_radial_max: bool
    """ Use a maximum radial distance for the field to work

    :type: bool
    """

    use_radial_min: bool
    """ Use a minimum radial distance for the field's falloff

    :type: bool
    """

    use_root_coords: bool
    """ Texture coordinates from root particle locations

    :type: bool
    """

    use_smoke_density: bool
    """ Adjust force strength based on smoke density

    :type: bool
    """

    wind_factor: float
    """ How much the force is reduced when acting parallel to a surface, e.g. cloth

    :type: float
    """

    z_direction: typing.Union[int, str]
    """ Effect in full or only positive/negative Z direction

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FileAssetSelectIDFilter(bpy_struct):
    """Which asset types to show/hide, when browsing an asset library"""

    experimental_filter_armature: bool
    """ Show Armature data-blocks

    :type: bool
    """

    experimental_filter_brush: bool
    """ Show Brushes data-blocks

    :type: bool
    """

    experimental_filter_cachefile: bool
    """ Show Cache File data-blocks

    :type: bool
    """

    experimental_filter_camera: bool
    """ Show Camera data-blocks

    :type: bool
    """

    experimental_filter_curve: bool
    """ Show Curve data-blocks

    :type: bool
    """

    experimental_filter_curves: bool
    """ Show/hide Curves data-blocks

    :type: bool
    """

    experimental_filter_font: bool
    """ Show Font data-blocks

    :type: bool
    """

    experimental_filter_grease_pencil: bool
    """ Show Grease pencil data-blocks

    :type: bool
    """

    experimental_filter_image: bool
    """ Show Image data-blocks

    :type: bool
    """

    experimental_filter_lattice: bool
    """ Show Lattice data-blocks

    :type: bool
    """

    experimental_filter_light: bool
    """ Show Light data-blocks

    :type: bool
    """

    experimental_filter_light_probe: bool
    """ Show Light Probe data-blocks

    :type: bool
    """

    experimental_filter_linestyle: bool
    """ Show Freestyle's Line Style data-blocks

    :type: bool
    """

    experimental_filter_mask: bool
    """ Show Mask data-blocks

    :type: bool
    """

    experimental_filter_mesh: bool
    """ Show Mesh data-blocks

    :type: bool
    """

    experimental_filter_metaball: bool
    """ Show Metaball data-blocks

    :type: bool
    """

    experimental_filter_movie_clip: bool
    """ Show Movie Clip data-blocks

    :type: bool
    """

    experimental_filter_paint_curve: bool
    """ Show Paint Curve data-blocks

    :type: bool
    """

    experimental_filter_palette: bool
    """ Show Palette data-blocks

    :type: bool
    """

    experimental_filter_particle_settings: bool
    """ Show Particle Settings data-blocks

    :type: bool
    """

    experimental_filter_pointcloud: bool
    """ Show/hide Point Cloud data-blocks

    :type: bool
    """

    experimental_filter_scene: bool
    """ Show Scene data-blocks

    :type: bool
    """

    experimental_filter_sound: bool
    """ Show Sound data-blocks

    :type: bool
    """

    experimental_filter_speaker: bool
    """ Show Speaker data-blocks

    :type: bool
    """

    experimental_filter_text: bool
    """ Show Text data-blocks

    :type: bool
    """

    experimental_filter_texture: bool
    """ Show Texture data-blocks

    :type: bool
    """

    experimental_filter_volume: bool
    """ Show/hide Volume data-blocks

    :type: bool
    """

    experimental_filter_work_space: bool
    """ Show workspace data-blocks

    :type: bool
    """

    filter_action: bool
    """ Show Action data-blocks

    :type: bool
    """

    filter_group: bool
    """ Show Collection data-blocks

    :type: bool
    """

    filter_material: bool
    """ Show Material data-blocks

    :type: bool
    """

    filter_node_tree: bool
    """ Show Node Tree data-blocks

    :type: bool
    """

    filter_object: bool
    """ Show Object data-blocks

    :type: bool
    """

    filter_world: bool
    """ Show World data-blocks

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FileBrowserFSMenuEntry(bpy_struct):
    """File Select Parameters"""

    icon: int
    """ 

    :type: int
    """

    is_valid: typing.Union[bool, typing.Any]
    """ Whether this path is currently reachable

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    path: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    use_save: typing.Union[bool, typing.Any]
    """ Whether this path is saved in bookmarks, or generated from OS

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FileSelectEntry(bpy_struct):
    """A file viewable in the File Browser"""

    asset_data: "AssetMetaData"
    """ Asset data, valid if the file represents an asset

    :type: 'AssetMetaData'
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    preview_icon_id: int
    """ Unique integer identifying the preview of this file as an icon (zero means invalid)

    :type: int
    """

    relative_path: typing.Union[str, typing.Any]
    """ Path relative to the directory currently displayed in the File Browser (includes the file name)

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FileSelectIDFilter(bpy_struct):
    """Which ID types to show/hide, when browsing a library"""

    category_animation: bool
    """ Show animation data

    :type: bool
    """

    category_environment: bool
    """ Show worlds, lights, cameras and speakers

    :type: bool
    """

    category_geometry: bool
    """ Show meshes, curves, lattice, armatures and metaballs data

    :type: bool
    """

    category_image: bool
    """ Show images, movie clips, sounds and masks

    :type: bool
    """

    category_misc: bool
    """ Show other data types

    :type: bool
    """

    category_object: bool
    """ Show objects and collections

    :type: bool
    """

    category_scene: bool
    """ Show scenes

    :type: bool
    """

    category_shading: bool
    """ Show materials, node-trees, textures and Freestyle's line-styles

    :type: bool
    """

    filter_action: bool
    """ Show Action data-blocks

    :type: bool
    """

    filter_armature: bool
    """ Show Armature data-blocks

    :type: bool
    """

    filter_brush: bool
    """ Show Brushes data-blocks

    :type: bool
    """

    filter_cachefile: bool
    """ Show Cache File data-blocks

    :type: bool
    """

    filter_camera: bool
    """ Show Camera data-blocks

    :type: bool
    """

    filter_curve: bool
    """ Show Curve data-blocks

    :type: bool
    """

    filter_curves: bool
    """ Show/hide Curves data-blocks

    :type: bool
    """

    filter_font: bool
    """ Show Font data-blocks

    :type: bool
    """

    filter_grease_pencil: bool
    """ Show Grease pencil data-blocks

    :type: bool
    """

    filter_group: bool
    """ Show Collection data-blocks

    :type: bool
    """

    filter_image: bool
    """ Show Image data-blocks

    :type: bool
    """

    filter_lattice: bool
    """ Show Lattice data-blocks

    :type: bool
    """

    filter_light: bool
    """ Show Light data-blocks

    :type: bool
    """

    filter_light_probe: bool
    """ Show Light Probe data-blocks

    :type: bool
    """

    filter_linestyle: bool
    """ Show Freestyle's Line Style data-blocks

    :type: bool
    """

    filter_mask: bool
    """ Show Mask data-blocks

    :type: bool
    """

    filter_material: bool
    """ Show Material data-blocks

    :type: bool
    """

    filter_mesh: bool
    """ Show Mesh data-blocks

    :type: bool
    """

    filter_metaball: bool
    """ Show Metaball data-blocks

    :type: bool
    """

    filter_movie_clip: bool
    """ Show Movie Clip data-blocks

    :type: bool
    """

    filter_node_tree: bool
    """ Show Node Tree data-blocks

    :type: bool
    """

    filter_object: bool
    """ Show Object data-blocks

    :type: bool
    """

    filter_paint_curve: bool
    """ Show Paint Curve data-blocks

    :type: bool
    """

    filter_palette: bool
    """ Show Palette data-blocks

    :type: bool
    """

    filter_particle_settings: bool
    """ Show Particle Settings data-blocks

    :type: bool
    """

    filter_pointcloud: bool
    """ Show/hide Point Cloud data-blocks

    :type: bool
    """

    filter_scene: bool
    """ Show Scene data-blocks

    :type: bool
    """

    filter_sound: bool
    """ Show Sound data-blocks

    :type: bool
    """

    filter_speaker: bool
    """ Show Speaker data-blocks

    :type: bool
    """

    filter_text: bool
    """ Show Text data-blocks

    :type: bool
    """

    filter_texture: bool
    """ Show Texture data-blocks

    :type: bool
    """

    filter_volume: bool
    """ Show/hide Volume data-blocks

    :type: bool
    """

    filter_work_space: bool
    """ Show workspace data-blocks

    :type: bool
    """

    filter_world: bool
    """ Show World data-blocks

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FileSelectParams(bpy_struct):
    """File Select Parameters"""

    directory: typing.Union[str, typing.Any]
    """ Directory displayed in the file browser

    :type: typing.Union[str, typing.Any]
    """

    display_size: int
    """ Change the size of thumbnails

    :type: int
    """

    display_size_discrete: typing.Union[int, str]
    """ Change the size of thumbnails in discrete steps

    :type: typing.Union[int, str]
    """

    display_type: typing.Union[int, str]
    """ Display mode for the file list

    :type: typing.Union[int, str]
    """

    filename: typing.Union[str, typing.Any]
    """ Active file in the file browser

    :type: typing.Union[str, typing.Any]
    """

    filter_glob: typing.Union[str, typing.Any]
    """ UNIX shell-like filename patterns matching, supports wildcards ('*') and list of patterns separated by ';'

    :type: typing.Union[str, typing.Any]
    """

    filter_id: "FileSelectIDFilter"
    """ Which ID types to show/hide, when browsing a library

    :type: 'FileSelectIDFilter'
    """

    filter_search: typing.Union[str, typing.Any]
    """ Filter by name or tag, supports '*' wildcard

    :type: typing.Union[str, typing.Any]
    """

    recursion_level: typing.Union[int, str]
    """ Numbers of dirtree levels to show simultaneously

    :type: typing.Union[int, str]
    """

    show_details_datetime: bool
    """ Show a column listing the date and time of modification for each file

    :type: bool
    """

    show_details_size: bool
    """ Show a column listing the size of each file

    :type: bool
    """

    show_hidden: bool
    """ Show hidden dot files

    :type: bool
    """

    sort_method: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    title: typing.Union[str, typing.Any]
    """ Title for the file browser

    :type: typing.Union[str, typing.Any]
    """

    use_filter: bool
    """ Enable filtering of files

    :type: bool
    """

    use_filter_asset_only: bool
    """ Hide .blend files items that are not data-blocks with asset metadata

    :type: bool
    """

    use_filter_backup: bool
    """ Show .blend1, .blend2, etc. files

    :type: bool
    """

    use_filter_blender: bool
    """ Show .blend files

    :type: bool
    """

    use_filter_blendid: bool
    """ Show .blend files items (objects, materials, etc.)

    :type: bool
    """

    use_filter_folder: bool
    """ Show folders

    :type: bool
    """

    use_filter_font: bool
    """ Show font files

    :type: bool
    """

    use_filter_image: bool
    """ Show image files

    :type: bool
    """

    use_filter_movie: bool
    """ Show movie files

    :type: bool
    """

    use_filter_script: bool
    """ Show script files

    :type: bool
    """

    use_filter_sound: bool
    """ Show sound files

    :type: bool
    """

    use_filter_text: bool
    """ Show text files

    :type: bool
    """

    use_filter_volume: bool
    """ Show 3D volume files

    :type: bool
    """

    use_library_browsing: typing.Union[bool, typing.Any]
    """ Whether we may browse Blender files' content or not

    :type: typing.Union[bool, typing.Any]
    """

    use_sort_invert: bool
    """ Sort items descending, from highest value to lowest

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Float2AttributeValue(bpy_struct):
    """2D Vector value in geometry attribute"""

    vector: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ 2D vector

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Float4x4AttributeValue(bpy_struct):
    """Matrix value in geometry attribute"""

    value: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FloatAttributeValue(bpy_struct):
    """Floating-point value in geometry attribute"""

    value: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FloatColorAttributeValue(bpy_struct):
    """Color value in geometry attribute"""

    color: bpy_prop_array[float]
    """ RGBA color in scene linear color space

    :type: bpy_prop_array[float]
    """

    color_srgb: bpy_prop_array[float]
    """ RGBA color in sRGB color space

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FloatVectorAttributeValue(bpy_struct):
    """Vector value in geometry attribute"""

    vector: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 3D vector

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FloatVectorValueReadOnly(bpy_struct):
    vector: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 3D vector

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FluidDomainSettings(bpy_struct):
    """Fluid domain settings"""

    adapt_margin: int
    """ Margin added around fluid to minimize boundary interference

    :type: int
    """

    adapt_threshold: float
    """ Minimum amount of fluid a cell can contain before it is considered empty

    :type: float
    """

    additional_res: int
    """ Maximum number of additional cells

    :type: int
    """

    alpha: float
    """ Buoyant force based on smoke density (higher value results in faster rising smoke)

    :type: float
    """

    beta: float
    """ Buoyant force based on smoke heat (higher value results in faster rising smoke)

    :type: float
    """

    burning_rate: float
    """ Speed of the burning reaction (higher value results in smaller flames)

    :type: float
    """

    cache_data_format: typing.Union[int, str]
    """ Select the file format to be used for caching volumetric data

    :type: typing.Union[int, str]
    """

    cache_directory: typing.Union[str, typing.Any]
    """ Directory that contains fluid cache files

    :type: typing.Union[str, typing.Any]
    """

    cache_frame_end: int
    """ Frame on which the simulation stops. This is the last frame that will be baked

    :type: int
    """

    cache_frame_offset: int
    """ Frame offset that is used when loading the simulation from the cache. It is not considered when baking the simulation, only when loading it

    :type: int
    """

    cache_frame_pause_data: int
    """ 

    :type: int
    """

    cache_frame_pause_guide: int
    """ 

    :type: int
    """

    cache_frame_pause_mesh: int
    """ 

    :type: int
    """

    cache_frame_pause_noise: int
    """ 

    :type: int
    """

    cache_frame_pause_particles: int
    """ 

    :type: int
    """

    cache_frame_start: int
    """ Frame on which the simulation starts. This is the first frame that will be baked

    :type: int
    """

    cache_mesh_format: typing.Union[int, str]
    """ Select the file format to be used for caching surface data

    :type: typing.Union[int, str]
    """

    cache_noise_format: typing.Union[int, str]
    """ Select the file format to be used for caching noise data

    :type: typing.Union[int, str]
    """

    cache_particle_format: typing.Union[int, str]
    """ Select the file format to be used for caching particle data

    :type: typing.Union[int, str]
    """

    cache_resumable: bool
    """ Additional data will be saved so that the bake jobs can be resumed after pausing. Because more data will be written to disk it is recommended to avoid enabling this option when baking at high resolutions

    :type: bool
    """

    cache_type: typing.Union[int, str]
    """ Change the cache type of the simulation

    :type: typing.Union[int, str]
    """

    cell_size: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Cell Size

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    cfl_condition: float
    """ Maximal velocity per cell (greater CFL numbers will minimize the number of simulation steps and the computation time.)

    :type: float
    """

    clipping: float
    """ Value under which voxels are considered empty space to optimize rendering

    :type: float
    """

    color_grid: bpy_prop_array[float]
    """ Smoke color grid

    :type: bpy_prop_array[float]
    """

    color_ramp: "ColorRamp"
    """ 

    :type: 'ColorRamp'
    """

    color_ramp_field: typing.Union[int, str]
    """ Simulation field to color map

    :type: typing.Union[int, str]
    """

    color_ramp_field_scale: float
    """ Multiplier for scaling the selected field to color map

    :type: float
    """

    delete_in_obstacle: bool
    """ Delete fluid inside obstacles

    :type: bool
    """

    density_grid: bpy_prop_array[float]
    """ Smoke density grid

    :type: bpy_prop_array[float]
    """

    display_interpolation: typing.Union[int, str]
    """ Interpolation method to use for smoke/fire volumes in solid mode

    :type: typing.Union[int, str]
    """

    display_thickness: float
    """ Thickness of smoke display in the viewport

    :type: float
    """

    dissolve_speed: int
    """ Determine how quickly the smoke dissolves (lower value makes smoke disappear faster)

    :type: int
    """

    domain_resolution: bpy_prop_array[int]
    """ Smoke Grid Resolution

    :type: bpy_prop_array[int]
    """

    domain_type: typing.Union[int, str]
    """ Change domain type of the simulation

    :type: typing.Union[int, str]
    """

    effector_group: "Collection"
    """ Limit effectors to this collection

    :type: 'Collection'
    """

    effector_weights: "EffectorWeights"
    """ 

    :type: 'EffectorWeights'
    """

    export_manta_script: bool
    """ Generate and export Mantaflow script from current domain settings during bake. This is only needed if you plan to analyze the cache (e.g. view grids, velocity vectors, particles) in Mantaflow directly (outside of Blender) after baking the simulation

    :type: bool
    """

    flame_grid: bpy_prop_array[float]
    """ Smoke flame grid

    :type: bpy_prop_array[float]
    """

    flame_ignition: float
    """ Minimum temperature of the flames (higher value results in faster rising flames)

    :type: float
    """

    flame_max_temp: float
    """ Maximum temperature of the flames (higher value results in faster rising flames)

    :type: float
    """

    flame_smoke: float
    """ Amount of smoke created by burning fuel

    :type: float
    """

    flame_smoke_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of smoke emitted from burning fuel

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    flame_vorticity: float
    """ Additional vorticity for the flames

    :type: float
    """

    flip_ratio: float
    """ PIC/FLIP Ratio. A value of 1.0 will result in a completely FLIP based simulation. Use a lower value for simulations which should produce smaller splashes

    :type: float
    """

    fluid_group: "Collection"
    """ Limit fluid objects to this collection

    :type: 'Collection'
    """

    force_collection: "Collection"
    """ Limit forces to this collection

    :type: 'Collection'
    """

    fractions_distance: float
    """ Determines how far apart fluid and obstacle are (higher values will result in fluid being further away from obstacles, smaller values will let fluid move towards the inside of obstacles)

    :type: float
    """

    fractions_threshold: float
    """ Determines how much fluid is allowed in an obstacle cell (higher values will tag a boundary cell as an obstacle easier and reduce the boundary smoothening effect)

    :type: float
    """

    gravity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Gravity in X, Y and Z direction

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    gridlines_cell_filter: typing.Union[int, str]
    """ Cell type to be highlighted

    :type: typing.Union[int, str]
    """

    gridlines_color_field: typing.Union[int, str]
    """ Simulation field to color map onto gridlines

    :type: typing.Union[int, str]
    """

    gridlines_lower_bound: float
    """ Lower bound of the highlighting range

    :type: float
    """

    gridlines_range_color: bpy_prop_array[float]
    """ Color used to highlight the range

    :type: bpy_prop_array[float]
    """

    gridlines_upper_bound: float
    """ Upper bound of the highlighting range

    :type: float
    """

    guide_alpha: float
    """ Guiding weight (higher value results in greater lag)

    :type: float
    """

    guide_beta: int
    """ Guiding size (higher value results in larger vortices)

    :type: int
    """

    guide_parent: "Object"
    """ Use velocities from this object for the guiding effect (object needs to have fluid modifier and be of type domain))

    :type: 'Object'
    """

    guide_source: typing.Union[int, str]
    """ Choose where to get guiding velocities from

    :type: typing.Union[int, str]
    """

    guide_vel_factor: float
    """ Guiding velocity factor (higher value results in greater guiding velocities)

    :type: float
    """

    has_cache_baked_any: bool
    """ 

    :type: bool
    """

    has_cache_baked_data: bool
    """ 

    :type: bool
    """

    has_cache_baked_guide: bool
    """ 

    :type: bool
    """

    has_cache_baked_mesh: bool
    """ 

    :type: bool
    """

    has_cache_baked_noise: bool
    """ 

    :type: bool
    """

    has_cache_baked_particles: bool
    """ 

    :type: bool
    """

    heat_grid: bpy_prop_array[float]
    """ Smoke heat grid

    :type: bpy_prop_array[float]
    """

    highres_sampling: typing.Union[int, str]
    """ Method for sampling the high resolution flow

    :type: typing.Union[int, str]
    """

    is_cache_baking_any: bool
    """ 

    :type: bool
    """

    is_cache_baking_data: bool
    """ 

    :type: bool
    """

    is_cache_baking_guide: bool
    """ 

    :type: bool
    """

    is_cache_baking_mesh: bool
    """ 

    :type: bool
    """

    is_cache_baking_noise: bool
    """ 

    :type: bool
    """

    is_cache_baking_particles: bool
    """ 

    :type: bool
    """

    mesh_concave_lower: float
    """ Lower mesh concavity bound (high values tend to smoothen and fill out concave regions)

    :type: float
    """

    mesh_concave_upper: float
    """ Upper mesh concavity bound (high values tend to smoothen and fill out concave regions)

    :type: float
    """

    mesh_generator: typing.Union[int, str]
    """ Which particle level set generator to use

    :type: typing.Union[int, str]
    """

    mesh_particle_radius: float
    """ Particle radius factor (higher value results in larger (meshed) particles). Needs to be adjusted after changing the mesh scale

    :type: float
    """

    mesh_scale: int
    """ The mesh simulation is scaled up by this factor (compared to the base resolution of the domain). For best meshing, it is recommended to adjust the mesh particle radius alongside this value

    :type: int
    """

    mesh_smoothen_neg: int
    """ Negative mesh smoothening

    :type: int
    """

    mesh_smoothen_pos: int
    """ Positive mesh smoothening

    :type: int
    """

    noise_pos_scale: float
    """ Scale of noise (higher value results in larger vortices)

    :type: float
    """

    noise_scale: int
    """ The noise simulation is scaled up by this factor (compared to the base resolution of the domain)

    :type: int
    """

    noise_strength: float
    """ Strength of noise

    :type: float
    """

    noise_time_anim: float
    """ Animation time of noise

    :type: float
    """

    openvdb_cache_compress_type: typing.Union[int, str]
    """ Compression method to be used

    :type: typing.Union[int, str]
    """

    openvdb_data_depth: typing.Union[int, str]
    """ Bit depth for fluid particles and grids (lower bit values reduce file size)

    :type: typing.Union[int, str]
    """

    particle_band_width: float
    """ Particle (narrow) band width (higher value results in thicker band and more particles)

    :type: float
    """

    particle_max: int
    """ Maximum number of particles per cell (ensures that each cell has at most this amount of particles)

    :type: int
    """

    particle_min: int
    """ Minimum number of particles per cell (ensures that each cell has at least this amount of particles)

    :type: int
    """

    particle_number: int
    """ Particle number factor (higher value results in more particles)

    :type: int
    """

    particle_radius: float
    """ Particle radius factor. Increase this value if the simulation appears to leak volume, decrease it if the simulation seems to gain volume

    :type: float
    """

    particle_randomness: float
    """ Randomness factor for particle sampling

    :type: float
    """

    particle_scale: int
    """ The particle simulation is scaled up by this factor (compared to the base resolution of the domain)

    :type: int
    """

    resolution_max: int
    """ Resolution used for the fluid domain. Value corresponds to the longest domain side (resolution for other domain sides is calculated automatically)

    :type: int
    """

    show_gridlines: bool
    """ Show gridlines

    :type: bool
    """

    show_velocity: bool
    """ Visualize vector fields

    :type: bool
    """

    simulation_method: typing.Union[int, str]
    """ Change the underlying simulation method

    :type: typing.Union[int, str]
    """

    slice_axis: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    slice_depth: float
    """ Position of the slice

    :type: float
    """

    slice_per_voxel: float
    """ How many slices per voxel should be generated

    :type: float
    """

    sndparticle_boundary: typing.Union[int, str]
    """ How particles that left the domain are treated

    :type: typing.Union[int, str]
    """

    sndparticle_bubble_buoyancy: float
    """ Amount of buoyancy force that rises bubbles (high value results in bubble movement mainly upwards)

    :type: float
    """

    sndparticle_bubble_drag: float
    """ Amount of drag force that moves bubbles along with the fluid (high value results in bubble movement mainly along with the fluid)

    :type: float
    """

    sndparticle_combined_export: typing.Union[int, str]
    """ Determines which particle systems are created from secondary particles

    :type: typing.Union[int, str]
    """

    sndparticle_life_max: float
    """ Highest possible particle lifetime

    :type: float
    """

    sndparticle_life_min: float
    """ Lowest possible particle lifetime

    :type: float
    """

    sndparticle_potential_max_energy: float
    """ Upper clamping threshold that indicates the fluid speed where cells no longer emit more particles (higher value results in generally less particles)

    :type: float
    """

    sndparticle_potential_max_trappedair: float
    """ Upper clamping threshold for marking fluid cells where air is trapped (higher value results in less marked cells)

    :type: float
    """

    sndparticle_potential_max_wavecrest: float
    """ Upper clamping threshold for marking fluid cells as wave crests (higher value results in less marked cells)

    :type: float
    """

    sndparticle_potential_min_energy: float
    """ Lower clamping threshold that indicates the fluid speed where cells start to emit particles (lower values result in generally more particles)

    :type: float
    """

    sndparticle_potential_min_trappedair: float
    """ Lower clamping threshold for marking fluid cells where air is trapped (lower value results in more marked cells)

    :type: float
    """

    sndparticle_potential_min_wavecrest: float
    """ Lower clamping threshold for marking fluid cells as wave crests (lower value results in more marked cells)

    :type: float
    """

    sndparticle_potential_radius: int
    """ Radius to compute potential for each cell (higher values are slower but create smoother potential grids)

    :type: int
    """

    sndparticle_sampling_trappedair: int
    """ Maximum number of particles generated per trapped air cell per frame

    :type: int
    """

    sndparticle_sampling_wavecrest: int
    """ Maximum number of particles generated per wave crest cell per frame

    :type: int
    """

    sndparticle_update_radius: int
    """ Radius to compute position update for each particle (higher values are slower but particles move less chaotic)

    :type: int
    """

    start_point: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Start point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    surface_tension: float
    """ Surface tension of liquid (higher value results in greater hydrophobic behavior)

    :type: float
    """

    sys_particle_maximum: int
    """ Maximum number of fluid particles that are allowed in this simulation

    :type: int
    """

    temperature_grid: bpy_prop_array[float]
    """ Smoke temperature grid, range 0 to 1 represents 0 to 1000K

    :type: bpy_prop_array[float]
    """

    time_scale: float
    """ Adjust simulation speed

    :type: float
    """

    timesteps_max: int
    """ Maximum number of simulation steps to perform for one frame

    :type: int
    """

    timesteps_min: int
    """ Minimum number of simulation steps to perform for one frame

    :type: int
    """

    use_adaptive_domain: bool
    """ Adapt simulation resolution and size to fluid

    :type: bool
    """

    use_adaptive_timesteps: bool
    """ 

    :type: bool
    """

    use_bubble_particles: bool
    """ Create bubble particle system

    :type: bool
    """

    use_collision_border_back: bool
    """ Enable collisions with back domain border

    :type: bool
    """

    use_collision_border_bottom: bool
    """ Enable collisions with bottom domain border

    :type: bool
    """

    use_collision_border_front: bool
    """ Enable collisions with front domain border

    :type: bool
    """

    use_collision_border_left: bool
    """ Enable collisions with left domain border

    :type: bool
    """

    use_collision_border_right: bool
    """ Enable collisions with right domain border

    :type: bool
    """

    use_collision_border_top: bool
    """ Enable collisions with top domain border

    :type: bool
    """

    use_color_ramp: bool
    """ Render a simulation field while mapping its voxels values to the colors of a ramp or using a predefined color code

    :type: bool
    """

    use_diffusion: bool
    """ Enable fluid diffusion settings (e.g. viscosity, surface tension)

    :type: bool
    """

    use_dissolve_smoke: bool
    """ Let smoke disappear over time

    :type: bool
    """

    use_dissolve_smoke_log: bool
    """ Dissolve smoke in a logarithmic fashion. Dissolves quickly at first, but lingers longer

    :type: bool
    """

    use_flip_particles: bool
    """ Create liquid particle system

    :type: bool
    """

    use_foam_particles: bool
    """ Create foam particle system

    :type: bool
    """

    use_fractions: bool
    """ Fractional obstacles improve and smoothen the fluid-obstacle boundary

    :type: bool
    """

    use_guide: bool
    """ Enable fluid guiding

    :type: bool
    """

    use_mesh: bool
    """ Enable fluid mesh (using amplification)

    :type: bool
    """

    use_noise: bool
    """ Enable fluid noise (using amplification)

    :type: bool
    """

    use_slice: bool
    """ Perform a single slice of the domain object

    :type: bool
    """

    use_speed_vectors: bool
    """ Caches velocities of mesh vertices. These will be used (automatically) when rendering with motion blur enabled

    :type: bool
    """

    use_spray_particles: bool
    """ Create spray particle system

    :type: bool
    """

    use_tracer_particles: bool
    """ Create tracer particle system

    :type: bool
    """

    use_viscosity: bool
    """ Simulate fluids with high viscosity using a special solver

    :type: bool
    """

    vector_display_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    vector_field: typing.Union[int, str]
    """ Vector field to be represented by the display vectors

    :type: typing.Union[int, str]
    """

    vector_scale: float
    """ Multiplier for scaling the vectors

    :type: float
    """

    vector_scale_with_magnitude: bool
    """ Scale vectors with their magnitudes

    :type: bool
    """

    vector_show_mac_x: bool
    """ Show X-component of MAC Grid

    :type: bool
    """

    vector_show_mac_y: bool
    """ Show Y-component of MAC Grid

    :type: bool
    """

    vector_show_mac_z: bool
    """ Show Z-component of MAC Grid

    :type: bool
    """

    velocity_grid: bpy_prop_array[float]
    """ Smoke velocity grid

    :type: bpy_prop_array[float]
    """

    velocity_scale: float
    """ Factor to control the amount of motion blur

    :type: float
    """

    viscosity_base: float
    """ Viscosity setting: value that is multiplied by 10 to the power of (exponent*-1)

    :type: float
    """

    viscosity_exponent: int
    """ Negative exponent for the viscosity value (to simplify entering small values e.g. 5*10^-6)

    :type: int
    """

    viscosity_value: float
    """ Viscosity of liquid (higher values result in more viscous fluids, a value of 0 will still apply some viscosity)

    :type: float
    """

    vorticity: float
    """ Amount of turbulence and rotation in smoke

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FluidEffectorSettings(bpy_struct):
    """Smoke collision settings"""

    effector_type: typing.Union[int, str]
    """ Change type of effector in the simulation

    :type: typing.Union[int, str]
    """

    guide_mode: typing.Union[int, str]
    """ How to create guiding velocities

    :type: typing.Union[int, str]
    """

    subframes: int
    """ Number of additional samples to take between frames to improve quality of fast moving effector objects

    :type: int
    """

    surface_distance: float
    """ Additional distance around mesh surface to consider as effector

    :type: float
    """

    use_effector: bool
    """ Control when to apply the effector

    :type: bool
    """

    use_plane_init: bool
    """ Treat this object as a planar, unclosed mesh

    :type: bool
    """

    velocity_factor: float
    """ Multiplier of obstacle velocity

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FluidFlowSettings(bpy_struct):
    """Fluid flow settings"""

    density: float
    """ 

    :type: float
    """

    density_vertex_group: typing.Union[str, typing.Any]
    """ Name of vertex group which determines surface emission rate

    :type: typing.Union[str, typing.Any]
    """

    flow_behavior: typing.Union[int, str]
    """ Change flow behavior in the simulation

    :type: typing.Union[int, str]
    """

    flow_source: typing.Union[int, str]
    """ Change how fluid is emitted

    :type: typing.Union[int, str]
    """

    flow_type: typing.Union[int, str]
    """ Change type of fluid in the simulation

    :type: typing.Union[int, str]
    """

    fuel_amount: float
    """ 

    :type: float
    """

    noise_texture: "Texture"
    """ Texture that controls emission strength

    :type: 'Texture'
    """

    particle_size: float
    """ Particle size in simulation cells

    :type: float
    """

    particle_system: "ParticleSystem"
    """ Particle systems emitted from the object

    :type: 'ParticleSystem'
    """

    smoke_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of smoke

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    subframes: int
    """ Number of additional samples to take between frames to improve quality of fast moving flows

    :type: int
    """

    surface_distance: float
    """ Controls fluid emission from the mesh surface (higher value results in emission further away from the mesh surface

    :type: float
    """

    temperature: float
    """ Temperature difference to ambient temperature

    :type: float
    """

    texture_map_type: typing.Union[int, str]
    """ Texture mapping type

    :type: typing.Union[int, str]
    """

    texture_offset: float
    """ Z-offset of texture mapping

    :type: float
    """

    texture_size: float
    """ Size of texture mapping

    :type: float
    """

    use_absolute: bool
    """ Only allow given density value in emitter area and will not add up

    :type: bool
    """

    use_inflow: bool
    """ Control when to apply fluid flow

    :type: bool
    """

    use_initial_velocity: bool
    """ Fluid has some initial velocity when it is emitted

    :type: bool
    """

    use_particle_size: bool
    """ Set particle size in simulation cells or use nearest cell

    :type: bool
    """

    use_plane_init: bool
    """ Treat this object as a planar and unclosed mesh. Fluid will only be emitted from the mesh surface and based on the surface emission value

    :type: bool
    """

    use_texture: bool
    """ Use a texture to control emission strength

    :type: bool
    """

    uv_layer: typing.Union[str, typing.Any]
    """ UV map name

    :type: typing.Union[str, typing.Any]
    """

    velocity_coord: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Additional initial velocity in X, Y and Z direction (added to source velocity)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    velocity_factor: float
    """ Multiplier of source velocity passed to fluid (source velocity is non-zero only if object is moving)

    :type: float
    """

    velocity_normal: float
    """ Amount of normal directional velocity

    :type: float
    """

    velocity_random: float
    """ Amount of random velocity

    :type: float
    """

    volume_density: float
    """ Controls fluid emission from within the mesh (higher value results in greater emissions from inside the mesh)

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FreestyleLineSet(bpy_struct):
    """Line set for associating lines and style parameters"""

    collection: "Collection"
    """ A collection of objects based on which feature edges are selected

    :type: 'Collection'
    """

    collection_negation: typing.Union[int, str]
    """ Specify either inclusion or exclusion of feature edges belonging to a collection of objects

    :type: typing.Union[int, str]
    """

    edge_type_combination: typing.Union[int, str]
    """ Specify a logical combination of selection conditions on feature edge types

    :type: typing.Union[int, str]
    """

    edge_type_negation: typing.Union[int, str]
    """ Specify either inclusion or exclusion of feature edges selected by edge types

    :type: typing.Union[int, str]
    """

    exclude_border: bool
    """ Exclude border edges

    :type: bool
    """

    exclude_contour: bool
    """ Exclude contours

    :type: bool
    """

    exclude_crease: bool
    """ Exclude crease edges

    :type: bool
    """

    exclude_edge_mark: bool
    """ Exclude edge marks

    :type: bool
    """

    exclude_external_contour: bool
    """ Exclude external contours

    :type: bool
    """

    exclude_material_boundary: bool
    """ Exclude edges at material boundaries

    :type: bool
    """

    exclude_ridge_valley: bool
    """ Exclude ridges and valleys

    :type: bool
    """

    exclude_silhouette: bool
    """ Exclude silhouette edges

    :type: bool
    """

    exclude_suggestive_contour: bool
    """ Exclude suggestive contours

    :type: bool
    """

    face_mark_condition: typing.Union[int, str]
    """ Specify a feature edge selection condition based on face marks

    :type: typing.Union[int, str]
    """

    face_mark_negation: typing.Union[int, str]
    """ Specify either inclusion or exclusion of feature edges selected by face marks

    :type: typing.Union[int, str]
    """

    linestyle: "FreestyleLineStyle"
    """ Line style settings

    :type: 'FreestyleLineStyle'
    """

    name: typing.Union[str, typing.Any]
    """ Line set name

    :type: typing.Union[str, typing.Any]
    """

    qi_end: int
    """ Last QI value of the QI range

    :type: int
    """

    qi_start: int
    """ First QI value of the QI range

    :type: int
    """

    select_border: bool
    """ Select border edges (open mesh edges)

    :type: bool
    """

    select_by_collection: bool
    """ Select feature edges based on a collection of objects

    :type: bool
    """

    select_by_edge_types: bool
    """ Select feature edges based on edge types

    :type: bool
    """

    select_by_face_marks: bool
    """ Select feature edges by face marks

    :type: bool
    """

    select_by_image_border: bool
    """ Select feature edges by image border (less memory consumption)

    :type: bool
    """

    select_by_visibility: bool
    """ Select feature edges based on visibility

    :type: bool
    """

    select_contour: bool
    """ Select contours (outer silhouettes of each object)

    :type: bool
    """

    select_crease: bool
    """ Select crease edges (those between two faces making an angle smaller than the Crease Angle)

    :type: bool
    """

    select_edge_mark: bool
    """ Select edge marks (edges annotated by Freestyle edge marks)

    :type: bool
    """

    select_external_contour: bool
    """ Select external contours (outer silhouettes of occluding and occluded objects)

    :type: bool
    """

    select_material_boundary: bool
    """ Select edges at material boundaries

    :type: bool
    """

    select_ridge_valley: bool
    """ Select ridges and valleys (boundary lines between convex and concave areas of surface)

    :type: bool
    """

    select_silhouette: bool
    """ Select silhouettes (edges at the boundary of visible and hidden faces)

    :type: bool
    """

    select_suggestive_contour: bool
    """ Select suggestive contours (almost silhouette/contour edges)

    :type: bool
    """

    show_render: bool
    """ Enable or disable this line set during stroke rendering

    :type: bool
    """

    visibility: typing.Union[int, str]
    """ Determine how to use visibility for feature edge selection

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FreestyleModuleSettings(bpy_struct):
    """Style module configuration for specifying a style module"""

    script: "Text"
    """ Python script to define a style module

    :type: 'Text'
    """

    use: bool
    """ Enable or disable this style module during stroke rendering

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FreestyleModules(bpy_struct):
    """A list of style modules (to be applied from top to bottom)"""

    def new(self) -> "FreestyleModuleSettings":
        """Add a style module to scene render layer Freestyle settings

        :rtype: 'FreestyleModuleSettings'
        :return: Newly created style module
        """
        ...

    def remove(self, module: "FreestyleModuleSettings"):
        """Remove a style module from scene render layer Freestyle settings

        :param module: Style module to remove
        :type module: 'FreestyleModuleSettings'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FreestyleSettings(bpy_struct):
    """Freestyle settings for a ViewLayer data-block"""

    as_render_pass: bool
    """ Renders Freestyle output to a separate pass instead of overlaying it on the Combined pass

    :type: bool
    """

    crease_angle: float
    """ Angular threshold for detecting crease edges

    :type: float
    """

    kr_derivative_epsilon: float
    """ Kr derivative epsilon for computing suggestive contours

    :type: float
    """

    linesets: bpy_prop_collection["FreestyleLineSet"]
    """ 

    :type: bpy_prop_collection['FreestyleLineSet']
    """

    mode: typing.Union[int, str]
    """ Select the Freestyle control mode

    :type: typing.Union[int, str]
    """

    modules: bpy_prop_collection["FreestyleModuleSettings"]
    """ A list of style modules (to be applied from top to bottom)

    :type: bpy_prop_collection['FreestyleModuleSettings']
    """

    sphere_radius: float
    """ Sphere radius for computing curvatures

    :type: float
    """

    use_culling: bool
    """ If enabled, out-of-view edges are ignored

    :type: bool
    """

    use_material_boundaries: bool
    """ Enable material boundaries

    :type: bool
    """

    use_ridges_and_valleys: bool
    """ Enable ridges and valleys

    :type: bool
    """

    use_smoothness: bool
    """ Take face smoothness into account in view map calculation

    :type: bool
    """

    use_suggestive_contours: bool
    """ Enable suggestive contours

    :type: bool
    """

    use_view_map_cache: bool
    """ Keep the computed view map and avoid recalculating it if mesh geometry is unchanged

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Function(bpy_struct):
    """RNA function definition"""

    description: typing.Union[str, typing.Any]
    """ Description of the Function's purpose

    :type: typing.Union[str, typing.Any]
    """

    identifier: typing.Union[str, typing.Any]
    """ Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    """

    is_registered: typing.Union[bool, typing.Any]
    """ Function is registered as callback as part of type registration

    :type: typing.Union[bool, typing.Any]
    """

    is_registered_optional: typing.Union[bool, typing.Any]
    """ Function is optionally registered as callback part of type registration

    :type: typing.Union[bool, typing.Any]
    """

    parameters: bpy_prop_collection["Property"]
    """ Parameters for the function

    :type: bpy_prop_collection['Property']
    """

    use_self: typing.Union[bool, typing.Any]
    """ Function does not pass itself as an argument (becomes a static method in Python)

    :type: typing.Union[bool, typing.Any]
    """

    use_self_type: typing.Union[bool, typing.Any]
    """ Function passes itself type as an argument (becomes a class method in Python if use_self is false)

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilEditCurve(bpy_struct):
    """Edition Curve"""

    curve_points: bpy_prop_collection["GPencilEditCurvePoint"]
    """ Curve data points

    :type: bpy_prop_collection['GPencilEditCurvePoint']
    """

    select: bool
    """ Curve is selected for viewport editing

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilEditCurvePoint(bpy_struct):
    """Bézier curve point with two handles"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Coordinates of the control point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_left: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Coordinates of the first handle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_right: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Coordinates of the second handle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    hide: bool
    """ Visibility status

    :type: bool
    """

    point_index: int
    """ Index of the corresponding grease pencil stroke point

    :type: int
    """

    pressure: float
    """ Pressure of the grease pencil stroke point

    :type: float
    """

    select_control_point: bool
    """ Control point selection status

    :type: bool
    """

    select_left_handle: bool
    """ Handle 1 selection status

    :type: bool
    """

    select_right_handle: bool
    """ Handle 2 selection status

    :type: bool
    """

    strength: float
    """ Color intensity (alpha factor) of the grease pencil stroke point

    :type: float
    """

    uv_factor: float
    """ Internal UV factor

    :type: float
    """

    uv_rotation: float
    """ Internal UV factor for dot mode

    :type: float
    """

    vertex_color: bpy_prop_array[float]
    """ Vertex color of the grease pencil stroke point

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilFrame(bpy_struct):
    """Collection of related sketches on a particular frame"""

    frame_number: int
    """ The frame on which this sketch appears

    :type: int
    """

    is_edited: bool
    """ Frame is being edited (painted on)

    :type: bool
    """

    keyframe_type: typing.Union[int, str]
    """ Type of keyframe

    :type: typing.Union[int, str]
    """

    select: bool
    """ Frame is selected for editing in the Dope Sheet

    :type: bool
    """

    strokes: bpy_prop_collection["GPencilStroke"]
    """ Freehand curves defining the sketch on this frame

    :type: bpy_prop_collection['GPencilStroke']
    """

    def clear(self):
        """Remove all the grease pencil frame data"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilFrames(bpy_struct):
    """Collection of grease pencil frames"""

    def new(
        self,
        frame_number: typing.Optional[int],
        active: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "GPencilFrame":
        """Add a new grease pencil frame

        :param frame_number: Frame Number, The frame on which this sketch appears
        :type frame_number: typing.Optional[int]
        :param active: Active
        :type active: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'GPencilFrame'
        :return: The newly created frame
        """
        ...

    def remove(self, frame: "GPencilFrame"):
        """Remove a grease pencil frame

        :param frame: Frame, The frame to remove
        :type frame: 'GPencilFrame'
        """
        ...

    def copy(self, source: "GPencilFrame") -> "GPencilFrame":
        """Copy a grease pencil frame

        :param source: Source, The source frame
        :type source: 'GPencilFrame'
        :rtype: 'GPencilFrame'
        :return: The newly copied frame
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilInterpolateSettings(bpy_struct):
    """Settings for Grease Pencil interpolation tools"""

    interpolation_curve: "CurveMapping"
    """ Custom curve to control 'sequence' interpolation between Grease Pencil frames

    :type: 'CurveMapping'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilLayer(bpy_struct):
    """Collection of related sketches"""

    active_frame: "GPencilFrame"
    """ Frame currently being displayed for this layer

    :type: 'GPencilFrame'
    """

    annotation_hide: bool
    """ Set annotation Visibility

    :type: bool
    """

    annotation_onion_after_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Base color for ghosts after the active frame

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    annotation_onion_after_range: int
    """ Maximum number of frames to show after current frame

    :type: int
    """

    annotation_onion_before_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Base color for ghosts before the active frame

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    annotation_onion_before_range: int
    """ Maximum number of frames to show before current frame

    :type: int
    """

    annotation_opacity: float
    """ Annotation Layer Opacity

    :type: float
    """

    blend_mode: typing.Union[int, str]
    """ Blend mode

    :type: typing.Union[int, str]
    """

    channel_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Custom color for animation channel in Dopesheet

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color for all strokes in this layer

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    frames: bpy_prop_collection["GPencilFrame"]
    """ Sketches for this layer on different frames

    :type: bpy_prop_collection['GPencilFrame']
    """

    hide: bool
    """ Set layer Visibility

    :type: bool
    """

    info: typing.Union[str, typing.Any]
    """ Layer name

    :type: typing.Union[str, typing.Any]
    """

    is_parented: typing.Union[bool, typing.Any]
    """ True when the layer parent object is set

    :type: typing.Union[bool, typing.Any]
    """

    is_ruler: typing.Union[bool, typing.Any]
    """ This is a special ruler layer

    :type: typing.Union[bool, typing.Any]
    """

    line_change: int
    """ Thickness change to apply to current strokes (in pixels)

    :type: int
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Values for change location

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    lock: bool
    """ Protect layer from further editing and/or frame changes

    :type: bool
    """

    lock_frame: bool
    """ Lock current frame displayed by layer

    :type: bool
    """

    lock_material: bool
    """ Avoids editing locked materials in the layer

    :type: bool
    """

    mask_layers: bpy_prop_collection["GPencilLayerMask"]
    """ List of Masking Layers

    :type: bpy_prop_collection['GPencilLayerMask']
    """

    matrix_inverse: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Parent inverse transformation matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_inverse_layer: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Local Layer transformation inverse matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_layer: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Local Layer transformation matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    opacity: float
    """ Layer Opacity

    :type: float
    """

    parent: "Object"
    """ Parent object

    :type: 'Object'
    """

    parent_bone: typing.Union[str, typing.Any]
    """ Name of parent bone in case of a bone parenting relation

    :type: typing.Union[str, typing.Any]
    """

    parent_type: typing.Union[int, str]
    """ Type of parent relation

    :type: typing.Union[int, str]
    """

    pass_index: int
    """ Index number for the "Layer Index" pass

    :type: int
    """

    rotation: typing.Union[
        "mathutils.Euler", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Values for changes in rotation

    :type: typing.Union['mathutils.Euler', typing.List[float], typing.Tuple[float, float, float]]
    """

    scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Values for changes in scale

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    select: bool
    """ Layer is selected for editing in the Dope Sheet

    :type: bool
    """

    show_in_front: bool
    """ Make the layer display in front of objects

    :type: bool
    """

    show_points: bool
    """ Show the points which make up the strokes (for debugging purposes)

    :type: bool
    """

    thickness: int
    """ Thickness of annotation strokes

    :type: int
    """

    tint_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color for tinting stroke colors

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    tint_factor: float
    """ Factor of tinting color

    :type: float
    """

    use_annotation_onion_skinning: bool
    """ Display annotation onion skins before and after the current frame

    :type: bool
    """

    use_lights: bool
    """ Enable the use of lights on stroke and fill materials

    :type: bool
    """

    use_mask_layer: bool
    """ The visibility of drawings on this layer is affected by the layers in its masks list

    :type: bool
    """

    use_onion_skinning: bool
    """ Display onion skins before and after the current frame

    :type: bool
    """

    use_solo_mode: bool
    """ In Draw Mode only display layers with keyframe in current frame

    :type: bool
    """

    use_viewlayer_masks: bool
    """ Include the mask layers when rendering the view-layer

    :type: bool
    """

    vertex_paint_opacity: float
    """ Vertex Paint mix factor

    :type: float
    """

    viewlayer_render: typing.Union[str, typing.Any]
    """ Only include Layer in this View Layer render output (leave blank to include always)

    :type: typing.Union[str, typing.Any]
    """

    def clear(self):
        """Remove all the grease pencil layer data"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilLayerMask(bpy_struct):
    """List of Mask Layers"""

    hide: bool
    """ Set mask Visibility

    :type: bool
    """

    invert: bool
    """ Invert mask

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Mask layer name

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilSculptGuide(bpy_struct):
    """Guides for drawing"""

    angle: float
    """ Direction of lines

    :type: float
    """

    angle_snap: float
    """ Angle snapping

    :type: float
    """

    location: bpy_prop_array[float]
    """ Custom reference point for guides

    :type: bpy_prop_array[float]
    """

    reference_object: "Object"
    """ Object used for reference point

    :type: 'Object'
    """

    reference_point: typing.Union[int, str]
    """ Type of speed guide

    :type: typing.Union[int, str]
    """

    spacing: float
    """ Guide spacing

    :type: float
    """

    type: typing.Union[int, str]
    """ Type of speed guide

    :type: typing.Union[int, str]
    """

    use_guide: bool
    """ Enable speed guides

    :type: bool
    """

    use_snapping: bool
    """ Enable snapping to guides angle or spacing options

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilSculptSettings(bpy_struct):
    """General properties for Grease Pencil stroke sculpting tools"""

    guide: "GPencilSculptGuide"
    """ 

    :type: 'GPencilSculptGuide'
    """

    intersection_threshold: float
    """ Threshold for stroke intersections

    :type: float
    """

    lock_axis: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    multiframe_falloff_curve: "CurveMapping"
    """ Custom curve to control falloff of brush effect by Grease Pencil frames

    :type: 'CurveMapping'
    """

    thickness_primitive_curve: "CurveMapping"
    """ Custom curve to control primitive thickness

    :type: 'CurveMapping'
    """

    use_automasking_layer_active: bool
    """ Affect only the Active Layer

    :type: bool
    """

    use_automasking_layer_stroke: bool
    """ Affect only strokes below the cursor

    :type: bool
    """

    use_automasking_material_active: bool
    """ Affect only the Active Material

    :type: bool
    """

    use_automasking_material_stroke: bool
    """ Affect only strokes below the cursor

    :type: bool
    """

    use_automasking_stroke: bool
    """ Affect only strokes below the cursor

    :type: bool
    """

    use_multiframe_falloff: bool
    """ Use falloff effect when edit in multiframe mode to compute brush effect by frame

    :type: bool
    """

    use_scale_thickness: bool
    """ Scale the stroke thickness when transforming strokes

    :type: bool
    """

    use_thickness_curve: bool
    """ Use curve to define primitive stroke thickness

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilStroke(bpy_struct):
    """Freehand curve defining part of a sketch"""

    aspect: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    bound_box_max: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bound_box_min: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    display_mode: typing.Union[int, str]
    """ Coordinate space that stroke is in

    :type: typing.Union[int, str]
    """

    edit_curve: "GPencilEditCurve"
    """ Temporary data for Edit Curve

    :type: 'GPencilEditCurve'
    """

    end_cap_mode: typing.Union[int, str]
    """ Stroke end extreme cap style

    :type: typing.Union[int, str]
    """

    hardness: float
    """ Amount of gradient along section of stroke

    :type: float
    """

    has_edit_curve: typing.Union[bool, typing.Any]
    """ Stroke has Curve data to edit shape

    :type: typing.Union[bool, typing.Any]
    """

    is_nofill_stroke: bool
    """ Special stroke to use as boundary for filling areas

    :type: bool
    """

    line_width: int
    """ Thickness of stroke (in pixels)

    :type: int
    """

    material_index: int
    """ Material slot index of this stroke

    :type: int
    """

    points: bpy_prop_collection["GPencilStrokePoint"]
    """ Stroke data points

    :type: bpy_prop_collection['GPencilStrokePoint']
    """

    select: bool
    """ Stroke is selected for viewport editing

    :type: bool
    """

    select_index: int
    """ Index of selection used for interpolation

    :type: int
    """

    start_cap_mode: typing.Union[int, str]
    """ Stroke start extreme cap style

    :type: typing.Union[int, str]
    """

    time_start: float
    """ Initial time of the stroke

    :type: float
    """

    triangles: bpy_prop_collection["GPencilTriangle"]
    """ Triangulation data for HQ fill

    :type: bpy_prop_collection['GPencilTriangle']
    """

    use_cyclic: bool
    """ Enable cyclic drawing, closing the stroke

    :type: bool
    """

    uv_rotation: float
    """ Rotation of the UV

    :type: float
    """

    uv_scale: float
    """ Scale of the UV

    :type: float
    """

    uv_translation: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Translation of default UV position

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    vertex_color_fill: bpy_prop_array[float]
    """ Color used to mix with fill color to get final color

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilStrokePoint(bpy_struct):
    """Data point for freehand stroke curve"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    pressure: float
    """ Pressure of tablet at point when drawing it

    :type: float
    """

    select: bool
    """ Point is selected for viewport editing

    :type: bool
    """

    strength: float
    """ Color intensity (alpha factor)

    :type: float
    """

    time: float
    """ Time relative to stroke start

    :type: float
    """

    uv_factor: float
    """ Internal UV factor

    :type: float
    """

    uv_fill: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Internal UV factor for filling

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    uv_rotation: float
    """ Internal UV factor for dot mode

    :type: float
    """

    vertex_color: bpy_prop_array[float]
    """ Color used to mix with point color to get final color

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilStrokePoints(bpy_struct):
    """Collection of grease pencil stroke points"""

    def add(
        self,
        count: typing.Optional[int],
        pressure: typing.Optional[typing.Any] = 1.0,
        strength: typing.Optional[typing.Any] = 1.0,
    ):
        """Add a new grease pencil stroke point

        :param count: Number, Number of points to add to the stroke
        :type count: typing.Optional[int]
        :param pressure: Pressure, Pressure for newly created points
        :type pressure: typing.Optional[typing.Any]
        :param strength: Strength, Color intensity (alpha factor) for newly created points
        :type strength: typing.Optional[typing.Any]
        """
        ...

    def pop(self, index: typing.Optional[typing.Any] = -1):
        """Remove a grease pencil stroke point

        :param index: Index, point index
        :type index: typing.Optional[typing.Any]
        """
        ...

    def update(self):
        """Recalculate internal triangulation data"""
        ...

    def weight_get(
        self,
        vertex_group_index: typing.Optional[typing.Any] = 0,
        point_index: typing.Optional[typing.Any] = 0,
    ) -> float:
        """Get vertex group point weight

        :param vertex_group_index: Vertex Group Index, Index of Vertex Group in the array of groups
        :type vertex_group_index: typing.Optional[typing.Any]
        :param point_index: Point Index, Index of the Point in the array
        :type point_index: typing.Optional[typing.Any]
        :rtype: float
        :return: Weight, Point Weight
        """
        ...

    def weight_set(
        self,
        vertex_group_index: typing.Optional[typing.Any] = 0,
        point_index: typing.Optional[typing.Any] = 0,
        weight: typing.Optional[typing.Any] = 0.0,
    ):
        """Set vertex group point weight

        :param vertex_group_index: Vertex Group Index, Index of Vertex Group in the array of groups
        :type vertex_group_index: typing.Optional[typing.Any]
        :param point_index: Point Index, Index of the Point in the array
        :type point_index: typing.Optional[typing.Any]
        :param weight: Weight, Point Weight
        :type weight: typing.Optional[typing.Any]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilStrokes(bpy_struct):
    """Collection of grease pencil stroke"""

    def new(self) -> "GPencilStroke":
        """Add a new grease pencil stroke

        :rtype: 'GPencilStroke'
        :return: The newly created stroke
        """
        ...

    def remove(self, stroke: "GPencilStroke"):
        """Remove a grease pencil stroke

        :param stroke: Stroke, The stroke to remove
        :type stroke: 'GPencilStroke'
        """
        ...

    def close(self, stroke: "GPencilStroke"):
        """Close a grease pencil stroke adding geometry

        :param stroke: Stroke, The stroke to close
        :type stroke: 'GPencilStroke'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilTriangle(bpy_struct):
    """Triangulation data for Grease Pencil fills"""

    v1: int
    """ First triangle vertex index

    :type: int
    """

    v2: int
    """ Second triangle vertex index

    :type: int
    """

    v3: int
    """ Third triangle vertex index

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Gizmo(bpy_struct):
    """Collection of gizmos"""

    alpha: float
    """ 

    :type: float
    """

    alpha_highlight: float
    """ 

    :type: float
    """

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    color_highlight: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    group: "GizmoGroup"
    """ Gizmo group this gizmo is a member of

    :type: 'GizmoGroup'
    """

    hide: bool
    """ 

    :type: bool
    """

    hide_keymap: bool
    """ Ignore the key-map for this gizmo

    :type: bool
    """

    hide_select: bool
    """ 

    :type: bool
    """

    is_highlight: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    is_modal: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    line_width: float
    """ 

    :type: float
    """

    matrix_basis: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ 

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_offset: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ 

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_space: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ 

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_world: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ 

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    properties: "GizmoProperties"
    """ 

    :type: 'GizmoProperties'
    """

    scale_basis: float
    """ 

    :type: float
    """

    select: bool
    """ 

    :type: bool
    """

    select_bias: float
    """ Depth bias used for selection

    :type: float
    """

    use_draw_hover: bool
    """ 

    :type: bool
    """

    use_draw_modal: bool
    """ Show while dragging

    :type: bool
    """

    use_draw_offset_scale: bool
    """ Scale the offset matrix (use to apply screen-space offset)

    :type: bool
    """

    use_draw_scale: bool
    """ Use scale when calculating the matrix

    :type: bool
    """

    use_draw_value: bool
    """ Show an indicator for the current value while dragging

    :type: bool
    """

    use_event_handle_all: bool
    """ When highlighted, do not pass events through to be handled by other keymaps

    :type: bool
    """

    use_grab_cursor: bool
    """ 

    :type: bool
    """

    use_operator_tool_properties: bool
    """ Merge active tool properties on activation (does not overwrite existing)

    :type: bool
    """

    use_select_background: bool
    """ Don't write into the depth buffer

    :type: bool
    """

    use_tooltip: bool
    """ Use tooltips when hovering over this gizmo

    :type: bool
    """

    def draw(self, context: "Context"):
        """

        :param context:
        :type context: 'Context'
        """
        ...

    def draw_select(
        self, context: "Context", select_id: typing.Optional[typing.Any] = 0
    ):
        """

        :param context:
        :type context: 'Context'
        :param select_id:
        :type select_id: typing.Optional[typing.Any]
        """
        ...

    def test_select(self, context: "Context", location: typing.Any) -> int:
        """

        :param context:
        :type context: 'Context'
        :param location: Location, Region coordinates
        :type location: typing.Any
        :rtype: int
        :return: Use -1 to skip this gizmo
        """
        ...

    def modal(
        self,
        context: "Context",
        event: "Event",
        tweak: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]],
    ) -> typing.Union[typing.Set[int], typing.Set[str]]:
        """

        :param context:
        :type context: 'Context'
        :param event:
        :type event: 'Event'
        :param tweak: Tweak
        :type tweak: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]]
        :rtype: typing.Union[typing.Set[int], typing.Set[str]]
        :return: result
        """
        ...

    def setup(self): ...
    def invoke(
        self, context: "Context", event: "Event"
    ) -> typing.Union[typing.Set[int], typing.Set[str]]:
        """

        :param context:
        :type context: 'Context'
        :param event:
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[int], typing.Set[str]]
        :return: result
        """
        ...

    def exit(self, context: "Context", cancel: typing.Optional[bool]):
        """

        :param context:
        :type context: 'Context'
        :param cancel: Cancel, otherwise confirm
        :type cancel: typing.Optional[bool]
        """
        ...

    def select_refresh(self): ...
    def draw_preset_box(
        self,
        matrix: typing.Optional[
            typing.Union[
                "mathutils.Matrix",
                typing.List[typing.List[float]],
                typing.Tuple[
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                ],
            ]
        ],
        select_id: typing.Optional[typing.Any] = -1,
    ):
        """Draw a box

        :param matrix: The matrix to transform
        :type matrix: typing.Optional[typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]]
        :param select_id: ID to use when gizmo is selectable. Use -1 when not selecting
        :type select_id: typing.Optional[typing.Any]
        """
        ...

    def draw_preset_arrow(
        self,
        matrix: typing.Optional[
            typing.Union[
                "mathutils.Matrix",
                typing.List[typing.List[float]],
                typing.Tuple[
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                ],
            ]
        ],
        axis: typing.Optional[typing.Any] = "POS_Z",
        select_id: typing.Optional[typing.Any] = -1,
    ):
        """Draw a box

        :param matrix: The matrix to transform
        :type matrix: typing.Optional[typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]]
        :param axis: Arrow Orientation
        :type axis: typing.Optional[typing.Any]
        :param select_id: ID to use when gizmo is selectable. Use -1 when not selecting
        :type select_id: typing.Optional[typing.Any]
        """
        ...

    def draw_preset_circle(
        self,
        matrix: typing.Optional[
            typing.Union[
                "mathutils.Matrix",
                typing.List[typing.List[float]],
                typing.Tuple[
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                ],
            ]
        ],
        axis: typing.Optional[typing.Any] = "POS_Z",
        select_id: typing.Optional[typing.Any] = -1,
    ):
        """Draw a box

        :param matrix: The matrix to transform
        :type matrix: typing.Optional[typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]]
        :param axis: Arrow Orientation
        :type axis: typing.Optional[typing.Any]
        :param select_id: ID to use when gizmo is selectable. Use -1 when not selecting
        :type select_id: typing.Optional[typing.Any]
        """
        ...

    def target_set_prop(
        self,
        target: typing.Union[str, typing.Any],
        data: typing.Any,
        property: typing.Union[str, typing.Any],
        index: typing.Optional[typing.Any] = -1,
    ):
        """

        :param target: Target property
        :type target: typing.Union[str, typing.Any]
        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param index:
        :type index: typing.Optional[typing.Any]
        """
        ...

    def target_set_operator(
        self,
        operator: typing.Union[str, typing.Any],
        index: typing.Optional[typing.Any] = 0,
    ) -> "OperatorProperties":
        """Operator to run when activating the gizmo (overrides property targets)

        :param operator: Target operator
        :type operator: typing.Union[str, typing.Any]
        :param index: Part index
        :type index: typing.Optional[typing.Any]
        :rtype: 'OperatorProperties'
        :return: Operator properties to fill in
        """
        ...

    def target_is_valid(self, property: typing.Union[str, typing.Any]) -> bool:
        """

        :param property: Property identifier
        :type property: typing.Union[str, typing.Any]
        :rtype: bool
        """
        ...

    def draw_custom_shape(
        self,
        shape: typing.Optional[typing.Any],
        *,
        matrix: typing.Optional[
            typing.Union["mathutils.Matrix", typing.Sequence[float]]
        ] = None,
        select_id=None,
    ):
        """Draw a shape created form `Gizmo.draw_custom_shape`.

                :param shape: The cached shape to draw.
                :type shape: typing.Optional[typing.Any]
                :param *:
                :type *:
                :param matrix: 4x4 matrix, when not given `Gizmo.matrix_world` is used.
                :type matrix: typing.Optional[typing.Union['mathutils.Matrix', typing.Sequence[float]]]
                :param select_id: The selection id.
        Only use when drawing within `Gizmo.draw_select`.
                :type select_id:
        """
        ...

    def new_custom_shape(
        self, type: typing.Optional[str], verts: typing.Optional[typing.List]
    ) -> typing.Any:
        """Create a new shape that can be passed to `Gizmo.draw_custom_shape`.

        :param type: The type of shape to create in (POINTS, LINES, TRIS, LINE_STRIP).
        :type type: typing.Optional[str]
        :param verts: Coordinates.
        :type verts: typing.Optional[typing.List]
        :rtype: typing.Any
        :return: The newly created shape.
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

    def target_get_range(self, target) -> typing.Tuple:
        """Get the range for this target property.

        :param target: Target property name.
        :type target:
        :rtype: typing.Tuple
        :return: The range of this property (min, max).
        """
        ...

    def target_get_value(self, target: typing.Optional[str]) -> typing.List:
        """Get the value of this target property.

        :param target: Target property name.
        :type target: typing.Optional[str]
        :rtype: typing.List
        :return: The value of the target property.
        """
        ...

    def target_set_handler(
        self,
        target: typing.Optional[str],
        get: typing.Optional[typing.Callable],
        set: typing.Optional[typing.Callable],
        range: typing.Optional[typing.Callable] = None,
    ):
        """Assigns callbacks to a gizmos property.

        :param target: Target property name.
        :type target: typing.Optional[str]
        :param get: Function that returns the value for this property (single value or sequence).
        :type get: typing.Optional[typing.Callable]
        :param set: Function that takes a single value argument and applies it.
        :type set: typing.Optional[typing.Callable]
        :param range: Function that returns a (min, max) tuple for gizmos that use a range.
        :type range: typing.Optional[typing.Callable]
        """
        ...

    def target_set_value(self, target: typing.Optional[str]):
        """Set the value of this target property.

        :param target: Target property name.
        :type target: typing.Optional[str]
        """
        ...

class GizmoGroup(bpy_struct):
    """Storage of an operator being executed, or registered after execution"""

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Options for this operator type

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    bl_owner_id: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_region_type: typing.Union[int, str]
    """ The region where the panel is going to be used in

    :type: typing.Union[int, str]
    """

    bl_space_type: typing.Union[int, str]
    """ The space where the panel is going to be used in

    :type: typing.Union[int, str]
    """

    gizmos: bpy_prop_collection["Gizmo"]
    """ List of gizmos in the Gizmo Map

    :type: bpy_prop_collection['Gizmo']
    """

    has_reports: typing.Union[bool, typing.Any]
    """ GizmoGroup has a set of reports (warnings and errors) from last execution

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def poll(self, context: "Context") -> bool:
        """Test if the gizmo group can be called or not

        :param context:
        :type context: 'Context'
        :rtype: bool
        """
        ...

    def setup_keymap(self, keyconfig: "KeyConfig") -> "KeyMap":
        """Initialize keymaps for this gizmo group, use fallback keymap when not present

        :param keyconfig:
        :type keyconfig: 'KeyConfig'
        :rtype: 'KeyMap'
        """
        ...

    def setup(self, context: "Context"):
        """Create gizmos function for the gizmo group

        :param context:
        :type context: 'Context'
        """
        ...

    def refresh(self, context: "Context"):
        """Refresh data (called on common state changes such as selection)

        :param context:
        :type context: 'Context'
        """
        ...

    def draw_prepare(self, context: "Context"):
        """Run before each redraw

        :param context:
        :type context: 'Context'
        """
        ...

    def invoke_prepare(self, context: "Context", gizmo: "Gizmo"):
        """Run before invoke

        :param context:
        :type context: 'Context'
        :param gizmo:
        :type gizmo: 'Gizmo'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GizmoGroupProperties(bpy_struct):
    """Input properties of a Gizmo Group"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GizmoProperties(bpy_struct):
    """Input properties of a Gizmo"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Gizmos(bpy_struct):
    """Collection of gizmos"""

    def new(self, type: typing.Union[str, typing.Any]) -> "Gizmo":
        """Add gizmo

        :param type: Gizmo identifier
        :type type: typing.Union[str, typing.Any]
        :rtype: 'Gizmo'
        :return: New gizmo
        """
        ...

    def remove(self, gizmo: "Gizmo"):
        """Delete gizmo

        :param gizmo: New gizmo
        :type gizmo: 'Gizmo'
        """
        ...

    def clear(self):
        """Delete all gizmos"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GpencilModifier(bpy_struct):
    """Modifier affecting the Grease Pencil object"""

    is_override_data: typing.Union[bool, typing.Any]
    """ In a local override object, whether this modifier comes from the linked reference object, or is local to the override

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Modifier name

    :type: typing.Union[str, typing.Any]
    """

    show_expanded: bool
    """ Set modifier expanded in the user interface

    :type: bool
    """

    show_in_editmode: bool
    """ Display modifier in Edit mode

    :type: bool
    """

    show_render: bool
    """ Use modifier during render

    :type: bool
    """

    show_viewport: bool
    """ Display modifier in viewport

    :type: bool
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GpencilVertexGroupElement(bpy_struct):
    """Weight value of a vertex in a vertex group"""

    group: int
    """ 

    :type: int
    """

    weight: float
    """ Vertex Weight

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilDashModifierSegment(bpy_struct):
    """Configuration for a single dash segment"""

    dash: int
    """ The number of consecutive points from the original stroke to include in this segment

    :type: int
    """

    gap: int
    """ The number of points skipped after this segment

    :type: int
    """

    material_index: int
    """ Use this index on generated segment. -1 means using the existing material

    :type: int
    """

    name: typing.Union[str, typing.Any]
    """ Name of the dash segment

    :type: typing.Union[str, typing.Any]
    """

    opacity: float
    """ The factor to apply to the original point's opacity for the new points

    :type: float
    """

    radius: float
    """ The factor to apply to the original point's radius for the new points

    :type: float
    """

    use_cyclic: bool
    """ Enable cyclic on individual stroke dashes

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilGrid(bpy_struct):
    """Settings for grid and canvas in 3D viewport"""

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color for grid lines

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    lines: int
    """ Number of subdivisions in each side of symmetry line

    :type: int
    """

    offset: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Offset of the canvas

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Grid scale

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilLayer(bpy_struct):
    """Collection of related drawings"""

    blend_mode: typing.Union[int, str]
    """ Blend mode

    :type: typing.Union[int, str]
    """

    hide: bool
    """ Set layer visibility

    :type: bool
    """

    lock: bool
    """ Protect layer from further editing and/or frame changes

    :type: bool
    """

    mask_layers: bpy_prop_collection["GreasePencilLayerMask"]
    """ List of Masking Layers

    :type: bpy_prop_collection['GreasePencilLayerMask']
    """

    name: typing.Union[str, typing.Any]
    """ Layer name

    :type: typing.Union[str, typing.Any]
    """

    opacity: float
    """ Layer Opacity

    :type: float
    """

    parent: "Object"
    """ Parent object

    :type: 'Object'
    """

    parent_bone: typing.Union[str, typing.Any]
    """ Name of parent bone. Only used when the parent object is an armature

    :type: typing.Union[str, typing.Any]
    """

    pass_index: int
    """ Index number for the "Layer Index" pass

    :type: int
    """

    rotation: typing.Union[
        "mathutils.Euler", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Euler rotation of the layer

    :type: typing.Union['mathutils.Euler', typing.List[float], typing.Tuple[float, float, float]]
    """

    scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale of the layer

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    translation: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Translation of the layer

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    use_masks: bool
    """ The visibility of drawings on this layer is affected by the layers in its masks list

    :type: bool
    """

    use_onion_skinning: bool
    """ Display onion skins before and after the current frame

    :type: bool
    """

    viewlayer_render: typing.Union[str, typing.Any]
    """ Only include Layer in this View Layer render output (leave blank to include always)

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilLayerGroup(bpy_struct):
    """Group of Grease Pencil layers"""

    hide: bool
    """ Set layer group visibility

    :type: bool
    """

    lock: bool
    """ Protect group from further editing and/or frame changes

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Group name

    :type: typing.Union[str, typing.Any]
    """

    use_masks: bool
    """ The visibility of drawings in the layers in this group is affected by the layers in the masks lists

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilLayerMask(bpy_struct):
    """List of Mask Layers"""

    hide: bool
    """ Set mask Visibility

    :type: bool
    """

    invert: bool
    """ Invert mask

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Mask layer name

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilLayerMasks(bpy_struct):
    """Collection of grease pencil masking layers"""

    active_mask_index: int
    """ Active index in layer mask array

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilLayers(bpy_struct):
    """Collection of grease pencil layers"""

    active: "GPencilLayer"
    """ Active grease pencil layer

    :type: 'GPencilLayer'
    """

    active_index: int
    """ Index of active grease pencil layer

    :type: int
    """

    active_note: typing.Union[int, str]
    """ Note/Layer to add annotation strokes to

    :type: typing.Union[int, str]
    """

    def new(
        self,
        name: typing.Union[str, typing.Any],
        set_active: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ) -> "GPencilLayer":
        """Add a new grease pencil layer

        :param name: Name, Name of the layer
        :type name: typing.Union[str, typing.Any]
        :param set_active: Set Active, Set the newly created layer to the active layer
        :type set_active: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'GPencilLayer'
        :return: The newly created layer
        """
        ...

    def remove(self, layer: "GPencilLayer"):
        """Remove a grease pencil layer

        :param layer: The layer to remove
        :type layer: 'GPencilLayer'
        """
        ...

    def move(
        self, layer: "GPencilLayer", type: typing.Optional[typing.Union[int, str]]
    ):
        """Move a grease pencil layer in the layer stack

        :param layer: The layer to move
        :type layer: 'GPencilLayer'
        :param type: Direction of movement
        :type type: typing.Optional[typing.Union[int, str]]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilMaskLayers(bpy_struct):
    """Collection of grease pencil masking layers"""

    active_mask_index: int
    """ Active index in layer mask array

    :type: int
    """

    def add(self, layer: "GPencilLayer"):
        """Add a layer to mask list

        :param layer: Layer to add as mask
        :type layer: 'GPencilLayer'
        """
        ...

    def remove(self, mask: "GPencilLayerMask"):
        """Remove a layer from mask list

        :param mask: Mask to remove
        :type mask: 'GPencilLayerMask'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilTimeModifierSegment(bpy_struct):
    """Configuration for a single dash segment"""

    name: typing.Union[str, typing.Any]
    """ Name of the dash segment

    :type: typing.Union[str, typing.Any]
    """

    segment_end: int
    """ Last frame of the segment

    :type: int
    """

    segment_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    segment_repeat: int
    """ Number of cycle repeats

    :type: int
    """

    segment_start: int
    """ First frame of the segment

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilv3Layers(bpy_struct):
    """Collection of Grease Pencil layers"""

    active: "GreasePencilLayer"
    """ Active Grease Pencil layer

    :type: 'GreasePencilLayer'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Header(bpy_struct):
    """Editor header containing UI elements"""

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the header gets a custom ID, otherwise it takes the name of the class used to define the header; for example, if the class name is "OBJECT_HT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_HT_hello"

    :type: typing.Union[str, typing.Any]
    """

    bl_region_type: typing.Union[int, str]
    """ The region where the header is going to be used in (defaults to header region)

    :type: typing.Union[int, str]
    """

    bl_space_type: typing.Union[int, str]
    """ The space where the header is going to be used in

    :type: typing.Union[int, str]
    """

    layout: "UILayout"
    """ Structure of the header in the UI

    :type: 'UILayout'
    """

    def draw(self, context: typing.Optional["Context"]):
        """Draw UI elements into the header UI layout

        :param context:
        :type context: typing.Optional['Context']
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Histogram(bpy_struct):
    """Statistical view of the levels of color in an image"""

    mode: typing.Union[int, str]
    """ Channels to display in the histogram

    :type: typing.Union[int, str]
    """

    show_line: bool
    """ Display lines rather than filled shapes

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ID(bpy_struct):
    """Base type for data-blocks, defining a unique name, linking from other libraries and garbage collection"""

    asset_data: "AssetMetaData"
    """ Additional data for an asset data-block

    :type: 'AssetMetaData'
    """

    id_type: typing.Any
    """ Type identifier of this data-block

    :type: typing.Any
    """

    is_embedded_data: typing.Union[bool, typing.Any]
    """ This data-block is not an independent one, but is actually a sub-data of another ID (typical example: root node trees or master collections)

    :type: typing.Union[bool, typing.Any]
    """

    is_evaluated: typing.Union[bool, typing.Any]
    """ Whether this ID is runtime-only, evaluated data-block, or actual data from .blend file

    :type: typing.Union[bool, typing.Any]
    """

    is_library_indirect: typing.Union[bool, typing.Any]
    """ Is this ID block linked indirectly

    :type: typing.Union[bool, typing.Any]
    """

    is_missing: typing.Union[bool, typing.Any]
    """ This data-block is a place-holder for missing linked data (i.e. it is [an override of] a linked data that could not be found anymore)

    :type: typing.Union[bool, typing.Any]
    """

    is_runtime_data: bool
    """ This data-block is runtime data, i.e. it won't be saved in .blend file. Note that e.g. evaluated IDs are always runtime, so this value is only editable for data-blocks in Main data-base

    :type: bool
    """

    library: "Library"
    """ Library file the data-block is linked from

    :type: 'Library'
    """

    library_weak_reference: "LibraryWeakReference"
    """ Weak reference to a data-block in another library .blend file (used to re-use already appended data instead of appending new copies)

    :type: 'LibraryWeakReference'
    """

    name: typing.Union[str, typing.Any]
    """ Unique data-block ID name (within a same type and library)

    :type: typing.Union[str, typing.Any]
    """

    name_full: typing.Union[str, typing.Any]
    """ Unique data-block ID name, including library one is any

    :type: typing.Union[str, typing.Any]
    """

    original: "ID"
    """ Actual data-block from .blend file (Main database) that generated that evaluated one

    :type: 'ID'
    """

    override_library: "IDOverrideLibrary"
    """ Library override data

    :type: 'IDOverrideLibrary'
    """

    preview: "ImagePreview"
    """ Preview image and icon of this data-block (always None if not supported for this type of data)

    :type: 'ImagePreview'
    """

    session_uid: int
    """ A session-wide unique identifier for the data block that remains the same across renames and internal reallocations. It does change when reloading the file

    :type: int
    """

    tag: bool
    """ Tools can use this to tag data for their own purposes (initial state is undefined)

    :type: bool
    """

    use_extra_user: bool
    """ Indicates whether an extra user is set or not (mainly for internal/debug usages)

    :type: bool
    """

    use_fake_user: bool
    """ Save this data-block even if it has no users

    :type: bool
    """

    users: int
    """ Number of times this data-block is referenced

    :type: int
    """

    def evaluated_get(self, depsgraph: "Depsgraph") -> "ID":
        """Get corresponding evaluated ID from the given dependency graph. Note that this does not ensure the dependency graph is fully evaluated, it just returns the result of the last evaluation

        :param depsgraph: Dependency graph to perform lookup in
        :type depsgraph: 'Depsgraph'
        :rtype: 'ID'
        :return: New copy of the ID
        """
        ...

    def copy(self) -> "ID":
        """Create a copy of this data-block (not supported for all data-blocks). The result is added to the Blend-File Data (Main database), with all references to other data-blocks ensured to be from within the same Blend-File Data

        :rtype: 'ID'
        :return: New copy of the ID
        """
        ...

    def asset_mark(self):
        """Enable easier reuse of the data-block through the Asset Browser, with the help of customizable metadata (like previews, descriptions and tags)"""
        ...

    def asset_clear(self):
        """Delete all asset metadata and turn the asset data-block back into a normal data-block"""
        ...

    def asset_generate_preview(self):
        """Generate preview image (might be scheduled in a background thread)"""
        ...

    def override_create(
        self,
        remap_local_usages: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "ID":
        """Create an overridden local copy of this linked data-block (not supported for all data-blocks)

        :param remap_local_usages: Whether local usages of the linked ID should be remapped to the new library override of it
        :type remap_local_usages: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'ID'
        :return: New overridden local copy of the ID
        """
        ...

    def override_hierarchy_create(
        self,
        scene: "Scene",
        view_layer: "ViewLayer",
        reference: typing.Optional["ID"] = None,
        do_fully_editable: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "ID":
        """Create an overridden local copy of this linked data-block, and most of its dependencies when it is a Collection or and Object

        :param scene: In which scene the new overrides should be instantiated
        :type scene: 'Scene'
        :param view_layer: In which view layer the new overrides should be instantiated
        :type view_layer: 'ViewLayer'
        :param reference: Another ID (usually an Object or Collection) used as a hint to decide where to instantiate the new overrides
        :type reference: typing.Optional['ID']
        :param do_fully_editable: Make all library overrides generated by this call fully editable by the user (none will be 'system overrides')
        :type do_fully_editable: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'ID'
        :return: New overridden local copy of the root ID
        """
        ...

    def user_clear(self):
        """Clear the user count of a data-block so its not saved, on reload the data will be removedThis function is for advanced use only, misuse can crash blender since the user
        count is used to prevent data being removed when it is used.

        """
        ...

    def user_remap(self, new_id: "ID"):
        """Replace all usage in the .blend file of this ID by new given one

        :param new_id: New ID to use
        :type new_id: 'ID'
        """
        ...

    def make_local(
        self,
        clear_proxy: typing.Optional[typing.Union[bool, typing.Any]] = True,
        clear_liboverride: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "ID":
        """Make this datablock local, return local one (may be a copy of the original, in case it is also indirectly used)

        :param clear_proxy: Deprecated, has no effect
        :type clear_proxy: typing.Optional[typing.Union[bool, typing.Any]]
        :param clear_liboverride: Remove potential library override data from the newly made local data
        :type clear_liboverride: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'ID'
        :return: This ID, or the new ID if it was copied
        """
        ...

    def user_of_id(self, id: "ID") -> int:
        """Count the number of times that ID uses/references given one

        :param id: ID to count usages
        :type id: 'ID'
        :rtype: int
        :return: Number of usages/references of given id by current data-block
        """
        ...

    def animation_data_create(self) -> "AnimData":
        """Create animation data to this ID, note that not all ID types support this

        :rtype: 'AnimData'
        :return: New animation data or nullptr
        """
        ...

    def animation_data_clear(self):
        """Clear animation on this ID"""
        ...

    def update_tag(self, refresh: typing.Optional[typing.Any] = {}):
        """Tag the ID to update its display data, e.g. when calling `bpy.types.Scene.update`

        :param refresh: Type of updates to perform
        :type refresh: typing.Optional[typing.Any]
        """
        ...

    def preview_ensure(self) -> "ImagePreview":
        """Ensure that this ID has preview data (if ID type supports it)

        :rtype: 'ImagePreview'
        :return: The existing or created preview
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IDMaterials(bpy_struct):
    """Collection of materials"""

    def append(self, material: typing.Optional["Material"]):
        """Add a new material to the data-block

        :param material: Material to add
        :type material: typing.Optional['Material']
        """
        ...

    def pop(self, index: typing.Optional[typing.Any] = -1) -> "Material":
        """Remove a material from the data-block

        :param index: Index of material to remove
        :type index: typing.Optional[typing.Any]
        :rtype: 'Material'
        :return: Material to remove
        """
        ...

    def clear(self):
        """Remove all materials from the data-block"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IDOverrideLibrary(bpy_struct):
    """Struct gathering all data needed by overridden linked IDs"""

    hierarchy_root: "ID"
    """ Library override ID used as root of the override hierarchy this ID is a member of

    :type: 'ID'
    """

    is_in_hierarchy: bool
    """ Whether this library override is defined as part of a library hierarchy, or as a single, isolated and autonomous override

    :type: bool
    """

    is_system_override: bool
    """ Whether this library override exists only for the override hierarchy, or if it is actually editable by the user

    :type: bool
    """

    properties: bpy_prop_collection["IDOverrideLibraryProperty"]
    """ List of overridden properties

    :type: bpy_prop_collection['IDOverrideLibraryProperty']
    """

    reference: "ID"
    """ Linked ID used as reference by this override

    :type: 'ID'
    """

    def operations_update(self):
        """Update the library override operations based on the differences between this override ID and its reference"""
        ...

    def reset(
        self,
        do_hierarchy: typing.Optional[typing.Union[bool, typing.Any]] = True,
        set_system_override: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ):
        """Reset this override to match again its linked reference ID

        :param do_hierarchy: Also reset all the dependencies of this override to match their reference linked IDs
        :type do_hierarchy: typing.Optional[typing.Union[bool, typing.Any]]
        :param set_system_override: Reset all user-editable overrides as (non-editable) system overrides
        :type set_system_override: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def destroy(
        self, do_hierarchy: typing.Optional[typing.Union[bool, typing.Any]] = True
    ):
        """Delete this override ID and remap its usages to its linked reference ID instead

        :param do_hierarchy: Also delete all the dependencies of this override and remap their usages to their reference linked IDs
        :type do_hierarchy: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def resync(
        self,
        scene: "Scene",
        view_layer: typing.Optional["ViewLayer"] = None,
        residual_storage: typing.Optional["Collection"] = None,
        do_hierarchy_enforce: typing.Optional[typing.Union[bool, typing.Any]] = False,
        do_whole_hierarchy: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> bool:
        """Resync the data-block and its sub-hierarchy, or the whole hierarchy if requested

        :param scene: The scene to operate in (for contextual things like keeping active object active, ensuring all overridden objects remain instantiated, etc.)
        :type scene: 'Scene'
        :param view_layer: The view layer to operate in (same usage as the scene data, in case it is not provided the scene's collection will be used instead)
        :type view_layer: typing.Optional['ViewLayer']
        :param residual_storage: Collection where to store objects that are instantiated in any other collection anymore (garbage collection, will be created if needed and none is provided)
        :type residual_storage: typing.Optional['Collection']
        :param do_hierarchy_enforce: Enforce restoring the dependency hierarchy between data-blocks to match the one from the reference linked hierarchy (WARNING: if some ID pointers have been purposedly overridden, these will be reset to their default value)
        :type do_hierarchy_enforce: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_whole_hierarchy: Resync the whole hierarchy this data-block belongs to, not only its own sub-hierarchy
        :type do_whole_hierarchy: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: bool
        :return: Success, Whether the resync process was successful or not
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IDOverrideLibraryProperties(bpy_struct):
    """Collection of override properties"""

    def add(
        self, rna_path: typing.Union[str, typing.Any]
    ) -> "IDOverrideLibraryProperty":
        """Add a property to the override library when it doesn't exist yet

        :param rna_path: RNA Path, RNA-Path of the property to add
        :type rna_path: typing.Union[str, typing.Any]
        :rtype: 'IDOverrideLibraryProperty'
        :return: New Property, Newly created override property or existing one
        """
        ...

    def remove(self, property: typing.Optional["IDOverrideLibraryProperty"]):
        """Remove and delete a property

        :param property: Property, Override property to be deleted
        :type property: typing.Optional['IDOverrideLibraryProperty']
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IDOverrideLibraryProperty(bpy_struct):
    """Description of an overridden property"""

    operations: bpy_prop_collection["IDOverrideLibraryPropertyOperation"]
    """ List of overriding operations for a property

    :type: bpy_prop_collection['IDOverrideLibraryPropertyOperation']
    """

    rna_path: typing.Union[str, typing.Any]
    """ RNA path leading to that property, from owning ID

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IDOverrideLibraryPropertyOperation(bpy_struct):
    """Description of an override operation over an overridden property"""

    flag: typing.Any
    """ Status flags

    :type: typing.Any
    """

    operation: typing.Union[int, str]
    """ What override operation is performed

    :type: typing.Union[int, str]
    """

    subitem_local_id: "ID"
    """ Collection of IDs only, used to disambiguate between potential IDs with same name from different libraries

    :type: 'ID'
    """

    subitem_local_index: int
    """ Used to handle changes into collection

    :type: int
    """

    subitem_local_name: typing.Union[str, typing.Any]
    """ Used to handle changes into collection

    :type: typing.Union[str, typing.Any]
    """

    subitem_reference_id: "ID"
    """ Collection of IDs only, used to disambiguate between potential IDs with same name from different libraries

    :type: 'ID'
    """

    subitem_reference_index: int
    """ Used to handle changes into collection

    :type: int
    """

    subitem_reference_name: typing.Union[str, typing.Any]
    """ Used to handle changes into collection

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IDOverrideLibraryPropertyOperations(bpy_struct):
    """Collection of override operations"""

    def add(
        self,
        operation: typing.Optional[typing.Union[int, str]],
        use_id: typing.Optional[typing.Union[bool, typing.Any]] = False,
        subitem_reference_name: typing.Union[str, typing.Any] = "",
        subitem_local_name: typing.Union[str, typing.Any] = "",
        subitem_reference_id: typing.Optional["ID"] = None,
        subitem_local_id: typing.Optional["ID"] = None,
        subitem_reference_index: typing.Optional[typing.Any] = -1,
        subitem_local_index: typing.Optional[typing.Any] = -1,
    ) -> "IDOverrideLibraryPropertyOperation":
        """Add a new operation

                :param operation: Operation, What override operation is performed

        NOOP
        No-Op -- Does nothing, prevents adding actual overrides (NOT USED).

        REPLACE
        Replace -- Replace value of reference by overriding one.

        DIFF_ADD
        Differential -- Stores and apply difference between reference and local value (NOT USED).

        DIFF_SUB
        Differential -- Stores and apply difference between reference and local value (NOT USED).

        FACT_MULTIPLY
        Factor -- Stores and apply multiplication factor between reference and local value (NOT USED).

        INSERT_AFTER
        Insert After -- Insert a new item into collection after the one referenced in subitem_reference_name/_id or _index.

        INSERT_BEFORE
        Insert Before -- Insert a new item into collection before the one referenced in subitem_reference_name/_id or _index (NOT USED).
                :type operation: typing.Optional[typing.Union[int, str]]
                :param use_id: Use ID Pointer Subitem, Whether the found or created liboverride operation should use ID pointers or not
                :type use_id: typing.Optional[typing.Union[bool, typing.Any]]
                :param subitem_reference_name: Subitem Reference Name, Used to handle insertions or ID replacements into collection
                :type subitem_reference_name: typing.Union[str, typing.Any]
                :param subitem_local_name: Subitem Local Name, Used to handle insertions or ID replacements into collection
                :type subitem_local_name: typing.Union[str, typing.Any]
                :param subitem_reference_id: Subitem Reference ID, Used to handle ID replacements into collection
                :type subitem_reference_id: typing.Optional['ID']
                :param subitem_local_id: Subitem Local ID, Used to handle ID replacements into collection
                :type subitem_local_id: typing.Optional['ID']
                :param subitem_reference_index: Subitem Reference Index, Used to handle insertions or ID replacements into collection
                :type subitem_reference_index: typing.Optional[typing.Any]
                :param subitem_local_index: Subitem Local Index, Used to handle insertions or ID replacements into collection
                :type subitem_local_index: typing.Optional[typing.Any]
                :rtype: 'IDOverrideLibraryPropertyOperation'
                :return: New Operation, Created operation
        """
        ...

    def remove(self, operation: typing.Optional["IDOverrideLibraryPropertyOperation"]):
        """Remove and delete an operation

        :param operation: Operation, Override operation to be deleted
        :type operation: typing.Optional['IDOverrideLibraryPropertyOperation']
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IDPropertyWrapPtr(bpy_struct):
    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IKParam(bpy_struct):
    """Base type for IK solver parameters"""

    ik_solver: typing.Union[int, str]
    """ IK solver for which these parameters are defined

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ImageFormatSettings(bpy_struct):
    """Settings for image formats"""

    cineon_black: int
    """ Log conversion reference blackpoint

    :type: int
    """

    cineon_gamma: float
    """ Log conversion gamma

    :type: float
    """

    cineon_white: int
    """ Log conversion reference whitepoint

    :type: int
    """

    color_depth: typing.Union[int, str]
    """ Bit depth per channel

    :type: typing.Union[int, str]
    """

    color_management: typing.Union[int, str]
    """ Which color management settings to use for file saving

    :type: typing.Union[int, str]
    """

    color_mode: typing.Union[int, str]
    """ Choose BW for saving grayscale images, RGB for saving red, green and blue channels, and RGBA for saving red, green, blue and alpha channels

    :type: typing.Union[int, str]
    """

    compression: int
    """ Amount of time to determine best compression: 0 = no compression with fast file output, 100 = maximum lossless compression with slow file output

    :type: int
    """

    display_settings: "ColorManagedDisplaySettings"
    """ Settings of device saved image would be displayed on

    :type: 'ColorManagedDisplaySettings'
    """

    exr_codec: typing.Union[int, str]
    """ Codec settings for OpenEXR

    :type: typing.Union[int, str]
    """

    file_format: typing.Union[int, str]
    """ File format to save the rendered images as

    :type: typing.Union[int, str]
    """

    has_linear_colorspace: typing.Union[bool, typing.Any]
    """ File format expects linear color space

    :type: typing.Union[bool, typing.Any]
    """

    jpeg2k_codec: typing.Union[int, str]
    """ Codec settings for JPEG 2000

    :type: typing.Union[int, str]
    """

    linear_colorspace_settings: "ColorManagedInputColorspaceSettings"
    """ Output color space settings

    :type: 'ColorManagedInputColorspaceSettings'
    """

    quality: int
    """ Quality for image formats that support lossy compression

    :type: int
    """

    stereo_3d_format: "Stereo3dFormat"
    """ Settings for stereo 3D

    :type: 'Stereo3dFormat'
    """

    tiff_codec: typing.Union[int, str]
    """ Compression mode for TIFF

    :type: typing.Union[int, str]
    """

    use_cineon_log: bool
    """ Convert to logarithmic color space

    :type: bool
    """

    use_jpeg2k_cinema_48: bool
    """ Use OpenJPEG Cinema Preset (48fps)

    :type: bool
    """

    use_jpeg2k_cinema_preset: bool
    """ Use OpenJPEG Cinema Preset

    :type: bool
    """

    use_jpeg2k_ycc: bool
    """ Save luminance-chrominance-chrominance channels instead of RGB colors

    :type: bool
    """

    use_preview: bool
    """ When rendering animations, save JPG preview images in same directory

    :type: bool
    """

    view_settings: "ColorManagedViewSettings"
    """ Color management settings applied on image before saving

    :type: 'ColorManagedViewSettings'
    """

    views_format: typing.Union[int, str]
    """ Format of multiview media

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ImagePackedFile(bpy_struct):
    filepath: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    packed_file: "PackedFile"
    """ 

    :type: 'PackedFile'
    """

    tile_number: int
    """ 

    :type: int
    """

    view: int
    """ 

    :type: int
    """

    def save(self):
        """Save the packed file to its filepath"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ImagePreview(bpy_struct):
    """Preview image and icon"""

    icon_id: int
    """ Unique integer identifying this preview as an icon (zero means invalid)

    :type: int
    """

    icon_pixels: int
    """ Icon pixels, as bytes (always 32-bit RGBA)

    :type: int
    """

    icon_pixels_float: float
    """ Icon pixels components, as floats (RGBA concatenated values)

    :type: float
    """

    icon_size: bpy_prop_array[int]
    """ Width and height in pixels

    :type: bpy_prop_array[int]
    """

    image_pixels: int
    """ Image pixels, as bytes (always 32-bit RGBA)

    :type: int
    """

    image_pixels_float: float
    """ Image pixels components, as floats (RGBA concatenated values)

    :type: float
    """

    image_size: bpy_prop_array[int]
    """ Width and height in pixels

    :type: bpy_prop_array[int]
    """

    is_icon_custom: bool
    """ True if this preview icon has been modified by py script, and is no more auto-generated by Blender

    :type: bool
    """

    is_image_custom: bool
    """ True if this preview image has been modified by py script, and is no more auto-generated by Blender

    :type: bool
    """

    def reload(self):
        """Reload the preview from its source path"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ImageUser(bpy_struct):
    """Parameters defining how an Image data-block is used by another data-block"""

    frame_current: int
    """ Current frame number in image sequence or movie

    :type: int
    """

    frame_duration: int
    """ Number of images of a movie to use

    :type: int
    """

    frame_offset: int
    """ Offset the number of the frame to use in the animation

    :type: int
    """

    frame_start: int
    """ Global starting frame of the movie/sequence, assuming first picture has a #1

    :type: int
    """

    multilayer_layer: int
    """ Layer in multilayer image

    :type: int
    """

    multilayer_pass: int
    """ Pass in multilayer image

    :type: int
    """

    multilayer_view: int
    """ View in multilayer image

    :type: int
    """

    tile: int
    """ Tile in tiled image

    :type: int
    """

    use_auto_refresh: bool
    """ Always refresh image on frame changes

    :type: bool
    """

    use_cyclic: bool
    """ Cycle the images in the movie

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IndexSwitchItem(bpy_struct):
    identifier: int
    """ Consistent identifier used for the item

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Int2AttributeValue(bpy_struct):
    """2D value in geometry attribute"""

    value: bpy_prop_array[int]
    """ 2D vector

    :type: bpy_prop_array[int]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IntAttributeValue(bpy_struct):
    """Integer value in geometry attribute"""

    value: int
    """ 

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyConfig(bpy_struct):
    """Input configuration, including keymaps"""

    is_user_defined: typing.Union[bool, typing.Any]
    """ Indicates that a keyconfig was defined by the user

    :type: typing.Union[bool, typing.Any]
    """

    keymaps: bpy_prop_collection["KeyMap"]
    """ Key maps configured as part of this configuration

    :type: bpy_prop_collection['KeyMap']
    """

    name: typing.Union[str, typing.Any]
    """ Name of the key configuration

    :type: typing.Union[str, typing.Any]
    """

    preferences: "KeyConfigPreferences"
    """ 

    :type: 'KeyConfigPreferences'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyConfigPreferences(bpy_struct):
    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyConfigurations(bpy_struct):
    """Collection of KeyConfigs"""

    active: "KeyConfig"
    """ Active key configuration (preset)

    :type: 'KeyConfig'
    """

    addon: "KeyConfig"
    """ Key configuration that can be extended by add-ons, and is added to the active configuration when handling events

    :type: 'KeyConfig'
    """

    default: "KeyConfig"
    """ Default builtin key configuration

    :type: 'KeyConfig'
    """

    user: "KeyConfig"
    """ Final key configuration that combines keymaps from the active and add-on configurations, and can be edited by the user

    :type: 'KeyConfig'
    """

    def new(self, name: typing.Union[str, typing.Any]) -> "KeyConfig":
        """new

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'KeyConfig'
        :return: Key Configuration, Added key configuration
        """
        ...

    def remove(self, keyconfig: "KeyConfig"):
        """remove

        :param keyconfig: Key Configuration, Removed key configuration
        :type keyconfig: 'KeyConfig'
        """
        ...

    def find_item_from_operator(
        self,
        idname: typing.Union[str, typing.Any],
        context: typing.Optional[typing.Any] = "INVOKE_DEFAULT",
        properties: typing.Optional["OperatorProperties"] = None,
        include: typing.Optional[typing.Any] = {
            '"MOUSE"',
            '"ACTIONZONE"',
            '"NDOF"',
            '"KEYBOARD"',
        },
        exclude: typing.Optional[typing.Any] = {},
    ):
        """find_item_from_operator

                :param idname: Operator Identifier
                :type idname: typing.Union[str, typing.Any]
                :param context: context
                :type context: typing.Optional[typing.Any]
                :param properties:
                :type properties: typing.Optional['OperatorProperties']
                :param include: Include
                :type include: typing.Optional[typing.Any]
                :param exclude: Exclude
                :type exclude: typing.Optional[typing.Any]
                :return: keymap, `KeyMap`

        item, `KeyMapItem`
        """
        ...

    def update(
        self, keep_properties: typing.Optional[typing.Union[bool, typing.Any]] = False
    ):
        """update

        :param keep_properties: Keep Properties, Operator properties are kept to allow the operators to be registered again in the future
        :type keep_properties: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyMap(bpy_struct):
    """Input configuration, including keymaps"""

    bl_owner_id: typing.Union[str, typing.Any]
    """ Internal owner

    :type: typing.Union[str, typing.Any]
    """

    is_modal: typing.Union[bool, typing.Any]
    """ Indicates that a keymap is used for translate modal events for an operator

    :type: typing.Union[bool, typing.Any]
    """

    is_user_modified: bool
    """ Keymap is defined by the user

    :type: bool
    """

    keymap_items: bpy_prop_collection["KeyMapItem"]
    """ Items in the keymap, linking an operator to an input event

    :type: bpy_prop_collection['KeyMapItem']
    """

    modal_event_values: bpy_prop_collection["EnumPropertyItem"]
    """ Give access to the possible event values of this modal keymap's items (#KeyMapItem.propvalue), for API introspection

    :type: bpy_prop_collection['EnumPropertyItem']
    """

    name: typing.Union[str, typing.Any]
    """ Name of the key map

    :type: typing.Union[str, typing.Any]
    """

    region_type: typing.Any
    """ Optional region type keymap is associated with

    :type: typing.Any
    """

    show_expanded_children: bool
    """ Children expanded in the user interface

    :type: bool
    """

    show_expanded_items: bool
    """ Expanded in the user interface

    :type: bool
    """

    space_type: typing.Any
    """ Optional space type keymap is associated with

    :type: typing.Any
    """

    def active(self) -> "KeyMap":
        """active

        :rtype: 'KeyMap'
        :return: Key Map, Active key map
        """
        ...

    def restore_to_default(self):
        """restore_to_default"""
        ...

    def restore_item_to_default(self, item: "KeyMapItem"):
        """restore_item_to_default

        :param item: Item
        :type item: 'KeyMapItem'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyMapItem(bpy_struct):
    """Item in a Key Map"""

    active: bool
    """ Activate or deactivate item

    :type: bool
    """

    alt: int
    """ Alt key pressed, -1 for any state

    :type: int
    """

    alt_ui: bool
    """ Alt key pressed

    :type: bool
    """

    any: bool
    """ Any modifier keys pressed

    :type: bool
    """

    ctrl: int
    """ Control key pressed, -1 for any state

    :type: int
    """

    ctrl_ui: bool
    """ Control key pressed

    :type: bool
    """

    direction: typing.Union[int, str]
    """ The direction (only applies to drag events)

    :type: typing.Union[int, str]
    """

    id: int
    """ ID of the item

    :type: int
    """

    idname: typing.Union[str, typing.Any]
    """ Identifier of operator to call on input event

    :type: typing.Union[str, typing.Any]
    """

    is_user_defined: typing.Union[bool, typing.Any]
    """ Is this keymap item user defined (doesn't just replace a builtin item)

    :type: typing.Union[bool, typing.Any]
    """

    is_user_modified: typing.Union[bool, typing.Any]
    """ Is this keymap item modified by the user

    :type: typing.Union[bool, typing.Any]
    """

    key_modifier: typing.Union[int, str]
    """ Regular key pressed as a modifier

    :type: typing.Union[int, str]
    """

    map_type: typing.Union[int, str]
    """ Type of event mapping

    :type: typing.Union[int, str]
    """

    name: typing.Union[str, typing.Any]
    """ Name of operator (translated) to call on input event

    :type: typing.Union[str, typing.Any]
    """

    oskey: int
    """ Operating system key pressed, -1 for any state

    :type: int
    """

    oskey_ui: bool
    """ Operating system key pressed

    :type: bool
    """

    properties: "OperatorProperties"
    """ Properties to set when the operator is called

    :type: 'OperatorProperties'
    """

    propvalue: typing.Union[int, str]
    """ The value this event translates to in a modal keymap

    :type: typing.Union[int, str]
    """

    repeat: bool
    """ Active on key-repeat events (when a key is held)

    :type: bool
    """

    shift: int
    """ Shift key pressed, -1 for any state

    :type: int
    """

    shift_ui: bool
    """ Shift key pressed

    :type: bool
    """

    show_expanded: bool
    """ Show key map event and property details in the user interface

    :type: bool
    """

    type: typing.Union[int, str]
    """ Type of event

    :type: typing.Union[int, str]
    """

    value: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    def compare(self, item: typing.Optional["KeyMapItem"]) -> bool:
        """compare

        :param item: Item
        :type item: typing.Optional['KeyMapItem']
        :rtype: bool
        :return: Comparison result
        """
        ...

    def to_string(
        self, compact: typing.Optional[typing.Union[bool, typing.Any]] = False
    ) -> typing.Union[str, typing.Any]:
        """to_string

        :param compact: Compact
        :type compact: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: typing.Union[str, typing.Any]
        :return: result
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyMapItems(bpy_struct):
    """Collection of keymap items"""

    def new(
        self,
        idname: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
        value: typing.Optional[typing.Union[int, str]],
        any: typing.Optional[typing.Union[bool, typing.Any]] = False,
        shift: typing.Optional[typing.Any] = 0,
        ctrl: typing.Optional[typing.Any] = 0,
        alt: typing.Optional[typing.Any] = 0,
        oskey: typing.Optional[typing.Any] = 0,
        key_modifier: typing.Optional[typing.Any] = "NONE",
        direction: typing.Optional[typing.Any] = "ANY",
        repeat: typing.Optional[typing.Union[bool, typing.Any]] = False,
        head: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "KeyMapItem":
        """new

        :param idname: Operator Identifier
        :type idname: typing.Union[str, typing.Any]
        :param type: Type
        :type type: typing.Optional[typing.Union[int, str]]
        :param value: Value
        :type value: typing.Optional[typing.Union[int, str]]
        :param any: Any
        :type any: typing.Optional[typing.Union[bool, typing.Any]]
        :param shift: Shift
        :type shift: typing.Optional[typing.Any]
        :param ctrl: Ctrl
        :type ctrl: typing.Optional[typing.Any]
        :param alt: Alt
        :type alt: typing.Optional[typing.Any]
        :param oskey: OS Key
        :type oskey: typing.Optional[typing.Any]
        :param key_modifier: Key Modifier
        :type key_modifier: typing.Optional[typing.Any]
        :param direction: Direction
        :type direction: typing.Optional[typing.Any]
        :param repeat: Repeat, When set, accept key-repeat events
        :type repeat: typing.Optional[typing.Union[bool, typing.Any]]
        :param head: At Head, Force item to be added at start (not end) of key map so that it doesn't get blocked by an existing key map item
        :type head: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'KeyMapItem'
        :return: Item, Added key map item
        """
        ...

    def new_modal(
        self,
        propvalue: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
        value: typing.Optional[typing.Union[int, str]],
        any: typing.Optional[typing.Union[bool, typing.Any]] = False,
        shift: typing.Optional[typing.Any] = 0,
        ctrl: typing.Optional[typing.Any] = 0,
        alt: typing.Optional[typing.Any] = 0,
        oskey: typing.Optional[typing.Any] = 0,
        key_modifier: typing.Optional[typing.Any] = "NONE",
        direction: typing.Optional[typing.Any] = "ANY",
        repeat: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "KeyMapItem":
        """new_modal

        :param propvalue: Property Value
        :type propvalue: typing.Union[str, typing.Any]
        :param type: Type
        :type type: typing.Optional[typing.Union[int, str]]
        :param value: Value
        :type value: typing.Optional[typing.Union[int, str]]
        :param any: Any
        :type any: typing.Optional[typing.Union[bool, typing.Any]]
        :param shift: Shift
        :type shift: typing.Optional[typing.Any]
        :param ctrl: Ctrl
        :type ctrl: typing.Optional[typing.Any]
        :param alt: Alt
        :type alt: typing.Optional[typing.Any]
        :param oskey: OS Key
        :type oskey: typing.Optional[typing.Any]
        :param key_modifier: Key Modifier
        :type key_modifier: typing.Optional[typing.Any]
        :param direction: Direction
        :type direction: typing.Optional[typing.Any]
        :param repeat: Repeat, When set, accept key-repeat events
        :type repeat: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'KeyMapItem'
        :return: Item, Added key map item
        """
        ...

    def new_from_item(
        self,
        item: "KeyMapItem",
        head: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "KeyMapItem":
        """new_from_item

        :param item: Item, Item to use as a reference
        :type item: 'KeyMapItem'
        :param head: At Head
        :type head: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'KeyMapItem'
        :return: Item, Added key map item
        """
        ...

    def remove(self, item: "KeyMapItem"):
        """remove

        :param item: Item
        :type item: 'KeyMapItem'
        """
        ...

    def from_id(self, id: typing.Optional[int]) -> "KeyMapItem":
        """from_id

        :param id: id, ID of the item
        :type id: typing.Optional[int]
        :rtype: 'KeyMapItem'
        :return: Item
        """
        ...

    def find_from_operator(
        self,
        idname: typing.Union[str, typing.Any],
        properties: typing.Optional["OperatorProperties"] = None,
        include: typing.Optional[typing.Any] = {
            '"MOUSE"',
            '"ACTIONZONE"',
            '"NDOF"',
            '"KEYBOARD"',
        },
        exclude: typing.Optional[typing.Any] = {},
    ) -> "KeyMapItem":
        """find_from_operator

        :param idname: Operator Identifier
        :type idname: typing.Union[str, typing.Any]
        :param properties:
        :type properties: typing.Optional['OperatorProperties']
        :param include: Include
        :type include: typing.Optional[typing.Any]
        :param exclude: Exclude
        :type exclude: typing.Optional[typing.Any]
        :rtype: 'KeyMapItem'
        """
        ...

    def match_event(self, event: typing.Optional["Event"]) -> "KeyMapItem":
        """match_event

        :param event:
        :type event: typing.Optional['Event']
        :rtype: 'KeyMapItem'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyMaps(bpy_struct):
    """Collection of keymaps"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        space_type: typing.Optional[typing.Any] = "EMPTY",
        region_type: typing.Optional[typing.Any] = "WINDOW",
        modal: typing.Optional[typing.Union[bool, typing.Any]] = False,
        tool: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "KeyMap":
        """Ensure the keymap exists. This will return the one with the given name/space type/region type, or create a new one if it does not exist yet.

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :param space_type: Space Type
        :type space_type: typing.Optional[typing.Any]
        :param region_type: Region Type
        :type region_type: typing.Optional[typing.Any]
        :param modal: Modal, Keymap for modal operators
        :type modal: typing.Optional[typing.Union[bool, typing.Any]]
        :param tool: Tool, Keymap for active tools
        :type tool: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'KeyMap'
        :return: Key Map, Added key map
        """
        ...

    def remove(self, keymap: "KeyMap"):
        """remove

        :param keymap: Key Map, Removed key map
        :type keymap: 'KeyMap'
        """
        ...

    def clear(self):
        """Remove all keymaps."""
        ...

    def find(
        self,
        name: typing.Union[str, typing.Any],
        space_type: typing.Optional[typing.Any] = "EMPTY",
        region_type: typing.Optional[typing.Any] = "WINDOW",
    ) -> "KeyMap":
        """find

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :param space_type: Space Type
        :type space_type: typing.Optional[typing.Any]
        :param region_type: Region Type
        :type region_type: typing.Optional[typing.Any]
        :rtype: 'KeyMap'
        :return: Key Map, Corresponding key map
        """
        ...

    def find_modal(self, name: typing.Union[str, typing.Any]) -> "KeyMap":
        """find_modal

        :param name: Operator Name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'KeyMap'
        :return: Key Map, Corresponding key map
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Keyframe(bpy_struct):
    """Bézier curve point with two handles defining a Keyframe on an F-Curve"""

    amplitude: float
    """ Amount to boost elastic bounces for 'elastic' easing

    :type: float
    """

    back: float
    """ Amount of overshoot for 'back' easing

    :type: float
    """

    co: typing.Union["mathutils.Vector", typing.List[float], typing.Tuple[float, float]]
    """ Coordinates of the control point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    co_ui: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Coordinates of the control point. Note: Changing this value also updates the handles similar to using the graph editor transform operator

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    easing: typing.Union[int, str]
    """ Which ends of the segment between this and the next keyframe easing interpolation is applied to

    :type: typing.Union[int, str]
    """

    handle_left: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Coordinates of the left handle (before the control point)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    handle_left_type: typing.Union[int, str]
    """ Handle types

    :type: typing.Union[int, str]
    """

    handle_right: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Coordinates of the right handle (after the control point)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    handle_right_type: typing.Union[int, str]
    """ Handle types

    :type: typing.Union[int, str]
    """

    interpolation: typing.Union[int, str]
    """ Interpolation method to use for segment of the F-Curve from this Keyframe until the next Keyframe

    :type: typing.Union[int, str]
    """

    period: float
    """ Time between bounces for elastic easing

    :type: float
    """

    select_control_point: bool
    """ Control point selection status

    :type: bool
    """

    select_left_handle: bool
    """ Left handle selection status

    :type: bool
    """

    select_right_handle: bool
    """ Right handle selection status

    :type: bool
    """

    type: typing.Union[int, str]
    """ Type of keyframe (for visual purposes only)

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyingSet(bpy_struct):
    """Settings that should be keyframed together"""

    bl_description: typing.Union[str, typing.Any]
    """ A short description of the keying set

    :type: typing.Union[str, typing.Any]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the Keying Set gets a custom ID, otherwise it takes the name of the class used to define the Keying Set (for example, if the class name is "BUILTIN_KSI_location", and bl_idname is not set by the script, then bl_idname = "BUILTIN_KSI_location")

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    is_path_absolute: typing.Union[bool, typing.Any]
    """ Keying Set defines specific paths/settings to be keyframed (i.e. is not reliant on context info)

    :type: typing.Union[bool, typing.Any]
    """

    paths: bpy_prop_collection["KeyingSetPath"]
    """ Keying Set Paths to define settings that get keyframed together

    :type: bpy_prop_collection['KeyingSetPath']
    """

    type_info: "KeyingSetInfo"
    """ Callback function defines for built-in Keying Sets

    :type: 'KeyingSetInfo'
    """

    use_insertkey_needed: bool
    """ Only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    """

    use_insertkey_override_needed: bool
    """ Override default setting to only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    """

    use_insertkey_override_visual: bool
    """ Override default setting to insert keyframes based on 'visual transforms'

    :type: bool
    """

    use_insertkey_visual: bool
    """ Insert keyframes based on 'visual transforms'

    :type: bool
    """

    def refresh(self):
        """Refresh Keying Set to ensure that it is valid for the current context (call before each use of one)"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyingSetInfo(bpy_struct):
    """Callback function defines for builtin Keying Sets"""

    bl_description: typing.Union[str, typing.Any]
    """ A short description of the keying set

    :type: typing.Union[str, typing.Any]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the Keying Set gets a custom ID, otherwise it takes the name of the class used to define the Keying Set (for example, if the class name is "BUILTIN_KSI_location", and bl_idname is not set by the script, then bl_idname = "BUILTIN_KSI_location")

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Keying Set options to use when inserting keyframes

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    def poll(self, context: typing.Optional["Context"]) -> bool:
        """Test if Keying Set can be used or not

        :param context:
        :type context: typing.Optional['Context']
        :rtype: bool
        """
        ...

    def iterator(
        self, context: typing.Optional["Context"], ks: typing.Optional["KeyingSet"]
    ):
        """Call generate() on the structs which have properties to be keyframed

        :param context:
        :type context: typing.Optional['Context']
        :param ks:
        :type ks: typing.Optional['KeyingSet']
        """
        ...

    def generate(
        self,
        context: typing.Optional["Context"],
        ks: typing.Optional["KeyingSet"],
        data: typing.Any,
    ):
        """Add Paths to the Keying Set to keyframe the properties of the given data

        :param context:
        :type context: typing.Optional['Context']
        :param ks:
        :type ks: typing.Optional['KeyingSet']
        :param data:
        :type data: typing.Any
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyingSetPath(bpy_struct):
    """Path to a setting for use in a Keying Set"""

    array_index: int
    """ Index to the specific setting if applicable

    :type: int
    """

    data_path: typing.Union[str, typing.Any]
    """ Path to property setting

    :type: typing.Union[str, typing.Any]
    """

    group: typing.Union[str, typing.Any]
    """ Name of Action Group to assign setting(s) for this path to

    :type: typing.Union[str, typing.Any]
    """

    group_method: typing.Union[int, str]
    """ Method used to define which Group-name to use

    :type: typing.Union[int, str]
    """

    id: "ID"
    """ ID-Block that keyframes for Keying Set should be added to (for Absolute Keying Sets only)

    :type: 'ID'
    """

    id_type: typing.Union[int, str]
    """ Type of ID-block that can be used

    :type: typing.Union[int, str]
    """

    use_entire_array: bool
    """ When an 'array/vector' type is chosen (Location, Rotation, Color, etc.), entire array is to be used

    :type: bool
    """

    use_insertkey_needed: bool
    """ Only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    """

    use_insertkey_override_needed: bool
    """ Override default setting to only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    """

    use_insertkey_override_visual: bool
    """ Override default setting to insert keyframes based on 'visual transforms'

    :type: bool
    """

    use_insertkey_visual: bool
    """ Insert keyframes based on 'visual transforms'

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyingSetPaths(bpy_struct):
    """Collection of keying set paths"""

    active: "KeyingSetPath"
    """ Active Keying Set used to insert/delete keyframes

    :type: 'KeyingSetPath'
    """

    active_index: int
    """ Current Keying Set index

    :type: int
    """

    def add(
        self,
        target_id: typing.Optional["ID"],
        data_path: typing.Union[str, typing.Any],
        index: typing.Optional[typing.Any] = -1,
        group_method: typing.Optional[typing.Any] = "KEYINGSET",
        group_name: typing.Union[str, typing.Any] = "",
    ) -> "KeyingSetPath":
        """Add a new path for the Keying Set

        :param target_id: Target ID, ID data-block for the destination
        :type target_id: typing.Optional['ID']
        :param data_path: Data-Path, RNA-Path to destination property
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, The index of the destination property (i.e. axis of Location/Rotation/etc.), or -1 for the entire array
        :type index: typing.Optional[typing.Any]
        :param group_method: Grouping Method, Method used to define which Group-name to use
        :type group_method: typing.Optional[typing.Any]
        :param group_name: Group Name, Name of Action Group to assign destination to (only if grouping mode is to use this name)
        :type group_name: typing.Union[str, typing.Any]
        :rtype: 'KeyingSetPath'
        :return: New Path, Path created and added to the Keying Set
        """
        ...

    def remove(self, path: "KeyingSetPath"):
        """Remove the given path from the Keying Set

        :param path: Path
        :type path: 'KeyingSetPath'
        """
        ...

    def clear(self):
        """Remove all the paths from the Keying Set"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyingSets(bpy_struct):
    """Scene keying sets"""

    active: "KeyingSet"
    """ Active Keying Set used to insert/delete keyframes

    :type: 'KeyingSet'
    """

    active_index: int
    """ Current Keying Set index (negative for 'builtin' and positive for 'absolute')

    :type: int
    """

    def new(
        self,
        idname: typing.Union[str, typing.Any] = "KeyingSet",
        name: typing.Union[str, typing.Any] = "KeyingSet",
    ) -> "KeyingSet":
        """Add a new Keying Set to Scene

        :param idname: IDName, Internal identifier of Keying Set
        :type idname: typing.Union[str, typing.Any]
        :param name: Name, User visible name of Keying Set
        :type name: typing.Union[str, typing.Any]
        :rtype: 'KeyingSet'
        :return: Newly created Keying Set
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyingSetsAll(bpy_struct):
    """All available keying sets"""

    active: "KeyingSet"
    """ Active Keying Set used to insert/delete keyframes

    :type: 'KeyingSet'
    """

    active_index: int
    """ Current Keying Set index (negative for 'builtin' and positive for 'absolute')

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LatticePoint(bpy_struct):
    """Point in the lattice grid"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Original undeformed location used to calculate the strength of the deform effect (edit/animate the Deformed Location instead)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    co_deform: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    groups: bpy_prop_collection["VertexGroupElement"]
    """ Weights for the vertex groups this point is member of

    :type: bpy_prop_collection['VertexGroupElement']
    """

    select: bool
    """ Selection status

    :type: bool
    """

    weight_softbody: float
    """ Softbody goal weight

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LayerCollection(bpy_struct):
    """Layer collection"""

    children: bpy_prop_collection["LayerCollection"]
    """ Layer collection children

    :type: bpy_prop_collection['LayerCollection']
    """

    collection: "Collection"
    """ Collection this layer collection is wrapping

    :type: 'Collection'
    """

    exclude: bool
    """ Exclude from view layer

    :type: bool
    """

    hide_viewport: bool
    """ Temporarily hide in viewport

    :type: bool
    """

    holdout: bool
    """ Mask out objects in collection from view layer

    :type: bool
    """

    indirect_only: bool
    """ Objects in collection only contribute indirectly (through shadows and reflections) in the view layer

    :type: bool
    """

    is_visible: typing.Union[bool, typing.Any]
    """ Whether this collection is visible for the view layer, take into account the collection parent

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Name of this layer collection (same as its collection one)

    :type: typing.Union[str, typing.Any]
    """

    def visible_get(self) -> bool:
        """Whether this collection is visible, take into account the collection parent and the viewport

        :rtype: bool
        """
        ...

    def has_objects(self) -> bool:
        """

        :rtype: bool
        """
        ...

    def has_selected_objects(self, view_layer: typing.Optional["ViewLayer"]) -> bool:
        """

        :param view_layer: View layer the layer collection belongs to
        :type view_layer: typing.Optional['ViewLayer']
        :rtype: bool
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LayerObjects(bpy_struct):
    """Collections of objects"""

    active: "Object"
    """ Active object for this layer

    :type: 'Object'
    """

    selected: bpy_prop_collection["Object"]
    """ All the selected objects of this layer

    :type: bpy_prop_collection['Object']
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LayoutPanelState(bpy_struct):
    is_open: bool
    """ 

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LibraryWeakReference(bpy_struct):
    """Read-only external reference to a linked data-block and its library file"""

    filepath: typing.Union[str, typing.Any]
    """ Path to the library .blend file

    :type: typing.Union[str, typing.Any]
    """

    id_name: typing.Union[str, typing.Any]
    """ Full ID name in the library .blend file (including the two leading 'id type' chars)

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Lightgroup(bpy_struct):
    name: typing.Union[str, typing.Any]
    """ Name of the Lightgroup

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Lightgroups(bpy_struct):
    """Collection of Lightgroups"""

    def add(self, name: typing.Union[str, typing.Any] = "") -> "Lightgroup":
        """add

        :param name: Name, Name of newly created lightgroup
        :type name: typing.Union[str, typing.Any]
        :rtype: 'Lightgroup'
        :return: Newly created Lightgroup
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LineStyleAlphaModifiers(bpy_struct):
    """Alpha modifiers for changing line alphas"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ) -> "LineStyleAlphaModifier":
        """Add a alpha modifier to line style

        :param name: New name for the alpha modifier (not unique)
        :type name: typing.Union[str, typing.Any]
        :param type: Alpha modifier type to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'LineStyleAlphaModifier'
        :return: Newly added alpha modifier
        """
        ...

    def remove(self, modifier: "LineStyleAlphaModifier"):
        """Remove a alpha modifier from line style

        :param modifier: Alpha modifier to remove
        :type modifier: 'LineStyleAlphaModifier'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LineStyleColorModifiers(bpy_struct):
    """Color modifiers for changing line colors"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ) -> "LineStyleColorModifier":
        """Add a color modifier to line style

        :param name: New name for the color modifier (not unique)
        :type name: typing.Union[str, typing.Any]
        :param type: Color modifier type to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'LineStyleColorModifier'
        :return: Newly added color modifier
        """
        ...

    def remove(self, modifier: "LineStyleColorModifier"):
        """Remove a color modifier from line style

        :param modifier: Color modifier to remove
        :type modifier: 'LineStyleColorModifier'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LineStyleGeometryModifiers(bpy_struct):
    """Geometry modifiers for changing line geometries"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ) -> "LineStyleGeometryModifier":
        """Add a geometry modifier to line style

        :param name: New name for the geometry modifier (not unique)
        :type name: typing.Union[str, typing.Any]
        :param type: Geometry modifier type to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'LineStyleGeometryModifier'
        :return: Newly added geometry modifier
        """
        ...

    def remove(self, modifier: "LineStyleGeometryModifier"):
        """Remove a geometry modifier from line style

        :param modifier: Geometry modifier to remove
        :type modifier: 'LineStyleGeometryModifier'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LineStyleModifier(bpy_struct):
    """Base type to define modifiers"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LineStyleTextureSlots(bpy_struct):
    """Collection of texture slots"""

    def add(self) -> "LineStyleTextureSlot":
        """add

        :rtype: 'LineStyleTextureSlot'
        :return: The newly initialized mtex
        """
        ...

    def create(self, index: typing.Optional[int]) -> "LineStyleTextureSlot":
        """create

        :param index: Index, Slot index to initialize
        :type index: typing.Optional[int]
        :rtype: 'LineStyleTextureSlot'
        :return: The newly initialized mtex
        """
        ...

    def clear(self, index: typing.Optional[int]):
        """clear

        :param index: Index, Slot index to clear
        :type index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LineStyleThicknessModifiers(bpy_struct):
    """Thickness modifiers for changing line thickness"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ) -> "LineStyleThicknessModifier":
        """Add a thickness modifier to line style

        :param name: New name for the thickness modifier (not unique)
        :type name: typing.Union[str, typing.Any]
        :param type: Thickness modifier type to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'LineStyleThicknessModifier'
        :return: Newly added thickness modifier
        """
        ...

    def remove(self, modifier: "LineStyleThicknessModifier"):
        """Remove a thickness modifier from line style

        :param modifier: Thickness modifier to remove
        :type modifier: 'LineStyleThicknessModifier'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Linesets(bpy_struct):
    """Line sets for associating lines and style parameters"""

    active: "FreestyleLineSet"
    """ Active line set being displayed

    :type: 'FreestyleLineSet'
    """

    active_index: int
    """ Index of active line set slot

    :type: int
    """

    def new(self, name: typing.Union[str, typing.Any]) -> "FreestyleLineSet":
        """Add a line set to scene render layer Freestyle settings

        :param name: New name for the line set (not unique)
        :type name: typing.Union[str, typing.Any]
        :rtype: 'FreestyleLineSet'
        :return: Newly created line set
        """
        ...

    def remove(self, lineset: "FreestyleLineSet"):
        """Remove a line set from scene render layer Freestyle settings

        :param lineset: Line set to remove
        :type lineset: 'FreestyleLineSet'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LoopColors(bpy_struct):
    """Collection of vertex colors"""

    active: "MeshLoopColorLayer"
    """ Active vertex color layer

    :type: 'MeshLoopColorLayer'
    """

    active_index: int
    """ Active vertex color index

    :type: int
    """

    def new(
        self,
        name: typing.Union[str, typing.Any] = "Col",
        do_init: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ) -> "MeshLoopColorLayer":
        """Add a vertex color layer to Mesh

        :param name: Vertex color name
        :type name: typing.Union[str, typing.Any]
        :param do_init: Whether new layer's data should be initialized by copying current active one
        :type do_init: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'MeshLoopColorLayer'
        :return: The newly created layer
        """
        ...

    def remove(self, layer: "MeshLoopColorLayer"):
        """Remove a vertex color layer

        :param layer: The layer to remove
        :type layer: 'MeshLoopColorLayer'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Macro(bpy_struct):
    """Storage of a macro operator being executed, or registered after execution"""

    bl_cursor_pending: typing.Union[int, str]
    """ Cursor to use when waiting for the user to select a location to activate the operator (when bl_options has DEPENDS_ON_CURSOR set)

    :type: typing.Union[int, str]
    """

    bl_description: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Options for this operator type

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    bl_translation_context: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_undo_group: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    has_reports: typing.Union[bool, typing.Any]
    """ Operator has a set of reports (warnings and errors) from last execution

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    properties: "OperatorProperties"
    """ 

    :type: 'OperatorProperties'
    """

    def report(
        self,
        type: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]],
        message: typing.Union[str, typing.Any],
    ):
        """report

        :param type: Type
        :type type: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]]
        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        """
        ...

    def poll(self, context: "Context") -> bool:
        """Test if the operator can be called or not

        :param context:
        :type context: 'Context'
        :rtype: bool
        """
        ...

    def draw(self, context: "Context"):
        """Draw function for the operator

        :param context:
        :type context: 'Context'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaskLayer(bpy_struct):
    """Single layer used for masking pixels"""

    alpha: float
    """ Render Opacity

    :type: float
    """

    blend: typing.Union[int, str]
    """ Method of blending mask layers

    :type: typing.Union[int, str]
    """

    falloff: typing.Union[int, str]
    """ Falloff type the feather

    :type: typing.Union[int, str]
    """

    hide: bool
    """ Restrict visibility in the viewport

    :type: bool
    """

    hide_render: bool
    """ Restrict renderability

    :type: bool
    """

    hide_select: bool
    """ Restrict selection in the viewport

    :type: bool
    """

    invert: bool
    """ Invert the mask black/white

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Unique name of layer

    :type: typing.Union[str, typing.Any]
    """

    select: bool
    """ Layer is selected for editing in the Dope Sheet

    :type: bool
    """

    splines: bpy_prop_collection["MaskSpline"]
    """ Collection of splines which defines this layer

    :type: bpy_prop_collection['MaskSpline']
    """

    use_fill_holes: bool
    """ Calculate holes when filling overlapping curves

    :type: bool
    """

    use_fill_overlap: bool
    """ Calculate self intersections and overlap before filling

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaskLayers(bpy_struct):
    """Collection of layers used by mask"""

    active: "MaskLayer"
    """ Active layer in this mask

    :type: 'MaskLayer'
    """

    def new(self, name: typing.Union[str, typing.Any] = "") -> "MaskLayer":
        """Add layer to this mask

        :param name: Name, Name of new layer
        :type name: typing.Union[str, typing.Any]
        :rtype: 'MaskLayer'
        :return: New mask layer
        """
        ...

    def remove(self, layer: "MaskLayer"):
        """Remove layer from this mask

        :param layer: Shape to be removed
        :type layer: 'MaskLayer'
        """
        ...

    def clear(self):
        """Remove all mask layers"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaskParent(bpy_struct):
    """Parenting settings for masking element"""

    id: "ID"
    """ ID-block to which masking element would be parented to or to its property

    :type: 'ID'
    """

    id_type: typing.Union[int, str]
    """ Type of ID-block that can be used

    :type: typing.Union[int, str]
    """

    parent: typing.Union[str, typing.Any]
    """ Name of parent object in specified data-block to which parenting happens

    :type: typing.Union[str, typing.Any]
    """

    sub_parent: typing.Union[str, typing.Any]
    """ Name of parent sub-object in specified data-block to which parenting happens

    :type: typing.Union[str, typing.Any]
    """

    type: typing.Union[int, str]
    """ Parent Type

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaskSpline(bpy_struct):
    """Single spline used for defining mask shape"""

    offset_mode: typing.Union[int, str]
    """ The method used for calculating the feather offset

    :type: typing.Union[int, str]
    """

    points: bpy_prop_collection["MaskSplinePoint"]
    """ Collection of points

    :type: bpy_prop_collection['MaskSplinePoint']
    """

    use_cyclic: bool
    """ Make this spline a closed loop

    :type: bool
    """

    use_fill: bool
    """ Make this spline filled

    :type: bool
    """

    use_self_intersection_check: bool
    """ Prevent feather from self-intersections

    :type: bool
    """

    weight_interpolation: typing.Union[int, str]
    """ The type of weight interpolation for spline

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaskSplinePoint(bpy_struct):
    """Single point in spline used for defining mask"""

    co: typing.Union["mathutils.Vector", typing.List[float], typing.Tuple[float, float]]
    """ Coordinates of the control point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    feather_points: bpy_prop_collection["MaskSplinePointUW"]
    """ Points defining feather

    :type: bpy_prop_collection['MaskSplinePointUW']
    """

    handle_left: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Coordinates of the first handle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    handle_left_type: typing.Union[int, str]
    """ Handle type

    :type: typing.Union[int, str]
    """

    handle_right: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Coordinates of the second handle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    handle_right_type: typing.Union[int, str]
    """ Handle type

    :type: typing.Union[int, str]
    """

    handle_type: typing.Union[int, str]
    """ Handle type

    :type: typing.Union[int, str]
    """

    parent: "MaskParent"
    """ 

    :type: 'MaskParent'
    """

    select: bool
    """ Selection status

    :type: bool
    """

    weight: float
    """ Weight of the point

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaskSplinePointUW(bpy_struct):
    """Single point in spline segment defining feather"""

    select: bool
    """ Selection status

    :type: bool
    """

    u: float
    """ U coordinate of point along spline segment

    :type: float
    """

    weight: float
    """ Weight of feather point

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaskSplinePoints(bpy_struct):
    """Collection of masking spline points"""

    def add(self, count: typing.Optional[int]):
        """Add a number of point to this spline

        :param count: Number, Number of points to add to the spline
        :type count: typing.Optional[int]
        """
        ...

    def remove(self, point: "MaskSplinePoint"):
        """Remove a point from a spline

        :param point: The point to remove
        :type point: 'MaskSplinePoint'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaskSplines(bpy_struct):
    """Collection of masking splines"""

    active: "MaskSpline"
    """ Active spline of masking layer

    :type: 'MaskSpline'
    """

    active_point: "MaskSplinePoint"
    """ Active point of masking layer

    :type: 'MaskSplinePoint'
    """

    def new(self) -> "MaskSpline":
        """Add a new spline to the layer

        :rtype: 'MaskSpline'
        :return: The newly created spline
        """
        ...

    def remove(self, spline: "MaskSpline"):
        """Remove a spline from a layer

        :param spline: The spline to remove
        :type spline: 'MaskSpline'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaterialGPencilStyle(bpy_struct):
    alignment_mode: typing.Union[int, str]
    """ Defines how align Dots and Boxes with drawing path and object rotation

    :type: typing.Union[int, str]
    """

    alignment_rotation: float
    """ Additional rotation applied to dots and square texture of strokes. Only applies in texture shading mode

    :type: float
    """

    color: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    fill_color: bpy_prop_array[float]
    """ Color for filling region bounded by each stroke

    :type: bpy_prop_array[float]
    """

    fill_image: "Image"
    """ 

    :type: 'Image'
    """

    fill_style: typing.Union[int, str]
    """ Select style used to fill strokes

    :type: typing.Union[int, str]
    """

    flip: bool
    """ Flip filling colors

    :type: bool
    """

    ghost: bool
    """ Display strokes using this color when showing onion skins

    :type: bool
    """

    gradient_type: typing.Union[int, str]
    """ Select type of gradient used to fill strokes

    :type: typing.Union[int, str]
    """

    hide: bool
    """ Set color Visibility

    :type: bool
    """

    is_fill_visible: typing.Union[bool, typing.Any]
    """ True when opacity of fill is set high enough to be visible

    :type: typing.Union[bool, typing.Any]
    """

    is_stroke_visible: typing.Union[bool, typing.Any]
    """ True when opacity of stroke is set high enough to be visible

    :type: typing.Union[bool, typing.Any]
    """

    lock: bool
    """ Protect color from further editing and/or frame changes

    :type: bool
    """

    mix_color: bpy_prop_array[float]
    """ Color for mixing with primary filling color

    :type: bpy_prop_array[float]
    """

    mix_factor: float
    """ Mix Factor

    :type: float
    """

    mix_stroke_factor: float
    """ Mix Stroke Factor

    :type: float
    """

    mode: typing.Union[int, str]
    """ Select line type for strokes

    :type: typing.Union[int, str]
    """

    pass_index: int
    """ Index number for the "Color Index" pass

    :type: int
    """

    pixel_size: float
    """ Texture Pixel Size factor along the stroke

    :type: float
    """

    show_fill: bool
    """ Show stroke fills of this material

    :type: bool
    """

    show_stroke: bool
    """ Show stroke lines of this material

    :type: bool
    """

    stroke_image: "Image"
    """ 

    :type: 'Image'
    """

    stroke_style: typing.Union[int, str]
    """ Select style used to draw strokes

    :type: typing.Union[int, str]
    """

    texture_angle: float
    """ Texture Orientation Angle

    :type: float
    """

    texture_clamp: bool
    """ Do not repeat texture and clamp to one instance only

    :type: bool
    """

    texture_offset: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Shift Texture in 2d Space

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    texture_scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Scale Factor for Texture

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    use_fill_holdout: bool
    """ Remove the color from underneath this stroke by using it as a mask

    :type: bool
    """

    use_overlap_strokes: bool
    """ Disable stencil and overlap self intersections with alpha materials

    :type: bool
    """

    use_stroke_holdout: bool
    """ Remove the color from underneath this stroke by using it as a mask

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaterialLineArt(bpy_struct):
    intersection_priority: int
    """ The intersection line will be included into the object with the higher intersection priority value

    :type: int
    """

    mat_occlusion: int
    """ Faces with this material will behave as if it has set number of layers in occlusion

    :type: int
    """

    use_intersection_priority_override: bool
    """ Override object and collection intersection priority value

    :type: bool
    """

    use_material_mask: bool
    """ Use material masks to filter out occluded strokes

    :type: bool
    """

    use_material_mask_bits: typing.List[bool]
    """ 

    :type: typing.List[bool]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaterialSlot(bpy_struct):
    """Material slot in an object"""

    link: typing.Union[int, str]
    """ Link material to object or the object's data

    :type: typing.Union[int, str]
    """

    material: "Material"
    """ Material data-block used by this material slot

    :type: 'Material'
    """

    name: typing.Union[str, typing.Any]
    """ Material slot name

    :type: typing.Union[str, typing.Any]
    """

    slot_index: int
    """ 

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshEdge(bpy_struct):
    """Edge in a Mesh data-block"""

    hide: bool
    """ 

    :type: bool
    """

    index: int
    """ Index of this edge

    :type: int
    """

    is_loose: typing.Union[bool, typing.Any]
    """ Edge is not connected to any faces

    :type: typing.Union[bool, typing.Any]
    """

    select: bool
    """ 

    :type: bool
    """

    use_edge_sharp: bool
    """ Sharp edge for shading

    :type: bool
    """

    use_freestyle_mark: bool
    """ Edge mark for Freestyle line rendering

    :type: bool
    """

    use_seam: bool
    """ Seam edge for UV unwrapping

    :type: bool
    """

    vertices: bpy_prop_array[int]
    """ Vertex indices

    :type: bpy_prop_array[int]
    """

    key: typing.Any
    """ (readonly)"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshEdges(bpy_struct):
    """Collection of mesh edges"""

    def add(self, count: typing.Optional[int]):
        """add

        :param count: Count, Number of edges to add
        :type count: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshLoop(bpy_struct):
    """Loop in a Mesh data-block"""

    bitangent: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Bitangent vector of this vertex for this face (must be computed beforehand using calc_tangents, use it only if really needed, slower access than bitangent_sign)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bitangent_sign: float
    """ Sign of the bitangent vector of this vertex for this face (must be computed beforehand using calc_tangents, bitangent = bitangent_sign * cross(normal, tangent))

    :type: float
    """

    edge_index: int
    """ Edge index

    :type: int
    """

    index: int
    """ Index of this loop

    :type: int
    """

    normal: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ The normal direction of the face corner, taking into account sharp faces, sharp edges, and custom normal data

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    tangent: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Local space unit length tangent vector of this vertex for this face (must be computed beforehand using calc_tangents)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_index: int
    """ Vertex index

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshLoopColor(bpy_struct):
    """Vertex loop colors in a Mesh"""

    color: bpy_prop_array[float]
    """ Color in sRGB color space

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshLoopColorLayer(bpy_struct):
    """Layer of vertex colors in a Mesh data-block"""

    active: bool
    """ Sets the layer as active for display and editing

    :type: bool
    """

    active_render: bool
    """ Sets the layer as active for rendering

    :type: bool
    """

    data: bpy_prop_collection["MeshLoopColor"]
    """ 

    :type: bpy_prop_collection['MeshLoopColor']
    """

    name: typing.Union[str, typing.Any]
    """ Name of Vertex color layer

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshLoopTriangle(bpy_struct):
    """Tessellated triangle in a Mesh data-block"""

    area: float
    """ Area of this triangle

    :type: float
    """

    index: int
    """ Index of this loop triangle

    :type: int
    """

    loops: bpy_prop_array[int]
    """ Indices of mesh loops that make up the triangle

    :type: bpy_prop_array[int]
    """

    material_index: int
    """ Material slot index of this triangle

    :type: int
    """

    normal: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Local space unit length normal vector for this triangle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    polygon_index: int
    """ Index of mesh face that the triangle is a part of

    :type: int
    """

    split_normals: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
        ],
    ]
    """ Local space unit length split normal vectors of the face corners of this triangle

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]]]
    """

    use_smooth: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    vertices: bpy_prop_array[int]
    """ Indices of triangle vertices

    :type: bpy_prop_array[int]
    """

    center: typing.Any
    """ The midpoint of the face.(readonly)"""

    edge_keys: typing.Any
    """ (readonly)"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshLoopTriangles(bpy_struct):
    """Tessellation of mesh polygons into triangles"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshLoops(bpy_struct):
    """Collection of mesh loops"""

    def add(self, count: typing.Optional[int]):
        """add

        :param count: Count, Number of loops to add
        :type count: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshNormalValue(bpy_struct):
    """Vector in a mesh normal array"""

    vector: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 3D vector

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshPolygon(bpy_struct):
    """Polygon in a Mesh data-block"""

    area: float
    """ Read only area of this face

    :type: float
    """

    center: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Center of this face

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    hide: bool
    """ 

    :type: bool
    """

    index: int
    """ Index of this face

    :type: int
    """

    loop_start: int
    """ Index of the first loop of this face

    :type: int
    """

    loop_total: int
    """ Number of loops used by this face

    :type: int
    """

    material_index: int
    """ Material slot index of this face

    :type: int
    """

    normal: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Local space unit length normal vector for this face

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    select: bool
    """ 

    :type: bool
    """

    use_freestyle_mark: bool
    """ Face mark for Freestyle line rendering

    :type: bool
    """

    use_smooth: bool
    """ 

    :type: bool
    """

    vertices: bpy_prop_array[int]
    """ Vertex indices

    :type: bpy_prop_array[int]
    """

    edge_keys: typing.Any
    """ (readonly)"""

    loop_indices: typing.Any
    """ (readonly)"""

    def flip(self):
        """Invert winding of this face (flip its normal)"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshPolygons(bpy_struct):
    """Collection of mesh polygons"""

    active: int
    """ The active face for this mesh

    :type: int
    """

    def add(self, count: typing.Optional[int]):
        """add

        :param count: Count, Number of polygons to add
        :type count: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshSkinVertex(bpy_struct):
    """Per-vertex skin data for use with the Skin modifier"""

    radius: bpy_prop_array[float]
    """ Radius of the skin

    :type: bpy_prop_array[float]
    """

    use_loose: bool
    """ If vertex has multiple adjacent edges, it is hulled to them directly

    :type: bool
    """

    use_root: bool
    """ Vertex is a root for rotation calculations and armature generation, setting this flag does not clear other roots in the same mesh island

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshSkinVertexLayer(bpy_struct):
    """Per-vertex skin data for use with the Skin modifier"""

    data: bpy_prop_collection["MeshSkinVertex"]
    """ 

    :type: bpy_prop_collection['MeshSkinVertex']
    """

    name: typing.Union[str, typing.Any]
    """ Name of skin layer

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshStatVis(bpy_struct):
    distort_max: float
    """ Maximum angle to display

    :type: float
    """

    distort_min: float
    """ Minimum angle to display

    :type: float
    """

    overhang_axis: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    overhang_max: float
    """ Maximum angle to display

    :type: float
    """

    overhang_min: float
    """ Minimum angle to display

    :type: float
    """

    sharp_max: float
    """ Maximum angle to display

    :type: float
    """

    sharp_min: float
    """ Minimum angle to display

    :type: float
    """

    thickness_max: float
    """ Maximum for measuring thickness

    :type: float
    """

    thickness_min: float
    """ Minimum for measuring thickness

    :type: float
    """

    thickness_samples: int
    """ Number of samples to test per face

    :type: int
    """

    type: typing.Union[int, str]
    """ Type of data to visualize/check

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshUVLoop(bpy_struct):
    """(Deprecated) Layer of UV coordinates in a Mesh data-block"""

    pin_uv: bool
    """ 

    :type: bool
    """

    select: bool
    """ 

    :type: bool
    """

    select_edge: bool
    """ 

    :type: bool
    """

    uv: typing.Union["mathutils.Vector", typing.List[float], typing.Tuple[float, float]]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshUVLoopLayer(bpy_struct):
    active: bool
    """ Set the map as active for display and editing

    :type: bool
    """

    active_clone: bool
    """ Set the map as active for cloning

    :type: bool
    """

    active_render: bool
    """ Set the UV map as active for rendering

    :type: bool
    """

    data: bpy_prop_collection["MeshUVLoop"]
    """ Deprecated, use 'uv', 'vertex_select', 'edge_select' or 'pin' properties instead

    :type: bpy_prop_collection['MeshUVLoop']
    """

    edge_selection: bpy_prop_collection["BoolAttributeValue"]
    """ Selection state of the edge in the UV editor

    :type: bpy_prop_collection['BoolAttributeValue']
    """

    name: typing.Union[str, typing.Any]
    """ Name of UV map

    :type: typing.Union[str, typing.Any]
    """

    pin: bpy_prop_collection["BoolAttributeValue"]
    """ UV pinned state in the UV editor

    :type: bpy_prop_collection['BoolAttributeValue']
    """

    uv: bpy_prop_collection["Float2AttributeValue"]
    """ UV coordinates on face corners

    :type: bpy_prop_collection['Float2AttributeValue']
    """

    vertex_selection: bpy_prop_collection["BoolAttributeValue"]
    """ Selection state of the face corner the UV editor

    :type: bpy_prop_collection['BoolAttributeValue']
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshVertex(bpy_struct):
    """Vertex in a Mesh data-block"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    groups: bpy_prop_collection["VertexGroupElement"]
    """ Weights for the vertex groups this vertex is member of

    :type: bpy_prop_collection['VertexGroupElement']
    """

    hide: bool
    """ 

    :type: bool
    """

    index: int
    """ Index of this vertex

    :type: int
    """

    normal: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Vertex Normal

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    select: bool
    """ 

    :type: bool
    """

    undeformed_co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ For meshes with modifiers applied, the coordinate of the vertex with no deforming modifiers applied, as used for generated texture coordinates

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshVertices(bpy_struct):
    """Collection of mesh vertices"""

    def add(self, count: typing.Optional[int]):
        """add

        :param count: Count, Number of vertices to add
        :type count: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MetaBallElements(bpy_struct):
    """Collection of metaball elements"""

    active: "MetaElement"
    """ Last selected element

    :type: 'MetaElement'
    """

    def new(self, type: typing.Optional[typing.Any] = "BALL") -> "MetaElement":
        """Add a new element to the metaball

        :param type: Type for the new metaball element
        :type type: typing.Optional[typing.Any]
        :rtype: 'MetaElement'
        :return: The newly created metaball element
        """
        ...

    def remove(self, element: "MetaElement"):
        """Remove an element from the metaball

        :param element: The element to remove
        :type element: 'MetaElement'
        """
        ...

    def clear(self):
        """Remove all elements from the metaball"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MetaElement(bpy_struct):
    """Blobby element in a metaball data-block"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    hide: bool
    """ Hide element

    :type: bool
    """

    radius: float
    """ 

    :type: float
    """

    rotation: typing.Union[
        "mathutils.Quaternion",
        typing.List[float],
        typing.Tuple[float, float, float, float],
    ]
    """ Normalized quaternion rotation

    :type: typing.Union['mathutils.Quaternion', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    select: bool
    """ Select element

    :type: bool
    """

    size_x: float
    """ Size of element, use of components depends on element type

    :type: float
    """

    size_y: float
    """ Size of element, use of components depends on element type

    :type: float
    """

    size_z: float
    """ Size of element, use of components depends on element type

    :type: float
    """

    stiffness: float
    """ Stiffness defines how much of the element to fill

    :type: float
    """

    type: typing.Union[int, str]
    """ Metaball type

    :type: typing.Union[int, str]
    """

    use_negative: bool
    """ Set metaball as negative one

    :type: bool
    """

    use_scale_stiffness: bool
    """ Scale stiffness instead of radius

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Modifier(bpy_struct):
    """Modifier affecting the geometry data of an object"""

    execution_time: float
    """ Time in seconds that the modifier took to evaluate. This is only set on evaluated objects. If multiple modifiers run in parallel, execution time is not a reliable metric

    :type: float
    """

    is_active: bool
    """ The active modifier in the list

    :type: bool
    """

    is_override_data: typing.Union[bool, typing.Any]
    """ In a local override object, whether this modifier comes from the linked reference object, or is local to the override

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Modifier name

    :type: typing.Union[str, typing.Any]
    """

    persistent_uid: int
    """ Uniquely identifies the modifier within the modifier stack that it is part of

    :type: int
    """

    show_expanded: bool
    """ Set modifier expanded in the user interface

    :type: bool
    """

    show_in_editmode: bool
    """ Display modifier in Edit mode

    :type: bool
    """

    show_on_cage: bool
    """ Adjust edit cage to modifier result

    :type: bool
    """

    show_render: bool
    """ Use modifier during render

    :type: bool
    """

    show_viewport: bool
    """ Display modifier in viewport

    :type: bool
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    use_apply_on_spline: bool
    """ Apply this and all preceding deformation modifiers on splines' points rather than on filled curve/surface

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MotionPath(bpy_struct):
    """Cache of the world-space positions of an element over a frame range"""

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Custom color for motion path

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    frame_end: int
    """ End frame of the stored range

    :type: int
    """

    frame_start: int
    """ Starting frame of the stored range

    :type: int
    """

    is_modified: bool
    """ Path is being edited

    :type: bool
    """

    length: int
    """ Number of frames cached

    :type: int
    """

    line_thickness: int
    """ Line thickness for motion path

    :type: int
    """

    lines: bool
    """ Use straight lines between keyframe points

    :type: bool
    """

    points: bpy_prop_collection["MotionPathVert"]
    """ Cached positions per frame

    :type: bpy_prop_collection['MotionPathVert']
    """

    use_bone_head: typing.Union[bool, typing.Any]
    """ For PoseBone paths, use the bone head location when calculating this path

    :type: typing.Union[bool, typing.Any]
    """

    use_custom_color: bool
    """ Use custom color for this motion path

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MotionPathVert(bpy_struct):
    """Cached location on path"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    select: bool
    """ Path point is selected for editing

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieClipProxy(bpy_struct):
    """Proxy parameters for a movie clip"""

    build_100: bool
    """ Build proxy resolution 100% of the original footage dimension

    :type: bool
    """

    build_25: bool
    """ Build proxy resolution 25% of the original footage dimension

    :type: bool
    """

    build_50: bool
    """ Build proxy resolution 50% of the original footage dimension

    :type: bool
    """

    build_75: bool
    """ Build proxy resolution 75% of the original footage dimension

    :type: bool
    """

    build_free_run: bool
    """ Build free run time code index

    :type: bool
    """

    build_free_run_rec_date: bool
    """ Build free run time code index using Record Date/Time

    :type: bool
    """

    build_record_run: bool
    """ Build record run time code index

    :type: bool
    """

    build_undistorted_100: bool
    """ Build proxy resolution 100% of the original undistorted footage dimension

    :type: bool
    """

    build_undistorted_25: bool
    """ Build proxy resolution 25% of the original undistorted footage dimension

    :type: bool
    """

    build_undistorted_50: bool
    """ Build proxy resolution 50% of the original undistorted footage dimension

    :type: bool
    """

    build_undistorted_75: bool
    """ Build proxy resolution 75% of the original undistorted footage dimension

    :type: bool
    """

    directory: typing.Union[str, typing.Any]
    """ Location to store the proxy files

    :type: typing.Union[str, typing.Any]
    """

    quality: int
    """ JPEG quality of proxy images

    :type: int
    """

    timecode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieClipScopes(bpy_struct):
    """Scopes for statistical view of a movie clip"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieClipUser(bpy_struct):
    """Parameters defining how a MovieClip data-block is used by another data-block"""

    frame_current: int
    """ Current frame number in movie or image sequence

    :type: int
    """

    proxy_render_size: typing.Union[int, str]
    """ Display preview using full resolution or different proxy resolutions

    :type: typing.Union[int, str]
    """

    use_render_undistorted: bool
    """ Render preview using undistorted proxy

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieReconstructedCamera(bpy_struct):
    """Match-moving reconstructed camera data from tracker"""

    average_error: float
    """ Average error of reconstruction

    :type: float
    """

    frame: int
    """ Frame number marker is keyframed on

    :type: int
    """

    matrix: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Worldspace transformation matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTracking(bpy_struct):
    """Match-moving data for tracking"""

    active_object_index: int
    """ Index of active object

    :type: int
    """

    camera: "MovieTrackingCamera"
    """ 

    :type: 'MovieTrackingCamera'
    """

    dopesheet: "MovieTrackingDopesheet"
    """ 

    :type: 'MovieTrackingDopesheet'
    """

    objects: bpy_prop_collection["MovieTrackingObject"]
    """ Collection of objects in this tracking data object

    :type: bpy_prop_collection['MovieTrackingObject']
    """

    plane_tracks: bpy_prop_collection["MovieTrackingPlaneTrack"]
    """ Collection of plane tracks in this tracking data object. Deprecated, use objects[name].plane_tracks

    :type: bpy_prop_collection['MovieTrackingPlaneTrack']
    """

    reconstruction: "MovieTrackingReconstruction"
    """ 

    :type: 'MovieTrackingReconstruction'
    """

    settings: "MovieTrackingSettings"
    """ 

    :type: 'MovieTrackingSettings'
    """

    stabilization: "MovieTrackingStabilization"
    """ 

    :type: 'MovieTrackingStabilization'
    """

    tracks: bpy_prop_collection["MovieTrackingTrack"]
    """ Collection of tracks in this tracking data object. Deprecated, use objects[name].tracks

    :type: bpy_prop_collection['MovieTrackingTrack']
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingCamera(bpy_struct):
    """Match-moving camera data for tracking"""

    brown_k1: float
    """ First coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    """

    brown_k2: float
    """ Second coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    """

    brown_k3: float
    """ Third coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    """

    brown_k4: float
    """ Fourth coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    """

    brown_p1: float
    """ First coefficient of second order Brown-Conrady tangential distortion

    :type: float
    """

    brown_p2: float
    """ Second coefficient of second order Brown-Conrady tangential distortion

    :type: float
    """

    distortion_model: typing.Union[int, str]
    """ Distortion model used for camera lenses

    :type: typing.Union[int, str]
    """

    division_k1: float
    """ First coefficient of second order division distortion

    :type: float
    """

    division_k2: float
    """ Second coefficient of second order division distortion

    :type: float
    """

    focal_length: float
    """ Camera's focal length

    :type: float
    """

    focal_length_pixels: float
    """ Camera's focal length

    :type: float
    """

    k1: float
    """ First coefficient of third order polynomial radial distortion

    :type: float
    """

    k2: float
    """ Second coefficient of third order polynomial radial distortion

    :type: float
    """

    k3: float
    """ Third coefficient of third order polynomial radial distortion

    :type: float
    """

    nuke_k1: float
    """ First coefficient of second order Nuke distortion

    :type: float
    """

    nuke_k2: float
    """ Second coefficient of second order Nuke distortion

    :type: float
    """

    pixel_aspect: float
    """ Pixel aspect ratio

    :type: float
    """

    principal_point: bpy_prop_array[float]
    """ Optical center of lens

    :type: bpy_prop_array[float]
    """

    principal_point_pixels: bpy_prop_array[float]
    """ Optical center of lens in pixels

    :type: bpy_prop_array[float]
    """

    sensor_width: float
    """ Width of CCD sensor in millimeters

    :type: float
    """

    units: typing.Union[int, str]
    """ Units used for camera focal length

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingDopesheet(bpy_struct):
    """Match-moving dopesheet data"""

    show_hidden: bool
    """ Include channels from objects/bone that are not visible

    :type: bool
    """

    show_only_selected: bool
    """ Only include channels relating to selected objects and data

    :type: bool
    """

    sort_method: typing.Union[int, str]
    """ Method to be used to sort channels in dopesheet view

    :type: typing.Union[int, str]
    """

    use_invert_sort: bool
    """ Invert sort order of dopesheet channels

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingMarker(bpy_struct):
    """Match-moving marker data for tracking"""

    co: typing.Union["mathutils.Vector", typing.List[float], typing.Tuple[float, float]]
    """ Marker position at frame in normalized coordinates

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    frame: int
    """ Frame number marker is keyframed on

    :type: int
    """

    is_keyed: bool
    """ Whether the position of the marker is keyframed or tracked

    :type: bool
    """

    mute: bool
    """ Is marker muted for current frame

    :type: bool
    """

    pattern_bound_box: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[typing.Tuple[float, float], typing.Tuple[float, float]],
    ]
    """ Pattern area bounding box in normalized coordinates

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float], typing.Tuple[float, float]]]
    """

    pattern_corners: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Array of coordinates which represents pattern's corners in normalized coordinates relative to marker position

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    search_max: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Right-bottom corner of search area in normalized coordinates relative to marker position

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    search_min: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Left-bottom corner of search area in normalized coordinates relative to marker position

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingMarkers(bpy_struct):
    """Collection of markers for movie tracking track"""

    def find_frame(
        self,
        frame: typing.Optional[int],
        exact: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ) -> "MovieTrackingMarker":
        """Get marker for specified frame

        :param frame: Frame, Frame number to find marker for
        :type frame: typing.Optional[int]
        :param exact: Exact, Get marker at exact frame number rather than get estimated marker
        :type exact: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'MovieTrackingMarker'
        :return: Marker for specified frame
        """
        ...

    def insert_frame(
        self, frame: typing.Optional[int], co: typing.Optional[typing.Any] = (0.0, 0.0)
    ) -> "MovieTrackingMarker":
        """Insert a new marker at the specified frame

        :param frame: Frame, Frame number to insert marker to
        :type frame: typing.Optional[int]
        :param co: Coordinate, Place new marker at the given frame using specified in normalized space coordinates
        :type co: typing.Optional[typing.Any]
        :rtype: 'MovieTrackingMarker'
        :return: Newly created marker
        """
        ...

    def delete_frame(self, frame: typing.Optional[int]):
        """Delete marker at specified frame

        :param frame: Frame, Frame number to delete marker from
        :type frame: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingObject(bpy_struct):
    """Match-moving object tracking and reconstruction data"""

    is_camera: typing.Union[bool, typing.Any]
    """ Object is used for camera tracking

    :type: typing.Union[bool, typing.Any]
    """

    keyframe_a: int
    """ First keyframe used for reconstruction initialization

    :type: int
    """

    keyframe_b: int
    """ Second keyframe used for reconstruction initialization

    :type: int
    """

    name: typing.Union[str, typing.Any]
    """ Unique name of object

    :type: typing.Union[str, typing.Any]
    """

    plane_tracks: bpy_prop_collection["MovieTrackingPlaneTrack"]
    """ Collection of plane tracks in this tracking data object

    :type: bpy_prop_collection['MovieTrackingPlaneTrack']
    """

    reconstruction: "MovieTrackingReconstruction"
    """ 

    :type: 'MovieTrackingReconstruction'
    """

    scale: float
    """ Scale of object solution in camera space

    :type: float
    """

    tracks: bpy_prop_collection["MovieTrackingTrack"]
    """ Collection of tracks in this tracking data object

    :type: bpy_prop_collection['MovieTrackingTrack']
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingObjectPlaneTracks(bpy_struct):
    """Collection of tracking plane tracks"""

    active: "MovieTrackingTrack"
    """ Active track in this tracking data object

    :type: 'MovieTrackingTrack'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingObjectTracks(bpy_struct):
    """Collection of movie tracking tracks"""

    active: "MovieTrackingTrack"
    """ Active track in this tracking data object

    :type: 'MovieTrackingTrack'
    """

    def new(
        self,
        name: typing.Union[str, typing.Any] = "",
        frame: typing.Optional[typing.Any] = 1,
    ) -> "MovieTrackingTrack":
        """create new motion track in this movie clip

        :param name: Name of new track
        :type name: typing.Union[str, typing.Any]
        :param frame: Frame, Frame number to add tracks on
        :type frame: typing.Optional[typing.Any]
        :rtype: 'MovieTrackingTrack'
        :return: Newly created track
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingObjects(bpy_struct):
    """Collection of movie tracking objects"""

    active: "MovieTrackingObject"
    """ Active object in this tracking data object

    :type: 'MovieTrackingObject'
    """

    def new(self, name: typing.Union[str, typing.Any]) -> "MovieTrackingObject":
        """Add tracking object to this movie clip

        :param name: Name of new object
        :type name: typing.Union[str, typing.Any]
        :rtype: 'MovieTrackingObject'
        :return: New motion tracking object
        """
        ...

    def remove(self, object: "MovieTrackingObject"):
        """Remove tracking object from this movie clip

        :param object: Motion tracking object to be removed
        :type object: 'MovieTrackingObject'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingPlaneMarker(bpy_struct):
    """Match-moving plane marker data for tracking"""

    corners: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Array of coordinates which represents UI rectangle corners in frame normalized coordinates

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    frame: int
    """ Frame number marker is keyframed on

    :type: int
    """

    mute: bool
    """ Is marker muted for current frame

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingPlaneMarkers(bpy_struct):
    """Collection of markers for movie tracking plane track"""

    def find_frame(
        self,
        frame: typing.Optional[int],
        exact: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ) -> "MovieTrackingPlaneMarker":
        """Get plane marker for specified frame

        :param frame: Frame, Frame number to find marker for
        :type frame: typing.Optional[int]
        :param exact: Exact, Get plane marker at exact frame number rather than get estimated marker
        :type exact: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'MovieTrackingPlaneMarker'
        :return: Plane marker for specified frame
        """
        ...

    def insert_frame(self, frame: typing.Optional[int]) -> "MovieTrackingPlaneMarker":
        """Insert a new plane marker at the specified frame

        :param frame: Frame, Frame number to insert marker to
        :type frame: typing.Optional[int]
        :rtype: 'MovieTrackingPlaneMarker'
        :return: Newly created plane marker
        """
        ...

    def delete_frame(self, frame: typing.Optional[int]):
        """Delete plane marker at specified frame

        :param frame: Frame, Frame number to delete plane marker from
        :type frame: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingPlaneTrack(bpy_struct):
    """Match-moving plane track data for tracking"""

    image: "Image"
    """ Image displayed in the track during editing in clip editor

    :type: 'Image'
    """

    image_opacity: float
    """ Opacity of the image

    :type: float
    """

    markers: bpy_prop_collection["MovieTrackingPlaneMarker"]
    """ Collection of markers in track

    :type: bpy_prop_collection['MovieTrackingPlaneMarker']
    """

    name: typing.Union[str, typing.Any]
    """ Unique name of track

    :type: typing.Union[str, typing.Any]
    """

    select: bool
    """ Plane track is selected

    :type: bool
    """

    use_auto_keying: bool
    """ Automatic keyframe insertion when moving plane corners

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingPlaneTracks(bpy_struct):
    """Collection of movie tracking plane tracks"""

    active: "MovieTrackingPlaneTrack"
    """ Active plane track in this tracking data object. Deprecated, use objects[name].plane_tracks.active

    :type: 'MovieTrackingPlaneTrack'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingReconstructedCameras(bpy_struct):
    """Collection of solved cameras"""

    def find_frame(
        self, frame: typing.Optional[typing.Any] = 1
    ) -> "MovieReconstructedCamera":
        """Find a reconstructed camera for a give frame number

        :param frame: Frame, Frame number to find camera for
        :type frame: typing.Optional[typing.Any]
        :rtype: 'MovieReconstructedCamera'
        :return: Camera for a given frame
        """
        ...

    def matrix_from_frame(
        self, frame: typing.Optional[typing.Any] = 1
    ) -> typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]:
        """Return interpolated camera matrix for a given frame

        :param frame: Frame, Frame number to find camera for
        :type frame: typing.Optional[typing.Any]
        :rtype: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
        :return: Matrix, Interpolated camera matrix for a given frame
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingReconstruction(bpy_struct):
    """Match-moving reconstruction data from tracker"""

    average_error: float
    """ Average error of reconstruction

    :type: float
    """

    cameras: bpy_prop_collection["MovieReconstructedCamera"]
    """ Collection of solved cameras

    :type: bpy_prop_collection['MovieReconstructedCamera']
    """

    is_valid: typing.Union[bool, typing.Any]
    """ Is tracking data contains valid reconstruction information

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingSettings(bpy_struct):
    """Match moving settings"""

    clean_action: typing.Union[int, str]
    """ Cleanup action to execute

    :type: typing.Union[int, str]
    """

    clean_error: float
    """ Effect on tracks which have a larger re-projection error

    :type: float
    """

    clean_frames: int
    """ Effect on tracks which are tracked less than the specified amount of frames

    :type: int
    """

    default_correlation_min: float
    """ Default minimum value of correlation between matched pattern and reference that is still treated as successful tracking

    :type: float
    """

    default_frames_limit: int
    """ Every tracking cycle, this number of frames are tracked

    :type: int
    """

    default_margin: int
    """ Default distance from image boundary at which marker stops tracking

    :type: int
    """

    default_motion_model: typing.Union[int, str]
    """ Default motion model to use for tracking

    :type: typing.Union[int, str]
    """

    default_pattern_match: typing.Union[int, str]
    """ Track pattern from given frame when tracking marker to next frame

    :type: typing.Union[int, str]
    """

    default_pattern_size: int
    """ Size of pattern area for newly created tracks

    :type: int
    """

    default_search_size: int
    """ Size of search area for newly created tracks

    :type: int
    """

    default_weight: float
    """ Influence of newly created track on a final solution

    :type: float
    """

    distance: float
    """ Distance between two bundles used for scene scaling

    :type: float
    """

    object_distance: float
    """ Distance between two bundles used for object scaling

    :type: float
    """

    refine_intrinsics_focal_length: bool
    """ Refine focal length during camera solving

    :type: bool
    """

    refine_intrinsics_principal_point: bool
    """ Refine principal point during camera solving

    :type: bool
    """

    refine_intrinsics_radial_distortion: bool
    """ Refine radial coefficients of distortion model during camera solving

    :type: bool
    """

    refine_intrinsics_tangential_distortion: bool
    """ Refine tangential coefficients of distortion model during camera solving

    :type: bool
    """

    speed: typing.Union[int, str]
    """ Limit speed of tracking to make visual feedback easier (this does not affect the tracking quality)

    :type: typing.Union[int, str]
    """

    use_default_blue_channel: bool
    """ Use blue channel from footage for tracking

    :type: bool
    """

    use_default_brute: bool
    """ Use a brute-force translation-only initialization when tracking

    :type: bool
    """

    use_default_green_channel: bool
    """ Use green channel from footage for tracking

    :type: bool
    """

    use_default_mask: bool
    """ Use a grease pencil data-block as a mask to use only specified areas of pattern when tracking

    :type: bool
    """

    use_default_normalization: bool
    """ Normalize light intensities while tracking (slower)

    :type: bool
    """

    use_default_red_channel: bool
    """ Use red channel from footage for tracking

    :type: bool
    """

    use_keyframe_selection: bool
    """ Automatically select keyframes when solving camera/object motion

    :type: bool
    """

    use_tripod_solver: bool
    """ Use special solver to track a stable camera position, such as a tripod

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingStabilization(bpy_struct):
    """2D stabilization based on tracking markers"""

    active_rotation_track_index: int
    """ Index of active track in rotation stabilization tracks list

    :type: int
    """

    active_track_index: int
    """ Index of active track in translation stabilization tracks list

    :type: int
    """

    anchor_frame: int
    """ Reference point to anchor stabilization (other frames will be adjusted relative to this frame's position)

    :type: int
    """

    filter_type: typing.Union[int, str]
    """ Interpolation to use for sub-pixel shifts and rotations due to stabilization

    :type: typing.Union[int, str]
    """

    influence_location: float
    """ Influence of stabilization algorithm on footage location

    :type: float
    """

    influence_rotation: float
    """ Influence of stabilization algorithm on footage rotation

    :type: float
    """

    influence_scale: float
    """ Influence of stabilization algorithm on footage scale

    :type: float
    """

    rotation_tracks: bpy_prop_collection["MovieTrackingTrack"]
    """ Collection of tracks used for 2D stabilization (translation)

    :type: bpy_prop_collection['MovieTrackingTrack']
    """

    scale_max: float
    """ Limit the amount of automatic scaling

    :type: float
    """

    show_tracks_expanded: bool
    """ Show UI list of tracks participating in stabilization

    :type: bool
    """

    target_position: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Known relative offset of original shot, will be subtracted (e.g. for panning shot, can be animated)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    target_rotation: float
    """ Rotation present on original shot, will be compensated (e.g. for deliberate tilting)

    :type: float
    """

    target_scale: float
    """ Explicitly scale resulting frame to compensate zoom of original shot

    :type: float
    """

    tracks: bpy_prop_collection["MovieTrackingTrack"]
    """ Collection of tracks used for 2D stabilization (translation)

    :type: bpy_prop_collection['MovieTrackingTrack']
    """

    use_2d_stabilization: bool
    """ Use 2D stabilization for footage

    :type: bool
    """

    use_autoscale: bool
    """ Automatically scale footage to cover unfilled areas when stabilizing

    :type: bool
    """

    use_stabilize_rotation: bool
    """ Stabilize detected rotation around center of frame

    :type: bool
    """

    use_stabilize_scale: bool
    """ Compensate any scale changes relative to center of rotation

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingTrack(bpy_struct):
    """Match-moving track data for tracking"""

    average_error: float
    """ Average error of re-projection

    :type: float
    """

    bundle: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Position of bundle reconstructed from this track

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of the track in the Movie Clip Editor and the 3D viewport after a solve

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    correlation_min: float
    """ Minimal value of correlation between matched pattern and reference that is still treated as successful tracking

    :type: float
    """

    frames_limit: int
    """ Every tracking cycle, this number of frames are tracked

    :type: int
    """

    grease_pencil: "GreasePencil"
    """ Grease pencil data for this track

    :type: 'GreasePencil'
    """

    has_bundle: typing.Union[bool, typing.Any]
    """ True if track has a valid bundle

    :type: typing.Union[bool, typing.Any]
    """

    hide: bool
    """ Track is hidden

    :type: bool
    """

    lock: bool
    """ Track is locked and all changes to it are disabled

    :type: bool
    """

    margin: int
    """ Distance from image boundary at which marker stops tracking

    :type: int
    """

    markers: bpy_prop_collection["MovieTrackingMarker"]
    """ Collection of markers in track

    :type: bpy_prop_collection['MovieTrackingMarker']
    """

    motion_model: typing.Union[int, str]
    """ Default motion model to use for tracking

    :type: typing.Union[int, str]
    """

    name: typing.Union[str, typing.Any]
    """ Unique name of track

    :type: typing.Union[str, typing.Any]
    """

    offset: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Offset of track from the parenting point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    pattern_match: typing.Union[int, str]
    """ Track pattern from given frame when tracking marker to next frame

    :type: typing.Union[int, str]
    """

    select: bool
    """ Track is selected

    :type: bool
    """

    select_anchor: bool
    """ Track's anchor point is selected

    :type: bool
    """

    select_pattern: bool
    """ Track's pattern area is selected

    :type: bool
    """

    select_search: bool
    """ Track's search area is selected

    :type: bool
    """

    use_alpha_preview: bool
    """ Apply track's mask on displaying preview

    :type: bool
    """

    use_blue_channel: bool
    """ Use blue channel from footage for tracking

    :type: bool
    """

    use_brute: bool
    """ Use a brute-force translation only pre-track before refinement

    :type: bool
    """

    use_custom_color: bool
    """ Use custom color instead of theme-defined

    :type: bool
    """

    use_grayscale_preview: bool
    """ Display what the tracking algorithm sees in the preview

    :type: bool
    """

    use_green_channel: bool
    """ Use green channel from footage for tracking

    :type: bool
    """

    use_mask: bool
    """ Use a grease pencil data-block as a mask to use only specified areas of pattern when tracking

    :type: bool
    """

    use_normalization: bool
    """ Normalize light intensities while tracking. Slower

    :type: bool
    """

    use_red_channel: bool
    """ Use red channel from footage for tracking

    :type: bool
    """

    weight: float
    """ Influence of this track on a final solution

    :type: float
    """

    weight_stab: float
    """ Influence of this track on 2D stabilization

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingTracks(bpy_struct):
    """Collection of movie tracking tracks"""

    active: "MovieTrackingTrack"
    """ Active track in this tracking data object. Deprecated, use objects[name].tracks.active

    :type: 'MovieTrackingTrack'
    """

    def new(
        self,
        name: typing.Union[str, typing.Any] = "",
        frame: typing.Optional[typing.Any] = 1,
    ) -> "MovieTrackingTrack":
        """Create new motion track in this movie clip

        :param name: Name of new track
        :type name: typing.Union[str, typing.Any]
        :param frame: Frame, Frame number to add track on
        :type frame: typing.Optional[typing.Any]
        :rtype: 'MovieTrackingTrack'
        :return: Newly created track
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NlaStrip(bpy_struct):
    """A container referencing an existing Action"""

    action: "Action"
    """ Action referenced by this strip

    :type: 'Action'
    """

    action_frame_end: float
    """ Last frame from action to use

    :type: float
    """

    action_frame_start: float
    """ First frame from action to use

    :type: float
    """

    active: typing.Union[bool, typing.Any]
    """ NLA Strip is active

    :type: typing.Union[bool, typing.Any]
    """

    blend_in: float
    """ Number of frames at start of strip to fade in influence

    :type: float
    """

    blend_out: float
    """ 

    :type: float
    """

    blend_type: typing.Union[int, str]
    """ Method used for combining strip's result with accumulated result

    :type: typing.Union[int, str]
    """

    extrapolation: typing.Union[int, str]
    """ Action to take for gaps past the strip extents

    :type: typing.Union[int, str]
    """

    fcurves: bpy_prop_collection["FCurve"]
    """ F-Curves for controlling the strip's influence and timing

    :type: bpy_prop_collection['FCurve']
    """

    frame_end: float
    """ 

    :type: float
    """

    frame_end_raw: float
    """ Same as frame_end, except that any value can be set, including ones that create an invalid state

    :type: float
    """

    frame_end_ui: float
    """ End frame of the NLA strip. Note: changing this value also updates the value of the strip's repeats or its action's end frame. If only the end frame should be changed, see the "frame_end" property instead

    :type: float
    """

    frame_start: float
    """ 

    :type: float
    """

    frame_start_raw: float
    """ Same as frame_start, except that any value can be set, including ones that create an invalid state

    :type: float
    """

    frame_start_ui: float
    """ Start frame of the NLA strip. Note: changing this value also updates the value of the strip's end frame. If only the start frame should be changed, see the "frame_start" property instead

    :type: float
    """

    influence: float
    """ Amount the strip contributes to the current result

    :type: float
    """

    modifiers: bpy_prop_collection["FModifier"]
    """ Modifiers affecting all the F-Curves in the referenced Action

    :type: bpy_prop_collection['FModifier']
    """

    mute: bool
    """ Disable NLA Strip evaluation

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    repeat: float
    """ Number of times to repeat the action range

    :type: float
    """

    scale: float
    """ Scaling factor for action

    :type: float
    """

    select: bool
    """ NLA Strip is selected

    :type: bool
    """

    strip_time: float
    """ Frame of referenced Action to evaluate

    :type: float
    """

    strips: bpy_prop_collection["NlaStrip"]
    """ NLA Strips that this strip acts as a container for (if it is of type Meta)

    :type: bpy_prop_collection['NlaStrip']
    """

    type: typing.Union[int, str]
    """ Type of NLA Strip

    :type: typing.Union[int, str]
    """

    use_animated_influence: bool
    """ Influence setting is controlled by an F-Curve rather than automatically determined

    :type: bool
    """

    use_animated_time: bool
    """ Strip time is controlled by an F-Curve rather than automatically determined

    :type: bool
    """

    use_animated_time_cyclic: bool
    """ Cycle the animated time within the action start and end

    :type: bool
    """

    use_auto_blend: bool
    """ Number of frames for Blending In/Out is automatically determined from overlapping strips

    :type: bool
    """

    use_reverse: bool
    """ NLA Strip is played back in reverse order (only when timing is automatically determined)

    :type: bool
    """

    use_sync_length: bool
    """ Update range of frames referenced from action after tweaking strip and its keyframes

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NlaStripFCurves(bpy_struct):
    """Collection of NLA strip F-Curves"""

    def find(
        self,
        data_path: typing.Union[str, typing.Any],
        index: typing.Optional[typing.Any] = 0,
    ) -> "FCurve":
        """Find an F-Curve. Note that this function performs a linear scan of all F-Curves in the NLA strip.

        :param data_path: Data Path, F-Curve data path
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, Array index
        :type index: typing.Optional[typing.Any]
        :rtype: 'FCurve'
        :return: The found F-Curve, or None if it doesn't exist
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NlaStrips(bpy_struct):
    """Collection of NLA Strips"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        start: typing.Optional[int],
        action: "Action",
    ) -> "NlaStrip":
        """Add a new Action-Clip strip to the track

        :param name: Name for the NLA Strips
        :type name: typing.Union[str, typing.Any]
        :param start: Start Frame, Start frame for this strip
        :type start: typing.Optional[int]
        :param action: Action to assign to this strip
        :type action: 'Action'
        :rtype: 'NlaStrip'
        :return: New NLA Strip
        """
        ...

    def remove(self, strip: "NlaStrip"):
        """Remove a NLA Strip

        :param strip: NLA Strip to remove
        :type strip: 'NlaStrip'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NlaTrack(bpy_struct):
    """An animation layer containing Actions referenced as NLA strips"""

    active: typing.Union[bool, typing.Any]
    """ NLA Track is active

    :type: typing.Union[bool, typing.Any]
    """

    is_override_data: typing.Union[bool, typing.Any]
    """ In a local override data, whether this NLA track comes from the linked reference data, or is local to the override

    :type: typing.Union[bool, typing.Any]
    """

    is_solo: bool
    """ NLA Track is evaluated itself (i.e. active Action and all other NLA Tracks in the same AnimData block are disabled)

    :type: bool
    """

    lock: bool
    """ NLA Track is locked

    :type: bool
    """

    mute: bool
    """ Disable NLA Track evaluation

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    select: bool
    """ NLA Track is selected

    :type: bool
    """

    strips: bpy_prop_collection["NlaStrip"]
    """ NLA Strips on this NLA-track

    :type: bpy_prop_collection['NlaStrip']
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NlaTracks(bpy_struct):
    """Collection of NLA Tracks"""

    active: "NlaTrack"
    """ Active NLA Track

    :type: 'NlaTrack'
    """

    def new(self, prev: typing.Optional["NlaTrack"] = None) -> "NlaTrack":
        """Add a new NLA Track

        :param prev: NLA Track to add the new one after
        :type prev: typing.Optional['NlaTrack']
        :rtype: 'NlaTrack'
        :return: New NLA Track
        """
        ...

    def remove(self, track: "NlaTrack"):
        """Remove a NLA Track

        :param track: NLA Track to remove
        :type track: 'NlaTrack'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Node(bpy_struct):
    """Node in a node tree"""

    bl_description: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_height_default: float
    """ 

    :type: float
    """

    bl_height_max: float
    """ 

    :type: float
    """

    bl_height_min: float
    """ 

    :type: float
    """

    bl_icon: typing.Union[int, str]
    """ The node icon

    :type: typing.Union[int, str]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ The node label

    :type: typing.Union[str, typing.Any]
    """

    bl_static_type: typing.Union[int, str]
    """ Node type (deprecated, use with care)

    :type: typing.Union[int, str]
    """

    bl_width_default: float
    """ 

    :type: float
    """

    bl_width_max: float
    """ 

    :type: float
    """

    bl_width_min: float
    """ 

    :type: float
    """

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Custom color of the node body

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    dimensions: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Absolute bounding box dimensions of the node

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    height: float
    """ Height of the node

    :type: float
    """

    hide: bool
    """ 

    :type: bool
    """

    inputs: bpy_prop_collection["NodeSocket"]
    """ 

    :type: bpy_prop_collection['NodeSocket']
    """

    internal_links: bpy_prop_collection["NodeLink"]
    """ Internal input-to-output connections for muting

    :type: bpy_prop_collection['NodeLink']
    """

    label: typing.Union[str, typing.Any]
    """ Optional custom node label

    :type: typing.Union[str, typing.Any]
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    mute: bool
    """ 

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Unique node identifier

    :type: typing.Union[str, typing.Any]
    """

    outputs: bpy_prop_collection["NodeSocket"]
    """ 

    :type: bpy_prop_collection['NodeSocket']
    """

    parent: "Node"
    """ Parent this node is attached to

    :type: 'Node'
    """

    select: bool
    """ Node selection state

    :type: bool
    """

    show_options: bool
    """ 

    :type: bool
    """

    show_preview: bool
    """ 

    :type: bool
    """

    show_texture: bool
    """ Display node in viewport textured shading mode

    :type: bool
    """

    type: typing.Union[int, str]
    """ Node type (deprecated, use bl_static_type or bl_idname for the actual identifier string)

    :type: typing.Union[int, str]
    """

    use_custom_color: bool
    """ Use custom color for the node

    :type: bool
    """

    width: float
    """ Width of the node

    :type: float
    """

    def socket_value_update(self, context: "Context"):
        """Update after property changes

        :param context:
        :type context: 'Context'
        """
        ...

    def is_registered_node_type(self) -> bool:
        """True if a registered node type

        :rtype: bool
        :return: Result
        """
        ...

    def poll(self, node_tree: typing.Optional["NodeTree"]) -> bool:
        """If non-null output is returned, the node type can be added to the tree

        :param node_tree: Node Tree
        :type node_tree: typing.Optional['NodeTree']
        :rtype: bool
        """
        ...

    def poll_instance(self, node_tree: typing.Optional["NodeTree"]) -> bool:
        """If non-null output is returned, the node can be added to the tree

        :param node_tree: Node Tree
        :type node_tree: typing.Optional['NodeTree']
        :rtype: bool
        """
        ...

    def update(self):
        """Update on node graph topology changes (adding or removing nodes and links)"""
        ...

    def insert_link(self, link: "NodeLink"):
        """Handle creation of a link to or from the node

        :param link: Link, Node link that will be inserted
        :type link: 'NodeLink'
        """
        ...

    def init(self, context: "Context"):
        """Initialize a new instance of this node

        :param context:
        :type context: 'Context'
        """
        ...

    def copy(self, node: "Node"):
        """Initialize a new instance of this node from an existing node

        :param node: Node, Existing node to copy
        :type node: 'Node'
        """
        ...

    def free(self):
        """Clean up node on removal"""
        ...

    def draw_buttons(self, context: "Context", layout: "UILayout"):
        """Draw node buttons

        :param context:
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        """
        ...

    def draw_buttons_ext(self, context: "Context", layout: "UILayout"):
        """Draw node buttons in the sidebar

        :param context:
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        """
        ...

    def draw_label(self) -> typing.Union[str, typing.Any]:
        """Returns a dynamic label string

        :rtype: typing.Union[str, typing.Any]
        :return: Label
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeEnumDefinition(bpy_struct):
    """Definition of an enumeration for nodes"""

    active_index: int
    """ Index of the active item

    :type: int
    """

    active_item: "NodeEnumItem"
    """ Active item

    :type: 'NodeEnumItem'
    """

    enum_items: bpy_prop_collection["NodeEnumItem"]
    """ 

    :type: bpy_prop_collection['NodeEnumItem']
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeEnumDefinitionItems(bpy_struct):
    """Collection of items that make up an enum"""

    def new(self, name: typing.Union[str, typing.Any]) -> "NodeEnumItem":
        """Add an a new enum item

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'NodeEnumItem'
        :return: Item, New item
        """
        ...

    def remove(self, item: "NodeEnumItem"):
        """Remove an item from this enum

        :param item: Item, The item to remove
        :type item: 'NodeEnumItem'
        """
        ...

    def clear(self):
        """Remove all items from this enum"""
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move an item to another position

        :param from_index: From Index, Index of the item to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index for the item
        :type to_index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeEnumItem(bpy_struct):
    description: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeGeometryBakeItem(bpy_struct):
    attribute_domain: typing.Union[int, str]
    """ Attribute domain where the attribute is stored in the baked data

    :type: typing.Union[int, str]
    """

    color: bpy_prop_array[float]
    """ Color of the corresponding socket type in the node editor

    :type: bpy_prop_array[float]
    """

    is_attribute: bool
    """ Bake item is an attribute stored on a geometry

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    socket_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeGeometryBakeItems(bpy_struct):
    """Collection of bake items"""

    def new(
        self,
        socket_type: typing.Optional[typing.Union[int, str]],
        name: typing.Union[str, typing.Any],
    ) -> "NodeGeometryBakeItem":
        """Add an item at the end

        :param socket_type: Socket Type, Socket type of the item
        :type socket_type: typing.Optional[typing.Union[int, str]]
        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'NodeGeometryBakeItem'
        :return: Item, New item
        """
        ...

    def remove(self, item: "NodeGeometryBakeItem"):
        """Remove an item

        :param item: Item, The item to remove
        :type item: 'NodeGeometryBakeItem'
        """
        ...

    def clear(self):
        """Remove all items"""
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move an item to another position

        :param from_index: From Index, Index of the item to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index for the item
        :type to_index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeGeometryRepeatOutputItems(bpy_struct):
    """Collection of repeat items"""

    def new(
        self,
        socket_type: typing.Optional[typing.Union[int, str]],
        name: typing.Union[str, typing.Any],
    ) -> "RepeatItem":
        """Add an item at the end

        :param socket_type: Socket Type, Socket type of the item
        :type socket_type: typing.Optional[typing.Union[int, str]]
        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'RepeatItem'
        :return: Item, New item
        """
        ...

    def remove(self, item: "RepeatItem"):
        """Remove an item

        :param item: Item, The item to remove
        :type item: 'RepeatItem'
        """
        ...

    def clear(self):
        """Remove all items"""
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move an item to another position

        :param from_index: From Index, Index of the item to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index for the item
        :type to_index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeGeometrySimulationOutputItems(bpy_struct):
    """Collection of simulation items"""

    def new(
        self,
        socket_type: typing.Optional[typing.Union[int, str]],
        name: typing.Union[str, typing.Any],
    ) -> "SimulationStateItem":
        """Add an item at the end

        :param socket_type: Socket Type, Socket type of the item
        :type socket_type: typing.Optional[typing.Union[int, str]]
        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'SimulationStateItem'
        :return: Item, New item
        """
        ...

    def remove(self, item: "SimulationStateItem"):
        """Remove an item

        :param item: Item, The item to remove
        :type item: 'SimulationStateItem'
        """
        ...

    def clear(self):
        """Remove all items"""
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move an item to another position

        :param from_index: From Index, Index of the item to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index for the item
        :type to_index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeIndexSwitchItems(bpy_struct):
    """Collection of index_switch items"""

    def new(self) -> "IndexSwitchItem":
        """Add an item at the end

        :rtype: 'IndexSwitchItem'
        :return: Item, New item
        """
        ...

    def remove(self, item: "IndexSwitchItem"):
        """Remove an item

        :param item: Item, The item to remove
        :type item: 'IndexSwitchItem'
        """
        ...

    def clear(self):
        """Remove all items"""
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move an item to another position

        :param from_index: From Index, Index of the item to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index for the item
        :type to_index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeInputs(bpy_struct):
    """Collection of Node Sockets"""

    def new(
        self,
        type: typing.Union[str, typing.Any],
        name: typing.Union[str, typing.Any],
        identifier: typing.Union[str, typing.Any] = "",
        use_multi_input: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "NodeSocket":
        """Add a socket to this node

        :param type: Type, Data type
        :type type: typing.Union[str, typing.Any]
        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :param identifier: Identifier, Unique socket identifier
        :type identifier: typing.Union[str, typing.Any]
        :param use_multi_input: Make the socket a multi-input. Only valid for inputs
        :type use_multi_input: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'NodeSocket'
        :return: New socket
        """
        ...

    def remove(self, socket: typing.Optional["NodeSocket"]):
        """Remove a socket from this node

        :param socket: The socket to remove
        :type socket: typing.Optional['NodeSocket']
        """
        ...

    def clear(self):
        """Remove all sockets from this node"""
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move a socket to another position

        :param from_index: From Index, Index of the socket to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index for the socket
        :type to_index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeInstanceHash(bpy_struct):
    """Hash table containing node instance data"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeInternalSocketTemplate(bpy_struct):
    """Type and default value of a node socket"""

    identifier: typing.Union[str, typing.Any]
    """ Identifier of the socket

    :type: typing.Union[str, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Name of the socket

    :type: typing.Union[str, typing.Any]
    """

    type: typing.Any
    """ Data type of the socket

    :type: typing.Any
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeLink(bpy_struct):
    """Link between nodes in a node tree"""

    from_node: "Node"
    """ 

    :type: 'Node'
    """

    from_socket: "NodeSocket"
    """ 

    :type: 'NodeSocket'
    """

    is_hidden: typing.Union[bool, typing.Any]
    """ Link is hidden due to invisible sockets

    :type: typing.Union[bool, typing.Any]
    """

    is_muted: bool
    """ Link is muted and can be ignored

    :type: bool
    """

    is_valid: bool
    """ Link is valid

    :type: bool
    """

    multi_input_sort_id: int
    """ Used to sort multiple links coming into the same input. The highest ID is at the top

    :type: int
    """

    to_node: "Node"
    """ 

    :type: 'Node'
    """

    to_socket: "NodeSocket"
    """ 

    :type: 'NodeSocket'
    """

    def swap_multi_input_sort_id(self, other: "NodeLink"):
        """Swap the order of two links connected to the same multi-input socket

        :param other: Other, The other link. Must link to the same multi input socket
        :type other: 'NodeLink'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeLinks(bpy_struct):
    """Collection of Node Links"""

    def new(
        self,
        input: "NodeSocket",
        output: "NodeSocket",
        verify_limits: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ) -> "NodeLink":
        """Add a node link to this node tree

        :param input: The input socket
        :type input: 'NodeSocket'
        :param output: The output socket
        :type output: 'NodeSocket'
        :param verify_limits: Verify Limits, Remove existing links if connection limit is exceeded
        :type verify_limits: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'NodeLink'
        :return: New node link
        """
        ...

    def remove(self, link: "NodeLink"):
        """remove a node link from the node tree

        :param link: The node link to remove
        :type link: 'NodeLink'
        """
        ...

    def clear(self):
        """remove all node links from the node tree"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeOutputFileSlotFile(bpy_struct):
    """Single layer file slot of the file output node"""

    format: "ImageFormatSettings"
    """ 

    :type: 'ImageFormatSettings'
    """

    path: typing.Union[str, typing.Any]
    """ Subpath used for this slot

    :type: typing.Union[str, typing.Any]
    """

    save_as_render: bool
    """ Apply render part of display transform when saving byte image

    :type: bool
    """

    use_node_format: bool
    """ 

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeOutputFileSlotLayer(bpy_struct):
    """Multilayer slot of the file output node"""

    name: typing.Union[str, typing.Any]
    """ OpenEXR layer name used for this slot

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeOutputs(bpy_struct):
    """Collection of Node Sockets"""

    def new(
        self,
        type: typing.Union[str, typing.Any],
        name: typing.Union[str, typing.Any],
        identifier: typing.Union[str, typing.Any] = "",
        use_multi_input: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "NodeSocket":
        """Add a socket to this node

        :param type: Type, Data type
        :type type: typing.Union[str, typing.Any]
        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :param identifier: Identifier, Unique socket identifier
        :type identifier: typing.Union[str, typing.Any]
        :param use_multi_input: Make the socket a multi-input. Only valid for inputs
        :type use_multi_input: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'NodeSocket'
        :return: New socket
        """
        ...

    def remove(self, socket: typing.Optional["NodeSocket"]):
        """Remove a socket from this node

        :param socket: The socket to remove
        :type socket: typing.Optional['NodeSocket']
        """
        ...

    def clear(self):
        """Remove all sockets from this node"""
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move a socket to another position

        :param from_index: From Index, Index of the socket to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index for the socket
        :type to_index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeSocket(bpy_struct):
    """Input or output socket of a node"""

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ Label to display for the socket type in the UI

    :type: typing.Union[str, typing.Any]
    """

    bl_subtype_label: typing.Union[str, typing.Any]
    """ Label to display for the socket subtype in the UI

    :type: typing.Union[str, typing.Any]
    """

    description: typing.Union[str, typing.Any]
    """ Socket tooltip

    :type: typing.Union[str, typing.Any]
    """

    display_shape: typing.Union[int, str]
    """ Socket shape

    :type: typing.Union[int, str]
    """

    enabled: bool
    """ Enable the socket

    :type: bool
    """

    hide: bool
    """ Hide the socket

    :type: bool
    """

    hide_value: bool
    """ Hide the socket input value

    :type: bool
    """

    identifier: typing.Union[str, typing.Any]
    """ Unique identifier for mapping sockets

    :type: typing.Union[str, typing.Any]
    """

    is_linked: typing.Union[bool, typing.Any]
    """ True if the socket is connected

    :type: typing.Union[bool, typing.Any]
    """

    is_multi_input: typing.Union[bool, typing.Any]
    """ True if the socket can accept multiple ordered input links

    :type: typing.Union[bool, typing.Any]
    """

    is_output: typing.Union[bool, typing.Any]
    """ True if the socket is an output, otherwise input

    :type: typing.Union[bool, typing.Any]
    """

    is_unavailable: typing.Union[bool, typing.Any]
    """ True if the socket is unavailable

    :type: typing.Union[bool, typing.Any]
    """

    label: typing.Union[str, typing.Any]
    """ Custom dynamic defined socket label

    :type: typing.Union[str, typing.Any]
    """

    link_limit: int
    """ Max number of links allowed for this socket

    :type: int
    """

    name: typing.Union[str, typing.Any]
    """ Socket name

    :type: typing.Union[str, typing.Any]
    """

    node: "Node"
    """ Node owning this socket

    :type: 'Node'
    """

    show_expanded: bool
    """ Socket links are expanded in the user interface

    :type: bool
    """

    type: typing.Union[int, str]
    """ Data type

    :type: typing.Union[int, str]
    """

    links: typing.Any
    """ List of node links from or to this socket.(readonly)"""

    def draw(
        self,
        context: "Context",
        layout: "UILayout",
        node: "Node",
        text: typing.Union[str, typing.Any],
    ):
        """Draw socket

        :param context:
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        :param node: Node, Node the socket belongs to
        :type node: 'Node'
        :param text: Text, Text label to draw alongside properties
        :type text: typing.Union[str, typing.Any]
        """
        ...

    def draw_color(self, context: "Context", node: "Node") -> bpy_prop_array[float]:
        """Color of the socket icon

        :param context:
        :type context: 'Context'
        :param node: Node, Node the socket belongs to
        :type node: 'Node'
        :rtype: bpy_prop_array[float]
        :return: Color
        """
        ...

    def draw_color_simple(self) -> bpy_prop_array[float]:
        """Color of the socket icon. Used to draw sockets in places where the socket does not belong to a node, like the node interface panel. Also used to draw node sockets if draw_color is not defined

        :rtype: bpy_prop_array[float]
        :return: Color
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeTreeInterface(bpy_struct):
    """Declaration of sockets and ui panels of a node group"""

    active: "NodeTreeInterfaceItem"
    """ Active item

    :type: 'NodeTreeInterfaceItem'
    """

    active_index: int
    """ Index of the active item

    :type: int
    """

    items_tree: bpy_prop_collection["NodeTreeInterfaceItem"]
    """ Items in the node interface

    :type: bpy_prop_collection['NodeTreeInterfaceItem']
    """

    def new_socket(
        self,
        name: typing.Union[str, typing.Any],
        description: typing.Union[str, typing.Any] = "",
        in_out: typing.Optional[typing.Any] = "INPUT",
        socket_type: typing.Optional[typing.Union[int, str, typing.Any]] = "DEFAULT",
        parent: typing.Optional["NodeTreeInterfacePanel"] = None,
    ) -> "NodeTreeInterfaceSocket":
        """Add a new socket to the interface

                :param name: Name, Name of the socket
                :type name: typing.Union[str, typing.Any]
                :param description: Description, Description of the socket
                :type description: typing.Union[str, typing.Any]
                :param in_out: Input/Output Type, Create an input or output socket

        INPUT
        Input -- Generate a input node socket.

        OUTPUT
        Output -- Generate a output node socket.
                :type in_out: typing.Optional[typing.Any]
                :param socket_type: Socket Type, Type of socket generated on nodes
                :type socket_type: typing.Optional[typing.Union[int, str, typing.Any]]
                :param parent: Parent, Panel to add the socket in
                :type parent: typing.Optional['NodeTreeInterfacePanel']
                :rtype: 'NodeTreeInterfaceSocket'
                :return: Socket, New socket
        """
        ...

    def new_panel(
        self,
        name: typing.Union[str, typing.Any],
        description: typing.Union[str, typing.Any] = "",
        default_closed: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "NodeTreeInterfacePanel":
        """Add a new panel to the interface

        :param name: Name, Name of the new panel
        :type name: typing.Union[str, typing.Any]
        :param description: Description, Description of the panel
        :type description: typing.Union[str, typing.Any]
        :param default_closed: Default Closed, Panel is closed by default on new nodes
        :type default_closed: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'NodeTreeInterfacePanel'
        :return: Panel, New panel
        """
        ...

    def copy(self, item: "NodeTreeInterfaceItem") -> "NodeTreeInterfaceItem":
        """Add a copy of an item to the interface

        :param item: Item, Item to copy
        :type item: 'NodeTreeInterfaceItem'
        :rtype: 'NodeTreeInterfaceItem'
        :return: Item Copy, Copy of the item
        """
        ...

    def remove(
        self,
        item: "NodeTreeInterfaceItem",
        move_content_to_parent: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove an item from the interface

        :param item: Item, The item to remove
        :type item: 'NodeTreeInterfaceItem'
        :param move_content_to_parent: Move Content, If the item is a panel, move the contents to the parent instead of deleting it
        :type move_content_to_parent: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def clear(self):
        """Remove all items from the interface"""
        ...

    def move(self, item: "NodeTreeInterfaceItem", to_position: typing.Optional[int]):
        """Move an item to another position

        :param item: Item, The item to move
        :type item: 'NodeTreeInterfaceItem'
        :param to_position: To Position, Target position for the item in its current panel
        :type to_position: typing.Optional[int]
        """
        ...

    def move_to_parent(
        self,
        item: "NodeTreeInterfaceItem",
        parent: typing.Optional["NodeTreeInterfacePanel"],
        to_position: typing.Optional[int],
    ):
        """Move an item to a new panel and/or position.

        :param item: Item, The item to move
        :type item: 'NodeTreeInterfaceItem'
        :param parent: Parent, New parent of the item
        :type parent: typing.Optional['NodeTreeInterfacePanel']
        :param to_position: To Position, Target position for the item in the new parent panel
        :type to_position: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeTreeInterfaceItem(bpy_struct):
    """Item in a node tree interface"""

    index: int
    """ Global index of the item among all items in the interface

    :type: int
    """

    item_type: typing.Any
    """ Type of interface item

    :type: typing.Any
    """

    parent: "NodeTreeInterfacePanel"
    """ Panel that contains the item

    :type: 'NodeTreeInterfacePanel'
    """

    position: int
    """ Position of the item in its parent panel

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeTreePath(bpy_struct):
    """Element of the node space tree path"""

    node_tree: "NodeTree"
    """ Base node tree from context

    :type: 'NodeTree'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Nodes(bpy_struct):
    """Collection of Nodes"""

    active: "Node"
    """ Active node in this tree

    :type: 'Node'
    """

    def new(self, type: typing.Union[str, typing.Any]) -> "Node":
        """Add a node to this node tree

        :param type: Type, Type of node to add (Warning: should be same as node.bl_idname, not node.type!)
        :type type: typing.Union[str, typing.Any]
        :rtype: 'Node'
        :return: New node
        """
        ...

    def remove(self, node: "Node"):
        """Remove a node from this node tree

        :param node: The node to remove
        :type node: 'Node'
        """
        ...

    def clear(self):
        """Remove all nodes from this node tree"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodesModifierBake(bpy_struct):
    bake_id: int
    """ Identifier for this bake which remains unchanged even when the bake node is renamed, grouped or ungrouped

    :type: int
    """

    bake_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    data_blocks: bpy_prop_collection["NodesModifierDataBlock"]
    """ 

    :type: bpy_prop_collection['NodesModifierDataBlock']
    """

    directory: typing.Union[str, typing.Any]
    """ Location on disk where the bake data is stored

    :type: typing.Union[str, typing.Any]
    """

    frame_end: int
    """ Frame where the baking ends

    :type: int
    """

    frame_start: int
    """ Frame where the baking starts

    :type: int
    """

    node: "Node"
    """ Bake node or simulation output node that corresponds to this bake. This node may be deeply nested in the modifier node group. It can be none in some cases like missing linked data blocks

    :type: 'Node'
    """

    use_custom_path: bool
    """ Specify a path where the baked data should be stored manually

    :type: bool
    """

    use_custom_simulation_frame_range: bool
    """ Override the simulation frame range from the scene

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodesModifierBakeDataBlocks(bpy_struct):
    """Collection of data-blocks that can be referenced by baked data"""

    active_index: int
    """ 

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodesModifierBakes(bpy_struct):
    """Bake data for every bake node"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodesModifierDataBlock(bpy_struct):
    id: "ID"
    """ 

    :type: 'ID'
    """

    id_name: typing.Union[str, typing.Any]
    """ Name that is mapped to the referenced data-block

    :type: typing.Union[str, typing.Any]
    """

    id_type: typing.Any
    """ 

    :type: typing.Any
    """

    lib_name: typing.Union[str, typing.Any]
    """ Used when the data block is not local to the current .blend file but is linked from some library

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodesModifierPanel(bpy_struct):
    is_open: bool
    """ Whether the panel is expanded or closed

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodesModifierPanels(bpy_struct):
    """State of all panels defined by the node group"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ObjectBase(bpy_struct):
    """An object instance in a render layer"""

    hide_viewport: bool
    """ Temporarily hide in viewport

    :type: bool
    """

    object: "Object"
    """ Object this base links to

    :type: 'Object'
    """

    select: bool
    """ Object base selection state

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ObjectConstraints(bpy_struct):
    """Collection of object constraints"""

    active: "Constraint"
    """ Active Object constraint

    :type: 'Constraint'
    """

    def new(self, type: typing.Optional[typing.Union[int, str]]) -> "Constraint":
        """Add a new constraint to this object

        :param type: Constraint type to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'Constraint'
        :return: New constraint
        """
        ...

    def remove(self, constraint: "Constraint"):
        """Remove a constraint from this object

        :param constraint: Removed constraint
        :type constraint: 'Constraint'
        """
        ...

    def clear(self):
        """Remove all constraint from this object"""
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move a constraint to a different position

        :param from_index: From Index, Index to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index
        :type to_index: typing.Optional[int]
        """
        ...

    def copy(self, constraint: "Constraint") -> "Constraint":
        """Add a new constraint that is a copy of the given one

        :param constraint: Constraint to copy - may belong to a different object
        :type constraint: 'Constraint'
        :rtype: 'Constraint'
        :return: New constraint
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ObjectDisplay(bpy_struct):
    """Object display settings for 3D viewport"""

    show_shadows: bool
    """ Object cast shadows in the 3D viewport

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ObjectGpencilModifiers(bpy_struct):
    """Collection of object grease pencil modifiers"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ) -> "GpencilModifier":
        """Add a new greasepencil_modifier

        :param name: New name for the greasepencil_modifier
        :type name: typing.Union[str, typing.Any]
        :param type: Modifier type to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'GpencilModifier'
        :return: Newly created modifier
        """
        ...

    def remove(self, greasepencil_modifier: "GpencilModifier"):
        """Remove an existing greasepencil_modifier from the object

        :param greasepencil_modifier: Modifier to remove
        :type greasepencil_modifier: 'GpencilModifier'
        """
        ...

    def clear(self):
        """Remove all grease pencil modifiers from the object"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ObjectLightLinking(bpy_struct):
    blocker_collection: "Collection"
    """ Collection which defines objects which block light from this emitter

    :type: 'Collection'
    """

    receiver_collection: "Collection"
    """ Collection which defines light linking relation of this emitter

    :type: 'Collection'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ObjectLineArt(bpy_struct):
    """Object line art settings"""

    crease_threshold: float
    """ Angles smaller than this will be treated as creases

    :type: float
    """

    intersection_priority: int
    """ The intersection line will be included into the object with the higher intersection priority value

    :type: int
    """

    usage: typing.Union[int, str]
    """ How to use this object in line art calculation

    :type: typing.Union[int, str]
    """

    use_crease_override: bool
    """ Use this object's crease setting to overwrite scene global

    :type: bool
    """

    use_intersection_priority_override: bool
    """ Use this object's intersection priority to override collection setting

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ObjectModifiers(bpy_struct):
    """Collection of object modifiers"""

    active: "Modifier"
    """ The active modifier in the list

    :type: 'Modifier'
    """

    def new(
        self,
        name: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ) -> "Modifier":
        """Add a new modifier

        :param name: New name for the modifier
        :type name: typing.Union[str, typing.Any]
        :param type: Modifier type to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'Modifier'
        :return: Newly created modifier
        """
        ...

    def remove(self, modifier: "Modifier"):
        """Remove an existing modifier from the object

        :param modifier: Modifier to remove
        :type modifier: 'Modifier'
        """
        ...

    def clear(self):
        """Remove all modifiers from the object"""
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move a modifier to a different position

        :param from_index: From Index, Index to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index
        :type to_index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ObjectShaderFx(bpy_struct):
    """Collection of object effects"""

    def new(
        self,
        name: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ) -> "ShaderFx":
        """Add a new shader fx

        :param name: New name for the effect
        :type name: typing.Union[str, typing.Any]
        :param type: Effect type to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'ShaderFx'
        :return: Newly created effect
        """
        ...

    def remove(self, shader_fx: "ShaderFx"):
        """Remove an existing effect from the object

        :param shader_fx: Effect to remove
        :type shader_fx: 'ShaderFx'
        """
        ...

    def clear(self):
        """Remove all effects from the object"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class OperatorMacro(bpy_struct):
    """Storage of a sub operator in a macro after it has been added"""

    properties: "OperatorProperties"
    """ 

    :type: 'OperatorProperties'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class OperatorOptions(bpy_struct):
    """Runtime options"""

    is_grab_cursor: typing.Union[bool, typing.Any]
    """ True when the cursor is grabbed

    :type: typing.Union[bool, typing.Any]
    """

    is_invoke: typing.Union[bool, typing.Any]
    """ True when invoked (even if only the execute callbacks available)

    :type: typing.Union[bool, typing.Any]
    """

    is_repeat: typing.Union[bool, typing.Any]
    """ True when run from the 'Adjust Last Operation' panel

    :type: typing.Union[bool, typing.Any]
    """

    is_repeat_last: typing.Union[bool, typing.Any]
    """ True when run from the operator 'Repeat Last'

    :type: typing.Union[bool, typing.Any]
    """

    use_cursor_region: bool
    """ Enable to use the region under the cursor for modal execution

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class OperatorProperties(bpy_struct):
    """Input properties of an operator"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PackedFile(bpy_struct):
    """External file packed into the .blend file"""

    data: typing.Union[str, typing.Any]
    """ Raw data (bytes, exact content of the embedded file)

    :type: typing.Union[str, typing.Any]
    """

    size: int
    """ Size of packed file in bytes

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Paint(bpy_struct):
    brush: "Brush"
    """ Active Brush

    :type: 'Brush'
    """

    cavity_curve: "CurveMapping"
    """ Editable cavity curve

    :type: 'CurveMapping'
    """

    palette: "Palette"
    """ Active Palette

    :type: 'Palette'
    """

    show_brush: bool
    """ 

    :type: bool
    """

    show_brush_on_surface: bool
    """ 

    :type: bool
    """

    show_low_resolution: bool
    """ For multires, show low resolution while navigating the view

    :type: bool
    """

    tile_offset: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Stride at which tiled strokes are copied

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    tile_x: bool
    """ Tile along X axis

    :type: bool
    """

    tile_y: bool
    """ Tile along Y axis

    :type: bool
    """

    tile_z: bool
    """ Tile along Z axis

    :type: bool
    """

    tool_slots: bpy_prop_collection["PaintToolSlot"]
    """ 

    :type: bpy_prop_collection['PaintToolSlot']
    """

    use_cavity: bool
    """ Mask painting according to mesh geometry cavity

    :type: bool
    """

    use_sculpt_delay_updates: bool
    """ Update the geometry when it enters the view, providing faster view navigation

    :type: bool
    """

    use_symmetry_feather: bool
    """ Reduce the strength of the brush where it overlaps symmetrical daubs

    :type: bool
    """

    use_symmetry_x: bool
    """ Mirror brush across the X axis

    :type: bool
    """

    use_symmetry_y: bool
    """ Mirror brush across the Y axis

    :type: bool
    """

    use_symmetry_z: bool
    """ Mirror brush across the Z axis

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PaintModeSettings(bpy_struct):
    """Properties of paint mode"""

    canvas_image: "Image"
    """ Image used as painting target

    :type: 'Image'
    """

    canvas_source: typing.Union[int, str]
    """ Source to select canvas from

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PaintToolSlot(bpy_struct):
    brush: "Brush"
    """ 

    :type: 'Brush'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PaletteColor(bpy_struct):
    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    strength: float
    """ 

    :type: float
    """

    weight: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PaletteColors(bpy_struct):
    """Collection of palette colors"""

    active: "PaletteColor"
    """ 

    :type: 'PaletteColor'
    """

    def new(self) -> "PaletteColor":
        """Add a new color to the palette

        :rtype: 'PaletteColor'
        :return: The newly created color
        """
        ...

    def remove(self, color: "PaletteColor"):
        """Remove a color from the palette

        :param color: The color to remove
        :type color: 'PaletteColor'
        """
        ...

    def clear(self):
        """Remove all colors from the palette"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Particle(bpy_struct):
    """Particle in a particle system"""

    alive_state: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    angular_velocity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    birth_time: float
    """ 

    :type: float
    """

    die_time: float
    """ 

    :type: float
    """

    hair_keys: bpy_prop_collection["ParticleHairKey"]
    """ 

    :type: bpy_prop_collection['ParticleHairKey']
    """

    is_exist: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    is_visible: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    lifetime: float
    """ 

    :type: float
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    particle_keys: bpy_prop_collection["ParticleKey"]
    """ 

    :type: bpy_prop_collection['ParticleKey']
    """

    prev_angular_velocity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    prev_location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    prev_rotation: typing.Union[
        "mathutils.Quaternion",
        typing.List[float],
        typing.Tuple[float, float, float, float],
    ]
    """ 

    :type: typing.Union['mathutils.Quaternion', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    prev_velocity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    rotation: typing.Union[
        "mathutils.Quaternion",
        typing.List[float],
        typing.Tuple[float, float, float, float],
    ]
    """ 

    :type: typing.Union['mathutils.Quaternion', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    size: float
    """ 

    :type: float
    """

    velocity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    def uv_on_emitter(
        self, modifier: "ParticleSystemModifier"
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]:
        """Obtain UV coordinates for a particle on an evaluated mesh.

        :param modifier: Particle modifier from an evaluated object
        :type modifier: 'ParticleSystemModifier'
        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
        :return: uv
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleBrush(bpy_struct):
    """Particle editing brush"""

    count: int
    """ Particle count

    :type: int
    """

    curve: "CurveMapping"
    """ 

    :type: 'CurveMapping'
    """

    length_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    puff_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    size: int
    """ Radius of the brush in pixels

    :type: int
    """

    steps: int
    """ Brush steps

    :type: int
    """

    strength: float
    """ Brush strength

    :type: float
    """

    use_puff_volume: bool
    """ Apply puff to unselected end-points (helps maintain hair volume when puffing root)

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleDupliWeight(bpy_struct):
    """Weight of a particle instance object in a collection"""

    count: int
    """ The number of times this object is repeated with respect to other objects

    :type: int
    """

    name: typing.Union[str, typing.Any]
    """ Particle instance object name

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleEdit(bpy_struct):
    """Properties of particle editing mode"""

    brush: "ParticleBrush"
    """ 

    :type: 'ParticleBrush'
    """

    default_key_count: int
    """ How many keys to make new particles with

    :type: int
    """

    display_step: int
    """ How many steps to display the path with

    :type: int
    """

    emitter_distance: float
    """ Distance to keep particles away from the emitter

    :type: float
    """

    fade_frames: int
    """ How many frames to fade

    :type: int
    """

    is_editable: typing.Union[bool, typing.Any]
    """ A valid edit mode exists

    :type: typing.Union[bool, typing.Any]
    """

    is_hair: typing.Union[bool, typing.Any]
    """ Editing hair

    :type: typing.Union[bool, typing.Any]
    """

    object: "Object"
    """ The edited object

    :type: 'Object'
    """

    select_mode: typing.Union[int, str]
    """ Particle select and display mode

    :type: typing.Union[int, str]
    """

    shape_object: "Object"
    """ Outer shape to use for tools

    :type: 'Object'
    """

    show_particles: bool
    """ Display actual particles

    :type: bool
    """

    tool: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    use_auto_velocity: bool
    """ Calculate point velocities automatically

    :type: bool
    """

    use_default_interpolate: bool
    """ Interpolate new particles from the existing ones

    :type: bool
    """

    use_emitter_deflect: bool
    """ Keep paths from intersecting the emitter

    :type: bool
    """

    use_fade_time: bool
    """ Fade paths and keys further away from current frame

    :type: bool
    """

    use_preserve_length: bool
    """ Keep path lengths constant

    :type: bool
    """

    use_preserve_root: bool
    """ Keep root keys unmodified

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleHairKey(bpy_struct):
    """Particle key for hair particle system"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of the hair key in object space

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    co_local: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of the hair key in its local coordinate system, relative to the emitting face

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    time: float
    """ Relative time of key over hair length

    :type: float
    """

    weight: float
    """ Weight for cloth simulation

    :type: float
    """

    def co_object(
        self, object: "Object", modifier: "ParticleSystemModifier", particle: "Particle"
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]:
        """Obtain hairkey location with particle and modifier data

        :param object: Object
        :type object: 'Object'
        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: hair particle
        :type particle: 'Particle'
        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
        :return: Co, Exported hairkey location
        """
        ...

    def co_object_set(
        self,
        object: "Object",
        modifier: "ParticleSystemModifier",
        particle: "Particle",
        co: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
    ):
        """Set hairkey location with particle and modifier data

        :param object: Object
        :type object: 'Object'
        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: hair particle
        :type particle: 'Particle'
        :param co: Co, Specified hairkey location
        :type co: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleKey(bpy_struct):
    """Key location for a particle over time"""

    angular_velocity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Key angular velocity

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Key location

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    rotation: typing.Union[
        "mathutils.Quaternion",
        typing.List[float],
        typing.Tuple[float, float, float, float],
    ]
    """ Key rotation quaternion

    :type: typing.Union['mathutils.Quaternion', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    time: float
    """ Time of key over the simulation

    :type: float
    """

    velocity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Key velocity

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleSettingsTextureSlots(bpy_struct):
    """Collection of texture slots"""

    def add(self) -> "ParticleSettingsTextureSlot":
        """add

        :rtype: 'ParticleSettingsTextureSlot'
        :return: The newly initialized mtex
        """
        ...

    def create(self, index: typing.Optional[int]) -> "ParticleSettingsTextureSlot":
        """create

        :param index: Index, Slot index to initialize
        :type index: typing.Optional[int]
        :rtype: 'ParticleSettingsTextureSlot'
        :return: The newly initialized mtex
        """
        ...

    def clear(self, index: typing.Optional[int]):
        """clear

        :param index: Index, Slot index to clear
        :type index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleSystem(bpy_struct):
    """Particle system in an object"""

    active_particle_target: "ParticleTarget"
    """ 

    :type: 'ParticleTarget'
    """

    active_particle_target_index: int
    """ 

    :type: int
    """

    child_particles: bpy_prop_collection["ChildParticle"]
    """ Child particles generated by the particle system

    :type: bpy_prop_collection['ChildParticle']
    """

    child_seed: int
    """ Offset in the random number table for child particles, to get a different randomized result

    :type: int
    """

    cloth: "ClothModifier"
    """ Cloth dynamics for hair

    :type: 'ClothModifier'
    """

    dt_frac: float
    """ The current simulation time step size, as a fraction of a frame

    :type: float
    """

    has_multiple_caches: typing.Union[bool, typing.Any]
    """ Particle system has multiple point caches

    :type: typing.Union[bool, typing.Any]
    """

    invert_vertex_group_clump: bool
    """ Negate the effect of the clump vertex group

    :type: bool
    """

    invert_vertex_group_density: bool
    """ Negate the effect of the density vertex group

    :type: bool
    """

    invert_vertex_group_field: bool
    """ Negate the effect of the field vertex group

    :type: bool
    """

    invert_vertex_group_kink: bool
    """ Negate the effect of the kink vertex group

    :type: bool
    """

    invert_vertex_group_length: bool
    """ Negate the effect of the length vertex group

    :type: bool
    """

    invert_vertex_group_rotation: bool
    """ Negate the effect of the rotation vertex group

    :type: bool
    """

    invert_vertex_group_roughness_1: bool
    """ Negate the effect of the roughness 1 vertex group

    :type: bool
    """

    invert_vertex_group_roughness_2: bool
    """ Negate the effect of the roughness 2 vertex group

    :type: bool
    """

    invert_vertex_group_roughness_end: bool
    """ Negate the effect of the roughness end vertex group

    :type: bool
    """

    invert_vertex_group_size: bool
    """ Negate the effect of the size vertex group

    :type: bool
    """

    invert_vertex_group_tangent: bool
    """ Negate the effect of the tangent vertex group

    :type: bool
    """

    invert_vertex_group_twist: bool
    """ Negate the effect of the twist vertex group

    :type: bool
    """

    invert_vertex_group_velocity: bool
    """ Negate the effect of the velocity vertex group

    :type: bool
    """

    is_editable: typing.Union[bool, typing.Any]
    """ Particle system can be edited in particle mode

    :type: typing.Union[bool, typing.Any]
    """

    is_edited: typing.Union[bool, typing.Any]
    """ Particle system has been edited in particle mode

    :type: typing.Union[bool, typing.Any]
    """

    is_global_hair: typing.Union[bool, typing.Any]
    """ Hair keys are in global coordinate space

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Particle system name

    :type: typing.Union[str, typing.Any]
    """

    parent: "Object"
    """ Use this object's coordinate system instead of global coordinate system

    :type: 'Object'
    """

    particles: bpy_prop_collection["Particle"]
    """ Particles generated by the particle system

    :type: bpy_prop_collection['Particle']
    """

    point_cache: "PointCache"
    """ 

    :type: 'PointCache'
    """

    reactor_target_object: "Object"
    """ For reactor systems, the object that has the target particle system (empty if same object)

    :type: 'Object'
    """

    reactor_target_particle_system: int
    """ For reactor systems, index of particle system on the target object

    :type: int
    """

    seed: int
    """ Offset in the random number table, to get a different randomized result

    :type: int
    """

    settings: "ParticleSettings"
    """ Particle system settings

    :type: 'ParticleSettings'
    """

    targets: bpy_prop_collection["ParticleTarget"]
    """ Target particle systems

    :type: bpy_prop_collection['ParticleTarget']
    """

    use_hair_dynamics: bool
    """ Enable hair dynamics using cloth simulation

    :type: bool
    """

    use_keyed_timing: bool
    """ Use key times

    :type: bool
    """

    vertex_group_clump: typing.Union[str, typing.Any]
    """ Vertex group to control clump

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_density: typing.Union[str, typing.Any]
    """ Vertex group to control density

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_field: typing.Union[str, typing.Any]
    """ Vertex group to control field

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_kink: typing.Union[str, typing.Any]
    """ Vertex group to control kink

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_length: typing.Union[str, typing.Any]
    """ Vertex group to control length

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_rotation: typing.Union[str, typing.Any]
    """ Vertex group to control rotation

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_roughness_1: typing.Union[str, typing.Any]
    """ Vertex group to control roughness 1

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_roughness_2: typing.Union[str, typing.Any]
    """ Vertex group to control roughness 2

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_roughness_end: typing.Union[str, typing.Any]
    """ Vertex group to control roughness end

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_size: typing.Union[str, typing.Any]
    """ Vertex group to control size

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_tangent: typing.Union[str, typing.Any]
    """ Vertex group to control tangent

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_twist: typing.Union[str, typing.Any]
    """ Vertex group to control twist

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_velocity: typing.Union[str, typing.Any]
    """ Vertex group to control velocity

    :type: typing.Union[str, typing.Any]
    """

    def co_hair(
        self,
        object: "Object",
        particle_no: typing.Optional[typing.Any] = 0,
        step: typing.Optional[typing.Any] = 0,
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]:
        """Obtain cache hair data

        :param object: Object
        :type object: 'Object'
        :param particle_no: Particle no
        :type particle_no: typing.Optional[typing.Any]
        :param step: step no
        :type step: typing.Optional[typing.Any]
        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
        :return: Co, Exported hairkey location
        """
        ...

    def uv_on_emitter(
        self,
        modifier: "ParticleSystemModifier",
        particle: "Particle",
        particle_no: typing.Optional[typing.Any] = 0,
        uv_no: typing.Optional[typing.Any] = 0,
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]:
        """Obtain uv for all particles

        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: Particle
        :type particle: 'Particle'
        :param particle_no: Particle no
        :type particle_no: typing.Optional[typing.Any]
        :param uv_no: UV no
        :type uv_no: typing.Optional[typing.Any]
        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
        :return: uv
        """
        ...

    def mcol_on_emitter(
        self,
        modifier: "ParticleSystemModifier",
        particle: "Particle",
        particle_no: typing.Optional[typing.Any] = 0,
        vcol_no: typing.Optional[typing.Any] = 0,
    ) -> typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]:
        """Obtain mcol for all particles

        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: Particle
        :type particle: 'Particle'
        :param particle_no: Particle no
        :type particle_no: typing.Optional[typing.Any]
        :param vcol_no: vcol no
        :type vcol_no: typing.Optional[typing.Any]
        :rtype: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
        :return: mcol
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleSystems(bpy_struct):
    """Collection of particle systems"""

    active: "ParticleSystem"
    """ Active particle system being displayed

    :type: 'ParticleSystem'
    """

    active_index: int
    """ Index of active particle system slot

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleTarget(bpy_struct):
    """Target particle system"""

    alliance: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    duration: float
    """ 

    :type: float
    """

    is_valid: bool
    """ Keyed particles target is valid

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Particle target name

    :type: typing.Union[str, typing.Any]
    """

    object: "Object"
    """ The object that has the target particle system (empty if same object)

    :type: 'Object'
    """

    system: int
    """ The index of particle system on the target object

    :type: int
    """

    time: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PathCompare(bpy_struct):
    """Match paths against this value"""

    path: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    use_glob: bool
    """ Enable wildcard globbing

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PathCompareCollection(bpy_struct):
    """Collection of paths"""

    def new(self) -> "PathCompare":
        """Add a new path

        :rtype: 'PathCompare'
        """
        ...

    def remove(self, pathcmp: "PathCompare"):
        """Remove path

        :param pathcmp:
        :type pathcmp: 'PathCompare'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Point(bpy_struct):
    """Point in a point cloud"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    index: int
    """ Index of this point

    :type: int
    """

    radius: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PointCache(bpy_struct):
    """Active point cache for physics simulations"""

    compression: typing.Union[int, str]
    """ Compression method to be used

    :type: typing.Union[int, str]
    """

    filepath: typing.Union[str, typing.Any]
    """ Cache file path

    :type: typing.Union[str, typing.Any]
    """

    frame_end: int
    """ Frame on which the simulation stops

    :type: int
    """

    frame_start: int
    """ Frame on which the simulation starts

    :type: int
    """

    frame_step: int
    """ Number of frames between cached frames

    :type: int
    """

    index: int
    """ Index number of cache files

    :type: int
    """

    info: typing.Union[str, typing.Any]
    """ Info on current cache status

    :type: typing.Union[str, typing.Any]
    """

    is_baked: typing.Union[bool, typing.Any]
    """ The cache is baked

    :type: typing.Union[bool, typing.Any]
    """

    is_baking: typing.Union[bool, typing.Any]
    """ The cache is being baked

    :type: typing.Union[bool, typing.Any]
    """

    is_frame_skip: typing.Union[bool, typing.Any]
    """ Some frames were skipped while baking/saving that cache

    :type: typing.Union[bool, typing.Any]
    """

    is_outdated: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Cache name

    :type: typing.Union[str, typing.Any]
    """

    point_caches: bpy_prop_collection["PointCacheItem"]
    """ 

    :type: bpy_prop_collection['PointCacheItem']
    """

    use_disk_cache: bool
    """ Save cache files to disk (.blend file must be saved first)

    :type: bool
    """

    use_external: bool
    """ Read cache from an external location

    :type: bool
    """

    use_library_path: bool
    """ Use this file's path for the disk cache when library linked into another file (for local bakes per scene file, disable this option)

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PointCacheItem(bpy_struct):
    """Point cache for physics simulations"""

    compression: typing.Union[int, str]
    """ Compression method to be used

    :type: typing.Union[int, str]
    """

    filepath: typing.Union[str, typing.Any]
    """ Cache file path

    :type: typing.Union[str, typing.Any]
    """

    frame_end: int
    """ Frame on which the simulation stops

    :type: int
    """

    frame_start: int
    """ Frame on which the simulation starts

    :type: int
    """

    frame_step: int
    """ Number of frames between cached frames

    :type: int
    """

    index: int
    """ Index number of cache files

    :type: int
    """

    info: typing.Union[str, typing.Any]
    """ Info on current cache status

    :type: typing.Union[str, typing.Any]
    """

    is_baked: typing.Union[bool, typing.Any]
    """ The cache is baked

    :type: typing.Union[bool, typing.Any]
    """

    is_baking: typing.Union[bool, typing.Any]
    """ The cache is being baked

    :type: typing.Union[bool, typing.Any]
    """

    is_frame_skip: typing.Union[bool, typing.Any]
    """ Some frames were skipped while baking/saving that cache

    :type: typing.Union[bool, typing.Any]
    """

    is_outdated: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Cache name

    :type: typing.Union[str, typing.Any]
    """

    use_disk_cache: bool
    """ Save cache files to disk (.blend file must be saved first)

    :type: bool
    """

    use_external: bool
    """ Read cache from an external location

    :type: bool
    """

    use_library_path: bool
    """ Use this file's path for the disk cache when library linked into another file (for local bakes per scene file, disable this option)

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PointCaches(bpy_struct):
    """Collection of point caches"""

    active_index: int
    """ 

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Pose(bpy_struct):
    """A collection of pose channels, including settings for animating bones"""

    animation_visualization: "AnimViz"
    """ Animation data for this data-block

    :type: 'AnimViz'
    """

    bones: bpy_prop_collection["PoseBone"]
    """ Individual pose bones for the armature

    :type: bpy_prop_collection['PoseBone']
    """

    ik_param: "IKParam"
    """ Parameters for IK solver

    :type: 'IKParam'
    """

    ik_solver: typing.Union[int, str]
    """ Selection of IK solver for IK chain

    :type: typing.Union[int, str]
    """

    use_auto_ik: bool
    """ Add temporary IK constraints while grabbing bones in Pose Mode

    :type: bool
    """

    use_mirror_relative: bool
    """ Apply relative transformations in X-mirror mode (not supported with Auto IK)

    :type: bool
    """

    use_mirror_x: bool
    """ Apply changes to matching bone on opposite side of X-Axis

    :type: bool
    """

    def apply_pose_from_action(
        self,
        action: typing.Optional["Action"],
        evaluation_time: typing.Optional[typing.Any] = 0.0,
    ):
        """Apply the given action to this pose by evaluating it at a specific time. Only updates the pose of selected bones, or all bones if none are selected.

        :param action: Action, The Action containing the pose
        :type action: typing.Optional['Action']
        :param evaluation_time: Evaluation Time, Time at which the given action is evaluated to obtain the pose
        :type evaluation_time: typing.Optional[typing.Any]
        """
        ...

    def blend_pose_from_action(
        self,
        action: typing.Optional["Action"],
        blend_factor: typing.Optional[typing.Any] = 1.0,
        evaluation_time: typing.Optional[typing.Any] = 0.0,
    ):
        """Blend the given action into this pose by evaluating it at a specific time. Only updates the pose of selected bones, or all bones if none are selected.

        :param action: Action, The Action containing the pose
        :type action: typing.Optional['Action']
        :param blend_factor: Blend Factor, How much the given Action affects the final pose
        :type blend_factor: typing.Optional[typing.Any]
        :param evaluation_time: Evaluation Time, Time at which the given action is evaluated to obtain the pose
        :type evaluation_time: typing.Optional[typing.Any]
        """
        ...

    def backup_create(self, action: typing.Optional["Action"]):
        """Create a backup of the current pose. Only those bones that are animated in the Action are backed up. The object owns the backup, and each object can have only one backup at a time. When you no longer need it, it must be freed use backup_clear()

        :param action: Action, An Action with animation data for the bones. Only the animated bones will be included in the backup
        :type action: typing.Optional['Action']
        """
        ...

    def backup_restore(self) -> bool:
        """Restore the previously made pose backup. This can be called multiple times. See Pose.backup_create() for more info

        :rtype: bool
        :return: True when the backup was restored, False if there was no backup to restore
        """
        ...

    def backup_clear(self):
        """Free a previously made pose backup. See Pose.backup_create() for more info."""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PoseBone(bpy_struct):
    """Channel defining pose data for a bone in a Pose"""

    bbone_curveinx: float
    """ X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveinz: float
    """ Z-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutx: float
    """ X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutz: float
    """ Z-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_custom_handle_end: "PoseBone"
    """ Bone that serves as the end handle for the B-Bone curve

    :type: 'PoseBone'
    """

    bbone_custom_handle_start: "PoseBone"
    """ Bone that serves as the start handle for the B-Bone curve

    :type: 'PoseBone'
    """

    bbone_easein: float
    """ Length of first Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_easeout: float
    """ Length of second Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_rollin: float
    """ Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    """

    bbone_rollout: float
    """ Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    """

    bbone_scalein: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale factors for the start of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bbone_scaleout: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale factors for the end of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bone: "Bone"
    """ Bone associated with this PoseBone

    :type: 'Bone'
    """

    child: "PoseBone"
    """ Child of this pose bone

    :type: 'PoseBone'
    """

    color: "BoneColor"
    """ 

    :type: 'BoneColor'
    """

    constraints: bpy_prop_collection["Constraint"]
    """ Constraints that act on this pose channel

    :type: bpy_prop_collection['Constraint']
    """

    custom_shape: "Object"
    """ Object that defines custom display shape for this bone

    :type: 'Object'
    """

    custom_shape_rotation_euler: typing.Union[
        "mathutils.Euler", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Adjust the rotation of the custom shape

    :type: typing.Union['mathutils.Euler', typing.List[float], typing.Tuple[float, float, float]]
    """

    custom_shape_scale_xyz: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Adjust the size of the custom shape

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    custom_shape_transform: "PoseBone"
    """ Bone that defines the display transform of this custom shape

    :type: 'PoseBone'
    """

    custom_shape_translation: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Adjust the location of the custom shape

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    head: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of head of the channel's bone

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    ik_linear_weight: float
    """ Weight of scale constraint for IK

    :type: float
    """

    ik_max_x: float
    """ Maximum angles for IK Limit

    :type: float
    """

    ik_max_y: float
    """ Maximum angles for IK Limit

    :type: float
    """

    ik_max_z: float
    """ Maximum angles for IK Limit

    :type: float
    """

    ik_min_x: float
    """ Minimum angles for IK Limit

    :type: float
    """

    ik_min_y: float
    """ Minimum angles for IK Limit

    :type: float
    """

    ik_min_z: float
    """ Minimum angles for IK Limit

    :type: float
    """

    ik_rotation_weight: float
    """ Weight of rotation constraint for IK

    :type: float
    """

    ik_stiffness_x: float
    """ IK stiffness around the X axis

    :type: float
    """

    ik_stiffness_y: float
    """ IK stiffness around the Y axis

    :type: float
    """

    ik_stiffness_z: float
    """ IK stiffness around the Z axis

    :type: float
    """

    ik_stretch: float
    """ Allow scaling of the bone for IK

    :type: float
    """

    is_in_ik_chain: typing.Union[bool, typing.Any]
    """ Is part of an IK chain

    :type: typing.Union[bool, typing.Any]
    """

    length: float
    """ Length of the bone

    :type: float
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    lock_ik_x: bool
    """ Disallow movement around the X axis

    :type: bool
    """

    lock_ik_y: bool
    """ Disallow movement around the Y axis

    :type: bool
    """

    lock_ik_z: bool
    """ Disallow movement around the Z axis

    :type: bool
    """

    lock_location: typing.List[bool]
    """ Lock editing of location when transforming

    :type: typing.List[bool]
    """

    lock_rotation: typing.List[bool]
    """ Lock editing of rotation when transforming

    :type: typing.List[bool]
    """

    lock_rotation_w: bool
    """ Lock editing of 'angle' component of four-component rotations when transforming

    :type: bool
    """

    lock_rotations_4d: bool
    """ Lock editing of four component rotations by components (instead of as Eulers)

    :type: bool
    """

    lock_scale: typing.List[bool]
    """ Lock editing of scale when transforming

    :type: typing.List[bool]
    """

    matrix: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Final 4×4 matrix after constraints and drivers are applied, in the armature object space

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_basis: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Alternative access to location/scale/rotation relative to the parent and own rest bone

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_channel: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ 4×4 matrix of the bone's location/rotation/scale channels (including animation and drivers) and the effect of bone constraints

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    motion_path: "MotionPath"
    """ Motion Path for this element

    :type: 'MotionPath'
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    parent: "PoseBone"
    """ Parent of this pose bone

    :type: 'PoseBone'
    """

    rotation_axis_angle: bpy_prop_array[float]
    """ Angle of Rotation for Axis-Angle rotation representation

    :type: bpy_prop_array[float]
    """

    rotation_euler: typing.Union[
        "mathutils.Euler", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Rotation in Eulers

    :type: typing.Union['mathutils.Euler', typing.List[float], typing.Tuple[float, float, float]]
    """

    rotation_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    rotation_quaternion: typing.Union[
        "mathutils.Quaternion",
        typing.List[float],
        typing.Tuple[float, float, float, float],
    ]
    """ Rotation in Quaternions

    :type: typing.Union['mathutils.Quaternion', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    tail: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of tail of the channel's bone

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    use_custom_shape_bone_size: bool
    """ Scale the custom object by the bone length

    :type: bool
    """

    use_ik_limit_x: bool
    """ Limit movement around the X axis

    :type: bool
    """

    use_ik_limit_y: bool
    """ Limit movement around the Y axis

    :type: bool
    """

    use_ik_limit_z: bool
    """ Limit movement around the Z axis

    :type: bool
    """

    use_ik_linear_control: bool
    """ Apply channel size as IK constraint if stretching is enabled

    :type: bool
    """

    use_ik_rotation_control: bool
    """ Apply channel rotation as IK constraint

    :type: bool
    """

    basename: typing.Any
    """ The name of this bone before any '.' character(readonly)"""

    center: typing.Any
    """ The midpoint between the head and the tail.(readonly)"""

    children: typing.Any
    """ (readonly)"""

    children_recursive: typing.Any
    """ A list of all children from this bone.(readonly)"""

    children_recursive_basename: typing.Any
    """ Returns a chain of children with the same base name as this bone.
Only direct chains are supported, forks caused by multiple children
with matching base names will terminate the function
and not be returned.(readonly)"""

    parent_recursive: typing.Any
    """ A list of parents, starting with the immediate parent(readonly)"""

    vector: typing.Any
    """ The direction this bone is pointing.
Utility function for (tail - head)(readonly)"""

    x_axis: typing.Any
    """ Vector pointing down the x-axis of the bone.(readonly)"""

    y_axis: typing.Any
    """ Vector pointing down the y-axis of the bone.(readonly)"""

    z_axis: typing.Any
    """ Vector pointing down the z-axis of the bone.(readonly)"""

    def evaluate_envelope(
        self,
        point: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
    ) -> float:
        """Calculate bone envelope at given point

        :param point: Point, Position in 3d space to evaluate
        :type point: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
        :rtype: float
        :return: Factor, Envelope factor
        """
        ...

    def bbone_segment_index(
        self,
        point: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
    ):
        """Retrieve the index and blend factor of the B-Bone segments based on vertex position

                :param point: Point, Vertex position in armature pose space
                :type point: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
                :return: index, The index of the first segment joint affecting the point, int in [-inf, inf]

        blend_next, The blend factor between the given and the following joint, float in [-inf, inf]
        """
        ...

    def bbone_segment_matrix(
        self,
        index: typing.Optional[int],
        rest: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]:
        """Retrieve the matrix of the joint between B-Bone segments if availableThis example shows how to use B-Bone segment matrices to emulate deformation
        produced by the Armature modifier or constraint when assigned to the given bone
        (without Preserve Volume). The coordinates are processed in armature Pose space:

                :param index: Index of the segment endpoint
                :type index: typing.Optional[int]
                :param rest: Return the rest pose matrix
                :type rest: typing.Optional[typing.Union[bool, typing.Any]]
                :rtype: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
                :return: The resulting matrix in bone local space
        """
        ...

    def compute_bbone_handles(
        self,
        rest: typing.Optional[typing.Union[bool, typing.Any]] = False,
        ease: typing.Optional[typing.Union[bool, typing.Any]] = False,
        offsets: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ):
        """Retrieve the vectors and rolls coming from B-Bone custom handles

                :param rest: Return the rest pose state
                :type rest: typing.Optional[typing.Union[bool, typing.Any]]
                :param ease: Apply scale from ease values
                :type ease: typing.Optional[typing.Union[bool, typing.Any]]
                :param offsets: Apply roll and curve offsets from bone properties
                :type offsets: typing.Optional[typing.Union[bool, typing.Any]]
                :return: handle1, The direction vector of the start handle in bone local space, `mathutils.Vector` of 3 items in [-inf, inf]

        roll1, Roll of the start handle, float in [-inf, inf]

        handle2, The direction vector of the end handle in bone local space, `mathutils.Vector` of 3 items in [-inf, inf]

        roll2, Roll of the end handle, float in [-inf, inf]
        """
        ...

    def parent_index(self, parent_test):
        """The same as 'bone in other_bone.parent_recursive'
        but saved generating a list.

                :param parent_test:
                :type parent_test:
        """
        ...

    def translate(self, vec):
        """Utility function to add vec to the head and tail of this bone

        :param vec:
        :type vec:
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PoseBoneConstraints(bpy_struct):
    """Collection of pose bone constraints"""

    active: "Constraint"
    """ Active PoseChannel constraint

    :type: 'Constraint'
    """

    def new(self, type: typing.Optional[typing.Union[int, str]]) -> "Constraint":
        """Add a constraint to this object

        :param type: Constraint type to add
        :type type: typing.Optional[typing.Union[int, str]]
        :rtype: 'Constraint'
        :return: New constraint
        """
        ...

    def remove(self, constraint: "Constraint"):
        """Remove a constraint from this object

        :param constraint: Removed constraint
        :type constraint: 'Constraint'
        """
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move a constraint to a different position

        :param from_index: From Index, Index to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index
        :type to_index: typing.Optional[int]
        """
        ...

    def copy(self, constraint: "Constraint") -> "Constraint":
        """Add a new constraint that is a copy of the given one

        :param constraint: Constraint to copy - may belong to a different object
        :type constraint: 'Constraint'
        :rtype: 'Constraint'
        :return: New constraint
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Preferences(bpy_struct):
    """Global preferences"""

    active_section: typing.Union[int, str]
    """ Active section of the preferences shown in the user interface

    :type: typing.Union[int, str]
    """

    addons: bpy_prop_collection["Addon"]
    """ 

    :type: bpy_prop_collection['Addon']
    """

    app_template: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    apps: "PreferencesApps"
    """ Preferences that work only for apps

    :type: 'PreferencesApps'
    """

    autoexec_paths: bpy_prop_collection["PathCompare"]
    """ 

    :type: bpy_prop_collection['PathCompare']
    """

    edit: "PreferencesEdit"
    """ Settings for interacting with Blender data

    :type: 'PreferencesEdit'
    """

    experimental: "PreferencesExperimental"
    """ Settings for features that are still early in their development stage

    :type: 'PreferencesExperimental'
    """

    filepaths: "PreferencesFilePaths"
    """ Default paths for external files

    :type: 'PreferencesFilePaths'
    """

    inputs: "PreferencesInput"
    """ Settings for input devices

    :type: 'PreferencesInput'
    """

    is_dirty: bool
    """ Preferences have changed

    :type: bool
    """

    keymap: "PreferencesKeymap"
    """ Shortcut setup for keyboards and other input devices

    :type: 'PreferencesKeymap'
    """

    studio_lights: bpy_prop_collection["StudioLight"]
    """ 

    :type: bpy_prop_collection['StudioLight']
    """

    system: "PreferencesSystem"
    """ Graphics driver and operating system settings

    :type: 'PreferencesSystem'
    """

    themes: bpy_prop_collection["Theme"]
    """ 

    :type: bpy_prop_collection['Theme']
    """

    ui_styles: bpy_prop_collection["ThemeStyle"]
    """ 

    :type: bpy_prop_collection['ThemeStyle']
    """

    use_preferences_save: bool
    """ Save preferences on exit when modified (unless factory settings have been loaded)

    :type: bool
    """

    use_recent_searches: bool
    """ Sort the recently searched items at the top

    :type: bool
    """

    version: bpy_prop_array[int]
    """ Version of Blender the userpref.blend was saved with

    :type: bpy_prop_array[int]
    """

    view: "PreferencesView"
    """ Preferences related to viewing data

    :type: 'PreferencesView'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PreferencesApps(bpy_struct):
    """Preferences that work only for apps"""

    show_corner_split: bool
    """ Split and join editors by dragging from corners

    :type: bool
    """

    show_edge_resize: bool
    """ Resize editors by dragging from the edges

    :type: bool
    """

    show_regions_visibility_toggle: bool
    """ Header and side bars visibility toggles

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PreferencesEdit(bpy_struct):
    """Settings for interacting with Blender data"""

    auto_keying_mode: typing.Union[int, str]
    """ Mode of automatic keyframe insertion for Objects and Bones (default setting used for new Scenes)

    :type: typing.Union[int, str]
    """

    collection_instance_empty_size: float
    """ Display size of the empty when new collection instances are created

    :type: float
    """

    fcurve_new_auto_smoothing: typing.Union[int, str]
    """ Auto Handle Smoothing mode used for newly added F-Curves

    :type: typing.Union[int, str]
    """

    fcurve_unselected_alpha: float
    """ The opacity of unselected F-Curves against the background of the Graph Editor

    :type: float
    """

    grease_pencil_default_color: bpy_prop_array[float]
    """ Color of new annotation layers

    :type: bpy_prop_array[float]
    """

    grease_pencil_eraser_radius: int
    """ Radius of eraser 'brush'

    :type: int
    """

    grease_pencil_euclidean_distance: int
    """ Distance moved by mouse when drawing stroke to include

    :type: int
    """

    grease_pencil_manhattan_distance: int
    """ Pixels moved by mouse per axis when drawing stroke

    :type: int
    """

    key_insert_channels: typing.Union[typing.Set[int], typing.Set[str]]
    """ Which channels to insert keys at when no keying set is active

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    keyframe_new_handle_type: typing.Union[int, str]
    """ Handle type for handles of new keyframes

    :type: typing.Union[int, str]
    """

    keyframe_new_interpolation_type: typing.Union[int, str]
    """ Interpolation mode used for first keyframe on newly added F-Curves (subsequent keyframes take interpolation from preceding keyframe)

    :type: typing.Union[int, str]
    """

    material_link: typing.Union[int, str]
    """ Toggle whether the material is linked to object data or the object block

    :type: typing.Union[int, str]
    """

    node_margin: int
    """ Minimum distance between nodes for Auto-offsetting nodes

    :type: int
    """

    node_preview_resolution: int
    """ Resolution used for Shader node previews (should be changed for performance convenience)

    :type: int
    """

    node_use_insert_offset: bool
    """ Automatically offset the following or previous nodes in a chain when inserting a new node

    :type: bool
    """

    object_align: typing.Union[int, str]
    """ The default alignment for objects added from a 3D viewport menu

    :type: typing.Union[int, str]
    """

    sculpt_paint_overlay_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of texture overlay

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    show_only_selected_curve_keyframes: bool
    """ Only keyframes of selected F-Curves are visible and editable

    :type: bool
    """

    undo_memory_limit: int
    """ Maximum memory usage in megabytes (0 means unlimited)

    :type: int
    """

    undo_steps: int
    """ Number of undo steps available (smaller values conserve memory)

    :type: int
    """

    use_anim_channel_group_colors: bool
    """ Use animation channel group colors; generally this is used to show bone group colors

    :type: bool
    """

    use_auto_keyframe_insert_needed: bool
    """ Auto-Keying will skip inserting keys that don't affect the animation

    :type: bool
    """

    use_auto_keying: bool
    """ Automatic keyframe insertion for Objects and Bones (default setting used for new Scenes)

    :type: bool
    """

    use_auto_keying_warning: bool
    """ Show warning indicators when transforming objects and bones if auto keying is enabled

    :type: bool
    """

    use_cursor_lock_adjust: bool
    """ Place the cursor without 'jumping' to the new location (when lock-to-cursor is used)

    :type: bool
    """

    use_duplicate_action: bool
    """ Causes actions to be duplicated with the data-blocks

    :type: bool
    """

    use_duplicate_armature: bool
    """ Causes armature data to be duplicated with the object

    :type: bool
    """

    use_duplicate_camera: bool
    """ Causes camera data to be duplicated with the object

    :type: bool
    """

    use_duplicate_curve: bool
    """ Causes curve data to be duplicated with the object

    :type: bool
    """

    use_duplicate_curves: bool
    """ Causes curves data to be duplicated with the object

    :type: bool
    """

    use_duplicate_grease_pencil: bool
    """ Causes grease pencil data to be duplicated with the object

    :type: bool
    """

    use_duplicate_lattice: bool
    """ Causes lattice data to be duplicated with the object

    :type: bool
    """

    use_duplicate_light: bool
    """ Causes light data to be duplicated with the object

    :type: bool
    """

    use_duplicate_lightprobe: bool
    """ Causes light probe data to be duplicated with the object

    :type: bool
    """

    use_duplicate_material: bool
    """ Causes material data to be duplicated with the object

    :type: bool
    """

    use_duplicate_mesh: bool
    """ Causes mesh data to be duplicated with the object

    :type: bool
    """

    use_duplicate_metaball: bool
    """ Causes metaball data to be duplicated with the object

    :type: bool
    """

    use_duplicate_node_tree: bool
    """ Make copies of node groups when duplicating nodes in the node editor

    :type: bool
    """

    use_duplicate_particle: bool
    """ Causes particle systems to be duplicated with the object

    :type: bool
    """

    use_duplicate_pointcloud: bool
    """ Causes point cloud data to be duplicated with the object

    :type: bool
    """

    use_duplicate_speaker: bool
    """ Causes speaker data to be duplicated with the object

    :type: bool
    """

    use_duplicate_surface: bool
    """ Causes surface data to be duplicated with the object

    :type: bool
    """

    use_duplicate_text: bool
    """ Causes text data to be duplicated with the object

    :type: bool
    """

    use_duplicate_volume: bool
    """ Causes volume data to be duplicated with the object

    :type: bool
    """

    use_enter_edit_mode: bool
    """ Enter edit mode automatically after adding a new object

    :type: bool
    """

    use_fcurve_high_quality_drawing: bool
    """ Draw F-Curves using Anti-Aliasing (disable for better performance)

    :type: bool
    """

    use_global_undo: bool
    """ Global undo works by keeping a full copy of the file itself in memory, so takes extra memory

    :type: bool
    """

    use_insertkey_xyz_to_rgb: bool
    """ Color for newly added transformation F-Curves (Location, Rotation, Scale) and also Color is based on the transform axis

    :type: bool
    """

    use_keyframe_insert_available: bool
    """ Insert Keyframes only for properties that are already animated

    :type: bool
    """

    use_keyframe_insert_needed: bool
    """ When keying manually, skip inserting keys that don't affect the animation

    :type: bool
    """

    use_mouse_depth_cursor: bool
    """ Use the surface depth for cursor placement

    :type: bool
    """

    use_negative_frames: bool
    """ Current frame number can be manually set to a negative value

    :type: bool
    """

    use_text_edit_auto_close: bool
    """ Automatically close relevant character pairs when typing in the text editor

    :type: bool
    """

    use_visual_keying: bool
    """ Use Visual keying automatically for constrained objects

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PreferencesExperimental(bpy_struct):
    """Experimental features"""

    enable_overlay_next: bool
    """ Enable the new Overlay codebase, requires restart

    :type: bool
    """

    override_auto_resync: bool
    """ Disable library overrides automatic resync detection and process on file load (can be useful to help fixing broken files)

    :type: bool
    """

    show_asset_debug_info: bool
    """ Enable some extra fields in the Asset Browser to aid in debugging

    :type: bool
    """

    use_all_linked_data_direct: bool
    """ Forces all linked data to be considered as directly linked. Workaround for current issues/limitations in BAT (Blender studio pipeline tool)

    :type: bool
    """

    use_asset_indexing: bool
    """ Disable the asset indexer, to force every asset library refresh to completely reread assets from disk

    :type: bool
    """

    use_cycles_debug: bool
    """ Enable Cycles debugging options for developers

    :type: bool
    """

    use_eevee_debug: bool
    """ Enable EEVEE debugging options for developers

    :type: bool
    """

    use_experimental_compositors: bool
    """ Enable compositor full frame and realtime GPU execution mode options (no tiling, reduces execution time and memory usage)

    :type: bool
    """

    use_extended_asset_browser: bool
    """ Enable Asset Browser editor and operators to manage regular data-blocks as assets, not just poses

    :type: bool
    """

    use_extension_repos: bool
    """ Enables support for extensions, accessible from the "Extensions" section of the preferences

    :type: bool
    """

    use_extension_utils: bool
    """ Developer support utilities for extensions

    :type: bool
    """

    use_grease_pencil_version3: bool
    """ Enable the new grease pencil 3.0 codebase

    :type: bool
    """

    use_new_curves_tools: bool
    """ Enable additional features for the new curves data block

    :type: bool
    """

    use_new_matrix_socket: bool
    """ Enable the matrix socket type for geometry nodes

    :type: bool
    """

    use_new_point_cloud_type: bool
    """ Enable the new point cloud type in the ui

    :type: bool
    """

    use_new_volume_nodes: bool
    """ Enables visibility of the new Volume nodes in the UI

    :type: bool
    """

    use_sculpt_texture_paint: bool
    """ Use texture painting in Sculpt Mode

    :type: bool
    """

    use_sculpt_tools_tilt: bool
    """ Support for pen tablet tilt events in Sculpt Mode

    :type: bool
    """

    use_shader_node_previews: bool
    """ Enables previews in the shader node editor

    :type: bool
    """

    use_undo_legacy: bool
    """ Use legacy undo (slower than the new default one, but may be more stable in some cases)

    :type: bool
    """

    use_viewport_debug: bool
    """ Enable viewport debugging options for developers in the overlays pop-over

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PreferencesFilePaths(bpy_struct):
    """Default paths for external files"""

    active_asset_library: int
    """ Index of the asset library being edited in the Preferences UI

    :type: int
    """

    active_extension_repo: int
    """ Index of the extensions repository being edited in the Preferences UI

    :type: int
    """

    animation_player: typing.Union[str, typing.Any]
    """ Path to a custom animation/frame sequence player

    :type: typing.Union[str, typing.Any]
    """

    animation_player_preset: typing.Union[int, str]
    """ Preset configs for external animation players

    :type: typing.Union[int, str]
    """

    asset_libraries: bpy_prop_collection["UserAssetLibrary"]
    """ 

    :type: bpy_prop_collection['UserAssetLibrary']
    """

    auto_save_time: int
    """ The time (in minutes) to wait between automatic temporary saves

    :type: int
    """

    extension_repos: bpy_prop_collection["UserExtensionRepo"]
    """ 

    :type: bpy_prop_collection['UserExtensionRepo']
    """

    file_preview_type: typing.Union[int, str]
    """ What type of blend preview to create

    :type: typing.Union[int, str]
    """

    font_directory: typing.Union[str, typing.Any]
    """ The default directory to search for loading fonts

    :type: typing.Union[str, typing.Any]
    """

    i18n_branches_directory: typing.Union[str, typing.Any]
    """ The path to the '/branches' directory of your local svn-translation copy, to allow translating from the UI

    :type: typing.Union[str, typing.Any]
    """

    image_editor: typing.Union[str, typing.Any]
    """ Path to an image editor

    :type: typing.Union[str, typing.Any]
    """

    recent_files: int
    """ Maximum number of recently opened files to remember

    :type: int
    """

    render_cache_directory: typing.Union[str, typing.Any]
    """ Where to cache raw render results

    :type: typing.Union[str, typing.Any]
    """

    render_output_directory: typing.Union[str, typing.Any]
    """ The default directory for rendering output, for new scenes

    :type: typing.Union[str, typing.Any]
    """

    save_version: int
    """ The number of old versions to maintain in the current directory, when manually saving

    :type: int
    """

    script_directories: bpy_prop_collection["ScriptDirectory"]
    """ 

    :type: bpy_prop_collection['ScriptDirectory']
    """

    show_hidden_files_datablocks: bool
    """ Show files and data-blocks that are normally hidden

    :type: bool
    """

    show_recent_locations: bool
    """ Show Recent locations list in the File Browser

    :type: bool
    """

    show_system_bookmarks: bool
    """ Show System locations list in the File Browser

    :type: bool
    """

    sound_directory: typing.Union[str, typing.Any]
    """ The default directory to search for sounds

    :type: typing.Union[str, typing.Any]
    """

    temporary_directory: typing.Union[str, typing.Any]
    """ The directory for storing temporary save files. The path must reference an existing directory or it will be ignored

    :type: typing.Union[str, typing.Any]
    """

    text_editor: typing.Union[str, typing.Any]
    """ Command to launch the text editor, either a full path or a command in $PATH.
Use the internal editor when left blank

    :type: typing.Union[str, typing.Any]
    """

    text_editor_args: typing.Union[str, typing.Any]
    """ Defines the specific format of the arguments with which the text editor opens files. The supported expansions are as follows:$filepath The absolute path of the file.
$line The line to open at (Optional).
$column The column to open from the beginning of the line (Optional).
$line0 & column0 start at zero.
Example: -f $filepath -l $line -c $column

    :type: typing.Union[str, typing.Any]
    """

    texture_directory: typing.Union[str, typing.Any]
    """ The default directory to search for textures

    :type: typing.Union[str, typing.Any]
    """

    use_auto_save_temporary_files: bool
    """ Automatic saving of temporary files in temp directory, uses process ID.
Warning: Sculpt and edit mode data won't be saved

    :type: bool
    """

    use_file_compression: bool
    """ Enable file compression when saving .blend files

    :type: bool
    """

    use_filter_files: bool
    """ Enable filtering of files in the File Browser

    :type: bool
    """

    use_load_ui: bool
    """ Load user interface setup when loading .blend files

    :type: bool
    """

    use_relative_paths: bool
    """ Default relative path option for the file selector, when no path is defined yet

    :type: bool
    """

    use_scripts_auto_execute: bool
    """ Allow any .blend file to run scripts automatically (unsafe with blend files from an untrusted source)

    :type: bool
    """

    use_tabs_as_spaces: bool
    """ Automatically convert all new tabs into spaces for new and loaded text files

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PreferencesInput(bpy_struct):
    """Settings for input devices"""

    drag_threshold: int
    """ Number of pixels to drag before a drag event is triggered for keyboard and other non mouse/tablet input (otherwise click events are detected)

    :type: int
    """

    drag_threshold_mouse: int
    """ Number of pixels to drag before a drag event is triggered for mouse/trackpad input (otherwise click events are detected)

    :type: int
    """

    drag_threshold_tablet: int
    """ Number of pixels to drag before a drag event is triggered for tablet input (otherwise click events are detected)

    :type: int
    """

    invert_mouse_zoom: bool
    """ Invert the axis of mouse movement for zooming

    :type: bool
    """

    invert_zoom_wheel: bool
    """ Swap the Mouse Wheel zoom direction

    :type: bool
    """

    mouse_double_click_time: int
    """ Time/delay (in ms) for a double click

    :type: int
    """

    mouse_emulate_3_button_modifier: typing.Union[int, str]
    """ Hold this modifier to emulate the middle mouse button

    :type: typing.Union[int, str]
    """

    move_threshold: int
    """ Number of pixels to before the cursor is considered to have moved (used for cycling selected items on successive clicks)

    :type: int
    """

    navigation_mode: typing.Union[int, str]
    """ Which method to use for viewport navigation

    :type: typing.Union[int, str]
    """

    ndof_deadzone: float
    """ Threshold of initial movement needed from the device's rest position

    :type: float
    """

    ndof_fly_helicopter: bool
    """ Device up/down directly controls the Z position of the 3D viewport

    :type: bool
    """

    ndof_lock_camera_pan_zoom: bool
    """ Pan/zoom the camera view instead of leaving the camera view when orbiting

    :type: bool
    """

    ndof_lock_horizon: bool
    """ Keep horizon level while flying with 3D Mouse

    :type: bool
    """

    ndof_orbit_sensitivity: float
    """ Overall sensitivity of the 3D Mouse for orbiting

    :type: float
    """

    ndof_pan_yz_swap_axis: bool
    """ Pan using up/down on the device (otherwise forward/backward)

    :type: bool
    """

    ndof_panx_invert_axis: bool
    """ 

    :type: bool
    """

    ndof_pany_invert_axis: bool
    """ 

    :type: bool
    """

    ndof_panz_invert_axis: bool
    """ 

    :type: bool
    """

    ndof_rotx_invert_axis: bool
    """ 

    :type: bool
    """

    ndof_roty_invert_axis: bool
    """ 

    :type: bool
    """

    ndof_rotz_invert_axis: bool
    """ 

    :type: bool
    """

    ndof_sensitivity: float
    """ Overall sensitivity of the 3D Mouse for panning

    :type: float
    """

    ndof_show_guide: bool
    """ Display the center and axis during rotation

    :type: bool
    """

    ndof_view_navigate_method: typing.Union[int, str]
    """ Navigation style in the viewport

    :type: typing.Union[int, str]
    """

    ndof_view_rotate_method: typing.Union[int, str]
    """ Rotation style in the viewport

    :type: typing.Union[int, str]
    """

    ndof_zoom_invert: bool
    """ Zoom using opposite direction

    :type: bool
    """

    pressure_softness: float
    """ Adjusts softness of the low pressure response onset using a gamma curve

    :type: float
    """

    pressure_threshold_max: float
    """ Raw input pressure value that is interpreted as 100% by Blender

    :type: float
    """

    tablet_api: typing.Union[int, str]
    """ Select the tablet API to use for pressure sensitivity (may require restarting Blender for changes to take effect)

    :type: typing.Union[int, str]
    """

    use_auto_perspective: bool
    """ Automatically switch between orthographic and perspective when changing from top/front/side views

    :type: bool
    """

    use_drag_immediately: bool
    """ Moving things with a mouse drag confirms when releasing the button

    :type: bool
    """

    use_emulate_numpad: bool
    """ Main 1 to 0 keys act as the numpad ones (useful for laptops)

    :type: bool
    """

    use_mouse_continuous: bool
    """ Let the mouse wrap around the view boundaries so mouse movements are not limited by the screen size (used by transform, dragging of UI controls, etc.)

    :type: bool
    """

    use_mouse_depth_navigate: bool
    """ Use the depth under the mouse to improve view pan/rotate/zoom functionality

    :type: bool
    """

    use_mouse_emulate_3_button: bool
    """ Emulate Middle Mouse with Alt+Left Mouse

    :type: bool
    """

    use_multitouch_gestures: bool
    """ Use multi-touch gestures for navigation with touchpad, instead of scroll wheel emulation

    :type: bool
    """

    use_ndof: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    use_numeric_input_advanced: bool
    """ When entering numbers while transforming, default to advanced mode for full math expression evaluation

    :type: bool
    """

    use_rotate_around_active: bool
    """ Use selection as the pivot point

    :type: bool
    """

    use_zoom_to_mouse: bool
    """ Zoom in towards the mouse pointer's position in the 3D view, rather than the 2D window center

    :ty