# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NgwafWorkspaceListArgs', 'NgwafWorkspaceList']

@pulumi.input_type
class NgwafWorkspaceListArgs:
    def __init__(__self__, *,
                 entries: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 type: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NgwafWorkspaceList resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entries: The values in the list.
        :param pulumi.Input[_builtins.str] type: The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        :param pulumi.Input[_builtins.str] description: The description of the list.
        :param pulumi.Input[_builtins.str] name: The name of the list.
        """
        pulumi.set(__self__, "entries", entries)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The values in the list.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the list.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NgwafWorkspaceListState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NgwafWorkspaceList resources.
        :param pulumi.Input[_builtins.str] description: The description of the list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entries: The values in the list.
        :param pulumi.Input[_builtins.str] name: The name of the list.
        :param pulumi.Input[_builtins.str] type: The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The values in the list.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the list.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("fastly:index/ngwafWorkspaceList:NgwafWorkspaceList")
class NgwafWorkspaceList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Fastly Next-Gen WAF **List** resource scoped to a specific **workspace**.

        Workspace-scoped lists are local to a workspace and typically used within workspace-specific rules.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example = fastly.NgwafWorkspace("example",
            name="example",
            description="Workspace with custom list",
            mode="block",
            ip_anonymization="hashed",
            client_ip_headers=[
                "X-Forwarded-For",
                "X-Real-IP",
            ],
            default_blocking_response_code=403,
            attack_signal_thresholds={
                "one_minute": 100,
                "ten_minutes": 500,
                "one_hour": 1000,
                "immediate": True,
            })
        example_ngwaf_workspace_list = fastly.NgwafWorkspaceList("example",
            workspace_id=example.id,
            name="local-allowlist",
            description="IP allowlist for this workspace",
            type="ip",
            entries=[
                "192.168.0.1",
                "10.0.0.1",
            ])
        ```

        ## Import

        Fastly Next-Gen WAF workspace-scoped lists can be imported using the format `<workspaceID>/<listID>`, e.g.:

        ```sh
        $ pulumi import fastly:index/ngwafWorkspaceList:NgwafWorkspaceList demo <workspaceID>/<listID>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entries: The values in the list.
        :param pulumi.Input[_builtins.str] name: The name of the list.
        :param pulumi.Input[_builtins.str] type: The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgwafWorkspaceListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Fastly Next-Gen WAF **List** resource scoped to a specific **workspace**.

        Workspace-scoped lists are local to a workspace and typically used within workspace-specific rules.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example = fastly.NgwafWorkspace("example",
            name="example",
            description="Workspace with custom list",
            mode="block",
            ip_anonymization="hashed",
            client_ip_headers=[
                "X-Forwarded-For",
                "X-Real-IP",
            ],
            default_blocking_response_code=403,
            attack_signal_thresholds={
                "one_minute": 100,
                "ten_minutes": 500,
                "one_hour": 1000,
                "immediate": True,
            })
        example_ngwaf_workspace_list = fastly.NgwafWorkspaceList("example",
            workspace_id=example.id,
            name="local-allowlist",
            description="IP allowlist for this workspace",
            type="ip",
            entries=[
                "192.168.0.1",
                "10.0.0.1",
            ])
        ```

        ## Import

        Fastly Next-Gen WAF workspace-scoped lists can be imported using the format `<workspaceID>/<listID>`, e.g.:

        ```sh
        $ pulumi import fastly:index/ngwafWorkspaceList:NgwafWorkspaceList demo <workspaceID>/<listID>
        ```

        :param str resource_name: The name of the resource.
        :param NgwafWorkspaceListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgwafWorkspaceListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgwafWorkspaceListArgs.__new__(NgwafWorkspaceListArgs)

            __props__.__dict__["description"] = description
            if entries is None and not opts.urn:
                raise TypeError("Missing required property 'entries'")
            __props__.__dict__["entries"] = entries
            __props__.__dict__["name"] = name
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(NgwafWorkspaceList, __self__).__init__(
            'fastly:index/ngwafWorkspaceList:NgwafWorkspaceList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            entries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NgwafWorkspaceList':
        """
        Get an existing NgwafWorkspaceList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entries: The values in the list.
        :param pulumi.Input[_builtins.str] name: The name of the list.
        :param pulumi.Input[_builtins.str] type: The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgwafWorkspaceListState.__new__(_NgwafWorkspaceListState)

        __props__.__dict__["description"] = description
        __props__.__dict__["entries"] = entries
        __props__.__dict__["name"] = name
        __props__.__dict__["type"] = type
        __props__.__dict__["workspace_id"] = workspace_id
        return NgwafWorkspaceList(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the list.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The values in the list.
        """
        return pulumi.get(self, "entries")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the list.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "workspace_id")

