# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'AlertDimensions',
    'AlertEvaluationStrategy',
    'CustomDashboardDashboardItem',
    'CustomDashboardDashboardItemDataSource',
    'CustomDashboardDashboardItemDataSourceConfig',
    'CustomDashboardDashboardItemVisualization',
    'CustomDashboardDashboardItemVisualizationConfig',
    'NgwafAccountRuleAction',
    'NgwafAccountRuleCondition',
    'NgwafAccountRuleGroupCondition',
    'NgwafAccountRuleGroupConditionCondition',
    'NgwafAccountRuleRateLimit',
    'NgwafAccountRuleRateLimitClientIdentifier',
    'NgwafWorkspaceAttackSignalThresholds',
    'NgwafWorkspaceRuleAction',
    'NgwafWorkspaceRuleCondition',
    'NgwafWorkspaceRuleGroupCondition',
    'NgwafWorkspaceRuleGroupConditionCondition',
    'NgwafWorkspaceRuleRateLimit',
    'NgwafWorkspaceRuleRateLimitClientIdentifier',
    'ServiceACLEntriesEntry',
    'ServiceComputeBackend',
    'ServiceComputeDictionary',
    'ServiceComputeDomain',
    'ServiceComputeImageOptimizerDefaultSettings',
    'ServiceComputeLoggingBigquery',
    'ServiceComputeLoggingBlobstorage',
    'ServiceComputeLoggingCloudfile',
    'ServiceComputeLoggingDatadog',
    'ServiceComputeLoggingDigitalocean',
    'ServiceComputeLoggingElasticsearch',
    'ServiceComputeLoggingFtp',
    'ServiceComputeLoggingGc',
    'ServiceComputeLoggingGooglepubsub',
    'ServiceComputeLoggingGrafanacloudlog',
    'ServiceComputeLoggingHeroku',
    'ServiceComputeLoggingHoneycomb',
    'ServiceComputeLoggingHttp',
    'ServiceComputeLoggingKafka',
    'ServiceComputeLoggingKinese',
    'ServiceComputeLoggingLogentry',
    'ServiceComputeLoggingLoggly',
    'ServiceComputeLoggingLogshuttle',
    'ServiceComputeLoggingNewrelic',
    'ServiceComputeLoggingOpenstack',
    'ServiceComputeLoggingPapertrail',
    'ServiceComputeLoggingS3',
    'ServiceComputeLoggingScalyr',
    'ServiceComputeLoggingSftp',
    'ServiceComputeLoggingSplunk',
    'ServiceComputeLoggingSumologic',
    'ServiceComputeLoggingSyslog',
    'ServiceComputePackage',
    'ServiceComputeProductEnablement',
    'ServiceComputeProductEnablementDdosProtection',
    'ServiceComputeProductEnablementNgwaf',
    'ServiceComputeResourceLink',
    'ServiceVclAcl',
    'ServiceVclBackend',
    'ServiceVclCacheSetting',
    'ServiceVclCondition',
    'ServiceVclDictionary',
    'ServiceVclDirector',
    'ServiceVclDomain',
    'ServiceVclDynamicsnippet',
    'ServiceVclGzip',
    'ServiceVclHeader',
    'ServiceVclHealthcheck',
    'ServiceVclImageOptimizerDefaultSettings',
    'ServiceVclLoggingBigquery',
    'ServiceVclLoggingBlobstorage',
    'ServiceVclLoggingCloudfile',
    'ServiceVclLoggingDatadog',
    'ServiceVclLoggingDigitalocean',
    'ServiceVclLoggingElasticsearch',
    'ServiceVclLoggingFtp',
    'ServiceVclLoggingGc',
    'ServiceVclLoggingGooglepubsub',
    'ServiceVclLoggingGrafanacloudlog',
    'ServiceVclLoggingHerokus',
    'ServiceVclLoggingHoneycomb',
    'ServiceVclLoggingHttp',
    'ServiceVclLoggingKafka',
    'ServiceVclLoggingKinese',
    'ServiceVclLoggingLogentry',
    'ServiceVclLoggingLoggly',
    'ServiceVclLoggingLogshuttle',
    'ServiceVclLoggingNewrelic',
    'ServiceVclLoggingNewrelicotlp',
    'ServiceVclLoggingOpenstack',
    'ServiceVclLoggingPapertrail',
    'ServiceVclLoggingS3',
    'ServiceVclLoggingScalyr',
    'ServiceVclLoggingSftp',
    'ServiceVclLoggingSplunk',
    'ServiceVclLoggingSumologic',
    'ServiceVclLoggingSyslog',
    'ServiceVclProductEnablement',
    'ServiceVclProductEnablementDdosProtection',
    'ServiceVclProductEnablementNgwaf',
    'ServiceVclRateLimiter',
    'ServiceVclRateLimiterResponse',
    'ServiceVclRequestSetting',
    'ServiceVclResponseObject',
    'ServiceVclSnippet',
    'ServiceVclVcl',
    'TlsSubscriptionManagedDnsChallenge',
    'TlsSubscriptionManagedHttpChallenge',
    'GetConfigstoresStoreResult',
    'GetDatacentersPopResult',
    'GetDictionariesDictionaryResult',
    'GetKvstoresStoreResult',
    'GetNgwafAlertDatadogIntegrationDatadogAlertResult',
    'GetNgwafAlertJiraIntegrationJiraAlertResult',
    'GetNgwafAlertMailingListIntegrationMailingListAlertResult',
    'GetNgwafAlertMicrosoftTeamsIntegrationMicrosoftTeamsAlertResult',
    'GetNgwafAlertOpsgenieIntegrationOpsgenieAlertResult',
    'GetNgwafAlertPagerdutyIntegrationPagerdutyAlertResult',
    'GetNgwafAlertSlackIntegrationSlackAlertResult',
    'GetNgwafAlertWebhookIntegrationWebhookAlertResult',
    'GetNgwafRedactionsRedactionResult',
    'GetNgwafThresholdsThresholdResult',
    'GetNgwafVirtualPatchesVirtualPatchResult',
    'GetNgwafWorkspacesWorkspaceResult',
    'GetSecretstoresStoreResult',
    'GetServicesDetailResult',
    'GetTlsConfigurationDnsRecordResult',
    'GetVclSnippetsVclSnippetResult',
]

@pulumi.output_type
class AlertDimensions(dict):
    def __init__(__self__, *,
                 domains: Optional[Sequence[_builtins.str]] = None,
                 origins: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] domains: Names of a subset of domains that the alert monitors.
        :param Sequence[_builtins.str] origins: Addresses of a subset of backends that the alert monitors.
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[_builtins.str]]:
        """
        Names of a subset of domains that the alert monitors.
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter
    def origins(self) -> Optional[Sequence[_builtins.str]]:
        """
        Addresses of a subset of backends that the alert monitors.
        """
        return pulumi.get(self, "origins")


@pulumi.output_type
class AlertEvaluationStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreBelow":
            suggest = "ignore_below"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertEvaluationStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertEvaluationStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertEvaluationStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 period: _builtins.str,
                 threshold: _builtins.float,
                 type: _builtins.str,
                 ignore_below: Optional[_builtins.float] = None):
        """
        :param _builtins.str period: The length of time to evaluate whether the conditions have been met. The data is polled every minute. One of: `2m`, `3m`, `5m`, `15m`, `30m`.
        :param _builtins.float threshold: Threshold used to alert.
        :param _builtins.str type: Type of strategy to use to evaluate. One of: `above_threshold`, `all_above_threshold`, `below_threshold`, `percent_absolute`, `percent_decrease`, `percent_increase`.
        :param _builtins.float ignore_below: Threshold for the denominator value used in evaluations that calculate a rate or ratio. Usually used to filter out noise.
        """
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "type", type)
        if ignore_below is not None:
            pulumi.set(__self__, "ignore_below", ignore_below)

    @_builtins.property
    @pulumi.getter
    def period(self) -> _builtins.str:
        """
        The length of time to evaluate whether the conditions have been met. The data is polled every minute. One of: `2m`, `3m`, `5m`, `15m`, `30m`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.float:
        """
        Threshold used to alert.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of strategy to use to evaluate. One of: `above_threshold`, `all_above_threshold`, `below_threshold`, `percent_absolute`, `percent_decrease`, `percent_increase`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="ignoreBelow")
    def ignore_below(self) -> Optional[_builtins.float]:
        """
        Threshold for the denominator value used in evaluations that calculate a rate or ratio. Usually used to filter out noise.
        """
        return pulumi.get(self, "ignore_below")


@pulumi.output_type
class CustomDashboardDashboardItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSource":
            suggest = "data_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDashboardDashboardItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDashboardDashboardItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDashboardDashboardItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source: 'outputs.CustomDashboardDashboardItemDataSource',
                 id: _builtins.str,
                 subtitle: _builtins.str,
                 title: _builtins.str,
                 visualization: 'outputs.CustomDashboardDashboardItemVisualization',
                 span: Optional[_builtins.int] = None):
        """
        :param 'CustomDashboardDashboardItemDataSourceArgs' data_source: An object which describes the data to display.
        :param _builtins.str id: Dashboard item identifier (alphanumeric). Must be unique, relative to other items in the same dashboard.
        :param _builtins.str subtitle: A human-readable subtitle for the dashboard item. Often a description of the visualization.
        :param _builtins.str title: A human-readable title for the dashboard item.
        :param 'CustomDashboardDashboardItemVisualizationArgs' visualization: An object which describes the data visualization to display.
        :param _builtins.int span: The number of columns for the dashboard item to span. Dashboards are rendered on a 12-column grid on "desktop" screen sizes.
        """
        pulumi.set(__self__, "data_source", data_source)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "subtitle", subtitle)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "visualization", visualization)
        if span is not None:
            pulumi.set(__self__, "span", span)

    @_builtins.property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> 'outputs.CustomDashboardDashboardItemDataSource':
        """
        An object which describes the data to display.
        """
        return pulumi.get(self, "data_source")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Dashboard item identifier (alphanumeric). Must be unique, relative to other items in the same dashboard.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def subtitle(self) -> _builtins.str:
        """
        A human-readable subtitle for the dashboard item. Often a description of the visualization.
        """
        return pulumi.get(self, "subtitle")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A human-readable title for the dashboard item.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def visualization(self) -> 'outputs.CustomDashboardDashboardItemVisualization':
        """
        An object which describes the data visualization to display.
        """
        return pulumi.get(self, "visualization")

    @_builtins.property
    @pulumi.getter
    def span(self) -> Optional[_builtins.int]:
        """
        The number of columns for the dashboard item to span. Dashboards are rendered on a 12-column grid on "desktop" screen sizes.
        """
        return pulumi.get(self, "span")


@pulumi.output_type
class CustomDashboardDashboardItemDataSource(dict):
    def __init__(__self__, *,
                 config: 'outputs.CustomDashboardDashboardItemDataSourceConfig',
                 type: _builtins.str):
        """
        :param 'CustomDashboardDashboardItemDataSourceConfigArgs' config: Configuration options for the selected data source.
        :param _builtins.str type: The source of the data to display. One of: `stats.edge`, `stats.domain`, `stats.origin`.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def config(self) -> 'outputs.CustomDashboardDashboardItemDataSourceConfig':
        """
        Configuration options for the selected data source.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The source of the data to display. One of: `stats.edge`, `stats.domain`, `stats.origin`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomDashboardDashboardItemDataSourceConfig(dict):
    def __init__(__self__, *,
                 metrics: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] metrics: The metrics to visualize. Valid options are defined by the selected data source: [stats.edge](https://www.fastly.com/documentation/reference/api/observability/custom-dashboards/metrics/edge/), [stats.domain](https://www.fastly.com/documentation/reference/api/observability/custom-dashboards/metrics/domain/), [stats.origin](https://www.fastly.com/documentation/reference/api/observability/custom-dashboards/metrics/origin/).
        """
        pulumi.set(__self__, "metrics", metrics)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Sequence[_builtins.str]:
        """
        The metrics to visualize. Valid options are defined by the selected data source: [stats.edge](https://www.fastly.com/documentation/reference/api/observability/custom-dashboards/metrics/edge/), [stats.domain](https://www.fastly.com/documentation/reference/api/observability/custom-dashboards/metrics/domain/), [stats.origin](https://www.fastly.com/documentation/reference/api/observability/custom-dashboards/metrics/origin/).
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class CustomDashboardDashboardItemVisualization(dict):
    def __init__(__self__, *,
                 config: 'outputs.CustomDashboardDashboardItemVisualizationConfig',
                 type: _builtins.str):
        """
        :param 'CustomDashboardDashboardItemVisualizationConfigArgs' config: Configuration options for the selected data source.
        :param _builtins.str type: The type of visualization to display. One of: `chart`.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def config(self) -> 'outputs.CustomDashboardDashboardItemVisualizationConfig':
        """
        Configuration options for the selected data source.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of visualization to display. One of: `chart`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomDashboardDashboardItemVisualizationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "plotType":
            suggest = "plot_type"
        elif key == "calculationMethod":
            suggest = "calculation_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDashboardDashboardItemVisualizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDashboardDashboardItemVisualizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDashboardDashboardItemVisualizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plot_type: _builtins.str,
                 calculation_method: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None):
        """
        :param _builtins.str plot_type: The type of chart to display. One of: `line`, `bar`, `single-metric`, `donut`.
        :param _builtins.str calculation_method: The aggregation function to apply to the dataset. One of: `avg`, `sum`, `min`, `max`, `latest`, `p95`.
        :param _builtins.str format: The units to use to format the data. One of: `number`, `bytes`, `percent`, `requests`, `responses`, `seconds`, `milliseconds`, `ratio`, `bitrate`.
        """
        pulumi.set(__self__, "plot_type", plot_type)
        if calculation_method is not None:
            pulumi.set(__self__, "calculation_method", calculation_method)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @_builtins.property
    @pulumi.getter(name="plotType")
    def plot_type(self) -> _builtins.str:
        """
        The type of chart to display. One of: `line`, `bar`, `single-metric`, `donut`.
        """
        return pulumi.get(self, "plot_type")

    @_builtins.property
    @pulumi.getter(name="calculationMethod")
    def calculation_method(self) -> Optional[_builtins.str]:
        """
        The aggregation function to apply to the dataset. One of: `avg`, `sum`, `min`, `max`, `latest`, `p95`.
        """
        return pulumi.get(self, "calculation_method")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        The units to use to format the data. One of: `number`, `bytes`, `percent`, `requests`, `responses`, `seconds`, `milliseconds`, `ratio`, `bitrate`.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class NgwafAccountRuleAction(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 signal: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The action type, e.g. `block`, `redirect`, `exclude_signal`.
        :param _builtins.str signal: Signal name to exclude (used when `type = exclude_signal`).
        """
        pulumi.set(__self__, "type", type)
        if signal is not None:
            pulumi.set(__self__, "signal", signal)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The action type, e.g. `block`, `redirect`, `exclude_signal`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def signal(self) -> Optional[_builtins.str]:
        """
        Signal name to exclude (used when `type = exclude_signal`).
        """
        return pulumi.get(self, "signal")


@pulumi.output_type
class NgwafAccountRuleCondition(dict):
    def __init__(__self__, *,
                 field: _builtins.str,
                 operator: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str field: Field to inspect (e.g., `ip`, `path`).
        :param _builtins.str operator: Operator to apply (e.g., `equals`, `contains`).
        :param _builtins.str value: The value to test the field against.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        """
        Field to inspect (e.g., `ip`, `path`).
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator to apply (e.g., `equals`, `contains`).
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value to test the field against.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NgwafAccountRuleGroupCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupOperator":
            suggest = "group_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgwafAccountRuleGroupCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgwafAccountRuleGroupCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgwafAccountRuleGroupCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Sequence['outputs.NgwafAccountRuleGroupConditionCondition'],
                 group_operator: _builtins.str):
        """
        :param Sequence['NgwafAccountRuleGroupConditionConditionArgs'] conditions: A list of nested conditions in this group.
        :param _builtins.str group_operator: Logical operator for the group. Accepted values are `any` and `all`.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "group_operator", group_operator)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.NgwafAccountRuleGroupConditionCondition']:
        """
        A list of nested conditions in this group.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="groupOperator")
    def group_operator(self) -> _builtins.str:
        """
        Logical operator for the group. Accepted values are `any` and `all`.
        """
        return pulumi.get(self, "group_operator")


@pulumi.output_type
class NgwafAccountRuleGroupConditionCondition(dict):
    def __init__(__self__, *,
                 field: _builtins.str,
                 operator: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str field: Field to inspect (e.g., `ip`, `path`).
        :param _builtins.str operator: Operator to apply (e.g., `equals`, `contains`).
        :param _builtins.str value: The value to test the field against.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        """
        Field to inspect (e.g., `ip`, `path`).
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator to apply (e.g., `equals`, `contains`).
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value to test the field against.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NgwafAccountRuleRateLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientIdentifiers":
            suggest = "client_identifiers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgwafAccountRuleRateLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgwafAccountRuleRateLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgwafAccountRuleRateLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_identifiers: Sequence['outputs.NgwafAccountRuleRateLimitClientIdentifier'],
                 duration: _builtins.int,
                 interval: _builtins.int,
                 signal: _builtins.str,
                 threshold: _builtins.int):
        """
        :param Sequence['NgwafAccountRuleRateLimitClientIdentifierArgs'] client_identifiers: List of client identifiers used for rate limiting. Can only be length 1 or 2.
        :param _builtins.int duration: Duration in seconds for the rate limit.
        :param _builtins.int interval: Time interval for the rate limit in seconds. Accepted values are 60, 600, and 3600.
        :param _builtins.str signal: Reference ID of the custom signal this rule uses to count requests.
        :param _builtins.int threshold: Rate limit threshold. Minimum 1 and maximum 10,000.
        """
        pulumi.set(__self__, "client_identifiers", client_identifiers)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "signal", signal)
        pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter(name="clientIdentifiers")
    def client_identifiers(self) -> Sequence['outputs.NgwafAccountRuleRateLimitClientIdentifier']:
        """
        List of client identifiers used for rate limiting. Can only be length 1 or 2.
        """
        return pulumi.get(self, "client_identifiers")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.int:
        """
        Duration in seconds for the rate limit.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.int:
        """
        Time interval for the rate limit in seconds. Accepted values are 60, 600, and 3600.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def signal(self) -> _builtins.str:
        """
        Reference ID of the custom signal this rule uses to count requests.
        """
        return pulumi.get(self, "signal")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.int:
        """
        Rate limit threshold. Minimum 1 and maximum 10,000.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class NgwafAccountRuleRateLimitClientIdentifier(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 key: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of the Client Identifier.
        :param _builtins.str key: Key for the Client Identifier.
        :param _builtins.str name: Name for the Client Identifier.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the Client Identifier.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Key for the Client Identifier.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name for the Client Identifier.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NgwafWorkspaceAttackSignalThresholds(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oneHour":
            suggest = "one_hour"
        elif key == "oneMinute":
            suggest = "one_minute"
        elif key == "tenMinutes":
            suggest = "ten_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgwafWorkspaceAttackSignalThresholds. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgwafWorkspaceAttackSignalThresholds.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgwafWorkspaceAttackSignalThresholds.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immediate: Optional[_builtins.bool] = None,
                 one_hour: Optional[_builtins.int] = None,
                 one_minute: Optional[_builtins.int] = None,
                 ten_minutes: Optional[_builtins.int] = None):
        """
        :param _builtins.bool immediate: Ignore thresholds and block immediately when at least one attack signal is detected. Default value `false`.
        :param _builtins.int one_hour: The one-hour interval threshold. Minimum 1 and maximum 10,000. Default value 100.
        :param _builtins.int one_minute: The one-minute interval threshold. Minimum 1 and maximum 10,000. Default value 1.
        :param _builtins.int ten_minutes: The ten-minute interval threshold. Minimum 1 and maximum 10,000. Default value 60.
        """
        if immediate is not None:
            pulumi.set(__self__, "immediate", immediate)
        if one_hour is not None:
            pulumi.set(__self__, "one_hour", one_hour)
        if one_minute is not None:
            pulumi.set(__self__, "one_minute", one_minute)
        if ten_minutes is not None:
            pulumi.set(__self__, "ten_minutes", ten_minutes)

    @_builtins.property
    @pulumi.getter
    def immediate(self) -> Optional[_builtins.bool]:
        """
        Ignore thresholds and block immediately when at least one attack signal is detected. Default value `false`.
        """
        return pulumi.get(self, "immediate")

    @_builtins.property
    @pulumi.getter(name="oneHour")
    def one_hour(self) -> Optional[_builtins.int]:
        """
        The one-hour interval threshold. Minimum 1 and maximum 10,000. Default value 100.
        """
        return pulumi.get(self, "one_hour")

    @_builtins.property
    @pulumi.getter(name="oneMinute")
    def one_minute(self) -> Optional[_builtins.int]:
        """
        The one-minute interval threshold. Minimum 1 and maximum 10,000. Default value 1.
        """
        return pulumi.get(self, "one_minute")

    @_builtins.property
    @pulumi.getter(name="tenMinutes")
    def ten_minutes(self) -> Optional[_builtins.int]:
        """
        The ten-minute interval threshold. Minimum 1 and maximum 10,000. Default value 60.
        """
        return pulumi.get(self, "ten_minutes")


@pulumi.output_type
class NgwafWorkspaceRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redirectUrl":
            suggest = "redirect_url"
        elif key == "responseCode":
            suggest = "response_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgwafWorkspaceRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgwafWorkspaceRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgwafWorkspaceRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 redirect_url: Optional[_builtins.str] = None,
                 response_code: Optional[_builtins.int] = None,
                 signal: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The action type, e.g. `block`, `redirect`, `exclude_signal`.
        :param _builtins.str redirect_url: Redirect target (used when `type = redirect`).
        :param _builtins.int response_code: Response code used with redirect.
        :param _builtins.str signal: Signal name to exclude (used when `type = exclude_signal`).
        """
        pulumi.set(__self__, "type", type)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if response_code is not None:
            pulumi.set(__self__, "response_code", response_code)
        if signal is not None:
            pulumi.set(__self__, "signal", signal)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The action type, e.g. `block`, `redirect`, `exclude_signal`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[_builtins.str]:
        """
        Redirect target (used when `type = redirect`).
        """
        return pulumi.get(self, "redirect_url")

    @_builtins.property
    @pulumi.getter(name="responseCode")
    def response_code(self) -> Optional[_builtins.int]:
        """
        Response code used with redirect.
        """
        return pulumi.get(self, "response_code")

    @_builtins.property
    @pulumi.getter
    def signal(self) -> Optional[_builtins.str]:
        """
        Signal name to exclude (used when `type = exclude_signal`).
        """
        return pulumi.get(self, "signal")


@pulumi.output_type
class NgwafWorkspaceRuleCondition(dict):
    def __init__(__self__, *,
                 field: _builtins.str,
                 operator: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str field: Field to inspect (e.g., `ip`, `path`).
        :param _builtins.str operator: Operator to apply (e.g., `equals`, `contains`).
        :param _builtins.str value: The value to test the field against.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        """
        Field to inspect (e.g., `ip`, `path`).
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator to apply (e.g., `equals`, `contains`).
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value to test the field against.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NgwafWorkspaceRuleGroupCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupOperator":
            suggest = "group_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgwafWorkspaceRuleGroupCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgwafWorkspaceRuleGroupCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgwafWorkspaceRuleGroupCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Sequence['outputs.NgwafWorkspaceRuleGroupConditionCondition'],
                 group_operator: _builtins.str):
        """
        :param Sequence['NgwafWorkspaceRuleGroupConditionConditionArgs'] conditions: A list of nested conditions in this group.
        :param _builtins.str group_operator: Logical operator for the group. Accepted values are `any` and `all`.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "group_operator", group_operator)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.NgwafWorkspaceRuleGroupConditionCondition']:
        """
        A list of nested conditions in this group.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="groupOperator")
    def group_operator(self) -> _builtins.str:
        """
        Logical operator for the group. Accepted values are `any` and `all`.
        """
        return pulumi.get(self, "group_operator")


@pulumi.output_type
class NgwafWorkspaceRuleGroupConditionCondition(dict):
    def __init__(__self__, *,
                 field: _builtins.str,
                 operator: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str field: Field to inspect (e.g., `ip`, `path`).
        :param _builtins.str operator: Operator to apply (e.g., `equals`, `contains`).
        :param _builtins.str value: The value to test the field against.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        """
        Field to inspect (e.g., `ip`, `path`).
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator to apply (e.g., `equals`, `contains`).
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value to test the field against.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NgwafWorkspaceRuleRateLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientIdentifiers":
            suggest = "client_identifiers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgwafWorkspaceRuleRateLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgwafWorkspaceRuleRateLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgwafWorkspaceRuleRateLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_identifiers: Sequence['outputs.NgwafWorkspaceRuleRateLimitClientIdentifier'],
                 duration: _builtins.int,
                 interval: _builtins.int,
                 signal: _builtins.str,
                 threshold: _builtins.int):
        """
        :param Sequence['NgwafWorkspaceRuleRateLimitClientIdentifierArgs'] client_identifiers: List of client identifiers used for rate limiting. Can only be length 1 or 2.
        :param _builtins.int duration: Duration in seconds for the rate limit.
        :param _builtins.int interval: Time interval for the rate limit in seconds. Accepted values are 60, 600, and 3600.
        :param _builtins.str signal: Reference ID of the custom signal this rule uses to count requests.
        :param _builtins.int threshold: Rate limit threshold. Minimum 1 and maximum 10,000.
        """
        pulumi.set(__self__, "client_identifiers", client_identifiers)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "signal", signal)
        pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter(name="clientIdentifiers")
    def client_identifiers(self) -> Sequence['outputs.NgwafWorkspaceRuleRateLimitClientIdentifier']:
        """
        List of client identifiers used for rate limiting. Can only be length 1 or 2.
        """
        return pulumi.get(self, "client_identifiers")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.int:
        """
        Duration in seconds for the rate limit.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.int:
        """
        Time interval for the rate limit in seconds. Accepted values are 60, 600, and 3600.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def signal(self) -> _builtins.str:
        """
        Reference ID of the custom signal this rule uses to count requests.
        """
        return pulumi.get(self, "signal")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.int:
        """
        Rate limit threshold. Minimum 1 and maximum 10,000.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class NgwafWorkspaceRuleRateLimitClientIdentifier(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 key: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of the Client Identifier.
        :param _builtins.str key: Key for the Client Identifier.
        :param _builtins.str name: Name for the Client Identifier.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the Client Identifier.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Key for the Client Identifier.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name for the Client Identifier.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceACLEntriesEntry(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 comment: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 negated: Optional[_builtins.bool] = None,
                 subnet: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip: An IP address that is the focus for the ACL
        :param _builtins.str comment: A personal freeform descriptive note
        :param _builtins.str id: The unique ID of the entry
        :param _builtins.bool negated: A boolean that will negate the match if true
        :param _builtins.str subnet: An optional subnet mask applied to the IP address
        """
        pulumi.set(__self__, "ip", ip)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if negated is not None:
            pulumi.set(__self__, "negated", negated)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        An IP address that is the focus for the ACL
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[_builtins.str]:
        """
        A personal freeform descriptive note
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The unique ID of the entry
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def negated(self) -> Optional[_builtins.bool]:
        """
        A boolean that will negate the match if true
        """
        return pulumi.get(self, "negated")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[_builtins.str]:
        """
        An optional subnet mask applied to the IP address
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ServiceComputeBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "betweenBytesTimeout":
            suggest = "between_bytes_timeout"
        elif key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "errorThreshold":
            suggest = "error_threshold"
        elif key == "firstByteTimeout":
            suggest = "first_byte_timeout"
        elif key == "keepaliveTime":
            suggest = "keepalive_time"
        elif key == "maxConn":
            suggest = "max_conn"
        elif key == "maxTlsVersion":
            suggest = "max_tls_version"
        elif key == "minTlsVersion":
            suggest = "min_tls_version"
        elif key == "overrideHost":
            suggest = "override_host"
        elif key == "preferIpv6":
            suggest = "prefer_ipv6"
        elif key == "shareKey":
            suggest = "share_key"
        elif key == "sslCaCert":
            suggest = "ssl_ca_cert"
        elif key == "sslCertHostname":
            suggest = "ssl_cert_hostname"
        elif key == "sslCheckCert":
            suggest = "ssl_check_cert"
        elif key == "sslCiphers":
            suggest = "ssl_ciphers"
        elif key == "sslClientCert":
            suggest = "ssl_client_cert"
        elif key == "sslClientKey":
            suggest = "ssl_client_key"
        elif key == "sslSniHostname":
            suggest = "ssl_sni_hostname"
        elif key == "useSsl":
            suggest = "use_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 name: _builtins.str,
                 between_bytes_timeout: Optional[_builtins.int] = None,
                 connect_timeout: Optional[_builtins.int] = None,
                 error_threshold: Optional[_builtins.int] = None,
                 first_byte_timeout: Optional[_builtins.int] = None,
                 healthcheck: Optional[_builtins.str] = None,
                 keepalive_time: Optional[_builtins.int] = None,
                 max_conn: Optional[_builtins.int] = None,
                 max_tls_version: Optional[_builtins.str] = None,
                 min_tls_version: Optional[_builtins.str] = None,
                 override_host: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 prefer_ipv6: Optional[_builtins.bool] = None,
                 share_key: Optional[_builtins.str] = None,
                 shield: Optional[_builtins.str] = None,
                 ssl_ca_cert: Optional[_builtins.str] = None,
                 ssl_cert_hostname: Optional[_builtins.str] = None,
                 ssl_check_cert: Optional[_builtins.bool] = None,
                 ssl_ciphers: Optional[_builtins.str] = None,
                 ssl_client_cert: Optional[_builtins.str] = None,
                 ssl_client_key: Optional[_builtins.str] = None,
                 ssl_sni_hostname: Optional[_builtins.str] = None,
                 use_ssl: Optional[_builtins.bool] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str address: An IPv4, hostname, or IPv6 address for the Backend
        :param _builtins.str name: Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.int between_bytes_timeout: How long to wait between bytes in milliseconds. Default `10000`
        :param _builtins.int connect_timeout: How long to wait for a timeout in milliseconds. Default `1000`
        :param _builtins.int error_threshold: Number of errors to allow before the Backend is marked as down. Default `0`
        :param _builtins.int first_byte_timeout: How long to wait for the first bytes in milliseconds. Default `15000`
        :param _builtins.str healthcheck: Name of a defined `healthcheck` to assign to this backend
        :param _builtins.int keepalive_time: How long in seconds to keep a persistent connection to the backend between requests.
        :param _builtins.int max_conn: Maximum number of connections for this Backend. Default `200`
        :param _builtins.str max_tls_version: Maximum allowed TLS version on SSL connections to this backend.
        :param _builtins.str min_tls_version: Minimum allowed TLS version on SSL connections to this backend.
        :param _builtins.str override_host: The hostname to override the Host header
        :param _builtins.int port: The port number on which the Backend responds. Default `80`
        :param _builtins.bool prefer_ipv6: Prefer IPv6 connections to origins for hostname backends. Default `true`
        :param _builtins.str share_key: Value that when shared across backends will enable those backends to share the same health check.
        :param _builtins.str shield: The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        :param _builtins.str ssl_ca_cert: CA certificate attached to origin.
        :param _builtins.str ssl_cert_hostname: Configure certificate validation. Does not affect SNI at all
        :param _builtins.bool ssl_check_cert: Be strict about checking SSL certs. Default `true`
        :param _builtins.str ssl_ciphers: Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        :param _builtins.str ssl_client_cert: Client certificate attached to origin. Used when connecting to the backend
        :param _builtins.str ssl_client_key: Client key attached to origin. Used when connecting to the backend
        :param _builtins.str ssl_sni_hostname: Configure SNI in the TLS handshake. Does not affect cert validation at all
        :param _builtins.bool use_ssl: Whether or not to use SSL to reach the Backend. Default `false`
        :param _builtins.int weight: The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if between_bytes_timeout is not None:
            pulumi.set(__self__, "between_bytes_timeout", between_bytes_timeout)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if first_byte_timeout is not None:
            pulumi.set(__self__, "first_byte_timeout", first_byte_timeout)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if keepalive_time is not None:
            pulumi.set(__self__, "keepalive_time", keepalive_time)
        if max_conn is not None:
            pulumi.set(__self__, "max_conn", max_conn)
        if max_tls_version is not None:
            pulumi.set(__self__, "max_tls_version", max_tls_version)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if override_host is not None:
            pulumi.set(__self__, "override_host", override_host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if prefer_ipv6 is not None:
            pulumi.set(__self__, "prefer_ipv6", prefer_ipv6)
        if share_key is not None:
            pulumi.set(__self__, "share_key", share_key)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if ssl_ca_cert is not None:
            pulumi.set(__self__, "ssl_ca_cert", ssl_ca_cert)
        if ssl_cert_hostname is not None:
            pulumi.set(__self__, "ssl_cert_hostname", ssl_cert_hostname)
        if ssl_check_cert is not None:
            pulumi.set(__self__, "ssl_check_cert", ssl_check_cert)
        if ssl_ciphers is not None:
            pulumi.set(__self__, "ssl_ciphers", ssl_ciphers)
        if ssl_client_cert is not None:
            pulumi.set(__self__, "ssl_client_cert", ssl_client_cert)
        if ssl_client_key is not None:
            pulumi.set(__self__, "ssl_client_key", ssl_client_key)
        if ssl_sni_hostname is not None:
            pulumi.set(__self__, "ssl_sni_hostname", ssl_sni_hostname)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        An IPv4, hostname, or IPv6 address for the Backend
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="betweenBytesTimeout")
    def between_bytes_timeout(self) -> Optional[_builtins.int]:
        """
        How long to wait between bytes in milliseconds. Default `10000`
        """
        return pulumi.get(self, "between_bytes_timeout")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[_builtins.int]:
        """
        How long to wait for a timeout in milliseconds. Default `1000`
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[_builtins.int]:
        """
        Number of errors to allow before the Backend is marked as down. Default `0`
        """
        return pulumi.get(self, "error_threshold")

    @_builtins.property
    @pulumi.getter(name="firstByteTimeout")
    def first_byte_timeout(self) -> Optional[_builtins.int]:
        """
        How long to wait for the first bytes in milliseconds. Default `15000`
        """
        return pulumi.get(self, "first_byte_timeout")

    @_builtins.property
    @pulumi.getter
    def healthcheck(self) -> Optional[_builtins.str]:
        """
        Name of a defined `healthcheck` to assign to this backend
        """
        return pulumi.get(self, "healthcheck")

    @_builtins.property
    @pulumi.getter(name="keepaliveTime")
    def keepalive_time(self) -> Optional[_builtins.int]:
        """
        How long in seconds to keep a persistent connection to the backend between requests.
        """
        return pulumi.get(self, "keepalive_time")

    @_builtins.property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> Optional[_builtins.int]:
        """
        Maximum number of connections for this Backend. Default `200`
        """
        return pulumi.get(self, "max_conn")

    @_builtins.property
    @pulumi.getter(name="maxTlsVersion")
    def max_tls_version(self) -> Optional[_builtins.str]:
        """
        Maximum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "max_tls_version")

    @_builtins.property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[_builtins.str]:
        """
        Minimum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "min_tls_version")

    @_builtins.property
    @pulumi.getter(name="overrideHost")
    def override_host(self) -> Optional[_builtins.str]:
        """
        The hostname to override the Host header
        """
        return pulumi.get(self, "override_host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port number on which the Backend responds. Default `80`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="preferIpv6")
    def prefer_ipv6(self) -> Optional[_builtins.bool]:
        """
        Prefer IPv6 connections to origins for hostname backends. Default `true`
        """
        return pulumi.get(self, "prefer_ipv6")

    @_builtins.property
    @pulumi.getter(name="shareKey")
    def share_key(self) -> Optional[_builtins.str]:
        """
        Value that when shared across backends will enable those backends to share the same health check.
        """
        return pulumi.get(self, "share_key")

    @_builtins.property
    @pulumi.getter
    def shield(self) -> Optional[_builtins.str]:
        """
        The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        """
        return pulumi.get(self, "shield")

    @_builtins.property
    @pulumi.getter(name="sslCaCert")
    def ssl_ca_cert(self) -> Optional[_builtins.str]:
        """
        CA certificate attached to origin.
        """
        return pulumi.get(self, "ssl_ca_cert")

    @_builtins.property
    @pulumi.getter(name="sslCertHostname")
    def ssl_cert_hostname(self) -> Optional[_builtins.str]:
        """
        Configure certificate validation. Does not affect SNI at all
        """
        return pulumi.get(self, "ssl_cert_hostname")

    @_builtins.property
    @pulumi.getter(name="sslCheckCert")
    def ssl_check_cert(self) -> Optional[_builtins.bool]:
        """
        Be strict about checking SSL certs. Default `true`
        """
        return pulumi.get(self, "ssl_check_cert")

    @_builtins.property
    @pulumi.getter(name="sslCiphers")
    def ssl_ciphers(self) -> Optional[_builtins.str]:
        """
        Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        """
        return pulumi.get(self, "ssl_ciphers")

    @_builtins.property
    @pulumi.getter(name="sslClientCert")
    def ssl_client_cert(self) -> Optional[_builtins.str]:
        """
        Client certificate attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_cert")

    @_builtins.property
    @pulumi.getter(name="sslClientKey")
    def ssl_client_key(self) -> Optional[_builtins.str]:
        """
        Client key attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_key")

    @_builtins.property
    @pulumi.getter(name="sslSniHostname")
    def ssl_sni_hostname(self) -> Optional[_builtins.str]:
        """
        Configure SNI in the TLS handshake. Does not affect cert validation at all
        """
        return pulumi.get(self, "ssl_sni_hostname")

    @_builtins.property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[_builtins.bool]:
        """
        Whether or not to use SSL to reach the Backend. Default `false`
        """
        return pulumi.get(self, "use_ssl")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServiceComputeDictionary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dictionaryId":
            suggest = "dictionary_id"
        elif key == "forceDestroy":
            suggest = "force_destroy"
        elif key == "writeOnly":
            suggest = "write_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeDictionary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeDictionary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeDictionary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 dictionary_id: Optional[_builtins.str] = None,
                 force_destroy: Optional[_builtins.bool] = None,
                 write_only: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        :param _builtins.str dictionary_id: The ID of the dictionary
        :param _builtins.bool force_destroy: Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        pulumi.set(__self__, "name", name)
        if dictionary_id is not None:
            pulumi.set(__self__, "dictionary_id", dictionary_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if write_only is not None:
            pulumi.set(__self__, "write_only", write_only)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[_builtins.str]:
        """
        The ID of the dictionary
        """
        return pulumi.get(self, "dictionary_id")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[_builtins.bool]:
        """
        Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "write_only")


@pulumi.output_type
class ServiceComputeDomain(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 comment: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        :param _builtins.str comment: An optional comment about the Domain.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[_builtins.str]:
        """
        An optional comment about the Domain.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class ServiceComputeImageOptimizerDefaultSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowVideo":
            suggest = "allow_video"
        elif key == "jpegQuality":
            suggest = "jpeg_quality"
        elif key == "jpegType":
            suggest = "jpeg_type"
        elif key == "resizeFilter":
            suggest = "resize_filter"
        elif key == "webpQuality":
            suggest = "webp_quality"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeImageOptimizerDefaultSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeImageOptimizerDefaultSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeImageOptimizerDefaultSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_video: Optional[_builtins.bool] = None,
                 jpeg_quality: Optional[_builtins.int] = None,
                 jpeg_type: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 resize_filter: Optional[_builtins.str] = None,
                 upscale: Optional[_builtins.bool] = None,
                 webp: Optional[_builtins.bool] = None,
                 webp_quality: Optional[_builtins.int] = None):
        """
        :param _builtins.bool allow_video: Enables GIF to MP4 transformations on this service.
        :param _builtins.int jpeg_quality: The default quality to use with JPEG output. This can be overridden with the "quality" parameter on specific image optimizer requests.
        :param _builtins.str jpeg_type: The default type of JPEG output to use. This can be overridden with "format=bjpeg" and "format=pjpeg" on specific image optimizer requests. Valid values are `auto`, `baseline` and `progressive`.
               	- auto: Match the input JPEG type, or baseline if transforming from a non-JPEG input.
               	- baseline: Output baseline JPEG images
               	- progressive: Output progressive JPEG images
        :param _builtins.str name: Used by the provider to identify modified settings. Changing this value will force the entire block to be deleted, then recreated.
        :param _builtins.str resize_filter: The type of filter to use while resizing an image. Valid values are `lanczos3`, `lanczos2`, `bicubic`, `bilinear` and `nearest`.
               	- lanczos3: A Lanczos filter with a kernel size of 3. Lanczos filters can detect edges and linear features within an image, providing the best possible reconstruction.
               	- lanczos2: A Lanczos filter with a kernel size of 2.
               	- bicubic: A filter using an average of a 4x4 environment of pixels, weighing the innermost pixels higher.
               	- bilinear: A filter using an average of a 2x2 environment of pixels.
               	- nearest: A filter using the value of nearby translated pixel values. Preserves hard edges.
        :param _builtins.bool upscale: Whether or not we should allow output images to render at sizes larger than input.
        :param _builtins.bool webp: Controls whether or not to default to WebP output when the client supports it. This is equivalent to adding "auto=webp" to all image optimizer requests.
        :param _builtins.int webp_quality: The default quality to use with WebP output. This can be overridden with the second option in the "quality" URL parameter on specific image optimizer requests.
        """
        if allow_video is not None:
            pulumi.set(__self__, "allow_video", allow_video)
        if jpeg_quality is not None:
            pulumi.set(__self__, "jpeg_quality", jpeg_quality)
        if jpeg_type is not None:
            pulumi.set(__self__, "jpeg_type", jpeg_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resize_filter is not None:
            pulumi.set(__self__, "resize_filter", resize_filter)
        if upscale is not None:
            pulumi.set(__self__, "upscale", upscale)
        if webp is not None:
            pulumi.set(__self__, "webp", webp)
        if webp_quality is not None:
            pulumi.set(__self__, "webp_quality", webp_quality)

    @_builtins.property
    @pulumi.getter(name="allowVideo")
    def allow_video(self) -> Optional[_builtins.bool]:
        """
        Enables GIF to MP4 transformations on this service.
        """
        return pulumi.get(self, "allow_video")

    @_builtins.property
    @pulumi.getter(name="jpegQuality")
    def jpeg_quality(self) -> Optional[_builtins.int]:
        """
        The default quality to use with JPEG output. This can be overridden with the "quality" parameter on specific image optimizer requests.
        """
        return pulumi.get(self, "jpeg_quality")

    @_builtins.property
    @pulumi.getter(name="jpegType")
    def jpeg_type(self) -> Optional[_builtins.str]:
        """
        The default type of JPEG output to use. This can be overridden with "format=bjpeg" and "format=pjpeg" on specific image optimizer requests. Valid values are `auto`, `baseline` and `progressive`.
        	- auto: Match the input JPEG type, or baseline if transforming from a non-JPEG input.
        	- baseline: Output baseline JPEG images
        	- progressive: Output progressive JPEG images
        """
        return pulumi.get(self, "jpeg_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Used by the provider to identify modified settings. Changing this value will force the entire block to be deleted, then recreated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resizeFilter")
    def resize_filter(self) -> Optional[_builtins.str]:
        """
        The type of filter to use while resizing an image. Valid values are `lanczos3`, `lanczos2`, `bicubic`, `bilinear` and `nearest`.
        	- lanczos3: A Lanczos filter with a kernel size of 3. Lanczos filters can detect edges and linear features within an image, providing the best possible reconstruction.
        	- lanczos2: A Lanczos filter with a kernel size of 2.
        	- bicubic: A filter using an average of a 4x4 environment of pixels, weighing the innermost pixels higher.
        	- bilinear: A filter using an average of a 2x2 environment of pixels.
        	- nearest: A filter using the value of nearby translated pixel values. Preserves hard edges.
        """
        return pulumi.get(self, "resize_filter")

    @_builtins.property
    @pulumi.getter
    def upscale(self) -> Optional[_builtins.bool]:
        """
        Whether or not we should allow output images to render at sizes larger than input.
        """
        return pulumi.get(self, "upscale")

    @_builtins.property
    @pulumi.getter
    def webp(self) -> Optional[_builtins.bool]:
        """
        Controls whether or not to default to WebP output when the client supports it. This is equivalent to adding "auto=webp" to all image optimizer requests.
        """
        return pulumi.get(self, "webp")

    @_builtins.property
    @pulumi.getter(name="webpQuality")
    def webp_quality(self) -> Optional[_builtins.int]:
        """
        The default quality to use with WebP output. This can be overridden with the second option in the "quality" URL parameter on specific image optimizer requests.
        """
        return pulumi.get(self, "webp_quality")


@pulumi.output_type
class ServiceComputeLoggingBigquery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "processingRegion":
            suggest = "processing_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingBigquery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingBigquery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingBigquery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: _builtins.str,
                 email: _builtins.str,
                 name: _builtins.str,
                 project_id: _builtins.str,
                 secret_key: _builtins.str,
                 table: _builtins.str,
                 account_name: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 template: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataset: The ID of your BigQuery dataset
        :param _builtins.str email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        :param _builtins.str name: A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str project_id: The ID of your GCP project
        :param _builtins.str secret_key: The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        :param _builtins.str table: The ID of your BigQuery table
        :param _builtins.str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str template: BigQuery table name suffix template
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "table", table)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> _builtins.str:
        """
        The ID of your BigQuery dataset
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of your GCP project
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> _builtins.str:
        """
        The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter
    def table(self) -> _builtins.str:
        """
        The ID of your BigQuery table
        """
        return pulumi.get(self, "table")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[_builtins.str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[_builtins.str]:
        """
        BigQuery table name suffix template
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class ServiceComputeLoggingBlobstorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "sasToken":
            suggest = "sas_token"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingBlobstorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingBlobstorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingBlobstorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: _builtins.str,
                 container: _builtins.str,
                 name: _builtins.str,
                 sas_token: _builtins.str,
                 compression_codec: Optional[_builtins.str] = None,
                 file_max_bytes: Optional[_builtins.int] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str account_name: The unique Azure Blob Storage namespace in which your data objects are stored
        :param _builtins.str container: The name of the Azure Blob Storage container in which to store logs
        :param _builtins.str name: A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str sas_token: The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str path: The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        :param _builtins.int period: How frequently the logs should be transferred in seconds. Default `3600`
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sas_token", sas_token)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if file_max_bytes is not None:
            pulumi.set(__self__, "file_max_bytes", file_max_bytes)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        The unique Azure Blob Storage namespace in which your data objects are stored
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter
    def container(self) -> _builtins.str:
        """
        The name of the Azure Blob Storage container in which to store logs
        """
        return pulumi.get(self, "container")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> _builtins.str:
        """
        The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        """
        return pulumi.get(self, "sas_token")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[_builtins.int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently the logs should be transferred in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingCloudfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingCloudfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingCloudfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingCloudfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: _builtins.str,
                 bucket_name: _builtins.str,
                 name: _builtins.str,
                 user: _builtins.str,
                 compression_codec: Optional[_builtins.str] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_key: Your Cloud File account access key
        :param _builtins.str bucket_name: The name of your Cloud Files container
        :param _builtins.str name: The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str user: The username for your Cloud Files account
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str path: The path to upload logs to
        :param _builtins.int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> _builtins.str:
        """
        Your Cloud File account access key
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The name of your Cloud Files container
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The username for your Cloud Files account
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingDatadog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processingRegion":
            suggest = "processing_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingDatadog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingDatadog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingDatadog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 processing_region: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The API key from your Datadog account
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The API key from your Datadog account
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ServiceComputeLoggingDigitalocean(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingDigitalocean. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingDigitalocean.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingDigitalocean.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: _builtins.str,
                 bucket_name: _builtins.str,
                 name: _builtins.str,
                 secret_key: _builtins.str,
                 compression_codec: Optional[_builtins.str] = None,
                 domain: Optional[_builtins.str] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_key: Your DigitalOcean Spaces account access key
        :param _builtins.str bucket_name: The name of the DigitalOcean Space
        :param _builtins.str name: The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str secret_key: Your DigitalOcean Spaces account secret key
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.str domain: The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str path: The path to upload logs to
        :param _builtins.int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> _builtins.str:
        """
        Your DigitalOcean Spaces account access key
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The name of the DigitalOcean Space
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> _builtins.str:
        """
        Your DigitalOcean Spaces account secret key
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingElasticsearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processingRegion":
            suggest = "processing_region"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingElasticsearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingElasticsearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingElasticsearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index: _builtins.str,
                 name: _builtins.str,
                 url: _builtins.str,
                 password: Optional[_builtins.str] = None,
                 pipeline: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 request_max_bytes: Optional[_builtins.int] = None,
                 request_max_entries: Optional[_builtins.int] = None,
                 tls_ca_cert: Optional[_builtins.str] = None,
                 tls_client_cert: Optional[_builtins.str] = None,
                 tls_client_key: Optional[_builtins.str] = None,
                 tls_hostname: Optional[_builtins.str] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.str index: The name of the Elasticsearch index to send documents (logs) to
        :param _builtins.str name: The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str url: The Elasticsearch URL to stream logs to
        :param _builtins.str password: BasicAuth password for Elasticsearch
        :param _builtins.str pipeline: The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.int request_max_bytes: The maximum number of logs sent in one request. Defaults to `0` for unbounded
        :param _builtins.int request_max_entries: The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        :param _builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param _builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param _builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param _builtins.str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        :param _builtins.str user: BasicAuth username for Elasticsearch
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def index(self) -> _builtins.str:
        """
        The name of the Elasticsearch index to send documents (logs) to
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The Elasticsearch URL to stream logs to
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        BasicAuth password for Elasticsearch
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def pipeline(self) -> Optional[_builtins.str]:
        """
        The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        """
        return pulumi.get(self, "pipeline")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[_builtins.int]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @_builtins.property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[_builtins.int]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_entries")

    @_builtins.property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[_builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[_builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[_builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @_builtins.property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[_builtins.str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        BasicAuth username for Elasticsearch
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceComputeLoggingFtp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingFtp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingFtp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingFtp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 name: _builtins.str,
                 password: _builtins.str,
                 path: _builtins.str,
                 user: _builtins.str,
                 compression_codec: Optional[_builtins.str] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 port: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The FTP address to stream logs to
        :param _builtins.str name: The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str password: The password for the server (for anonymous use an email address)
        :param _builtins.str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param _builtins.str user: The username for the server (can be `anonymous`)
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.int period: How frequently the logs should be transferred, in seconds (Default `3600`)
        :param _builtins.int port: The port number. Default: `21`
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The FTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password for the server (for anonymous use an email address)
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The username for the server (can be `anonymous`)
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently the logs should be transferred, in seconds (Default `3600`)
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port number. Default: `21`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingGc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingGc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingGc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingGc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 name: _builtins.str,
                 account_name: Optional[_builtins.str] = None,
                 compression_codec: Optional[_builtins.str] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 secret_key: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket_name: The name of the bucket in which to store the logs
        :param _builtins.str name: A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param _builtins.int period: How frequently the logs should be transferred, in seconds (Default 3600)
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str project_id: The ID of your Google Cloud Platform project
        :param _builtins.str secret_key: The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        :param _builtins.str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[_builtins.str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently the logs should be transferred, in seconds (Default 3600)
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[_builtins.str]:
        """
        The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceComputeLoggingGooglepubsub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "processingRegion":
            suggest = "processing_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingGooglepubsub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingGooglepubsub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingGooglepubsub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 project_id: _builtins.str,
                 secret_key: _builtins.str,
                 topic: _builtins.str,
                 user: _builtins.str,
                 account_name: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str project_id: The ID of your Google Cloud Platform project
        :param _builtins.str secret_key: Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        :param _builtins.str topic: The Google Cloud Pub/Sub topic to which logs will be published
        :param _builtins.str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        :param _builtins.str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "topic", topic)
        pulumi.set(__self__, "user", user)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> _builtins.str:
        """
        Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        """
        The Google Cloud Pub/Sub topic to which logs will be published
        """
        return pulumi.get(self, "topic")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[_builtins.str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")


@pulumi.output_type
class ServiceComputeLoggingGrafanacloudlog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processingRegion":
            suggest = "processing_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingGrafanacloudlog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingGrafanacloudlog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingGrafanacloudlog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index: _builtins.str,
                 name: _builtins.str,
                 token: _builtins.str,
                 url: _builtins.str,
                 user: _builtins.str,
                 processing_region: Optional[_builtins.str] = None):
        """
        :param _builtins.str index: The stream identifier as a JSON string
        :param _builtins.str name: The unique name of the GrafanaCloudLogs logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The Access Policy Token key for your GrafanaCloudLogs account
        :param _builtins.str url: The URL to stream logs to
        :param _builtins.str user: The Grafana User ID
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)

    @_builtins.property
    @pulumi.getter
    def index(self) -> _builtins.str:
        """
        The stream identifier as a JSON string
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the GrafanaCloudLogs logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The Access Policy Token key for your GrafanaCloudLogs account
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The Grafana User ID
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")


@pulumi.output_type
class ServiceComputeLoggingHeroku(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processingRegion":
            suggest = "processing_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingHeroku. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingHeroku.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingHeroku.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 url: _builtins.str,
                 processing_region: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        :param _builtins.str url: The URL to stream logs to
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")


@pulumi.output_type
class ServiceComputeLoggingHoneycomb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processingRegion":
            suggest = "processing_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingHoneycomb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingHoneycomb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingHoneycomb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: _builtins.str,
                 name: _builtins.str,
                 token: _builtins.str,
                 processing_region: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataset: The Honeycomb Dataset you want to log to
        :param _builtins.str name: The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The Write Key from the Account page of your Honeycomb account
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> _builtins.str:
        """
        The Honeycomb Dataset you want to log to
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The Write Key from the Account page of your Honeycomb account
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")


@pulumi.output_type
class ServiceComputeLoggingHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"
        elif key == "jsonFormat":
            suggest = "json_format"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 url: _builtins.str,
                 content_type: Optional[_builtins.str] = None,
                 header_name: Optional[_builtins.str] = None,
                 header_value: Optional[_builtins.str] = None,
                 json_format: Optional[_builtins.str] = None,
                 message_type: Optional[_builtins.str] = None,
                 method: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 request_max_bytes: Optional[_builtins.int] = None,
                 request_max_entries: Optional[_builtins.int] = None,
                 tls_ca_cert: Optional[_builtins.str] = None,
                 tls_client_cert: Optional[_builtins.str] = None,
                 tls_client_key: Optional[_builtins.str] = None,
                 tls_hostname: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str url: URL that log data will be sent to. Must use the https protocol
        :param _builtins.str content_type: Value of the `Content-Type` header sent with the request
        :param _builtins.str header_name: Custom header sent with the request
        :param _builtins.str header_value: Value of the custom header sent with the request
        :param _builtins.str json_format: Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.int request_max_bytes: The maximum number of bytes sent in one request
        :param _builtins.int request_max_entries: The maximum number of logs sent in one request
        :param _builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param _builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param _builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param _builtins.str tls_hostname: Used during the TLS handshake to validate the certificate
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)
        if json_format is not None:
            pulumi.set(__self__, "json_format", json_format)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL that log data will be sent to. Must use the https protocol
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[_builtins.str]:
        """
        Value of the `Content-Type` header sent with the request
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[_builtins.str]:
        """
        Custom header sent with the request
        """
        return pulumi.get(self, "header_name")

    @_builtins.property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[_builtins.str]:
        """
        Value of the custom header sent with the request
        """
        return pulumi.get(self, "header_value")

    @_builtins.property
    @pulumi.getter(name="jsonFormat")
    def json_format(self) -> Optional[_builtins.str]:
        """
        Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        """
        return pulumi.get(self, "json_format")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[_builtins.int]:
        """
        The maximum number of bytes sent in one request
        """
        return pulumi.get(self, "request_max_bytes")

    @_builtins.property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[_builtins.int]:
        """
        The maximum number of logs sent in one request
        """
        return pulumi.get(self, "request_max_entries")

    @_builtins.property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[_builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[_builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[_builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @_builtins.property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[_builtins.str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")


@pulumi.output_type
class ServiceComputeLoggingKafka(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMethod":
            suggest = "auth_method"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "parseLogKeyvals":
            suggest = "parse_log_keyvals"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requiredAcks":
            suggest = "required_acks"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingKafka. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingKafka.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingKafka.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 brokers: _builtins.str,
                 name: _builtins.str,
                 topic: _builtins.str,
                 auth_method: Optional[_builtins.str] = None,
                 compression_codec: Optional[_builtins.str] = None,
                 parse_log_keyvals: Optional[_builtins.bool] = None,
                 password: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 request_max_bytes: Optional[_builtins.int] = None,
                 required_acks: Optional[_builtins.str] = None,
                 tls_ca_cert: Optional[_builtins.str] = None,
                 tls_client_cert: Optional[_builtins.str] = None,
                 tls_client_key: Optional[_builtins.str] = None,
                 tls_hostname: Optional[_builtins.str] = None,
                 use_tls: Optional[_builtins.bool] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.str brokers: A comma-separated list of IP addresses or hostnames of Kafka brokers
        :param _builtins.str name: The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str topic: The Kafka topic to send logs to
        :param _builtins.str auth_method: SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        :param _builtins.str compression_codec: The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        :param _builtins.bool parse_log_keyvals: Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        :param _builtins.str password: SASL Pass
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.int request_max_bytes: Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        :param _builtins.str required_acks: The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1` Wait for all in-sync replicas to respond
        :param _builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param _builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param _builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param _builtins.str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param _builtins.bool use_tls: Whether to use TLS for secure logging. Can be either `true` or `false`
        :param _builtins.str user: SASL User
        """
        pulumi.set(__self__, "brokers", brokers)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if parse_log_keyvals is not None:
            pulumi.set(__self__, "parse_log_keyvals", parse_log_keyvals)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if required_acks is not None:
            pulumi.set(__self__, "required_acks", required_acks)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def brokers(self) -> _builtins.str:
        """
        A comma-separated list of IP addresses or hostnames of Kafka brokers
        """
        return pulumi.get(self, "brokers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        """
        The Kafka topic to send logs to
        """
        return pulumi.get(self, "topic")

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[_builtins.str]:
        """
        SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        """
        return pulumi.get(self, "auth_method")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter(name="parseLogKeyvals")
    def parse_log_keyvals(self) -> Optional[_builtins.bool]:
        """
        Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        """
        return pulumi.get(self, "parse_log_keyvals")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        SASL Pass
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[_builtins.int]:
        """
        Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @_builtins.property
    @pulumi.getter(name="requiredAcks")
    def required_acks(self) -> Optional[_builtins.str]:
        """
        The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1` Wait for all in-sync replicas to respond
        """
        return pulumi.get(self, "required_acks")

    @_builtins.property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[_builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[_builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[_builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @_builtins.property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[_builtins.str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @_builtins.property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[_builtins.bool]:
        """
        Whether to use TLS for secure logging. Can be either `true` or `false`
        """
        return pulumi.get(self, "use_tls")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        SASL User
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceComputeLoggingKinese(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "iamRole":
            suggest = "iam_role"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingKinese. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingKinese.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingKinese.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 topic: _builtins.str,
                 access_key: Optional[_builtins.str] = None,
                 iam_role: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 secret_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str topic: The Kinesis stream name
        :param _builtins.str access_key: The AWS access key to be used to write to the stream
        :param _builtins.str iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str region: The AWS region the stream resides in. (Default: `us-east-1`)
        :param _builtins.str secret_key: The AWS secret access key to authenticate with
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        """
        The Kinesis stream name
        """
        return pulumi.get(self, "topic")

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[_builtins.str]:
        """
        The AWS access key to be used to write to the stream
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[_builtins.str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        """
        return pulumi.get(self, "iam_role")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The AWS region the stream resides in. (Default: `us-east-1`)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[_builtins.str]:
        """
        The AWS secret access key to authenticate with
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class ServiceComputeLoggingLogentry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processingRegion":
            suggest = "processing_region"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingLogentry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingLogentry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingLogentry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 port: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 use_tls: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: Use token based authentication (https://logentries.com/doc/input-token/)
        :param _builtins.int port: The port number configured in Logentries
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.bool use_tls: Whether to use TLS for secure logging
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        Use token based authentication (https://logentries.com/doc/input-token/)
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port number configured in Logentries
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[_builtins.bool]:
        """
        Whether to use TLS for secure logging
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceComputeLoggingLoggly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processingRegion":
            suggest = "processing_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingLoggly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingLoggly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingLoggly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 processing_region: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")


@pulumi.output_type
class ServiceComputeLoggingLogshuttle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processingRegion":
            suggest = "processing_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingLogshuttle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingLogshuttle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingLogshuttle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 url: _builtins.str,
                 processing_region: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The data authentication token associated with this endpoint
        :param _builtins.str url: Your Log Shuttle endpoint URL
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The data authentication token associated with this endpoint
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Your Log Shuttle endpoint URL
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")


@pulumi.output_type
class ServiceComputeLoggingNewrelic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processingRegion":
            suggest = "processing_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingNewrelic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingNewrelic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingNewrelic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 processing_region: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The Insert API key from the Account page of your New Relic account
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str region: The region that log data will be sent to. Default: `US`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The Insert API key from the Account page of your New Relic account
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region that log data will be sent to. Default: `US`
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ServiceComputeLoggingOpenstack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingOpenstack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingOpenstack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingOpenstack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: _builtins.str,
                 bucket_name: _builtins.str,
                 name: _builtins.str,
                 url: _builtins.str,
                 user: _builtins.str,
                 compression_codec: Optional[_builtins.str] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_key: Your OpenStack account access key
        :param _builtins.str bucket_name: The name of your OpenStack container
        :param _builtins.str name: The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str url: Your OpenStack auth url
        :param _builtins.str user: The username for your OpenStack account
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param _builtins.int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> _builtins.str:
        """
        Your OpenStack account access key
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The name of your OpenStack container
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Your OpenStack auth url
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The username for your OpenStack account
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingPapertrail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processingRegion":
            suggest = "processing_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingPapertrail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingPapertrail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingPapertrail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 name: _builtins.str,
                 port: _builtins.int,
                 processing_region: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The address of the Papertrail endpoint
        :param _builtins.str name: A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.int port: The port associated with the address where the Papertrail endpoint can be accessed
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The address of the Papertrail endpoint
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port associated with the address where the Papertrail endpoint can be accessed
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")


@pulumi.output_type
class ServiceComputeLoggingS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "s3AccessKey":
            suggest = "s3_access_key"
        elif key == "s3IamRole":
            suggest = "s3_iam_role"
        elif key == "s3SecretKey":
            suggest = "s3_secret_key"
        elif key == "serverSideEncryption":
            suggest = "server_side_encryption"
        elif key == "serverSideEncryptionKmsKeyId":
            suggest = "server_side_encryption_kms_key_id"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 name: _builtins.str,
                 acl: Optional[_builtins.str] = None,
                 compression_codec: Optional[_builtins.str] = None,
                 domain: Optional[_builtins.str] = None,
                 file_max_bytes: Optional[_builtins.int] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 redundancy: Optional[_builtins.str] = None,
                 s3_access_key: Optional[_builtins.str] = None,
                 s3_iam_role: Optional[_builtins.str] = None,
                 s3_secret_key: Optional[_builtins.str] = None,
                 server_side_encryption: Optional[_builtins.str] = None,
                 server_side_encryption_kms_key_id: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket_name: The name of the bucket in which to store the logs
        :param _builtins.str name: The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str acl: The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.str domain: If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        :param _builtins.int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param _builtins.int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str redundancy: The S3 storage class (redundancy level). Should be one of: `standard`, `intelligent_tiering`, `standard_ia`, `onezone_ia`, `glacier`, `glacier_ir`, `deep_archive`, or `reduced_redundancy`
        :param _builtins.str s3_access_key: AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        :param _builtins.str s3_iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        :param _builtins.str s3_secret_key: AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        :param _builtins.str server_side_encryption: Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        :param _builtins.str server_side_encryption_kms_key_id: Optional server-side KMS Key Id. Must be set if server_side_encryption is set to `aws:kms`
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if file_max_bytes is not None:
            pulumi.set(__self__, "file_max_bytes", file_max_bytes)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if redundancy is not None:
            pulumi.set(__self__, "redundancy", redundancy)
        if s3_access_key is not None:
            pulumi.set(__self__, "s3_access_key", s3_access_key)
        if s3_iam_role is not None:
            pulumi.set(__self__, "s3_iam_role", s3_iam_role)
        if s3_secret_key is not None:
            pulumi.set(__self__, "s3_secret_key", s3_secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[_builtins.str]:
        """
        The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[_builtins.int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def redundancy(self) -> Optional[_builtins.str]:
        """
        The S3 storage class (redundancy level). Should be one of: `standard`, `intelligent_tiering`, `standard_ia`, `onezone_ia`, `glacier`, `glacier_ir`, `deep_archive`, or `reduced_redundancy`
        """
        return pulumi.get(self, "redundancy")

    @_builtins.property
    @pulumi.getter(name="s3AccessKey")
    def s3_access_key(self) -> Optional[_builtins.str]:
        """
        AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        """
        return pulumi.get(self, "s3_access_key")

    @_builtins.property
    @pulumi.getter(name="s3IamRole")
    def s3_iam_role(self) -> Optional[_builtins.str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        """
        return pulumi.get(self, "s3_iam_role")

    @_builtins.property
    @pulumi.getter(name="s3SecretKey")
    def s3_secret_key(self) -> Optional[_builtins.str]:
        """
        AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        """
        return pulumi.get(self, "s3_secret_key")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[_builtins.str]:
        """
        Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[_builtins.str]:
        """
        Optional server-side KMS Key Id. Must be set if server_side_encryption is set to `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingScalyr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processingRegion":
            suggest = "processing_region"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingScalyr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingScalyr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingScalyr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 processing_region: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The token to use for authentication (https://www.scalyr.com/keys)
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str project_id: The name of the logfile field sent to Scalyr
        :param _builtins.str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The token to use for authentication (https://www.scalyr.com/keys)
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The name of the logfile field sent to Scalyr
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ServiceComputeLoggingSftp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKnownHosts":
            suggest = "ssh_known_hosts"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingSftp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingSftp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingSftp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 name: _builtins.str,
                 path: _builtins.str,
                 ssh_known_hosts: _builtins.str,
                 user: _builtins.str,
                 compression_codec: Optional[_builtins.str] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 port: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 secret_key: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The SFTP address to stream logs to
        :param _builtins.str name: The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param _builtins.str ssh_known_hosts: A list of host keys for all hosts we can connect to over SFTP
        :param _builtins.str user: The username for the server
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param _builtins.int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param _builtins.int port: The port the SFTP service listens on. (Default: `22`)
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str secret_key: The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "ssh_known_hosts", ssh_known_hosts)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The SFTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> _builtins.str:
        """
        A list of host keys for all hosts we can connect to over SFTP
        """
        return pulumi.get(self, "ssh_known_hosts")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The username for the server
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port the SFTP service listens on. (Default: `22`)
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[_builtins.str]:
        """
        The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingSplunk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processingRegion":
            suggest = "processing_region"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingSplunk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingSplunk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingSplunk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 url: _builtins.str,
                 processing_region: Optional[_builtins.str] = None,
                 tls_ca_cert: Optional[_builtins.str] = None,
                 tls_client_cert: Optional[_builtins.str] = None,
                 tls_client_key: Optional[_builtins.str] = None,
                 tls_hostname: Optional[_builtins.str] = None,
                 use_tls: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The Splunk token to be used for authentication
        :param _builtins.str url: The Splunk URL to stream logs to
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        :param _builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param _builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param _builtins.str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param _builtins.bool use_tls: Whether to use TLS for secure logging. Default: `false`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The Splunk token to be used for authentication
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The Splunk URL to stream logs to
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[_builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[_builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[_builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @_builtins.property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[_builtins.str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @_builtins.property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[_builtins.bool]:
        """
        Whether to use TLS for secure logging. Default: `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceComputeLoggingSumologic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingSumologic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingSumologic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingSumologic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 url: _builtins.str,
                 message_type: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str url: The URL to Sumologic collector endpoint
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL to Sumologic collector endpoint
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")


@pulumi.output_type
class ServiceComputeLoggingSyslog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingSyslog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingSyslog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingSyslog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 name: _builtins.str,
                 message_type: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 tls_ca_cert: Optional[_builtins.str] = None,
                 tls_client_cert: Optional[_builtins.str] = None,
                 tls_client_key: Optional[_builtins.str] = None,
                 tls_hostname: Optional[_builtins.str] = None,
                 token: Optional[_builtins.str] = None,
                 use_tls: Optional[_builtins.bool] = None):
        """
        :param _builtins.str address: A hostname or IPv4 address of the Syslog endpoint
        :param _builtins.str name: A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.int port: The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        :param _builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        :param _builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        :param _builtins.str tls_hostname: Used during the TLS handshake to validate the certificate
        :param _builtins.str token: Whether to prepend each message with a specific token
        :param _builtins.bool use_tls: Whether to use TLS for secure logging. Default `false`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        A hostname or IPv4 address of the Syslog endpoint
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[_builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[_builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        """
        return pulumi.get(self, "tls_client_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[_builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        """
        return pulumi.get(self, "tls_client_key")

    @_builtins.property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[_builtins.str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[_builtins.str]:
        """
        Whether to prepend each message with a specific token
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[_builtins.bool]:
        """
        Whether to use TLS for secure logging. Default `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceComputePackage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceCodeHash":
            suggest = "source_code_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputePackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputePackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputePackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: Optional[_builtins.str] = None,
                 filename: Optional[_builtins.str] = None,
                 source_code_hash: Optional[_builtins.str] = None):
        """
        :param _builtins.str content: The contents of the Wasm deployment package as a base64 encoded string (e.g. could be provided using an input variable or via external data source output variable). Conflicts with `filename`. Exactly one of these two arguments must be specified
        :param _builtins.str filename: The path to the Wasm deployment package within your local filesystem. Conflicts with `content`. Exactly one of these two arguments must be specified
        :param _builtins.str source_code_hash: Used to trigger updates. Must be set to a SHA512 hash of all files (in sorted order) within the package. The usual way to set this is using the get_package_hash data source.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if source_code_hash is not None:
            pulumi.set(__self__, "source_code_hash", source_code_hash)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[_builtins.str]:
        """
        The contents of the Wasm deployment package as a base64 encoded string (e.g. could be provided using an input variable or via external data source output variable). Conflicts with `filename`. Exactly one of these two arguments must be specified
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def filename(self) -> Optional[_builtins.str]:
        """
        The path to the Wasm deployment package within your local filesystem. Conflicts with `content`. Exactly one of these two arguments must be specified
        """
        return pulumi.get(self, "filename")

    @_builtins.property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> Optional[_builtins.str]:
        """
        Used to trigger updates. Must be set to a SHA512 hash of all files (in sorted order) within the package. The usual way to set this is using the get_package_hash data source.
        """
        return pulumi.get(self, "source_code_hash")


@pulumi.output_type
class ServiceComputeProductEnablement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ddosProtection":
            suggest = "ddos_protection"
        elif key == "logExplorerInsights":
            suggest = "log_explorer_insights"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeProductEnablement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeProductEnablement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeProductEnablement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ddos_protection: Optional['outputs.ServiceComputeProductEnablementDdosProtection'] = None,
                 fanout: Optional[_builtins.bool] = None,
                 log_explorer_insights: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 ngwaf: Optional['outputs.ServiceComputeProductEnablementNgwaf'] = None,
                 websockets: Optional[_builtins.bool] = None):
        """
        :param 'ServiceComputeProductEnablementDdosProtectionArgs' ddos_protection: DDoS Protection product
        :param _builtins.bool fanout: Enable Fanout support
        :param _builtins.bool log_explorer_insights: Enable Log Explorer & Insights
        :param _builtins.str name: Used by the provider to identify modified settings (changing this value will force the entire block to be deleted, then recreated)
        :param 'ServiceComputeProductEnablementNgwafArgs' ngwaf: Next-Gen WAF product
        :param _builtins.bool websockets: Enable WebSockets support
        """
        if ddos_protection is not None:
            pulumi.set(__self__, "ddos_protection", ddos_protection)
        if fanout is not None:
            pulumi.set(__self__, "fanout", fanout)
        if log_explorer_insights is not None:
            pulumi.set(__self__, "log_explorer_insights", log_explorer_insights)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ngwaf is not None:
            pulumi.set(__self__, "ngwaf", ngwaf)
        if websockets is not None:
            pulumi.set(__self__, "websockets", websockets)

    @_builtins.property
    @pulumi.getter(name="ddosProtection")
    def ddos_protection(self) -> Optional['outputs.ServiceComputeProductEnablementDdosProtection']:
        """
        DDoS Protection product
        """
        return pulumi.get(self, "ddos_protection")

    @_builtins.property
    @pulumi.getter
    def fanout(self) -> Optional[_builtins.bool]:
        """
        Enable Fanout support
        """
        return pulumi.get(self, "fanout")

    @_builtins.property
    @pulumi.getter(name="logExplorerInsights")
    def log_explorer_insights(self) -> Optional[_builtins.bool]:
        """
        Enable Log Explorer & Insights
        """
        return pulumi.get(self, "log_explorer_insights")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Used by the provider to identify modified settings (changing this value will force the entire block to be deleted, then recreated)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ngwaf(self) -> Optional['outputs.ServiceComputeProductEnablementNgwaf']:
        """
        Next-Gen WAF product
        """
        return pulumi.get(self, "ngwaf")

    @_builtins.property
    @pulumi.getter
    def websockets(self) -> Optional[_builtins.bool]:
        """
        Enable WebSockets support
        """
        return pulumi.get(self, "websockets")


@pulumi.output_type
class ServiceComputeProductEnablementDdosProtection(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 mode: _builtins.str):
        """
        :param _builtins.bool enabled: Enable DDoS Protection support
        :param _builtins.str mode: Operation mode. Can be either `off`, `log`, or `block`.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "mode", mode)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable DDoS Protection support
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        Operation mode. Can be either `off`, `log`, or `block`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class ServiceComputeProductEnablementNgwaf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workspaceId":
            suggest = "workspace_id"
        elif key == "trafficRamp":
            suggest = "traffic_ramp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeProductEnablementNgwaf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeProductEnablementNgwaf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeProductEnablementNgwaf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 workspace_id: _builtins.str,
                 traffic_ramp: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enabled: Enable Next-Gen WAF support
        :param _builtins.str workspace_id: The workspace to link
        :param _builtins.int traffic_ramp: The percentage of traffic to inspect
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if traffic_ramp is not None:
            pulumi.set(__self__, "traffic_ramp", traffic_ramp)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable Next-Gen WAF support
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> _builtins.str:
        """
        The workspace to link
        """
        return pulumi.get(self, "workspace_id")

    @_builtins.property
    @pulumi.getter(name="trafficRamp")
    def traffic_ramp(self) -> Optional[_builtins.int]:
        """
        The percentage of traffic to inspect
        """
        return pulumi.get(self, "traffic_ramp")


@pulumi.output_type
class ServiceComputeResourceLink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "linkId":
            suggest = "link_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeResourceLink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeResourceLink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeResourceLink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 resource_id: _builtins.str,
                 link_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the resource link.
        :param _builtins.str resource_id: The ID of the underlying linked resource.
        :param _builtins.str link_id: An alphanumeric string identifying the resource link.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_id", resource_id)
        if link_id is not None:
            pulumi.set(__self__, "link_id", link_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the resource link.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The ID of the underlying linked resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="linkId")
    def link_id(self) -> Optional[_builtins.str]:
        """
        An alphanumeric string identifying the resource link.
        """
        return pulumi.get(self, "link_id")


@pulumi.output_type
class ServiceVclAcl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aclId":
            suggest = "acl_id"
        elif key == "forceDestroy":
            suggest = "force_destroy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclAcl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclAcl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclAcl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 acl_id: Optional[_builtins.str] = None,
                 force_destroy: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A unique name to identify this ACL. It is important to note that changing this attribute will delete and recreate the ACL, and discard the current items in the ACL
        :param _builtins.str acl_id: The ID of the ACL
        :param _builtins.bool force_destroy: Allow the ACL to be deleted, even if it contains entries. Defaults to false.
        """
        pulumi.set(__self__, "name", name)
        if acl_id is not None:
            pulumi.set(__self__, "acl_id", acl_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this ACL. It is important to note that changing this attribute will delete and recreate the ACL, and discard the current items in the ACL
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[_builtins.str]:
        """
        The ID of the ACL
        """
        return pulumi.get(self, "acl_id")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[_builtins.bool]:
        """
        Allow the ACL to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")


@pulumi.output_type
class ServiceVclBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoLoadbalance":
            suggest = "auto_loadbalance"
        elif key == "betweenBytesTimeout":
            suggest = "between_bytes_timeout"
        elif key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "errorThreshold":
            suggest = "error_threshold"
        elif key == "firstByteTimeout":
            suggest = "first_byte_timeout"
        elif key == "keepaliveTime":
            suggest = "keepalive_time"
        elif key == "maxConn":
            suggest = "max_conn"
        elif key == "maxTlsVersion":
            suggest = "max_tls_version"
        elif key == "minTlsVersion":
            suggest = "min_tls_version"
        elif key == "overrideHost":
            suggest = "override_host"
        elif key == "preferIpv6":
            suggest = "prefer_ipv6"
        elif key == "requestCondition":
            suggest = "request_condition"
        elif key == "shareKey":
            suggest = "share_key"
        elif key == "sslCaCert":
            suggest = "ssl_ca_cert"
        elif key == "sslCertHostname":
            suggest = "ssl_cert_hostname"
        elif key == "sslCheckCert":
            suggest = "ssl_check_cert"
        elif key == "sslCiphers":
            suggest = "ssl_ciphers"
        elif key == "sslClientCert":
            suggest = "ssl_client_cert"
        elif key == "sslClientKey":
            suggest = "ssl_client_key"
        elif key == "sslSniHostname":
            suggest = "ssl_sni_hostname"
        elif key == "useSsl":
            suggest = "use_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 name: _builtins.str,
                 auto_loadbalance: Optional[_builtins.bool] = None,
                 between_bytes_timeout: Optional[_builtins.int] = None,
                 connect_timeout: Optional[_builtins.int] = None,
                 error_threshold: Optional[_builtins.int] = None,
                 first_byte_timeout: Optional[_builtins.int] = None,
                 healthcheck: Optional[_builtins.str] = None,
                 keepalive_time: Optional[_builtins.int] = None,
                 max_conn: Optional[_builtins.int] = None,
                 max_tls_version: Optional[_builtins.str] = None,
                 min_tls_version: Optional[_builtins.str] = None,
                 override_host: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 prefer_ipv6: Optional[_builtins.bool] = None,
                 request_condition: Optional[_builtins.str] = None,
                 share_key: Optional[_builtins.str] = None,
                 shield: Optional[_builtins.str] = None,
                 ssl_ca_cert: Optional[_builtins.str] = None,
                 ssl_cert_hostname: Optional[_builtins.str] = None,
                 ssl_check_cert: Optional[_builtins.bool] = None,
                 ssl_ciphers: Optional[_builtins.str] = None,
                 ssl_client_cert: Optional[_builtins.str] = None,
                 ssl_client_key: Optional[_builtins.str] = None,
                 ssl_sni_hostname: Optional[_builtins.str] = None,
                 use_ssl: Optional[_builtins.bool] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str address: An IPv4, hostname, or IPv6 address for the Backend
        :param _builtins.str name: Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.bool auto_loadbalance: Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `false`
        :param _builtins.int between_bytes_timeout: How long to wait between bytes in milliseconds. Default `10000`
        :param _builtins.int connect_timeout: How long to wait for a timeout in milliseconds. Default `1000`
        :param _builtins.int error_threshold: Number of errors to allow before the Backend is marked as down. Default `0`
        :param _builtins.int first_byte_timeout: How long to wait for the first bytes in milliseconds. Default `15000`
        :param _builtins.str healthcheck: Name of a defined `healthcheck` to assign to this backend
        :param _builtins.int keepalive_time: How long in seconds to keep a persistent connection to the backend between requests.
        :param _builtins.int max_conn: Maximum number of connections for this Backend. Default `200`
        :param _builtins.str max_tls_version: Maximum allowed TLS version on SSL connections to this backend.
        :param _builtins.str min_tls_version: Minimum allowed TLS version on SSL connections to this backend.
        :param _builtins.str override_host: The hostname to override the Host header
        :param _builtins.int port: The port number on which the Backend responds. Default `80`
        :param _builtins.bool prefer_ipv6: Prefer IPv6 connections to origins for hostname backends. Default `false`
        :param _builtins.str request_condition: Name of a condition, which if met, will select this backend during a request.
        :param _builtins.str share_key: Value that when shared across backends will enable those backends to share the same health check.
        :param _builtins.str shield: The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        :param _builtins.str ssl_ca_cert: CA certificate attached to origin.
        :param _builtins.str ssl_cert_hostname: Configure certificate validation. Does not affect SNI at all
        :param _builtins.bool ssl_check_cert: Be strict about checking SSL certs. Default `true`
        :param _builtins.str ssl_ciphers: Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        :param _builtins.str ssl_client_cert: Client certificate attached to origin. Used when connecting to the backend
        :param _builtins.str ssl_client_key: Client key attached to origin. Used when connecting to the backend
        :param _builtins.str ssl_sni_hostname: Configure SNI in the TLS handshake. Does not affect cert validation at all
        :param _builtins.bool use_ssl: Whether or not to use SSL to reach the Backend. Default `false`
        :param _builtins.int weight: The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if auto_loadbalance is not None:
            pulumi.set(__self__, "auto_loadbalance", auto_loadbalance)
        if between_bytes_timeout is not None:
            pulumi.set(__self__, "between_bytes_timeout", between_bytes_timeout)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if first_byte_timeout is not None:
            pulumi.set(__self__, "first_byte_timeout", first_byte_timeout)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if keepalive_time is not None:
            pulumi.set(__self__, "keepalive_time", keepalive_time)
        if max_conn is not None:
            pulumi.set(__self__, "max_conn", max_conn)
        if max_tls_version is not None:
            pulumi.set(__self__, "max_tls_version", max_tls_version)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if override_host is not None:
            pulumi.set(__self__, "override_host", override_host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if prefer_ipv6 is not None:
            pulumi.set(__self__, "prefer_ipv6", prefer_ipv6)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if share_key is not None:
            pulumi.set(__self__, "share_key", share_key)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if ssl_ca_cert is not None:
            pulumi.set(__self__, "ssl_ca_cert", ssl_ca_cert)
        if ssl_cert_hostname is not None:
            pulumi.set(__self__, "ssl_cert_hostname", ssl_cert_hostname)
        if ssl_check_cert is not None:
            pulumi.set(__self__, "ssl_check_cert", ssl_check_cert)
        if ssl_ciphers is not None:
            pulumi.set(__self__, "ssl_ciphers", ssl_ciphers)
        if ssl_client_cert is not None:
            pulumi.set(__self__, "ssl_client_cert", ssl_client_cert)
        if ssl_client_key is not None:
            pulumi.set(__self__, "ssl_client_key", ssl_client_key)
        if ssl_sni_hostname is not None:
            pulumi.set(__self__, "ssl_sni_hostname", ssl_sni_hostname)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        An IPv4, hostname, or IPv6 address for the Backend
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="autoLoadbalance")
    def auto_loadbalance(self) -> Optional[_builtins.bool]:
        """
        Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `false`
        """
        return pulumi.get(self, "auto_loadbalance")

    @_builtins.property
    @pulumi.getter(name="betweenBytesTimeout")
    def between_bytes_timeout(self) -> Optional[_builtins.int]:
        """
        How long to wait between bytes in milliseconds. Default `10000`
        """
        return pulumi.get(self, "between_bytes_timeout")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[_builtins.int]:
        """
        How long to wait for a timeout in milliseconds. Default `1000`
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[_builtins.int]:
        """
        Number of errors to allow before the Backend is marked as down. Default `0`
        """
        return pulumi.get(self, "error_threshold")

    @_builtins.property
    @pulumi.getter(name="firstByteTimeout")
    def first_byte_timeout(self) -> Optional[_builtins.int]:
        """
        How long to wait for the first bytes in milliseconds. Default `15000`
        """
        return pulumi.get(self, "first_byte_timeout")

    @_builtins.property
    @pulumi.getter
    def healthcheck(self) -> Optional[_builtins.str]:
        """
        Name of a defined `healthcheck` to assign to this backend
        """
        return pulumi.get(self, "healthcheck")

    @_builtins.property
    @pulumi.getter(name="keepaliveTime")
    def keepalive_time(self) -> Optional[_builtins.int]:
        """
        How long in seconds to keep a persistent connection to the backend between requests.
        """
        return pulumi.get(self, "keepalive_time")

    @_builtins.property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> Optional[_builtins.int]:
        """
        Maximum number of connections for this Backend. Default `200`
        """
        return pulumi.get(self, "max_conn")

    @_builtins.property
    @pulumi.getter(name="maxTlsVersion")
    def max_tls_version(self) -> Optional[_builtins.str]:
        """
        Maximum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "max_tls_version")

    @_builtins.property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[_builtins.str]:
        """
        Minimum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "min_tls_version")

    @_builtins.property
    @pulumi.getter(name="overrideHost")
    def override_host(self) -> Optional[_builtins.str]:
        """
        The hostname to override the Host header
        """
        return pulumi.get(self, "override_host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port number on which the Backend responds. Default `80`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="preferIpv6")
    def prefer_ipv6(self) -> Optional[_builtins.bool]:
        """
        Prefer IPv6 connections to origins for hostname backends. Default `false`
        """
        return pulumi.get(self, "prefer_ipv6")

    @_builtins.property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[_builtins.str]:
        """
        Name of a condition, which if met, will select this backend during a request.
        """
        return pulumi.get(self, "request_condition")

    @_builtins.property
    @pulumi.getter(name="shareKey")
    def share_key(self) -> Optional[_builtins.str]:
        """
        Value that when shared across backends will enable those backends to share the same health check.
        """
        return pulumi.get(self, "share_key")

    @_builtins.property
    @pulumi.getter
    def shield(self) -> Optional[_builtins.str]:
        """
        The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        """
        return pulumi.get(self, "shield")

    @_builtins.property
    @pulumi.getter(name="sslCaCert")
    def ssl_ca_cert(self) -> Optional[_builtins.str]:
        """
        CA certificate attached to origin.
        """
        return pulumi.get(self, "ssl_ca_cert")

    @_builtins.property
    @pulumi.getter(name="sslCertHostname")
    def ssl_cert_hostname(self) -> Optional[_builtins.str]:
        """
        Configure certificate validation. Does not affect SNI at all
        """
        return pulumi.get(self, "ssl_cert_hostname")

    @_builtins.property
    @pulumi.getter(name="sslCheckCert")
    def ssl_check_cert(self) -> Optional[_builtins.bool]:
        """
        Be strict about checking SSL certs. Default `true`
        """
        return pulumi.get(self, "ssl_check_cert")

    @_builtins.property
    @pulumi.getter(name="sslCiphers")
    def ssl_ciphers(self) -> Optional[_builtins.str]:
        """
        Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        """
        return pulumi.get(self, "ssl_ciphers")

    @_builtins.property
    @pulumi.getter(name="sslClientCert")
    def ssl_client_cert(self) -> Optional[_builtins.str]:
        """
        Client certificate attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_cert")

    @_builtins.property
    @pulumi.getter(name="sslClientKey")
    def ssl_client_key(self) -> Optional[_builtins.str]:
        """
        Client key attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_key")

    @_builtins.property
    @pulumi.getter(name="sslSniHostname")
    def ssl_sni_hostname(self) -> Optional[_builtins.str]:
        """
        Configure SNI in the TLS handshake. Does not affect cert validation at all
        """
        return pulumi.get(self, "ssl_sni_hostname")

    @_builtins.property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[_builtins.bool]:
        """
        Whether or not to use SSL to reach the Backend. Default `false`
        """
        return pulumi.get(self, "use_ssl")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServiceVclCacheSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "staleTtl":
            suggest = "stale_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclCacheSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclCacheSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclCacheSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 action: Optional[_builtins.str] = None,
                 cache_condition: Optional[_builtins.str] = None,
                 stale_ttl: Optional[_builtins.int] = None,
                 ttl: Optional[_builtins.int] = None):
        """
        :param _builtins.str name: Unique name for this Cache Setting. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str action: One of cache, pass, or restart, as defined on Fastly's documentation under "[Caching action descriptions](https://docs.fastly.com/en/guides/controlling-caching#caching-action-descriptions)"
        :param _builtins.str cache_condition: Name of already defined `condition` used to test whether this settings object should be used. This `condition` must be of type `CACHE`
        :param _builtins.int stale_ttl: Max "Time To Live" for stale (unreachable) objects
        :param _builtins.int ttl: The Time-To-Live (TTL) for the object
        """
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if stale_ttl is not None:
            pulumi.set(__self__, "stale_ttl", stale_ttl)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Unique name for this Cache Setting. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        One of cache, pass, or restart, as defined on Fastly's documentation under "[Caching action descriptions](https://docs.fastly.com/en/guides/controlling-caching#caching-action-descriptions)"
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[_builtins.str]:
        """
        Name of already defined `condition` used to test whether this settings object should be used. This `condition` must be of type `CACHE`
        """
        return pulumi.get(self, "cache_condition")

    @_builtins.property
    @pulumi.getter(name="staleTtl")
    def stale_ttl(self) -> Optional[_builtins.int]:
        """
        Max "Time To Live" for stale (unreachable) objects
        """
        return pulumi.get(self, "stale_ttl")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.int]:
        """
        The Time-To-Live (TTL) for the object
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class ServiceVclCondition(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 statement: _builtins.str,
                 type: _builtins.str,
                 priority: Optional[_builtins.int] = None):
        """
        :param _builtins.str name: The unique name for the condition. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str statement: The statement used to determine if the condition is met
        :param _builtins.str type: Type of condition, either `REQUEST` (req), `RESPONSE` (req, resp), or `CACHE` (req, beresp)
        :param _builtins.int priority: A number used to determine the order in which multiple conditions execute. Lower numbers execute first. Default `10`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statement", statement)
        pulumi.set(__self__, "type", type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name for the condition. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def statement(self) -> _builtins.str:
        """
        The statement used to determine if the condition is met
        """
        return pulumi.get(self, "statement")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of condition, either `REQUEST` (req), `RESPONSE` (req, resp), or `CACHE` (req, beresp)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        A number used to determine the order in which multiple conditions execute. Lower numbers execute first. Default `10`
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class ServiceVclDictionary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dictionaryId":
            suggest = "dictionary_id"
        elif key == "forceDestroy":
            suggest = "force_destroy"
        elif key == "writeOnly":
            suggest = "write_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclDictionary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclDictionary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclDictionary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 dictionary_id: Optional[_builtins.str] = None,
                 force_destroy: Optional[_builtins.bool] = None,
                 write_only: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        :param _builtins.str dictionary_id: The ID of the dictionary
        :param _builtins.bool force_destroy: Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        pulumi.set(__self__, "name", name)
        if dictionary_id is not None:
            pulumi.set(__self__, "dictionary_id", dictionary_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if write_only is not None:
            pulumi.set(__self__, "write_only", write_only)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[_builtins.str]:
        """
        The ID of the dictionary
        """
        return pulumi.get(self, "dictionary_id")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[_builtins.bool]:
        """
        Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "write_only")


@pulumi.output_type
class ServiceVclDirector(dict):
    def __init__(__self__, *,
                 backends: Sequence[_builtins.str],
                 name: _builtins.str,
                 comment: Optional[_builtins.str] = None,
                 quorum: Optional[_builtins.int] = None,
                 retries: Optional[_builtins.int] = None,
                 shield: Optional[_builtins.str] = None,
                 type: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] backends: Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        :param _builtins.str name: Unique name for this Director. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str comment: An optional comment about the Director
        :param _builtins.int quorum: Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`
        :param _builtins.int retries: How many backends to search if it fails. Default `5`
        :param _builtins.str shield: Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response
        :param _builtins.int type: Type of load balance group to use. Integer, 1 to 4. Values: `1` (random), `3` (hash), `4` (client). Default `1`
        """
        pulumi.set(__self__, "backends", backends)
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if quorum is not None:
            pulumi.set(__self__, "quorum", quorum)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Sequence[_builtins.str]:
        """
        Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        """
        return pulumi.get(self, "backends")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Unique name for this Director. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[_builtins.str]:
        """
        An optional comment about the Director
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def quorum(self) -> Optional[_builtins.int]:
        """
        Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`
        """
        return pulumi.get(self, "quorum")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[_builtins.int]:
        """
        How many backends to search if it fails. Default `5`
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter
    def shield(self) -> Optional[_builtins.str]:
        """
        Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response
        """
        return pulumi.get(self, "shield")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.int]:
        """
        Type of load balance group to use. Integer, 1 to 4. Values: `1` (random), `3` (hash), `4` (client). Default `1`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceVclDomain(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 comment: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        :param _builtins.str comment: An optional comment about the Domain.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[_builtins.str]:
        """
        An optional comment about the Domain.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class ServiceVclDynamicsnippet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snippetId":
            suggest = "snippet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclDynamicsnippet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclDynamicsnippet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclDynamicsnippet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 content: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None,
                 snippet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        :param _builtins.str content: The VCL code that specifies exactly what the snippet does
        :param _builtins.int priority: Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        :param _builtins.str snippet_id: The ID of the dynamic snippet
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if snippet_id is not None:
            pulumi.set(__self__, "snippet_id", snippet_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[_builtins.str]:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="snippetId")
    def snippet_id(self) -> Optional[_builtins.str]:
        """
        The ID of the dynamic snippet
        """
        return pulumi.get(self, "snippet_id")


@pulumi.output_type
class ServiceVclGzip(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "contentTypes":
            suggest = "content_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclGzip. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclGzip.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclGzip.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 cache_condition: Optional[_builtins.str] = None,
                 content_types: Optional[Sequence[_builtins.str]] = None,
                 extensions: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str name: A name to refer to this gzip condition. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str cache_condition: Name of already defined `condition` controlling when this gzip configuration applies. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param Sequence[_builtins.str] content_types: The content-type for each type of content you wish to have dynamically gzip'ed. Example: `["text/html", "text/css"]`
        :param Sequence[_builtins.str] extensions: File extensions for each file type to dynamically gzip. Example: `["css", "js"]`
        """
        pulumi.set(__self__, "name", name)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if content_types is not None:
            pulumi.set(__self__, "content_types", content_types)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A name to refer to this gzip condition. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[_builtins.str]:
        """
        Name of already defined `condition` controlling when this gzip configuration applies. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "cache_condition")

    @_builtins.property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        The content-type for each type of content you wish to have dynamically gzip'ed. Example: `["text/html", "text/css"]`
        """
        return pulumi.get(self, "content_types")

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence[_builtins.str]]:
        """
        File extensions for each file type to dynamically gzip. Example: `["css", "js"]`
        """
        return pulumi.get(self, "extensions")


@pulumi.output_type
class ServiceVclHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "ignoreIfSet":
            suggest = "ignore_if_set"
        elif key == "requestCondition":
            suggest = "request_condition"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 destination: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 cache_condition: Optional[_builtins.str] = None,
                 ignore_if_set: Optional[_builtins.bool] = None,
                 priority: Optional[_builtins.int] = None,
                 regex: Optional[_builtins.str] = None,
                 request_condition: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 source: Optional[_builtins.str] = None,
                 substitution: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: The Header manipulation action to take; must be one of `set`, `append`, `delete`, `regex`, or `regex_repeat`
        :param _builtins.str destination: The name of the header that is going to be affected by the Action
        :param _builtins.str name: Unique name for this header attribute. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str type: The Request type on which to apply the selected Action; must be one of `request`, `fetch`, `cache` or `response`
        :param _builtins.str cache_condition: Name of already defined `condition` to apply. This `condition` must be of type `CACHE`
        :param _builtins.bool ignore_if_set: Don't add the header if it is already. (Only applies to `set` action.). Default `false`
        :param _builtins.int priority: Lower priorities execute first. Default: `100`
        :param _builtins.str regex: Regular expression to use (Only applies to `regex` and `regex_repeat` actions.)
        :param _builtins.str request_condition: Name of already defined `condition` to apply. This `condition` must be of type `REQUEST`
        :param _builtins.str response_condition: Name of already defined `condition` to apply. This `condition` must be of type `RESPONSE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param _builtins.str source: Variable to be used as a source for the header content (Does not apply to `delete` action.)
        :param _builtins.str substitution: Value to substitute in place of regular expression. (Only applies to `regex` and `regex_repeat`.)
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if ignore_if_set is not None:
            pulumi.set(__self__, "ignore_if_set", ignore_if_set)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if substitution is not None:
            pulumi.set(__self__, "substitution", substitution)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The Header manipulation action to take; must be one of `set`, `append`, `delete`, `regex`, or `regex_repeat`
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        The name of the header that is going to be affected by the Action
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Unique name for this header attribute. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Request type on which to apply the selected Action; must be one of `request`, `fetch`, `cache` or `response`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[_builtins.str]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `CACHE`
        """
        return pulumi.get(self, "cache_condition")

    @_builtins.property
    @pulumi.getter(name="ignoreIfSet")
    def ignore_if_set(self) -> Optional[_builtins.bool]:
        """
        Don't add the header if it is already. (Only applies to `set` action.). Default `false`
        """
        return pulumi.get(self, "ignore_if_set")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        Lower priorities execute first. Default: `100`
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.str]:
        """
        Regular expression to use (Only applies to `regex` and `regex_repeat` actions.)
        """
        return pulumi.get(self, "regex")

    @_builtins.property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[_builtins.str]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `REQUEST`
        """
        return pulumi.get(self, "request_condition")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `RESPONSE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        Variable to be used as a source for the header content (Does not apply to `delete` action.)
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def substitution(self) -> Optional[_builtins.str]:
        """
        Value to substitute in place of regular expression. (Only applies to `regex` and `regex_repeat`.)
        """
        return pulumi.get(self, "substitution")


@pulumi.output_type
class ServiceVclHealthcheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkInterval":
            suggest = "check_interval"
        elif key == "expectedResponse":
            suggest = "expected_response"
        elif key == "httpVersion":
            suggest = "http_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclHealthcheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclHealthcheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclHealthcheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: _builtins.str,
                 name: _builtins.str,
                 path: _builtins.str,
                 check_interval: Optional[_builtins.int] = None,
                 expected_response: Optional[_builtins.int] = None,
                 headers: Optional[Sequence[_builtins.str]] = None,
                 http_version: Optional[_builtins.str] = None,
                 initial: Optional[_builtins.int] = None,
                 method: Optional[_builtins.str] = None,
                 threshold: Optional[_builtins.int] = None,
                 timeout: Optional[_builtins.int] = None,
                 window: Optional[_builtins.int] = None):
        """
        :param _builtins.str host: The Host header to send for this Healthcheck
        :param _builtins.str name: A unique name to identify this Healthcheck. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str path: The path to check
        :param _builtins.int check_interval: How often to run the Healthcheck in milliseconds. Default `5000`
        :param _builtins.int expected_response: The status code expected from the host. Default `200`
        :param Sequence[_builtins.str] headers: Custom health check HTTP headers (e.g. if your health check requires an API key to be provided).
        :param _builtins.str http_version: Whether to use version 1.0 or 1.1 HTTP. Default `1.1`
        :param _builtins.int initial: When loading a config, the initial number of probes to be seen as OK. Default `3`
        :param _builtins.str method: Which HTTP method to use. Default `HEAD`
        :param _builtins.int threshold: How many Healthchecks must succeed to be considered healthy. Default `3`
        :param _builtins.int timeout: Timeout in milliseconds. Default `5000`
        :param _builtins.int window: The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if expected_response is not None:
            pulumi.set(__self__, "expected_response", expected_response)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if initial is not None:
            pulumi.set(__self__, "initial", initial)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The Host header to send for this Healthcheck
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this Healthcheck. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path to check
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[_builtins.int]:
        """
        How often to run the Healthcheck in milliseconds. Default `5000`
        """
        return pulumi.get(self, "check_interval")

    @_builtins.property
    @pulumi.getter(name="expectedResponse")
    def expected_response(self) -> Optional[_builtins.int]:
        """
        The status code expected from the host. Default `200`
        """
        return pulumi.get(self, "expected_response")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Custom health check HTTP headers (e.g. if your health check requires an API key to be provided).
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[_builtins.str]:
        """
        Whether to use version 1.0 or 1.1 HTTP. Default `1.1`
        """
        return pulumi.get(self, "http_version")

    @_builtins.property
    @pulumi.getter
    def initial(self) -> Optional[_builtins.int]:
        """
        When loading a config, the initial number of probes to be seen as OK. Default `3`
        """
        return pulumi.get(self, "initial")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        Which HTTP method to use. Default `HEAD`
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[_builtins.int]:
        """
        How many Healthchecks must succeed to be considered healthy. Default `3`
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        Timeout in milliseconds. Default `5000`
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def window(self) -> Optional[_builtins.int]:
        """
        The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`
        """
        return pulumi.get(self, "window")


@pulumi.output_type
class ServiceVclImageOptimizerDefaultSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowVideo":
            suggest = "allow_video"
        elif key == "jpegQuality":
            suggest = "jpeg_quality"
        elif key == "jpegType":
            suggest = "jpeg_type"
        elif key == "resizeFilter":
            suggest = "resize_filter"
        elif key == "webpQuality":
            suggest = "webp_quality"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclImageOptimizerDefaultSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclImageOptimizerDefaultSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclImageOptimizerDefaultSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_video: Optional[_builtins.bool] = None,
                 jpeg_quality: Optional[_builtins.int] = None,
                 jpeg_type: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 resize_filter: Optional[_builtins.str] = None,
                 upscale: Optional[_builtins.bool] = None,
                 webp: Optional[_builtins.bool] = None,
                 webp_quality: Optional[_builtins.int] = None):
        """
        :param _builtins.bool allow_video: Enables GIF to MP4 transformations on this service.
        :param _builtins.int jpeg_quality: The default quality to use with JPEG output. This can be overridden with the "quality" parameter on specific image optimizer requests.
        :param _builtins.str jpeg_type: The default type of JPEG output to use. This can be overridden with "format=bjpeg" and "format=pjpeg" on specific image optimizer requests. Valid values are `auto`, `baseline` and `progressive`.
               	- auto: Match the input JPEG type, or baseline if transforming from a non-JPEG input.
               	- baseline: Output baseline JPEG images
               	- progressive: Output progressive JPEG images
        :param _builtins.str name: Used by the provider to identify modified settings. Changing this value will force the entire block to be deleted, then recreated.
        :param _builtins.str resize_filter: The type of filter to use while resizing an image. Valid values are `lanczos3`, `lanczos2`, `bicubic`, `bilinear` and `nearest`.
               	- lanczos3: A Lanczos filter with a kernel size of 3. Lanczos filters can detect edges and linear features within an image, providing the best possible reconstruction.
               	- lanczos2: A Lanczos filter with a kernel size of 2.
               	- bicubic: A filter using an average of a 4x4 environment of pixels, weighing the innermost pixels higher.
               	- bilinear: A filter using an average of a 2x2 environment of pixels.
               	- nearest: A filter using the value of nearby translated pixel values. Preserves hard edges.
        :param _builtins.bool upscale: Whether or not we should allow output images to render at sizes larger than input.
        :param _builtins.bool webp: Controls whether or not to default to WebP output when the client supports it. This is equivalent to adding "auto=webp" to all image optimizer requests.
        :param _builtins.int webp_quality: The default quality to use with WebP output. This can be overridden with the second option in the "quality" URL parameter on specific image optimizer requests.
        """
        if allow_video is not None:
            pulumi.set(__self__, "allow_video", allow_video)
        if jpeg_quality is not None:
            pulumi.set(__self__, "jpeg_quality", jpeg_quality)
        if jpeg_type is not None:
            pulumi.set(__self__, "jpeg_type", jpeg_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resize_filter is not None:
            pulumi.set(__self__, "resize_filter", resize_filter)
        if upscale is not None:
            pulumi.set(__self__, "upscale", upscale)
        if webp is not None:
            pulumi.set(__self__, "webp", webp)
        if webp_quality is not None:
            pulumi.set(__self__, "webp_quality", webp_quality)

    @_builtins.property
    @pulumi.getter(name="allowVideo")
    def allow_video(self) -> Optional[_builtins.bool]:
        """
        Enables GIF to MP4 transformations on this service.
        """
        return pulumi.get(self, "allow_video")

    @_builtins.property
    @pulumi.getter(name="jpegQuality")
    def jpeg_quality(self) -> Optional[_builtins.int]:
        """
        The default quality to use with JPEG output. This can be overridden with the "quality" parameter on specific image optimizer requests.
        """
        return pulumi.get(self, "jpeg_quality")

    @_builtins.property
    @pulumi.getter(name="jpegType")
    def jpeg_type(self) -> Optional[_builtins.str]:
        """
        The default type of JPEG output to use. This can be overridden with "format=bjpeg" and "format=pjpeg" on specific image optimizer requests. Valid values are `auto`, `baseline` and `progressive`.
        	- auto: Match the input JPEG type, or baseline if transforming from a non-JPEG input.
        	- baseline: Output baseline JPEG images
        	- progressive: Output progressive JPEG images
        """
        return pulumi.get(self, "jpeg_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Used by the provider to identify modified settings. Changing this value will force the entire block to be deleted, then recreated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resizeFilter")
    def resize_filter(self) -> Optional[_builtins.str]:
        """
        The type of filter to use while resizing an image. Valid values are `lanczos3`, `lanczos2`, `bicubic`, `bilinear` and `nearest`.
        	- lanczos3: A Lanczos filter with a kernel size of 3. Lanczos filters can detect edges and linear features within an image, providing the best possible reconstruction.
        	- lanczos2: A Lanczos filter with a kernel size of 2.
        	- bicubic: A filter using an average of a 4x4 environment of pixels, weighing the innermost pixels higher.
        	- bilinear: A filter using an average of a 2x2 environment of pixels.
        	- nearest: A filter using the value of nearby translated pixel values. Preserves hard edges.
        """
        return pulumi.get(self, "resize_filter")

    @_builtins.property
    @pulumi.getter
    def upscale(self) -> Optional[_builtins.bool]:
        """
        Whether or not we should allow output images to render at sizes larger than input.
        """
        return pulumi.get(self, "upscale")

    @_builtins.property
    @pulumi.getter
    def webp(self) -> Optional[_builtins.bool]:
        """
        Controls whether or not to default to WebP output when the client supports it. This is equivalent to adding "auto=webp" to all image optimizer requests.
        """
        return pulumi.get(self, "webp")

    @_builtins.property
    @pulumi.getter(name="webpQuality")
    def webp_quality(self) -> Optional[_builtins.int]:
        """
        The default quality to use with WebP output. This can be overridden with the second option in the "quality" URL parameter on specific image optimizer requests.
        """
        return pulumi.get(self, "webp_quality")


@pulumi.output_type
class ServiceVclLoggingBigquery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingBigquery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingBigquery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingBigquery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: _builtins.str,
                 email: _builtins.str,
                 name: _builtins.str,
                 project_id: _builtins.str,
                 secret_key: _builtins.str,
                 table: _builtins.str,
                 account_name: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 template: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataset: The ID of your BigQuery dataset
        :param _builtins.str email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        :param _builtins.str name: A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str project_id: The ID of your GCP project
        :param _builtins.str secret_key: The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        :param _builtins.str table: The ID of your BigQuery table
        :param _builtins.str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param _builtins.str format: The logging format desired.
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str response_condition: Name of a condition to apply this logging.
        :param _builtins.str template: BigQuery table name suffix template
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "table", table)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> _builtins.str:
        """
        The ID of your BigQuery dataset
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of your GCP project
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> _builtins.str:
        """
        The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter
    def table(self) -> _builtins.str:
        """
        The ID of your BigQuery table
        """
        return pulumi.get(self, "table")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[_builtins.str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        The logging format desired.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        Name of a condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[_builtins.str]:
        """
        BigQuery table name suffix template
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class ServiceVclLoggingBlobstorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "sasToken":
            suggest = "sas_token"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingBlobstorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingBlobstorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingBlobstorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: _builtins.str,
                 container: _builtins.str,
                 name: _builtins.str,
                 sas_token: _builtins.str,
                 compression_codec: Optional[_builtins.str] = None,
                 file_max_bytes: Optional[_builtins.int] = None,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str account_name: The unique Azure Blob Storage namespace in which your data objects are stored
        :param _builtins.str container: The name of the Azure Blob Storage container in which to store logs
        :param _builtins.str name: A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str sas_token: The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str path: The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        :param _builtins.int period: How frequently the logs should be transferred in seconds. Default `3600`
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str response_condition: The name of the condition to apply
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sas_token", sas_token)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if file_max_bytes is not None:
            pulumi.set(__self__, "file_max_bytes", file_max_bytes)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        The unique Azure Blob Storage namespace in which your data objects are stored
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter
    def container(self) -> _builtins.str:
        """
        The name of the Azure Blob Storage container in which to store logs
        """
        return pulumi.get(self, "container")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> _builtins.str:
        """
        The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        """
        return pulumi.get(self, "sas_token")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[_builtins.int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently the logs should be transferred in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingCloudfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingCloudfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingCloudfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingCloudfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: _builtins.str,
                 bucket_name: _builtins.str,
                 name: _builtins.str,
                 user: _builtins.str,
                 compression_codec: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_key: Your Cloud File account access key
        :param _builtins.str bucket_name: The name of your Cloud Files container
        :param _builtins.str name: The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str user: The username for your Cloud Files account
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.str format: Apache style log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str path: The path to upload logs to
        :param _builtins.int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        :param _builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> _builtins.str:
        """
        Your Cloud File account access key
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The name of your Cloud Files container
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The username for your Cloud Files account
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingDatadog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingDatadog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingDatadog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingDatadog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The API key from your Datadog account
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        :param _builtins.str response_condition: The name of the condition to apply.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The API key from your Datadog account
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingDigitalocean(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingDigitalocean. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingDigitalocean.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingDigitalocean.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: _builtins.str,
                 bucket_name: _builtins.str,
                 name: _builtins.str,
                 secret_key: _builtins.str,
                 compression_codec: Optional[_builtins.str] = None,
                 domain: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_key: Your DigitalOcean Spaces account access key
        :param _builtins.str bucket_name: The name of the DigitalOcean Space
        :param _builtins.str name: The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str secret_key: Your DigitalOcean Spaces account secret key
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.str domain: The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        :param _builtins.str format: Apache style log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str path: The path to upload logs to
        :param _builtins.int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> _builtins.str:
        """
        Your DigitalOcean Spaces account access key
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The name of the DigitalOcean Space
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> _builtins.str:
        """
        Your DigitalOcean Spaces account secret key
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingElasticsearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingElasticsearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingElasticsearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingElasticsearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index: _builtins.str,
                 name: _builtins.str,
                 url: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 pipeline: Optional[_builtins.str] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 request_max_bytes: Optional[_builtins.int] = None,
                 request_max_entries: Optional[_builtins.int] = None,
                 response_condition: Optional[_builtins.str] = None,
                 tls_ca_cert: Optional[_builtins.str] = None,
                 tls_client_cert: Optional[_builtins.str] = None,
                 tls_client_key: Optional[_builtins.str] = None,
                 tls_hostname: Optional[_builtins.str] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.str index: The name of the Elasticsearch index to send documents (logs) to
        :param _builtins.str name: The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str url: The Elasticsearch URL to stream logs to
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param _builtins.str password: BasicAuth password for Elasticsearch
        :param _builtins.str pipeline: The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.int request_max_bytes: The maximum number of logs sent in one request. Defaults to `0` for unbounded
        :param _builtins.int request_max_entries: The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        :param _builtins.str response_condition: The name of the condition to apply
        :param _builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param _builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param _builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param _builtins.str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        :param _builtins.str user: BasicAuth username for Elasticsearch
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def index(self) -> _builtins.str:
        """
        The name of the Elasticsearch index to send documents (logs) to
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The Elasticsearch URL to stream logs to
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        BasicAuth password for Elasticsearch
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def pipeline(self) -> Optional[_builtins.str]:
        """
        The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        """
        return pulumi.get(self, "pipeline")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[_builtins.int]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @_builtins.property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[_builtins.int]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_entries")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[_builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[_builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[_builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @_builtins.property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[_builtins.str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        BasicAuth username for Elasticsearch
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceVclLoggingFtp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingFtp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingFtp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingFtp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 name: _builtins.str,
                 password: _builtins.str,
                 path: _builtins.str,
                 user: _builtins.str,
                 compression_codec: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The FTP address to stream logs to
        :param _builtins.str name: The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str password: The password for the server (for anonymous use an email address)
        :param _builtins.str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param _builtins.str user: The username for the server (can be `anonymous`)
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.int period: How frequently the logs should be transferred, in seconds (Default `3600`)
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.int port: The port number. Default: `21`
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str response_condition: The name of the condition to apply.
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The FTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password for the server (for anonymous use an email address)
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The username for the server (can be `anonymous`)
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently the logs should be transferred, in seconds (Default `3600`)
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port number. Default: `21`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingGc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingGc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingGc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingGc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 name: _builtins.str,
                 account_name: Optional[_builtins.str] = None,
                 compression_codec: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 secret_key: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket_name: The name of the bucket in which to store the logs
        :param _builtins.str name: A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param _builtins.int period: How frequently the logs should be transferred, in seconds (Default 3600)
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str project_id: The ID of your Google Cloud Platform project
        :param _builtins.str response_condition: Name of a condition to apply this logging.
        :param _builtins.str secret_key: The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        :param _builtins.str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[_builtins.str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently the logs should be transferred, in seconds (Default 3600)
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        Name of a condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[_builtins.str]:
        """
        The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceVclLoggingGooglepubsub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingGooglepubsub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingGooglepubsub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingGooglepubsub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 project_id: _builtins.str,
                 secret_key: _builtins.str,
                 topic: _builtins.str,
                 user: _builtins.str,
                 account_name: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str project_id: The ID of your Google Cloud Platform project
        :param _builtins.str secret_key: Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        :param _builtins.str topic: The Google Cloud Pub/Sub topic to which logs will be published
        :param _builtins.str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        :param _builtins.str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param _builtins.str format: Apache style log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "topic", topic)
        pulumi.set(__self__, "user", user)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> _builtins.str:
        """
        Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        """
        The Google Cloud Pub/Sub topic to which logs will be published
        """
        return pulumi.get(self, "topic")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[_builtins.str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingGrafanacloudlog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingGrafanacloudlog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingGrafanacloudlog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingGrafanacloudlog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index: _builtins.str,
                 name: _builtins.str,
                 token: _builtins.str,
                 url: _builtins.str,
                 user: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str index: The stream identifier as a JSON string
        :param _builtins.str name: The unique name of the GrafanaCloudLogs logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The Access Policy Token key for your GrafanaCloudLogs account
        :param _builtins.str url: The URL to stream logs to
        :param _builtins.str user: The Grafana User ID
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str response_condition: The name of the condition to apply.
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @_builtins.property
    @pulumi.getter
    def index(self) -> _builtins.str:
        """
        The stream identifier as a JSON string
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the GrafanaCloudLogs logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The Access Policy Token key for your GrafanaCloudLogs account
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The Grafana User ID
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingHerokus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingHerokus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingHerokus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingHerokus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 url: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        :param _builtins.str url: The URL to stream logs to
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingHoneycomb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingHoneycomb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingHoneycomb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingHoneycomb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: _builtins.str,
                 name: _builtins.str,
                 token: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataset: The Honeycomb Dataset you want to log to
        :param _builtins.str name: The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The Write Key from the Account page of your Honeycomb account
        :param _builtins.str format: Apache style log formatting. Your log must produce valid JSON that Honeycomb can ingest.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> _builtins.str:
        """
        The Honeycomb Dataset you want to log to
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The Write Key from the Account page of your Honeycomb account
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache style log formatting. Your log must produce valid JSON that Honeycomb can ingest.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"
        elif key == "jsonFormat":
            suggest = "json_format"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 url: _builtins.str,
                 content_type: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 header_name: Optional[_builtins.str] = None,
                 header_value: Optional[_builtins.str] = None,
                 json_format: Optional[_builtins.str] = None,
                 message_type: Optional[_builtins.str] = None,
                 method: Optional[_builtins.str] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 request_max_bytes: Optional[_builtins.int] = None,
                 request_max_entries: Optional[_builtins.int] = None,
                 response_condition: Optional[_builtins.str] = None,
                 tls_ca_cert: Optional[_builtins.str] = None,
                 tls_client_cert: Optional[_builtins.str] = None,
                 tls_client_key: Optional[_builtins.str] = None,
                 tls_hostname: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str url: URL that log data will be sent to. Must use the https protocol
        :param _builtins.str content_type: Value of the `Content-Type` header sent with the request
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param _builtins.str header_name: Custom header sent with the request
        :param _builtins.str header_value: Value of the custom header sent with the request
        :param _builtins.str json_format: Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.int request_max_bytes: The maximum number of bytes sent in one request
        :param _builtins.int request_max_entries: The maximum number of logs sent in one request
        :param _builtins.str response_condition: The name of the condition to apply
        :param _builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param _builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param _builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param _builtins.str tls_hostname: Used during the TLS handshake to validate the certificate
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)
        if json_format is not None:
            pulumi.set(__self__, "json_format", json_format)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL that log data will be sent to. Must use the https protocol
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[_builtins.str]:
        """
        Value of the `Content-Type` header sent with the request
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[_builtins.str]:
        """
        Custom header sent with the request
        """
        return pulumi.get(self, "header_name")

    @_builtins.property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[_builtins.str]:
        """
        Value of the custom header sent with the request
        """
        return pulumi.get(self, "header_value")

    @_builtins.property
    @pulumi.getter(name="jsonFormat")
    def json_format(self) -> Optional[_builtins.str]:
        """
        Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        """
        return pulumi.get(self, "json_format")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[_builtins.int]:
        """
        The maximum number of bytes sent in one request
        """
        return pulumi.get(self, "request_max_bytes")

    @_builtins.property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[_builtins.int]:
        """
        The maximum number of logs sent in one request
        """
        return pulumi.get(self, "request_max_entries")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[_builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[_builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[_builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @_builtins.property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[_builtins.str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")


@pulumi.output_type
class ServiceVclLoggingKafka(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMethod":
            suggest = "auth_method"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "parseLogKeyvals":
            suggest = "parse_log_keyvals"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requiredAcks":
            suggest = "required_acks"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingKafka. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingKafka.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingKafka.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 brokers: _builtins.str,
                 name: _builtins.str,
                 topic: _builtins.str,
                 auth_method: Optional[_builtins.str] = None,
                 compression_codec: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 parse_log_keyvals: Optional[_builtins.bool] = None,
                 password: Optional[_builtins.str] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 request_max_bytes: Optional[_builtins.int] = None,
                 required_acks: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 tls_ca_cert: Optional[_builtins.str] = None,
                 tls_client_cert: Optional[_builtins.str] = None,
                 tls_client_key: Optional[_builtins.str] = None,
                 tls_hostname: Optional[_builtins.str] = None,
                 use_tls: Optional[_builtins.bool] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.str brokers: A comma-separated list of IP addresses or hostnames of Kafka brokers
        :param _builtins.str name: The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str topic: The Kafka topic to send logs to
        :param _builtins.str auth_method: SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        :param _builtins.str compression_codec: The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        :param _builtins.str format: Apache style log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param _builtins.bool parse_log_keyvals: Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        :param _builtins.str password: SASL Pass
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.int request_max_bytes: Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        :param _builtins.str required_acks: The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1` Wait for all in-sync replicas to respond
        :param _builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param _builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param _builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param _builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param _builtins.str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param _builtins.bool use_tls: Whether to use TLS for secure logging. Can be either `true` or `false`
        :param _builtins.str user: SASL User
        """
        pulumi.set(__self__, "brokers", brokers)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if parse_log_keyvals is not None:
            pulumi.set(__self__, "parse_log_keyvals", parse_log_keyvals)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if required_acks is not None:
            pulumi.set(__self__, "required_acks", required_acks)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def brokers(self) -> _builtins.str:
        """
        A comma-separated list of IP addresses or hostnames of Kafka brokers
        """
        return pulumi.get(self, "brokers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        """
        The Kafka topic to send logs to
        """
        return pulumi.get(self, "topic")

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[_builtins.str]:
        """
        SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        """
        return pulumi.get(self, "auth_method")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter(name="parseLogKeyvals")
    def parse_log_keyvals(self) -> Optional[_builtins.bool]:
        """
        Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        """
        return pulumi.get(self, "parse_log_keyvals")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        SASL Pass
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[_builtins.int]:
        """
        Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @_builtins.property
    @pulumi.getter(name="requiredAcks")
    def required_acks(self) -> Optional[_builtins.str]:
        """
        The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1` Wait for all in-sync replicas to respond
        """
        return pulumi.get(self, "required_acks")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[_builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[_builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[_builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @_builtins.property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[_builtins.str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @_builtins.property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[_builtins.bool]:
        """
        Whether to use TLS for secure logging. Can be either `true` or `false`
        """
        return pulumi.get(self, "use_tls")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        SASL User
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceVclLoggingKinese(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "iamRole":
            suggest = "iam_role"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingKinese. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingKinese.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingKinese.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 topic: _builtins.str,
                 access_key: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 iam_role: Optional[_builtins.str] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 secret_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str topic: The Kinesis stream name
        :param _builtins.str access_key: The AWS access key to be used to write to the stream
        :param _builtins.str format: Apache style log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param _builtins.str iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str region: The AWS region the stream resides in. (Default: `us-east-1`)
        :param _builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param _builtins.str secret_key: The AWS secret access key to authenticate with
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        """
        The Kinesis stream name
        """
        return pulumi.get(self, "topic")

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[_builtins.str]:
        """
        The AWS access key to be used to write to the stream
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[_builtins.str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        """
        return pulumi.get(self, "iam_role")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The AWS region the stream resides in. (Default: `us-east-1`)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[_builtins.str]:
        """
        The AWS secret access key to authenticate with
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class ServiceVclLoggingLogentry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingLogentry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingLogentry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingLogentry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 use_tls: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: Use token based authentication (https://logentries.com/doc/input-token/)
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.int port: The port number configured in Logentries
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str response_condition: Name of blockAttributes condition to apply this logging.
        :param _builtins.bool use_tls: Whether to use TLS for secure logging
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        Use token based authentication (https://logentries.com/doc/input-token/)
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port number configured in Logentries
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[_builtins.bool]:
        """
        Whether to use TLS for secure logging
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceVclLoggingLoggly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingLoggly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingLoggly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingLoggly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingLogshuttle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingLogshuttle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingLogshuttle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingLogshuttle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 url: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The data authentication token associated with this endpoint
        :param _builtins.str url: Your Log Shuttle endpoint URL
        :param _builtins.str format: Apache style log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The data authentication token associated with this endpoint
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Your Log Shuttle endpoint URL
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingNewrelic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingNewrelic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingNewrelic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingNewrelic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The Insert API key from the Account page of your New Relic account
        :param _builtins.str format: Apache style log formatting. Your log must produce valid JSON that New Relic Logs can ingest.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str region: The region that log data will be sent to. Default: `US`
        :param _builtins.str response_condition: The name of the condition to apply.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The Insert API key from the Account page of your New Relic account
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache style log formatting. Your log must produce valid JSON that New Relic Logs can ingest.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region that log data will be sent to. Default: `US`
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingNewrelicotlp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingNewrelicotlp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingNewrelicotlp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingNewrelicotlp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the New Relic OTLP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The Insert API key from the Account page of your New Relic account
        :param _builtins.str format: Apache style log formatting. Your log must produce valid JSON that New Relic OTLP can ingest.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str region: The region that log data will be sent to. Default: `US`
        :param _builtins.str response_condition: The name of the condition to apply.
        :param _builtins.str url: The optional New Relic Trace Observer URL to stream logs to for Infinite Tracing.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the New Relic OTLP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The Insert API key from the Account page of your New Relic account
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache style log formatting. Your log must produce valid JSON that New Relic OTLP can ingest.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region that log data will be sent to. Default: `US`
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        The optional New Relic Trace Observer URL to stream logs to for Infinite Tracing.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ServiceVclLoggingOpenstack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingOpenstack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingOpenstack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingOpenstack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: _builtins.str,
                 bucket_name: _builtins.str,
                 name: _builtins.str,
                 url: _builtins.str,
                 user: _builtins.str,
                 compression_codec: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_key: Your OpenStack account access key
        :param _builtins.str bucket_name: The name of your OpenStack container
        :param _builtins.str name: The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str url: Your OpenStack auth url
        :param _builtins.str user: The username for your OpenStack account
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.str format: Apache style log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param _builtins.int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> _builtins.str:
        """
        Your OpenStack account access key
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The name of your OpenStack container
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Your OpenStack auth url
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The username for your OpenStack account
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `none`.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingPapertrail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingPapertrail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingPapertrail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingPapertrail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 name: _builtins.str,
                 port: _builtins.int,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The address of the Papertrail endpoint
        :param _builtins.str name: A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.int port: The port associated with the address where the Papertrail endpoint can be accessed
        :param _builtins.str format: A Fastly [log format string](https://docs.fastly.com/en/guides/custom-log-formats)
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. The logging call gets placed by default in `vcl_log` if `format_version` is set to `2` and in `vcl_deliver` if `format_version` is set to `1`
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed. If not set, endpoints with `format_version` of 2 are placed in `vcl_log` and those with `format_version` of 1 are placed in `vcl_deliver`
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The address of the Papertrail endpoint
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port associated with the address where the Papertrail endpoint can be accessed
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        A Fastly [log format string](https://docs.fastly.com/en/guides/custom-log-formats)
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. The logging call gets placed by default in `vcl_log` if `format_version` is set to `2` and in `vcl_deliver` if `format_version` is set to `1`
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed. If not set, endpoints with `format_version` of 2 are placed in `vcl_log` and those with `format_version` of 1 are placed in `vcl_deliver`
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "s3AccessKey":
            suggest = "s3_access_key"
        elif key == "s3IamRole":
            suggest = "s3_iam_role"
        elif key == "s3SecretKey":
            suggest = "s3_secret_key"
        elif key == "serverSideEncryption":
            suggest = "server_side_encryption"
        elif key == "serverSideEncryptionKmsKeyId":
            suggest = "server_side_encryption_kms_key_id"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 name: _builtins.str,
                 acl: Optional[_builtins.str] = None,
                 compression_codec: Optional[_builtins.str] = None,
                 domain: Optional[_builtins.str] = None,
                 file_max_bytes: Optional[_builtins.int] = None,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 redundancy: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 s3_access_key: Optional[_builtins.str] = None,
                 s3_iam_role: Optional[_builtins.str] = None,
                 s3_secret_key: Optional[_builtins.str] = None,
                 server_side_encryption: Optional[_builtins.str] = None,
                 server_side_encryption_kms_key_id: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket_name: The name of the bucket in which to store the logs
        :param _builtins.str name: The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str acl: The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.str domain: If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        :param _builtins.int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2).
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param _builtins.int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str redundancy: The S3 storage class (redundancy level). Should be one of: `standard`, `intelligent_tiering`, `standard_ia`, `onezone_ia`, `glacier`, `glacier_ir`, `deep_archive`, or `reduced_redundancy`
        :param _builtins.str response_condition: Name of blockAttributes condition to apply this logging.
        :param _builtins.str s3_access_key: AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        :param _builtins.str s3_iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        :param _builtins.str s3_secret_key: AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        :param _builtins.str server_side_encryption: Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        :param _builtins.str server_side_encryption_kms_key_id: Optional server-side KMS Key Id. Must be set if server_side_encryption is set to `aws:kms`
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if file_max_bytes is not None:
            pulumi.set(__self__, "file_max_bytes", file_max_bytes)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if redundancy is not None:
            pulumi.set(__self__, "redundancy", redundancy)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if s3_access_key is not None:
            pulumi.set(__self__, "s3_access_key", s3_access_key)
        if s3_iam_role is not None:
            pulumi.set(__self__, "s3_iam_role", s3_iam_role)
        if s3_secret_key is not None:
            pulumi.set(__self__, "s3_secret_key", s3_secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[_builtins.str]:
        """
        The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[_builtins.int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def redundancy(self) -> Optional[_builtins.str]:
        """
        The S3 storage class (redundancy level). Should be one of: `standard`, `intelligent_tiering`, `standard_ia`, `onezone_ia`, `glacier`, `glacier_ir`, `deep_archive`, or `reduced_redundancy`
        """
        return pulumi.get(self, "redundancy")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="s3AccessKey")
    def s3_access_key(self) -> Optional[_builtins.str]:
        """
        AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        """
        return pulumi.get(self, "s3_access_key")

    @_builtins.property
    @pulumi.getter(name="s3IamRole")
    def s3_iam_role(self) -> Optional[_builtins.str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        """
        return pulumi.get(self, "s3_iam_role")

    @_builtins.property
    @pulumi.getter(name="s3SecretKey")
    def s3_secret_key(self) -> Optional[_builtins.str]:
        """
        AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        """
        return pulumi.get(self, "s3_secret_key")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[_builtins.str]:
        """
        Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[_builtins.str]:
        """
        Optional server-side KMS Key Id. Must be set if server_side_encryption is set to `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingScalyr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingScalyr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingScalyr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingScalyr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The token to use for authentication (https://www.scalyr.com/keys)
        :param _builtins.str format: Apache style log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str project_id: The name of the logfile field sent to Scalyr
        :param _builtins.str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        :param _builtins.str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The token to use for authentication (https://www.scalyr.com/keys)
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The name of the logfile field sent to Scalyr
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingSftp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKnownHosts":
            suggest = "ssh_known_hosts"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingSftp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingSftp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingSftp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 name: _builtins.str,
                 path: _builtins.str,
                 ssh_known_hosts: _builtins.str,
                 user: _builtins.str,
                 compression_codec: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 gzip_level: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 secret_key: Optional[_builtins.str] = None,
                 timestamp_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The SFTP address to stream logs to
        :param _builtins.str name: The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param _builtins.str ssh_known_hosts: A list of host keys for all hosts we can connect to over SFTP
        :param _builtins.str user: The username for the server
        :param _builtins.str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting.
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param _builtins.int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param _builtins.int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.int port: The port the SFTP service listens on. (Default: `22`)
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param _builtins.str response_condition: The name of the condition to apply.
        :param _builtins.str secret_key: The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param _builtins.str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "ssh_known_hosts", ssh_known_hosts)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The SFTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> _builtins.str:
        """
        A list of host keys for all hosts we can connect to over SFTP
        """
        return pulumi.get(self, "ssh_known_hosts")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The username for the server
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[_builtins.str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip_level will default to 3. To specify a different level, leave compression_codec blank and explicitly set the level using gzip_level. Specifying both compression_codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[_builtins.int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port the SFTP service listens on. (Default: `22`)
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[_builtins.str]:
        """
        The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[_builtins.str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingSplunk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingSplunk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingSplunk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingSplunk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 token: _builtins.str,
                 url: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 tls_ca_cert: Optional[_builtins.str] = None,
                 tls_client_cert: Optional[_builtins.str] = None,
                 tls_client_key: Optional[_builtins.str] = None,
                 tls_hostname: Optional[_builtins.str] = None,
                 use_tls: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str token: The Splunk token to be used for authentication
        :param _builtins.str url: The Splunk URL to stream logs to
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str response_condition: The name of the condition to apply
        :param _builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        :param _builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param _builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param _builtins.str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param _builtins.bool use_tls: Whether to use TLS for secure logging. Default: `false`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The Splunk token to be used for authentication
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The Splunk URL to stream logs to
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[_builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[_builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[_builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @_builtins.property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[_builtins.str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @_builtins.property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[_builtins.bool]:
        """
        Whether to use TLS for secure logging. Default: `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceVclLoggingSumologic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingSumologic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingSumologic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingSumologic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 url: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 placement: Optional[_builtins.str] = None,
                 processing_region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str url: The URL to Sumologic collector endpoint
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting
        :param _builtins.int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str response_condition: Name of blockAttributes condition to apply this logging.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL to Sumologic collector endpoint
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingSyslog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "processingRegion":
            suggest = "processing_region"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingSyslog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingSyslog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingSyslog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 name: _builtins.str,
                 format: Optional[_builtins.str] = None,
                 format_version: Optional[_builtins.int] = None,
                 message_type: Optional[_builtins.str] = None,
                 placement: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 processing_region: Optional[_builtins.str] = None,
                 response_condition: Optional[_builtins.str] = None,
                 tls_ca_cert: Optional[_builtins.str] = None,
                 tls_client_cert: Optional[_builtins.str] = None,
                 tls_client_key: Optional[_builtins.str] = None,
                 tls_hostname: Optional[_builtins.str] = None,
                 token: Optional[_builtins.str] = None,
                 use_tls: Optional[_builtins.bool] = None):
        """
        :param _builtins.str address: A hostname or IPv4 address of the Syslog endpoint
        :param _builtins.str name: A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str format: Apache-style string or VCL variables to use for log formatting
        :param _builtins.int format_version: The version of the custom logging format. Can be either 1 or 2. (Default: 2)
        :param _builtins.str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param _builtins.str placement: Where in the generated VCL the logging call should be placed.
        :param _builtins.int port: The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        :param _builtins.str processing_region: Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        :param _builtins.str response_condition: Name of blockAttributes condition to apply this logging.
        :param _builtins.str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        :param _builtins.str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        :param _builtins.str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        :param _builtins.str tls_hostname: Used during the TLS handshake to validate the certificate
        :param _builtins.str token: Whether to prepend each message with a specific token
        :param _builtins.bool use_tls: Whether to use TLS for secure logging. Default `false`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if processing_region is not None:
            pulumi.set(__self__, "processing_region", processing_region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        A hostname or IPv4 address of the Syslog endpoint
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[_builtins.int]:
        """
        The version of the custom logging format. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="processingRegion")
    def processing_region(self) -> Optional[_builtins.str]:
        """
        Region where logs will be processed before streaming to BigQuery. Valid values are 'none', 'us' and 'eu'.
        """
        return pulumi.get(self, "processing_region")

    @_builtins.property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[_builtins.str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @_builtins.property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[_builtins.str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[_builtins.str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        """
        return pulumi.get(self, "tls_client_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[_builtins.str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        """
        return pulumi.get(self, "tls_client_key")

    @_builtins.property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[_builtins.str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[_builtins.str]:
        """
        Whether to prepend each message with a specific token
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[_builtins.bool]:
        """
        Whether to use TLS for secure logging. Default `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceVclProductEnablement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "botManagement":
            suggest = "bot_management"
        elif key == "brotliCompression":
            suggest = "brotli_compression"
        elif key == "ddosProtection":
            suggest = "ddos_protection"
        elif key == "domainInspector":
            suggest = "domain_inspector"
        elif key == "imageOptimizer":
            suggest = "image_optimizer"
        elif key == "logExplorerInsights":
            suggest = "log_explorer_insights"
        elif key == "originInspector":
            suggest = "origin_inspector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclProductEnablement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclProductEnablement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclProductEnablement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bot_management: Optional[_builtins.bool] = None,
                 brotli_compression: Optional[_builtins.bool] = None,
                 ddos_protection: Optional['outputs.ServiceVclProductEnablementDdosProtection'] = None,
                 domain_inspector: Optional[_builtins.bool] = None,
                 image_optimizer: Optional[_builtins.bool] = None,
                 log_explorer_insights: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 ngwaf: Optional['outputs.ServiceVclProductEnablementNgwaf'] = None,
                 origin_inspector: Optional[_builtins.bool] = None,
                 websockets: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool bot_management: Enable Bot Management support
        :param _builtins.bool brotli_compression: Enable Brotli Compression support
        :param 'ServiceVclProductEnablementDdosProtectionArgs' ddos_protection: DDoS Protection product
        :param _builtins.bool domain_inspector: Enable Domain Inspector support
        :param _builtins.bool image_optimizer: Enable Image Optimizer support (all backends must have a `shield` attribute)
        :param _builtins.bool log_explorer_insights: Enable Log Explorer & Insights
        :param _builtins.str name: Used by the provider to identify modified settings (changing this value will force the entire block to be deleted, then recreated)
        :param 'ServiceVclProductEnablementNgwafArgs' ngwaf: Next-Gen WAF product
        :param _builtins.bool origin_inspector: Enable Origin Inspector support
        :param _builtins.bool websockets: Enable WebSockets support
        """
        if bot_management is not None:
            pulumi.set(__self__, "bot_management", bot_management)
        if brotli_compression is not None:
            pulumi.set(__self__, "brotli_compression", brotli_compression)
        if ddos_protection is not None:
            pulumi.set(__self__, "ddos_protection", ddos_protection)
        if domain_inspector is not None:
            pulumi.set(__self__, "domain_inspector", domain_inspector)
        if image_optimizer is not None:
            pulumi.set(__self__, "image_optimizer", image_optimizer)
        if log_explorer_insights is not None:
            pulumi.set(__self__, "log_explorer_insights", log_explorer_insights)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ngwaf is not None:
            pulumi.set(__self__, "ngwaf", ngwaf)
        if origin_inspector is not None:
            pulumi.set(__self__, "origin_inspector", origin_inspector)
        if websockets is not None:
            pulumi.set(__self__, "websockets", websockets)

    @_builtins.property
    @pulumi.getter(name="botManagement")
    def bot_management(self) -> Optional[_builtins.bool]:
        """
        Enable Bot Management support
        """
        return pulumi.get(self, "bot_management")

    @_builtins.property
    @pulumi.getter(name="brotliCompression")
    def brotli_compression(self) -> Optional[_builtins.bool]:
        """
        Enable Brotli Compression support
        """
        return pulumi.get(self, "brotli_compression")

    @_builtins.property
    @pulumi.getter(name="ddosProtection")
    def ddos_protection(self) -> Optional['outputs.ServiceVclProductEnablementDdosProtection']:
        """
        DDoS Protection product
        """
        return pulumi.get(self, "ddos_protection")

    @_builtins.property
    @pulumi.getter(name="domainInspector")
    def domain_inspector(self) -> Optional[_builtins.bool]:
        """
        Enable Domain Inspector support
        """
        return pulumi.get(self, "domain_inspector")

    @_builtins.property
    @pulumi.getter(name="imageOptimizer")
    def image_optimizer(self) -> Optional[_builtins.bool]:
        """
        Enable Image Optimizer support (all backends must have a `shield` attribute)
        """
        return pulumi.get(self, "image_optimizer")

    @_builtins.property
    @pulumi.getter(name="logExplorerInsights")
    def log_explorer_insights(self) -> Optional[_builtins.bool]:
        """
        Enable Log Explorer & Insights
        """
        return pulumi.get(self, "log_explorer_insights")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Used by the provider to identify modified settings (changing this value will force the entire block to be deleted, then recreated)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ngwaf(self) -> Optional['outputs.ServiceVclProductEnablementNgwaf']:
        """
        Next-Gen WAF product
        """
        return pulumi.get(self, "ngwaf")

    @_builtins.property
    @pulumi.getter(name="originInspector")
    def origin_inspector(self) -> Optional[_builtins.bool]:
        """
        Enable Origin Inspector support
        """
        return pulumi.get(self, "origin_inspector")

    @_builtins.property
    @pulumi.getter
    def websockets(self) -> Optional[_builtins.bool]:
        """
        Enable WebSockets support
        """
        return pulumi.get(self, "websockets")


@pulumi.output_type
class ServiceVclProductEnablementDdosProtection(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 mode: _builtins.str):
        """
        :param _builtins.bool enabled: Enable DDoS Protection support
        :param _builtins.str mode: Operation mode. Can be either `off`, `log`, or `block`.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "mode", mode)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable DDoS Protection support
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        Operation mode. Can be either `off`, `log`, or `block`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class ServiceVclProductEnablementNgwaf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workspaceId":
            suggest = "workspace_id"
        elif key == "trafficRamp":
            suggest = "traffic_ramp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclProductEnablementNgwaf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclProductEnablementNgwaf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclProductEnablementNgwaf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 workspace_id: _builtins.str,
                 traffic_ramp: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enabled: Enable Next-Gen WAF support
        :param _builtins.str workspace_id: The workspace to link
        :param _builtins.int traffic_ramp: The percentage of traffic to inspect
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if traffic_ramp is not None:
            pulumi.set(__self__, "traffic_ramp", traffic_ramp)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable Next-Gen WAF support
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> _builtins.str:
        """
        The workspace to link
        """
        return pulumi.get(self, "workspace_id")

    @_builtins.property
    @pulumi.getter(name="trafficRamp")
    def traffic_ramp(self) -> Optional[_builtins.int]:
        """
        The percentage of traffic to inspect
        """
        return pulumi.get(self, "traffic_ramp")


@pulumi.output_type
class ServiceVclRateLimiter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientKey":
            suggest = "client_key"
        elif key == "httpMethods":
            suggest = "http_methods"
        elif key == "penaltyBoxDuration":
            suggest = "penalty_box_duration"
        elif key == "rpsLimit":
            suggest = "rps_limit"
        elif key == "windowSize":
            suggest = "window_size"
        elif key == "featureRevision":
            suggest = "feature_revision"
        elif key == "loggerType":
            suggest = "logger_type"
        elif key == "ratelimiterId":
            suggest = "ratelimiter_id"
        elif key == "responseObjectName":
            suggest = "response_object_name"
        elif key == "uriDictionaryName":
            suggest = "uri_dictionary_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclRateLimiter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclRateLimiter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclRateLimiter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 client_key: _builtins.str,
                 http_methods: _builtins.str,
                 name: _builtins.str,
                 penalty_box_duration: _builtins.int,
                 rps_limit: _builtins.int,
                 window_size: _builtins.int,
                 feature_revision: Optional[_builtins.int] = None,
                 logger_type: Optional[_builtins.str] = None,
                 ratelimiter_id: Optional[_builtins.str] = None,
                 response: Optional['outputs.ServiceVclRateLimiterResponse'] = None,
                 response_object_name: Optional[_builtins.str] = None,
                 uri_dictionary_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: The action to take when a rate limiter violation is detected (one of: log_only, response, response_object)
        :param _builtins.str client_key: Comma-separated list of VCL variables used to generate a counter key to identify a client
        :param _builtins.str http_methods: Comma-separated list of HTTP methods to apply rate limiting to
        :param _builtins.str name: A unique human readable name for the rate limiting rule
        :param _builtins.int penalty_box_duration: Length of time in minutes that the rate limiter is in effect after the initial violation is detected
        :param _builtins.int rps_limit: Upper limit of requests per second allowed by the rate limiter
        :param _builtins.int window_size: Number of seconds during which the RPS limit must be exceeded in order to trigger a violation (one of: 1, 10, 60)
        :param _builtins.int feature_revision: Revision number of the rate limiting feature implementation
        :param _builtins.str logger_type: Name of the type of logging endpoint to be used when action is log_only (one of: azureblob, bigquery, cloudfiles, datadog, digitalocean, elasticsearch, ftp, gcs, googleanalytics, heroku, honeycomb, http, https, kafka, kinesis, logentries, loggly, logshuttle, newrelic, openstack, papertrail, pubsub, s3, scalyr, sftp, splunk, stackdriver, sumologic, syslog)
        :param _builtins.str ratelimiter_id: Alphanumeric string identifying the rate limiter
        :param 'ServiceVclRateLimiterResponseArgs' response: Custom response to be sent when the rate limit is exceeded. Required if action is response
        :param _builtins.str response_object_name: Name of existing response object. Required if action is response_object
        :param _builtins.str uri_dictionary_name: The name of an Edge Dictionary containing URIs as keys. If not defined or null, all origin URIs will be rate limited
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "http_methods", http_methods)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "penalty_box_duration", penalty_box_duration)
        pulumi.set(__self__, "rps_limit", rps_limit)
        pulumi.set(__self__, "window_size", window_size)
        if feature_revision is not None:
            pulumi.set(__self__, "feature_revision", feature_revision)
        if logger_type is not None:
            pulumi.set(__self__, "logger_type", logger_type)
        if ratelimiter_id is not None:
            pulumi.set(__self__, "ratelimiter_id", ratelimiter_id)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if response_object_name is not None:
            pulumi.set(__self__, "response_object_name", response_object_name)
        if uri_dictionary_name is not None:
            pulumi.set(__self__, "uri_dictionary_name", uri_dictionary_name)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to take when a rate limiter violation is detected (one of: log_only, response, response_object)
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> _builtins.str:
        """
        Comma-separated list of VCL variables used to generate a counter key to identify a client
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="httpMethods")
    def http_methods(self) -> _builtins.str:
        """
        Comma-separated list of HTTP methods to apply rate limiting to
        """
        return pulumi.get(self, "http_methods")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique human readable name for the rate limiting rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="penaltyBoxDuration")
    def penalty_box_duration(self) -> _builtins.int:
        """
        Length of time in minutes that the rate limiter is in effect after the initial violation is detected
        """
        return pulumi.get(self, "penalty_box_duration")

    @_builtins.property
    @pulumi.getter(name="rpsLimit")
    def rps_limit(self) -> _builtins.int:
        """
        Upper limit of requests per second allowed by the rate limiter
        """
        return pulumi.get(self, "rps_limit")

    @_builtins.property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> _builtins.int:
        """
        Number of seconds during which the RPS limit must be exceeded in order to trigger a violation (one of: 1, 10, 60)
        """
        return pulumi.get(self, "window_size")

    @_builtins.property
    @pulumi.getter(name="featureRevision")
    def feature_revision(self) -> Optional[_builtins.int]:
        """
        Revision number of the rate limiting feature implementation
        """
        return pulumi.get(self, "feature_revision")

    @_builtins.property
    @pulumi.getter(name="loggerType")
    def logger_type(self) -> Optional[_builtins.str]:
        """
        Name of the type of logging endpoint to be used when action is log_only (one of: azureblob, bigquery, cloudfiles, datadog, digitalocean, elasticsearch, ftp, gcs, googleanalytics, heroku, honeycomb, http, https, kafka, kinesis, logentries, loggly, logshuttle, newrelic, openstack, papertrail, pubsub, s3, scalyr, sftp, splunk, stackdriver, sumologic, syslog)
        """
        return pulumi.get(self, "logger_type")

    @_builtins.property
    @pulumi.getter(name="ratelimiterId")
    def ratelimiter_id(self) -> Optional[_builtins.str]:
        """
        Alphanumeric string identifying the rate limiter
        """
        return pulumi.get(self, "ratelimiter_id")

    @_builtins.property
    @pulumi.getter
    def response(self) -> Optional['outputs.ServiceVclRateLimiterResponse']:
        """
        Custom response to be sent when the rate limit is exceeded. Required if action is response
        """
        return pulumi.get(self, "response")

    @_builtins.property
    @pulumi.getter(name="responseObjectName")
    def response_object_name(self) -> Optional[_builtins.str]:
        """
        Name of existing response object. Required if action is response_object
        """
        return pulumi.get(self, "response_object_name")

    @_builtins.property
    @pulumi.getter(name="uriDictionaryName")
    def uri_dictionary_name(self) -> Optional[_builtins.str]:
        """
        The name of an Edge Dictionary containing URIs as keys. If not defined or null, all origin URIs will be rate limited
        """
        return pulumi.get(self, "uri_dictionary_name")


@pulumi.output_type
class ServiceVclRateLimiterResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclRateLimiterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclRateLimiterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclRateLimiterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: _builtins.str,
                 content_type: _builtins.str,
                 status: _builtins.int):
        """
        :param _builtins.str content: HTTP response body data
        :param _builtins.str content_type: HTTP Content-Type (e.g. application/json)
        :param _builtins.int status: HTTP response status code (e.g. 429)
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        HTTP response body data
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        HTTP Content-Type (e.g. application/json)
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        """
        HTTP response status code (e.g. 429)
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServiceVclRequestSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bypassBusyWait":
            suggest = "bypass_busy_wait"
        elif key == "defaultHost":
            suggest = "default_host"
        elif key == "forceMiss":
            suggest = "force_miss"
        elif key == "forceSsl":
            suggest = "force_ssl"
        elif key == "hashKeys":
            suggest = "hash_keys"
        elif key == "maxStaleAge":
            suggest = "max_stale_age"
        elif key == "requestCondition":
            suggest = "request_condition"
        elif key == "timerSupport":
            suggest = "timer_support"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclRequestSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclRequestSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclRequestSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 action: Optional[_builtins.str] = None,
                 bypass_busy_wait: Optional[_builtins.bool] = None,
                 default_host: Optional[_builtins.str] = None,
                 force_miss: Optional[_builtins.bool] = None,
                 force_ssl: Optional[_builtins.bool] = None,
                 hash_keys: Optional[_builtins.str] = None,
                 max_stale_age: Optional[_builtins.int] = None,
                 request_condition: Optional[_builtins.str] = None,
                 timer_support: Optional[_builtins.bool] = None,
                 xff: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Unique name to refer to this Request Setting. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str action: Allows you to terminate request handling and immediately perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely)
        :param _builtins.bool bypass_busy_wait: Disable collapsed forwarding, so you don't wait for other objects to origin
        :param _builtins.str default_host: Sets the host header
        :param _builtins.bool force_miss: Force a cache miss for the request. If specified, can be `true` or `false`
        :param _builtins.bool force_ssl: Forces the request to use SSL (Redirects a non-SSL request to SSL)
        :param _builtins.str hash_keys: Comma separated list of varnish request object fields that should be in the hash key
        :param _builtins.int max_stale_age: How old an object is allowed to be to serve `stale-if-error` or `stale-while-revalidate`, in seconds
        :param _builtins.str request_condition: Name of already defined `condition` to determine if this request setting should be applied (should be unique across multiple instances of `request_setting`)
        :param _builtins.bool timer_support: Injects the X-Timer info into the request for viewing origin fetch durations
        :param _builtins.str xff: X-Forwarded-For, should be `clear`, `leave`, `append`, `append_all`, or `overwrite`. Default `append`
        """
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if bypass_busy_wait is not None:
            pulumi.set(__self__, "bypass_busy_wait", bypass_busy_wait)
        if default_host is not None:
            pulumi.set(__self__, "default_host", default_host)
        if force_miss is not None:
            pulumi.set(__self__, "force_miss", force_miss)
        if force_ssl is not None:
            pulumi.set(__self__, "force_ssl", force_ssl)
        if hash_keys is not None:
            pulumi.set(__self__, "hash_keys", hash_keys)
        if max_stale_age is not None:
            pulumi.set(__self__, "max_stale_age", max_stale_age)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if timer_support is not None:
            pulumi.set(__self__, "timer_support", timer_support)
        if xff is not None:
            pulumi.set(__self__, "xff", xff)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Unique name to refer to this Request Setting. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        Allows you to terminate request handling and immediately perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely)
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="bypassBusyWait")
    def bypass_busy_wait(self) -> Optional[_builtins.bool]:
        """
        Disable collapsed forwarding, so you don't wait for other objects to origin
        """
        return pulumi.get(self, "bypass_busy_wait")

    @_builtins.property
    @pulumi.getter(name="defaultHost")
    def default_host(self) -> Optional[_builtins.str]:
        """
        Sets the host header
        """
        return pulumi.get(self, "default_host")

    @_builtins.property
    @pulumi.getter(name="forceMiss")
    def force_miss(self) -> Optional[_builtins.bool]:
        """
        Force a cache miss for the request. If specified, can be `true` or `false`
        """
        return pulumi.get(self, "force_miss")

    @_builtins.property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[_builtins.bool]:
        """
        Forces the request to use SSL (Redirects a non-SSL request to SSL)
        """
        return pulumi.get(self, "force_ssl")

    @_builtins.property
    @pulumi.getter(name="hashKeys")
    def hash_keys(self) -> Optional[_builtins.str]:
        """
        Comma separated list of varnish request object fields that should be in the hash key
        """
        return pulumi.get(self, "hash_keys")

    @_builtins.property
    @pulumi.getter(name="maxStaleAge")
    def max_stale_age(self) -> Optional[_builtins.int]:
        """
        How old an object is allowed to be to serve `stale-if-error` or `stale-while-revalidate`, in seconds
        """
        return pulumi.get(self, "max_stale_age")

    @_builtins.property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[_builtins.str]:
        """
        Name of already defined `condition` to determine if this request setting should be applied (should be unique across multiple instances of `request_setting`)
        """
        return pulumi.get(self, "request_condition")

    @_builtins.property
    @pulumi.getter(name="timerSupport")
    def timer_support(self) -> Optional[_builtins.bool]:
        """
        Injects the X-Timer info into the request for viewing origin fetch durations
        """
        return pulumi.get(self, "timer_support")

    @_builtins.property
    @pulumi.getter
    def xff(self) -> Optional[_builtins.str]:
        """
        X-Forwarded-For, should be `clear`, `leave`, `append`, `append_all`, or `overwrite`. Default `append`
        """
        return pulumi.get(self, "xff")


@pulumi.output_type
class ServiceVclResponseObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "requestCondition":
            suggest = "request_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclResponseObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclResponseObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclResponseObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 cache_condition: Optional[_builtins.str] = None,
                 content: Optional[_builtins.str] = None,
                 content_type: Optional[_builtins.str] = None,
                 request_condition: Optional[_builtins.str] = None,
                 response: Optional[_builtins.str] = None,
                 status: Optional[_builtins.int] = None):
        """
        :param _builtins.str name: A unique name to identify this Response Object. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str cache_condition: Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param _builtins.str content: The content to deliver for the response object
        :param _builtins.str content_type: The MIME type of the content
        :param _builtins.str request_condition: Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`
        :param _builtins.str response: The HTTP Response. Default `OK`
        :param _builtins.int status: The HTTP Status Code. Default `200`
        """
        pulumi.set(__self__, "name", name)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name to identify this Response Object. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[_builtins.str]:
        """
        Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "cache_condition")

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[_builtins.str]:
        """
        The content to deliver for the response object
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[_builtins.str]:
        """
        The MIME type of the content
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[_builtins.str]:
        """
        Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`
        """
        return pulumi.get(self, "request_condition")

    @_builtins.property
    @pulumi.getter
    def response(self) -> Optional[_builtins.str]:
        """
        The HTTP Response. Default `OK`
        """
        return pulumi.get(self, "response")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.int]:
        """
        The HTTP Status Code. Default `200`
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServiceVclSnippet(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 priority: Optional[_builtins.int] = None):
        """
        :param _builtins.str content: The VCL code that specifies exactly what the snippet does
        :param _builtins.str name: A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.str type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        :param _builtins.int priority: Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class ServiceVclVcl(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 name: _builtins.str,
                 main: Optional[_builtins.bool] = None):
        """
        :param _builtins.str content: The custom VCL code to upload
        :param _builtins.str name: A unique name for this configuration block. It is important to note that changing this attribute will delete and recreate the resource
        :param _builtins.bool main: If `true`, use this block as the main configuration. If `false`, use this block as an includable library. Only a single VCL block can be marked as the main block. Default is `false`
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "name", name)
        if main is not None:
            pulumi.set(__self__, "main", main)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The custom VCL code to upload
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name for this configuration block. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def main(self) -> Optional[_builtins.bool]:
        """
        If `true`, use this block as the main configuration. If `false`, use this block as an includable library. Only a single VCL block can be marked as the main block. Default is `false`
        """
        return pulumi.get(self, "main")


@pulumi.output_type
class TlsSubscriptionManagedDnsChallenge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordName":
            suggest = "record_name"
        elif key == "recordType":
            suggest = "record_type"
        elif key == "recordValue":
            suggest = "record_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsSubscriptionManagedDnsChallenge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsSubscriptionManagedDnsChallenge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsSubscriptionManagedDnsChallenge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_name: Optional[_builtins.str] = None,
                 record_type: Optional[_builtins.str] = None,
                 record_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str record_name: The name of the DNS record to add. For example `_acme-challenge.example.com`.
        :param _builtins.str record_type: The type of DNS record to add, e.g. `A`, or `CNAME`.
        :param _builtins.str record_value: The value to which the DNS record should point, e.g. `xxxxx.fastly-validations.com`.
        """
        if record_name is not None:
            pulumi.set(__self__, "record_name", record_name)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if record_value is not None:
            pulumi.set(__self__, "record_value", record_value)

    @_builtins.property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[_builtins.str]:
        """
        The name of the DNS record to add. For example `_acme-challenge.example.com`.
        """
        return pulumi.get(self, "record_name")

    @_builtins.property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[_builtins.str]:
        """
        The type of DNS record to add, e.g. `A`, or `CNAME`.
        """
        return pulumi.get(self, "record_type")

    @_builtins.property
    @pulumi.getter(name="recordValue")
    def record_value(self) -> Optional[_builtins.str]:
        """
        The value to which the DNS record should point, e.g. `xxxxx.fastly-validations.com`.
        """
        return pulumi.get(self, "record_value")


@pulumi.output_type
class TlsSubscriptionManagedHttpChallenge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordName":
            suggest = "record_name"
        elif key == "recordType":
            suggest = "record_type"
        elif key == "recordValues":
            suggest = "record_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsSubscriptionManagedHttpChallenge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsSubscriptionManagedHttpChallenge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsSubscriptionManagedHttpChallenge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_name: Optional[_builtins.str] = None,
                 record_type: Optional[_builtins.str] = None,
                 record_values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str record_name: The name of the DNS record to add. For example `example.com`. Best accessed through a `for` expression to filter the relevant record.
        :param _builtins.str record_type: The type of DNS record to add, e.g. `A`, or `CNAME`.
        :param Sequence[_builtins.str] record_values: A list with the value(s) to which the DNS record should point.
        """
        if record_name is not None:
            pulumi.set(__self__, "record_name", record_name)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if record_values is not None:
            pulumi.set(__self__, "record_values", record_values)

    @_builtins.property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[_builtins.str]:
        """
        The name of the DNS record to add. For example `example.com`. Best accessed through a `for` expression to filter the relevant record.
        """
        return pulumi.get(self, "record_name")

    @_builtins.property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[_builtins.str]:
        """
        The type of DNS record to add, e.g. `A`, or `CNAME`.
        """
        return pulumi.get(self, "record_type")

    @_builtins.property
    @pulumi.getter(name="recordValues")
    def record_values(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list with the value(s) to which the DNS record should point.
        """
        return pulumi.get(self, "record_values")


@pulumi.output_type
class GetConfigstoresStoreResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: Alphanumeric string identifying the Config Store.
        :param _builtins.str name: Name for the Config Store.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Alphanumeric string identifying the Config Store.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name for the Config Store.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDatacentersPopResult(dict):
    def __init__(__self__, *,
                 code: _builtins.str,
                 group: _builtins.str,
                 name: _builtins.str,
                 shield: _builtins.str):
        """
        :param _builtins.str code: A code representing the POP location.
        :param _builtins.str group: A code representing the general region of the world in which the POP location resides.
        :param _builtins.str name: The name of the POP.
        :param _builtins.str shield: A code representing the shielding name of the POP. The value may be empty if the POP is not available for shielding.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "shield", shield)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        A code representing the POP location.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def group(self) -> _builtins.str:
        """
        A code representing the general region of the world in which the POP location resides.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the POP.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def shield(self) -> _builtins.str:
        """
        A code representing the shielding name of the POP. The value may be empty if the POP is not available for shielding.
        """
        return pulumi.get(self, "shield")


@pulumi.output_type
class GetDictionariesDictionaryResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 write_only: _builtins.bool):
        """
        :param _builtins.str id: Alphanumeric string identifying the Dictionary.
        :param _builtins.str name: Name for the Dictionary.
        :param _builtins.bool write_only: Indicates if items in the dictionary are readable or not.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "write_only", write_only)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Alphanumeric string identifying the Dictionary.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name for the Dictionary.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> _builtins.bool:
        """
        Indicates if items in the dictionary are readable or not.
        """
        return pulumi.get(self, "write_only")


@pulumi.output_type
class GetKvstoresStoreResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: Alphanumeric string identifying the KV Store.
        :param _builtins.str name: Name for the KV Store.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Alphanumeric string identifying the KV Store.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name for the KV Store.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetNgwafAlertDatadogIntegrationDatadogAlertResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The ID of the workspace alert.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the workspace alert.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetNgwafAlertJiraIntegrationJiraAlertResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The ID of the workspace alert.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the workspace alert.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetNgwafAlertMailingListIntegrationMailingListAlertResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The ID of the workspace alert.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the workspace alert.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetNgwafAlertMicrosoftTeamsIntegrationMicrosoftTeamsAlertResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The ID of the workspace alert.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the workspace alert.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetNgwafAlertOpsgenieIntegrationOpsgenieAlertResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The ID of the workspace alert.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the workspace alert.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetNgwafAlertPagerdutyIntegrationPagerdutyAlertResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The ID of the workspace alert.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the workspace alert.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetNgwafAlertSlackIntegrationSlackAlertResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The ID of the workspace alert.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the workspace alert.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetNgwafAlertWebhookIntegrationWebhookAlertResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The ID of the workspace alert.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the workspace alert.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetNgwafRedactionsRedactionResult(dict):
    def __init__(__self__, *,
                 field: _builtins.str,
                 id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str field: The name of the field that is being redacted.
        :param _builtins.str id: The ID of the redaction.
        :param _builtins.str type: The type of field being redacted. One of `request_parameter`, `request_header`, or `response_header`.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def field(self) -> _builtins.str:
        """
        The name of the field that is being redacted.
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the redaction.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of field being redacted. One of `request_parameter`, `request_header`, or `response_header`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNgwafThresholdsThresholdResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The ID of the threshold.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the threshold.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetNgwafVirtualPatchesVirtualPatchResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 id: _builtins.str,
                 mode: _builtins.str):
        """
        :param _builtins.bool enabled: Whether the virtual patch is enabled or disabled.
        :param _builtins.str id: The ID of the virtual patch.
        :param _builtins.str mode: Action to take when a signal for the virtual patch is detected. One of `log` or `block`.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mode", mode)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether the virtual patch is enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the virtual patch.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        Action to take when a signal for the virtual patch is detected. One of `log` or `block`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class GetNgwafWorkspacesWorkspaceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: The ID of the workspace.
        :param _builtins.str name: The name of the workspace.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the workspace.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSecretstoresStoreResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: Alphanumeric string identifying the Secrets Store.
        :param _builtins.str name: Name for the Secrets Store.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Alphanumeric string identifying the Secrets Store.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name for the Secrets Store.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServicesDetailResult(dict):
    def __init__(__self__, *,
                 comment: _builtins.str,
                 created_at: _builtins.str,
                 customer_id: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 updated_at: _builtins.str,
                 version: _builtins.int):
        """
        :param _builtins.str comment: A freeform descriptive note.
        :param _builtins.str created_at: Date and time in ISO 8601 format.
        :param _builtins.str customer_id: Alphanumeric string identifying the customer.
        :param _builtins.str id: Alphanumeric string identifying the service.
        :param _builtins.str name: The name of the service.
        :param _builtins.str type: The type of this service. One of `vcl`, `wasm`.
        :param _builtins.str updated_at: Date and time in ISO 8601 format.
        :param _builtins.int version: The currently activated version.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "customer_id", customer_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        A freeform descriptive note.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date and time in ISO 8601 format.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> _builtins.str:
        """
        Alphanumeric string identifying the customer.
        """
        return pulumi.get(self, "customer_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Alphanumeric string identifying the service.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of this service. One of `vcl`, `wasm`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Date and time in ISO 8601 format.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The currently activated version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetTlsConfigurationDnsRecordResult(dict):
    def __init__(__self__, *,
                 record_type: _builtins.str,
                 record_value: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str record_type: Type of DNS record to set, e.g. A, AAAA, or CNAME.
        :param _builtins.str record_value: The IP address or hostname of the DNS record.
        :param _builtins.str region: The regions that will be used to route traffic. Select DNS Records with a `global` region to route traffic to the most performant point of presence (POP) worldwide (global pricing will apply). Select DNS records with a `us-eu` region to exclusively land traffic on North American and European POPs.
        """
        pulumi.set(__self__, "record_type", record_type)
        pulumi.set(__self__, "record_value", record_value)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="recordType")
    def record_type(self) -> _builtins.str:
        """
        Type of DNS record to set, e.g. A, AAAA, or CNAME.
        """
        return pulumi.get(self, "record_type")

    @_builtins.property
    @pulumi.getter(name="recordValue")
    def record_value(self) -> _builtins.str:
        """
        The IP address or hostname of the DNS record.
        """
        return pulumi.get(self, "record_value")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The regions that will be used to route traffic. Select DNS Records with a `global` region to route traffic to the most performant point of presence (POP) worldwide (global pricing will apply). Select DNS records with a `us-eu` region to exclusively land traffic on North American and European POPs.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetVclSnippetsVclSnippetResult(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 priority: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.str content: The VCL code that specifies exactly what the snippet does.
        :param _builtins.str id: Alphanumeric string identifying a VCL Snippet.
        :param _builtins.str name: The name for the snippet.
        :param _builtins.int priority: Priority determines execution order. Lower numbers execute first.
        :param _builtins.str type: The location in generated VCL where the snippet should be placed.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The VCL code that specifies exactly what the snippet does.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Alphanumeric string identifying a VCL Snippet.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name for the snippet.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Priority determines execution order. Lower numbers execute first.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The location in generated VCL where the snippet should be placed.
        """
        return pulumi.get(self, "type")


