# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/06_lars.ipynb (unless otherwise specified).

__all__ = ['prepare_lars_weather', 'select_lars_wdf']

# Cell
import sys
_=[sys.path.append(i) for i in ['.', '..']]

# Cell
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
from .core import *
from .classes import *
import seaborn as sns

# Cell
def prepare_lars_weather(file,year,generated=True,order=["year","jday","minTemp","maxTemp","precip","rad"]):

    df = pd.read_csv(file,delim_whitespace=True,header=None)

    if generated:
        df.columns=order
        df["tdelta"]=pd.to_timedelta(df.jday,unit='D')
        df["date"]=pd.to_datetime(f'{year-1}/12/31')+df["tdelta"]
        df["eto"] = df.rad*(0.0023)*(((df.maxTemp-df.minTemp)/2)+17.8)*(df.maxTemp-df.minTemp)**0.5
        df.eto=df.eto.clip(0.1)
        df=df[["simyear","minTemp","maxTemp","precip","eto",'date']]
        df.columns=["simyear","MinTemp","MaxTemp","Precipitation","ReferenceET","Date"]


    else:
        df.columns=order
        df['date'] = pd.to_datetime(df.year, format='%Y') + pd.to_timedelta(df.jday - 1, unit='d')
        df["eto"] = df.rad*(0.0023)*(((df.maxTemp-df.minTemp)/2)+17.8)*(df.maxTemp-df.minTemp)**0.5
        df.eto=df.eto.clip(0.1)
        df=df[["minTemp","maxTemp","precip","eto",'date']]
        df.columns=["MinTemp","MaxTemp","Precipitation","ReferenceET","Date"]


    return df

# Cell
def select_lars_wdf(df,simyear):
    temp =  df[df.simyear==simyear][["MinTemp","MaxTemp","Precipitation","ReferenceET","Date"]]
    return temp.reset_index(drop=True)