/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: ROCDLOps.td                                                          *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace ROCDL {
/// Vote across thread group
/// Ballot provides a bit mask containing the 1-bit predicate value from each lane.
///       The nth bit of the result contains the 1 bit contributed by the nth warp lane.
class BallotOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class BarrierOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class BarrierSignalOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class BarrierWaitOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class BlockDimXOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class BlockDimYOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class BlockDimZOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class BlockIdXOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class BlockIdYOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class BlockIdZOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Convert bf8 to f32
/// Convert 8-bit bf8 value from the `byteSel`th bit of `srcA` to fp32.
class CvtF32Bf8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Convert fp8 to f32
/// Convert 8-bit fp8 value from the `byteSel`th bit of `srcA` to fp32.
class CvtF32Fp8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Convert two f32's to bf8
/// Convert `srcA` and `srcB` to bf8 and store into the low/high word of
///     `old`, preserving the other word.
class CvtPkBf8F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Convert packed bf8 to packed f32
/// Convert `src` based on $wordSel to packed fp32,
class CvtPkF32Bf8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Convert packed fp8 to packed f32
/// Convert `src` based on $wordSel to packed fp32.
class CvtPkF32Fp8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Convert two f32's to fp8
/// Convert `srcA` and `srcB` to fp8 and store into the low/high word of
///     `old`, preserving the other word.
class CvtPkFp8F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Convert two f32 input into a vector<2xf16>
/// Convert two f32 values into a packed vector<2xf16>.
class CvtPkRtz;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert two vector<16xf32> to 32 packed bf6
/// Convert 32 single-precision float values, packed into two length-16
///       vectors that will be logically concanenated, to packed bf6, dividing by the exponent part of `scale`
///       before doing so.
class CvtScaleF322xPk16Bf6F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert two vector<16xf32> to 32 packed fp6
/// Convert 32 single-precision float values, packed into two length-16
///       vectors that will be logically concanenated, to packed fp6, dividing by the exponent part of `scale`
///       before doing so.
class CvtScaleF322xPk16Fp6F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert bf8 from packed vector to f16, updating tied result
/// Convert a bf8 byte from `src`, selected by
///       `srcSelIndex`, to f16 while multiplying it by the expontent of `scale`,
///       and place it into the `dstLoHiSel`th bit
///       of `oldVdst` preserving the other element of that vector in
///       the return value.
/// 
///       The bytes are stored as an `i32` and not a `<4 x i8>`.
class CvtScaleF32F16Bf8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert fp8 from packed vector to f16, updating tied result
/// Convert a fp8 byte from `src`, selected by
///       `srcSelIndex`, to f16 while multiplying it by the expontent of `scale`,
///       and place it into the `dstLoHiSel`th bit
///       of `oldVdst` preserving the other element of that vector in
///       the return value.
/// 
///       The bytes are stored as an `i32` and not a `<4 x i8>`.
class CvtScaleF32F16Fp8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert bf8 from packed vector to f32
/// Convert a bf8 byte from `src`, selected by
///       `srcSelIndex`, to f32, multiplying it by the exponent of `scale`.
/// 
///       The bytes are stored in an `i32`, not a `<4 x i8>`.
class CvtScaleF32F32Bf8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert fp8 from packed vector to f32
/// Convert a fp8 byte from `src`, selected by
///       `srcSelIndex`, to f32, multiplying it by the exponent of `scale`.
/// 
///       The bytes are stored in an `i32`, not a `<4 x i8>`.
class CvtScaleF32F32Fp8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed bf6 to packed bf16
/// Convert 32 packed bf6 values to packed bf16, multiplying by the exponent part of `scale`
///         before doing so.
class CvtScaleF32Pk32Bf16Bf6Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed fp6 to packed bf16
/// Convert 32 packed fp6 values to packed bf16, multiplying by the exponent part of `scale`
///         before doing so.
class CvtScaleF32Pk32Bf16Fp6Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed bf16 to packed bf6
/// Convert 32 packed bf16 values to packed bf6, dividing by the exponent part of `scale`
///           before doing so.
class CvtScaleF32Pk32Bf6Bf16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed f16 to packed bf6
/// Convert 32 packed f16 values to packed bf6, dividing by the exponent part of `scale`
///           before doing so.
class CvtScaleF32Pk32Bf6F16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed bf6 to packed f16
/// Convert 32 packed bf6 values to packed f16, multiplying by the exponent part of `scale`
///         before doing so.
class CvtScaleF32Pk32F16Bf6Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed fp6 to packed f16
/// Convert 32 packed fp6 values to packed f16, multiplying by the exponent part of `scale`
///         before doing so.
class CvtScaleF32Pk32F16Fp6Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed bf6 to packed f32
/// Convert 32 packed bf6 values to packed f32, multiplying by the exponent part of `scale`
///         before doing so.
class CvtScaleF32Pk32F32Bf6Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed fp6 to packed f32
/// Convert 32 packed fp6 values to packed f32, multiplying by the exponent part of `scale`
///         before doing so.
class CvtScaleF32Pk32F32Fp6Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed bf16 to packed fp6
/// Convert 32 packed bf16 values to packed fp6, dividing by the exponent part of `scale`
///           before doing so.
class CvtScaleF32Pk32Fp6Bf16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed f16 to packed fp6
/// Convert 32 packed f16 values to packed fp6, dividing by the exponent part of `scale`
///           before doing so.
class CvtScaleF32Pk32Fp6F16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert two bf8to two bf16
/// Convert two packed bf8 values in `src0` to two bf16 values, multiplying by the exponent in `scale`.
///         The two values to be converted are selected from the low or high half
///         of `src` (a packed vector represented as an `i32`)
///         on the basis of `srcLoHiSel`.
class CvtScaleF32PkBf16Bf8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert two packed fp4 to packed bf16
/// Convert two packed fp4 (f4E2M1) values  stored as one byte of a 32-bit integer
///       to packed bf16, multiplying by the exponent part of `scale`
///       before doing so.
/// 
///       The byte to convert is chosen by `srcSelIndex`.
class CvtScaleF32PkBf16Fp4Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert two fp8to two bf16
/// Convert two packed fp8 values in `src0` to two bf16 values, multiplying by the exponent in `scale`.
///         The two values to be converted are selected from the low or high half
///         of `src` (a packed vector represented as an `i32`)
///         on the basis of `srcLoHiSel`.
class CvtScaleF32PkBf16Fp8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert two bf16to two bf8, updating packed vector
/// Convert two bf16 values in `src0` to two bf8 bytes, dividing by the exponent in `scale`. The bytes are
///         packed into a 16-bit value which is inserted into `oldVdst` at the
///         `dstLoHiSel` position, with the entire updated vector being returned.
class CvtScaleF32PkBf8Bf16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert two f16to two bf8, updating packed vector
/// Convert two f16 values in `src0` to two bf8 bytes, dividing by the exponent in `scale`. The bytes are
///         packed into a 16-bit value which is inserted into `oldVdst` at the
///         `dstLoHiSel` position, with the entire updated vector being returned.
class CvtScaleF32PkBf8F16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert two f32 to two bf8, updating packed vector
/// Convert two f32 values in `src0` and `src1` to two bf8 bytes,
///       dividing by the exponent in `scale`. The bytes are packed into
///       a 16-bit value which is inserted into `oldVdst` at the `dstLoHiSel`
///       position, with the entire updated vector being returned.
class CvtScaleF32PkBf8F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert two bf8to two f16
/// Convert two packed bf8 values in `src0` to two f16 values, multiplying by the exponent in `scale`.
///         The two values to be converted are selected from the low or high half
///         of `src` (a packed vector represented as an `i32`)
///         on the basis of `srcLoHiSel`.
class CvtScaleF32PkF16Bf8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert two packed fp4 to packed f16
/// Convert two packed fp4 (f4E2M1) values  stored as one byte of a 32-bit integer
///       to packed f16, multiplying by the exponent part of `scale`
///       before doing so.
/// 
///       The byte to convert is chosen by `srcSelIndex`.
class CvtScaleF32PkF16Fp4Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert two fp8to two f16
/// Convert two packed fp8 values in `src0` to two f16 values, multiplying by the exponent in `scale`.
///         The two values to be converted are selected from the low or high half
///         of `src` (a packed vector represented as an `i32`)
///         on the basis of `srcLoHiSel`.
class CvtScaleF32PkF16Fp8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert two bf8to two f32
/// Convert two packed bf8 values in `src0` to two f32 values, multiplying by the exponent in `scale`.
///         The two values to be converted are selected from the low or high half
///         of `src` (a packed vector represented as an `i32`)
///         on the basis of `srcLoHiSel`.
class CvtScaleF32PkF32Bf8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert two packed fp4 to packed f32
/// Convert two packed fp4 (f4E2M1) values  stored as one byte of a 32-bit integer
///       to packed f32, multiplying by the exponent part of `scale`
///       before doing so.
/// 
///       The byte to convert is chosen by `srcSelIndex`.
class CvtScaleF32PkF32Fp4Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert two fp8to two f32
/// Convert two packed fp8 values in `src0` to two f32 values, multiplying by the exponent in `scale`.
///         The two values to be converted are selected from the low or high half
///         of `src` (a packed vector represented as an `i32`)
///         on the basis of `srcLoHiSel`.
class CvtScaleF32PkF32Fp8Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert two bf16 to packed fp4, updating tied vector
/// Convert two packed bf16 values to packed
///         fp4, dividing by the exponent part of `scale`
///         before doing so.
/// 
///         The two scaled values are packed  into a byte.
///         That byte is used to update the `dstSelIndex`th
///         byte of `oldVdst`, which is returned in its entirity.
class CvtScaleF32PkFp4Bf16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert two f16 to packed fp4, updating tied vector
/// Convert two packed f16 values to packed
///         fp4, dividing by the exponent part of `scale`
///         before doing so.
/// 
///         The two scaled values are packed  into a byte.
///         That byte is used to update the `dstSelIndex`th
///         byte of `oldVdst`, which is returned in its entirity.
class CvtScaleF32PkFp4F16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert two f32 values to two packed fp4, updating tied vector
/// Convert two single-precision float values, passed in `src0` and `src1`
///     into two fp4 values, dividing them by the expontent part of `scale`
///     before doing so.
/// 
///     The two scaled values are packed  into a byte.
///     That byte is used to update the `dstSelIndex`th
///     byte of `oldVdst`, which is returned in its entirity.
class CvtScaleF32PkFp4F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert two bf16to two fp8, updating packed vector
/// Convert two bf16 values in `src0` to two fp8 bytes, dividing by the exponent in `scale`. The bytes are
///         packed into a 16-bit value which is inserted into `oldVdst` at the
///         `dstLoHiSel` position, with the entire updated vector being returned.
class CvtScaleF32PkFp8Bf16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert two f16to two fp8, updating packed vector
/// Convert two f16 values in `src0` to two fp8 bytes, dividing by the exponent in `scale`. The bytes are
///         packed into a 16-bit value which is inserted into `oldVdst` at the
///         `dstLoHiSel` position, with the entire updated vector being returned.
class CvtScaleF32PkFp8F16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert two f32 to two fp8, updating packed vector
/// Convert two f32 values in `src0` and `src1` to two fp8 bytes,
///       dividing by the exponent in `scale`. The bytes are packed into
///       a 16-bit value which is inserted into `oldVdst` at the `dstLoHiSel`
///       position, with the entire updated vector being returned.
class CvtScaleF32PkFp8F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert bf16to bf8 with stochiastic rounding, updating packed vector
/// Convert a bf16 value in `src0` to a bf8 bytes, dividing by the exponent in `scale` and using `seed`
///         for stochiastic rounding. Place the resulting byte in the
///         `dstSelIndex`th bit of `oldVdst` and return the entire packed vector,
///         which is stored as an `i32`.
class CvtScaleF32SrBf8BF16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert f16to bf8 with stochiastic rounding, updating packed vector
/// Convert a f16 value in `src0` to a bf8 bytes, dividing by the exponent in `scale` and using `seed`
///         for stochiastic rounding. Place the resulting byte in the
///         `dstSelIndex`th bit of `oldVdst` and return the entire packed vector,
///         which is stored as an `i32`.
class CvtScaleF32SrBf8F16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert f32to bf8 with stochiastic rounding, updating packed vector
/// Convert a f32 value in `src0` to a bf8 bytes, dividing by the exponent in `scale` and using `seed`
///         for stochiastic rounding. Place the resulting byte in the
///         `dstSelIndex`th bit of `oldVdst` and return the entire packed vector,
///         which is stored as an `i32`.
class CvtScaleF32SrBf8F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert bf16to fp8 with stochiastic rounding, updating packed vector
/// Convert a bf16 value in `src0` to a fp8 bytes, dividing by the exponent in `scale` and using `seed`
///         for stochiastic rounding. Place the resulting byte in the
///         `dstSelIndex`th bit of `oldVdst` and return the entire packed vector,
///         which is stored as an `i32`.
class CvtScaleF32SrFp8BF16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert f16to fp8 with stochiastic rounding, updating packed vector
/// Convert a f16 value in `src0` to a fp8 bytes, dividing by the exponent in `scale` and using `seed`
///         for stochiastic rounding. Place the resulting byte in the
///         `dstSelIndex`th bit of `oldVdst` and return the entire packed vector,
///         which is stored as an `i32`.
class CvtScaleF32SrFp8F16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scaled convert f32to fp8 with stochiastic rounding, updating packed vector
/// Convert a f32 value in `src0` to a fp8 bytes, dividing by the exponent in `scale` and using `seed`
///         for stochiastic rounding. Place the resulting byte in the
///         `dstSelIndex`th bit of `oldVdst` and return the entire packed vector,
///         which is stored as an `i32`.
class CvtScaleF32SrFp8F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed bf16 to packed bf6 with stochiastic rounding
/// Convert 32 packed bf16 values to packed bf6, dividing by the exponent part of `scale`
///         before doing so and applying random rounding derived from
///         `seed`.
class CvtScaleF32SrPk32Bf6Bf16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed f16 to packed bf6 with stochiastic rounding
/// Convert 32 packed f16 values to packed bf6, dividing by the exponent part of `scale`
///         before doing so and applying random rounding derived from
///         `seed`.
class CvtScaleF32SrPk32Bf6F16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed f32 to packed bf6 with stochiastic rounding
/// Convert 32 packed f32 values to packed bf6, dividing by the exponent part of `scale`
///         before doing so and applying random rounding derived from
///         `seed`.
class CvtScaleF32SrPk32Bf6F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed bf16 to packed fp6 with stochiastic rounding
/// Convert 32 packed bf16 values to packed fp6, dividing by the exponent part of `scale`
///         before doing so and applying random rounding derived from
///         `seed`.
class CvtScaleF32SrPk32Fp6Bf16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed f16 to packed fp6 with stochiastic rounding
/// Convert 32 packed f16 values to packed fp6, dividing by the exponent part of `scale`
///         before doing so and applying random rounding derived from
///         `seed`.
class CvtScaleF32SrPk32Fp6F16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert packed f32 to packed fp6 with stochiastic rounding
/// Convert 32 packed f32 values to packed fp6, dividing by the exponent part of `scale`
///         before doing so and applying random rounding derived from
///         `seed`.
class CvtScaleF32SrPk32Fp6F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert two bf16 to packed fp4 with stochiastic rounding, updating tied vector
/// Convert two packed bf16 values to packed
///       fp4, dividing by the exponent part of `scale`
///       before doing so and using `seed` as the random seed for
///       stochiastic rounding.
/// 
///       The two scaled values are packed (little-endian)
///       into a byte. That byte is used to update the `dstSelIndex`th
///       byte of `oldVdst`, which is returned in its entirity.
class CvtScaleF32SrPkFp4Bf16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert two f16 to packed fp4 with stochiastic rounding, updating tied vector
/// Convert two packed f16 values to packed
///       fp4, dividing by the exponent part of `scale`
///       before doing so and using `seed` as the random seed for
///       stochiastic rounding.
/// 
///       The two scaled values are packed (little-endian)
///       into a byte. That byte is used to update the `dstSelIndex`th
///       byte of `oldVdst`, which is returned in its entirity.
class CvtScaleF32SrPkFp4F16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Scale and convert two f32 to packed fp4 with stochiastic rounding, updating tied vector
/// Convert two packed f32 values to packed
///       fp4, dividing by the exponent part of `scale`
///       before doing so and using `seed` as the random seed for
///       stochiastic rounding.
/// 
///       The two scaled values are packed (little-endian)
///       into a byte. That byte is used to update the `dstSelIndex`th
///       byte of `oldVdst`, which is returned in its entirity.
class CvtScaleF32SrPkFp4F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Convert f32 to bf8, stochiastic rounding
/// Convert `srcA` to bf8, adding the rounding factor from `srcB`,
///     and store into the `byteSel`th byte of `old`, preserving the others.
class CvtSrBf8F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Convert f32 to fp8, stochiastic rounding
/// Convert `srcA` to fp8, adding the rounding factor from `srcB`,
///     and store into the `byteSel`th byte of `old`, preserving the others.
class CvtSrFp8F32Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class DPPUpdateOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class DsBpermuteOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class DsSwizzleOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class GlobalLoadLDSOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class GridDimXOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class GridDimYOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class GridDimZOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class IglpOpt;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class LoadToLDSOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class MakeBufferRsrcOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class MbcntHiOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class MbcntLoOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Performs a `permlanex16` operation with the given operands, applying the
///     permutation specified by $fi to the provided inputs.
class PermlaneX16Op;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawBufferAtomicCmpSwap;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawBufferAtomicFAddOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawBufferAtomicFMaxOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawBufferAtomicSMaxOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawBufferAtomicUMinOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawBufferLoadOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawBufferStoreOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawPtrBufferAtomicCmpSwap;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawPtrBufferAtomicFaddOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawPtrBufferAtomicFmaxOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawPtrBufferAtomicSmaxOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawPtrBufferAtomicUminOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawPtrBufferLoadLdsOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawPtrBufferLoadOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class RawPtrBufferStoreOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Get the value in first active lane.
/// Returns the value in the lowest active lane of the input operand.
class ReadfirstlaneOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Get the value in the specific lane.
/// Get the value in lane `src1` from input `src0`.
class ReadlaneOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class SBarrierOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class SSleepOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class SWaitcntOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class SchedBarrier;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class SchedGroupBarrier;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class SetPrioOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class ThreadIdXOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class ThreadIdYOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class ThreadIdZOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Wait until DSCNT is less than or equal to `count`
/// Wait for the counter specified to be less-than or equal-to the `count`
///       before continuing.
/// 
///       Available on gfx12+.
class WaitDscntOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Wait until EXPCNT is less than or equal to `count`
/// Wait for the counter specified to be less-than or equal-to the `count`
///       before continuing.
/// 
///       Available on gfx12+.
class WaitExpcntOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Wait until LOADCNT is less than or equal to `count`
/// Wait for the counter specified to be less-than or equal-to the `count`
///       before continuing.
/// 
///       Available on gfx12+.
class WaitLoadcntOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
/// Wait until STORECNT is less than or equal to `count`
/// Wait for the counter specified to be less-than or equal-to the `count`
///       before continuing.
/// 
///       Available on gfx12+.
class WaitStorecntOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class WavefrontSizeOp;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class ds_read_tr16_b64;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class ds_read_tr4_b64;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class ds_read_tr6_b96;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class ds_read_tr8_b64;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x16bf16_1k;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x16f16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x1f32;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x2bf16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x32_bf16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x32_bf8_bf8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x32_bf8_fp8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x32_f16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x32_fp8_bf8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x32_fp8_fp8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x4bf16_1k;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x4f16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x4f32;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x8_xf32;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_16x16x8bf16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x16_bf16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x16_bf8_bf8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x16_bf8_fp8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x16_f16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x16_fp8_bf8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x16_fp8_fp8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x1f32;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x2bf16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x2f32;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x4_xf32;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x4bf16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x4bf16_1k;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x4f16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x8bf16_1k;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_32x32x8f16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_4x4x1f32;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_4x4x2bf16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_4x4x4bf16_1k;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f32_4x4x4f16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f64_16x16x4f64;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_f64_4x4x4f64;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_i32_16x16x16i8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_i32_16x16x32_i8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_i32_16x16x4i8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_i32_16x16x64_i8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_i32_32x32x16_i8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_i32_32x32x32_i8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_i32_32x32x4i8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_i32_32x32x8i8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_i32_4x4x4i8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_scale_f32_16x16x128_f8f6f4;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class mfma_scale_f32_32x32x64_f8f6f4;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_f32_16x16x32_bf16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_f32_16x16x32_f16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_f32_16x16x64_bf8_bf8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_f32_16x16x64_bf8_fp8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_f32_16x16x64_fp8_bf8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_f32_16x16x64_fp8_fp8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_f32_32x32x16_bf16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_f32_32x32x16_f16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_f32_32x32x32_bf8_bf8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_f32_32x32x32_bf8_fp8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_f32_32x32x32_fp8_bf8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_f32_32x32x32_fp8_fp8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_i32_16x16x64_i8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class smfmac_i32_32x32x32_i8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class wmma_bf16_16x16x16_bf16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class wmma_f16_16x16x16_f16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class wmma_f32_16x16x16_bf16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class wmma_f32_16x16x16_bf8_bf8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class wmma_f32_16x16x16_bf8_fp8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class wmma_f32_16x16x16_f16;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class wmma_f32_16x16x16_fp8_bf8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class wmma_f32_16x16x16_fp8_fp8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class wmma_i32_16x16x16_iu4;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class wmma_i32_16x16x16_iu8;
} // namespace ROCDL
} // namespace mlir
namespace mlir {
namespace ROCDL {
class wmma_i32_16x16x32_iu4;
} // namespace ROCDL
} // namespace mlir
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BallotOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BallotOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BallotOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.ballot", odsAttrs.getContext());
  }

  BallotOpGenericAdaptorBase(BallotOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BallotOpGenericAdaptor : public detail::BallotOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BallotOpGenericAdaptorBase;
  static constexpr int odsIndex_pred = 0;
public:
  BallotOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BallotOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BallotOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BallotOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BallotOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BallotOpGenericAdaptor(RangeT values, const BallotOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BallotOp, typename = std::enable_if_t<std::is_same_v<LateInst, BallotOp>>>
  BallotOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPred() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BallotOpAdaptor : public BallotOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BallotOpGenericAdaptor::BallotOpGenericAdaptor;
  BallotOpAdaptor(BallotOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BallotOp : public ::mlir::Op<BallotOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BallotOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BallotOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pred = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.ballot");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getPredMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value pred);
  static BallotOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value pred);
  static BallotOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pred);
  static BallotOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pred);
  static BallotOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BallotOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BallotOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BallotOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BallotOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BallotOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BarrierOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BarrierOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BarrierOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.barrier", odsAttrs.getContext());
  }

  BarrierOpGenericAdaptorBase(BarrierOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BarrierOpGenericAdaptor : public detail::BarrierOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BarrierOpGenericAdaptorBase;
public:
  BarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BarrierOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BarrierOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BarrierOpGenericAdaptor(RangeT values, const BarrierOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BarrierOp, typename = std::enable_if_t<std::is_same_v<LateInst, BarrierOp>>>
  BarrierOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BarrierOpAdaptor : public BarrierOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BarrierOpGenericAdaptor::BarrierOpGenericAdaptor;
  BarrierOpAdaptor(BarrierOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BarrierOp : public ::mlir::Op<BarrierOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BarrierOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BarrierOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.barrier");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BarrierOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BarrierSignalOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BarrierSignalOpGenericAdaptorBase {
public:
  struct Properties {
    using idTy = ::mlir::IntegerAttr;
    idTy id;

    auto getId() const {
      auto &propStorage = this->id;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setId(const ::mlir::IntegerAttr &propValue) {
      this->id = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.id == this->id &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BarrierSignalOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.s.barrier.signal", odsAttrs.getContext());
  }

  BarrierSignalOpGenericAdaptorBase(BarrierSignalOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIdAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
    return attr;
  }

  uint32_t getId();
};
} // namespace detail
template <typename RangeT>
class BarrierSignalOpGenericAdaptor : public detail::BarrierSignalOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BarrierSignalOpGenericAdaptorBase;
public:
  BarrierSignalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BarrierSignalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BarrierSignalOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BarrierSignalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BarrierSignalOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BarrierSignalOpGenericAdaptor(RangeT values, const BarrierSignalOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BarrierSignalOp, typename = std::enable_if_t<std::is_same_v<LateInst, BarrierSignalOp>>>
  BarrierSignalOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BarrierSignalOpAdaptor : public BarrierSignalOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BarrierSignalOpGenericAdaptor::BarrierSignalOpGenericAdaptor;
  BarrierSignalOpAdaptor(BarrierSignalOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BarrierSignalOp : public ::mlir::Op<BarrierSignalOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BarrierSignalOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BarrierSignalOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("id")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIdAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIdAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.s.barrier.signal");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIdAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
  }

  uint32_t getId();
  void setIdAttr(::mlir::IntegerAttr attr) {
    getProperties().id = attr;
  }

  void setId(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr id);
  static BarrierSignalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr id);
  static BarrierSignalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static BarrierSignalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static BarrierSignalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint32_t id);
  static BarrierSignalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, uint32_t id);
  static BarrierSignalOp create(::mlir::ImplicitLocOpBuilder &builder, uint32_t id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint32_t id);
  static BarrierSignalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint32_t id);
  static BarrierSignalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint32_t id);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierSignalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierSignalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierSignalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierSignalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BarrierSignalOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BarrierWaitOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BarrierWaitOpGenericAdaptorBase {
public:
  struct Properties {
    using idTy = ::mlir::IntegerAttr;
    idTy id;

    auto getId() const {
      auto &propStorage = this->id;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setId(const ::mlir::IntegerAttr &propValue) {
      this->id = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.id == this->id &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BarrierWaitOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.s.barrier.wait", odsAttrs.getContext());
  }

  BarrierWaitOpGenericAdaptorBase(BarrierWaitOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIdAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
    return attr;
  }

  uint16_t getId();
};
} // namespace detail
template <typename RangeT>
class BarrierWaitOpGenericAdaptor : public detail::BarrierWaitOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BarrierWaitOpGenericAdaptorBase;
public:
  BarrierWaitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BarrierWaitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BarrierWaitOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BarrierWaitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BarrierWaitOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BarrierWaitOpGenericAdaptor(RangeT values, const BarrierWaitOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BarrierWaitOp, typename = std::enable_if_t<std::is_same_v<LateInst, BarrierWaitOp>>>
  BarrierWaitOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BarrierWaitOpAdaptor : public BarrierWaitOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BarrierWaitOpGenericAdaptor::BarrierWaitOpGenericAdaptor;
  BarrierWaitOpAdaptor(BarrierWaitOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BarrierWaitOp : public ::mlir::Op<BarrierWaitOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BarrierWaitOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BarrierWaitOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("id")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIdAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIdAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.s.barrier.wait");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIdAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
  }

  uint16_t getId();
  void setIdAttr(::mlir::IntegerAttr attr) {
    getProperties().id = attr;
  }

  void setId(uint16_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr id);
  static BarrierWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr id);
  static BarrierWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static BarrierWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static BarrierWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint16_t id);
  static BarrierWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, uint16_t id);
  static BarrierWaitOp create(::mlir::ImplicitLocOpBuilder &builder, uint16_t id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint16_t id);
  static BarrierWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint16_t id);
  static BarrierWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint16_t id);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BarrierWaitOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BlockDimXOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BlockDimXOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockDimXOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.workgroup.dim.x", odsAttrs.getContext());
  }

  BlockDimXOpGenericAdaptorBase(BlockDimXOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};
} // namespace detail
template <typename RangeT>
class BlockDimXOpGenericAdaptor : public detail::BlockDimXOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockDimXOpGenericAdaptorBase;
public:
  BlockDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockDimXOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockDimXOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockDimXOpGenericAdaptor(RangeT values, const BlockDimXOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockDimXOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockDimXOp>>>
  BlockDimXOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockDimXOpAdaptor : public BlockDimXOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockDimXOpGenericAdaptor::BlockDimXOpGenericAdaptor;
  BlockDimXOpAdaptor(BlockDimXOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockDimXOp : public ::mlir::Op<BlockDimXOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockDimXOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockDimXOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.workgroup.dim.x");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BlockDimXOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BlockDimYOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BlockDimYOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockDimYOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.workgroup.dim.y", odsAttrs.getContext());
  }

  BlockDimYOpGenericAdaptorBase(BlockDimYOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};
} // namespace detail
template <typename RangeT>
class BlockDimYOpGenericAdaptor : public detail::BlockDimYOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockDimYOpGenericAdaptorBase;
public:
  BlockDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockDimYOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockDimYOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockDimYOpGenericAdaptor(RangeT values, const BlockDimYOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockDimYOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockDimYOp>>>
  BlockDimYOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockDimYOpAdaptor : public BlockDimYOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockDimYOpGenericAdaptor::BlockDimYOpGenericAdaptor;
  BlockDimYOpAdaptor(BlockDimYOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockDimYOp : public ::mlir::Op<BlockDimYOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockDimYOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockDimYOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.workgroup.dim.y");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BlockDimYOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BlockDimZOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BlockDimZOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockDimZOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.workgroup.dim.z", odsAttrs.getContext());
  }

  BlockDimZOpGenericAdaptorBase(BlockDimZOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};
} // namespace detail
template <typename RangeT>
class BlockDimZOpGenericAdaptor : public detail::BlockDimZOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockDimZOpGenericAdaptorBase;
public:
  BlockDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockDimZOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockDimZOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockDimZOpGenericAdaptor(RangeT values, const BlockDimZOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockDimZOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockDimZOp>>>
  BlockDimZOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockDimZOpAdaptor : public BlockDimZOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockDimZOpGenericAdaptor::BlockDimZOpGenericAdaptor;
  BlockDimZOpAdaptor(BlockDimZOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockDimZOp : public ::mlir::Op<BlockDimZOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockDimZOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockDimZOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.workgroup.dim.z");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BlockDimZOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BlockIdXOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BlockIdXOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockIdXOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.workgroup.id.x", odsAttrs.getContext());
  }

  BlockIdXOpGenericAdaptorBase(BlockIdXOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};
} // namespace detail
template <typename RangeT>
class BlockIdXOpGenericAdaptor : public detail::BlockIdXOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockIdXOpGenericAdaptorBase;
public:
  BlockIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockIdXOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockIdXOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockIdXOpGenericAdaptor(RangeT values, const BlockIdXOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockIdXOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockIdXOp>>>
  BlockIdXOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockIdXOpAdaptor : public BlockIdXOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockIdXOpGenericAdaptor::BlockIdXOpGenericAdaptor;
  BlockIdXOpAdaptor(BlockIdXOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockIdXOp : public ::mlir::Op<BlockIdXOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockIdXOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockIdXOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.workgroup.id.x");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BlockIdXOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BlockIdYOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BlockIdYOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockIdYOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.workgroup.id.y", odsAttrs.getContext());
  }

  BlockIdYOpGenericAdaptorBase(BlockIdYOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};
} // namespace detail
template <typename RangeT>
class BlockIdYOpGenericAdaptor : public detail::BlockIdYOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockIdYOpGenericAdaptorBase;
public:
  BlockIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockIdYOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockIdYOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockIdYOpGenericAdaptor(RangeT values, const BlockIdYOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockIdYOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockIdYOp>>>
  BlockIdYOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockIdYOpAdaptor : public BlockIdYOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockIdYOpGenericAdaptor::BlockIdYOpGenericAdaptor;
  BlockIdYOpAdaptor(BlockIdYOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockIdYOp : public ::mlir::Op<BlockIdYOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockIdYOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockIdYOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.workgroup.id.y");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BlockIdYOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BlockIdZOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BlockIdZOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockIdZOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.workgroup.id.z", odsAttrs.getContext());
  }

  BlockIdZOpGenericAdaptorBase(BlockIdZOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};
} // namespace detail
template <typename RangeT>
class BlockIdZOpGenericAdaptor : public detail::BlockIdZOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockIdZOpGenericAdaptorBase;
public:
  BlockIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockIdZOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockIdZOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockIdZOpGenericAdaptor(RangeT values, const BlockIdZOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockIdZOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockIdZOp>>>
  BlockIdZOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockIdZOpAdaptor : public BlockIdZOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockIdZOpGenericAdaptor::BlockIdZOpGenericAdaptor;
  BlockIdZOpAdaptor(BlockIdZOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockIdZOp : public ::mlir::Op<BlockIdZOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockIdZOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockIdZOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.workgroup.id.z");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BlockIdZOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtF32Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtF32Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using byteSelTy = ::mlir::IntegerAttr;
    byteSelTy byteSel;

    auto getByteSel() const {
      auto &propStorage = this->byteSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setByteSel(const ::mlir::IntegerAttr &propValue) {
      this->byteSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.byteSel == this->byteSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtF32Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.f32.bf8", odsAttrs.getContext());
  }

  CvtF32Bf8OpGenericAdaptorBase(CvtF32Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getByteSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().byteSel);
    return attr;
  }

  uint32_t getByteSel();
};
} // namespace detail
template <typename RangeT>
class CvtF32Bf8OpGenericAdaptor : public detail::CvtF32Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtF32Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_srcA = 0;
public:
  CvtF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtF32Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtF32Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtF32Bf8OpGenericAdaptor(RangeT values, const CvtF32Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtF32Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtF32Bf8Op>>>
  CvtF32Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcA() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtF32Bf8OpAdaptor : public CvtF32Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtF32Bf8OpGenericAdaptor::CvtF32Bf8OpGenericAdaptor;
  CvtF32Bf8OpAdaptor(CvtF32Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtF32Bf8Op : public ::mlir::Op<CvtF32Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtF32Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtF32Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_srcA = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("byteSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getByteSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getByteSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.f32.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrcA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getByteSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().byteSel);
  }

  uint32_t getByteSel();
  void setByteSelAttr(::mlir::IntegerAttr attr) {
    getProperties().byteSel = attr;
  }

  void setByteSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, uint32_t byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, uint32_t byteSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtF32Bf8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtF32Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtF32Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using byteSelTy = ::mlir::IntegerAttr;
    byteSelTy byteSel;

    auto getByteSel() const {
      auto &propStorage = this->byteSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setByteSel(const ::mlir::IntegerAttr &propValue) {
      this->byteSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.byteSel == this->byteSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtF32Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.f32.fp8", odsAttrs.getContext());
  }

  CvtF32Fp8OpGenericAdaptorBase(CvtF32Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getByteSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().byteSel);
    return attr;
  }

  uint32_t getByteSel();
};
} // namespace detail
template <typename RangeT>
class CvtF32Fp8OpGenericAdaptor : public detail::CvtF32Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtF32Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_srcA = 0;
public:
  CvtF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtF32Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtF32Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtF32Fp8OpGenericAdaptor(RangeT values, const CvtF32Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtF32Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtF32Fp8Op>>>
  CvtF32Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcA() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtF32Fp8OpAdaptor : public CvtF32Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtF32Fp8OpGenericAdaptor::CvtF32Fp8OpGenericAdaptor;
  CvtF32Fp8OpAdaptor(CvtF32Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtF32Fp8Op : public ::mlir::Op<CvtF32Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtF32Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtF32Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_srcA = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("byteSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getByteSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getByteSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.f32.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrcA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getByteSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().byteSel);
  }

  uint32_t getByteSel();
  void setByteSelAttr(::mlir::IntegerAttr attr) {
    getProperties().byteSel = attr;
  }

  void setByteSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, uint32_t byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, uint32_t byteSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtF32Fp8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkBf8F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtPkBf8F32OpGenericAdaptorBase {
public:
  struct Properties {
    using wordSelTy = ::mlir::IntegerAttr;
    wordSelTy wordSel;

    auto getWordSel() const {
      auto &propStorage = this->wordSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setWordSel(const ::mlir::IntegerAttr &propValue) {
      this->wordSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.wordSel == this->wordSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkBf8F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.pk.bf8.f32", odsAttrs.getContext());
  }

  CvtPkBf8F32OpGenericAdaptorBase(CvtPkBf8F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getWordSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
    return attr;
  }

  bool getWordSel();
};
} // namespace detail
template <typename RangeT>
class CvtPkBf8F32OpGenericAdaptor : public detail::CvtPkBf8F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkBf8F32OpGenericAdaptorBase;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  static constexpr int odsIndex_old = 2;
public:
  CvtPkBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkBf8F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkBf8F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkBf8F32OpGenericAdaptor(RangeT values, const CvtPkBf8F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkBf8F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkBf8F32Op>>>
  CvtPkBf8F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOld() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkBf8F32OpAdaptor : public CvtPkBf8F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkBf8F32OpGenericAdaptor::CvtPkBf8F32OpGenericAdaptor;
  CvtPkBf8F32OpAdaptor(CvtPkBf8F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkBf8F32Op : public ::mlir::Op<CvtPkBf8F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkBf8F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkBf8F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  static constexpr int odsIndex_old = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("wordSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getWordSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getWordSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.pk.bf8.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOld() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrcAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOldMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getWordSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
  }

  bool getWordSel();
  void setWordSelAttr(::mlir::IntegerAttr attr) {
    getProperties().wordSel = attr;
  }

  void setWordSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkBf8F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkF32Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtPkF32Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using wordSelTy = ::mlir::IntegerAttr;
    wordSelTy wordSel;

    auto getWordSel() const {
      auto &propStorage = this->wordSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setWordSel(const ::mlir::IntegerAttr &propValue) {
      this->wordSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.wordSel == this->wordSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkF32Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.pk.f32.bf8", odsAttrs.getContext());
  }

  CvtPkF32Bf8OpGenericAdaptorBase(CvtPkF32Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getWordSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
    return attr;
  }

  bool getWordSel();
};
} // namespace detail
template <typename RangeT>
class CvtPkF32Bf8OpGenericAdaptor : public detail::CvtPkF32Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkF32Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
public:
  CvtPkF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkF32Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkF32Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkF32Bf8OpGenericAdaptor(RangeT values, const CvtPkF32Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkF32Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkF32Bf8Op>>>
  CvtPkF32Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkF32Bf8OpAdaptor : public CvtPkF32Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkF32Bf8OpGenericAdaptor::CvtPkF32Bf8OpGenericAdaptor;
  CvtPkF32Bf8OpAdaptor(CvtPkF32Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkF32Bf8Op : public ::mlir::Op<CvtPkF32Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkF32Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkF32Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("wordSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getWordSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getWordSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.pk.f32.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getWordSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
  }

  bool getWordSel();
  void setWordSelAttr(::mlir::IntegerAttr attr) {
    getProperties().wordSel = attr;
  }

  void setWordSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, bool wordSel);
  static CvtPkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, bool wordSel);
  static CvtPkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, bool wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool wordSel);
  static CvtPkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool wordSel);
  static CvtPkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool wordSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkF32Bf8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkF32Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtPkF32Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using wordSelTy = ::mlir::IntegerAttr;
    wordSelTy wordSel;

    auto getWordSel() const {
      auto &propStorage = this->wordSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setWordSel(const ::mlir::IntegerAttr &propValue) {
      this->wordSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.wordSel == this->wordSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkF32Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.pk.f32.fp8", odsAttrs.getContext());
  }

  CvtPkF32Fp8OpGenericAdaptorBase(CvtPkF32Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getWordSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
    return attr;
  }

  bool getWordSel();
};
} // namespace detail
template <typename RangeT>
class CvtPkF32Fp8OpGenericAdaptor : public detail::CvtPkF32Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkF32Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
public:
  CvtPkF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkF32Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkF32Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkF32Fp8OpGenericAdaptor(RangeT values, const CvtPkF32Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkF32Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkF32Fp8Op>>>
  CvtPkF32Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkF32Fp8OpAdaptor : public CvtPkF32Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkF32Fp8OpGenericAdaptor::CvtPkF32Fp8OpGenericAdaptor;
  CvtPkF32Fp8OpAdaptor(CvtPkF32Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkF32Fp8Op : public ::mlir::Op<CvtPkF32Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkF32Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkF32Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("wordSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getWordSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getWordSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.pk.f32.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getWordSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
  }

  bool getWordSel();
  void setWordSelAttr(::mlir::IntegerAttr attr) {
    getProperties().wordSel = attr;
  }

  void setWordSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, bool wordSel);
  static CvtPkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, bool wordSel);
  static CvtPkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, bool wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool wordSel);
  static CvtPkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool wordSel);
  static CvtPkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool wordSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkF32Fp8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkFp8F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtPkFp8F32OpGenericAdaptorBase {
public:
  struct Properties {
    using wordSelTy = ::mlir::IntegerAttr;
    wordSelTy wordSel;

    auto getWordSel() const {
      auto &propStorage = this->wordSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setWordSel(const ::mlir::IntegerAttr &propValue) {
      this->wordSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.wordSel == this->wordSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkFp8F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.pk.fp8.f32", odsAttrs.getContext());
  }

  CvtPkFp8F32OpGenericAdaptorBase(CvtPkFp8F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getWordSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
    return attr;
  }

  bool getWordSel();
};
} // namespace detail
template <typename RangeT>
class CvtPkFp8F32OpGenericAdaptor : public detail::CvtPkFp8F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkFp8F32OpGenericAdaptorBase;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  static constexpr int odsIndex_old = 2;
public:
  CvtPkFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkFp8F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkFp8F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkFp8F32OpGenericAdaptor(RangeT values, const CvtPkFp8F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkFp8F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkFp8F32Op>>>
  CvtPkFp8F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOld() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkFp8F32OpAdaptor : public CvtPkFp8F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkFp8F32OpGenericAdaptor::CvtPkFp8F32OpGenericAdaptor;
  CvtPkFp8F32OpAdaptor(CvtPkFp8F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkFp8F32Op : public ::mlir::Op<CvtPkFp8F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkFp8F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkFp8F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  static constexpr int odsIndex_old = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("wordSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getWordSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getWordSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.pk.fp8.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOld() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrcAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOldMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getWordSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
  }

  bool getWordSel();
  void setWordSelAttr(::mlir::IntegerAttr attr) {
    getProperties().wordSel = attr;
  }

  void setWordSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkFp8F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkRtz declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtPkRtzGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkRtzGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.pkrtz", odsAttrs.getContext());
  }

  CvtPkRtzGenericAdaptorBase(CvtPkRtz op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtPkRtzGenericAdaptor : public detail::CvtPkRtzGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkRtzGenericAdaptorBase;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
public:
  CvtPkRtzGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkRtzGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkRtzGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkRtzGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkRtzGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkRtzGenericAdaptor(RangeT values, const CvtPkRtzGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkRtz, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkRtz>>>
  CvtPkRtzGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcB() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkRtzAdaptor : public CvtPkRtzGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkRtzGenericAdaptor::CvtPkRtzGenericAdaptor;
  CvtPkRtzAdaptor(CvtPkRtz op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkRtz : public ::mlir::Op<CvtPkRtz, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkRtzAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkRtzGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.pkrtz");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB);
  static CvtPkRtz create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB);
  static CvtPkRtz create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB);
  static CvtPkRtz create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB);
  static CvtPkRtz create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkRtz create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkRtz create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkRtz create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkRtz create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkRtz)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF322xPk16Bf6F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF322xPk16Bf6F32OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF322xPk16Bf6F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.2xpk16.bf6.f32", odsAttrs.getContext());
  }

  CvtScaleF322xPk16Bf6F32OpGenericAdaptorBase(CvtScaleF322xPk16Bf6F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF322xPk16Bf6F32OpGenericAdaptor : public detail::CvtScaleF322xPk16Bf6F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF322xPk16Bf6F32OpGenericAdaptorBase;
  static constexpr int odsIndex_src0 = 0;
  static constexpr int odsIndex_src1 = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF322xPk16Bf6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF322xPk16Bf6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF322xPk16Bf6F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF322xPk16Bf6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF322xPk16Bf6F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF322xPk16Bf6F32OpGenericAdaptor(RangeT values, const CvtScaleF322xPk16Bf6F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF322xPk16Bf6F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF322xPk16Bf6F32Op>>>
  CvtScaleF322xPk16Bf6F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc0() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc1() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF322xPk16Bf6F32OpAdaptor : public CvtScaleF322xPk16Bf6F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF322xPk16Bf6F32OpGenericAdaptor::CvtScaleF322xPk16Bf6F32OpGenericAdaptor;
  CvtScaleF322xPk16Bf6F32OpAdaptor(CvtScaleF322xPk16Bf6F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF322xPk16Bf6F32Op : public ::mlir::Op<CvtScaleF322xPk16Bf6F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF322xPk16Bf6F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF322xPk16Bf6F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src0 = 0;
  static constexpr int odsIndex_src1 = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.2xpk16.bf6.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc1Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF322xPk16Bf6F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF322xPk16Fp6F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF322xPk16Fp6F32OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF322xPk16Fp6F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.2xpk16.fp6.f32", odsAttrs.getContext());
  }

  CvtScaleF322xPk16Fp6F32OpGenericAdaptorBase(CvtScaleF322xPk16Fp6F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF322xPk16Fp6F32OpGenericAdaptor : public detail::CvtScaleF322xPk16Fp6F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF322xPk16Fp6F32OpGenericAdaptorBase;
  static constexpr int odsIndex_src0 = 0;
  static constexpr int odsIndex_src1 = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF322xPk16Fp6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF322xPk16Fp6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF322xPk16Fp6F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF322xPk16Fp6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF322xPk16Fp6F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF322xPk16Fp6F32OpGenericAdaptor(RangeT values, const CvtScaleF322xPk16Fp6F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF322xPk16Fp6F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF322xPk16Fp6F32Op>>>
  CvtScaleF322xPk16Fp6F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc0() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc1() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF322xPk16Fp6F32OpAdaptor : public CvtScaleF322xPk16Fp6F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF322xPk16Fp6F32OpGenericAdaptor::CvtScaleF322xPk16Fp6F32OpGenericAdaptor;
  CvtScaleF322xPk16Fp6F32OpAdaptor(CvtScaleF322xPk16Fp6F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF322xPk16Fp6F32Op : public ::mlir::Op<CvtScaleF322xPk16Fp6F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF322xPk16Fp6F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF322xPk16Fp6F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src0 = 0;
  static constexpr int odsIndex_src1 = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.2xpk16.fp6.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc1Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF322xPk16Fp6F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32F16Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32F16Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using dstLoHiSelTy = ::mlir::IntegerAttr;
    dstLoHiSelTy dstLoHiSel;

    auto getDstLoHiSel() const {
      auto &propStorage = this->dstLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->dstLoHiSel = propValue;
    }
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstLoHiSel == this->dstLoHiSel &&
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32F16Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.f16.bf8", odsAttrs.getContext());
  }

  CvtScaleF32F16Bf8OpGenericAdaptorBase(CvtScaleF32F16Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
    return attr;
  }

  bool getDstLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32F16Bf8OpGenericAdaptor : public detail::CvtScaleF32F16Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32F16Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32F16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32F16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32F16Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32F16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32F16Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32F16Bf8OpGenericAdaptor(RangeT values, const CvtScaleF32F16Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32F16Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32F16Bf8Op>>>
  CvtScaleF32F16Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32F16Bf8OpAdaptor : public CvtScaleF32F16Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32F16Bf8OpGenericAdaptor::CvtScaleF32F16Bf8OpGenericAdaptor;
  CvtScaleF32F16Bf8OpAdaptor(CvtScaleF32F16Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32F16Bf8Op : public ::mlir::Op<CvtScaleF32F16Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32F16Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32F16Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstLoHiSel"), ::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.f16.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
  }

  bool getDstLoHiSel();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  void setDstLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().dstLoHiSel = attr;
  }

  void setDstLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32F16Bf8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32F16Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32F16Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using dstLoHiSelTy = ::mlir::IntegerAttr;
    dstLoHiSelTy dstLoHiSel;

    auto getDstLoHiSel() const {
      auto &propStorage = this->dstLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->dstLoHiSel = propValue;
    }
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstLoHiSel == this->dstLoHiSel &&
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32F16Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.f16.fp8", odsAttrs.getContext());
  }

  CvtScaleF32F16Fp8OpGenericAdaptorBase(CvtScaleF32F16Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
    return attr;
  }

  bool getDstLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32F16Fp8OpGenericAdaptor : public detail::CvtScaleF32F16Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32F16Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32F16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32F16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32F16Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32F16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32F16Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32F16Fp8OpGenericAdaptor(RangeT values, const CvtScaleF32F16Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32F16Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32F16Fp8Op>>>
  CvtScaleF32F16Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32F16Fp8OpAdaptor : public CvtScaleF32F16Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32F16Fp8OpGenericAdaptor::CvtScaleF32F16Fp8OpGenericAdaptor;
  CvtScaleF32F16Fp8OpAdaptor(CvtScaleF32F16Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32F16Fp8Op : public ::mlir::Op<CvtScaleF32F16Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32F16Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32F16Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstLoHiSel"), ::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.f16.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
  }

  bool getDstLoHiSel();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  void setDstLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().dstLoHiSel = attr;
  }

  void setDstLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32F16Fp8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32F32Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32F32Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32F32Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.f32.bf8", odsAttrs.getContext());
  }

  CvtScaleF32F32Bf8OpGenericAdaptorBase(CvtScaleF32F32Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32F32Bf8OpGenericAdaptor : public detail::CvtScaleF32F32Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32F32Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32F32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32F32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32F32Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32F32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32F32Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32F32Bf8OpGenericAdaptor(RangeT values, const CvtScaleF32F32Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32F32Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32F32Bf8Op>>>
  CvtScaleF32F32Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32F32Bf8OpAdaptor : public CvtScaleF32F32Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32F32Bf8OpGenericAdaptor::CvtScaleF32F32Bf8OpGenericAdaptor;
  CvtScaleF32F32Bf8OpAdaptor(CvtScaleF32F32Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32F32Bf8Op : public ::mlir::Op<CvtScaleF32F32Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::FloatType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32F32Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32F32Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.f32.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32F32Bf8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32F32Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32F32Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32F32Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.f32.fp8", odsAttrs.getContext());
  }

  CvtScaleF32F32Fp8OpGenericAdaptorBase(CvtScaleF32F32Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32F32Fp8OpGenericAdaptor : public detail::CvtScaleF32F32Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32F32Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32F32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32F32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32F32Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32F32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32F32Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32F32Fp8OpGenericAdaptor(RangeT values, const CvtScaleF32F32Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32F32Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32F32Fp8Op>>>
  CvtScaleF32F32Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32F32Fp8OpAdaptor : public CvtScaleF32F32Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32F32Fp8OpGenericAdaptor::CvtScaleF32F32Fp8OpGenericAdaptor;
  CvtScaleF32F32Fp8OpAdaptor(CvtScaleF32F32Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32F32Fp8Op : public ::mlir::Op<CvtScaleF32F32Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::FloatType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32F32Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32F32Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.f32.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32F32Fp8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32Bf16Bf6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32Pk32Bf16Bf6OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.bf16.bf6", odsAttrs.getContext());
  }

  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptorBase(CvtScaleF32Pk32Bf16Bf6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor : public detail::CvtScaleF32Pk32Bf16Bf6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32Bf16Bf6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32Bf16Bf6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32Bf16Bf6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32Bf16Bf6Op>>>
  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32Bf16Bf6OpAdaptor : public CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor::CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor;
  CvtScaleF32Pk32Bf16Bf6OpAdaptor(CvtScaleF32Pk32Bf16Bf6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32Bf16Bf6Op : public ::mlir::Op<CvtScaleF32Pk32Bf16Bf6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32Bf16Bf6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.bf16.bf6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32Bf16Bf6Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32Bf16Fp6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32Pk32Bf16Fp6OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.bf16.fp6", odsAttrs.getContext());
  }

  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptorBase(CvtScaleF32Pk32Bf16Fp6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor : public detail::CvtScaleF32Pk32Bf16Fp6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32Bf16Fp6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32Bf16Fp6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32Bf16Fp6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32Bf16Fp6Op>>>
  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32Bf16Fp6OpAdaptor : public CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor::CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor;
  CvtScaleF32Pk32Bf16Fp6OpAdaptor(CvtScaleF32Pk32Bf16Fp6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32Bf16Fp6Op : public ::mlir::Op<CvtScaleF32Pk32Bf16Fp6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32Bf16Fp6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.bf16.fp6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32Bf16Fp6Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32Bf6Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32Pk32Bf6Bf16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.bf6.bf16", odsAttrs.getContext());
  }

  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptorBase(CvtScaleF32Pk32Bf6Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor : public detail::CvtScaleF32Pk32Bf6Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32Bf6Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32Bf6Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32Bf6Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32Bf6Bf16Op>>>
  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32Bf6Bf16OpAdaptor : public CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor::CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor;
  CvtScaleF32Pk32Bf6Bf16OpAdaptor(CvtScaleF32Pk32Bf6Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32Bf6Bf16Op : public ::mlir::Op<CvtScaleF32Pk32Bf6Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32Bf6Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.bf6.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32Bf6Bf16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32Bf6F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32Pk32Bf6F16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32Bf6F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.bf6.f16", odsAttrs.getContext());
  }

  CvtScaleF32Pk32Bf6F16OpGenericAdaptorBase(CvtScaleF32Pk32Bf6F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32Bf6F16OpGenericAdaptor : public detail::CvtScaleF32Pk32Bf6F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32Bf6F16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32Bf6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32Bf6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32Bf6F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32Bf6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32Bf6F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32Bf6F16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32Bf6F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32Bf6F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32Bf6F16Op>>>
  CvtScaleF32Pk32Bf6F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32Bf6F16OpAdaptor : public CvtScaleF32Pk32Bf6F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32Bf6F16OpGenericAdaptor::CvtScaleF32Pk32Bf6F16OpGenericAdaptor;
  CvtScaleF32Pk32Bf6F16OpAdaptor(CvtScaleF32Pk32Bf6F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32Bf6F16Op : public ::mlir::Op<CvtScaleF32Pk32Bf6F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32Bf6F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32Bf6F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.bf6.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32Bf6F16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32F16Bf6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32Pk32F16Bf6OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32F16Bf6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.f16.bf6", odsAttrs.getContext());
  }

  CvtScaleF32Pk32F16Bf6OpGenericAdaptorBase(CvtScaleF32Pk32F16Bf6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32F16Bf6OpGenericAdaptor : public detail::CvtScaleF32Pk32F16Bf6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32F16Bf6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32F16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32F16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32F16Bf6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32F16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32F16Bf6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32F16Bf6OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32F16Bf6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32F16Bf6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32F16Bf6Op>>>
  CvtScaleF32Pk32F16Bf6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32F16Bf6OpAdaptor : public CvtScaleF32Pk32F16Bf6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32F16Bf6OpGenericAdaptor::CvtScaleF32Pk32F16Bf6OpGenericAdaptor;
  CvtScaleF32Pk32F16Bf6OpAdaptor(CvtScaleF32Pk32F16Bf6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32F16Bf6Op : public ::mlir::Op<CvtScaleF32Pk32F16Bf6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32F16Bf6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32F16Bf6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.f16.bf6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32F16Bf6Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32F16Fp6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32Pk32F16Fp6OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32F16Fp6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.f16.fp6", odsAttrs.getContext());
  }

  CvtScaleF32Pk32F16Fp6OpGenericAdaptorBase(CvtScaleF32Pk32F16Fp6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32F16Fp6OpGenericAdaptor : public detail::CvtScaleF32Pk32F16Fp6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32F16Fp6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32F16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32F16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32F16Fp6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32F16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32F16Fp6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32F16Fp6OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32F16Fp6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32F16Fp6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32F16Fp6Op>>>
  CvtScaleF32Pk32F16Fp6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32F16Fp6OpAdaptor : public CvtScaleF32Pk32F16Fp6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32F16Fp6OpGenericAdaptor::CvtScaleF32Pk32F16Fp6OpGenericAdaptor;
  CvtScaleF32Pk32F16Fp6OpAdaptor(CvtScaleF32Pk32F16Fp6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32F16Fp6Op : public ::mlir::Op<CvtScaleF32Pk32F16Fp6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32F16Fp6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32F16Fp6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.f16.fp6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32F16Fp6Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32F32Bf6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32Pk32F32Bf6OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32F32Bf6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.f32.bf6", odsAttrs.getContext());
  }

  CvtScaleF32Pk32F32Bf6OpGenericAdaptorBase(CvtScaleF32Pk32F32Bf6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32F32Bf6OpGenericAdaptor : public detail::CvtScaleF32Pk32F32Bf6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32F32Bf6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32F32Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32F32Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32F32Bf6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32F32Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32F32Bf6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32F32Bf6OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32F32Bf6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32F32Bf6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32F32Bf6Op>>>
  CvtScaleF32Pk32F32Bf6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32F32Bf6OpAdaptor : public CvtScaleF32Pk32F32Bf6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32F32Bf6OpGenericAdaptor::CvtScaleF32Pk32F32Bf6OpGenericAdaptor;
  CvtScaleF32Pk32F32Bf6OpAdaptor(CvtScaleF32Pk32F32Bf6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32F32Bf6Op : public ::mlir::Op<CvtScaleF32Pk32F32Bf6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32F32Bf6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32F32Bf6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.f32.bf6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32F32Bf6Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32F32Fp6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32Pk32F32Fp6OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32F32Fp6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.f32.fp6", odsAttrs.getContext());
  }

  CvtScaleF32Pk32F32Fp6OpGenericAdaptorBase(CvtScaleF32Pk32F32Fp6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32F32Fp6OpGenericAdaptor : public detail::CvtScaleF32Pk32F32Fp6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32F32Fp6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32F32Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32F32Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32F32Fp6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32F32Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32F32Fp6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32F32Fp6OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32F32Fp6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32F32Fp6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32F32Fp6Op>>>
  CvtScaleF32Pk32F32Fp6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32F32Fp6OpAdaptor : public CvtScaleF32Pk32F32Fp6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32F32Fp6OpGenericAdaptor::CvtScaleF32Pk32F32Fp6OpGenericAdaptor;
  CvtScaleF32Pk32F32Fp6OpAdaptor(CvtScaleF32Pk32F32Fp6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32F32Fp6Op : public ::mlir::Op<CvtScaleF32Pk32F32Fp6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32F32Fp6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32F32Fp6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.f32.fp6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32F32Fp6Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32Fp6Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32Pk32Fp6Bf16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.fp6.bf16", odsAttrs.getContext());
  }

  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptorBase(CvtScaleF32Pk32Fp6Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor : public detail::CvtScaleF32Pk32Fp6Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32Fp6Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32Fp6Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32Fp6Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32Fp6Bf16Op>>>
  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32Fp6Bf16OpAdaptor : public CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor::CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor;
  CvtScaleF32Pk32Fp6Bf16OpAdaptor(CvtScaleF32Pk32Fp6Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32Fp6Bf16Op : public ::mlir::Op<CvtScaleF32Pk32Fp6Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32Fp6Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.fp6.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32Fp6Bf16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32Fp6F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32Pk32Fp6F16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32Fp6F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.fp6.f16", odsAttrs.getContext());
  }

  CvtScaleF32Pk32Fp6F16OpGenericAdaptorBase(CvtScaleF32Pk32Fp6F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32Fp6F16OpGenericAdaptor : public detail::CvtScaleF32Pk32Fp6F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32Fp6F16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32Fp6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32Fp6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32Fp6F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32Fp6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32Fp6F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32Fp6F16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32Fp6F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32Fp6F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32Fp6F16Op>>>
  CvtScaleF32Pk32Fp6F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32Fp6F16OpAdaptor : public CvtScaleF32Pk32Fp6F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32Fp6F16OpGenericAdaptor::CvtScaleF32Pk32Fp6F16OpGenericAdaptor;
  CvtScaleF32Pk32Fp6F16OpAdaptor(CvtScaleF32Pk32Fp6F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32Fp6F16Op : public ::mlir::Op<CvtScaleF32Pk32Fp6F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32Fp6F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32Fp6F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.fp6.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32Fp6F16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkBf16Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkBf16Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcLoHiSelTy = ::mlir::IntegerAttr;
    srcLoHiSelTy srcLoHiSel;

    auto getSrcLoHiSel() const {
      auto &propStorage = this->srcLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->srcLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcLoHiSel == this->srcLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkBf16Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.bf16.bf8", odsAttrs.getContext());
  }

  CvtScaleF32PkBf16Bf8OpGenericAdaptorBase(CvtScaleF32PkBf16Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
    return attr;
  }

  bool getSrcLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkBf16Bf8OpGenericAdaptor : public detail::CvtScaleF32PkBf16Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkBf16Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkBf16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkBf16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkBf16Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkBf16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkBf16Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkBf16Bf8OpGenericAdaptor(RangeT values, const CvtScaleF32PkBf16Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkBf16Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkBf16Bf8Op>>>
  CvtScaleF32PkBf16Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkBf16Bf8OpAdaptor : public CvtScaleF32PkBf16Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkBf16Bf8OpGenericAdaptor::CvtScaleF32PkBf16Bf8OpGenericAdaptor;
  CvtScaleF32PkBf16Bf8OpAdaptor(CvtScaleF32PkBf16Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkBf16Bf8Op : public ::mlir::Op<CvtScaleF32PkBf16Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkBf16Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkBf16Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.bf16.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
  }

  bool getSrcLoHiSel();
  void setSrcLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().srcLoHiSel = attr;
  }

  void setSrcLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkBf16Bf8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkBf16Fp4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkBf16Fp4OpGenericAdaptorBase {
public:
  struct Properties {
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkBf16Fp4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.bf16.fp4", odsAttrs.getContext());
  }

  CvtScaleF32PkBf16Fp4OpGenericAdaptorBase(CvtScaleF32PkBf16Fp4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkBf16Fp4OpGenericAdaptor : public detail::CvtScaleF32PkBf16Fp4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkBf16Fp4OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkBf16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkBf16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkBf16Fp4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkBf16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkBf16Fp4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkBf16Fp4OpGenericAdaptor(RangeT values, const CvtScaleF32PkBf16Fp4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkBf16Fp4Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkBf16Fp4Op>>>
  CvtScaleF32PkBf16Fp4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkBf16Fp4OpAdaptor : public CvtScaleF32PkBf16Fp4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkBf16Fp4OpGenericAdaptor::CvtScaleF32PkBf16Fp4OpGenericAdaptor;
  CvtScaleF32PkBf16Fp4OpAdaptor(CvtScaleF32PkBf16Fp4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkBf16Fp4Op : public ::mlir::Op<CvtScaleF32PkBf16Fp4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkBf16Fp4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkBf16Fp4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.bf16.fp4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkBf16Fp4Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkBf16Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkBf16Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcLoHiSelTy = ::mlir::IntegerAttr;
    srcLoHiSelTy srcLoHiSel;

    auto getSrcLoHiSel() const {
      auto &propStorage = this->srcLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->srcLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcLoHiSel == this->srcLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkBf16Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.bf16.fp8", odsAttrs.getContext());
  }

  CvtScaleF32PkBf16Fp8OpGenericAdaptorBase(CvtScaleF32PkBf16Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
    return attr;
  }

  bool getSrcLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkBf16Fp8OpGenericAdaptor : public detail::CvtScaleF32PkBf16Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkBf16Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkBf16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkBf16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkBf16Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkBf16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkBf16Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkBf16Fp8OpGenericAdaptor(RangeT values, const CvtScaleF32PkBf16Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkBf16Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkBf16Fp8Op>>>
  CvtScaleF32PkBf16Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkBf16Fp8OpAdaptor : public CvtScaleF32PkBf16Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkBf16Fp8OpGenericAdaptor::CvtScaleF32PkBf16Fp8OpGenericAdaptor;
  CvtScaleF32PkBf16Fp8OpAdaptor(CvtScaleF32PkBf16Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkBf16Fp8Op : public ::mlir::Op<CvtScaleF32PkBf16Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkBf16Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkBf16Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.bf16.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
  }

  bool getSrcLoHiSel();
  void setSrcLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().srcLoHiSel = attr;
  }

  void setSrcLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkBf16Fp8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkBf8Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkBf8Bf16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstLoHiSelTy = ::mlir::IntegerAttr;
    dstLoHiSelTy dstLoHiSel;

    auto getDstLoHiSel() const {
      auto &propStorage = this->dstLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->dstLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstLoHiSel == this->dstLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkBf8Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.bf8.bf16", odsAttrs.getContext());
  }

  CvtScaleF32PkBf8Bf16OpGenericAdaptorBase(CvtScaleF32PkBf8Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
    return attr;
  }

  bool getDstLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkBf8Bf16OpGenericAdaptor : public detail::CvtScaleF32PkBf8Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkBf8Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32PkBf8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkBf8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkBf8Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkBf8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkBf8Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkBf8Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32PkBf8Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkBf8Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkBf8Bf16Op>>>
  CvtScaleF32PkBf8Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkBf8Bf16OpAdaptor : public CvtScaleF32PkBf8Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkBf8Bf16OpGenericAdaptor::CvtScaleF32PkBf8Bf16OpGenericAdaptor;
  CvtScaleF32PkBf8Bf16OpAdaptor(CvtScaleF32PkBf8Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkBf8Bf16Op : public ::mlir::Op<CvtScaleF32PkBf8Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkBf8Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkBf8Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.bf8.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
  }

  bool getDstLoHiSel();
  void setDstLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().dstLoHiSel = attr;
  }

  void setDstLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkBf8Bf16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkBf8F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkBf8F16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstLoHiSelTy = ::mlir::IntegerAttr;
    dstLoHiSelTy dstLoHiSel;

    auto getDstLoHiSel() const {
      auto &propStorage = this->dstLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->dstLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstLoHiSel == this->dstLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkBf8F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.bf8.f16", odsAttrs.getContext());
  }

  CvtScaleF32PkBf8F16OpGenericAdaptorBase(CvtScaleF32PkBf8F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
    return attr;
  }

  bool getDstLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkBf8F16OpGenericAdaptor : public detail::CvtScaleF32PkBf8F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkBf8F16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32PkBf8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkBf8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkBf8F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkBf8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkBf8F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkBf8F16OpGenericAdaptor(RangeT values, const CvtScaleF32PkBf8F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkBf8F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkBf8F16Op>>>
  CvtScaleF32PkBf8F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkBf8F16OpAdaptor : public CvtScaleF32PkBf8F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkBf8F16OpGenericAdaptor::CvtScaleF32PkBf8F16OpGenericAdaptor;
  CvtScaleF32PkBf8F16OpAdaptor(CvtScaleF32PkBf8F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkBf8F16Op : public ::mlir::Op<CvtScaleF32PkBf8F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkBf8F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkBf8F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.bf8.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
  }

  bool getDstLoHiSel();
  void setDstLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().dstLoHiSel = attr;
  }

  void setDstLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkBf8F16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkBf8F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkBf8F32OpGenericAdaptorBase {
public:
  struct Properties {
    using dstLoHiSelTy = ::mlir::IntegerAttr;
    dstLoHiSelTy dstLoHiSel;

    auto getDstLoHiSel() const {
      auto &propStorage = this->dstLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->dstLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstLoHiSel == this->dstLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkBf8F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.bf8.f32", odsAttrs.getContext());
  }

  CvtScaleF32PkBf8F32OpGenericAdaptorBase(CvtScaleF32PkBf8F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
    return attr;
  }

  bool getDstLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkBf8F32OpGenericAdaptor : public detail::CvtScaleF32PkBf8F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkBf8F32OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_src1 = 2;
  static constexpr int odsIndex_scale = 3;
public:
  CvtScaleF32PkBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkBf8F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkBf8F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkBf8F32OpGenericAdaptor(RangeT values, const CvtScaleF32PkBf8F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkBf8F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkBf8F32Op>>>
  CvtScaleF32PkBf8F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSrc1() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkBf8F32OpAdaptor : public CvtScaleF32PkBf8F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkBf8F32OpGenericAdaptor::CvtScaleF32PkBf8F32OpGenericAdaptor;
  CvtScaleF32PkBf8F32OpAdaptor(CvtScaleF32PkBf8F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkBf8F32Op : public ::mlir::Op<CvtScaleF32PkBf8F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkBf8F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkBf8F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_src1 = 2;
  static constexpr int odsIndex_scale = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.bf8.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrc1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc1Mutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
  }

  bool getDstLoHiSel();
  void setDstLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().dstLoHiSel = attr;
  }

  void setDstLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkBf8F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkF16Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkF16Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcLoHiSelTy = ::mlir::IntegerAttr;
    srcLoHiSelTy srcLoHiSel;

    auto getSrcLoHiSel() const {
      auto &propStorage = this->srcLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->srcLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcLoHiSel == this->srcLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkF16Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.f16.bf8", odsAttrs.getContext());
  }

  CvtScaleF32PkF16Bf8OpGenericAdaptorBase(CvtScaleF32PkF16Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
    return attr;
  }

  bool getSrcLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkF16Bf8OpGenericAdaptor : public detail::CvtScaleF32PkF16Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkF16Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkF16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkF16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkF16Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkF16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkF16Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkF16Bf8OpGenericAdaptor(RangeT values, const CvtScaleF32PkF16Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkF16Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkF16Bf8Op>>>
  CvtScaleF32PkF16Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkF16Bf8OpAdaptor : public CvtScaleF32PkF16Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkF16Bf8OpGenericAdaptor::CvtScaleF32PkF16Bf8OpGenericAdaptor;
  CvtScaleF32PkF16Bf8OpAdaptor(CvtScaleF32PkF16Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkF16Bf8Op : public ::mlir::Op<CvtScaleF32PkF16Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkF16Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkF16Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.f16.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
  }

  bool getSrcLoHiSel();
  void setSrcLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().srcLoHiSel = attr;
  }

  void setSrcLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkF16Bf8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkF16Fp4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkF16Fp4OpGenericAdaptorBase {
public:
  struct Properties {
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkF16Fp4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.f16.fp4", odsAttrs.getContext());
  }

  CvtScaleF32PkF16Fp4OpGenericAdaptorBase(CvtScaleF32PkF16Fp4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkF16Fp4OpGenericAdaptor : public detail::CvtScaleF32PkF16Fp4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkF16Fp4OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkF16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkF16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkF16Fp4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkF16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkF16Fp4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkF16Fp4OpGenericAdaptor(RangeT values, const CvtScaleF32PkF16Fp4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkF16Fp4Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkF16Fp4Op>>>
  CvtScaleF32PkF16Fp4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkF16Fp4OpAdaptor : public CvtScaleF32PkF16Fp4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkF16Fp4OpGenericAdaptor::CvtScaleF32PkF16Fp4OpGenericAdaptor;
  CvtScaleF32PkF16Fp4OpAdaptor(CvtScaleF32PkF16Fp4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkF16Fp4Op : public ::mlir::Op<CvtScaleF32PkF16Fp4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkF16Fp4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkF16Fp4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.f16.fp4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkF16Fp4Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkF16Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkF16Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcLoHiSelTy = ::mlir::IntegerAttr;
    srcLoHiSelTy srcLoHiSel;

    auto getSrcLoHiSel() const {
      auto &propStorage = this->srcLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->srcLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcLoHiSel == this->srcLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkF16Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.f16.fp8", odsAttrs.getContext());
  }

  CvtScaleF32PkF16Fp8OpGenericAdaptorBase(CvtScaleF32PkF16Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
    return attr;
  }

  bool getSrcLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkF16Fp8OpGenericAdaptor : public detail::CvtScaleF32PkF16Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkF16Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkF16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkF16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkF16Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkF16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkF16Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkF16Fp8OpGenericAdaptor(RangeT values, const CvtScaleF32PkF16Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkF16Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkF16Fp8Op>>>
  CvtScaleF32PkF16Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkF16Fp8OpAdaptor : public CvtScaleF32PkF16Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkF16Fp8OpGenericAdaptor::CvtScaleF32PkF16Fp8OpGenericAdaptor;
  CvtScaleF32PkF16Fp8OpAdaptor(CvtScaleF32PkF16Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkF16Fp8Op : public ::mlir::Op<CvtScaleF32PkF16Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkF16Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkF16Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.f16.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
  }

  bool getSrcLoHiSel();
  void setSrcLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().srcLoHiSel = attr;
  }

  void setSrcLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkF16Fp8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkF32Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkF32Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcLoHiSelTy = ::mlir::IntegerAttr;
    srcLoHiSelTy srcLoHiSel;

    auto getSrcLoHiSel() const {
      auto &propStorage = this->srcLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->srcLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcLoHiSel == this->srcLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkF32Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.f32.bf8", odsAttrs.getContext());
  }

  CvtScaleF32PkF32Bf8OpGenericAdaptorBase(CvtScaleF32PkF32Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
    return attr;
  }

  bool getSrcLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkF32Bf8OpGenericAdaptor : public detail::CvtScaleF32PkF32Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkF32Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkF32Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkF32Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkF32Bf8OpGenericAdaptor(RangeT values, const CvtScaleF32PkF32Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkF32Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkF32Bf8Op>>>
  CvtScaleF32PkF32Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkF32Bf8OpAdaptor : public CvtScaleF32PkF32Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkF32Bf8OpGenericAdaptor::CvtScaleF32PkF32Bf8OpGenericAdaptor;
  CvtScaleF32PkF32Bf8OpAdaptor(CvtScaleF32PkF32Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkF32Bf8Op : public ::mlir::Op<CvtScaleF32PkF32Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkF32Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkF32Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.f32.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
  }

  bool getSrcLoHiSel();
  void setSrcLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().srcLoHiSel = attr;
  }

  void setSrcLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkF32Bf8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkF32Fp4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkF32Fp4OpGenericAdaptorBase {
public:
  struct Properties {
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkF32Fp4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.f32.fp4", odsAttrs.getContext());
  }

  CvtScaleF32PkF32Fp4OpGenericAdaptorBase(CvtScaleF32PkF32Fp4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkF32Fp4OpGenericAdaptor : public detail::CvtScaleF32PkF32Fp4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkF32Fp4OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkF32Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkF32Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkF32Fp4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkF32Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkF32Fp4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkF32Fp4OpGenericAdaptor(RangeT values, const CvtScaleF32PkF32Fp4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkF32Fp4Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkF32Fp4Op>>>
  CvtScaleF32PkF32Fp4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkF32Fp4OpAdaptor : public CvtScaleF32PkF32Fp4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkF32Fp4OpGenericAdaptor::CvtScaleF32PkF32Fp4OpGenericAdaptor;
  CvtScaleF32PkF32Fp4OpAdaptor(CvtScaleF32PkF32Fp4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkF32Fp4Op : public ::mlir::Op<CvtScaleF32PkF32Fp4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkF32Fp4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkF32Fp4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.f32.fp4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkF32Fp4Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkF32Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkF32Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcLoHiSelTy = ::mlir::IntegerAttr;
    srcLoHiSelTy srcLoHiSel;

    auto getSrcLoHiSel() const {
      auto &propStorage = this->srcLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->srcLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcLoHiSel == this->srcLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkF32Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.f32.fp8", odsAttrs.getContext());
  }

  CvtScaleF32PkF32Fp8OpGenericAdaptorBase(CvtScaleF32PkF32Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
    return attr;
  }

  bool getSrcLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkF32Fp8OpGenericAdaptor : public detail::CvtScaleF32PkF32Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkF32Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkF32Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkF32Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkF32Fp8OpGenericAdaptor(RangeT values, const CvtScaleF32PkF32Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkF32Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkF32Fp8Op>>>
  CvtScaleF32PkF32Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkF32Fp8OpAdaptor : public CvtScaleF32PkF32Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkF32Fp8OpGenericAdaptor::CvtScaleF32PkF32Fp8OpGenericAdaptor;
  CvtScaleF32PkF32Fp8OpAdaptor(CvtScaleF32PkF32Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkF32Fp8Op : public ::mlir::Op<CvtScaleF32PkF32Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkF32Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkF32Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.f32.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
  }

  bool getSrcLoHiSel();
  void setSrcLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().srcLoHiSel = attr;
  }

  void setSrcLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkF32Fp8Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkFp4Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkFp4Bf16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstSelIndexTy = ::mlir::IntegerAttr;
    dstSelIndexTy dstSelIndex;

    auto getDstSelIndex() const {
      auto &propStorage = this->dstSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->dstSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstSelIndex == this->dstSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkFp4Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.fp4.bf16", odsAttrs.getContext());
  }

  CvtScaleF32PkFp4Bf16OpGenericAdaptorBase(CvtScaleF32PkFp4Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
    return attr;
  }

  uint32_t getDstSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkFp4Bf16OpGenericAdaptor : public detail::CvtScaleF32PkFp4Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkFp4Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32PkFp4Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkFp4Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkFp4Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkFp4Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkFp4Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkFp4Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32PkFp4Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkFp4Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkFp4Bf16Op>>>
  CvtScaleF32PkFp4Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkFp4Bf16OpAdaptor : public CvtScaleF32PkFp4Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkFp4Bf16OpGenericAdaptor::CvtScaleF32PkFp4Bf16OpGenericAdaptor;
  CvtScaleF32PkFp4Bf16OpAdaptor(CvtScaleF32PkFp4Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkFp4Bf16Op : public ::mlir::Op<CvtScaleF32PkFp4Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkFp4Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkFp4Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.fp4.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
  }

  uint32_t getDstSelIndex();
  void setDstSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().dstSelIndex = attr;
  }

  void setDstSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32PkFp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32PkFp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32PkFp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32PkFp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32PkFp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32PkFp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32PkFp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32PkFp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkFp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkFp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkFp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkFp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkFp4Bf16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkFp4F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkFp4F16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstSelIndexTy = ::mlir::IntegerAttr;
    dstSelIndexTy dstSelIndex;

    auto getDstSelIndex() const {
      auto &propStorage = this->dstSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->dstSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstSelIndex == this->dstSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkFp4F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.fp4.f16", odsAttrs.getContext());
  }

  CvtScaleF32PkFp4F16OpGenericAdaptorBase(CvtScaleF32PkFp4F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
    return attr;
  }

  uint32_t getDstSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkFp4F16OpGenericAdaptor : public detail::CvtScaleF32PkFp4F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkFp4F16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32PkFp4F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkFp4F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkFp4F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkFp4F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkFp4F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkFp4F16OpGenericAdaptor(RangeT values, const CvtScaleF32PkFp4F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkFp4F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkFp4F16Op>>>
  CvtScaleF32PkFp4F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkFp4F16OpAdaptor : public CvtScaleF32PkFp4F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkFp4F16OpGenericAdaptor::CvtScaleF32PkFp4F16OpGenericAdaptor;
  CvtScaleF32PkFp4F16OpAdaptor(CvtScaleF32PkFp4F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkFp4F16Op : public ::mlir::Op<CvtScaleF32PkFp4F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkFp4F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkFp4F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.fp4.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
  }

  uint32_t getDstSelIndex();
  void setDstSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().dstSelIndex = attr;
  }

  void setDstSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32PkFp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32PkFp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32PkFp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32PkFp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32PkFp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32PkFp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32PkFp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32PkFp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkFp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkFp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkFp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkFp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkFp4F16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkFp4F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkFp4F32OpGenericAdaptorBase {
public:
  struct Properties {
    using dstSelIndexTy = ::mlir::IntegerAttr;
    dstSelIndexTy dstSelIndex;

    auto getDstSelIndex() const {
      auto &propStorage = this->dstSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->dstSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstSelIndex == this->dstSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkFp4F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.fp4.f32", odsAttrs.getContext());
  }

  CvtScaleF32PkFp4F32OpGenericAdaptorBase(CvtScaleF32PkFp4F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
    return attr;
  }

  uint32_t getDstSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkFp4F32OpGenericAdaptor : public detail::CvtScaleF32PkFp4F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkFp4F32OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_src1 = 2;
  static constexpr int odsIndex_scale = 3;
public:
  CvtScaleF32PkFp4F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkFp4F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkFp4F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkFp4F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkFp4F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkFp4F32OpGenericAdaptor(RangeT values, const CvtScaleF32PkFp4F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkFp4F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkFp4F32Op>>>
  CvtScaleF32PkFp4F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSrc1() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkFp4F32OpAdaptor : public CvtScaleF32PkFp4F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkFp4F32OpGenericAdaptor::CvtScaleF32PkFp4F32OpGenericAdaptor;
  CvtScaleF32PkFp4F32OpAdaptor(CvtScaleF32PkFp4F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkFp4F32Op : public ::mlir::Op<CvtScaleF32PkFp4F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkFp4F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkFp4F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_src1 = 2;
  static constexpr int odsIndex_scale = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.fp4.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrc1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc1Mutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
  }

  uint32_t getDstSelIndex();
  void setDstSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().dstSelIndex = attr;
  }

  void setDstSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32PkFp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32PkFp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32PkFp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32PkFp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32PkFp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32PkFp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32PkFp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32PkFp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkFp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkFp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkFp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkFp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkFp4F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkFp8Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkFp8Bf16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstLoHiSelTy = ::mlir::IntegerAttr;
    dstLoHiSelTy dstLoHiSel;

    auto getDstLoHiSel() const {
      auto &propStorage = this->dstLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->dstLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstLoHiSel == this->dstLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkFp8Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.fp8.bf16", odsAttrs.getContext());
  }

  CvtScaleF32PkFp8Bf16OpGenericAdaptorBase(CvtScaleF32PkFp8Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
    return attr;
  }

  bool getDstLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkFp8Bf16OpGenericAdaptor : public detail::CvtScaleF32PkFp8Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkFp8Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32PkFp8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkFp8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkFp8Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkFp8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkFp8Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkFp8Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32PkFp8Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkFp8Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkFp8Bf16Op>>>
  CvtScaleF32PkFp8Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkFp8Bf16OpAdaptor : public CvtScaleF32PkFp8Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkFp8Bf16OpGenericAdaptor::CvtScaleF32PkFp8Bf16OpGenericAdaptor;
  CvtScaleF32PkFp8Bf16OpAdaptor(CvtScaleF32PkFp8Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkFp8Bf16Op : public ::mlir::Op<CvtScaleF32PkFp8Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkFp8Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkFp8Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.fp8.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
  }

  bool getDstLoHiSel();
  void setDstLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().dstLoHiSel = attr;
  }

  void setDstLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkFp8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkFp8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkFp8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkFp8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkFp8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkFp8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkFp8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkFp8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkFp8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkFp8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkFp8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkFp8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkFp8Bf16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkFp8F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkFp8F16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstLoHiSelTy = ::mlir::IntegerAttr;
    dstLoHiSelTy dstLoHiSel;

    auto getDstLoHiSel() const {
      auto &propStorage = this->dstLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->dstLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstLoHiSel == this->dstLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkFp8F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.fp8.f16", odsAttrs.getContext());
  }

  CvtScaleF32PkFp8F16OpGenericAdaptorBase(CvtScaleF32PkFp8F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
    return attr;
  }

  bool getDstLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkFp8F16OpGenericAdaptor : public detail::CvtScaleF32PkFp8F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkFp8F16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32PkFp8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkFp8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkFp8F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkFp8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkFp8F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkFp8F16OpGenericAdaptor(RangeT values, const CvtScaleF32PkFp8F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkFp8F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkFp8F16Op>>>
  CvtScaleF32PkFp8F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkFp8F16OpAdaptor : public CvtScaleF32PkFp8F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkFp8F16OpGenericAdaptor::CvtScaleF32PkFp8F16OpGenericAdaptor;
  CvtScaleF32PkFp8F16OpAdaptor(CvtScaleF32PkFp8F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkFp8F16Op : public ::mlir::Op<CvtScaleF32PkFp8F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkFp8F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkFp8F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.fp8.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
  }

  bool getDstLoHiSel();
  void setDstLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().dstLoHiSel = attr;
  }

  void setDstLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkFp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkFp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkFp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkFp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkFp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkFp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkFp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkFp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkFp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkFp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkFp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkFp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkFp8F16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkFp8F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32PkFp8F32OpGenericAdaptorBase {
public:
  struct Properties {
    using dstLoHiSelTy = ::mlir::IntegerAttr;
    dstLoHiSelTy dstLoHiSel;

    auto getDstLoHiSel() const {
      auto &propStorage = this->dstLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->dstLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstLoHiSel == this->dstLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkFp8F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.fp8.f32", odsAttrs.getContext());
  }

  CvtScaleF32PkFp8F32OpGenericAdaptorBase(CvtScaleF32PkFp8F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
    return attr;
  }

  bool getDstLoHiSel();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32PkFp8F32OpGenericAdaptor : public detail::CvtScaleF32PkFp8F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkFp8F32OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_src1 = 2;
  static constexpr int odsIndex_scale = 3;
public:
  CvtScaleF32PkFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkFp8F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkFp8F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkFp8F32OpGenericAdaptor(RangeT values, const CvtScaleF32PkFp8F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkFp8F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkFp8F32Op>>>
  CvtScaleF32PkFp8F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSrc1() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkFp8F32OpAdaptor : public CvtScaleF32PkFp8F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkFp8F32OpGenericAdaptor::CvtScaleF32PkFp8F32OpGenericAdaptor;
  CvtScaleF32PkFp8F32OpAdaptor(CvtScaleF32PkFp8F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkFp8F32Op : public ::mlir::Op<CvtScaleF32PkFp8F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkFp8F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkFp8F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_src1 = 2;
  static constexpr int odsIndex_scale = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.fp8.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrc1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc1Mutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
  }

  bool getDstLoHiSel();
  void setDstLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().dstLoHiSel = attr;
  }

  void setDstLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkFp8F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrBf8BF16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrBf8BF16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstSelIndexTy = ::mlir::IntegerAttr;
    dstSelIndexTy dstSelIndex;

    auto getDstSelIndex() const {
      auto &propStorage = this->dstSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->dstSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstSelIndex == this->dstSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrBf8BF16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.bf8.bf16", odsAttrs.getContext());
  }

  CvtScaleF32SrBf8BF16OpGenericAdaptorBase(CvtScaleF32SrBf8BF16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
    return attr;
  }

  uint32_t getDstSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrBf8BF16OpGenericAdaptor : public detail::CvtScaleF32SrBf8BF16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrBf8BF16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
public:
  CvtScaleF32SrBf8BF16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrBf8BF16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrBf8BF16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrBf8BF16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrBf8BF16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrBf8BF16OpGenericAdaptor(RangeT values, const CvtScaleF32SrBf8BF16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrBf8BF16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrBf8BF16Op>>>
  CvtScaleF32SrBf8BF16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrBf8BF16OpAdaptor : public CvtScaleF32SrBf8BF16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrBf8BF16OpGenericAdaptor::CvtScaleF32SrBf8BF16OpGenericAdaptor;
  CvtScaleF32SrBf8BF16OpAdaptor(CvtScaleF32SrBf8BF16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrBf8BF16Op : public ::mlir::Op<CvtScaleF32SrBf8BF16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrBf8BF16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrBf8BF16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.bf8.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
  }

  uint32_t getDstSelIndex();
  void setDstSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().dstSelIndex = attr;
  }

  void setDstSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrBf8BF16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrBf8BF16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrBf8BF16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrBf8BF16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrBf8BF16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrBf8BF16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrBf8BF16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrBf8BF16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrBf8BF16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrBf8BF16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrBf8BF16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrBf8BF16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrBf8BF16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrBf8F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrBf8F16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstSelIndexTy = ::mlir::IntegerAttr;
    dstSelIndexTy dstSelIndex;

    auto getDstSelIndex() const {
      auto &propStorage = this->dstSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->dstSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstSelIndex == this->dstSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrBf8F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.bf8.f16", odsAttrs.getContext());
  }

  CvtScaleF32SrBf8F16OpGenericAdaptorBase(CvtScaleF32SrBf8F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
    return attr;
  }

  uint32_t getDstSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrBf8F16OpGenericAdaptor : public detail::CvtScaleF32SrBf8F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrBf8F16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
public:
  CvtScaleF32SrBf8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrBf8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrBf8F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrBf8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrBf8F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrBf8F16OpGenericAdaptor(RangeT values, const CvtScaleF32SrBf8F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrBf8F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrBf8F16Op>>>
  CvtScaleF32SrBf8F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrBf8F16OpAdaptor : public CvtScaleF32SrBf8F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrBf8F16OpGenericAdaptor::CvtScaleF32SrBf8F16OpGenericAdaptor;
  CvtScaleF32SrBf8F16OpAdaptor(CvtScaleF32SrBf8F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrBf8F16Op : public ::mlir::Op<CvtScaleF32SrBf8F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrBf8F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrBf8F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.bf8.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
  }

  uint32_t getDstSelIndex();
  void setDstSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().dstSelIndex = attr;
  }

  void setDstSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrBf8F16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrBf8F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrBf8F32OpGenericAdaptorBase {
public:
  struct Properties {
    using dstSelIndexTy = ::mlir::IntegerAttr;
    dstSelIndexTy dstSelIndex;

    auto getDstSelIndex() const {
      auto &propStorage = this->dstSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->dstSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstSelIndex == this->dstSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrBf8F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.bf8.f32", odsAttrs.getContext());
  }

  CvtScaleF32SrBf8F32OpGenericAdaptorBase(CvtScaleF32SrBf8F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
    return attr;
  }

  uint32_t getDstSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrBf8F32OpGenericAdaptor : public detail::CvtScaleF32SrBf8F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrBf8F32OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
public:
  CvtScaleF32SrBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrBf8F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrBf8F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrBf8F32OpGenericAdaptor(RangeT values, const CvtScaleF32SrBf8F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrBf8F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrBf8F32Op>>>
  CvtScaleF32SrBf8F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrBf8F32OpAdaptor : public CvtScaleF32SrBf8F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrBf8F32OpGenericAdaptor::CvtScaleF32SrBf8F32OpGenericAdaptor;
  CvtScaleF32SrBf8F32OpAdaptor(CvtScaleF32SrBf8F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrBf8F32Op : public ::mlir::Op<CvtScaleF32SrBf8F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrBf8F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrBf8F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.bf8.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
  }

  uint32_t getDstSelIndex();
  void setDstSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().dstSelIndex = attr;
  }

  void setDstSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrBf8F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrFp8BF16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrFp8BF16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstSelIndexTy = ::mlir::IntegerAttr;
    dstSelIndexTy dstSelIndex;

    auto getDstSelIndex() const {
      auto &propStorage = this->dstSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->dstSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstSelIndex == this->dstSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrFp8BF16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.fp8.bf16", odsAttrs.getContext());
  }

  CvtScaleF32SrFp8BF16OpGenericAdaptorBase(CvtScaleF32SrFp8BF16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
    return attr;
  }

  uint32_t getDstSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrFp8BF16OpGenericAdaptor : public detail::CvtScaleF32SrFp8BF16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrFp8BF16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
public:
  CvtScaleF32SrFp8BF16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrFp8BF16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrFp8BF16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrFp8BF16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrFp8BF16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrFp8BF16OpGenericAdaptor(RangeT values, const CvtScaleF32SrFp8BF16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrFp8BF16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrFp8BF16Op>>>
  CvtScaleF32SrFp8BF16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrFp8BF16OpAdaptor : public CvtScaleF32SrFp8BF16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrFp8BF16OpGenericAdaptor::CvtScaleF32SrFp8BF16OpGenericAdaptor;
  CvtScaleF32SrFp8BF16OpAdaptor(CvtScaleF32SrFp8BF16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrFp8BF16Op : public ::mlir::Op<CvtScaleF32SrFp8BF16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrFp8BF16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrFp8BF16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.fp8.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
  }

  uint32_t getDstSelIndex();
  void setDstSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().dstSelIndex = attr;
  }

  void setDstSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrFp8BF16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrFp8BF16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrFp8BF16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrFp8BF16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrFp8BF16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrFp8BF16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrFp8BF16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrFp8BF16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrFp8BF16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrFp8BF16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrFp8BF16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrFp8BF16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrFp8BF16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrFp8F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrFp8F16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstSelIndexTy = ::mlir::IntegerAttr;
    dstSelIndexTy dstSelIndex;

    auto getDstSelIndex() const {
      auto &propStorage = this->dstSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->dstSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstSelIndex == this->dstSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrFp8F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.fp8.f16", odsAttrs.getContext());
  }

  CvtScaleF32SrFp8F16OpGenericAdaptorBase(CvtScaleF32SrFp8F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
    return attr;
  }

  uint32_t getDstSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrFp8F16OpGenericAdaptor : public detail::CvtScaleF32SrFp8F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrFp8F16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
public:
  CvtScaleF32SrFp8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrFp8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrFp8F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrFp8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrFp8F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrFp8F16OpGenericAdaptor(RangeT values, const CvtScaleF32SrFp8F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrFp8F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrFp8F16Op>>>
  CvtScaleF32SrFp8F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrFp8F16OpAdaptor : public CvtScaleF32SrFp8F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrFp8F16OpGenericAdaptor::CvtScaleF32SrFp8F16OpGenericAdaptor;
  CvtScaleF32SrFp8F16OpAdaptor(CvtScaleF32SrFp8F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrFp8F16Op : public ::mlir::Op<CvtScaleF32SrFp8F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrFp8F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrFp8F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.fp8.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
  }

  uint32_t getDstSelIndex();
  void setDstSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().dstSelIndex = attr;
  }

  void setDstSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrFp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrFp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrFp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrFp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrFp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrFp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrFp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrFp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrFp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrFp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrFp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrFp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrFp8F16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrFp8F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrFp8F32OpGenericAdaptorBase {
public:
  struct Properties {
    using dstSelIndexTy = ::mlir::IntegerAttr;
    dstSelIndexTy dstSelIndex;

    auto getDstSelIndex() const {
      auto &propStorage = this->dstSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->dstSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstSelIndex == this->dstSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrFp8F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.fp8.f32", odsAttrs.getContext());
  }

  CvtScaleF32SrFp8F32OpGenericAdaptorBase(CvtScaleF32SrFp8F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
    return attr;
  }

  uint32_t getDstSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrFp8F32OpGenericAdaptor : public detail::CvtScaleF32SrFp8F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrFp8F32OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
public:
  CvtScaleF32SrFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrFp8F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrFp8F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrFp8F32OpGenericAdaptor(RangeT values, const CvtScaleF32SrFp8F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrFp8F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrFp8F32Op>>>
  CvtScaleF32SrFp8F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrFp8F32OpAdaptor : public CvtScaleF32SrFp8F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrFp8F32OpGenericAdaptor::CvtScaleF32SrFp8F32OpGenericAdaptor;
  CvtScaleF32SrFp8F32OpAdaptor(CvtScaleF32SrFp8F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrFp8F32Op : public ::mlir::Op<CvtScaleF32SrFp8F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrFp8F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrFp8F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.fp8.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
  }

  uint32_t getDstSelIndex();
  void setDstSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().dstSelIndex = attr;
  }

  void setDstSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrFp8F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrPk32Bf6Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.pk32.bf6.bf16", odsAttrs.getContext());
  }

  CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptorBase(CvtScaleF32SrPk32Bf6Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptor : public detail::CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_seed = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrPk32Bf6Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrPk32Bf6Bf16Op>>>
  CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrPk32Bf6Bf16OpAdaptor : public CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptor::CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptor;
  CvtScaleF32SrPk32Bf6Bf16OpAdaptor(CvtScaleF32SrPk32Bf6Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrPk32Bf6Bf16Op : public ::mlir::Op<CvtScaleF32SrPk32Bf6Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrPk32Bf6Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrPk32Bf6Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_seed = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.pk32.bf6.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPk32Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPk32Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPk32Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPk32Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrPk32Bf6Bf16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrPk32Bf6F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrPk32Bf6F16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrPk32Bf6F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.pk32.bf6.f16", odsAttrs.getContext());
  }

  CvtScaleF32SrPk32Bf6F16OpGenericAdaptorBase(CvtScaleF32SrPk32Bf6F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrPk32Bf6F16OpGenericAdaptor : public detail::CvtScaleF32SrPk32Bf6F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrPk32Bf6F16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_seed = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32SrPk32Bf6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrPk32Bf6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrPk32Bf6F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrPk32Bf6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrPk32Bf6F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrPk32Bf6F16OpGenericAdaptor(RangeT values, const CvtScaleF32SrPk32Bf6F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrPk32Bf6F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrPk32Bf6F16Op>>>
  CvtScaleF32SrPk32Bf6F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrPk32Bf6F16OpAdaptor : public CvtScaleF32SrPk32Bf6F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrPk32Bf6F16OpGenericAdaptor::CvtScaleF32SrPk32Bf6F16OpGenericAdaptor;
  CvtScaleF32SrPk32Bf6F16OpAdaptor(CvtScaleF32SrPk32Bf6F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrPk32Bf6F16Op : public ::mlir::Op<CvtScaleF32SrPk32Bf6F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrPk32Bf6F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrPk32Bf6F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_seed = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.pk32.bf6.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPk32Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPk32Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPk32Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPk32Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrPk32Bf6F16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrPk32Bf6F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrPk32Bf6F32OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrPk32Bf6F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.pk32.bf6.f32", odsAttrs.getContext());
  }

  CvtScaleF32SrPk32Bf6F32OpGenericAdaptorBase(CvtScaleF32SrPk32Bf6F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrPk32Bf6F32OpGenericAdaptor : public detail::CvtScaleF32SrPk32Bf6F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrPk32Bf6F32OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_seed = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32SrPk32Bf6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrPk32Bf6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrPk32Bf6F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrPk32Bf6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrPk32Bf6F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrPk32Bf6F32OpGenericAdaptor(RangeT values, const CvtScaleF32SrPk32Bf6F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrPk32Bf6F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrPk32Bf6F32Op>>>
  CvtScaleF32SrPk32Bf6F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrPk32Bf6F32OpAdaptor : public CvtScaleF32SrPk32Bf6F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrPk32Bf6F32OpGenericAdaptor::CvtScaleF32SrPk32Bf6F32OpGenericAdaptor;
  CvtScaleF32SrPk32Bf6F32OpAdaptor(CvtScaleF32SrPk32Bf6F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrPk32Bf6F32Op : public ::mlir::Op<CvtScaleF32SrPk32Bf6F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrPk32Bf6F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrPk32Bf6F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_seed = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.pk32.bf6.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPk32Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPk32Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPk32Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPk32Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrPk32Bf6F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrPk32Fp6Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.pk32.fp6.bf16", odsAttrs.getContext());
  }

  CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptorBase(CvtScaleF32SrPk32Fp6Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptor : public detail::CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_seed = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrPk32Fp6Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrPk32Fp6Bf16Op>>>
  CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrPk32Fp6Bf16OpAdaptor : public CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptor::CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptor;
  CvtScaleF32SrPk32Fp6Bf16OpAdaptor(CvtScaleF32SrPk32Fp6Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrPk32Fp6Bf16Op : public ::mlir::Op<CvtScaleF32SrPk32Fp6Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrPk32Fp6Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrPk32Fp6Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_seed = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.pk32.fp6.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPk32Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPk32Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPk32Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPk32Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrPk32Fp6Bf16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrPk32Fp6F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrPk32Fp6F16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrPk32Fp6F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.pk32.fp6.f16", odsAttrs.getContext());
  }

  CvtScaleF32SrPk32Fp6F16OpGenericAdaptorBase(CvtScaleF32SrPk32Fp6F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrPk32Fp6F16OpGenericAdaptor : public detail::CvtScaleF32SrPk32Fp6F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrPk32Fp6F16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_seed = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32SrPk32Fp6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrPk32Fp6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrPk32Fp6F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrPk32Fp6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrPk32Fp6F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrPk32Fp6F16OpGenericAdaptor(RangeT values, const CvtScaleF32SrPk32Fp6F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrPk32Fp6F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrPk32Fp6F16Op>>>
  CvtScaleF32SrPk32Fp6F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrPk32Fp6F16OpAdaptor : public CvtScaleF32SrPk32Fp6F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrPk32Fp6F16OpGenericAdaptor::CvtScaleF32SrPk32Fp6F16OpGenericAdaptor;
  CvtScaleF32SrPk32Fp6F16OpAdaptor(CvtScaleF32SrPk32Fp6F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrPk32Fp6F16Op : public ::mlir::Op<CvtScaleF32SrPk32Fp6F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrPk32Fp6F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrPk32Fp6F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_seed = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.pk32.fp6.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPk32Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPk32Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPk32Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPk32Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrPk32Fp6F16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrPk32Fp6F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrPk32Fp6F32OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrPk32Fp6F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.pk32.fp6.f32", odsAttrs.getContext());
  }

  CvtScaleF32SrPk32Fp6F32OpGenericAdaptorBase(CvtScaleF32SrPk32Fp6F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrPk32Fp6F32OpGenericAdaptor : public detail::CvtScaleF32SrPk32Fp6F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrPk32Fp6F32OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_seed = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32SrPk32Fp6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrPk32Fp6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrPk32Fp6F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrPk32Fp6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrPk32Fp6F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrPk32Fp6F32OpGenericAdaptor(RangeT values, const CvtScaleF32SrPk32Fp6F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrPk32Fp6F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrPk32Fp6F32Op>>>
  CvtScaleF32SrPk32Fp6F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrPk32Fp6F32OpAdaptor : public CvtScaleF32SrPk32Fp6F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrPk32Fp6F32OpGenericAdaptor::CvtScaleF32SrPk32Fp6F32OpGenericAdaptor;
  CvtScaleF32SrPk32Fp6F32OpAdaptor(CvtScaleF32SrPk32Fp6F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrPk32Fp6F32Op : public ::mlir::Op<CvtScaleF32SrPk32Fp6F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrPk32Fp6F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrPk32Fp6F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_seed = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.pk32.fp6.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static CvtScaleF32SrPk32Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPk32Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPk32Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPk32Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPk32Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrPk32Fp6F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrPkFp4Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrPkFp4Bf16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstSelIndexTy = ::mlir::IntegerAttr;
    dstSelIndexTy dstSelIndex;

    auto getDstSelIndex() const {
      auto &propStorage = this->dstSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->dstSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstSelIndex == this->dstSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrPkFp4Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.pk.fp4.bf16", odsAttrs.getContext());
  }

  CvtScaleF32SrPkFp4Bf16OpGenericAdaptorBase(CvtScaleF32SrPkFp4Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
    return attr;
  }

  uint32_t getDstSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrPkFp4Bf16OpGenericAdaptor : public detail::CvtScaleF32SrPkFp4Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrPkFp4Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
public:
  CvtScaleF32SrPkFp4Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrPkFp4Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrPkFp4Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrPkFp4Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrPkFp4Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrPkFp4Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32SrPkFp4Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrPkFp4Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrPkFp4Bf16Op>>>
  CvtScaleF32SrPkFp4Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrPkFp4Bf16OpAdaptor : public CvtScaleF32SrPkFp4Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrPkFp4Bf16OpGenericAdaptor::CvtScaleF32SrPkFp4Bf16OpGenericAdaptor;
  CvtScaleF32SrPkFp4Bf16OpAdaptor(CvtScaleF32SrPkFp4Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrPkFp4Bf16Op : public ::mlir::Op<CvtScaleF32SrPkFp4Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrPkFp4Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrPkFp4Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.pk.fp4.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
  }

  uint32_t getDstSelIndex();
  void setDstSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().dstSelIndex = attr;
  }

  void setDstSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrPkFp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrPkFp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrPkFp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrPkFp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrPkFp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrPkFp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrPkFp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrPkFp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPkFp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPkFp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPkFp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPkFp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrPkFp4Bf16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrPkFp4F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrPkFp4F16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstSelIndexTy = ::mlir::IntegerAttr;
    dstSelIndexTy dstSelIndex;

    auto getDstSelIndex() const {
      auto &propStorage = this->dstSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->dstSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstSelIndex == this->dstSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrPkFp4F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.pk.fp4.f16", odsAttrs.getContext());
  }

  CvtScaleF32SrPkFp4F16OpGenericAdaptorBase(CvtScaleF32SrPkFp4F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
    return attr;
  }

  uint32_t getDstSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrPkFp4F16OpGenericAdaptor : public detail::CvtScaleF32SrPkFp4F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrPkFp4F16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
public:
  CvtScaleF32SrPkFp4F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrPkFp4F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrPkFp4F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrPkFp4F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrPkFp4F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrPkFp4F16OpGenericAdaptor(RangeT values, const CvtScaleF32SrPkFp4F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrPkFp4F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrPkFp4F16Op>>>
  CvtScaleF32SrPkFp4F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrPkFp4F16OpAdaptor : public CvtScaleF32SrPkFp4F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrPkFp4F16OpGenericAdaptor::CvtScaleF32SrPkFp4F16OpGenericAdaptor;
  CvtScaleF32SrPkFp4F16OpAdaptor(CvtScaleF32SrPkFp4F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrPkFp4F16Op : public ::mlir::Op<CvtScaleF32SrPkFp4F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrPkFp4F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrPkFp4F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.pk.fp4.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
  }

  uint32_t getDstSelIndex();
  void setDstSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().dstSelIndex = attr;
  }

  void setDstSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrPkFp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrPkFp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrPkFp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrPkFp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrPkFp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrPkFp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrPkFp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrPkFp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPkFp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPkFp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPkFp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPkFp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrPkFp4F16Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32SrPkFp4F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtScaleF32SrPkFp4F32OpGenericAdaptorBase {
public:
  struct Properties {
    using dstSelIndexTy = ::mlir::IntegerAttr;
    dstSelIndexTy dstSelIndex;

    auto getDstSelIndex() const {
      auto &propStorage = this->dstSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->dstSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstSelIndex == this->dstSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32SrPkFp4F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.sr.pk.fp4.f32", odsAttrs.getContext());
  }

  CvtScaleF32SrPkFp4F32OpGenericAdaptorBase(CvtScaleF32SrPkFp4F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
    return attr;
  }

  uint32_t getDstSelIndex();
};
} // namespace detail
template <typename RangeT>
class CvtScaleF32SrPkFp4F32OpGenericAdaptor : public detail::CvtScaleF32SrPkFp4F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32SrPkFp4F32OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
public:
  CvtScaleF32SrPkFp4F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32SrPkFp4F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32SrPkFp4F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32SrPkFp4F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32SrPkFp4F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32SrPkFp4F32OpGenericAdaptor(RangeT values, const CvtScaleF32SrPkFp4F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32SrPkFp4F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32SrPkFp4F32Op>>>
  CvtScaleF32SrPkFp4F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSeed() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32SrPkFp4F32OpAdaptor : public CvtScaleF32SrPkFp4F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32SrPkFp4F32OpGenericAdaptor::CvtScaleF32SrPkFp4F32OpGenericAdaptor;
  CvtScaleF32SrPkFp4F32OpAdaptor(CvtScaleF32SrPkFp4F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32SrPkFp4F32Op : public ::mlir::Op<CvtScaleF32SrPkFp4F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32SrPkFp4F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32SrPkFp4F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_seed = 2;
  static constexpr int odsIndex_scale = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.sr.pk.fp4.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
  }

  uint32_t getDstSelIndex();
  void setDstSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().dstSelIndex = attr;
  }

  void setDstSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrPkFp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrPkFp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrPkFp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static CvtScaleF32SrPkFp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, ::mlir::IntegerAttr dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrPkFp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrPkFp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrPkFp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static CvtScaleF32SrPkFp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value seed, ::mlir::Value scale, uint32_t dstSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPkFp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32SrPkFp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPkFp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32SrPkFp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32SrPkFp4F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtSrBf8F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtSrBf8F32OpGenericAdaptorBase {
public:
  struct Properties {
    using byteSelTy = ::mlir::IntegerAttr;
    byteSelTy byteSel;

    auto getByteSel() const {
      auto &propStorage = this->byteSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setByteSel(const ::mlir::IntegerAttr &propValue) {
      this->byteSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.byteSel == this->byteSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtSrBf8F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.sr.bf8.f32", odsAttrs.getContext());
  }

  CvtSrBf8F32OpGenericAdaptorBase(CvtSrBf8F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getByteSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().byteSel);
    return attr;
  }

  uint32_t getByteSel();
};
} // namespace detail
template <typename RangeT>
class CvtSrBf8F32OpGenericAdaptor : public detail::CvtSrBf8F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtSrBf8F32OpGenericAdaptorBase;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  static constexpr int odsIndex_old = 2;
public:
  CvtSrBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtSrBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtSrBf8F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtSrBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtSrBf8F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtSrBf8F32OpGenericAdaptor(RangeT values, const CvtSrBf8F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtSrBf8F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtSrBf8F32Op>>>
  CvtSrBf8F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOld() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtSrBf8F32OpAdaptor : public CvtSrBf8F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtSrBf8F32OpGenericAdaptor::CvtSrBf8F32OpGenericAdaptor;
  CvtSrBf8F32OpAdaptor(CvtSrBf8F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtSrBf8F32Op : public ::mlir::Op<CvtSrBf8F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtSrBf8F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtSrBf8F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  static constexpr int odsIndex_old = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("byteSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getByteSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getByteSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.sr.bf8.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrcB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOld() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrcAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOldMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getByteSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().byteSel);
  }

  uint32_t getByteSel();
  void setByteSelAttr(::mlir::IntegerAttr attr) {
    getProperties().byteSel = attr;
  }

  void setByteSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr byteSel);
  static CvtSrBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr byteSel);
  static CvtSrBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr byteSel);
  static CvtSrBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr byteSel);
  static CvtSrBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, uint32_t byteSel);
  static CvtSrBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, uint32_t byteSel);
  static CvtSrBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, uint32_t byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, uint32_t byteSel);
  static CvtSrBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, uint32_t byteSel);
  static CvtSrBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, uint32_t byteSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtSrBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtSrBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtSrBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtSrBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtSrBf8F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtSrFp8F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CvtSrFp8F32OpGenericAdaptorBase {
public:
  struct Properties {
    using byteSelTy = ::mlir::IntegerAttr;
    byteSelTy byteSel;

    auto getByteSel() const {
      auto &propStorage = this->byteSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setByteSel(const ::mlir::IntegerAttr &propValue) {
      this->byteSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.byteSel == this->byteSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtSrFp8F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.sr.fp8.f32", odsAttrs.getContext());
  }

  CvtSrFp8F32OpGenericAdaptorBase(CvtSrFp8F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getByteSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().byteSel);
    return attr;
  }

  uint32_t getByteSel();
};
} // namespace detail
template <typename RangeT>
class CvtSrFp8F32OpGenericAdaptor : public detail::CvtSrFp8F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtSrFp8F32OpGenericAdaptorBase;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  static constexpr int odsIndex_old = 2;
public:
  CvtSrFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtSrFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtSrFp8F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtSrFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtSrFp8F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtSrFp8F32OpGenericAdaptor(RangeT values, const CvtSrFp8F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtSrFp8F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtSrFp8F32Op>>>
  CvtSrFp8F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOld() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtSrFp8F32OpAdaptor : public CvtSrFp8F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtSrFp8F32OpGenericAdaptor::CvtSrFp8F32OpGenericAdaptor;
  CvtSrFp8F32OpAdaptor(CvtSrFp8F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtSrFp8F32Op : public ::mlir::Op<CvtSrFp8F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtSrFp8F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtSrFp8F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  static constexpr int odsIndex_old = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("byteSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getByteSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getByteSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.sr.fp8.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrcB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOld() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrcAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOldMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getByteSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().byteSel);
  }

  uint32_t getByteSel();
  void setByteSelAttr(::mlir::IntegerAttr attr) {
    getProperties().byteSel = attr;
  }

  void setByteSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr byteSel);
  static CvtSrFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr byteSel);
  static CvtSrFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr byteSel);
  static CvtSrFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr byteSel);
  static CvtSrFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, uint32_t byteSel);
  static CvtSrFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, uint32_t byteSel);
  static CvtSrFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, uint32_t byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, uint32_t byteSel);
  static CvtSrFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, uint32_t byteSel);
  static CvtSrFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, uint32_t byteSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtSrFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtSrFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtSrFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtSrFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtSrFp8F32Op)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::DPPUpdateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DPPUpdateOpGenericAdaptorBase {
public:
  struct Properties {
    using bankMaskTy = ::mlir::IntegerAttr;
    bankMaskTy bankMask;

    auto getBankMask() const {
      auto &propStorage = this->bankMask;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBankMask(const ::mlir::IntegerAttr &propValue) {
      this->bankMask = propValue;
    }
    using boundCtrlTy = ::mlir::IntegerAttr;
    boundCtrlTy boundCtrl;

    auto getBoundCtrl() const {
      auto &propStorage = this->boundCtrl;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBoundCtrl(const ::mlir::IntegerAttr &propValue) {
      this->boundCtrl = propValue;
    }
    using dppCtrlTy = ::mlir::IntegerAttr;
    dppCtrlTy dppCtrl;

    auto getDppCtrl() const {
      auto &propStorage = this->dppCtrl;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDppCtrl(const ::mlir::IntegerAttr &propValue) {
      this->dppCtrl = propValue;
    }
    using rowMaskTy = ::mlir::IntegerAttr;
    rowMaskTy rowMask;

    auto getRowMask() const {
      auto &propStorage = this->rowMask;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setRowMask(const ::mlir::IntegerAttr &propValue) {
      this->rowMask = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.bankMask == this->bankMask &&
        rhs.boundCtrl == this->boundCtrl &&
        rhs.dppCtrl == this->dppCtrl &&
        rhs.rowMask == this->rowMask &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DPPUpdateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.update.dpp", odsAttrs.getContext());
  }

  DPPUpdateOpGenericAdaptorBase(DPPUpdateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDppCtrlAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dppCtrl);
    return attr;
  }

  uint32_t getDppCtrl();
  ::mlir::IntegerAttr getRowMaskAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().rowMask);
    return attr;
  }

  uint32_t getRowMask();
  ::mlir::IntegerAttr getBankMaskAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().bankMask);
    return attr;
  }

  uint32_t getBankMask();
  ::mlir::IntegerAttr getBoundCtrlAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().boundCtrl);
    return attr;
  }

  bool getBoundCtrl();
};
} // namespace detail
template <typename RangeT>
class DPPUpdateOpGenericAdaptor : public detail::DPPUpdateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DPPUpdateOpGenericAdaptorBase;
  static constexpr int odsIndex_old = 0;
  static constexpr int odsIndex_src = 1;
public:
  DPPUpdateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DPPUpdateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DPPUpdateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DPPUpdateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DPPUpdateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DPPUpdateOpGenericAdaptor(RangeT values, const DPPUpdateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DPPUpdateOp, typename = std::enable_if_t<std::is_same_v<LateInst, DPPUpdateOp>>>
  DPPUpdateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOld() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DPPUpdateOpAdaptor : public DPPUpdateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DPPUpdateOpGenericAdaptor::DPPUpdateOpGenericAdaptor;
  DPPUpdateOpAdaptor(DPPUpdateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DPPUpdateOp : public ::mlir::Op<DPPUpdateOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DPPUpdateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DPPUpdateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_old = 0;
  static constexpr int odsIndex_src = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("bankMask"), ::llvm::StringRef("boundCtrl"), ::llvm::StringRef("dppCtrl"), ::llvm::StringRef("rowMask")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBankMaskAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBankMaskAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getBoundCtrlAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getBoundCtrlAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDppCtrlAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDppCtrlAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getRowMaskAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getRowMaskAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.update.dpp");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOld() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getOldMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDppCtrlAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dppCtrl);
  }

  uint32_t getDppCtrl();
  ::mlir::IntegerAttr getRowMaskAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().rowMask);
  }

  uint32_t getRowMask();
  ::mlir::IntegerAttr getBankMaskAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().bankMask);
  }

  uint32_t getBankMask();
  ::mlir::IntegerAttr getBoundCtrlAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().boundCtrl);
  }

  bool getBoundCtrl();
  void setDppCtrlAttr(::mlir::IntegerAttr attr) {
    getProperties().dppCtrl = attr;
  }

  void setDppCtrl(uint32_t attrValue);
  void setRowMaskAttr(::mlir::IntegerAttr attr) {
    getProperties().rowMask = attr;
  }

  void setRowMask(uint32_t attrValue);
  void setBankMaskAttr(::mlir::IntegerAttr attr) {
    getProperties().bankMask = attr;
  }

  void setBankMask(uint32_t attrValue);
  void setBoundCtrlAttr(::mlir::IntegerAttr attr) {
    getProperties().boundCtrl = attr;
  }

  void setBoundCtrl(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value old, ::mlir::Value src, ::mlir::IntegerAttr dppCtrl, ::mlir::IntegerAttr rowMask, ::mlir::IntegerAttr bankMask, ::mlir::IntegerAttr boundCtrl);
  static DPPUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value old, ::mlir::Value src, ::mlir::IntegerAttr dppCtrl, ::mlir::IntegerAttr rowMask, ::mlir::IntegerAttr bankMask, ::mlir::IntegerAttr boundCtrl);
  static DPPUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value old, ::mlir::Value src, ::mlir::IntegerAttr dppCtrl, ::mlir::IntegerAttr rowMask, ::mlir::IntegerAttr bankMask, ::mlir::IntegerAttr boundCtrl);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value old, ::mlir::Value src, ::mlir::IntegerAttr dppCtrl, ::mlir::IntegerAttr rowMask, ::mlir::IntegerAttr bankMask, ::mlir::IntegerAttr boundCtrl);
  static DPPUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value old, ::mlir::Value src, ::mlir::IntegerAttr dppCtrl, ::mlir::IntegerAttr rowMask, ::mlir::IntegerAttr bankMask, ::mlir::IntegerAttr boundCtrl);
  static DPPUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value old, ::mlir::Value src, ::mlir::IntegerAttr dppCtrl, ::mlir::IntegerAttr rowMask, ::mlir::IntegerAttr bankMask, ::mlir::IntegerAttr boundCtrl);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value old, ::mlir::Value src, uint32_t dppCtrl, uint32_t rowMask, uint32_t bankMask, bool boundCtrl);
  static DPPUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value old, ::mlir::Value src, uint32_t dppCtrl, uint32_t rowMask, uint32_t bankMask, bool boundCtrl);
  static DPPUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value old, ::mlir::Value src, uint32_t dppCtrl, uint32_t rowMask, uint32_t bankMask, bool boundCtrl);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value old, ::mlir::Value src, uint32_t dppCtrl, uint32_t rowMask, uint32_t bankMask, bool boundCtrl);
  static DPPUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value old, ::mlir::Value src, uint32_t dppCtrl, uint32_t rowMask, uint32_t bankMask, bool boundCtrl);
  static DPPUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value old, ::mlir::Value src, uint32_t dppCtrl, uint32_t rowMask, uint32_t bankMask, bool boundCtrl);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DPPUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DPPUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DPPUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DPPUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::DPPUpdateOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::DsBpermuteOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DsBpermuteOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DsBpermuteOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.ds_bpermute", odsAttrs.getContext());
  }

  DsBpermuteOpGenericAdaptorBase(DsBpermuteOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class DsBpermuteOpGenericAdaptor : public detail::DsBpermuteOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DsBpermuteOpGenericAdaptorBase;
  static constexpr int odsIndex_index = 0;
  static constexpr int odsIndex_src = 1;
public:
  DsBpermuteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DsBpermuteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DsBpermuteOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DsBpermuteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DsBpermuteOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DsBpermuteOpGenericAdaptor(RangeT values, const DsBpermuteOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DsBpermuteOp, typename = std::enable_if_t<std::is_same_v<LateInst, DsBpermuteOp>>>
  DsBpermuteOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getIndex() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DsBpermuteOpAdaptor : public DsBpermuteOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DsBpermuteOpGenericAdaptor::DsBpermuteOpGenericAdaptor;
  DsBpermuteOpAdaptor(DsBpermuteOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DsBpermuteOp : public ::mlir::Op<DsBpermuteOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DsBpermuteOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DsBpermuteOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_index = 0;
  static constexpr int odsIndex_src = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.ds_bpermute");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getIndex() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getIndexMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value index, ::mlir::Value src);
  static DsBpermuteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value index, ::mlir::Value src);
  static DsBpermuteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value index, ::mlir::Value src);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value index, ::mlir::Value src);
  static DsBpermuteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value index, ::mlir::Value src);
  static DsBpermuteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value index, ::mlir::Value src);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DsBpermuteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DsBpermuteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DsBpermuteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DsBpermuteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::DsBpermuteOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::DsSwizzleOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DsSwizzleOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DsSwizzleOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.ds_swizzle", odsAttrs.getContext());
  }

  DsSwizzleOpGenericAdaptorBase(DsSwizzleOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class DsSwizzleOpGenericAdaptor : public detail::DsSwizzleOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DsSwizzleOpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_offset = 1;
public:
  DsSwizzleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DsSwizzleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DsSwizzleOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DsSwizzleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DsSwizzleOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DsSwizzleOpGenericAdaptor(RangeT values, const DsSwizzleOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DsSwizzleOp, typename = std::enable_if_t<std::is_same_v<LateInst, DsSwizzleOp>>>
  DsSwizzleOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getOffset() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DsSwizzleOpAdaptor : public DsSwizzleOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DsSwizzleOpGenericAdaptor::DsSwizzleOpGenericAdaptor;
  DsSwizzleOpAdaptor(DsSwizzleOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DsSwizzleOp : public ::mlir::Op<DsSwizzleOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DsSwizzleOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DsSwizzleOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_offset = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.ds_swizzle");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOffset() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOffsetMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value offset);
  static DsSwizzleOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value offset);
  static DsSwizzleOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value offset);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value offset);
  static DsSwizzleOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value offset);
  static DsSwizzleOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value offset);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DsSwizzleOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DsSwizzleOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DsSwizzleOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DsSwizzleOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::DsSwizzleOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::GlobalLoadLDSOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GlobalLoadLDSOpGenericAdaptorBase {
public:
  struct Properties {
    using alias_scopesTy = ::mlir::ArrayAttr;
    alias_scopesTy alias_scopes;

    auto getAliasScopes() const {
      auto &propStorage = this->alias_scopes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAliasScopes(const ::mlir::ArrayAttr &propValue) {
      this->alias_scopes = propValue;
    }
    using auxTy = ::mlir::IntegerAttr;
    auxTy aux;

    auto getAux() const {
      auto &propStorage = this->aux;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setAux(const ::mlir::IntegerAttr &propValue) {
      this->aux = propValue;
    }
    using noalias_scopesTy = ::mlir::ArrayAttr;
    noalias_scopesTy noalias_scopes;

    auto getNoaliasScopes() const {
      auto &propStorage = this->noalias_scopes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setNoaliasScopes(const ::mlir::ArrayAttr &propValue) {
      this->noalias_scopes = propValue;
    }
    using offsetTy = ::mlir::IntegerAttr;
    offsetTy offset;

    auto getOffset() const {
      auto &propStorage = this->offset;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setOffset(const ::mlir::IntegerAttr &propValue) {
      this->offset = propValue;
    }
    using sizeTy = ::mlir::IntegerAttr;
    sizeTy size;

    auto getSize() const {
      auto &propStorage = this->size;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSize(const ::mlir::IntegerAttr &propValue) {
      this->size = propValue;
    }
    using tbaaTy = ::mlir::ArrayAttr;
    tbaaTy tbaa;

    auto getTbaa() const {
      auto &propStorage = this->tbaa;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setTbaa(const ::mlir::ArrayAttr &propValue) {
      this->tbaa = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.alias_scopes == this->alias_scopes &&
        rhs.aux == this->aux &&
        rhs.noalias_scopes == this->noalias_scopes &&
        rhs.offset == this->offset &&
        rhs.size == this->size &&
        rhs.tbaa == this->tbaa &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GlobalLoadLDSOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.global.load.lds", odsAttrs.getContext());
  }

  GlobalLoadLDSOpGenericAdaptorBase(GlobalLoadLDSOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().size);
    return attr;
  }

  uint32_t getSize();
  ::mlir::IntegerAttr getOffsetAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().offset);
    return attr;
  }

  uint32_t getOffset();
  ::mlir::IntegerAttr getAuxAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().aux);
    return attr;
  }

  uint32_t getAux();
  ::mlir::ArrayAttr getAliasScopesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAliasScopes();
  ::mlir::ArrayAttr getNoaliasScopesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getNoaliasScopes();
  ::mlir::ArrayAttr getTbaaAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
};
} // namespace detail
template <typename RangeT>
class GlobalLoadLDSOpGenericAdaptor : public detail::GlobalLoadLDSOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GlobalLoadLDSOpGenericAdaptorBase;
  static constexpr int odsIndex_globalPtr = 0;
  static constexpr int odsIndex_ldsPtr = 1;
public:
  GlobalLoadLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GlobalLoadLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GlobalLoadLDSOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GlobalLoadLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GlobalLoadLDSOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GlobalLoadLDSOpGenericAdaptor(RangeT values, const GlobalLoadLDSOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GlobalLoadLDSOp, typename = std::enable_if_t<std::is_same_v<LateInst, GlobalLoadLDSOp>>>
  GlobalLoadLDSOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getGlobalPtr() {
    return (*getODSOperands(0).begin());
  }

  ValueT getLdsPtr() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GlobalLoadLDSOpAdaptor : public GlobalLoadLDSOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GlobalLoadLDSOpGenericAdaptor::GlobalLoadLDSOpGenericAdaptor;
  GlobalLoadLDSOpAdaptor(GlobalLoadLDSOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GlobalLoadLDSOp : public ::mlir::Op<GlobalLoadLDSOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::LLVM::AliasAnalysisOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GlobalLoadLDSOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GlobalLoadLDSOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_globalPtr = 0;
  static constexpr int odsIndex_ldsPtr = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("alias_scopes"), ::llvm::StringRef("aux"), ::llvm::StringRef("noalias_scopes"), ::llvm::StringRef("offset"), ::llvm::StringRef("size"), ::llvm::StringRef("tbaa")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAliasScopesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAliasScopesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAuxAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAuxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getNoaliasScopesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getNoaliasScopesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOffsetAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getOffsetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getSizeAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getTbaaAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getTbaaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.global.load.lds");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getGlobalPtr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getLdsPtr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getGlobalPtrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getLdsPtrMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().size);
  }

  uint32_t getSize();
  ::mlir::IntegerAttr getOffsetAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().offset);
  }

  uint32_t getOffset();
  ::mlir::IntegerAttr getAuxAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().aux);
  }

  uint32_t getAux();
  ::mlir::ArrayAttr getAliasScopesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
  }

  ::std::optional< ::mlir::ArrayAttr > getAliasScopes();
  ::mlir::ArrayAttr getNoaliasScopesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
  }

  ::std::optional< ::mlir::ArrayAttr > getNoaliasScopes();
  ::mlir::ArrayAttr getTbaaAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
  void setSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().size = attr;
  }

  void setSize(uint32_t attrValue);
  void setOffsetAttr(::mlir::IntegerAttr attr) {
    getProperties().offset = attr;
  }

  void setOffset(uint32_t attrValue);
  void setAuxAttr(::mlir::IntegerAttr attr) {
    getProperties().aux = attr;
  }

  void setAux(uint32_t attrValue);
  void setAliasScopesAttr(::mlir::ArrayAttr attr) {
    getProperties().alias_scopes = attr;
  }

  void setNoaliasScopesAttr(::mlir::ArrayAttr attr) {
    getProperties().noalias_scopes = attr;
  }

  void setTbaaAttr(::mlir::ArrayAttr attr) {
    getProperties().tbaa = attr;
  }

  ::mlir::Attribute removeAliasScopesAttr() {
      auto attr = getProperties().alias_scopes;
      getProperties().alias_scopes = {};
      return attr;
  }

  ::mlir::Attribute removeNoaliasScopesAttr() {
      auto attr = getProperties().noalias_scopes;
      getProperties().noalias_scopes = {};
      return attr;
  }

  ::mlir::Attribute removeTbaaAttr() {
      auto attr = getProperties().tbaa;
      getProperties().tbaa = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, ::mlir::IntegerAttr size, ::mlir::IntegerAttr offset, ::mlir::IntegerAttr aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static GlobalLoadLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, ::mlir::IntegerAttr size, ::mlir::IntegerAttr offset, ::mlir::IntegerAttr aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static GlobalLoadLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, ::mlir::IntegerAttr size, ::mlir::IntegerAttr offset, ::mlir::IntegerAttr aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, ::mlir::IntegerAttr size, ::mlir::IntegerAttr offset, ::mlir::IntegerAttr aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static GlobalLoadLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, ::mlir::IntegerAttr size, ::mlir::IntegerAttr offset, ::mlir::IntegerAttr aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static GlobalLoadLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, ::mlir::IntegerAttr size, ::mlir::IntegerAttr offset, ::mlir::IntegerAttr aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, uint32_t size, uint32_t offset, uint32_t aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static GlobalLoadLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, uint32_t size, uint32_t offset, uint32_t aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static GlobalLoadLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, uint32_t size, uint32_t offset, uint32_t aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, uint32_t size, uint32_t offset, uint32_t aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static GlobalLoadLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, uint32_t size, uint32_t offset, uint32_t aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static GlobalLoadLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, uint32_t size, uint32_t offset, uint32_t aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalLoadLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalLoadLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalLoadLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalLoadLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::SmallVector<::mlir::Value> getAccessedOperands();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 6 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::GlobalLoadLDSOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::GridDimXOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GridDimXOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GridDimXOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.grid.dim.x", odsAttrs.getContext());
  }

  GridDimXOpGenericAdaptorBase(GridDimXOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};
} // namespace detail
template <typename RangeT>
class GridDimXOpGenericAdaptor : public detail::GridDimXOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GridDimXOpGenericAdaptorBase;
public:
  GridDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GridDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GridDimXOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GridDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GridDimXOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GridDimXOpGenericAdaptor(RangeT values, const GridDimXOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GridDimXOp, typename = std::enable_if_t<std::is_same_v<LateInst, GridDimXOp>>>
  GridDimXOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GridDimXOpAdaptor : public GridDimXOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GridDimXOpGenericAdaptor::GridDimXOpGenericAdaptor;
  GridDimXOpAdaptor(GridDimXOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GridDimXOp : public ::mlir::Op<GridDimXOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GridDimXOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GridDimXOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.grid.dim.x");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static GridDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static GridDimXOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static GridDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static GridDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static GridDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static GridDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GridDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GridDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GridDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GridDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::GridDimXOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::GridDimYOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GridDimYOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GridDimYOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.grid.dim.y", odsAttrs.getContext());
  }

  GridDimYOpGenericAdaptorBase(GridDimYOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};
} // namespace detail
template <typename RangeT>
class GridDimYOpGenericAdaptor : public detail::GridDimYOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GridDimYOpGenericAdaptorBase;
public:
  GridDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GridDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GridDimYOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GridDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GridDimYOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GridDimYOpGenericAdaptor(RangeT values, const GridDimYOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GridDimYOp, typename = std::enable_if_t<std::is_same_v<LateInst, GridDimYOp>>>
  GridDimYOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GridDimYOpAdaptor : public GridDimYOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GridDimYOpGenericAdaptor::GridDimYOpGenericAdaptor;
  GridDimYOpAdaptor(GridDimYOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GridDimYOp : public ::mlir::Op<GridDimYOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GridDimYOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GridDimYOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.grid.dim.y");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static GridDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static GridDimYOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static GridDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static GridDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static GridDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static GridDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GridDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GridDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GridDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GridDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::GridDimYOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::GridDimZOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GridDimZOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GridDimZOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.grid.dim.z", odsAttrs.getContext());
  }

  GridDimZOpGenericAdaptorBase(GridDimZOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};
} // namespace detail
template <typename RangeT>
class GridDimZOpGenericAdaptor : public detail::GridDimZOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GridDimZOpGenericAdaptorBase;
public:
  GridDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GridDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GridDimZOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GridDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GridDimZOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GridDimZOpGenericAdaptor(RangeT values, const GridDimZOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GridDimZOp, typename = std::enable_if_t<std::is_same_v<LateInst, GridDimZOp>>>
  GridDimZOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GridDimZOpAdaptor : public GridDimZOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GridDimZOpGenericAdaptor::GridDimZOpGenericAdaptor;
  GridDimZOpAdaptor(GridDimZOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GridDimZOp : public ::mlir::Op<GridDimZOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GridDimZOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GridDimZOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.grid.dim.z");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static GridDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static GridDimZOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static GridDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static GridDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static GridDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static GridDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GridDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GridDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GridDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GridDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::GridDimZOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::IglpOpt declarations
//===----------------------------------------------------------------------===//

namespace detail {
class IglpOptGenericAdaptorBase {
public:
  struct Properties {
    using variantTy = ::mlir::IntegerAttr;
    variantTy variant;

    auto getVariant() const {
      auto &propStorage = this->variant;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setVariant(const ::mlir::IntegerAttr &propValue) {
      this->variant = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.variant == this->variant &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IglpOptGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.iglp.opt", odsAttrs.getContext());
  }

  IglpOptGenericAdaptorBase(IglpOpt op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getVariantAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().variant);
    return attr;
  }

  uint32_t getVariant();
};
} // namespace detail
template <typename RangeT>
class IglpOptGenericAdaptor : public detail::IglpOptGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IglpOptGenericAdaptorBase;
public:
  IglpOptGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IglpOptGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IglpOptGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IglpOptGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : IglpOptGenericAdaptor(values, attrs, Properties{}, {}) {}

  IglpOptGenericAdaptor(RangeT values, const IglpOptGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IglpOpt, typename = std::enable_if_t<std::is_same_v<LateInst, IglpOpt>>>
  IglpOptGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IglpOptAdaptor : public IglpOptGenericAdaptor<::mlir::ValueRange> {
public:
  using IglpOptGenericAdaptor::IglpOptGenericAdaptor;
  IglpOptAdaptor(IglpOpt op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IglpOpt : public ::mlir::Op<IglpOpt, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IglpOptAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IglpOptGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("variant")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getVariantAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getVariantAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.iglp.opt");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getVariantAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().variant);
  }

  uint32_t getVariant();
  void setVariantAttr(::mlir::IntegerAttr attr) {
    getProperties().variant = attr;
  }

  void setVariant(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr variant);
  static IglpOpt create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr variant);
  static IglpOpt create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr variant);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr variant);
  static IglpOpt create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr variant);
  static IglpOpt create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr variant);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint32_t variant);
  static IglpOpt create(::mlir::OpBuilder &builder, ::mlir::Location location, uint32_t variant);
  static IglpOpt create(::mlir::ImplicitLocOpBuilder &builder, uint32_t variant);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint32_t variant);
  static IglpOpt create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint32_t variant);
  static IglpOpt create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint32_t variant);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IglpOpt create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IglpOpt create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IglpOpt create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IglpOpt create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::IglpOpt)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::LoadToLDSOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class LoadToLDSOpGenericAdaptorBase {
public:
  struct Properties {
    using alias_scopesTy = ::mlir::ArrayAttr;
    alias_scopesTy alias_scopes;

    auto getAliasScopes() const {
      auto &propStorage = this->alias_scopes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAliasScopes(const ::mlir::ArrayAttr &propValue) {
      this->alias_scopes = propValue;
    }
    using auxTy = ::mlir::IntegerAttr;
    auxTy aux;

    auto getAux() const {
      auto &propStorage = this->aux;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setAux(const ::mlir::IntegerAttr &propValue) {
      this->aux = propValue;
    }
    using noalias_scopesTy = ::mlir::ArrayAttr;
    noalias_scopesTy noalias_scopes;

    auto getNoaliasScopes() const {
      auto &propStorage = this->noalias_scopes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setNoaliasScopes(const ::mlir::ArrayAttr &propValue) {
      this->noalias_scopes = propValue;
    }
    using offsetTy = ::mlir::IntegerAttr;
    offsetTy offset;

    auto getOffset() const {
      auto &propStorage = this->offset;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setOffset(const ::mlir::IntegerAttr &propValue) {
      this->offset = propValue;
    }
    using sizeTy = ::mlir::IntegerAttr;
    sizeTy size;

    auto getSize() const {
      auto &propStorage = this->size;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSize(const ::mlir::IntegerAttr &propValue) {
      this->size = propValue;
    }
    using tbaaTy = ::mlir::ArrayAttr;
    tbaaTy tbaa;

    auto getTbaa() const {
      auto &propStorage = this->tbaa;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setTbaa(const ::mlir::ArrayAttr &propValue) {
      this->tbaa = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.alias_scopes == this->alias_scopes &&
        rhs.aux == this->aux &&
        rhs.noalias_scopes == this->noalias_scopes &&
        rhs.offset == this->offset &&
        rhs.size == this->size &&
        rhs.tbaa == this->tbaa &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LoadToLDSOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.load.to.lds", odsAttrs.getContext());
  }

  LoadToLDSOpGenericAdaptorBase(LoadToLDSOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().size);
    return attr;
  }

  uint32_t getSize();
  ::mlir::IntegerAttr getOffsetAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().offset);
    return attr;
  }

  uint32_t getOffset();
  ::mlir::IntegerAttr getAuxAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().aux);
    return attr;
  }

  uint32_t getAux();
  ::mlir::ArrayAttr getAliasScopesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAliasScopes();
  ::mlir::ArrayAttr getNoaliasScopesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getNoaliasScopes();
  ::mlir::ArrayAttr getTbaaAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
};
} // namespace detail
template <typename RangeT>
class LoadToLDSOpGenericAdaptor : public detail::LoadToLDSOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LoadToLDSOpGenericAdaptorBase;
  static constexpr int odsIndex_globalPtr = 0;
  static constexpr int odsIndex_ldsPtr = 1;
public:
  LoadToLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LoadToLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LoadToLDSOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LoadToLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : LoadToLDSOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LoadToLDSOpGenericAdaptor(RangeT values, const LoadToLDSOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LoadToLDSOp, typename = std::enable_if_t<std::is_same_v<LateInst, LoadToLDSOp>>>
  LoadToLDSOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getGlobalPtr() {
    return (*getODSOperands(0).begin());
  }

  ValueT getLdsPtr() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LoadToLDSOpAdaptor : public LoadToLDSOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LoadToLDSOpGenericAdaptor::LoadToLDSOpGenericAdaptor;
  LoadToLDSOpAdaptor(LoadToLDSOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LoadToLDSOp : public ::mlir::Op<LoadToLDSOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::LLVM::AliasAnalysisOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LoadToLDSOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LoadToLDSOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_globalPtr = 0;
  static constexpr int odsIndex_ldsPtr = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("alias_scopes"), ::llvm::StringRef("aux"), ::llvm::StringRef("noalias_scopes"), ::llvm::StringRef("offset"), ::llvm::StringRef("size"), ::llvm::StringRef("tbaa")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAliasScopesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAliasScopesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAuxAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAuxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getNoaliasScopesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getNoaliasScopesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOffsetAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getOffsetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getSizeAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getTbaaAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getTbaaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.load.to.lds");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getGlobalPtr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getLdsPtr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getGlobalPtrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getLdsPtrMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().size);
  }

  uint32_t getSize();
  ::mlir::IntegerAttr getOffsetAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().offset);
  }

  uint32_t getOffset();
  ::mlir::IntegerAttr getAuxAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().aux);
  }

  uint32_t getAux();
  ::mlir::ArrayAttr getAliasScopesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
  }

  ::std::optional< ::mlir::ArrayAttr > getAliasScopes();
  ::mlir::ArrayAttr getNoaliasScopesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
  }

  ::std::optional< ::mlir::ArrayAttr > getNoaliasScopes();
  ::mlir::ArrayAttr getTbaaAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
  void setSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().size = attr;
  }

  void setSize(uint32_t attrValue);
  void setOffsetAttr(::mlir::IntegerAttr attr) {
    getProperties().offset = attr;
  }

  void setOffset(uint32_t attrValue);
  void setAuxAttr(::mlir::IntegerAttr attr) {
    getProperties().aux = attr;
  }

  void setAux(uint32_t attrValue);
  void setAliasScopesAttr(::mlir::ArrayAttr attr) {
    getProperties().alias_scopes = attr;
  }

  void setNoaliasScopesAttr(::mlir::ArrayAttr attr) {
    getProperties().noalias_scopes = attr;
  }

  void setTbaaAttr(::mlir::ArrayAttr attr) {
    getProperties().tbaa = attr;
  }

  ::mlir::Attribute removeAliasScopesAttr() {
      auto attr = getProperties().alias_scopes;
      getProperties().alias_scopes = {};
      return attr;
  }

  ::mlir::Attribute removeNoaliasScopesAttr() {
      auto attr = getProperties().noalias_scopes;
      getProperties().noalias_scopes = {};
      return attr;
  }

  ::mlir::Attribute removeTbaaAttr() {
      auto attr = getProperties().tbaa;
      getProperties().tbaa = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, ::mlir::IntegerAttr size, ::mlir::IntegerAttr offset, ::mlir::IntegerAttr aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, ::mlir::IntegerAttr size, ::mlir::IntegerAttr offset, ::mlir::IntegerAttr aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, ::mlir::IntegerAttr size, ::mlir::IntegerAttr offset, ::mlir::IntegerAttr aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, ::mlir::IntegerAttr size, ::mlir::IntegerAttr offset, ::mlir::IntegerAttr aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, ::mlir::IntegerAttr size, ::mlir::IntegerAttr offset, ::mlir::IntegerAttr aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, ::mlir::IntegerAttr size, ::mlir::IntegerAttr offset, ::mlir::IntegerAttr aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, uint32_t size, uint32_t offset, uint32_t aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, uint32_t size, uint32_t offset, uint32_t aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, uint32_t size, uint32_t offset, uint32_t aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, uint32_t size, uint32_t offset, uint32_t aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, uint32_t size, uint32_t offset, uint32_t aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value globalPtr, ::mlir::Value ldsPtr, uint32_t size, uint32_t offset, uint32_t aux, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::SmallVector<::mlir::Value> getAccessedOperands();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 6 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::LoadToLDSOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::MakeBufferRsrcOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class MakeBufferRsrcOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MakeBufferRsrcOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.make.buffer.rsrc", odsAttrs.getContext());
  }

  MakeBufferRsrcOpGenericAdaptorBase(MakeBufferRsrcOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class MakeBufferRsrcOpGenericAdaptor : public detail::MakeBufferRsrcOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MakeBufferRsrcOpGenericAdaptorBase;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_stride = 1;
  static constexpr int odsIndex_numRecords = 2;
  static constexpr int odsIndex_flags = 3;
public:
  MakeBufferRsrcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MakeBufferRsrcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MakeBufferRsrcOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MakeBufferRsrcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : MakeBufferRsrcOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MakeBufferRsrcOpGenericAdaptor(RangeT values, const MakeBufferRsrcOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MakeBufferRsrcOp, typename = std::enable_if_t<std::is_same_v<LateInst, MakeBufferRsrcOp>>>
  MakeBufferRsrcOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBase() {
    return (*getODSOperands(0).begin());
  }

  ValueT getStride() {
    return (*getODSOperands(1).begin());
  }

  ValueT getNumRecords() {
    return (*getODSOperands(2).begin());
  }

  ValueT getFlags() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MakeBufferRsrcOpAdaptor : public MakeBufferRsrcOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MakeBufferRsrcOpGenericAdaptor::MakeBufferRsrcOpGenericAdaptor;
  MakeBufferRsrcOpAdaptor(MakeBufferRsrcOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MakeBufferRsrcOp : public ::mlir::Op<MakeBufferRsrcOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::LLVM::LLVMPointerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MakeBufferRsrcOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MakeBufferRsrcOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_stride = 1;
  static constexpr int odsIndex_numRecords = 2;
  static constexpr int odsIndex_flags = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.make.buffer.rsrc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getBase() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getStride() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getNumRecords() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getFlags() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getBaseMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getStrideMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getNumRecordsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getFlagsMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value base, ::mlir::Value stride, ::mlir::Value numRecords, ::mlir::Value flags);
  static MakeBufferRsrcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value base, ::mlir::Value stride, ::mlir::Value numRecords, ::mlir::Value flags);
  static MakeBufferRsrcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value base, ::mlir::Value stride, ::mlir::Value numRecords, ::mlir::Value flags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value stride, ::mlir::Value numRecords, ::mlir::Value flags);
  static MakeBufferRsrcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value stride, ::mlir::Value numRecords, ::mlir::Value flags);
  static MakeBufferRsrcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value stride, ::mlir::Value numRecords, ::mlir::Value flags);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeBufferRsrcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MakeBufferRsrcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeBufferRsrcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MakeBufferRsrcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::MakeBufferRsrcOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::MbcntHiOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class MbcntHiOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MbcntHiOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.mbcnt.hi", odsAttrs.getContext());
  }

  MbcntHiOpGenericAdaptorBase(MbcntHiOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class MbcntHiOpGenericAdaptor : public detail::MbcntHiOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MbcntHiOpGenericAdaptorBase;
  static constexpr int odsIndex_in0 = 0;
  static constexpr int odsIndex_in1 = 1;
public:
  MbcntHiOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MbcntHiOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MbcntHiOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MbcntHiOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : MbcntHiOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MbcntHiOpGenericAdaptor(RangeT values, const MbcntHiOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MbcntHiOp, typename = std::enable_if_t<std::is_same_v<LateInst, MbcntHiOp>>>
  MbcntHiOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getIn0() {
    return (*getODSOperands(0).begin());
  }

  ValueT getIn1() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MbcntHiOpAdaptor : public MbcntHiOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MbcntHiOpGenericAdaptor::MbcntHiOpGenericAdaptor;
  MbcntHiOpAdaptor(MbcntHiOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MbcntHiOp : public ::mlir::Op<MbcntHiOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MbcntHiOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MbcntHiOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_in0 = 0;
  static constexpr int odsIndex_in1 = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.mbcnt.hi");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getIn0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getIn1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getIn0Mutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getIn1Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in0, ::mlir::Value in1);
  static MbcntHiOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value in0, ::mlir::Value in1);
  static MbcntHiOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value in0, ::mlir::Value in1);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in0, ::mlir::Value in1);
  static MbcntHiOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value in0, ::mlir::Value in1);
  static MbcntHiOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value in0, ::mlir::Value in1);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MbcntHiOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MbcntHiOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MbcntHiOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MbcntHiOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace ROCDL
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::MbcntHiOp)

namespace mlir {
namespace ROCDL {

//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::MbcntLoOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class MbcntLoOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MbcntLoOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.mbcnt.lo", odsAttrs.getContext());
  }

  MbcntLoOpGenericAdaptorBase(MbcntLoOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class MbcntLoOpGenericAdaptor : public detail::MbcntLoOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MbcntLoOpGenericAdaptorBase;
  static constexpr int odsIndex_in0 = 0;
  static constexpr int odsIndex_in1 = 1;
public:
  MbcntLoOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MbcntLoOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MbcntLoOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MbcntLoOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : MbcntLoOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MbcntLoOpGenericAdaptor(RangeT values, const MbcntLoOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MbcntLoOp, typename = std::enable_if_t<std::is_same_v<LateInst, MbcntLoOp>>>
  MbcntLoOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getIn0() {
    return (*getODSOperands(0).begin());
  }

  ValueT getIn1() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MbcntLoOpAdaptor : public MbcntLoOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MbcntLoOpGenericAdaptor::MbcntLoOpGenericAdaptor;
  MbcntLoOpAdaptor(MbcntLoOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MbcntLoOp : public ::mlir::Op<MbcntLoOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MbcntLoOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MbcntLoOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_in0 = 0;
  static constexpr int odsIndex_in1 = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.mbcnt.lo");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getIn0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getIn1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getIn0Mutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getIn1Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &pro