/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: StablehloOps.td                                                      *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace stablehlo {
/// Abs operation
/// Performs element-wise abs operation on `operand` tensor and produces a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#abs
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.abs %operand : tensor<3xi32>
///     ```
class AbsOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Add operation
/// Performs element-wise addition of two tensors `lhs` and `rhs` and produces a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#add
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.add %lhs, %rhs : tensor<2x2xi32>
///     ```
class AddOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// AfterAll operation
/// Ensures that the operations producing the `inputs` are executed before any
///     operations that depend on `result`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#after_all
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.after_all %input0, %input1 : !stablehlo.token
///     ```
class AfterAllOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// AllGather operation
/// Within each process group in the process grid, concatenates the values of the
///     `operand` tensor from each process along `all_gather_dim` and produces a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#all_gather
/// 
///     Example:
///     ```mlir
///     %result:2 = "stablehlo.all_gather"(%operand0, %operand1) {
///       all_gather_dim = 1 : i64,
///       replica_groups = dense<[[0, 1]]> : tensor<1x2xi64>,
///       channel_handle = #stablehlo.channel_handle<handle = 0, type = 0>
///     } : (tensor<2x2xi64>, tensor<2x2xi64>) -> (tensor<2x4xi64>, tensor<2x4xi64>)
///     ```
class AllGatherOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// AllReduce operation
/// Within each process group in the process grid, applies a reduction function
///     `computation` to the values of the `operand` tensor from each process and
///     produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#all_reduce
/// 
///     Example:
///     ```mlir
///     %result:2 = "stablehlo.all_reduce"(%operand0, %operand0) ({
///       ^bb0(%arg0: tensor<i64>, %arg1: tensor<i64>):
///       %0 = "stablehlo.add"(%arg0, %arg1) : (tensor<i64>, tensor<i64>) -> tensor<i64>
///       "stablehlo.return"(%0) : (tensor<i64>) -> ()
///     }) {
///       replica_groups = dense<[[0, 1]]> : tensor<1x2xi64>,
///       channel_handle = #stablehlo.channel_handle<handle = 0, type = 0>
///     } : (tensor<4xi64>, tensor<4xi64>) -> (tensor<4xi64>, tensor<4xi64>)
///     ```
class AllReduceOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// AllToAll operation
/// Within each process group in the process grid, splits the values of the
///     `operand` tensor along `split_dimension` into parts, scatters the split parts
///     between the processes, concatenates the scattered parts along `concat_dimension`
///     and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#all_to_all
/// 
///     Example:
///     ```mlir
///     %result:2 = "stablehlo.all_to_all"(%operand1, %operand2) {
///       split_dimension = 1 : i64,
///       concat_dimension = 0 : i64,
///       split_count = 2 : i64,
///       replica_groups = dense<[[0, 1]]> : tensor<1x2xi64>
///     } : (tensor<2x4xi64>, tensor<2x4xi64>) -> (tensor<4x2xi64>, tensor<4x2xi64>)
///     ```
class AllToAllOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// And operation
/// Performs element-wise AND of two tensors `lhs` and `rhs` and produces a
///     `result` tensor
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#and
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.and %lhs, %rhs : tensor<2x2xi32>
///     ```
class AndOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Atan2 operation
/// Performs element-wise atan2 operation on `lhs` and `rhs` tensor and produces
///     a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#atan2
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.atan2 %lhs, %rhs : tensor<3xf64>
///     ```
class Atan2Op;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// BatchNormGrad operation
/// Computes gradients of several inputs of BatchNormTrainingOp backpropagating
///     from `grad_output`, and produces `grad_operand`, `grad_scale` and
///     `grad_offset` tensors.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#batch_norm_grad
/// 
///     Example:
///     ```mlir
///     %grad_operand, %grad_scale, %grad_offset =
///     "stablehlo.batch_norm_grad"(%operand, %scale, %mean, %variance, %grad_output) {
///       epsilon = 0.0 : f32,
///       feature_index = 2 : i64
///     } : (tensor<2x2x2xf64>, tensor<2xf64>, tensor<2xf64>, tensor<2xf64>,
///          tensor<2x2x2xf64>) -> (tensor<2x2x2xf64>, tensor<2xf64>, tensor<2xf64>)
///     ```
class BatchNormGradOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// BatchNormInference operation
/// Normalizes the `operand` tensor across all dimensions except for the
///     `feature_index` dimension and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#batch_norm_inference
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.batch_norm_inference"(%operand, %scale, %offset, %mean, %variance) {
///       epsilon = 0.0 : f32,
///       feature_index = 2 : i64
///     } : (tensor<2x2x2xf64>, tensor<2xf64>, tensor<2xf64>, tensor<2xf64>, tensor<2xf64>) -> tensor<2x2x2xf64>
///     ```
class BatchNormInferenceOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// BatchNormTraining operation
/// Computes mean and variance across batch and spatial dimensions and
///     normalizes the `operand` tensor, for each feature in the `feature_index`
///     dimension and produces `output`, `batch_mean` and `batch_var` tensors.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#batch_norm_training
/// 
///     Example:
///     ```mlir
///     %output, %batch_mean, %batch_var = "stablehlo.batch_norm_training"(%operand, %scale, %offset) {
///       epsilon = 0.0 : f32,
///       feature_index = 2 : i64
///     } : (tensor<2x2x2xf64>, tensor<2xf64>, tensor<2xf64>) ->
///         (tensor<2x2x2xf64>, tensor<2xf64>, tensor<2xf64>)
///     ```
class BatchNormTrainingOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// BitcastConvert operation
/// Performs a bitcast operation on `operand` tensor and produces a `result`
///     tensor where the bits of the entire `operand` tensor are reinterpreted using
///     the type of the `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#bitcast_convert
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.bitcast_convert %operand : (tensor<f64>) -> tensor<4xf16>
///     ```
class BitcastConvertOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// BroadcastInDim operation
/// Expands the dimensions and/or rank of an input tensor by duplicating the
///     data in the `operand` tensor and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#broadcast_in_dim
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.broadcast_in_dim %operand, dims = [2, 1] : (tensor<1x3xi32>) -> tensor<2x3x2xi32>
///     ```
class BroadcastInDimOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Broadcast operation
/// This operation is on its way out of StableHLO, so it is not included in
///     the StableHLO specification: https://github.com/openxla/stablehlo/issues/3.
/// 
///     Informally, this operation does the same thing as XLA's Broadcast:
///     https://www.tensorflow.org/xla/operation_semantics#broadcast
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.broadcast %operand, sizes = [1, 2] : (tensor<3xi32>) -> tensor<1x2x3xi32>
///     ```
class BroadcastOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Case operation
/// Produces the output from executing exactly one `function` from `branches`
///     depending on the value of `index`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#case
/// 
///     Example:
///     ```mlir
///     %result0, %result1 = "stablehlo.case"(%index) ({
///       stablehlo.return %result_branch0, %result_branch0 : tensor<2xi64>, tensor<2xi64>
///     }, {
///       stablehlo.return %result_branch1, %result_branch1 : tensor<2xi64>, tensor<2xi64>
///     }) : (tensor<i32>) -> (tensor<2xi64>, tensor<2xi64>)
///     ```
class CaseOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Cbrt operation
/// Performs element-wise cubic root operation on `operand` tensor and produces
///     a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#cbrt
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.cbrt %operand : tensor<4xf64>
///     ```
class CbrtOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Ceil operation
/// Performs element-wise ceil of `operand` tensor and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#ceil
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.ceil %operand : tensor<5xf32>
///     ```
class CeilOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Cholesky operation
/// Computes the Cholesky decomposition of a batch of matrices.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#cholesky
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.cholesky %a, lower = true : tensor<3x3xf64>
///     ```
class CholeskyOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Clamp operation
/// Clamps every element of the `operand` tensor between a minimum and maximum
///     value and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#clamp
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.clamp %min, %operand, %max : tensor<3xi32>
///     ```
class ClampOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Clz operation
/// Performs element-wise count of the number of leading zero bits in the
///     `operand` tensor and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#count_leading_zeros
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.count_leading_zeros %operand : tensor<2x2xi64>
///     ```
class ClzOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// CollectiveBroadcast operation
/// Within each process group in the process grid, send the value of the
///     `operand` tensor from the source process to the target processes and produce a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#collective_broadcast
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.collective_broadcast"(%operand) {
///       replica_groups = dense<[[0, 1]]> : tensor<1x2xi64>,
///       channel_handle = #stablehlo.channel_handle<handle = 0, type = 0>
///     } : (tensor<1x2xi64>) -> tensor<1x2xi64>
///     ```
class CollectiveBroadcastOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// CollectivePermute operation
/// Within each process group in the process grid, sends the value of the
///     `operand` tensor from the source process to the target process and produces
///     a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#collective_permute
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.collective_permute"(%operand) {
///       source_target_pairs = dense<[[0, 1], [1, 2]]> : tensor<2x2xi64>,
///       channel_handle = #stablehlo.channel_handle<handle = 0, type = 0>
///     } : (tensor<2x2xi64>) -> tensor<2x2xi64>
///     ```
class CollectivePermuteOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Compare operation
/// Performs element-wise comparison of `lhs` and `rhs` tensors according to
///     `comparison_direction` and `compare_type`, and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#compare
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.compare LT, %lhs, %rhs, FLOAT : (tensor<2xf32>, tensor<2xf32>) -> tensor<2xi1>
///     ```
class CompareOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Complex operation
/// Performs element-wise conversion to a complex value from a pair of real and
///     imaginary values, `lhs` and `rhs`, and produces a `result` tensor.
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#complex
///     Example:
///     ```mlir
///     %result = stablehlo.complex %lhs, %rhs : tensor<2xcomplex<f64>>
///     ```
class ComplexOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Composite operation
/// Encapsulates an operation made up (composed) of other StableHLO operations,
///     taking `inputs` and `composite_attributes` and producing `results`. The
///     semantics of the op are implemented by the `decomposition` attribute. The
///     `composite` op can be replaced with its decomposition without changing program
///     semantics. In cases where inlining the decomposition does not provide the same
///     op semantics, prefer using `custom_call`.
/// 
///     The `version` field (defaults to `0`) is used to denote when a composite's
///     semantics change.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#composite
/// 
///     Example:
///     ```mlir
///     %results = stablehlo.composite "my.op" %input0, %input1 {
///       composite_attributes = {
///         my_attribute = "my_value"
///       },
///       decomposition = @my_op,
///       version = 1 : i32
///     } : (tensor<f32>, tensor<f32>) -> tensor<f32>
///     ```
class CompositeOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Concatenate operation
/// Concatenates a variadic number of tensors in `inputs` along `dimension`
///     dimension in the same order as the given arguments and produces a `result`
///     tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#concatenate
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.concatenate %input0, %input1, dim = 0 : (tensor<3x2xi64>, tensor<1x2xi64>) -> tensor<4x2xi64>
///     ```
class ConcatenateOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Constant operation
/// Produces an `output` tensor from a constant `value`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#constant
/// 
///     Example:
///     ```mlir
///     %output = stablehlo.constant dense<[[0.0, 1.0], [2.0, 3.0]]> : tensor<2x2xf32>
///     ```
class ConstantOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Convert operation
/// Performs an element-wise conversion from one element type to another on
///     `operand` tensor and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#convert
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.convert %operand : (tensor<3xi64>) -> tensor<3xcomplex<f64>>
///     ```
class ConvertOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Convolution operation
/// Computes dot products between windows of `lhs` and slices of `rhs` and
///     produces `result`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#convolution
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.convolution(%lhs, %rhs)
///       dim_numbers = [b, 0, 1, f]x[0, 1, i, o]->[b, 0, 1, f],
///       window = {
///         stride = [4, 4],
///         pad = [[0, 0], [0, 0]],
///         lhs_dilate = [2, 2],
///         rhs_dilate = [1, 1],
///         reverse = [0, 0]
///       } {
///         feature_group_count = 1 : i64,
///         batch_group_count = 1 : i64,
///         precision_config = [#stablehlo<precision DEFAULT>, #stablehlo<precision DEFAULT>]
///       } :
///     (tensor<1x4x4x1xi64>, tensor<3x3x1x1xi64>) -> tensor<1x2x2x1xi64>
///     ```
class ConvolutionOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Cosine operation
/// Performs element-wise cosine operation on `operand` tensor and produces a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#cosine
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.cosine %operand : tensor<2xf32>
///     ```
class CosineOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// CreateToken operation
/// This operation is on its way out of StableHLO, so it is not included in
///     the StableHLO specification: https://github.com/openxla/stablehlo/issues/3.
/// 
///     Informally, this operation does the same thing as AfterAllOp with 0 inputs:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#after_all
/// 
///     Example:
///     ```mlir
///     %output = stablehlo.create_token : !stablehlo.token
///     ```
class CreateTokenOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// CrossReplicaSum operation
/// This operation is on its way out of StableHLO, so it is not included in
///     the StableHLO specification: https://github.com/openxla/stablehlo/issues/3.
/// 
///     Informally, this operation does the same thing as AllReduceOp with
///     `channel_id = 0`, `use_global_device_ids = false` and `computation`
///     implementing addition:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#all_reduce
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.cross-replica-sum"(%operand) {
///       replica_groups = dense<[[0, 1]]> : tensor<1x2xi64>
///     } : (tensor<4xf32>) -> tensor<4xf32>
///     ```
class CrossReplicaSumOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// CustomCall operation
/// Encapsulates an implementation-defined operation `call_target_name` that
///     takes `inputs` and `called_computations` and produces `results`.
/// 
///     Depending on the API version there are two ways to pass extra bits of static
///     information to the external function:
///     1. Use `API_VERSION_TYPED_FFI` which allows passing a dictionary attribute.
///     2. Use a previous API version with a StringAttr to encode backend config.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#custom_call
/// 
///     Example:
///     ```mlir
///     %results = stablehlo.custom_call @foo(%input0) {
///       backend_config = {bar = 42 : i32},
///       api_version = 4 : i32,
///       called_computations = [@foo]
///     } : (tensor<f64>) -> tensor<f64>
///     ```
class CustomCallOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Div operation
/// Performs element-wise division of dividend `lhs` and divisor `rhs` tensors
///     and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#divide
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.divide %lhs, %rhs : tensor<4xf32>
///     ```
class DivOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// DotGeneral operation
/// Computes dot products between slices of `lhs` and slices of `rhs` and
///     produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#dot_general
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.dot_general %lhs, %rhs,
///       batching_dims = [0] x [0],
///       contracting_dims = [2] x [1],
///       precision = [DEFAULT, DEFAULT],
///       algorithm = <lhs_precision_type = tf32, rhs_precision_type = tf32, accumulation_type = f32, lhs_component_count = 1, rhs_component_count = 1, num_primitive_operations = 1, allow_imprecise_accumulation = false>
///       : (tensor<2x2x2xi64>, tensor<2x2x2xi64>) -> tensor<2x2x2xi64>
///     ```
class DotGeneralOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Dot operation
/// This operation is on its way out of StableHLO, so it is not included in
///     the StableHLO specification: https://github.com/openxla/stablehlo/issues/3.
/// 
///     Informally, this operation does the same thing as XLA's Dot:
///     https://www.tensorflow.org/xla/operation_semantics#dot
/// 
///     Example:
///     ```mlir
///     %0 = stablehlo.dot %arg0, %arg1 : (tensor<1x2xi32>, tensor<2x1xi32>) -> tensor<1x1xi32>
///     ```
class DotOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// DynamicBroadcastInDim operation
/// This operation is functionally identical to
///     [broadcast_in_dim](https://github.com/openxla/stablehlo/blob/main/docs/spec.md#broadcast_in_dim)
///     op, but the result shape is specified dynamically via `output_dimensions`.
/// 
///     It also accepts optional attributes to express static knowledge about the
///     expanding behavior of dimensions. If not specified, all dimensions are
///     assumed to be possibly expanding. The sets of dimensions that are known to
///     be expanding and the set of dimensions that are known to be non-expanding
///     must be disjoint and they must be a subset of the operand's dimensions.
/// 
///     See: https://github.com/openxla/stablehlo/blob/main/docs/spec.md#dynamic_broadcast_in_dim
/// 
///     Example:
///     ```mlir
///     %operand = stablehlo.constant dense<[[1, 2, 3]]> : tensor<1x3xi64>
///     %output_dimensions = stablehlo.constant dense<[2, 3, 2]> : tensor<3xi64>
///     %result = "stablehlo.dynamic_broadcast_in_dim"(%operand, %output_dimensions) {
///       broadcast_dimensions = array<i64: 2, 1>,
///       known_expanding_dimensions = array<i64: 0>,
///       known_nonexpanding_dimensions = array<i64: 1>
///     } : (tensor<1x3xi64>, tensor<3xi64>) -> tensor<2x3x2xi64>
///     ```
class DynamicBroadcastInDimOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// DynamicConv operation
/// This operation is functionally identical to
///     [convolution](https://github.com/openxla/stablehlo/blob/main/docs/spec.md#convolution)
///     op, but the padding is specified dynamically via `padding`.
/// 
///     Example:
///     ```mlir
///     %padding = stablehlo.constant dense<2> : tensor<2x2xi64>
///     %result = "stablehlo.dynamic_conv"(%lhs, %rhs, %padding) {
///       window_strides = array<i64: 4, 4>,
///       lhs_dilation = array<i64: 2, 2>,
///       rhs_dilation = array<i64: 1, 1>,
///       window_reversal = array<i1: false, false>,
///       dimension_numbers = #stablehlo.conv<[b, 0, 1, f]x[0, 1, i, o]->[b, 0, 1, f]>,
///       batch_group_count = 1 : i64,
///       feature_group_count = 1 : i64,
///       precision_config = [#stablehlo<precision DEFAULT>, #stablehlo<precision DEFAULT>]
///     } : (tensor<1x4x4x1xi64>, tensor<3x3x1x1xi64>, tensor<2x2xi64>) -> tensor<1x2x2x1xi64>
///     ```
class DynamicConvOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// DynamicGather operation
/// This operation is functionally identical to
///     [gather](https://github.com/openxla/stablehlo/blob/main/docs/spec.md#gather)
///     op, with the `slice_sizes` specified dynamically as an operand.
/// 
///     Example:
///     ```mlir
///     %slice_sizes = stablehlo.constant dense<[1, 2, 2]> : tensor<3xi64>
///     %result = "stablehlo.dynamic_gather"(%operand, %start_indices, %slice_sizes) {
///       dimension_numbers = #stablehlo.gather<
///         offset_dims = [2, 3],
///         collapsed_slice_dims = [0],
///         start_index_map = [0, 2],
///         index_vector_dim = 2>,
///       indices_are_sorted = false
///     } : (tensor<3x4x2xi64>, tensor<2x3x2xi64>, tensor<3xi64>) -> tensor<2x3x2x2xi64>
///     ```
class DynamicGatherOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// DynamicIota operation
/// This operation is functionally identical to
///     [iota](https://github.com/openxla/stablehlo/blob/main/docs/spec.md#iota)
///     op, but the result shape is specified dynamically via `output_shape`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#dynamic_iota
/// 
///     Example:
///     ```mlir
///     %output_shape = stablehlo.constant dense<[4, 5]> : tensor<2xi64>
///     %0 = stablehlo.dynamic_iota %output_shape, dim = 0 : (tensor<2xi64>) -> tensor<4x5xi64>
///     ```
class DynamicIotaOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// DynamicPad operation
/// This operation is functionally identical to
///     [pad](https://github.com/openxla/stablehlo/blob/main/docs/spec.md#pad)
///     https://github.com/openxla/stablehlo/pull/2306#discussion_r1595669709
///     op, but with `edge_padding_low`, `edge_padding_high` and `interior_padding`
///     specified dynamically as values.
/// 
///     See: https://github.com/openxla/stablehlo/blob/main/docs/spec.md#dynamic_pad
/// 
///     Example:
///     ```mlir
///     %edge_padding_low = stablehlo.constant dense<[0, 1]> : tensor<2xi32>
///     %edge_padding_high = stablehlo.constant dense<[2, 1]> : tensor<2xi32>
///     %interior_padding = stablehlo.constant dense<[1, 2]> : tensor<2xi32>
///     %result = stablehlo.dynamic_pad %operand, %padding_value,
///                 %edge_padding_low, %edge_padding_high, %interior_padding
///                 : (tensor<2x3xi64>, tensor<i64>, tensor<2xi64>, tensor<2xi64>, tensor<2xi64>) -> tensor<5x9xi64>
///     ```
class DynamicPadOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// DynamicReshape operation
/// This operation is functionally identical to
///     [reshape](https://github.com/openxla/stablehlo/blob/main/docs/spec.md#reshape)
///     op, but the result shape is specified dynamically via `output_shape`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#dynamic_reshape
/// 
///     Example:
///     ```mlir
///     %output_shape = stablehlo.constant dense<[3, 2]> : tensor<2xi64>
///     %result = stablehlo.dynamic_reshape %operand, %output_shape : (tensor<2x3xi64>, tensor<2xi64>) -> tensor<3x2xi64>
///     ```
class DynamicReshapeOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// DynamicSlice operation
/// Extracts a slice from the `operand` using dynamically-computed starting
///     indices and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#dynamic_slice
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.dynamic_slice %operand, %start_indices0, %start_indices1, sizes = [2, 2]
///       : (tensor<4x4xi32>, tensor<i64>, tensor<i64>) -> tensor<2x2xi32>
///     ```
class DynamicSliceOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// DynamicUpdateSlice operation
/// Produces a `result` tensor which is equal to the `operand` tensor except
///     that the slice starting at `start_indices` is updated with the values in
///     `update`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#dynamic_update_slice
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.dynamic_update_slice %operand, %update, %start_indices0, %start_indices1
///       : (tensor<4x4xi32>, tensor<2x2xi32>, tensor<i64>, tensor<i64>) -> tensor<4x4xi32>
///     ```
class DynamicUpdateSliceOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Einsum operation
/// This operation is on its way out of StableHLO, so it is not included in
///     the StableHLO specification: https://github.com/openxla/stablehlo/issues/3.
/// 
///     Informally, this operation does the same thing as TF's einsum:
///     https://www.tensorflow.org/api_docs/python/tf/einsum
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.einsum"(%lhs, %rhs) {
///       einsum_config = "ab,bc->ac"
///     } : (tensor<4x16xf32>, tensor<16x4xf32>) -> tensor<4x4xf32>
///     ```
class EinsumOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Exp operation
/// Performs element-wise exponential operation on `operand` tensor and produces
///     a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#exponential
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.exponential %operand : tensor<2x2xf64>
///     ```
class ExpOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Expm1 operation
/// Performs element-wise exponential minus one operation on `operand` tensor
///     and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#exponential_minus_one
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.exponential_minus_one %operand : tensor<2xf64>
///     ```
class Expm1Op;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Fft operation
/// Performs the forward and inverse Fourier transforms for real and complex
///     inputs/outputs.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#fft
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.fft %operand, type = FFT, length = [4] : (tensor<4xcomplex<f32>>) -> tensor<4xcomplex<f32>>
///     ```
class FftOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Floor operation
/// Performs element-wise floor of `operand` tensor and produces a `result`
///     tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#floor
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.floor %operand : tensor<2xf32>
///     ```
class FloorOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Gather operation
/// Gathers slices from `operand` tensor from offsets specified in
///     `start_indices` and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#gather
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.gather"(%operand, %start_indices) {
///       dimension_numbers = #stablehlo.gather<
///         offset_dims = [3, 4],
///         collapsed_slice_dims = [1],
///         operand_batching_dims = [0],
///         start_indices_batching_dims = [1],
///         start_index_map = [2, 1],
///         index_vector_dim = 3>,
///       slice_sizes = array<i64: 1, 1, 2, 2>,
///       indices_are_sorted = false
///     } : (tensor<2x3x4x2xi64>, tensor<2x2x3x2xi64>) -> tensor<2x2x3x2x2xi64>
///     ```
class GatherOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// GetDimensionSize operation
/// Produces the size of the given `dimension` of the `operand`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#get_dimension_size
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.get_dimension_size %operand, dim = 1 : (tensor<2x3xi64>) -> tensor<i32>
///     ```
class GetDimensionSizeOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// GetTupleElement operation
/// Extracts element at `index` position of the `operand` tuple and produces a
///     `result`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#get_tuple_element
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.get_tuple_element %operand[0] : (tuple<tensor<2xf64>, tuple<tensor<i64>>>) -> tensor<2xf64>
///     ```
class GetTupleElementOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// If operation
/// Produces the output from executing exactly one branch from `true_branch` or
///     `false_branch` depending on the value of `pred`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#if
/// 
///     Example:
///     %result = "stablehlo.if"(%pred) ({
///       "stablehlo.return"(%result_true_branch) : (tensor<i32>) -> ()
///     }, {
///       "stablehlo.return"(%result_false_branch) : (tensor<i32>) -> ()
///     }) : (tensor<i1>) -> tensor<i32>
class IfOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Imag operation
/// Extracts the imaginary part, element-wise, from the `operand` and produces a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#imag
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.imag %operand : (tensor<2xcomplex<f32>>) -> tensor<2xf32>
///     ```
class ImagOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Infeed operation
/// Reads data from the infeed and produces `results`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#infeed
/// 
///     Example:
///     ```mlir
///     %results0:2 = "stablehlo.infeed"(%token) :
///         (!stablehlo.token) -> (tensor<2x2xi64>, !stablehlo.token)
///     ```
class InfeedOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Iota operation
/// Fills an `output` tensor with values in increasing order starting from zero
///     along the `iota_dimension` dimension.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#iota
/// 
///     Example:
///     ```mlir
///     %output = stablehlo.iota dim = 0 : tensor<4x5xi32>
///     ```
class IotaOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// IsFinite operation
/// Performs element-wise check whether the value in `x` is finite (i.e. is
///     neither +Inf, -Inf, nor NaN) and produces a `y` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#is_finite
/// 
///     Example:
///     ```mlir
///     %y = stablehlo.is_finite %x : (tensor<7xf64>) -> tensor<7xi1>
///     ```
class IsFiniteOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Log1p operation
/// Performs element-wise logarithm plus one operation on `operand` tensor and
///     produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#log_plus_one
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.log_plus_one %operand : tensor<5xf64>
///     ```
class Log1pOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Log operation
/// Performs element-wise logarithm operation on `operand` tensor and produces a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#log
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.log %operand : tensor<2x2xf64>
///     ```
class LogOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Logistic operation
/// Performs element-wise logistic operation on `operand` tensor and produces a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#logistic
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.logistic %operand : tensor<2x2xf64>
///     ```
class LogisticOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Map operation
/// Applies a map function `computation` to `inputs` along the `dimensions` and
///     produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#map
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.map"(%input0, %input1) ({
///       ^bb0(%arg0: tensor<i64>, %arg1: tensor<i64>):
///         %0 = stablehlo.multiply %arg0, %arg1 : tensor<i64>
///         stablehlo.return %0 : tensor<i64>
///     }) {
///       dimensions = array<i64: 0, 1>
///     } : (tensor<2x2xi64>, tensor<2x2xi64>) -> tensor<2x2xi64>
///     ```
class MapOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Max operation
/// Performs element-wise max operation on tensors `lhs` and `rhs` and produces
///     a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#maximum
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.maximum %lhs, %rhs : tensor<4xf32>
///     ```
class MaxOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Min operation
/// Performs element-wise min operation on tensors `lhs` and `rhs` and produces a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#minimum
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.minimum %lhs, %rhs : tensor<4xf32>
///     ```
class MinOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Mul operation
/// Performs element-wise product of two tensors `lhs` and `rhs` and produces a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#multiply
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.multiply %lhs, %rhs : tensor<2xi32>
///     ```
class MulOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Neg operation
/// Performs element-wise negation of `operand` tensor and produces a `result`
///     tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#negate
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.negate %operand : tensor<2x3xi32>
///     ```
class NegOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Not operation
/// Performs element-wise NOT of tensor `operand` of type integer and produces
///     a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#not
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.not %operand : tensor<5x3x1xi1>
///     ```
class NotOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// OptimizationBarrier operation
/// Ensures that the operations that produce the `operand` are executed before any
///     operations that depend on the `result` and prevents compiler transformations
///     from moving operations across the barrier. Other than that, the operation is
///     an identity, i.e. `result` = `operand`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#optimization_barrier
/// 
///     Example:
///     ```mlir
///     %result0, %result1 = stablehlo.optimization_barrier %operand0, %operand1 : tensor<f32>, tensor<f32>
///     ```
class OptimizationBarrierOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Or operation
/// Performs element-wise OR of two tensors `lhs` and `rhs` and produces a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#or
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.or %lhs, %rhs : tensor<2xi1>
///     ```
class OrOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Outfeed operation
/// Writes `inputs` to the outfeed and produces a `result` token.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#outfeed
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.outfeed"(%input0, %token) :
///         (tensor<2x2x2xi64>, !stablehlo.token) -> !stablehlo.token
///     ```
class OutfeedOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Pad operation
/// Expands `operand` by padding around the tensor as well as between the
///     elements of the tensor with the given `padding_value`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#pad
/// 
///     Example:
///     ```mlir
///     %0 = stablehlo.pad %arg0, %arg1, low = [0, 1], high = [2, 1], interior = [1, 2]
///       : (tensor<2x3xi32>, tensor<i32>) -> tensor<5x9xi32>
///     ```
class PadOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// PartitionId operation
/// Produces `partition_id` of the current process.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#partition_id
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.partition_id : tensor<ui32>
///     ```
class PartitionIdOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// PopulationCount operation
/// Performs element-wise count of the number of bits set in the `operand`
///     tensor and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#popcnt
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.popcnt %operand : tensor<4xi64>
///     ```
class PopulationCountOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Power operation
/// Performs element-wise exponentiation of `lhs` tensor by `rhs` tensor and
///     produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#power
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.power %lhs, %rhs : tensor<6xf64>
///     ```
class PowOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// RealDynamicSlice operation
/// This operation is a work in progress, so it is not yet included in
///     the StableHLO specification: https://github.com/openxla/stablehlo/issues/8.
/// 
///     Informally, this operation does the same thing as SliceOp except
///     that `start_indices`, `limit_indices` and `strides` are specified dynamically:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#slice
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.real_dynamic_slice %operand,
///                 %start_indices, %limit_indices, %strides
///            : (tensor<256x?xf32>, tensor<2xindex>, tensor<2xindex>, tensor<2xindex>) -> tensor<256x?xf32>
///     ```
class RealDynamicSliceOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Real operation
/// Extracts the real part, element-wise, from the `operand` and produces a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#real
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.real %operand : (tensor<2xcomplex<f32>>) -> tensor<2xf32>
///     ```
class RealOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Recv operation
/// Receives data from a channel with `channel_id` and produces `results`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#recv
/// 
///     Example:
///     ```mlir
///     %results:2 = "stablehlo.recv"(%token) {
///       channel_handle = #stablehlo.channel_handle<handle = 0, type = 1>,
///       is_host_transfer = false,
///       source_target_pairs = dense<[[0, 1], [1, 2]]> : tensor<2x2xi64>
///     } : (!stablehlo.token) -> (tensor<2x2xi64>, !stablehlo.token)
///     ```
class RecvOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Reduce operation
/// Applies a reduction function `body` to `inputs` and `init_values` along the
///     `dimensions` and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#reduce
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.reduce"(%input, %init_value) ({
///       ^bb0(%arg0: tensor<i64>, %arg1: tensor<i64>):
///         %0 = stablehlo.add %arg0, %arg1 : tensor<i64>
///         stablehlo.return %0 : tensor<i64>
///     }) {
///       dimensions = array<i64: 1>
///     } : (tensor<1x6xi64>, tensor<i64>) -> tensor<1xi64>
///     ```
class ReduceOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// ReducePrecision operation
/// Performs element-wise conversion of `operand` to another floating-point type
///     that uses `exponent_bits` and `mantissa_bits` and back to the original
///     floating-point type and produces an `output` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#reduce_precision
/// 
///     Example:
///     ```mlir
///     %output = stablehlo.reduce_precision %operand, format = e5m10 : tensor<6xf64>
///     ```
class ReducePrecisionOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// ReduceScatter operation
/// Within each process group in the process grid, performs reduction, using
///      `computations`, over the values of the `operand` tensor from each process,
///      splits the reduction result along `scatter_dimension` into parts, and
///      scatters the split parts between the processes to produce the `result`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#reduce_scatter
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.reduce_scatter"(%operand) ({
///       ^bb0(%arg0: tensor<i64>, %arg1: tensor<i64>):
///       %0 = stablehlo.add %arg0, %arg1 : tensor<i64>
///       stablehlo.return %0 : tensor<i64>
///     }) {
///       scatter_dimension = 1 : i64,
///       replica_groups = dense<[[0, 1]]> : tensor<1x2xi64>,
///       channel_handle = #stablehlo.channel_handle<handle = 0, type = 0>
///     } : (tensor<2x4xi64>) -> tensor<2x2xi64>
///     ```
class ReduceScatterOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// ReduceWindow operation
/// Applies a reduction function `body` to windows of `inputs` and `init_values`
///     and produces `results`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#reduce_window
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.reduce_window"(%input, %init_value) ({
///       ^bb0(%arg0: tensor<i64>, %arg1: tensor<i64>):
///         %0 = stablehlo.add %arg0, %arg1 : tensor<i64>
///         stablehlo.return %0 : tensor<i64>
///     }) {
///       window_dimensions = array<i64: 2, 1>,
///       window_strides = array<i64: 4, 1>,
///       base_dilations = array<i64: 2, 1>,
///       window_dilations = array<i64: 3, 1>,
///       padding = dense<[[2, 1], [0, 0]]> : tensor<2x2xi64>
///     } : (tensor<3x2xi64>, tensor<i64>) -> tensor<2x2xi64>
///     ```
class ReduceWindowOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Rem operation
/// Performs element-wise remainder of dividend `lhs` and divisor `rhs` tensors
///     and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#remainder
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.remainder %lhs, %rhs : tensor<4xi64>
///     ```
class RemOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// ReplicaId operation
/// Produces `replica_id` of the current process.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#replica_id
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.replica_id : tensor<ui32>
///     ```
class ReplicaIdOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Reshape operation
/// Performs reshape of `operand` tensor to a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#reshape
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.reshape %operand : (tensor<2xf32>) -> tensor<1x2xf32>
///     ```
class ReshapeOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// This operation is a work in progress, so it is not yet included in
///     the StableHLO specification: https://github.com/openxla/stablehlo/issues/425.
/// 
///     Informally, this operation serves as a terminator for regions defined by
///     the StableHLO ops. Non-StableHLO ops, e.g. `func.func`, have their own
///     terminators, e.g. `func.return`.
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.reduce"(%input, %init_value) ({
///       ^bb0(%arg0: tensor<i32>, %arg1: tensor<i32>):
///         %0 = "stablehlo.add"(%arg0, %arg1) : (tensor<i32>, tensor<i32>) -> tensor<i32>
///         "stablehlo.return"(%0) : (tensor<i32>) -> ()
///     }) {
///       dimensions = array<i64: 1>
///     } : (tensor<1x6xi32>, tensor<i32>) -> tensor<1xi32>
///     ```
class ReturnOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Reverse operation
/// Reverses the order of elements in the `operand` along the specified
///     `dimensions` and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#reverse
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.reverse %operand, dims = [1] : tensor<3x2xi32>
///     ```
class ReverseOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// RngBitGenerator operation
/// Returns an `output` filled with uniform random data and an updated output
///     state `output_state` given an initial state `initial_state` using the
///     pseudorandom number generator algorithm `rng_algorithm`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#rng_bit_generator
/// 
///     Example:
///     ```mlir
///     %output_state, %output = stablehlo.rng_bit_generator %initial_state, algorithm = THREE_FRY : (tensor<2xui64>) -> (tensor<2xui64>, tensor<2x2xui64>)
///     ```
class RngBitGeneratorOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Rng operation
/// Generates random numbers using the `rng_distribution` algorithm and produces
///     a `result` tensor of a given shape `shape`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#rng
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.rng %a, %b, %shape, distribution = NORMAL : (tensor<i32>, tensor<i32>, tensor<2xi64>) -> tensor<3x3xi32>
///     ```
class RngOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// RoundNearestEven operation
/// Performs element-wise rounding towards the nearest integer, breaking ties
///     towards the even integer, on the `operand` tensor and produces a `result`
///     tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#round_nearest_even
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.round_nearest_even %operand : tensor<5xf64>
///     ```
class RoundNearestEvenOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Round operation
/// Performs element-wise rounding towards the nearest integer, breaking ties
///     away from zero, on the `operand` tensor and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#round_nearest_afz
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.round_nearest_afz %operand : tensor<5xf64>
///     ```
class RoundOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Rsqrt operation
/// Performs element-wise reciprocal square root operation on `operand` tensor
///     and produces a `result` tensor, implementing the `rSqrt` operation from the
///     IEEE-754 specification.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#rsqrt
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.rsqrt %operand : tensor<2x2xf32>
///     ```
class RsqrtOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Scatter operation
/// Produces `results` tensors which are equal to `inputs` tensors except that
///     several slices specified by `scatter_indices` are updated with the values
///     `updates` using `update_computation`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#scatter
/// 
///    Example:
///    ```mlir
///    %result = "stablehlo.scatter"(%input, %scatter_indices, %update) ({
///      ^bb0(%arg0: tensor<i64>, %arg1: tensor<i64>):
///        %0 = stablehlo.add %arg0, %arg1 : tensor<i64>
///        stablehlo.return %0 : tensor<i64>
///    }) {
///      scatter_dimension_numbers = #stablehlo.scatter<
///        update_window_dims = [3, 4],
///        inserted_window_dims = [1],
///        input_batching_dims = [0],
///        scatter_indices_batching_dims = [1],
///        scatter_dims_to_operand_dims = [2, 1],
///        index_vector_dim = 3>,
///      indices_are_sorted = false,
///      unique_indices = false
///    } : (tensor<2x3x4x2xi64>, tensor<2x2x3x2xi64>, tensor<2x2x3x2x2xi64>) -> tensor<2x3x4x2xi64>
///    ```
class ScatterOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// SelectAndScatter operation
/// Scatters the values from the `source` tensor using `scatter` based on the
///     outcome of `reduce_window` of the `input` tensor using `select` and produces
///     a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#select_and_scatter
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.select_and_scatter"(%operand, %source, %init_value) ({
///       ^bb0(%arg0: tensor<i64>, %arg1: tensor<i64>):
///         %0 = stablehlo.compare GE, %arg0, %arg1 : (tensor<i64>, tensor<i64>) -> tensor<i1>
///         stablehlo.return %0 : tensor<i1>
///     }, {
///       ^bb0(%arg0: tensor<i64>, %arg1: tensor<i64>):
///         %0 = stablehlo.add %arg0, %arg1 : tensor<i64>
///         stablehlo.return %0 : tensor<i64>
///     }) {
///       window_dimensions = array<i64: [3, 1]>,
///       window_strides = array<i64: [2, 1]>,
///       padding = dense<[[0, 1], [0, 0]]> : tensor<2x2xi64>
///     } : (tensor<4x2xi64>, tensor<2x2xi64>, tensor<i64>) -> tensor<4x2xi64>
///     ```
class SelectAndScatterOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Select operation
/// Produces a `result` tensor where each element is selected from `on_true` or
///     `on_false` tensor based on the value of the corresponding element of `pred`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#select
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.select %pred, %on_true, %on_false : tensor<2x2xi1>, tensor<2x2xi32>
///     ```
class SelectOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Send operation
/// Sends `inputs` to a channel `channel_id` and produces a `result` token.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#send
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.send"(%operand, %token) {
///       channel_handle = #stablehlo.channel_handle<handle = 0, type = 1>,
///       is_host_transfer = false,
///       source_target_pairs = dense<[[0, 1], [1, 2]]> : tensor<2x2xi64>
///     } : (tensor<2x2xi64>, !stablehlo.token) -> !stablehlo.token
///     ```
class SendOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// SetDimensionSize operation
/// This operation is a work in progress, so it is not yet included in
///     the StableHLO specification: https://github.com/openxla/stablehlo/issues/8.
/// 
///     Informally, this operation does the same thing as XLA's SetDimensionSize:
///     https://www.tensorflow.org/xla/operation_semantics#setdimensionsize
/// 
///     Example:
///     ```mlir
///     %0 = stablehlo.set_dimension_size %arg0, %arg1, dim = 1 : (tensor<4x2xf32>, tensor<i32>) -> tensor<4x2xf32>
///     ```
class SetDimensionSizeOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// ShiftLeft operation
/// Performs element-wise left-shift operation on the `lhs` tensor by `rhs`
///     number of bits and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#shift_left
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.shift_left %lhs, %rhs : tensor<3xi64>
///     ```
class ShiftLeftOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// ShiftRightArithmetic operation
/// Performs element-wise arithmetic right-shift operation on the `lhs` tensor
///     by `rhs` number of bits and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#shift_right_arithmetic
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.shift_right_arithmetic %lhs, %rhs : tensor<3xi64>
///     ```
class ShiftRightArithmeticOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// ShiftRightLogical operation
/// Performs element-wise logical right-shift operation on the `lhs` tensor by
///     `rhs` number of bits and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#shift_right_logical
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.shift_right_logical %lhs, %rhs : tensor<3xi64>
///     ```
class ShiftRightLogicalOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Sign operation
/// Returns the sign of the `operand` element-wise and produces a `result`
///     tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#sign
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.sign %operand : tensor<5xf64>
///     ```
class SignOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Sine operation
/// Performs element-wise sine operation on `operand` tensor and produces a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#sine
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.sine %operand : tensor<2xf32>
///     ```
class SineOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Slice operation
/// Extracts a slice from the `operand` using statically-computed starting
///     indices and produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#slice
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.slice %operand [1:3, 4:8:2]
///        : (tensor<3x8xi64>) -> tensor<2x2xi64>
/// 
///     // Same in generic form: the `1:3` above is mapped to the first entry in
///     // `start_indices` and `limit_indices`, while `strides` is implicitly 1.
///     // The `4:8:2` above is parsed into the second entry of `start_indices`,
///     // `limit_indices` and `strides` respectively.
///     %result = "stablehlo.slice" (%operand) {
///       start_indices = array<i64: 1, 4>,
///       limit_indices = array<i64: 3, 8>,
///       strides = array<i64: 1, 2>
///     } : (tensor<3x8xi64>) -> tensor<2x2xi64>
///     ```
class SliceOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Sort operation
/// Sorts a variadic number of tensors in `inputs` together, according to a
///     custom `comparator`, along the given `dimension` and produces a variadic
///     number of tensors as `results`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#sort
/// 
///     Example:
///     ```mlir
///     %result0, %result1 = "stablehlo.sort"(%input0, %input1) ({
///       ^bb0(%arg0: tensor<i64>, %arg1: tensor<i64>, %arg2: tensor<i64>, %arg3: tensor<i64>):
///         %predicate = stablehlo.compare GT, %arg0, %arg1 : (tensor<i64>, tensor<i64>) -> tensor<i1>
///         stablehlo.return %predicate : tensor<i1>
///     }) {
///       dimension = 0 : i64,
///       is_stable = true
///     } : (tensor<2x3xi64>, tensor<2x3xi64>) -> (tensor<2x3xi64>, tensor<2x3xi64>)
class SortOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Sqrt operation
/// Performs element-wise square root operation on `operand` tensor and produces
///     a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#sqrt
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.sqrt %operand : tensor<2x2xf32>
///     ```
class SqrtOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Subtract operation
/// Performs element-wise subtraction of two tensors `lhs` and `rhs` and
///     produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#subtract
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.subtract %lhs, %rhs : tensor<2xi32>
///     ```
class SubtractOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Tan operation
/// Performs element-wise tangent operation on `operand` tensor and
///     produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#tan
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.tan %operand : tensor<2x2xf64>
///     ```
class TanOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Tanh operation
/// Performs element-wise hyperbolic tangent operation on `operand` tensor and
///     produces a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#tanh
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.tanh %operand : tensor<2xf32>
///     ```
class TanhOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// TorchIndexSelect operation
/// This operation is on its way out of StableHLO, so it is not included in
///     the StableHLO specification: https://github.com/openxla/stablehlo/issues/3.
/// 
///     Informally, this operation does the same thing as PyTorch's index_select,
///     augmented with support for batch dimensions:
///     https://pytorch.org/docs/stable/generated/torch.index_select.html.
/// 
///     The `batch_dims` attribute specifies the number of major batch dimensions
///     (0 or more) that act like a multidimensional loop over both the operand and
///     the index.
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.torch_index_select"(%operand, %index) {
///       dim = 2 : i64,
///       batch_dims = 1 : i64
///     } : (tensor<8x128x3072x64xf32>, tensor<8x16x1024xi32>) -> tensor<8x128x16x1024x64xf32>
///     ```
class TorchIndexSelectOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Transpose operation
/// Permutes the dimensions of `operand` tensor using `permutation` and produces
///     a `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#transpose
/// 
///     Example:
///     ```mlir
///     %0 = stablehlo.transpose %arg0, dims = [2, 1, 0] : (tensor<1x2x3xi32>) -> tensor<3x2x1xi32>
///     ```
class TransposeOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// TriangularSolve operation
/// Solves batches of systems of linear equations with lower or upper triangular
///     coefficient matrices.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#triangular_solve
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.triangular_solve"(%a, %b) {
///       left_side = true,
///       lower = true,
///       unit_diagonal = false,
///       transpose_a = #stablehlo<transpose NO_TRANSPOSE>
///     } : (tensor<3x3xf32>, tensor<3x3xf32>) -> tensor<3x3xf32>
///     ```
class TriangularSolveOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Tuple operation
/// Produces a `result` tuple from values `val`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#tuple
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.tuple %val0, %val1 : tuple<tensor<2xf64>, tuple<tensor<i64>>>
///     ```
class TupleOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// UnaryEinsum operation
/// This operation is on its way out of StableHLO, so it is not included in
///     the StableHLO specification: https://github.com/openxla/stablehlo/issues/3.
/// 
///     Informally, this operation does the same thing as TF's einsum:
///     https://www.tensorflow.org/api_docs/python/tf/einsum
/// 
///     Example:
///     ```mlir
///     %result = "stablehlo.unary_einsum"(%operand) {
///       einsum_config = "ab->a"
///     } : (tensor<4x16xf32>) -> tensor<4xf32>
///     ```
class UnaryEinsumOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// UniformDequantize operation
/// Performs element-wise conversion of quantized tensor `operand` to a
///     floating-point tensor `result` according to the quantization parameters
///     defined by the `operand` type.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#uniform_dequantize
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.uniform_dequantize %operand : (tensor<2x!quant.uniform<i8:f32:0, {0.1:-30,0.5:-20}>>) -> tensor<2xf32>
///     ```
class UniformDequantizeOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// UniformQuantize operation
/// Performs element-wise conversion of floating-point tensor or quantized
///     tensor `operand` to a quantized tensor `result` according to the
///     quantization parameters defined by the `result` type.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#uniform_quantize
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.uniform_quantize %operand : (tensor<2xf32>) -> tensor<2x!quant.uniform<i8:f32:0, {0.1:-30,0.5:-20}>>
///     ```
class UniformQuantizeOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// While operation
/// Produces the output from executing `body` function 0 or more times while the
///     `cond` function outputs `true`.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#while
/// 
///     Example:
///     ```mlir
///     %results0, %results1 = stablehlo.while(%arg0 = %init_i, %arg1 = %init_sum) : tensor<i64>, tensor<i64>
///     cond {
///       %cond = stablehlo.compare LT, %arg0, %ten : (tensor<i64>, tensor<i64>) -> tensor<i1>
///       stablehlo.return %cond : tensor<i1>
///     } do {
///       %new_sum = stablehlo.add %arg1, %one : tensor<i64>
///       %new_i = stablehlo.add %arg0, %one : tensor<i64>
///       stablehlo.return %new_i, %new_sum : tensor<i64>, tensor<i64>
///     }
///     ```
class WhileOp;
} // namespace stablehlo
} // namespace mlir
namespace mlir {
namespace stablehlo {
/// Xor operation
/// Performs element-wise XOR of two tensors `lhs` and `rhs` and produces a
///     `result` tensor.
/// 
///     See:
///     https://github.com/openxla/stablehlo/blob/main/docs/spec.md#xor
/// 
///     Example:
///     ```mlir
///     %result = stablehlo.xor %lhs, %rhs : tensor<2xi32>
///     ```
class XorOp;
} // namespace stablehlo
} // namespace mlir
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::AbsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AbsOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AbsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.abs", odsAttrs.getContext());
  }

  AbsOpGenericAdaptorBase(AbsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AbsOpGenericAdaptor : public detail::AbsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AbsOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  AbsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AbsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AbsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AbsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AbsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AbsOpGenericAdaptor(RangeT values, const AbsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AbsOp, typename = std::enable_if_t<std::is_same_v<LateInst, AbsOp>>>
  AbsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AbsOpAdaptor : public AbsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AbsOpGenericAdaptor::AbsOpGenericAdaptor;
  AbsOpAdaptor(AbsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AbsOp : public ::mlir::Op<AbsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::InferTypeOpInterface::Trait, ::mlir::OpTrait::Elementwise, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AbsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AbsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.abs");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static AbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static AbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static AbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static AbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static AbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static AbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AbsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AbsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::AbsOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::AddOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AddOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AddOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.add", odsAttrs.getContext());
  }

  AddOpGenericAdaptorBase(AddOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AddOpGenericAdaptor : public detail::AddOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AddOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  AddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AddOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AddOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AddOpGenericAdaptor(RangeT values, const AddOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AddOp, typename = std::enable_if_t<std::is_same_v<LateInst, AddOp>>>
  AddOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AddOpAdaptor : public AddOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AddOpGenericAdaptor::AddOpGenericAdaptor;
  AddOpAdaptor(AddOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AddOp : public ::mlir::Op<AddOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::hlo::OpTrait::IsCommutative, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::OpTrait::Elementwise, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AddOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AddOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.add");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                               operands.front(),
                                               &reifiedReturnShapes);
  }

  static LogicalResult inferReturnTypes(
      MLIRContext * /*context*/, std::optional<Location> location,
      ValueRange operands, DictionaryAttr /*attributes*/,
      OpaqueProperties /*properties*/, RegionRange /*regions*/,
      SmallVectorImpl<Type> &inferredReturnTypes) {
    if (operands.empty())
      return emitOptionalError(
          location,
          "Expected non-empty operands for AddOp::inferReturnTypes");

    auto inferredTypeOrErr =
        mlir::hlo::inferMostSpecificType(location, operands.getTypes());
    if (failed(inferredTypeOrErr)) return failure();
    inferredReturnTypes.emplace_back(*inferredTypeOrErr);
    return success();
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::AddOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::AfterAllOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AfterAllOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AfterAllOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.after_all", odsAttrs.getContext());
  }

  AfterAllOpGenericAdaptorBase(AfterAllOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AfterAllOpGenericAdaptor : public detail::AfterAllOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AfterAllOpGenericAdaptorBase;
  static constexpr int odsIndex_inputs = 0;
public:
  AfterAllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AfterAllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AfterAllOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AfterAllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AfterAllOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AfterAllOpGenericAdaptor(RangeT values, const AfterAllOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AfterAllOp, typename = std::enable_if_t<std::is_same_v<LateInst, AfterAllOp>>>
  AfterAllOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getInputs() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AfterAllOpAdaptor : public AfterAllOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AfterAllOpGenericAdaptor::AfterAllOpGenericAdaptor;
  AfterAllOpAdaptor(AfterAllOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AfterAllOp : public ::mlir::Op<AfterAllOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AfterAllOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AfterAllOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_inputs = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.after_all");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getInputs() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getInputsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::ValueRange inputs);
  static AfterAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::ValueRange inputs);
  static AfterAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::ValueRange inputs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AfterAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AfterAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AfterAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AfterAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AfterAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AfterAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AfterAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AfterAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::AfterAllOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::AllGatherOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AllGatherOpGenericAdaptorBase {
public:
  struct Properties {
    using all_gather_dimTy = ::mlir::IntegerAttr;
    all_gather_dimTy all_gather_dim;

    auto getAllGatherDim() const {
      auto &propStorage = this->all_gather_dim;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setAllGatherDim(const ::mlir::IntegerAttr &propValue) {
      this->all_gather_dim = propValue;
    }
    using channel_handleTy = ::mlir::stablehlo::ChannelHandleAttr;
    channel_handleTy channel_handle;

    auto getChannelHandle() const {
      auto &propStorage = this->channel_handle;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(propStorage);
    }
    void setChannelHandle(const ::mlir::stablehlo::ChannelHandleAttr &propValue) {
      this->channel_handle = propValue;
    }
    using replica_groupsTy = ::mlir::DenseIntElementsAttr;
    replica_groupsTy replica_groups;

    auto getReplicaGroups() const {
      auto &propStorage = this->replica_groups;
      return ::llvm::cast<::mlir::DenseIntElementsAttr>(propStorage);
    }
    void setReplicaGroups(const ::mlir::DenseIntElementsAttr &propValue) {
      this->replica_groups = propValue;
    }
    using use_global_device_idsTy = ::mlir::UnitAttr;
    use_global_device_idsTy use_global_device_ids;

    auto getUseGlobalDeviceIds() const {
      auto &propStorage = this->use_global_device_ids;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setUseGlobalDeviceIds(const ::mlir::UnitAttr &propValue) {
      this->use_global_device_ids = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.all_gather_dim == this->all_gather_dim &&
        rhs.channel_handle == this->channel_handle &&
        rhs.replica_groups == this->replica_groups &&
        rhs.use_global_device_ids == this->use_global_device_ids &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AllGatherOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.all_gather", odsAttrs.getContext());
  }

  AllGatherOpGenericAdaptorBase(AllGatherOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getAllGatherDimAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().all_gather_dim);
    return attr;
  }

  uint64_t getAllGatherDim();
  ::mlir::DenseIntElementsAttr getReplicaGroupsAttr() {
    auto attr = ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().replica_groups);
    return attr;
  }

  ::mlir::DenseIntElementsAttr getReplicaGroups();
  ::mlir::stablehlo::ChannelHandleAttr getChannelHandleAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(getProperties().channel_handle);
    return attr;
  }

  ::std::optional<::mlir::stablehlo::ChannelHandleAttr> getChannelHandle();
  ::mlir::UnitAttr getUseGlobalDeviceIdsAttr();
  bool getUseGlobalDeviceIds();
};
} // namespace detail
template <typename RangeT>
class AllGatherOpGenericAdaptor : public detail::AllGatherOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AllGatherOpGenericAdaptorBase;
  static constexpr int odsIndex_operands = 0;
public:
  AllGatherOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AllGatherOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AllGatherOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AllGatherOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AllGatherOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AllGatherOpGenericAdaptor(RangeT values, const AllGatherOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AllGatherOp, typename = std::enable_if_t<std::is_same_v<LateInst, AllGatherOp>>>
  AllGatherOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return getODSOperands(0);
  }

private:
  RangeT odsOperands;
};
class AllGatherOpAdaptor : public AllGatherOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AllGatherOpGenericAdaptor::AllGatherOpGenericAdaptor;
  AllGatherOpAdaptor(AllGatherOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AllGatherOp : public ::mlir::Op<AllGatherOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::PairwiseSameOperandAndResultElementType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AllGatherOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AllGatherOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operands = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("all_gather_dim"), ::llvm::StringRef("channel_handle"), ::llvm::StringRef("replica_groups"), ::llvm::StringRef("use_global_device_ids")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAllGatherDimAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAllGatherDimAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getChannelHandleAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getChannelHandleAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getReplicaGroupsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getReplicaGroupsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getUseGlobalDeviceIdsAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getUseGlobalDeviceIdsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.all_gather");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getOperands() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getAllGatherDimAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().all_gather_dim);
  }

  uint64_t getAllGatherDim();
  ::mlir::DenseIntElementsAttr getReplicaGroupsAttr() {
    return ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().replica_groups);
  }

  ::mlir::DenseIntElementsAttr getReplicaGroups();
  ::mlir::stablehlo::ChannelHandleAttr getChannelHandleAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(getProperties().channel_handle);
  }

  ::std::optional<::mlir::stablehlo::ChannelHandleAttr> getChannelHandle();
  ::mlir::UnitAttr getUseGlobalDeviceIdsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().use_global_device_ids);
  }

  bool getUseGlobalDeviceIds();
  void setAllGatherDimAttr(::mlir::IntegerAttr attr) {
    getProperties().all_gather_dim = attr;
  }

  void setAllGatherDim(uint64_t attrValue);
  void setReplicaGroupsAttr(::mlir::DenseIntElementsAttr attr) {
    getProperties().replica_groups = attr;
  }

  void setChannelHandleAttr(::mlir::stablehlo::ChannelHandleAttr attr) {
    getProperties().channel_handle = attr;
  }

  void setUseGlobalDeviceIdsAttr(::mlir::UnitAttr attr) {
    getProperties().use_global_device_ids = attr;
  }

  void setUseGlobalDeviceIds(bool attrValue);
  ::mlir::Attribute removeChannelHandleAttr() {
      auto attr = getProperties().channel_handle;
      getProperties().channel_handle = {};
      return attr;
  }

  ::mlir::Attribute removeUseGlobalDeviceIdsAttr() {
      auto attr = getProperties().use_global_device_ids;
      getProperties().use_global_device_ids = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, ::mlir::IntegerAttr all_gather_dim, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/::mlir::UnitAttr use_global_device_ids = nullptr);
  static AllGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, ::mlir::IntegerAttr all_gather_dim, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/::mlir::UnitAttr use_global_device_ids = nullptr);
  static AllGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, ::mlir::IntegerAttr all_gather_dim, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/::mlir::UnitAttr use_global_device_ids = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, uint64_t all_gather_dim, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/bool use_global_device_ids = false);
  static AllGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, uint64_t all_gather_dim, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/bool use_global_device_ids = false);
  static AllGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, uint64_t all_gather_dim, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/bool use_global_device_ids = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  /// Interface method for ConditionallySpeculatable.
  mlir::Speculation::Speculatability getSpeculatability();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::AllGatherOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::AllReduceOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AllReduceOpGenericAdaptorBase {
public:
  struct Properties {
    using channel_handleTy = ::mlir::stablehlo::ChannelHandleAttr;
    channel_handleTy channel_handle;

    auto getChannelHandle() const {
      auto &propStorage = this->channel_handle;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(propStorage);
    }
    void setChannelHandle(const ::mlir::stablehlo::ChannelHandleAttr &propValue) {
      this->channel_handle = propValue;
    }
    using replica_groupsTy = ::mlir::DenseIntElementsAttr;
    replica_groupsTy replica_groups;

    auto getReplicaGroups() const {
      auto &propStorage = this->replica_groups;
      return ::llvm::cast<::mlir::DenseIntElementsAttr>(propStorage);
    }
    void setReplicaGroups(const ::mlir::DenseIntElementsAttr &propValue) {
      this->replica_groups = propValue;
    }
    using use_global_device_idsTy = ::mlir::UnitAttr;
    use_global_device_idsTy use_global_device_ids;

    auto getUseGlobalDeviceIds() const {
      auto &propStorage = this->use_global_device_ids;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setUseGlobalDeviceIds(const ::mlir::UnitAttr &propValue) {
      this->use_global_device_ids = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.channel_handle == this->channel_handle &&
        rhs.replica_groups == this->replica_groups &&
        rhs.use_global_device_ids == this->use_global_device_ids &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AllReduceOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.all_reduce", odsAttrs.getContext());
  }

  AllReduceOpGenericAdaptorBase(AllReduceOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseIntElementsAttr getReplicaGroupsAttr() {
    auto attr = ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().replica_groups);
    return attr;
  }

  ::mlir::DenseIntElementsAttr getReplicaGroups();
  ::mlir::stablehlo::ChannelHandleAttr getChannelHandleAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(getProperties().channel_handle);
    return attr;
  }

  ::std::optional<::mlir::stablehlo::ChannelHandleAttr> getChannelHandle();
  ::mlir::UnitAttr getUseGlobalDeviceIdsAttr();
  bool getUseGlobalDeviceIds();
  ::mlir::Region &getComputation() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class AllReduceOpGenericAdaptor : public detail::AllReduceOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AllReduceOpGenericAdaptorBase;
  static constexpr int odsIndex_operands = 0;
public:
  AllReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AllReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AllReduceOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AllReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AllReduceOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AllReduceOpGenericAdaptor(RangeT values, const AllReduceOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AllReduceOp, typename = std::enable_if_t<std::is_same_v<LateInst, AllReduceOp>>>
  AllReduceOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return getODSOperands(0);
  }

private:
  RangeT odsOperands;
};
class AllReduceOpAdaptor : public AllReduceOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AllReduceOpGenericAdaptor::AllReduceOpGenericAdaptor;
  AllReduceOpAdaptor(AllReduceOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AllReduceOp : public ::mlir::Op<AllReduceOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::SingleBlockImplicitTerminator<ReturnOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AllReduceOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AllReduceOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operands = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("channel_handle"), ::llvm::StringRef("replica_groups"), ::llvm::StringRef("use_global_device_ids")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getChannelHandleAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getChannelHandleAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getReplicaGroupsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getReplicaGroupsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getUseGlobalDeviceIdsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getUseGlobalDeviceIdsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.all_reduce");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getOperands() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getComputation() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseIntElementsAttr getReplicaGroupsAttr() {
    return ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().replica_groups);
  }

  ::mlir::DenseIntElementsAttr getReplicaGroups();
  ::mlir::stablehlo::ChannelHandleAttr getChannelHandleAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(getProperties().channel_handle);
  }

  ::std::optional<::mlir::stablehlo::ChannelHandleAttr> getChannelHandle();
  ::mlir::UnitAttr getUseGlobalDeviceIdsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().use_global_device_ids);
  }

  bool getUseGlobalDeviceIds();
  void setReplicaGroupsAttr(::mlir::DenseIntElementsAttr attr) {
    getProperties().replica_groups = attr;
  }

  void setChannelHandleAttr(::mlir::stablehlo::ChannelHandleAttr attr) {
    getProperties().channel_handle = attr;
  }

  void setUseGlobalDeviceIdsAttr(::mlir::UnitAttr attr) {
    getProperties().use_global_device_ids = attr;
  }

  void setUseGlobalDeviceIds(bool attrValue);
  ::mlir::Attribute removeChannelHandleAttr() {
      auto attr = getProperties().channel_handle;
      getProperties().channel_handle = {};
      return attr;
  }

  ::mlir::Attribute removeUseGlobalDeviceIdsAttr() {
      auto attr = getProperties().use_global_device_ids;
      getProperties().use_global_device_ids = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result_type, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups, ::mlir::stablehlo::ChannelHandleAttr channel_handle, bool use_global_device_ids = false);
  static AllReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result_type, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups, ::mlir::stablehlo::ChannelHandleAttr channel_handle, bool use_global_device_ids = false);
  static AllReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result_type, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups, ::mlir::stablehlo::ChannelHandleAttr channel_handle, bool use_global_device_ids = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/::mlir::UnitAttr use_global_device_ids);
  static AllReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/::mlir::UnitAttr use_global_device_ids);
  static AllReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/::mlir::UnitAttr use_global_device_ids);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/::mlir::UnitAttr use_global_device_ids);
  static AllReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/::mlir::UnitAttr use_global_device_ids);
  static AllReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/::mlir::UnitAttr use_global_device_ids);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/bool use_global_device_ids = false);
  static AllReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/bool use_global_device_ids = false);
  static AllReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/bool use_global_device_ids = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/bool use_global_device_ids = false);
  static AllReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/bool use_global_device_ids = false);
  static AllReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle, /*optional*/bool use_global_device_ids = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::AllReduceOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::AllToAllOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AllToAllOpGenericAdaptorBase {
public:
  struct Properties {
    using channel_handleTy = ::mlir::stablehlo::ChannelHandleAttr;
    channel_handleTy channel_handle;

    auto getChannelHandle() const {
      auto &propStorage = this->channel_handle;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(propStorage);
    }
    void setChannelHandle(const ::mlir::stablehlo::ChannelHandleAttr &propValue) {
      this->channel_handle = propValue;
    }
    using concat_dimensionTy = ::mlir::IntegerAttr;
    concat_dimensionTy concat_dimension;

    auto getConcatDimension() const {
      auto &propStorage = this->concat_dimension;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setConcatDimension(const ::mlir::IntegerAttr &propValue) {
      this->concat_dimension = propValue;
    }
    using replica_groupsTy = ::mlir::DenseIntElementsAttr;
    replica_groupsTy replica_groups;

    auto getReplicaGroups() const {
      auto &propStorage = this->replica_groups;
      return ::llvm::cast<::mlir::DenseIntElementsAttr>(propStorage);
    }
    void setReplicaGroups(const ::mlir::DenseIntElementsAttr &propValue) {
      this->replica_groups = propValue;
    }
    using split_countTy = ::mlir::IntegerAttr;
    split_countTy split_count;

    auto getSplitCount() const {
      auto &propStorage = this->split_count;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSplitCount(const ::mlir::IntegerAttr &propValue) {
      this->split_count = propValue;
    }
    using split_dimensionTy = ::mlir::IntegerAttr;
    split_dimensionTy split_dimension;

    auto getSplitDimension() const {
      auto &propStorage = this->split_dimension;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSplitDimension(const ::mlir::IntegerAttr &propValue) {
      this->split_dimension = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.channel_handle == this->channel_handle &&
        rhs.concat_dimension == this->concat_dimension &&
        rhs.replica_groups == this->replica_groups &&
        rhs.split_count == this->split_count &&
        rhs.split_dimension == this->split_dimension &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AllToAllOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.all_to_all", odsAttrs.getContext());
  }

  AllToAllOpGenericAdaptorBase(AllToAllOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSplitDimensionAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().split_dimension);
    return attr;
  }

  uint64_t getSplitDimension();
  ::mlir::IntegerAttr getConcatDimensionAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().concat_dimension);
    return attr;
  }

  uint64_t getConcatDimension();
  ::mlir::IntegerAttr getSplitCountAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().split_count);
    return attr;
  }

  uint64_t getSplitCount();
  ::mlir::DenseIntElementsAttr getReplicaGroupsAttr() {
    auto attr = ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().replica_groups);
    return attr;
  }

  ::mlir::DenseIntElementsAttr getReplicaGroups();
  ::mlir::stablehlo::ChannelHandleAttr getChannelHandleAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(getProperties().channel_handle);
    return attr;
  }

  ::std::optional<::mlir::stablehlo::ChannelHandleAttr> getChannelHandle();
};
} // namespace detail
template <typename RangeT>
class AllToAllOpGenericAdaptor : public detail::AllToAllOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AllToAllOpGenericAdaptorBase;
  static constexpr int odsIndex_operands = 0;
public:
  AllToAllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AllToAllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AllToAllOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AllToAllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AllToAllOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AllToAllOpGenericAdaptor(RangeT values, const AllToAllOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AllToAllOp, typename = std::enable_if_t<std::is_same_v<LateInst, AllToAllOp>>>
  AllToAllOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return getODSOperands(0);
  }

private:
  RangeT odsOperands;
};
class AllToAllOpAdaptor : public AllToAllOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AllToAllOpGenericAdaptor::AllToAllOpGenericAdaptor;
  AllToAllOpAdaptor(AllToAllOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AllToAllOp : public ::mlir::Op<AllToAllOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::PairwiseSameOperandAndResultElementType, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AllToAllOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AllToAllOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operands = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("channel_handle"), ::llvm::StringRef("concat_dimension"), ::llvm::StringRef("replica_groups"), ::llvm::StringRef("split_count"), ::llvm::StringRef("split_dimension")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getChannelHandleAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getChannelHandleAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getConcatDimensionAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getConcatDimensionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getReplicaGroupsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getReplicaGroupsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getSplitCountAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getSplitCountAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getSplitDimensionAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getSplitDimensionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.all_to_all");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getOperands() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSplitDimensionAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().split_dimension);
  }

  uint64_t getSplitDimension();
  ::mlir::IntegerAttr getConcatDimensionAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().concat_dimension);
  }

  uint64_t getConcatDimension();
  ::mlir::IntegerAttr getSplitCountAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().split_count);
  }

  uint64_t getSplitCount();
  ::mlir::DenseIntElementsAttr getReplicaGroupsAttr() {
    return ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().replica_groups);
  }

  ::mlir::DenseIntElementsAttr getReplicaGroups();
  ::mlir::stablehlo::ChannelHandleAttr getChannelHandleAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(getProperties().channel_handle);
  }

  ::std::optional<::mlir::stablehlo::ChannelHandleAttr> getChannelHandle();
  void setSplitDimensionAttr(::mlir::IntegerAttr attr) {
    getProperties().split_dimension = attr;
  }

  void setSplitDimension(uint64_t attrValue);
  void setConcatDimensionAttr(::mlir::IntegerAttr attr) {
    getProperties().concat_dimension = attr;
  }

  void setConcatDimension(uint64_t attrValue);
  void setSplitCountAttr(::mlir::IntegerAttr attr) {
    getProperties().split_count = attr;
  }

  void setSplitCount(uint64_t attrValue);
  void setReplicaGroupsAttr(::mlir::DenseIntElementsAttr attr) {
    getProperties().replica_groups = attr;
  }

  void setChannelHandleAttr(::mlir::stablehlo::ChannelHandleAttr attr) {
    getProperties().channel_handle = attr;
  }

  ::mlir::Attribute removeChannelHandleAttr() {
      auto attr = getProperties().channel_handle;
      getProperties().channel_handle = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result_type, ::mlir::Value operand, ::mlir::IntegerAttr split_dimension, ::mlir::IntegerAttr concat_dimension, ::mlir::IntegerAttr split_count, ::mlir::DenseIntElementsAttr replica_groups);
  static AllToAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result_type, ::mlir::Value operand, ::mlir::IntegerAttr split_dimension, ::mlir::IntegerAttr concat_dimension, ::mlir::IntegerAttr split_count, ::mlir::DenseIntElementsAttr replica_groups);
  static AllToAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result_type, ::mlir::Value operand, ::mlir::IntegerAttr split_dimension, ::mlir::IntegerAttr concat_dimension, ::mlir::IntegerAttr split_count, ::mlir::DenseIntElementsAttr replica_groups);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, ::mlir::IntegerAttr split_dimension, ::mlir::IntegerAttr concat_dimension, ::mlir::IntegerAttr split_count, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static AllToAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, ::mlir::IntegerAttr split_dimension, ::mlir::IntegerAttr concat_dimension, ::mlir::IntegerAttr split_count, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static AllToAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, ::mlir::IntegerAttr split_dimension, ::mlir::IntegerAttr concat_dimension, ::mlir::IntegerAttr split_count, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::mlir::IntegerAttr split_dimension, ::mlir::IntegerAttr concat_dimension, ::mlir::IntegerAttr split_count, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static AllToAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::mlir::IntegerAttr split_dimension, ::mlir::IntegerAttr concat_dimension, ::mlir::IntegerAttr split_count, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static AllToAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::mlir::IntegerAttr split_dimension, ::mlir::IntegerAttr concat_dimension, ::mlir::IntegerAttr split_count, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, uint64_t split_dimension, uint64_t concat_dimension, uint64_t split_count, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static AllToAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, uint64_t split_dimension, uint64_t concat_dimension, uint64_t split_count, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static AllToAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::ValueRange operands, uint64_t split_dimension, uint64_t concat_dimension, uint64_t split_count, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, uint64_t split_dimension, uint64_t concat_dimension, uint64_t split_count, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static AllToAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, uint64_t split_dimension, uint64_t concat_dimension, uint64_t split_count, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static AllToAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, uint64_t split_dimension, uint64_t concat_dimension, uint64_t split_count, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllToAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllToAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllToAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllToAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllToAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllToAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllToAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllToAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  /// Interface method for ConditionallySpeculatable.
  mlir::Speculation::Speculatability getSpeculatability();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::AllToAllOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::AndOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AndOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AndOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.and", odsAttrs.getContext());
  }

  AndOpGenericAdaptorBase(AndOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AndOpGenericAdaptor : public detail::AndOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AndOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  AndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AndOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AndOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AndOpGenericAdaptor(RangeT values, const AndOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AndOp, typename = std::enable_if_t<std::is_same_v<LateInst, AndOp>>>
  AndOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AndOpAdaptor : public AndOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AndOpGenericAdaptor::AndOpGenericAdaptor;
  AndOpAdaptor(AndOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AndOp : public ::mlir::Op<AndOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::hlo::OpTrait::IsCommutative, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::OpTrait::Elementwise> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AndOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AndOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.and");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                               operands.front(),
                                               &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::AndOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::Atan2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class Atan2OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  Atan2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.atan2", odsAttrs.getContext());
  }

  Atan2OpGenericAdaptorBase(Atan2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class Atan2OpGenericAdaptor : public detail::Atan2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::Atan2OpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  Atan2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  Atan2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : Atan2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  Atan2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : Atan2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  Atan2OpGenericAdaptor(RangeT values, const Atan2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = Atan2Op, typename = std::enable_if_t<std::is_same_v<LateInst, Atan2Op>>>
  Atan2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class Atan2OpAdaptor : public Atan2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using Atan2OpGenericAdaptor::Atan2OpGenericAdaptor;
  Atan2OpAdaptor(Atan2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class Atan2Op : public ::mlir::Op<Atan2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::OpTrait::Elementwise, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = Atan2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = Atan2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.atan2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static Atan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static Atan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static Atan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static Atan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static Atan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static Atan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Atan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Atan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Atan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Atan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Atan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Atan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Atan2Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Atan2Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                               operands.front(),
                                               &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::Atan2Op)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::BatchNormGradOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BatchNormGradOpGenericAdaptorBase {
public:
  struct Properties {
    using epsilonTy = ::mlir::FloatAttr;
    epsilonTy epsilon;

    auto getEpsilon() const {
      auto &propStorage = this->epsilon;
      return ::llvm::cast<::mlir::FloatAttr>(propStorage);
    }
    void setEpsilon(const ::mlir::FloatAttr &propValue) {
      this->epsilon = propValue;
    }
    using feature_indexTy = ::mlir::IntegerAttr;
    feature_indexTy feature_index;

    auto getFeatureIndex() const {
      auto &propStorage = this->feature_index;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setFeatureIndex(const ::mlir::IntegerAttr &propValue) {
      this->feature_index = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.epsilon == this->epsilon &&
        rhs.feature_index == this->feature_index &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BatchNormGradOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.batch_norm_grad", odsAttrs.getContext());
  }

  BatchNormGradOpGenericAdaptorBase(BatchNormGradOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::FloatAttr getEpsilonAttr() {
    auto attr = ::llvm::cast<::mlir::FloatAttr>(getProperties().epsilon);
    return attr;
  }

  ::llvm::APFloat getEpsilon();
  ::mlir::IntegerAttr getFeatureIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().feature_index);
    return attr;
  }

  uint64_t getFeatureIndex();
};
} // namespace detail
template <typename RangeT>
class BatchNormGradOpGenericAdaptor : public detail::BatchNormGradOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BatchNormGradOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_scale = 1;
  static constexpr int odsIndex_mean = 2;
  static constexpr int odsIndex_variance = 3;
  static constexpr int odsIndex_grad_output = 4;
public:
  BatchNormGradOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BatchNormGradOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BatchNormGradOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BatchNormGradOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BatchNormGradOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BatchNormGradOpGenericAdaptor(RangeT values, const BatchNormGradOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BatchNormGradOp, typename = std::enable_if_t<std::is_same_v<LateInst, BatchNormGradOp>>>
  BatchNormGradOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMean() {
    return (*getODSOperands(2).begin());
  }

  ValueT getVariance() {
    return (*getODSOperands(3).begin());
  }

  ValueT getGradOutput() {
    return (*getODSOperands(4).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BatchNormGradOpAdaptor : public BatchNormGradOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BatchNormGradOpGenericAdaptor::BatchNormGradOpGenericAdaptor;
  BatchNormGradOpAdaptor(BatchNormGradOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BatchNormGradOp : public ::mlir::Op<BatchNormGradOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<3>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<5>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultElementType, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpAsmOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BatchNormGradOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BatchNormGradOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_scale = 1;
  static constexpr int odsIndex_mean = 2;
  static constexpr int odsIndex_variance = 3;
  static constexpr int odsIndex_grad_output = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("epsilon"), ::llvm::StringRef("feature_index")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getEpsilonAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getEpsilonAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFeatureIndexAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFeatureIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.batch_norm_grad");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getMean() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getVariance() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getGradOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(4).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMeanMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getVarianceMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getGradOutputMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getGradOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getGradScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(1).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getGradOffset() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(2).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::FloatAttr getEpsilonAttr() {
    return ::llvm::cast<::mlir::FloatAttr>(getProperties().epsilon);
  }

  ::llvm::APFloat getEpsilon();
  ::mlir::IntegerAttr getFeatureIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().feature_index);
  }

  uint64_t getFeatureIndex();
  void setEpsilonAttr(::mlir::FloatAttr attr) {
    getProperties().epsilon = attr;
  }

  void setEpsilon(::llvm::APFloat attrValue);
  void setFeatureIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().feature_index = attr;
  }

  void setFeatureIndex(uint64_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type grad_operand, ::mlir::Type grad_scale, ::mlir::Type grad_offset, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormGradOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type grad_operand, ::mlir::Type grad_scale, ::mlir::Type grad_offset, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormGradOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type grad_operand, ::mlir::Type grad_scale, ::mlir::Type grad_offset, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormGradOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormGradOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormGradOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormGradOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type grad_operand, ::mlir::Type grad_scale, ::mlir::Type grad_offset, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormGradOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type grad_operand, ::mlir::Type grad_scale, ::mlir::Type grad_offset, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormGradOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type grad_operand, ::mlir::Type grad_scale, ::mlir::Type grad_offset, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::llvm::APFloat epsilon, uint64_t feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormGradOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormGradOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::llvm::APFloat epsilon, uint64_t feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormGradOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormGradOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value mean, ::mlir::Value variance, ::mlir::Value grad_output, ::llvm::APFloat epsilon, uint64_t feature_index);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BatchNormGradOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BatchNormGradOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BatchNormGradOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BatchNormGradOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BatchNormGradOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BatchNormGradOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BatchNormGradOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BatchNormGradOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::BatchNormGradOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::BatchNormInferenceOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BatchNormInferenceOpGenericAdaptorBase {
public:
  struct Properties {
    using epsilonTy = ::mlir::FloatAttr;
    epsilonTy epsilon;

    auto getEpsilon() const {
      auto &propStorage = this->epsilon;
      return ::llvm::cast<::mlir::FloatAttr>(propStorage);
    }
    void setEpsilon(const ::mlir::FloatAttr &propValue) {
      this->epsilon = propValue;
    }
    using feature_indexTy = ::mlir::IntegerAttr;
    feature_indexTy feature_index;

    auto getFeatureIndex() const {
      auto &propStorage = this->feature_index;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setFeatureIndex(const ::mlir::IntegerAttr &propValue) {
      this->feature_index = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.epsilon == this->epsilon &&
        rhs.feature_index == this->feature_index &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BatchNormInferenceOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.batch_norm_inference", odsAttrs.getContext());
  }

  BatchNormInferenceOpGenericAdaptorBase(BatchNormInferenceOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::FloatAttr getEpsilonAttr() {
    auto attr = ::llvm::cast<::mlir::FloatAttr>(getProperties().epsilon);
    return attr;
  }

  ::llvm::APFloat getEpsilon();
  ::mlir::IntegerAttr getFeatureIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().feature_index);
    return attr;
  }

  uint64_t getFeatureIndex();
};
} // namespace detail
template <typename RangeT>
class BatchNormInferenceOpGenericAdaptor : public detail::BatchNormInferenceOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BatchNormInferenceOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_scale = 1;
  static constexpr int odsIndex_offset = 2;
  static constexpr int odsIndex_mean = 3;
  static constexpr int odsIndex_variance = 4;
public:
  BatchNormInferenceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BatchNormInferenceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BatchNormInferenceOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BatchNormInferenceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BatchNormInferenceOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BatchNormInferenceOpGenericAdaptor(RangeT values, const BatchNormInferenceOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BatchNormInferenceOp, typename = std::enable_if_t<std::is_same_v<LateInst, BatchNormInferenceOp>>>
  BatchNormInferenceOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOffset() {
    return (*getODSOperands(2).begin());
  }

  ValueT getMean() {
    return (*getODSOperands(3).begin());
  }

  ValueT getVariance() {
    return (*getODSOperands(4).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BatchNormInferenceOpAdaptor : public BatchNormInferenceOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BatchNormInferenceOpGenericAdaptor::BatchNormInferenceOpGenericAdaptor;
  BatchNormInferenceOpAdaptor(BatchNormInferenceOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BatchNormInferenceOp : public ::mlir::Op<BatchNormInferenceOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<5>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultElementType, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BatchNormInferenceOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BatchNormInferenceOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_scale = 1;
  static constexpr int odsIndex_offset = 2;
  static constexpr int odsIndex_mean = 3;
  static constexpr int odsIndex_variance = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("epsilon"), ::llvm::StringRef("feature_index")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getEpsilonAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getEpsilonAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFeatureIndexAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFeatureIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.batch_norm_inference");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOffset() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getMean() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getVariance() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(4).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOffsetMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMeanMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getVarianceMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::FloatAttr getEpsilonAttr() {
    return ::llvm::cast<::mlir::FloatAttr>(getProperties().epsilon);
  }

  ::llvm::APFloat getEpsilon();
  ::mlir::IntegerAttr getFeatureIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().feature_index);
  }

  uint64_t getFeatureIndex();
  void setEpsilonAttr(::mlir::FloatAttr attr) {
    getProperties().epsilon = attr;
  }

  void setEpsilon(::llvm::APFloat attrValue);
  void setFeatureIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().feature_index = attr;
  }

  void setFeatureIndex(uint64_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormInferenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormInferenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormInferenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormInferenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormInferenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormInferenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormInferenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormInferenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::llvm::APFloat epsilon, uint64_t feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormInferenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormInferenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::llvm::APFloat epsilon, uint64_t feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormInferenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormInferenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::Value mean, ::mlir::Value variance, ::llvm::APFloat epsilon, uint64_t feature_index);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BatchNormInferenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BatchNormInferenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BatchNormInferenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BatchNormInferenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BatchNormInferenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BatchNormInferenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BatchNormInferenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BatchNormInferenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::BatchNormInferenceOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::BatchNormTrainingOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BatchNormTrainingOpGenericAdaptorBase {
public:
  struct Properties {
    using epsilonTy = ::mlir::FloatAttr;
    epsilonTy epsilon;

    auto getEpsilon() const {
      auto &propStorage = this->epsilon;
      return ::llvm::cast<::mlir::FloatAttr>(propStorage);
    }
    void setEpsilon(const ::mlir::FloatAttr &propValue) {
      this->epsilon = propValue;
    }
    using feature_indexTy = ::mlir::IntegerAttr;
    feature_indexTy feature_index;

    auto getFeatureIndex() const {
      auto &propStorage = this->feature_index;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setFeatureIndex(const ::mlir::IntegerAttr &propValue) {
      this->feature_index = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.epsilon == this->epsilon &&
        rhs.feature_index == this->feature_index &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BatchNormTrainingOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.batch_norm_training", odsAttrs.getContext());
  }

  BatchNormTrainingOpGenericAdaptorBase(BatchNormTrainingOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::FloatAttr getEpsilonAttr() {
    auto attr = ::llvm::cast<::mlir::FloatAttr>(getProperties().epsilon);
    return attr;
  }

  ::llvm::APFloat getEpsilon();
  ::mlir::IntegerAttr getFeatureIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().feature_index);
    return attr;
  }

  uint64_t getFeatureIndex();
};
} // namespace detail
template <typename RangeT>
class BatchNormTrainingOpGenericAdaptor : public detail::BatchNormTrainingOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BatchNormTrainingOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_scale = 1;
  static constexpr int odsIndex_offset = 2;
public:
  BatchNormTrainingOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BatchNormTrainingOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BatchNormTrainingOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BatchNormTrainingOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BatchNormTrainingOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BatchNormTrainingOpGenericAdaptor(RangeT values, const BatchNormTrainingOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BatchNormTrainingOp, typename = std::enable_if_t<std::is_same_v<LateInst, BatchNormTrainingOp>>>
  BatchNormTrainingOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOffset() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BatchNormTrainingOpAdaptor : public BatchNormTrainingOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BatchNormTrainingOpGenericAdaptor::BatchNormTrainingOpGenericAdaptor;
  BatchNormTrainingOpAdaptor(BatchNormTrainingOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BatchNormTrainingOp : public ::mlir::Op<BatchNormTrainingOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<3>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultElementType, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpAsmOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BatchNormTrainingOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BatchNormTrainingOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_scale = 1;
  static constexpr int odsIndex_offset = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("epsilon"), ::llvm::StringRef("feature_index")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getEpsilonAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getEpsilonAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFeatureIndexAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFeatureIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.batch_norm_training");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOffset() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOffsetMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getBatchMean() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(1).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getBatchVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(2).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::FloatAttr getEpsilonAttr() {
    return ::llvm::cast<::mlir::FloatAttr>(getProperties().epsilon);
  }

  ::llvm::APFloat getEpsilon();
  ::mlir::IntegerAttr getFeatureIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().feature_index);
  }

  uint64_t getFeatureIndex();
  void setEpsilonAttr(::mlir::FloatAttr attr) {
    getProperties().epsilon = attr;
  }

  void setEpsilon(::llvm::APFloat attrValue);
  void setFeatureIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().feature_index = attr;
  }

  void setFeatureIndex(uint64_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Type batch_mean, ::mlir::Type batch_var, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormTrainingOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type output, ::mlir::Type batch_mean, ::mlir::Type batch_var, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormTrainingOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type output, ::mlir::Type batch_mean, ::mlir::Type batch_var, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormTrainingOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormTrainingOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormTrainingOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static BatchNormTrainingOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::mlir::FloatAttr epsilon, ::mlir::IntegerAttr feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Type batch_mean, ::mlir::Type batch_var, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormTrainingOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type output, ::mlir::Type batch_mean, ::mlir::Type batch_var, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormTrainingOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type output, ::mlir::Type batch_mean, ::mlir::Type batch_var, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::llvm::APFloat epsilon, uint64_t feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormTrainingOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormTrainingOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::llvm::APFloat epsilon, uint64_t feature_index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormTrainingOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::llvm::APFloat epsilon, uint64_t feature_index);
  static BatchNormTrainingOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value scale, ::mlir::Value offset, ::llvm::APFloat epsilon, uint64_t feature_index);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BatchNormTrainingOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BatchNormTrainingOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BatchNormTrainingOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BatchNormTrainingOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BatchNormTrainingOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BatchNormTrainingOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BatchNormTrainingOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BatchNormTrainingOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::BatchNormTrainingOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::BitcastConvertOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BitcastConvertOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BitcastConvertOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.bitcast_convert", odsAttrs.getContext());
  }

  BitcastConvertOpGenericAdaptorBase(BitcastConvertOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BitcastConvertOpGenericAdaptor : public detail::BitcastConvertOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BitcastConvertOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  BitcastConvertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BitcastConvertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BitcastConvertOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BitcastConvertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BitcastConvertOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BitcastConvertOpGenericAdaptor(RangeT values, const BitcastConvertOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BitcastConvertOp, typename = std::enable_if_t<std::is_same_v<LateInst, BitcastConvertOp>>>
  BitcastConvertOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BitcastConvertOpAdaptor : public BitcastConvertOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BitcastConvertOpGenericAdaptor::BitcastConvertOpGenericAdaptor;
  BitcastConvertOpAdaptor(BitcastConvertOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BitcastConvertOp : public ::mlir::Op<BitcastConvertOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BitcastConvertOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BitcastConvertOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.bitcast_convert");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand);
  static BitcastConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand);
  static BitcastConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static BitcastConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static BitcastConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitcastConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitcastConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitcastConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitcastConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::LogicalResult reifyReturnTypeShapes(::mlir::OpBuilder&builder, ::mlir::ValueRange operands, ::llvm::SmallVectorImpl<::mlir::Value> &reifiedReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  /// Interface method for ConditionallySpeculatable.
  mlir::Speculation::Speculatability getSpeculatability();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::BitcastConvertOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::BroadcastInDimOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BroadcastInDimOpGenericAdaptorBase {
public:
  struct Properties {
    using broadcast_dimensionsTy = ::mlir::DenseI64ArrayAttr;
    broadcast_dimensionsTy broadcast_dimensions;

    auto getBroadcastDimensions() const {
      auto &propStorage = this->broadcast_dimensions;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setBroadcastDimensions(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->broadcast_dimensions = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.broadcast_dimensions == this->broadcast_dimensions &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BroadcastInDimOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.broadcast_in_dim", odsAttrs.getContext());
  }

  BroadcastInDimOpGenericAdaptorBase(BroadcastInDimOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getBroadcastDimensionsAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().broadcast_dimensions);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getBroadcastDimensions();
};
} // namespace detail
template <typename RangeT>
class BroadcastInDimOpGenericAdaptor : public detail::BroadcastInDimOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BroadcastInDimOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  BroadcastInDimOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BroadcastInDimOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BroadcastInDimOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BroadcastInDimOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BroadcastInDimOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BroadcastInDimOpGenericAdaptor(RangeT values, const BroadcastInDimOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BroadcastInDimOp, typename = std::enable_if_t<std::is_same_v<LateInst, BroadcastInDimOp>>>
  BroadcastInDimOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BroadcastInDimOpAdaptor : public BroadcastInDimOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BroadcastInDimOpGenericAdaptor::BroadcastInDimOpGenericAdaptor;
  BroadcastInDimOpAdaptor(BroadcastInDimOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BroadcastInDimOp : public ::mlir::Op<BroadcastInDimOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultElementType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BroadcastInDimOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BroadcastInDimOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("broadcast_dimensions")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBroadcastDimensionsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBroadcastDimensionsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.broadcast_in_dim");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getBroadcastDimensionsAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().broadcast_dimensions);
  }

  ::llvm::ArrayRef<int64_t> getBroadcastDimensions();
  void setBroadcastDimensionsAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().broadcast_dimensions = attr;
  }

  void setBroadcastDimensions(::llvm::ArrayRef<int64_t> attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_dimensions);
  static BroadcastInDimOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_dimensions);
  static BroadcastInDimOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_dimensions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_dimensions);
  static BroadcastInDimOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_dimensions);
  static BroadcastInDimOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_dimensions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_dimensions);
  static BroadcastInDimOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_dimensions);
  static BroadcastInDimOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_dimensions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_dimensions);
  static BroadcastInDimOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_dimensions);
  static BroadcastInDimOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_dimensions);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BroadcastInDimOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BroadcastInDimOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BroadcastInDimOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BroadcastInDimOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  /// Determines if this BroadcastInDim instance can be expressed as a Broadcast.
  bool isSimpleBroadcast();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::BroadcastInDimOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::BroadcastOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BroadcastOpGenericAdaptorBase {
public:
  struct Properties {
    using broadcast_sizesTy = ::mlir::DenseI64ArrayAttr;
    broadcast_sizesTy broadcast_sizes;

    auto getBroadcastSizes() const {
      auto &propStorage = this->broadcast_sizes;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setBroadcastSizes(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->broadcast_sizes = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.broadcast_sizes == this->broadcast_sizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BroadcastOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.broadcast", odsAttrs.getContext());
  }

  BroadcastOpGenericAdaptorBase(BroadcastOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getBroadcastSizesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().broadcast_sizes);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getBroadcastSizes();
};
} // namespace detail
template <typename RangeT>
class BroadcastOpGenericAdaptor : public detail::BroadcastOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BroadcastOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  BroadcastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BroadcastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BroadcastOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BroadcastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BroadcastOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BroadcastOpGenericAdaptor(RangeT values, const BroadcastOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BroadcastOp, typename = std::enable_if_t<std::is_same_v<LateInst, BroadcastOp>>>
  BroadcastOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BroadcastOpAdaptor : public BroadcastOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BroadcastOpGenericAdaptor::BroadcastOpGenericAdaptor;
  BroadcastOpAdaptor(BroadcastOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BroadcastOp : public ::mlir::Op<BroadcastOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultElementType, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BroadcastOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BroadcastOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("broadcast_sizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBroadcastSizesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBroadcastSizesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.broadcast");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getBroadcastSizesAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().broadcast_sizes);
  }

  ::llvm::ArrayRef<int64_t> getBroadcastSizes();
  void setBroadcastSizesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().broadcast_sizes = attr;
  }

  void setBroadcastSizes(::llvm::ArrayRef<int64_t> attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_sizes);
  static BroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_sizes);
  static BroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_sizes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_sizes);
  static BroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_sizes);
  static BroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_sizes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_sizes);
  static BroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_sizes);
  static BroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseI64ArrayAttr broadcast_sizes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_sizes);
  static BroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_sizes);
  static BroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_sizes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_sizes);
  static BroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_sizes);
  static BroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_sizes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_sizes);
  static BroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_sizes);
  static BroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::llvm::ArrayRef<int64_t> broadcast_sizes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  ::llvm::LogicalResult reifyReturnTypeShapes(::mlir::OpBuilder&builder, ::mlir::ValueRange operands, ::llvm::SmallVectorImpl<::mlir::Value> &reifiedReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::BroadcastOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::CaseOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CaseOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CaseOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.case", odsAttrs.getContext());
  }

  CaseOpGenericAdaptorBase(CaseOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::RegionRange getBranches() {
    return odsRegions.drop_front(0);
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class CaseOpGenericAdaptor : public detail::CaseOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CaseOpGenericAdaptorBase;
  static constexpr int odsIndex_index = 0;
public:
  CaseOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CaseOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CaseOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CaseOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CaseOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CaseOpGenericAdaptor(RangeT values, const CaseOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CaseOp, typename = std::enable_if_t<std::is_same_v<LateInst, CaseOp>>>
  CaseOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getIndex() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CaseOpAdaptor : public CaseOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CaseOpGenericAdaptor::CaseOpGenericAdaptor;
  CaseOpAdaptor(CaseOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CaseOp : public ::mlir::Op<CaseOp, ::mlir::OpTrait::VariadicRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::SingleBlockImplicitTerminator<ReturnOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::HasRecursiveMemoryEffects, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::RecursivelySpeculatableImplTrait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CaseOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CaseOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_index = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.case");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getIndex() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getIndexMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::MutableArrayRef<::mlir::Region> getBranches() {
    return (*this)->getRegions().drop_front(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::Value index, unsigned branchesCount);
  static CaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::Value index, unsigned branchesCount);
  static CaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::Value index, unsigned branchesCount);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value index, unsigned branchesCount);
  static CaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value index, unsigned branchesCount);
  static CaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value index, unsigned branchesCount);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions);
  static CaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions);
  static CaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions);
  static CaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions);
  static CaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes, unsigned numRegions);
  static CaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes, unsigned numRegions);
  static CaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes, unsigned numRegions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes, unsigned numRegions);
  static CaseOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes, unsigned numRegions);
  static CaseOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes, unsigned numRegions);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::CaseOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::CbrtOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CbrtOpGenericAdaptorBase {
public:
  struct Properties {
    using result_accuracyTy = ::mlir::stablehlo::ResultAccuracyAttr;
    result_accuracyTy result_accuracy;

    auto getResultAccuracy() const {
      auto &propStorage = this->result_accuracy;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(propStorage);
    }
    void setResultAccuracy(const ::mlir::stablehlo::ResultAccuracyAttr &propValue) {
      this->result_accuracy = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.result_accuracy == this->result_accuracy &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CbrtOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.cbrt", odsAttrs.getContext());
  }

  CbrtOpGenericAdaptorBase(CbrtOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr();
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
};
} // namespace detail
template <typename RangeT>
class CbrtOpGenericAdaptor : public detail::CbrtOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CbrtOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CbrtOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CbrtOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CbrtOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CbrtOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CbrtOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CbrtOpGenericAdaptor(RangeT values, const CbrtOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CbrtOp, typename = std::enable_if_t<std::is_same_v<LateInst, CbrtOp>>>
  CbrtOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CbrtOpAdaptor : public CbrtOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CbrtOpGenericAdaptor::CbrtOpGenericAdaptor;
  CbrtOpAdaptor(CbrtOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CbrtOp : public ::mlir::Op<CbrtOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::Elementwise, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CbrtOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CbrtOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("result_accuracy")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getResultAccuracyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getResultAccuracyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.cbrt");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(getProperties().result_accuracy);
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
  void setResultAccuracyAttr(::mlir::stablehlo::ResultAccuracyAttr attr) {
    getProperties().result_accuracy = attr;
  }

  ::mlir::Attribute removeResultAccuracyAttr() {
      auto attr = getProperties().result_accuracy;
      getProperties().result_accuracy = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static CbrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static CbrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static CbrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static CbrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static CbrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static CbrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CbrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CbrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CbrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CbrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CbrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CbrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CbrtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CbrtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::CbrtOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::CeilOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CeilOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CeilOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.ceil", odsAttrs.getContext());
  }

  CeilOpGenericAdaptorBase(CeilOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CeilOpGenericAdaptor : public detail::CeilOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CeilOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CeilOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CeilOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CeilOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CeilOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CeilOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CeilOpGenericAdaptor(RangeT values, const CeilOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CeilOp, typename = std::enable_if_t<std::is_same_v<LateInst, CeilOp>>>
  CeilOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CeilOpAdaptor : public CeilOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CeilOpGenericAdaptor::CeilOpGenericAdaptor;
  CeilOpAdaptor(CeilOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CeilOp : public ::mlir::Op<CeilOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::Elementwise, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CeilOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CeilOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.ceil");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static CeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static CeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static CeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static CeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static CeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CeilOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CeilOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::CeilOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::CholeskyOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CholeskyOpGenericAdaptorBase {
public:
  struct Properties {
    using lowerTy = ::mlir::BoolAttr;
    lowerTy lower;

    auto getLower() const {
      auto &propStorage = this->lower;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setLower(const ::mlir::BoolAttr &propValue) {
      this->lower = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.lower == this->lower &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CholeskyOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.cholesky", odsAttrs.getContext());
  }

  CholeskyOpGenericAdaptorBase(CholeskyOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getLowerAttr();
  bool getLower();
};
} // namespace detail
template <typename RangeT>
class CholeskyOpGenericAdaptor : public detail::CholeskyOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CholeskyOpGenericAdaptorBase;
  static constexpr int odsIndex_a = 0;
public:
  CholeskyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CholeskyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CholeskyOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CholeskyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CholeskyOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CholeskyOpGenericAdaptor(RangeT values, const CholeskyOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CholeskyOp, typename = std::enable_if_t<std::is_same_v<LateInst, CholeskyOp>>>
  CholeskyOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getA() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CholeskyOpAdaptor : public CholeskyOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CholeskyOpGenericAdaptor::CholeskyOpGenericAdaptor;
  CholeskyOpAdaptor(CholeskyOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CholeskyOp : public ::mlir::Op<CholeskyOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultElementType, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CholeskyOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CholeskyOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_a = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("lower")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getLowerAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getLowerAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.cholesky");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getLowerAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().lower);
  }

  bool getLower();
  void setLowerAttr(::mlir::BoolAttr attr) {
    getProperties().lower = attr;
  }

  void setLower(::std::optional<bool> attrValue);
  ::mlir::Attribute removeLowerAttr() {
      auto attr = getProperties().lower;
      getProperties().lower = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value a, /*optional*/::mlir::BoolAttr lower);
  static CholeskyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value a, /*optional*/::mlir::BoolAttr lower);
  static CholeskyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value a, /*optional*/::mlir::BoolAttr lower);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, /*optional*/::mlir::BoolAttr lower);
  static CholeskyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value a, /*optional*/::mlir::BoolAttr lower);
  static CholeskyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value a, /*optional*/::mlir::BoolAttr lower);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, /*optional*/::mlir::BoolAttr lower);
  static CholeskyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, /*optional*/::mlir::BoolAttr lower);
  static CholeskyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, /*optional*/::mlir::BoolAttr lower);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value a, /*optional*/bool lower = false);
  static CholeskyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value a, /*optional*/bool lower = false);
  static CholeskyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value a, /*optional*/bool lower = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, /*optional*/bool lower = false);
  static CholeskyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value a, /*optional*/bool lower = false);
  static CholeskyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value a, /*optional*/bool lower = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, /*optional*/bool lower = false);
  static CholeskyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, /*optional*/bool lower = false);
  static CholeskyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, /*optional*/bool lower = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CholeskyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CholeskyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CholeskyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CholeskyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CholeskyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CholeskyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CholeskyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CholeskyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::CholeskyOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::ClampOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ClampOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClampOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.clamp", odsAttrs.getContext());
  }

  ClampOpGenericAdaptorBase(ClampOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class ClampOpGenericAdaptor : public detail::ClampOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClampOpGenericAdaptorBase;
  static constexpr int odsIndex_min = 0;
  static constexpr int odsIndex_operand = 1;
  static constexpr int odsIndex_max = 2;
public:
  ClampOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClampOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClampOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClampOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClampOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClampOpGenericAdaptor(RangeT values, const ClampOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClampOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClampOp>>>
  ClampOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMin() {
    return (*getODSOperands(0).begin());
  }

  ValueT getOperand() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMax() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClampOpAdaptor : public ClampOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClampOpGenericAdaptor::ClampOpGenericAdaptor;
  ClampOpAdaptor(ClampOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClampOp : public ::mlir::Op<ClampOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultElementType, ::mlir::hlo::OpTrait::BroadcastingElementwise, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClampOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClampOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_min = 0;
  static constexpr int odsIndex_operand = 1;
  static constexpr int odsIndex_max = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.clamp");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getMin() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getMax() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getMinMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMaxMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value min, ::mlir::Value operand, ::mlir::Value max);
  static ClampOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value min, ::mlir::Value operand, ::mlir::Value max);
  static ClampOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value min, ::mlir::Value operand, ::mlir::Value max);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value min, ::mlir::Value operand, ::mlir::Value max);
  static ClampOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value min, ::mlir::Value operand, ::mlir::Value max);
  static ClampOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value min, ::mlir::Value operand, ::mlir::Value max);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value min, ::mlir::Value operand, ::mlir::Value max);
  static ClampOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value min, ::mlir::Value operand, ::mlir::Value max);
  static ClampOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value min, ::mlir::Value operand, ::mlir::Value max);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClampOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClampOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClampOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClampOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClampOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClampOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClampOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClampOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  ::llvm::LogicalResult reifyReturnTypeShapes(::mlir::OpBuilder&builder, ::mlir::ValueRange operands, ::llvm::SmallVectorImpl<::mlir::Value> &reifiedReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::ClampOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::ClzOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ClzOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClzOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.count_leading_zeros", odsAttrs.getContext());
  }

  ClzOpGenericAdaptorBase(ClzOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class ClzOpGenericAdaptor : public detail::ClzOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClzOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  ClzOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClzOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClzOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClzOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClzOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClzOpGenericAdaptor(RangeT values, const ClzOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClzOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClzOp>>>
  ClzOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClzOpAdaptor : public ClzOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClzOpGenericAdaptor::ClzOpGenericAdaptor;
  ClzOpAdaptor(ClzOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClzOp : public ::mlir::Op<ClzOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::Elementwise, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClzOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClzOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.count_leading_zeros");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static ClzOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static ClzOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static ClzOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static ClzOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static ClzOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static ClzOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClzOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClzOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClzOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClzOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClzOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClzOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClzOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClzOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::ClzOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::CollectiveBroadcastOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CollectiveBroadcastOpGenericAdaptorBase {
public:
  struct Properties {
    using channel_handleTy = ::mlir::stablehlo::ChannelHandleAttr;
    channel_handleTy channel_handle;

    auto getChannelHandle() const {
      auto &propStorage = this->channel_handle;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(propStorage);
    }
    void setChannelHandle(const ::mlir::stablehlo::ChannelHandleAttr &propValue) {
      this->channel_handle = propValue;
    }
    using replica_groupsTy = ::mlir::DenseIntElementsAttr;
    replica_groupsTy replica_groups;

    auto getReplicaGroups() const {
      auto &propStorage = this->replica_groups;
      return ::llvm::cast<::mlir::DenseIntElementsAttr>(propStorage);
    }
    void setReplicaGroups(const ::mlir::DenseIntElementsAttr &propValue) {
      this->replica_groups = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.channel_handle == this->channel_handle &&
        rhs.replica_groups == this->replica_groups &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CollectiveBroadcastOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.collective_broadcast", odsAttrs.getContext());
  }

  CollectiveBroadcastOpGenericAdaptorBase(CollectiveBroadcastOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseIntElementsAttr getReplicaGroupsAttr() {
    auto attr = ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().replica_groups);
    return attr;
  }

  ::mlir::DenseIntElementsAttr getReplicaGroups();
  ::mlir::stablehlo::ChannelHandleAttr getChannelHandleAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(getProperties().channel_handle);
    return attr;
  }

  ::std::optional<::mlir::stablehlo::ChannelHandleAttr> getChannelHandle();
};
} // namespace detail
template <typename RangeT>
class CollectiveBroadcastOpGenericAdaptor : public detail::CollectiveBroadcastOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CollectiveBroadcastOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CollectiveBroadcastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CollectiveBroadcastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CollectiveBroadcastOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CollectiveBroadcastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CollectiveBroadcastOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CollectiveBroadcastOpGenericAdaptor(RangeT values, const CollectiveBroadcastOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CollectiveBroadcastOp, typename = std::enable_if_t<std::is_same_v<LateInst, CollectiveBroadcastOp>>>
  CollectiveBroadcastOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CollectiveBroadcastOpAdaptor : public CollectiveBroadcastOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CollectiveBroadcastOpGenericAdaptor::CollectiveBroadcastOpGenericAdaptor;
  CollectiveBroadcastOpAdaptor(CollectiveBroadcastOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CollectiveBroadcastOp : public ::mlir::Op<CollectiveBroadcastOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::OpTrait::SameOperandsAndResultElementType, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CollectiveBroadcastOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CollectiveBroadcastOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("channel_handle"), ::llvm::StringRef("replica_groups")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getChannelHandleAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getChannelHandleAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getReplicaGroupsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getReplicaGroupsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.collective_broadcast");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseIntElementsAttr getReplicaGroupsAttr() {
    return ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().replica_groups);
  }

  ::mlir::DenseIntElementsAttr getReplicaGroups();
  ::mlir::stablehlo::ChannelHandleAttr getChannelHandleAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(getProperties().channel_handle);
  }

  ::std::optional<::mlir::stablehlo::ChannelHandleAttr> getChannelHandle();
  void setReplicaGroupsAttr(::mlir::DenseIntElementsAttr attr) {
    getProperties().replica_groups = attr;
  }

  void setChannelHandleAttr(::mlir::stablehlo::ChannelHandleAttr attr) {
    getProperties().channel_handle = attr;
  }

  ::mlir::Attribute removeChannelHandleAttr() {
      auto attr = getProperties().channel_handle;
      getProperties().channel_handle = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result_type, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups);
  static CollectiveBroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result_type, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups);
  static CollectiveBroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result_type, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static CollectiveBroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static CollectiveBroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static CollectiveBroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static CollectiveBroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static CollectiveBroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static CollectiveBroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CollectiveBroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CollectiveBroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CollectiveBroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CollectiveBroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CollectiveBroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CollectiveBroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CollectiveBroadcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CollectiveBroadcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::CollectiveBroadcastOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::CollectivePermuteOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CollectivePermuteOpGenericAdaptorBase {
public:
  struct Properties {
    using channel_handleTy = ::mlir::stablehlo::ChannelHandleAttr;
    channel_handleTy channel_handle;

    auto getChannelHandle() const {
      auto &propStorage = this->channel_handle;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(propStorage);
    }
    void setChannelHandle(const ::mlir::stablehlo::ChannelHandleAttr &propValue) {
      this->channel_handle = propValue;
    }
    using source_target_pairsTy = ::mlir::DenseIntElementsAttr;
    source_target_pairsTy source_target_pairs;

    auto getSourceTargetPairs() const {
      auto &propStorage = this->source_target_pairs;
      return ::llvm::cast<::mlir::DenseIntElementsAttr>(propStorage);
    }
    void setSourceTargetPairs(const ::mlir::DenseIntElementsAttr &propValue) {
      this->source_target_pairs = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.channel_handle == this->channel_handle &&
        rhs.source_target_pairs == this->source_target_pairs &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CollectivePermuteOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.collective_permute", odsAttrs.getContext());
  }

  CollectivePermuteOpGenericAdaptorBase(CollectivePermuteOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseIntElementsAttr getSourceTargetPairsAttr() {
    auto attr = ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().source_target_pairs);
    return attr;
  }

  ::mlir::DenseIntElementsAttr getSourceTargetPairs();
  ::mlir::stablehlo::ChannelHandleAttr getChannelHandleAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(getProperties().channel_handle);
    return attr;
  }

  ::std::optional<::mlir::stablehlo::ChannelHandleAttr> getChannelHandle();
};
} // namespace detail
template <typename RangeT>
class CollectivePermuteOpGenericAdaptor : public detail::CollectivePermuteOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CollectivePermuteOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CollectivePermuteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CollectivePermuteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CollectivePermuteOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CollectivePermuteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CollectivePermuteOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CollectivePermuteOpGenericAdaptor(RangeT values, const CollectivePermuteOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CollectivePermuteOp, typename = std::enable_if_t<std::is_same_v<LateInst, CollectivePermuteOp>>>
  CollectivePermuteOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CollectivePermuteOpAdaptor : public CollectivePermuteOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CollectivePermuteOpGenericAdaptor::CollectivePermuteOpGenericAdaptor;
  CollectivePermuteOpAdaptor(CollectivePermuteOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CollectivePermuteOp : public ::mlir::Op<CollectivePermuteOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::OpTrait::SameOperandsAndResultElementType, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CollectivePermuteOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CollectivePermuteOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("channel_handle"), ::llvm::StringRef("source_target_pairs")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getChannelHandleAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getChannelHandleAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSourceTargetPairsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSourceTargetPairsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.collective_permute");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseIntElementsAttr getSourceTargetPairsAttr() {
    return ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().source_target_pairs);
  }

  ::mlir::DenseIntElementsAttr getSourceTargetPairs();
  ::mlir::stablehlo::ChannelHandleAttr getChannelHandleAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ChannelHandleAttr>(getProperties().channel_handle);
  }

  ::std::optional<::mlir::stablehlo::ChannelHandleAttr> getChannelHandle();
  void setSourceTargetPairsAttr(::mlir::DenseIntElementsAttr attr) {
    getProperties().source_target_pairs = attr;
  }

  void setChannelHandleAttr(::mlir::stablehlo::ChannelHandleAttr attr) {
    getProperties().channel_handle = attr;
  }

  ::mlir::Attribute removeChannelHandleAttr() {
      auto attr = getProperties().channel_handle;
      getProperties().channel_handle = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result_type, ::mlir::Value operand, ::mlir::DenseIntElementsAttr source_target_pairs);
  static CollectivePermuteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result_type, ::mlir::Value operand, ::mlir::DenseIntElementsAttr source_target_pairs);
  static CollectivePermuteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result_type, ::mlir::Value operand, ::mlir::DenseIntElementsAttr source_target_pairs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseIntElementsAttr source_target_pairs, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static CollectivePermuteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseIntElementsAttr source_target_pairs, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static CollectivePermuteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseIntElementsAttr source_target_pairs, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::DenseIntElementsAttr source_target_pairs, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static CollectivePermuteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::DenseIntElementsAttr source_target_pairs, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static CollectivePermuteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::DenseIntElementsAttr source_target_pairs, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseIntElementsAttr source_target_pairs, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static CollectivePermuteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseIntElementsAttr source_target_pairs, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static CollectivePermuteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseIntElementsAttr source_target_pairs, /*optional*/::mlir::stablehlo::ChannelHandleAttr channel_handle);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CollectivePermuteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CollectivePermuteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CollectivePermuteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CollectivePermuteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CollectivePermuteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CollectivePermuteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CollectivePermuteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CollectivePermuteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::CollectivePermuteOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::CompareOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CompareOpGenericAdaptorBase {
public:
  struct Properties {
    using compare_typeTy = ::mlir::stablehlo::ComparisonTypeAttr;
    compare_typeTy compare_type;

    auto getCompareType() const {
      auto &propStorage = this->compare_type;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ComparisonTypeAttr>(propStorage);
    }
    void setCompareType(const ::mlir::stablehlo::ComparisonTypeAttr &propValue) {
      this->compare_type = propValue;
    }
    using comparison_directionTy = ::mlir::stablehlo::ComparisonDirectionAttr;
    comparison_directionTy comparison_direction;

    auto getComparisonDirection() const {
      auto &propStorage = this->comparison_direction;
      return ::llvm::cast<::mlir::stablehlo::ComparisonDirectionAttr>(propStorage);
    }
    void setComparisonDirection(const ::mlir::stablehlo::ComparisonDirectionAttr &propValue) {
      this->comparison_direction = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.compare_type == this->compare_type &&
        rhs.comparison_direction == this->comparison_direction &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CompareOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.compare", odsAttrs.getContext());
  }

  CompareOpGenericAdaptorBase(CompareOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::stablehlo::ComparisonDirectionAttr getComparisonDirectionAttr() {
    auto attr = ::llvm::cast<::mlir::stablehlo::ComparisonDirectionAttr>(getProperties().comparison_direction);
    return attr;
  }

  ::mlir::stablehlo::ComparisonDirection getComparisonDirection();
  ::mlir::stablehlo::ComparisonTypeAttr getCompareTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::stablehlo::ComparisonTypeAttr>(getProperties().compare_type);
    return attr;
  }

  ::std::optional<::mlir::stablehlo::ComparisonType> getCompareType();
};
} // namespace detail
template <typename RangeT>
class CompareOpGenericAdaptor : public detail::CompareOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CompareOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  CompareOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CompareOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CompareOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CompareOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CompareOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CompareOpGenericAdaptor(RangeT values, const CompareOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CompareOp, typename = std::enable_if_t<std::is_same_v<LateInst, CompareOp>>>
  CompareOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CompareOpAdaptor : public CompareOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CompareOpGenericAdaptor::CompareOpGenericAdaptor;
  CompareOpAdaptor(CompareOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CompareOp : public ::mlir::Op<CompareOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::Elementwise, ::mlir::hlo::OpTrait::CompatibleOperandsElementType, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CompareOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CompareOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("compare_type"), ::llvm::StringRef("comparison_direction")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCompareTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCompareTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getComparisonDirectionAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getComparisonDirectionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.compare");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::stablehlo::ComparisonDirectionAttr getComparisonDirectionAttr() {
    return ::llvm::cast<::mlir::stablehlo::ComparisonDirectionAttr>(getProperties().comparison_direction);
  }

  ::mlir::stablehlo::ComparisonDirection getComparisonDirection();
  ::mlir::stablehlo::ComparisonTypeAttr getCompareTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ComparisonTypeAttr>(getProperties().compare_type);
  }

  ::std::optional<::mlir::stablehlo::ComparisonType> getCompareType();
  void setComparisonDirectionAttr(::mlir::stablehlo::ComparisonDirectionAttr attr) {
    getProperties().comparison_direction = attr;
  }

  void setComparisonDirection(::mlir::stablehlo::ComparisonDirection attrValue);
  void setCompareTypeAttr(::mlir::stablehlo::ComparisonTypeAttr attr) {
    getProperties().compare_type = attr;
  }

  void setCompareType(::std::optional<::mlir::stablehlo::ComparisonType> attrValue);
  ::mlir::Attribute removeCompareTypeAttr() {
      auto attr = getProperties().compare_type;
      getProperties().compare_type = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value lhs, Value rhs, ::mlir::stablehlo::ComparisonDirection comparison_direction, ::mlir::stablehlo::ComparisonType compare_type = ::mlir::stablehlo::ComparisonType::NOTYPE);
  static CompareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value lhs, Value rhs, ::mlir::stablehlo::ComparisonDirection comparison_direction, ::mlir::stablehlo::ComparisonType compare_type = ::mlir::stablehlo::ComparisonType::NOTYPE);
  static CompareOp create(::mlir::ImplicitLocOpBuilder &builder, Value lhs, Value rhs, ::mlir::stablehlo::ComparisonDirection comparison_direction, ::mlir::stablehlo::ComparisonType compare_type = ::mlir::stablehlo::ComparisonType::NOTYPE);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirectionAttr comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static CompareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirectionAttr comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static CompareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirectionAttr comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirectionAttr comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static CompareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirectionAttr comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static CompareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirectionAttr comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirectionAttr comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static CompareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirectionAttr comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static CompareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirectionAttr comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirection comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static CompareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirection comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static CompareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirection comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirection comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static CompareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirection comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static CompareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirection comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirection comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static CompareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirection comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static CompareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::ComparisonDirection comparison_direction, /*optional*/::mlir::stablehlo::ComparisonTypeAttr compare_type);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CompareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CompareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CompareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CompareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CompareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CompareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CompareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CompareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  ::llvm::LogicalResult reifyReturnTypeShapes(::mlir::OpBuilder&builder, ::mlir::ValueRange operands, ::llvm::SmallVectorImpl<::mlir::Value> &reifiedReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::CompareOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::ComplexOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ComplexOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ComplexOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.complex", odsAttrs.getContext());
  }

  ComplexOpGenericAdaptorBase(ComplexOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class ComplexOpGenericAdaptor : public detail::ComplexOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ComplexOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  ComplexOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ComplexOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ComplexOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ComplexOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ComplexOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ComplexOpGenericAdaptor(RangeT values, const ComplexOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ComplexOp, typename = std::enable_if_t<std::is_same_v<LateInst, ComplexOp>>>
  ComplexOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ComplexOpAdaptor : public ComplexOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ComplexOpGenericAdaptor::ComplexOpGenericAdaptor;
  ComplexOpAdaptor(ComplexOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ComplexOp : public ::mlir::Op<ComplexOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsElementType, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::Elementwise> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ComplexOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ComplexOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.complex");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static ComplexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static ComplexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static ComplexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static ComplexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static ComplexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static ComplexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ComplexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ComplexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ComplexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ComplexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ComplexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ComplexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ComplexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ComplexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                               operands.front(),
                                               &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::ComplexOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::CompositeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CompositeOpGenericAdaptorBase {
public:
  struct Properties {
    using composite_attributesTy = ::mlir::DictionaryAttr;
    composite_attributesTy composite_attributes;

    auto getCompositeAttributes() const {
      auto &propStorage = this->composite_attributes;
      return ::llvm::dyn_cast_or_null<::mlir::DictionaryAttr>(propStorage);
    }
    void setCompositeAttributes(const ::mlir::DictionaryAttr &propValue) {
      this->composite_attributes = propValue;
    }
    using decompositionTy = ::mlir::FlatSymbolRefAttr;
    decompositionTy decomposition;

    auto getDecomposition() const {
      auto &propStorage = this->decomposition;
      return ::llvm::cast<::mlir::FlatSymbolRefAttr>(propStorage);
    }
    void setDecomposition(const ::mlir::FlatSymbolRefAttr &propValue) {
      this->decomposition = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using versionTy = ::mlir::IntegerAttr;
    versionTy version;

    auto getVersion() const {
      auto &propStorage = this->version;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setVersion(const ::mlir::IntegerAttr &propValue) {
      this->version = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.composite_attributes == this->composite_attributes &&
        rhs.decomposition == this->decomposition &&
        rhs.name == this->name &&
        rhs.version == this->version &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CompositeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.composite", odsAttrs.getContext());
  }

  CompositeOpGenericAdaptorBase(CompositeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::llvm::StringRef getName();
  ::mlir::DictionaryAttr getCompositeAttributesAttr();
  ::mlir::DictionaryAttr getCompositeAttributes();
  ::mlir::FlatSymbolRefAttr getDecompositionAttr() {
    auto attr = ::llvm::cast<::mlir::FlatSymbolRefAttr>(getProperties().decomposition);
    return attr;
  }

  ::llvm::StringRef getDecomposition();
  ::mlir::IntegerAttr getVersionAttr();
  uint32_t getVersion();
};
} // namespace detail
template <typename RangeT>
class CompositeOpGenericAdaptor : public detail::CompositeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CompositeOpGenericAdaptorBase;
  static constexpr int odsIndex_inputs = 0;
public:
  CompositeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CompositeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CompositeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CompositeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CompositeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CompositeOpGenericAdaptor(RangeT values, const CompositeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CompositeOp, typename = std::enable_if_t<std::is_same_v<LateInst, CompositeOp>>>
  CompositeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getInputs() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CompositeOpAdaptor : public CompositeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CompositeOpGenericAdaptor::CompositeOpGenericAdaptor;
  CompositeOpAdaptor(CompositeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CompositeOp : public ::mlir::Op<CompositeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::SymbolUserOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CompositeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CompositeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_inputs = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("composite_attributes"), ::llvm::StringRef("decomposition"), ::llvm::StringRef("name"), ::llvm::StringRef("version")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCompositeAttributesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCompositeAttributesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDecompositionAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDecompositionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getVersionAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getVersionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.composite");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getInputs() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getInputsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().name);
  }

  ::llvm::StringRef getName();
  ::mlir::DictionaryAttr getCompositeAttributesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DictionaryAttr>(getProperties().composite_attributes);
  }

  ::mlir::DictionaryAttr getCompositeAttributes();
  ::mlir::FlatSymbolRefAttr getDecompositionAttr() {
    return ::llvm::cast<::mlir::FlatSymbolRefAttr>(getProperties().decomposition);
  }

  ::llvm::StringRef getDecomposition();
  ::mlir::IntegerAttr getVersionAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().version);
  }

  uint32_t getVersion();
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::llvm::StringRef attrValue);
  void setCompositeAttributesAttr(::mlir::DictionaryAttr attr) {
    getProperties().composite_attributes = attr;
  }

  void setDecompositionAttr(::mlir::FlatSymbolRefAttr attr) {
    getProperties().decomposition = attr;
  }

  void setDecomposition(::llvm::StringRef attrValue);
  void setVersionAttr(::mlir::IntegerAttr attr) {
    getProperties().version = attr;
  }

  void setVersion(::std::optional<uint32_t> attrValue);
  ::mlir::Attribute removeCompositeAttributesAttr() {
      auto attr = getProperties().composite_attributes;
      getProperties().composite_attributes = {};
      return attr;
  }

  ::mlir::Attribute removeVersionAttr() {
      auto attr = getProperties().version;
      getProperties().version = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::ValueRange inputs, ::mlir::StringAttr name, /*optional*/::mlir::DictionaryAttr composite_attributes, ::mlir::FlatSymbolRefAttr decomposition, /*optional*/::mlir::IntegerAttr version = nullptr);
  static CompositeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::ValueRange inputs, ::mlir::StringAttr name, /*optional*/::mlir::DictionaryAttr composite_attributes, ::mlir::FlatSymbolRefAttr decomposition, /*optional*/::mlir::IntegerAttr version = nullptr);
  static CompositeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::ValueRange inputs, ::mlir::StringAttr name, /*optional*/::mlir::DictionaryAttr composite_attributes, ::mlir::FlatSymbolRefAttr decomposition, /*optional*/::mlir::IntegerAttr version = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::ValueRange inputs, ::llvm::StringRef name, /*optional*/::mlir::DictionaryAttr composite_attributes, ::llvm::StringRef decomposition, /*optional*/uint32_t version = 0);
  static CompositeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::ValueRange inputs, ::llvm::StringRef name, /*optional*/::mlir::DictionaryAttr composite_attributes, ::llvm::StringRef decomposition, /*optional*/uint32_t version = 0);
  static CompositeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::ValueRange inputs, ::llvm::StringRef name, /*optional*/::mlir::DictionaryAttr composite_attributes, ::llvm::StringRef decomposition, /*optional*/uint32_t version = 0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CompositeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CompositeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CompositeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CompositeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verifySymbolUses(::mlir::SymbolTableCollection &symbolTable);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::CompositeOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::ConcatenateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ConcatenateOpGenericAdaptorBase {
public:
  struct Properties {
    using dimensionTy = ::mlir::IntegerAttr;
    dimensionTy dimension;

    auto getDimension() const {
      auto &propStorage = this->dimension;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDimension(const ::mlir::IntegerAttr &propValue) {
      this->dimension = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dimension == this->dimension &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConcatenateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.concatenate", odsAttrs.getContext());
  }

  ConcatenateOpGenericAdaptorBase(ConcatenateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDimensionAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dimension);
    return attr;
  }

  uint64_t getDimension();
};
} // namespace detail
template <typename RangeT>
class ConcatenateOpGenericAdaptor : public detail::ConcatenateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConcatenateOpGenericAdaptorBase;
  static constexpr int odsIndex_inputs = 0;
public:
  ConcatenateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConcatenateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConcatenateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConcatenateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConcatenateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConcatenateOpGenericAdaptor(RangeT values, const ConcatenateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConcatenateOp, typename = std::enable_if_t<std::is_same_v<LateInst, ConcatenateOp>>>
  ConcatenateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getInputs() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConcatenateOpAdaptor : public ConcatenateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConcatenateOpGenericAdaptor::ConcatenateOpGenericAdaptor;
  ConcatenateOpAdaptor(ConcatenateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConcatenateOp : public ::mlir::Op<ConcatenateOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultElementType, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConcatenateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConcatenateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_inputs = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dimension")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDimensionAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDimensionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.concatenate");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getInputs() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getInputsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDimensionAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dimension);
  }

  uint64_t getDimension();
  void setDimensionAttr(::mlir::IntegerAttr attr) {
    getProperties().dimension = attr;
  }

  void setDimension(uint64_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::ValueRange inputs, ::mlir::IntegerAttr dimension);
  static ConcatenateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::ValueRange inputs, ::mlir::IntegerAttr dimension);
  static ConcatenateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::ValueRange inputs, ::mlir::IntegerAttr dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange inputs, ::mlir::IntegerAttr dimension);
  static ConcatenateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange inputs, ::mlir::IntegerAttr dimension);
  static ConcatenateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange inputs, ::mlir::IntegerAttr dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange inputs, ::mlir::IntegerAttr dimension);
  static ConcatenateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange inputs, ::mlir::IntegerAttr dimension);
  static ConcatenateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange inputs, ::mlir::IntegerAttr dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::ValueRange inputs, uint64_t dimension);
  static ConcatenateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::ValueRange inputs, uint64_t dimension);
  static ConcatenateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::ValueRange inputs, uint64_t dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange inputs, uint64_t dimension);
  static ConcatenateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange inputs, uint64_t dimension);
  static ConcatenateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange inputs, uint64_t dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange inputs, uint64_t dimension);
  static ConcatenateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange inputs, uint64_t dimension);
  static ConcatenateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange inputs, uint64_t dimension);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConcatenateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConcatenateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConcatenateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConcatenateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConcatenateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConcatenateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConcatenateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConcatenateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::llvm::LogicalResult reifyReturnTypeShapes(::mlir::OpBuilder&builder, ::mlir::ValueRange operands, ::llvm::SmallVectorImpl<::mlir::Value> &reifiedReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  /// Interface method for ConditionallySpeculatable.
  mlir::Speculation::Speculatability getSpeculatability();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::ConcatenateOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::ConstantOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ConstantOpGenericAdaptorBase {
public:
  struct Properties {
    using valueTy = ::mlir::ElementsAttr;
    valueTy value;

    auto getValue() const {
      auto &propStorage = this->value;
      return ::llvm::cast<::mlir::ElementsAttr>(propStorage);
    }
    void setValue(const ::mlir::ElementsAttr &propValue) {
      this->value = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.value == this->value &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConstantOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.constant", odsAttrs.getContext());
  }

  ConstantOpGenericAdaptorBase(ConstantOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ElementsAttr getValueAttr() {
    auto attr = ::llvm::cast<::mlir::ElementsAttr>(getProperties().value);
    return attr;
  }

  ::mlir::ElementsAttr getValue();
};
} // namespace detail
template <typename RangeT>
class ConstantOpGenericAdaptor : public detail::ConstantOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConstantOpGenericAdaptorBase;
public:
  ConstantOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConstantOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConstantOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConstantOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConstantOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConstantOpGenericAdaptor(RangeT values, const ConstantOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConstantOp, typename = std::enable_if_t<std::is_same_v<LateInst, ConstantOp>>>
  ConstantOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConstantOpAdaptor : public ConstantOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConstantOpGenericAdaptor::ConstantOpGenericAdaptor;
  ConstantOpAdaptor(ConstantOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConstantOp : public ::mlir::Op<ConstantOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::ConstantLike, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConstantOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConstantOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("value")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getValueAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getValueAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.constant");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ElementsAttr getValueAttr() {
    return ::llvm::cast<::mlir::ElementsAttr>(getProperties().value);
  }

  ::mlir::ElementsAttr getValue();
  void setValueAttr(::mlir::ElementsAttr attr) {
    getProperties().value = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Attribute value);
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Attribute value);
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, Attribute value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::ElementsAttr value);
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type output, ::mlir::ElementsAttr value);
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type output, ::mlir::ElementsAttr value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ElementsAttr value);
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ElementsAttr value);
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ElementsAttr value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ElementsAttr value);
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ElementsAttr value);
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ElementsAttr value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r);
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::ConstantOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::ConvertOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ConvertOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.convert", odsAttrs.getContext());
  }

  ConvertOpGenericAdaptorBase(ConvertOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class ConvertOpGenericAdaptor : public detail::ConvertOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  ConvertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertOpGenericAdaptor(RangeT values, const ConvertOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertOp, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertOp>>>
  ConvertOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertOpAdaptor : public ConvertOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertOpGenericAdaptor::ConvertOpGenericAdaptor;
  ConvertOpAdaptor(ConvertOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertOp : public ::mlir::Op<ConvertOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::OpTrait::Elementwise, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.convert");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value operand, Type result_element_ty);
  static ConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value operand, Type result_element_ty);
  static ConvertOp create(::mlir::ImplicitLocOpBuilder &builder, Value operand, Type result_element_ty);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static ConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static ConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static ConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static ConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::ConvertOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::ConvolutionOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ConvolutionOpGenericAdaptorBase {
public:
  struct Properties {
    using batch_group_countTy = ::mlir::IntegerAttr;
    batch_group_countTy batch_group_count;

    auto getBatchGroupCount() const {
      auto &propStorage = this->batch_group_count;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBatchGroupCount(const ::mlir::IntegerAttr &propValue) {
      this->batch_group_count = propValue;
    }
    using dimension_numbersTy = ::mlir::stablehlo::ConvDimensionNumbersAttr;
    dimension_numbersTy dimension_numbers;

    auto getDimensionNumbers() const {
      auto &propStorage = this->dimension_numbers;
      return ::llvm::cast<::mlir::stablehlo::ConvDimensionNumbersAttr>(propStorage);
    }
    void setDimensionNumbers(const ::mlir::stablehlo::ConvDimensionNumbersAttr &propValue) {
      this->dimension_numbers = propValue;
    }
    using feature_group_countTy = ::mlir::IntegerAttr;
    feature_group_countTy feature_group_count;

    auto getFeatureGroupCount() const {
      auto &propStorage = this->feature_group_count;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setFeatureGroupCount(const ::mlir::IntegerAttr &propValue) {
      this->feature_group_count = propValue;
    }
    using lhs_dilationTy = ::mlir::DenseI64ArrayAttr;
    lhs_dilationTy lhs_dilation;

    auto getLhsDilation() const {
      auto &propStorage = this->lhs_dilation;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setLhsDilation(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->lhs_dilation = propValue;
    }
    using paddingTy = ::mlir::DenseIntElementsAttr;
    paddingTy padding;

    auto getPadding() const {
      auto &propStorage = this->padding;
      return ::llvm::dyn_cast_or_null<::mlir::DenseIntElementsAttr>(propStorage);
    }
    void setPadding(const ::mlir::DenseIntElementsAttr &propValue) {
      this->padding = propValue;
    }
    using precision_configTy = ::mlir::ArrayAttr;
    precision_configTy precision_config;

    auto getPrecisionConfig() const {
      auto &propStorage = this->precision_config;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setPrecisionConfig(const ::mlir::ArrayAttr &propValue) {
      this->precision_config = propValue;
    }
    using rhs_dilationTy = ::mlir::DenseI64ArrayAttr;
    rhs_dilationTy rhs_dilation;

    auto getRhsDilation() const {
      auto &propStorage = this->rhs_dilation;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setRhsDilation(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->rhs_dilation = propValue;
    }
    using window_reversalTy = ::mlir::DenseBoolArrayAttr;
    window_reversalTy window_reversal;

    auto getWindowReversal() const {
      auto &propStorage = this->window_reversal;
      return ::llvm::dyn_cast_or_null<::mlir::DenseBoolArrayAttr>(propStorage);
    }
    void setWindowReversal(const ::mlir::DenseBoolArrayAttr &propValue) {
      this->window_reversal = propValue;
    }
    using window_stridesTy = ::mlir::DenseI64ArrayAttr;
    window_stridesTy window_strides;

    auto getWindowStrides() const {
      auto &propStorage = this->window_strides;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setWindowStrides(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->window_strides = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.batch_group_count == this->batch_group_count &&
        rhs.dimension_numbers == this->dimension_numbers &&
        rhs.feature_group_count == this->feature_group_count &&
        rhs.lhs_dilation == this->lhs_dilation &&
        rhs.padding == this->padding &&
        rhs.precision_config == this->precision_config &&
        rhs.rhs_dilation == this->rhs_dilation &&
        rhs.window_reversal == this->window_reversal &&
        rhs.window_strides == this->window_strides &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvolutionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.convolution", odsAttrs.getContext());
  }

  ConvolutionOpGenericAdaptorBase(ConvolutionOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getWindowStridesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().window_strides);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getWindowStrides();
  ::mlir::DenseIntElementsAttr getPaddingAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseIntElementsAttr>(getProperties().padding);
    return attr;
  }

  ::std::optional< ::mlir::DenseIntElementsAttr > getPadding();
  ::mlir::DenseI64ArrayAttr getLhsDilationAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().lhs_dilation);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getLhsDilation();
  ::mlir::DenseI64ArrayAttr getRhsDilationAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().rhs_dilation);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getRhsDilation();
  ::mlir::DenseBoolArrayAttr getWindowReversalAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseBoolArrayAttr>(getProperties().window_reversal);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<bool>> getWindowReversal();
  ::mlir::stablehlo::ConvDimensionNumbersAttr getDimensionNumbersAttr() {
    auto attr = ::llvm::cast<::mlir::stablehlo::ConvDimensionNumbersAttr>(getProperties().dimension_numbers);
    return attr;
  }

  ::mlir::stablehlo::ConvDimensionNumbersAttr getDimensionNumbers();
  ::mlir::IntegerAttr getFeatureGroupCountAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().feature_group_count);
    return attr;
  }

  uint64_t getFeatureGroupCount();
  ::mlir::IntegerAttr getBatchGroupCountAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().batch_group_count);
    return attr;
  }

  uint64_t getBatchGroupCount();
  ::mlir::ArrayAttr getPrecisionConfigAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().precision_config);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getPrecisionConfig();
};
} // namespace detail
template <typename RangeT>
class ConvolutionOpGenericAdaptor : public detail::ConvolutionOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvolutionOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  ConvolutionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvolutionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvolutionOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvolutionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvolutionOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvolutionOpGenericAdaptor(RangeT values, const ConvolutionOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvolutionOp, typename = std::enable_if_t<std::is_same_v<LateInst, ConvolutionOp>>>
  ConvolutionOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvolutionOpAdaptor : public ConvolutionOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvolutionOpGenericAdaptor::ConvolutionOpGenericAdaptor;
  ConvolutionOpAdaptor(ConvolutionOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvolutionOp : public ::mlir::Op<ConvolutionOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvolutionOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvolutionOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("batch_group_count"), ::llvm::StringRef("dimension_numbers"), ::llvm::StringRef("feature_group_count"), ::llvm::StringRef("lhs_dilation"), ::llvm::StringRef("padding"), ::llvm::StringRef("precision_config"), ::llvm::StringRef("rhs_dilation"), ::llvm::StringRef("window_reversal"), ::llvm::StringRef("window_strides")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBatchGroupCountAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBatchGroupCountAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDimensionNumbersAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDimensionNumbersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getFeatureGroupCountAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getFeatureGroupCountAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getLhsDilationAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getLhsDilationAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getPaddingAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getPaddingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getPrecisionConfigAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getPrecisionConfigAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getRhsDilationAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getRhsDilationAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getWindowReversalAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getWindowReversalAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getWindowStridesAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getWindowStridesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.convolution");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getWindowStridesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().window_strides);
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getWindowStrides();
  ::mlir::DenseIntElementsAttr getPaddingAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseIntElementsAttr>(getProperties().padding);
  }

  ::std::optional< ::mlir::DenseIntElementsAttr > getPadding();
  ::mlir::DenseI64ArrayAttr getLhsDilationAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().lhs_dilation);
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getLhsDilation();
  ::mlir::DenseI64ArrayAttr getRhsDilationAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().rhs_dilation);
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getRhsDilation();
  ::mlir::DenseBoolArrayAttr getWindowReversalAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseBoolArrayAttr>(getProperties().window_reversal);
  }

  ::std::optional<::llvm::ArrayRef<bool>> getWindowReversal();
  ::mlir::stablehlo::ConvDimensionNumbersAttr getDimensionNumbersAttr() {
    return ::llvm::cast<::mlir::stablehlo::ConvDimensionNumbersAttr>(getProperties().dimension_numbers);
  }

  ::mlir::stablehlo::ConvDimensionNumbersAttr getDimensionNumbers();
  ::mlir::IntegerAttr getFeatureGroupCountAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().feature_group_count);
  }

  uint64_t getFeatureGroupCount();
  ::mlir::IntegerAttr getBatchGroupCountAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().batch_group_count);
  }

  uint64_t getBatchGroupCount();
  ::mlir::ArrayAttr getPrecisionConfigAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().precision_config);
  }

  ::std::optional< ::mlir::ArrayAttr > getPrecisionConfig();
  void setWindowStridesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().window_strides = attr;
  }

  void setWindowStrides(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setPaddingAttr(::mlir::DenseIntElementsAttr attr) {
    getProperties().padding = attr;
  }

  void setLhsDilationAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().lhs_dilation = attr;
  }

  void setLhsDilation(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setRhsDilationAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().rhs_dilation = attr;
  }

  void setRhsDilation(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setWindowReversalAttr(::mlir::DenseBoolArrayAttr attr) {
    getProperties().window_reversal = attr;
  }

  void setWindowReversal(::std::optional<::llvm::ArrayRef<bool>> attrValue);
  void setDimensionNumbersAttr(::mlir::stablehlo::ConvDimensionNumbersAttr attr) {
    getProperties().dimension_numbers = attr;
  }

  void setFeatureGroupCountAttr(::mlir::IntegerAttr attr) {
    getProperties().feature_group_count = attr;
  }

  void setFeatureGroupCount(uint64_t attrValue);
  void setBatchGroupCountAttr(::mlir::IntegerAttr attr) {
    getProperties().batch_group_count = attr;
  }

  void setBatchGroupCount(uint64_t attrValue);
  void setPrecisionConfigAttr(::mlir::ArrayAttr attr) {
    getProperties().precision_config = attr;
  }

  ::mlir::Attribute removeWindowStridesAttr() {
      auto attr = getProperties().window_strides;
      getProperties().window_strides = {};
      return attr;
  }

  ::mlir::Attribute removePaddingAttr() {
      auto attr = getProperties().padding;
      getProperties().padding = {};
      return attr;
  }

  ::mlir::Attribute removeLhsDilationAttr() {
      auto attr = getProperties().lhs_dilation;
      getProperties().lhs_dilation = {};
      return attr;
  }

  ::mlir::Attribute removeRhsDilationAttr() {
      auto attr = getProperties().rhs_dilation;
      getProperties().rhs_dilation = {};
      return attr;
  }

  ::mlir::Attribute removeWindowReversalAttr() {
      auto attr = getProperties().window_reversal;
      getProperties().window_reversal = {};
      return attr;
  }

  ::mlir::Attribute removePrecisionConfigAttr() {
      auto attr = getProperties().precision_config;
      getProperties().precision_config = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseIntElementsAttr padding, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, ::mlir::IntegerAttr feature_group_count, ::mlir::IntegerAttr batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static ConvolutionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseIntElementsAttr padding, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, ::mlir::IntegerAttr feature_group_count, ::mlir::IntegerAttr batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static ConvolutionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseIntElementsAttr padding, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, ::mlir::IntegerAttr feature_group_count, ::mlir::IntegerAttr batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseIntElementsAttr padding, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, ::mlir::IntegerAttr feature_group_count, ::mlir::IntegerAttr batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static ConvolutionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseIntElementsAttr padding, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, ::mlir::IntegerAttr feature_group_count, ::mlir::IntegerAttr batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static ConvolutionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseIntElementsAttr padding, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, ::mlir::IntegerAttr feature_group_count, ::mlir::IntegerAttr batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseIntElementsAttr padding, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, uint64_t feature_group_count, uint64_t batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static ConvolutionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseIntElementsAttr padding, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, uint64_t feature_group_count, uint64_t batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static ConvolutionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseIntElementsAttr padding, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, uint64_t feature_group_count, uint64_t batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseIntElementsAttr padding, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, uint64_t feature_group_count, uint64_t batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static ConvolutionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseIntElementsAttr padding, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, uint64_t feature_group_count, uint64_t batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static ConvolutionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseIntElementsAttr padding, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, uint64_t feature_group_count, uint64_t batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvolutionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvolutionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvolutionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvolutionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 9 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  /// Interface method for ConditionallySpeculatable.
  mlir::Speculation::Speculatability getSpeculatability();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::ConvolutionOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::CosineOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CosineOpGenericAdaptorBase {
public:
  struct Properties {
    using result_accuracyTy = ::mlir::stablehlo::ResultAccuracyAttr;
    result_accuracyTy result_accuracy;

    auto getResultAccuracy() const {
      auto &propStorage = this->result_accuracy;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(propStorage);
    }
    void setResultAccuracy(const ::mlir::stablehlo::ResultAccuracyAttr &propValue) {
      this->result_accuracy = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.result_accuracy == this->result_accuracy &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CosineOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.cosine", odsAttrs.getContext());
  }

  CosineOpGenericAdaptorBase(CosineOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr();
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
};
} // namespace detail
template <typename RangeT>
class CosineOpGenericAdaptor : public detail::CosineOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CosineOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CosineOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CosineOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CosineOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CosineOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CosineOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CosineOpGenericAdaptor(RangeT values, const CosineOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CosineOp, typename = std::enable_if_t<std::is_same_v<LateInst, CosineOp>>>
  CosineOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CosineOpAdaptor : public CosineOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CosineOpGenericAdaptor::CosineOpGenericAdaptor;
  CosineOpAdaptor(CosineOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CosineOp : public ::mlir::Op<CosineOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::Elementwise, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CosineOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CosineOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("result_accuracy")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getResultAccuracyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getResultAccuracyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.cosine");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(getProperties().result_accuracy);
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
  void setResultAccuracyAttr(::mlir::stablehlo::ResultAccuracyAttr attr) {
    getProperties().result_accuracy = attr;
  }

  ::mlir::Attribute removeResultAccuracyAttr() {
      auto attr = getProperties().result_accuracy;
      getProperties().result_accuracy = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static CosineOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static CosineOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static CosineOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static CosineOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static CosineOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static CosineOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CosineOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CosineOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CosineOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CosineOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CosineOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CosineOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CosineOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CosineOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::CosineOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::CreateTokenOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CreateTokenOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CreateTokenOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.create_token", odsAttrs.getContext());
  }

  CreateTokenOpGenericAdaptorBase(CreateTokenOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class CreateTokenOpGenericAdaptor : public detail::CreateTokenOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CreateTokenOpGenericAdaptorBase;
public:
  CreateTokenOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CreateTokenOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CreateTokenOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CreateTokenOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CreateTokenOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CreateTokenOpGenericAdaptor(RangeT values, const CreateTokenOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CreateTokenOp, typename = std::enable_if_t<std::is_same_v<LateInst, CreateTokenOp>>>
  CreateTokenOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CreateTokenOpAdaptor : public CreateTokenOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CreateTokenOpGenericAdaptor::CreateTokenOpGenericAdaptor;
  CreateTokenOpAdaptor(CreateTokenOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CreateTokenOp : public ::mlir::Op<CreateTokenOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CreateTokenOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CreateTokenOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.create_token");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output);
  static CreateTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type output);
  static CreateTokenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type output);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static CreateTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static CreateTokenOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static CreateTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static CreateTokenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CreateTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CreateTokenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CreateTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CreateTokenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CreateTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CreateTokenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CreateTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CreateTokenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::CreateTokenOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::CrossReplicaSumOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CrossReplicaSumOpGenericAdaptorBase {
public:
  struct Properties {
    using replica_groupsTy = ::mlir::DenseIntElementsAttr;
    replica_groupsTy replica_groups;

    auto getReplicaGroups() const {
      auto &propStorage = this->replica_groups;
      return ::llvm::cast<::mlir::DenseIntElementsAttr>(propStorage);
    }
    void setReplicaGroups(const ::mlir::DenseIntElementsAttr &propValue) {
      this->replica_groups = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.replica_groups == this->replica_groups &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CrossReplicaSumOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.cross-replica-sum", odsAttrs.getContext());
  }

  CrossReplicaSumOpGenericAdaptorBase(CrossReplicaSumOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseIntElementsAttr getReplicaGroupsAttr() {
    auto attr = ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().replica_groups);
    return attr;
  }

  ::mlir::DenseIntElementsAttr getReplicaGroups();
};
} // namespace detail
template <typename RangeT>
class CrossReplicaSumOpGenericAdaptor : public detail::CrossReplicaSumOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CrossReplicaSumOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  CrossReplicaSumOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CrossReplicaSumOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CrossReplicaSumOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CrossReplicaSumOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CrossReplicaSumOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CrossReplicaSumOpGenericAdaptor(RangeT values, const CrossReplicaSumOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CrossReplicaSumOp, typename = std::enable_if_t<std::is_same_v<LateInst, CrossReplicaSumOp>>>
  CrossReplicaSumOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CrossReplicaSumOpAdaptor : public CrossReplicaSumOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CrossReplicaSumOpGenericAdaptor::CrossReplicaSumOpGenericAdaptor;
  CrossReplicaSumOpAdaptor(CrossReplicaSumOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CrossReplicaSumOp : public ::mlir::Op<CrossReplicaSumOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CrossReplicaSumOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CrossReplicaSumOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("replica_groups")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getReplicaGroupsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getReplicaGroupsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.cross-replica-sum");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseIntElementsAttr getReplicaGroupsAttr() {
    return ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().replica_groups);
  }

  ::mlir::DenseIntElementsAttr getReplicaGroups();
  void setReplicaGroupsAttr(::mlir::DenseIntElementsAttr attr) {
    getProperties().replica_groups = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups);
  static CrossReplicaSumOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups);
  static CrossReplicaSumOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups);
  static CrossReplicaSumOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups);
  static CrossReplicaSumOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups);
  static CrossReplicaSumOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups);
  static CrossReplicaSumOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::DenseIntElementsAttr replica_groups);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CrossReplicaSumOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CrossReplicaSumOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CrossReplicaSumOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CrossReplicaSumOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CrossReplicaSumOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CrossReplicaSumOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CrossReplicaSumOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CrossReplicaSumOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::CrossReplicaSumOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::CustomCallOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CustomCallOpGenericAdaptorBase {
public:
  struct Properties {
    using api_versionTy = ::mlir::stablehlo::CustomCallApiVersionAttr;
    api_versionTy api_version;

    auto getApiVersion() const {
      auto &propStorage = this->api_version;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::CustomCallApiVersionAttr>(propStorage);
    }
    void setApiVersion(const ::mlir::stablehlo::CustomCallApiVersionAttr &propValue) {
      this->api_version = propValue;
    }
    using backend_configTy = ::mlir::Attribute;
    backend_configTy backend_config;

    auto getBackendConfig() const {
      auto &propStorage = this->backend_config;
      return ::llvm::dyn_cast_or_null<::mlir::Attribute>(propStorage);
    }
    void setBackendConfig(const ::mlir::Attribute &propValue) {
      this->backend_config = propValue;
    }
    using call_target_nameTy = ::mlir::StringAttr;
    call_target_nameTy call_target_name;

    auto getCallTargetName() const {
      auto &propStorage = this->call_target_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setCallTargetName(const ::mlir::StringAttr &propValue) {
      this->call_target_name = propValue;
    }
    using called_computationsTy = ::mlir::ArrayAttr;
    called_computationsTy called_computations;

    auto getCalledComputations() const {
      auto &propStorage = this->called_computations;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setCalledComputations(const ::mlir::ArrayAttr &propValue) {
      this->called_computations = propValue;
    }
    using has_side_effectTy = ::mlir::BoolAttr;
    has_side_effectTy has_side_effect;

    auto getHasSideEffect() const {
      auto &propStorage = this->has_side_effect;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setHasSideEffect(const ::mlir::BoolAttr &propValue) {
      this->has_side_effect = propValue;
    }
    using operand_layoutsTy = ::mlir::ArrayAttr;
    operand_layoutsTy operand_layouts;

    auto getOperandLayouts() const {
      auto &propStorage = this->operand_layouts;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setOperandLayouts(const ::mlir::ArrayAttr &propValue) {
      this->operand_layouts = propValue;
    }
    using output_operand_aliasesTy = ::mlir::ArrayAttr;
    output_operand_aliasesTy output_operand_aliases;

    auto getOutputOperandAliases() const {
      auto &propStorage = this->output_operand_aliases;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputOperandAliases(const ::mlir::ArrayAttr &propValue) {
      this->output_operand_aliases = propValue;
    }
    using result_layoutsTy = ::mlir::ArrayAttr;
    result_layoutsTy result_layouts;

    auto getResultLayouts() const {
      auto &propStorage = this->result_layouts;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setResultLayouts(const ::mlir::ArrayAttr &propValue) {
      this->result_layouts = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.api_version == this->api_version &&
        rhs.backend_config == this->backend_config &&
        rhs.call_target_name == this->call_target_name &&
        rhs.called_computations == this->called_computations &&
        rhs.has_side_effect == this->has_side_effect &&
        rhs.operand_layouts == this->operand_layouts &&
        rhs.output_operand_aliases == this->output_operand_aliases &&
        rhs.result_layouts == this->result_layouts &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CustomCallOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.custom_call", odsAttrs.getContext());
  }

  CustomCallOpGenericAdaptorBase(CustomCallOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getCallTargetNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().call_target_name);
    return attr;
  }

  ::llvm::StringRef getCallTargetName();
  ::mlir::BoolAttr getHasSideEffectAttr();
  bool getHasSideEffect();
  ::mlir::Attribute getBackendConfigAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::Attribute>(getProperties().backend_config);
    return attr;
  }

  ::std::optional<::mlir::Attribute> getBackendConfig();
  ::mlir::stablehlo::CustomCallApiVersionAttr getApiVersionAttr();
  ::mlir::stablehlo::CustomCallApiVersion getApiVersion();
  ::mlir::ArrayAttr getCalledComputationsAttr();
  ::mlir::ArrayAttr getCalledComputations();
  ::mlir::ArrayAttr getOperandLayoutsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().operand_layouts);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getOperandLayouts();
  ::mlir::ArrayAttr getResultLayoutsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().result_layouts);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getResultLayouts();
  ::mlir::ArrayAttr getOutputOperandAliasesAttr();
  ::mlir::ArrayAttr getOutputOperandAliases();
};
} // namespace detail
template <typename RangeT>
class CustomCallOpGenericAdaptor : public detail::CustomCallOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CustomCallOpGenericAdaptorBase;
  static constexpr int odsIndex_inputs = 0;
public:
  CustomCallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CustomCallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CustomCallOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CustomCallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CustomCallOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CustomCallOpGenericAdaptor(RangeT values, const CustomCallOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CustomCallOp, typename = std::enable_if_t<std::is_same_v<LateInst, CustomCallOp>>>
  CustomCallOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getInputs() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CustomCallOpAdaptor : public CustomCallOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CustomCallOpGenericAdaptor::CustomCallOpGenericAdaptor;
  CustomCallOpAdaptor(CustomCallOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CustomCallOp : public ::mlir::Op<CustomCallOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CustomCallOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CustomCallOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_inputs = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("api_version"), ::llvm::StringRef("backend_config"), ::llvm::StringRef("call_target_name"), ::llvm::StringRef("called_computations"), ::llvm::StringRef("has_side_effect"), ::llvm::StringRef("operand_layouts"), ::llvm::StringRef("output_operand_aliases"), ::llvm::StringRef("result_layouts")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getApiVersionAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getApiVersionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getBackendConfigAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getBackendConfigAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getCallTargetNameAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getCallTargetNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getCalledComputationsAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getCalledComputationsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getHasSideEffectAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getHasSideEffectAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getOperandLayoutsAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getOperandLayoutsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getOutputOperandAliasesAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getOutputOperandAliasesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getResultLayoutsAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getResultLayoutsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.custom_call");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getInputs() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getInputsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getCallTargetNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().call_target_name);
  }

  ::llvm::StringRef getCallTargetName();
  ::mlir::BoolAttr getHasSideEffectAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().has_side_effect);
  }

  bool getHasSideEffect();
  ::mlir::Attribute getBackendConfigAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::Attribute>(getProperties().backend_config);
  }

  ::std::optional<::mlir::Attribute> getBackendConfig();
  ::mlir::stablehlo::CustomCallApiVersionAttr getApiVersionAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::CustomCallApiVersionAttr>(getProperties().api_version);
  }

  ::mlir::stablehlo::CustomCallApiVersion getApiVersion();
  ::mlir::ArrayAttr getCalledComputationsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().called_computations);
  }

  ::mlir::ArrayAttr getCalledComputations();
  ::mlir::ArrayAttr getOperandLayoutsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().operand_layouts);
  }

  ::std::optional< ::mlir::ArrayAttr > getOperandLayouts();
  ::mlir::ArrayAttr getResultLayoutsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().result_layouts);
  }

  ::std::optional< ::mlir::ArrayAttr > getResultLayouts();
  ::mlir::ArrayAttr getOutputOperandAliasesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().output_operand_aliases);
  }

  ::mlir::ArrayAttr getOutputOperandAliases();
  void setCallTargetNameAttr(::mlir::StringAttr attr) {
    getProperties().call_target_name = attr;
  }

  void setCallTargetName(::llvm::StringRef attrValue);
  void setHasSideEffectAttr(::mlir::BoolAttr attr) {
    getProperties().has_side_effect = attr;
  }

  void setHasSideEffect(::std::optional<bool> attrValue);
  void setBackendConfigAttr(::mlir::Attribute attr) {
    getProperties().backend_config = attr;
  }

  void setApiVersionAttr(::mlir::stablehlo::CustomCallApiVersionAttr attr) {
    getProperties().api_version = attr;
  }

  void setApiVersion(::std::optional<::mlir::stablehlo::CustomCallApiVersion> attrValue);
  void setCalledComputationsAttr(::mlir::ArrayAttr attr) {
    getProperties().called_computations = attr;
  }

  void setOperandLayoutsAttr(::mlir::ArrayAttr attr) {
    getProperties().operand_layouts = attr;
  }

  void setResultLayoutsAttr(::mlir::ArrayAttr attr) {
    getProperties().result_layouts = attr;
  }

  void setOutputOperandAliasesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_operand_aliases = attr;
  }

  ::mlir::Attribute removeHasSideEffectAttr() {
      auto attr = getProperties().has_side_effect;
      getProperties().has_side_effect = {};
      return attr;
  }

  ::mlir::Attribute removeBackendConfigAttr() {
      auto attr = getProperties().backend_config;
      getProperties().backend_config = {};
      return attr;
  }

  ::mlir::Attribute removeApiVersionAttr() {
      auto attr = getProperties().api_version;
      getProperties().api_version = {};
      return attr;
  }

  ::mlir::Attribute removeCalledComputationsAttr() {
      auto attr = getProperties().called_computations;
      getProperties().called_computations = {};
      return attr;
  }

  ::mlir::Attribute removeOperandLayoutsAttr() {
      auto attr = getProperties().operand_layouts;
      getProperties().operand_layouts = {};
      return attr;
  }

  ::mlir::Attribute removeResultLayoutsAttr() {
      auto attr = getProperties().result_layouts;
      getProperties().result_layouts = {};
      return attr;
  }

  ::mlir::Attribute removeOutputOperandAliasesAttr() {
      auto attr = getProperties().output_operand_aliases;
      getProperties().output_operand_aliases = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::ValueRange inputs, ::mlir::StringAttr call_target_name, /*optional*/::mlir::BoolAttr has_side_effect, /*optional*/::mlir::Attribute backend_config, /*optional*/::mlir::stablehlo::CustomCallApiVersionAttr api_version, /*optional*/::mlir::ArrayAttr called_computations, /*optional*/::mlir::ArrayAttr operand_layouts, /*optional*/::mlir::ArrayAttr result_layouts, /*optional*/::mlir::ArrayAttr output_operand_aliases = nullptr);
  static CustomCallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::ValueRange inputs, ::mlir::StringAttr call_target_name, /*optional*/::mlir::BoolAttr has_side_effect, /*optional*/::mlir::Attribute backend_config, /*optional*/::mlir::stablehlo::CustomCallApiVersionAttr api_version, /*optional*/::mlir::ArrayAttr called_computations, /*optional*/::mlir::ArrayAttr operand_layouts, /*optional*/::mlir::ArrayAttr result_layouts, /*optional*/::mlir::ArrayAttr output_operand_aliases = nullptr);
  static CustomCallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::ValueRange inputs, ::mlir::StringAttr call_target_name, /*optional*/::mlir::BoolAttr has_side_effect, /*optional*/::mlir::Attribute backend_config, /*optional*/::mlir::stablehlo::CustomCallApiVersionAttr api_version, /*optional*/::mlir::ArrayAttr called_computations, /*optional*/::mlir::ArrayAttr operand_layouts, /*optional*/::mlir::ArrayAttr result_layouts, /*optional*/::mlir::ArrayAttr output_operand_aliases = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::ValueRange inputs, ::llvm::StringRef call_target_name, /*optional*/bool has_side_effect, /*optional*/::mlir::Attribute backend_config, /*optional*/::mlir::stablehlo::CustomCallApiVersion api_version, /*optional*/::mlir::ArrayAttr called_computations, /*optional*/::mlir::ArrayAttr operand_layouts, /*optional*/::mlir::ArrayAttr result_layouts, /*optional*/::mlir::ArrayAttr output_operand_aliases);
  static CustomCallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::ValueRange inputs, ::llvm::StringRef call_target_name, /*optional*/bool has_side_effect, /*optional*/::mlir::Attribute backend_config, /*optional*/::mlir::stablehlo::CustomCallApiVersion api_version, /*optional*/::mlir::ArrayAttr called_computations, /*optional*/::mlir::ArrayAttr operand_layouts, /*optional*/::mlir::ArrayAttr result_layouts, /*optional*/::mlir::ArrayAttr output_operand_aliases);
  static CustomCallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::ValueRange inputs, ::llvm::StringRef call_target_name, /*optional*/bool has_side_effect, /*optional*/::mlir::Attribute backend_config, /*optional*/::mlir::stablehlo::CustomCallApiVersion api_version, /*optional*/::mlir::ArrayAttr called_computations, /*optional*/::mlir::ArrayAttr operand_layouts, /*optional*/::mlir::ArrayAttr result_layouts, /*optional*/::mlir::ArrayAttr output_operand_aliases);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CustomCallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CustomCallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CustomCallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CustomCallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  mlir::Attribute getBackendConfigOrDefault();
  bool hasEmptyBackendConfig();
  LogicalResult verifyKnownCustomCalls();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::CustomCallOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::DivOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DivOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DivOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.divide", odsAttrs.getContext());
  }

  DivOpGenericAdaptorBase(DivOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class DivOpGenericAdaptor : public detail::DivOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DivOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  DivOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DivOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DivOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DivOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DivOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DivOpGenericAdaptor(RangeT values, const DivOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DivOp, typename = std::enable_if_t<std::is_same_v<LateInst, DivOp>>>
  DivOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DivOpAdaptor : public DivOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DivOpGenericAdaptor::DivOpGenericAdaptor;
  DivOpAdaptor(DivOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DivOp : public ::mlir::Op<DivOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::OpTrait::Elementwise, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DivOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DivOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.divide");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static DivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static DivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static DivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static DivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static DivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static DivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                               operands.front(),
                                               &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::DivOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::DotGeneralOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DotGeneralOpGenericAdaptorBase {
public:
  struct Properties {
    using algorithmTy = ::mlir::stablehlo::DotAlgorithmAttr;
    algorithmTy algorithm;

    auto getAlgorithm() const {
      auto &propStorage = this->algorithm;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::DotAlgorithmAttr>(propStorage);
    }
    void setAlgorithm(const ::mlir::stablehlo::DotAlgorithmAttr &propValue) {
      this->algorithm = propValue;
    }
    using dot_dimension_numbersTy = ::mlir::stablehlo::DotDimensionNumbersAttr;
    dot_dimension_numbersTy dot_dimension_numbers;

    auto getDotDimensionNumbers() const {
      auto &propStorage = this->dot_dimension_numbers;
      return ::llvm::cast<::mlir::stablehlo::DotDimensionNumbersAttr>(propStorage);
    }
    void setDotDimensionNumbers(const ::mlir::stablehlo::DotDimensionNumbersAttr &propValue) {
      this->dot_dimension_numbers = propValue;
    }
    using precision_configTy = ::mlir::ArrayAttr;
    precision_configTy precision_config;

    auto getPrecisionConfig() const {
      auto &propStorage = this->precision_config;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setPrecisionConfig(const ::mlir::ArrayAttr &propValue) {
      this->precision_config = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.algorithm == this->algorithm &&
        rhs.dot_dimension_numbers == this->dot_dimension_numbers &&
        rhs.precision_config == this->precision_config &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DotGeneralOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.dot_general", odsAttrs.getContext());
  }

  DotGeneralOpGenericAdaptorBase(DotGeneralOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::stablehlo::DotDimensionNumbersAttr getDotDimensionNumbersAttr() {
    auto attr = ::llvm::cast<::mlir::stablehlo::DotDimensionNumbersAttr>(getProperties().dot_dimension_numbers);
    return attr;
  }

  ::mlir::stablehlo::DotDimensionNumbersAttr getDotDimensionNumbers();
  ::mlir::ArrayAttr getPrecisionConfigAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().precision_config);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getPrecisionConfig();
  ::mlir::stablehlo::DotAlgorithmAttr getAlgorithmAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::stablehlo::DotAlgorithmAttr>(getProperties().algorithm);
    return attr;
  }

  ::std::optional<::mlir::stablehlo::DotAlgorithmAttr> getAlgorithm();
};
} // namespace detail
template <typename RangeT>
class DotGeneralOpGenericAdaptor : public detail::DotGeneralOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DotGeneralOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  DotGeneralOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DotGeneralOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DotGeneralOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DotGeneralOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DotGeneralOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DotGeneralOpGenericAdaptor(RangeT values, const DotGeneralOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DotGeneralOp, typename = std::enable_if_t<std::is_same_v<LateInst, DotGeneralOp>>>
  DotGeneralOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DotGeneralOpAdaptor : public DotGeneralOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DotGeneralOpGenericAdaptor::DotGeneralOpGenericAdaptor;
  DotGeneralOpAdaptor(DotGeneralOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DotGeneralOp : public ::mlir::Op<DotGeneralOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DotGeneralOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DotGeneralOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("algorithm"), ::llvm::StringRef("dot_dimension_numbers"), ::llvm::StringRef("precision_config")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAlgorithmAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAlgorithmAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDotDimensionNumbersAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDotDimensionNumbersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getPrecisionConfigAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getPrecisionConfigAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.dot_general");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::stablehlo::DotDimensionNumbersAttr getDotDimensionNumbersAttr() {
    return ::llvm::cast<::mlir::stablehlo::DotDimensionNumbersAttr>(getProperties().dot_dimension_numbers);
  }

  ::mlir::stablehlo::DotDimensionNumbersAttr getDotDimensionNumbers();
  ::mlir::ArrayAttr getPrecisionConfigAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().precision_config);
  }

  ::std::optional< ::mlir::ArrayAttr > getPrecisionConfig();
  ::mlir::stablehlo::DotAlgorithmAttr getAlgorithmAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::DotAlgorithmAttr>(getProperties().algorithm);
  }

  ::std::optional<::mlir::stablehlo::DotAlgorithmAttr> getAlgorithm();
  void setDotDimensionNumbersAttr(::mlir::stablehlo::DotDimensionNumbersAttr attr) {
    getProperties().dot_dimension_numbers = attr;
  }

  void setPrecisionConfigAttr(::mlir::ArrayAttr attr) {
    getProperties().precision_config = attr;
  }

  void setAlgorithmAttr(::mlir::stablehlo::DotAlgorithmAttr attr) {
    getProperties().algorithm = attr;
  }

  ::mlir::Attribute removePrecisionConfigAttr() {
      auto attr = getProperties().precision_config;
      getProperties().precision_config = {};
      return attr;
  }

  ::mlir::Attribute removeAlgorithmAttr() {
      auto attr = getProperties().algorithm;
      getProperties().algorithm = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::DotDimensionNumbersAttr dot_dimension_numbers, /*optional*/::mlir::ArrayAttr precision_config, /*optional*/::mlir::stablehlo::DotAlgorithmAttr algorithm);
  static DotGeneralOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::DotDimensionNumbersAttr dot_dimension_numbers, /*optional*/::mlir::ArrayAttr precision_config, /*optional*/::mlir::stablehlo::DotAlgorithmAttr algorithm);
  static DotGeneralOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::DotDimensionNumbersAttr dot_dimension_numbers, /*optional*/::mlir::ArrayAttr precision_config, /*optional*/::mlir::stablehlo::DotAlgorithmAttr algorithm);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::DotDimensionNumbersAttr dot_dimension_numbers, /*optional*/::mlir::ArrayAttr precision_config, /*optional*/::mlir::stablehlo::DotAlgorithmAttr algorithm);
  static DotGeneralOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::DotDimensionNumbersAttr dot_dimension_numbers, /*optional*/::mlir::ArrayAttr precision_config, /*optional*/::mlir::stablehlo::DotAlgorithmAttr algorithm);
  static DotGeneralOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::stablehlo::DotDimensionNumbersAttr dot_dimension_numbers, /*optional*/::mlir::ArrayAttr precision_config, /*optional*/::mlir::stablehlo::DotAlgorithmAttr algorithm);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DotGeneralOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DotGeneralOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DotGeneralOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DotGeneralOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::LogicalResult reifyReturnTypeShapes(::mlir::OpBuilder&builder, ::mlir::ValueRange operands, ::llvm::SmallVectorImpl<::mlir::Value> &reifiedReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  /// Interface method for ConditionallySpeculatable.
  mlir::Speculation::Speculatability getSpeculatability();

  /// Determines if this DotGeneral instance can be expressed as a DotOp.
  bool isSimpleDot();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::DotGeneralOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::DotOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DotOpGenericAdaptorBase {
public:
  struct Properties {
    using precision_configTy = ::mlir::ArrayAttr;
    precision_configTy precision_config;

    auto getPrecisionConfig() const {
      auto &propStorage = this->precision_config;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setPrecisionConfig(const ::mlir::ArrayAttr &propValue) {
      this->precision_config = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.precision_config == this->precision_config &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DotOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.dot", odsAttrs.getContext());
  }

  DotOpGenericAdaptorBase(DotOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getPrecisionConfigAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().precision_config);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getPrecisionConfig();
};
} // namespace detail
template <typename RangeT>
class DotOpGenericAdaptor : public detail::DotOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DotOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  DotOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DotOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DotOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DotOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DotOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DotOpGenericAdaptor(RangeT values, const DotOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DotOp, typename = std::enable_if_t<std::is_same_v<LateInst, DotOp>>>
  DotOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DotOpAdaptor : public DotOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DotOpGenericAdaptor::DotOpGenericAdaptor;
  DotOpAdaptor(DotOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DotOp : public ::mlir::Op<DotOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DotOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DotOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("precision_config")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getPrecisionConfigAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getPrecisionConfigAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.dot");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getPrecisionConfigAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().precision_config);
  }

  ::std::optional< ::mlir::ArrayAttr > getPrecisionConfig();
  void setPrecisionConfigAttr(::mlir::ArrayAttr attr) {
    getProperties().precision_config = attr;
  }

  ::mlir::Attribute removePrecisionConfigAttr() {
      auto attr = getProperties().precision_config;
      getProperties().precision_config = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::ArrayAttr precision_config);
  static DotOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::ArrayAttr precision_config);
  static DotOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::ArrayAttr precision_config);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::ArrayAttr precision_config);
  static DotOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::ArrayAttr precision_config);
  static DotOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::ArrayAttr precision_config);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DotOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DotOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DotOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DotOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::DotOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::DynamicBroadcastInDimOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DynamicBroadcastInDimOpGenericAdaptorBase {
public:
  struct Properties {
    using broadcast_dimensionsTy = ::mlir::DenseI64ArrayAttr;
    broadcast_dimensionsTy broadcast_dimensions;

    auto getBroadcastDimensions() const {
      auto &propStorage = this->broadcast_dimensions;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setBroadcastDimensions(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->broadcast_dimensions = propValue;
    }
    using known_expanding_dimensionsTy = ::mlir::DenseI64ArrayAttr;
    known_expanding_dimensionsTy known_expanding_dimensions;

    auto getKnownExpandingDimensions() const {
      auto &propStorage = this->known_expanding_dimensions;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setKnownExpandingDimensions(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->known_expanding_dimensions = propValue;
    }
    using known_nonexpanding_dimensionsTy = ::mlir::DenseI64ArrayAttr;
    known_nonexpanding_dimensionsTy known_nonexpanding_dimensions;

    auto getKnownNonexpandingDimensions() const {
      auto &propStorage = this->known_nonexpanding_dimensions;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setKnownNonexpandingDimensions(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->known_nonexpanding_dimensions = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.broadcast_dimensions == this->broadcast_dimensions &&
        rhs.known_expanding_dimensions == this->known_expanding_dimensions &&
        rhs.known_nonexpanding_dimensions == this->known_nonexpanding_dimensions &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DynamicBroadcastInDimOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.dynamic_broadcast_in_dim", odsAttrs.getContext());
  }

  DynamicBroadcastInDimOpGenericAdaptorBase(DynamicBroadcastInDimOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getBroadcastDimensionsAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().broadcast_dimensions);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getBroadcastDimensions();
  ::mlir::DenseI64ArrayAttr getKnownExpandingDimensionsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().known_expanding_dimensions);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getKnownExpandingDimensions();
  ::mlir::DenseI64ArrayAttr getKnownNonexpandingDimensionsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().known_nonexpanding_dimensions);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getKnownNonexpandingDimensions();
};
} // namespace detail
template <typename RangeT>
class DynamicBroadcastInDimOpGenericAdaptor : public detail::DynamicBroadcastInDimOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DynamicBroadcastInDimOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_output_dimensions = 1;
public:
  DynamicBroadcastInDimOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DynamicBroadcastInDimOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DynamicBroadcastInDimOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DynamicBroadcastInDimOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DynamicBroadcastInDimOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DynamicBroadcastInDimOpGenericAdaptor(RangeT values, const DynamicBroadcastInDimOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DynamicBroadcastInDimOp, typename = std::enable_if_t<std::is_same_v<LateInst, DynamicBroadcastInDimOp>>>
  DynamicBroadcastInDimOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  ValueT getOutputDimensions() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DynamicBroadcastInDimOpAdaptor : public DynamicBroadcastInDimOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DynamicBroadcastInDimOpGenericAdaptor::DynamicBroadcastInDimOpGenericAdaptor;
  DynamicBroadcastInDimOpAdaptor(DynamicBroadcastInDimOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DynamicBroadcastInDimOp : public ::mlir::Op<DynamicBroadcastInDimOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DynamicBroadcastInDimOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DynamicBroadcastInDimOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_output_dimensions = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("broadcast_dimensions"), ::llvm::StringRef("known_expanding_dimensions"), ::llvm::StringRef("known_nonexpanding_dimensions")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBroadcastDimensionsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBroadcastDimensionsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getKnownExpandingDimensionsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getKnownExpandingDimensionsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getKnownNonexpandingDimensionsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getKnownNonexpandingDimensionsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.dynamic_broadcast_in_dim");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOutputDimensions() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOutputDimensionsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getBroadcastDimensionsAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().broadcast_dimensions);
  }

  ::llvm::ArrayRef<int64_t> getBroadcastDimensions();
  ::mlir::DenseI64ArrayAttr getKnownExpandingDimensionsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().known_expanding_dimensions);
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getKnownExpandingDimensions();
  ::mlir::DenseI64ArrayAttr getKnownNonexpandingDimensionsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().known_nonexpanding_dimensions);
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getKnownNonexpandingDimensions();
  void setBroadcastDimensionsAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().broadcast_dimensions = attr;
  }

  void setBroadcastDimensions(::llvm::ArrayRef<int64_t> attrValue);
  void setKnownExpandingDimensionsAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().known_expanding_dimensions = attr;
  }

  void setKnownExpandingDimensions(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setKnownNonexpandingDimensionsAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().known_nonexpanding_dimensions = attr;
  }

  void setKnownNonexpandingDimensions(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  ::mlir::Attribute removeKnownExpandingDimensionsAttr() {
      auto attr = getProperties().known_expanding_dimensions;
      getProperties().known_expanding_dimensions = {};
      return attr;
  }

  ::mlir::Attribute removeKnownNonexpandingDimensionsAttr() {
      auto attr = getProperties().known_nonexpanding_dimensions;
      getProperties().known_nonexpanding_dimensions = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type result_type, Value operand, Value output_dimensions, DenseI64ArrayAttr broadcast_dimensions);
  static DynamicBroadcastInDimOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type result_type, Value operand, Value output_dimensions, DenseI64ArrayAttr broadcast_dimensions);
  static DynamicBroadcastInDimOp create(::mlir::ImplicitLocOpBuilder &builder, Type result_type, Value operand, Value output_dimensions, DenseI64ArrayAttr broadcast_dimensions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::Value output_dimensions, ::mlir::DenseI64ArrayAttr broadcast_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_expanding_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_nonexpanding_dimensions);
  static DynamicBroadcastInDimOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::Value output_dimensions, ::mlir::DenseI64ArrayAttr broadcast_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_expanding_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_nonexpanding_dimensions);
  static DynamicBroadcastInDimOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::Value output_dimensions, ::mlir::DenseI64ArrayAttr broadcast_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_expanding_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_nonexpanding_dimensions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value output_dimensions, ::mlir::DenseI64ArrayAttr broadcast_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_expanding_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_nonexpanding_dimensions);
  static DynamicBroadcastInDimOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value output_dimensions, ::mlir::DenseI64ArrayAttr broadcast_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_expanding_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_nonexpanding_dimensions);
  static DynamicBroadcastInDimOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value output_dimensions, ::mlir::DenseI64ArrayAttr broadcast_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_expanding_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_nonexpanding_dimensions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::Value output_dimensions, ::llvm::ArrayRef<int64_t> broadcast_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_expanding_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_nonexpanding_dimensions);
  static DynamicBroadcastInDimOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::Value output_dimensions, ::llvm::ArrayRef<int64_t> broadcast_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_expanding_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_nonexpanding_dimensions);
  static DynamicBroadcastInDimOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::Value output_dimensions, ::llvm::ArrayRef<int64_t> broadcast_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_expanding_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_nonexpanding_dimensions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value output_dimensions, ::llvm::ArrayRef<int64_t> broadcast_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_expanding_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_nonexpanding_dimensions);
  static DynamicBroadcastInDimOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value output_dimensions, ::llvm::ArrayRef<int64_t> broadcast_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_expanding_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_nonexpanding_dimensions);
  static DynamicBroadcastInDimOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value output_dimensions, ::llvm::ArrayRef<int64_t> broadcast_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_expanding_dimensions, /*optional*/::mlir::DenseI64ArrayAttr known_nonexpanding_dimensions);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicBroadcastInDimOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicBroadcastInDimOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicBroadcastInDimOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicBroadcastInDimOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::LogicalResult reifyReturnTypeShapes(::mlir::OpBuilder&builder, ::mlir::ValueRange operands, ::llvm::SmallVectorImpl<::mlir::Value> &reifiedReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  /// Interface method for ConditionallySpeculatable.
  mlir::Speculation::Speculatability getSpeculatability();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::DynamicBroadcastInDimOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::DynamicConvOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DynamicConvOpGenericAdaptorBase {
public:
  struct Properties {
    using batch_group_countTy = ::mlir::IntegerAttr;
    batch_group_countTy batch_group_count;

    auto getBatchGroupCount() const {
      auto &propStorage = this->batch_group_count;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBatchGroupCount(const ::mlir::IntegerAttr &propValue) {
      this->batch_group_count = propValue;
    }
    using dimension_numbersTy = ::mlir::stablehlo::ConvDimensionNumbersAttr;
    dimension_numbersTy dimension_numbers;

    auto getDimensionNumbers() const {
      auto &propStorage = this->dimension_numbers;
      return ::llvm::cast<::mlir::stablehlo::ConvDimensionNumbersAttr>(propStorage);
    }
    void setDimensionNumbers(const ::mlir::stablehlo::ConvDimensionNumbersAttr &propValue) {
      this->dimension_numbers = propValue;
    }
    using feature_group_countTy = ::mlir::IntegerAttr;
    feature_group_countTy feature_group_count;

    auto getFeatureGroupCount() const {
      auto &propStorage = this->feature_group_count;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setFeatureGroupCount(const ::mlir::IntegerAttr &propValue) {
      this->feature_group_count = propValue;
    }
    using lhs_dilationTy = ::mlir::DenseI64ArrayAttr;
    lhs_dilationTy lhs_dilation;

    auto getLhsDilation() const {
      auto &propStorage = this->lhs_dilation;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setLhsDilation(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->lhs_dilation = propValue;
    }
    using precision_configTy = ::mlir::ArrayAttr;
    precision_configTy precision_config;

    auto getPrecisionConfig() const {
      auto &propStorage = this->precision_config;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setPrecisionConfig(const ::mlir::ArrayAttr &propValue) {
      this->precision_config = propValue;
    }
    using rhs_dilationTy = ::mlir::DenseI64ArrayAttr;
    rhs_dilationTy rhs_dilation;

    auto getRhsDilation() const {
      auto &propStorage = this->rhs_dilation;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setRhsDilation(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->rhs_dilation = propValue;
    }
    using window_reversalTy = ::mlir::DenseBoolArrayAttr;
    window_reversalTy window_reversal;

    auto getWindowReversal() const {
      auto &propStorage = this->window_reversal;
      return ::llvm::dyn_cast_or_null<::mlir::DenseBoolArrayAttr>(propStorage);
    }
    void setWindowReversal(const ::mlir::DenseBoolArrayAttr &propValue) {
      this->window_reversal = propValue;
    }
    using window_stridesTy = ::mlir::DenseI64ArrayAttr;
    window_stridesTy window_strides;

    auto getWindowStrides() const {
      auto &propStorage = this->window_strides;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setWindowStrides(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->window_strides = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.batch_group_count == this->batch_group_count &&
        rhs.dimension_numbers == this->dimension_numbers &&
        rhs.feature_group_count == this->feature_group_count &&
        rhs.lhs_dilation == this->lhs_dilation &&
        rhs.precision_config == this->precision_config &&
        rhs.rhs_dilation == this->rhs_dilation &&
        rhs.window_reversal == this->window_reversal &&
        rhs.window_strides == this->window_strides &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DynamicConvOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.dynamic_conv", odsAttrs.getContext());
  }

  DynamicConvOpGenericAdaptorBase(DynamicConvOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getWindowStridesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().window_strides);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getWindowStrides();
  ::mlir::DenseI64ArrayAttr getLhsDilationAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().lhs_dilation);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getLhsDilation();
  ::mlir::DenseI64ArrayAttr getRhsDilationAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().rhs_dilation);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getRhsDilation();
  ::mlir::DenseBoolArrayAttr getWindowReversalAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseBoolArrayAttr>(getProperties().window_reversal);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<bool>> getWindowReversal();
  ::mlir::stablehlo::ConvDimensionNumbersAttr getDimensionNumbersAttr() {
    auto attr = ::llvm::cast<::mlir::stablehlo::ConvDimensionNumbersAttr>(getProperties().dimension_numbers);
    return attr;
  }

  ::mlir::stablehlo::ConvDimensionNumbersAttr getDimensionNumbers();
  ::mlir::IntegerAttr getFeatureGroupCountAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().feature_group_count);
    return attr;
  }

  uint64_t getFeatureGroupCount();
  ::mlir::IntegerAttr getBatchGroupCountAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().batch_group_count);
    return attr;
  }

  uint64_t getBatchGroupCount();
  ::mlir::ArrayAttr getPrecisionConfigAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().precision_config);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getPrecisionConfig();
};
} // namespace detail
template <typename RangeT>
class DynamicConvOpGenericAdaptor : public detail::DynamicConvOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DynamicConvOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  static constexpr int odsIndex_padding = 2;
public:
  DynamicConvOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DynamicConvOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DynamicConvOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DynamicConvOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DynamicConvOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DynamicConvOpGenericAdaptor(RangeT values, const DynamicConvOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DynamicConvOp, typename = std::enable_if_t<std::is_same_v<LateInst, DynamicConvOp>>>
  DynamicConvOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  ValueT getPadding() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DynamicConvOpAdaptor : public DynamicConvOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DynamicConvOpGenericAdaptor::DynamicConvOpGenericAdaptor;
  DynamicConvOpAdaptor(DynamicConvOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DynamicConvOp : public ::mlir::Op<DynamicConvOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticAndShapeConstantImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DynamicConvOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DynamicConvOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  static constexpr int odsIndex_padding = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("batch_group_count"), ::llvm::StringRef("dimension_numbers"), ::llvm::StringRef("feature_group_count"), ::llvm::StringRef("lhs_dilation"), ::llvm::StringRef("precision_config"), ::llvm::StringRef("rhs_dilation"), ::llvm::StringRef("window_reversal"), ::llvm::StringRef("window_strides")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBatchGroupCountAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBatchGroupCountAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDimensionNumbersAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDimensionNumbersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getFeatureGroupCountAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getFeatureGroupCountAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getLhsDilationAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getLhsDilationAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getPrecisionConfigAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getPrecisionConfigAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getRhsDilationAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getRhsDilationAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getWindowReversalAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getWindowReversalAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getWindowStridesAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getWindowStridesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.dynamic_conv");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getPadding() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getPaddingMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getWindowStridesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().window_strides);
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getWindowStrides();
  ::mlir::DenseI64ArrayAttr getLhsDilationAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().lhs_dilation);
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getLhsDilation();
  ::mlir::DenseI64ArrayAttr getRhsDilationAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().rhs_dilation);
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getRhsDilation();
  ::mlir::DenseBoolArrayAttr getWindowReversalAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseBoolArrayAttr>(getProperties().window_reversal);
  }

  ::std::optional<::llvm::ArrayRef<bool>> getWindowReversal();
  ::mlir::stablehlo::ConvDimensionNumbersAttr getDimensionNumbersAttr() {
    return ::llvm::cast<::mlir::stablehlo::ConvDimensionNumbersAttr>(getProperties().dimension_numbers);
  }

  ::mlir::stablehlo::ConvDimensionNumbersAttr getDimensionNumbers();
  ::mlir::IntegerAttr getFeatureGroupCountAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().feature_group_count);
  }

  uint64_t getFeatureGroupCount();
  ::mlir::IntegerAttr getBatchGroupCountAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().batch_group_count);
  }

  uint64_t getBatchGroupCount();
  ::mlir::ArrayAttr getPrecisionConfigAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().precision_config);
  }

  ::std::optional< ::mlir::ArrayAttr > getPrecisionConfig();
  void setWindowStridesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().window_strides = attr;
  }

  void setWindowStrides(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setLhsDilationAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().lhs_dilation = attr;
  }

  void setLhsDilation(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setRhsDilationAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().rhs_dilation = attr;
  }

  void setRhsDilation(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setWindowReversalAttr(::mlir::DenseBoolArrayAttr attr) {
    getProperties().window_reversal = attr;
  }

  void setWindowReversal(::std::optional<::llvm::ArrayRef<bool>> attrValue);
  void setDimensionNumbersAttr(::mlir::stablehlo::ConvDimensionNumbersAttr attr) {
    getProperties().dimension_numbers = attr;
  }

  void setFeatureGroupCountAttr(::mlir::IntegerAttr attr) {
    getProperties().feature_group_count = attr;
  }

  void setFeatureGroupCount(uint64_t attrValue);
  void setBatchGroupCountAttr(::mlir::IntegerAttr attr) {
    getProperties().batch_group_count = attr;
  }

  void setBatchGroupCount(uint64_t attrValue);
  void setPrecisionConfigAttr(::mlir::ArrayAttr attr) {
    getProperties().precision_config = attr;
  }

  ::mlir::Attribute removeWindowStridesAttr() {
      auto attr = getProperties().window_strides;
      getProperties().window_strides = {};
      return attr;
  }

  ::mlir::Attribute removeLhsDilationAttr() {
      auto attr = getProperties().lhs_dilation;
      getProperties().lhs_dilation = {};
      return attr;
  }

  ::mlir::Attribute removeRhsDilationAttr() {
      auto attr = getProperties().rhs_dilation;
      getProperties().rhs_dilation = {};
      return attr;
  }

  ::mlir::Attribute removeWindowReversalAttr() {
      auto attr = getProperties().window_reversal;
      getProperties().window_reversal = {};
      return attr;
  }

  ::mlir::Attribute removePrecisionConfigAttr() {
      auto attr = getProperties().precision_config;
      getProperties().precision_config = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::Value padding, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, ::mlir::IntegerAttr feature_group_count, ::mlir::IntegerAttr batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static DynamicConvOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::Value padding, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, ::mlir::IntegerAttr feature_group_count, ::mlir::IntegerAttr batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static DynamicConvOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::Value padding, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, ::mlir::IntegerAttr feature_group_count, ::mlir::IntegerAttr batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::Value padding, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, ::mlir::IntegerAttr feature_group_count, ::mlir::IntegerAttr batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static DynamicConvOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::Value padding, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, ::mlir::IntegerAttr feature_group_count, ::mlir::IntegerAttr batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static DynamicConvOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::Value padding, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, ::mlir::IntegerAttr feature_group_count, ::mlir::IntegerAttr batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::Value padding, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, uint64_t feature_group_count, uint64_t batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static DynamicConvOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::Value padding, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, uint64_t feature_group_count, uint64_t batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static DynamicConvOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::Value padding, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, uint64_t feature_group_count, uint64_t batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::Value padding, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, uint64_t feature_group_count, uint64_t batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static DynamicConvOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::Value padding, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, uint64_t feature_group_count, uint64_t batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static DynamicConvOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::Value padding, /*optional*/::mlir::DenseI64ArrayAttr window_strides, /*optional*/::mlir::DenseI64ArrayAttr lhs_dilation, /*optional*/::mlir::DenseI64ArrayAttr rhs_dilation, /*optional*/::mlir::DenseBoolArrayAttr window_reversal, ::mlir::stablehlo::ConvDimensionNumbersAttr dimension_numbers, uint64_t feature_group_count, uint64_t batch_group_count, /*optional*/::mlir::ArrayAttr precision_config);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicConvOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicConvOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicConvOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicConvOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  bool hasWindowReversal() {
    auto reversal = getWindowReversal();
    return reversal.has_value() && llvm::any_of(reversal.value(), [](bool v) { return v; });
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::DynamicConvOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::DynamicGatherOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DynamicGatherOpGenericAdaptorBase {
public:
  struct Properties {
    using dimension_numbersTy = ::mlir::stablehlo::GatherDimensionNumbersAttr;
    dimension_numbersTy dimension_numbers;

    auto getDimensionNumbers() const {
      auto &propStorage = this->dimension_numbers;
      return ::llvm::cast<::mlir::stablehlo::GatherDimensionNumbersAttr>(propStorage);
    }
    void setDimensionNumbers(const ::mlir::stablehlo::GatherDimensionNumbersAttr &propValue) {
      this->dimension_numbers = propValue;
    }
    using indices_are_sortedTy = ::mlir::BoolAttr;
    indices_are_sortedTy indices_are_sorted;

    auto getIndicesAreSorted() const {
      auto &propStorage = this->indices_are_sorted;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setIndicesAreSorted(const ::mlir::BoolAttr &propValue) {
      this->indices_are_sorted = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dimension_numbers == this->dimension_numbers &&
        rhs.indices_are_sorted == this->indices_are_sorted &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DynamicGatherOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.dynamic_gather", odsAttrs.getContext());
  }

  DynamicGatherOpGenericAdaptorBase(DynamicGatherOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::stablehlo::GatherDimensionNumbersAttr getDimensionNumbersAttr() {
    auto attr = ::llvm::cast<::mlir::stablehlo::GatherDimensionNumbersAttr>(getProperties().dimension_numbers);
    return attr;
  }

  ::mlir::stablehlo::GatherDimensionNumbersAttr getDimensionNumbers();
  ::mlir::BoolAttr getIndicesAreSortedAttr();
  bool getIndicesAreSorted();
};
} // namespace detail
template <typename RangeT>
class DynamicGatherOpGenericAdaptor : public detail::DynamicGatherOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DynamicGatherOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_start_indices = 1;
  static constexpr int odsIndex_slice_sizes = 2;
public:
  DynamicGatherOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DynamicGatherOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DynamicGatherOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DynamicGatherOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DynamicGatherOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DynamicGatherOpGenericAdaptor(RangeT values, const DynamicGatherOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DynamicGatherOp, typename = std::enable_if_t<std::is_same_v<LateInst, DynamicGatherOp>>>
  DynamicGatherOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  ValueT getStartIndices() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSliceSizes() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DynamicGatherOpAdaptor : public DynamicGatherOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DynamicGatherOpGenericAdaptor::DynamicGatherOpGenericAdaptor;
  DynamicGatherOpAdaptor(DynamicGatherOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DynamicGatherOp : public ::mlir::Op<DynamicGatherOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticAndShapeConstantImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DynamicGatherOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DynamicGatherOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_start_indices = 1;
  static constexpr int odsIndex_slice_sizes = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dimension_numbers"), ::llvm::StringRef("indices_are_sorted")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDimensionNumbersAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDimensionNumbersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getIndicesAreSortedAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getIndicesAreSortedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.dynamic_gather");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getStartIndices() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getSliceSizes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getStartIndicesMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSliceSizesMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::stablehlo::GatherDimensionNumbersAttr getDimensionNumbersAttr() {
    return ::llvm::cast<::mlir::stablehlo::GatherDimensionNumbersAttr>(getProperties().dimension_numbers);
  }

  ::mlir::stablehlo::GatherDimensionNumbersAttr getDimensionNumbers();
  ::mlir::BoolAttr getIndicesAreSortedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().indices_are_sorted);
  }

  bool getIndicesAreSorted();
  void setDimensionNumbersAttr(::mlir::stablehlo::GatherDimensionNumbersAttr attr) {
    getProperties().dimension_numbers = attr;
  }

  void setIndicesAreSortedAttr(::mlir::BoolAttr attr) {
    getProperties().indices_are_sorted = attr;
  }

  void setIndicesAreSorted(::std::optional<bool> attrValue);
  ::mlir::Attribute removeIndicesAreSortedAttr() {
      auto attr = getProperties().indices_are_sorted;
      getProperties().indices_are_sorted = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/::mlir::BoolAttr indices_are_sorted);
  static DynamicGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/::mlir::BoolAttr indices_are_sorted);
  static DynamicGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/::mlir::BoolAttr indices_are_sorted);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/::mlir::BoolAttr indices_are_sorted);
  static DynamicGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/::mlir::BoolAttr indices_are_sorted);
  static DynamicGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/::mlir::BoolAttr indices_are_sorted);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/::mlir::BoolAttr indices_are_sorted);
  static DynamicGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/::mlir::BoolAttr indices_are_sorted);
  static DynamicGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/::mlir::BoolAttr indices_are_sorted);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/bool indices_are_sorted = false);
  static DynamicGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/bool indices_are_sorted = false);
  static DynamicGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/bool indices_are_sorted = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/bool indices_are_sorted = false);
  static DynamicGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/bool indices_are_sorted = false);
  static DynamicGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/bool indices_are_sorted = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/bool indices_are_sorted = false);
  static DynamicGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/bool indices_are_sorted = false);
  static DynamicGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::Value slice_sizes, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, /*optional*/bool indices_are_sorted = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicGatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicGatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  ::llvm::LogicalResult reifyReturnTypeShapes(::mlir::OpBuilder&builder, ::mlir::ValueRange operands, ::llvm::SmallVectorImpl<::mlir::Value> &reifiedReturnShapes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::DynamicGatherOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::DynamicIotaOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DynamicIotaOpGenericAdaptorBase {
public:
  struct Properties {
    using iota_dimensionTy = ::mlir::IntegerAttr;
    iota_dimensionTy iota_dimension;

    auto getIotaDimension() const {
      auto &propStorage = this->iota_dimension;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setIotaDimension(const ::mlir::IntegerAttr &propValue) {
      this->iota_dimension = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.iota_dimension == this->iota_dimension &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DynamicIotaOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.dynamic_iota", odsAttrs.getContext());
  }

  DynamicIotaOpGenericAdaptorBase(DynamicIotaOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIotaDimensionAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().iota_dimension);
    return attr;
  }

  uint64_t getIotaDimension();
};
} // namespace detail
template <typename RangeT>
class DynamicIotaOpGenericAdaptor : public detail::DynamicIotaOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DynamicIotaOpGenericAdaptorBase;
  static constexpr int odsIndex_output_shape = 0;
public:
  DynamicIotaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DynamicIotaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DynamicIotaOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DynamicIotaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DynamicIotaOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DynamicIotaOpGenericAdaptor(RangeT values, const DynamicIotaOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DynamicIotaOp, typename = std::enable_if_t<std::is_same_v<LateInst, DynamicIotaOp>>>
  DynamicIotaOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOutputShape() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DynamicIotaOpAdaptor : public DynamicIotaOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DynamicIotaOpGenericAdaptor::DynamicIotaOpGenericAdaptor;
  DynamicIotaOpAdaptor(DynamicIotaOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DynamicIotaOp : public ::mlir::Op<DynamicIotaOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DynamicIotaOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DynamicIotaOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_output_shape = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("iota_dimension")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIotaDimensionAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIotaDimensionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.dynamic_iota");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOutputShape() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOutputShapeMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIotaDimensionAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().iota_dimension);
  }

  uint64_t getIotaDimension();
  void setIotaDimensionAttr(::mlir::IntegerAttr attr) {
    getProperties().iota_dimension = attr;
  }

  void setIotaDimension(uint64_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value output_shape, ::mlir::IntegerAttr iota_dimension);
  static DynamicIotaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value output_shape, ::mlir::IntegerAttr iota_dimension);
  static DynamicIotaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value output_shape, ::mlir::IntegerAttr iota_dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value output_shape, ::mlir::IntegerAttr iota_dimension);
  static DynamicIotaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value output_shape, ::mlir::IntegerAttr iota_dimension);
  static DynamicIotaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value output_shape, ::mlir::IntegerAttr iota_dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value output_shape, uint64_t iota_dimension);
  static DynamicIotaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value output_shape, uint64_t iota_dimension);
  static DynamicIotaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value output_shape, uint64_t iota_dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value output_shape, uint64_t iota_dimension);
  static DynamicIotaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value output_shape, uint64_t iota_dimension);
  static DynamicIotaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value output_shape, uint64_t iota_dimension);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicIotaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicIotaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicIotaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicIotaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::LogicalResult reifyReturnTypeShapes(::mlir::OpBuilder&builder, ::mlir::ValueRange operands, ::llvm::SmallVectorImpl<::mlir::Value> &reifiedReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  /// Interface method for ConditionallySpeculatable.
  mlir::Speculation::Speculatability getSpeculatability();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::DynamicIotaOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::DynamicPadOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DynamicPadOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DynamicPadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.dynamic_pad", odsAttrs.getContext());
  }

  DynamicPadOpGenericAdaptorBase(DynamicPadOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class DynamicPadOpGenericAdaptor : public detail::DynamicPadOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DynamicPadOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_padding_value = 1;
  static constexpr int odsIndex_edge_padding_low = 2;
  static constexpr int odsIndex_edge_padding_high = 3;
  static constexpr int odsIndex_interior_padding = 4;
public:
  DynamicPadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DynamicPadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DynamicPadOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DynamicPadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DynamicPadOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DynamicPadOpGenericAdaptor(RangeT values, const DynamicPadOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DynamicPadOp, typename = std::enable_if_t<std::is_same_v<LateInst, DynamicPadOp>>>
  DynamicPadOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  ValueT getPaddingValue() {
    return (*getODSOperands(1).begin());
  }

  ValueT getEdgePaddingLow() {
    return (*getODSOperands(2).begin());
  }

  ValueT getEdgePaddingHigh() {
    return (*getODSOperands(3).begin());
  }

  ValueT getInteriorPadding() {
    return (*getODSOperands(4).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DynamicPadOpAdaptor : public DynamicPadOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DynamicPadOpGenericAdaptor::DynamicPadOpGenericAdaptor;
  DynamicPadOpAdaptor(DynamicPadOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DynamicPadOp : public ::mlir::Op<DynamicPadOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<5>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DynamicPadOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DynamicPadOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_padding_value = 1;
  static constexpr int odsIndex_edge_padding_low = 2;
  static constexpr int odsIndex_edge_padding_high = 3;
  static constexpr int odsIndex_interior_padding = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.dynamic_pad");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getPaddingValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getEdgePaddingLow() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getEdgePaddingHigh() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getInteriorPadding() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(4).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getPaddingValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getEdgePaddingLowMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getEdgePaddingHighMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getInteriorPaddingMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value padding_value, ::mlir::Value edge_padding_low, ::mlir::Value edge_padding_high, ::mlir::Value interior_padding);
  static DynamicPadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value padding_value, ::mlir::Value edge_padding_low, ::mlir::Value edge_padding_high, ::mlir::Value interior_padding);
  static DynamicPadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value padding_value, ::mlir::Value edge_padding_low, ::mlir::Value edge_padding_high, ::mlir::Value interior_padding);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value padding_value, ::mlir::Value edge_padding_low, ::mlir::Value edge_padding_high, ::mlir::Value interior_padding);
  static DynamicPadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value padding_value, ::mlir::Value edge_padding_low, ::mlir::Value edge_padding_high, ::mlir::Value interior_padding);
  static DynamicPadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value padding_value, ::mlir::Value edge_padding_low, ::mlir::Value edge_padding_high, ::mlir::Value interior_padding);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicPadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicPadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicPadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicPadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::LogicalResult reifyReturnTypeShapes(::mlir::OpBuilder&builder, ::mlir::ValueRange operands, ::llvm::SmallVectorImpl<::mlir::Value> &reifiedReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  /// Interface method for ConditionallySpeculatable.
  mlir::Speculation::Speculatability getSpeculatability();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::DynamicPadOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::DynamicReshapeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DynamicReshapeOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DynamicReshapeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.dynamic_reshape", odsAttrs.getContext());
  }

  DynamicReshapeOpGenericAdaptorBase(DynamicReshapeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class DynamicReshapeOpGenericAdaptor : public detail::DynamicReshapeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DynamicReshapeOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_output_shape = 1;
public:
  DynamicReshapeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DynamicReshapeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DynamicReshapeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DynamicReshapeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DynamicReshapeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DynamicReshapeOpGenericAdaptor(RangeT values, const DynamicReshapeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DynamicReshapeOp, typename = std::enable_if_t<std::is_same_v<LateInst, DynamicReshapeOp>>>
  DynamicReshapeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  ValueT getOutputShape() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DynamicReshapeOpAdaptor : public DynamicReshapeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DynamicReshapeOpGenericAdaptor::DynamicReshapeOpGenericAdaptor;
  DynamicReshapeOpAdaptor(DynamicReshapeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DynamicReshapeOp : public ::mlir::Op<DynamicReshapeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticAndShapeConstantImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DynamicReshapeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DynamicReshapeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_output_shape = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.dynamic_reshape");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOutputShape() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOutputShapeMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value output_shape);
  static DynamicReshapeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value output_shape);
  static DynamicReshapeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value output_shape);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value output_shape);
  static DynamicReshapeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value output_shape);
  static DynamicReshapeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value output_shape);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicReshapeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicReshapeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicReshapeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicReshapeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::LogicalResult reifyReturnTypeShapes(::mlir::OpBuilder&builder, ::mlir::ValueRange operands, ::llvm::SmallVectorImpl<::mlir::Value> &reifiedReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::DynamicReshapeOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::DynamicSliceOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DynamicSliceOpGenericAdaptorBase {
public:
  struct Properties {
    using slice_sizesTy = ::mlir::DenseI64ArrayAttr;
    slice_sizesTy slice_sizes;

    auto getSliceSizes() const {
      auto &propStorage = this->slice_sizes;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setSliceSizes(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->slice_sizes = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.slice_sizes == this->slice_sizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DynamicSliceOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.dynamic_slice", odsAttrs.getContext());
  }

  DynamicSliceOpGenericAdaptorBase(DynamicSliceOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getSliceSizesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().slice_sizes);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getSliceSizes();
};
} // namespace detail
template <typename RangeT>
class DynamicSliceOpGenericAdaptor : public detail::DynamicSliceOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DynamicSliceOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_start_indices = 1;
public:
  DynamicSliceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DynamicSliceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DynamicSliceOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DynamicSliceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DynamicSliceOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DynamicSliceOpGenericAdaptor(RangeT values, const DynamicSliceOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DynamicSliceOp, typename = std::enable_if_t<std::is_same_v<LateInst, DynamicSliceOp>>>
  DynamicSliceOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getStartIndices() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DynamicSliceOpAdaptor : public DynamicSliceOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DynamicSliceOpGenericAdaptor::DynamicSliceOpGenericAdaptor;
  DynamicSliceOpAdaptor(DynamicSliceOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DynamicSliceOp : public ::mlir::Op<DynamicSliceOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DynamicSliceOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DynamicSliceOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_start_indices = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("slice_sizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSliceSizesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSliceSizesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.dynamic_slice");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getStartIndices() {
    return getODSOperands(1);
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getStartIndicesMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getSliceSizesAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().slice_sizes);
  }

  ::llvm::ArrayRef<int64_t> getSliceSizes();
  void setSliceSizesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().slice_sizes = attr;
  }

  void setSliceSizes(::llvm::ArrayRef<int64_t> attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::mlir::DenseI64ArrayAttr slice_sizes);
  static DynamicSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::mlir::DenseI64ArrayAttr slice_sizes);
  static DynamicSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::mlir::DenseI64ArrayAttr slice_sizes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::mlir::DenseI64ArrayAttr slice_sizes);
  static DynamicSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::mlir::DenseI64ArrayAttr slice_sizes);
  static DynamicSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::mlir::DenseI64ArrayAttr slice_sizes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::mlir::DenseI64ArrayAttr slice_sizes);
  static DynamicSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::mlir::DenseI64ArrayAttr slice_sizes);
  static DynamicSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::mlir::DenseI64ArrayAttr slice_sizes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::llvm::ArrayRef<int64_t> slice_sizes);
  static DynamicSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::llvm::ArrayRef<int64_t> slice_sizes);
  static DynamicSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::llvm::ArrayRef<int64_t> slice_sizes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::llvm::ArrayRef<int64_t> slice_sizes);
  static DynamicSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::llvm::ArrayRef<int64_t> slice_sizes);
  static DynamicSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::llvm::ArrayRef<int64_t> slice_sizes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::llvm::ArrayRef<int64_t> slice_sizes);
  static DynamicSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::llvm::ArrayRef<int64_t> slice_sizes);
  static DynamicSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::ValueRange start_indices, ::llvm::ArrayRef<int64_t> slice_sizes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::DynamicSliceOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::DynamicUpdateSliceOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DynamicUpdateSliceOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DynamicUpdateSliceOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.dynamic_update_slice", odsAttrs.getContext());
  }

  DynamicUpdateSliceOpGenericAdaptorBase(DynamicUpdateSliceOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class DynamicUpdateSliceOpGenericAdaptor : public detail::DynamicUpdateSliceOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DynamicUpdateSliceOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_update = 1;
  static constexpr int odsIndex_start_indices = 2;
public:
  DynamicUpdateSliceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DynamicUpdateSliceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DynamicUpdateSliceOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DynamicUpdateSliceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DynamicUpdateSliceOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DynamicUpdateSliceOpGenericAdaptor(RangeT values, const DynamicUpdateSliceOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DynamicUpdateSliceOp, typename = std::enable_if_t<std::is_same_v<LateInst, DynamicUpdateSliceOp>>>
  DynamicUpdateSliceOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  ValueT getUpdate() {
    return (*getODSOperands(1).begin());
  }

  RangeT getStartIndices() {
    return getODSOperands(2);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DynamicUpdateSliceOpAdaptor : public DynamicUpdateSliceOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DynamicUpdateSliceOpGenericAdaptor::DynamicUpdateSliceOpGenericAdaptor;
  DynamicUpdateSliceOpAdaptor(DynamicUpdateSliceOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DynamicUpdateSliceOp : public ::mlir::Op<DynamicUpdateSliceOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DynamicUpdateSliceOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DynamicUpdateSliceOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_update = 1;
  static constexpr int odsIndex_start_indices = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.dynamic_update_slice");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getUpdate() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getStartIndices() {
    return getODSOperands(2);
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getUpdateMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getStartIndicesMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value update, ::mlir::ValueRange start_indices);
  static DynamicUpdateSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value update, ::mlir::ValueRange start_indices);
  static DynamicUpdateSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value update, ::mlir::ValueRange start_indices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::Value update, ::mlir::ValueRange start_indices);
  static DynamicUpdateSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::Value update, ::mlir::ValueRange start_indices);
  static DynamicUpdateSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::Value update, ::mlir::ValueRange start_indices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value update, ::mlir::ValueRange start_indices);
  static DynamicUpdateSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value update, ::mlir::ValueRange start_indices);
  static DynamicUpdateSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value update, ::mlir::ValueRange start_indices);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicUpdateSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicUpdateSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicUpdateSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DynamicUpdateSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicUpdateSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicUpdateSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicUpdateSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DynamicUpdateSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::DynamicUpdateSliceOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::EinsumOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class EinsumOpGenericAdaptorBase {
public:
  struct Properties {
    using einsum_configTy = ::mlir::StringAttr;
    einsum_configTy einsum_config;

    auto getEinsumConfig() const {
      auto &propStorage = this->einsum_config;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setEinsumConfig(const ::mlir::StringAttr &propValue) {
      this->einsum_config = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.einsum_config == this->einsum_config &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EinsumOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.einsum", odsAttrs.getContext());
  }

  EinsumOpGenericAdaptorBase(EinsumOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getEinsumConfigAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().einsum_config);
    return attr;
  }

  ::llvm::StringRef getEinsumConfig();
};
} // namespace detail
template <typename RangeT>
class EinsumOpGenericAdaptor : public detail::EinsumOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EinsumOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  EinsumOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EinsumOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EinsumOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EinsumOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : EinsumOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EinsumOpGenericAdaptor(RangeT values, const EinsumOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EinsumOp, typename = std::enable_if_t<std::is_same_v<LateInst, EinsumOp>>>
  EinsumOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EinsumOpAdaptor : public EinsumOpGenericAdaptor<::mlir::ValueRange> {
public:
  using EinsumOpGenericAdaptor::EinsumOpGenericAdaptor;
  EinsumOpAdaptor(EinsumOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EinsumOp : public ::mlir::Op<EinsumOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EinsumOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EinsumOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("einsum_config")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getEinsumConfigAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getEinsumConfigAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.einsum");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getEinsumConfigAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().einsum_config);
  }

  ::llvm::StringRef getEinsumConfig();
  void setEinsumConfigAttr(::mlir::StringAttr attr) {
    getProperties().einsum_config = attr;
  }

  void setEinsumConfig(::llvm::StringRef attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::StringAttr einsum_config);
  static EinsumOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::StringAttr einsum_config);
  static EinsumOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::StringAttr einsum_config);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::StringAttr einsum_config);
  static EinsumOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::StringAttr einsum_config);
  static EinsumOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::StringAttr einsum_config);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::llvm::StringRef einsum_config);
  static EinsumOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::llvm::StringRef einsum_config);
  static EinsumOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::llvm::StringRef einsum_config);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::llvm::StringRef einsum_config);
  static EinsumOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::llvm::StringRef einsum_config);
  static EinsumOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::llvm::StringRef einsum_config);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EinsumOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EinsumOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EinsumOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EinsumOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::EinsumOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::ExpOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExpOpGenericAdaptorBase {
public:
  struct Properties {
    using result_accuracyTy = ::mlir::stablehlo::ResultAccuracyAttr;
    result_accuracyTy result_accuracy;

    auto getResultAccuracy() const {
      auto &propStorage = this->result_accuracy;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(propStorage);
    }
    void setResultAccuracy(const ::mlir::stablehlo::ResultAccuracyAttr &propValue) {
      this->result_accuracy = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.result_accuracy == this->result_accuracy &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExpOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.exponential", odsAttrs.getContext());
  }

  ExpOpGenericAdaptorBase(ExpOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr();
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
};
} // namespace detail
template <typename RangeT>
class ExpOpGenericAdaptor : public detail::ExpOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExpOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  ExpOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExpOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExpOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExpOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExpOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExpOpGenericAdaptor(RangeT values, const ExpOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExpOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExpOp>>>
  ExpOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExpOpAdaptor : public ExpOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExpOpGenericAdaptor::ExpOpGenericAdaptor;
  ExpOpAdaptor(ExpOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExpOp : public ::mlir::Op<ExpOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::Elementwise, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExpOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExpOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("result_accuracy")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getResultAccuracyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getResultAccuracyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.exponential");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(getProperties().result_accuracy);
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
  void setResultAccuracyAttr(::mlir::stablehlo::ResultAccuracyAttr attr) {
    getProperties().result_accuracy = attr;
  }

  ::mlir::Attribute removeResultAccuracyAttr() {
      auto attr = getProperties().result_accuracy;
      getProperties().result_accuracy = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static ExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static ExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static ExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static ExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static ExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static ExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::ExpOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::Expm1Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class Expm1OpGenericAdaptorBase {
public:
  struct Properties {
    using result_accuracyTy = ::mlir::stablehlo::ResultAccuracyAttr;
    result_accuracyTy result_accuracy;

    auto getResultAccuracy() const {
      auto &propStorage = this->result_accuracy;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(propStorage);
    }
    void setResultAccuracy(const ::mlir::stablehlo::ResultAccuracyAttr &propValue) {
      this->result_accuracy = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.result_accuracy == this->result_accuracy &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  Expm1OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.exponential_minus_one", odsAttrs.getContext());
  }

  Expm1OpGenericAdaptorBase(Expm1Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr();
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
};
} // namespace detail
template <typename RangeT>
class Expm1OpGenericAdaptor : public detail::Expm1OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::Expm1OpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  Expm1OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  Expm1OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : Expm1OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  Expm1OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : Expm1OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  Expm1OpGenericAdaptor(RangeT values, const Expm1OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = Expm1Op, typename = std::enable_if_t<std::is_same_v<LateInst, Expm1Op>>>
  Expm1OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class Expm1OpAdaptor : public Expm1OpGenericAdaptor<::mlir::ValueRange> {
public:
  using Expm1OpGenericAdaptor::Expm1OpGenericAdaptor;
  Expm1OpAdaptor(Expm1Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class Expm1Op : public ::mlir::Op<Expm1Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::Elementwise, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = Expm1OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = Expm1OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("result_accuracy")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getResultAccuracyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getResultAccuracyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.exponential_minus_one");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(getProperties().result_accuracy);
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
  void setResultAccuracyAttr(::mlir::stablehlo::ResultAccuracyAttr attr) {
    getProperties().result_accuracy = attr;
  }

  ::mlir::Attribute removeResultAccuracyAttr() {
      auto attr = getProperties().result_accuracy;
      getProperties().result_accuracy = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static Expm1Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static Expm1Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static Expm1Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static Expm1Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static Expm1Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static Expm1Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Expm1Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Expm1Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Expm1Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Expm1Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Expm1Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Expm1Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Expm1Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Expm1Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::Expm1Op)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::FftOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class FftOpGenericAdaptorBase {
public:
  struct Properties {
    using fft_lengthTy = ::mlir::DenseI64ArrayAttr;
    fft_lengthTy fft_length;

    auto getFftLength() const {
      auto &propStorage = this->fft_length;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setFftLength(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->fft_length = propValue;
    }
    using fft_typeTy = ::mlir::stablehlo::FftTypeAttr;
    fft_typeTy fft_type;

    auto getFftType() const {
      auto &propStorage = this->fft_type;
      return ::llvm::cast<::mlir::stablehlo::FftTypeAttr>(propStorage);
    }
    void setFftType(const ::mlir::stablehlo::FftTypeAttr &propValue) {
      this->fft_type = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.fft_length == this->fft_length &&
        rhs.fft_type == this->fft_type &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FftOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.fft", odsAttrs.getContext());
  }

  FftOpGenericAdaptorBase(FftOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::stablehlo::FftTypeAttr getFftTypeAttr() {
    auto attr = ::llvm::cast<::mlir::stablehlo::FftTypeAttr>(getProperties().fft_type);
    return attr;
  }

  ::mlir::stablehlo::FftType getFftType();
  ::mlir::DenseI64ArrayAttr getFftLengthAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().fft_length);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getFftLength();
};
} // namespace detail
template <typename RangeT>
class FftOpGenericAdaptor : public detail::FftOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FftOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  FftOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FftOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FftOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FftOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FftOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FftOpGenericAdaptor(RangeT values, const FftOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FftOp, typename = std::enable_if_t<std::is_same_v<LateInst, FftOp>>>
  FftOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FftOpAdaptor : public FftOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FftOpGenericAdaptor::FftOpGenericAdaptor;
  FftOpAdaptor(FftOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FftOp : public ::mlir::Op<FftOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FftOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FftOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("fft_length"), ::llvm::StringRef("fft_type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFftLengthAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFftLengthAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFftTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFftTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.fft");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::stablehlo::FftTypeAttr getFftTypeAttr() {
    return ::llvm::cast<::mlir::stablehlo::FftTypeAttr>(getProperties().fft_type);
  }

  ::mlir::stablehlo::FftType getFftType();
  ::mlir::DenseI64ArrayAttr getFftLengthAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().fft_length);
  }

  ::llvm::ArrayRef<int64_t> getFftLength();
  void setFftTypeAttr(::mlir::stablehlo::FftTypeAttr attr) {
    getProperties().fft_type = attr;
  }

  void setFftType(::mlir::stablehlo::FftType attrValue);
  void setFftLengthAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().fft_length = attr;
  }

  void setFftLength(::llvm::ArrayRef<int64_t> attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::stablehlo::FftTypeAttr fft_type, ::mlir::DenseI64ArrayAttr fft_length);
  static FftOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::stablehlo::FftTypeAttr fft_type, ::mlir::DenseI64ArrayAttr fft_length);
  static FftOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::stablehlo::FftTypeAttr fft_type, ::mlir::DenseI64ArrayAttr fft_length);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::stablehlo::FftTypeAttr fft_type, ::mlir::DenseI64ArrayAttr fft_length);
  static FftOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::stablehlo::FftTypeAttr fft_type, ::mlir::DenseI64ArrayAttr fft_length);
  static FftOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::stablehlo::FftTypeAttr fft_type, ::mlir::DenseI64ArrayAttr fft_length);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::stablehlo::FftTypeAttr fft_type, ::mlir::DenseI64ArrayAttr fft_length);
  static FftOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::stablehlo::FftTypeAttr fft_type, ::mlir::DenseI64ArrayAttr fft_length);
  static FftOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::stablehlo::FftTypeAttr fft_type, ::mlir::DenseI64ArrayAttr fft_length);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::stablehlo::FftType fft_type, ::llvm::ArrayRef<int64_t> fft_length);
  static FftOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::stablehlo::FftType fft_type, ::llvm::ArrayRef<int64_t> fft_length);
  static FftOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::stablehlo::FftType fft_type, ::llvm::ArrayRef<int64_t> fft_length);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::stablehlo::FftType fft_type, ::llvm::ArrayRef<int64_t> fft_length);
  static FftOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::stablehlo::FftType fft_type, ::llvm::ArrayRef<int64_t> fft_length);
  static FftOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::stablehlo::FftType fft_type, ::llvm::ArrayRef<int64_t> fft_length);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::stablehlo::FftType fft_type, ::llvm::ArrayRef<int64_t> fft_length);
  static FftOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::stablehlo::FftType fft_type, ::llvm::ArrayRef<int64_t> fft_length);
  static FftOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::stablehlo::FftType fft_type, ::llvm::ArrayRef<int64_t> fft_length);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FftOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FftOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FftOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FftOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FftOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FftOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FftOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FftOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  /// Interface method for ConditionallySpeculatable.
  mlir::Speculation::Speculatability getSpeculatability();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::FftOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::FloorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class FloorOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FloorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.floor", odsAttrs.getContext());
  }

  FloorOpGenericAdaptorBase(FloorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class FloorOpGenericAdaptor : public detail::FloorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FloorOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  FloorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FloorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FloorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FloorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FloorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FloorOpGenericAdaptor(RangeT values, const FloorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FloorOp, typename = std::enable_if_t<std::is_same_v<LateInst, FloorOp>>>
  FloorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FloorOpAdaptor : public FloorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FloorOpGenericAdaptor::FloorOpGenericAdaptor;
  FloorOpAdaptor(FloorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FloorOp : public ::mlir::Op<FloorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::Elementwise, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FloorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FloorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.floor");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static FloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static FloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static FloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static FloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static FloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static FloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FloorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FloorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::FloorOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::GatherOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GatherOpGenericAdaptorBase {
public:
  struct Properties {
    using dimension_numbersTy = ::mlir::stablehlo::GatherDimensionNumbersAttr;
    dimension_numbersTy dimension_numbers;

    auto getDimensionNumbers() const {
      auto &propStorage = this->dimension_numbers;
      return ::llvm::cast<::mlir::stablehlo::GatherDimensionNumbersAttr>(propStorage);
    }
    void setDimensionNumbers(const ::mlir::stablehlo::GatherDimensionNumbersAttr &propValue) {
      this->dimension_numbers = propValue;
    }
    using indices_are_sortedTy = ::mlir::BoolAttr;
    indices_are_sortedTy indices_are_sorted;

    auto getIndicesAreSorted() const {
      auto &propStorage = this->indices_are_sorted;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setIndicesAreSorted(const ::mlir::BoolAttr &propValue) {
      this->indices_are_sorted = propValue;
    }
    using slice_sizesTy = ::mlir::DenseI64ArrayAttr;
    slice_sizesTy slice_sizes;

    auto getSliceSizes() const {
      auto &propStorage = this->slice_sizes;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setSliceSizes(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->slice_sizes = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dimension_numbers == this->dimension_numbers &&
        rhs.indices_are_sorted == this->indices_are_sorted &&
        rhs.slice_sizes == this->slice_sizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GatherOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.gather", odsAttrs.getContext());
  }

  GatherOpGenericAdaptorBase(GatherOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::stablehlo::GatherDimensionNumbersAttr getDimensionNumbersAttr() {
    auto attr = ::llvm::cast<::mlir::stablehlo::GatherDimensionNumbersAttr>(getProperties().dimension_numbers);
    return attr;
  }

  ::mlir::stablehlo::GatherDimensionNumbersAttr getDimensionNumbers();
  ::mlir::DenseI64ArrayAttr getSliceSizesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().slice_sizes);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getSliceSizes();
  ::mlir::BoolAttr getIndicesAreSortedAttr();
  bool getIndicesAreSorted();
};
} // namespace detail
template <typename RangeT>
class GatherOpGenericAdaptor : public detail::GatherOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GatherOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_start_indices = 1;
public:
  GatherOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GatherOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GatherOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GatherOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GatherOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GatherOpGenericAdaptor(RangeT values, const GatherOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GatherOp, typename = std::enable_if_t<std::is_same_v<LateInst, GatherOp>>>
  GatherOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  ValueT getStartIndices() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GatherOpAdaptor : public GatherOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GatherOpGenericAdaptor::GatherOpGenericAdaptor;
  GatherOpAdaptor(GatherOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GatherOp : public ::mlir::Op<GatherOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GatherOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GatherOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  static constexpr int odsIndex_start_indices = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dimension_numbers"), ::llvm::StringRef("indices_are_sorted"), ::llvm::StringRef("slice_sizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDimensionNumbersAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDimensionNumbersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getIndicesAreSortedAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getIndicesAreSortedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSliceSizesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSliceSizesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.gather");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getStartIndices() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getStartIndicesMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::stablehlo::GatherDimensionNumbersAttr getDimensionNumbersAttr() {
    return ::llvm::cast<::mlir::stablehlo::GatherDimensionNumbersAttr>(getProperties().dimension_numbers);
  }

  ::mlir::stablehlo::GatherDimensionNumbersAttr getDimensionNumbers();
  ::mlir::DenseI64ArrayAttr getSliceSizesAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().slice_sizes);
  }

  ::llvm::ArrayRef<int64_t> getSliceSizes();
  ::mlir::BoolAttr getIndicesAreSortedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().indices_are_sorted);
  }

  bool getIndicesAreSorted();
  void setDimensionNumbersAttr(::mlir::stablehlo::GatherDimensionNumbersAttr attr) {
    getProperties().dimension_numbers = attr;
  }

  void setSliceSizesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().slice_sizes = attr;
  }

  void setSliceSizes(::llvm::ArrayRef<int64_t> attrValue);
  void setIndicesAreSortedAttr(::mlir::BoolAttr attr) {
    getProperties().indices_are_sorted = attr;
  }

  void setIndicesAreSorted(::std::optional<bool> attrValue);
  ::mlir::Attribute removeIndicesAreSortedAttr() {
      auto attr = getProperties().indices_are_sorted;
      getProperties().indices_are_sorted = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::mlir::DenseI64ArrayAttr slice_sizes, /*optional*/::mlir::BoolAttr indices_are_sorted = nullptr);
  static GatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::mlir::DenseI64ArrayAttr slice_sizes, /*optional*/::mlir::BoolAttr indices_are_sorted = nullptr);
  static GatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::mlir::DenseI64ArrayAttr slice_sizes, /*optional*/::mlir::BoolAttr indices_are_sorted = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::mlir::DenseI64ArrayAttr slice_sizes, /*optional*/::mlir::BoolAttr indices_are_sorted = nullptr);
  static GatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::mlir::DenseI64ArrayAttr slice_sizes, /*optional*/::mlir::BoolAttr indices_are_sorted = nullptr);
  static GatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::mlir::DenseI64ArrayAttr slice_sizes, /*optional*/::mlir::BoolAttr indices_are_sorted = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::mlir::DenseI64ArrayAttr slice_sizes, /*optional*/::mlir::BoolAttr indices_are_sorted = nullptr);
  static GatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::mlir::DenseI64ArrayAttr slice_sizes, /*optional*/::mlir::BoolAttr indices_are_sorted = nullptr);
  static GatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::mlir::DenseI64ArrayAttr slice_sizes, /*optional*/::mlir::BoolAttr indices_are_sorted = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::llvm::ArrayRef<int64_t> slice_sizes, /*optional*/bool indices_are_sorted = false);
  static GatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::llvm::ArrayRef<int64_t> slice_sizes, /*optional*/bool indices_are_sorted = false);
  static GatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::llvm::ArrayRef<int64_t> slice_sizes, /*optional*/bool indices_are_sorted = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::llvm::ArrayRef<int64_t> slice_sizes, /*optional*/bool indices_are_sorted = false);
  static GatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::llvm::ArrayRef<int64_t> slice_sizes, /*optional*/bool indices_are_sorted = false);
  static GatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::llvm::ArrayRef<int64_t> slice_sizes, /*optional*/bool indices_are_sorted = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::llvm::ArrayRef<int64_t> slice_sizes, /*optional*/bool indices_are_sorted = false);
  static GatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::llvm::ArrayRef<int64_t> slice_sizes, /*optional*/bool indices_are_sorted = false);
  static GatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::Value start_indices, ::mlir::stablehlo::GatherDimensionNumbersAttr dimension_numbers, ::llvm::ArrayRef<int64_t> slice_sizes, /*optional*/bool indices_are_sorted = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GatherOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GatherOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  ::llvm::LogicalResult reifyReturnTypeShapes(::mlir::OpBuilder&builder, ::mlir::ValueRange operands, ::llvm::SmallVectorImpl<::mlir::Value> &reifiedReturnShapes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  /// Interface method for ConditionallySpeculatable.
  mlir::Speculation::Speculatability getSpeculatability();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::GatherOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::GetDimensionSizeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GetDimensionSizeOpGenericAdaptorBase {
public:
  struct Properties {
    using dimensionTy = ::mlir::IntegerAttr;
    dimensionTy dimension;

    auto getDimension() const {
      auto &propStorage = this->dimension;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDimension(const ::mlir::IntegerAttr &propValue) {
      this->dimension = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dimension == this->dimension &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GetDimensionSizeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.get_dimension_size", odsAttrs.getContext());
  }

  GetDimensionSizeOpGenericAdaptorBase(GetDimensionSizeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDimensionAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dimension);
    return attr;
  }

  uint64_t getDimension();
};
} // namespace detail
template <typename RangeT>
class GetDimensionSizeOpGenericAdaptor : public detail::GetDimensionSizeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GetDimensionSizeOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  GetDimensionSizeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GetDimensionSizeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GetDimensionSizeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GetDimensionSizeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GetDimensionSizeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GetDimensionSizeOpGenericAdaptor(RangeT values, const GetDimensionSizeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GetDimensionSizeOp, typename = std::enable_if_t<std::is_same_v<LateInst, GetDimensionSizeOp>>>
  GetDimensionSizeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GetDimensionSizeOpAdaptor : public GetDimensionSizeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GetDimensionSizeOpGenericAdaptor::GetDimensionSizeOpGenericAdaptor;
  GetDimensionSizeOpAdaptor(GetDimensionSizeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GetDimensionSizeOp : public ::mlir::Op<GetDimensionSizeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GetDimensionSizeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GetDimensionSizeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dimension")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDimensionAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDimensionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.get_dimension_size");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDimensionAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dimension);
  }

  uint64_t getDimension();
  void setDimensionAttr(::mlir::IntegerAttr attr) {
    getProperties().dimension = attr;
  }

  void setDimension(uint64_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::IntegerAttr dimension);
  static GetDimensionSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::IntegerAttr dimension);
  static GetDimensionSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::IntegerAttr dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::IntegerAttr dimension);
  static GetDimensionSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::IntegerAttr dimension);
  static GetDimensionSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::IntegerAttr dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::IntegerAttr dimension);
  static GetDimensionSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::IntegerAttr dimension);
  static GetDimensionSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::IntegerAttr dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, uint64_t dimension);
  static GetDimensionSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, uint64_t dimension);
  static GetDimensionSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, uint64_t dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, uint64_t dimension);
  static GetDimensionSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, uint64_t dimension);
  static GetDimensionSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, uint64_t dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, uint64_t dimension);
  static GetDimensionSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, uint64_t dimension);
  static GetDimensionSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, uint64_t dimension);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetDimensionSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetDimensionSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetDimensionSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetDimensionSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetDimensionSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetDimensionSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetDimensionSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetDimensionSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::GetDimensionSizeOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::GetTupleElementOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GetTupleElementOpGenericAdaptorBase {
public:
  struct Properties {
    using indexTy = ::mlir::IntegerAttr;
    indexTy index;

    auto getIndex() const {
      auto &propStorage = this->index;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setIndex(const ::mlir::IntegerAttr &propValue) {
      this->index = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.index == this->index &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GetTupleElementOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.get_tuple_element", odsAttrs.getContext());
  }

  GetTupleElementOpGenericAdaptorBase(GetTupleElementOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().index);
    return attr;
  }

  uint32_t getIndex();
};
} // namespace detail
template <typename RangeT>
class GetTupleElementOpGenericAdaptor : public detail::GetTupleElementOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GetTupleElementOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  GetTupleElementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GetTupleElementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GetTupleElementOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GetTupleElementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GetTupleElementOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GetTupleElementOpGenericAdaptor(RangeT values, const GetTupleElementOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GetTupleElementOp, typename = std::enable_if_t<std::is_same_v<LateInst, GetTupleElementOp>>>
  GetTupleElementOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GetTupleElementOpAdaptor : public GetTupleElementOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GetTupleElementOpGenericAdaptor::GetTupleElementOpGenericAdaptor;
  GetTupleElementOpAdaptor(GetTupleElementOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GetTupleElementOp : public ::mlir::Op<GetTupleElementOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GetTupleElementOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GetTupleElementOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("index")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.get_tuple_element");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().index);
  }

  uint32_t getIndex();
  void setIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().index = attr;
  }

  void setIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::IntegerAttr index);
  static GetTupleElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::IntegerAttr index);
  static GetTupleElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, ::mlir::IntegerAttr index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::IntegerAttr index);
  static GetTupleElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::IntegerAttr index);
  static GetTupleElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::IntegerAttr index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::IntegerAttr index);
  static GetTupleElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::IntegerAttr index);
  static GetTupleElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::IntegerAttr index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value operand, uint32_t index);
  static GetTupleElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value operand, uint32_t index);
  static GetTupleElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value operand, uint32_t index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, uint32_t index);
  static GetTupleElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, uint32_t index);
  static GetTupleElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, uint32_t index);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, uint32_t index);
  static GetTupleElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, uint32_t index);
  static GetTupleElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, uint32_t index);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetTupleElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetTupleElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetTupleElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetTupleElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetTupleElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetTupleElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetTupleElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetTupleElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::GetTupleElementOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::IfOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class IfOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IfOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.if", odsAttrs.getContext());
  }

  IfOpGenericAdaptorBase(IfOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::Region &getTrueBranch() {
    return *odsRegions[0];
  }

  ::mlir::Region &getFalseBranch() {
    return *odsRegions[1];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class IfOpGenericAdaptor : public detail::IfOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IfOpGenericAdaptorBase;
  static constexpr int odsIndex_pred = 0;
public:
  IfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IfOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : IfOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  IfOpGenericAdaptor(RangeT values, const IfOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IfOp, typename = std::enable_if_t<std::is_same_v<LateInst, IfOp>>>
  IfOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPred() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IfOpAdaptor : public IfOpGenericAdaptor<::mlir::ValueRange> {
public:
  using IfOpGenericAdaptor::IfOpGenericAdaptor;
  IfOpAdaptor(IfOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IfOp : public ::mlir::Op<IfOp, ::mlir::OpTrait::NRegions<2>::Impl, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::SingleBlockImplicitTerminator<ReturnOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::HasRecursiveMemoryEffects, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::RecursivelySpeculatableImplTrait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IfOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IfOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pred = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.if");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getPred() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getPredMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getTrueBranch() {
    return (*this)->getRegion(0);
  }

  ::mlir::Region &getFalseBranch() {
    return (*this)->getRegion(1);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::Value pred);
  static IfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::Value pred);
  static IfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value pred);
  static IfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value pred);
  static IfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::IfOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::ImagOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ImagOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ImagOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.imag", odsAttrs.getContext());
  }

  ImagOpGenericAdaptorBase(ImagOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class ImagOpGenericAdaptor : public detail::ImagOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ImagOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  ImagOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ImagOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ImagOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ImagOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ImagOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ImagOpGenericAdaptor(RangeT values, const ImagOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ImagOp, typename = std::enable_if_t<std::is_same_v<LateInst, ImagOp>>>
  ImagOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ImagOpAdaptor : public ImagOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ImagOpGenericAdaptor::ImagOpGenericAdaptor;
  ImagOpAdaptor(ImagOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ImagOp : public ::mlir::Op<ImagOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::InferTypeOpInterface::Trait, ::mlir::OpTrait::Elementwise, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ImagOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ImagOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.imag");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static ImagOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static ImagOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static ImagOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static ImagOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static ImagOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static ImagOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ImagOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ImagOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ImagOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ImagOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ImagOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ImagOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ImagOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ImagOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::ImagOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::InfeedOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class InfeedOpGenericAdaptorBase {
public:
  struct Properties {
    using infeed_configTy = ::mlir::StringAttr;
    infeed_configTy infeed_config;

    auto getInfeedConfig() const {
      auto &propStorage = this->infeed_config;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setInfeedConfig(const ::mlir::StringAttr &propValue) {
      this->infeed_config = propValue;
    }
    using layoutTy = ::mlir::ArrayAttr;
    layoutTy layout;

    auto getLayout() const {
      auto &propStorage = this->layout;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setLayout(const ::mlir::ArrayAttr &propValue) {
      this->layout = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.infeed_config == this->infeed_config &&
        rhs.layout == this->layout &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  InfeedOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.infeed", odsAttrs.getContext());
  }

  InfeedOpGenericAdaptorBase(InfeedOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getInfeedConfigAttr();
  ::llvm::StringRef getInfeedConfig();
  ::mlir::ArrayAttr getLayoutAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().layout);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getLayout();
};
} // namespace detail
template <typename RangeT>
class InfeedOpGenericAdaptor : public detail::InfeedOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::InfeedOpGenericAdaptorBase;
  static constexpr int odsIndex_token = 0;
public:
  InfeedOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  InfeedOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : InfeedOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  InfeedOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : InfeedOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  InfeedOpGenericAdaptor(RangeT values, const InfeedOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = InfeedOp, typename = std::enable_if_t<std::is_same_v<LateInst, InfeedOp>>>
  InfeedOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getToken() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class InfeedOpAdaptor : public InfeedOpGenericAdaptor<::mlir::ValueRange> {
public:
  using InfeedOpGenericAdaptor::InfeedOpGenericAdaptor;
  InfeedOpAdaptor(InfeedOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class InfeedOp : public ::mlir::Op<InfeedOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = InfeedOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = InfeedOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_token = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("infeed_config"), ::llvm::StringRef("layout")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getInfeedConfigAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getInfeedConfigAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getLayoutAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getLayoutAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.infeed");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getToken() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getTokenMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getInfeedConfigAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().infeed_config);
  }

  ::llvm::StringRef getInfeedConfig();
  ::mlir::ArrayAttr getLayoutAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().layout);
  }

  ::std::optional< ::mlir::ArrayAttr > getLayout();
  void setInfeedConfigAttr(::mlir::StringAttr attr) {
    getProperties().infeed_config = attr;
  }

  void setInfeedConfig(::llvm::StringRef attrValue);
  void setLayoutAttr(::mlir::ArrayAttr attr) {
    getProperties().layout = attr;
  }

  ::mlir::Attribute removeLayoutAttr() {
      auto attr = getProperties().layout;
      getProperties().layout = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::Value token, ::mlir::StringAttr infeed_config, /*optional*/::mlir::ArrayAttr layout);
  static InfeedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::Value token, ::mlir::StringAttr infeed_config, /*optional*/::mlir::ArrayAttr layout);
  static InfeedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::Value token, ::mlir::StringAttr infeed_config, /*optional*/::mlir::ArrayAttr layout);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, ::mlir::Value token, ::llvm::StringRef infeed_config, /*optional*/::mlir::ArrayAttr layout);
  static InfeedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, ::mlir::Value token, ::llvm::StringRef infeed_config, /*optional*/::mlir::ArrayAttr layout);
  static InfeedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, ::mlir::Value token, ::llvm::StringRef infeed_config, /*optional*/::mlir::ArrayAttr layout);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InfeedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InfeedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InfeedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InfeedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::InfeedOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::IotaOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class IotaOpGenericAdaptorBase {
public:
  struct Properties {
    using iota_dimensionTy = ::mlir::IntegerAttr;
    iota_dimensionTy iota_dimension;

    auto getIotaDimension() const {
      auto &propStorage = this->iota_dimension;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setIotaDimension(const ::mlir::IntegerAttr &propValue) {
      this->iota_dimension = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.iota_dimension == this->iota_dimension &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IotaOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.iota", odsAttrs.getContext());
  }

  IotaOpGenericAdaptorBase(IotaOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIotaDimensionAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().iota_dimension);
    return attr;
  }

  uint64_t getIotaDimension();
};
} // namespace detail
template <typename RangeT>
class IotaOpGenericAdaptor : public detail::IotaOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IotaOpGenericAdaptorBase;
public:
  IotaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IotaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IotaOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IotaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : IotaOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  IotaOpGenericAdaptor(RangeT values, const IotaOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IotaOp, typename = std::enable_if_t<std::is_same_v<LateInst, IotaOp>>>
  IotaOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IotaOpAdaptor : public IotaOpGenericAdaptor<::mlir::ValueRange> {
public:
  using IotaOpGenericAdaptor::IotaOpGenericAdaptor;
  IotaOpAdaptor(IotaOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IotaOp : public ::mlir::Op<IotaOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IotaOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IotaOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("iota_dimension")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIotaDimensionAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIotaDimensionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.iota");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIotaDimensionAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().iota_dimension);
  }

  uint64_t getIotaDimension();
  void setIotaDimensionAttr(::mlir::IntegerAttr attr) {
    getProperties().iota_dimension = attr;
  }

  void setIotaDimension(uint64_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::IntegerAttr iota_dimension);
  static IotaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type output, ::mlir::IntegerAttr iota_dimension);
  static IotaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type output, ::mlir::IntegerAttr iota_dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr iota_dimension);
  static IotaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr iota_dimension);
  static IotaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr iota_dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, uint64_t iota_dimension);
  static IotaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type output, uint64_t iota_dimension);
  static IotaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type output, uint64_t iota_dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint64_t iota_dimension);
  static IotaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint64_t iota_dimension);
  static IotaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint64_t iota_dimension);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IotaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IotaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IotaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IotaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::IotaOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::IsFiniteOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class IsFiniteOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IsFiniteOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.is_finite", odsAttrs.getContext());
  }

  IsFiniteOpGenericAdaptorBase(IsFiniteOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class IsFiniteOpGenericAdaptor : public detail::IsFiniteOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IsFiniteOpGenericAdaptorBase;
  static constexpr int odsIndex_x = 0;
public:
  IsFiniteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IsFiniteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IsFiniteOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IsFiniteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : IsFiniteOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  IsFiniteOpGenericAdaptor(RangeT values, const IsFiniteOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IsFiniteOp, typename = std::enable_if_t<std::is_same_v<LateInst, IsFiniteOp>>>
  IsFiniteOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IsFiniteOpAdaptor : public IsFiniteOpGenericAdaptor<::mlir::ValueRange> {
public:
  using IsFiniteOpGenericAdaptor::IsFiniteOpGenericAdaptor;
  IsFiniteOpAdaptor(IsFiniteOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IsFiniteOp : public ::mlir::Op<IsFiniteOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::InferTypeOpInterface::Trait, ::mlir::OpTrait::Elementwise, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IsFiniteOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IsFiniteOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_x = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.is_finite");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type y, ::mlir::Value x);
  static IsFiniteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type y, ::mlir::Value x);
  static IsFiniteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x);
  static IsFiniteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value x);
  static IsFiniteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static IsFiniteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static IsFiniteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsFiniteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsFiniteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsFiniteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsFiniteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsFiniteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsFiniteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsFiniteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsFiniteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::IsFiniteOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::Log1pOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class Log1pOpGenericAdaptorBase {
public:
  struct Properties {
    using result_accuracyTy = ::mlir::stablehlo::ResultAccuracyAttr;
    result_accuracyTy result_accuracy;

    auto getResultAccuracy() const {
      auto &propStorage = this->result_accuracy;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(propStorage);
    }
    void setResultAccuracy(const ::mlir::stablehlo::ResultAccuracyAttr &propValue) {
      this->result_accuracy = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.result_accuracy == this->result_accuracy &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  Log1pOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.log_plus_one", odsAttrs.getContext());
  }

  Log1pOpGenericAdaptorBase(Log1pOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr();
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
};
} // namespace detail
template <typename RangeT>
class Log1pOpGenericAdaptor : public detail::Log1pOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::Log1pOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  Log1pOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  Log1pOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : Log1pOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  Log1pOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : Log1pOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  Log1pOpGenericAdaptor(RangeT values, const Log1pOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = Log1pOp, typename = std::enable_if_t<std::is_same_v<LateInst, Log1pOp>>>
  Log1pOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class Log1pOpAdaptor : public Log1pOpGenericAdaptor<::mlir::ValueRange> {
public:
  using Log1pOpGenericAdaptor::Log1pOpGenericAdaptor;
  Log1pOpAdaptor(Log1pOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class Log1pOp : public ::mlir::Op<Log1pOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::Elementwise, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = Log1pOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = Log1pOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("result_accuracy")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getResultAccuracyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getResultAccuracyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.log_plus_one");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(getProperties().result_accuracy);
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
  void setResultAccuracyAttr(::mlir::stablehlo::ResultAccuracyAttr attr) {
    getProperties().result_accuracy = attr;
  }

  ::mlir::Attribute removeResultAccuracyAttr() {
      auto attr = getProperties().result_accuracy;
      getProperties().result_accuracy = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static Log1pOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static Log1pOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static Log1pOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static Log1pOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static Log1pOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static Log1pOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Log1pOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Log1pOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Log1pOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static Log1pOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Log1pOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Log1pOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Log1pOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static Log1pOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::Log1pOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::LogOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class LogOpGenericAdaptorBase {
public:
  struct Properties {
    using result_accuracyTy = ::mlir::stablehlo::ResultAccuracyAttr;
    result_accuracyTy result_accuracy;

    auto getResultAccuracy() const {
      auto &propStorage = this->result_accuracy;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(propStorage);
    }
    void setResultAccuracy(const ::mlir::stablehlo::ResultAccuracyAttr &propValue) {
      this->result_accuracy = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.result_accuracy == this->result_accuracy &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LogOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.log", odsAttrs.getContext());
  }

  LogOpGenericAdaptorBase(LogOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr();
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
};
} // namespace detail
template <typename RangeT>
class LogOpGenericAdaptor : public detail::LogOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LogOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  LogOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LogOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LogOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LogOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : LogOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LogOpGenericAdaptor(RangeT values, const LogOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LogOp, typename = std::enable_if_t<std::is_same_v<LateInst, LogOp>>>
  LogOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LogOpAdaptor : public LogOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LogOpGenericAdaptor::LogOpGenericAdaptor;
  LogOpAdaptor(LogOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LogOp : public ::mlir::Op<LogOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::Elementwise, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LogOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LogOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("result_accuracy")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getResultAccuracyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getResultAccuracyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.log");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(getProperties().result_accuracy);
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
  void setResultAccuracyAttr(::mlir::stablehlo::ResultAccuracyAttr attr) {
    getProperties().result_accuracy = attr;
  }

  ::mlir::Attribute removeResultAccuracyAttr() {
      auto attr = getProperties().result_accuracy;
      getProperties().result_accuracy = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static LogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static LogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static LogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static LogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static LogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static LogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LogOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LogOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::LogOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::LogisticOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class LogisticOpGenericAdaptorBase {
public:
  struct Properties {
    using result_accuracyTy = ::mlir::stablehlo::ResultAccuracyAttr;
    result_accuracyTy result_accuracy;

    auto getResultAccuracy() const {
      auto &propStorage = this->result_accuracy;
      return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(propStorage);
    }
    void setResultAccuracy(const ::mlir::stablehlo::ResultAccuracyAttr &propValue) {
      this->result_accuracy = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.result_accuracy == this->result_accuracy &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LogisticOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.logistic", odsAttrs.getContext());
  }

  LogisticOpGenericAdaptorBase(LogisticOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr();
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
};
} // namespace detail
template <typename RangeT>
class LogisticOpGenericAdaptor : public detail::LogisticOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LogisticOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  LogisticOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LogisticOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LogisticOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LogisticOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : LogisticOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LogisticOpGenericAdaptor(RangeT values, const LogisticOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LogisticOp, typename = std::enable_if_t<std::is_same_v<LateInst, LogisticOp>>>
  LogisticOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LogisticOpAdaptor : public LogisticOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LogisticOpGenericAdaptor::LogisticOpGenericAdaptor;
  LogisticOpAdaptor(LogisticOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LogisticOp : public ::mlir::Op<LogisticOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::Elementwise, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfStaticDimInOutputIsStaticInInputImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LogisticOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LogisticOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("result_accuracy")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getResultAccuracyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getResultAccuracyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.logistic");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::stablehlo::ResultAccuracyAttr>(getProperties().result_accuracy);
  }

  ::mlir::stablehlo::ResultAccuracyAttr getResultAccuracy();
  void setResultAccuracyAttr(::mlir::stablehlo::ResultAccuracyAttr attr) {
    getProperties().result_accuracy = attr;
  }

  ::mlir::Attribute removeResultAccuracyAttr() {
      auto attr = getProperties().result_accuracy;
      getProperties().result_accuracy = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static LogisticOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static LogisticOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static LogisticOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static LogisticOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static LogisticOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static LogisticOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, /*optional*/::mlir::stablehlo::ResultAccuracyAttr result_accuracy = nullptr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LogisticOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LogisticOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LogisticOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LogisticOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LogisticOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LogisticOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LogisticOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LogisticOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                              operands.front(),
                                              &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::LogisticOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::MapOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class MapOpGenericAdaptorBase {
public:
  struct Properties {
    using dimensionsTy = ::mlir::DenseI64ArrayAttr;
    dimensionsTy dimensions;

    auto getDimensions() const {
      auto &propStorage = this->dimensions;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setDimensions(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->dimensions = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dimensions == this->dimensions &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MapOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.map", odsAttrs.getContext());
  }

  MapOpGenericAdaptorBase(MapOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getDimensionsAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().dimensions);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getDimensions();
  ::mlir::Region &getComputation() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class MapOpGenericAdaptor : public detail::MapOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MapOpGenericAdaptorBase;
  static constexpr int odsIndex_inputs = 0;
public:
  MapOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MapOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MapOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MapOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : MapOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MapOpGenericAdaptor(RangeT values, const MapOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MapOp, typename = std::enable_if_t<std::is_same_v<LateInst, MapOp>>>
  MapOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getInputs() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MapOpAdaptor : public MapOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MapOpGenericAdaptor::MapOpGenericAdaptor;
  MapOpAdaptor(MapOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MapOp : public ::mlir::Op<MapOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::SingleBlockImplicitTerminator<ReturnOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::RecursivelySpeculatableIfAllInputsStaticImplTrait, ::mlir::OpTrait::HasRecursiveMemoryEffects, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MapOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MapOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_inputs = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dimensions")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDimensionsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDimensionsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.map");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getInputs() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getInputsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getComputation() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getDimensionsAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().dimensions);
  }

  ::llvm::ArrayRef<int64_t> getDimensions();
  void setDimensionsAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().dimensions = attr;
  }

  void setDimensions(::llvm::ArrayRef<int64_t> attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::ValueRange inputs, ::mlir::DenseI64ArrayAttr dimensions);
  static MapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::ValueRange inputs, ::mlir::DenseI64ArrayAttr dimensions);
  static MapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::ValueRange inputs, ::mlir::DenseI64ArrayAttr dimensions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange inputs, ::mlir::DenseI64ArrayAttr dimensions);
  static MapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange inputs, ::mlir::DenseI64ArrayAttr dimensions);
  static MapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange inputs, ::mlir::DenseI64ArrayAttr dimensions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange inputs, ::mlir::DenseI64ArrayAttr dimensions);
  static MapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange inputs, ::mlir::DenseI64ArrayAttr dimensions);
  static MapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange inputs, ::mlir::DenseI64ArrayAttr dimensions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::ValueRange inputs, ::llvm::ArrayRef<int64_t> dimensions);
  static MapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::ValueRange inputs, ::llvm::ArrayRef<int64_t> dimensions);
  static MapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::ValueRange inputs, ::llvm::ArrayRef<int64_t> dimensions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange inputs, ::llvm::ArrayRef<int64_t> dimensions);
  static MapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange inputs, ::llvm::ArrayRef<int64_t> dimensions);
  static MapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange inputs, ::llvm::ArrayRef<int64_t> dimensions);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange inputs, ::llvm::ArrayRef<int64_t> dimensions);
  static MapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange inputs, ::llvm::ArrayRef<int64_t> dimensions);
  static MapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange inputs, ::llvm::ArrayRef<int64_t> dimensions);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MapOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MapOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  ::llvm::LogicalResult reifyReturnTypeShapes(::mlir::OpBuilder&builder, ::mlir::ValueRange operands, ::llvm::SmallVectorImpl<::mlir::Value> &reifiedReturnShapes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  /// Interface method for ConditionallySpeculatable.
  mlir::Speculation::Speculatability getSpeculatability();
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::MapOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::MaxOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class MaxOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MaxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.maximum", odsAttrs.getContext());
  }

  MaxOpGenericAdaptorBase(MaxOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class MaxOpGenericAdaptor : public detail::MaxOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MaxOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  MaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MaxOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : MaxOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MaxOpGenericAdaptor(RangeT values, const MaxOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MaxOp, typename = std::enable_if_t<std::is_same_v<LateInst, MaxOp>>>
  MaxOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MaxOpAdaptor : public MaxOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MaxOpGenericAdaptor::MaxOpGenericAdaptor;
  MaxOpAdaptor(MaxOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MaxOp : public ::mlir::Op<MaxOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::hlo::OpTrait::IsCommutative, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::OpTrait::Elementwise, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MaxOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MaxOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.maximum");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static MaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static MaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static MaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static MaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static MaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static MaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MaxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MaxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                               operands.front(),
                                               &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::MaxOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::MinOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class MinOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.minimum", odsAttrs.getContext());
  }

  MinOpGenericAdaptorBase(MinOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class MinOpGenericAdaptor : public detail::MinOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MinOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  MinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MinOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : MinOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MinOpGenericAdaptor(RangeT values, const MinOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MinOp, typename = std::enable_if_t<std::is_same_v<LateInst, MinOp>>>
  MinOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MinOpAdaptor : public MinOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MinOpGenericAdaptor::MinOpGenericAdaptor;
  MinOpAdaptor(MinOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MinOp : public ::mlir::Op<MinOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::hlo::OpTrait::IsCommutative, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::OpTrait::Elementwise, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MinOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MinOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.minimum");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static MinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static MinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static MinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static MinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static MinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static MinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // Relax the strict default implementation with one that allows
  // for StableHLO-specific differences.
  static bool isCompatibleReturnTypes(TypeRange l, TypeRange r) {
    return mlir::hlo::isCompatibleForHloTypeInference(l, r);
  }

  LogicalResult reifyReturnTypeShapes(
      OpBuilder& builder, ValueRange operands,
      SmallVectorImpl<Value>& reifiedReturnShapes) {
    return ::mlir::hlo::deriveShapeFromOperand(&builder, getOperation(),
                                               operands.front(),
                                               &reifiedReturnShapes);
  }
};
} // namespace stablehlo
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::stablehlo::MinOp)

namespace mlir {
namespace stablehlo {

//===----------------------------------------------------------------------===//
// ::mlir::stablehlo::MulOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class MulOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MulOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("stablehlo.multiply", odsAttrs.getContext());
  }

  MulOpGenericAdaptorBase(MulOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class MulOpGenericAdaptor : public detail::MulOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MulOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  MulOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MulOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MulOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MulOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : MulOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MulOpGenericAdaptor(RangeT values, const MulOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MulOp, typename = std::enable_if_t<std::is_same_v<LateInst, MulOp>>>
  MulOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MulOpAdaptor : public MulOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MulOpGenericAdaptor::MulOpGenericAdaptor;
  MulOpAdaptor(MulOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MulOp : public ::mlir::Op<MulOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::hlo::OpTrait::IsCommutative, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::hlo::OpTrait::CompatibleOperandsAndResultType, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::OpTrait::Elementwise, ::mlir::ConditionallySpeculatable::Trait, ::mlir::hlo::OpTrait::SpeculatableIfAllInputsStaticImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MulOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MulOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("stablehlo.multiply");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getLhs() {
    re