# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ApplianceVlansSettingsArgs', 'ApplianceVlansSettings']

@pulumi.input_type
class ApplianceVlansSettingsArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 vlans_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ApplianceVlansSettings resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.bool] vlans_enabled: Boolean indicating whether VLANs are enabled (true) or disabled (false) for the network
        """
        pulumi.set(__self__, "network_id", network_id)
        if vlans_enabled is not None:
            pulumi.set(__self__, "vlans_enabled", vlans_enabled)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="vlansEnabled")
    def vlans_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean indicating whether VLANs are enabled (true) or disabled (false) for the network
        """
        return pulumi.get(self, "vlans_enabled")

    @vlans_enabled.setter
    def vlans_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "vlans_enabled", value)


@pulumi.input_type
class _ApplianceVlansSettingsState:
    def __init__(__self__, *,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 vlans_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ApplianceVlansSettings resources.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.bool] vlans_enabled: Boolean indicating whether VLANs are enabled (true) or disabled (false) for the network
        """
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if vlans_enabled is not None:
            pulumi.set(__self__, "vlans_enabled", vlans_enabled)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="vlansEnabled")
    def vlans_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean indicating whether VLANs are enabled (true) or disabled (false) for the network
        """
        return pulumi.get(self, "vlans_enabled")

    @vlans_enabled.setter
    def vlans_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "vlans_enabled", value)


@pulumi.type_token("meraki:networks/applianceVlansSettings:ApplianceVlansSettings")
class ApplianceVlansSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 vlans_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ApplianceVlansSettings("example",
            network_id="string",
            vlans_enabled=True)
        pulumi.export("merakiNetworksApplianceVlansSettingsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceVlansSettings:ApplianceVlansSettings example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.bool] vlans_enabled: Boolean indicating whether VLANs are enabled (true) or disabled (false) for the network
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceVlansSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ApplianceVlansSettings("example",
            network_id="string",
            vlans_enabled=True)
        pulumi.export("merakiNetworksApplianceVlansSettingsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceVlansSettings:ApplianceVlansSettings example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceVlansSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceVlansSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 vlans_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceVlansSettingsArgs.__new__(ApplianceVlansSettingsArgs)

            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["vlans_enabled"] = vlans_enabled
        super(ApplianceVlansSettings, __self__).__init__(
            'meraki:networks/applianceVlansSettings:ApplianceVlansSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            vlans_enabled: Optional[pulumi.Input[builtins.bool]] = None) -> 'ApplianceVlansSettings':
        """
        Get an existing ApplianceVlansSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.bool] vlans_enabled: Boolean indicating whether VLANs are enabled (true) or disabled (false) for the network
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceVlansSettingsState.__new__(_ApplianceVlansSettingsState)

        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["vlans_enabled"] = vlans_enabled
        return ApplianceVlansSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="vlansEnabled")
    def vlans_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Boolean indicating whether VLANs are enabled (true) or disabled (false) for the network
        """
        return pulumi.get(self, "vlans_enabled")

