# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SnmpArgs', 'Snmp']

@pulumi.input_type
class SnmpArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 access: Optional[pulumi.Input[builtins.str]] = None,
                 community_string: Optional[pulumi.Input[builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['SnmpUserArgs']]]] = None):
        """
        The set of arguments for constructing a Snmp resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] access: The type of SNMP access. Can be one of 'none' (disabled), 'community' (V1/V2c), or 'users' (V3).
        :param pulumi.Input[builtins.str] community_string: SNMP community string if access is 'community'.
        :param pulumi.Input[Sequence[pulumi.Input['SnmpUserArgs']]] users: SNMP settings if access is 'users'.
        """
        pulumi.set(__self__, "network_id", network_id)
        if access is not None:
            pulumi.set(__self__, "access", access)
        if community_string is not None:
            pulumi.set(__self__, "community_string", community_string)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of SNMP access. Can be one of 'none' (disabled), 'community' (V1/V2c), or 'users' (V3).
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter(name="communityString")
    def community_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SNMP community string if access is 'community'.
        """
        return pulumi.get(self, "community_string")

    @community_string.setter
    def community_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "community_string", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SnmpUserArgs']]]]:
        """
        SNMP settings if access is 'users'.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SnmpUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _SnmpState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[builtins.str]] = None,
                 community_string: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['SnmpUserArgs']]]] = None):
        """
        Input properties used for looking up and filtering Snmp resources.
        :param pulumi.Input[builtins.str] access: The type of SNMP access. Can be one of 'none' (disabled), 'community' (V1/V2c), or 'users' (V3).
        :param pulumi.Input[builtins.str] community_string: SNMP community string if access is 'community'.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['SnmpUserArgs']]] users: SNMP settings if access is 'users'.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if community_string is not None:
            pulumi.set(__self__, "community_string", community_string)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of SNMP access. Can be one of 'none' (disabled), 'community' (V1/V2c), or 'users' (V3).
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter(name="communityString")
    def community_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SNMP community string if access is 'community'.
        """
        return pulumi.get(self, "community_string")

    @community_string.setter
    def community_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "community_string", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SnmpUserArgs']]]]:
        """
        SNMP settings if access is 'users'.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SnmpUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.type_token("meraki:networks/snmp:Snmp")
class Snmp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[builtins.str]] = None,
                 community_string: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SnmpUserArgs', 'SnmpUserArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.Snmp("example",
            access="users",
            community_string="sample",
            network_id="string",
            users=[{
                "passphrase": "hunter2",
                "username": "AzureDiamond",
            }])
        pulumi.export("merakiNetworksSnmpExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/snmp:Snmp example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access: The type of SNMP access. Can be one of 'none' (disabled), 'community' (V1/V2c), or 'users' (V3).
        :param pulumi.Input[builtins.str] community_string: SNMP community string if access is 'community'.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SnmpUserArgs', 'SnmpUserArgsDict']]]] users: SNMP settings if access is 'users'.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnmpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.Snmp("example",
            access="users",
            community_string="sample",
            network_id="string",
            users=[{
                "passphrase": "hunter2",
                "username": "AzureDiamond",
            }])
        pulumi.export("merakiNetworksSnmpExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/snmp:Snmp example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param SnmpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnmpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[builtins.str]] = None,
                 community_string: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SnmpUserArgs', 'SnmpUserArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnmpArgs.__new__(SnmpArgs)

            __props__.__dict__["access"] = access
            __props__.__dict__["community_string"] = community_string
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["users"] = users
        super(Snmp, __self__).__init__(
            'meraki:networks/snmp:Snmp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[builtins.str]] = None,
            community_string: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SnmpUserArgs', 'SnmpUserArgsDict']]]]] = None) -> 'Snmp':
        """
        Get an existing Snmp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access: The type of SNMP access. Can be one of 'none' (disabled), 'community' (V1/V2c), or 'users' (V3).
        :param pulumi.Input[builtins.str] community_string: SNMP community string if access is 'community'.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SnmpUserArgs', 'SnmpUserArgsDict']]]] users: SNMP settings if access is 'users'.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnmpState.__new__(_SnmpState)

        __props__.__dict__["access"] = access
        __props__.__dict__["community_string"] = community_string
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["users"] = users
        return Snmp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Output[builtins.str]:
        """
        The type of SNMP access. Can be one of 'none' (disabled), 'community' (V1/V2c), or 'users' (V3).
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter(name="communityString")
    def community_string(self) -> pulumi.Output[builtins.str]:
        """
        SNMP community string if access is 'community'.
        """
        return pulumi.get(self, "community_string")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Sequence['outputs.SnmpUser']]:
        """
        SNMP settings if access is 'users'.
        """
        return pulumi.get(self, "users")

