# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CameraRolesArgs', 'CameraRoles']

@pulumi.input_type
class CameraRolesArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[builtins.str],
                 applied_on_devices: Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnDeviceArgs']]]] = None,
                 applied_on_networks: Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnNetworkArgs']]]] = None,
                 applied_org_wides: Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOrgWideArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CameraRoles resource.
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnDeviceArgs']]] applied_on_devices: Device tag on which this specified permission is applied.
        :param pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnNetworkArgs']]] applied_on_networks: Network tag on which this specified permission is applied.
        :param pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOrgWideArgs']]] applied_org_wides: Permissions to be applied org wide.
        :param pulumi.Input[builtins.str] name: The name of the new role. Must be unique. This parameter is required.
        :param pulumi.Input[builtins.str] role_id: roleId path parameter. Role ID
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if applied_on_devices is not None:
            pulumi.set(__self__, "applied_on_devices", applied_on_devices)
        if applied_on_networks is not None:
            pulumi.set(__self__, "applied_on_networks", applied_on_networks)
        if applied_org_wides is not None:
            pulumi.set(__self__, "applied_org_wides", applied_org_wides)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="appliedOnDevices")
    def applied_on_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnDeviceArgs']]]]:
        """
        Device tag on which this specified permission is applied.
        """
        return pulumi.get(self, "applied_on_devices")

    @applied_on_devices.setter
    def applied_on_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnDeviceArgs']]]]):
        pulumi.set(self, "applied_on_devices", value)

    @property
    @pulumi.getter(name="appliedOnNetworks")
    def applied_on_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnNetworkArgs']]]]:
        """
        Network tag on which this specified permission is applied.
        """
        return pulumi.get(self, "applied_on_networks")

    @applied_on_networks.setter
    def applied_on_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnNetworkArgs']]]]):
        pulumi.set(self, "applied_on_networks", value)

    @property
    @pulumi.getter(name="appliedOrgWides")
    def applied_org_wides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOrgWideArgs']]]]:
        """
        Permissions to be applied org wide.
        """
        return pulumi.get(self, "applied_org_wides")

    @applied_org_wides.setter
    def applied_org_wides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOrgWideArgs']]]]):
        pulumi.set(self, "applied_org_wides", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the new role. Must be unique. This parameter is required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        roleId path parameter. Role ID
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_id", value)


@pulumi.input_type
class _CameraRolesState:
    def __init__(__self__, *,
                 applied_on_devices: Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnDeviceArgs']]]] = None,
                 applied_on_networks: Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnNetworkArgs']]]] = None,
                 applied_org_wides: Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOrgWideArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CameraRoles resources.
        :param pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnDeviceArgs']]] applied_on_devices: Device tag on which this specified permission is applied.
        :param pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnNetworkArgs']]] applied_on_networks: Network tag on which this specified permission is applied.
        :param pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOrgWideArgs']]] applied_org_wides: Permissions to be applied org wide.
        :param pulumi.Input[builtins.str] name: The name of the new role. Must be unique. This parameter is required.
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.str] role_id: roleId path parameter. Role ID
        """
        if applied_on_devices is not None:
            pulumi.set(__self__, "applied_on_devices", applied_on_devices)
        if applied_on_networks is not None:
            pulumi.set(__self__, "applied_on_networks", applied_on_networks)
        if applied_org_wides is not None:
            pulumi.set(__self__, "applied_org_wides", applied_org_wides)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)

    @property
    @pulumi.getter(name="appliedOnDevices")
    def applied_on_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnDeviceArgs']]]]:
        """
        Device tag on which this specified permission is applied.
        """
        return pulumi.get(self, "applied_on_devices")

    @applied_on_devices.setter
    def applied_on_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnDeviceArgs']]]]):
        pulumi.set(self, "applied_on_devices", value)

    @property
    @pulumi.getter(name="appliedOnNetworks")
    def applied_on_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnNetworkArgs']]]]:
        """
        Network tag on which this specified permission is applied.
        """
        return pulumi.get(self, "applied_on_networks")

    @applied_on_networks.setter
    def applied_on_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOnNetworkArgs']]]]):
        pulumi.set(self, "applied_on_networks", value)

    @property
    @pulumi.getter(name="appliedOrgWides")
    def applied_org_wides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOrgWideArgs']]]]:
        """
        Permissions to be applied org wide.
        """
        return pulumi.get(self, "applied_org_wides")

    @applied_org_wides.setter
    def applied_org_wides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CameraRolesAppliedOrgWideArgs']]]]):
        pulumi.set(self, "applied_org_wides", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the new role. Must be unique. This parameter is required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        roleId path parameter. Role ID
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_id", value)


@pulumi.type_token("meraki:organizations/cameraRoles:CameraRoles")
class CameraRoles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applied_on_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOnDeviceArgs', 'CameraRolesAppliedOnDeviceArgsDict']]]]] = None,
                 applied_on_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOnNetworkArgs', 'CameraRolesAppliedOnNetworkArgsDict']]]]] = None,
                 applied_org_wides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOrgWideArgs', 'CameraRolesAppliedOrgWideArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:organizations/cameraRoles:CameraRoles example "organization_id,role_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOnDeviceArgs', 'CameraRolesAppliedOnDeviceArgsDict']]]] applied_on_devices: Device tag on which this specified permission is applied.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOnNetworkArgs', 'CameraRolesAppliedOnNetworkArgsDict']]]] applied_on_networks: Network tag on which this specified permission is applied.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOrgWideArgs', 'CameraRolesAppliedOrgWideArgsDict']]]] applied_org_wides: Permissions to be applied org wide.
        :param pulumi.Input[builtins.str] name: The name of the new role. Must be unique. This parameter is required.
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.str] role_id: roleId path parameter. Role ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CameraRolesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:organizations/cameraRoles:CameraRoles example "organization_id,role_id"
        ```

        :param str resource_name: The name of the resource.
        :param CameraRolesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CameraRolesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applied_on_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOnDeviceArgs', 'CameraRolesAppliedOnDeviceArgsDict']]]]] = None,
                 applied_on_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOnNetworkArgs', 'CameraRolesAppliedOnNetworkArgsDict']]]]] = None,
                 applied_org_wides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOrgWideArgs', 'CameraRolesAppliedOrgWideArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CameraRolesArgs.__new__(CameraRolesArgs)

            __props__.__dict__["applied_on_devices"] = applied_on_devices
            __props__.__dict__["applied_on_networks"] = applied_on_networks
            __props__.__dict__["applied_org_wides"] = applied_org_wides
            __props__.__dict__["name"] = name
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["role_id"] = role_id
        super(CameraRoles, __self__).__init__(
            'meraki:organizations/cameraRoles:CameraRoles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            applied_on_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOnDeviceArgs', 'CameraRolesAppliedOnDeviceArgsDict']]]]] = None,
            applied_on_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOnNetworkArgs', 'CameraRolesAppliedOnNetworkArgsDict']]]]] = None,
            applied_org_wides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOrgWideArgs', 'CameraRolesAppliedOrgWideArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            role_id: Optional[pulumi.Input[builtins.str]] = None) -> 'CameraRoles':
        """
        Get an existing CameraRoles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOnDeviceArgs', 'CameraRolesAppliedOnDeviceArgsDict']]]] applied_on_devices: Device tag on which this specified permission is applied.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOnNetworkArgs', 'CameraRolesAppliedOnNetworkArgsDict']]]] applied_on_networks: Network tag on which this specified permission is applied.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CameraRolesAppliedOrgWideArgs', 'CameraRolesAppliedOrgWideArgsDict']]]] applied_org_wides: Permissions to be applied org wide.
        :param pulumi.Input[builtins.str] name: The name of the new role. Must be unique. This parameter is required.
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.str] role_id: roleId path parameter. Role ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CameraRolesState.__new__(_CameraRolesState)

        __props__.__dict__["applied_on_devices"] = applied_on_devices
        __props__.__dict__["applied_on_networks"] = applied_on_networks
        __props__.__dict__["applied_org_wides"] = applied_org_wides
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["role_id"] = role_id
        return CameraRoles(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appliedOnDevices")
    def applied_on_devices(self) -> pulumi.Output[Sequence['outputs.CameraRolesAppliedOnDevice']]:
        """
        Device tag on which this specified permission is applied.
        """
        return pulumi.get(self, "applied_on_devices")

    @property
    @pulumi.getter(name="appliedOnNetworks")
    def applied_on_networks(self) -> pulumi.Output[Sequence['outputs.CameraRolesAppliedOnNetwork']]:
        """
        Network tag on which this specified permission is applied.
        """
        return pulumi.get(self, "applied_on_networks")

    @property
    @pulumi.getter(name="appliedOrgWides")
    def applied_org_wides(self) -> pulumi.Output[Sequence['outputs.CameraRolesAppliedOrgWide']]:
        """
        Permissions to be applied org wide.
        """
        return pulumi.get(self, "applied_org_wides")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the new role. Must be unique. This parameter is required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        roleId path parameter. Role ID
        """
        return pulumi.get(self, "role_id")

