# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/02_esm.ipynb (unless otherwise specified).

__all__ = ['batch_converter', 'naturalAAIndex', 'maskifySeq', 'getNatProbs', 'esmPredictionDF']

# Cell
import torch
import esm
import pandas as pd

# Cell
from berteome import berteomeDF

# Cell
model, alphabet = esm.pretrained.esm1b_t33_650M_UR50S()

# Cell
batch_converter = alphabet.get_batch_converter()

# Cell
def naturalAAIndex(aas):

    model_alphabet=alphabet.all_toks
    naturalAAIndices = []
    for aa in aas:
      naturalAAIndices.append(model_alphabet.index(aa))
    return naturalAAIndices

# Cell
def maskifySeq(seq, i):
    seqList = list(seq)
    seqList[i] = "<mask>"
    return seqList

# Cell
def getNatProbs(natAAList,probList):
    natProbList = []
    for natAAIndex in natAAList:
      natProbList.append(probList[natAAIndex])
    return natProbList

# Cell
def esmPredictionDF(seq, aas="ACDEFGHIKLMNPQRSTVWY"): # this should probably be a class where model/alphabet are declared??
    naturalAAIndices=naturalAAIndex(aas)
    esmPredDict = {}
    for wtIndex in range(len(seq)):
      maskSeq = maskifySeq(seq, wtIndex) # import from other module, ie seqtools.maskifySeq(), or not, maybe both classes should just be in the same module...
      data = [("protein1", maskSeq)]
      batch_labels, batch_strs, batch_tokens = batch_converter(data)
      with torch.no_grad():
        results = model(batch_tokens)
        logits = results['logits']
        prob = torch.softmax(logits,dim=2)
      esmPredDict[wtIndex] = [i.item() for i in getNatProbs(naturalAAIndices, prob[0, wtIndex +1])]
    esmPredDF = berteomeDF.modelPredDF(esmPredDict,seq, aas).predDf

    return esmPredDF