"""
    Securitized Derivatives API For Digital Portals

    Search for securitized derivative instruments, using a criteria-based screener. The API provides also fundamental data, notation-based key figures, list of barrier types, and details regarding the underlyings, their respective barriers and related cash flows, coupon lists and derived basic interest rate information.  The screener is based on securitized derivatives-specific parameters. The result is limited to the notations that satisfy all the selected filters. If more than one notation of an instrument matches the parameters, and no market priority has been specified, only the notation with the highest trading volume, averaged over one month, is considered. All identifier types used as parameters must be valid and application must have permissions for them.  Available search criteria include:  * validation: filter for only active listings, by price quality and latest/previous available price dates * traded markets: filter and indicate a market priority for the validation * life cycle: important dates in and features of the life cycle of the securitized derivatives instruments * filter by issuer, country of registration of the securitized derivatives * underlying and related barriers, including level and distance, and resulting cash flows * coupon data: where applicable, occurrence and frequency of coupon payments, current interest rate range * performance and volatility * product-specific ask-based key figures (not all key figures are available for all product types):     * bonus yield, sideways yield, maximum yield based on the ask price     * agio, discount     * spread     * break even, outperformance point, parity     * delta, weekly theta, vega, implied volatility     * leverage, omega     * intrinsic value, time value         Since some underlyings, e.g. an index or a performance difference of a stock and an index (alpha structure), do not represent a directly tradable asset, they do not have a price in the classical sense. Therefore, the term *level* is used instead of *price*, e.g. underlying level instead of underlying price. The endpoint does not support the search for securitized derivatives with multiple underlyings, thus only securitized derivatives with a single underlying are returned in the result.  The search can be restricted to a specific set of products by using customer-specific instrument or notation lists. Such restriction lists are set up by FactSet upon request.  This API is fully integrated with the corresponding [Quotes API](https://developer.factset.com/api-catalog/quotes-api-digital-portals), allowing access to detailed price and performance information of instruments, as well as basic security identifier cross-reference. For direct access to price histories, please refer to the [Time Series API for Digital Portals](https://developer.factset.com/api-catalog/time-series-api-digital-portals).  Similar criteria based screener APIs exist for equity and fixed income instruments: See the [Stocks API](https://developer.factset.com/api-catalog/stocks-api-digital-portals) and the [Bonds API](https://developer.factset.com/api-catalog/bonds-api-digital-portals) for details.    # noqa: E501

    The version of the OpenAPI document: 4.0.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.exceptions import ApiAttributeError


def lazy_import():
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.attributes_member import AttributesMember
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.language_member import LanguageMember
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_request_meta_pagination import PostSecuritizedDerivativeNotationScreenerSearchRequestMetaPagination
    globals()['AttributesMember'] = AttributesMember
    globals()['LanguageMember'] = LanguageMember
    globals()['PostSecuritizedDerivativeNotationScreenerSearchRequestMetaPagination'] = PostSecuritizedDerivativeNotationScreenerSearchRequestMetaPagination


class PostSecuritizedDerivativeNotationScreenerSearchRequestMeta(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('sort',): {
            'SYMBOL': "symbol",
            '-SYMBOL': "-symbol",
            'MARKET.NAME': "market.name",
            '-MARKET.NAME': "-market.name",
            'INSTRUMENT.NAME': "instrument.name",
            '-INSTRUMENT.NAME': "-instrument.name",
            'INSTRUMENT.SHORTNAME': "instrument.shortName",
            '-INSTRUMENT.SHORTNAME': "-instrument.shortName",
            'INSTRUMENT.CATEGORIZATION.DDV.LEVEL1.NAME': "instrument.categorization.ddv.level1.name",
            '-INSTRUMENT.CATEGORIZATION.DDV.LEVEL1.NAME': "-instrument.categorization.ddv.level1.name",
            'INSTRUMENT.CATEGORIZATION.DDV.LEVEL2.NAME': "instrument.categorization.ddv.level2.name",
            '-INSTRUMENT.CATEGORIZATION.DDV.LEVEL2.NAME': "-instrument.categorization.ddv.level2.name",
            'INSTRUMENT.CATEGORIZATION.DDV.LEVEL3.NAME': "instrument.categorization.ddv.level3.name",
            '-INSTRUMENT.CATEGORIZATION.DDV.LEVEL3.NAME': "-instrument.categorization.ddv.level3.name",
            'INSTRUMENT.CATEGORIZATION.EUSIPA.LEVEL1.NAME': "instrument.categorization.eusipa.level1.name",
            '-INSTRUMENT.CATEGORIZATION.EUSIPA.LEVEL1.NAME': "-instrument.categorization.eusipa.level1.name",
            'INSTRUMENT.CATEGORIZATION.EUSIPA.LEVEL2.NAME': "instrument.categorization.eusipa.level2.name",
            '-INSTRUMENT.CATEGORIZATION.EUSIPA.LEVEL2.NAME': "-instrument.categorization.eusipa.level2.name",
            'INSTRUMENT.CATEGORIZATION.EUSIPA.LEVEL3.NAME': "instrument.categorization.eusipa.level3.name",
            '-INSTRUMENT.CATEGORIZATION.EUSIPA.LEVEL3.NAME': "-instrument.categorization.eusipa.level3.name",
            'INSTRUMENT.LIFECYCLE.MATURITY.DATE': "instrument.lifeCycle.maturity.date",
            '-INSTRUMENT.LIFECYCLE.MATURITY.DATE': "-instrument.lifeCycle.maturity.date",
            'INSTRUMENT.LIFECYCLE.MATURITY.REMAININGTERMDAYS': "instrument.lifeCycle.maturity.remainingTermDays",
            '-INSTRUMENT.LIFECYCLE.MATURITY.REMAININGTERMDAYS': "-instrument.lifeCycle.maturity.remainingTermDays",
            'INSTRUMENT.LIFECYCLE.MATURITY.PERPETUAL': "instrument.lifeCycle.maturity.perpetual",
            '-INSTRUMENT.LIFECYCLE.MATURITY.PERPETUAL': "-instrument.lifeCycle.maturity.perpetual",
            'INSTRUMENT.LIFECYCLE.CALLABLE': "instrument.lifeCycle.callable",
            '-INSTRUMENT.LIFECYCLE.CALLABLE': "-instrument.lifeCycle.callable",
            'INSTRUMENT.LIFECYCLE.VALUATION': "instrument.lifeCycle.valuation",
            '-INSTRUMENT.LIFECYCLE.VALUATION': "-instrument.lifeCycle.valuation",
            'INSTRUMENT.LIFECYCLE.REPAYMENT': "instrument.lifeCycle.repayment",
            '-INSTRUMENT.LIFECYCLE.REPAYMENT': "-instrument.lifeCycle.repayment",
            'INSTRUMENT.ISSUER.NAME': "instrument.issuer.name",
            '-INSTRUMENT.ISSUER.NAME': "-instrument.issuer.name",
            'INSTRUMENT.ISSUER.GROUP.NAME': "instrument.issuer.group.name",
            '-INSTRUMENT.ISSUER.GROUP.NAME': "-instrument.issuer.group.name",
            'INSTRUMENT.EXERCISE.RIGHT': "instrument.exercise.right",
            '-INSTRUMENT.EXERCISE.RIGHT': "-instrument.exercise.right",
            'INSTRUMENT.EXERCISE.STYLE': "instrument.exercise.style",
            '-INSTRUMENT.EXERCISE.STYLE': "-instrument.exercise.style",
            'INSTRUMENT.SETTLEMENT': "instrument.settlement",
            '-INSTRUMENT.SETTLEMENT': "-instrument.settlement",
            'INSTRUMENT.QUANTO': "instrument.quanto",
            '-INSTRUMENT.QUANTO': "-instrument.quanto",
            'INSTRUMENT.CAPITALPROTECTION': "instrument.capitalProtection",
            '-INSTRUMENT.CAPITALPROTECTION': "-instrument.capitalProtection",
            'INSTRUMENT.UNDERLYING.NAME': "instrument.underlying.name",
            '-INSTRUMENT.UNDERLYING.NAME': "-instrument.underlying.name",
            'INSTRUMENT.UNDERLYING.VALUEUNIT.CODE': "instrument.underlying.valueUnit.code",
            '-INSTRUMENT.UNDERLYING.VALUEUNIT.CODE': "-instrument.underlying.valueUnit.code",
            'INSTRUMENT.UNDERLYING.NOTATION.INSTRUMENT.TYPECOMPOSITE': "instrument.underlying.notation.instrument.typeComposite",
            '-INSTRUMENT.UNDERLYING.NOTATION.INSTRUMENT.TYPECOMPOSITE': "-instrument.underlying.notation.instrument.typeComposite",
            'INSTRUMENT.STRIKE.VALUE': "instrument.strike.value",
            '-INSTRUMENT.STRIKE.VALUE': "-instrument.strike.value",
            'INSTRUMENT.STRIKE.DISTANCE.ABSOLUTE': "instrument.strike.distance.absolute",
            '-INSTRUMENT.STRIKE.DISTANCE.ABSOLUTE': "-instrument.strike.distance.absolute",
            'INSTRUMENT.STRIKE.DISTANCE.RELATIVE': "instrument.strike.distance.relative",
            '-INSTRUMENT.STRIKE.DISTANCE.RELATIVE': "-instrument.strike.distance.relative",
            'INSTRUMENT.BONUSLEVEL.VALUE': "instrument.bonusLevel.value",
            '-INSTRUMENT.BONUSLEVEL.VALUE': "-instrument.bonusLevel.value",
            'INSTRUMENT.BONUSLEVEL.DISTANCE.ABSOLUTE': "instrument.bonusLevel.distance.absolute",
            '-INSTRUMENT.BONUSLEVEL.DISTANCE.ABSOLUTE': "-instrument.bonusLevel.distance.absolute",
            'INSTRUMENT.BONUSLEVEL.DISTANCE.RELATIVE': "instrument.bonusLevel.distance.relative",
            '-INSTRUMENT.BONUSLEVEL.DISTANCE.RELATIVE': "-instrument.bonusLevel.distance.relative",
            'INSTRUMENT.CAP.VALUE': "instrument.cap.value",
            '-INSTRUMENT.CAP.VALUE': "-instrument.cap.value",
            'INSTRUMENT.CAP.DISTANCE.ABSOLUTE': "instrument.cap.distance.absolute",
            '-INSTRUMENT.CAP.DISTANCE.ABSOLUTE': "-instrument.cap.distance.absolute",
            'INSTRUMENT.CAP.DISTANCE.RELATIVE': "instrument.cap.distance.relative",
            '-INSTRUMENT.CAP.DISTANCE.RELATIVE': "-instrument.cap.distance.relative",
            'INSTRUMENT.CAP.CASHFLOW': "instrument.cap.cashFlow",
            '-INSTRUMENT.CAP.CASHFLOW': "-instrument.cap.cashFlow",
            'INSTRUMENT.KNOCKOUT.OBSERVATION.TYPE': "instrument.knockOut.observation.type",
            '-INSTRUMENT.KNOCKOUT.OBSERVATION.TYPE': "-instrument.knockOut.observation.type",
            'INSTRUMENT.KNOCKOUT.VALUE': "instrument.knockOut.value",
            '-INSTRUMENT.KNOCKOUT.VALUE': "-instrument.knockOut.value",
            'INSTRUMENT.KNOCKOUT.DISTANCE.ABSOLUTE': "instrument.knockOut.distance.absolute",
            '-INSTRUMENT.KNOCKOUT.DISTANCE.ABSOLUTE': "-instrument.knockOut.distance.absolute",
            'INSTRUMENT.KNOCKOUT.DISTANCE.RELATIVE': "instrument.knockOut.distance.relative",
            '-INSTRUMENT.KNOCKOUT.DISTANCE.RELATIVE': "-instrument.knockOut.distance.relative",
            'INSTRUMENT.KNOCKOUT.BREACH.BREACHED': "instrument.knockOut.breach.breached",
            '-INSTRUMENT.KNOCKOUT.BREACH.BREACHED': "-instrument.knockOut.breach.breached",
            'INSTRUMENT.KNOCKOUT.BREACH.DATETIME': "instrument.knockOut.breach.datetime",
            '-INSTRUMENT.KNOCKOUT.BREACH.DATETIME': "-instrument.knockOut.breach.datetime",
            'INSTRUMENT.KNOCKIN.OBSERVATION.TYPE': "instrument.knockIn.observation.type",
            '-INSTRUMENT.KNOCKIN.OBSERVATION.TYPE': "-instrument.knockIn.observation.type",
            'INSTRUMENT.KNOCKIN.VALUE': "instrument.knockIn.value",
            '-INSTRUMENT.KNOCKIN.VALUE': "-instrument.knockIn.value",
            'INSTRUMENT.KNOCKIN.DISTANCE.ABSOLUTE': "instrument.knockIn.distance.absolute",
            '-INSTRUMENT.KNOCKIN.DISTANCE.ABSOLUTE': "-instrument.knockIn.distance.absolute",
            'INSTRUMENT.KNOCKIN.DISTANCE.RELATIVE': "instrument.knockIn.distance.relative",
            '-INSTRUMENT.KNOCKIN.DISTANCE.RELATIVE': "-instrument.knockIn.distance.relative",
            'INSTRUMENT.KNOCKIN.BREACH.BREACHED': "instrument.knockIn.breach.breached",
            '-INSTRUMENT.KNOCKIN.BREACH.BREACHED': "-instrument.knockIn.breach.breached",
            'INSTRUMENT.KNOCKIN.BREACH.DATETIME': "instrument.knockIn.breach.datetime",
            '-INSTRUMENT.KNOCKIN.BREACH.DATETIME': "-instrument.knockIn.breach.datetime",
            'INSTRUMENT.LOCKOUT.OBSERVATION.TYPE': "instrument.lockOut.observation.type",
            '-INSTRUMENT.LOCKOUT.OBSERVATION.TYPE': "-instrument.lockOut.observation.type",
            'INSTRUMENT.LOCKOUT.VALUE': "instrument.lockOut.value",
            '-INSTRUMENT.LOCKOUT.VALUE': "-instrument.lockOut.value",
            'INSTRUMENT.LOCKOUT.DISTANCE.ABSOLUTE': "instrument.lockOut.distance.absolute",
            '-INSTRUMENT.LOCKOUT.DISTANCE.ABSOLUTE': "-instrument.lockOut.distance.absolute",
            'INSTRUMENT.LOCKOUT.DISTANCE.RELATIVE': "instrument.lockOut.distance.relative",
            '-INSTRUMENT.LOCKOUT.DISTANCE.RELATIVE': "-instrument.lockOut.distance.relative",
            'INSTRUMENT.LOCKOUT.CASHFLOW': "instrument.lockOut.cashFlow",
            '-INSTRUMENT.LOCKOUT.CASHFLOW': "-instrument.lockOut.cashFlow",
            'INSTRUMENT.LOCKIN.OBSERVATION.TYPE': "instrument.lockIn.observation.type",
            '-INSTRUMENT.LOCKIN.OBSERVATION.TYPE': "-instrument.lockIn.observation.type",
            'INSTRUMENT.LOCKIN.VALUE': "instrument.lockIn.value",
            '-INSTRUMENT.LOCKIN.VALUE': "-instrument.lockIn.value",
            'INSTRUMENT.LOCKIN.DISTANCE.ABSOLUTE': "instrument.lockIn.distance.absolute",
            '-INSTRUMENT.LOCKIN.DISTANCE.ABSOLUTE': "-instrument.lockIn.distance.absolute",
            'INSTRUMENT.LOCKIN.DISTANCE.RELATIVE': "instrument.lockIn.distance.relative",
            '-INSTRUMENT.LOCKIN.DISTANCE.RELATIVE': "-instrument.lockIn.distance.relative",
            'INSTRUMENT.LOCKIN.CASHFLOW': "instrument.lockIn.cashFlow",
            '-INSTRUMENT.LOCKIN.CASHFLOW': "-instrument.lockIn.cashFlow",
            'INSTRUMENT.CAPITALGUARANTEE.VALUE': "instrument.capitalGuarantee.value",
            '-INSTRUMENT.CAPITALGUARANTEE.VALUE': "-instrument.capitalGuarantee.value",
            'INSTRUMENT.CAPITALGUARANTEE.DISTANCE.ABSOLUTE': "instrument.capitalGuarantee.distance.absolute",
            '-INSTRUMENT.CAPITALGUARANTEE.DISTANCE.ABSOLUTE': "-instrument.capitalGuarantee.distance.absolute",
            'INSTRUMENT.CAPITALGUARANTEE.DISTANCE.RELATIVE': "instrument.capitalGuarantee.distance.relative",
            '-INSTRUMENT.CAPITALGUARANTEE.DISTANCE.RELATIVE': "-instrument.capitalGuarantee.distance.relative",
            'INSTRUMENT.CAPITALGUARANTEE.CASHFLOW': "instrument.capitalGuarantee.cashFlow",
            '-INSTRUMENT.CAPITALGUARANTEE.CASHFLOW': "-instrument.capitalGuarantee.cashFlow",
            'INSTRUMENT.COUPONTRIGGERLEVEL.VALUE': "instrument.couponTriggerLevel.value",
            '-INSTRUMENT.COUPONTRIGGERLEVEL.VALUE': "-instrument.couponTriggerLevel.value",
            'INSTRUMENT.COUPONTRIGGERLEVEL.DISTANCE.ABSOLUTE': "instrument.couponTriggerLevel.distance.absolute",
            '-INSTRUMENT.COUPONTRIGGERLEVEL.DISTANCE.ABSOLUTE': "-instrument.couponTriggerLevel.distance.absolute",
            'INSTRUMENT.COUPONTRIGGERLEVEL.DISTANCE.RELATIVE': "instrument.couponTriggerLevel.distance.relative",
            '-INSTRUMENT.COUPONTRIGGERLEVEL.DISTANCE.RELATIVE': "-instrument.couponTriggerLevel.distance.relative",
            'INSTRUMENT.COUPONTRIGGERLEVEL.CASHFLOW': "instrument.couponTriggerLevel.cashFlow",
            '-INSTRUMENT.COUPONTRIGGERLEVEL.CASHFLOW': "-instrument.couponTriggerLevel.cashFlow",
            'INSTRUMENT.RANGEKNOCKOUT.OBSERVATION.TYPE': "instrument.rangeKnockOut.observation.type",
            '-INSTRUMENT.RANGEKNOCKOUT.OBSERVATION.TYPE': "-instrument.rangeKnockOut.observation.type",
            'INSTRUMENT.RANGEKNOCKOUT.UPPER.VALUE': "instrument.rangeKnockOut.upper.value",
            '-INSTRUMENT.RANGEKNOCKOUT.UPPER.VALUE': "-instrument.rangeKnockOut.upper.value",
            'INSTRUMENT.RANGEKNOCKOUT.LOWER.VALUE': "instrument.rangeKnockOut.lower.value",
            '-INSTRUMENT.RANGEKNOCKOUT.LOWER.VALUE': "-instrument.rangeKnockOut.lower.value",
            'INSTRUMENT.RANGEKNOCKOUT.BREACH.BREACHED': "instrument.rangeKnockOut.breach.breached",
            '-INSTRUMENT.RANGEKNOCKOUT.BREACH.BREACHED': "-instrument.rangeKnockOut.breach.breached",
            'INSTRUMENT.RANGEKNOCKOUT.BREACH.DATETIME': "instrument.rangeKnockOut.breach.datetime",
            '-INSTRUMENT.RANGEKNOCKOUT.BREACH.DATETIME': "-instrument.rangeKnockOut.breach.datetime",
            'INSTRUMENT.RANGEKNOCKOUT.CASHFLOW': "instrument.rangeKnockOut.cashFlow",
            '-INSTRUMENT.RANGEKNOCKOUT.CASHFLOW': "-instrument.rangeKnockOut.cashFlow",
            'INSTRUMENT.PARTICIPATION': "instrument.participation",
            '-INSTRUMENT.PARTICIPATION': "-instrument.participation",
            'INSTRUMENT.CONSTANTLEVERAGE': "instrument.constantLeverage",
            '-INSTRUMENT.CONSTANTLEVERAGE': "-instrument.constantLeverage",
            'INSTRUMENT.NOMINALCURRENCY.ISOCODE': "instrument.nominalCurrency.isoCode",
            '-INSTRUMENT.NOMINALCURRENCY.ISOCODE': "-instrument.nominalCurrency.isoCode",
            'INSTRUMENT.CURRENTINTERESTRATE.TYPE': "instrument.currentInterestRate.type",
            '-INSTRUMENT.CURRENTINTERESTRATE.TYPE': "-instrument.currentInterestRate.type",
            'INSTRUMENT.CURRENTINTERESTRATE.VALUE': "instrument.currentInterestRate.value",
            '-INSTRUMENT.CURRENTINTERESTRATE.VALUE': "-instrument.currentInterestRate.value",
            'KEYFIGURES.BONUSYIELD.ABSOLUTE': "keyFigures.bonusYield.absolute",
            '-KEYFIGURES.BONUSYIELD.ABSOLUTE': "-keyFigures.bonusYield.absolute",
            'KEYFIGURES.BONUSYIELD.RELATIVE': "keyFigures.bonusYield.relative",
            '-KEYFIGURES.BONUSYIELD.RELATIVE': "-keyFigures.bonusYield.relative",
            'KEYFIGURES.BONUSYIELD.ANNUALIZED': "keyFigures.bonusYield.annualized",
            '-KEYFIGURES.BONUSYIELD.ANNUALIZED': "-keyFigures.bonusYield.annualized",
            'KEYFIGURES.SIDEWAYSYIELD.ABSOLUTE': "keyFigures.sidewaysYield.absolute",
            '-KEYFIGURES.SIDEWAYSYIELD.ABSOLUTE': "-keyFigures.sidewaysYield.absolute",
            'KEYFIGURES.SIDEWAYSYIELD.RELATIVE': "keyFigures.sidewaysYield.relative",
            '-KEYFIGURES.SIDEWAYSYIELD.RELATIVE': "-keyFigures.sidewaysYield.relative",
            'KEYFIGURES.SIDEWAYSYIELD.ANNUALIZED': "keyFigures.sidewaysYield.annualized",
            '-KEYFIGURES.SIDEWAYSYIELD.ANNUALIZED': "-keyFigures.sidewaysYield.annualized",
            'KEYFIGURES.MAXIMUMYIELD.ABSOLUTE': "keyFigures.maximumYield.absolute",
            '-KEYFIGURES.MAXIMUMYIELD.ABSOLUTE': "-keyFigures.maximumYield.absolute",
            'KEYFIGURES.MAXIMUMYIELD.RELATIVE': "keyFigures.maximumYield.relative",
            '-KEYFIGURES.MAXIMUMYIELD.RELATIVE': "-keyFigures.maximumYield.relative",
            'KEYFIGURES.MAXIMUMYIELD.ANNUALIZED': "keyFigures.maximumYield.annualized",
            '-KEYFIGURES.MAXIMUMYIELD.ANNUALIZED': "-keyFigures.maximumYield.annualized",
            'KEYFIGURES.AGIO.ABSOLUTE': "keyFigures.agio.absolute",
            '-KEYFIGURES.AGIO.ABSOLUTE': "-keyFigures.agio.absolute",
            'KEYFIGURES.AGIO.RELATIVE': "keyFigures.agio.relative",
            '-KEYFIGURES.AGIO.RELATIVE': "-keyFigures.agio.relative",
            'KEYFIGURES.AGIO.ANNUALIZED': "keyFigures.agio.annualized",
            '-KEYFIGURES.AGIO.ANNUALIZED': "-keyFigures.agio.annualized",
            'KEYFIGURES.DISCOUNT.ABSOLUTE': "keyFigures.discount.absolute",
            '-KEYFIGURES.DISCOUNT.ABSOLUTE': "-keyFigures.discount.absolute",
            'KEYFIGURES.DISCOUNT.RELATIVE': "keyFigures.discount.relative",
            '-KEYFIGURES.DISCOUNT.RELATIVE': "-keyFigures.discount.relative",
            'KEYFIGURES.BREAKEVEN.BREAKEVENPOINT': "keyFigures.breakEven.breakEvenPoint",
            '-KEYFIGURES.BREAKEVEN.BREAKEVENPOINT': "-keyFigures.breakEven.breakEvenPoint",
            'KEYFIGURES.SPREAD.HARMONIZED': "keyFigures.spread.harmonized",
            '-KEYFIGURES.SPREAD.HARMONIZED': "-keyFigures.spread.harmonized",
            'KEYFIGURES.SPREAD.RELATIVE': "keyFigures.spread.relative",
            '-KEYFIGURES.SPREAD.RELATIVE': "-keyFigures.spread.relative",
            'KEYFIGURES.DELTA.EFFECTIVE': "keyFigures.delta.effective",
            '-KEYFIGURES.DELTA.EFFECTIVE': "-keyFigures.delta.effective",
            'KEYFIGURES.DELTA.UNADJUSTED': "keyFigures.delta.unadjusted",
            '-KEYFIGURES.DELTA.UNADJUSTED': "-keyFigures.delta.unadjusted",
            'KEYFIGURES.THETAONEWEEK.EFFECTIVE': "keyFigures.thetaOneWeek.effective",
            '-KEYFIGURES.THETAONEWEEK.EFFECTIVE': "-keyFigures.thetaOneWeek.effective",
            'KEYFIGURES.THETAONEWEEK.UNADJUSTED': "keyFigures.thetaOneWeek.unadjusted",
            '-KEYFIGURES.THETAONEWEEK.UNADJUSTED': "-keyFigures.thetaOneWeek.unadjusted",
            'KEYFIGURES.VEGA.EFFECTIVE': "keyFigures.vega.effective",
            '-KEYFIGURES.VEGA.EFFECTIVE': "-keyFigures.vega.effective",
            'KEYFIGURES.VEGA.UNADJUSTED': "keyFigures.vega.unadjusted",
            '-KEYFIGURES.VEGA.UNADJUSTED': "-keyFigures.vega.unadjusted",
            'KEYFIGURES.LEVERAGE': "keyFigures.leverage",
            '-KEYFIGURES.LEVERAGE': "-keyFigures.leverage",
            'KEYFIGURES.OMEGA': "keyFigures.omega",
            '-KEYFIGURES.OMEGA': "-keyFigures.omega",
            'KEYFIGURES.IMPLIEDVOLATILITY': "keyFigures.impliedVolatility",
            '-KEYFIGURES.IMPLIEDVOLATILITY': "-keyFigures.impliedVolatility",
            'KEYFIGURES.INTRINSICVALUE': "keyFigures.intrinsicValue",
            '-KEYFIGURES.INTRINSICVALUE': "-keyFigures.intrinsicValue",
            'KEYFIGURES.TIMEVALUE': "keyFigures.timeValue",
            '-KEYFIGURES.TIMEVALUE': "-keyFigures.timeValue",
            'KEYFIGURES.OUTPERFORMANCEPOINT': "keyFigures.outperformancePoint",
            '-KEYFIGURES.OUTPERFORMANCEPOINT': "-keyFigures.outperformancePoint",
            'KEYFIGURES.PARITY': "keyFigures.parity",
            '-KEYFIGURES.PARITY': "-keyFigures.parity",
            'PERFORMANCE.INTRADAY': "performance.intraday",
            '-PERFORMANCE.INTRADAY': "-performance.intraday",
            'PERFORMANCE.SINCEISSUE.ASK': "performance.sinceIssue.ask",
            '-PERFORMANCE.SINCEISSUE.ASK': "-performance.sinceIssue.ask",
            'PERFORMANCE.SINCEISSUE.BID': "performance.sinceIssue.bid",
            '-PERFORMANCE.SINCEISSUE.BID': "-performance.sinceIssue.bid",
            'PERFORMANCE.ENDOFDAY.DAY1': "performance.endOfDay.day1",
            '-PERFORMANCE.ENDOFDAY.DAY1': "-performance.endOfDay.day1",
            'PERFORMANCE.ENDOFDAY.WEEK1': "performance.endOfDay.week1",
            '-PERFORMANCE.ENDOFDAY.WEEK1': "-performance.endOfDay.week1",
            'PERFORMANCE.ENDOFDAY.MONTH1': "performance.endOfDay.month1",
            '-PERFORMANCE.ENDOFDAY.MONTH1': "-performance.endOfDay.month1",
            'PERFORMANCE.ENDOFDAY.MONTHS3': "performance.endOfDay.months3",
            '-PERFORMANCE.ENDOFDAY.MONTHS3': "-performance.endOfDay.months3",
            'PERFORMANCE.ENDOFDAY.MONTHS6': "performance.endOfDay.months6",
            '-PERFORMANCE.ENDOFDAY.MONTHS6': "-performance.endOfDay.months6",
            'PERFORMANCE.ENDOFDAY.YEAR1': "performance.endOfDay.year1",
            '-PERFORMANCE.ENDOFDAY.YEAR1': "-performance.endOfDay.year1",
            'PERFORMANCE.ENDOFDAY.YEARS3': "performance.endOfDay.years3",
            '-PERFORMANCE.ENDOFDAY.YEARS3': "-performance.endOfDay.years3",
            'PERFORMANCE.ENDOFDAY.YEARS5': "performance.endOfDay.years5",
            '-PERFORMANCE.ENDOFDAY.YEARS5': "-performance.endOfDay.years5",
            'PERFORMANCE.ENDOFDAY.YEARTODATE': "performance.endOfDay.yearToDate",
            '-PERFORMANCE.ENDOFDAY.YEARTODATE': "-performance.endOfDay.yearToDate",
            'VOLATILITY.WEEK1': "volatility.week1",
            '-VOLATILITY.WEEK1': "-volatility.week1",
            'VOLATILITY.MONTH1': "volatility.month1",
            '-VOLATILITY.MONTH1': "-volatility.month1",
            'VOLATILITY.MONTHS3': "volatility.months3",
            '-VOLATILITY.MONTHS3': "-volatility.months3",
            'VOLATILITY.MONTHS6': "volatility.months6",
            '-VOLATILITY.MONTHS6': "-volatility.months6",
            'VOLATILITY.YEAR1': "volatility.year1",
            '-VOLATILITY.YEAR1': "-volatility.year1",
            'VOLATILITY.YEARS3': "volatility.years3",
            '-VOLATILITY.YEARS3': "-volatility.years3",
            'VOLATILITY.YEARS5': "volatility.years5",
            '-VOLATILITY.YEARS5': "-volatility.years5",
            'VOLATILITY.YEARTODATE': "volatility.yearToDate",
            '-VOLATILITY.YEARTODATE': "-volatility.yearToDate",


        },
    }

    validations = {
        ('sort',): {
            'max_items': 10,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'attributes': (AttributesMember,),  # noqa: E501
            'language': (LanguageMember,),  # noqa: E501
            'sort': ([str],),  # noqa: E501
            'pagination': (PostSecuritizedDerivativeNotationScreenerSearchRequestMetaPagination,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'attributes': 'attributes',  # noqa: E501
        'language': 'language',  # noqa: E501
        'sort': 'sort',  # noqa: E501
        'pagination': 'pagination',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """PostSecuritizedDerivativeNotationScreenerSearchRequestMeta - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            attributes (AttributesMember): [optional]  # noqa: E501
            language (LanguageMember): [optional]  # noqa: E501
            sort ([str]): Sortable attributes. The sort order is ascending unless it is prefixed with a minus sign, in which case it is descending. A list of at most 10 (possibly prefixed) attribute name(s) is allowed. | Value | | --- | | symbol | | -symbol | | market.name | | -market.name | | instrument.name | | -instrument.name | | instrument.shortName | | -instrument.shortName | | instrument.categorization.ddv.level1.name | | -instrument.categorization.ddv.level1.name | | instrument.categorization.ddv.level2.name | | -instrument.categorization.ddv.level2.name | | instrument.categorization.ddv.level3.name | | -instrument.categorization.ddv.level3.name | | instrument.categorization.eusipa.level1.name | | -instrument.categorization.eusipa.level1.name | | instrument.categorization.eusipa.level2.name | | -instrument.categorization.eusipa.level2.name | | instrument.categorization.eusipa.level3.name | | -instrument.categorization.eusipa.level3.name | | instrument.lifeCycle.maturity.date | | -instrument.lifeCycle.maturity.date | | instrument.lifeCycle.maturity.remainingTermDays | | -instrument.lifeCycle.maturity.remainingTermDays | | instrument.lifeCycle.maturity.perpetual | | -instrument.lifeCycle.maturity.perpetual | | instrument.lifeCycle.callable | | -instrument.lifeCycle.callable | | instrument.lifeCycle.valuation | | -instrument.lifeCycle.valuation | | instrument.lifeCycle.repayment | | -instrument.lifeCycle.repayment | | instrument.issuer.name | | -instrument.issuer.name | | instrument.issuer.group.name | | -instrument.issuer.group.name | | instrument.exercise.right | | -instrument.exercise.right | | instrument.exercise.style | | -instrument.exercise.style | | instrument.settlement | | -instrument.settlement | | instrument.quanto | | -instrument.quanto | | instrument.capitalProtection | | -instrument.capitalProtection | | instrument.underlying.name | | -instrument.underlying.name | | instrument.underlying.valueUnit.code | | -instrument.underlying.valueUnit.code | | instrument.underlying.notation.instrument.typeComposite | | -instrument.underlying.notation.instrument.typeComposite | | instrument.strike.value | | -instrument.strike.value | | instrument.strike.distance.absolute | | -instrument.strike.distance.absolute | | instrument.strike.distance.relative | | -instrument.strike.distance.relative | | instrument.bonusLevel.value | | -instrument.bonusLevel.value | | instrument.bonusLevel.distance.absolute | | -instrument.bonusLevel.distance.absolute | | instrument.bonusLevel.distance.relative | | -instrument.bonusLevel.distance.relative | | instrument.cap.value | | -instrument.cap.value | | instrument.cap.distance.absolute | | -instrument.cap.distance.absolute | | instrument.cap.distance.relative | | -instrument.cap.distance.relative | | instrument.cap.cashFlow | | -instrument.cap.cashFlow | | instrument.knockOut.observation.type | | -instrument.knockOut.observation.type | | instrument.knockOut.value | | -instrument.knockOut.value | | instrument.knockOut.distance.absolute | | -instrument.knockOut.distance.absolute | | instrument.knockOut.distance.relative | | -instrument.knockOut.distance.relative | | instrument.knockOut.breach.breached | | -instrument.knockOut.breach.breached | | instrument.knockOut.breach.datetime | | -instrument.knockOut.breach.datetime | | instrument.knockIn.observation.type | | -instrument.knockIn.observation.type | | instrument.knockIn.value | | -instrument.knockIn.value | | instrument.knockIn.distance.absolute | | -instrument.knockIn.distance.absolute | | instrument.knockIn.distance.relative | | -instrument.knockIn.distance.relative | | instrument.knockIn.breach.breached | | -instrument.knockIn.breach.breached | | instrument.knockIn.breach.datetime | | -instrument.knockIn.breach.datetime | | instrument.lockOut.observation.type | | -instrument.lockOut.observation.type | | instrument.lockOut.value | | -instrument.lockOut.value | | instrument.lockOut.distance.absolute | | -instrument.lockOut.distance.absolute | | instrument.lockOut.distance.relative | | -instrument.lockOut.distance.relative | | instrument.lockOut.cashFlow | | -instrument.lockOut.cashFlow | | instrument.lockIn.observation.type | | -instrument.lockIn.observation.type | | instrument.lockIn.value | | -instrument.lockIn.value | | instrument.lockIn.distance.absolute | | -instrument.lockIn.distance.absolute | | instrument.lockIn.distance.relative | | -instrument.lockIn.distance.relative | | instrument.lockIn.cashFlow | | -instrument.lockIn.cashFlow | | instrument.capitalGuarantee.value | | -instrument.capitalGuarantee.value | | instrument.capitalGuarantee.distance.absolute | | -instrument.capitalGuarantee.distance.absolute | | instrument.capitalGuarantee.distance.relative | | -instrument.capitalGuarantee.distance.relative | | instrument.capitalGuarantee.cashFlow | | -instrument.capitalGuarantee.cashFlow | | instrument.couponTriggerLevel.value | | -instrument.couponTriggerLevel.value | | instrument.couponTriggerLevel.distance.absolute | | -instrument.couponTriggerLevel.distance.absolute | | instrument.couponTriggerLevel.distance.relative | | -instrument.couponTriggerLevel.distance.relative | | instrument.couponTriggerLevel.cashFlow | | -instrument.couponTriggerLevel.cashFlow | | instrument.rangeKnockOut.observation.type | | -instrument.rangeKnockOut.observation.type | | instrument.rangeKnockOut.upper.value | | -instrument.rangeKnockOut.upper.value | | instrument.rangeKnockOut.lower.value | | -instrument.rangeKnockOut.lower.value | | instrument.rangeKnockOut.breach.breached | | -instrument.rangeKnockOut.breach.breached | | instrument.rangeKnockOut.breach.datetime | | -instrument.rangeKnockOut.breach.datetime | | instrument.rangeKnockOut.cashFlow | | -instrument.rangeKnockOut.cashFlow | | instrument.participation | | -instrument.participation | | instrument.constantLeverage | | -instrument.constantLeverage | | instrument.nominalCurrency.isoCode | | -instrument.nominalCurrency.isoCode | | instrument.currentInterestRate.type | | -instrument.currentInterestRate.type | | instrument.currentInterestRate.value | | -instrument.currentInterestRate.value | | keyFigures.bonusYield.absolute | | -keyFigures.bonusYield.absolute | | keyFigures.bonusYield.relative | | -keyFigures.bonusYield.relative | | keyFigures.bonusYield.annualized | | -keyFigures.bonusYield.annualized | | keyFigures.sidewaysYield.absolute | | -keyFigures.sidewaysYield.absolute | | keyFigures.sidewaysYield.relative | | -keyFigures.sidewaysYield.relative | | keyFigures.sidewaysYield.annualized | | -keyFigures.sidewaysYield.annualized | | keyFigures.maximumYield.absolute | | -keyFigures.maximumYield.absolute | | keyFigures.maximumYield.relative | | -keyFigures.maximumYield.relative | | keyFigures.maximumYield.annualized | | -keyFigures.maximumYield.annualized | | keyFigures.agio.absolute | | -keyFigures.agio.absolute | | keyFigures.agio.relative | | -keyFigures.agio.relative | | keyFigures.agio.annualized | | -keyFigures.agio.annualized | | keyFigures.discount.absolute | | -keyFigures.discount.absolute | | keyFigures.discount.relative | | -keyFigures.discount.relative | | keyFigures.breakEven.breakEvenPoint | | -keyFigures.breakEven.breakEvenPoint | | keyFigures.spread.harmonized | | -keyFigures.spread.harmonized | | keyFigures.spread.relative | | -keyFigures.spread.relative | | keyFigures.delta.effective | | -keyFigures.delta.effective | | keyFigures.delta.unadjusted | | -keyFigures.delta.unadjusted | | keyFigures.thetaOneWeek.effective | | -keyFigures.thetaOneWeek.effective | | keyFigures.thetaOneWeek.unadjusted | | -keyFigures.thetaOneWeek.unadjusted | | keyFigures.vega.effective | | -keyFigures.vega.effective | | keyFigures.vega.unadjusted | | -keyFigures.vega.unadjusted | | keyFigures.leverage | | -keyFigures.leverage | | keyFigures.omega | | -keyFigures.omega | | keyFigures.impliedVolatility | | -keyFigures.impliedVolatility | | keyFigures.intrinsicValue | | -keyFigures.intrinsicValue | | keyFigures.timeValue | | -keyFigures.timeValue | | keyFigures.outperformancePoint | | -keyFigures.outperformancePoint | | keyFigures.parity | | -keyFigures.parity | | performance.intraday | | -performance.intraday | | performance.sinceIssue.ask | | -performance.sinceIssue.ask | | performance.sinceIssue.bid | | -performance.sinceIssue.bid | | performance.endOfDay.day1 | | -performance.endOfDay.day1 | | performance.endOfDay.week1 | | -performance.endOfDay.week1 | | performance.endOfDay.month1 | | -performance.endOfDay.month1 | | performance.endOfDay.months3 | | -performance.endOfDay.months3 | | performance.endOfDay.months6 | | -performance.endOfDay.months6 | | performance.endOfDay.year1 | | -performance.endOfDay.year1 | | performance.endOfDay.years3 | | -performance.endOfDay.years3 | | performance.endOfDay.years5 | | -performance.endOfDay.years5 | | performance.endOfDay.yearToDate | | -performance.endOfDay.yearToDate | | volatility.week1 | | -volatility.week1 | | volatility.month1 | | -volatility.month1 | | volatility.months3 | | -volatility.months3 | | volatility.months6 | | -volatility.months6 | | volatility.year1 | | -volatility.year1 | | volatility.years3 | | -volatility.years3 | | volatility.years5 | | -volatility.years5 | | volatility.yearToDate | | -volatility.yearToDate |  . [optional] if omitted the server will use the default value of ["inSortEnumument.name"]  # noqa: E501
            pagination (PostSecuritizedDerivativeNotationScreenerSearchRequestMetaPagination): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """PostSecuritizedDerivativeNotationScreenerSearchRequestMeta - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            attributes (AttributesMember): [optional]  # noqa: E501
            language (LanguageMember): [optional]  # noqa: E501
            sort ([str]): Sortable attributes. The sort order is ascending unless it is prefixed with a minus sign, in which case it is descending. A list of at most 10 (possibly prefixed) attribute name(s) is allowed. | Value | | --- | | symbol | | -symbol | | market.name | | -market.name | | instrument.name | | -instrument.name | | instrument.shortName | | -instrument.shortName | | instrument.categorization.ddv.level1.name | | -instrument.categorization.ddv.level1.name | | instrument.categorization.ddv.level2.name | | -instrument.categorization.ddv.level2.name | | instrument.categorization.ddv.level3.name | | -instrument.categorization.ddv.level3.name | | instrument.categorization.eusipa.level1.name | | -instrument.categorization.eusipa.level1.name | | instrument.categorization.eusipa.level2.name | | -instrument.categorization.eusipa.level2.name | | instrument.categorization.eusipa.level3.name | | -instrument.categorization.eusipa.level3.name | | instrument.lifeCycle.maturity.date | | -instrument.lifeCycle.maturity.date | | instrument.lifeCycle.maturity.remainingTermDays | | -instrument.lifeCycle.maturity.remainingTermDays | | instrument.lifeCycle.maturity.perpetual | | -instrument.lifeCycle.maturity.perpetual | | instrument.lifeCycle.callable | | -instrument.lifeCycle.callable | | instrument.lifeCycle.valuation | | -instrument.lifeCycle.valuation | | instrument.lifeCycle.repayment | | -instrument.lifeCycle.repayment | | instrument.issuer.name | | -instrument.issuer.name | | instrument.issuer.group.name | | -instrument.issuer.group.name | | instrument.exercise.right | | -instrument.exercise.right | | instrument.exercise.style | | -instrument.exercise.style | | instrument.settlement | | -instrument.settlement | | instrument.quanto | | -instrument.quanto | | instrument.capitalProtection | | -instrument.capitalProtection | | instrument.underlying.name | | -instrument.underlying.name | | instrument.underlying.valueUnit.code | | -instrument.underlying.valueUnit.code | | instrument.underlying.notation.instrument.typeComposite | | -instrument.underlying.notation.instrument.typeComposite | | instrument.strike.value | | -instrument.strike.value | | instrument.strike.distance.absolute | | -instrument.strike.distance.absolute | | instrument.strike.distance.relative | | -instrument.strike.distance.relative | | instrument.bonusLevel.value | | -instrument.bonusLevel.value | | instrument.bonusLevel.distance.absolute | | -instrument.bonusLevel.distance.absolute | | instrument.bonusLevel.distance.relative | | -instrument.bonusLevel.distance.relative | | instrument.cap.value | | -instrument.cap.value | | instrument.cap.distance.absolute | | -instrument.cap.distance.absolute | | instrument.cap.distance.relative | | -instrument.cap.distance.relative | | instrument.cap.cashFlow | | -instrument.cap.cashFlow | | instrument.knockOut.observation.type | | -instrument.knockOut.observation.type | | instrument.knockOut.value | | -instrument.knockOut.value | | instrument.knockOut.distance.absolute | | -instrument.knockOut.distance.absolute | | instrument.knockOut.distance.relative | | -instrument.knockOut.distance.relative | | instrument.knockOut.breach.breached | | -instrument.knockOut.breach.breached | | instrument.knockOut.breach.datetime | | -instrument.knockOut.breach.datetime | | instrument.knockIn.observation.type | | -instrument.knockIn.observation.type | | instrument.knockIn.value | | -instrument.knockIn.value | | instrument.knockIn.distance.absolute | | -instrument.knockIn.distance.absolute | | instrument.knockIn.distance.relative | | -instrument.knockIn.distance.relative | | instrument.knockIn.breach.breached | | -instrument.knockIn.breach.breached | | instrument.knockIn.breach.datetime | | -instrument.knockIn.breach.datetime | | instrument.lockOut.observation.type | | -instrument.lockOut.observation.type | | instrument.lockOut.value | | -instrument.lockOut.value | | instrument.lockOut.distance.absolute | | -instrument.lockOut.distance.absolute | | instrument.lockOut.distance.relative | | -instrument.lockOut.distance.relative | | instrument.lockOut.cashFlow | | -instrument.lockOut.cashFlow | | instrument.lockIn.observation.type | | -instrument.lockIn.observation.type | | instrument.lockIn.value | | -instrument.lockIn.value | | instrument.lockIn.distance.absolute | | -instrument.lockIn.distance.absolute | | instrument.lockIn.distance.relative | | -instrument.lockIn.distance.relative | | instrument.lockIn.cashFlow | | -instrument.lockIn.cashFlow | | instrument.capitalGuarantee.value | | -instrument.capitalGuarantee.value | | instrument.capitalGuarantee.distance.absolute | | -instrument.capitalGuarantee.distance.absolute | | instrument.capitalGuarantee.distance.relative | | -instrument.capitalGuarantee.distance.relative | | instrument.capitalGuarantee.cashFlow | | -instrument.capitalGuarantee.cashFlow | | instrument.couponTriggerLevel.value | | -instrument.couponTriggerLevel.value | | instrument.couponTriggerLevel.distance.absolute | | -instrument.couponTriggerLevel.distance.absolute | | instrument.couponTriggerLevel.distance.relative | | -instrument.couponTriggerLevel.distance.relative | | instrument.couponTriggerLevel.cashFlow | | -instrument.couponTriggerLevel.cashFlow | | instrument.rangeKnockOut.observation.type | | -instrument.rangeKnockOut.observation.type | | instrument.rangeKnockOut.upper.value | | -instrument.rangeKnockOut.upper.value | | instrument.rangeKnockOut.lower.value | | -instrument.rangeKnockOut.lower.value | | instrument.rangeKnockOut.breach.breached | | -instrument.rangeKnockOut.breach.breached | | instrument.rangeKnockOut.breach.datetime | | -instrument.rangeKnockOut.breach.datetime | | instrument.rangeKnockOut.cashFlow | | -instrument.rangeKnockOut.cashFlow | | instrument.participation | | -instrument.participation | | instrument.constantLeverage | | -instrument.constantLeverage | | instrument.nominalCurrency.isoCode | | -instrument.nominalCurrency.isoCode | | instrument.currentInterestRate.type | | -instrument.currentInterestRate.type | | instrument.currentInterestRate.value | | -instrument.currentInterestRate.value | | keyFigures.bonusYield.absolute | | -keyFigures.bonusYield.absolute | | keyFigures.bonusYield.relative | | -keyFigures.bonusYield.relative | | keyFigures.bonusYield.annualized | | -keyFigures.bonusYield.annualized | | keyFigures.sidewaysYield.absolute | | -keyFigures.sidewaysYield.absolute | | keyFigures.sidewaysYield.relative | | -keyFigures.sidewaysYield.relative | | keyFigures.sidewaysYield.annualized | | -keyFigures.sidewaysYield.annualized | | keyFigures.maximumYield.absolute | | -keyFigures.maximumYield.absolute | | keyFigures.maximumYield.relative | | -keyFigures.maximumYield.relative | | keyFigures.maximumYield.annualized | | -keyFigures.maximumYield.annualized | | keyFigures.agio.absolute | | -keyFigures.agio.absolute | | keyFigures.agio.relative | | -keyFigures.agio.relative | | keyFigures.agio.annualized | | -keyFigures.agio.annualized | | keyFigures.discount.absolute | | -keyFigures.discount.absolute | | keyFigures.discount.relative | | -keyFigures.discount.relative | | keyFigures.breakEven.breakEvenPoint | | -keyFigures.breakEven.breakEvenPoint | | keyFigures.spread.harmonized | | -keyFigures.spread.harmonized | | keyFigures.spread.relative | | -keyFigures.spread.relative | | keyFigures.delta.effective | | -keyFigures.delta.effective | | keyFigures.delta.unadjusted | | -keyFigures.delta.unadjusted | | keyFigures.thetaOneWeek.effective | | -keyFigures.thetaOneWeek.effective | | keyFigures.thetaOneWeek.unadjusted | | -keyFigures.thetaOneWeek.unadjusted | | keyFigures.vega.effective | | -keyFigures.vega.effective | | keyFigures.vega.unadjusted | | -keyFigures.vega.unadjusted | | keyFigures.leverage | | -keyFigures.leverage | | keyFigures.omega | | -keyFigures.omega | | keyFigures.impliedVolatility | | -keyFigures.impliedVolatility | | keyFigures.intrinsicValue | | -keyFigures.intrinsicValue | | keyFigures.timeValue | | -keyFigures.timeValue | | keyFigures.outperformancePoint | | -keyFigures.outperformancePoint | | keyFigures.parity | | -keyFigures.parity | | performance.intraday | | -performance.intraday | | performance.sinceIssue.ask | | -performance.sinceIssue.ask | | performance.sinceIssue.bid | | -performance.sinceIssue.bid | | performance.endOfDay.day1 | | -performance.endOfDay.day1 | | performance.endOfDay.week1 | | -performance.endOfDay.week1 | | performance.endOfDay.month1 | | -performance.endOfDay.month1 | | performance.endOfDay.months3 | | -performance.endOfDay.months3 | | performance.endOfDay.months6 | | -performance.endOfDay.months6 | | performance.endOfDay.year1 | | -performance.endOfDay.year1 | | performance.endOfDay.years3 | | -performance.endOfDay.years3 | | performance.endOfDay.years5 | | -performance.endOfDay.years5 | | performance.endOfDay.yearToDate | | -performance.endOfDay.yearToDate | | volatility.week1 | | -volatility.week1 | | volatility.month1 | | -volatility.month1 | | volatility.months3 | | -volatility.months3 | | volatility.months6 | | -volatility.months6 | | volatility.year1 | | -volatility.year1 | | volatility.years3 | | -volatility.years3 | | volatility.years5 | | -volatility.years5 | | volatility.yearToDate | | -volatility.yearToDate |  . [optional] if omitted the server will use the default value of ["inSortEnumument.name"]  # noqa: E501
            pagination (PostSecuritizedDerivativeNotationScreenerSearchRequestMetaPagination): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
