# from __future__ import annotations

from pydantic import Field, AnyUrl
from typing import Optional, Union, Any, List

# dynamic registering
from .definitions import register_model, model_dependence

# basic definitions
from .definitions import Text, DefinedTerm


# base imports
from .product import Product


@register_model
class ProductGroup(Product):
    """A ProductGroup represents a group of Products that vary only in certain well described ways such as by size color material etc While a ProductGroup itself is not directly offered for sale the various varying products that it represents can be The ProductGroup serves as a prototype or template standing in for all of the products who have an isVariantOf relationship to it As such properties including additional types can be applied to the ProductGroup to represent characteristics shared by each of the possibly very many variants Properties that reference a ProductGroup are not included in this mechanism neither are the following specific properties variesBy hasVariant url"""

    hasVariant: Optional[Union["Product", str, List["Product"], List[str]]] = Field(
        None,
        description="Indicates a Product that is a member of this ProductGroup or ProductModel Inverse property isVariantOf",
    )
    productGroupID: Optional[Union[str, List[str]]] = Field(
        None, description="Indicates a textual identifier for a ProductGroup"
    )
    variesBy: Optional[Union[str, List[str]]] = Field(
        None,
        description="Indicates the property or properties by which the variants in a ProductGroup vary e g their size color etc Schema org properties can be referenced by their short name e g color terms defined elsewhere can be referenced with their URIs",
    )


# parent dependences
model_dependence("ProductGroup", "Product")


# attribute dependences
model_dependence(
    "ProductGroup",
    "Product",
)
