import argparse

parser = argparse.ArgumentParser(description = 'Crea ficheros .cas de MSX para aventuras de DAAD.')
parser.add_argument ("in_file", help = 'Nombre de fichero DDB para MSX.')
parser.add_argument ("out_file", help = 'Nombre de fichero CAS generado para MSX.', nargs='?')
parser.add_argument ('-scr', metavar='<file>', help = 'Fichero de pantalla de carga SCR.', type = str)
parser.add_argument ('-mdg', metavar='<file>', help = 'Fichero de gráficos MDG para MSX.', type = str)
parser.add_argument ('-v', help = 'Modo verboso.', action = 'store_true')
parser.add_argument ('-e', help = 'Usar intérprete inglés.', action = 'store_true')

args=parser.parse_args()

in_file = args.in_file
out_file = args.out_file
scr = args.scr
mdg = args.mdg
v = args.v
e = args.e

if out_file == None:
        out_file = in_file
        out_file = out_file.lower()
        out_file = out_file.replace('.ddb', '.cas')
if not (out_file.endswith('.cas')):
        out_file = out_file + '.cas'

print ()
print (' Daad2MsxCas : MSX DAAD-CAS Maker versión 1.0 211003 (c) 2020-21 Pedro Fernández.')
print ('-h para ayuda / -h for options')
print ()

loaderList=[
0,
213,
154,
215,
0,
213,
243,
33,
5,
215,
17,
0,
144,
1,
145,
0,
237,
176,
205,
0,
144,
58,
63,
224,
211,
168,
58,
62,
224,
50,
255,
255,
221,
33,
0,
64,
17,
0,
27,
205,
126,
213,
33,
0,
64,
6,
24,
14,
32,
205,
65,
214,
221,
33,
0,
1,
17,
53,
92,
205,
126,
213,
221,
33,
212,
119,
17,
44,
56,
205,
126,
213,
221,
33,
0,
176,
17,
103,
33,
205,
126,
213,
58,
63,
224,
50,
9,
176,
58,
64,
224,
50,
8,
176,
58,
62,
224,
71,
50,
255,
255,
58,
255,
255,
184,
40,
22,
33,
0,
0,
34,
37,
208,
33,
159,
0,
34,
57,
0,
62,
195,
50,
56,
0,
62,
201,
50,
159,
0,
195,
0,
176,
175,
55,
243,
243,
8,
217,
197,
213,
229,
33,
166,
252,
6,
12,
43,
86,
43,
94,
213,
16,
249,
124,
96,
104,
57,
49,
164,
252,
17,
97,
201,
213,
17,
217,
237,
213,
17,
225,
0,
213,
17,
217,
205,
213,
17,
237,
105,
213,
229,
217,
14,
168,
237,
96,
164,
111,
205,
154,
252,
56,
65,
62,
228,
50,
158,
252,
205,
154,
252,
56,
55,
71,
8,
184,
55,
32,
49,
24,
28,
241,
221,
229,
217,
193,
33,
114,
3,
9,
48,
12,
235,
33,
232,
255,
25,
56,
5,
225,
229,
25,
119,
10,
2,
217,
221,
35,
27,
205,
154,
252,
56,
14,
245,
168,
71,
123,
211,
153,
178,
62,
135,
211,
153,
32,
210,
241,
159,
176,
8,
62,
243,
50,
158,
252,
175,
205,
154,
252,
217,
225,
249,
33,
142,
252,
6,
12,
209,
115,
35,
114,
35,
16,
249,
225,
209,
193,
217,
8,
254,
1,
201,
128,
202,
21,
214,
121,
47,
79,
237,
95,
230,
15,
211,
153,
62,
135,
211,
153,
55,
201,
30,
19,
62,
9,
211,
171,
62,
1,
211,
153,
62,
135,
211,
153,
201,
229,
203,
188,
125,
203,
63,
203,
63,
203,
63,
203,
63,
203,
63,
180,
34,
243,
214,
225,
246,
64,
87,
125,
230,
31,
203,
39,
203,
39,
203,
39,
229,
197,
95,
213,
211,
153,
122,
211,
153,
197,
213,
229,
229,
30,
8,
126,
211,
152,
36,
29,
32,
249,
225,
44,
13,
32,
241,
225,
125,
254,
224,
48,
6,
17,
32,
0,
25,
24,
8,
124,
198,
8,
103,
125,
230,
31,
111,
209,
193,
20,
123,
5,
32,
206,
209,
193,
225,
122,
246,
32,
87,
197,
213,
6,
0,
58,
243,
214,
79,
58,
244,
214,
111,
38,
0,
41,
41,
41,
41,
41,
9,
124,
246,
88,
103,
209,
193,
197,
229,
123,
211,
153,
122,
211,
153,
126,
245,
230,
7,
217,
111,
38,
0,
17,
245,
214,
25,
78,
241,
15,
15,
15,
230,
7,
111,
38,
0,
17,
253,
214,
25,
126,
177,
6,
8,
211,
152,
0,
0,
16,
250,
217,
35,
13,
32,
215,
225,
1,
32,
0,
9,
193,
20,
5,
32,
197,
201,
0,
0,
16,
64,
96,
208,
32,
112,
160,
240,
1,
4,
6,
13,
2,
7,
10,
15,
243,
219,
168,
71,
8,
120,
230,
48,
71,
219,
168,
230,
240,
61,
33,
0,
0,
60,
211,
168,
79,
126,
47,
119,
190,
121,
40,
39,
30,
0,
121,
15,
15,
230,
192,
176,
211,
168,
58,
255,
255,
47,
230,
240,
179,
50,
255,
255,
121,
211,
168,
126,
47,
119,
190,
121,
40,
9,
28,
123,
254,
4,
32,
222,
121,
24,
206,
214,
4,
33,
0,
64,
198,
4,
211,
168,
79,
126,
47,
119,
190,
121,
40,
43,
30,
0,
121,
15,
15,
15,
15,
230,
192,
176,
211,
168,
58,
255,
255,
47,
230,
243,
179,
50,
255,
255,
121,
211,
168,
126,
47,
119,
190,
121,
40,
11,
123,
198,
4,
95,
254,
16,
32,
218,
121,
24,
201,
8,
50,
64,
224,
211,
168,
8,
50,
63,
224,
58,
255,
255,
47,
50,
62,
224,
201,
0,
74,
4,
202,
0,
0,
0,
0,
0,
0,
0,
0,]

blankMdgList = [
7,
206,
167,
207,
167,
255,
255,
0,
224,
0,
0,
12,
42,
255,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
32,
80,
48,
0,
112,
0,
0,
32,
0,
32,
32,
32,
32,
32,
0,
32,
0,
32,
64,
136,
136,
112,
0,
0,
0,
40,
80,
160,
80,
40,
0,
0,
0,
160,
80,
40,
80,
160,
0,
32,
64,
0,
104,
152,
152,
104,
0,
16,
32,
112,
136,
248,
128,
120,
0,
16,
32,
0,
96,
32,
32,
112,
0,
16,
32,
0,
112,
136,
136,
112,
0,
16,
32,
0,
136,
136,
136,
112,
0,
40,
80,
0,
176,
200,
136,
136,
0,
40,
80,
136,
200,
168,
152,
136,
0,
0,
112,
136,
128,
136,
112,
32,
64,
112,
136,
128,
128,
136,
112,
32,
64,
0,
80,
0,
136,
136,
136,
112,
0,
80,
0,
136,
136,
136,
136,
112,
0,
0,
0,
0,
0,
0,
0,
0,
0,
32,
32,
32,
32,
32,
0,
32,
0,
80,
80,
0,
0,
0,
0,
0,
0,
80,
248,
80,
80,
80,
248,
80,
0,
32,
248,
160,
248,
40,
248,
32,
0,
200,
200,
16,
32,
64,
152,
152,
0,
32,
80,
32,
96,
152,
144,
104,
0,
32,
64,
0,
0,
0,
0,
0,
0,
8,
16,
16,
16,
16,
16,
8,
0,
64,
32,
32,
32,
32,
32,
64,
0,
168,
168,
112,
248,
112,
168,
168,
0,
0,
32,
32,
248,
32,
32,
0,
0,
0,
0,
0,
0,
0,
16,
16,
32,
0,
0,
0,
120,
0,
0,
0,
0,
0,
0,
0,
0,
0,
48,
48,
0,
8,
8,
16,
32,
64,
128,
128,
0,
112,
152,
152,
168,
200,
200,
112,
0,
32,
96,
32,
32,
32,
32,
112,
0,
112,
136,
8,
112,
128,
128,
248,
0,
112,
136,
8,
48,
8,
136,
112,
0,
16,
48,
80,
144,
248,
16,
16,
0,
248,
128,
128,
240,
8,
136,
112,
0,
112,
136,
128,
240,
136,
136,
112,
0,
248,
8,
8,
16,
16,
32,
32,
0,
112,
136,
136,
112,
136,
136,
112,
0,
112,
136,
136,
120,
8,
136,
112,
0,
0,
0,
32,
0,
0,
32,
0,
0,
0,
0,
32,
0,
0,
32,
32,
64,
0,
8,
16,
32,
32,
16,
8,
0,
0,
0,
0,
120,
0,
120,
0,
0,
0,
64,
32,
16,
16,
32,
64,
0,
112,
136,
136,
16,
32,
0,
32,
0,
0,
112,
136,
168,
184,
128,
112,
0,
112,
136,
136,
248,
136,
136,
136,
0,
240,
136,
136,
240,
136,
136,
240,
0,
112,
136,
128,
128,
128,
136,
112,
0,
240,
136,
136,
136,
136,
136,
240,
0,
248,
128,
128,
240,
128,
128,
248,
0,
248,
128,
128,
240,
128,
128,
128,
0,
112,
136,
128,
128,
152,
136,
112,
0,
136,
136,
136,
248,
136,
136,
136,
0,
112,
32,
32,
32,
32,
32,
112,
0,
8,
8,
8,
8,
8,
136,
112,
0,
136,
144,
160,
192,
160,
144,
136,
0,
128,
128,
128,
128,
128,
128,
248,
0,
136,
216,
168,
136,
136,
136,
136,
0,
136,
136,
200,
168,
152,
136,
136,
0,
112,
136,
136,
136,
136,
136,
112,
0,
240,
136,
136,
240,
128,
128,
128,
0,
112,
136,
136,
136,
168,
152,
120,
0,
240,
136,
136,
240,
144,
136,
136,
0,
112,
136,
128,
112,
8,
136,
112,
0,
248,
32,
32,
32,
32,
32,
32,
0,
136,
136,
136,
136,
136,
136,
112,
0,
136,
136,
136,
136,
136,
80,
32,
0,
136,
136,
136,
136,
168,
168,
80,
0,
136,
136,
80,
32,
80,
136,
136,
0,
136,
136,
80,
32,
32,
32,
32,
0,
248,
8,
16,
32,
64,
128,
248,
0,
56,
32,
32,
32,
32,
32,
56,
0,
128,
128,
64,
32,
16,
8,
8,
0,
112,
16,
16,
16,
16,
16,
112,
0,
32,
112,
168,
32,
32,
32,
32,
0,
0,
0,
0,
0,
0,
0,
0,
0,
48,
72,
64,
240,
64,
64,
248,
0,
0,
0,
104,
152,
136,
152,
104,
0,
128,
128,
176,
200,
136,
200,
176,
0,
0,
0,
112,
136,
128,
136,
112,
0,
8,
8,
104,
152,
136,
152,
104,
0,
0,
0,
112,
136,
240,
128,
120,
0,
48,
72,
64,
96,
64,
64,
64,
0,
0,
0,
112,
136,
136,
120,
8,
112,
128,
128,
176,
200,
136,
136,
136,
0,
32,
0,
96,
32,
32,
32,
112,
0,
16,
0,
16,
16,
16,
144,
96,
0,
128,
128,
128,
160,
192,
160,
144,
0,
64,
64,
64,
64,
64,
64,
48,
0,
0,
0,
208,
168,
168,
168,
168,
0,
0,
0,
176,
200,
136,
136,
136,
0,
0,
0,
112,
136,
136,
136,
112,
0,
0,
0,
176,
200,
136,
240,
128,
128,
0,
0,
104,
152,
136,
120,
8,
12,
0,
0,
176,
64,
64,
64,
64,
0,
0,
0,
112,
128,
112,
8,
240,
0,
0,
64,
224,
64,
64,
64,
48,
0,
0,
0,
136,
136,
136,
136,
112,
0,
0,
0,
136,
136,
80,
80,
32,
0,
0,
0,
136,
168,
168,
168,
80,
0,
0,
0,
136,
80,
32,
80,
136,
0,
0,
0,
136,
136,
152,
104,
8,
112,
0,
0,
248,
16,
32,
64,
248,
0,
24,
32,
32,
64,
32,
32,
24,
0,
16,
16,
16,
16,
16,
16,
16,
0,
96,
16,
16,
8,
16,
16,
96,
0,
0,
40,
80,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
196,
170,
174,
202,
38,
85,
117,
86,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
14,
6,
13,
12,
7,
10,
4,
0,
5,
8,
9,
3,
2,
11,
15,
0,
82,
206,
167,
207,
167,
213,
167,
219,
167,
220,
167,
220,
175,
255,
255,
1,
0,
0]

eTerpList = [
195,
58,
207,
208,
32,
255,
255,
255,
240,
255,
201,
0,
0,
195,
223,
206,
201,
0,
0,
195,
228,
206,
195,
198,
189,
195,
69,
200,
195,
7,
201,
195,
84,
202,
195,
237,
199,
195,
249,
199,
195,
45,
176,
1,
15,
221,
203,
255,
198,
225,
43,
43,
43,
43,
34,
17,
208,
122,
50,
212,
207,
221,
33,
208,
208,
221,
203,
255,
182,
58,
216,
207,
183,
32,
8,
62,
8,
205,
69,
200,
205,
173,
204,
205,
120,
176,
205,
84,
202,
205,
237,
199,
221,
203,
255,
150,
205,
147,
202,
33,
58,
207,
54,
13,
34,
179,
207,
221,
54,
249,
120,
42,
215,
207,
124,
183,
202,
202,
176,
233,
205,
5,
201,
58,
212,
207,
33,
190,
176,
221,
203,
255,
70,
32,
17,
33,
173,
176,
254,
101,
40,
28,
33,
179,
176,
254,
102,
40,
21,
33,
183,
176,
95,
213,
205,
157,
189,
209,
205,
76,
189,
221,
203,
255,
70,
221,
203,
255,
134,
201,
195,
157,
189,
189,
173,
186,
190,
180,
245,
182,
208,
176,
223,
186,
141,
141,
144,
141,
223,
245,
184,
158,
146,
154,
223,
186,
141,
141,
144,
141,
223,
245,
237,
123,
213,
207,
205,
239,
206,
62,
2,
205,
95,
0,
58,
43,
176,
50,
235,
243,
50,
234,
243,
58,
44,
176,
50,
233,
243,
205,
98,
0,
205,
250,
206,
17,
36,
208,
62,
8,
33,
20,
208,
1,
16,
0,
237,
176,
61,
32,
245,
50,
182,
208,
17,
183,
208,
33,
20,
208,
1,
16,
0,
237,
176,
58,
187,
208,
95,
22,
0,
237,
83,
187,
207,
33,
208,
208,
229,
221,
225,
175,
71,
119,
35,
16,
252,
221,
203,
29,
254,
205,
45,
177,
194,
92,
176,
205,
239,
206,
199,
237,
115,
13,
208,
175,
50,
16,
208,
205,
10,
189,
175,
245,
50,
19,
208,
50,
15,
208,
175,
190,
32,
24,
209,
122,
183,
40,
5,
225,
193,
195,
232,
181,
33,
15,
208,
190,
200,
123,
50,
16,
208,
53,
193,
225,
24,
32,
126,
35,
254,
255,
40,
5,
221,
190,
33,
32,
10,
126,
254,
255,
40,
11,
221,
190,
34,
40,
6,
35,
35,
35,
195,
64,
177,
35,
78,
35,
70,
35,
10,
254,
255,
40,
191,
50,
203,
208,
229,
22,
0,
203,
39,
95,
3,
10,
33,
136,
183,
25,
94,
35,
86,
213,
22,
0,
95,
221,
203,
251,
126,
40,
6,
33,
208,
208,
25,
126,
95,
33,
208,
209,
25,
229,
33,
208,
208,
25,
209,
201,
221,
190,
38,
40,
97,
24,
12,
221,
190,
38,
32,
90,
24,
5,
221,
190,
38,
56,
83,
225,
195,
64,
177,
221,
190,
38,
56,
247,
40,
245,
24,
70,
26,
221,
190,
38,
40,
64,
254,
253,
48,
60,
24,
231,
26,
221,
190,
38,
40,
225,
254,
253,
48,
221,
24,
46,
26,
254,
253,
40,
41,
24,
212,
26,
254,
253,
32,
34,
24,
205,
26,
254,
254,
32,
200,
24,
25,
26,
254,
254,
40,
193,
24,
18,
205,
41,
189,
188,
48,
12,
24,
183,
126,
183,
32,
179,
24,
4,
126,
183,
40,
173,
3,
225,
195,
124,
177,
3,
10,
190,
32,
163,
24,
244,
205,
13,
181,
24,
246,
3,
10,
190,
40,
151,
24,
232,
205,
13,
181,
24,
246,
205,
13,
181,
24,
2,
3,
10,
190,
56,
217,
24,
132,
205,
13,
181,
24,
2,
3,
10,
190,
218,
193,
177,
202,
193,
177,
195,
20,
178,
221,
190,
35,
40,
193,
195,
193,
177,
221,
190,
36,
24,
246,
221,
190,
43,
24,
241,
221,
190,
44,
24,
236,
221,
190,
45,
24,
231,
46,
12,
197,
205,
239,
191,
193,
126,
46,
30,
205,
26,
189,
47,
190,
194,
193,
177,
195,
87,
180,
46,
13,
205,
239,
191,
126,
46,
31,
205,
26,
189,
47,
150,
40,
11,
175,
50,
246,
208,
237,
123,
13,
208,
195,
49,
177,
237,
123,
13,
208,
183,
201,
221,
203,
255,
150,
205,
148,
189,
225,
221,
203,
255,
230,
195,
68,
177,
46,
15,
24,
241,
197,
205,
207,
199,
193,
195,
87,
180,
3,
205,
10,
176,
195,
86,
180,
3,
205,
13,
176,
195,
86,
180,
197,
205,
133,
200,
193,
195,
87,
180,
221,
54,
1,
0,
33,
208,
209,
126,
254,
255,
202,
87,
180,
254,
253,
56,
4,
58,
246,
208,
119,
35,
24,
239,
197,
58,
246,
208,
1,
253,
254,
205,
82,
185,
193,
46,
26,
202,
132,
179,
11,
205,
159,
185,
26,
46,
25,
254,
253,
48,
72,
44,
221,
190,
38,
32,
127,
58,
3,
209,
205,
203,
184,
205,
165,
184,
46,
43,
132,
56,
113,
33,
4,
209,
190,
40,
4,
46,
43,
48,
103,
46,
36,
38,
27,
229,
58,
209,
208,
33,
245,
208,
190,
48,
13,
235,
54,
254,
221,
52,
1,
225,
205,
148,
189,
195,
86,
180,
225,
108,
58,
19,
208,
183,
202,
159,
178,
58,
3,
1,
50,
19,
208,
195,
159,
178,
205,
67,
185,
40,
49,
11,
205,
159,
185,
26,
254,
253,
46,
24,
40,
237,
46,
49,
221,
190,
38,
40,
230,
46,
28,
254,
254,
32,
224,
58,
246,
208,
18,
221,
53,
1,
46,
39,
24,
192,
197,
62,
253,
6,
254,
205,
79,
185,
193,
11,
32,
12,
46,
23,
56,
2,
46,
8,
195,
159,
178,
205,
159,
185,
26,
46,
50,
254,
254,
40,
243,
221,
190,
38,
40,
238,
46,
23,
254,
253,
32,
232,
205,
38,
185,
44,
48,
226,
46,
38,
38,
42,
195,
37,
179,
197,
6,
253,
205,
77,
185,
193,
46,
28,
40,
204,
11,
205,
159,
185,
26,
46,
49,
221,
190,
38,
40,
196,
46,
29,
254,
253,
40,
190,
45,
56,
187,
205,
38,
185,
48,
182,
235,
54,
253,
221,
53,
1,
46,
37,
195,
54,
179,
95,
22,
0,
197,
205,
9,
200,
193,
24,
111,
50,
246,
208,
24,
106,
237,
91,
14,
1,
33,
4,
1,
24,
20,
221,
203,
255,
246,
237,
91,
16,
1,
33,
5,
1,
24,
7,
237,
91,
18,
1,
33,
6,
1,
190,
48,
15,
235,
22,
0,
95,
25,
25,
94,
35,
86,
235,
205,
157,
189,
24,
59,
22,
7,
195,
45,
176,
205,
159,
185,
235,
126,
254,
254,
54,
252,
32,
43,
221,
53,
1,
24,
38,
205,
159,
185,
26,
254,
254,
58,
246,
208,
18,
24,
237,
3,
10,
205,
159,
185,
111,
38,
0,
26,
213,
17,
208,
209,
25,
86,
119,
225,
114,
24,
6,
54,
255,
24,
2,
54,
0,
3,
225,
221,
203,
255,
230,
195,
124,
177,
3,
87,
10,
134,
48,
34,
62,
255,
24,
30,
3,
10,
87,
126,
146,
48,
1,
175,
119,
24,
226,
3,
245,
10,
229,
95,
22,
0,
33,
208,
208,
25,
94,
225,
241,
24,
5,
3,
87,
10,
95,
122,
254,
38,
32,
12,
58,
4,
1,
187,
22,
1,
218,
45,
176,
202,
45,
176,
115,
24,
186,
205,
5,
201,
24,
182,
94,
35,
86,
205,
78,
189,
24,
173,
94,
205,
76,
189,
24,
167,
3,
235,
10,
205,
31,
185,
190,
194,
193,
177,
195,
20,
178,
3,
235,
10,
205,
31,
185,
190,
194,
20,
178,
195,
193,
177,
205,
159,
185,
3,
235,
10,
205,
31,
185,
245,
126,
24,
29,
205,
31,
185,
245,
58,
3,
209,
24,
17,
126,
254,
255,
32,
6,
22,
2,
195,
45,
176,
26,
245,
3,
10,
205,
159,
185,
205,
58,
185,
254,
254,
32,
3,
221,
53,
1,
241,
254,
254,
32,
3,
221,
52,
1,
119,
195,
86,
180,
235,
205,
14,
181,
195,
135,
180,
235,
3,
10,
197,
79,
6,
0,
33,
208,
208,
9,
26,
95,
81,
193,
201,
205,
13,
181,
195,
98,
180,
205,
13,
181,
195,
107,
180,
221,
86,
38,
221,
203,
255,
206,
205,
28,
186,
195,
87,
180,
197,
183,
32,
5,
205,
204,
186,
24,
3,
205,
192,
186,
193,
218,
20,
178,
221,
203,
255,
230,
195,
193,
177,
205,
31,
185,
87,
221,
203,
255,
142,
205,
28,
186,
195,
86,
180,
3,
33,
7,
1,
190,
48,
38,
183,
40,
35,
205,
10,
189,
245,
58,
15,
208,
60,
50,
15,
208,
254,
10,
202,
141,
181,
241,
197,
237,
91,
16,
208,
22,
0,
213,
50,
16,
208,
221,
203,
255,
166,
195,
64,
177,
22,
6,
195,
45,
176,
241,
22,
3,
195,
45,
176,
225,
58,
16,
208,
205,
10,
189,
195,
64,
177,
50,
0,
209,
3,
10,
95,
22,
248,
24,
26,
3,
195,
86,
180,
50,
245,
208,
3,
10,
50,
4,
209,
195,
86,
180,
50,
249,
208,
3,
10,
7,
7,
7,
95,
22,
199,
58,
1,
209,
171,
162,
171,
50,
1,
209,
195,
86,
180,
221,
203,
255,
150,
195,
87,
180,
205,
31,
185,
50,
2,
209,
58,
19,
208,
183,
22,
4,
194,
45,
176,
225,
221,
203,
255,
166,
197,
229,
17,
0,
255,
213,
229,
197,
58,
19,
208,
95,
58,
2,
209,
205,
244,
185,
48,
39,
50,
242,
208,
221,
190,
44,
35,
126,
50,
243,
208,
32,
13,
58,
253,
208,
254,
255,
40,
3,
190,
32,
3,
225,
24,
222,
123,
50,
19,
208,
61,
205,
159,
185,
209,
193,
195,
86,
180,
175,
50,
19,
208,
193,
225,
225,
225,
225,
195,
68,
177,
245,
205,
14,
181,
241,
229,
205,
203,
184,
124,
225,
195,
135,
180,
87,
205,
165,
184,
195,
135,
180,
229,
205,
41,
189,
87,
124,
225,
195,
135,
180,
50,
217,
207,
205,
67,
185,
202,
132,
179,
24,
8,
205,
159,
185,
3,
10,
50,
217,
207,
26,
254,
253,
46,
24,
202,
159,
178,
46,
49,
221,
190,
38,
202,
159,
178,
254,
254,
46,
28,
194,
159,
178,
58,
217,
207,
18,
221,
53,
1,
46,
44,
205,
217,
182,
195,
54,
179,
50,
217,
207,
197,
1,
253,
254,
205,
82,
185,
32,
7,
58,
246,
208,
71,
205,
79,
185,
193,
32,
8,
58,
217,
207,
56,
47,
195,
134,
179,
58,
217,
207,
24,
5,
205,
159,
185,
3,
10,
103,
26,
46,
25,
254,
253,
210,
159,
178,
188,
32,
14,
124,
213,
205,
58,
185,
209,
254,
253,
210,
33,
179,
195,
9,
179,
46,
45,
221,
190,
38,
124,
40,
2,
46,
52,
205,
217,
182,
195,
159,
178,
245,
205,
148,
189,
241,
221,
203,
253,
230,
205,
206,
188,
46,
51,
201,
197,
6,
253,
205,
77,
185,
193,
195,
87,
180,
197,
42,
24,
1,
17,
208,
209,
126,
237,
160,
254,
254,
56,
249,
32,
236,
221,
52,
1,
24,
242,
221,
203,
255,
166,
225,
195,
68,
177,
197,
126,
229,
33,
4,
1,
190,
220,
166,
186,
225,
193,
210,
193,
177,
119,
195,
86,
180,
221,
203,
255,
102,
194,
21,
178,
195,
193,
177,
221,
203,
255,
102,
194,
193,
177,
195,
21,
178,
38,
0,
111,
203,
37,
48,
1,
37,
41,
209,
25,
195,
64,
177,
254,
255,
40,
3,
50,
241,
208,
3,
10,
254,
255,
40,
3,
50,
242,
208,
195,
86,
180,
205,
159,
185,
195,
86,
180,
62,
32,
205,
7,
201,
195,
87,
180,
205,
136,
184,
194,
20,
178,
195,
193,
177,
205,
136,
184,
194,
193,
177,
195,
20,
178,
111,
3,
10,
3,
103,
205,
130,
183,
195,
87,
180,
233,
22,
5,
195,
45,
176,
174,
177,
181,
177,
188,
177,
197,
177,
206,
177,
218,
177,
230,
177,
237,
177,
244,
177,
251,
177,
2,
178,
10,
178,
16,
178,
25,
178,
54,
178,
66,
178,
78,
178,
86,
178,
193,
178,
236,
179,
106,
178,
127,
178,
166,
178,
174,
178,
178,
178,
83,
191,
116,
191,
161,
180,
252,
189,
200,
178,
208,
178,
232,
178,
78,
179,
173,
179,
118,
179,
221,
179,
68,
183,
231,
179,
245,
179,
139,
179,
249,
178,
84,
179,
185,
179,
32,
180,
48,
180,
60,
180,
201,
180,
80,
180,
84,
180,
95,
180,
105,
180,
132,
180,
156,
180,
169,
180,
2,
180,
175,
180,
87,
183,
93,
183,
101,
183,
110,
183,
41,
181,
186,
178,
25,
191,
41,
191,
204,
190,
208,
190,
215,
190,
241,
190,
91,
178,
96,
178,
101,
178,
29,
181,
35,
181,
54,
181,
77,
181,
91,
181,
32,
178,
249,
179,
125,
190,
37,
178,
44,
178,
216,
189,
149,
190,
157,
181,
231,
189,
212,
181,
167,
181,
167,
181,
188,
180,
47,
182,
89,
182,
170,
182,
205,
181,
171,
181,
61,
182,
68,
182,
182,
181,
34,
190,
54,
190,
90,
190,
232,
182,
119,
183,
214,
180,
7,
183,
78,
182,
135,
182,
15,
183,
177,
190,
147,
181,
133,
190,
153,
178,
249,
190,
61,
178,
49,
178,
34,
183,
44,
183,
54,
183,
146,
178,
77,
190,
7,
181,
131,
183,
233,
180,
131,
183,
223,
180,
131,
183,
6,
181,
116,
180,
242,
182,
103,
15,
15,
15,
230,
31,
111,
62,
59,
149,
50,
162,
184,
124,
7,
7,
7,
230,
56,
246,
70,
50,
163,
184,
221,
203,
0,
0,
201,
175,
229,
213,
197,
237,
75,
2,
1,
79,
17,
208,
209,
245,
26,
254,
253,
105,
38,
0,
212,
204,
184,
241,
132,
48,
4,
62,
255,
24,
4,
12,
19,
16,
234,
193,
209,
225,
201,
111,
235,
175,
87,
50,
219,
207,
205,
216,
184,
235,
125,
201,
229,
213,
197,
205,
50,
185,
230,
127,
198,
192,
203,
183,
203,
191,
48,
43,
230,
63,
40,
38,
79,
58,
219,
207,
60,
50,
219,
207,
254,
10,
40,
21,
121,
237,
75,
2,
1,
75,
30,
0,
87,
33,
208,
209,
126,
185,
204,
216,
184,
35,
28,
16,
247,
33,
219,
207,
53,
122,
55,
193,
209,
225,
245,
130,
87,
48,
2,
22,
255,
241,
201,
254,
255,
192,
58,
246,
208,
201,
213,
221,
94,
51,
205,
50,
185,
209,
46,
40,
7,
201,
22,
0,
42,
28,
1,
25,
126,
201,
95,
22,
0,
33,
208,
209,
25,
126,
201,
197,
6,
253,
205,
77,
185,
193,
46,
28,
201,
62,
254,
221,
78,
38,
50,
3,
209,
58,
242,
208,
60,
55,
40,
28,
197,
221,
70,
51,
205,
132,
185,
56,
23,
193,
205,
132,
185,
56,
18,
65,
205,
132,
185,
56,
12,
6,
255,
205,
132,
185,
56,
6,
62,
255,
24,
35,
193,
183,
43,
235,
43,
125,
24,
27,
30,
0,
205,
245,
185,
208,
205,
146,
185,
225,
32,
246,
55,
201,
221,
190,
34,
192,
58,
243,
208,
254,
255,
200,
35,
190,
201,
245,
229,
213,
33,
0,
0,
34,
6,
209,
34,
8,
209,
34,
10,
209,
95,
50,
3,
209,
254,
255,
40,
49,
33,
3,
1,
190,
48,
47,
205,
50,
185,
23,
221,
203,
57,
30,
23,
221,
203,
56,
30,
205,
61,
185,
50,
6,
209,
235,
205,
204,
184,
221,
116,
55,
38,
0,
235,
42,
30,
1,
25,
25,
126,
50,
11,
209,
35,
126,
50,
10,
209,
209,
225,
241,
201,
209,
225,
241,
241,
22,
0,
195,
45,
176,
71,
33,
208,
209,
22,
0,
25,
58,
3,
1,
187,
200,
120,
19,
254,
255,
40,
1,
190,
35,
32,
241,
227,
229,
213,
29,
42,
26,
1,
25,
25,
126,
254,
255,
209,
216,
225,
227,
24,
223,
197,
1,
0,
0,
197,
221,
203,
53,
190,
221,
203,
253,
166,
33,
208,
209,
9,
126,
254,
255,
40,
74,
186,
32,
43,
97,
46,
0,
227,
229,
241,
221,
203,
53,
126,
32,
28,
221,
203,
53,
254,
221,
203,
255,
78,
40,
12,
46,
1,
205,
148,
189,
221,
203,
53,
118,
204,
5,
201,
227,
46,
1,
227,
24,
3,
205,
99,
186,
3,
24,
198,
221,
203,
53,
118,
32,
7,
111,
205,
19,
189,
195,
153,
189,
56,
7,
245,
46,
46,
205,
148,
189,
241,
195,
206,
188,
241,
193,
221,
203,
53,
126,
40,
24,
221,
203,
53,
118,
40,
217,
56,
8,
245,
46,
47,
205,
148,
189,
241,
55,
205,
99,
186,
46,
48,
195,
148,
189,
221,
203,
255,
78,
192,
46,
53,
195,
148,
189,
42,
20,
1,
79,
6,
0,
9,
9,
94,
35,
86,
235,
126,
254,
255,
200,
221,
190,
33,
35,
126,
55,
200,
35,
24,
242,
42,
11,
208,
125,
180,
40,
99,
22,
1,
175,
24,
30,
221,
203,
255,
86,
40,
6,
42,
9,
208,
126,
254,
13,
245,
55,
204,
197,
191,
48,
39,
34,
9,
208,
241,
17,
0,
0,
237,
83,
11,
208,
221,
114,
254,
17,
255,
255,
123,
32,
6,
50,
241,
208,
50,
244,
208,
237,
83,
242,
208,
237,
83,
251,
208,
50,
253,
208,
24,
8,
241,
221,
203,
49,
254,
24,
29,
35,
205,
179,
188,
254,
34,
40,
21,
205,
187,
188,
56,
23,
254,
13,
32,
239,
221,
203,
255,
86,
40,
6,
221,
203,
255,
150,
24,
162,
221,
203,
255,
150,
55,
201,
225,
205,
99,
188,
183,
194,
183,
187,
205,
186,
188,
56,
244,
254,
34,
32,
33,
221,
203,
254,
70,
32,
27,
237,
91,
11,
208,
122,
179,
32,
219,
35,
34,
11,
208,
126,
254,
13,
40,
210,
35,
254,
34,
32,
246,
205,
179,
188,
24,
214,
221,
203,
255,
214,
221,
203,
254,
70,
32,
5,
34,
9,
208,
24,
3,
34,
11,
208,
126,
254,
13,
32,
4,
221,
203,
255,
150,
221,
203,
254,
78,
32,
15,
58,
242,
208,
254,
255,
40,
160,
254,
40,
208,
50,
241,
208,
183,
201,
221,
203,
254,
110,
32,
5,
62,
255,
50,
244,
208,
237,
91,
252,
208,
205,
168,
187,
237,
91,
242,
208,
123,
254,
255,
40,
8,
254,
50,
56,
4,
237,
83,
254,
208,
175,
201,
95,
10,
254,
5,
40,
165,
183,
32,
17,
221,
203,
254,
78,
194,
49,
187,
221,
115,
33,
221,
203,
254,
206,
195,
49,
187,
254,
1,
32,
17,
221,
203,
254,
110,
194,
49,
187,
221,
115,
36,
221,
203,
254,
238,
195,
49,
187,
254,
4,
32,
14,
58,
251,
208,
254,
255,
194,
49,
187,
221,
115,
43,
195,
49,
187,
221,
203,
254,
94,
194,
49,
187,
229,
33,
242,
208,
221,
203,
254,
86,
40,
3,
33,
252,
208,
254,
6,
40,
66,
254,
2,
32,
46,
221,
203,
254,
86,
40,
28,
58,
242,
208,
187,
32,
18,
35,
126,
43,
254,
255,
40,
16,
221,
190,
35,
40,
11,
58,
243,
208,
60,
40,
5,
221,
203,
254,
222,
115,
221,
203,
254,
214,
221,
203,
254,
190,
195,
48,
187,
221,
203,
254,
126,
194,
48,
187,
35,
115,
221,
203,
254,
254,
195,
48,
187,
58,
254,
208,
254,
255,
202,
48,
187,
95,
35,
58,
255,
208,
119,
43,
24,
177,
62,
223,
17,
212,
207,
6,
5,
27,
18,
16,
252,
6,
5,
205,
186,
188,
48,
13,
47,
18,
19,
35,
16,
245,
205,
186,
188,
35,
56,
250,
43,
205,
179,
188,
237,
75,
22,
1,
229,
33,
207,
207,
221,
203,
255,
174,
22,
5,
10,
183,
32,
2,
225,
201,
190,
40,
4,
221,
203,
255,
238,
3,
35,
21,
32,
238,
221,
203,
255,
110,
32,
4,
10,
3,
225,
201,
3,
3,
24,
215,
126,
254,
32,
192,
35,
24,
249,
126,
205,
199,
188,
63,
216,
254,
65,
63,
208,
254,
91,
201,
254,
48,
216,
254,
58,
63,
201,
229,
33,
3,
1,
190,
48,
51,
205,
18,
189,
205,
250,
188,
40,
251,
221,
203,
253,
102,
32,
4,
230,
223,
24,
10,
205,
250,
188,
32,
251,
205,
250,
188,
40,
251,
47,
205,
7,
201,
205,
250,
188,
24,
247,
126,
254,
245,
40,
8,
254,
209,
40,
4,
35,
254,
223,
201,
225,
225,
201,
111,
213,
237,
91,
10,
1,
24,
13,
111,
213,
237,
91,
12,
1,
24,
5,
213,
237,
91,
18,
1,
38,
0,
41,
25,
94,
35,
86,
235,
209,
201,
245,
197,
1,
101,
8,
33,
0,
0,
237,
91,
180,
208,
28,
84,
203,
57,
48,
1,
25,
203,
35,
203,
18,
16,
245,
34,
180,
208,
124,
183,
40,
226,
193,
241,
201,
22,
0,
229,
213,
221,
203,
253,
142,
235,
17,
16,
39,
205,
118,
189,
17,
232,
3,
205,
118,
189,
17,
100,
0,
205,
118,
189,
17,
10,
0,
205,
118,
189,
125,
198,
48,
205,
7,
201,
209,
225,
201,
175,
60,
183,
237,
82,
48,
250,
25,
61,
32,
5,
221,
203,
253,
78,
200,
221,
203,
253,
206,
198,
48,
195,
7,
201,
205,
26,
189,
24,
5,
205,
26,
189,
24,
4,
221,
203,
255,
246,
126,
47,
254,
10,
40,
23,
221,
190,
250,
32,
12,
221,
203,
253,
230,
58,
3,
209,
205,
206,
188,
24,
3,
205,
7,
201,
35,
24,
227,
221,
203,
255,
118,
200,
221,
203,
255,
182,
195,
5,
201,
227,
237,
83,
213,
189,
94,
35,
86,
35,
235,
25,
235,
227,
213,
17,
0,
0,
201,
230,
7,
95,
58,
198,
208,
230,
248,
179,
50,
198,
208,
195,
86,
180,
33,
253,
175,
190,
48,
12,
50,
218,
207,
95,
205,
180,
194,
203,
126,
194,
20,
178,
195,
193,
177,
221,
203,
252,
190,
183,
40,
4,
221,
203,
252,
254,
197,
205,
84,
202,
58,
198,
208,
245,
221,
203,
246,
182,
58,
218,
207,
95,
205,
37,
194,
241,
50,
198,
208,
193,
195,
86,
180,
197,
205,
84,
202,
221,
203,
246,
174,
221,
203,
246,
190,
42,
196,
208,
34,
185,
208,
24,
19,
197,
205,
84,
202,
221,
203,
246,
174,
221,
203,
246,
190,
237,
91,
185,
208,
205,
174,
200,
193,
195,
87,
180,
197,
245,
205,
84,
202,
58,
197,
208,
87,
241,
95,
24,
15,
87,
3,
10,
95,
197,
213,
205,
84,
202,
209,
58,
194,
208,
130,
87,
58,
195,
208,
131,
95,
205,
174,
200,
221,
203,
246,
174,
221,
203,
246,
190,
193,
195,
86,
180,
197,
205,
69,
200,
193,
195,
86,
180,
11,
197,
205,
84,
202,
58,
192,
208,
203,
63,
103,
62,
21,
148,
24,
23,
245,
197,
205,
84,
202,
193,
241,
254,
24,
56,
1,
175,
50,
194,
208,
3,
197,
10,
254,
42,
56,
1,
175,
50,
195,
208,
24,
17,
245,
197,
205,
84,
202,
193,
241,
61,
50,
193,
208,
3,
197,
10,
50,
192,
208,
205,
225,
200,
205,
149,
200,
193,
195,
86,
180,
3,
195,
86,
180,
205,
185,
191,
30,
240,
24,
11,
205,
185,
191,
7,
7,
7,
7,
230,
240,
30,
15,
87,
58,
187,
208,
163,
178,
50,
187,
208,
50,
187,
207,
195,
86,
180,
230,
15,
205,
126,
205,
195,
86,
180,
205,
239,
206,
205,
156,
0,
40,
18,
205,
159,
0,
50,
12,
209,
205,
250,
206,
58,
193,
208,
205,
40,
200,
195,
21,
178,
205,
250,
206,
195,
193,
177,
17,
208,
210,
221,
203,
253,
198,
197,
33,
208,
208,
1,
0,
2,
24,
36,
221,
203,
253,
70,
32,
7,
221,
203,
255,
150,
195,
193,
177,
3,
197,
33,
208,
210,
17,
208,
208,
79,
6,
0,
3,
237,
176,
33,
208,
211,
17,
208,
209,
1,
0,
1,
237,
176,
193,
195,
87,
180,
197,
42,
215,
207,
229,
33,
108,
191,
34,
215,
207,
205,
131,
191,
46,
61,
205,
148,
189,
205,
237,
199,
205,
138,
205,
225,
34,
215,
207,
193,
195,
86,
180,
197,
205,
131,
191,
205,
236,
205,
221,
203,
255,
150,
193,
195,
86,
180,
46,
60,
205,
239,
191,
17,
177,
191,
1,
8,
0,
126,
254,
13,
40,
11,
254,
32,
40,
7,
237,
160,
234,
142,
191,
24,
7,
235,
54,
32,
35,
13,
32,
250,
253,
33,
170,
191,
201,
84,
74,
71,
0,
2,
208,
208,
68,
65,
65,
68,
86,
49,
46,
48,
230,
15,
95,
22,
0,
42,
249,
175,
35,
25,
126,
201,
221,
203,
254,
166,
58,
250,
208,
183,
40,
9,
111,
58,
6,
1,
189,
40,
2,
48,
35,
205,
41,
189,
124,
46,
2,
254,
30,
56,
25,
44,
254,
60,
56,
20,
44,
254,
90,
56,
15,
44,
24,
12,
221,
203,
255,
150,
221,
203,
254,
230,
221,
54,
249,
12,
229,
58,
182,
208,
50,
8,
208,
58,
249,
208,
230,
7,
196,
69,
200,
225,
205,
148,
189,
205,
84,
202,
221,
203,
246,
182,
62,
128,
50,
190,
208,
46,
33,
205,
148,
189,
205,
253,
193,
205,
34,
204,
58,
196,
208,
50,
7,
208,
221,
203,
254,
102,
32,
23,
58,
1,
209,
7,
48,
17,
7,
48,
14,
7,
48,
11,
33,
58,
207,
205,
185,
193,
205,
200,
193,
24,
21,
175,
50,
181,
207,
33,
58,
207,
62,
13,
119,
34,
179,
207,
24,
6,
221,
203,
49,
70,
32,
34,
221,
203,
254,
102,
32,
28,
58,
0,
209,
183,
40,
22,
205,
249,
199,
56,
20,
42,
179,
207,
205,
185,
193,
205,
222,
193,
58,
1,
209,
246,
192,
195,
252,
192,
205,
237,
199,
254,
8,
202,
122,
193,
254,
29,
202,
80,
193,
254,
28,
202,
105,
193,
254,
13,
32,
9,
58,
181,
207,
183,
194,
234,
192,
24,
185,
95,
58,
181,
207,
221,
190,
249,
202,
87,
192,
123,
254,
32,
218,
87,
192,
254,
91,
56,
10,
254,
97,
218,
87,
192,
254,
123,
210,
87,
192,
42,
179,
207,
229,
62,
13,
6,
255,
237,
177,
193,
123,
229,
209,
183,
237,
66,
229,
193,
213,
225,
43,
237,
184,
33,
181,
207,
52,
42,
179,
207,
119,
35,
34,
179,
207,
43,
205,
185,
193,
205,
200,
193,
195,
87,
192,
42,
179,
207,
205,
185,
193,
205,
222,
193,
205,
5,
201,
58,
1,
209,
230,
63,
55,
50,
1,
209,
245,
205,
50,
204,
221,
203,
49,
94,
196,
133,
200,
221,
203,
246,
246,
58,
8,
208,
205,
69,
200,
241,
245,
48,
47,
221,
203,
49,
102,
46,
33,
196,
148,
189,
33,
58,
207,
126,
254,
13,
40,
23,
245,
221,
203,
49,
102,
196,
7,
201,
241,
254,
97,
56,
7,
254,
123,
48,
3,
230,
223,
119,
35,
24,
228,
221,
203,
49,
102,
196,
5,
201,
241,
221,
54,
249,
120,
33,
58,
207,
201,
237,
91,
179,
207,
33,
58,
207,
183,
237,
82,
40,
10,
27,
237,
83,
179,
207,
62,
8,
205,
162,
202,
195,
87,
192,
42,
179,
207,
126,
254,
13,
40,
245,
35,
34,
179,
207,
205,
162,
202,
24,
236,
237,
91,
179,
207,
33,
58,
207,
183,
237,
82,
40,
224,
213,
225,
62,
13,
6,
255,
237,
177,
183,
237,
82,
229,
193,
213,
225,
27,
237,
176,
62,
8,
205,
162,
202,
33,
181,
207,
53,
42,
179,
207,
43,
34,
179,
207,
205,
185,
193,
229,
62,
32,
205,
162,
202,
225,
35,
205,
200,
193,
195,
87,
192,
205,
50,
204,
126,
254,
13,
202,
34,
204,
205,
162,
202,
35,
24,
244,
237,
91,
179,
207,
175,
237,
82,
200,
205,
50,
204,
69,
62,
8,
205,
162,
202,
16,
249,
195,
34,
204,
17,
58,
207,
183,
237,
82,
58,
7,
208,
133,
221,
150,
243,
221,
110,
241,
221,
150,
240,
56,
6,
45,
32,
248,
221,
110,
241,
125,
195,
40,
200,
237,
91,
192,
208,
22,
0,
98,
106,
237,
75,
192,
208,
4,
25,
16,
253,
58,
195,
208,
60,
221,
150,
243,
95,
183,
237,
82,
221,
94,
249,
229,
183,
237,
82,
225,
208,
221,
117,
249,
201,
221,
203,
29,
110,
192,
205,
180,
194,
203,
126,
202,
139,
194,
205,
84,
194,
221,
203,
29,
94,
196,
126,
205,
205,
133,
200,
221,
203,
252,
126,
204,
139,
194,
221,
203,
29,
102,
196,
237,
199,
58,
189,
207,
205,
126,
205,
201,
58,
184,
207,
230,
15,
50,
184,
207,
58,
235,
243,
50,
189,
207,
35,
126,
245,
35,
126,
50,
194,
208,
35,
126,
50,
195,
208,
35,
126,
61,
50,
193,
208,
35,
126,
50,
192,
208,
213,
205,
225,
200,
209,
241,
111,
38,
0,
34,
187,
207,
108,
34,
185,
207,
201,
221,
229,
253,
229,
22,
0,
42,
241,
175,
235,
41,
25,
94,
35,
86,
213,
221,
225,
253,
33,
182,
207,
62,
0,
50,
201,
199,
50,
202,
199,
50,
183,
207,
205,
203,
194,
253,
225,
221,
225,
201,
42,
243,
175,
22,
0,
25,
25,
25,
25,
25,
25,
201,
30,
3,
195,
199,
194,
30,
1,
22,
0,
221,
25,
221,
126,
0,
230,
7,
203,
39,
33,
226,
194,
95,
22,
0,
25,
221,
34,
199,
199,
126,
35,
102,
111,
233,
242,
194,
3,
195,
81,
195,
238,
195,
66,
196,
206,
196,
226,
196,
9,
197,
221,
126,
0,
205,
60,
195,
221,
70,
2,
221,
78,
1,
205,
105,
199,
24,
50,
221,
126,
0,
230,
24,
254,
24,
32,
10,
205,
37,
197,
237,
67,
185,
207,
195,
192,
194,
205,
60,
195,
205,
83,
197,
66,
75,
30,
1,
253,
203,
0,
118,
40,
2,
30,
255,
22,
1,
253,
203,
0,
126,
40,
2,
22,
255,
205,
37,
199,
175,
205,
70,
195,
195,
192,
194,
15,
15,
15,
230,
3,
183,
198,
2,
230,
5,
95,
58,
184,
207,
230,
250,
179,
50,
184,
207,
201,
221,
126,
0,
254,
18,
202,
152,
195,
205,
37,
197,
221,
203,
0,
110,
32,
22,
175,
33,
112,
195,
93,
84,
205,
146,
197,
30,
3,
195,
199,
194,
255,
255,
255,
255,
255,
255,
255,
255,
221,
126,
3,
111,
38,
0,
41,
41,
41,
237,
91,
247,
175,
25,
93,
84,
175,
221,
203,
0,
102,
40,
1,
61,
205,
146,
197,
30,
4,
195,
199,
194,
237,
91,
187,
207,
221,
126,
2,
60,
203,
39,
203,
39,
203,
39,
71,
14,
0,
121,
221,
134,
4,
246,
32,
103,
221,
126,
3,
203,
39,
203,
39,
203,
39,
111,
205,
113,
205,
197,
229,
33,
217,
212,
219,
152,
171,
162,
171,
119,
35,
16,
247,
225,
193,
197,
205,
98,
205,
33,
217,
212,
126,
211,
152,
0,
0,
0,
35,
16,
247,
193,
121,
221,
190,
1,
40,
4,
12,
195,
169,
195,
17,
5,
0,
195,
199,
194,
58,
183,
207,
254,
10,
32,
16,
62,
0,
50,
183,
207,
50,
201,
199,
50,
202,
199,
62,
104,
195,
58,
176,
183,
32,
4,
221,
34,
197,
199,
253,
52,
1,
221,
229,
237,
75,
201,
199,
121,
176,
245,
221,
126,
0,
15,
15,
15,
230,
7,
50,
201,
199,
58,
202,
199,
221,
174,
0,
230,
192,
50,
202,
199,
38,
0,
221,
110,
1,
41,
237,
91,
241,
175,
25,
94,
35,
86,
213,
221,
225,
195,
203,
194,
221,
126,
0,
205,
60,
195,
221,
126,
1,
111,
38,
0,
41,
41,
41,
237,
91,
247,
175,
25,
235,
221,
126,
3,
103,
221,
126,
2,
203,
39,
203,
39,
203,
39,
111,
58,
184,
207,
6,
255,
31,
56,
1,
4,
31,
31,
159,
79,
205,
113,
205,
229,
62,
8,
33,
217,
212,
235,
8,
219,
152,
160,
174,
169,
18,
35,
19,
8,
61,
32,
243,
225,
229,
205,
98,
205,
33,
217,
212,
6,
8,
126,
211,
152,
0,
0,
0,
35,
16,
247,
225,
203,
236,
229,
237,
91,
187,
207,
205,
113,
205,
33,
217,
212,
6,
8,
219,
152,
171,
162,
171,
119,
35,
16,
247,
225,
193,
197,
205,
98,
205,
33,
217,
212,
6,
8,
126,
211,
152,
0,
0,
0,
35,
16,
247,
30,
4,
195,
199,
194,
33,
187,
207,
221,
126,
0,
203,
63,
203,
63,
203,
63,
6,
15,
203,
103,
40,
13,
24,
17,
33,
187,
207,
221,
126,
0,
7,
6,
240,
56,
6,
205,
2,
197,
175,
24,
6,
126,
205,
2,
197,
62,
255,
205,
2,
197,
17,
1,
0,
195,
199,
194,
174,
160,
174,
119,
35,
120,
201,
58,
183,
207,
183,
200,
193,
120,
230,
7,
50,
201,
199,
120,
230,
192,
50,
202,
199,
221,
225,
253,
53,
1,
30,
2,
195,
199,
194,
205,
83,
197,
237,
75,
185,
207,
121,
253,
203,
0,
118,
40,
4,
147,
195,
56,
197,
131,
79,
120,
253,
203,
0,
126,
40,
8,
146,
48,
14,
214,
80,
195,
81,
197,
130,
56,
4,
254,
176,
56,
2,
214,
176,
71,
201,
58,
201,
199,
167,
194,
99,
197,
221,
94,
1,
221,
86,
2,
195,
116,
197,
22,
0,
221,
94,
2,
205,
126,
197,
77,
221,
94,
1,
205,
126,
197,
81,
93,
58,
202,
199,
221,
174,
0,
50,
182,
207,
201,
33,
0,
0,
71,
25,
16,
253,
203,
60,
203,
29,
203,
60,
203,
29,
203,
60,
203,
29,
201,
253,
229,
221,
229,
237,
115,
205,
199,
221,
33,
209,
212,
221,
229,
237,
67,
203,
199,
79,
6,
8,
26,
182,
169,
35,
19,
221,
119,
0,
221,
35,
16,
244,
221,
225,
33,
217,
212,
54,
255,
35,
6,
176,
54,
0,
35,
16,
251,
54,
255,
237,
75,
203,
199,
22,
0,
205,
16,
199,
205,
113,
205,
219,
152,
163,
194,
7,
199,
62,
30,
8,
33,
255,
255,
229,
122,
230,
252,
87,
205,
16,
199,
120,
203,
122,
40,
4,
4,
195,
238,
197,
5,
197,
217,
111,
38,
0,
17,
218,
212,
25,
229,
253,
225,
230,
7,
50,
1,
198,
221,
86,
0,
193,
120,
254,
176,
220,
16,
199,
217,
203,
122,
217,
40,
6,
253,
78,
1,
195,
24,
198,
253,
78,
255,
217,
203,
59,
48,
20,
30,
128,
35,
35,
35,
35,
35,
35,
35,
35,
217,
35,
35,
35,
35,
35,
35,
35,
35,
217,
12,
40,
8,
205,
113,
205,
219,
152,
163,
40,
221,
13,
253,
113,
0,
195,
158,
198,
205,
113,
205,
219,
152,
50,
208,
212,
163,
194,
237,
198,
205,
98,
205,
217,
122,
217,
163,
221,
182,
255,
211,
152,
213,
205,
146,
199,
209,
121,
183,
202,
237,
198,
203,
74,
32,
52,
217,
95,
121,
183,
202,
124,
198,
187,
218,
124,
198,
217,
122,
246,
3,
87,
195,
157,
198,
205,
113,
205,
219,
152,
217,
163,
32,
1,
55,
203,
66,
194,
152,
198,
48,
16,
8,
61,
40,
101,
8,
197,
203,
194,
195,
157,
198,
218,
157,
198,
203,
130,
13,
203,
35,
210,
67,
198,
30,
1,
43,
43,
43,
43,
43,
43,
43,
43,
205,
113,
205,
219,
152,
217,
43,
43,
43,
43,
43,
43,
43,
43,
183,
32,
43,
217,
203,
74,
217,
32,
14,
205,
113,
205,
219,
152,
183,
32,
29,
217,
203,
66,
217,
40,
23,
217,
205,
98,
205,
217,
122,
217,
211,
152,
213,
205,
146,
199,
209,
121,
214,
8,
79,
56,
7,
195,
165,
198,
217,
195,
67,
198,
8,
60,
8,
193,
120,
60,
194,
221,
197,
237,
75,
203,
199,
203,
122,
32,
9,
203,
250,
4,
120,
254,
176,
218,
202,
197,
237,
123,
205,
199,
221,
225,
253,
225,
201,
197,
205,
170,
199,
1,
29,
199,
129,
79,
10,
95,
193,
201,
128,
64,
32,
16,
8,
4,
2,
1,
121,
184,
48,
6,
105,
213,
175,
95,
24,
7,
177,
200,
104,
65,
213,
22,
0,
96,
120,
31,
133,
56,
3,
188,
56,
7,
148,
79,
217,
193,
197,
24,
4,
79,
213,
217,
193,
42,
185,
207,
120,
132,
71,
121,
60,
133,
56,
13,
40,
13,
61,
79,
205,
105,
199,
217,
121,
16,
217,
209,
201,
40,
243,
62,
103,
195,
58,
176,
237,
67,
185,
207,
205,
170,
199,
71,
4,
62,
254,
15,
16,
253,
71,
205,
113,
205,
219,
152,
253,
78,
2,
203,
65,
32,
1,
160,
203,
81,
32,
2,
168,
47,
71,
205,
98,
205,
120,
211,
152,
203,
236,
237,
91,
187,
207,
205,
113,
205,
219,
152,
171,
162,
171,
245,
205,
98,
205,
241,
211,
152,
203,
172,
201,
62,
175,
144,
218,
100,
199,
71,
230,
7,
111,
121,
230,
248,
181,
111,
120,
203,
63,
203,
63,
203,
63,
103,
121,
230,
7,
201,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
205,
84,
202,
46,
16,
205,
148,
189,
205,
84,
202,
58,
193,
208,
60,
205,
40,
200,
221,
203,
49,
86,
40,
6,
58,
0,
209,
183,
32,
12,
213,
205,
239,
206,
118,
205,
156,
0,
40,
251,
24,
36,
213,
221,
86,
48,
30,
0,
203,
58,
203,
27,
203,
58,
203,
27,
24,
1,
213,
205,
239,
206,
118,
205,
156,
0,
32,
10,
205,
56,
207,
27,
122,
179,
32,
243,
24,
4,
205,
159,
0,
55,
245,
205,
250,
206,
241,
209,
201,
50,
190,
208,
221,
229,
197,
221,
33,
36,
208,
17,
16,
0,
6,
8,
221,
126,
10,
221,
119,
7,
221,
25,
16,
246,
193,
221,
225,
201,
221,
190,
230,
200,
245,
205,
84,
202,
58,
182,
208,
205,
116,
200,
235,
33,
183,
208,
1,
16,
0,
237,
176,
241,
245,
50,
182,
208,
205,
116,
200,
17,
183,
208,
1,
16,
0,
237,
176,
58,
187,
208,
50,
187,
207,
241,
201,
33,
36,
208,
7,
7,
7,
7,
95,
22,
0,
25,
201,
221,
203,
29,
118,
192,
197,
229,
213,
205,
147,
202,
205,
149,
200,
205,
173,
204,
209,
225,
193,
201,
58,
194,
208,
50,
197,
208,
205,
94,
205,
34,
188,
208,
58,
195,
208,
50,
196,
208,
58,
193,
208,
50,
190,
208,
201,
122,
221,
190,
242,
56,
25,
58,
194,
208,
221,
134,
241,
186,
56,
16,
123,
221,
190,
243,
56,
10,
58,
195,
208,
221,
134,
240,
61,
187,
48,
6,
221,
94,
243,
221,
86,
242,
221,
115,
244,
122,
50,
197,
208,
205,
94,
205,
34,
188,
208,
201,
58,
194,
208,
221,
134,
241,
254,
24,
56,
8,
62,
23,
221,
150,
242,
50,
193,
208,
58,
195,
208,
221,
134,
240,
254,
43,
216,
62,
42,
221,
150,
243,
50,
192,
208,
201,
62,
13,
221,
229,
221,
33,
208,
208,
254,
128,
56,
35,
221,
203,
253,
86,
40,
29,
229,
42,
8,
1,
214,
127,
203,
126,
35,
40,
251,
61,
32,
248,
126,
198,
128,
56,
11,
198,
128,
205,
50,
201,
35,
24,
243,
221,
229,
229,
213,
197,
254,
13,
40,
74,
254,
16,
56,
90,
221,
203,
246,
70,
40,
2,
246,
128,
221,
203,
246,
118,
40,
51,
254,
32,
40,
32,
254,
160,
40,
28,
245,
58,
220,
207,
254,
40,
204,
84,
202,
241,
221,
203,
246,
174,
42,
5,
208,
119,
35,
34,
5,
208,
33,
220,
207,
52,
24,
34,
221,
203,
246,
110,
32,
28,
245,
205,
84,
202,
241,
221,
203,
246,
110,
204,
44,
202,
24,
14,
205,
84,
202,
221,
203,
246,
126,
221,
203,
246,
190,
204,
199,
201,
193,
209,
225,
221,
225,
201,
254,
15,
32,
6,
221,
203,
246,
134,
24,
240,
254,
14,
32,
6,
221,
203,
246,
198,
24,
230,
245,
205,
84,
202,
241,
254,
11,
32,
5,
205,
133,
200,
24,
216,
254,
12,
32,
212,
58,
193,
208,
205,
222,
199,
24,
204,
62,
13,
205,
162,
202,
33,
190,
208,
53,
192,
58,
193,
208,
119,
221,
203,
252,
118,
192,
221,
203,
246,
78,
192,
205,
40,
200,
46,
32,
205,
26,
189,
58,
198,
208,
245,
62,
2,
50,
198,
208,
126,
47,
254,
10,
40,
6,
35,
205,
7,
201,
24,
244,
241,
50,
198,
208,
221,
203,
49,
78,
40,
11,
58,
0,
209,
183,
40,
5,
205,
249,
199,
24,
3,
205,
237,
199,
58,
196,
208,
221,
190,
243,
200,
62,
8,
205,
162,
202,
62,
32,
205,
162,
202,
62,
8,
205,
162,
202,
24,
232,
95,
213,
205,
162,
202,
209,
221,
203,
246,
190,
58,
196,
208,
221,
190,
243,
192,
123,
254,
32,
32,
10,
221,
203,
246,
118,
40,
4,
221,
203,
246,
238,
205,
204,
201,
221,
203,
246,
254,
201,
221,
203,
246,
118,
200,
58,
220,
207,
183,
200,
58,
195,
208,
221,
134,
240,
33,
196,
208,
150,
33,
220,
207,
190,
40,
13,
48,
15,
58,
196,
208,
221,
190,
243,
196,
199,
201,
24,
4,
221,
203,
246,
238,
237,
75,
219,
207,
33,
221,
207,
126,
229,
197,
205,
44,
202,
193,
225,
35,
16,
245,
24,
4,
221,
203,
246,
174,
33,
221,
207,
34,
5,
208,
175,
50,
220,
207,
201,
229,
213,
197,
245,
205,
191,
202,
241,
254,
8,
204,
209,
202,
254,
13,
204,
252,
202,
183,
196,
45,
203,
205,
191,
202,
193,
209,
225,
201,
221,
203,
246,
94,
200,
221,
203,
246,
230,
62,
95,
205,
45,
203,
221,
203,
246,
166,
33,
196,
208,
58,
195,
208,
190,
40,
3,
53,
24,
29,
33,
194,
208,
58,
197,
208,
190,
40,
20,
61,
50,
197,
208,
205,
94,
205,
34,
188,
208,
58,
195,
208,
221,
134,
240,
61,
50,
196,
208,
175,
201,
58,
195,
208,
221,
134,
240,
221,
190,
244,
40,
7,
62,
32,
205,
45,
203,
24,
238,
33,
197,
208,
58,
194,
208,
221,
134,
241,
190,
40,
8,
52,
126,
205,
94,
205,
34,
188,
208,
204,
60,
204,
58,
195,
208,
50,
196,
208,
175,
201,
245,
58,
195,
208,
221,
134,
240,
221,
190,
244,
194,
61,
203,
205,
252,
202,
58,
196,
208,
205,
79,
205,
230,
3,
203,
79,
40,
1,
35,
203,
37,
203,
20,
203,
37,
203,
20,
203,
37,
203,
20,
237,
91,
188,
208,
25,
245,
221,
203,
253,
254,
205,
113,
205,
6,
16,
17,
191,
207,
219,
152,
0,
0,
0,
18,
19,
16,
247,
221,
203,
253,
190,
241,
227,
229,
7,
22,
0,
95,
1,
255,
255,
221,
203,
246,
102,
32,
7,
33,
26,
204,
25,
78,
35,
70,
203,
3,
203,
3,
33,
250,
203,
25,
34,
171,
203,
237,
91,
247,
175,
241,
111,
38,
0,
41,
41,
41,
25,
17,
191,
207,
62,
8,
8,
229,
205,
250,
203,
26,
160,
172,
18,
19,
19,
19,
19,
19,
19,
19,
19,
26,
161,
173,
18,
27,
27,
27,
27,
27,
27,
27,
225,
35,
8,
61,
32,
222,
225,
221,
203,
253,
254,
205,
98,
205,
17,
191,
207,
6,
16,
26,
211,
152,
0,
0,
0,
19,
16,
247,
203,
236,
205,
98,
205,
58,
187,
207,
6,
16,
211,
152,
0,
0,
0,
16,
249,
221,
203,
253,
190,
33,
196,
208,
52,
201,
102,
46,
0,
201,
0,
0,
0,
0,
110,
38,
0,
41,
41,
201,
0,
0,
110,
38,
0,
41,
41,
41,
41,
201,
110,
38,
0,
203,
61,
203,
61,
201,
255,
3,
15,
252,
63,
240,
192,
255,
229,
221,
203,
246,
94,
32,
17,
221,
203,
246,
222,
205,
196,
202,
24,
8,
229,
205,
191,
202,
221,
203,
246,
158,
225,
201,
205,
244,
204,
58,
193,
208,
221,
78,
242,
183,
40,
97,
71,
58,
191,
208,
203,
39,
203,
39,
203,
39,
221,
203,
253,
254,
197,
245,
121,
60,
205,
47,
205,
205,
113,
205,
241,
245,
71,
17,
217,
212,
219,
152,
0,
0,
0,
18,
19,
16,
247,
203,
236,
205,
113,
205,
241,
245,
71,
219,
152,
18,
19,
16,
250,
121,
205,
47,
205,
205,
98,
205,
241,
245,
71,
17,
217,
212,
26,
211,
152,
0,
0,
0,
19,
16,
247,
203,
236,
205,
98,
205,
241,
245,
71,
26,
211,
152,
0,
0,
0,
19,
16,
247,
241,
193,
12,
16,
173,
6,
1,
24,
7,
221,
70,
241,
4,
221,
78,
242,
205,
244,
204,
50,
191,
208,
203,
39,
203,
39,
203,
39,
221,
203,
253,
254,
197,
245,
121,
205,
47,
205,
205,
98,
205,
241,
245,
71,
175,
211,
152,
0,
0,
0,
16,
249,
203,
236,
205,
98,
205,
241,
245,
71,
58,
187,
207,
211,
152,
0,
0,
0,
16,
249,
241,
193,
12,
16,
213,
221,
203,
253,
190,
201,
197,
229,
58,
192,
208,
71,
203,
63,
203,
63,
79,
135,
129,
79,
58,
195,
208,
230,
3,
203,
39,
203,
39,
95,
120,
230,
3,
131,
95,
22,
0,
33,
31,
205,
25,
126,
129,
50,
191,
208,
225,
193,
201,
0,
1,
2,
3,
1,
2,
3,
3,
1,
2,
2,
3,
1,
1,
2,
3,
205,
94,
205,
229,
58,
195,
208,
205,
79,
205,
230,
3,
40,
3,
61,
95,
25,
203,
37,
203,
20,
203,
37,
203,
20,
203,
37,
203,
20,
209,
25,
201,
95,
203,
59,
203,
59,
22,
0,
33,
0,
0,
25,
25,
25,
201,
201,
103,
46,
0,
201,
125,
243,
211,
153,
124,
230,
63,
246,
64,
211,
153,
251,
227,
227,
201,
125,
243,
211,
153,
124,
230,
63,
211,
153,
251,
227,
227,
201,
50,
235,
243,
205,
239,
206,
205,
98,
0,
195,
250,
206,
253,
229,
205,
239,
206,
243,
209,
1,
15,
0,
175,
205,
172,
205,
253,
78,
3,
253,
70,
4,
253,
94,
5,
253,
86,
6,
62,
255,
205,
172,
205,
195,
250,
206,
197,
213,
245,
205,
234,
0,
241,
205,
237,
0,
33,
0,
0,
209,
193,
197,
213,
26,
95,
22,
0,
25,
229,
205,
237,
0,
205,
183,
0,
56,
22,
225,
209,
193,
19,
11,
120,
177,
32,
231,
125,
205,
237,
0,
205,
240,
0,
201,
205,
231,
0,
24,
3,
205,
240,
0,
205,
250,
206,
62,
101,
195,
58,
176,
205,
239,
206,
243,
17,
217,
214,
1,
15,
0,
175,
205,
110,
206,
32,
244,
221,
203,
252,
246,
33,
205,
206,
6,
7,
205,
197,
206,
33,
224,
214,
6,
8,
205,
197,
206,
205,
5,
201,
221,
203,
252,
182,
253,
229,
225,
17,
7,
0,
25,
17,
224,
214,
6,
8,
26,
190,
35,
19,
32,
199,
16,
248,
221,
203,
252,
246,
33,
212,
206,
6,
11,
205,
197,
206,
221,
203,
252,
182,
253,
126,
3,
253,
70,
4,
79,
176,
32,
6,
237,
75,
220,
214,
24,
10,
42,
220,
214,
183,
237,
66,
48,
2,
77,
68,
253,
126,
5,
253,
86,
6,
95,
178,
32,
4,
237,
91,
222,
214,
62,
255,
205,
110,
206,
194,
189,
206,
195,
250,
206,
213,
197,
245,
205,
225,
0,
218,
220,
205,
205,
228,
0,
218,
186,
206,
111,
241,
189,
33,
0,
0,
193,
209,
40,
7,
205,
231,
0,
62,
255,
183,
201,
197,
213,
229,
205,
228,
0,
218,
186,
206,
225,
209,
18,
79,
6,
0,
9,
205,
183,
0,
218,
220,
205,
193,
19,
11,
120,
177,
32,
227,
229,
205,
228,
0,
218,
186,
206,
205,
231,
0,
225,
189,
32,
4,
201,
205,
231,
0,
205,
250,
206,
62,
102,
195,
58,
176,
126,
205,
7,
201,
35,
16,
249,
201,
70,
111,
117,
110,
100,
58,
32,
76,
111,
97,
100,
105,
110,
103,
46,
46,
46,
13,
95,
10,
254,
14,
208,
245,
205,
239,
206,
241,
205,
147,
0,
195,
250,
206,
243,
58,
8,
176,
211,
168,
50,
190,
207,
251,
201,
243,
58,
9,
176,
211,
168,
50,
190,
207,
251,
201,
243,
245,
229,
221,
229,
58,
190,
207,
245,
58,
9,
176,
211,
168,
50,
190,
207,
42,
17,
176,
221,
33,
208,
208,
205,
16,
176,
58,
8,
176,
211,
168,
50,
190,
207,
0,
0,
255,
243,
241,
211,
168,
50,
190,
207,
221,
225,
225,
241,
251,
201,
118,
201,
243,
58,
9,
176,
211,
168,
50,
190,
207,
6,
0,
33,
0,
217,
62,
216,
119,
35,
16,
252,
119,
62,
217,
237,
71,
62,
195,
50,
216,
216,
33,
5,
207,
34,
217,
216,
33,
34,
1,
17,
10,
176,
62,
3,
8,
78,
35,
70,
35,
120,
177,
40,
12,
235,
62,
195,
119,
35,
113,
35,
112,
35,
235,
24,
3,
19,
19,
19,
8,
61,
32,
228,
58,
2,
1,
50,
202,
208,
237,
115,
213,
207,
221,
33,
208,
208,
237,
94,
251,
221,
203,
253,
150,
42,
8,
1,
125,
180,
202,
92,
176,
221,
203,
253,
214,
195,
92,
176,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
58,
207,
0,
0,
0,
0,
0,
0,
241,
0,
0,
0,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
0,
0,
0,
0,
0,
0,
0,
0,
0,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
221,
207,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
249,
0,
0,
3,
13,
16,
3,
0,
0,
0,
0,
64,
0,
0,
0,
255,
255,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
120,
0,
0,
0,
0,
0,
0,]

sTerpList=[
195,
207,
207,
103,
33,
255,
255,
255,
240,
255,
201,
0,
0,
195,
116,
207,
201,
0,
0,
195,
121,
207,
195,
38,
190,
195,
216,
200,
195,
154,
201,
195,
231,
202,
195,
128,
200,
195,
140,
200,
195,
45,
176,
1,
15,
221,
203,
255,
198,
225,
43,
43,
43,
43,
34,
166,
208,
122,
50,
105,
208,
221,
33,
103,
209,
221,
203,
255,
182,
58,
109,
208,
183,
32,
8,
62,
8,
205,
216,
200,
205,
64,
205,
205,
120,
176,
205,
231,
202,
205,
128,
200,
221,
203,
255,
150,
205,
38,
203,
33,
207,
207,
54,
13,
34,
72,
208,
221,
54,
249,
120,
42,
108,
208,
124,
183,
202,
202,
176,
233,
205,
152,
201,
58,
105,
208,
33,
190,
176,
221,
203,
255,
70,
32,
17,
33,
173,
176,
254,
101,
40,
28,
33,
179,
176,
254,
102,
40,
21,
33,
183,
176,
95,
213,
205,
241,
189,
209,
205,
160,
189,
221,
203,
255,
70,
221,
203,
255,
134,
201,
195,
241,
189,
189,
173,
186,
190,
180,
245,
182,
208,
176,
223,
186,
141,
141,
144,
141,
223,
245,
184,
158,
146,
154,
223,
186,
141,
141,
144,
141,
223,
245,
237,
123,
106,
208,
205,
132,
207,
62,
2,
205,
95,
0,
58,
43,
176,
50,
235,
243,
50,
234,
243,
58,
44,
176,
50,
233,
243,
205,
98,
0,
205,
143,
207,
17,
187,
208,
62,
8,
33,
171,
208,
1,
16,
0,
237,
176,
61,
32,
245,
50,
77,
209,
17,
78,
209,
33,
171,
208,
1,
16,
0,
237,
176,
58,
82,
209,
95,
22,
0,
237,
83,
80,
208,
33,
103,
209,
229,
221,
225,
175,
71,
119,
35,
16,
252,
221,
203,
29,
254,
205,
45,
177,
194,
92,
176,
205,
132,
207,
199,
237,
115,
162,
208,
175,
50,
165,
208,
205,
94,
189,
175,
245,
50,
168,
208,
50,
164,
208,
175,
190,
32,
24,
209,
122,
183,
40,
5,
225,
193,
195,
232,
181,
33,
164,
208,
190,
200,
123,
50,
165,
208,
53,
193,
225,
24,
32,
126,
35,
254,
255,
40,
5,
221,
190,
33,
32,
10,
126,
254,
255,
40,
11,
221,
190,
34,
40,
6,
35,
35,
35,
195,
64,
177,
35,
78,
35,
70,
35,
10,
254,
255,
40,
191,
50,
98,
209,
229,
22,
0,
203,
39,
95,
3,
10,
33,
140,
183,
25,
94,
35,
86,
213,
22,
0,
95,
221,
203,
251,
126,
40,
6,
33,
103,
209,
25,
126,
95,
33,
103,
210,
25,
229,
33,
103,
209,
25,
209,
201,
221,
190,
38,
40,
97,
24,
12,
221,
190,
38,
32,
90,
24,
5,
221,
190,
38,
56,
83,
225,
195,
64,
177,
221,
190,
38,
56,
247,
40,
245,
24,
70,
26,
221,
190,
38,
40,
64,
254,
253,
48,
60,
24,
231,
26,
221,
190,
38,
40,
225,
254,
253,
48,
221,
24,
46,
26,
254,
253,
40,
41,
24,
212,
26,
254,
253,
32,
34,
24,
205,
26,
254,
254,
32,
200,
24,
25,
26,
254,
254,
40,
193,
24,
18,
205,
125,
189,
188,
48,
12,
24,
183,
126,
183,
32,
179,
24,
4,
126,
183,
40,
173,
3,
225,
195,
124,
177,
3,
10,
190,
32,
163,
24,
244,
205,
13,
181,
24,
246,
3,
10,
190,
40,
151,
24,
232,
205,
13,
181,
24,
246,
205,
13,
181,
24,
2,
3,
10,
190,
56,
217,
24,
132,
205,
13,
181,
24,
2,
3,
10,
190,
218,
193,
177,
202,
193,
177,
195,
20,
178,
221,
190,
35,
40,
193,
195,
193,
177,
221,
190,
36,
24,
246,
221,
190,
43,
24,
241,
221,
190,
44,
24,
236,
221,
190,
45,
24,
231,
46,
12,
197,
205,
79,
192,
193,
126,
46,
30,
205,
110,
189,
47,
190,
194,
193,
177,
195,
87,
180,
46,
13,
205,
79,
192,
126,
46,
31,
205,
110,
189,
47,
150,
40,
11,
175,
50,
141,
209,
237,
123,
162,
208,
195,
49,
177,
237,
123,
162,
208,
183,
201,
221,
203,
255,
150,
205,
232,
189,
225,
221,
203,
255,
230,
195,
68,
177,
46,
15,
24,
241,
197,
205,
98,
200,
193,
195,
87,
180,
3,
205,
10,
176,
195,
86,
180,
3,
205,
13,
176,
195,
86,
180,
197,
205,
24,
201,
193,
195,
87,
180,
221,
54,
1,
0,
33,
103,
210,
126,
254,
255,
202,
87,
180,
254,
253,
56,
4,
58,
141,
209,
119,
35,
24,
239,
197,
58,
141,
209,
1,
253,
254,
205,
86,
185,
193,
46,
26,
202,
132,
179,
11,
205,
163,
185,
26,
46,
25,
254,
253,
48,
72,
44,
221,
190,
38,
32,
127,
58,
154,
209,
205,
207,
184,
205,
169,
184,
46,
43,
132,
56,
113,
33,
155,
209,
190,
40,
4,
46,
43,
48,
103,
46,
36,
38,
27,
229,
58,
104,
209,
33,
140,
209,
190,
48,
13,
235,
54,
254,
221,
52,
1,
225,
205,
232,
189,
195,
86,
180,
225,
108,
58,
168,
208,
183,
202,
159,
178,
58,
3,
1,
50,
168,
208,
195,
159,
178,
205,
71,
185,
40,
49,
11,
205,
163,
185,
26,
254,
253,
46,
24,
40,
237,
46,
49,
221,
190,
38,
40,
230,
46,
28,
254,
254,
32,
224,
58,
141,
209,
18,
221,
53,
1,
46,
39,
24,
192,
197,
62,
253,
6,
254,
205,
83,
185,
193,
11,
32,
12,
46,
23,
56,
2,
46,
8,
195,
159,
178,
205,
163,
185,
26,
46,
50,
254,
254,
40,
243,
221,
190,
38,
40,
238,
46,
23,
254,
253,
32,
232,
205,
42,
185,
44,
48,
226,
46,
38,
38,
42,
195,
37,
179,
197,
6,
253,
205,
81,
185,
193,
46,
28,
40,
204,
11,
205,
163,
185,
26,
46,
49,
221,
190,
38,
40,
196,
46,
29,
254,
253,
40,
190,
45,
56,
187,
205,
42,
185,
48,
182,
235,
54,
253,
221,
53,
1,
46,
37,
195,
54,
179,
95,
22,
0,
197,
205,
156,
200,
193,
24,
111,
50,
141,
209,
24,
106,
237,
91,
14,
1,
33,
4,
1,
24,
20,
221,
203,
255,
246,
237,
91,
16,
1,
33,
5,
1,
24,
7,
237,
91,
18,
1,
33,
6,
1,
190,
48,
15,
235,
22,
0,
95,
25,
25,
94,
35,
86,
235,
205,
241,
189,
24,
59,
22,
7,
195,
45,
176,
205,
163,
185,
235,
126,
254,
254,
54,
252,
32,
43,
221,
53,
1,
24,
38,
205,
163,
185,
26,
254,
254,
58,
141,
209,
18,
24,
237,
3,
10,
205,
163,
185,
111,
38,
0,
26,
213,
17,
103,
210,
25,
86,
119,
225,
114,
24,
6,
54,
255,
24,
2,
54,
0,
3,
225,
221,
203,
255,
230,
195,
124,
177,
3,
87,
10,
134,
48,
34,
62,
255,
24,
30,
3,
10,
87,
126,
146,
48,
1,
175,
119,
24,
226,
3,
245,
10,
229,
95,
22,
0,
33,
103,
209,
25,
94,
225,
241,
24,
5,
3,
87,
10,
95,
122,
254,
38,
32,
12,
58,
4,
1,
187,
22,
1,
218,
45,
176,
202,
45,
176,
115,
24,
186,
205,
152,
201,
24,
182,
94,
35,
86,
205,
162,
189,
24,
173,
94,
205,
160,
189,
24,
167,
3,
235,
10,
205,
35,
185,
190,
194,
193,
177,
195,
20,
178,
3,
235,
10,
205,
35,
185,
190,
194,
20,
178,
195,
193,
177,
205,
163,
185,
3,
235,
10,
205,
35,
185,
245,
126,
24,
29,
205,
35,
185,
245,
58,
154,
209,
24,
17,
126,
254,
255,
32,
6,
22,
2,
195,
45,
176,
26,
245,
3,
10,
205,
163,
185,
205,
62,
185,
254,
254,
32,
3,
221,
53,
1,
241,
254,
254,
32,
3,
221,
52,
1,
119,
195,
86,
180,
235,
205,
14,
181,
195,
135,
180,
235,
3,
10,
197,
79,
6,
0,
33,
103,
209,
9,
26,
95,
81,
193,
201,
205,
13,
181,
195,
98,
180,
205,
13,
181,
195,
107,
180,
221,
86,
38,
221,
203,
255,
206,
205,
32,
186,
195,
87,
180,
197,
183,
32,
5,
205,
212,
186,
24,
3,
205,
200,
186,
193,
218,
20,
178,
221,
203,
255,
230,
195,
193,
177,
205,
35,
185,
87,
221,
203,
255,
142,
205,
32,
186,
195,
86,
180,
3,
33,
7,
1,
190,
48,
38,
183,
40,
35,
205,
94,
189,
245,
58,
164,
208,
60,
50,
164,
208,
254,
10,
202,
141,
181,
241,
197,
237,
91,
165,
208,
22,
0,
213,
50,
165,
208,
221,
203,
255,
166,
195,
64,
177,
22,
6,
195,
45,
176,
241,
22,
3,
195,
45,
176,
225,
58,
165,
208,
205,
94,
189,
195,
64,
177,
50,
151,
209,
3,
10,
95,
22,
248,
24,
26,
3,
195,
86,
180,
50,
140,
209,
3,
10,
50,
155,
209,
195,
86,
180,
50,
144,
209,
3,
10,
7,
7,
7,
95,
22,
199,
58,
152,
209,
171,
162,
171,
50,
152,
209,
195,
86,
180,
221,
203,
255,
150,
195,
87,
180,
205,
35,
185,
50,
153,
209,
58,
168,
208,
183,
22,
4,
194,
45,
176,
225,
221,
203,
255,
166,
197,
229,
17,
0,
255,
213,
229,
197,
58,
168,
208,
95,
58,
153,
209,
205,
248,
185,
48,
39,
50,
137,
209,
221,
190,
44,
35,
126,
50,
138,
209,
32,
13,
58,
148,
209,
254,
255,
40,
3,
190,
32,
3,
225,
24,
222,
123,
50,
168,
208,
61,
205,
163,
185,
209,
193,
195,
86,
180,
175,
50,
168,
208,
193,
225,
225,
225,
225,
195,
68,
177,
245,
205,
14,
181,
241,
229,
205,
207,
184,
124,
225,
195,
135,
180,
87,
205,
169,
184,
195,
135,
180,
229,
205,
125,
189,
87,
124,
225,
195,
135,
180,
50,
110,
208,
205,
71,
185,
202,
132,
179,
24,
8,
205,
163,
185,
3,
10,
50,
110,
208,
26,
254,
253,
46,
24,
202,
159,
178,
46,
49,
221,
190,
38,
202,
159,
178,
254,
254,
46,
28,
194,
159,
178,
58,
110,
208,
18,
221,
53,
1,
46,
44,
205,
217,
182,
195,
54,
179,
50,
110,
208,
197,
1,
253,
254,
205,
86,
185,
32,
7,
58,
141,
209,
71,
205,
83,
185,
193,
32,
8,
58,
110,
208,
56,
47,
195,
134,
179,
58,
110,
208,
24,
5,
205,
163,
185,
3,
10,
103,
26,
46,
25,
254,
253,
210,
159,
178,
188,
32,
14,
124,
213,
205,
62,
185,
209,
254,
253,
210,
33,
179,
195,
9,
179,
46,
45,
221,
190,
38,
124,
40,
2,
46,
52,
205,
217,
182,
195,
159,
178,
245,
205,
232,
189,
241,
221,
203,
253,
230,
221,
203,
253,
238,
205,
253,
188,
46,
51,
201,
197,
6,
253,
205,
81,
185,
193,
195,
87,
180,
197,
42,
24,
1,
17,
103,
210,
126,
237,
160,
254,
254,
56,
249,
32,
236,
221,
52,
1,
24,
242,
221,
203,
255,
166,
225,
195,
68,
177,
197,
126,
229,
33,
4,
1,
190,
220,
174,
186,
225,
193,
210,
193,
177,
119,
195,
86,
180,
221,
203,
255,
102,
194,
21,
178,
195,
193,
177,
221,
203,
255,
102,
194,
193,
177,
195,
21,
178,
38,
0,
111,
203,
37,
48,
1,
37,
41,
209,
25,
195,
64,
177,
254,
255,
40,
3,
50,
136,
209,
3,
10,
254,
255,
40,
3,
50,
137,
209,
195,
86,
180,
205,
163,
185,
195,
86,
180,
62,
32,
205,
154,
201,
195,
87,
180,
205,
140,
184,
194,
20,
178,
195,
193,
177,
205,
140,
184,
194,
193,
177,
195,
20,
178,
111,
3,
10,
3,
103,
205,
134,
183,
195,
87,
180,
233,
22,
5,
195,
45,
176,
174,
177,
181,
177,
188,
177,
197,
177,
206,
177,
218,
177,
230,
177,
237,
177,
244,
177,
251,
177,
2,
178,
10,
178,
16,
178,
25,
178,
54,
178,
66,
178,
78,
178,
86,
178,
193,
178,
236,
179,
106,
178,
127,
178,
166,
178,
174,
178,
178,
178,
179,
191,
212,
191,
161,
180,
92,
190,
200,
178,
208,
178,
232,
178,
78,
179,
173,
179,
118,
179,
221,
179,
72,
183,
231,
179,
245,
179,
139,
179,
249,
178,
84,
179,
185,
179,
32,
180,
48,
180,
60,
180,
201,
180,
80,
180,
84,
180,
95,
180,
105,
180,
132,
180,
156,
180,
169,
180,
2,
180,
175,
180,
91,
183,
97,
183,
105,
183,
114,
183,
41,
181,
186,
178,
121,
191,
137,
191,
44,
191,
48,
191,
55,
191,
81,
191,
91,
178,
96,
178,
101,
178,
29,
181,
35,
181,
54,
181,
77,
181,
91,
181,
32,
178,
249,
179,
221,
190,
37,
178,
44,
178,
56,
190,
245,
190,
157,
181,
71,
190,
212,
181,
167,
181,
167,
181,
188,
180,
47,
182,
89,
182,
170,
182,
205,
181,
171,
181,
61,
182,
68,
182,
182,
181,
130,
190,
150,
190,
186,
190,
236,
182,
123,
183,
214,
180,
11,
183,
78,
182,
135,
182,
19,
183,
17,
191,
147,
181,
229,
190,
153,
178,
89,
191,
61,
178,
49,
178,
38,
183,
48,
183,
58,
183,
146,
178,
173,
190,
7,
181,
135,
183,
233,
180,
135,
183,
223,
180,
135,
183,
6,
181,
116,
180,
246,
182,
103,
15,
15,
15,
230,
31,
111,
62,
59,
149,
50,
166,
184,
124,
7,
7,
7,
230,
56,
246,
70,
50,
167,
184,
221,
203,
0,
0,
201,
175,
229,
213,
197,
237,
75,
2,
1,
79,
17,
103,
210,
245,
26,
254,
253,
105,
38,
0,
212,
208,
184,
241,
132,
48,
4,
62,
255,
24,
4,
12,
19,
16,
234,
193,
209,
225,
201,
111,
235,
175,
87,
50,
112,
208,
205,
220,
184,
235,
125,
201,
229,
213,
197,
205,
54,
185,
230,
127,
198,
192,
203,
183,
203,
191,
48,
43,
230,
63,
40,
38,
79,
58,
112,
208,
60,
50,
112,
208,
254,
10,
40,
21,
121,
237,
75,
2,
1,
75,
30,
0,
87,
33,
103,
210,
126,
185,
204,
220,
184,
35,
28,
16,
247,
33,
112,
208,
53,
122,
55,
193,
209,
225,
245,
130,
87,
48,
2,
22,
255,
241,
201,
254,
255,
192,
58,
141,
209,
201,
213,
221,
94,
51,
205,
54,
185,
209,
46,
40,
7,
201,
22,
0,
42,
28,
1,
25,
126,
201,
95,
22,
0,
33,
103,
210,
25,
126,
201,
197,
6,
253,
205,
81,
185,
193,
46,
28,
201,
62,
254,
221,
78,
38,
50,
154,
209,
58,
137,
209,
60,
55,
40,
28,
197,
221,
70,
51,
205,
136,
185,
56,
23,
193,
205,
136,
185,
56,
18,
65,
205,
136,
185,
56,
12,
6,
255,
205,
136,
185,
56,
6,
62,
255,
24,
35,
193,
183,
43,
235,
43,
125,
24,
27,
30,
0,
205,
249,
185,
208,
205,
150,
185,
225,
32,
246,
55,
201,
221,
190,
34,
192,
58,
138,
209,
254,
255,
200,
35,
190,
201,
245,
229,
213,
33,
0,
0,
34,
157,
209,
34,
159,
209,
34,
161,
209,
95,
50,
154,
209,
254,
255,
40,
49,
33,
3,
1,
190,
48,
47,
205,
54,
185,
23,
221,
203,
57,
30,
23,
221,
203,
56,
30,
205,
65,
185,
50,
157,
209,
235,
205,
208,
184,
221,
116,
55,
38,
0,
235,
42,
30,
1,
25,
25,
126,
50,
162,
209,
35,
126,
50,
161,
209,
209,
225,
241,
201,
209,
225,
241,
241,
22,
0,
195,
45,
176,
71,
33,
103,
210,
22,
0,
25,
58,
3,
1,
187,
200,
120,
19,
254,
255,
40,
1,
190,
35,
32,
241,
227,
229,
213,
29,
42,
26,
1,
25,
25,
126,
254,
255,
209,
216,
225,
227,
24,
223,
197,
1,
0,
0,
197,
221,
203,
53,
190,
221,
203,
253,
166,
221,
203,
253,
238,
33,
103,
210,
9,
126,
254,
255,
40,
74,
186,
32,
43,
97,
46,
0,
227,
229,
241,
221,
203,
53,
126,
32,
28,
221,
203,
53,
254,
221,
203,
255,
78,
40,
12,
46,
1,
205,
232,
189,
221,
203,
53,
118,
204,
152,
201,
227,
46,
1,
227,
24,
3,
205,
107,
186,
3,
24,
198,
221,
203,
53,
118,
32,
7,
111,
205,
103,
189,
195,
237,
189,
56,
7,
245,
46,
46,
205,
232,
189,
241,
195,
253,
188,
241,
193,
221,
203,
53,
126,
40,
24,
221,
203,
53,
118,
40,
217,
56,
8,
245,
46,
47,
205,
232,
189,
241,
55,
205,
107,
186,
46,
48,
195,
232,
189,
221,
203,
255,
78,
192,
46,
53,
195,
232,
189,
42,
20,
1,
79,
6,
0,
9,
9,
94,
35,
86,
235,
126,
254,
255,
200,
221,
190,
33,
35,
126,
55,
200,
35,
24,
242,
42,
160,
208,
125,
180,
40,
99,
22,
1,
175,
24,
30,
221,
203,
255,
86,
40,
6,
42,
158,
208,
126,
254,
13,
245,
55,
204,
37,
192,
48,
39,
34,
158,
208,
241,
17,
0,
0,
237,
83,
160,
208,
221,
114,
254,
17,
255,
255,
123,
32,
6,
50,
136,
209,
50,
139,
209,
237,
83,
137,
209,
237,
83,
146,
209,
50,
148,
209,
24,
8,
241,
221,
203,
49,
254,
24,
29,
35,
205,
219,
188,
254,
34,
40,
21,
205,
227,
188,
56,
23,
254,
13,
32,
239,
221,
203,
255,
86,
40,
6,
221,
203,
255,
150,
24,
162,
221,
203,
255,
150,
55,
201,
225,
205,
136,
188,
183,
194,
191,
187,
205,
226,
188,
56,
244,
254,
34,
32,
33,
221,
203,
254,
70,
32,
27,
237,
91,
160,
208,
122,
179,
32,
219,
35,
34,
160,
208,
126,
254,
13,
40,
210,
35,
254,
34,
32,
246,
205,
219,
188,
24,
214,
221,
203,
255,
214,
221,
203,
254,
70,
32,
5,
34,
158,
208,
24,
3,
34,
160,
208,
126,
254,
13,
32,
4,
221,
203,
255,
150,
221,
203,
254,
78,
32,
15,
58,
137,
209,
254,
255,
40,
160,
254,
40,
208,
50,
136,
209,
183,
201,
221,
203,
254,
110,
32,
5,
62,
255,
50,
139,
209,
237,
91,
147,
209,
205,
176,
187,
237,
91,
137,
209,
123,
254,
255,
40,
8,
254,
50,
56,
4,
237,
83,
149,
209,
175,
201,
95,
10,
254,
5,
40,
165,
183,
32,
46,
221,
203,
254,
78,
194,
57,
187,
221,
115,
33,
221,
203,
254,
206,
229,
42,
169,
208,
43,
126,
254,
83,
32,
2,
43,
126,
254,
65,
40,
4,
254,
79,
32,
6,
43,
126,
254,
76,
62,
6,
225,
40,
42,
195,
57,
187,
254,
1,
32,
17,
221,
203,
254,
110,
194,
57,
187,
221,
115,
36,
221,
203,
254,
238,
195,
57,
187,
254,
4,
32,
14,
58,
146,
209,
254,
255,
194,
57,
187,
221,
115,
43,
195,
57,
187,
229,
33,
101,
209,
203,
86,
32,
33,
254,
3,
40,
26,
254,
2,
40,
16,
58,
149,
209,
254,
255,
40,
15,
95,
58,
150,
209,
50,
138,
209,
203,
246,
123,
50,
137,
209,
203,
214,
195,
56,
187,
203,
118,
32,
11,
203,
246,
254,
3,
32,
5,
221,
115,
35,
24,
238,
203,
94,
32,
32,
254,
3,
40,
230,
254,
2,
40,
16,
58,
149,
209,
254,
255,
40,
219,
95,
58,
150,
209,
50,
148,
209,
203,
254,
123,
50,
147,
209,
203,
222,
24,
202,
203,
126,
32,
198,
203,
254,
254,
3,
32,
192,
221,
115,
45,
24,
187,
62,
223,
17,
105,
208,
6,
5,
27,
18,
16,
252,
6,
5,
205,
226,
188,
48,
13,
47,
18,
19,
35,
16,
245,
205,
226,
188,
35,
56,
250,
43,
34,
169,
208,
205,
219,
188,
237,
75,
22,
1,
229,
33,
100,
208,
221,
203,
255,
174,
22,
5,
10,
183,
32,
2,
225,
201,
190,
40,
4,
221,
203,
255,
238,
3,
35,
21,
32,
238,
221,
203,
255,
110,
32,
4,
10,
3,
225,
201,
3,
3,
24,
215,
126,
254,
32,
192,
35,
24,
249,
126,
205,
246,
188,
63,
216,
254,
21,
63,
208,
254,
32,
216,
254,
65,
63,
208,
254,
91,
201,
254,
48,
216,
254,
58,
63,
201,
229,
33,
3,
1,
190,
48,
88,
205,
102,
189,
205,
78,
189,
40,
251,
221,
203,
253,
102,
32,
4,
230,
223,
24,
47,
254,
170,
40,
4,
254,
138,
32,
39,
205,
78,
189,
205,
78,
189,
32,
24,
245,
62,
101,
205,
51,
189,
62,
108,
205,
154,
201,
24,
17,
221,
203,
253,
110,
32,
2,
230,
223,
195,
154,
201,
245,
62,
108,
205,
51,
189,
241,
47,
205,
154,
201,
205,
78,
189,
24,
247,
126,
254,
245,
40,
8,
254,
209,
40,
4,
35,
254,
223,
201,
225,
225,
201,
111,
213,
237,
91,
10,
1,
24,
13,
111,
213,
237,
91,
12,
1,
24,
5,
213,
237,
91,
18,
1,
38,
0,
41,
25,
94,
35,
86,
235,
209,
201,
245,
197,
1,
101,
8,
33,
0,
0,
237,
91,
75,
209,
28,
84,
203,
57,
48,
1,
25,
203,
35,
203,
18,
16,
245,
34,
75,
209,
124,
183,
40,
226,
193,
241,
201,
22,
0,
229,
213,
221,
203,
253,
142,
235,
17,
16,
39,
205,
202,
189,
17,
232,
3,
205,
202,
189,
17,
100,
0,
205,
202,
189,
17,
10,
0,
205,
202,
189,
125,
198,
48,
205,
154,
201,
209,
225,
201,
175,
60,
183,
237,
82,
48,
250,
25,
61,
32,
5,
221,
203,
253,
78,
200,
221,
203,
253,
206,
198,
48,
195,
154,
201,
205,
110,
189,
24,
5,
205,
110,
189,
24,
4,
221,
203,
255,
246,
126,
47,
254,
10,
40,
35,
221,
203,
253,
238,
221,
190,
250,
40,
8,
254,
64,
32,
16,
221,
203,
253,
174,
221,
203,
253,
230,
58,
154,
209,
205,
253,
188,
24,
3,
205,
154,
201,
35,
24,
215,
221,
203,
255,
118,
200,
221,
203,
255,
182,
195,
152,
201,
227,
237,
83,
53,
190,
94,
35,
86,
35,
235,
25,
235,
227,
213,
17,
0,
0,
201,
230,
7,
95,
58,
93,
209,
230,
248,
179,
50,
93,
209,
195,
86,
180,
33,
253,
175,
190,
48,
12,
50,
111,
208,
95,
205,
71,
195,
203,
126,
194,
20,
178,
195,
193,
177,
221,
203,
252,
190,
183,
40,
4,
221,
203,
252,
254,
197,
205,
231,
202,
58,
93,
209,
245,
221,
203,
246,
182,
58,
111,
208,
95,
205,
184,
194,
241,
50,
93,
209,
193,
195,
86,
180,
197,
205,
231,
202,
221,
203,
246,
174,
221,
203,
246,
190,
42,
91,
209,
34,
80,
209,
24,
19,
197,
205,
231,
202,
221,
203,
246,
174,
221,
203,
246,
190,
237,
91,
80,
209,
205,
65,
201,
193,
195,
87,
180,
197,
245,
205,
231,
202,
58,
92,
209,
87,
241,
95,
24,
15,
87,
3,
10,
95,
197,
213,
205,
231,
202,
209,
58,
89,
209,
130,
87,
58,
90,
209,
131,
95,
205,
65,
201,
221,
203,
246,
174,
221,
203,
246,
190,
193,
195,
86,
180,
197,
205,
216,
200,
193,
195,
86,
180,
11,
197,
205,
231,
202,
58,
87,
209,
203,
63,
103,
62,
21,
148,
24,
23,
245,
197,
205,
231,
202,
193,
241,
254,
24,
56,
1,
175,
50,
89,
209,
3,
197,
10,
254,
42,
56,
1,
175,
50,
90,
209,
24,
17,
245,
197,
205,
231,
202,
193,
241,
61,
50,
88,
209,
3,
197,
10,
50,
87,
209,
205,
116,
201,
205,
40,
201,
193,
195,
86,
180,
3,
195,
86,
180,
205,
25,
192,
30,
240,
24,
11,
205,
25,
192,
7,
7,
7,
7,
230,
240,
30,
15,
87,
58,
82,
209,
163,
178,
50,
82,
209,
50,
80,
208,
195,
86,
180,
230,
15,
205,
17,
206,
195,
86,
180,
205,
132,
207,
205,
156,
0,
40,
18,
205,
159,
0,
50,
163,
209,
205,
143,
207,
58,
88,
209,
205,
187,
200,
195,
21,
178,
205,
143,
207,
195,
193,
177,
17,
103,
211,
221,
203,
253,
198,
197,
33,
103,
209,
1,
0,
2,
24,
36,
221,
203,
253,
70,
32,
7,
221,
203,
255,
150,
195,
193,
177,
3,
197,
33,
103,
211,
17,
103,
209,
79,
6,
0,
3,
237,
176,
33,
103,
212,
17,
103,
210,
1,
0,
1,
237,
176,
193,
195,
87,
180,
197,
42,
108,
208,
229,
33,
204,
191,
34,
108,
208,
205,
227,
191,
46,
61,
205,
232,
189,
205,
128,
200,
205,
29,
206,
225,
34,
108,
208,
193,
195,
86,
180,
197,
205,
227,
191,
205,
127,
206,
221,
203,
255,
150,
193,
195,
86,
180,
46,
60,
205,
79,
192,
17,
17,
192,
1,
8,
0,
126,
254,
13,
40,
11,
254,
32,
40,
7,
237,
160,
234,
238,
191,
24,
7,
235,
54,
32,
35,
13,
32,
250,
253,
33,
10,
192,
201,
84,
74,
71,
0,
2,
103,
209,
68,
65,
65,
68,
86,
49,
46,
48,
230,
15,
95,
22,
0,
42,
249,
175,
35,
25,
126,
201,
221,
203,
254,
166,
58,
145,
209,
183,
40,
9,
111,
58,
6,
1,
189,
40,
2,
48,
35,
205,
125,
189,
124,
46,
2,
254,
30,
56,
25,
44,
254,
60,
56,
20,
44,
254,
90,
56,
15,
44,
24,
12,
221,
203,
255,
150,
221,
203,
254,
230,
221,
54,
249,
12,
229,
58,
77,
209,
50,
157,
208,
58,
144,
209,
230,
7,
196,
216,
200,
225,
205,
232,
189,
205,
231,
202,
221,
203,
246,
182,
221,
203,
253,
158,
62,
128,
50,
85,
209,
46,
33,
205,
232,
189,
205,
144,
194,
205,
181,
204,
58,
91,
209,
50,
156,
208,
221,
203,
254,
102,
32,
23,
58,
152,
209,
7,
48,
17,
7,
48,
14,
7,
48,
11,
33,
207,
207,
205,
76,
194,
205,
91,
194,
24,
21,
175,
50,
74,
208,
33,
207,
207,
62,
13,
119,
34,
72,
208,
24,
6,
221,
203,
49,
70,
32,
34,
221,
203,
254,
102,
32,
28,
58,
151,
209,
183,
40,
22,
205,
140,
200,
56,
20,
42,
72,
208,
205,
76,
194,
205,
113,
194,
58,
152,
209,
246,
192,
195,
131,
193,
205,
128,
200,
254,
8,
202,
13,
194,
254,
29,
202,
227,
193,
254,
28,
202,
252,
193,
254,
13,
32,
9,
58,
74,
208,
183,
194,
113,
193,
24,
185,
95,
33,
17,
193,
126,
35,
183,
40,
27,
187,
40,
23,
35,
24,
245,
164,
26,
165,
27,
160,
21,
130,
22,
161,
23,
162,
24,
163,
25,
183,
30,
182,
31,
0,
0,
94,
58,
74,
208,
221,
190,
249,
202,
187,
192,
123,
254,
17,
218,
187,
192,
254,
91,
56,
10,
254,
97,
218,
187,
192,
254,
123,
210,
187,
192,
42,
72,
208,
229,
62,
13,
6,
255,
237,
177,
193,
123,
229,
209,
183,
237,
66,
229,
193,
213,
225,
43,
237,
184,
33,
74,
208,
52,
42,
72,
208,
119,
35,
34,
72,
208,
43,
205,
76,
194,
205,
91,
194,
195,
187,
192,
42,
72,
208,
205,
76,
194,
205,
113,
194,
205,
152,
201,
58,
152,
209,
230,
63,
55,
50,
152,
209,
245,
205,
197,
204,
221,
203,
49,
94,
196,
24,
201,
221,
203,
246,
246,
58,
157,
208,
205,
216,
200,
241,
245,
48,
59,
221,
203,
49,
102,
46,
33,
196,
232,
189,
33,
207,
207,
126,
254,
13,
40,
35,
245,
221,
203,
49,
102,
196,
154,
201,
241,
254,
26,
56,
8,
254,
32,
48,
4,
246,
1,
24,
10,
254,
97,
56,
7,
254,
123,
48,
3,
230,
223,
119,
35,
24,
216,
221,
203,
49,
102,
196,
152,
201,
241,
221,
54,
249,
120,
33,
207,
207,
201,
237,
91,
72,
208,
33,
207,
207,
183,
237,
82,
40,
10,
27,
237,
83,
72,
208,
62,
8,
205,
53,
203,
195,
187,
192,
42,
72,
208,
126,
254,
13,
40,
245,
35,
34,
72,
208,
205,
53,
203,
24,
236,
237,
91,
72,
208,
33,
207,
207,
183,
237,
82,
40,
224,
213,
225,
62,
13,
6,
255,
237,
177,
183,
237,
82,
229,
193,
213,
225,
27,
237,
176,
62,
8,
205,
53,
203,
33,
74,
208,
53,
42,
72,
208,
43,
34,
72,
208,
205,
76,
194,
229,
62,
32,
205,
53,
203,
225,
35,
205,
91,
194,
195,
187,
192,
205,
197,
204,
126,
254,
13,
202,
181,
204,
205,
53,
203,
35,
24,
244,
237,
91,
72,
208,
175,
237,
82,
200,
205,
197,
204,
69,
62,
8,
205,
53,
203,
16,
249,
195,
181,
204,
17,
207,
207,
183,
237,
82,
58,
156,
208,
133,
221,
150,
243,
221,
110,
241,
221,
150,
240,
56,
6,
45,
32,
248,
221,
110,
241,
125,
195,
187,
200,
237,
91,
87,
209,
22,
0,
98,
106,
237,
75,
87,
209,
4,
25,
16,
253,
58,
90,
209,
60,
221,
150,
243,
95,
183,
237,
82,
221,
94,
249,
229,
183,
237,
82,
225,
208,
221,
117,
249,
201,
221,
203,
29,
110,
192,
205,
71,
195,
203,
126,
202,
30,
195,
205,
231,
194,
221,
203,
29,
94,
196,
17,
206,
205,
24,
201,
221,
203,
252,
126,
204,
30,
195,
221,
203,
29,
102,
196,
128,
200,
58,
82,
208,
205,
17,
206,
201,
58,
77,
208,
230,
15,
50,
77,
208,
58,
235,
243,
50,
82,
208,
35,
126,
245,
35,
126,
50,
89,
209,
35,
126,
50,
90,
209,
35,
126,
61,
50,
88,
209,
35,
126,
50,
87,
209,
213,
205,
116,
201,
209,
241,
111,
38,
0,
34,
80,
208,
108,
34,
78,
208,
201,
221,
229,
253,
229,
22,
0,
42,
241,
175,
235,
41,
25,
94,
35,
86,
213,
221,
225,
253,
33,
75,
208,
62,
0,
50,
92,
200,
50,
93,
200,
50,
76,
208,
205,
94,
195,
253,
225,
221,
225,
201,
42,
243,
175,
22,
0,
25,
25,
25,
25,
25,
25,
201,
30,
3,
195,
90,
195,
30,
1,
22,
0,
221,
25,
221,
126,
0,
230,
7,
203,
39,
33,
117,
195,
95,
22,
0,
25,
221,
34,
90,
200,
126,
35,
102,
111,
233,
133,
195,
150,
195,
228,
195,
129,
196,
213,
196,
97,
197,
117,
197,
156,
197,
221,
126,
0,
205,
207,
195,
221,
70,
2,
221,
78,
1,
205,
252,
199,
24,
50,
221,
126,
0,
230,
24,
254,
24,
32,
10,
205,
184,
197,
237,
67,
78,
208,
195,
83,
195,
205,
207,
195,
205,
230,
197,
66,
75,
30,
1,
253,
203,
0,
118,
40,
2,
30,
255,
22,
1,
253,
203,
0,
126,
40,
2,
22,
255,
205,
184,
199,
175,
205,
217,
195,
195,
83,
195,
15,
15,
15,
230,
3,
183,
198,
2,
230,
5,
95,
58,
77,
208,
230,
250,
179,
50,
77,
208,
201,
221,
126,
0,
254,
18,
202,
43,
196,
205,
184,
197,
221,
203,
0,
110,
32,
22,
175,
33,
3,
196,
93,
84,
205,
37,
198,
30,
3,
195,
90,
195,
255,
255,
255,
255,
255,
255,
255,
255,
221,
126,
3,
111,
38,
0,
41,
41,
41,
237,
91,
247,
175,
25,
93,
84,
175,
221,
203,
0,
102,
40,
1,
61,
205,
37,
198,
30,
4,
195,
90,
195,
237,
91,
80,
208,
221,
126,
2,
60,
203,
39,
203,
39,
203,
39,
71,
14,
0,
121,
221,
134,
4,
246,
32,
103,
221,
126,
3,
203,
39,
203,
39,
203,
39,
111,
205,
4,
206,
197,
229,
33,
112,
213,
219,
152,
171,
162,
171,
119,
35,
16,
247,
225,
193,
197,
205,
245,
205,
33,
112,
213,
126,
211,
152,
0,
0,
0,
35,
16,
247,
193,
121,
221,
190,
1,
40,
4,
12,
195,
60,
196,
17,
5,
0,
195,
90,
195,
58,
76,
208,
254,
10,
32,
16,
62,
0,
50,
76,
208,
50,
92,
200,
50,
93,
200,
62,
104,
195,
58,
176,
183,
32,
4,
221,
34,
88,
200,
253,
52,
1,
221,
229,
237,
75,
92,
200,
121,
176,
245,
221,
126,
0,
15,
15,
15,
230,
7,
50,
92,
200,
58,
93,
200,
221,
174,
0,
230,
192,
50,
93,
200,
38,
0,
221,
110,
1,
41,
237,
91,
241,
175,
25,
94,
35,
86,
213,
221,
225,
195,
94,
195,
221,
126,
0,
205,
207,
195,
221,
126,
1,
111,
38,
0,
41,
41,
41,
237,
91,
247,
175,
25,
235,
221,
126,
3,
103,
221,
126,
2,
203,
39,
203,
39,
203,
39,
111,
58,
77,
208,
6,
255,
31,
56,
1,
4,
31,
31,
159,
79,
205,
4,
206,
229,
62,
8,
33,
112,
213,
235,
8,
219,
152,
160,
174,
169,
18,
35,
19,
8,
61,
32,
243,
225,
229,
205,
245,
205,
33,
112,
213,
6,
8,
126,
211,
152,
0,
0,
0,
35,
16,
247,
225,
203,
236,
229,
237,
91,
80,
208,
205,
4,
206,
33,
112,
213,
6,
8,
219,
152,
171,
162,
171,
119,
35,
16,
247,
225,
193,
197,
205,
245,
205,
33,
112,
213,
6,
8,
126,
211,
152,
0,
0,
0,
35,
16,
247,
30,
4,
195,
90,
195,
33,
80,
208,
221,
126,
0,
203,
63,
203,
63,
203,
63,
6,
15,
203,
103,
40,
13,
24,
17,
33,
80,
208,
221,
126,
0,
7,
6,
240,
56,
6,
205,
149,
197,
175,
24,
6,
126,
205,
149,
197,
62,
255,
205,
149,
197,
17,
1,
0,
195,
90,
195,
174,
160,
174,
119,
35,
120,
201,
58,
76,
208,
183,
200,
193,
120,
230,
7,
50,
92,
200,
120,
230,
192,
50,
93,
200,
221,
225,
253,
53,
1,
30,
2,
195,
90,
195,
205,
230,
197,
237,
75,
78,
208,
121,
253,
203,
0,
118,
40,
4,
147,
195,
203,
197,
131,
79,
120,
253,
203,
0,
126,
40,
8,
146,
48,
14,
214,
80,
195,
228,
197,
130,
56,
4,
254,
176,
56,
2,
214,
176,
71,
201,
58,
92,
200,
167,
194,
246,
197,
221,
94,
1,
221,
86,
2,
195,
7,
198,
22,
0,
221,
94,
2,
205,
17,
198,
77,
221,
94,
1,
205,
17,
198,
81,
93,
58,
93,
200,
221,
174,
0,
50,
75,
208,
201,
33,
0,
0,
71,
25,
16,
253,
203,
60,
203,
29,
203,
60,
203,
29,
203,
60,
203,
29,
201,
253,
229,
221,
229,
237,
115,
96,
200,
221,
33,
104,
213,
221,
229,
237,
67,
94,
200,
79,
6,
8,
26,
182,
169,
35,
19,
221,
119,
0,
221,
35,
16,
244,
221,
225,
33,
112,
213,
54,
255,
35,
6,
176,
54,
0,
35,
16,
251,
54,
255,
237,
75,
94,
200,
22,
0,
205,
163,
199,
205,
4,
206,
219,
152,
163,
194,
154,
199,
62,
30,
8,
33,
255,
255,
229,
122,
230,
252,
87,
205,
163,
199,
120,
203,
122,
40,
4,
4,
195,
129,
198,
5,
197,
217,
111,
38,
0,
17,
113,
213,
25,
229,
253,
225,
230,
7,
50,
148,
198,
221,
86,
0,
193,
120,
254,
176,
220,
163,
199,
217,
203,
122,
217,
40,
6,
253,
78,
1,
195,
171,
198,
253,
78,
255,
217,
203,
59,
48,
20,
30,
128,
35,
35,
35,
35,
35,
35,
35,
35,
217,
35,
35,
35,
35,
35,
35,
35,
35,
217,
12,
40,
8,
205,
4,
206,
219,
152,
163,
40,
221,
13,
253,
113,
0,
195,
49,
199,
205,
4,
206,
219,
152,
50,
103,
213,
163,
194,
128,
199,
205,
245,
205,
217,
122,
217,
163,
221,
182,
255,
211,
152,
213,
205,
37,
200,
209,
121,
183,
202,
128,
199,
203,
74,
32,
52,
217,
95,
121,
183,
202,
15,
199,
187,
218,
15,
199,
217,
122,
246,
3,
87,
195,
48,
199,
205,
4,
206,
219,
152,
217,
163,
32,
1,
55,
203,
66,
194,
43,
199,
48,
16,
8,
61,
40,
101,
8,
197,
203,
194,
195,
48,
199,
218,
48,
199,
203,
130,
13,
203,
35,
210,
214,
198,
30,
1,
43,
43,
43,
43,
43,
43,
43,
43,
205,
4,
206,
219,
152,
217,
43,
43,
43,
43,
43,
43,
43,
43,
183,
32,
43,
217,
203,
74,
217,
32,
14,
205,
4,
206,
219,
152,
183,
32,
29,
217,
203,
66,
217,
40,
23,
217,
205,
245,
205,
217,
122,
217,
211,
152,
213,
205,
37,
200,
209,
121,
214,
8,
79,
56,
7,
195,
56,
199,
217,
195,
214,
198,
8,
60,
8,
193,
120,
60,
194,
112,
198,
237,
75,
94,
200,
203,
122,
32,
9,
203,
250,
4,
120,
254,
176,
218,
93,
198,
237,
123,
96,
200,
221,
225,
253,
225,
201,
197,
205,
61,
200,
1,
176,
199,
129,
79,
10,
95,
193,
201,
128,
64,
32,
16,
8,
4,
2,
1,
121,
184,
48,
6,
105,
213,
175,
95,
24,
7,
177,
200,
104,
65,
213,
22,
0,
96,
120,
31,
133,
56,
3,
188,
56,
7,
148,
79,
217,
193,
197,
24,
4,
79,
213,
217,
193,
42,
78,
208,
120,
132,
71,
121,
60,
133,
56,
13,
40,
13,
61,
79,
205,
252,
199,
217,
121,
16,
217,
209,
201,
40,
243,
62,
103,
195,
58,
176,
237,
67,
78,
208,
205,
61,
200,
71,
4,
62,
254,
15,
16,
253,
71,
205,
4,
206,
219,
152,
253,
78,
2,
203,
65,
32,
1,
160,
203,
81,
32,
2,
168,
47,
71,
205,
245,
205,
120,
211,
152,
203,
236,
237,
91,
80,
208,
205,
4,
206,
219,
152,
171,
162,
171,
245,
205,
245,
205,
241,
211,
152,
203,
172,
201,
62,
175,
144,
218,
247,
199,
71,
230,
7,
111,
121,
230,
248,
181,
111,
120,
203,
63,
203,
63,
203,
63,
103,
121,
230,
7,
201,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
205,
231,
202,
46,
16,
205,
232,
189,
205,
231,
202,
58,
88,
209,
60,
205,
187,
200,
221,
203,
49,
86,
40,
6,
58,
151,
209,
183,
32,
12,
213,
205,
132,
207,
118,
205,
156,
0,
40,
251,
24,
36,
213,
221,
86,
48,
30,
0,
203,
58,
203,
27,
203,
58,
203,
27,
24,
1,
213,
205,
132,
207,
118,
205,
156,
0,
32,
10,
205,
205,
207,
27,
122,
179,
32,
243,
24,
4,
205,
159,
0,
55,
245,
205,
143,
207,
241,
209,
201,
50,
85,
209,
221,
229,
197,
221,
33,
187,
208,
17,
16,
0,
6,
8,
221,
126,
10,
221,
119,
7,
221,
25,
16,
246,
193,
221,
225,
201,
221,
190,
230,
200,
245,
205,
231,
202,
58,
77,
209,
205,
7,
201,
235,
33,
78,
209,
1,
16,
0,
237,
176,
241,
245,
50,
77,
209,
205,
7,
201,
17,
78,
209,
1,
16,
0,
237,
176,
58,
82,
209,
50,
80,
208,
241,
201,
33,
187,
208,
7,
7,
7,
7,
95,
22,
0,
25,
201,
221,
203,
29,
118,
192,
197,
229,
213,
205,
38,
203,
205,
40,
201,
205,
64,
205,
209,
225,
193,
201,
58,
89,
209,
50,
92,
209,
205,
241,
205,
34,
83,
209,
58,
90,
209,
50,
91,
209,
58,
88,
209,
50,
85,
209,
201,
122,
221,
190,
242,
56,
25,
58,
89,
209,
221,
134,
241,
186,
56,
16,
123,
221,
190,
243,
56,
10,
58,
90,
209,
221,
134,
240,
61,
187,
48,
6,
221,
94,
243,
221,
86,
242,
221,
115,
244,
122,
50,
92,
209,
205,
241,
205,
34,
83,
209,
201,
58,
89,
209,
221,
134,
241,
254,
24,
56,
8,
62,
23,
221,
150,
242,
50,
88,
209,
58,
90,
209,
221,
134,
240,
254,
43,
216,
62,
42,
221,
150,
243,
50,
87,
209,
201,
62,
13,
221,
229,
221,
33,
103,
209,
254,
128,
56,
35,
221,
203,
253,
86,
40,
29,
229,
42,
8,
1,
214,
127,
203,
126,
35,
40,
251,
61,
32,
248,
126,
198,
128,
56,
11,
198,
128,
205,
197,
201,
35,
24,
243,
221,
229,
229,
213,
197,
254,
13,
40,
74,
254,
16,
56,
90,
221,
203,
246,
70,
40,
2,
246,
128,
221,
203,
246,
118,
40,
51,
254,
32,
40,
32,
254,
160,
40,
28,
245,
58,
113,
208,
254,
40,
204,
231,
202,
241,
221,
203,
246,
174,
42,
154,
208,
119,
35,
34,
154,
208,
33,
113,
208,
52,
24,
34,
221,
203,
246,
110,
32,
28,
245,
205,
231,
202,
241,
221,
203,
246,
110,
204,
191,
202,
24,
14,
205,
231,
202,
221,
203,
246,
126,
221,
203,
246,
190,
204,
90,
202,
193,
209,
225,
221,
225,
201,
254,
15,
32,
6,
221,
203,
246,
134,
24,
240,
254,
14,
32,
6,
221,
203,
246,
198,
24,
230,
245,
205,
231,
202,
241,
254,
11,
32,
5,
205,
24,
201,
24,
216,
254,
12,
32,
212,
58,
88,
209,
205,
113,
200,
24,
204,
62,
13,
205,
53,
203,
33,
85,
209,
53,
192,
58,
88,
209,
119,
221,
203,
252,
118,
192,
221,
203,
246,
78,
192,
205,
187,
200,
46,
32,
205,
110,
189,
58,
93,
209,
245,
62,
2,
50,
93,
209,
126,
47,
254,
10,
40,
6,
35,
205,
154,
201,
24,
244,
241,
50,
93,
209,
221,
203,
49,
78,
40,
11,
58,
151,
209,
183,
40,
5,
205,
140,
200,
24,
3,
205,
128,
200,
58,
91,
209,
221,
190,
243,
200,
62,
8,
205,
53,
203,
62,
32,
205,
53,
203,
62,
8,
205,
53,
203,
24,
232,
95,
213,
205,
53,
203,
209,
221,
203,
246,
190,
58,
91,
209,
221,
190,
243,
192,
123,
254,
32,
32,
10,
221,
203,
246,
118,
40,
4,
221,
203,
246,
238,
205,
95,
202,
221,
203,
246,
254,
201,
221,
203,
246,
118,
200,
58,
113,
208,
183,
200,
58,
90,
209,
221,
134,
240,
33,
91,
209,
150,
33,
113,
208,
190,
40,
13,
48,
15,
58,
91,
209,
221,
190,
243,
196,
90,
202,
24,
4,
221,
203,
246,
238,
237,
75,
112,
208,
33,
114,
208,
126,
229,
197,
205,
191,
202,
193,
225,
35,
16,
245,
24,
4,
221,
203,
246,
174,
33,
114,
208,
34,
154,
208,
175,
50,
113,
208,
201,
229,
213,
197,
245,
205,
82,
203,
241,
254,
8,
204,
100,
203,
254,
13,
204,
143,
203,
183,
196,
192,
203,
205,
82,
203,
193,
209,
225,
201,
221,
203,
246,
94,
200,
221,
203,
246,
230,
62,
95,
205,
192,
203,
221,
203,
246,
166,
33,
91,
209,
58,
90,
209,
190,
40,
3,
53,
24,
29,
33,
89,
209,
58,
92,
209,
190,
40,
20,
61,
50,
92,
209,
205,
241,
205,
34,
83,
209,
58,
90,
209,
221,
134,
240,
61,
50,
91,
209,
175,
201,
58,
90,
209,
221,
134,
240,
221,
190,
244,
40,
7,
62,
32,
205,
192,
203,
24,
238,
33,
92,
209,
58,
89,
209,
221,
134,
241,
190,
40,
8,
52,
126,
205,
241,
205,
34,
83,
209,
204,
207,
204,
58,
90,
209,
50,
91,
209,
175,
201,
245,
58,
90,
209,
221,
134,
240,
221,
190,
244,
194,
208,
203,
205,
143,
203,
58,
91,
209,
205,
226,
205,
230,
3,
203,
79,
40,
1,
35,
203,
37,
203,
20,
203,
37,
203,
20,
203,
37,
203,
20,
237,
91,
83,
209,
25,
245,
221,
203,
253,
254,
205,
4,
206,
6,
16,
17,
84,
208,
219,
152,
0,
0,
0,
18,
19,
16,
247,
221,
203,
253,
190,
241,
227,
229,
7,
22,
0,
95,
1,
255,
255,
221,
203,
246,
102,
32,
7,
33,
173,
204,
25,
78,
35,
70,
203,
3,
203,
3,
33,
141,
204,
25,
34,
62,
204,
237,
91,
247,
175,
241,
111,
38,
0,
41,
41,
41,
25,
17,
84,
208,
62,
8,
8,
229,
205,
141,
204,
26,
160,
172,
18,
19,
19,
19,
19,
19,
19,
19,
19,
26,
161,
173,
18,
27,
27,
27,
27,
27,
27,
27,
225,
35,
8,
61,
32,
222,
225,
221,
203,
253,
254,
205,
245,
205,
17,
84,
208,
6,
16,
26,
211,
152,
0,
0,
0,
19,
16,
247,
203,
236,
205,
245,
205,
58,
80,
208,
6,
16,
211,
152,
0,
0,
0,
16,
249,
221,
203,
253,
190,
33,
91,
209,
52,
201,
102,
46,
0,
201,
0,
0,
0,
0,
110,
38,
0,
41,
41,
201,
0,
0,
110,
38,
0,
41,
41,
41,
41,
201,
110,
38,
0,
203,
61,
203,
61,
201,
255,
3,
15,
252,
63,
240,
192,
255,
229,
221,
203,
246,
94,
32,
17,
221,
203,
246,
222,
205,
87,
203,
24,
8,
229,
205,
82,
203,
221,
203,
246,
158,
225,
201,
205,
135,
205,
58,
88,
209,
221,
78,
242,
183,
40,
97,
71,
58,
86,
209,
203,
39,
203,
39,
203,
39,
221,
203,
253,
254,
197,
245,
121,
60,
205,
194,
205,
205,
4,
206,
241,
245,
71,
17,
112,
213,
219,
152,
0,
0,
0,
18,
19,
16,
247,
203,
236,
205,
4,
206,
241,
245,
71,
219,
152,
18,
19,
16,
250,
121,
205,
194,
205,
205,
245,
205,
241,
245,
71,
17,
112,
213,
26,
211,
152,
0,
0,
0,
19,
16,
247,
203,
236,
205,
245,
205,
241,
245,
71,
26,
211,
152,
0,
0,
0,
19,
16,
247,
241,
193,
12,
16,
173,
6,
1,
24,
7,
221,
70,
241,
4,
221,
78,
242,
205,
135,
205,
50,
86,
209,
203,
39,
203,
39,
203,
39,
221,
203,
253,
254,
197,
245,
121,
205,
194,
205,
205,
245,
205,
241,
245,
71,
175,
211,
152,
0,
0,
0,
16,
249,
203,
236,
205,
245,
205,
241,
245,
71,
58,
80,
208,
211,
152,
0,
0,
0,
16,
249,
241,
193,
12,
16,
213,
221,
203,
253,
190,
201,
197,
229,
58,
87,
209,
71,
203,
63,
203,
63,
79,
135,
129,
79,
58,
90,
209,
230,
3,
203,
39,
203,
39,
95,
120,
230,
3,
131,
95,
22,
0,
33,
178,
205,
25,
126,
129,
50,
86,
209,
225,
193,
201,
0,
1,
2,
3,
1,
2,
3,
3,
1,
2,
2,
3,
1,
1,
2,
3,
205,
241,
205,
229,
58,
90,
209,
205,
226,
205,
230,
3,
40,
3,
61,
95,
25,
203,
37,
203,
20,
203,
37,
203,
20,
203,
37,
203,
20,
209,
25,
201,
95,
203,
59,
203,
59,
22,
0,
33,
0,
0,
25,
25,
25,
201,
201,
103,
46,
0,
201,
125,
243,
211,
153,
124,
230,
63,
246,
64,
211,
153,
251,
227,
227,
201,
125,
243,
211,
153,
124,
230,
63,
211,
153,
251,
227,
227,
201,
50,
235,
243,
205,
132,
207,
205,
98,
0,
195,
143,
207,
253,
229,
205,
132,
207,
243,
209,
1,
15,
0,
175,
205,
63,
206,
253,
78,
3,
253,
70,
4,
253,
94,
5,
253,
86,
6,
62,
255,
205,
63,
206,
195,
143,
207,
197,
213,
245,
205,
234,
0,
241,
205,
237,
0,
33,
0,
0,
209,
193,
197,
213,
26,
95,
22,
0,
25,
229,
205,
237,
0,
205,
183,
0,
56,
22,
225,
209,
193,
19,
11,
120,
177,
32,
231,
125,
205,
237,
0,
205,
240,
0,
201,
205,
231,
0,
24,
3,
205,
240,
0,
205,
143,
207,
62,
101,
195,
58,
176,
205,
132,
207,
243,
17,
112,
215,
1,
15,
0,
175,
205,
1,
207,
32,
244,
221,
203,
252,
246,
33,
96,
207,
6,
8,
205,
88,
207,
33,
119,
215,
6,
8,
205,
88,
207,
205,
152,
201,
221,
203,
252,
182,
253,
229,
225,
17,
7,
0,
25,
17,
119,
215,
6,
8,
26,
190,
35,
19,
32,
199,
16,
248,
221,
203,
252,
246,
33,
104,
207,
6,
12,
205,
88,
207,
221,
203,
252,
182,
253,
126,
3,
253,
70,
4,
79,
176,
32,
6,
237,
75,
115,
215,
24,
10,
42,
115,
215,
183,
237,
66,
48,
2,
77,
68,
253,
126,
5,
253,
86,
6,
95,
178,
32,
4,
237,
91,
117,
215,
62,
255,
205,
1,
207,
194,
80,
207,
195,
143,
207,
213,
197,
245,
205,
225,
0,
218,
111,
206,
205,
228,
0,
218,
77,
207,
111,
241,
189,
33,
0,
0,
193,
209,
40,
7,
205,
231,
0,
62,
255,
183,
201,
197,
213,
229,
205,
228,
0,
218,
77,
207,
225,
209,
18,
79,
6,
0,
9,
205,
183,
0,
218,
111,
206,
193,
19,
11,
120,
177,
32,
227,
229,
205,
228,
0,
218,
77,
207,
205,
231,
0,
225,
189,
32,
4,
201,
205,
231,
0,
205,
143,
207,
62,
102,
195,
58,
176,
126,
205,
154,
201,
35,
16,
249,
201,
78,
111,
109,
98,
114,
101,
58,
32,
67,
97,
114,
103,
97,
110,
100,
111,
46,
46,
46,
13,
95,
10,
254,
14,
208,
245,
205,
132,
207,
241,
205,
147,
0,
195,
143,
207,
243,
58,
8,
176,
211,
168,
50,
83,
208,
251,
201,
243,
58,
9,
176,
211,
168,
50,
83,
208,
251,
201,
243,
245,
229,
221,
229,
58,
83,
208,
245,
58,
9,
176,
211,
168,
50,
83,
208,
42,
17,
176,
221,
33,
103,
209,
205,
16,
176,
58,
8,
176,
211,
168,
50,
83,
208,
0,
0,
255,
243,
241,
211,
168,
50,
83,
208,
221,
225,
225,
241,
251,
201,
118,
201,
243,
58,
9,
176,
211,
168,
50,
83,
208,
6,
0,
33,
0,
217,
62,
216,
119,
35,
16,
252,
119,
62,
217,
237,
71,
62,
195,
50,
216,
216,
33,
154,
207,
34,
217,
216,
33,
34,
1,
17,
10,
176,
62,
3,
8,
78,
35,
70,
35,
120,
177,
40,
12,
235,
62,
195,
119,
35,
113,
35,
112,
35,
235,
24,
3,
19,
19,
19,
8,
61,
32,
228,
58,
2,
1,
50,
97,
209,
237,
115,
106,
208,
221,
33,
103,
209,
237,
94,
251,
221,
203,
253,
150,
42,
8,
1,
125,
180,
202,
92,
176,
221,
203,
253,
214,
195,
92,
176,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
207,
207,
0,
0,
0,
0,
0,
0,
241,
0,
0,
0,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
0,
0,
0,
0,
0,
0,
0,
0,
0,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
255,
114,
208,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
0,
0,
249,
0,
0,
3,
13,
16,
3,
0,
0,
0,
0,
64,
0,
0,
0,
255,
255,
0,
0,
241,
0,
0,
23,
32,
42,
23,
0,
0,
0,
0,
64,
0,
0,
120,
0,
0,
0,
0,
0,
0]

# Equipara la longitud del intérprete inglés con la del español, ya que el cargador se espera un intérprete con la longitud del español

eTerpList = eTerpList + [0 for y in range(151)]

# Cambia en el intérprete inglés un IM 2 por un IM 1

eTerpList[8081] = 0x56

blockIdSequence = bytes([0x1F, 0xA6, 0xDE, 0xBA, 0xCC, 0x13, 0x7D, 0x74])

blockTypeBinary = bytes([0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0])

blockTypeAscii = bytes([0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA])

basicAscii = bytes('10 COLOR 15,1,1:SCREEN 2:BLOAD"cas:",R', 'ANSI')

with open(in_file, 'rb') as a:
        textDatabase = a.read()

if scr:
        with open(scr, 'rb') as a:
                screen = a.read()
else:
        screen = None

if mdg:
        with open(mdg, 'rb') as a:
                graphicDatabase = a.read()
else:
        graphicDatabase = bytes(blankMdgList)

textDatabaseLenght = len(textDatabase)

graphicDatabaseLenght = len(graphicDatabase)

graphicDatabaseStart = 0xAFFF - graphicDatabaseLenght + 1

if e:
        terpList = eTerpList
else:                
        terpList = sTerpList

if v:
        if screen:
                print ('Pantalla SCR cargada')
        else:
                print ('Sin pantalla de carga')
        print ()        
        print ('-DDB:')
        print ('Comienzo: 0x100')
        print ('Fin:', hex(textDatabaseLenght + 0x100 -1))
        print ('Longitud:', hex(textDatabaseLenght))
        print ()
        print ('-MDG:')
        print ('Comienzo:', hex(graphicDatabaseStart))
        print ('Fin: 0xAfff')
        print ('Longitud:', hex(graphicDatabaseLenght))
        print ()
        print ('Intérprete:')
        if e:
                aux = 'inglés.'
        else:
                aux = 'español.'
        print ('Idioma:', aux)
        print ('Comienzo: 0xb000')
        aux = len(terpList) - 1
        if e:
                aux = aux + 151
        print ('Fin:', hex(0xb000 + aux))
        aux = len(terpList)
        if e:
                aux = aux - 151
        print ('Longitud:', hex(aux))
        print ()
        
aux = int.to_bytes(textDatabaseLenght, 2, byteorder="little")
loaderList[0x39] = aux[0]
loaderList[0x3A] = aux[1]

aux = int.to_bytes(graphicDatabaseStart, 2, byteorder="little")
loaderList[0x40] = aux[0]
loaderList[0x41] = aux[1]

aux = int.to_bytes(graphicDatabaseLenght, 2, byteorder="little")
loaderList[0x43] = aux[0]
loaderList[0x44] = aux[1]

if screen == None:
        for y in range (0x20, 0x34):
                loaderList[y] = 0

diff = 256 - len(basicAscii)
fillAscii = bytes([0x1A for x in range(diff)])

asciiBlock = blockIdSequence + blockTypeAscii + bytes('AD    ', 'ANSI') + blockIdSequence + basicAscii + fillAscii

loaderBlock = blockIdSequence + blockTypeBinary + bytes('ZonaFI', 'ANSI') + blockIdSequence + bytes(loaderList)

if screen:
        screenBlock = blockIdSequence + bytes([0x00]) + screen + bytes([0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,])
else:
        screenBlock = None

textDatabaseBlock = blockIdSequence + bytes([0x00]) + textDatabase + bytes([0x00, 0x00])

graphicDatabaseBlock = blockIdSequence + bytes([0x00]) + graphicDatabase + bytes([0x00, 0x00, 0x00])

terpBlock = blockIdSequence + bytes([0x00]) + bytes(terpList) + bytes([0x00])

if screenBlock == None:
        casFile = asciiBlock + loaderBlock + textDatabaseBlock + graphicDatabaseBlock + terpBlock
else:
        casFile = asciiBlock + loaderBlock + screenBlock + textDatabaseBlock + graphicDatabaseBlock + terpBlock

with open(out_file, 'wb') as a:
        a.write(casFile)

print ('Fichero', out_file, 'creado.')
print ()
