from enum import Enum, auto
from typing import List

class RecordType(Enum):
    GENOME = auto()
    GENE = auto()
    PROTEIN = auto()
    NUCLEOTIDE = auto()
    UNKNOWN = auto()

class Header:
    name: str
    desc: str

    def __init__(self, name: str, desc: str) -> None: ...
    def __eq__(self, other: Header) -> bool: ...
    def __ne__(self, other: Header) -> bool: ...
    def empty(self) -> bool: ...
    def to_string(self) -> str: ...
    def clean(self) -> None: ...
    def clear(self) -> None: ...

class Record:
    header: Header
    seq: str
    type: RecordType

    def __init__(self, name: str, desc: str, seq: str) -> None: ...
    def __eq__(self, other: Record) -> bool: ...
    def __ne__(self, other: Record) -> bool: ...
    def empty(self) -> bool: ...
    def clear(self) -> None: ...
    def to_string(self) -> str: ...
    def clean_header(self) -> None: ...
    def remove_stops(self) -> None: ...

class Records(List[Record]): ...
class Headers(List[Header]): ...

class Parser:
    type: RecordType

    def __init__(self, filename: str) -> None: ...
    def __iter__(self) -> "Parser": ...
    def __next__(self) -> Record: ...
    def has_next(self) -> bool: ...
    def all(self) -> Records: ...
    def take(self, n: int) -> Records: ...
    def refresh(self) -> None: ...
    def next(self) -> Record: ...
    def py_next(self) -> Record: ...
    def py_next_header(self) -> Header: ...
    def count(self) -> int: ...
    def extension(self) -> str: ...
    def next_header(self) -> Header: ...
    def headers(self) -> Headers: ...
