# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/dashboard/powerBIConnection.json
#   timestamp: 2022-06-21T17:50:40+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class PowerBiType(Enum):
    PowerBI = 'PowerBI'


class PowerBIConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[PowerBiType] = Field(
        PowerBiType.PowerBI, description='Service Type', title='Service Type'
    )
    clientId: str = Field(..., description='client_id for PowerBI.', title='Client ID')
    clientSecret: SecretStr = Field(
        ..., description='clientSecret for PowerBI.', title='Client Secret'
    )
    credentials: Optional[str] = Field(
        None, description='Credentials for PowerBI.', title='Credentials'
    )
    redirectURI: Optional[str] = Field(
        None,
        description='Dashboard redirect URI for the PowerBI service.',
        title='Redirect URI',
    )
    hostPort: AnyUrl = Field(
        ..., description='Dashboard URL for PowerBI service.', title='Host and Port'
    )
    scope: Optional[List[str]] = Field(
        None, description='PowerBI secrets.', title='Scope'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
