# coding: utf-8

"""
Earnix import export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import ConfigDict, Field
from typing_extensions import Annotated, Self

from earnix_elevate.clients.imx.models.data_source_response import DataSourceResponse
from earnix_elevate.clients.imx.models.user import User


class BucketDataSourceResponse(DataSourceResponse):
    """
    BucketDataSourceResponse
    """  # noqa: E501

    path: Optional[Annotated[str, Field(strict=True, max_length=1000)]] = None
    __properties: ClassVar[List[str]] = [
        "id",
        "version",
        "name",
        "description",
        "tags",
        "connectionId",
        "createdBy",
        "createdDate",
        "lastModifiedBy",
        "lastModifiedDate",
        "type",
        "path",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BucketDataSourceResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict["createdBy"] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_by
        if self.last_modified_by:
            _dict["lastModifiedBy"] = self.last_modified_by.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BucketDataSourceResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "version": obj.get("version"),
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "connectionId": obj.get("connectionId"),
                "createdBy": User.from_dict(obj["createdBy"])
                if obj.get("createdBy") is not None
                else None,
                "createdDate": obj.get("createdDate"),
                "lastModifiedBy": User.from_dict(obj["lastModifiedBy"])
                if obj.get("lastModifiedBy") is not None
                else None,
                "lastModifiedDate": obj.get("lastModifiedDate"),
                "type": obj.get("type"),
                "path": obj.get("path"),
            }
        )
        return _obj
