# coding: utf-8

"""
    Cashfree LRS

    CashFree LRS APIs (v2)  # noqa: E501

    The version of the OpenAPI document: 1.0.15
    Contact: nextgenapi@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBytes, StrictStr, conlist

from typing import Any, Dict, Optional, Union

from cashfree_lrs_client.models.bulk_documents_upload_response import BulkDocumentsUploadResponse
from cashfree_lrs_client.models.create_beneficiary_request import CreateBeneficiaryRequest
from cashfree_lrs_client.models.create_order_request import CreateOrderRequest
from cashfree_lrs_client.models.create_order_response import CreateOrderResponse
from cashfree_lrs_client.models.create_remitter_request import CreateRemitterRequest
from cashfree_lrs_client.models.fetch_forex_rate_request import FetchForexRateRequest
from cashfree_lrs_client.models.fetch_forex_rate_response import FetchForexRateResponse
from cashfree_lrs_client.models.setup_webhooks_request import SetupWebhooksRequest
from cashfree_lrs_client.models.success_message import SuccessMessage

from cashfree_lrs_client.api_client import ApiClient
from cashfree_lrs_client.api_response import ApiResponse
from cashfree_lrs_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class LrsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def bulk_documents_upload(self, files : Annotated[conlist(Union[StrictBytes, StrictStr]), Field(..., description="Upload multiple document at a time. Accepted file type - .pdf. Maximum file size - 20 MB")], **kwargs) -> BulkDocumentsUploadResponse:  # noqa: E501
        """Upload Documents in Bulk  # noqa: E501

        Use this API to Upload documents in bulk before the order creation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.bulk_documents_upload(files, async_req=True)
        >>> result = thread.get()

        :param files: Upload multiple document at a time. Accepted file type - .pdf. Maximum file size - 20 MB (required)
        :type files: List[bytearray]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BulkDocumentsUploadResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the bulk_documents_upload_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.bulk_documents_upload_with_http_info(files, **kwargs)  # noqa: E501

    @validate_arguments
    def bulk_documents_upload_with_http_info(self, files : Annotated[conlist(Union[StrictBytes, StrictStr]), Field(..., description="Upload multiple document at a time. Accepted file type - .pdf. Maximum file size - 20 MB")], **kwargs) -> ApiResponse:  # noqa: E501
        """Upload Documents in Bulk  # noqa: E501

        Use this API to Upload documents in bulk before the order creation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.bulk_documents_upload_with_http_info(files, async_req=True)
        >>> result = thread.get()

        :param files: Upload multiple document at a time. Accepted file type - .pdf. Maximum file size - 20 MB (required)
        :type files: List[bytearray]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BulkDocumentsUploadResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'files'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_documents_upload" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['files']:
            _files['files'] = _params['files']
            _collection_formats['files'] = 'csv'

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['X-Client-ID', 'X-Client-Secret', 'X-API-Version']  # noqa: E501

        _response_types_map = {
            '200': "BulkDocumentsUploadResponse",
            '413': "Error",
        }

        return self.api_client.call_api(
            '/orders/documents/upload', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_beneficiary(self, create_beneficiary_request : Optional[CreateBeneficiaryRequest] = None, **kwargs) -> SuccessMessage:  # noqa: E501
        """Create Beneficiary  # noqa: E501

        Use this API to create beneficiaries with Cashfree Payments from your backend.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_beneficiary(create_beneficiary_request, async_req=True)
        >>> result = thread.get()

        :param create_beneficiary_request:
        :type create_beneficiary_request: CreateBeneficiaryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessMessage
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_beneficiary_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_beneficiary_with_http_info(create_beneficiary_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_beneficiary_with_http_info(self, create_beneficiary_request : Optional[CreateBeneficiaryRequest] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Beneficiary  # noqa: E501

        Use this API to create beneficiaries with Cashfree Payments from your backend.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_beneficiary_with_http_info(create_beneficiary_request, async_req=True)
        >>> result = thread.get()

        :param create_beneficiary_request:
        :type create_beneficiary_request: CreateBeneficiaryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessMessage, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_beneficiary_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_beneficiary" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_beneficiary_request'] is not None:
            _body_params = _params['create_beneficiary_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['X-Client-ID', 'X-Client-Secret', 'X-API-Version']  # noqa: E501

        _response_types_map = {
            '200': "SuccessMessage",
            '400': "Error",
        }

        return self.api_client.call_api(
            '/beneficiaries', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_order(self, create_order_request : Optional[CreateOrderRequest] = None, **kwargs) -> CreateOrderResponse:  # noqa: E501
        """Create LRS Order  # noqa: E501

        Use this API to create orders with Cashfree Payments.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_order(create_order_request, async_req=True)
        >>> result = thread.get()

        :param create_order_request:
        :type create_order_request: CreateOrderRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateOrderResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_order_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_order_with_http_info(create_order_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_order_with_http_info(self, create_order_request : Optional[CreateOrderRequest] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create LRS Order  # noqa: E501

        Use this API to create orders with Cashfree Payments.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_order_with_http_info(create_order_request, async_req=True)
        >>> result = thread.get()

        :param create_order_request:
        :type create_order_request: CreateOrderRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateOrderResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_order_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_order" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_order_request'] is not None:
            _body_params = _params['create_order_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['X-Client-ID', 'X-Client-Secret', 'X-API-Version']  # noqa: E501

        _response_types_map = {
            '200': "CreateOrderResponse",
            '400': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/orders', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_remitter(self, create_remitter_request : Optional[CreateRemitterRequest] = None, **kwargs) -> SuccessMessage:  # noqa: E501
        """Create Remitter  # noqa: E501

        Use this API to create remmiter account with Cashfree Payments for LRS transactions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_remitter(create_remitter_request, async_req=True)
        >>> result = thread.get()

        :param create_remitter_request:
        :type create_remitter_request: CreateRemitterRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessMessage
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_remitter_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_remitter_with_http_info(create_remitter_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_remitter_with_http_info(self, create_remitter_request : Optional[CreateRemitterRequest] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Remitter  # noqa: E501

        Use this API to create remmiter account with Cashfree Payments for LRS transactions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_remitter_with_http_info(create_remitter_request, async_req=True)
        >>> result = thread.get()

        :param create_remitter_request:
        :type create_remitter_request: CreateRemitterRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessMessage, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_remitter_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_remitter" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_remitter_request'] is not None:
            _body_params = _params['create_remitter_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['X-Client-ID', 'X-Client-Secret', 'X-API-Version']  # noqa: E501

        _response_types_map = {
            '200': "SuccessMessage",
            '400': "Error",
        }

        return self.api_client.call_api(
            '/remitters', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def fetch_forex_rate(self, fetch_forex_rate_request : Optional[FetchForexRateRequest] = None, **kwargs) -> FetchForexRateResponse:  # noqa: E501
        """Fetch FX Rate  # noqa: E501

        Use this API to get the foreign exchange rate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_forex_rate(fetch_forex_rate_request, async_req=True)
        >>> result = thread.get()

        :param fetch_forex_rate_request: 
        :type fetch_forex_rate_request: FetchForexRateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FetchForexRateResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the fetch_forex_rate_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.fetch_forex_rate_with_http_info(fetch_forex_rate_request, **kwargs)  # noqa: E501

    @validate_arguments
    def fetch_forex_rate_with_http_info(self, fetch_forex_rate_request : Optional[FetchForexRateRequest] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Fetch FX Rate  # noqa: E501

        Use this API to get the foreign exchange rate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_forex_rate_with_http_info(fetch_forex_rate_request, async_req=True)
        >>> result = thread.get()

        :param fetch_forex_rate_request: 
        :type fetch_forex_rate_request: FetchForexRateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FetchForexRateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'fetch_forex_rate_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fetch_forex_rate" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['fetch_forex_rate_request'] is not None:
            _body_params = _params['fetch_forex_rate_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['X-Client-ID', 'X-Client-Secret', 'X-API-Version']  # noqa: E501

        _response_types_map = {
            '200': "FetchForexRateResponse",
        }

        return self.api_client.call_api(
            '/fx-rate/details', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def process_order(self, order_id : Annotated[StrictStr, Field(..., description="The subject Order ID")], **kwargs) -> None:  # noqa: E501
        """Process Order  # noqa: E501

        Use this API to process an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.process_order(order_id, async_req=True)
        >>> result = thread.get()

        :param order_id: The subject Order ID (required)
        :type order_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the process_order_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.process_order_with_http_info(order_id, **kwargs)  # noqa: E501

    @validate_arguments
    def process_order_with_http_info(self, order_id : Annotated[StrictStr, Field(..., description="The subject Order ID")], **kwargs) -> ApiResponse:  # noqa: E501
        """Process Order  # noqa: E501

        Use this API to process an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.process_order_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param order_id: The subject Order ID (required)
        :type order_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'order_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method process_order" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['order_id']:
            _path_params['order_id'] = _params['order_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['X-Client-ID', 'X-Client-Secret', 'X-API-Version']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/orders/{order_id}/process', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def setup_webhooks(self, setup_webhooks_request : Optional[SetupWebhooksRequest] = None, **kwargs) -> SuccessMessage:  # noqa: E501
        """Setup Webhooks  # noqa: E501

        Use this API to configure webhook URLs to receive updates about payments, refunds, and orders.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.setup_webhooks(setup_webhooks_request, async_req=True)
        >>> result = thread.get()

        :param setup_webhooks_request: 
        :type setup_webhooks_request: SetupWebhooksRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessMessage
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the setup_webhooks_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.setup_webhooks_with_http_info(setup_webhooks_request, **kwargs)  # noqa: E501

    @validate_arguments
    def setup_webhooks_with_http_info(self, setup_webhooks_request : Optional[SetupWebhooksRequest] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Setup Webhooks  # noqa: E501

        Use this API to configure webhook URLs to receive updates about payments, refunds, and orders.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.setup_webhooks_with_http_info(setup_webhooks_request, async_req=True)
        >>> result = thread.get()

        :param setup_webhooks_request: 
        :type setup_webhooks_request: SetupWebhooksRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessMessage, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'setup_webhooks_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method setup_webhooks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['setup_webhooks_request'] is not None:
            _body_params = _params['setup_webhooks_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['X-Client-ID', 'X-Client-Secret', 'X-API-Version']  # noqa: E501

        _response_types_map = {
            '200': "SuccessMessage",
        }

        return self.api_client.call_api(
            '/webhooks', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def upload_documents(self, order_id : Annotated[StrictStr, Field(..., description="The subject Order ID")], files : Annotated[conlist(Union[StrictBytes, StrictStr]), Field(..., description="Upload multiple document at a time. Accepted file type - .pdf. Maximum file size - 20 MB")], **kwargs) -> object:  # noqa: E501
        """Upload Documents  # noqa: E501

        Use this API to Upload documents on your Order ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_documents(order_id, files, async_req=True)
        >>> result = thread.get()

        :param order_id: The subject Order ID (required)
        :type order_id: str
        :param files: Upload multiple document at a time. Accepted file type - .pdf. Maximum file size - 20 MB (required)
        :type files: List[bytearray]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the upload_documents_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.upload_documents_with_http_info(order_id, files, **kwargs)  # noqa: E501

    @validate_arguments
    def upload_documents_with_http_info(self, order_id : Annotated[StrictStr, Field(..., description="The subject Order ID")], files : Annotated[conlist(Union[StrictBytes, StrictStr]), Field(..., description="Upload multiple document at a time. Accepted file type - .pdf. Maximum file size - 20 MB")], **kwargs) -> ApiResponse:  # noqa: E501
        """Upload Documents  # noqa: E501

        Use this API to Upload documents on your Order ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_documents_with_http_info(order_id, files, async_req=True)
        >>> result = thread.get()

        :param order_id: The subject Order ID (required)
        :type order_id: str
        :param files: Upload multiple document at a time. Accepted file type - .pdf. Maximum file size - 20 MB (required)
        :type files: List[bytearray]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'order_id',
            'files'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_documents" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['order_id']:
            _path_params['order_id'] = _params['order_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['files']:
            _files['files'] = _params['files']
            _collection_formats['files'] = 'csv'

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['X-Client-ID', 'X-Client-Secret', 'X-API-Version']  # noqa: E501

        _response_types_map = {
            '200': "object",
            '400': "Error",
            '404': "Error",
            '413': "Error",
        }

        return self.api_client.call_api(
            '/orders/{order_id}/documents/upload', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
