# coding: utf-8

"""
    Cashfree LRS

    CashFree LRS APIs (v2)  # noqa: E501

    The version of the OpenAPI document: 1.0.15
    Contact: nextgenapi@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, confloat, conint, constr, validator
from cashfree_lrs_client.models.currency import Currency
from cashfree_lrs_client.models.purpose import Purpose

class CreateOrderRequest(BaseModel):
    """
    
    """
    order_id: constr(strict=True, max_length=50, min_length=1) = Field(..., description="Unique Order Id to place the order. Alphanumeric characters, hyphens and underscores are allowed. Maximum of 50 characters is allowed.")
    to_currency: Currency = Field(...)
    to_amount: Union[confloat(ge=1, strict=True), conint(ge=1, strict=True)] = Field(..., description="Final settlement amount in to_currency (Double with 2 decimals allowed)")
    from_amount: Optional[Union[confloat(ge=1, strict=True), conint(ge=1, strict=True)]] = Field(None, description="Amount in INR excluding GST, TCS and handling charges (Double with 2 decimals allowed)")
    purpose: Purpose = Field(...)
    return_url: constr(strict=True, max_length=300, min_length=3) = Field(..., description="The URL to which customer will be redirected to after the payment (should accept query params cf_id and cf_token).")
    remitter_id: constr(strict=True, max_length=50, min_length=1) = Field(..., description="Unique remitter ID to identify the remitter. Alphanumeric characters, hyphens, and underscores are allowed. Maximum of 50 characters are allowed.")
    beneficiary_id: constr(strict=True, max_length=50, min_length=1) = Field(..., description="Unique Beneficiary ID to identify the beneficiary. Alphanumeric characters and underscores are allowed. Maximum of 50 characters is allowed.")
    customer_declaration: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Amount in INR declared by Customer (Double with 2 decimals allowed)")
    doc_ids: Optional[StrictStr] = Field(None, description="Comma seperated bulk_doc_id provided from the upload APIs.")
    customer_relationship: StrictStr = Field(...)
    education_loan: Optional[StrictBool] = Field(False, description="Whether the remitter has availed an education loan")
    remarks: Optional[StrictStr] = Field(None, description="This is used to pass any narration for the order.")
    auto_process: Optional[StrictBool] = Field(False, description="It defines if you automate the process or not. Possible values - TRUE or FALSE.")
    __properties = ["order_id", "to_currency", "to_amount", "from_amount", "purpose", "return_url", "remitter_id", "beneficiary_id", "customer_declaration", "doc_ids", "customer_relationship", "education_loan", "remarks", "auto_process"]

    @validator('customer_relationship')
    def customer_relationship_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('SELF', 'HUSBAND', 'WIFE', 'FATHER', 'STEP_FATHER', 'MOTHER', 'STEP_MOTHER', 'SON', 'STEP_SON', 'WIFE_OF_SON', 'DAUGHTER', 'HUSBAND_OF_DAUGHTER', 'BROTHER', 'STEP_BROTHER', 'SISTER', 'STEP_SISTER', 'GRAND_FATHER', 'GRAND_MOTHER'):
            raise ValueError("must be one of enum values ('SELF', 'HUSBAND', 'WIFE', 'FATHER', 'STEP_FATHER', 'MOTHER', 'STEP_MOTHER', 'SON', 'STEP_SON', 'WIFE_OF_SON', 'DAUGHTER', 'HUSBAND_OF_DAUGHTER', 'BROTHER', 'STEP_BROTHER', 'SISTER', 'STEP_SISTER', 'GRAND_FATHER', 'GRAND_MOTHER')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateOrderRequest:
        """Create an instance of CreateOrderRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateOrderRequest:
        """Create an instance of CreateOrderRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateOrderRequest.parse_obj(obj)

        _obj = CreateOrderRequest.parse_obj({
            "order_id": obj.get("order_id"),
            "to_currency": obj.get("to_currency"),
            "to_amount": obj.get("to_amount"),
            "from_amount": obj.get("from_amount"),
            "purpose": obj.get("purpose"),
            "return_url": obj.get("return_url"),
            "remitter_id": obj.get("remitter_id"),
            "beneficiary_id": obj.get("beneficiary_id"),
            "customer_declaration": obj.get("customer_declaration"),
            "doc_ids": obj.get("doc_ids"),
            "customer_relationship": obj.get("customer_relationship"),
            "education_loan": obj.get("education_loan") if obj.get("education_loan") is not None else False,
            "remarks": obj.get("remarks"),
            "auto_process": obj.get("auto_process") if obj.get("auto_process") is not None else False
        })
        return _obj

