# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAppCatalogListingResourceVersionsResult',
    'AwaitableGetAppCatalogListingResourceVersionsResult',
    'get_app_catalog_listing_resource_versions',
    'get_app_catalog_listing_resource_versions_output',
]

@pulumi.output_type
class GetAppCatalogListingResourceVersionsResult:
    """
    A collection of values returned by getAppCatalogListingResourceVersions.
    """
    def __init__(__self__, app_catalog_listing_resource_versions=None, filters=None, id=None, listing_id=None):
        if app_catalog_listing_resource_versions and not isinstance(app_catalog_listing_resource_versions, list):
            raise TypeError("Expected argument 'app_catalog_listing_resource_versions' to be a list")
        pulumi.set(__self__, "app_catalog_listing_resource_versions", app_catalog_listing_resource_versions)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listing_id and not isinstance(listing_id, str):
            raise TypeError("Expected argument 'listing_id' to be a str")
        pulumi.set(__self__, "listing_id", listing_id)

    @property
    @pulumi.getter(name="appCatalogListingResourceVersions")
    def app_catalog_listing_resource_versions(self) -> Sequence['outputs.GetAppCatalogListingResourceVersionsAppCatalogListingResourceVersionResult']:
        """
        The list of app_catalog_listing_resource_versions.
        """
        return pulumi.get(self, "app_catalog_listing_resource_versions")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAppCatalogListingResourceVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> str:
        """
        The OCID of the listing this resource version belongs to.
        """
        return pulumi.get(self, "listing_id")


class AwaitableGetAppCatalogListingResourceVersionsResult(GetAppCatalogListingResourceVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppCatalogListingResourceVersionsResult(
            app_catalog_listing_resource_versions=self.app_catalog_listing_resource_versions,
            filters=self.filters,
            id=self.id,
            listing_id=self.listing_id)


def get_app_catalog_listing_resource_versions(filters: Optional[Sequence[pulumi.InputType['GetAppCatalogListingResourceVersionsFilterArgs']]] = None,
                                              listing_id: Optional[str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppCatalogListingResourceVersionsResult:
    """
    This data source provides the list of App Catalog Listing Resource Versions in Oracle Cloud Infrastructure Core service.

    Gets all resource versions for a particular listing.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_app_catalog_listing_resource_versions = oci.Core.get_app_catalog_listing_resource_versions(listing_id=data["oci_core_app_catalog_listing"]["test_listing"]["id"])
    ```


    :param str listing_id: The OCID of the listing.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['listingId'] = listing_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getAppCatalogListingResourceVersions:getAppCatalogListingResourceVersions', __args__, opts=opts, typ=GetAppCatalogListingResourceVersionsResult).value

    return AwaitableGetAppCatalogListingResourceVersionsResult(
        app_catalog_listing_resource_versions=pulumi.get(__ret__, 'app_catalog_listing_resource_versions'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        listing_id=pulumi.get(__ret__, 'listing_id'))


@_utilities.lift_output_func(get_app_catalog_listing_resource_versions)
def get_app_catalog_listing_resource_versions_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAppCatalogListingResourceVersionsFilterArgs']]]]] = None,
                                                     listing_id: Optional[pulumi.Input[str]] = None,
                                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppCatalogListingResourceVersionsResult]:
    """
    This data source provides the list of App Catalog Listing Resource Versions in Oracle Cloud Infrastructure Core service.

    Gets all resource versions for a particular listing.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_app_catalog_listing_resource_versions = oci.Core.get_app_catalog_listing_resource_versions(listing_id=data["oci_core_app_catalog_listing"]["test_listing"]["id"])
    ```


    :param str listing_id: The OCID of the listing.
    """
    ...
