# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkFirewallPolicyUrlListArgs', 'NetworkFirewallPolicyUrlList']

@pulumi.input_type
class NetworkFirewallPolicyUrlListArgs:
    def __init__(__self__, *,
                 network_firewall_policy_id: pulumi.Input[str],
                 urls: pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListUrlArgs']]],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NetworkFirewallPolicyUrlList resource.
        :param pulumi.Input[str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListUrlArgs']]] urls: (Updatable) List of urls.
        :param pulumi.Input[str] name: Unique name to identify the group of urls to be used in the policy rules.
        """
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        pulumi.set(__self__, "urls", urls)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Input[str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @property
    @pulumi.getter
    def urls(self) -> pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListUrlArgs']]]:
        """
        (Updatable) List of urls.
        """
        return pulumi.get(self, "urls")

    @urls.setter
    def urls(self, value: pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListUrlArgs']]]):
        pulumi.set(self, "urls", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name to identify the group of urls to be used in the policy rules.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkFirewallPolicyUrlListState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 parent_resource_id: Optional[pulumi.Input[str]] = None,
                 total_urls: Optional[pulumi.Input[int]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListUrlArgs']]]] = None):
        """
        Input properties used for looking up and filtering NetworkFirewallPolicyUrlList resources.
        :param pulumi.Input[str] name: Unique name to identify the group of urls to be used in the policy rules.
        :param pulumi.Input[str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[str] parent_resource_id: OCID of the Network Firewall Policy this URL List belongs to.
        :param pulumi.Input[int] total_urls: Total count of URLs in the URL List
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListUrlArgs']]] urls: (Updatable) List of urls.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_firewall_policy_id is not None:
            pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id is not None:
            pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if total_urls is not None:
            pulumi.set(__self__, "total_urls", total_urls)
        if urls is not None:
            pulumi.set(__self__, "urls", urls)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name to identify the group of urls to be used in the policy rules.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the Network Firewall Policy this URL List belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @parent_resource_id.setter
    def parent_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_resource_id", value)

    @property
    @pulumi.getter(name="totalUrls")
    def total_urls(self) -> Optional[pulumi.Input[int]]:
        """
        Total count of URLs in the URL List
        """
        return pulumi.get(self, "total_urls")

    @total_urls.setter
    def total_urls(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_urls", value)

    @property
    @pulumi.getter
    def urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListUrlArgs']]]]:
        """
        (Updatable) List of urls.
        """
        return pulumi.get(self, "urls")

    @urls.setter
    def urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListUrlArgs']]]]):
        pulumi.set(self, "urls", value)


class NetworkFirewallPolicyUrlList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyUrlListUrlArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Network Firewall Policy Url List resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new Url List for the Network Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_url_list = oci.network_firewall.NetworkFirewallPolicyUrlList("testNetworkFirewallPolicyUrlList",
            network_firewall_policy_id=oci_network_firewall_network_firewall_policy["test_network_firewall_policy"]["id"],
            urls=[oci.network_firewall.NetworkFirewallPolicyUrlListUrlArgs(
                pattern=var["network_firewall_policy_url_list_urls_pattern"],
                type=var["network_firewall_policy_url_list_urls_type"],
            )])
        ```

        ## Import

        NetworkFirewallPolicyUrlLists can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:NetworkFirewall/networkFirewallPolicyUrlList:NetworkFirewallPolicyUrlList test_network_firewall_policy_url_list "networkFirewallPolicies/{networkFirewallPolicyId}/urlLists/{urlListName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Unique name to identify the group of urls to be used in the policy rules.
        :param pulumi.Input[str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyUrlListUrlArgs']]]] urls: (Updatable) List of urls.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkFirewallPolicyUrlListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Network Firewall Policy Url List resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new Url List for the Network Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_url_list = oci.network_firewall.NetworkFirewallPolicyUrlList("testNetworkFirewallPolicyUrlList",
            network_firewall_policy_id=oci_network_firewall_network_firewall_policy["test_network_firewall_policy"]["id"],
            urls=[oci.network_firewall.NetworkFirewallPolicyUrlListUrlArgs(
                pattern=var["network_firewall_policy_url_list_urls_pattern"],
                type=var["network_firewall_policy_url_list_urls_type"],
            )])
        ```

        ## Import

        NetworkFirewallPolicyUrlLists can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:NetworkFirewall/networkFirewallPolicyUrlList:NetworkFirewallPolicyUrlList test_network_firewall_policy_url_list "networkFirewallPolicies/{networkFirewallPolicyId}/urlLists/{urlListName}"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkFirewallPolicyUrlListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkFirewallPolicyUrlListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyUrlListUrlArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkFirewallPolicyUrlListArgs.__new__(NetworkFirewallPolicyUrlListArgs)

            __props__.__dict__["name"] = name
            if network_firewall_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_firewall_policy_id'")
            __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
            if urls is None and not opts.urn:
                raise TypeError("Missing required property 'urls'")
            __props__.__dict__["urls"] = urls
            __props__.__dict__["parent_resource_id"] = None
            __props__.__dict__["total_urls"] = None
        super(NetworkFirewallPolicyUrlList, __self__).__init__(
            'oci:NetworkFirewall/networkFirewallPolicyUrlList:NetworkFirewallPolicyUrlList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
            parent_resource_id: Optional[pulumi.Input[str]] = None,
            total_urls: Optional[pulumi.Input[int]] = None,
            urls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyUrlListUrlArgs']]]]] = None) -> 'NetworkFirewallPolicyUrlList':
        """
        Get an existing NetworkFirewallPolicyUrlList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Unique name to identify the group of urls to be used in the policy rules.
        :param pulumi.Input[str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[str] parent_resource_id: OCID of the Network Firewall Policy this URL List belongs to.
        :param pulumi.Input[int] total_urls: Total count of URLs in the URL List
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyUrlListUrlArgs']]]] urls: (Updatable) List of urls.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkFirewallPolicyUrlListState.__new__(_NetworkFirewallPolicyUrlListState)

        __props__.__dict__["name"] = name
        __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
        __props__.__dict__["parent_resource_id"] = parent_resource_id
        __props__.__dict__["total_urls"] = total_urls
        __props__.__dict__["urls"] = urls
        return NetworkFirewallPolicyUrlList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Unique name to identify the group of urls to be used in the policy rules.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Output[str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> pulumi.Output[str]:
        """
        OCID of the Network Firewall Policy this URL List belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter(name="totalUrls")
    def total_urls(self) -> pulumi.Output[int]:
        """
        Total count of URLs in the URL List
        """
        return pulumi.get(self, "total_urls")

    @property
    @pulumi.getter
    def urls(self) -> pulumi.Output[Sequence['outputs.NetworkFirewallPolicyUrlListUrl']]:
        """
        (Updatable) List of urls.
        """
        return pulumi.get(self, "urls")

