# mypy-boto3-snowball

[![PyPI - mypy-boto3-snowball](https://img.shields.io/pypi/v/mypy-boto3-snowball.svg?color=blue)](https://pypi.org/project/mypy-boto3-snowball)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-snowball.svg?color=blue)](https://pypi.org/project/mypy-boto3-snowball)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Snowball 1.14.30](https://boto3.amazonaws.com/v1/documentation/api/1.14.30/reference/services/snowball.html#Snowball) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Snowball` service.

```bash
python -m pip install boto3-stubs[snowball]
```

## How to use

### Client annotations

`SnowballClient` provides annotations for `boto3.client("snowball")`.

```python
import boto3

from mypy_boto3_snowball import SnowballClient
from mypy_boto3_snowball.paginator import (
    DescribeAddressesPaginator,
    ListClusterJobsPaginator,
    ListClustersPaginator,
    ListCompatibleImagesPaginator,
    ListJobsPaginator,
)
from mypy_boto3_snowball.type_defs import AddressTypeDef, ...

client: SnowballClient = boto3.client("snowball")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SnowballClient = session.client("snowball")
```

### Paginators annotations

`mypy_boto3_snowball.paginator` module contains type annotations for all paginators.

```python

client: SnowballClient = boto3.client("snowball")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_addresses_paginator: DescribeAddressesPaginator = client.get_paginator("describe_addresses")
list_cluster_jobs_paginator: ListClusterJobsPaginator = client.get_paginator("list_cluster_jobs")
list_clusters_paginator: ListClustersPaginator = client.get_paginator("list_clusters")
list_compatible_images_paginator: ListCompatibleImagesPaginator = client.get_paginator("list_compatible_images")
list_jobs_paginator: ListJobsPaginator = client.get_paginator("list_jobs")
```







### Typed dictionations

`mypy_boto3_snowball.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AddressTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_snowball` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("snowball")

session_client = boto3.Session().client("snowball")
```
