import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * A rulestack defines the NGFW's advanced access control (APP-ID, URL Filtering) and threat prevention behavior.
 *
 * @schema CfnRuleStackProps
 */
export interface CfnRuleStackProps {
    /**
     * Rule stack name
     *
     * @schema CfnRuleStackProps#RuleStackName
     */
    readonly ruleStackName: string;
    /**
     * @schema CfnRuleStackProps#RuleStack
     */
    readonly ruleStack?: RuleStack;
    /**
     * list of rules
     *
     * @schema CfnRuleStackProps#RuleList
     */
    readonly ruleList?: Rule[];
    /**
     * @schema CfnRuleStackProps#SecurityObjects
     */
    readonly securityObjects?: SecurityObjects;
    /**
     * @schema CfnRuleStackProps#CustomSecurityProfiles
     */
    readonly customSecurityProfiles?: CustomSecurityProfiles;
}
/**
 * Converts an object of type 'CfnRuleStackProps' to JSON representation.
 */
export declare function toJson_CfnRuleStackProps(obj: CfnRuleStackProps | undefined): Record<string, any> | undefined;
/**
 * @schema RuleStack
 */
export interface RuleStack {
    /**
     * @schema RuleStack#AccountId
     */
    readonly accountId?: string;
    /**
     * @schema RuleStack#Scope
     */
    readonly scope?: RuleStackScope;
    /**
     * @schema RuleStack#LookupXForwardedFor
     */
    readonly lookupXForwardedFor?: RuleStackLookupXForwardedFor;
    /**
     * @schema RuleStack#MinAppIdVersion
     */
    readonly minAppIdVersion?: string;
    /**
     * @schema RuleStack#Profiles
     */
    readonly profiles?: RuleStackProfiles;
    /**
     * @schema RuleStack#Description
     */
    readonly description?: string;
    /**
     * Deploy RuleStack YES/NO
     *
     * @schema RuleStack#Deploy
     */
    readonly deploy?: string;
}
/**
 * Converts an object of type 'RuleStack' to JSON representation.
 */
export declare function toJson_RuleStack(obj: RuleStack | undefined): Record<string, any> | undefined;
/**
 * @schema Rule
 */
export interface Rule {
    /**
     * @schema Rule#RuleName
     */
    readonly ruleName: string;
    /**
     * @schema Rule#Description
     */
    readonly description?: string;
    /**
     * RuleList type: LocalRule, PreRule, PostRule
     *
     * @schema Rule#RuleListType
     */
    readonly ruleListType: string;
    /**
     * Priority of the Rule
     *
     * @schema Rule#Priority
     */
    readonly priority: number;
    /**
     * @schema Rule#Enabled
     */
    readonly enabled?: boolean;
    /**
     * @schema Rule#Source
     */
    readonly source?: RuleSource;
    /**
     * @schema Rule#NegateSource
     */
    readonly negateSource?: boolean;
    /**
     * @schema Rule#Destination
     */
    readonly destination?: RuleDestination;
    /**
     * @schema Rule#NegateDestination
     */
    readonly negateDestination?: boolean;
    /**
     * @schema Rule#Applications
     */
    readonly applications?: string[];
    /**
     * @schema Rule#Category
     */
    readonly category?: UrlCategory;
    /**
     * @schema Rule#Protocol
     */
    readonly protocol?: string;
    /**
     * @schema Rule#ProtPortList
     */
    readonly protPortList?: string[];
    /**
     * @schema Rule#AuditComment
     */
    readonly auditComment?: string;
    /**
     * @schema Rule#Action
     */
    readonly action?: RuleAction;
    /**
     * @schema Rule#Logging
     */
    readonly logging?: boolean;
    /**
     * @schema Rule#DecryptionRuleType
     */
    readonly decryptionRuleType?: RuleDecryptionRuleType;
    /**
     * @schema Rule#InboundInspectionCertificate
     */
    readonly inboundInspectionCertificate?: string;
    /**
     * @schema Rule#Tags
     */
    readonly tags?: Tag[];
}
/**
 * Converts an object of type 'Rule' to JSON representation.
 */
export declare function toJson_Rule(obj: Rule | undefined): Record<string, any> | undefined;
/**
 * Security objects
 *
 * @schema SecurityObjects
 */
export interface SecurityObjects {
    /**
     * @schema SecurityObjects#PrefixLists
     */
    readonly prefixLists?: PrefixList[];
    /**
     * @schema SecurityObjects#FqdnLists
     */
    readonly fqdnLists?: FqdnList[];
    /**
     * @schema SecurityObjects#CustomUrlCategories
     */
    readonly customUrlCategories?: CustomUrlCategory[];
    /**
     * @schema SecurityObjects#IntelligentFeeds
     */
    readonly intelligentFeeds?: IntelligentFeed[];
    /**
     * @schema SecurityObjects#CertificateObjects
     */
    readonly certificateObjects?: CertObject[];
}
/**
 * Converts an object of type 'SecurityObjects' to JSON representation.
 */
export declare function toJson_SecurityObjects(obj: SecurityObjects | undefined): Record<string, any> | undefined;
/**
 * Custom Security Profiles object
 *
 * @schema CustomSecurityProfiles
 */
export interface CustomSecurityProfiles {
    /**
     * @schema CustomSecurityProfiles#FileBlocking
     */
    readonly fileBlocking?: FileBlocking;
}
/**
 * Converts an object of type 'CustomSecurityProfiles' to JSON representation.
 */
export declare function toJson_CustomSecurityProfiles(obj: CustomSecurityProfiles | undefined): Record<string, any> | undefined;
/**
 * @schema RuleStackScope
 */
export declare enum RuleStackScope {
    /** Local */
    LOCAL = "Local"
}
/**
 * @schema RuleStackLookupXForwardedFor
 */
export declare enum RuleStackLookupXForwardedFor {
    /** SecurityPolicy */
    SECURITY_POLICY = "SecurityPolicy",
    /** None */
    NONE = "None"
}
/**
 * @schema RuleStackProfiles
 */
export interface RuleStackProfiles {
    /**
     * @schema RuleStackProfiles#AntiSpywareProfile
     */
    readonly antiSpywareProfile?: RuleStackProfilesAntiSpywareProfile;
    /**
     * @schema RuleStackProfiles#AntiVirusProfile
     */
    readonly antiVirusProfile?: RuleStackProfilesAntiVirusProfile;
    /**
     * @schema RuleStackProfiles#VulnerabilityProfile
     */
    readonly vulnerabilityProfile?: RuleStackProfilesVulnerabilityProfile;
    /**
     * @schema RuleStackProfiles#URLFilteringProfile
     */
    readonly urlFilteringProfile?: RuleStackProfilesUrlFilteringProfile;
    /**
     * @schema RuleStackProfiles#FileBlockingProfile
     */
    readonly fileBlockingProfile?: RuleStackProfilesFileBlockingProfile;
    /**
     * @schema RuleStackProfiles#OutboundTrustCertificate
     */
    readonly outboundTrustCertificate?: string;
    /**
     * @schema RuleStackProfiles#OutboundUntrustCertificate
     */
    readonly outboundUntrustCertificate?: string;
}
/**
 * Converts an object of type 'RuleStackProfiles' to JSON representation.
 */
export declare function toJson_RuleStackProfiles(obj: RuleStackProfiles | undefined): Record<string, any> | undefined;
/**
 * @schema RuleSource
 */
export interface RuleSource {
    /**
     * @schema RuleSource#Cidrs
     */
    readonly cidrs?: string[];
    /**
     * @schema RuleSource#PrefixLists
     */
    readonly prefixLists?: string[];
    /**
     * Country code
     *
     * @schema RuleSource#Countries
     */
    readonly countries?: string[];
    /**
     * @schema RuleSource#Feeds
     */
    readonly feeds?: string[];
}
/**
 * Converts an object of type 'RuleSource' to JSON representation.
 */
export declare function toJson_RuleSource(obj: RuleSource | undefined): Record<string, any> | undefined;
/**
 * @schema RuleDestination
 */
export interface RuleDestination {
    /**
     * @schema RuleDestination#Cidrs
     */
    readonly cidrs?: string[];
    /**
     * @schema RuleDestination#FqdnLists
     */
    readonly fqdnLists?: string[];
    /**
     * @schema RuleDestination#PrefixLists
     */
    readonly prefixLists?: string[];
    /**
     * Country code
     *
     * @schema RuleDestination#Countries
     */
    readonly countries?: string[];
    /**
     * @schema RuleDestination#Feeds
     */
    readonly feeds?: string[];
}
/**
 * Converts an object of type 'RuleDestination' to JSON representation.
 */
export declare function toJson_RuleDestination(obj: RuleDestination | undefined): Record<string, any> | undefined;
/**
 * @schema UrlCategory
 */
export interface UrlCategory {
    /**
     * @schema UrlCategory#URLCategoryNames
     */
    readonly urlCategoryNames?: string[];
    /**
     * @schema UrlCategory#Feeds
     */
    readonly feeds?: string[];
}
/**
 * Converts an object of type 'UrlCategory' to JSON representation.
 */
export declare function toJson_UrlCategory(obj: UrlCategory | undefined): Record<string, any> | undefined;
/**
 * @schema RuleAction
 */
export declare enum RuleAction {
    /** Allow */
    ALLOW = "Allow",
    /** DenySilent */
    DENY_SILENT = "DenySilent",
    /** DenyResetServer */
    DENY_RESET_SERVER = "DenyResetServer",
    /** DenyResetBoth */
    DENY_RESET_BOTH = "DenyResetBoth"
}
/**
 * @schema RuleDecryptionRuleType
 */
export declare enum RuleDecryptionRuleType {
    /** SSLOutboundInspection */
    SSL_OUTBOUND_INSPECTION = "SSLOutboundInspection",
    /** SSLInboundInspection */
    SSL_INBOUND_INSPECTION = "SSLInboundInspection",
    /** SSLOutboundNoInspection */
    SSL_OUTBOUND_NO_INSPECTION = "SSLOutboundNoInspection",
    /** SSLInboundNoInspection */
    SSL_INBOUND_NO_INSPECTION = "SSLInboundNoInspection"
}
/**
 * @schema Tag
 */
export interface Tag {
    /**
     * @schema Tag#Key
     */
    readonly key: string;
    /**
     * @schema Tag#Value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'Tag' to JSON representation.
 */
export declare function toJson_Tag(obj: Tag | undefined): Record<string, any> | undefined;
/**
 * SecurityObjects PrefixList
 *
 * @schema PrefixList
 */
export interface PrefixList {
    /**
     * @schema PrefixList#Name
     */
    readonly name: string;
    /**
     * @schema PrefixList#PrefixList
     */
    readonly prefixList: string[];
    /**
     * @schema PrefixList#AuditComment
     */
    readonly auditComment?: string;
    /**
     * @schema PrefixList#Description
     */
    readonly description?: string;
}
/**
 * Converts an object of type 'PrefixList' to JSON representation.
 */
export declare function toJson_PrefixList(obj: PrefixList | undefined): Record<string, any> | undefined;
/**
 * @schema FqdnList
 */
export interface FqdnList {
    /**
     * @schema FqdnList#Name
     */
    readonly name: string;
    /**
     * @schema FqdnList#Description
     */
    readonly description?: string;
    /**
     * @schema FqdnList#FqdnList
     */
    readonly fqdnList: string[];
    /**
     * @schema FqdnList#AuditComment
     */
    readonly auditComment?: string;
}
/**
 * Converts an object of type 'FqdnList' to JSON representation.
 */
export declare function toJson_FqdnList(obj: FqdnList | undefined): Record<string, any> | undefined;
/**
 * @schema CustomUrlCategory
 */
export interface CustomUrlCategory {
    /**
     * @schema CustomUrlCategory#URLTargets
     */
    readonly urlTargets: string[];
    /**
     * @schema CustomUrlCategory#Name
     */
    readonly name?: string;
    /**
     * @schema CustomUrlCategory#Description
     */
    readonly description?: string;
    /**
     * @schema CustomUrlCategory#Action
     */
    readonly action?: CustomUrlCategoryAction;
    /**
     * @schema CustomUrlCategory#AuditComment
     */
    readonly auditComment?: string;
}
/**
 * Converts an object of type 'CustomUrlCategory' to JSON representation.
 */
export declare function toJson_CustomUrlCategory(obj: CustomUrlCategory | undefined): Record<string, any> | undefined;
/**
 * @schema IntelligentFeed
 */
export interface IntelligentFeed {
    /**
     * @schema IntelligentFeed#Name
     */
    readonly name: string;
    /**
     * @schema IntelligentFeed#Description
     */
    readonly description?: string;
    /**
     * @schema IntelligentFeed#Certificate
     */
    readonly certificate?: string;
    /**
     * @schema IntelligentFeed#FeedURL
     */
    readonly feedUrl: string;
    /**
     * @schema IntelligentFeed#Type
     */
    readonly type: IntelligentFeedType;
    /**
     * @schema IntelligentFeed#Frequency
     */
    readonly frequency: IntelligentFeedFrequency;
    /**
     * @schema IntelligentFeed#Time
     */
    readonly time?: number;
    /**
     * @schema IntelligentFeed#AuditComment
     */
    readonly auditComment?: string;
}
/**
 * Converts an object of type 'IntelligentFeed' to JSON representation.
 */
export declare function toJson_IntelligentFeed(obj: IntelligentFeed | undefined): Record<string, any> | undefined;
/**
 * @schema CertObject
 */
export interface CertObject {
    /**
     * @schema CertObject#Name
     */
    readonly name: string;
    /**
     * @schema CertObject#Description
     */
    readonly description?: string;
    /**
     * @schema CertObject#CertificateSignerArn
     */
    readonly certificateSignerArn?: string;
    /**
     * @schema CertObject#CertificateSelfSigned
     */
    readonly certificateSelfSigned?: boolean;
    /**
     * @schema CertObject#AuditComment
     */
    readonly auditComment?: string;
}
/**
 * Converts an object of type 'CertObject' to JSON representation.
 */
export declare function toJson_CertObject(obj: CertObject | undefined): Record<string, any> | undefined;
/**
 * @schema FileBlocking
 */
export interface FileBlocking {
    /**
     * @schema FileBlocking#Direction
     */
    readonly direction?: FileBlockingDirection;
    /**
     * @schema FileBlocking#FileType
     */
    readonly fileType: string;
    /**
     * @schema FileBlocking#Description
     */
    readonly description?: string;
    /**
     * @schema FileBlocking#Action
     */
    readonly action?: FileBlockingAction;
    /**
     * @schema FileBlocking#AuditComment
     */
    readonly auditComment?: string;
}
/**
 * Converts an object of type 'FileBlocking' to JSON representation.
 */
export declare function toJson_FileBlocking(obj: FileBlocking | undefined): Record<string, any> | undefined;
/**
 * @schema RuleStackProfilesAntiSpywareProfile
 */
export declare enum RuleStackProfilesAntiSpywareProfile {
    /** BestPractice */
    BEST_PRACTICE = "BestPractice",
    /** None */
    NONE = "None"
}
/**
 * @schema RuleStackProfilesAntiVirusProfile
 */
export declare enum RuleStackProfilesAntiVirusProfile {
    /** BestPractice */
    BEST_PRACTICE = "BestPractice",
    /** None */
    NONE = "None"
}
/**
 * @schema RuleStackProfilesVulnerabilityProfile
 */
export declare enum RuleStackProfilesVulnerabilityProfile {
    /** BestPractice */
    BEST_PRACTICE = "BestPractice",
    /** None */
    NONE = "None"
}
/**
 * @schema RuleStackProfilesUrlFilteringProfile
 */
export declare enum RuleStackProfilesUrlFilteringProfile {
    /** BestPractice */
    BEST_PRACTICE = "BestPractice",
    /** None */
    NONE = "None"
}
/**
 * @schema RuleStackProfilesFileBlockingProfile
 */
export declare enum RuleStackProfilesFileBlockingProfile {
    /** Custom */
    CUSTOM = "Custom",
    /** BestPractice */
    BEST_PRACTICE = "BestPractice",
    /** None */
    NONE = "None"
}
/**
 * @schema CustomUrlCategoryAction
 */
export declare enum CustomUrlCategoryAction {
    /** none */
    NONE = "none",
    /** allow */
    ALLOW = "allow",
    /** alert */
    ALERT = "alert",
    /** block */
    BLOCK = "block"
}
/**
 * @schema IntelligentFeedType
 */
export declare enum IntelligentFeedType {
    /** IP_LIST */
    IP_UNDERSCORE_LIST = "IP_LIST",
    /** URL_LIST */
    URL_UNDERSCORE_LIST = "URL_LIST"
}
/**
 * @schema IntelligentFeedFrequency
 */
export declare enum IntelligentFeedFrequency {
    /** HOURLY */
    HOURLY = "HOURLY",
    /** DAILY */
    DAILY = "DAILY"
}
/**
 * @schema FileBlockingDirection
 */
export declare enum FileBlockingDirection {
    /** upload */
    UPLOAD = "upload",
    /** download */
    DOWNLOAD = "download",
    /** both */
    BOTH = "both"
}
/**
 * @schema FileBlockingAction
 */
export declare enum FileBlockingAction {
    /** alert */
    ALERT = "alert",
    /** block */
    BLOCK = "block",
    /** continue */
    CONTINUE = "continue"
}
/**
 * A CloudFormation `PaloAltoNetworks::CloudNGFW::RuleStack`
 *
 * @cloudformationResource PaloAltoNetworks::CloudNGFW::RuleStack
 * @stability external
 * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
 */
export declare class CfnRuleStack extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "PaloAltoNetworks::CloudNGFW::RuleStack";
    /**
     * Resource props.
     */
    readonly props: CfnRuleStackProps;
    /**
     * Create a new `PaloAltoNetworks::CloudNGFW::RuleStack`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnRuleStackProps);
}
