"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnRuleStack = exports.FileBlockingAction = exports.FileBlockingDirection = exports.IntelligentFeedFrequency = exports.IntelligentFeedType = exports.CustomUrlCategoryAction = exports.RuleStackProfilesFileBlockingProfile = exports.RuleStackProfilesUrlFilteringProfile = exports.RuleStackProfilesVulnerabilityProfile = exports.RuleStackProfilesAntiVirusProfile = exports.RuleStackProfilesAntiSpywareProfile = exports.toJson_FileBlocking = exports.toJson_CertObject = exports.toJson_IntelligentFeed = exports.toJson_CustomUrlCategory = exports.toJson_FqdnList = exports.toJson_PrefixList = exports.toJson_Tag = exports.RuleDecryptionRuleType = exports.RuleAction = exports.toJson_UrlCategory = exports.toJson_RuleDestination = exports.toJson_RuleSource = exports.toJson_RuleStackProfiles = exports.RuleStackLookupXForwardedFor = exports.RuleStackScope = exports.toJson_CustomSecurityProfiles = exports.toJson_SecurityObjects = exports.toJson_Rule = exports.toJson_RuleStack = exports.toJson_CfnRuleStackProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnRuleStackProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnRuleStackProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'RuleStackName': obj.ruleStackName,
        'RuleStack': toJson_RuleStack(obj.ruleStack),
        'RuleList': obj.ruleList?.map(y => toJson_Rule(y)),
        'SecurityObjects': toJson_SecurityObjects(obj.securityObjects),
        'CustomSecurityProfiles': toJson_CustomSecurityProfiles(obj.customSecurityProfiles),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnRuleStackProps = toJson_CfnRuleStackProps;
/**
 * Converts an object of type 'RuleStack' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_RuleStack(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccountId': obj.accountId,
        'Scope': obj.scope,
        'LookupXForwardedFor': obj.lookupXForwardedFor,
        'MinAppIdVersion': obj.minAppIdVersion,
        'Profiles': toJson_RuleStackProfiles(obj.profiles),
        'Description': obj.description,
        'Deploy': obj.deploy,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_RuleStack = toJson_RuleStack;
/**
 * Converts an object of type 'Rule' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Rule(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'RuleName': obj.ruleName,
        'Description': obj.description,
        'RuleListType': obj.ruleListType,
        'Priority': obj.priority,
        'Enabled': obj.enabled,
        'Source': toJson_RuleSource(obj.source),
        'NegateSource': obj.negateSource,
        'Destination': toJson_RuleDestination(obj.destination),
        'NegateDestination': obj.negateDestination,
        'Applications': obj.applications?.map(y => y),
        'Category': toJson_UrlCategory(obj.category),
        'Protocol': obj.protocol,
        'ProtPortList': obj.protPortList?.map(y => y),
        'AuditComment': obj.auditComment,
        'Action': obj.action,
        'Logging': obj.logging,
        'DecryptionRuleType': obj.decryptionRuleType,
        'InboundInspectionCertificate': obj.inboundInspectionCertificate,
        'Tags': obj.tags?.map(y => toJson_Tag(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Rule = toJson_Rule;
/**
 * Converts an object of type 'SecurityObjects' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_SecurityObjects(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'PrefixLists': obj.prefixLists?.map(y => toJson_PrefixList(y)),
        'FqdnLists': obj.fqdnLists?.map(y => toJson_FqdnList(y)),
        'CustomUrlCategories': obj.customUrlCategories?.map(y => toJson_CustomUrlCategory(y)),
        'IntelligentFeeds': obj.intelligentFeeds?.map(y => toJson_IntelligentFeed(y)),
        'CertificateObjects': obj.certificateObjects?.map(y => toJson_CertObject(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_SecurityObjects = toJson_SecurityObjects;
/**
 * Converts an object of type 'CustomSecurityProfiles' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CustomSecurityProfiles(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'FileBlocking': toJson_FileBlocking(obj.fileBlocking),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CustomSecurityProfiles = toJson_CustomSecurityProfiles;
/* eslint-enable max-len, quote-props */
/**
 * @schema RuleStackScope
 */
var RuleStackScope;
(function (RuleStackScope) {
    /** Local */
    RuleStackScope["LOCAL"] = "Local";
})(RuleStackScope = exports.RuleStackScope || (exports.RuleStackScope = {}));
/**
 * @schema RuleStackLookupXForwardedFor
 */
var RuleStackLookupXForwardedFor;
(function (RuleStackLookupXForwardedFor) {
    /** SecurityPolicy */
    RuleStackLookupXForwardedFor["SECURITY_POLICY"] = "SecurityPolicy";
    /** None */
    RuleStackLookupXForwardedFor["NONE"] = "None";
})(RuleStackLookupXForwardedFor = exports.RuleStackLookupXForwardedFor || (exports.RuleStackLookupXForwardedFor = {}));
/**
 * Converts an object of type 'RuleStackProfiles' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_RuleStackProfiles(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AntiSpywareProfile': obj.antiSpywareProfile,
        'AntiVirusProfile': obj.antiVirusProfile,
        'VulnerabilityProfile': obj.vulnerabilityProfile,
        'URLFilteringProfile': obj.urlFilteringProfile,
        'FileBlockingProfile': obj.fileBlockingProfile,
        'OutboundTrustCertificate': obj.outboundTrustCertificate,
        'OutboundUntrustCertificate': obj.outboundUntrustCertificate,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_RuleStackProfiles = toJson_RuleStackProfiles;
/**
 * Converts an object of type 'RuleSource' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_RuleSource(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Cidrs': obj.cidrs?.map(y => y),
        'PrefixLists': obj.prefixLists?.map(y => y),
        'Countries': obj.countries?.map(y => y),
        'Feeds': obj.feeds?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_RuleSource = toJson_RuleSource;
/**
 * Converts an object of type 'RuleDestination' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_RuleDestination(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Cidrs': obj.cidrs?.map(y => y),
        'FqdnLists': obj.fqdnLists?.map(y => y),
        'PrefixLists': obj.prefixLists?.map(y => y),
        'Countries': obj.countries?.map(y => y),
        'Feeds': obj.feeds?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_RuleDestination = toJson_RuleDestination;
/**
 * Converts an object of type 'UrlCategory' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_UrlCategory(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'URLCategoryNames': obj.urlCategoryNames?.map(y => y),
        'Feeds': obj.feeds?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_UrlCategory = toJson_UrlCategory;
/* eslint-enable max-len, quote-props */
/**
 * @schema RuleAction
 */
var RuleAction;
(function (RuleAction) {
    /** Allow */
    RuleAction["ALLOW"] = "Allow";
    /** DenySilent */
    RuleAction["DENY_SILENT"] = "DenySilent";
    /** DenyResetServer */
    RuleAction["DENY_RESET_SERVER"] = "DenyResetServer";
    /** DenyResetBoth */
    RuleAction["DENY_RESET_BOTH"] = "DenyResetBoth";
})(RuleAction = exports.RuleAction || (exports.RuleAction = {}));
/**
 * @schema RuleDecryptionRuleType
 */
var RuleDecryptionRuleType;
(function (RuleDecryptionRuleType) {
    /** SSLOutboundInspection */
    RuleDecryptionRuleType["SSL_OUTBOUND_INSPECTION"] = "SSLOutboundInspection";
    /** SSLInboundInspection */
    RuleDecryptionRuleType["SSL_INBOUND_INSPECTION"] = "SSLInboundInspection";
    /** SSLOutboundNoInspection */
    RuleDecryptionRuleType["SSL_OUTBOUND_NO_INSPECTION"] = "SSLOutboundNoInspection";
    /** SSLInboundNoInspection */
    RuleDecryptionRuleType["SSL_INBOUND_NO_INSPECTION"] = "SSLInboundNoInspection";
})(RuleDecryptionRuleType = exports.RuleDecryptionRuleType || (exports.RuleDecryptionRuleType = {}));
/**
 * Converts an object of type 'Tag' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Tag(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Key': obj.key,
        'Value': obj.value,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Tag = toJson_Tag;
/**
 * Converts an object of type 'PrefixList' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_PrefixList(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'PrefixList': obj.prefixList?.map(y => y),
        'AuditComment': obj.auditComment,
        'Description': obj.description,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_PrefixList = toJson_PrefixList;
/**
 * Converts an object of type 'FqdnList' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_FqdnList(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Description': obj.description,
        'FqdnList': obj.fqdnList?.map(y => y),
        'AuditComment': obj.auditComment,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_FqdnList = toJson_FqdnList;
/**
 * Converts an object of type 'CustomUrlCategory' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CustomUrlCategory(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'URLTargets': obj.urlTargets?.map(y => y),
        'Name': obj.name,
        'Description': obj.description,
        'Action': obj.action,
        'AuditComment': obj.auditComment,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CustomUrlCategory = toJson_CustomUrlCategory;
/**
 * Converts an object of type 'IntelligentFeed' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_IntelligentFeed(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Description': obj.description,
        'Certificate': obj.certificate,
        'FeedURL': obj.feedUrl,
        'Type': obj.type,
        'Frequency': obj.frequency,
        'Time': obj.time,
        'AuditComment': obj.auditComment,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_IntelligentFeed = toJson_IntelligentFeed;
/**
 * Converts an object of type 'CertObject' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CertObject(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Description': obj.description,
        'CertificateSignerArn': obj.certificateSignerArn,
        'CertificateSelfSigned': obj.certificateSelfSigned,
        'AuditComment': obj.auditComment,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CertObject = toJson_CertObject;
/**
 * Converts an object of type 'FileBlocking' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_FileBlocking(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Direction': obj.direction,
        'FileType': obj.fileType,
        'Description': obj.description,
        'Action': obj.action,
        'AuditComment': obj.auditComment,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_FileBlocking = toJson_FileBlocking;
/* eslint-enable max-len, quote-props */
/**
 * @schema RuleStackProfilesAntiSpywareProfile
 */
var RuleStackProfilesAntiSpywareProfile;
(function (RuleStackProfilesAntiSpywareProfile) {
    /** BestPractice */
    RuleStackProfilesAntiSpywareProfile["BEST_PRACTICE"] = "BestPractice";
    /** None */
    RuleStackProfilesAntiSpywareProfile["NONE"] = "None";
})(RuleStackProfilesAntiSpywareProfile = exports.RuleStackProfilesAntiSpywareProfile || (exports.RuleStackProfilesAntiSpywareProfile = {}));
/**
 * @schema RuleStackProfilesAntiVirusProfile
 */
var RuleStackProfilesAntiVirusProfile;
(function (RuleStackProfilesAntiVirusProfile) {
    /** BestPractice */
    RuleStackProfilesAntiVirusProfile["BEST_PRACTICE"] = "BestPractice";
    /** None */
    RuleStackProfilesAntiVirusProfile["NONE"] = "None";
})(RuleStackProfilesAntiVirusProfile = exports.RuleStackProfilesAntiVirusProfile || (exports.RuleStackProfilesAntiVirusProfile = {}));
/**
 * @schema RuleStackProfilesVulnerabilityProfile
 */
var RuleStackProfilesVulnerabilityProfile;
(function (RuleStackProfilesVulnerabilityProfile) {
    /** BestPractice */
    RuleStackProfilesVulnerabilityProfile["BEST_PRACTICE"] = "BestPractice";
    /** None */
    RuleStackProfilesVulnerabilityProfile["NONE"] = "None";
})(RuleStackProfilesVulnerabilityProfile = exports.RuleStackProfilesVulnerabilityProfile || (exports.RuleStackProfilesVulnerabilityProfile = {}));
/**
 * @schema RuleStackProfilesUrlFilteringProfile
 */
var RuleStackProfilesUrlFilteringProfile;
(function (RuleStackProfilesUrlFilteringProfile) {
    /** BestPractice */
    RuleStackProfilesUrlFilteringProfile["BEST_PRACTICE"] = "BestPractice";
    /** None */
    RuleStackProfilesUrlFilteringProfile["NONE"] = "None";
})(RuleStackProfilesUrlFilteringProfile = exports.RuleStackProfilesUrlFilteringProfile || (exports.RuleStackProfilesUrlFilteringProfile = {}));
/**
 * @schema RuleStackProfilesFileBlockingProfile
 */
var RuleStackProfilesFileBlockingProfile;
(function (RuleStackProfilesFileBlockingProfile) {
    /** Custom */
    RuleStackProfilesFileBlockingProfile["CUSTOM"] = "Custom";
    /** BestPractice */
    RuleStackProfilesFileBlockingProfile["BEST_PRACTICE"] = "BestPractice";
    /** None */
    RuleStackProfilesFileBlockingProfile["NONE"] = "None";
})(RuleStackProfilesFileBlockingProfile = exports.RuleStackProfilesFileBlockingProfile || (exports.RuleStackProfilesFileBlockingProfile = {}));
/**
 * @schema CustomUrlCategoryAction
 */
var CustomUrlCategoryAction;
(function (CustomUrlCategoryAction) {
    /** none */
    CustomUrlCategoryAction["NONE"] = "none";
    /** allow */
    CustomUrlCategoryAction["ALLOW"] = "allow";
    /** alert */
    CustomUrlCategoryAction["ALERT"] = "alert";
    /** block */
    CustomUrlCategoryAction["BLOCK"] = "block";
})(CustomUrlCategoryAction = exports.CustomUrlCategoryAction || (exports.CustomUrlCategoryAction = {}));
/**
 * @schema IntelligentFeedType
 */
var IntelligentFeedType;
(function (IntelligentFeedType) {
    /** IP_LIST */
    IntelligentFeedType["IP_UNDERSCORE_LIST"] = "IP_LIST";
    /** URL_LIST */
    IntelligentFeedType["URL_UNDERSCORE_LIST"] = "URL_LIST";
})(IntelligentFeedType = exports.IntelligentFeedType || (exports.IntelligentFeedType = {}));
/**
 * @schema IntelligentFeedFrequency
 */
var IntelligentFeedFrequency;
(function (IntelligentFeedFrequency) {
    /** HOURLY */
    IntelligentFeedFrequency["HOURLY"] = "HOURLY";
    /** DAILY */
    IntelligentFeedFrequency["DAILY"] = "DAILY";
})(IntelligentFeedFrequency = exports.IntelligentFeedFrequency || (exports.IntelligentFeedFrequency = {}));
/**
 * @schema FileBlockingDirection
 */
var FileBlockingDirection;
(function (FileBlockingDirection) {
    /** upload */
    FileBlockingDirection["UPLOAD"] = "upload";
    /** download */
    FileBlockingDirection["DOWNLOAD"] = "download";
    /** both */
    FileBlockingDirection["BOTH"] = "both";
})(FileBlockingDirection = exports.FileBlockingDirection || (exports.FileBlockingDirection = {}));
/**
 * @schema FileBlockingAction
 */
var FileBlockingAction;
(function (FileBlockingAction) {
    /** alert */
    FileBlockingAction["ALERT"] = "alert";
    /** block */
    FileBlockingAction["BLOCK"] = "block";
    /** continue */
    FileBlockingAction["CONTINUE"] = "continue";
})(FileBlockingAction = exports.FileBlockingAction || (exports.FileBlockingAction = {}));
/**
 * A CloudFormation `PaloAltoNetworks::CloudNGFW::RuleStack`
 *
 * @cloudformationResource PaloAltoNetworks::CloudNGFW::RuleStack
 * @stability external
 * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
 */
class CfnRuleStack extends cdk.CfnResource {
    /**
     * Create a new `PaloAltoNetworks::CloudNGFW::RuleStack`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRuleStack.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnRuleStackProps(props) });
        this.props = props;
    }
}
exports.CfnRuleStack = CfnRuleStack;
_a = JSII_RTTI_SYMBOL_1;
CfnRuleStack[_a] = { fqn: "@cdk-cloudformation/paloaltonetworks-cloudngfw-rulestack.CfnRuleStack", version: "2.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnRuleStack.CFN_RESOURCE_TYPE_NAME = "PaloAltoNetworks::CloudNGFW::RuleStack";
//# sourceMappingURL=data:application/json;base64,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