/**
* plotly.js (geo) v2.32.0
* Copyright 2012-2024, Plotly, Inc.
* All rights reserved.
* Licensed under the MIT license
*/
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["Plotly"] = factory();
	else
		root["Plotly"] = factory();
})(self, function() {
return /******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 9288:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var rules = {
  "X,X div": "direction:ltr;font-family:\"Open Sans\",verdana,arial,sans-serif;margin:0;padding:0;",
  "X input,X button": "font-family:\"Open Sans\",verdana,arial,sans-serif;",
  "X input:focus,X button:focus": "outline:none;",
  "X a": "text-decoration:none;",
  "X a:hover": "text-decoration:none;",
  "X .crisp": "shape-rendering:crispEdges;",
  "X .user-select-none": "-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;-o-user-select:none;user-select:none;",
  "X svg": "overflow:hidden;",
  "X svg a": "fill:#447adb;",
  "X svg a:hover": "fill:#3c6dc5;",
  "X .main-svg": "position:absolute;top:0;left:0;pointer-events:none;",
  "X .main-svg .draglayer": "pointer-events:all;",
  "X .cursor-default": "cursor:default;",
  "X .cursor-pointer": "cursor:pointer;",
  "X .cursor-crosshair": "cursor:crosshair;",
  "X .cursor-move": "cursor:move;",
  "X .cursor-col-resize": "cursor:col-resize;",
  "X .cursor-row-resize": "cursor:row-resize;",
  "X .cursor-ns-resize": "cursor:ns-resize;",
  "X .cursor-ew-resize": "cursor:ew-resize;",
  "X .cursor-sw-resize": "cursor:sw-resize;",
  "X .cursor-s-resize": "cursor:s-resize;",
  "X .cursor-se-resize": "cursor:se-resize;",
  "X .cursor-w-resize": "cursor:w-resize;",
  "X .cursor-e-resize": "cursor:e-resize;",
  "X .cursor-nw-resize": "cursor:nw-resize;",
  "X .cursor-n-resize": "cursor:n-resize;",
  "X .cursor-ne-resize": "cursor:ne-resize;",
  "X .cursor-grab": "cursor:-webkit-grab;cursor:grab;",
  "X .modebar": "position:absolute;top:2px;right:2px;",
  "X .ease-bg": "-webkit-transition:background-color .3s ease 0s;-moz-transition:background-color .3s ease 0s;-ms-transition:background-color .3s ease 0s;-o-transition:background-color .3s ease 0s;transition:background-color .3s ease 0s;",
  "X .modebar--hover>:not(.watermark)": "opacity:0;-webkit-transition:opacity .3s ease 0s;-moz-transition:opacity .3s ease 0s;-ms-transition:opacity .3s ease 0s;-o-transition:opacity .3s ease 0s;transition:opacity .3s ease 0s;",
  "X:hover .modebar--hover .modebar-group": "opacity:1;",
  "X .modebar-group": "float:left;display:inline-block;box-sizing:border-box;padding-left:8px;position:relative;vertical-align:middle;white-space:nowrap;",
  "X .modebar-btn": "position:relative;font-size:16px;padding:3px 4px;height:22px;cursor:pointer;line-height:normal;box-sizing:border-box;",
  "X .modebar-btn svg": "position:relative;top:2px;",
  "X .modebar.vertical": "display:flex;flex-direction:column;flex-wrap:wrap;align-content:flex-end;max-height:100%;",
  "X .modebar.vertical svg": "top:-1px;",
  "X .modebar.vertical .modebar-group": "display:block;float:none;padding-left:0px;padding-bottom:8px;",
  "X .modebar.vertical .modebar-group .modebar-btn": "display:block;text-align:center;",
  "X [data-title]:before,X [data-title]:after": "position:absolute;-webkit-transform:translate3d(0, 0, 0);-moz-transform:translate3d(0, 0, 0);-ms-transform:translate3d(0, 0, 0);-o-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);display:none;opacity:0;z-index:1001;pointer-events:none;top:110%;right:50%;",
  "X [data-title]:hover:before,X [data-title]:hover:after": "display:block;opacity:1;",
  "X [data-title]:before": "content:\"\";position:absolute;background:rgba(0,0,0,0);border:6px solid rgba(0,0,0,0);z-index:1002;margin-top:-12px;border-bottom-color:#69738a;margin-right:-6px;",
  "X [data-title]:after": "content:attr(data-title);background:#69738a;color:#fff;padding:8px 10px;font-size:12px;line-height:12px;white-space:nowrap;margin-right:-18px;border-radius:2px;",
  "X .vertical [data-title]:before,X .vertical [data-title]:after": "top:0%;right:200%;",
  "X .vertical [data-title]:before": "border:6px solid rgba(0,0,0,0);border-left-color:#69738a;margin-top:8px;margin-right:-30px;",
  Y: "font-family:\"Open Sans\",verdana,arial,sans-serif;position:fixed;top:50px;right:20px;z-index:10000;font-size:10pt;max-width:180px;",
  "Y p": "margin:0;",
  "Y .notifier-note": "min-width:180px;max-width:250px;border:1px solid #fff;z-index:3000;margin:0;background-color:#8c97af;background-color:rgba(140,151,175,.9);color:#fff;padding:10px;overflow-wrap:break-word;word-wrap:break-word;-ms-hyphens:auto;-webkit-hyphens:auto;hyphens:auto;",
  "Y .notifier-close": "color:#fff;opacity:.8;float:right;padding:0 5px;background:none;border:none;font-size:20px;font-weight:bold;line-height:20px;",
  "Y .notifier-close:hover": "color:#444;text-decoration:none;cursor:pointer;"
};
for (var selector in rules) {
  var fullSelector = selector.replace(/^,/, ' ,').replace(/X/g, '.js-plotly-plot .plotly').replace(/Y/g, '.plotly-notifier');
  Lib.addStyleRule(fullSelector, rules[selector]);
}

/***/ }),

/***/ 6712:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__(1843);

/***/ }),

/***/ 6144:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__(7776);

/***/ }),

/***/ 4543:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__(4272);

/***/ }),

/***/ 2016:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__(4884);

/***/ }),

/***/ 5556:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__(6744);

/***/ }),

/***/ 6489:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__(2028);

/***/ }),

/***/ 9344:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Plotly = __webpack_require__(2016);
Plotly.register([
// traces
__webpack_require__(8363), __webpack_require__(4543),
// transforms
__webpack_require__(6712), __webpack_require__(5556), __webpack_require__(6489), __webpack_require__(7312),
// components
__webpack_require__(6144)]);
module.exports = Plotly;

/***/ }),

/***/ 8363:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__(6952);

/***/ }),

/***/ 7312:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__(6272);

/***/ }),

/***/ 2196:
/***/ (function(module) {

"use strict";


/**
 * All paths are tuned for maximum scalability of the arrowhead,
 * ie throughout arrowwidth=0.3..3 the head is joined smoothly
 * to the line, with the line coming from the left and ending at (0, 0).
 *
 * `backoff` is the distance to move the arrowhead and the end of the line,
 * in order that the arrowhead points to the desired place, either at
 * the tip of the arrow or (in the case of circle or square)
 * the center of the symbol.
 *
 * `noRotate`, if truthy, says that this arrowhead should not rotate with the
 * arrow. That's the case for squares, which should always be straight, and
 * circles, for which it's irrelevant.
 */
module.exports = [
// no arrow
{
  path: '',
  backoff: 0
},
// wide with flat back
{
  path: 'M-2.4,-3V3L0.6,0Z',
  backoff: 0.6
},
// narrower with flat back
{
  path: 'M-3.7,-2.5V2.5L1.3,0Z',
  backoff: 1.3
},
// barbed
{
  path: 'M-4.45,-3L-1.65,-0.2V0.2L-4.45,3L1.55,0Z',
  backoff: 1.55
},
// wide line-drawn
{
  path: 'M-2.2,-2.2L-0.2,-0.2V0.2L-2.2,2.2L-1.4,3L1.6,0L-1.4,-3Z',
  backoff: 1.6
},
// narrower line-drawn
{
  path: 'M-4.4,-2.1L-0.6,-0.2V0.2L-4.4,2.1L-4,3L2,0L-4,-3Z',
  backoff: 2
},
// circle
{
  path: 'M2,0A2,2 0 1,1 0,-2A2,2 0 0,1 2,0Z',
  backoff: 0,
  noRotate: true
},
// square
{
  path: 'M2,2V-2H-2V2Z',
  backoff: 0,
  noRotate: true
}];

/***/ }),

/***/ 3916:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var ARROWPATHS = __webpack_require__(2196);
var fontAttrs = __webpack_require__(5376);
var cartesianConstants = __webpack_require__(3816);
var templatedArray = (__webpack_require__(1780).templatedArray);
var axisPlaceableObjs = __webpack_require__(6208);
function arrowAxisRefDescription(axis) {
  return ['In order for absolute positioning of the arrow to work, *a' + axis + 'ref* must be exactly the same as *' + axis + 'ref*, otherwise *a' + axis + 'ref* will revert to *pixel* (explained next).', 'For relative positioning, *a' + axis + 'ref* can be set to *pixel*,', 'in which case the *a' + axis + '* value is specified in pixels', 'relative to *' + axis + '*.', 'Absolute positioning is useful', 'for trendline annotations which should continue to indicate', 'the correct trend when zoomed. Relative positioning is useful', 'for specifying the text offset for an annotated point.'].join(' ');
}
function arrowCoordinateDescription(axis, lower, upper) {
  return ['Sets the', axis, 'component of the arrow tail about the arrow head.', 'If `a' + axis + 'ref` is `pixel`, a positive (negative)', 'component corresponds to an arrow pointing', 'from', upper, 'to', lower, '(' + lower, 'to', upper + ').', 'If `a' + axis + 'ref` is not `pixel` and is exactly the same as `' + axis + 'ref`,', 'this is an absolute value on that axis,', 'like `' + axis + '`, specified in the same coordinates as `' + axis + 'ref`.'].join(' ');
}
module.exports = templatedArray('annotation', {
  visible: {
    valType: 'boolean',
    dflt: true,
    editType: 'calc+arraydraw'
  },
  text: {
    valType: 'string',
    editType: 'calc+arraydraw'
  },
  textangle: {
    valType: 'angle',
    dflt: 0,
    editType: 'calc+arraydraw'
  },
  font: fontAttrs({
    editType: 'calc+arraydraw',
    colorEditType: 'arraydraw'
  }),
  width: {
    valType: 'number',
    min: 1,
    dflt: null,
    editType: 'calc+arraydraw'
  },
  height: {
    valType: 'number',
    min: 1,
    dflt: null,
    editType: 'calc+arraydraw'
  },
  opacity: {
    valType: 'number',
    min: 0,
    max: 1,
    dflt: 1,
    editType: 'arraydraw'
  },
  align: {
    valType: 'enumerated',
    values: ['left', 'center', 'right'],
    dflt: 'center',
    editType: 'arraydraw'
  },
  valign: {
    valType: 'enumerated',
    values: ['top', 'middle', 'bottom'],
    dflt: 'middle',
    editType: 'arraydraw'
  },
  bgcolor: {
    valType: 'color',
    dflt: 'rgba(0,0,0,0)',
    editType: 'arraydraw'
  },
  bordercolor: {
    valType: 'color',
    dflt: 'rgba(0,0,0,0)',
    editType: 'arraydraw'
  },
  borderpad: {
    valType: 'number',
    min: 0,
    dflt: 1,
    editType: 'calc+arraydraw'
  },
  borderwidth: {
    valType: 'number',
    min: 0,
    dflt: 1,
    editType: 'calc+arraydraw'
  },
  // arrow
  showarrow: {
    valType: 'boolean',
    dflt: true,
    editType: 'calc+arraydraw'
  },
  arrowcolor: {
    valType: 'color',
    editType: 'arraydraw'
  },
  arrowhead: {
    valType: 'integer',
    min: 0,
    max: ARROWPATHS.length,
    dflt: 1,
    editType: 'arraydraw'
  },
  startarrowhead: {
    valType: 'integer',
    min: 0,
    max: ARROWPATHS.length,
    dflt: 1,
    editType: 'arraydraw'
  },
  arrowside: {
    valType: 'flaglist',
    flags: ['end', 'start'],
    extras: ['none'],
    dflt: 'end',
    editType: 'arraydraw'
  },
  arrowsize: {
    valType: 'number',
    min: 0.3,
    dflt: 1,
    editType: 'calc+arraydraw'
  },
  startarrowsize: {
    valType: 'number',
    min: 0.3,
    dflt: 1,
    editType: 'calc+arraydraw'
  },
  arrowwidth: {
    valType: 'number',
    min: 0.1,
    editType: 'calc+arraydraw'
  },
  standoff: {
    valType: 'number',
    min: 0,
    dflt: 0,
    editType: 'calc+arraydraw'
  },
  startstandoff: {
    valType: 'number',
    min: 0,
    dflt: 0,
    editType: 'calc+arraydraw'
  },
  ax: {
    valType: 'any',
    editType: 'calc+arraydraw'
  },
  ay: {
    valType: 'any',
    editType: 'calc+arraydraw'
  },
  axref: {
    valType: 'enumerated',
    dflt: 'pixel',
    values: ['pixel', cartesianConstants.idRegex.x.toString()],
    editType: 'calc'
  },
  ayref: {
    valType: 'enumerated',
    dflt: 'pixel',
    values: ['pixel', cartesianConstants.idRegex.y.toString()],
    editType: 'calc'
  },
  // positioning
  xref: {
    valType: 'enumerated',
    values: ['paper', cartesianConstants.idRegex.x.toString()],
    editType: 'calc'
  },
  x: {
    valType: 'any',
    editType: 'calc+arraydraw'
  },
  xanchor: {
    valType: 'enumerated',
    values: ['auto', 'left', 'center', 'right'],
    dflt: 'auto',
    editType: 'calc+arraydraw'
  },
  xshift: {
    valType: 'number',
    dflt: 0,
    editType: 'calc+arraydraw'
  },
  yref: {
    valType: 'enumerated',
    values: ['paper', cartesianConstants.idRegex.y.toString()],
    editType: 'calc'
  },
  y: {
    valType: 'any',
    editType: 'calc+arraydraw'
  },
  yanchor: {
    valType: 'enumerated',
    values: ['auto', 'top', 'middle', 'bottom'],
    dflt: 'auto',
    editType: 'calc+arraydraw'
  },
  yshift: {
    valType: 'number',
    dflt: 0,
    editType: 'calc+arraydraw'
  },
  clicktoshow: {
    valType: 'enumerated',
    values: [false, 'onoff', 'onout'],
    dflt: false,
    editType: 'arraydraw'
  },
  xclick: {
    valType: 'any',
    editType: 'arraydraw'
  },
  yclick: {
    valType: 'any',
    editType: 'arraydraw'
  },
  hovertext: {
    valType: 'string',
    editType: 'arraydraw'
  },
  hoverlabel: {
    bgcolor: {
      valType: 'color',
      editType: 'arraydraw'
    },
    bordercolor: {
      valType: 'color',
      editType: 'arraydraw'
    },
    font: fontAttrs({
      editType: 'arraydraw'
    }),
    editType: 'arraydraw'
  },
  captureevents: {
    valType: 'boolean',
    editType: 'arraydraw'
  },
  editType: 'calc',
  _deprecated: {
    ref: {
      valType: 'string',
      editType: 'calc'
    }
  }
});

/***/ }),

/***/ 272:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Axes = __webpack_require__(4460);
var draw = (__webpack_require__(6196).draw);
module.exports = function calcAutorange(gd) {
  var fullLayout = gd._fullLayout;
  var annotationList = Lib.filterVisible(fullLayout.annotations);
  if (annotationList.length && gd._fullData.length) {
    return Lib.syncOrAsync([draw, annAutorange], gd);
  }
};
function annAutorange(gd) {
  var fullLayout = gd._fullLayout;

  // find the bounding boxes for each of these annotations'
  // relative to their anchor points
  // use the arrow and the text bg rectangle,
  // as the whole anno may include hidden text in its bbox
  Lib.filterVisible(fullLayout.annotations).forEach(function (ann) {
    var xa = Axes.getFromId(gd, ann.xref);
    var ya = Axes.getFromId(gd, ann.yref);
    var xRefType = Axes.getRefType(ann.xref);
    var yRefType = Axes.getRefType(ann.yref);
    ann._extremes = {};
    if (xRefType === 'range') calcAxisExpansion(ann, xa);
    if (yRefType === 'range') calcAxisExpansion(ann, ya);
  });
}
function calcAxisExpansion(ann, ax) {
  var axId = ax._id;
  var letter = axId.charAt(0);
  var pos = ann[letter];
  var apos = ann['a' + letter];
  var ref = ann[letter + 'ref'];
  var aref = ann['a' + letter + 'ref'];
  var padplus = ann['_' + letter + 'padplus'];
  var padminus = ann['_' + letter + 'padminus'];
  var shift = {
    x: 1,
    y: -1
  }[letter] * ann[letter + 'shift'];
  var headSize = 3 * ann.arrowsize * ann.arrowwidth || 0;
  var headPlus = headSize + shift;
  var headMinus = headSize - shift;
  var startHeadSize = 3 * ann.startarrowsize * ann.arrowwidth || 0;
  var startHeadPlus = startHeadSize + shift;
  var startHeadMinus = startHeadSize - shift;
  var extremes;
  if (aref === ref) {
    // expand for the arrowhead (padded by arrowhead)
    var extremeArrowHead = Axes.findExtremes(ax, [ax.r2c(pos)], {
      ppadplus: headPlus,
      ppadminus: headMinus
    });
    // again for the textbox (padded by textbox)
    var extremeText = Axes.findExtremes(ax, [ax.r2c(apos)], {
      ppadplus: Math.max(padplus, startHeadPlus),
      ppadminus: Math.max(padminus, startHeadMinus)
    });
    extremes = {
      min: [extremeArrowHead.min[0], extremeText.min[0]],
      max: [extremeArrowHead.max[0], extremeText.max[0]]
    };
  } else {
    startHeadPlus = apos ? startHeadPlus + apos : startHeadPlus;
    startHeadMinus = apos ? startHeadMinus - apos : startHeadMinus;
    extremes = Axes.findExtremes(ax, [ax.r2c(pos)], {
      ppadplus: Math.max(padplus, headPlus, startHeadPlus),
      ppadminus: Math.max(padminus, headMinus, startHeadMinus)
    });
  }
  ann._extremes[axId] = extremes;
}

/***/ }),

/***/ 2300:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Registry = __webpack_require__(4040);
var arrayEditor = (__webpack_require__(1780).arrayEditor);
module.exports = {
  hasClickToShow: hasClickToShow,
  onClick: onClick
};

/*
 * hasClickToShow: does the given hoverData have ANY annotations which will
 * turn ON if we click here? (used by hover events to set cursor)
 *
 * gd: graphDiv
 * hoverData: a hoverData array, as included with the *plotly_hover* or
 *     *plotly_click* events in the `points` attribute
 *
 * returns: boolean
 */
function hasClickToShow(gd, hoverData) {
  var sets = getToggleSets(gd, hoverData);
  return sets.on.length > 0 || sets.explicitOff.length > 0;
}

/*
 * onClick: perform the toggling (via Plotly.update) implied by clicking
 * at this hoverData
 *
 * gd: graphDiv
 * hoverData: a hoverData array, as included with the *plotly_hover* or
 *     *plotly_click* events in the `points` attribute
 *
 * returns: Promise that the update is complete
 */
function onClick(gd, hoverData) {
  var toggleSets = getToggleSets(gd, hoverData);
  var onSet = toggleSets.on;
  var offSet = toggleSets.off.concat(toggleSets.explicitOff);
  var update = {};
  var annotationsOut = gd._fullLayout.annotations;
  var i, editHelpers;
  if (!(onSet.length || offSet.length)) return;
  for (i = 0; i < onSet.length; i++) {
    editHelpers = arrayEditor(gd.layout, 'annotations', annotationsOut[onSet[i]]);
    editHelpers.modifyItem('visible', true);
    Lib.extendFlat(update, editHelpers.getUpdateObj());
  }
  for (i = 0; i < offSet.length; i++) {
    editHelpers = arrayEditor(gd.layout, 'annotations', annotationsOut[offSet[i]]);
    editHelpers.modifyItem('visible', false);
    Lib.extendFlat(update, editHelpers.getUpdateObj());
  }
  return Registry.call('update', gd, {}, update);
}

/*
 * getToggleSets: find the annotations which will turn on or off at this
 * hoverData
 *
 * gd: graphDiv
 * hoverData: a hoverData array, as included with the *plotly_hover* or
 *     *plotly_click* events in the `points` attribute
 *
 * returns: {
 *   on: Array (indices of annotations to turn on),
 *   off: Array (indices to turn off because you're not hovering on them),
 *   explicitOff: Array (indices to turn off because you *are* hovering on them)
 * }
 */
function getToggleSets(gd, hoverData) {
  var annotations = gd._fullLayout.annotations;
  var onSet = [];
  var offSet = [];
  var explicitOffSet = [];
  var hoverLen = (hoverData || []).length;
  var i, j, anni, showMode, pointj, xa, ya, toggleType;
  for (i = 0; i < annotations.length; i++) {
    anni = annotations[i];
    showMode = anni.clicktoshow;
    if (showMode) {
      for (j = 0; j < hoverLen; j++) {
        pointj = hoverData[j];
        xa = pointj.xaxis;
        ya = pointj.yaxis;
        if (xa._id === anni.xref && ya._id === anni.yref && xa.d2r(pointj.x) === clickData2r(anni._xclick, xa) && ya.d2r(pointj.y) === clickData2r(anni._yclick, ya)) {
          // match! toggle this annotation
          // regardless of its clicktoshow mode
          // but if it's onout mode, off is implicit
          if (anni.visible) {
            if (showMode === 'onout') toggleType = offSet;else toggleType = explicitOffSet;
          } else {
            toggleType = onSet;
          }
          toggleType.push(i);
          break;
        }
      }
      if (j === hoverLen) {
        // no match - only turn this annotation OFF, and only if
        // showmode is 'onout'
        if (anni.visible && showMode === 'onout') offSet.push(i);
      }
    }
  }
  return {
    on: onSet,
    off: offSet,
    explicitOff: explicitOffSet
  };
}

// to handle log axes until v3
function clickData2r(d, ax) {
  return ax.type === 'log' ? ax.l2r(d) : ax.d2r(d);
}

/***/ }),

/***/ 7192:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Color = __webpack_require__(6308);

// defaults common to 'annotations' and 'annotations3d'
module.exports = function handleAnnotationCommonDefaults(annIn, annOut, fullLayout, coerce) {
  coerce('opacity');
  var bgColor = coerce('bgcolor');
  var borderColor = coerce('bordercolor');
  var borderOpacity = Color.opacity(borderColor);
  coerce('borderpad');
  var borderWidth = coerce('borderwidth');
  var showArrow = coerce('showarrow');
  coerce('text', showArrow ? ' ' : fullLayout._dfltTitle.annotation);
  coerce('textangle');
  Lib.coerceFont(coerce, 'font', fullLayout.font);
  coerce('width');
  coerce('align');
  var h = coerce('height');
  if (h) coerce('valign');
  if (showArrow) {
    var arrowside = coerce('arrowside');
    var arrowhead;
    var arrowsize;
    if (arrowside.indexOf('end') !== -1) {
      arrowhead = coerce('arrowhead');
      arrowsize = coerce('arrowsize');
    }
    if (arrowside.indexOf('start') !== -1) {
      coerce('startarrowhead', arrowhead);
      coerce('startarrowsize', arrowsize);
    }
    coerce('arrowcolor', borderOpacity ? annOut.bordercolor : Color.defaultLine);
    coerce('arrowwidth', (borderOpacity && borderWidth || 1) * 2);
    coerce('standoff');
    coerce('startstandoff');
  }
  var hoverText = coerce('hovertext');
  var globalHoverLabel = fullLayout.hoverlabel || {};
  if (hoverText) {
    var hoverBG = coerce('hoverlabel.bgcolor', globalHoverLabel.bgcolor || (Color.opacity(bgColor) ? Color.rgb(bgColor) : Color.defaultLine));
    var hoverBorder = coerce('hoverlabel.bordercolor', globalHoverLabel.bordercolor || Color.contrast(hoverBG));
    var fontDflt = Lib.extendFlat({}, globalHoverLabel.font);
    if (!fontDflt.color) {
      fontDflt.color = hoverBorder;
    }
    Lib.coerceFont(coerce, 'hoverlabel.font', fontDflt);
  }
  coerce('captureevents', !!hoverText);
};

/***/ }),

/***/ 9208:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isNumeric = __webpack_require__(8248);
var toLogRange = __webpack_require__(6896);

/*
 * convertCoords: when converting an axis between log and linear
 * you need to alter any annotations on that axis to keep them
 * pointing at the same data point.
 * In v3.0 this will become obsolete
 *
 * gd: the plot div
 * ax: the axis being changed
 * newType: the type it's getting
 * doExtra: function(attr, val) from inside relayout that sets the attribute.
 *     Use this to make the changes as it's aware if any other changes in the
 *     same relayout call should override this conversion.
 */
module.exports = function convertCoords(gd, ax, newType, doExtra) {
  ax = ax || {};
  var toLog = newType === 'log' && ax.type === 'linear';
  var fromLog = newType === 'linear' && ax.type === 'log';
  if (!(toLog || fromLog)) return;
  var annotations = gd._fullLayout.annotations;
  var axLetter = ax._id.charAt(0);
  var ann;
  var attrPrefix;
  function convert(attr) {
    var currentVal = ann[attr];
    var newVal = null;
    if (toLog) newVal = toLogRange(currentVal, ax.range);else newVal = Math.pow(10, currentVal);

    // if conversion failed, delete the value so it gets a default value
    if (!isNumeric(newVal)) newVal = null;
    doExtra(attrPrefix + attr, newVal);
  }
  for (var i = 0; i < annotations.length; i++) {
    ann = annotations[i];
    attrPrefix = 'annotations[' + i + '].';
    if (ann[axLetter + 'ref'] === ax._id) convert(axLetter);
    if (ann['a' + axLetter + 'ref'] === ax._id) convert('a' + axLetter);
  }
};

/***/ }),

/***/ 5216:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Axes = __webpack_require__(4460);
var handleArrayContainerDefaults = __webpack_require__(1272);
var handleAnnotationCommonDefaults = __webpack_require__(7192);
var attributes = __webpack_require__(3916);
module.exports = function supplyLayoutDefaults(layoutIn, layoutOut) {
  handleArrayContainerDefaults(layoutIn, layoutOut, {
    name: 'annotations',
    handleItemDefaults: handleAnnotationDefaults
  });
};
function handleAnnotationDefaults(annIn, annOut, fullLayout) {
  function coerce(attr, dflt) {
    return Lib.coerce(annIn, annOut, attributes, attr, dflt);
  }
  var visible = coerce('visible');
  var clickToShow = coerce('clicktoshow');
  if (!(visible || clickToShow)) return;
  handleAnnotationCommonDefaults(annIn, annOut, fullLayout, coerce);
  var showArrow = annOut.showarrow;

  // positioning
  var axLetters = ['x', 'y'];
  var arrowPosDflt = [-10, -30];
  var gdMock = {
    _fullLayout: fullLayout
  };
  for (var i = 0; i < 2; i++) {
    var axLetter = axLetters[i];

    // xref, yref
    var axRef = Axes.coerceRef(annIn, annOut, gdMock, axLetter, '', 'paper');
    if (axRef !== 'paper') {
      var ax = Axes.getFromId(gdMock, axRef);
      ax._annIndices.push(annOut._index);
    }

    // x, y
    Axes.coercePosition(annOut, gdMock, coerce, axRef, axLetter, 0.5);
    if (showArrow) {
      var arrowPosAttr = 'a' + axLetter;
      // axref, ayref
      var aaxRef = Axes.coerceRef(annIn, annOut, gdMock, arrowPosAttr, 'pixel', ['pixel', 'paper']);

      // for now the arrow can only be on the same axis or specified as pixels
      // TODO: sometime it might be interesting to allow it to be on *any* axis
      // but that would require updates to drawing & autorange code and maybe more
      if (aaxRef !== 'pixel' && aaxRef !== axRef) {
        aaxRef = annOut[arrowPosAttr] = 'pixel';
      }

      // ax, ay
      var aDflt = aaxRef === 'pixel' ? arrowPosDflt[i] : 0.4;
      Axes.coercePosition(annOut, gdMock, coerce, aaxRef, arrowPosAttr, aDflt);
    }

    // xanchor, yanchor
    coerce(axLetter + 'anchor');

    // xshift, yshift
    coerce(axLetter + 'shift');
  }

  // if you have one coordinate you should have both
  Lib.noneOrAll(annIn, annOut, ['x', 'y']);

  // if you have one part of arrow length you should have both
  if (showArrow) {
    Lib.noneOrAll(annIn, annOut, ['ax', 'ay']);
  }
  if (clickToShow) {
    var xClick = coerce('xclick');
    var yClick = coerce('yclick');

    // put the actual click data to bind to into private attributes
    // so we don't have to do this little bit of logic on every hover event
    annOut._xclick = xClick === undefined ? annOut.x : Axes.cleanPosition(xClick, gdMock, annOut.xref);
    annOut._yclick = yClick === undefined ? annOut.y : Axes.cleanPosition(yClick, gdMock, annOut.yref);
  }
}

/***/ }),

/***/ 6196:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var Registry = __webpack_require__(4040);
var Plots = __webpack_require__(7316);
var Lib = __webpack_require__(3400);
var strTranslate = Lib.strTranslate;
var Axes = __webpack_require__(4460);
var Color = __webpack_require__(6308);
var Drawing = __webpack_require__(3616);
var Fx = __webpack_require__(3024);
var svgTextUtils = __webpack_require__(2736);
var setCursor = __webpack_require__(3972);
var dragElement = __webpack_require__(6476);
var arrayEditor = (__webpack_require__(1780).arrayEditor);
var drawArrowHead = __webpack_require__(3652);

// Annotations are stored in gd.layout.annotations, an array of objects
// index can point to one item in this array,
//  or non-numeric to simply add a new one
//  or -1 to modify all existing
// opt can be the full options object, or one key (to be set to value)
//  or undefined to simply redraw
// if opt is blank, val can be 'add' or a full options object to add a new
//  annotation at that point in the array, or 'remove' to delete this one

module.exports = {
  draw: draw,
  drawOne: drawOne,
  drawRaw: drawRaw
};

/*
 * draw: draw all annotations without any new modifications
 */
function draw(gd) {
  var fullLayout = gd._fullLayout;
  fullLayout._infolayer.selectAll('.annotation').remove();
  for (var i = 0; i < fullLayout.annotations.length; i++) {
    if (fullLayout.annotations[i].visible) {
      drawOne(gd, i);
    }
  }
  return Plots.previousPromises(gd);
}

/*
 * drawOne: draw a single cartesian or paper-ref annotation, potentially with modifications
 *
 * index (int): the annotation to draw
 */
function drawOne(gd, index) {
  var fullLayout = gd._fullLayout;
  var options = fullLayout.annotations[index] || {};
  var xa = Axes.getFromId(gd, options.xref);
  var ya = Axes.getFromId(gd, options.yref);
  if (xa) xa.setScale();
  if (ya) ya.setScale();
  drawRaw(gd, options, index, false, xa, ya);
}

// Convert pixels to the coordinates relevant for the axis referred to. For
// example, for paper it would convert to a value normalized by the dimension of
// the plot.
// axDomainRef: if true and axa defined, draws relative to axis domain,
// otherwise draws relative to data (if axa defined) or paper (if not).
function shiftPosition(axa, dAx, axLetter, gs, options) {
  var optAx = options[axLetter];
  var axRef = options[axLetter + 'ref'];
  var vertical = axLetter.indexOf('y') !== -1;
  var axDomainRef = Axes.getRefType(axRef) === 'domain';
  var gsDim = vertical ? gs.h : gs.w;
  if (axa) {
    if (axDomainRef) {
      // here optAx normalized to length of axis (e.g., normally in range
      // 0 to 1). But dAx is in pixels. So we normalize dAx to length of
      // axis before doing the math.
      return optAx + (vertical ? -dAx : dAx) / axa._length;
    } else {
      return axa.p2r(axa.r2p(optAx) + dAx);
    }
  } else {
    return optAx + (vertical ? -dAx : dAx) / gsDim;
  }
}

/**
 * drawRaw: draw a single annotation, potentially with modifications
 *
 * @param {DOM element} gd
 * @param {object} options : this annotation's fullLayout options
 * @param {integer} index : index in 'annotations' container of the annotation to draw
 * @param {string} subplotId : id of the annotation's subplot
 *  - use false for 2d (i.e. cartesian or paper-ref) annotations
 * @param {object | undefined} xa : full x-axis object to compute subplot pos-to-px
 * @param {object | undefined} ya : ... y-axis
 */
function drawRaw(gd, options, index, subplotId, xa, ya) {
  var fullLayout = gd._fullLayout;
  var gs = gd._fullLayout._size;
  var edits = gd._context.edits;
  var className, containerStr;
  if (subplotId) {
    className = 'annotation-' + subplotId;
    containerStr = subplotId + '.annotations';
  } else {
    className = 'annotation';
    containerStr = 'annotations';
  }
  var editHelpers = arrayEditor(gd.layout, containerStr, options);
  var modifyBase = editHelpers.modifyBase;
  var modifyItem = editHelpers.modifyItem;
  var getUpdateObj = editHelpers.getUpdateObj;

  // remove the existing annotation if there is one
  fullLayout._infolayer.selectAll('.' + className + '[data-index="' + index + '"]').remove();
  var annClipID = 'clip' + fullLayout._uid + '_ann' + index;

  // this annotation is gone - quit now after deleting it
  // TODO: use d3 idioms instead of deleting and redrawing every time
  if (!options._input || options.visible === false) {
    d3.selectAll('#' + annClipID).remove();
    return;
  }

  // calculated pixel positions
  // x & y each will get text, head, and tail as appropriate
  var annPosPx = {
    x: {},
    y: {}
  };
  var textangle = +options.textangle || 0;

  // create the components
  // made a single group to contain all, so opacity can work right
  // with border/arrow together this could handle a whole bunch of
  // cleanup at this point, but works for now
  var annGroup = fullLayout._infolayer.append('g').classed(className, true).attr('data-index', String(index)).style('opacity', options.opacity);

  // another group for text+background so that they can rotate together
  var annTextGroup = annGroup.append('g').classed('annotation-text-g', true);
  var editTextPosition = edits[options.showarrow ? 'annotationTail' : 'annotationPosition'];
  var textEvents = options.captureevents || edits.annotationText || editTextPosition;
  function makeEventData(initialEvent) {
    var eventData = {
      index: index,
      annotation: options._input,
      fullAnnotation: options,
      event: initialEvent
    };
    if (subplotId) {
      eventData.subplotId = subplotId;
    }
    return eventData;
  }
  var annTextGroupInner = annTextGroup.append('g').style('pointer-events', textEvents ? 'all' : null).call(setCursor, 'pointer').on('click', function () {
    gd._dragging = false;
    gd.emit('plotly_clickannotation', makeEventData(d3.event));
  });
  if (options.hovertext) {
    annTextGroupInner.on('mouseover', function () {
      var hoverOptions = options.hoverlabel;
      var hoverFont = hoverOptions.font;
      var bBox = this.getBoundingClientRect();
      var bBoxRef = gd.getBoundingClientRect();
      Fx.loneHover({
        x0: bBox.left - bBoxRef.left,
        x1: bBox.right - bBoxRef.left,
        y: (bBox.top + bBox.bottom) / 2 - bBoxRef.top,
        text: options.hovertext,
        color: hoverOptions.bgcolor,
        borderColor: hoverOptions.bordercolor,
        fontFamily: hoverFont.family,
        fontSize: hoverFont.size,
        fontColor: hoverFont.color,
        fontWeight: hoverFont.weight,
        fontStyle: hoverFont.style,
        fontVariant: hoverFont.variant
      }, {
        container: fullLayout._hoverlayer.node(),
        outerContainer: fullLayout._paper.node(),
        gd: gd
      });
    }).on('mouseout', function () {
      Fx.loneUnhover(fullLayout._hoverlayer.node());
    });
  }
  var borderwidth = options.borderwidth;
  var borderpad = options.borderpad;
  var borderfull = borderwidth + borderpad;
  var annTextBG = annTextGroupInner.append('rect').attr('class', 'bg').style('stroke-width', borderwidth + 'px').call(Color.stroke, options.bordercolor).call(Color.fill, options.bgcolor);
  var isSizeConstrained = options.width || options.height;
  var annTextClip = fullLayout._topclips.selectAll('#' + annClipID).data(isSizeConstrained ? [0] : []);
  annTextClip.enter().append('clipPath').classed('annclip', true).attr('id', annClipID).append('rect');
  annTextClip.exit().remove();
  var font = options.font;
  var text = fullLayout._meta ? Lib.templateString(options.text, fullLayout._meta) : options.text;
  var annText = annTextGroupInner.append('text').classed('annotation-text', true).text(text);
  function textLayout(s) {
    s.call(Drawing.font, font).attr({
      'text-anchor': {
        left: 'start',
        right: 'end'
      }[options.align] || 'middle'
    });
    svgTextUtils.convertToTspans(s, gd, drawGraphicalElements);
    return s;
  }
  function drawGraphicalElements() {
    // if the text has *only* a link, make the whole box into a link
    var anchor3 = annText.selectAll('a');
    if (anchor3.size() === 1 && anchor3.text() === annText.text()) {
      var wholeLink = annTextGroupInner.insert('a', ':first-child').attr({
        'xlink:xlink:href': anchor3.attr('xlink:href'),
        'xlink:xlink:show': anchor3.attr('xlink:show')
      }).style({
        cursor: 'pointer'
      });
      wholeLink.node().appendChild(annTextBG.node());
    }
    var mathjaxGroup = annTextGroupInner.select('.annotation-text-math-group');
    var hasMathjax = !mathjaxGroup.empty();
    var anntextBB = Drawing.bBox((hasMathjax ? mathjaxGroup : annText).node());
    var textWidth = anntextBB.width;
    var textHeight = anntextBB.height;
    var annWidth = options.width || textWidth;
    var annHeight = options.height || textHeight;
    var outerWidth = Math.round(annWidth + 2 * borderfull);
    var outerHeight = Math.round(annHeight + 2 * borderfull);
    function shiftFraction(v, anchor) {
      if (anchor === 'auto') {
        if (v < 1 / 3) anchor = 'left';else if (v > 2 / 3) anchor = 'right';else anchor = 'center';
      }
      return {
        center: 0,
        middle: 0,
        left: 0.5,
        bottom: -0.5,
        right: -0.5,
        top: 0.5
      }[anchor];
    }
    var annotationIsOffscreen = false;
    var letters = ['x', 'y'];
    for (var i = 0; i < letters.length; i++) {
      var axLetter = letters[i];
      var axRef = options[axLetter + 'ref'] || axLetter;
      var tailRef = options['a' + axLetter + 'ref'];
      var ax = {
        x: xa,
        y: ya
      }[axLetter];
      var dimAngle = (textangle + (axLetter === 'x' ? 0 : -90)) * Math.PI / 180;
      // note that these two can be either positive or negative
      var annSizeFromWidth = outerWidth * Math.cos(dimAngle);
      var annSizeFromHeight = outerHeight * Math.sin(dimAngle);
      // but this one is the positive total size
      var annSize = Math.abs(annSizeFromWidth) + Math.abs(annSizeFromHeight);
      var anchor = options[axLetter + 'anchor'];
      var overallShift = options[axLetter + 'shift'] * (axLetter === 'x' ? 1 : -1);
      var posPx = annPosPx[axLetter];
      var basePx;
      var textPadShift;
      var alignPosition;
      var autoAlignFraction;
      var textShift;
      var axRefType = Axes.getRefType(axRef);

      /*
       * calculate the *primary* pixel position
       * which is the arrowhead if there is one,
       * otherwise the text anchor point
       */
      if (ax && axRefType !== 'domain') {
        // check if annotation is off screen, to bypass DOM manipulations
        var posFraction = ax.r2fraction(options[axLetter]);
        if (posFraction < 0 || posFraction > 1) {
          if (tailRef === axRef) {
            posFraction = ax.r2fraction(options['a' + axLetter]);
            if (posFraction < 0 || posFraction > 1) {
              annotationIsOffscreen = true;
            }
          } else {
            annotationIsOffscreen = true;
          }
        }
        basePx = ax._offset + ax.r2p(options[axLetter]);
        autoAlignFraction = 0.5;
      } else {
        var axRefTypeEqDomain = axRefType === 'domain';
        if (axLetter === 'x') {
          alignPosition = options[axLetter];
          basePx = axRefTypeEqDomain ? ax._offset + ax._length * alignPosition : basePx = gs.l + gs.w * alignPosition;
        } else {
          alignPosition = 1 - options[axLetter];
          basePx = axRefTypeEqDomain ? ax._offset + ax._length * alignPosition : basePx = gs.t + gs.h * alignPosition;
        }
        autoAlignFraction = options.showarrow ? 0.5 : alignPosition;
      }

      // now translate this into pixel positions of head, tail, and text
      // as well as paddings for autorange
      if (options.showarrow) {
        posPx.head = basePx;
        var arrowLength = options['a' + axLetter];

        // with an arrow, the text rotates around the anchor point
        textShift = annSizeFromWidth * shiftFraction(0.5, options.xanchor) - annSizeFromHeight * shiftFraction(0.5, options.yanchor);
        if (tailRef === axRef) {
          // In the case tailRefType is 'domain' or 'paper', the arrow's
          // position is set absolutely, which is consistent with how
          // it behaves when its position is set in data ('range')
          // coordinates.
          var tailRefType = Axes.getRefType(tailRef);
          if (tailRefType === 'domain') {
            if (axLetter === 'y') {
              arrowLength = 1 - arrowLength;
            }
            posPx.tail = ax._offset + ax._length * arrowLength;
          } else if (tailRefType === 'paper') {
            if (axLetter === 'y') {
              arrowLength = 1 - arrowLength;
              posPx.tail = gs.t + gs.h * arrowLength;
            } else {
              posPx.tail = gs.l + gs.w * arrowLength;
            }
          } else {
            // assumed tailRef is range or paper referenced
            posPx.tail = ax._offset + ax.r2p(arrowLength);
          }
          // tail is range- or domain-referenced: autorange pads the
          // text in px from the tail
          textPadShift = textShift;
        } else {
          posPx.tail = basePx + arrowLength;
          // tail is specified in px from head, so autorange also pads vs head
          textPadShift = textShift + arrowLength;
        }
        posPx.text = posPx.tail + textShift;

        // constrain pixel/paper referenced so the draggers are at least
        // partially visible
        var maxPx = fullLayout[axLetter === 'x' ? 'width' : 'height'];
        if (axRef === 'paper') {
          posPx.head = Lib.constrain(posPx.head, 1, maxPx - 1);
        }
        if (tailRef === 'pixel') {
          var shiftPlus = -Math.max(posPx.tail - 3, posPx.text);
          var shiftMinus = Math.min(posPx.tail + 3, posPx.text) - maxPx;
          if (shiftPlus > 0) {
            posPx.tail += shiftPlus;
            posPx.text += shiftPlus;
          } else if (shiftMinus > 0) {
            posPx.tail -= shiftMinus;
            posPx.text -= shiftMinus;
          }
        }
        posPx.tail += overallShift;
        posPx.head += overallShift;
      } else {
        // with no arrow, the text rotates and *then* we put the anchor
        // relative to the new bounding box
        textShift = annSize * shiftFraction(autoAlignFraction, anchor);
        textPadShift = textShift;
        posPx.text = basePx + textShift;
      }
      posPx.text += overallShift;
      textShift += overallShift;
      textPadShift += overallShift;

      // padplus/minus are used by autorange
      options['_' + axLetter + 'padplus'] = annSize / 2 + textPadShift;
      options['_' + axLetter + 'padminus'] = annSize / 2 - textPadShift;

      // size/shift are used during dragging
      options['_' + axLetter + 'size'] = annSize;
      options['_' + axLetter + 'shift'] = textShift;
    }
    if (annotationIsOffscreen) {
      annTextGroupInner.remove();
      return;
    }
    var xShift = 0;
    var yShift = 0;
    if (options.align !== 'left') {
      xShift = (annWidth - textWidth) * (options.align === 'center' ? 0.5 : 1);
    }
    if (options.valign !== 'top') {
      yShift = (annHeight - textHeight) * (options.valign === 'middle' ? 0.5 : 1);
    }
    if (hasMathjax) {
      mathjaxGroup.select('svg').attr({
        x: borderfull + xShift - 1,
        y: borderfull + yShift
      }).call(Drawing.setClipUrl, isSizeConstrained ? annClipID : null, gd);
    } else {
      var texty = borderfull + yShift - anntextBB.top;
      var textx = borderfull + xShift - anntextBB.left;
      annText.call(svgTextUtils.positionText, textx, texty).call(Drawing.setClipUrl, isSizeConstrained ? annClipID : null, gd);
    }
    annTextClip.select('rect').call(Drawing.setRect, borderfull, borderfull, annWidth, annHeight);
    annTextBG.call(Drawing.setRect, borderwidth / 2, borderwidth / 2, outerWidth - borderwidth, outerHeight - borderwidth);
    annTextGroupInner.call(Drawing.setTranslate, Math.round(annPosPx.x.text - outerWidth / 2), Math.round(annPosPx.y.text - outerHeight / 2));

    /*
     * rotate text and background
     * we already calculated the text center position *as rotated*
     * because we needed that for autoranging anyway, so now whether
     * we have an arrow or not, we rotate about the text center.
     */
    annTextGroup.attr({
      transform: 'rotate(' + textangle + ',' + annPosPx.x.text + ',' + annPosPx.y.text + ')'
    });

    /*
     * add the arrow
     * uses options[arrowwidth,arrowcolor,arrowhead] for styling
     * dx and dy are normally zero, but when you are dragging the textbox
     * while the head stays put, dx and dy are the pixel offsets
     */
    var drawArrow = function (dx, dy) {
      annGroup.selectAll('.annotation-arrow-g').remove();
      var headX = annPosPx.x.head;
      var headY = annPosPx.y.head;
      var tailX = annPosPx.x.tail + dx;
      var tailY = annPosPx.y.tail + dy;
      var textX = annPosPx.x.text + dx;
      var textY = annPosPx.y.text + dy;

      // find the edge of the text box, where we'll start the arrow:
      // create transform matrix to rotate the text box corners
      var transform = Lib.rotationXYMatrix(textangle, textX, textY);
      var applyTransform = Lib.apply2DTransform(transform);
      var applyTransform2 = Lib.apply2DTransform2(transform);

      // calculate and transform bounding box
      var width = +annTextBG.attr('width');
      var height = +annTextBG.attr('height');
      var xLeft = textX - 0.5 * width;
      var xRight = xLeft + width;
      var yTop = textY - 0.5 * height;
      var yBottom = yTop + height;
      var edges = [[xLeft, yTop, xLeft, yBottom], [xLeft, yBottom, xRight, yBottom], [xRight, yBottom, xRight, yTop], [xRight, yTop, xLeft, yTop]].map(applyTransform2);

      // Remove the line if it ends inside the box.  Use ray
      // casting for rotated boxes: see which edges intersect a
      // line from the arrowhead to far away and reduce with xor
      // to get the parity of the number of intersections.
      if (edges.reduce(function (a, x) {
        return a ^ !!Lib.segmentsIntersect(headX, headY, headX + 1e6, headY + 1e6, x[0], x[1], x[2], x[3]);
      }, false)) {
        // no line or arrow - so quit drawArrow now
        return;
      }
      edges.forEach(function (x) {
        var p = Lib.segmentsIntersect(tailX, tailY, headX, headY, x[0], x[1], x[2], x[3]);
        if (p) {
          tailX = p.x;
          tailY = p.y;
        }
      });
      var strokewidth = options.arrowwidth;
      var arrowColor = options.arrowcolor;
      var arrowSide = options.arrowside;
      var arrowGroup = annGroup.append('g').style({
        opacity: Color.opacity(arrowColor)
      }).classed('annotation-arrow-g', true);
      var arrow = arrowGroup.append('path').attr('d', 'M' + tailX + ',' + tailY + 'L' + headX + ',' + headY).style('stroke-width', strokewidth + 'px').call(Color.stroke, Color.rgb(arrowColor));
      drawArrowHead(arrow, arrowSide, options);

      // the arrow dragger is a small square right at the head, then a line to the tail,
      // all expanded by a stroke width of 6px plus the arrow line width
      if (edits.annotationPosition && arrow.node().parentNode && !subplotId) {
        var arrowDragHeadX = headX;
        var arrowDragHeadY = headY;
        if (options.standoff) {
          var arrowLength = Math.sqrt(Math.pow(headX - tailX, 2) + Math.pow(headY - tailY, 2));
          arrowDragHeadX += options.standoff * (tailX - headX) / arrowLength;
          arrowDragHeadY += options.standoff * (tailY - headY) / arrowLength;
        }
        var arrowDrag = arrowGroup.append('path').classed('annotation-arrow', true).classed('anndrag', true).classed('cursor-move', true).attr({
          d: 'M3,3H-3V-3H3ZM0,0L' + (tailX - arrowDragHeadX) + ',' + (tailY - arrowDragHeadY),
          transform: strTranslate(arrowDragHeadX, arrowDragHeadY)
        }).style('stroke-width', strokewidth + 6 + 'px').call(Color.stroke, 'rgba(0,0,0,0)').call(Color.fill, 'rgba(0,0,0,0)');
        var annx0, anny0;

        // dragger for the arrow & head: translates the whole thing
        // (head/tail/text) all together
        dragElement.init({
          element: arrowDrag.node(),
          gd: gd,
          prepFn: function () {
            var pos = Drawing.getTranslate(annTextGroupInner);
            annx0 = pos.x;
            anny0 = pos.y;
            if (xa && xa.autorange) {
              modifyBase(xa._name + '.autorange', true);
            }
            if (ya && ya.autorange) {
              modifyBase(ya._name + '.autorange', true);
            }
          },
          moveFn: function (dx, dy) {
            var annxy0 = applyTransform(annx0, anny0);
            var xcenter = annxy0[0] + dx;
            var ycenter = annxy0[1] + dy;
            annTextGroupInner.call(Drawing.setTranslate, xcenter, ycenter);
            modifyItem('x', shiftPosition(xa, dx, 'x', gs, options));
            modifyItem('y', shiftPosition(ya, dy, 'y', gs, options));

            // for these 2 calls to shiftPosition, it is assumed xa, ya are
            // defined, so gsDim will not be used, but we put it in
            // anyways for consistency
            if (options.axref === options.xref) {
              modifyItem('ax', shiftPosition(xa, dx, 'ax', gs, options));
            }
            if (options.ayref === options.yref) {
              modifyItem('ay', shiftPosition(ya, dy, 'ay', gs, options));
            }
            arrowGroup.attr('transform', strTranslate(dx, dy));
            annTextGroup.attr({
              transform: 'rotate(' + textangle + ',' + xcenter + ',' + ycenter + ')'
            });
          },
          doneFn: function () {
            Registry.call('_guiRelayout', gd, getUpdateObj());
            var notesBox = document.querySelector('.js-notes-box-panel');
            if (notesBox) notesBox.redraw(notesBox.selectedObj);
          }
        });
      }
    };
    if (options.showarrow) drawArrow(0, 0);

    // user dragging the annotation (text, not arrow)
    if (editTextPosition) {
      var baseTextTransform;

      // dragger for the textbox: if there's an arrow, just drag the
      // textbox and tail, leave the head untouched
      dragElement.init({
        element: annTextGroupInner.node(),
        gd: gd,
        prepFn: function () {
          baseTextTransform = annTextGroup.attr('transform');
        },
        moveFn: function (dx, dy) {
          var csr = 'pointer';
          if (options.showarrow) {
            // for these 2 calls to shiftPosition, it is assumed xa, ya are
            // defined, so gsDim will not be used, but we put it in
            // anyways for consistency
            if (options.axref === options.xref) {
              modifyItem('ax', shiftPosition(xa, dx, 'ax', gs, options));
            } else {
              modifyItem('ax', options.ax + dx);
            }
            if (options.ayref === options.yref) {
              modifyItem('ay', shiftPosition(ya, dy, 'ay', gs.w, options));
            } else {
              modifyItem('ay', options.ay + dy);
            }
            drawArrow(dx, dy);
          } else if (!subplotId) {
            var xUpdate, yUpdate;
            if (xa) {
              // shiftPosition will not execute code where xa was
              // undefined, so we use to calculate xUpdate too
              xUpdate = shiftPosition(xa, dx, 'x', gs, options);
            } else {
              var widthFraction = options._xsize / gs.w;
              var xLeft = options.x + (options._xshift - options.xshift) / gs.w - widthFraction / 2;
              xUpdate = dragElement.align(xLeft + dx / gs.w, widthFraction, 0, 1, options.xanchor);
            }
            if (ya) {
              // shiftPosition will not execute code where ya was
              // undefined, so we use to calculate yUpdate too
              yUpdate = shiftPosition(ya, dy, 'y', gs, options);
            } else {
              var heightFraction = options._ysize / gs.h;
              var yBottom = options.y - (options._yshift + options.yshift) / gs.h - heightFraction / 2;
              yUpdate = dragElement.align(yBottom - dy / gs.h, heightFraction, 0, 1, options.yanchor);
            }
            modifyItem('x', xUpdate);
            modifyItem('y', yUpdate);
            if (!xa || !ya) {
              csr = dragElement.getCursor(xa ? 0.5 : xUpdate, ya ? 0.5 : yUpdate, options.xanchor, options.yanchor);
            }
          } else return;
          annTextGroup.attr({
            transform: strTranslate(dx, dy) + baseTextTransform
          });
          setCursor(annTextGroupInner, csr);
        },
        clickFn: function (_, initialEvent) {
          if (options.captureevents) {
            gd.emit('plotly_clickannotation', makeEventData(initialEvent));
          }
        },
        doneFn: function () {
          setCursor(annTextGroupInner);
          Registry.call('_guiRelayout', gd, getUpdateObj());
          var notesBox = document.querySelector('.js-notes-box-panel');
          if (notesBox) notesBox.redraw(notesBox.selectedObj);
        }
      });
    }
  }
  if (edits.annotationText) {
    annText.call(svgTextUtils.makeEditable, {
      delegate: annTextGroupInner,
      gd: gd
    }).call(textLayout).on('edit', function (_text) {
      options.text = _text;
      this.call(textLayout);
      modifyItem('text', _text);
      if (xa && xa.autorange) {
        modifyBase(xa._name + '.autorange', true);
      }
      if (ya && ya.autorange) {
        modifyBase(ya._name + '.autorange', true);
      }
      Registry.call('_guiRelayout', gd, getUpdateObj());
    });
  } else annText.call(textLayout);
}

/***/ }),

/***/ 3652:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var Color = __webpack_require__(6308);
var ARROWPATHS = __webpack_require__(2196);
var Lib = __webpack_require__(3400);
var strScale = Lib.strScale;
var strRotate = Lib.strRotate;
var strTranslate = Lib.strTranslate;

/**
 * Add arrowhead(s) to a path or line element
 *
 * @param {d3.selection} el3: a d3-selected line or path element
 *
 * @param {string} ends: 'none', 'start', 'end', or 'start+end' for which ends get arrowheads
 *
 * @param {object} options: style information. Must have all the following:
 * @param {number} options.arrowhead: end head style - see ./arrow_paths
 * @param {number} options.startarrowhead: start head style - see ./arrow_paths
 * @param {number} options.arrowsize: relative size of the end head vs line width
 * @param {number} options.startarrowsize: relative size of the start head vs line width
 * @param {number} options.standoff: distance in px to move the end arrow point from its target
 * @param {number} options.startstandoff: distance in px to move the start arrow point from its target
 * @param {number} options.arrowwidth: width of the arrow line
 * @param {string} options.arrowcolor: color of the arrow line, for the head to match
 *     Note that the opacity of this color is ignored, as it's assumed the container
 *     of both the line and head has opacity applied to it so there isn't greater opacity
 *     where they overlap.
 */
module.exports = function drawArrowHead(el3, ends, options) {
  var el = el3.node();
  var headStyle = ARROWPATHS[options.arrowhead || 0];
  var startHeadStyle = ARROWPATHS[options.startarrowhead || 0];
  var scale = (options.arrowwidth || 1) * (options.arrowsize || 1);
  var startScale = (options.arrowwidth || 1) * (options.startarrowsize || 1);
  var doStart = ends.indexOf('start') >= 0;
  var doEnd = ends.indexOf('end') >= 0;
  var backOff = headStyle.backoff * scale + options.standoff;
  var startBackOff = startHeadStyle.backoff * startScale + options.startstandoff;
  var start, end, startRot, endRot;
  if (el.nodeName === 'line') {
    start = {
      x: +el3.attr('x1'),
      y: +el3.attr('y1')
    };
    end = {
      x: +el3.attr('x2'),
      y: +el3.attr('y2')
    };
    var dx = start.x - end.x;
    var dy = start.y - end.y;
    startRot = Math.atan2(dy, dx);
    endRot = startRot + Math.PI;
    if (backOff && startBackOff) {
      if (backOff + startBackOff > Math.sqrt(dx * dx + dy * dy)) {
        hideLine();
        return;
      }
    }
    if (backOff) {
      if (backOff * backOff > dx * dx + dy * dy) {
        hideLine();
        return;
      }
      var backOffX = backOff * Math.cos(startRot);
      var backOffY = backOff * Math.sin(startRot);
      end.x += backOffX;
      end.y += backOffY;
      el3.attr({
        x2: end.x,
        y2: end.y
      });
    }
    if (startBackOff) {
      if (startBackOff * startBackOff > dx * dx + dy * dy) {
        hideLine();
        return;
      }
      var startBackOffX = startBackOff * Math.cos(startRot);
      var startbackOffY = startBackOff * Math.sin(startRot);
      start.x -= startBackOffX;
      start.y -= startbackOffY;
      el3.attr({
        x1: start.x,
        y1: start.y
      });
    }
  } else if (el.nodeName === 'path') {
    var pathlen = el.getTotalLength();
    // using dash to hide the backOff region of the path.
    // if we ever allow dash for the arrow we'll have to
    // do better than this hack... maybe just manually
    // combine the two
    var dashArray = '';
    if (pathlen < backOff + startBackOff) {
      hideLine();
      return;
    }
    var start0 = el.getPointAtLength(0);
    var dstart = el.getPointAtLength(0.1);
    startRot = Math.atan2(start0.y - dstart.y, start0.x - dstart.x);
    start = el.getPointAtLength(Math.min(startBackOff, pathlen));
    dashArray = '0px,' + startBackOff + 'px,';
    var end0 = el.getPointAtLength(pathlen);
    var dend = el.getPointAtLength(pathlen - 0.1);
    endRot = Math.atan2(end0.y - dend.y, end0.x - dend.x);
    end = el.getPointAtLength(Math.max(0, pathlen - backOff));
    var shortening = dashArray ? startBackOff + backOff : backOff;
    dashArray += pathlen - shortening + 'px,' + pathlen + 'px';
    el3.style('stroke-dasharray', dashArray);
  }
  function hideLine() {
    el3.style('stroke-dasharray', '0px,100px');
  }
  function drawhead(arrowHeadStyle, p, rot, arrowScale) {
    if (!arrowHeadStyle.path) return;
    if (arrowHeadStyle.noRotate) rot = 0;
    d3.select(el.parentNode).append('path').attr({
      class: el3.attr('class'),
      d: arrowHeadStyle.path,
      transform: strTranslate(p.x, p.y) + strRotate(rot * 180 / Math.PI) + strScale(arrowScale)
    }).style({
      fill: Color.rgb(options.arrowcolor),
      'stroke-width': 0
    });
  }
  if (doStart) drawhead(startHeadStyle, start, startRot, startScale);
  if (doEnd) drawhead(headStyle, end, endRot, scale);
};

/***/ }),

/***/ 9180:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var drawModule = __webpack_require__(6196);
var clickModule = __webpack_require__(2300);
module.exports = {
  moduleType: 'component',
  name: 'annotations',
  layoutAttributes: __webpack_require__(3916),
  supplyLayoutDefaults: __webpack_require__(5216),
  includeBasePlot: __webpack_require__(6632)('annotations'),
  calcAutorange: __webpack_require__(272),
  draw: drawModule.draw,
  drawOne: drawModule.drawOne,
  drawRaw: drawModule.drawRaw,
  hasClickToShow: clickModule.hasClickToShow,
  onClick: clickModule.onClick,
  convertCoords: __webpack_require__(9208)
};

/***/ }),

/***/ 5899:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var annAttrs = __webpack_require__(3916);
var overrideAll = (__webpack_require__(7824).overrideAll);
var templatedArray = (__webpack_require__(1780).templatedArray);
module.exports = overrideAll(templatedArray('annotation', {
  visible: annAttrs.visible,
  x: {
    valType: 'any'
  },
  y: {
    valType: 'any'
  },
  z: {
    valType: 'any'
  },
  ax: {
    valType: 'number'
  },
  ay: {
    valType: 'number'
  },
  xanchor: annAttrs.xanchor,
  xshift: annAttrs.xshift,
  yanchor: annAttrs.yanchor,
  yshift: annAttrs.yshift,
  text: annAttrs.text,
  textangle: annAttrs.textangle,
  font: annAttrs.font,
  width: annAttrs.width,
  height: annAttrs.height,
  opacity: annAttrs.opacity,
  align: annAttrs.align,
  valign: annAttrs.valign,
  bgcolor: annAttrs.bgcolor,
  bordercolor: annAttrs.bordercolor,
  borderpad: annAttrs.borderpad,
  borderwidth: annAttrs.borderwidth,
  showarrow: annAttrs.showarrow,
  arrowcolor: annAttrs.arrowcolor,
  arrowhead: annAttrs.arrowhead,
  startarrowhead: annAttrs.startarrowhead,
  arrowside: annAttrs.arrowside,
  arrowsize: annAttrs.arrowsize,
  startarrowsize: annAttrs.startarrowsize,
  arrowwidth: annAttrs.arrowwidth,
  standoff: annAttrs.standoff,
  startstandoff: annAttrs.startstandoff,
  hovertext: annAttrs.hovertext,
  hoverlabel: annAttrs.hoverlabel,
  captureevents: annAttrs.captureevents

  // maybes later?
  // clicktoshow: annAttrs.clicktoshow,
  // xclick: annAttrs.xclick,
  // yclick: annAttrs.yclick,

  // not needed!
  // axref: 'pixel'
  // ayref: 'pixel'
  // xref: 'x'
  // yref: 'y
  // zref: 'z'
}), 'calc', 'from-root');

/***/ }),

/***/ 76:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Axes = __webpack_require__(4460);
module.exports = function convert(scene) {
  var fullSceneLayout = scene.fullSceneLayout;
  var anns = fullSceneLayout.annotations;
  for (var i = 0; i < anns.length; i++) {
    mockAnnAxes(anns[i], scene);
  }
  scene.fullLayout._infolayer.selectAll('.annotation-' + scene.id).remove();
};
function mockAnnAxes(ann, scene) {
  var fullSceneLayout = scene.fullSceneLayout;
  var domain = fullSceneLayout.domain;
  var size = scene.fullLayout._size;
  var base = {
    // this gets fill in on render
    pdata: null,
    // to get setConvert to not execute cleanly
    type: 'linear',
    // don't try to update them on `editable: true`
    autorange: false,
    // set infinite range so that annotation draw routine
    // does not try to remove 'outside-range' annotations,
    // this case is handled in the render loop
    range: [-Infinity, Infinity]
  };
  ann._xa = {};
  Lib.extendFlat(ann._xa, base);
  Axes.setConvert(ann._xa);
  ann._xa._offset = size.l + domain.x[0] * size.w;
  ann._xa.l2p = function () {
    return 0.5 * (1 + ann._pdata[0] / ann._pdata[3]) * size.w * (domain.x[1] - domain.x[0]);
  };
  ann._ya = {};
  Lib.extendFlat(ann._ya, base);
  Axes.setConvert(ann._ya);
  ann._ya._offset = size.t + (1 - domain.y[1]) * size.h;
  ann._ya.l2p = function () {
    return 0.5 * (1 - ann._pdata[1] / ann._pdata[3]) * size.h * (domain.y[1] - domain.y[0]);
  };
}

/***/ }),

/***/ 2808:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Axes = __webpack_require__(4460);
var handleArrayContainerDefaults = __webpack_require__(1272);
var handleAnnotationCommonDefaults = __webpack_require__(7192);
var attributes = __webpack_require__(5899);
module.exports = function handleDefaults(sceneLayoutIn, sceneLayoutOut, opts) {
  handleArrayContainerDefaults(sceneLayoutIn, sceneLayoutOut, {
    name: 'annotations',
    handleItemDefaults: handleAnnotationDefaults,
    fullLayout: opts.fullLayout
  });
};
function handleAnnotationDefaults(annIn, annOut, sceneLayout, opts) {
  function coerce(attr, dflt) {
    return Lib.coerce(annIn, annOut, attributes, attr, dflt);
  }
  function coercePosition(axLetter) {
    var axName = axLetter + 'axis';

    // mock in such way that getFromId grabs correct 3D axis
    var gdMock = {
      _fullLayout: {}
    };
    gdMock._fullLayout[axName] = sceneLayout[axName];
    return Axes.coercePosition(annOut, gdMock, coerce, axLetter, axLetter, 0.5);
  }
  var visible = coerce('visible');
  if (!visible) return;
  handleAnnotationCommonDefaults(annIn, annOut, opts.fullLayout, coerce);
  coercePosition('x');
  coercePosition('y');
  coercePosition('z');

  // if you have one coordinate you should all three
  Lib.noneOrAll(annIn, annOut, ['x', 'y', 'z']);

  // hard-set here for completeness
  annOut.xref = 'x';
  annOut.yref = 'y';
  annOut.zref = 'z';
  coerce('xanchor');
  coerce('yanchor');
  coerce('xshift');
  coerce('yshift');
  if (annOut.showarrow) {
    annOut.axref = 'pixel';
    annOut.ayref = 'pixel';

    // TODO maybe default values should be bigger than the 2D case?
    coerce('ax', -10);
    coerce('ay', -30);

    // if you have one part of arrow length you should have both
    Lib.noneOrAll(annIn, annOut, ['ax', 'ay']);
  }
}

/***/ }),

/***/ 1836:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var drawRaw = (__webpack_require__(6196).drawRaw);
var project = __webpack_require__(4424);
var axLetters = ['x', 'y', 'z'];
module.exports = function draw(scene) {
  var fullSceneLayout = scene.fullSceneLayout;
  var dataScale = scene.dataScale;
  var anns = fullSceneLayout.annotations;
  for (var i = 0; i < anns.length; i++) {
    var ann = anns[i];
    var annotationIsOffscreen = false;
    for (var j = 0; j < 3; j++) {
      var axLetter = axLetters[j];
      var pos = ann[axLetter];
      var ax = fullSceneLayout[axLetter + 'axis'];
      var posFraction = ax.r2fraction(pos);
      if (posFraction < 0 || posFraction > 1) {
        annotationIsOffscreen = true;
        break;
      }
    }
    if (annotationIsOffscreen) {
      scene.fullLayout._infolayer.select('.annotation-' + scene.id + '[data-index="' + i + '"]').remove();
    } else {
      ann._pdata = project(scene.glplot.cameraParams, [fullSceneLayout.xaxis.r2l(ann.x) * dataScale[0], fullSceneLayout.yaxis.r2l(ann.y) * dataScale[1], fullSceneLayout.zaxis.r2l(ann.z) * dataScale[2]]);
      drawRaw(scene.graphDiv, ann, i, scene.id, ann._xa, ann._ya);
    }
  }
};

/***/ }),

/***/ 6864:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Registry = __webpack_require__(4040);
var Lib = __webpack_require__(3400);
module.exports = {
  moduleType: 'component',
  name: 'annotations3d',
  schema: {
    subplots: {
      scene: {
        annotations: __webpack_require__(5899)
      }
    }
  },
  layoutAttributes: __webpack_require__(5899),
  handleDefaults: __webpack_require__(2808),
  includeBasePlot: includeGL3D,
  convert: __webpack_require__(76),
  draw: __webpack_require__(1836)
};
function includeGL3D(layoutIn, layoutOut) {
  var GL3D = Registry.subplotsRegistry.gl3d;
  if (!GL3D) return;
  var attrRegex = GL3D.attrRegex;
  var keys = Object.keys(layoutIn);
  for (var i = 0; i < keys.length; i++) {
    var k = keys[i];
    if (attrRegex.test(k) && (layoutIn[k].annotations || []).length) {
      Lib.pushUnique(layoutOut._basePlotModules, GL3D);
      Lib.pushUnique(layoutOut._subplots.gl3d, k);
    }
  }
}

/***/ }),

/***/ 4976:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


// a trimmed down version of:
// https://github.com/alexcjohnson/world-calendars/blob/master/dist/index.js
module.exports = __webpack_require__(8700);
__webpack_require__(5168);
__webpack_require__(7020);
__webpack_require__(7411);
__webpack_require__(5668);
__webpack_require__(2787);
__webpack_require__(2084);
__webpack_require__(6368);
__webpack_require__(4747);
__webpack_require__(5616);
__webpack_require__(632);
__webpack_require__(3040);
__webpack_require__(1104);
__webpack_require__(9075);
__webpack_require__(4592);
__webpack_require__(5348);

/***/ }),

/***/ 7776:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var calendars = __webpack_require__(4976);
var Lib = __webpack_require__(3400);
var constants = __webpack_require__(9032);
var EPOCHJD = constants.EPOCHJD;
var ONEDAY = constants.ONEDAY;
var attributes = {
  valType: 'enumerated',
  values: Lib.sortObjectKeys(calendars.calendars),
  editType: 'calc',
  dflt: 'gregorian'
};
var handleDefaults = function (contIn, contOut, attr, dflt) {
  var attrs = {};
  attrs[attr] = attributes;
  return Lib.coerce(contIn, contOut, attrs, attr, dflt);
};
var handleTraceDefaults = function (traceIn, traceOut, coords, layout) {
  for (var i = 0; i < coords.length; i++) {
    handleDefaults(traceIn, traceOut, coords[i] + 'calendar', layout.calendar);
  }
};

// each calendar needs its own default canonical tick. I would love to use
// 2000-01-01 (or even 0000-01-01) for them all but they don't necessarily
// all support either of those dates. Instead I'll use the most significant
// number they *do* support, biased toward the present day.
var CANONICAL_TICK = {
  chinese: '2000-01-01',
  coptic: '2000-01-01',
  discworld: '2000-01-01',
  ethiopian: '2000-01-01',
  hebrew: '5000-01-01',
  islamic: '1000-01-01',
  julian: '2000-01-01',
  mayan: '5000-01-01',
  nanakshahi: '1000-01-01',
  nepali: '2000-01-01',
  persian: '1000-01-01',
  jalali: '1000-01-01',
  taiwan: '1000-01-01',
  thai: '2000-01-01',
  ummalqura: '1400-01-01'
};

// Start on a Sunday - for week ticks
// Discworld and Mayan calendars don't have 7-day weeks but we're going to give them
// 7-day week ticks so start on our Sundays.
// If anyone really cares we can customize the auto tick spacings for these calendars.
var CANONICAL_SUNDAY = {
  chinese: '2000-01-02',
  coptic: '2000-01-03',
  discworld: '2000-01-03',
  ethiopian: '2000-01-05',
  hebrew: '5000-01-01',
  islamic: '1000-01-02',
  julian: '2000-01-03',
  mayan: '5000-01-01',
  nanakshahi: '1000-01-05',
  nepali: '2000-01-05',
  persian: '1000-01-01',
  jalali: '1000-01-01',
  taiwan: '1000-01-04',
  thai: '2000-01-04',
  ummalqura: '1400-01-06'
};
var DFLTRANGE = {
  chinese: ['2000-01-01', '2001-01-01'],
  coptic: ['1700-01-01', '1701-01-01'],
  discworld: ['1800-01-01', '1801-01-01'],
  ethiopian: ['2000-01-01', '2001-01-01'],
  hebrew: ['5700-01-01', '5701-01-01'],
  islamic: ['1400-01-01', '1401-01-01'],
  julian: ['2000-01-01', '2001-01-01'],
  mayan: ['5200-01-01', '5201-01-01'],
  nanakshahi: ['0500-01-01', '0501-01-01'],
  nepali: ['2000-01-01', '2001-01-01'],
  persian: ['1400-01-01', '1401-01-01'],
  jalali: ['1400-01-01', '1401-01-01'],
  taiwan: ['0100-01-01', '0101-01-01'],
  thai: ['2500-01-01', '2501-01-01'],
  ummalqura: ['1400-01-01', '1401-01-01']
};

/*
 * convert d3 templates to world-calendars templates, so our users only need
 * to know d3's specifiers. Map space padding to no padding, and unknown fields
 * to an ugly placeholder
 */
var UNKNOWN = '##';
var d3ToWorldCalendars = {
  d: {
    0: 'dd',
    '-': 'd'
  },
  // 2-digit or unpadded day of month
  e: {
    0: 'd',
    '-': 'd'
  },
  // alternate, always unpadded day of month
  a: {
    0: 'D',
    '-': 'D'
  },
  // short weekday name
  A: {
    0: 'DD',
    '-': 'DD'
  },
  // full weekday name
  j: {
    0: 'oo',
    '-': 'o'
  },
  // 3-digit or unpadded day of the year
  W: {
    0: 'ww',
    '-': 'w'
  },
  // 2-digit or unpadded week of the year (Monday first)
  m: {
    0: 'mm',
    '-': 'm'
  },
  // 2-digit or unpadded month number
  b: {
    0: 'M',
    '-': 'M'
  },
  // short month name
  B: {
    0: 'MM',
    '-': 'MM'
  },
  // full month name
  y: {
    0: 'yy',
    '-': 'yy'
  },
  // 2-digit year (map unpadded to zero-padded)
  Y: {
    0: 'yyyy',
    '-': 'yyyy'
  },
  // 4-digit year (map unpadded to zero-padded)
  U: UNKNOWN,
  // Sunday-first week of the year
  w: UNKNOWN,
  // day of the week [0(sunday),6]
  // combined format, we replace the date part with the world-calendar version
  // and the %X stays there for d3 to handle with time parts
  c: {
    0: 'D M d %X yyyy',
    '-': 'D M d %X yyyy'
  },
  x: {
    0: 'mm/dd/yyyy',
    '-': 'mm/dd/yyyy'
  }
};
function worldCalFmt(fmt, x, calendar) {
  var dateJD = Math.floor((x + 0.05) / ONEDAY) + EPOCHJD;
  var cDate = getCal(calendar).fromJD(dateJD);
  var i = 0;
  var modifier, directive, directiveLen, directiveObj, replacementPart;
  while ((i = fmt.indexOf('%', i)) !== -1) {
    modifier = fmt.charAt(i + 1);
    if (modifier === '0' || modifier === '-' || modifier === '_') {
      directiveLen = 3;
      directive = fmt.charAt(i + 2);
      if (modifier === '_') modifier = '-';
    } else {
      directive = modifier;
      modifier = '0';
      directiveLen = 2;
    }
    directiveObj = d3ToWorldCalendars[directive];
    if (!directiveObj) {
      i += directiveLen;
    } else {
      // code is recognized as a date part but world-calendars doesn't support it
      if (directiveObj === UNKNOWN) replacementPart = UNKNOWN;

      // format the cDate according to the translated directive
      else replacementPart = cDate.formatDate(directiveObj[modifier]);
      fmt = fmt.substr(0, i) + replacementPart + fmt.substr(i + directiveLen);
      i += replacementPart.length;
    }
  }
  return fmt;
}

// cache world calendars, so we don't have to reinstantiate
// during each date-time conversion
var allCals = {};
function getCal(calendar) {
  var calendarObj = allCals[calendar];
  if (calendarObj) return calendarObj;
  calendarObj = allCals[calendar] = calendars.instance(calendar);
  return calendarObj;
}
function makeAttrs(description) {
  return Lib.extendFlat({}, attributes, {
    description: description
  });
}
function makeTraceAttrsDescription(coord) {
  return 'Sets the calendar system to use with `' + coord + '` date data.';
}
var xAttrs = {
  xcalendar: makeAttrs(makeTraceAttrsDescription('x'))
};
var xyAttrs = Lib.extendFlat({}, xAttrs, {
  ycalendar: makeAttrs(makeTraceAttrsDescription('y'))
});
var xyzAttrs = Lib.extendFlat({}, xyAttrs, {
  zcalendar: makeAttrs(makeTraceAttrsDescription('z'))
});
var axisAttrs = makeAttrs(['Sets the calendar system to use for `range` and `tick0`', 'if this is a date axis. This does not set the calendar for', 'interpreting data on this axis, that\'s specified in the trace', 'or via the global `layout.calendar`'].join(' '));
module.exports = {
  moduleType: 'component',
  name: 'calendars',
  schema: {
    traces: {
      scatter: xyAttrs,
      bar: xyAttrs,
      box: xyAttrs,
      heatmap: xyAttrs,
      contour: xyAttrs,
      histogram: xyAttrs,
      histogram2d: xyAttrs,
      histogram2dcontour: xyAttrs,
      scatter3d: xyzAttrs,
      surface: xyzAttrs,
      mesh3d: xyzAttrs,
      scattergl: xyAttrs,
      ohlc: xAttrs,
      candlestick: xAttrs
    },
    layout: {
      calendar: makeAttrs(['Sets the default calendar system to use for interpreting and', 'displaying dates throughout the plot.'].join(' '))
    },
    subplots: {
      xaxis: {
        calendar: axisAttrs
      },
      yaxis: {
        calendar: axisAttrs
      },
      scene: {
        xaxis: {
          calendar: axisAttrs
        },
        // TODO: it's actually redundant to include yaxis and zaxis here
        // because in the scene attributes these are the same object so merging
        // into one merges into them all. However, I left them in for parity with
        // cartesian, where yaxis is unused until we Plotschema.get() when we
        // use its presence or absence to determine whether to delete attributes
        // from yaxis if they only apply to x (rangeselector/rangeslider)
        yaxis: {
          calendar: axisAttrs
        },
        zaxis: {
          calendar: axisAttrs
        }
      },
      polar: {
        radialaxis: {
          calendar: axisAttrs
        }
      }
    },
    transforms: {
      filter: {
        valuecalendar: makeAttrs(['WARNING: All transforms are deprecated and may be removed from the API in next major version.', 'Sets the calendar system to use for `value`, if it is a date.'].join(' ')),
        targetcalendar: makeAttrs(['WARNING: All transforms are deprecated and may be removed from the API in next major version.', 'Sets the calendar system to use for `target`, if it is an', 'array of dates. If `target` is a string (eg *x*) we use the', 'corresponding trace attribute (eg `xcalendar`) if it exists,', 'even if `targetcalendar` is provided.'].join(' '))
      }
    }
  },
  layoutAttributes: attributes,
  handleDefaults: handleDefaults,
  handleTraceDefaults: handleTraceDefaults,
  CANONICAL_SUNDAY: CANONICAL_SUNDAY,
  CANONICAL_TICK: CANONICAL_TICK,
  DFLTRANGE: DFLTRANGE,
  getCal: getCal,
  worldCalFmt: worldCalFmt
};

/***/ }),

/***/ 2548:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


// IMPORTANT - default colors should be in hex for compatibility
exports.defaults = ['#1f77b4',
// muted blue
'#ff7f0e',
// safety orange
'#2ca02c',
// cooked asparagus green
'#d62728',
// brick red
'#9467bd',
// muted purple
'#8c564b',
// chestnut brown
'#e377c2',
// raspberry yogurt pink
'#7f7f7f',
// middle gray
'#bcbd22',
// curry yellow-green
'#17becf' // blue-teal
];

exports.defaultLine = '#444';
exports.lightLine = '#eee';
exports.background = '#fff';
exports.borderLine = '#BEC8D9';

// with axis.color and Color.interp we aren't using lightLine
// itself anymore, instead interpolating between axis.color
// and the background color using tinycolor.mix. lightFraction
// gives back exactly lightLine if the other colors are defaults.
exports.lightFraction = 100 * (0xe - 0x4) / (0xf - 0x4);

/***/ }),

/***/ 6308:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var tinycolor = __webpack_require__(9760);
var isNumeric = __webpack_require__(8248);
var isTypedArray = (__webpack_require__(8116).isTypedArray);
var color = module.exports = {};
var colorAttrs = __webpack_require__(2548);
color.defaults = colorAttrs.defaults;
var defaultLine = color.defaultLine = colorAttrs.defaultLine;
color.lightLine = colorAttrs.lightLine;
var background = color.background = colorAttrs.background;

/*
 * tinyRGB: turn a tinycolor into an rgb string, but
 * unlike the built-in tinycolor.toRgbString this never includes alpha
 */
color.tinyRGB = function (tc) {
  var c = tc.toRgb();
  return 'rgb(' + Math.round(c.r) + ', ' + Math.round(c.g) + ', ' + Math.round(c.b) + ')';
};
color.rgb = function (cstr) {
  return color.tinyRGB(tinycolor(cstr));
};
color.opacity = function (cstr) {
  return cstr ? tinycolor(cstr).getAlpha() : 0;
};
color.addOpacity = function (cstr, op) {
  var c = tinycolor(cstr).toRgb();
  return 'rgba(' + Math.round(c.r) + ', ' + Math.round(c.g) + ', ' + Math.round(c.b) + ', ' + op + ')';
};

// combine two colors into one apparent color
// if back has transparency or is missing,
// color.background is assumed behind it
color.combine = function (front, back) {
  var fc = tinycolor(front).toRgb();
  if (fc.a === 1) return tinycolor(front).toRgbString();
  var bc = tinycolor(back || background).toRgb();
  var bcflat = bc.a === 1 ? bc : {
    r: 255 * (1 - bc.a) + bc.r * bc.a,
    g: 255 * (1 - bc.a) + bc.g * bc.a,
    b: 255 * (1 - bc.a) + bc.b * bc.a
  };
  var fcflat = {
    r: bcflat.r * (1 - fc.a) + fc.r * fc.a,
    g: bcflat.g * (1 - fc.a) + fc.g * fc.a,
    b: bcflat.b * (1 - fc.a) + fc.b * fc.a
  };
  return tinycolor(fcflat).toRgbString();
};

/*
 * Linearly interpolate between two colors at a normalized interpolation position (0 to 1).
 *
 * Ignores alpha channel values.
 * The resulting color is computed as: factor * first + (1 - factor) * second.
 */
color.interpolate = function (first, second, factor) {
  var fc = tinycolor(first).toRgb();
  var sc = tinycolor(second).toRgb();
  var ic = {
    r: factor * fc.r + (1 - factor) * sc.r,
    g: factor * fc.g + (1 - factor) * sc.g,
    b: factor * fc.b + (1 - factor) * sc.b
  };
  return tinycolor(ic).toRgbString();
};

/*
 * Create a color that contrasts with cstr.
 *
 * If cstr is a dark color, we lighten it; if it's light, we darken.
 *
 * If lightAmount / darkAmount are used, we adjust by these percentages,
 * otherwise we go all the way to white or black.
 */
color.contrast = function (cstr, lightAmount, darkAmount) {
  var tc = tinycolor(cstr);
  if (tc.getAlpha() !== 1) tc = tinycolor(color.combine(cstr, background));
  var newColor = tc.isDark() ? lightAmount ? tc.lighten(lightAmount) : background : darkAmount ? tc.darken(darkAmount) : defaultLine;
  return newColor.toString();
};
color.stroke = function (s, c) {
  var tc = tinycolor(c);
  s.style({
    stroke: color.tinyRGB(tc),
    'stroke-opacity': tc.getAlpha()
  });
};
color.fill = function (s, c) {
  var tc = tinycolor(c);
  s.style({
    fill: color.tinyRGB(tc),
    'fill-opacity': tc.getAlpha()
  });
};

// search container for colors with the deprecated rgb(fractions) format
// and convert them to rgb(0-255 values)
color.clean = function (container) {
  if (!container || typeof container !== 'object') return;
  var keys = Object.keys(container);
  var i, j, key, val;
  for (i = 0; i < keys.length; i++) {
    key = keys[i];
    val = container[key];
    if (key.substr(key.length - 5) === 'color') {
      // only sanitize keys that end in "color" or "colorscale"

      if (Array.isArray(val)) {
        for (j = 0; j < val.length; j++) val[j] = cleanOne(val[j]);
      } else container[key] = cleanOne(val);
    } else if (key.substr(key.length - 10) === 'colorscale' && Array.isArray(val)) {
      // colorscales have the format [[0, color1], [frac, color2], ... [1, colorN]]

      for (j = 0; j < val.length; j++) {
        if (Array.isArray(val[j])) val[j][1] = cleanOne(val[j][1]);
      }
    } else if (Array.isArray(val)) {
      // recurse into arrays of objects, and plain objects

      var el0 = val[0];
      if (!Array.isArray(el0) && el0 && typeof el0 === 'object') {
        for (j = 0; j < val.length; j++) color.clean(val[j]);
      }
    } else if (val && typeof val === 'object' && !isTypedArray(val)) color.clean(val);
  }
};
function cleanOne(val) {
  if (isNumeric(val) || typeof val !== 'string') return val;
  var valTrim = val.trim();
  if (valTrim.substr(0, 3) !== 'rgb') return val;
  var match = valTrim.match(/^rgba?\s*\(([^()]*)\)$/);
  if (!match) return val;
  var parts = match[1].trim().split(/\s*[\s,]\s*/);
  var rgba = valTrim.charAt(3) === 'a' && parts.length === 4;
  if (!rgba && parts.length !== 3) return val;
  for (var i = 0; i < parts.length; i++) {
    if (!parts[i].length) return val;
    parts[i] = Number(parts[i]);
    if (!(parts[i] >= 0)) {
      // all parts must be non-negative numbers

      return val;
    }
    if (i === 3) {
      // alpha>1 gets clipped to 1

      if (parts[i] > 1) parts[i] = 1;
    } else if (parts[i] >= 1) {
      // r, g, b must be < 1 (ie 1 itself is not allowed)

      return val;
    }
  }
  var rgbStr = Math.round(parts[0] * 255) + ', ' + Math.round(parts[1] * 255) + ', ' + Math.round(parts[2] * 255);
  if (rgba) return 'rgba(' + rgbStr + ', ' + parts[3] + ')';
  return 'rgb(' + rgbStr + ')';
}

/***/ }),

/***/ 616:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var axesAttrs = __webpack_require__(4724);
var fontAttrs = __webpack_require__(5376);
var extendFlat = (__webpack_require__(2880).extendFlat);
var overrideAll = (__webpack_require__(7824).overrideAll);
module.exports = overrideAll({
  orientation: {
    valType: 'enumerated',
    values: ['h', 'v'],
    dflt: 'v'
  },
  thicknessmode: {
    valType: 'enumerated',
    values: ['fraction', 'pixels'],
    dflt: 'pixels'
  },
  thickness: {
    valType: 'number',
    min: 0,
    dflt: 30
  },
  lenmode: {
    valType: 'enumerated',
    values: ['fraction', 'pixels'],
    dflt: 'fraction'
  },
  len: {
    valType: 'number',
    min: 0,
    dflt: 1
  },
  x: {
    valType: 'number'
  },
  xref: {
    valType: 'enumerated',
    dflt: 'paper',
    values: ['container', 'paper'],
    editType: 'layoutstyle'
  },
  xanchor: {
    valType: 'enumerated',
    values: ['left', 'center', 'right']
  },
  xpad: {
    valType: 'number',
    min: 0,
    dflt: 10
  },
  y: {
    valType: 'number'
  },
  yref: {
    valType: 'enumerated',
    dflt: 'paper',
    values: ['container', 'paper'],
    editType: 'layoutstyle'
  },
  yanchor: {
    valType: 'enumerated',
    values: ['top', 'middle', 'bottom']
  },
  ypad: {
    valType: 'number',
    min: 0,
    dflt: 10
  },
  // a possible line around the bar itself
  outlinecolor: axesAttrs.linecolor,
  outlinewidth: axesAttrs.linewidth,
  // Should outlinewidth have {dflt: 0} ?
  // another possible line outside the padding and tick labels
  bordercolor: axesAttrs.linecolor,
  borderwidth: {
    valType: 'number',
    min: 0,
    dflt: 0
  },
  bgcolor: {
    valType: 'color',
    dflt: 'rgba(0,0,0,0)'
  },
  // tick and title properties named and function exactly as in axes
  tickmode: axesAttrs.minor.tickmode,
  nticks: axesAttrs.nticks,
  tick0: axesAttrs.tick0,
  dtick: axesAttrs.dtick,
  tickvals: axesAttrs.tickvals,
  ticktext: axesAttrs.ticktext,
  ticks: extendFlat({}, axesAttrs.ticks, {
    dflt: ''
  }),
  ticklabeloverflow: extendFlat({}, axesAttrs.ticklabeloverflow, {}),
  // ticklabelposition: not used directly, as values depend on orientation
  // left/right options are for x axes, and top/bottom options are for y axes
  ticklabelposition: {
    valType: 'enumerated',
    values: ['outside', 'inside', 'outside top', 'inside top', 'outside left', 'inside left', 'outside right', 'inside right', 'outside bottom', 'inside bottom'],
    dflt: 'outside'
  },
  ticklen: axesAttrs.ticklen,
  tickwidth: axesAttrs.tickwidth,
  tickcolor: axesAttrs.tickcolor,
  ticklabelstep: axesAttrs.ticklabelstep,
  showticklabels: axesAttrs.showticklabels,
  labelalias: axesAttrs.labelalias,
  tickfont: fontAttrs({}),
  tickangle: axesAttrs.tickangle,
  tickformat: axesAttrs.tickformat,
  tickformatstops: axesAttrs.tickformatstops,
  tickprefix: axesAttrs.tickprefix,
  showtickprefix: axesAttrs.showtickprefix,
  ticksuffix: axesAttrs.ticksuffix,
  showticksuffix: axesAttrs.showticksuffix,
  separatethousands: axesAttrs.separatethousands,
  exponentformat: axesAttrs.exponentformat,
  minexponent: axesAttrs.minexponent,
  showexponent: axesAttrs.showexponent,
  title: {
    text: {
      valType: 'string'
    },
    font: fontAttrs({}),
    side: {
      valType: 'enumerated',
      values: ['right', 'top', 'bottom']
    }
  },
  _deprecated: {
    title: {
      valType: 'string'
    },
    titlefont: fontAttrs({}),
    titleside: {
      valType: 'enumerated',
      values: ['right', 'top', 'bottom'],
      dflt: 'top'
    }
  }
}, 'colorbars', 'from-root');

/***/ }),

/***/ 3964:
/***/ (function(module) {

"use strict";


module.exports = {
  cn: {
    colorbar: 'colorbar',
    cbbg: 'cbbg',
    cbfill: 'cbfill',
    cbfills: 'cbfills',
    cbline: 'cbline',
    cblines: 'cblines',
    cbaxis: 'cbaxis',
    cbtitleunshift: 'cbtitleunshift',
    cbtitle: 'cbtitle',
    cboutline: 'cboutline',
    crisp: 'crisp',
    jsPlaceholder: 'js-placeholder'
  }
};

/***/ }),

/***/ 4013:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Template = __webpack_require__(1780);
var handleTickValueDefaults = __webpack_require__(6332);
var handleTickMarkDefaults = __webpack_require__(5404);
var handleTickLabelDefaults = __webpack_require__(5936);
var handlePrefixSuffixDefaults = __webpack_require__(2568);
var attributes = __webpack_require__(616);
module.exports = function colorbarDefaults(containerIn, containerOut, layout) {
  var colorbarOut = Template.newContainer(containerOut, 'colorbar');
  var colorbarIn = containerIn.colorbar || {};
  function coerce(attr, dflt) {
    return Lib.coerce(colorbarIn, colorbarOut, attributes, attr, dflt);
  }
  var margin = layout.margin || {
    t: 0,
    b: 0,
    l: 0,
    r: 0
  };
  var w = layout.width - margin.l - margin.r;
  var h = layout.height - margin.t - margin.b;
  var orientation = coerce('orientation');
  var isVertical = orientation === 'v';
  var thicknessmode = coerce('thicknessmode');
  coerce('thickness', thicknessmode === 'fraction' ? 30 / (isVertical ? w : h) : 30);
  var lenmode = coerce('lenmode');
  coerce('len', lenmode === 'fraction' ? 1 : isVertical ? h : w);
  var yref = coerce('yref');
  var xref = coerce('xref');
  var isPaperY = yref === 'paper';
  var isPaperX = xref === 'paper';
  var defaultX, defaultY, defaultYAnchor;
  var defaultXAnchor = 'left';
  if (isVertical) {
    defaultYAnchor = 'middle';
    defaultXAnchor = isPaperX ? 'left' : 'right';
    defaultX = isPaperX ? 1.02 : 1;
    defaultY = 0.5;
  } else {
    defaultYAnchor = isPaperY ? 'bottom' : 'top';
    defaultXAnchor = 'center';
    defaultX = 0.5;
    defaultY = isPaperY ? 1.02 : 1;
  }
  Lib.coerce(colorbarIn, colorbarOut, {
    x: {
      valType: 'number',
      min: isPaperX ? -2 : 0,
      max: isPaperX ? 3 : 1,
      dflt: defaultX
    }
  }, 'x');
  Lib.coerce(colorbarIn, colorbarOut, {
    y: {
      valType: 'number',
      min: isPaperY ? -2 : 0,
      max: isPaperY ? 3 : 1,
      dflt: defaultY
    }
  }, 'y');
  coerce('xanchor', defaultXAnchor);
  coerce('xpad');
  coerce('yanchor', defaultYAnchor);
  coerce('ypad');
  Lib.noneOrAll(colorbarIn, colorbarOut, ['x', 'y']);
  coerce('outlinecolor');
  coerce('outlinewidth');
  coerce('bordercolor');
  coerce('borderwidth');
  coerce('bgcolor');
  var ticklabelposition = Lib.coerce(colorbarIn, colorbarOut, {
    ticklabelposition: {
      valType: 'enumerated',
      dflt: 'outside',
      values: isVertical ? ['outside', 'inside', 'outside top', 'inside top', 'outside bottom', 'inside bottom'] : ['outside', 'inside', 'outside left', 'inside left', 'outside right', 'inside right']
    }
  }, 'ticklabelposition');
  coerce('ticklabeloverflow', ticklabelposition.indexOf('inside') !== -1 ? 'hide past domain' : 'hide past div');
  handleTickValueDefaults(colorbarIn, colorbarOut, coerce, 'linear');
  var font = layout.font;
  var opts = {
    noAutotickangles: true,
    outerTicks: false,
    font: font
  };
  if (ticklabelposition.indexOf('inside') !== -1) {
    opts.bgColor = 'black'; // could we instead use the average of colors in the scale?
  }

  handlePrefixSuffixDefaults(colorbarIn, colorbarOut, coerce, 'linear', opts);
  handleTickLabelDefaults(colorbarIn, colorbarOut, coerce, 'linear', opts);
  handleTickMarkDefaults(colorbarIn, colorbarOut, coerce, 'linear', opts);
  coerce('title.text', layout._dfltTitle.colorbar);
  var tickFont = colorbarOut.showticklabels ? colorbarOut.tickfont : font;
  var dfltTitleFont = Lib.extendFlat({}, tickFont, {
    weight: font.weight,
    style: font.style,
    variant: font.variant,
    color: font.color,
    size: Lib.bigFont(tickFont.size)
  });
  Lib.coerceFont(coerce, 'title.font', dfltTitleFont);
  coerce('title.side', isVertical ? 'top' : 'right');
};

/***/ }),

/***/ 7848:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var tinycolor = __webpack_require__(9760);
var Plots = __webpack_require__(7316);
var Registry = __webpack_require__(4040);
var Axes = __webpack_require__(4460);
var dragElement = __webpack_require__(6476);
var Lib = __webpack_require__(3400);
var strTranslate = Lib.strTranslate;
var extendFlat = (__webpack_require__(2880).extendFlat);
var setCursor = __webpack_require__(3972);
var Drawing = __webpack_require__(3616);
var Color = __webpack_require__(6308);
var Titles = __webpack_require__(1668);
var svgTextUtils = __webpack_require__(2736);
var flipScale = (__webpack_require__(4288).flipScale);
var handleAxisDefaults = __webpack_require__(5955);
var handleAxisPositionDefaults = __webpack_require__(7668);
var axisLayoutAttrs = __webpack_require__(4724);
var alignmentConstants = __webpack_require__(4284);
var LINE_SPACING = alignmentConstants.LINE_SPACING;
var FROM_TL = alignmentConstants.FROM_TL;
var FROM_BR = alignmentConstants.FROM_BR;
var cn = (__webpack_require__(3964).cn);
function draw(gd) {
  var fullLayout = gd._fullLayout;
  var colorBars = fullLayout._infolayer.selectAll('g.' + cn.colorbar).data(makeColorBarData(gd), function (opts) {
    return opts._id;
  });
  colorBars.enter().append('g').attr('class', function (opts) {
    return opts._id;
  }).classed(cn.colorbar, true);
  colorBars.each(function (opts) {
    var g = d3.select(this);
    Lib.ensureSingle(g, 'rect', cn.cbbg);
    Lib.ensureSingle(g, 'g', cn.cbfills);
    Lib.ensureSingle(g, 'g', cn.cblines);
    Lib.ensureSingle(g, 'g', cn.cbaxis, function (s) {
      s.classed(cn.crisp, true);
    });
    Lib.ensureSingle(g, 'g', cn.cbtitleunshift, function (s) {
      s.append('g').classed(cn.cbtitle, true);
    });
    Lib.ensureSingle(g, 'rect', cn.cboutline);
    var done = drawColorBar(g, opts, gd);
    if (done && done.then) (gd._promises || []).push(done);
    if (gd._context.edits.colorbarPosition) {
      makeEditable(g, opts, gd);
    }
  });
  colorBars.exit().each(function (opts) {
    Plots.autoMargin(gd, opts._id);
  }).remove();
  colorBars.order();
}
function makeColorBarData(gd) {
  var fullLayout = gd._fullLayout;
  var calcdata = gd.calcdata;
  var out = [];

  // single out item
  var opts;
  // colorbar attr parent container
  var cont;
  // trace attr container
  var trace;
  // colorbar options
  var cbOpt;
  function initOpts(opts) {
    return extendFlat(opts, {
      // fillcolor can be a d3 scale, domain is z values, range is colors
      // or leave it out for no fill,
      // or set to a string constant for single-color fill
      _fillcolor: null,
      // line.color has the same options as fillcolor
      _line: {
        color: null,
        width: null,
        dash: null
      },
      // levels of lines to draw.
      // note that this DOES NOT determine the extent of the bar
      // that's given by the domain of fillcolor
      // (or line.color if no fillcolor domain)
      _levels: {
        start: null,
        end: null,
        size: null
      },
      // separate fill levels (for example, heatmap coloring of a
      // contour map) if this is omitted, fillcolors will be
      // evaluated halfway between levels
      _filllevels: null,
      // for continuous colorscales: fill with a gradient instead of explicit levels
      // value should be the colorscale [[0, c0], [v1, c1], ..., [1, cEnd]]
      _fillgradient: null,
      // when using a gradient, we need the data range specified separately
      _zrange: null
    });
  }
  function calcOpts() {
    if (typeof cbOpt.calc === 'function') {
      cbOpt.calc(gd, trace, opts);
    } else {
      opts._fillgradient = cont.reversescale ? flipScale(cont.colorscale) : cont.colorscale;
      opts._zrange = [cont[cbOpt.min], cont[cbOpt.max]];
    }
  }
  for (var i = 0; i < calcdata.length; i++) {
    var cd = calcdata[i];
    trace = cd[0].trace;
    if (!trace._module) continue;
    var moduleOpts = trace._module.colorbar;
    if (trace.visible === true && moduleOpts) {
      var allowsMultiplotCbs = Array.isArray(moduleOpts);
      var cbOpts = allowsMultiplotCbs ? moduleOpts : [moduleOpts];
      for (var j = 0; j < cbOpts.length; j++) {
        cbOpt = cbOpts[j];
        var contName = cbOpt.container;
        cont = contName ? trace[contName] : trace;
        if (cont && cont.showscale) {
          opts = initOpts(cont.colorbar);
          opts._id = 'cb' + trace.uid + (allowsMultiplotCbs && contName ? '-' + contName : '');
          opts._traceIndex = trace.index;
          opts._propPrefix = (contName ? contName + '.' : '') + 'colorbar.';
          opts._meta = trace._meta;
          calcOpts();
          out.push(opts);
        }
      }
    }
  }
  for (var k in fullLayout._colorAxes) {
    cont = fullLayout[k];
    if (cont.showscale) {
      var colorAxOpts = fullLayout._colorAxes[k];
      opts = initOpts(cont.colorbar);
      opts._id = 'cb' + k;
      opts._propPrefix = k + '.colorbar.';
      opts._meta = fullLayout._meta;
      cbOpt = {
        min: 'cmin',
        max: 'cmax'
      };
      if (colorAxOpts[0] !== 'heatmap') {
        trace = colorAxOpts[1];
        cbOpt.calc = trace._module.colorbar.calc;
      }
      calcOpts();
      out.push(opts);
    }
  }
  return out;
}
function drawColorBar(g, opts, gd) {
  var isVertical = opts.orientation === 'v';
  var len = opts.len;
  var lenmode = opts.lenmode;
  var thickness = opts.thickness;
  var thicknessmode = opts.thicknessmode;
  var outlinewidth = opts.outlinewidth;
  var borderwidth = opts.borderwidth;
  var bgcolor = opts.bgcolor;
  var xanchor = opts.xanchor;
  var yanchor = opts.yanchor;
  var xpad = opts.xpad;
  var ypad = opts.ypad;
  var optsX = opts.x;
  var optsY = isVertical ? opts.y : 1 - opts.y;
  var isPaperY = opts.yref === 'paper';
  var isPaperX = opts.xref === 'paper';
  var fullLayout = gd._fullLayout;
  var gs = fullLayout._size;
  var fillColor = opts._fillcolor;
  var line = opts._line;
  var title = opts.title;
  var titleSide = title.side;
  var zrange = opts._zrange || d3.extent((typeof fillColor === 'function' ? fillColor : line.color).domain());
  var lineColormap = typeof line.color === 'function' ? line.color : function () {
    return line.color;
  };
  var fillColormap = typeof fillColor === 'function' ? fillColor : function () {
    return fillColor;
  };
  var levelsIn = opts._levels;
  var levelsOut = calcLevels(gd, opts, zrange);
  var fillLevels = levelsOut.fill;
  var lineLevels = levelsOut.line;

  // we calculate pixel sizes based on the specified graph size,
  // not the actual (in case something pushed the margins around)
  // which is a little odd but avoids an odd iterative effect
  // when the colorbar itself is pushing the margins.
  // but then the fractional size is calculated based on the
  // actual graph size, so that the axes will size correctly.
  var thickPx = Math.round(thickness * (thicknessmode === 'fraction' ? isVertical ? gs.w : gs.h : 1));
  var thickFrac = thickPx / (isVertical ? gs.w : gs.h);
  var lenPx = Math.round(len * (lenmode === 'fraction' ? isVertical ? gs.h : gs.w : 1));
  var lenFrac = lenPx / (isVertical ? gs.h : gs.w);
  var posW = isPaperX ? gs.w : gd._fullLayout.width;
  var posH = isPaperY ? gs.h : gd._fullLayout.height;

  // x positioning: do it initially just for left anchor,
  // then fix at the end (since we don't know the width yet)
  var uPx = Math.round(isVertical ? optsX * posW + xpad : optsY * posH + ypad);
  var xRatio = {
    center: 0.5,
    right: 1
  }[xanchor] || 0;
  var yRatio = {
    top: 1,
    middle: 0.5
  }[yanchor] || 0;

  // for dragging... this is getting a little muddled...
  var uFrac = isVertical ? optsX - xRatio * thickFrac : optsY - yRatio * thickFrac;

  // y/x positioning (for v/h) we can do correctly from the start
  var vFrac = isVertical ? optsY - yRatio * lenFrac : optsX - xRatio * lenFrac;
  var vPx = Math.round(isVertical ? posH * (1 - vFrac) : posW * vFrac);

  // stash a few things for makeEditable
  opts._lenFrac = lenFrac;
  opts._thickFrac = thickFrac;
  opts._uFrac = uFrac;
  opts._vFrac = vFrac;

  // stash mocked axis for contour label formatting
  var ax = opts._axis = mockColorBarAxis(gd, opts, zrange);

  // position can't go in through supplyDefaults
  // because that restricts it to [0,1]
  ax.position = thickFrac + (isVertical ? optsX + xpad / gs.w : optsY + ypad / gs.h);
  var topOrBottom = ['top', 'bottom'].indexOf(titleSide) !== -1;
  if (isVertical && topOrBottom) {
    ax.title.side = titleSide;
    ax.titlex = optsX + xpad / gs.w;
    ax.titley = vFrac + (title.side === 'top' ? lenFrac - ypad / gs.h : ypad / gs.h);
  }
  if (!isVertical && !topOrBottom) {
    ax.title.side = titleSide;
    ax.titley = optsY + ypad / gs.h;
    ax.titlex = vFrac + xpad / gs.w; // right side
  }

  if (line.color && opts.tickmode === 'auto') {
    ax.tickmode = 'linear';
    ax.tick0 = levelsIn.start;
    var dtick = levelsIn.size;
    // expand if too many contours, so we don't get too many ticks
    var autoNtick = Lib.constrain(lenPx / 50, 4, 15) + 1;
    var dtFactor = (zrange[1] - zrange[0]) / ((opts.nticks || autoNtick) * dtick);
    if (dtFactor > 1) {
      var dtexp = Math.pow(10, Math.floor(Math.log(dtFactor) / Math.LN10));
      dtick *= dtexp * Lib.roundUp(dtFactor / dtexp, [2, 5, 10]);
      // if the contours are at round multiples, reset tick0
      // so they're still at round multiples. Otherwise,
      // keep the first label on the first contour level
      if ((Math.abs(levelsIn.start) / levelsIn.size + 1e-6) % 1 < 2e-6) {
        ax.tick0 = 0;
      }
    }
    ax.dtick = dtick;
  }

  // set domain after init, because we may want to
  // allow it outside [0,1]
  ax.domain = isVertical ? [vFrac + ypad / gs.h, vFrac + lenFrac - ypad / gs.h] : [vFrac + xpad / gs.w, vFrac + lenFrac - xpad / gs.w];
  ax.setScale();
  g.attr('transform', strTranslate(Math.round(gs.l), Math.round(gs.t)));
  var titleCont = g.select('.' + cn.cbtitleunshift).attr('transform', strTranslate(-Math.round(gs.l), -Math.round(gs.t)));
  var ticklabelposition = ax.ticklabelposition;
  var titleFontSize = ax.title.font.size;
  var axLayer = g.select('.' + cn.cbaxis);
  var titleEl;
  var titleHeight = 0;
  var titleWidth = 0;
  function drawTitle(titleClass, titleOpts) {
    var dfltTitleOpts = {
      propContainer: ax,
      propName: opts._propPrefix + 'title',
      traceIndex: opts._traceIndex,
      _meta: opts._meta,
      placeholder: fullLayout._dfltTitle.colorbar,
      containerGroup: g.select('.' + cn.cbtitle)
    };

    // this class-to-rotate thing with convertToTspans is
    // getting hackier and hackier... delete groups with the
    // wrong class (in case earlier the colorbar was drawn on
    // a different side, I think?)
    var otherClass = titleClass.charAt(0) === 'h' ? titleClass.substr(1) : 'h' + titleClass;
    g.selectAll('.' + otherClass + ',.' + otherClass + '-math-group').remove();
    Titles.draw(gd, titleClass, extendFlat(dfltTitleOpts, titleOpts || {}));
  }
  function drawDummyTitle() {
    // draw the title so we know how much room it needs
    // when we squish the axis.
    // On vertical colorbars this only applies to top or bottom titles, not right side.
    // On horizontal colorbars this only applies to right, etc.

    if (isVertical && topOrBottom || !isVertical && !topOrBottom) {
      var x, y;
      if (titleSide === 'top') {
        x = xpad + gs.l + posW * optsX;
        y = ypad + gs.t + posH * (1 - vFrac - lenFrac) + 3 + titleFontSize * 0.75;
      }
      if (titleSide === 'bottom') {
        x = xpad + gs.l + posW * optsX;
        y = ypad + gs.t + posH * (1 - vFrac) - 3 - titleFontSize * 0.25;
      }
      if (titleSide === 'right') {
        y = ypad + gs.t + posH * optsY + 3 + titleFontSize * 0.75;
        x = xpad + gs.l + posW * vFrac;
      }
      drawTitle(ax._id + 'title', {
        attributes: {
          x: x,
          y: y,
          'text-anchor': isVertical ? 'start' : 'middle'
        }
      });
    }
  }
  function drawCbTitle() {
    if (isVertical && !topOrBottom || !isVertical && topOrBottom) {
      var pos = ax.position || 0;
      var mid = ax._offset + ax._length / 2;
      var x, y;
      if (titleSide === 'right') {
        y = mid;
        x = gs.l + posW * pos + 10 + titleFontSize * (ax.showticklabels ? 1 : 0.5);
      } else {
        x = mid;
        if (titleSide === 'bottom') {
          y = gs.t + posH * pos + 10 + (ticklabelposition.indexOf('inside') === -1 ? ax.tickfont.size : 0) + (ax.ticks !== 'intside' ? opts.ticklen || 0 : 0);
        }
        if (titleSide === 'top') {
          var nlines = title.text.split('<br>').length;
          y = gs.t + posH * pos + 10 - thickPx - LINE_SPACING * titleFontSize * nlines;
        }
      }
      drawTitle((isVertical ?
      // the 'h' + is a hack to get around the fact that
      // convertToTspans rotates any 'y...' class by 90 degrees.
      // TODO: find a better way to control this.
      'h' : 'v') + ax._id + 'title', {
        avoid: {
          selection: d3.select(gd).selectAll('g.' + ax._id + 'tick'),
          side: titleSide,
          offsetTop: isVertical ? 0 : gs.t,
          offsetLeft: isVertical ? gs.l : 0,
          maxShift: isVertical ? fullLayout.width : fullLayout.height
        },
        attributes: {
          x: x,
          y: y,
          'text-anchor': 'middle'
        },
        transform: {
          rotate: isVertical ? -90 : 0,
          offset: 0
        }
      });
    }
  }
  function drawAxis() {
    if (!isVertical && !topOrBottom || isVertical && topOrBottom) {
      // squish the axis top to make room for the title
      var titleGroup = g.select('.' + cn.cbtitle);
      var titleText = titleGroup.select('text');
      var titleTrans = [-outlinewidth / 2, outlinewidth / 2];
      var mathJaxNode = titleGroup.select('.h' + ax._id + 'title-math-group').node();
      var lineSize = 15.6;
      if (titleText.node()) {
        lineSize = parseInt(titleText.node().style.fontSize, 10) * LINE_SPACING;
      }
      var bb;
      if (mathJaxNode) {
        bb = Drawing.bBox(mathJaxNode);
        titleWidth = bb.width;
        titleHeight = bb.height;
        if (titleHeight > lineSize) {
          // not entirely sure how mathjax is doing
          // vertical alignment, but this seems to work.
          titleTrans[1] -= (titleHeight - lineSize) / 2;
        }
      } else if (titleText.node() && !titleText.classed(cn.jsPlaceholder)) {
        bb = Drawing.bBox(titleText.node());
        titleWidth = bb.width;
        titleHeight = bb.height;
      }
      if (isVertical) {
        if (titleHeight) {
          // buffer btwn colorbar and title
          // TODO: configurable
          titleHeight += 5;
          if (titleSide === 'top') {
            ax.domain[1] -= titleHeight / gs.h;
            titleTrans[1] *= -1;
          } else {
            ax.domain[0] += titleHeight / gs.h;
            var nlines = svgTextUtils.lineCount(titleText);
            titleTrans[1] += (1 - nlines) * lineSize;
          }
          titleGroup.attr('transform', strTranslate(titleTrans[0], titleTrans[1]));
          ax.setScale();
        }
      } else {
        // horizontal colorbars
        if (titleWidth) {
          if (titleSide === 'right') {
            ax.domain[0] += (titleWidth + titleFontSize / 2) / gs.w;
          }
          titleGroup.attr('transform', strTranslate(titleTrans[0], titleTrans[1]));
          ax.setScale();
        }
      }
    }
    g.selectAll('.' + cn.cbfills + ',.' + cn.cblines).attr('transform', isVertical ? strTranslate(0, Math.round(gs.h * (1 - ax.domain[1]))) : strTranslate(Math.round(gs.w * ax.domain[0]), 0));
    axLayer.attr('transform', isVertical ? strTranslate(0, Math.round(-gs.t)) : strTranslate(Math.round(-gs.l), 0));
    var fills = g.select('.' + cn.cbfills).selectAll('rect.' + cn.cbfill).attr('style', '').data(fillLevels);
    fills.enter().append('rect').classed(cn.cbfill, true).attr('style', '');
    fills.exit().remove();
    var zBounds = zrange.map(ax.c2p).map(Math.round).sort(function (a, b) {
      return a - b;
    });
    fills.each(function (d, i) {
      var z = [i === 0 ? zrange[0] : (fillLevels[i] + fillLevels[i - 1]) / 2, i === fillLevels.length - 1 ? zrange[1] : (fillLevels[i] + fillLevels[i + 1]) / 2].map(ax.c2p).map(Math.round);

      // offset the side adjoining the next rectangle so they
      // overlap, to prevent antialiasing gaps
      if (isVertical) {
        z[1] = Lib.constrain(z[1] + (z[1] > z[0]) ? 1 : -1, zBounds[0], zBounds[1]);
      } /* else {
          // TODO: horizontal case
        } */

      // Colorbar cannot currently support opacities so we
      // use an opaque fill even when alpha channels present
      var fillEl = d3.select(this).attr(isVertical ? 'x' : 'y', uPx).attr(isVertical ? 'y' : 'x', d3.min(z)).attr(isVertical ? 'width' : 'height', Math.max(thickPx, 2)).attr(isVertical ? 'height' : 'width', Math.max(d3.max(z) - d3.min(z), 2));
      if (opts._fillgradient) {
        Drawing.gradient(fillEl, gd, opts._id, isVertical ? 'vertical' : 'horizontalreversed', opts._fillgradient, 'fill');
      } else {
        // tinycolor can't handle exponents and
        // at this scale, removing it makes no difference.
        var colorString = fillColormap(d).replace('e-', '');
        fillEl.attr('fill', tinycolor(colorString).toHexString());
      }
    });
    var lines = g.select('.' + cn.cblines).selectAll('path.' + cn.cbline).data(line.color && line.width ? lineLevels : []);
    lines.enter().append('path').classed(cn.cbline, true);
    lines.exit().remove();
    lines.each(function (d) {
      var a = uPx;
      var b = Math.round(ax.c2p(d)) + line.width / 2 % 1;
      d3.select(this).attr('d', 'M' + (isVertical ? a + ',' + b : b + ',' + a) + (isVertical ? 'h' : 'v') + thickPx).call(Drawing.lineGroupStyle, line.width, lineColormap(d), line.dash);
    });

    // force full redraw of labels and ticks
    axLayer.selectAll('g.' + ax._id + 'tick,path').remove();
    var shift = uPx + thickPx + (outlinewidth || 0) / 2 - (opts.ticks === 'outside' ? 1 : 0);
    var vals = Axes.calcTicks(ax);
    var tickSign = Axes.getTickSigns(ax)[2];
    Axes.drawTicks(gd, ax, {
      vals: ax.ticks === 'inside' ? Axes.clipEnds(ax, vals) : vals,
      layer: axLayer,
      path: Axes.makeTickPath(ax, shift, tickSign),
      transFn: Axes.makeTransTickFn(ax)
    });
    return Axes.drawLabels(gd, ax, {
      vals: vals,
      layer: axLayer,
      transFn: Axes.makeTransTickLabelFn(ax),
      labelFns: Axes.makeLabelFns(ax, shift)
    });
  }

  // wait for the axis & title to finish rendering before
  // continuing positioning
  // TODO: why are we redrawing multiple times now with this?
  // I guess autoMargin doesn't like being post-promise?
  function positionCB() {
    var bb;
    var innerThickness = thickPx + outlinewidth / 2;
    if (ticklabelposition.indexOf('inside') === -1) {
      bb = Drawing.bBox(axLayer.node());
      innerThickness += isVertical ? bb.width : bb.height;
    }
    titleEl = titleCont.select('text');
    var titleWidth = 0;
    var topSideVertical = isVertical && titleSide === 'top';
    var rightSideHorizontal = !isVertical && titleSide === 'right';
    var moveY = 0;
    if (titleEl.node() && !titleEl.classed(cn.jsPlaceholder)) {
      var _titleHeight;
      var mathJaxNode = titleCont.select('.h' + ax._id + 'title-math-group').node();
      if (mathJaxNode && (isVertical && topOrBottom || !isVertical && !topOrBottom)) {
        bb = Drawing.bBox(mathJaxNode);
        titleWidth = bb.width;
        _titleHeight = bb.height;
      } else {
        // note: the formula below works for all title sides,
        // (except for top/bottom mathjax, above)
        // but the weird gs.l is because the titleunshift
        // transform gets removed by Drawing.bBox
        bb = Drawing.bBox(titleCont.node());
        titleWidth = bb.right - gs.l - (isVertical ? uPx : vPx);
        _titleHeight = bb.bottom - gs.t - (isVertical ? vPx : uPx);
        if (!isVertical && titleSide === 'top') {
          innerThickness += bb.height;
          moveY = bb.height;
        }
      }
      if (rightSideHorizontal) {
        titleEl.attr('transform', strTranslate(titleWidth / 2 + titleFontSize / 2, 0));
        titleWidth *= 2;
      }
      innerThickness = Math.max(innerThickness, isVertical ? titleWidth : _titleHeight);
    }
    var outerThickness = (isVertical ? xpad : ypad) * 2 + innerThickness + borderwidth + outlinewidth / 2;
    var hColorbarMoveTitle = 0;
    if (!isVertical && title.text && yanchor === 'bottom' && optsY <= 0) {
      hColorbarMoveTitle = outerThickness / 2;
      outerThickness += hColorbarMoveTitle;
      moveY += hColorbarMoveTitle;
    }
    fullLayout._hColorbarMoveTitle = hColorbarMoveTitle;
    fullLayout._hColorbarMoveCBTitle = moveY;
    var extraW = borderwidth + outlinewidth;

    // TODO - are these the correct positions?
    var lx = (isVertical ? uPx : vPx) - extraW / 2 - (isVertical ? xpad : 0);
    var ly = (isVertical ? vPx : uPx) - (isVertical ? lenPx : ypad + moveY - hColorbarMoveTitle);
    g.select('.' + cn.cbbg).attr('x', lx).attr('y', ly).attr(isVertical ? 'width' : 'height', Math.max(outerThickness - hColorbarMoveTitle, 2)).attr(isVertical ? 'height' : 'width', Math.max(lenPx + extraW, 2)).call(Color.fill, bgcolor).call(Color.stroke, opts.bordercolor).style('stroke-width', borderwidth);
    var moveX = rightSideHorizontal ? Math.max(titleWidth - 10, 0) : 0;
    g.selectAll('.' + cn.cboutline).attr('x', (isVertical ? uPx : vPx + xpad) + moveX).attr('y', (isVertical ? vPx + ypad - lenPx : uPx) + (topSideVertical ? titleHeight : 0)).attr(isVertical ? 'width' : 'height', Math.max(thickPx, 2)).attr(isVertical ? 'height' : 'width', Math.max(lenPx - (isVertical ? 2 * ypad + titleHeight : 2 * xpad + moveX), 2)).call(Color.stroke, opts.outlinecolor).style({
      fill: 'none',
      'stroke-width': outlinewidth
    });
    var xShift = isVertical ? xRatio * outerThickness : 0;
    var yShift = isVertical ? 0 : (1 - yRatio) * outerThickness - moveY;
    xShift = isPaperX ? gs.l - xShift : -xShift;
    yShift = isPaperY ? gs.t - yShift : -yShift;
    g.attr('transform', strTranslate(xShift, yShift));
    if (!isVertical && (borderwidth || tinycolor(bgcolor).getAlpha() && !tinycolor.equals(fullLayout.paper_bgcolor, bgcolor))) {
      // for horizontal colorbars when there is a border line or having different background color
      // hide/adjust x positioning for the first/last tick labels if they go outside the border
      var tickLabels = axLayer.selectAll('text');
      var numTicks = tickLabels[0].length;
      var border = g.select('.' + cn.cbbg).node();
      var oBb = Drawing.bBox(border);
      var oTr = Drawing.getTranslate(g);
      var TEXTPAD = 2;
      tickLabels.each(function (d, i) {
        var first = 0;
        var last = numTicks - 1;
        if (i === first || i === last) {
          var iBb = Drawing.bBox(this);
          var iTr = Drawing.getTranslate(this);
          var deltaX;
          if (i === last) {
            var iRight = iBb.right + iTr.x;
            var oRight = oBb.right + oTr.x + vPx - borderwidth - TEXTPAD + optsX;
            deltaX = oRight - iRight;
            if (deltaX > 0) deltaX = 0;
          } else if (i === first) {
            var iLeft = iBb.left + iTr.x;
            var oLeft = oBb.left + oTr.x + vPx + borderwidth + TEXTPAD;
            deltaX = oLeft - iLeft;
            if (deltaX < 0) deltaX = 0;
          }
          if (deltaX) {
            if (numTicks < 3) {
              // adjust position
              this.setAttribute('transform', 'translate(' + deltaX + ',0) ' + this.getAttribute('transform'));
            } else {
              // hide
              this.setAttribute('visibility', 'hidden');
            }
          }
        }
      });
    }

    // auto margin adjustment
    var marginOpts = {};
    var lFrac = FROM_TL[xanchor];
    var rFrac = FROM_BR[xanchor];
    var tFrac = FROM_TL[yanchor];
    var bFrac = FROM_BR[yanchor];
    var extraThickness = outerThickness - thickPx;
    if (isVertical) {
      if (lenmode === 'pixels') {
        marginOpts.y = optsY;
        marginOpts.t = lenPx * tFrac;
        marginOpts.b = lenPx * bFrac;
      } else {
        marginOpts.t = marginOpts.b = 0;
        marginOpts.yt = optsY + len * tFrac;
        marginOpts.yb = optsY - len * bFrac;
      }
      if (thicknessmode === 'pixels') {
        marginOpts.x = optsX;
        marginOpts.l = outerThickness * lFrac;
        marginOpts.r = outerThickness * rFrac;
      } else {
        marginOpts.l = extraThickness * lFrac;
        marginOpts.r = extraThickness * rFrac;
        marginOpts.xl = optsX - thickness * lFrac;
        marginOpts.xr = optsX + thickness * rFrac;
      }
    } else {
      // horizontal colorbars
      if (lenmode === 'pixels') {
        marginOpts.x = optsX;
        marginOpts.l = lenPx * lFrac;
        marginOpts.r = lenPx * rFrac;
      } else {
        marginOpts.l = marginOpts.r = 0;
        marginOpts.xl = optsX + len * lFrac;
        marginOpts.xr = optsX - len * rFrac;
      }
      if (thicknessmode === 'pixels') {
        marginOpts.y = 1 - optsY;
        marginOpts.t = outerThickness * tFrac;
        marginOpts.b = outerThickness * bFrac;
      } else {
        marginOpts.t = extraThickness * tFrac;
        marginOpts.b = extraThickness * bFrac;
        marginOpts.yt = optsY - thickness * tFrac;
        marginOpts.yb = optsY + thickness * bFrac;
      }
    }
    var sideY = opts.y < 0.5 ? 'b' : 't';
    var sideX = opts.x < 0.5 ? 'l' : 'r';
    gd._fullLayout._reservedMargin[opts._id] = {};
    var possibleReservedMargins = {
      r: fullLayout.width - lx - xShift,
      l: lx + marginOpts.r,
      b: fullLayout.height - ly - yShift,
      t: ly + marginOpts.b
    };
    if (isPaperX && isPaperY) {
      Plots.autoMargin(gd, opts._id, marginOpts);
    } else if (isPaperX) {
      gd._fullLayout._reservedMargin[opts._id][sideY] = possibleReservedMargins[sideY];
    } else if (isPaperY) {
      gd._fullLayout._reservedMargin[opts._id][sideX] = possibleReservedMargins[sideX];
    } else {
      if (isVertical) {
        gd._fullLayout._reservedMargin[opts._id][sideX] = possibleReservedMargins[sideX];
      } else {
        gd._fullLayout._reservedMargin[opts._id][sideY] = possibleReservedMargins[sideY];
      }
    }
  }
  return Lib.syncOrAsync([Plots.previousPromises, drawDummyTitle, drawAxis, drawCbTitle, Plots.previousPromises, positionCB], gd);
}
function makeEditable(g, opts, gd) {
  var isVertical = opts.orientation === 'v';
  var fullLayout = gd._fullLayout;
  var gs = fullLayout._size;
  var t0, xf, yf;
  dragElement.init({
    element: g.node(),
    gd: gd,
    prepFn: function () {
      t0 = g.attr('transform');
      setCursor(g);
    },
    moveFn: function (dx, dy) {
      g.attr('transform', t0 + strTranslate(dx, dy));
      xf = dragElement.align((isVertical ? opts._uFrac : opts._vFrac) + dx / gs.w, isVertical ? opts._thickFrac : opts._lenFrac, 0, 1, opts.xanchor);
      yf = dragElement.align((isVertical ? opts._vFrac : 1 - opts._uFrac) - dy / gs.h, isVertical ? opts._lenFrac : opts._thickFrac, 0, 1, opts.yanchor);
      var csr = dragElement.getCursor(xf, yf, opts.xanchor, opts.yanchor);
      setCursor(g, csr);
    },
    doneFn: function () {
      setCursor(g);
      if (xf !== undefined && yf !== undefined) {
        var update = {};
        update[opts._propPrefix + 'x'] = xf;
        update[opts._propPrefix + 'y'] = yf;
        if (opts._traceIndex !== undefined) {
          Registry.call('_guiRestyle', gd, update, opts._traceIndex);
        } else {
          Registry.call('_guiRelayout', gd, update);
        }
      }
    }
  });
}
function calcLevels(gd, opts, zrange) {
  var levelsIn = opts._levels;
  var lineLevels = [];
  var fillLevels = [];
  var l;
  var i;
  var l0 = levelsIn.end + levelsIn.size / 100;
  var ls = levelsIn.size;
  var zr0 = 1.001 * zrange[0] - 0.001 * zrange[1];
  var zr1 = 1.001 * zrange[1] - 0.001 * zrange[0];
  for (i = 0; i < 1e5; i++) {
    l = levelsIn.start + i * ls;
    if (ls > 0 ? l >= l0 : l <= l0) break;
    if (l > zr0 && l < zr1) lineLevels.push(l);
  }
  if (opts._fillgradient) {
    fillLevels = [0];
  } else if (typeof opts._fillcolor === 'function') {
    var fillLevelsIn = opts._filllevels;
    if (fillLevelsIn) {
      l0 = fillLevelsIn.end + fillLevelsIn.size / 100;
      ls = fillLevelsIn.size;
      for (i = 0; i < 1e5; i++) {
        l = fillLevelsIn.start + i * ls;
        if (ls > 0 ? l >= l0 : l <= l0) break;
        if (l > zrange[0] && l < zrange[1]) fillLevels.push(l);
      }
    } else {
      fillLevels = lineLevels.map(function (v) {
        return v - levelsIn.size / 2;
      });
      fillLevels.push(fillLevels[fillLevels.length - 1] + levelsIn.size);
    }
  } else if (opts._fillcolor && typeof opts._fillcolor === 'string') {
    // doesn't matter what this value is, with a single value
    // we'll make a single fill rect covering the whole bar
    fillLevels = [0];
  }
  if (levelsIn.size < 0) {
    lineLevels.reverse();
    fillLevels.reverse();
  }
  return {
    line: lineLevels,
    fill: fillLevels
  };
}
function mockColorBarAxis(gd, opts, zrange) {
  var fullLayout = gd._fullLayout;
  var isVertical = opts.orientation === 'v';
  var cbAxisIn = {
    type: 'linear',
    range: zrange,
    tickmode: opts.tickmode,
    nticks: opts.nticks,
    tick0: opts.tick0,
    dtick: opts.dtick,
    tickvals: opts.tickvals,
    ticktext: opts.ticktext,
    ticks: opts.ticks,
    ticklen: opts.ticklen,
    tickwidth: opts.tickwidth,
    tickcolor: opts.tickcolor,
    showticklabels: opts.showticklabels,
    labelalias: opts.labelalias,
    ticklabelposition: opts.ticklabelposition,
    ticklabeloverflow: opts.ticklabeloverflow,
    ticklabelstep: opts.ticklabelstep,
    tickfont: opts.tickfont,
    tickangle: opts.tickangle,
    tickformat: opts.tickformat,
    exponentformat: opts.exponentformat,
    minexponent: opts.minexponent,
    separatethousands: opts.separatethousands,
    showexponent: opts.showexponent,
    showtickprefix: opts.showtickprefix,
    tickprefix: opts.tickprefix,
    showticksuffix: opts.showticksuffix,
    ticksuffix: opts.ticksuffix,
    title: opts.title,
    showline: true,
    anchor: 'free',
    side: isVertical ? 'right' : 'bottom',
    position: 1
  };
  var letter = isVertical ? 'y' : 'x';
  var cbAxisOut = {
    type: 'linear',
    _id: letter + opts._id
  };
  var axisOptions = {
    letter: letter,
    font: fullLayout.font,
    noAutotickangles: letter === 'y',
    noHover: true,
    noTickson: true,
    noTicklabelmode: true,
    noInsideRange: true,
    calendar: fullLayout.calendar // not really necessary (yet?)
  };

  function coerce(attr, dflt) {
    return Lib.coerce(cbAxisIn, cbAxisOut, axisLayoutAttrs, attr, dflt);
  }
  handleAxisDefaults(cbAxisIn, cbAxisOut, coerce, axisOptions, fullLayout);
  handleAxisPositionDefaults(cbAxisIn, cbAxisOut, coerce, axisOptions);
  return cbAxisOut;
}
module.exports = {
  draw: draw
};

/***/ }),

/***/ 553:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
module.exports = function hasColorbar(container) {
  return Lib.isPlainObject(container.colorbar);
};

/***/ }),

/***/ 5080:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = {
  moduleType: 'component',
  name: 'colorbar',
  attributes: __webpack_require__(616),
  supplyDefaults: __webpack_require__(4013),
  draw: (__webpack_require__(7848).draw),
  hasColorbar: __webpack_require__(553)
};

/***/ }),

/***/ 9084:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var colorbarAttrs = __webpack_require__(616);
var counterRegex = (__webpack_require__(3756).counter);
var sortObjectKeys = __webpack_require__(2996);
var palettes = (__webpack_require__(8304).scales);
var paletteStr = sortObjectKeys(palettes);
function code(s) {
  return '`' + s + '`';
}

/**
 * Make colorscale attribute declarations for
 *
 * - colorscale,
 * - (c|z)auto, (c|z)min, (c|z)max,
 * - autocolorscale, reversescale,
 * - showscale (optionally)
 * - color (optionally)
 *
 * @param {string} context (dflt: '', i.e. from trace root):
 *     the container this is in ('', *marker*, *marker.line* etc)
 *
 * @param {object} opts:
 *   - cLetter {string} (dflt: 'c'):
 *     leading letter for 'min', 'max and 'auto' attribute (either 'z' or 'c')
 *
 *   - colorAttr {string} (dflt: 'z' if `cLetter: 'z'`, 'color' if `cLetter: 'c'`):
 *     (for descriptions) sets the name of the color attribute that maps to the colorscale.
 *
 *     N.B. if `colorAttr: 'color'`, we include the `color` declaration here.
 *
 *   - onlyIfNumerical {string} (dflt: false' if `cLetter: 'z'`, true if `cLetter: 'c'`):
 *     (for descriptions) set to true if colorscale attribute only
 *
 *   - colorscaleDflt {string}:
 *     overrides the colorscale dflt
 *
 *   - autoColorDflt {boolean} (dflt true):
 *     normally autocolorscale.dflt is `true`, but pass `false` to override
 *
 *   - noScale {boolean} (dflt: true if `context: 'marker.line'`, false otherwise):
 *     set to `false` to not include showscale attribute (e.g. for 'marker.line')
 *
 *   - showScaleDflt {boolean} (dflt: true if `cLetter: 'z'`, false otherwise)
 *
 *   - editTypeOverride {boolean} (dflt: ''):
 *     most of these attributes already require a recalc, but the ones that do not
 *     have editType *style* or *plot* unless you override (presumably with *calc*)
 *
 *   - anim {boolean) (dflt: undefined): is 'color' animatable?
 *
 * @return {object}
 */
module.exports = function colorScaleAttrs(context, opts) {
  context = context || '';
  opts = opts || {};
  var cLetter = opts.cLetter || 'c';
  var onlyIfNumerical = 'onlyIfNumerical' in opts ? opts.onlyIfNumerical : Boolean(context);
  var noScale = 'noScale' in opts ? opts.noScale : context === 'marker.line';
  var showScaleDflt = 'showScaleDflt' in opts ? opts.showScaleDflt : cLetter === 'z';
  var colorscaleDflt = typeof opts.colorscaleDflt === 'string' ? palettes[opts.colorscaleDflt] : null;
  var editTypeOverride = opts.editTypeOverride || '';
  var contextHead = context ? context + '.' : '';
  var colorAttr, colorAttrFull;
  if ('colorAttr' in opts) {
    colorAttr = opts.colorAttr;
    colorAttrFull = opts.colorAttr;
  } else {
    colorAttr = {
      z: 'z',
      c: 'color'
    }[cLetter];
    colorAttrFull = 'in ' + code(contextHead + colorAttr);
  }
  var effectDesc = onlyIfNumerical ? ' Has an effect only if ' + colorAttrFull + ' is set to a numerical array.' : '';
  var auto = cLetter + 'auto';
  var min = cLetter + 'min';
  var max = cLetter + 'max';
  var mid = cLetter + 'mid';
  var autoFull = code(contextHead + auto);
  var minFull = code(contextHead + min);
  var maxFull = code(contextHead + max);
  var minmaxFull = minFull + ' and ' + maxFull;
  var autoImpliedEdits = {};
  autoImpliedEdits[min] = autoImpliedEdits[max] = undefined;
  var minmaxImpliedEdits = {};
  minmaxImpliedEdits[auto] = false;
  var attrs = {};
  if (colorAttr === 'color') {
    attrs.color = {
      valType: 'color',
      arrayOk: true,
      editType: editTypeOverride || 'style'
    };
    if (opts.anim) {
      attrs.color.anim = true;
    }
  }
  attrs[auto] = {
    valType: 'boolean',
    dflt: true,
    editType: 'calc',
    impliedEdits: autoImpliedEdits
  };
  attrs[min] = {
    valType: 'number',
    dflt: null,
    editType: editTypeOverride || 'plot',
    impliedEdits: minmaxImpliedEdits
  };
  attrs[max] = {
    valType: 'number',
    dflt: null,
    editType: editTypeOverride || 'plot',
    impliedEdits: minmaxImpliedEdits
  };
  attrs[mid] = {
    valType: 'number',
    dflt: null,
    editType: 'calc',
    impliedEdits: autoImpliedEdits
  };
  attrs.colorscale = {
    valType: 'colorscale',
    editType: 'calc',
    dflt: colorscaleDflt,
    impliedEdits: {
      autocolorscale: false
    }
  };
  attrs.autocolorscale = {
    valType: 'boolean',
    // gets overrode in 'heatmap' & 'surface' for backwards comp.
    dflt: opts.autoColorDflt === false ? false : true,
    editType: 'calc',
    impliedEdits: {
      colorscale: undefined
    }
  };
  attrs.reversescale = {
    valType: 'boolean',
    dflt: false,
    editType: 'plot'
  };
  if (!noScale) {
    attrs.showscale = {
      valType: 'boolean',
      dflt: showScaleDflt,
      editType: 'calc'
    };
    attrs.colorbar = colorbarAttrs;
  }
  if (!opts.noColorAxis) {
    attrs.coloraxis = {
      valType: 'subplotid',
      regex: counterRegex('coloraxis'),
      dflt: null,
      editType: 'calc'
    };
  }
  return attrs;
};

/***/ }),

/***/ 7128:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isNumeric = __webpack_require__(8248);
var Lib = __webpack_require__(3400);
var extractOpts = (__webpack_require__(4288).extractOpts);
module.exports = function calc(gd, trace, opts) {
  var fullLayout = gd._fullLayout;
  var vals = opts.vals;
  var containerStr = opts.containerStr;
  var container = containerStr ? Lib.nestedProperty(trace, containerStr).get() : trace;
  var cOpts = extractOpts(container);
  var auto = cOpts.auto !== false;
  var min = cOpts.min;
  var max = cOpts.max;
  var mid = cOpts.mid;
  var minVal = function () {
    return Lib.aggNums(Math.min, null, vals);
  };
  var maxVal = function () {
    return Lib.aggNums(Math.max, null, vals);
  };
  if (min === undefined) {
    min = minVal();
  } else if (auto) {
    if (container._colorAx && isNumeric(min)) {
      min = Math.min(min, minVal());
    } else {
      min = minVal();
    }
  }
  if (max === undefined) {
    max = maxVal();
  } else if (auto) {
    if (container._colorAx && isNumeric(max)) {
      max = Math.max(max, maxVal());
    } else {
      max = maxVal();
    }
  }
  if (auto && mid !== undefined) {
    if (max - mid > mid - min) {
      min = mid - (max - mid);
    } else if (max - mid < mid - min) {
      max = mid + (mid - min);
    }
  }
  if (min === max) {
    min -= 0.5;
    max += 0.5;
  }
  cOpts._sync('min', min);
  cOpts._sync('max', max);
  if (cOpts.autocolorscale) {
    var scl;
    if (min * max < 0) scl = fullLayout.colorscale.diverging;else if (min >= 0) scl = fullLayout.colorscale.sequential;else scl = fullLayout.colorscale.sequentialminus;
    cOpts._sync('colorscale', scl);
  }
};

/***/ }),

/***/ 5504:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var hasColorscale = (__webpack_require__(4288).hasColorscale);
var extractOpts = (__webpack_require__(4288).extractOpts);
module.exports = function crossTraceDefaults(fullData, fullLayout) {
  function replace(cont, k) {
    var val = cont['_' + k];
    if (val !== undefined) {
      cont[k] = val;
    }
  }
  function relinkColorAttrs(outerCont, cbOpt) {
    var cont = cbOpt.container ? Lib.nestedProperty(outerCont, cbOpt.container).get() : outerCont;
    if (cont) {
      if (cont.coloraxis) {
        // stash ref to color axis
        cont._colorAx = fullLayout[cont.coloraxis];
      } else {
        var cOpts = extractOpts(cont);
        var isAuto = cOpts.auto;
        if (isAuto || cOpts.min === undefined) {
          replace(cont, cbOpt.min);
        }
        if (isAuto || cOpts.max === undefined) {
          replace(cont, cbOpt.max);
        }
        if (cOpts.autocolorscale) {
          replace(cont, 'colorscale');
        }
      }
    }
  }
  for (var i = 0; i < fullData.length; i++) {
    var trace = fullData[i];
    var cbOpts = trace._module.colorbar;
    if (cbOpts) {
      if (Array.isArray(cbOpts)) {
        for (var j = 0; j < cbOpts.length; j++) {
          relinkColorAttrs(trace, cbOpts[j]);
        }
      } else {
        relinkColorAttrs(trace, cbOpts);
      }
    }
    if (hasColorscale(trace, 'marker.line')) {
      relinkColorAttrs(trace, {
        container: 'marker.line',
        min: 'cmin',
        max: 'cmax'
      });
    }
  }
  for (var k in fullLayout._colorAxes) {
    relinkColorAttrs(fullLayout[k], {
      min: 'cmin',
      max: 'cmax'
    });
  }
};

/***/ }),

/***/ 7260:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isNumeric = __webpack_require__(8248);
var Lib = __webpack_require__(3400);
var hasColorbar = __webpack_require__(553);
var colorbarDefaults = __webpack_require__(4013);
var isValidScale = (__webpack_require__(8304).isValid);
var traceIs = (__webpack_require__(4040).traceIs);
function npMaybe(parentCont, prefix) {
  var containerStr = prefix.slice(0, prefix.length - 1);
  return prefix ? Lib.nestedProperty(parentCont, containerStr).get() || {} : parentCont;
}

/**
 * Colorscale / colorbar default handler
 *
 * @param {object} parentContIn : user (input) parent container (e.g. trace or layout coloraxis object)
 * @param {object} parentContOut : full parent container
 * @param {object} layout : (full) layout object
 * @param {fn} coerce : Lib.coerce wrapper
 * @param {object} opts :
 * - prefix {string} : attr string prefix to colorscale container from parent root
 * - cLetter {string} : 'c or 'z' color letter
 */
module.exports = function colorScaleDefaults(parentContIn, parentContOut, layout, coerce, opts) {
  var prefix = opts.prefix;
  var cLetter = opts.cLetter;
  var inTrace = ('_module' in parentContOut);
  var containerIn = npMaybe(parentContIn, prefix);
  var containerOut = npMaybe(parentContOut, prefix);
  var template = npMaybe(parentContOut._template || {}, prefix) || {};

  // colorScaleDefaults wrapper called if-ever we need to reset the colorscale
  // attributes for containers that were linked to invalid color axes
  var thisFn = function () {
    delete parentContIn.coloraxis;
    delete parentContOut.coloraxis;
    return colorScaleDefaults(parentContIn, parentContOut, layout, coerce, opts);
  };
  if (inTrace) {
    var colorAxes = layout._colorAxes || {};
    var colorAx = coerce(prefix + 'coloraxis');
    if (colorAx) {
      var colorbarVisuals = traceIs(parentContOut, 'contour') && Lib.nestedProperty(parentContOut, 'contours.coloring').get() || 'heatmap';
      var stash = colorAxes[colorAx];
      if (stash) {
        stash[2].push(thisFn);
        if (stash[0] !== colorbarVisuals) {
          stash[0] = false;
          Lib.warn(['Ignoring coloraxis:', colorAx, 'setting', 'as it is linked to incompatible colorscales.'].join(' '));
        }
      } else {
        // stash:
        // - colorbar visual 'type'
        // - colorbar options to help in Colorbar.draw
        // - list of colorScaleDefaults wrapper functions
        colorAxes[colorAx] = [colorbarVisuals, parentContOut, [thisFn]];
      }
      return;
    }
  }
  var minIn = containerIn[cLetter + 'min'];
  var maxIn = containerIn[cLetter + 'max'];
  var validMinMax = isNumeric(minIn) && isNumeric(maxIn) && minIn < maxIn;
  var auto = coerce(prefix + cLetter + 'auto', !validMinMax);
  if (auto) {
    coerce(prefix + cLetter + 'mid');
  } else {
    coerce(prefix + cLetter + 'min');
    coerce(prefix + cLetter + 'max');
  }

  // handles both the trace case (autocolorscale is false by default) and
  // the marker and marker.line case (autocolorscale is true by default)
  var sclIn = containerIn.colorscale;
  var sclTemplate = template.colorscale;
  var autoColorscaleDflt;
  if (sclIn !== undefined) autoColorscaleDflt = !isValidScale(sclIn);
  if (sclTemplate !== undefined) autoColorscaleDflt = !isValidScale(sclTemplate);
  coerce(prefix + 'autocolorscale', autoColorscaleDflt);
  coerce(prefix + 'colorscale');
  coerce(prefix + 'reversescale');
  if (prefix !== 'marker.line.') {
    // handles both the trace case where the dflt is listed in attributes and
    // the marker case where the dflt is determined by hasColorbar
    var showScaleDflt;
    if (prefix && inTrace) showScaleDflt = hasColorbar(containerIn);
    var showScale = coerce(prefix + 'showscale', showScaleDflt);
    if (showScale) {
      if (prefix && template) containerOut._template = template;
      colorbarDefaults(containerIn, containerOut, layout);
    }
  }
};

/***/ }),

/***/ 4288:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var tinycolor = __webpack_require__(9760);
var isNumeric = __webpack_require__(8248);
var Lib = __webpack_require__(3400);
var Color = __webpack_require__(6308);
var isValidScale = (__webpack_require__(8304).isValid);
function hasColorscale(trace, containerStr, colorKey) {
  var container = containerStr ? Lib.nestedProperty(trace, containerStr).get() || {} : trace;
  var color = container[colorKey || 'color'];
  if (color && color._inputArray) color = color._inputArray;
  var isArrayWithOneNumber = false;
  if (Lib.isArrayOrTypedArray(color)) {
    for (var i = 0; i < color.length; i++) {
      if (isNumeric(color[i])) {
        isArrayWithOneNumber = true;
        break;
      }
    }
  }
  return Lib.isPlainObject(container) && (isArrayWithOneNumber || container.showscale === true || isNumeric(container.cmin) && isNumeric(container.cmax) || isValidScale(container.colorscale) || Lib.isPlainObject(container.colorbar));
}
var constantAttrs = ['showscale', 'autocolorscale', 'colorscale', 'reversescale', 'colorbar'];
var letterAttrs = ['min', 'max', 'mid', 'auto'];

/**
 * Extract 'c' / 'z', trace / color axis colorscale options
 *
 * Note that it would be nice to replace all z* with c* equivalents in v3
 *
 * @param {object} cont : attribute container
 * @return {object}:
 *  - min: cmin or zmin
 *  - max: cmax or zmax
 *  - mid: cmid or zmid
 *  - auto: cauto or zauto
 *  - *scale: *scale attrs
 *  - colorbar: colorbar
 *  - _sync: function syncing attr and underscore dual (useful when calc'ing min/max)
 */
function extractOpts(cont) {
  var colorAx = cont._colorAx;
  var cont2 = colorAx ? colorAx : cont;
  var out = {};
  var cLetter;
  var i, k;
  for (i = 0; i < constantAttrs.length; i++) {
    k = constantAttrs[i];
    out[k] = cont2[k];
  }
  if (colorAx) {
    cLetter = 'c';
    for (i = 0; i < letterAttrs.length; i++) {
      k = letterAttrs[i];
      out[k] = cont2['c' + k];
    }
  } else {
    var k2;
    for (i = 0; i < letterAttrs.length; i++) {
      k = letterAttrs[i];
      k2 = 'c' + k;
      if (k2 in cont2) {
        out[k] = cont2[k2];
        continue;
      }
      k2 = 'z' + k;
      if (k2 in cont2) {
        out[k] = cont2[k2];
      }
    }
    cLetter = k2.charAt(0);
  }
  out._sync = function (k, v) {
    var k2 = letterAttrs.indexOf(k) !== -1 ? cLetter + k : k;
    cont2[k2] = cont2['_' + k2] = v;
  };
  return out;
}

/**
 * Extract colorscale into numeric domain and color range.
 *
 * @param {object} cont colorscale container (e.g. trace, marker)
 *  - colorscale {array of arrays}
 *  - cmin/zmin {number}
 *  - cmax/zmax {number}
 *  - reversescale {boolean}
 *
 * @return {object}
 *  - domain {array}
 *  - range {array}
 */
function extractScale(cont) {
  var cOpts = extractOpts(cont);
  var cmin = cOpts.min;
  var cmax = cOpts.max;
  var scl = cOpts.reversescale ? flipScale(cOpts.colorscale) : cOpts.colorscale;
  var N = scl.length;
  var domain = new Array(N);
  var range = new Array(N);
  for (var i = 0; i < N; i++) {
    var si = scl[i];
    domain[i] = cmin + si[0] * (cmax - cmin);
    range[i] = si[1];
  }
  return {
    domain: domain,
    range: range
  };
}
function flipScale(scl) {
  var N = scl.length;
  var sclNew = new Array(N);
  for (var i = N - 1, j = 0; i >= 0; i--, j++) {
    var si = scl[i];
    sclNew[j] = [1 - si[0], si[1]];
  }
  return sclNew;
}

/**
 * General colorscale function generator.
 *
 * @param {object} specs output of Colorscale.extractScale or precomputed domain, range.
 *  - domain {array}
 *  - range {array}
 *
 * @param {object} opts
 *  - noNumericCheck {boolean} if true, scale func bypasses numeric checks
 *  - returnArray {boolean} if true, scale func return 4-item array instead of color strings
 *
 * @return {function}
 */
function makeColorScaleFunc(specs, opts) {
  opts = opts || {};
  var domain = specs.domain;
  var range = specs.range;
  var N = range.length;
  var _range = new Array(N);
  for (var i = 0; i < N; i++) {
    var rgba = tinycolor(range[i]).toRgb();
    _range[i] = [rgba.r, rgba.g, rgba.b, rgba.a];
  }
  var _sclFunc = d3.scale.linear().domain(domain).range(_range).clamp(true);
  var noNumericCheck = opts.noNumericCheck;
  var returnArray = opts.returnArray;
  var sclFunc;
  if (noNumericCheck && returnArray) {
    sclFunc = _sclFunc;
  } else if (noNumericCheck) {
    sclFunc = function (v) {
      return colorArray2rbga(_sclFunc(v));
    };
  } else if (returnArray) {
    sclFunc = function (v) {
      if (isNumeric(v)) return _sclFunc(v);else if (tinycolor(v).isValid()) return v;else return Color.defaultLine;
    };
  } else {
    sclFunc = function (v) {
      if (isNumeric(v)) return colorArray2rbga(_sclFunc(v));else if (tinycolor(v).isValid()) return v;else return Color.defaultLine;
    };
  }

  // colorbar draw looks into the d3 scale closure for domain and range
  sclFunc.domain = _sclFunc.domain;
  sclFunc.range = function () {
    return range;
  };
  return sclFunc;
}
function makeColorScaleFuncFromTrace(trace, opts) {
  return makeColorScaleFunc(extractScale(trace), opts);
}
function colorArray2rbga(colorArray) {
  var colorObj = {
    r: colorArray[0],
    g: colorArray[1],
    b: colorArray[2],
    a: colorArray[3]
  };
  return tinycolor(colorObj).toRgbString();
}
module.exports = {
  hasColorscale: hasColorscale,
  extractOpts: extractOpts,
  extractScale: extractScale,
  flipScale: flipScale,
  makeColorScaleFunc: makeColorScaleFunc,
  makeColorScaleFuncFromTrace: makeColorScaleFuncFromTrace
};

/***/ }),

/***/ 8932:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var scales = __webpack_require__(8304);
var helpers = __webpack_require__(4288);
module.exports = {
  moduleType: 'component',
  name: 'colorscale',
  attributes: __webpack_require__(9084),
  layoutAttributes: __webpack_require__(2332),
  supplyLayoutDefaults: __webpack_require__(1608),
  handleDefaults: __webpack_require__(7260),
  crossTraceDefaults: __webpack_require__(5504),
  calc: __webpack_require__(7128),
  // ./scales.js is required in lib/coerce.js ;
  // it needs to be a separate module to avoid a circular dependency
  scales: scales.scales,
  defaultScale: scales.defaultScale,
  getScale: scales.get,
  isValidScale: scales.isValid,
  hasColorscale: helpers.hasColorscale,
  extractOpts: helpers.extractOpts,
  extractScale: helpers.extractScale,
  flipScale: helpers.flipScale,
  makeColorScaleFunc: helpers.makeColorScaleFunc,
  makeColorScaleFuncFromTrace: helpers.makeColorScaleFuncFromTrace
};

/***/ }),

/***/ 2332:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var extendFlat = (__webpack_require__(2880).extendFlat);
var colorScaleAttrs = __webpack_require__(9084);
var scales = (__webpack_require__(8304).scales);
var msg = 'Note that `autocolorscale` must be true for this attribute to work.';
module.exports = {
  editType: 'calc',
  colorscale: {
    editType: 'calc',
    sequential: {
      valType: 'colorscale',
      dflt: scales.Reds,
      editType: 'calc'
    },
    sequentialminus: {
      valType: 'colorscale',
      dflt: scales.Blues,
      editType: 'calc'
    },
    diverging: {
      valType: 'colorscale',
      dflt: scales.RdBu,
      editType: 'calc'
    }
  },
  coloraxis: extendFlat({
    // not really a 'subplot' attribute container,
    // but this is the flag we use to denote attributes that
    // support yaxis, yaxis2, yaxis3, ... counters
    _isSubplotObj: true,
    editType: 'calc'
  }, colorScaleAttrs('', {
    colorAttr: 'corresponding trace color array(s)',
    noColorAxis: true,
    showScaleDflt: true
  }))
};

/***/ }),

/***/ 1608:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Template = __webpack_require__(1780);
var colorScaleAttrs = __webpack_require__(2332);
var colorScaleDefaults = __webpack_require__(7260);
module.exports = function supplyLayoutDefaults(layoutIn, layoutOut) {
  function coerce(attr, dflt) {
    return Lib.coerce(layoutIn, layoutOut, colorScaleAttrs, attr, dflt);
  }
  coerce('colorscale.sequential');
  coerce('colorscale.sequentialminus');
  coerce('colorscale.diverging');
  var colorAxes = layoutOut._colorAxes;
  var colorAxIn, colorAxOut;
  function coerceAx(attr, dflt) {
    return Lib.coerce(colorAxIn, colorAxOut, colorScaleAttrs.coloraxis, attr, dflt);
  }
  for (var k in colorAxes) {
    var stash = colorAxes[k];
    if (stash[0]) {
      colorAxIn = layoutIn[k] || {};
      colorAxOut = Template.newContainer(layoutOut, k, 'coloraxis');
      colorAxOut._name = k;
      colorScaleDefaults(colorAxIn, colorAxOut, layoutOut, coerceAx, {
        prefix: '',
        cLetter: 'c'
      });
    } else {
      // re-coerce colorscale attributes w/o coloraxis
      for (var i = 0; i < stash[2].length; i++) {
        stash[2][i]();
      }
      delete layoutOut._colorAxes[k];
    }
  }
};

/***/ }),

/***/ 8304:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var tinycolor = __webpack_require__(9760);
var scales = {
  Greys: [[0, 'rgb(0,0,0)'], [1, 'rgb(255,255,255)']],
  YlGnBu: [[0, 'rgb(8,29,88)'], [0.125, 'rgb(37,52,148)'], [0.25, 'rgb(34,94,168)'], [0.375, 'rgb(29,145,192)'], [0.5, 'rgb(65,182,196)'], [0.625, 'rgb(127,205,187)'], [0.75, 'rgb(199,233,180)'], [0.875, 'rgb(237,248,217)'], [1, 'rgb(255,255,217)']],
  Greens: [[0, 'rgb(0,68,27)'], [0.125, 'rgb(0,109,44)'], [0.25, 'rgb(35,139,69)'], [0.375, 'rgb(65,171,93)'], [0.5, 'rgb(116,196,118)'], [0.625, 'rgb(161,217,155)'], [0.75, 'rgb(199,233,192)'], [0.875, 'rgb(229,245,224)'], [1, 'rgb(247,252,245)']],
  YlOrRd: [[0, 'rgb(128,0,38)'], [0.125, 'rgb(189,0,38)'], [0.25, 'rgb(227,26,28)'], [0.375, 'rgb(252,78,42)'], [0.5, 'rgb(253,141,60)'], [0.625, 'rgb(254,178,76)'], [0.75, 'rgb(254,217,118)'], [0.875, 'rgb(255,237,160)'], [1, 'rgb(255,255,204)']],
  Bluered: [[0, 'rgb(0,0,255)'], [1, 'rgb(255,0,0)']],
  // modified RdBu based on
  // http://www.kennethmoreland.com/color-maps/
  RdBu: [[0, 'rgb(5,10,172)'], [0.35, 'rgb(106,137,247)'], [0.5, 'rgb(190,190,190)'], [0.6, 'rgb(220,170,132)'], [0.7, 'rgb(230,145,90)'], [1, 'rgb(178,10,28)']],
  // Scale for non-negative numeric values
  Reds: [[0, 'rgb(220,220,220)'], [0.2, 'rgb(245,195,157)'], [0.4, 'rgb(245,160,105)'], [1, 'rgb(178,10,28)']],
  // Scale for non-positive numeric values
  Blues: [[0, 'rgb(5,10,172)'], [0.35, 'rgb(40,60,190)'], [0.5, 'rgb(70,100,245)'], [0.6, 'rgb(90,120,245)'], [0.7, 'rgb(106,137,247)'], [1, 'rgb(220,220,220)']],
  Picnic: [[0, 'rgb(0,0,255)'], [0.1, 'rgb(51,153,255)'], [0.2, 'rgb(102,204,255)'], [0.3, 'rgb(153,204,255)'], [0.4, 'rgb(204,204,255)'], [0.5, 'rgb(255,255,255)'], [0.6, 'rgb(255,204,255)'], [0.7, 'rgb(255,153,255)'], [0.8, 'rgb(255,102,204)'], [0.9, 'rgb(255,102,102)'], [1, 'rgb(255,0,0)']],
  Rainbow: [[0, 'rgb(150,0,90)'], [0.125, 'rgb(0,0,200)'], [0.25, 'rgb(0,25,255)'], [0.375, 'rgb(0,152,255)'], [0.5, 'rgb(44,255,150)'], [0.625, 'rgb(151,255,0)'], [0.75, 'rgb(255,234,0)'], [0.875, 'rgb(255,111,0)'], [1, 'rgb(255,0,0)']],
  Portland: [[0, 'rgb(12,51,131)'], [0.25, 'rgb(10,136,186)'], [0.5, 'rgb(242,211,56)'], [0.75, 'rgb(242,143,56)'], [1, 'rgb(217,30,30)']],
  Jet: [[0, 'rgb(0,0,131)'], [0.125, 'rgb(0,60,170)'], [0.375, 'rgb(5,255,255)'], [0.625, 'rgb(255,255,0)'], [0.875, 'rgb(250,0,0)'], [1, 'rgb(128,0,0)']],
  Hot: [[0, 'rgb(0,0,0)'], [0.3, 'rgb(230,0,0)'], [0.6, 'rgb(255,210,0)'], [1, 'rgb(255,255,255)']],
  Blackbody: [[0, 'rgb(0,0,0)'], [0.2, 'rgb(230,0,0)'], [0.4, 'rgb(230,210,0)'], [0.7, 'rgb(255,255,255)'], [1, 'rgb(160,200,255)']],
  Earth: [[0, 'rgb(0,0,130)'], [0.1, 'rgb(0,180,180)'], [0.2, 'rgb(40,210,40)'], [0.4, 'rgb(230,230,50)'], [0.6, 'rgb(120,70,20)'], [1, 'rgb(255,255,255)']],
  Electric: [[0, 'rgb(0,0,0)'], [0.15, 'rgb(30,0,100)'], [0.4, 'rgb(120,0,100)'], [0.6, 'rgb(160,90,0)'], [0.8, 'rgb(230,200,0)'], [1, 'rgb(255,250,220)']],
  Viridis: [[0, '#440154'], [0.06274509803921569, '#48186a'], [0.12549019607843137, '#472d7b'], [0.18823529411764706, '#424086'], [0.25098039215686274, '#3b528b'], [0.3137254901960784, '#33638d'], [0.3764705882352941, '#2c728e'], [0.4392156862745098, '#26828e'], [0.5019607843137255, '#21918c'], [0.5647058823529412, '#1fa088'], [0.6274509803921569, '#28ae80'], [0.6901960784313725, '#3fbc73'], [0.7529411764705882, '#5ec962'], [0.8156862745098039, '#84d44b'], [0.8784313725490196, '#addc30'], [0.9411764705882353, '#d8e219'], [1, '#fde725']],
  Cividis: [[0.000000, 'rgb(0,32,76)'], [0.058824, 'rgb(0,42,102)'], [0.117647, 'rgb(0,52,110)'], [0.176471, 'rgb(39,63,108)'], [0.235294, 'rgb(60,74,107)'], [0.294118, 'rgb(76,85,107)'], [0.352941, 'rgb(91,95,109)'], [0.411765, 'rgb(104,106,112)'], [0.470588, 'rgb(117,117,117)'], [0.529412, 'rgb(131,129,120)'], [0.588235, 'rgb(146,140,120)'], [0.647059, 'rgb(161,152,118)'], [0.705882, 'rgb(176,165,114)'], [0.764706, 'rgb(192,177,109)'], [0.823529, 'rgb(209,191,102)'], [0.882353, 'rgb(225,204,92)'], [0.941176, 'rgb(243,219,79)'], [1.000000, 'rgb(255,233,69)']]
};
var defaultScale = scales.RdBu;
function getScale(scl, dflt) {
  if (!dflt) dflt = defaultScale;
  if (!scl) return dflt;
  function parseScale() {
    try {
      scl = scales[scl] || JSON.parse(scl);
    } catch (e) {
      scl = dflt;
    }
  }
  if (typeof scl === 'string') {
    parseScale();
    // occasionally scl is double-JSON encoded...
    if (typeof scl === 'string') parseScale();
  }
  if (!isValidScaleArray(scl)) return dflt;
  return scl;
}
function isValidScaleArray(scl) {
  var highestVal = 0;
  if (!Array.isArray(scl) || scl.length < 2) return false;
  if (!scl[0] || !scl[scl.length - 1]) return false;
  if (+scl[0][0] !== 0 || +scl[scl.length - 1][0] !== 1) return false;
  for (var i = 0; i < scl.length; i++) {
    var si = scl[i];
    if (si.length !== 2 || +si[0] < highestVal || !tinycolor(si[1]).isValid()) {
      return false;
    }
    highestVal = +si[0];
  }
  return true;
}
function isValidScale(scl) {
  if (scales[scl] !== undefined) return true;else return isValidScaleArray(scl);
}
module.exports = {
  scales: scales,
  defaultScale: defaultScale,
  get: getScale,
  isValid: isValidScale
};

/***/ }),

/***/ 8316:
/***/ (function(module) {

"use strict";


// for automatic alignment on dragging, <1/3 means left align,
// >2/3 means right, and between is center. Pick the right fraction
// based on where you are, and return the fraction corresponding to
// that position on the object
module.exports = function align(v, dv, v0, v1, anchor) {
  var vmin = (v - v0) / (v1 - v0);
  var vmax = vmin + dv / (v1 - v0);
  var vc = (vmin + vmax) / 2;

  // explicitly specified anchor
  if (anchor === 'left' || anchor === 'bottom') return vmin;
  if (anchor === 'center' || anchor === 'middle') return vc;
  if (anchor === 'right' || anchor === 'top') return vmax;

  // automatic based on position
  if (vmin < 2 / 3 - vc) return vmin;
  if (vmax > 4 / 3 - vc) return vmax;
  return vc;
};

/***/ }),

/***/ 7416:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);

// set cursors pointing toward the closest corner/side,
// to indicate alignment
// x and y are 0-1, fractions of the plot area
var cursorset = [['sw-resize', 's-resize', 'se-resize'], ['w-resize', 'move', 'e-resize'], ['nw-resize', 'n-resize', 'ne-resize']];
module.exports = function getCursor(x, y, xanchor, yanchor) {
  if (xanchor === 'left') x = 0;else if (xanchor === 'center') x = 1;else if (xanchor === 'right') x = 2;else x = Lib.constrain(Math.floor(x * 3), 0, 2);
  if (yanchor === 'bottom') y = 0;else if (yanchor === 'middle') y = 1;else if (yanchor === 'top') y = 2;else y = Lib.constrain(Math.floor(y * 3), 0, 2);
  return cursorset[y][x];
};

/***/ }),

/***/ 2760:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


exports.selectMode = function (dragmode) {
  return dragmode === 'lasso' || dragmode === 'select';
};
exports.drawMode = function (dragmode) {
  return dragmode === 'drawclosedpath' || dragmode === 'drawopenpath' || dragmode === 'drawline' || dragmode === 'drawrect' || dragmode === 'drawcircle';
};
exports.openMode = function (dragmode) {
  return dragmode === 'drawline' || dragmode === 'drawopenpath';
};
exports.rectMode = function (dragmode) {
  return dragmode === 'select' || dragmode === 'drawline' || dragmode === 'drawrect' || dragmode === 'drawcircle';
};
exports.freeMode = function (dragmode) {
  return dragmode === 'lasso' || dragmode === 'drawclosedpath' || dragmode === 'drawopenpath';
};
exports.selectingOrDrawing = function (dragmode) {
  return exports.freeMode(dragmode) || exports.rectMode(dragmode);
};

/***/ }),

/***/ 6476:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var mouseOffset = __webpack_require__(9128);
var hasHover = __webpack_require__(2264);
var supportsPassive = __webpack_require__(9184);
var removeElement = (__webpack_require__(3400).removeElement);
var constants = __webpack_require__(3816);
var dragElement = module.exports = {};
dragElement.align = __webpack_require__(8316);
dragElement.getCursor = __webpack_require__(7416);
var unhover = __webpack_require__(2616);
dragElement.unhover = unhover.wrapped;
dragElement.unhoverRaw = unhover.raw;

/**
 * Abstracts click & drag interactions
 *
 * During the interaction, a "coverSlip" element - a transparent
 * div covering the whole page - is created, which has two key effects:
 * - Lets you drag beyond the boundaries of the plot itself without
 *   dropping (but if you drag all the way out of the browser window the
 *   interaction will end)
 * - Freezes the cursor: whatever mouse cursor the drag element had when the
 *   interaction started gets copied to the coverSlip for use until mouseup
 *
 * If the user executes a drag bigger than MINDRAG, callbacks will fire as:
 *      prepFn, moveFn (1 or more times), doneFn
 * If the user does not drag enough, prepFn and clickFn will fire.
 *
 * Note: If you cancel contextmenu, clickFn will fire even with a right click
 * (unlike native events) so you'll get a `plotly_click` event. Cancel context eg:
 *    gd.addEventListener('contextmenu', function(e) { e.preventDefault(); });
 * TODO: we should probably turn this into a `config` parameter, so we can fix it
 * such that if you *don't* cancel contextmenu, we can prevent partial drags, which
 * put you in a weird state.
 *
 * If the user clicks multiple times quickly, clickFn will fire each time
 * but numClicks will increase to help you recognize doubleclicks.
 *
 * @param {object} options with keys:
 *      element (required) the DOM element to drag
 *      prepFn (optional) function(event, startX, startY)
 *          executed on mousedown
 *          startX and startY are the clientX and clientY pixel position
 *          of the mousedown event
 *      moveFn (optional) function(dx, dy)
 *          executed on move, ONLY after we've exceeded MINDRAG
 *          (we keep executing moveFn if you move back to where you started)
 *          dx and dy are the net pixel offset of the drag,
 *          dragged is true/false, has the mouse moved enough to
 *          constitute a drag
 *      doneFn (optional) function(e)
 *          executed on mouseup, ONLY if we exceeded MINDRAG (so you can be
 *          sure that moveFn has been called at least once)
 *          numClicks is how many clicks we've registered within
 *          a doubleclick time
 *          e is the original mouseup event
 *      clickFn (optional) function(numClicks, e)
 *          executed on mouseup if we have NOT exceeded MINDRAG (ie moveFn
 *          has not been called at all)
 *          numClicks is how many clicks we've registered within
 *          a doubleclick time
 *          e is the original mousedown event
 *      clampFn (optional, function(dx, dy) return [dx2, dy2])
 *          Provide custom clamping function for small displacements.
 *          By default, clamping is done using `minDrag` to x and y displacements
 *          independently.
 */
dragElement.init = function init(options) {
  var gd = options.gd;
  var numClicks = 1;
  var doubleClickDelay = gd._context.doubleClickDelay;
  var element = options.element;
  var startX, startY, newMouseDownTime, cursor, dragCover, initialEvent, initialTarget, rightClick;
  if (!gd._mouseDownTime) gd._mouseDownTime = 0;
  element.style.pointerEvents = 'all';
  element.onmousedown = onStart;
  if (!supportsPassive) {
    element.ontouchstart = onStart;
  } else {
    if (element._ontouchstart) {
      element.removeEventListener('touchstart', element._ontouchstart);
    }
    element._ontouchstart = onStart;
    element.addEventListener('touchstart', onStart, {
      passive: false
    });
  }
  function _clampFn(dx, dy, minDrag) {
    if (Math.abs(dx) < minDrag) dx = 0;
    if (Math.abs(dy) < minDrag) dy = 0;
    return [dx, dy];
  }
  var clampFn = options.clampFn || _clampFn;
  function onStart(e) {
    // make dragging and dragged into properties of gd
    // so that others can look at and modify them
    gd._dragged = false;
    gd._dragging = true;
    var offset = pointerOffset(e);
    startX = offset[0];
    startY = offset[1];
    initialTarget = e.target;
    initialEvent = e;
    rightClick = e.buttons === 2 || e.ctrlKey;

    // fix Fx.hover for touch events
    if (typeof e.clientX === 'undefined' && typeof e.clientY === 'undefined') {
      e.clientX = startX;
      e.clientY = startY;
    }
    newMouseDownTime = new Date().getTime();
    if (newMouseDownTime - gd._mouseDownTime < doubleClickDelay) {
      // in a click train
      numClicks += 1;
    } else {
      // new click train
      numClicks = 1;
      gd._mouseDownTime = newMouseDownTime;
    }
    if (options.prepFn) options.prepFn(e, startX, startY);
    if (hasHover && !rightClick) {
      dragCover = coverSlip();
      dragCover.style.cursor = window.getComputedStyle(element).cursor;
    } else if (!hasHover) {
      // document acts as a dragcover for mobile, bc we can't create dragcover dynamically
      dragCover = document;
      cursor = window.getComputedStyle(document.documentElement).cursor;
      document.documentElement.style.cursor = window.getComputedStyle(element).cursor;
    }
    document.addEventListener('mouseup', onDone);
    document.addEventListener('touchend', onDone);
    if (options.dragmode !== false) {
      e.preventDefault();
      document.addEventListener('mousemove', onMove);
      document.addEventListener('touchmove', onMove, {
        passive: false
      });
    }
    return;
  }
  function onMove(e) {
    e.preventDefault();
    var offset = pointerOffset(e);
    var minDrag = options.minDrag || constants.MINDRAG;
    var dxdy = clampFn(offset[0] - startX, offset[1] - startY, minDrag);
    var dx = dxdy[0];
    var dy = dxdy[1];
    if (dx || dy) {
      gd._dragged = true;
      dragElement.unhover(gd, e);
    }
    if (gd._dragged && options.moveFn && !rightClick) {
      gd._dragdata = {
        element: element,
        dx: dx,
        dy: dy
      };
      options.moveFn(dx, dy);
    }
    return;
  }
  function onDone(e) {
    delete gd._dragdata;
    if (options.dragmode !== false) {
      e.preventDefault();
      document.removeEventListener('mousemove', onMove);
      document.removeEventListener('touchmove', onMove);
    }
    document.removeEventListener('mouseup', onDone);
    document.removeEventListener('touchend', onDone);
    if (hasHover) {
      removeElement(dragCover);
    } else if (cursor) {
      dragCover.documentElement.style.cursor = cursor;
      cursor = null;
    }
    if (!gd._dragging) {
      gd._dragged = false;
      return;
    }
    gd._dragging = false;

    // don't count as a dblClick unless the mouseUp is also within
    // the dblclick delay
    if (new Date().getTime() - gd._mouseDownTime > doubleClickDelay) {
      numClicks = Math.max(numClicks - 1, 1);
    }
    if (gd._dragged) {
      if (options.doneFn) options.doneFn();
    } else {
      if (options.clickFn) options.clickFn(numClicks, initialEvent);

      // If we haven't dragged, this should be a click. But because of the
      // coverSlip changing the element, the natural system might not generate one,
      // so we need to make our own. But right clicks don't normally generate
      // click events, only contextmenu events, which happen on mousedown.
      if (!rightClick) {
        var e2;
        try {
          e2 = new MouseEvent('click', e);
        } catch (err) {
          var offset = pointerOffset(e);
          e2 = document.createEvent('MouseEvents');
          e2.initMouseEvent('click', e.bubbles, e.cancelable, e.view, e.detail, e.screenX, e.screenY, offset[0], offset[1], e.ctrlKey, e.altKey, e.shiftKey, e.metaKey, e.button, e.relatedTarget);
        }
        initialTarget.dispatchEvent(e2);
      }
    }
    gd._dragging = false;
    gd._dragged = false;
    return;
  }
};
function coverSlip() {
  var cover = document.createElement('div');
  cover.className = 'dragcover';
  var cStyle = cover.style;
  cStyle.position = 'fixed';
  cStyle.left = 0;
  cStyle.right = 0;
  cStyle.top = 0;
  cStyle.bottom = 0;
  cStyle.zIndex = 999999999;
  cStyle.background = 'none';
  document.body.appendChild(cover);
  return cover;
}
dragElement.coverSlip = coverSlip;
function pointerOffset(e) {
  return mouseOffset(e.changedTouches ? e.changedTouches[0] : e, document.body);
}

/***/ }),

/***/ 2616:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Events = __webpack_require__(5924);
var throttle = __webpack_require__(1200);
var getGraphDiv = (__webpack_require__(2200).getGraphDiv);
var hoverConstants = __webpack_require__(2456);
var unhover = module.exports = {};
unhover.wrapped = function (gd, evt, subplot) {
  gd = getGraphDiv(gd);

  // Important, clear any queued hovers
  if (gd._fullLayout) {
    throttle.clear(gd._fullLayout._uid + hoverConstants.HOVERID);
  }
  unhover.raw(gd, evt, subplot);
};

// remove hover effects on mouse out, and emit unhover event
unhover.raw = function raw(gd, evt) {
  var fullLayout = gd._fullLayout;
  var oldhoverdata = gd._hoverdata;
  if (!evt) evt = {};
  if (evt.target && !gd._dragged && Events.triggerHandler(gd, 'plotly_beforehover', evt) === false) {
    return;
  }
  fullLayout._hoverlayer.selectAll('g').remove();
  fullLayout._hoverlayer.selectAll('line').remove();
  fullLayout._hoverlayer.selectAll('circle').remove();
  gd._hoverdata = undefined;
  if (evt.target && oldhoverdata) {
    gd.emit('plotly_unhover', {
      event: evt,
      points: oldhoverdata
    });
  }
};

/***/ }),

/***/ 8192:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


exports.u = {
  valType: 'string',
  // string type usually doesn't take values... this one should really be
  // a special type or at least a special coercion function, from the GUI
  // you only get these values but elsewhere the user can supply a list of
  // dash lengths in px, and it will be honored
  values: ['solid', 'dot', 'dash', 'longdash', 'dashdot', 'longdashdot'],
  dflt: 'solid',
  editType: 'style'
};
exports.c = {
  shape: {
    valType: 'enumerated',
    values: ['', '/', '\\', 'x', '-', '|', '+', '.'],
    dflt: '',
    arrayOk: true,
    editType: 'style'
  },
  fillmode: {
    valType: 'enumerated',
    values: ['replace', 'overlay'],
    dflt: 'replace',
    editType: 'style'
  },
  bgcolor: {
    valType: 'color',
    arrayOk: true,
    editType: 'style'
  },
  fgcolor: {
    valType: 'color',
    arrayOk: true,
    editType: 'style'
  },
  fgopacity: {
    valType: 'number',
    editType: 'style',
    min: 0,
    max: 1
  },
  size: {
    valType: 'number',
    min: 0,
    dflt: 8,
    arrayOk: true,
    editType: 'style'
  },
  solidity: {
    valType: 'number',
    min: 0,
    max: 1,
    dflt: 0.3,
    arrayOk: true,
    editType: 'style'
  },
  editType: 'style'
};

/***/ }),

/***/ 3616:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var Lib = __webpack_require__(3400);
var numberFormat = Lib.numberFormat;
var isNumeric = __webpack_require__(8248);
var tinycolor = __webpack_require__(9760);
var Registry = __webpack_require__(4040);
var Color = __webpack_require__(6308);
var Colorscale = __webpack_require__(8932);
var strTranslate = Lib.strTranslate;
var svgTextUtils = __webpack_require__(2736);
var xmlnsNamespaces = __webpack_require__(9616);
var alignment = __webpack_require__(4284);
var LINE_SPACING = alignment.LINE_SPACING;
var DESELECTDIM = (__webpack_require__(3448).DESELECTDIM);
var subTypes = __webpack_require__(3028);
var makeBubbleSizeFn = __webpack_require__(7152);
var appendArrayPointValue = (__webpack_require__(624).appendArrayPointValue);
var drawing = module.exports = {};

// -----------------------------------------------------
// styling functions for plot elements
// -----------------------------------------------------

drawing.font = function (s, family, size, color, weight, style, variant) {
  // also allow the form font(s, {family, size, color, weight, style, variant})
  if (Lib.isPlainObject(family)) {
    variant = family.variant;
    style = family.style;
    weight = family.weight;
    color = family.color;
    size = family.size;
    family = family.family;
  }
  if (family) s.style('font-family', family);
  if (size + 1) s.style('font-size', size + 'px');
  if (color) s.call(Color.fill, color);
  if (weight) s.style('font-weight', weight);
  if (style) s.style('font-style', style);
  if (variant) s.style('font-variant', variant);
};

/*
 * Positioning helpers
 * Note: do not use `setPosition` with <text> nodes modified by
 * `svgTextUtils.convertToTspans`. Use `svgTextUtils.positionText`
 * instead, so that <tspan.line> elements get updated to match.
 */
drawing.setPosition = function (s, x, y) {
  s.attr('x', x).attr('y', y);
};
drawing.setSize = function (s, w, h) {
  s.attr('width', w).attr('height', h);
};
drawing.setRect = function (s, x, y, w, h) {
  s.call(drawing.setPosition, x, y).call(drawing.setSize, w, h);
};

/** Translate node
 *
 * @param {object} d : calcdata point item
 * @param {sel} sel : d3 selction of node to translate
 * @param {object} xa : corresponding full xaxis object
 * @param {object} ya : corresponding full yaxis object
 *
 * @return {boolean} :
 *  true if selection got translated
 *  false if selection could not get translated
 */
drawing.translatePoint = function (d, sel, xa, ya) {
  var x = xa.c2p(d.x);
  var y = ya.c2p(d.y);
  if (isNumeric(x) && isNumeric(y) && sel.node()) {
    // for multiline text this works better
    if (sel.node().nodeName === 'text') {
      sel.attr('x', x).attr('y', y);
    } else {
      sel.attr('transform', strTranslate(x, y));
    }
  } else {
    return false;
  }
  return true;
};
drawing.translatePoints = function (s, xa, ya) {
  s.each(function (d) {
    var sel = d3.select(this);
    drawing.translatePoint(d, sel, xa, ya);
  });
};
drawing.hideOutsideRangePoint = function (d, sel, xa, ya, xcalendar, ycalendar) {
  sel.attr('display', xa.isPtWithinRange(d, xcalendar) && ya.isPtWithinRange(d, ycalendar) ? null : 'none');
};
drawing.hideOutsideRangePoints = function (traceGroups, subplot) {
  if (!subplot._hasClipOnAxisFalse) return;
  var xa = subplot.xaxis;
  var ya = subplot.yaxis;
  traceGroups.each(function (d) {
    var trace = d[0].trace;
    var xcalendar = trace.xcalendar;
    var ycalendar = trace.ycalendar;
    var selector = Registry.traceIs(trace, 'bar-like') ? '.bartext' : '.point,.textpoint';
    traceGroups.selectAll(selector).each(function (d) {
      drawing.hideOutsideRangePoint(d, d3.select(this), xa, ya, xcalendar, ycalendar);
    });
  });
};
drawing.crispRound = function (gd, lineWidth, dflt) {
  // for lines that disable antialiasing we want to
  // make sure the width is an integer, and at least 1 if it's nonzero

  if (!lineWidth || !isNumeric(lineWidth)) return dflt || 0;

  // but not for static plots - these don't get antialiased anyway.
  if (gd._context.staticPlot) return lineWidth;
  if (lineWidth < 1) return 1;
  return Math.round(lineWidth);
};
drawing.singleLineStyle = function (d, s, lw, lc, ld) {
  s.style('fill', 'none');
  var line = (((d || [])[0] || {}).trace || {}).line || {};
  var lw1 = lw || line.width || 0;
  var dash = ld || line.dash || '';
  Color.stroke(s, lc || line.color);
  drawing.dashLine(s, dash, lw1);
};
drawing.lineGroupStyle = function (s, lw, lc, ld) {
  s.style('fill', 'none').each(function (d) {
    var line = (((d || [])[0] || {}).trace || {}).line || {};
    var lw1 = lw || line.width || 0;
    var dash = ld || line.dash || '';
    d3.select(this).call(Color.stroke, lc || line.color).call(drawing.dashLine, dash, lw1);
  });
};
drawing.dashLine = function (s, dash, lineWidth) {
  lineWidth = +lineWidth || 0;
  dash = drawing.dashStyle(dash, lineWidth);
  s.style({
    'stroke-dasharray': dash,
    'stroke-width': lineWidth + 'px'
  });
};
drawing.dashStyle = function (dash, lineWidth) {
  lineWidth = +lineWidth || 1;
  var dlw = Math.max(lineWidth, 3);
  if (dash === 'solid') dash = '';else if (dash === 'dot') dash = dlw + 'px,' + dlw + 'px';else if (dash === 'dash') dash = 3 * dlw + 'px,' + 3 * dlw + 'px';else if (dash === 'longdash') dash = 5 * dlw + 'px,' + 5 * dlw + 'px';else if (dash === 'dashdot') {
    dash = 3 * dlw + 'px,' + dlw + 'px,' + dlw + 'px,' + dlw + 'px';
  } else if (dash === 'longdashdot') {
    dash = 5 * dlw + 'px,' + 2 * dlw + 'px,' + dlw + 'px,' + 2 * dlw + 'px';
  }
  // otherwise user wrote the dasharray themselves - leave it be

  return dash;
};
function setFillStyle(sel, trace, gd, forLegend) {
  var markerPattern = trace.fillpattern;
  var fillgradient = trace.fillgradient;
  var patternShape = markerPattern && drawing.getPatternAttr(markerPattern.shape, 0, '');
  if (patternShape) {
    var patternBGColor = drawing.getPatternAttr(markerPattern.bgcolor, 0, null);
    var patternFGColor = drawing.getPatternAttr(markerPattern.fgcolor, 0, null);
    var patternFGOpacity = markerPattern.fgopacity;
    var patternSize = drawing.getPatternAttr(markerPattern.size, 0, 8);
    var patternSolidity = drawing.getPatternAttr(markerPattern.solidity, 0, 0.3);
    var patternID = trace.uid;
    drawing.pattern(sel, 'point', gd, patternID, patternShape, patternSize, patternSolidity, undefined, markerPattern.fillmode, patternBGColor, patternFGColor, patternFGOpacity);
  } else if (fillgradient && fillgradient.type !== 'none') {
    var direction = fillgradient.type;
    var gradientID = 'scatterfill-' + trace.uid;
    if (forLegend) {
      gradientID = 'legendfill-' + trace.uid;
    }
    if (!forLegend && (fillgradient.start !== undefined || fillgradient.stop !== undefined)) {
      var start, stop;
      if (direction === 'horizontal') {
        start = {
          x: fillgradient.start,
          y: 0
        };
        stop = {
          x: fillgradient.stop,
          y: 0
        };
      } else if (direction === 'vertical') {
        start = {
          x: 0,
          y: fillgradient.start
        };
        stop = {
          x: 0,
          y: fillgradient.stop
        };
      }
      start.x = trace._xA.c2p(start.x === undefined ? trace._extremes.x.min[0].val : start.x, true);
      start.y = trace._yA.c2p(start.y === undefined ? trace._extremes.y.min[0].val : start.y, true);
      stop.x = trace._xA.c2p(stop.x === undefined ? trace._extremes.x.max[0].val : stop.x, true);
      stop.y = trace._yA.c2p(stop.y === undefined ? trace._extremes.y.max[0].val : stop.y, true);
      sel.call(gradientWithBounds, gd, gradientID, 'linear', fillgradient.colorscale, 'fill', start, stop, true, false);
    } else {
      if (direction === 'horizontal') {
        direction = direction + 'reversed';
      }
      sel.call(drawing.gradient, gd, gradientID, direction, fillgradient.colorscale, 'fill');
    }
  } else if (trace.fillcolor) {
    sel.call(Color.fill, trace.fillcolor);
  }
}

// Same as fillGroupStyle, except in this case the selection may be a transition
drawing.singleFillStyle = function (sel, gd) {
  var node = d3.select(sel.node());
  var data = node.data();
  var trace = ((data[0] || [])[0] || {}).trace || {};
  setFillStyle(sel, trace, gd, false);
};
drawing.fillGroupStyle = function (s, gd, forLegend) {
  s.style('stroke-width', 0).each(function (d) {
    var shape = d3.select(this);
    // N.B. 'd' won't be a calcdata item when
    // fill !== 'none' on a segment-less and marker-less trace
    if (d[0].trace) {
      setFillStyle(shape, d[0].trace, gd, forLegend);
    }
  });
};
var SYMBOLDEFS = __webpack_require__(1984);
drawing.symbolNames = [];
drawing.symbolFuncs = [];
drawing.symbolBackOffs = [];
drawing.symbolNeedLines = {};
drawing.symbolNoDot = {};
drawing.symbolNoFill = {};
drawing.symbolList = [];
Object.keys(SYMBOLDEFS).forEach(function (k) {
  var symDef = SYMBOLDEFS[k];
  var n = symDef.n;
  drawing.symbolList.push(n, String(n), k, n + 100, String(n + 100), k + '-open');
  drawing.symbolNames[n] = k;
  drawing.symbolFuncs[n] = symDef.f;
  drawing.symbolBackOffs[n] = symDef.backoff || 0;
  if (symDef.needLine) {
    drawing.symbolNeedLines[n] = true;
  }
  if (symDef.noDot) {
    drawing.symbolNoDot[n] = true;
  } else {
    drawing.symbolList.push(n + 200, String(n + 200), k + '-dot', n + 300, String(n + 300), k + '-open-dot');
  }
  if (symDef.noFill) {
    drawing.symbolNoFill[n] = true;
  }
});
var MAXSYMBOL = drawing.symbolNames.length;
// add a dot in the middle of the symbol
var DOTPATH = 'M0,0.5L0.5,0L0,-0.5L-0.5,0Z';
drawing.symbolNumber = function (v) {
  if (isNumeric(v)) {
    v = +v;
  } else if (typeof v === 'string') {
    var vbase = 0;
    if (v.indexOf('-open') > 0) {
      vbase = 100;
      v = v.replace('-open', '');
    }
    if (v.indexOf('-dot') > 0) {
      vbase += 200;
      v = v.replace('-dot', '');
    }
    v = drawing.symbolNames.indexOf(v);
    if (v >= 0) {
      v += vbase;
    }
  }
  return v % 100 >= MAXSYMBOL || v >= 400 ? 0 : Math.floor(Math.max(v, 0));
};
function makePointPath(symbolNumber, r, t, s) {
  var base = symbolNumber % 100;
  return drawing.symbolFuncs[base](r, t, s) + (symbolNumber >= 200 ? DOTPATH : '');
}
var stopFormatter = numberFormat('~f');
var gradientInfo = {
  radial: {
    type: 'radial'
  },
  radialreversed: {
    type: 'radial',
    reversed: true
  },
  horizontal: {
    type: 'linear',
    start: {
      x: 1,
      y: 0
    },
    stop: {
      x: 0,
      y: 0
    }
  },
  horizontalreversed: {
    type: 'linear',
    start: {
      x: 1,
      y: 0
    },
    stop: {
      x: 0,
      y: 0
    },
    reversed: true
  },
  vertical: {
    type: 'linear',
    start: {
      x: 0,
      y: 1
    },
    stop: {
      x: 0,
      y: 0
    }
  },
  verticalreversed: {
    type: 'linear',
    start: {
      x: 0,
      y: 1
    },
    stop: {
      x: 0,
      y: 0
    },
    reversed: true
  }
};

/**
 * gradient: create and apply a gradient fill
 *
 * @param {object} sel: d3 selection to apply this gradient to
 *     You can use `selection.call(Drawing.gradient, ...)`
 * @param {DOM element} gd: the graph div `sel` is part of
 * @param {string} gradientID: a unique (within this plot) identifier
 *     for this gradient, so that we don't create unnecessary definitions
 * @param {string} type: 'radial', 'horizontal', or 'vertical', optionally with
 *     'reversed' at the end. Normally radial goes center to edge,
 *     horizontal goes right to left, and vertical goes bottom to top
 * @param {array} colorscale: as in attribute values, [[fraction, color], ...]
 * @param {string} prop: the property to apply to, 'fill' or 'stroke'
 */
drawing.gradient = function (sel, gd, gradientID, type, colorscale, prop) {
  var info = gradientInfo[type];
  return gradientWithBounds(sel, gd, gradientID, info.type, colorscale, prop, info.start, info.stop, false, info.reversed);
};

/**
 * gradient_with_bounds: create and apply a gradient fill for defined start and stop positions
 *
 * @param {object} sel: d3 selection to apply this gradient to
 *     You can use `selection.call(Drawing.gradient, ...)`
 * @param {DOM element} gd: the graph div `sel` is part of
 * @param {string} gradientID: a unique (within this plot) identifier
 *     for this gradient, so that we don't create unnecessary definitions
 * @param {string} type: 'radial' or 'linear'. Radial goes center to edge,
 *     horizontal goes as defined by start and stop
 * @param {array} colorscale: as in attribute values, [[fraction, color], ...]
 * @param {string} prop: the property to apply to, 'fill' or 'stroke'
 * @param {object} start: start point for linear gradients, { x: number, y: number }.
 *     Ignored if type is 'radial'.
 * @param {object} stop: stop point for linear gradients, { x: number, y: number }.
 *     Ignored if type is 'radial'.
 * @param {boolean} inUserSpace: If true, start and stop give absolute values in the plot.
 *     If false, start and stop are fractions of the traces extent along each axis.
 * @param {boolean} reversed: If true, the gradient is reversed between normal start and stop,
 *     i.e., the colorscale is applied in order from stop to start for linear, from edge
 *     to center for radial gradients.
 */
function gradientWithBounds(sel, gd, gradientID, type, colorscale, prop, start, stop, inUserSpace, reversed) {
  var len = colorscale.length;
  var info;
  if (type === 'linear') {
    info = {
      node: 'linearGradient',
      attrs: {
        x1: start.x,
        y1: start.y,
        x2: stop.x,
        y2: stop.y,
        gradientUnits: inUserSpace ? 'userSpaceOnUse' : 'objectBoundingBox'
      },
      reversed: reversed
    };
  } else if (type === 'radial') {
    info = {
      node: 'radialGradient',
      reversed: reversed
    };
  }
  var colorStops = new Array(len);
  for (var i = 0; i < len; i++) {
    if (info.reversed) {
      colorStops[len - 1 - i] = [stopFormatter((1 - colorscale[i][0]) * 100), colorscale[i][1]];
    } else {
      colorStops[i] = [stopFormatter(colorscale[i][0] * 100), colorscale[i][1]];
    }
  }
  var fullLayout = gd._fullLayout;
  var fullID = 'g' + fullLayout._uid + '-' + gradientID;
  var gradient = fullLayout._defs.select('.gradients').selectAll('#' + fullID).data([type + colorStops.join(';')], Lib.identity);
  gradient.exit().remove();
  gradient.enter().append(info.node).each(function () {
    var el = d3.select(this);
    if (info.attrs) el.attr(info.attrs);
    el.attr('id', fullID);
    var stops = el.selectAll('stop').data(colorStops);
    stops.exit().remove();
    stops.enter().append('stop');
    stops.each(function (d) {
      var tc = tinycolor(d[1]);
      d3.select(this).attr({
        offset: d[0] + '%',
        'stop-color': Color.tinyRGB(tc),
        'stop-opacity': tc.getAlpha()
      });
    });
  });
  sel.style(prop, getFullUrl(fullID, gd)).style(prop + '-opacity', null);
  sel.classed('gradient_filled', true);
}

/**
 * pattern: create and apply a pattern fill
 *
 * @param {object} sel: d3 selection to apply this pattern to
 *     You can use `selection.call(Drawing.pattern, ...)`
 * @param {string} calledBy: option to know the caller component
 * @param {DOM element} gd: the graph div `sel` is part of
 * @param {string} patternID: a unique (within this plot) identifier
 *     for this pattern, so that we don't create unnecessary definitions
 * @param {number} size: size of unit squares for repetition of this pattern
 * @param {number} solidity: how solid lines of this pattern are
 * @param {string} mcc: color when painted with colorscale
 * @param {string} fillmode: fillmode for this pattern
 * @param {string} bgcolor: background color for this pattern
 * @param {string} fgcolor: foreground color for this pattern
 * @param {number} fgopacity: foreground opacity for this pattern
 */
drawing.pattern = function (sel, calledBy, gd, patternID, shape, size, solidity, mcc, fillmode, bgcolor, fgcolor, fgopacity) {
  var isLegend = calledBy === 'legend';
  if (mcc) {
    if (fillmode === 'overlay') {
      bgcolor = mcc;
      fgcolor = Color.contrast(bgcolor);
    } else {
      bgcolor = undefined;
      fgcolor = mcc;
    }
  }
  var fullLayout = gd._fullLayout;
  var fullID = 'p' + fullLayout._uid + '-' + patternID;
  var width, height;

  // linear interpolation
  var linearFn = function (x, x0, x1, y0, y1) {
    return y0 + (y1 - y0) * (x - x0) / (x1 - x0);
  };
  var path, linewidth, radius;
  var patternTag;
  var patternAttrs = {};
  var fgC = tinycolor(fgcolor);
  var fgRGB = Color.tinyRGB(fgC);
  var fgAlpha = fgC.getAlpha();
  var opacity = fgopacity * fgAlpha;
  switch (shape) {
    case '/':
      width = size * Math.sqrt(2);
      height = size * Math.sqrt(2);
      path = 'M-' + width / 4 + ',' + height / 4 + 'l' + width / 2 + ',-' + height / 2 + 'M0,' + height + 'L' + width + ',0' + 'M' + width / 4 * 3 + ',' + height / 4 * 5 + 'l' + width / 2 + ',-' + height / 2;
      linewidth = solidity * size;
      patternTag = 'path';
      patternAttrs = {
        d: path,
        opacity: opacity,
        stroke: fgRGB,
        'stroke-width': linewidth + 'px'
      };
      break;
    case '\\':
      width = size * Math.sqrt(2);
      height = size * Math.sqrt(2);
      path = 'M' + width / 4 * 3 + ',-' + height / 4 + 'l' + width / 2 + ',' + height / 2 + 'M0,0L' + width + ',' + height + 'M-' + width / 4 + ',' + height / 4 * 3 + 'l' + width / 2 + ',' + height / 2;
      linewidth = solidity * size;
      patternTag = 'path';
      patternAttrs = {
        d: path,
        opacity: opacity,
        stroke: fgRGB,
        'stroke-width': linewidth + 'px'
      };
      break;
    case 'x':
      width = size * Math.sqrt(2);
      height = size * Math.sqrt(2);
      path = 'M-' + width / 4 + ',' + height / 4 + 'l' + width / 2 + ',-' + height / 2 + 'M0,' + height + 'L' + width + ',0' + 'M' + width / 4 * 3 + ',' + height / 4 * 5 + 'l' + width / 2 + ',-' + height / 2 + 'M' + width / 4 * 3 + ',-' + height / 4 + 'l' + width / 2 + ',' + height / 2 + 'M0,0L' + width + ',' + height + 'M-' + width / 4 + ',' + height / 4 * 3 + 'l' + width / 2 + ',' + height / 2;
      linewidth = size - size * Math.sqrt(1.0 - solidity);
      patternTag = 'path';
      patternAttrs = {
        d: path,
        opacity: opacity,
        stroke: fgRGB,
        'stroke-width': linewidth + 'px'
      };
      break;
    case '|':
      width = size;
      height = size;
      patternTag = 'path';
      path = 'M' + width / 2 + ',0L' + width / 2 + ',' + height;
      linewidth = solidity * size;
      patternTag = 'path';
      patternAttrs = {
        d: path,
        opacity: opacity,
        stroke: fgRGB,
        'stroke-width': linewidth + 'px'
      };
      break;
    case '-':
      width = size;
      height = size;
      patternTag = 'path';
      path = 'M0,' + height / 2 + 'L' + width + ',' + height / 2;
      linewidth = solidity * size;
      patternTag = 'path';
      patternAttrs = {
        d: path,
        opacity: opacity,
        stroke: fgRGB,
        'stroke-width': linewidth + 'px'
      };
      break;
    case '+':
      width = size;
      height = size;
      patternTag = 'path';
      path = 'M' + width / 2 + ',0L' + width / 2 + ',' + height + 'M0,' + height / 2 + 'L' + width + ',' + height / 2;
      linewidth = size - size * Math.sqrt(1.0 - solidity);
      patternTag = 'path';
      patternAttrs = {
        d: path,
        opacity: opacity,
        stroke: fgRGB,
        'stroke-width': linewidth + 'px'
      };
      break;
    case '.':
      width = size;
      height = size;
      if (solidity < Math.PI / 4) {
        radius = Math.sqrt(solidity * size * size / Math.PI);
      } else {
        radius = linearFn(solidity, Math.PI / 4, 1.0, size / 2, size / Math.sqrt(2));
      }
      patternTag = 'circle';
      patternAttrs = {
        cx: width / 2,
        cy: height / 2,
        r: radius,
        opacity: opacity,
        fill: fgRGB
      };
      break;
  }
  var str = [shape || 'noSh', bgcolor || 'noBg', fgcolor || 'noFg', size, solidity].join(';');
  var pattern = fullLayout._defs.select('.patterns').selectAll('#' + fullID).data([str], Lib.identity);
  pattern.exit().remove();
  pattern.enter().append('pattern').each(function () {
    var el = d3.select(this);
    el.attr({
      id: fullID,
      width: width + 'px',
      height: height + 'px',
      patternUnits: 'userSpaceOnUse',
      // for legends scale down patterns just a bit so that default size (i.e 8) nicely fit in small icons
      patternTransform: isLegend ? 'scale(0.8)' : ''
    });
    if (bgcolor) {
      var bgC = tinycolor(bgcolor);
      var bgRGB = Color.tinyRGB(bgC);
      var bgAlpha = bgC.getAlpha();
      var rects = el.selectAll('rect').data([0]);
      rects.exit().remove();
      rects.enter().append('rect').attr({
        width: width + 'px',
        height: height + 'px',
        fill: bgRGB,
        'fill-opacity': bgAlpha
      });
    }
    var patterns = el.selectAll(patternTag).data([0]);
    patterns.exit().remove();
    patterns.enter().append(patternTag).attr(patternAttrs);
  });
  sel.style('fill', getFullUrl(fullID, gd)).style('fill-opacity', null);
  sel.classed('pattern_filled', true);
};

/*
 * Make the gradients container and clear out any previous gradients.
 * We never collect all the gradients we need in one place,
 * so we can't ever remove gradients that have stopped being useful,
 * except all at once before a full redraw.
 * The upside of this is arbitrary points can share gradient defs
 */
drawing.initGradients = function (gd) {
  var fullLayout = gd._fullLayout;
  var gradientsGroup = Lib.ensureSingle(fullLayout._defs, 'g', 'gradients');
  gradientsGroup.selectAll('linearGradient,radialGradient').remove();
  d3.select(gd).selectAll('.gradient_filled').classed('gradient_filled', false);
};
drawing.initPatterns = function (gd) {
  var fullLayout = gd._fullLayout;
  var patternsGroup = Lib.ensureSingle(fullLayout._defs, 'g', 'patterns');
  patternsGroup.selectAll('pattern').remove();
  d3.select(gd).selectAll('.pattern_filled').classed('pattern_filled', false);
};
drawing.getPatternAttr = function (mp, i, dflt) {
  if (mp && Lib.isArrayOrTypedArray(mp)) {
    return i < mp.length ? mp[i] : dflt;
  }
  return mp;
};
drawing.pointStyle = function (s, trace, gd, pt) {
  if (!s.size()) return;
  var fns = drawing.makePointStyleFns(trace);
  s.each(function (d) {
    drawing.singlePointStyle(d, d3.select(this), trace, fns, gd, pt);
  });
};
drawing.singlePointStyle = function (d, sel, trace, fns, gd, pt) {
  var marker = trace.marker;
  var markerLine = marker.line;
  if (pt && pt.i >= 0 && d.i === undefined) d.i = pt.i;
  sel.style('opacity', fns.selectedOpacityFn ? fns.selectedOpacityFn(d) : d.mo === undefined ? marker.opacity : d.mo);
  if (fns.ms2mrc) {
    var r;

    // handle multi-trace graph edit case
    if (d.ms === 'various' || marker.size === 'various') {
      r = 3;
    } else {
      r = fns.ms2mrc(d.ms);
    }

    // store the calculated size so hover can use it
    d.mrc = r;
    if (fns.selectedSizeFn) {
      r = d.mrc = fns.selectedSizeFn(d);
    }

    // turn the symbol into a sanitized number
    var x = drawing.symbolNumber(d.mx || marker.symbol) || 0;

    // save if this marker is open
    // because that impacts how to handle colors
    d.om = x % 200 >= 100;
    var angle = getMarkerAngle(d, trace);
    var standoff = getMarkerStandoff(d, trace);
    sel.attr('d', makePointPath(x, r, angle, standoff));
  }
  var perPointGradient = false;
  var fillColor, lineColor, lineWidth;

  // 'so' is suspected outliers, for box plots
  if (d.so) {
    lineWidth = markerLine.outlierwidth;
    lineColor = markerLine.outliercolor;
    fillColor = marker.outliercolor;
  } else {
    var markerLineWidth = (markerLine || {}).width;
    lineWidth = (d.mlw + 1 || markerLineWidth + 1 ||
    // TODO: we need the latter for legends... can we get rid of it?
    (d.trace ? (d.trace.marker.line || {}).width : 0) + 1) - 1 || 0;
    if ('mlc' in d) lineColor = d.mlcc = fns.lineScale(d.mlc);
    // weird case: array wasn't long enough to apply to every point
    else if (Lib.isArrayOrTypedArray(markerLine.color)) lineColor = Color.defaultLine;else lineColor = markerLine.color;
    if (Lib.isArrayOrTypedArray(marker.color)) {
      fillColor = Color.defaultLine;
      perPointGradient = true;
    }
    if ('mc' in d) {
      fillColor = d.mcc = fns.markerScale(d.mc);
    } else {
      fillColor = marker.color || marker.colors || 'rgba(0,0,0,0)';
    }
    if (fns.selectedColorFn) {
      fillColor = fns.selectedColorFn(d);
    }
  }
  if (d.om) {
    // open markers can't have zero linewidth, default to 1px,
    // and use fill color as stroke color
    sel.call(Color.stroke, fillColor).style({
      'stroke-width': (lineWidth || 1) + 'px',
      fill: 'none'
    });
  } else {
    sel.style('stroke-width', (d.isBlank ? 0 : lineWidth) + 'px');
    var markerGradient = marker.gradient;
    var gradientType = d.mgt;
    if (gradientType) perPointGradient = true;else gradientType = markerGradient && markerGradient.type;

    // for legend - arrays will propagate through here, but we don't need
    // to treat it as per-point.
    if (Lib.isArrayOrTypedArray(gradientType)) {
      gradientType = gradientType[0];
      if (!gradientInfo[gradientType]) gradientType = 0;
    }
    var markerPattern = marker.pattern;
    var patternShape = markerPattern && drawing.getPatternAttr(markerPattern.shape, d.i, '');
    if (gradientType && gradientType !== 'none') {
      var gradientColor = d.mgc;
      if (gradientColor) perPointGradient = true;else gradientColor = markerGradient.color;
      var gradientID = trace.uid;
      if (perPointGradient) gradientID += '-' + d.i;
      drawing.gradient(sel, gd, gradientID, gradientType, [[0, gradientColor], [1, fillColor]], 'fill');
    } else if (patternShape) {
      var perPointPattern = false;
      var fgcolor = markerPattern.fgcolor;
      if (!fgcolor && pt && pt.color) {
        fgcolor = pt.color;
        perPointPattern = true;
      }
      var patternFGColor = drawing.getPatternAttr(fgcolor, d.i, pt && pt.color || null);
      var patternBGColor = drawing.getPatternAttr(markerPattern.bgcolor, d.i, null);
      var patternFGOpacity = markerPattern.fgopacity;
      var patternSize = drawing.getPatternAttr(markerPattern.size, d.i, 8);
      var patternSolidity = drawing.getPatternAttr(markerPattern.solidity, d.i, 0.3);
      perPointPattern = perPointPattern || d.mcc || Lib.isArrayOrTypedArray(markerPattern.shape) || Lib.isArrayOrTypedArray(markerPattern.bgcolor) || Lib.isArrayOrTypedArray(markerPattern.fgcolor) || Lib.isArrayOrTypedArray(markerPattern.size) || Lib.isArrayOrTypedArray(markerPattern.solidity);
      var patternID = trace.uid;
      if (perPointPattern) patternID += '-' + d.i;
      drawing.pattern(sel, 'point', gd, patternID, patternShape, patternSize, patternSolidity, d.mcc, markerPattern.fillmode, patternBGColor, patternFGColor, patternFGOpacity);
    } else {
      Lib.isArrayOrTypedArray(fillColor) ? Color.fill(sel, fillColor[d.i]) : Color.fill(sel, fillColor);
    }
    if (lineWidth) {
      Color.stroke(sel, lineColor);
    }
  }
};
drawing.makePointStyleFns = function (trace) {
  var out = {};
  var marker = trace.marker;

  // allow array marker and marker line colors to be
  // scaled by given max and min to colorscales
  out.markerScale = drawing.tryColorscale(marker, '');
  out.lineScale = drawing.tryColorscale(marker, 'line');
  if (Registry.traceIs(trace, 'symbols')) {
    out.ms2mrc = subTypes.isBubble(trace) ? makeBubbleSizeFn(trace) : function () {
      return (marker.size || 6) / 2;
    };
  }
  if (trace.selectedpoints) {
    Lib.extendFlat(out, drawing.makeSelectedPointStyleFns(trace));
  }
  return out;
};
drawing.makeSelectedPointStyleFns = function (trace) {
  var out = {};
  var selectedAttrs = trace.selected || {};
  var unselectedAttrs = trace.unselected || {};
  var marker = trace.marker || {};
  var selectedMarker = selectedAttrs.marker || {};
  var unselectedMarker = unselectedAttrs.marker || {};
  var mo = marker.opacity;
  var smo = selectedMarker.opacity;
  var usmo = unselectedMarker.opacity;
  var smoIsDefined = smo !== undefined;
  var usmoIsDefined = usmo !== undefined;
  if (Lib.isArrayOrTypedArray(mo) || smoIsDefined || usmoIsDefined) {
    out.selectedOpacityFn = function (d) {
      var base = d.mo === undefined ? marker.opacity : d.mo;
      if (d.selected) {
        return smoIsDefined ? smo : base;
      } else {
        return usmoIsDefined ? usmo : DESELECTDIM * base;
      }
    };
  }
  var mc = marker.color;
  var smc = selectedMarker.color;
  var usmc = unselectedMarker.color;
  if (smc || usmc) {
    out.selectedColorFn = function (d) {
      var base = d.mcc || mc;
      if (d.selected) {
        return smc || base;
      } else {
        return usmc || base;
      }
    };
  }
  var ms = marker.size;
  var sms = selectedMarker.size;
  var usms = unselectedMarker.size;
  var smsIsDefined = sms !== undefined;
  var usmsIsDefined = usms !== undefined;
  if (Registry.traceIs(trace, 'symbols') && (smsIsDefined || usmsIsDefined)) {
    out.selectedSizeFn = function (d) {
      var base = d.mrc || ms / 2;
      if (d.selected) {
        return smsIsDefined ? sms / 2 : base;
      } else {
        return usmsIsDefined ? usms / 2 : base;
      }
    };
  }
  return out;
};
drawing.makeSelectedTextStyleFns = function (trace) {
  var out = {};
  var selectedAttrs = trace.selected || {};
  var unselectedAttrs = trace.unselected || {};
  var textFont = trace.textfont || {};
  var selectedTextFont = selectedAttrs.textfont || {};
  var unselectedTextFont = unselectedAttrs.textfont || {};
  var tc = textFont.color;
  var stc = selectedTextFont.color;
  var utc = unselectedTextFont.color;
  out.selectedTextColorFn = function (d) {
    var base = d.tc || tc;
    if (d.selected) {
      return stc || base;
    } else {
      if (utc) return utc;else return stc ? base : Color.addOpacity(base, DESELECTDIM);
    }
  };
  return out;
};
drawing.selectedPointStyle = function (s, trace) {
  if (!s.size() || !trace.selectedpoints) return;
  var fns = drawing.makeSelectedPointStyleFns(trace);
  var marker = trace.marker || {};
  var seq = [];
  if (fns.selectedOpacityFn) {
    seq.push(function (pt, d) {
      pt.style('opacity', fns.selectedOpacityFn(d));
    });
  }
  if (fns.selectedColorFn) {
    seq.push(function (pt, d) {
      Color.fill(pt, fns.selectedColorFn(d));
    });
  }
  if (fns.selectedSizeFn) {
    seq.push(function (pt, d) {
      var mx = d.mx || marker.symbol || 0;
      var mrc2 = fns.selectedSizeFn(d);
      pt.attr('d', makePointPath(drawing.symbolNumber(mx), mrc2, getMarkerAngle(d, trace), getMarkerStandoff(d, trace)));

      // save for Drawing.selectedTextStyle
      d.mrc2 = mrc2;
    });
  }
  if (seq.length) {
    s.each(function (d) {
      var pt = d3.select(this);
      for (var i = 0; i < seq.length; i++) {
        seq[i](pt, d);
      }
    });
  }
};
drawing.tryColorscale = function (marker, prefix) {
  var cont = prefix ? Lib.nestedProperty(marker, prefix).get() : marker;
  if (cont) {
    var colorArray = cont.color;
    if ((cont.colorscale || cont._colorAx) && Lib.isArrayOrTypedArray(colorArray)) {
      return Colorscale.makeColorScaleFuncFromTrace(cont);
    }
  }
  return Lib.identity;
};
var TEXTOFFSETSIGN = {
  start: 1,
  end: -1,
  middle: 0,
  bottom: 1,
  top: -1
};
function textPointPosition(s, textPosition, fontSize, markerRadius, dontTouchParent) {
  var group = d3.select(s.node().parentNode);
  var v = textPosition.indexOf('top') !== -1 ? 'top' : textPosition.indexOf('bottom') !== -1 ? 'bottom' : 'middle';
  var h = textPosition.indexOf('left') !== -1 ? 'end' : textPosition.indexOf('right') !== -1 ? 'start' : 'middle';

  // if markers are shown, offset a little more than
  // the nominal marker size
  // ie 2/1.6 * nominal, bcs some markers are a bit bigger
  var r = markerRadius ? markerRadius / 0.8 + 1 : 0;
  var numLines = (svgTextUtils.lineCount(s) - 1) * LINE_SPACING + 1;
  var dx = TEXTOFFSETSIGN[h] * r;
  var dy = fontSize * 0.75 + TEXTOFFSETSIGN[v] * r + (TEXTOFFSETSIGN[v] - 1) * numLines * fontSize / 2;

  // fix the overall text group position
  s.attr('text-anchor', h);
  if (!dontTouchParent) {
    group.attr('transform', strTranslate(dx, dy));
  }
}
function extracTextFontSize(d, trace) {
  var fontSize = d.ts || trace.textfont.size;
  return isNumeric(fontSize) && fontSize > 0 ? fontSize : 0;
}

// draw text at points
drawing.textPointStyle = function (s, trace, gd) {
  if (!s.size()) return;
  var selectedTextColorFn;
  if (trace.selectedpoints) {
    var fns = drawing.makeSelectedTextStyleFns(trace);
    selectedTextColorFn = fns.selectedTextColorFn;
  }
  var texttemplate = trace.texttemplate;
  var fullLayout = gd._fullLayout;
  s.each(function (d) {
    var p = d3.select(this);
    var text = texttemplate ? Lib.extractOption(d, trace, 'txt', 'texttemplate') : Lib.extractOption(d, trace, 'tx', 'text');
    if (!text && text !== 0) {
      p.remove();
      return;
    }
    if (texttemplate) {
      var fn = trace._module.formatLabels;
      var labels = fn ? fn(d, trace, fullLayout) : {};
      var pointValues = {};
      appendArrayPointValue(pointValues, trace, d.i);
      var meta = trace._meta || {};
      text = Lib.texttemplateString(text, labels, fullLayout._d3locale, pointValues, d, meta);
    }
    var pos = d.tp || trace.textposition;
    var fontSize = extracTextFontSize(d, trace);
    var fontColor = selectedTextColorFn ? selectedTextColorFn(d) : d.tc || trace.textfont.color;
    p.call(drawing.font, {
      family: d.tf || trace.textfont.family,
      weight: d.tw || trace.textfont.weight,
      style: d.ty || trace.textfont.style,
      variant: d.tv || trace.textfont.variant,
      size: fontSize,
      color: fontColor
    }).text(text).call(svgTextUtils.convertToTspans, gd).call(textPointPosition, pos, fontSize, d.mrc);
  });
};
drawing.selectedTextStyle = function (s, trace) {
  if (!s.size() || !trace.selectedpoints) return;
  var fns = drawing.makeSelectedTextStyleFns(trace);
  s.each(function (d) {
    var tx = d3.select(this);
    var tc = fns.selectedTextColorFn(d);
    var tp = d.tp || trace.textposition;
    var fontSize = extracTextFontSize(d, trace);
    Color.fill(tx, tc);
    var dontTouchParent = Registry.traceIs(trace, 'bar-like');
    textPointPosition(tx, tp, fontSize, d.mrc2 || d.mrc, dontTouchParent);
  });
};

// generalized Catmull-Rom splines, per
// http://www.cemyuksel.com/research/catmullrom_param/catmullrom.pdf
var CatmullRomExp = 0.5;
drawing.smoothopen = function (pts, smoothness) {
  if (pts.length < 3) {
    return 'M' + pts.join('L');
  }
  var path = 'M' + pts[0];
  var tangents = [];
  var i;
  for (i = 1; i < pts.length - 1; i++) {
    tangents.push(makeTangent(pts[i - 1], pts[i], pts[i + 1], smoothness));
  }
  path += 'Q' + tangents[0][0] + ' ' + pts[1];
  for (i = 2; i < pts.length - 1; i++) {
    path += 'C' + tangents[i - 2][1] + ' ' + tangents[i - 1][0] + ' ' + pts[i];
  }
  path += 'Q' + tangents[pts.length - 3][1] + ' ' + pts[pts.length - 1];
  return path;
};
drawing.smoothclosed = function (pts, smoothness) {
  if (pts.length < 3) {
    return 'M' + pts.join('L') + 'Z';
  }
  var path = 'M' + pts[0];
  var pLast = pts.length - 1;
  var tangents = [makeTangent(pts[pLast], pts[0], pts[1], smoothness)];
  var i;
  for (i = 1; i < pLast; i++) {
    tangents.push(makeTangent(pts[i - 1], pts[i], pts[i + 1], smoothness));
  }
  tangents.push(makeTangent(pts[pLast - 1], pts[pLast], pts[0], smoothness));
  for (i = 1; i <= pLast; i++) {
    path += 'C' + tangents[i - 1][1] + ' ' + tangents[i][0] + ' ' + pts[i];
  }
  path += 'C' + tangents[pLast][1] + ' ' + tangents[0][0] + ' ' + pts[0] + 'Z';
  return path;
};
var lastDrawnX, lastDrawnY;
function roundEnd(pt, isY, isLastPoint) {
  if (isLastPoint) pt = applyBackoff(pt);
  return isY ? roundY(pt[1]) : roundX(pt[0]);
}
function roundX(p) {
  var v = d3.round(p, 2);
  lastDrawnX = v;
  return v;
}
function roundY(p) {
  var v = d3.round(p, 2);
  lastDrawnY = v;
  return v;
}
function makeTangent(prevpt, thispt, nextpt, smoothness) {
  var d1x = prevpt[0] - thispt[0];
  var d1y = prevpt[1] - thispt[1];
  var d2x = nextpt[0] - thispt[0];
  var d2y = nextpt[1] - thispt[1];
  var d1a = Math.pow(d1x * d1x + d1y * d1y, CatmullRomExp / 2);
  var d2a = Math.pow(d2x * d2x + d2y * d2y, CatmullRomExp / 2);
  var numx = (d2a * d2a * d1x - d1a * d1a * d2x) * smoothness;
  var numy = (d2a * d2a * d1y - d1a * d1a * d2y) * smoothness;
  var denom1 = 3 * d2a * (d1a + d2a);
  var denom2 = 3 * d1a * (d1a + d2a);
  return [[roundX(thispt[0] + (denom1 && numx / denom1)), roundY(thispt[1] + (denom1 && numy / denom1))], [roundX(thispt[0] - (denom2 && numx / denom2)), roundY(thispt[1] - (denom2 && numy / denom2))]];
}

// step paths - returns a generator function for paths
// with the given step shape
var STEPPATH = {
  hv: function (p0, p1, isLastPoint) {
    return 'H' + roundX(p1[0]) + 'V' + roundEnd(p1, 1, isLastPoint);
  },
  vh: function (p0, p1, isLastPoint) {
    return 'V' + roundY(p1[1]) + 'H' + roundEnd(p1, 0, isLastPoint);
  },
  hvh: function (p0, p1, isLastPoint) {
    return 'H' + roundX((p0[0] + p1[0]) / 2) + 'V' + roundY(p1[1]) + 'H' + roundEnd(p1, 0, isLastPoint);
  },
  vhv: function (p0, p1, isLastPoint) {
    return 'V' + roundY((p0[1] + p1[1]) / 2) + 'H' + roundX(p1[0]) + 'V' + roundEnd(p1, 1, isLastPoint);
  }
};
var STEPLINEAR = function (p0, p1, isLastPoint) {
  return 'L' + roundEnd(p1, 0, isLastPoint) + ',' + roundEnd(p1, 1, isLastPoint);
};
drawing.steps = function (shape) {
  var onestep = STEPPATH[shape] || STEPLINEAR;
  return function (pts) {
    var path = 'M' + roundX(pts[0][0]) + ',' + roundY(pts[0][1]);
    var len = pts.length;
    for (var i = 1; i < len; i++) {
      path += onestep(pts[i - 1], pts[i], i === len - 1);
    }
    return path;
  };
};
function applyBackoff(pt, start) {
  var backoff = pt.backoff;
  var trace = pt.trace;
  var d = pt.d;
  var i = pt.i;
  if (backoff && trace && trace.marker && trace.marker.angle % 360 === 0 && trace.line && trace.line.shape !== 'spline') {
    var arrayBackoff = Lib.isArrayOrTypedArray(backoff);
    var end = pt;
    var x1 = start ? start[0] : lastDrawnX || 0;
    var y1 = start ? start[1] : lastDrawnY || 0;
    var x2 = end[0];
    var y2 = end[1];
    var dx = x2 - x1;
    var dy = y2 - y1;
    var t = Math.atan2(dy, dx);
    var b = arrayBackoff ? backoff[i] : backoff;
    if (b === 'auto') {
      var endI = end.i;
      if (trace.type === 'scatter') endI--; // Why we need this hack?

      var endMarker = end.marker;
      var endMarkerSymbol = endMarker.symbol;
      if (Lib.isArrayOrTypedArray(endMarkerSymbol)) endMarkerSymbol = endMarkerSymbol[endI];
      var endMarkerSize = endMarker.size;
      if (Lib.isArrayOrTypedArray(endMarkerSize)) endMarkerSize = endMarkerSize[endI];
      b = endMarker ? drawing.symbolBackOffs[drawing.symbolNumber(endMarkerSymbol)] * endMarkerSize : 0;
      b += drawing.getMarkerStandoff(d[endI], trace) || 0;
    }
    var x = x2 - b * Math.cos(t);
    var y = y2 - b * Math.sin(t);
    if ((x <= x2 && x >= x1 || x >= x2 && x <= x1) && (y <= y2 && y >= y1 || y >= y2 && y <= y1)) {
      pt = [x, y];
    }
  }
  return pt;
}
drawing.applyBackoff = applyBackoff;

// off-screen svg render testing element, shared by the whole page
// uses the id 'js-plotly-tester' and stores it in drawing.tester
drawing.makeTester = function () {
  var tester = Lib.ensureSingleById(d3.select('body'), 'svg', 'js-plotly-tester', function (s) {
    s.attr(xmlnsNamespaces.svgAttrs).style({
      position: 'absolute',
      left: '-10000px',
      top: '-10000px',
      width: '9000px',
      height: '9000px',
      'z-index': '1'
    });
  });

  // browsers differ on how they describe the bounding rect of
  // the svg if its contents spill over... so make a 1x1px
  // reference point we can measure off of.
  var testref = Lib.ensureSingle(tester, 'path', 'js-reference-point', function (s) {
    s.attr('d', 'M0,0H1V1H0Z').style({
      'stroke-width': 0,
      fill: 'black'
    });
  });
  drawing.tester = tester;
  drawing.testref = testref;
};

/*
 * use our offscreen tester to get a clientRect for an element,
 * in a reference frame where it isn't translated (or transformed) and
 * its anchor point is at (0,0)
 * always returns a copy of the bbox, so the caller can modify it safely
 *
 * @param {SVGElement} node: the element to measure. If possible this should be
 *   a <text> or MathJax <g> element that's already passed through
 *   `convertToTspans` because in that case we can cache the results, but it's
 *   possible to pass in any svg element.
 *
 * @param {boolean} inTester: is this element already in `drawing.tester`?
 *   If you are measuring a dummy element, rather than one you really intend
 *   to use on the plot, making it in `drawing.tester` in the first place
 *   allows us to test faster because it cuts out cloning and appending it.
 *
 * @param {string} hash: for internal use only, if we already know the cache key
 *   for this element beforehand.
 *
 * @return {object}: a plain object containing the width, height, left, right,
 *   top, and bottom of `node`
 */
drawing.savedBBoxes = {};
var savedBBoxesCount = 0;
var maxSavedBBoxes = 10000;
drawing.bBox = function (node, inTester, hash) {
  /*
   * Cache elements we've already measured so we don't have to
   * remeasure the same thing many times
   * We have a few bBox callers though who pass a node larger than
   * a <text> or a MathJax <g>, such as an axis group containing many labels.
   * These will not generate a hash (unless we figure out an appropriate
   * hash key for them) and thus we will not hash them.
   */
  if (!hash) hash = nodeHash(node);
  var out;
  if (hash) {
    out = drawing.savedBBoxes[hash];
    if (out) return Lib.extendFlat({}, out);
  } else if (node.childNodes.length === 1) {
    /*
     * If we have only one child element, which is itself hashable, make
     * a new hash from this element plus its x,y,transform
     * These bounding boxes *include* x,y,transform - mostly for use by
     * callers trying to avoid overlaps (ie titles)
     */
    var innerNode = node.childNodes[0];
    hash = nodeHash(innerNode);
    if (hash) {
      var x = +innerNode.getAttribute('x') || 0;
      var y = +innerNode.getAttribute('y') || 0;
      var transform = innerNode.getAttribute('transform');
      if (!transform) {
        // in this case, just varying x and y, don't bother caching
        // the final bBox because the alteration is quick.
        var innerBB = drawing.bBox(innerNode, false, hash);
        if (x) {
          innerBB.left += x;
          innerBB.right += x;
        }
        if (y) {
          innerBB.top += y;
          innerBB.bottom += y;
        }
        return innerBB;
      }
      /*
       * else we have a transform - rather than make a complicated
       * (and error-prone and probably slow) transform parser/calculator,
       * just continue on calculating the boundingClientRect of the group
       * and use the new composite hash to cache it.
       * That said, `innerNode.transform.baseVal` is an array of
       * `SVGTransform` objects, that *do* seem to have a nice matrix
       * multiplication interface that we could use to avoid making
       * another getBoundingClientRect call...
       */
      hash += '~' + x + '~' + y + '~' + transform;
      out = drawing.savedBBoxes[hash];
      if (out) return Lib.extendFlat({}, out);
    }
  }
  var testNode, tester;
  if (inTester) {
    testNode = node;
  } else {
    tester = drawing.tester.node();

    // copy the node to test into the tester
    testNode = node.cloneNode(true);
    tester.appendChild(testNode);
  }

  // standardize its position (and newline tspans if any)
  d3.select(testNode).attr('transform', null).call(svgTextUtils.positionText, 0, 0);
  var testRect = testNode.getBoundingClientRect();
  var refRect = drawing.testref.node().getBoundingClientRect();
  if (!inTester) tester.removeChild(testNode);
  var bb = {
    height: testRect.height,
    width: testRect.width,
    left: testRect.left - refRect.left,
    top: testRect.top - refRect.top,
    right: testRect.right - refRect.left,
    bottom: testRect.bottom - refRect.top
  };

  // make sure we don't have too many saved boxes,
  // or a long session could overload on memory
  // by saving boxes for long-gone elements
  if (savedBBoxesCount >= maxSavedBBoxes) {
    drawing.savedBBoxes = {};
    savedBBoxesCount = 0;
  }

  // cache this bbox
  if (hash) drawing.savedBBoxes[hash] = bb;
  savedBBoxesCount++;
  return Lib.extendFlat({}, bb);
};

// capture everything about a node (at least in our usage) that
// impacts its bounding box, given that bBox clears x, y, and transform
function nodeHash(node) {
  var inputText = node.getAttribute('data-unformatted');
  if (inputText === null) return;
  return inputText + node.getAttribute('data-math') + node.getAttribute('text-anchor') + node.getAttribute('style');
}

/**
 * Set clipPath URL in a way that work for all situations.
 *
 * In details, graphs on pages with <base> HTML tags need to prepend
 * the clip path ids with the page's base url EXCEPT during toImage exports.
 *
 * @param {d3 selection} s : node to add clip-path attribute
 * @param {string} localId : local clip-path (w/o base url) id
 * @param {DOM element || object} gd
 * - context._baseUrl {string}
 * - context._exportedPlot {boolean}
 */
drawing.setClipUrl = function (s, localId, gd) {
  s.attr('clip-path', getFullUrl(localId, gd));
};
function getFullUrl(localId, gd) {
  if (!localId) return null;
  var context = gd._context;
  var baseUrl = context._exportedPlot ? '' : context._baseUrl || '';
  return baseUrl ? 'url(\'' + baseUrl + '#' + localId + '\')' : 'url(#' + localId + ')';
}
drawing.getTranslate = function (element) {
  // Note the separator [^\d] between x and y in this regex
  // We generally use ',' but IE will convert it to ' '
  var re = /.*\btranslate\((-?\d*\.?\d*)[^-\d]*(-?\d*\.?\d*)[^\d].*/;
  var getter = element.attr ? 'attr' : 'getAttribute';
  var transform = element[getter]('transform') || '';
  var translate = transform.replace(re, function (match, p1, p2) {
    return [p1, p2].join(' ');
  }).split(' ');
  return {
    x: +translate[0] || 0,
    y: +translate[1] || 0
  };
};
drawing.setTranslate = function (element, x, y) {
  var re = /(\btranslate\(.*?\);?)/;
  var getter = element.attr ? 'attr' : 'getAttribute';
  var setter = element.attr ? 'attr' : 'setAttribute';
  var transform = element[getter]('transform') || '';
  x = x || 0;
  y = y || 0;
  transform = transform.replace(re, '').trim();
  transform += strTranslate(x, y);
  transform = transform.trim();
  element[setter]('transform', transform);
  return transform;
};
drawing.getScale = function (element) {
  var re = /.*\bscale\((\d*\.?\d*)[^\d]*(\d*\.?\d*)[^\d].*/;
  var getter = element.attr ? 'attr' : 'getAttribute';
  var transform = element[getter]('transform') || '';
  var translate = transform.replace(re, function (match, p1, p2) {
    return [p1, p2].join(' ');
  }).split(' ');
  return {
    x: +translate[0] || 1,
    y: +translate[1] || 1
  };
};
drawing.setScale = function (element, x, y) {
  var re = /(\bscale\(.*?\);?)/;
  var getter = element.attr ? 'attr' : 'getAttribute';
  var setter = element.attr ? 'attr' : 'setAttribute';
  var transform = element[getter]('transform') || '';
  x = x || 1;
  y = y || 1;
  transform = transform.replace(re, '').trim();
  transform += 'scale(' + x + ',' + y + ')';
  transform = transform.trim();
  element[setter]('transform', transform);
  return transform;
};
var SCALE_RE = /\s*sc.*/;
drawing.setPointGroupScale = function (selection, xScale, yScale) {
  xScale = xScale || 1;
  yScale = yScale || 1;
  if (!selection) return;

  // The same scale transform for every point:
  var scale = xScale === 1 && yScale === 1 ? '' : 'scale(' + xScale + ',' + yScale + ')';
  selection.each(function () {
    var t = (this.getAttribute('transform') || '').replace(SCALE_RE, '');
    t += scale;
    t = t.trim();
    this.setAttribute('transform', t);
  });
};
var TEXT_POINT_LAST_TRANSLATION_RE = /translate\([^)]*\)\s*$/;
drawing.setTextPointsScale = function (selection, xScale, yScale) {
  if (!selection) return;
  selection.each(function () {
    var transforms;
    var el = d3.select(this);
    var text = el.select('text');
    if (!text.node()) return;
    var x = parseFloat(text.attr('x') || 0);
    var y = parseFloat(text.attr('y') || 0);
    var existingTransform = (el.attr('transform') || '').match(TEXT_POINT_LAST_TRANSLATION_RE);
    if (xScale === 1 && yScale === 1) {
      transforms = [];
    } else {
      transforms = [strTranslate(x, y), 'scale(' + xScale + ',' + yScale + ')', strTranslate(-x, -y)];
    }
    if (existingTransform) {
      transforms.push(existingTransform);
    }
    el.attr('transform', transforms.join(''));
  });
};
function getMarkerStandoff(d, trace) {
  var standoff;
  if (d) standoff = d.mf;
  if (standoff === undefined) {
    standoff = trace.marker ? trace.marker.standoff || 0 : 0;
  }
  if (!trace._geo && !trace._xA) {
    // case of legends
    return -standoff;
  }
  return standoff;
}
drawing.getMarkerStandoff = getMarkerStandoff;
var atan2 = Math.atan2;
var cos = Math.cos;
var sin = Math.sin;
function rotate(t, xy) {
  var x = xy[0];
  var y = xy[1];
  return [x * cos(t) - y * sin(t), x * sin(t) + y * cos(t)];
}
var previousLon;
var previousLat;
var previousX;
var previousY;
var previousI;
var previousTraceUid;
function getMarkerAngle(d, trace) {
  var angle = d.ma;
  if (angle === undefined) {
    angle = trace.marker.angle;
    if (!angle || Lib.isArrayOrTypedArray(angle)) {
      angle = 0;
    }
  }
  var x, y;
  var ref = trace.marker.angleref;
  if (ref === 'previous' || ref === 'north') {
    if (trace._geo) {
      var p = trace._geo.project(d.lonlat);
      x = p[0];
      y = p[1];
    } else {
      var xa = trace._xA;
      var ya = trace._yA;
      if (xa && ya) {
        x = xa.c2p(d.x);
        y = ya.c2p(d.y);
      } else {
        // case of legends
        return 90;
      }
    }
    if (trace._geo) {
      var lon = d.lonlat[0];
      var lat = d.lonlat[1];
      var north = trace._geo.project([lon, lat + 1e-5 // epsilon
      ]);

      var east = trace._geo.project([lon + 1e-5,
      // epsilon
      lat]);
      var u = atan2(east[1] - y, east[0] - x);
      var v = atan2(north[1] - y, north[0] - x);
      var t;
      if (ref === 'north') {
        t = angle / 180 * Math.PI;
        // To use counter-clockwise angles i.e.
        // East: 90, West: -90
        // to facilitate wind visualisations
        // in future we should use t = -t here.
      } else if (ref === 'previous') {
        var lon1 = lon / 180 * Math.PI;
        var lat1 = lat / 180 * Math.PI;
        var lon2 = previousLon / 180 * Math.PI;
        var lat2 = previousLat / 180 * Math.PI;
        var dLon = lon2 - lon1;
        var deltaY = cos(lat2) * sin(dLon);
        var deltaX = sin(lat2) * cos(lat1) - cos(lat2) * sin(lat1) * cos(dLon);
        t = -atan2(deltaY, deltaX) - Math.PI;
        previousLon = lon;
        previousLat = lat;
      }
      var A = rotate(u, [cos(t), 0]);
      var B = rotate(v, [sin(t), 0]);
      angle = atan2(A[1] + B[1], A[0] + B[0]) / Math.PI * 180;
      if (ref === 'previous' && !(previousTraceUid === trace.uid && d.i === previousI + 1)) {
        angle = null;
      }
    }
    if (ref === 'previous' && !trace._geo) {
      if (previousTraceUid === trace.uid && d.i === previousI + 1 && isNumeric(x) && isNumeric(y)) {
        var dX = x - previousX;
        var dY = y - previousY;
        var shape = trace.line ? trace.line.shape || '' : '';
        var lastShapeChar = shape.slice(shape.length - 1);
        if (lastShapeChar === 'h') dY = 0;
        if (lastShapeChar === 'v') dX = 0;
        angle += atan2(dY, dX) / Math.PI * 180 + 90;
      } else {
        angle = null;
      }
    }
  }
  previousX = x;
  previousY = y;
  previousI = d.i;
  previousTraceUid = trace.uid;
  return angle;
}
drawing.getMarkerAngle = getMarkerAngle;

/***/ }),

/***/ 1984:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var parseSvgPath = __webpack_require__(9604);
var round = (__webpack_require__(3428).round);

/** Marker symbol definitions
 * users can specify markers either by number or name
 * add 100 (or '-open') and you get an open marker
 *  open markers have no fill and use line color as the stroke color
 * add 200 (or '-dot') and you get a dot in the middle
 * add both and you get both
 */

var emptyPath = 'M0,0Z';
var sqrt2 = Math.sqrt(2);
var sqrt3 = Math.sqrt(3);
var PI = Math.PI;
var cos = Math.cos;
var sin = Math.sin;
module.exports = {
  circle: {
    n: 0,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rs = round(r, 2);
      var circle = 'M' + rs + ',0A' + rs + ',' + rs + ' 0 1,1 0,-' + rs + 'A' + rs + ',' + rs + ' 0 0,1 ' + rs + ',0Z';
      return standoff ? align(angle, standoff, circle) : circle;
    }
  },
  square: {
    n: 1,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rs = round(r, 2);
      return align(angle, standoff, 'M' + rs + ',' + rs + 'H-' + rs + 'V-' + rs + 'H' + rs + 'Z');
    }
  },
  diamond: {
    n: 2,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rd = round(r * 1.3, 2);
      return align(angle, standoff, 'M' + rd + ',0L0,' + rd + 'L-' + rd + ',0L0,-' + rd + 'Z');
    }
  },
  cross: {
    n: 3,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rc = round(r * 0.4, 2);
      var rc2 = round(r * 1.2, 2);
      return align(angle, standoff, 'M' + rc2 + ',' + rc + 'H' + rc + 'V' + rc2 + 'H-' + rc + 'V' + rc + 'H-' + rc2 + 'V-' + rc + 'H-' + rc + 'V-' + rc2 + 'H' + rc + 'V-' + rc + 'H' + rc2 + 'Z');
    }
  },
  x: {
    n: 4,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rx = round(r * 0.8 / sqrt2, 2);
      var ne = 'l' + rx + ',' + rx;
      var se = 'l' + rx + ',-' + rx;
      var sw = 'l-' + rx + ',-' + rx;
      var nw = 'l-' + rx + ',' + rx;
      return align(angle, standoff, 'M0,' + rx + ne + se + sw + se + sw + nw + sw + nw + ne + nw + ne + 'Z');
    }
  },
  'triangle-up': {
    n: 5,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rt = round(r * 2 / sqrt3, 2);
      var r2 = round(r / 2, 2);
      var rs = round(r, 2);
      return align(angle, standoff, 'M-' + rt + ',' + r2 + 'H' + rt + 'L0,-' + rs + 'Z');
    }
  },
  'triangle-down': {
    n: 6,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rt = round(r * 2 / sqrt3, 2);
      var r2 = round(r / 2, 2);
      var rs = round(r, 2);
      return align(angle, standoff, 'M-' + rt + ',-' + r2 + 'H' + rt + 'L0,' + rs + 'Z');
    }
  },
  'triangle-left': {
    n: 7,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rt = round(r * 2 / sqrt3, 2);
      var r2 = round(r / 2, 2);
      var rs = round(r, 2);
      return align(angle, standoff, 'M' + r2 + ',-' + rt + 'V' + rt + 'L-' + rs + ',0Z');
    }
  },
  'triangle-right': {
    n: 8,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rt = round(r * 2 / sqrt3, 2);
      var r2 = round(r / 2, 2);
      var rs = round(r, 2);
      return align(angle, standoff, 'M-' + r2 + ',-' + rt + 'V' + rt + 'L' + rs + ',0Z');
    }
  },
  'triangle-ne': {
    n: 9,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var r1 = round(r * 0.6, 2);
      var r2 = round(r * 1.2, 2);
      return align(angle, standoff, 'M-' + r2 + ',-' + r1 + 'H' + r1 + 'V' + r2 + 'Z');
    }
  },
  'triangle-se': {
    n: 10,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var r1 = round(r * 0.6, 2);
      var r2 = round(r * 1.2, 2);
      return align(angle, standoff, 'M' + r1 + ',-' + r2 + 'V' + r1 + 'H-' + r2 + 'Z');
    }
  },
  'triangle-sw': {
    n: 11,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var r1 = round(r * 0.6, 2);
      var r2 = round(r * 1.2, 2);
      return align(angle, standoff, 'M' + r2 + ',' + r1 + 'H-' + r1 + 'V-' + r2 + 'Z');
    }
  },
  'triangle-nw': {
    n: 12,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var r1 = round(r * 0.6, 2);
      var r2 = round(r * 1.2, 2);
      return align(angle, standoff, 'M-' + r1 + ',' + r2 + 'V-' + r1 + 'H' + r2 + 'Z');
    }
  },
  pentagon: {
    n: 13,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var x1 = round(r * 0.951, 2);
      var x2 = round(r * 0.588, 2);
      var y0 = round(-r, 2);
      var y1 = round(r * -0.309, 2);
      var y2 = round(r * 0.809, 2);
      return align(angle, standoff, 'M' + x1 + ',' + y1 + 'L' + x2 + ',' + y2 + 'H-' + x2 + 'L-' + x1 + ',' + y1 + 'L0,' + y0 + 'Z');
    }
  },
  hexagon: {
    n: 14,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var y0 = round(r, 2);
      var y1 = round(r / 2, 2);
      var x = round(r * sqrt3 / 2, 2);
      return align(angle, standoff, 'M' + x + ',-' + y1 + 'V' + y1 + 'L0,' + y0 + 'L-' + x + ',' + y1 + 'V-' + y1 + 'L0,-' + y0 + 'Z');
    }
  },
  hexagon2: {
    n: 15,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var x0 = round(r, 2);
      var x1 = round(r / 2, 2);
      var y = round(r * sqrt3 / 2, 2);
      return align(angle, standoff, 'M-' + x1 + ',' + y + 'H' + x1 + 'L' + x0 + ',0L' + x1 + ',-' + y + 'H-' + x1 + 'L-' + x0 + ',0Z');
    }
  },
  octagon: {
    n: 16,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var a = round(r * 0.924, 2);
      var b = round(r * 0.383, 2);
      return align(angle, standoff, 'M-' + b + ',-' + a + 'H' + b + 'L' + a + ',-' + b + 'V' + b + 'L' + b + ',' + a + 'H-' + b + 'L-' + a + ',' + b + 'V-' + b + 'Z');
    }
  },
  star: {
    n: 17,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rs = r * 1.4;
      var x1 = round(rs * 0.225, 2);
      var x2 = round(rs * 0.951, 2);
      var x3 = round(rs * 0.363, 2);
      var x4 = round(rs * 0.588, 2);
      var y0 = round(-rs, 2);
      var y1 = round(rs * -0.309, 2);
      var y3 = round(rs * 0.118, 2);
      var y4 = round(rs * 0.809, 2);
      var y5 = round(rs * 0.382, 2);
      return align(angle, standoff, 'M' + x1 + ',' + y1 + 'H' + x2 + 'L' + x3 + ',' + y3 + 'L' + x4 + ',' + y4 + 'L0,' + y5 + 'L-' + x4 + ',' + y4 + 'L-' + x3 + ',' + y3 + 'L-' + x2 + ',' + y1 + 'H-' + x1 + 'L0,' + y0 + 'Z');
    }
  },
  hexagram: {
    n: 18,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var y = round(r * 0.66, 2);
      var x1 = round(r * 0.38, 2);
      var x2 = round(r * 0.76, 2);
      return align(angle, standoff, 'M-' + x2 + ',0l-' + x1 + ',-' + y + 'h' + x2 + 'l' + x1 + ',-' + y + 'l' + x1 + ',' + y + 'h' + x2 + 'l-' + x1 + ',' + y + 'l' + x1 + ',' + y + 'h-' + x2 + 'l-' + x1 + ',' + y + 'l-' + x1 + ',-' + y + 'h-' + x2 + 'Z');
    }
  },
  'star-triangle-up': {
    n: 19,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var x = round(r * sqrt3 * 0.8, 2);
      var y1 = round(r * 0.8, 2);
      var y2 = round(r * 1.6, 2);
      var rc = round(r * 4, 2);
      var aPart = 'A ' + rc + ',' + rc + ' 0 0 1 ';
      return align(angle, standoff, 'M-' + x + ',' + y1 + aPart + x + ',' + y1 + aPart + '0,-' + y2 + aPart + '-' + x + ',' + y1 + 'Z');
    }
  },
  'star-triangle-down': {
    n: 20,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var x = round(r * sqrt3 * 0.8, 2);
      var y1 = round(r * 0.8, 2);
      var y2 = round(r * 1.6, 2);
      var rc = round(r * 4, 2);
      var aPart = 'A ' + rc + ',' + rc + ' 0 0 1 ';
      return align(angle, standoff, 'M' + x + ',-' + y1 + aPart + '-' + x + ',-' + y1 + aPart + '0,' + y2 + aPart + x + ',-' + y1 + 'Z');
    }
  },
  'star-square': {
    n: 21,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rp = round(r * 1.1, 2);
      var rc = round(r * 2, 2);
      var aPart = 'A ' + rc + ',' + rc + ' 0 0 1 ';
      return align(angle, standoff, 'M-' + rp + ',-' + rp + aPart + '-' + rp + ',' + rp + aPart + rp + ',' + rp + aPart + rp + ',-' + rp + aPart + '-' + rp + ',-' + rp + 'Z');
    }
  },
  'star-diamond': {
    n: 22,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rp = round(r * 1.4, 2);
      var rc = round(r * 1.9, 2);
      var aPart = 'A ' + rc + ',' + rc + ' 0 0 1 ';
      return align(angle, standoff, 'M-' + rp + ',0' + aPart + '0,' + rp + aPart + rp + ',0' + aPart + '0,-' + rp + aPart + '-' + rp + ',0' + 'Z');
    }
  },
  'diamond-tall': {
    n: 23,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var x = round(r * 0.7, 2);
      var y = round(r * 1.4, 2);
      return align(angle, standoff, 'M0,' + y + 'L' + x + ',0L0,-' + y + 'L-' + x + ',0Z');
    }
  },
  'diamond-wide': {
    n: 24,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var x = round(r * 1.4, 2);
      var y = round(r * 0.7, 2);
      return align(angle, standoff, 'M0,' + y + 'L' + x + ',0L0,-' + y + 'L-' + x + ',0Z');
    }
  },
  hourglass: {
    n: 25,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rs = round(r, 2);
      return align(angle, standoff, 'M' + rs + ',' + rs + 'H-' + rs + 'L' + rs + ',-' + rs + 'H-' + rs + 'Z');
    },
    noDot: true
  },
  bowtie: {
    n: 26,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rs = round(r, 2);
      return align(angle, standoff, 'M' + rs + ',' + rs + 'V-' + rs + 'L-' + rs + ',' + rs + 'V-' + rs + 'Z');
    },
    noDot: true
  },
  'circle-cross': {
    n: 27,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rs = round(r, 2);
      return align(angle, standoff, 'M0,' + rs + 'V-' + rs + 'M' + rs + ',0H-' + rs + 'M' + rs + ',0A' + rs + ',' + rs + ' 0 1,1 0,-' + rs + 'A' + rs + ',' + rs + ' 0 0,1 ' + rs + ',0Z');
    },
    needLine: true,
    noDot: true
  },
  'circle-x': {
    n: 28,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rs = round(r, 2);
      var rc = round(r / sqrt2, 2);
      return align(angle, standoff, 'M' + rc + ',' + rc + 'L-' + rc + ',-' + rc + 'M' + rc + ',-' + rc + 'L-' + rc + ',' + rc + 'M' + rs + ',0A' + rs + ',' + rs + ' 0 1,1 0,-' + rs + 'A' + rs + ',' + rs + ' 0 0,1 ' + rs + ',0Z');
    },
    needLine: true,
    noDot: true
  },
  'square-cross': {
    n: 29,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rs = round(r, 2);
      return align(angle, standoff, 'M0,' + rs + 'V-' + rs + 'M' + rs + ',0H-' + rs + 'M' + rs + ',' + rs + 'H-' + rs + 'V-' + rs + 'H' + rs + 'Z');
    },
    needLine: true,
    noDot: true
  },
  'square-x': {
    n: 30,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rs = round(r, 2);
      return align(angle, standoff, 'M' + rs + ',' + rs + 'L-' + rs + ',-' + rs + 'M' + rs + ',-' + rs + 'L-' + rs + ',' + rs + 'M' + rs + ',' + rs + 'H-' + rs + 'V-' + rs + 'H' + rs + 'Z');
    },
    needLine: true,
    noDot: true
  },
  'diamond-cross': {
    n: 31,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rd = round(r * 1.3, 2);
      return align(angle, standoff, 'M' + rd + ',0L0,' + rd + 'L-' + rd + ',0L0,-' + rd + 'Z' + 'M0,-' + rd + 'V' + rd + 'M-' + rd + ',0H' + rd);
    },
    needLine: true,
    noDot: true
  },
  'diamond-x': {
    n: 32,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rd = round(r * 1.3, 2);
      var r2 = round(r * 0.65, 2);
      return align(angle, standoff, 'M' + rd + ',0L0,' + rd + 'L-' + rd + ',0L0,-' + rd + 'Z' + 'M-' + r2 + ',-' + r2 + 'L' + r2 + ',' + r2 + 'M-' + r2 + ',' + r2 + 'L' + r2 + ',-' + r2);
    },
    needLine: true,
    noDot: true
  },
  'cross-thin': {
    n: 33,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rc = round(r * 1.4, 2);
      return align(angle, standoff, 'M0,' + rc + 'V-' + rc + 'M' + rc + ',0H-' + rc);
    },
    needLine: true,
    noDot: true,
    noFill: true
  },
  'x-thin': {
    n: 34,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rx = round(r, 2);
      return align(angle, standoff, 'M' + rx + ',' + rx + 'L-' + rx + ',-' + rx + 'M' + rx + ',-' + rx + 'L-' + rx + ',' + rx);
    },
    needLine: true,
    noDot: true,
    noFill: true
  },
  asterisk: {
    n: 35,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rc = round(r * 1.2, 2);
      var rs = round(r * 0.85, 2);
      return align(angle, standoff, 'M0,' + rc + 'V-' + rc + 'M' + rc + ',0H-' + rc + 'M' + rs + ',' + rs + 'L-' + rs + ',-' + rs + 'M' + rs + ',-' + rs + 'L-' + rs + ',' + rs);
    },
    needLine: true,
    noDot: true,
    noFill: true
  },
  hash: {
    n: 36,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var r1 = round(r / 2, 2);
      var r2 = round(r, 2);
      return align(angle, standoff, 'M' + r1 + ',' + r2 + 'V-' + r2 + 'M' + (r1 - r2) + ',-' + r2 + 'V' + r2 + 'M' + r2 + ',' + r1 + 'H-' + r2 + 'M-' + r2 + ',' + (r1 - r2) + 'H' + r2);
    },
    needLine: true,
    noFill: true
  },
  'y-up': {
    n: 37,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var x = round(r * 1.2, 2);
      var y0 = round(r * 1.6, 2);
      var y1 = round(r * 0.8, 2);
      return align(angle, standoff, 'M-' + x + ',' + y1 + 'L0,0M' + x + ',' + y1 + 'L0,0M0,-' + y0 + 'L0,0');
    },
    needLine: true,
    noDot: true,
    noFill: true
  },
  'y-down': {
    n: 38,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var x = round(r * 1.2, 2);
      var y0 = round(r * 1.6, 2);
      var y1 = round(r * 0.8, 2);
      return align(angle, standoff, 'M-' + x + ',-' + y1 + 'L0,0M' + x + ',-' + y1 + 'L0,0M0,' + y0 + 'L0,0');
    },
    needLine: true,
    noDot: true,
    noFill: true
  },
  'y-left': {
    n: 39,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var y = round(r * 1.2, 2);
      var x0 = round(r * 1.6, 2);
      var x1 = round(r * 0.8, 2);
      return align(angle, standoff, 'M' + x1 + ',' + y + 'L0,0M' + x1 + ',-' + y + 'L0,0M-' + x0 + ',0L0,0');
    },
    needLine: true,
    noDot: true,
    noFill: true
  },
  'y-right': {
    n: 40,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var y = round(r * 1.2, 2);
      var x0 = round(r * 1.6, 2);
      var x1 = round(r * 0.8, 2);
      return align(angle, standoff, 'M-' + x1 + ',' + y + 'L0,0M-' + x1 + ',-' + y + 'L0,0M' + x0 + ',0L0,0');
    },
    needLine: true,
    noDot: true,
    noFill: true
  },
  'line-ew': {
    n: 41,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rc = round(r * 1.4, 2);
      return align(angle, standoff, 'M' + rc + ',0H-' + rc);
    },
    needLine: true,
    noDot: true,
    noFill: true
  },
  'line-ns': {
    n: 42,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rc = round(r * 1.4, 2);
      return align(angle, standoff, 'M0,' + rc + 'V-' + rc);
    },
    needLine: true,
    noDot: true,
    noFill: true
  },
  'line-ne': {
    n: 43,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rx = round(r, 2);
      return align(angle, standoff, 'M' + rx + ',-' + rx + 'L-' + rx + ',' + rx);
    },
    needLine: true,
    noDot: true,
    noFill: true
  },
  'line-nw': {
    n: 44,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rx = round(r, 2);
      return align(angle, standoff, 'M' + rx + ',' + rx + 'L-' + rx + ',-' + rx);
    },
    needLine: true,
    noDot: true,
    noFill: true
  },
  'arrow-up': {
    n: 45,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rx = round(r, 2);
      var ry = round(r * 2, 2);
      return align(angle, standoff, 'M0,0L-' + rx + ',' + ry + 'H' + rx + 'Z');
    },
    backoff: 1,
    noDot: true
  },
  'arrow-down': {
    n: 46,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rx = round(r, 2);
      var ry = round(r * 2, 2);
      return align(angle, standoff, 'M0,0L-' + rx + ',-' + ry + 'H' + rx + 'Z');
    },
    noDot: true
  },
  'arrow-left': {
    n: 47,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rx = round(r * 2, 2);
      var ry = round(r, 2);
      return align(angle, standoff, 'M0,0L' + rx + ',-' + ry + 'V' + ry + 'Z');
    },
    noDot: true
  },
  'arrow-right': {
    n: 48,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rx = round(r * 2, 2);
      var ry = round(r, 2);
      return align(angle, standoff, 'M0,0L-' + rx + ',-' + ry + 'V' + ry + 'Z');
    },
    noDot: true
  },
  'arrow-bar-up': {
    n: 49,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rx = round(r, 2);
      var ry = round(r * 2, 2);
      return align(angle, standoff, 'M-' + rx + ',0H' + rx + 'M0,0L-' + rx + ',' + ry + 'H' + rx + 'Z');
    },
    backoff: 1,
    needLine: true,
    noDot: true
  },
  'arrow-bar-down': {
    n: 50,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rx = round(r, 2);
      var ry = round(r * 2, 2);
      return align(angle, standoff, 'M-' + rx + ',0H' + rx + 'M0,0L-' + rx + ',-' + ry + 'H' + rx + 'Z');
    },
    needLine: true,
    noDot: true
  },
  'arrow-bar-left': {
    n: 51,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rx = round(r * 2, 2);
      var ry = round(r, 2);
      return align(angle, standoff, 'M0,-' + ry + 'V' + ry + 'M0,0L' + rx + ',-' + ry + 'V' + ry + 'Z');
    },
    needLine: true,
    noDot: true
  },
  'arrow-bar-right': {
    n: 52,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var rx = round(r * 2, 2);
      var ry = round(r, 2);
      return align(angle, standoff, 'M0,-' + ry + 'V' + ry + 'M0,0L-' + rx + ',-' + ry + 'V' + ry + 'Z');
    },
    needLine: true,
    noDot: true
  },
  arrow: {
    n: 53,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var headAngle = PI / 2.5; // 36 degrees - golden ratio
      var x = 2 * r * cos(headAngle);
      var y = 2 * r * sin(headAngle);
      return align(angle, standoff, 'M0,0' + 'L' + -x + ',' + y + 'L' + x + ',' + y + 'Z');
    },
    backoff: 0.9,
    noDot: true
  },
  'arrow-wide': {
    n: 54,
    f: function (r, angle, standoff) {
      if (skipAngle(angle)) return emptyPath;
      var headAngle = PI / 4; // 90 degrees
      var x = 2 * r * cos(headAngle);
      var y = 2 * r * sin(headAngle);
      return align(angle, standoff, 'M0,0' + 'L' + -x + ',' + y + 'A ' + 2 * r + ',' + 2 * r + ' 0 0 1 ' + x + ',' + y + 'Z');
    },
    backoff: 0.4,
    noDot: true
  }
};
function skipAngle(angle) {
  return angle === null;
}
var lastPathIn, lastPathOut;
var lastAngle, lastStandoff;
function align(angle, standoff, path) {
  if ((!angle || angle % 360 === 0) && !standoff) return path;
  if (lastAngle === angle && lastStandoff === standoff && lastPathIn === path) return lastPathOut;
  lastAngle = angle;
  lastStandoff = standoff;
  lastPathIn = path;
  function rotate(t, xy) {
    var cosT = cos(t);
    var sinT = sin(t);
    var x = xy[0];
    var y = xy[1] + (standoff || 0);
    return [x * cosT - y * sinT, x * sinT + y * cosT];
  }
  var t = angle / 180 * PI;
  var x = 0;
  var y = 0;
  var cmd = parseSvgPath(path);
  var str = '';
  for (var i = 0; i < cmd.length; i++) {
    var cmdI = cmd[i];
    var op = cmdI[0];
    var x0 = x;
    var y0 = y;
    if (op === 'M' || op === 'L') {
      x = +cmdI[1];
      y = +cmdI[2];
    } else if (op === 'm' || op === 'l') {
      x += +cmdI[1];
      y += +cmdI[2];
    } else if (op === 'H') {
      x = +cmdI[1];
    } else if (op === 'h') {
      x += +cmdI[1];
    } else if (op === 'V') {
      y = +cmdI[1];
    } else if (op === 'v') {
      y += +cmdI[1];
    } else if (op === 'A') {
      x = +cmdI[1];
      y = +cmdI[2];
      var E = rotate(t, [+cmdI[6], +cmdI[7]]);
      cmdI[6] = E[0];
      cmdI[7] = E[1];
      cmdI[3] = +cmdI[3] + angle;
    }

    // change from H, V, h, v to L or l
    if (op === 'H' || op === 'V') op = 'L';
    if (op === 'h' || op === 'v') op = 'l';
    if (op === 'm' || op === 'l') {
      x -= x0;
      y -= y0;
    }
    var B = rotate(t, [x, y]);
    if (op === 'H' || op === 'V') op = 'L';
    if (op === 'M' || op === 'L' || op === 'm' || op === 'l') {
      cmdI[1] = B[0];
      cmdI[2] = B[1];
    }
    cmdI[0] = op;
    str += cmdI[0] + cmdI.slice(1).join(',');
  }
  lastPathOut = str;
  return str;
}

/***/ }),

/***/ 7644:
/***/ (function(module) {

"use strict";


module.exports = {
  visible: {
    valType: 'boolean',
    editType: 'calc'
  },
  type: {
    valType: 'enumerated',
    values: ['percent', 'constant', 'sqrt', 'data'],
    editType: 'calc'
  },
  symmetric: {
    valType: 'boolean',
    editType: 'calc'
  },
  array: {
    valType: 'data_array',
    editType: 'calc'
  },
  arrayminus: {
    valType: 'data_array',
    editType: 'calc'
  },
  value: {
    valType: 'number',
    min: 0,
    dflt: 10,
    editType: 'calc'
  },
  valueminus: {
    valType: 'number',
    min: 0,
    dflt: 10,
    editType: 'calc'
  },
  traceref: {
    valType: 'integer',
    min: 0,
    dflt: 0,
    editType: 'style'
  },
  tracerefminus: {
    valType: 'integer',
    min: 0,
    dflt: 0,
    editType: 'style'
  },
  copy_ystyle: {
    valType: 'boolean',
    editType: 'plot'
  },
  copy_zstyle: {
    valType: 'boolean',
    editType: 'style'
  },
  color: {
    valType: 'color',
    editType: 'style'
  },
  thickness: {
    valType: 'number',
    min: 0,
    dflt: 2,
    editType: 'style'
  },
  width: {
    valType: 'number',
    min: 0,
    editType: 'plot'
  },
  editType: 'calc',
  _deprecated: {
    opacity: {
      valType: 'number',
      editType: 'style'
    }
  }
};

/***/ }),

/***/ 4880:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isNumeric = __webpack_require__(8248);
var Registry = __webpack_require__(4040);
var Axes = __webpack_require__(4460);
var Lib = __webpack_require__(3400);
var makeComputeError = __webpack_require__(3792);
module.exports = function calc(gd) {
  var calcdata = gd.calcdata;
  for (var i = 0; i < calcdata.length; i++) {
    var calcTrace = calcdata[i];
    var trace = calcTrace[0].trace;
    if (trace.visible === true && Registry.traceIs(trace, 'errorBarsOK')) {
      var xa = Axes.getFromId(gd, trace.xaxis);
      var ya = Axes.getFromId(gd, trace.yaxis);
      calcOneAxis(calcTrace, trace, xa, 'x');
      calcOneAxis(calcTrace, trace, ya, 'y');
    }
  }
};
function calcOneAxis(calcTrace, trace, axis, coord) {
  var opts = trace['error_' + coord] || {};
  var isVisible = opts.visible && ['linear', 'log'].indexOf(axis.type) !== -1;
  var vals = [];
  if (!isVisible) return;
  var computeError = makeComputeError(opts);
  for (var i = 0; i < calcTrace.length; i++) {
    var calcPt = calcTrace[i];
    var iIn = calcPt.i;

    // for types that don't include `i` in each calcdata point
    if (iIn === undefined) iIn = i;

    // for stacked area inserted points
    // TODO: errorbars have been tested cursorily with stacked area,
    // but not thoroughly. It's not even really clear what you want to do:
    // Should it just be calculated based on that trace's size data?
    // Should you add errors from below in quadrature?
    // And what about normalization, where in principle the errors shrink
    // again when you get up to the top end?
    // One option would be to forbid errorbars with stacking until we
    // decide how to handle these questions.
    else if (iIn === null) continue;
    var calcCoord = calcPt[coord];
    if (!isNumeric(axis.c2l(calcCoord))) continue;
    var errors = computeError(calcCoord, iIn);
    if (isNumeric(errors[0]) && isNumeric(errors[1])) {
      var shoe = calcPt[coord + 's'] = calcCoord - errors[0];
      var hat = calcPt[coord + 'h'] = calcCoord + errors[1];
      vals.push(shoe, hat);
    }
  }
  var axId = axis._id;
  var baseExtremes = trace._extremes[axId];
  var extremes = Axes.findExtremes(axis, vals, Lib.extendFlat({
    tozero: baseExtremes.opts.tozero
  }, {
    padded: true
  }));
  baseExtremes.min = baseExtremes.min.concat(extremes.min);
  baseExtremes.max = baseExtremes.max.concat(extremes.max);
}

/***/ }),

/***/ 3792:
/***/ (function(module) {

"use strict";


/**
 * Error bar computing function generator
 *
 * N.B. The generated function does not clean the dataPt entries. Non-numeric
 * entries result in undefined error magnitudes.
 *
 * @param {object} opts error bar attributes
 *
 * @return {function} :
 *      @param {numeric} dataPt data point from where to compute the error magnitude
 *      @param {number} index index of dataPt in its corresponding data array
 *      @return {array}
 *        - error[0] : error magnitude in the negative direction
 *        - error[1] : " " " " positive "
 */
module.exports = function makeComputeError(opts) {
  var type = opts.type;
  var symmetric = opts.symmetric;
  if (type === 'data') {
    var array = opts.array || [];
    if (symmetric) {
      return function computeError(dataPt, index) {
        var val = +array[index];
        return [val, val];
      };
    } else {
      var arrayminus = opts.arrayminus || [];
      return function computeError(dataPt, index) {
        var val = +array[index];
        var valMinus = +arrayminus[index];
        // in case one is present and the other is missing, fill in 0
        // so we still see the present one. Mostly useful during manual
        // data entry.
        if (!isNaN(val) || !isNaN(valMinus)) {
          return [valMinus || 0, val || 0];
        }
        return [NaN, NaN];
      };
    }
  } else {
    var computeErrorValue = makeComputeErrorValue(type, opts.value);
    var computeErrorValueMinus = makeComputeErrorValue(type, opts.valueminus);
    if (symmetric || opts.valueminus === undefined) {
      return function computeError(dataPt) {
        var val = computeErrorValue(dataPt);
        return [val, val];
      };
    } else {
      return function computeError(dataPt) {
        return [computeErrorValueMinus(dataPt), computeErrorValue(dataPt)];
      };
    }
  }
};

/**
 * Compute error bar magnitude (for all types except data)
 *
 * @param {string} type error bar type
 * @param {numeric} value error bar value
 *
 * @return {function} :
 *      @param {numeric} dataPt
 */
function makeComputeErrorValue(type, value) {
  if (type === 'percent') {
    return function (dataPt) {
      return Math.abs(dataPt * value / 100);
    };
  }
  if (type === 'constant') {
    return function () {
      return Math.abs(value);
    };
  }
  if (type === 'sqrt') {
    return function (dataPt) {
      return Math.sqrt(Math.abs(dataPt));
    };
  }
}

/***/ }),

/***/ 5200:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isNumeric = __webpack_require__(8248);
var Registry = __webpack_require__(4040);
var Lib = __webpack_require__(3400);
var Template = __webpack_require__(1780);
var attributes = __webpack_require__(7644);
module.exports = function (traceIn, traceOut, defaultColor, opts) {
  var objName = 'error_' + opts.axis;
  var containerOut = Template.newContainer(traceOut, objName);
  var containerIn = traceIn[objName] || {};
  function coerce(attr, dflt) {
    return Lib.coerce(containerIn, containerOut, attributes, attr, dflt);
  }
  var hasErrorBars = containerIn.array !== undefined || containerIn.value !== undefined || containerIn.type === 'sqrt';
  var visible = coerce('visible', hasErrorBars);
  if (visible === false) return;
  var type = coerce('type', 'array' in containerIn ? 'data' : 'percent');
  var symmetric = true;
  if (type !== 'sqrt') {
    symmetric = coerce('symmetric', !((type === 'data' ? 'arrayminus' : 'valueminus') in containerIn));
  }
  if (type === 'data') {
    coerce('array');
    coerce('traceref');
    if (!symmetric) {
      coerce('arrayminus');
      coerce('tracerefminus');
    }
  } else if (type === 'percent' || type === 'constant') {
    coerce('value');
    if (!symmetric) coerce('valueminus');
  }
  var copyAttr = 'copy_' + opts.inherit + 'style';
  if (opts.inherit) {
    var inheritObj = traceOut['error_' + opts.inherit];
    if ((inheritObj || {}).visible) {
      coerce(copyAttr, !(containerIn.color || isNumeric(containerIn.thickness) || isNumeric(containerIn.width)));
    }
  }
  if (!opts.inherit || !containerOut[copyAttr]) {
    coerce('color', defaultColor);
    coerce('thickness');
    coerce('width', Registry.traceIs(traceOut, 'gl3d') ? 0 : 4);
  }
};

/***/ }),

/***/ 4968:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var overrideAll = (__webpack_require__(7824).overrideAll);
var attributes = __webpack_require__(7644);
var xyAttrs = {
  error_x: Lib.extendFlat({}, attributes),
  error_y: Lib.extendFlat({}, attributes)
};
delete xyAttrs.error_x.copy_zstyle;
delete xyAttrs.error_y.copy_zstyle;
delete xyAttrs.error_y.copy_ystyle;
var xyzAttrs = {
  error_x: Lib.extendFlat({}, attributes),
  error_y: Lib.extendFlat({}, attributes),
  error_z: Lib.extendFlat({}, attributes)
};
delete xyzAttrs.error_x.copy_ystyle;
delete xyzAttrs.error_y.copy_ystyle;
delete xyzAttrs.error_z.copy_ystyle;
delete xyzAttrs.error_z.copy_zstyle;
module.exports = {
  moduleType: 'component',
  name: 'errorbars',
  schema: {
    traces: {
      scatter: xyAttrs,
      bar: xyAttrs,
      histogram: xyAttrs,
      scatter3d: overrideAll(xyzAttrs, 'calc', 'nested'),
      scattergl: overrideAll(xyAttrs, 'calc', 'nested')
    }
  },
  supplyDefaults: __webpack_require__(5200),
  calc: __webpack_require__(4880),
  makeComputeError: __webpack_require__(3792),
  plot: __webpack_require__(8512),
  style: __webpack_require__(2036),
  hoverInfo: hoverInfo
};
function hoverInfo(calcPoint, trace, hoverPoint) {
  if ((trace.error_y || {}).visible) {
    hoverPoint.yerr = calcPoint.yh - calcPoint.y;
    if (!trace.error_y.symmetric) hoverPoint.yerrneg = calcPoint.y - calcPoint.ys;
  }
  if ((trace.error_x || {}).visible) {
    hoverPoint.xerr = calcPoint.xh - calcPoint.x;
    if (!trace.error_x.symmetric) hoverPoint.xerrneg = calcPoint.x - calcPoint.xs;
  }
}

/***/ }),

/***/ 8512:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var isNumeric = __webpack_require__(8248);
var Drawing = __webpack_require__(3616);
var subTypes = __webpack_require__(3028);
module.exports = function plot(gd, traces, plotinfo, transitionOpts) {
  var isNew;
  var xa = plotinfo.xaxis;
  var ya = plotinfo.yaxis;
  var hasAnimation = transitionOpts && transitionOpts.duration > 0;
  var isStatic = gd._context.staticPlot;
  traces.each(function (d) {
    var trace = d[0].trace;
    // || {} is in case the trace (specifically scatterternary)
    // doesn't support error bars at all, but does go through
    // the scatter.plot mechanics, which calls ErrorBars.plot
    // internally
    var xObj = trace.error_x || {};
    var yObj = trace.error_y || {};
    var keyFunc;
    if (trace.ids) {
      keyFunc = function (d) {
        return d.id;
      };
    }
    var sparse = subTypes.hasMarkers(trace) && trace.marker.maxdisplayed > 0;
    if (!yObj.visible && !xObj.visible) d = [];
    var errorbars = d3.select(this).selectAll('g.errorbar').data(d, keyFunc);
    errorbars.exit().remove();
    if (!d.length) return;
    if (!xObj.visible) errorbars.selectAll('path.xerror').remove();
    if (!yObj.visible) errorbars.selectAll('path.yerror').remove();
    errorbars.style('opacity', 1);
    var enter = errorbars.enter().append('g').classed('errorbar', true);
    if (hasAnimation) {
      enter.style('opacity', 0).transition().duration(transitionOpts.duration).style('opacity', 1);
    }
    Drawing.setClipUrl(errorbars, plotinfo.layerClipId, gd);
    errorbars.each(function (d) {
      var errorbar = d3.select(this);
      var coords = errorCoords(d, xa, ya);
      if (sparse && !d.vis) return;
      var path;
      var yerror = errorbar.select('path.yerror');
      if (yObj.visible && isNumeric(coords.x) && isNumeric(coords.yh) && isNumeric(coords.ys)) {
        var yw = yObj.width;
        path = 'M' + (coords.x - yw) + ',' + coords.yh + 'h' + 2 * yw +
        // hat
        'm-' + yw + ',0V' + coords.ys; // bar

        if (!coords.noYS) path += 'm-' + yw + ',0h' + 2 * yw; // shoe

        isNew = !yerror.size();
        if (isNew) {
          yerror = errorbar.append('path').style('vector-effect', isStatic ? 'none' : 'non-scaling-stroke').classed('yerror', true);
        } else if (hasAnimation) {
          yerror = yerror.transition().duration(transitionOpts.duration).ease(transitionOpts.easing);
        }
        yerror.attr('d', path);
      } else yerror.remove();
      var xerror = errorbar.select('path.xerror');
      if (xObj.visible && isNumeric(coords.y) && isNumeric(coords.xh) && isNumeric(coords.xs)) {
        var xw = (xObj.copy_ystyle ? yObj : xObj).width;
        path = 'M' + coords.xh + ',' + (coords.y - xw) + 'v' + 2 * xw +
        // hat
        'm0,-' + xw + 'H' + coords.xs; // bar

        if (!coords.noXS) path += 'm0,-' + xw + 'v' + 2 * xw; // shoe

        isNew = !xerror.size();
        if (isNew) {
          xerror = errorbar.append('path').style('vector-effect', isStatic ? 'none' : 'non-scaling-stroke').classed('xerror', true);
        } else if (hasAnimation) {
          xerror = xerror.transition().duration(transitionOpts.duration).ease(transitionOpts.easing);
        }
        xerror.attr('d', path);
      } else xerror.remove();
    });
  });
};

// compute the coordinates of the error-bar objects
function errorCoords(d, xa, ya) {
  var out = {
    x: xa.c2p(d.x),
    y: ya.c2p(d.y)
  };

  // calculate the error bar size and hat and shoe locations
  if (d.yh !== undefined) {
    out.yh = ya.c2p(d.yh);
    out.ys = ya.c2p(d.ys);

    // if the shoes go off-scale (ie log scale, error bars past zero)
    // clip the bar and hide the shoes
    if (!isNumeric(out.ys)) {
      out.noYS = true;
      out.ys = ya.c2p(d.ys, true);
    }
  }
  if (d.xh !== undefined) {
    out.xh = xa.c2p(d.xh);
    out.xs = xa.c2p(d.xs);
    if (!isNumeric(out.xs)) {
      out.noXS = true;
      out.xs = xa.c2p(d.xs, true);
    }
  }
  return out;
}

/***/ }),

/***/ 2036:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var Color = __webpack_require__(6308);
module.exports = function style(traces) {
  traces.each(function (d) {
    var trace = d[0].trace;
    var yObj = trace.error_y || {};
    var xObj = trace.error_x || {};
    var s = d3.select(this);
    s.selectAll('path.yerror').style('stroke-width', yObj.thickness + 'px').call(Color.stroke, yObj.color);
    if (xObj.copy_ystyle) xObj = yObj;
    s.selectAll('path.xerror').style('stroke-width', xObj.thickness + 'px').call(Color.stroke, xObj.color);
  });
};

/***/ }),

/***/ 5756:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var fontAttrs = __webpack_require__(5376);
var hoverLabelAttrs = (__webpack_require__(5460).hoverlabel);
var extendFlat = (__webpack_require__(2880).extendFlat);
module.exports = {
  hoverlabel: {
    bgcolor: extendFlat({}, hoverLabelAttrs.bgcolor, {
      arrayOk: true
    }),
    bordercolor: extendFlat({}, hoverLabelAttrs.bordercolor, {
      arrayOk: true
    }),
    font: fontAttrs({
      arrayOk: true,
      editType: 'none'
    }),
    align: extendFlat({}, hoverLabelAttrs.align, {
      arrayOk: true
    }),
    namelength: extendFlat({}, hoverLabelAttrs.namelength, {
      arrayOk: true
    }),
    editType: 'none'
  }
};

/***/ }),

/***/ 5056:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Registry = __webpack_require__(4040);
module.exports = function calc(gd) {
  var calcdata = gd.calcdata;
  var fullLayout = gd._fullLayout;
  function makeCoerceHoverInfo(trace) {
    return function (val) {
      return Lib.coerceHoverinfo({
        hoverinfo: val
      }, {
        _module: trace._module
      }, fullLayout);
    };
  }
  for (var i = 0; i < calcdata.length; i++) {
    var cd = calcdata[i];
    var trace = cd[0].trace;

    // don't include hover calc fields for pie traces
    // as calcdata items might be sorted by value and
    // won't match the data array order.
    if (Registry.traceIs(trace, 'pie-like')) continue;
    var fillFn = Registry.traceIs(trace, '2dMap') ? paste : Lib.fillArray;
    fillFn(trace.hoverinfo, cd, 'hi', makeCoerceHoverInfo(trace));
    if (trace.hovertemplate) fillFn(trace.hovertemplate, cd, 'ht');
    if (!trace.hoverlabel) continue;
    fillFn(trace.hoverlabel.bgcolor, cd, 'hbg');
    fillFn(trace.hoverlabel.bordercolor, cd, 'hbc');
    fillFn(trace.hoverlabel.font.size, cd, 'hts');
    fillFn(trace.hoverlabel.font.color, cd, 'htc');
    fillFn(trace.hoverlabel.font.family, cd, 'htf');
    fillFn(trace.hoverlabel.font.weight, cd, 'htw');
    fillFn(trace.hoverlabel.font.style, cd, 'hty');
    fillFn(trace.hoverlabel.font.variant, cd, 'htv');
    fillFn(trace.hoverlabel.namelength, cd, 'hnl');
    fillFn(trace.hoverlabel.align, cd, 'hta');
  }
};
function paste(traceAttr, cd, cdAttr, fn) {
  fn = fn || Lib.identity;
  if (Array.isArray(traceAttr)) {
    cd[0][cdAttr] = fn(traceAttr);
  }
}

/***/ }),

/***/ 2376:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Registry = __webpack_require__(4040);
var hover = (__webpack_require__(3292).hover);
module.exports = function click(gd, evt, subplot) {
  var annotationsDone = Registry.getComponentMethod('annotations', 'onClick')(gd, gd._hoverdata);

  // fallback to fail-safe in case the plot type's hover method doesn't pass the subplot.
  // Ternary, for example, didn't, but it was caught because tested.
  if (subplot !== undefined) {
    // The true flag at the end causes it to re-run the hover computation to figure out *which*
    // point is being clicked. Without this, clicking is somewhat unreliable.
    hover(gd, evt, subplot, true);
  }
  function emitClick() {
    gd.emit('plotly_click', {
      points: gd._hoverdata,
      event: evt
    });
  }
  if (gd._hoverdata && evt && evt.target) {
    if (annotationsDone && annotationsDone.then) {
      annotationsDone.then(emitClick);
    } else emitClick();

    // why do we get a double event without this???
    if (evt.stopImmediatePropagation) evt.stopImmediatePropagation();
  }
};

/***/ }),

/***/ 2456:
/***/ (function(module) {

"use strict";


module.exports = {
  // hover labels for multiple horizontal bars get tilted by this angle
  YANGLE: 60,
  // size and display constants for hover text

  // pixel size of hover arrows
  HOVERARROWSIZE: 6,
  // pixels padding around text
  HOVERTEXTPAD: 3,
  // hover font
  HOVERFONTSIZE: 13,
  HOVERFONT: 'Arial, sans-serif',
  // minimum time (msec) between hover calls
  HOVERMINTIME: 50,
  // ID suffix (with fullLayout._uid) for hover events in the throttle cache
  HOVERID: '-hover'
};

/***/ }),

/***/ 5448:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var attributes = __webpack_require__(5756);
var handleHoverLabelDefaults = __webpack_require__(6132);
module.exports = function supplyDefaults(traceIn, traceOut, defaultColor, layout) {
  function coerce(attr, dflt) {
    return Lib.coerce(traceIn, traceOut, attributes, attr, dflt);
  }
  var opts = Lib.extendFlat({}, layout.hoverlabel);
  if (traceOut.hovertemplate) opts.namelength = -1;
  handleHoverLabelDefaults(traceIn, traceOut, coerce, opts);
};

/***/ }),

/***/ 624:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);

// look for either subplot or xaxis and yaxis attributes
// does not handle splom case
exports.getSubplot = function (trace) {
  return trace.subplot || trace.xaxis + trace.yaxis || trace.geo;
};

// is trace in given list of subplots?
// does handle splom case
exports.isTraceInSubplots = function (trace, subplots) {
  if (trace.type === 'splom') {
    var xaxes = trace.xaxes || [];
    var yaxes = trace.yaxes || [];
    for (var i = 0; i < xaxes.length; i++) {
      for (var j = 0; j < yaxes.length; j++) {
        if (subplots.indexOf(xaxes[i] + yaxes[j]) !== -1) {
          return true;
        }
      }
    }
    return false;
  }
  return subplots.indexOf(exports.getSubplot(trace)) !== -1;
};

// convenience functions for mapping all relevant axes
exports.flat = function (subplots, v) {
  var out = new Array(subplots.length);
  for (var i = 0; i < subplots.length; i++) {
    out[i] = v;
  }
  return out;
};
exports.p2c = function (axArray, v) {
  var out = new Array(axArray.length);
  for (var i = 0; i < axArray.length; i++) {
    out[i] = axArray[i].p2c(v);
  }
  return out;
};
exports.getDistanceFunction = function (mode, dx, dy, dxy) {
  if (mode === 'closest') return dxy || exports.quadrature(dx, dy);
  return mode.charAt(0) === 'x' ? dx : dy;
};
exports.getClosest = function (cd, distfn, pointData) {
  // do we already have a point number? (array mode only)
  if (pointData.index !== false) {
    if (pointData.index >= 0 && pointData.index < cd.length) {
      pointData.distance = 0;
    } else pointData.index = false;
  } else {
    // apply the distance function to each data point
    // this is the longest loop... if this bogs down, we may need
    // to create pre-sorted data (by x or y), not sure how to
    // do this for 'closest'
    for (var i = 0; i < cd.length; i++) {
      var newDistance = distfn(cd[i]);
      if (newDistance <= pointData.distance) {
        pointData.index = i;
        pointData.distance = newDistance;
      }
    }
  }
  return pointData;
};

/*
 * pseudo-distance function for hover effects on areas: inside the region
 * distance is finite (`passVal`), outside it's Infinity.
 *
 * @param {number} v0: signed difference between the current position and the left edge
 * @param {number} v1: signed difference between the current position and the right edge
 * @param {number} passVal: the value to return on success
 */
exports.inbox = function (v0, v1, passVal) {
  return v0 * v1 < 0 || v0 === 0 ? passVal : Infinity;
};
exports.quadrature = function (dx, dy) {
  return function (di) {
    var x = dx(di);
    var y = dy(di);
    return Math.sqrt(x * x + y * y);
  };
};

/** Fill event data point object for hover and selection.
 *  Invokes _module.eventData if present.
 *
 * N.B. note that point 'index' corresponds to input data array index
 *  whereas 'number' is its post-transform version.
 *
 * If the hovered/selected pt corresponds to an multiple input points
 * (e.g. for histogram and transformed traces), 'pointNumbers` and 'pointIndices'
 * are include in the event data.
 *
 * @param {object} pt
 * @param {object} trace
 * @param {object} cd
 * @return {object}
 */
exports.makeEventData = function (pt, trace, cd) {
  // hover uses 'index', select uses 'pointNumber'
  var pointNumber = 'index' in pt ? pt.index : pt.pointNumber;
  var out = {
    data: trace._input,
    fullData: trace,
    curveNumber: trace.index,
    pointNumber: pointNumber
  };
  if (trace._indexToPoints) {
    var pointIndices = trace._indexToPoints[pointNumber];
    if (pointIndices.length === 1) {
      out.pointIndex = pointIndices[0];
    } else {
      out.pointIndices = pointIndices;
    }
  } else {
    out.pointIndex = pointNumber;
  }
  if (trace._module.eventData) {
    out = trace._module.eventData(out, pt, trace, cd, pointNumber);
  } else {
    if ('xVal' in pt) out.x = pt.xVal;else if ('x' in pt) out.x = pt.x;
    if ('yVal' in pt) out.y = pt.yVal;else if ('y' in pt) out.y = pt.y;
    if (pt.xa) out.xaxis = pt.xa;
    if (pt.ya) out.yaxis = pt.ya;
    if (pt.zLabelVal !== undefined) out.z = pt.zLabelVal;
  }
  exports.appendArrayPointValue(out, trace, pointNumber);
  return out;
};

/** Appends values inside array attributes corresponding to given point number
 *
 * @param {object} pointData : point data object (gets mutated here)
 * @param {object} trace : full trace object
 * @param {number|Array(number)} pointNumber : point number. May be a length-2 array
 *     [row, col] to dig into 2D arrays
 */
exports.appendArrayPointValue = function (pointData, trace, pointNumber) {
  var arrayAttrs = trace._arrayAttrs;
  if (!arrayAttrs) {
    return;
  }
  for (var i = 0; i < arrayAttrs.length; i++) {
    var astr = arrayAttrs[i];
    var key = getPointKey(astr);
    if (pointData[key] === undefined) {
      var val = Lib.nestedProperty(trace, astr).get();
      var pointVal = getPointData(val, pointNumber);
      if (pointVal !== undefined) pointData[key] = pointVal;
    }
  }
};

/**
 * Appends values inside array attributes corresponding to given point number array
 * For use when pointData references a plot entity that arose (or potentially arose)
 * from multiple points in the input data
 *
 * @param {object} pointData : point data object (gets mutated here)
 * @param {object} trace : full trace object
 * @param {Array(number)|Array(Array(number))} pointNumbers : Array of point numbers.
 *     Each entry in the array may itself be a length-2 array [row, col] to dig into 2D arrays
 */
exports.appendArrayMultiPointValues = function (pointData, trace, pointNumbers) {
  var arrayAttrs = trace._arrayAttrs;
  if (!arrayAttrs) {
    return;
  }
  for (var i = 0; i < arrayAttrs.length; i++) {
    var astr = arrayAttrs[i];
    var key = getPointKey(astr);
    if (pointData[key] === undefined) {
      var val = Lib.nestedProperty(trace, astr).get();
      var keyVal = new Array(pointNumbers.length);
      for (var j = 0; j < pointNumbers.length; j++) {
        keyVal[j] = getPointData(val, pointNumbers[j]);
      }
      pointData[key] = keyVal;
    }
  }
};
var pointKeyMap = {
  ids: 'id',
  locations: 'location',
  labels: 'label',
  values: 'value',
  'marker.colors': 'color',
  parents: 'parent'
};
function getPointKey(astr) {
  return pointKeyMap[astr] || astr;
}
function getPointData(val, pointNumber) {
  if (Array.isArray(pointNumber)) {
    if (Array.isArray(val) && Array.isArray(val[pointNumber[0]])) {
      return val[pointNumber[0]][pointNumber[1]];
    }
  } else {
    return val[pointNumber];
  }
}
var xyHoverMode = {
  x: true,
  y: true
};
var unifiedHoverMode = {
  'x unified': true,
  'y unified': true
};
exports.isUnifiedHover = function (hovermode) {
  if (typeof hovermode !== 'string') return false;
  return !!unifiedHoverMode[hovermode];
};
exports.isXYhover = function (hovermode) {
  if (typeof hovermode !== 'string') return false;
  return !!xyHoverMode[hovermode];
};

/***/ }),

/***/ 3292:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var isNumeric = __webpack_require__(8248);
var tinycolor = __webpack_require__(9760);
var Lib = __webpack_require__(3400);
var pushUnique = Lib.pushUnique;
var strTranslate = Lib.strTranslate;
var strRotate = Lib.strRotate;
var Events = __webpack_require__(5924);
var svgTextUtils = __webpack_require__(2736);
var overrideCursor = __webpack_require__(2213);
var Drawing = __webpack_require__(3616);
var Color = __webpack_require__(6308);
var dragElement = __webpack_require__(6476);
var Axes = __webpack_require__(4460);
var Registry = __webpack_require__(4040);
var helpers = __webpack_require__(624);
var constants = __webpack_require__(2456);
var legendSupplyDefaults = __webpack_require__(7864);
var legendDraw = __webpack_require__(1140);

// hover labels for multiple horizontal bars get tilted by some angle,
// then need to be offset differently if they overlap
var YANGLE = constants.YANGLE;
var YA_RADIANS = Math.PI * YANGLE / 180;

// expansion of projected height
var YFACTOR = 1 / Math.sin(YA_RADIANS);

// to make the appropriate post-rotation x offset,
// you need both x and y offsets
var YSHIFTX = Math.cos(YA_RADIANS);
var YSHIFTY = Math.sin(YA_RADIANS);

// size and display constants for hover text
var HOVERARROWSIZE = constants.HOVERARROWSIZE;
var HOVERTEXTPAD = constants.HOVERTEXTPAD;
var multipleHoverPoints = {
  box: true,
  ohlc: true,
  violin: true,
  candlestick: true
};
var cartesianScatterPoints = {
  scatter: true,
  scattergl: true,
  splom: true
};
function distanceSort(a, b) {
  return a.distance - b.distance;
}

// fx.hover: highlight data on hover
// evt can be a mousemove event, or an object with data about what points
//   to hover on
//      {xpx,ypx[,hovermode]} - pixel locations from top left
//          (with optional overriding hovermode)
//      {xval,yval[,hovermode]} - data values
//      [{curveNumber,(pointNumber|xval and/or yval)}] -
//              array of specific points to highlight
//          pointNumber is a single integer if gd.data[curveNumber] is 1D,
//              or a two-element array if it's 2D
//          xval and yval are data values,
//              1D data may specify either or both,
//              2D data must specify both
// subplot is an id string (default "xy")
// makes use of gl.hovermode, which can be:
//      x (find the points with the closest x values, ie a column),
//      closest (find the single closest point)
//    internally there are two more that occasionally get used:
//      y (pick out a row - only used for multiple horizontal bar charts)
//      array (used when the user specifies an explicit
//          array of points to hover on)
//
// We wrap the hovers in a timer, to limit their frequency.
// The actual rendering is done by private function _hover.
exports.hover = function hover(gd, evt, subplot, noHoverEvent) {
  gd = Lib.getGraphDiv(gd);
  // The 'target' property changes when bubbling out of Shadow DOM.
  // Throttling can delay reading the target, so we save the current value.
  var eventTarget = evt.target;
  Lib.throttle(gd._fullLayout._uid + constants.HOVERID, constants.HOVERMINTIME, function () {
    _hover(gd, evt, subplot, noHoverEvent, eventTarget);
  });
};

/*
 * Draw a single hover item or an array of hover item in a pre-existing svg container somewhere
 * hoverItem should have keys:
 *    - x and y (or x0, x1, y0, and y1):
 *      the pixel position to mark, relative to opts.container
 *    - xLabel, yLabel, zLabel, text, and name:
 *      info to go in the label
 *    - color:
 *      the background color for the label.
 *    - idealAlign (optional):
 *      'left' or 'right' for which side of the x/y box to try to put this on first
 *    - borderColor (optional):
 *      color for the border, defaults to strongest contrast with color
 *    - fontFamily (optional):
 *      string, the font for this label, defaults to constants.HOVERFONT
 *    - fontSize (optional):
 *      the label font size, defaults to constants.HOVERFONTSIZE
 *    - fontColor (optional):
 *      defaults to borderColor
 * opts should have keys:
 *    - bgColor:
 *      the background color this is against, used if the trace is
 *      non-opaque, and for the name, which goes outside the box
 *    - container:
 *      a <svg> or <g> element to add the hover label to
 *    - outerContainer:
 *      normally a parent of `container`, sets the bounding box to use to
 *      constrain the hover label and determine whether to show it on the left or right
 * opts can have optional keys:
 *    - anchorIndex:
        the index of the hover item used as an anchor for positioning.
        The other hover items will be pushed up or down to prevent overlap.
 */
exports.loneHover = function loneHover(hoverItems, opts) {
  var multiHover = true;
  if (!Array.isArray(hoverItems)) {
    multiHover = false;
    hoverItems = [hoverItems];
  }
  var gd = opts.gd;
  var gTop = getTopOffset(gd);
  var gLeft = getLeftOffset(gd);
  var pointsData = hoverItems.map(function (hoverItem) {
    var _x0 = hoverItem._x0 || hoverItem.x0 || hoverItem.x || 0;
    var _x1 = hoverItem._x1 || hoverItem.x1 || hoverItem.x || 0;
    var _y0 = hoverItem._y0 || hoverItem.y0 || hoverItem.y || 0;
    var _y1 = hoverItem._y1 || hoverItem.y1 || hoverItem.y || 0;
    var eventData = hoverItem.eventData;
    if (eventData) {
      var x0 = Math.min(_x0, _x1);
      var x1 = Math.max(_x0, _x1);
      var y0 = Math.min(_y0, _y1);
      var y1 = Math.max(_y0, _y1);
      var trace = hoverItem.trace;
      if (Registry.traceIs(trace, 'gl3d')) {
        var container = gd._fullLayout[trace.scene]._scene.container;
        var dx = container.offsetLeft;
        var dy = container.offsetTop;
        x0 += dx;
        x1 += dx;
        y0 += dy;
        y1 += dy;
      } // TODO: handle heatmapgl

      eventData.bbox = {
        x0: x0 + gLeft,
        x1: x1 + gLeft,
        y0: y0 + gTop,
        y1: y1 + gTop
      };
      if (opts.inOut_bbox) {
        opts.inOut_bbox.push(eventData.bbox);
      }
    } else {
      eventData = false;
    }
    return {
      color: hoverItem.color || Color.defaultLine,
      x0: hoverItem.x0 || hoverItem.x || 0,
      x1: hoverItem.x1 || hoverItem.x || 0,
      y0: hoverItem.y0 || hoverItem.y || 0,
      y1: hoverItem.y1 || hoverItem.y || 0,
      xLabel: hoverItem.xLabel,
      yLabel: hoverItem.yLabel,
      zLabel: hoverItem.zLabel,
      text: hoverItem.text,
      name: hoverItem.name,
      idealAlign: hoverItem.idealAlign,
      // optional extra bits of styling
      borderColor: hoverItem.borderColor,
      fontFamily: hoverItem.fontFamily,
      fontSize: hoverItem.fontSize,
      fontColor: hoverItem.fontColor,
      fontWeight: hoverItem.fontWeight,
      fontStyle: hoverItem.fontStyle,
      fontVariant: hoverItem.fontVariant,
      nameLength: hoverItem.nameLength,
      textAlign: hoverItem.textAlign,
      // filler to make createHoverText happy
      trace: hoverItem.trace || {
        index: 0,
        hoverinfo: ''
      },
      xa: {
        _offset: 0
      },
      ya: {
        _offset: 0
      },
      index: 0,
      hovertemplate: hoverItem.hovertemplate || false,
      hovertemplateLabels: hoverItem.hovertemplateLabels || false,
      eventData: eventData
    };
  });
  var rotateLabels = false;
  var hoverText = createHoverText(pointsData, {
    gd: gd,
    hovermode: 'closest',
    rotateLabels: rotateLabels,
    bgColor: opts.bgColor || Color.background,
    container: d3.select(opts.container),
    outerContainer: opts.outerContainer || opts.container
  });
  var hoverLabel = hoverText.hoverLabels;

  // Fix vertical overlap
  var tooltipSpacing = 5;
  var lastBottomY = 0;
  var anchor = 0;
  hoverLabel.sort(function (a, b) {
    return a.y0 - b.y0;
  }).each(function (d, i) {
    var topY = d.y0 - d.by / 2;
    if (topY - tooltipSpacing < lastBottomY) {
      d.offset = lastBottomY - topY + tooltipSpacing;
    } else {
      d.offset = 0;
    }
    lastBottomY = topY + d.by + d.offset;
    if (i === opts.anchorIndex || 0) anchor = d.offset;
  }).each(function (d) {
    d.offset -= anchor;
  });
  var scaleX = gd._fullLayout._invScaleX;
  var scaleY = gd._fullLayout._invScaleY;
  alignHoverText(hoverLabel, rotateLabels, scaleX, scaleY);
  return multiHover ? hoverLabel : hoverLabel.node();
};

// The actual implementation is here:
function _hover(gd, evt, subplot, noHoverEvent, eventTarget) {
  if (!subplot) subplot = 'xy';

  // if the user passed in an array of subplots,
  // use those instead of finding overlayed plots
  var subplots = Array.isArray(subplot) ? subplot : [subplot];
  var spId;
  var fullLayout = gd._fullLayout;
  var hoversubplots = fullLayout.hoversubplots;
  var plots = fullLayout._plots || [];
  var plotinfo = plots[subplot];
  var hasCartesian = fullLayout._has('cartesian');
  var hovermode = evt.hovermode || fullLayout.hovermode;
  var hovermodeHasX = (hovermode || '').charAt(0) === 'x';
  var hovermodeHasY = (hovermode || '').charAt(0) === 'y';
  var firstXaxis;
  var firstYaxis;
  if (hasCartesian && (hovermodeHasX || hovermodeHasY) && hoversubplots === 'axis') {
    var subplotsLength = subplots.length;
    for (var p = 0; p < subplotsLength; p++) {
      spId = subplots[p];
      if (plots[spId]) {
        // 'cartesian' case

        firstXaxis = Axes.getFromId(gd, spId, 'x');
        firstYaxis = Axes.getFromId(gd, spId, 'y');
        var subplotsWith = (hovermodeHasX ? firstXaxis : firstYaxis)._subplotsWith;
        if (subplotsWith && subplotsWith.length) {
          for (var q = 0; q < subplotsWith.length; q++) {
            pushUnique(subplots, subplotsWith[q]);
          }
        }
      }
    }
  }

  // list of all overlaid subplots to look at
  if (plotinfo && hoversubplots !== 'single') {
    var overlayedSubplots = plotinfo.overlays.map(function (pi) {
      return pi.id;
    });
    subplots = subplots.concat(overlayedSubplots);
  }
  var len = subplots.length;
  var xaArray = new Array(len);
  var yaArray = new Array(len);
  var supportsCompare = false;
  for (var i = 0; i < len; i++) {
    spId = subplots[i];
    if (plots[spId]) {
      // 'cartesian' case
      supportsCompare = true;
      xaArray[i] = plots[spId].xaxis;
      yaArray[i] = plots[spId].yaxis;
    } else if (fullLayout[spId] && fullLayout[spId]._subplot) {
      // other subplot types
      var _subplot = fullLayout[spId]._subplot;
      xaArray[i] = _subplot.xaxis;
      yaArray[i] = _subplot.yaxis;
    } else {
      Lib.warn('Unrecognized subplot: ' + spId);
      return;
    }
  }
  if (hovermode && !supportsCompare) hovermode = 'closest';
  if (['x', 'y', 'closest', 'x unified', 'y unified'].indexOf(hovermode) === -1 || !gd.calcdata || gd.querySelector('.zoombox') || gd._dragging) {
    return dragElement.unhoverRaw(gd, evt);
  }
  var hoverdistance = fullLayout.hoverdistance;
  if (hoverdistance === -1) hoverdistance = Infinity;
  var spikedistance = fullLayout.spikedistance;
  if (spikedistance === -1) spikedistance = Infinity;

  // hoverData: the set of candidate points we've found to highlight
  var hoverData = [];

  // searchData: the data to search in. Mostly this is just a copy of
  // gd.calcdata, filtered to the subplot and overlays we're on
  // but if a point array is supplied it will be a mapping
  // of indicated curves
  var searchData = [];

  // [x|y]valArray: the axis values of the hover event
  // mapped onto each of the currently selected overlaid subplots
  var xvalArray, yvalArray;
  var itemnum, curvenum, cd, trace, subplotId, subploti, _mode, xval, yval, pointData, closedataPreviousLength;

  // spikePoints: the set of candidate points we've found to draw spikes to
  var spikePoints = {
    hLinePoint: null,
    vLinePoint: null
  };

  // does subplot have one (or more) horizontal traces?
  // This is used to determine whether we rotate the labels or not
  var hasOneHorizontalTrace = false;

  // Figure out what we're hovering on:
  // mouse location or user-supplied data

  if (Array.isArray(evt)) {
    // user specified an array of points to highlight
    hovermode = 'array';
    for (itemnum = 0; itemnum < evt.length; itemnum++) {
      cd = gd.calcdata[evt[itemnum].curveNumber || 0];
      if (cd) {
        trace = cd[0].trace;
        if (cd[0].trace.hoverinfo !== 'skip') {
          searchData.push(cd);
          if (trace.orientation === 'h') {
            hasOneHorizontalTrace = true;
          }
        }
      }
    }
  } else {
    // take into account zorder
    var zorderedCalcdata = gd.calcdata.slice();
    zorderedCalcdata.sort(function (a, b) {
      var aZorder = a[0].trace.zorder || 0;
      var bZorder = b[0].trace.zorder || 0;
      return aZorder - bZorder;
    });
    for (curvenum = 0; curvenum < zorderedCalcdata.length; curvenum++) {
      cd = zorderedCalcdata[curvenum];
      trace = cd[0].trace;
      if (trace.hoverinfo !== 'skip' && helpers.isTraceInSubplots(trace, subplots)) {
        searchData.push(cd);
        if (trace.orientation === 'h') {
          hasOneHorizontalTrace = true;
        }
      }
    }

    // [x|y]px: the pixels (from top left) of the mouse location
    // on the currently selected plot area
    // add pointerX|Y property for drawing the spikes in spikesnap 'cursor' situation
    var hasUserCalledHover = !eventTarget;
    var xpx, ypx;
    if (hasUserCalledHover) {
      if ('xpx' in evt) xpx = evt.xpx;else xpx = xaArray[0]._length / 2;
      if ('ypx' in evt) ypx = evt.ypx;else ypx = yaArray[0]._length / 2;
    } else {
      // fire the beforehover event and quit if it returns false
      // note that we're only calling this on real mouse events, so
      // manual calls to fx.hover will always run.
      if (Events.triggerHandler(gd, 'plotly_beforehover', evt) === false) {
        return;
      }
      var dbb = eventTarget.getBoundingClientRect();
      xpx = evt.clientX - dbb.left;
      ypx = evt.clientY - dbb.top;
      fullLayout._calcInverseTransform(gd);
      var transformedCoords = Lib.apply3DTransform(fullLayout._invTransform)(xpx, ypx);
      xpx = transformedCoords[0];
      ypx = transformedCoords[1];

      // in case hover was called from mouseout into hovertext,
      // it's possible you're not actually over the plot anymore
      if (xpx < 0 || xpx > xaArray[0]._length || ypx < 0 || ypx > yaArray[0]._length) {
        return dragElement.unhoverRaw(gd, evt);
      }
    }
    evt.pointerX = xpx + xaArray[0]._offset;
    evt.pointerY = ypx + yaArray[0]._offset;
    if ('xval' in evt) xvalArray = helpers.flat(subplots, evt.xval);else xvalArray = helpers.p2c(xaArray, xpx);
    if ('yval' in evt) yvalArray = helpers.flat(subplots, evt.yval);else yvalArray = helpers.p2c(yaArray, ypx);
    if (!isNumeric(xvalArray[0]) || !isNumeric(yvalArray[0])) {
      Lib.warn('Fx.hover failed', evt, gd);
      return dragElement.unhoverRaw(gd, evt);
    }
  }

  // the pixel distance to beat as a matching point
  // in 'x' or 'y' mode this resets for each trace
  var distance = Infinity;

  // find the closest point in each trace
  // this is minimum dx and/or dy, depending on mode
  // and the pixel position for the label (labelXpx, labelYpx)
  function findHoverPoints(customXVal, customYVal) {
    for (curvenum = 0; curvenum < searchData.length; curvenum++) {
      cd = searchData[curvenum];

      // filter out invisible or broken data
      if (!cd || !cd[0] || !cd[0].trace) continue;
      trace = cd[0].trace;
      if (trace.visible !== true || trace._length === 0) continue;

      // Explicitly bail out for these two. I don't know how to otherwise prevent
      // the rest of this function from running and failing
      if (['carpet', 'contourcarpet'].indexOf(trace._module.name) !== -1) continue;

      // within one trace mode can sometimes be overridden
      _mode = hovermode;
      if (helpers.isUnifiedHover(_mode)) {
        _mode = _mode.charAt(0);
      }
      if (trace.type === 'splom') {
        // splom traces do not generate overlay subplots,
        // it is safe to assume here splom traces correspond to the 0th subplot
        subploti = 0;
        subplotId = subplots[subploti];
      } else {
        subplotId = helpers.getSubplot(trace);
        subploti = subplots.indexOf(subplotId);
      }

      // container for new point, also used to pass info into module.hoverPoints
      pointData = {
        // trace properties
        cd: cd,
        trace: trace,
        xa: xaArray[subploti],
        ya: yaArray[subploti],
        // max distances for hover and spikes - for points that want to show but do not
        // want to override other points, set distance/spikeDistance equal to max*Distance
        // and it will not get filtered out but it will be guaranteed to have a greater
        // distance than any point that calculated a real distance.
        maxHoverDistance: hoverdistance,
        maxSpikeDistance: spikedistance,
        // point properties - override all of these
        index: false,
        // point index in trace - only used by plotly.js hoverdata consumers
        distance: Math.min(distance, hoverdistance),
        // pixel distance or pseudo-distance

        // distance/pseudo-distance for spikes. This distance should always be calculated
        // as if in "closest" mode, and should only be set if this point should
        // generate a spike.
        spikeDistance: Infinity,
        // in some cases the spikes have different positioning from the hover label
        // they don't need x0/x1, just one position
        xSpike: undefined,
        ySpike: undefined,
        // where and how to display the hover label
        color: Color.defaultLine,
        // trace color
        name: trace.name,
        x0: undefined,
        x1: undefined,
        y0: undefined,
        y1: undefined,
        xLabelVal: undefined,
        yLabelVal: undefined,
        zLabelVal: undefined,
        text: undefined
      };

      // add ref to subplot object (non-cartesian case)
      if (fullLayout[subplotId]) {
        pointData.subplot = fullLayout[subplotId]._subplot;
      }
      // add ref to splom scene
      if (fullLayout._splomScenes && fullLayout._splomScenes[trace.uid]) {
        pointData.scene = fullLayout._splomScenes[trace.uid];
      }

      // for a highlighting array, figure out what
      // we're searching for with this element
      if (_mode === 'array') {
        var selection = evt[curvenum];
        if ('pointNumber' in selection) {
          pointData.index = selection.pointNumber;
          _mode = 'closest';
        } else {
          _mode = '';
          if ('xval' in selection) {
            xval = selection.xval;
            _mode = 'x';
          }
          if ('yval' in selection) {
            yval = selection.yval;
            _mode = _mode ? 'closest' : 'y';
          }
        }
      } else if (customXVal !== undefined && customYVal !== undefined) {
        xval = customXVal;
        yval = customYVal;
      } else {
        xval = xvalArray[subploti];
        yval = yvalArray[subploti];
      }
      closedataPreviousLength = hoverData.length;

      // Now if there is range to look in, find the points to hover.
      if (hoverdistance !== 0) {
        if (trace._module && trace._module.hoverPoints) {
          var newPoints = trace._module.hoverPoints(pointData, xval, yval, _mode, {
            finiteRange: true,
            hoverLayer: fullLayout._hoverlayer,
            // options for splom when hovering on same axis
            hoversubplots: hoversubplots,
            gd: gd
          });
          if (newPoints) {
            var newPoint;
            for (var newPointNum = 0; newPointNum < newPoints.length; newPointNum++) {
              newPoint = newPoints[newPointNum];
              if (isNumeric(newPoint.x0) && isNumeric(newPoint.y0)) {
                hoverData.push(cleanPoint(newPoint, hovermode));
              }
            }
          }
        } else {
          Lib.log('Unrecognized trace type in hover:', trace);
        }
      }

      // in closest mode, remove any existing (farther) points
      // and don't look any farther than this latest point (or points, some
      // traces like box & violin make multiple hover labels at once)
      if (hovermode === 'closest' && hoverData.length > closedataPreviousLength) {
        hoverData.splice(0, closedataPreviousLength);
        distance = hoverData[0].distance;
      }

      // Now if there is range to look in, find the points to draw the spikelines
      // Do it only if there is no hoverData
      if (hasCartesian && spikedistance !== 0) {
        if (hoverData.length === 0) {
          pointData.distance = spikedistance;
          pointData.index = false;
          var closestPoints = trace._module.hoverPoints(pointData, xval, yval, 'closest', {
            hoverLayer: fullLayout._hoverlayer
          });
          if (closestPoints) {
            closestPoints = closestPoints.filter(function (point) {
              // some hover points, like scatter fills, do not allow spikes,
              // so will generate a hover point but without a valid spikeDistance
              return point.spikeDistance <= spikedistance;
            });
          }
          if (closestPoints && closestPoints.length) {
            var tmpPoint;
            var closestVPoints = closestPoints.filter(function (point) {
              return point.xa.showspikes && point.xa.spikesnap !== 'hovered data';
            });
            if (closestVPoints.length) {
              var closestVPt = closestVPoints[0];
              if (isNumeric(closestVPt.x0) && isNumeric(closestVPt.y0)) {
                tmpPoint = fillSpikePoint(closestVPt);
                if (!spikePoints.vLinePoint || spikePoints.vLinePoint.spikeDistance > tmpPoint.spikeDistance) {
                  spikePoints.vLinePoint = tmpPoint;
                }
              }
            }
            var closestHPoints = closestPoints.filter(function (point) {
              return point.ya.showspikes && point.ya.spikesnap !== 'hovered data';
            });
            if (closestHPoints.length) {
              var closestHPt = closestHPoints[0];
              if (isNumeric(closestHPt.x0) && isNumeric(closestHPt.y0)) {
                tmpPoint = fillSpikePoint(closestHPt);
                if (!spikePoints.hLinePoint || spikePoints.hLinePoint.spikeDistance > tmpPoint.spikeDistance) {
                  spikePoints.hLinePoint = tmpPoint;
                }
              }
            }
          }
        }
      }
    }
  }
  findHoverPoints();
  function selectClosestPoint(pointsData, spikedistance, spikeOnWinning) {
    var resultPoint = null;
    var minDistance = Infinity;
    var thisSpikeDistance;
    for (var i = 0; i < pointsData.length; i++) {
      if (firstXaxis && firstXaxis._id !== pointsData[i].xa._id) continue;
      if (firstYaxis && firstYaxis._id !== pointsData[i].ya._id) continue;
      thisSpikeDistance = pointsData[i].spikeDistance;
      if (spikeOnWinning && i === 0) thisSpikeDistance = -Infinity;
      if (thisSpikeDistance <= minDistance && thisSpikeDistance <= spikedistance) {
        resultPoint = pointsData[i];
        minDistance = thisSpikeDistance;
      }
    }
    return resultPoint;
  }
  function fillSpikePoint(point) {
    if (!point) return null;
    return {
      xa: point.xa,
      ya: point.ya,
      x: point.xSpike !== undefined ? point.xSpike : (point.x0 + point.x1) / 2,
      y: point.ySpike !== undefined ? point.ySpike : (point.y0 + point.y1) / 2,
      distance: point.distance,
      spikeDistance: point.spikeDistance,
      curveNumber: point.trace.index,
      color: point.color,
      pointNumber: point.index
    };
  }
  var spikelineOpts = {
    fullLayout: fullLayout,
    container: fullLayout._hoverlayer,
    event: evt
  };
  var oldspikepoints = gd._spikepoints;
  var newspikepoints = {
    vLinePoint: spikePoints.vLinePoint,
    hLinePoint: spikePoints.hLinePoint
  };
  gd._spikepoints = newspikepoints;
  var sortHoverData = function () {
    // When sorting keep the points in the main subplot at the top
    // then add points in other subplots

    var hoverDataInSubplot = hoverData.filter(function (a) {
      return firstXaxis && firstXaxis._id === a.xa._id && firstYaxis && firstYaxis._id === a.ya._id;
    });
    var hoverDataOutSubplot = hoverData.filter(function (a) {
      return !(firstXaxis && firstXaxis._id === a.xa._id && firstYaxis && firstYaxis._id === a.ya._id);
    });
    hoverDataInSubplot.sort(distanceSort);
    hoverDataOutSubplot.sort(distanceSort);
    hoverData = hoverDataInSubplot.concat(hoverDataOutSubplot);

    // move period positioned points and box/bar-like traces to the end of the list
    hoverData = orderRangePoints(hoverData, hovermode);
  };
  sortHoverData();
  var axLetter = hovermode.charAt(0);
  var spikeOnWinning = (axLetter === 'x' || axLetter === 'y') && hoverData[0] && cartesianScatterPoints[hoverData[0].trace.type];

  // Now if it is not restricted by spikedistance option, set the points to draw the spikelines
  if (hasCartesian && spikedistance !== 0) {
    if (hoverData.length !== 0) {
      var tmpHPointData = hoverData.filter(function (point) {
        return point.ya.showspikes;
      });
      var tmpHPoint = selectClosestPoint(tmpHPointData, spikedistance, spikeOnWinning);
      spikePoints.hLinePoint = fillSpikePoint(tmpHPoint);
      var tmpVPointData = hoverData.filter(function (point) {
        return point.xa.showspikes;
      });
      var tmpVPoint = selectClosestPoint(tmpVPointData, spikedistance, spikeOnWinning);
      spikePoints.vLinePoint = fillSpikePoint(tmpVPoint);
    }
  }

  // if hoverData is empty check for the spikes to draw and quit if there are none
  if (hoverData.length === 0) {
    var result = dragElement.unhoverRaw(gd, evt);
    if (hasCartesian && (spikePoints.hLinePoint !== null || spikePoints.vLinePoint !== null)) {
      if (spikesChanged(oldspikepoints)) {
        createSpikelines(gd, spikePoints, spikelineOpts);
      }
    }
    return result;
  }
  if (hasCartesian) {
    if (spikesChanged(oldspikepoints)) {
      createSpikelines(gd, spikePoints, spikelineOpts);
    }
  }
  if (helpers.isXYhover(_mode) && hoverData[0].length !== 0 && hoverData[0].trace.type !== 'splom' // TODO: add support for splom
  ) {
    // pick winning point
    var winningPoint = hoverData[0];
    // discard other points
    if (multipleHoverPoints[winningPoint.trace.type]) {
      hoverData = hoverData.filter(function (d) {
        return d.trace.index === winningPoint.trace.index;
      });
    } else {
      hoverData = [winningPoint];
    }
    var initLen = hoverData.length;
    var winX = getCoord('x', winningPoint, fullLayout);
    var winY = getCoord('y', winningPoint, fullLayout);

    // in compare mode, select every point at position
    findHoverPoints(winX, winY);
    var finalPoints = [];
    var seen = {};
    var id = 0;
    var insert = function (newHd) {
      var key = multipleHoverPoints[newHd.trace.type] ? hoverDataKey(newHd) : newHd.trace.index;
      if (!seen[key]) {
        id++;
        seen[key] = id;
        finalPoints.push(newHd);
      } else {
        var oldId = seen[key] - 1;
        var oldHd = finalPoints[oldId];
        if (oldId > 0 && Math.abs(newHd.distance) < Math.abs(oldHd.distance)) {
          // replace with closest
          finalPoints[oldId] = newHd;
        }
      }
    };
    var k;
    // insert the winnig point(s) first
    for (k = 0; k < initLen; k++) {
      insert(hoverData[k]);
    }
    // override from the end
    for (k = hoverData.length - 1; k > initLen - 1; k--) {
      insert(hoverData[k]);
    }
    hoverData = finalPoints;
    sortHoverData();
  }

  // lastly, emit custom hover/unhover events
  var oldhoverdata = gd._hoverdata;
  var newhoverdata = [];
  var gTop = getTopOffset(gd);
  var gLeft = getLeftOffset(gd);

  // pull out just the data that's useful to
  // other people and send it to the event
  for (itemnum = 0; itemnum < hoverData.length; itemnum++) {
    var pt = hoverData[itemnum];
    var eventData = helpers.makeEventData(pt, pt.trace, pt.cd);
    if (pt.hovertemplate !== false) {
      var ht = false;
      if (pt.cd[pt.index] && pt.cd[pt.index].ht) {
        ht = pt.cd[pt.index].ht;
      }
      pt.hovertemplate = ht || pt.trace.hovertemplate || false;
    }
    if (pt.xa && pt.ya) {
      var _x0 = pt.x0 + pt.xa._offset;
      var _x1 = pt.x1 + pt.xa._offset;
      var _y0 = pt.y0 + pt.ya._offset;
      var _y1 = pt.y1 + pt.ya._offset;
      var x0 = Math.min(_x0, _x1);
      var x1 = Math.max(_x0, _x1);
      var y0 = Math.min(_y0, _y1);
      var y1 = Math.max(_y0, _y1);
      eventData.bbox = {
        x0: x0 + gLeft,
        x1: x1 + gLeft,
        y0: y0 + gTop,
        y1: y1 + gTop
      };
    }
    pt.eventData = [eventData];
    newhoverdata.push(eventData);
  }
  gd._hoverdata = newhoverdata;
  var rotateLabels = hovermode === 'y' && (searchData.length > 1 || hoverData.length > 1) || hovermode === 'closest' && hasOneHorizontalTrace && hoverData.length > 1;
  var bgColor = Color.combine(fullLayout.plot_bgcolor || Color.background, fullLayout.paper_bgcolor);
  var hoverText = createHoverText(hoverData, {
    gd: gd,
    hovermode: hovermode,
    rotateLabels: rotateLabels,
    bgColor: bgColor,
    container: fullLayout._hoverlayer,
    outerContainer: fullLayout._paper.node(),
    commonLabelOpts: fullLayout.hoverlabel,
    hoverdistance: fullLayout.hoverdistance
  });
  var hoverLabels = hoverText.hoverLabels;
  if (!helpers.isUnifiedHover(hovermode)) {
    hoverAvoidOverlaps(hoverLabels, rotateLabels, fullLayout, hoverText.commonLabelBoundingBox);
    alignHoverText(hoverLabels, rotateLabels, fullLayout._invScaleX, fullLayout._invScaleY);
  } // TODO: tagName hack is needed to appease geo.js's hack of using eventTarget=true
  // we should improve the "fx" API so other plots can use it without these hack.
  if (eventTarget && eventTarget.tagName) {
    var hasClickToShow = Registry.getComponentMethod('annotations', 'hasClickToShow')(gd, newhoverdata);
    overrideCursor(d3.select(eventTarget), hasClickToShow ? 'pointer' : '');
  }

  // don't emit events if called manually
  if (!eventTarget || noHoverEvent || !hoverChanged(gd, evt, oldhoverdata)) return;
  if (oldhoverdata) {
    gd.emit('plotly_unhover', {
      event: evt,
      points: oldhoverdata
    });
  }
  gd.emit('plotly_hover', {
    event: evt,
    points: gd._hoverdata,
    xaxes: xaArray,
    yaxes: yaArray,
    xvals: xvalArray,
    yvals: yvalArray
  });
}
function hoverDataKey(d) {
  return [d.trace.index, d.index, d.x0, d.y0, d.name, d.attr, d.xa ? d.xa._id : '', d.ya ? d.ya._id : ''].join(',');
}
var EXTRA_STRING_REGEX = /<extra>([\s\S]*)<\/extra>/;
function createHoverText(hoverData, opts) {
  var gd = opts.gd;
  var fullLayout = gd._fullLayout;
  var hovermode = opts.hovermode;
  var rotateLabels = opts.rotateLabels;
  var bgColor = opts.bgColor;
  var container = opts.container;
  var outerContainer = opts.outerContainer;
  var commonLabelOpts = opts.commonLabelOpts || {};
  // Early exit if no labels are drawn
  if (hoverData.length === 0) return [[]];

  // opts.fontFamily/Size are used for the common label
  // and as defaults for each hover label, though the individual labels
  // can override this.
  var fontFamily = opts.fontFamily || constants.HOVERFONT;
  var fontSize = opts.fontSize || constants.HOVERFONTSIZE;
  var fontWeight = opts.fontWeight || fullLayout.font.weight;
  var fontStyle = opts.fontStyle || fullLayout.font.style;
  var fontVariant = opts.fontVariant || fullLayout.font.variant;
  var c0 = hoverData[0];
  var xa = c0.xa;
  var ya = c0.ya;
  var axLetter = hovermode.charAt(0);
  var axLabel = axLetter + 'Label';
  var t0 = c0[axLabel];

  // search in array for the label
  if (t0 === undefined && xa.type === 'multicategory') {
    for (var q = 0; q < hoverData.length; q++) {
      t0 = hoverData[q][axLabel];
      if (t0 !== undefined) break;
    }
  }
  var outerContainerBB = getBoundingClientRect(gd, outerContainer);
  var outerTop = outerContainerBB.top;
  var outerWidth = outerContainerBB.width;
  var outerHeight = outerContainerBB.height;

  // show the common label, if any, on the axis
  // never show a common label in array mode,
  // even if sometimes there could be one
  var showCommonLabel = t0 !== undefined && c0.distance <= opts.hoverdistance && (hovermode === 'x' || hovermode === 'y');

  // all hover traces hoverinfo must contain the hovermode
  // to have common labels
  if (showCommonLabel) {
    var allHaveZ = true;
    var i, traceHoverinfo;
    for (i = 0; i < hoverData.length; i++) {
      if (allHaveZ && hoverData[i].zLabel === undefined) allHaveZ = false;
      traceHoverinfo = hoverData[i].hoverinfo || hoverData[i].trace.hoverinfo;
      if (traceHoverinfo) {
        var parts = Array.isArray(traceHoverinfo) ? traceHoverinfo : traceHoverinfo.split('+');
        if (parts.indexOf('all') === -1 && parts.indexOf(hovermode) === -1) {
          showCommonLabel = false;
          break;
        }
      }
    }

    // xyz labels put all info in their main label, so have no need of a common label
    if (allHaveZ) showCommonLabel = false;
  }
  var commonLabel = container.selectAll('g.axistext').data(showCommonLabel ? [0] : []);
  commonLabel.enter().append('g').classed('axistext', true);
  commonLabel.exit().remove();

  // set rect (without arrow) behind label below for later collision detection
  var commonLabelRect = {
    minX: 0,
    maxX: 0,
    minY: 0,
    maxY: 0
  };
  commonLabel.each(function () {
    var label = d3.select(this);
    var lpath = Lib.ensureSingle(label, 'path', '', function (s) {
      s.style({
        'stroke-width': '1px'
      });
    });
    var ltext = Lib.ensureSingle(label, 'text', '', function (s) {
      // prohibit tex interpretation until we can handle
      // tex and regular text together
      s.attr('data-notex', 1);
    });
    var commonBgColor = commonLabelOpts.bgcolor || Color.defaultLine;
    var commonStroke = commonLabelOpts.bordercolor || Color.contrast(commonBgColor);
    var contrastColor = Color.contrast(commonBgColor);
    var commonLabelFont = {
      weight: commonLabelOpts.font.weight || fontWeight,
      style: commonLabelOpts.font.style || fontStyle,
      variant: commonLabelOpts.font.variant || fontVariant,
      family: commonLabelOpts.font.family || fontFamily,
      size: commonLabelOpts.font.size || fontSize,
      color: commonLabelOpts.font.color || contrastColor
    };
    lpath.style({
      fill: commonBgColor,
      stroke: commonStroke
    });
    ltext.text(t0).call(Drawing.font, commonLabelFont).call(svgTextUtils.positionText, 0, 0).call(svgTextUtils.convertToTspans, gd);
    label.attr('transform', '');
    var tbb = getBoundingClientRect(gd, ltext.node());
    var lx, ly;
    if (hovermode === 'x') {
      var topsign = xa.side === 'top' ? '-' : '';
      ltext.attr('text-anchor', 'middle').call(svgTextUtils.positionText, 0, xa.side === 'top' ? outerTop - tbb.bottom - HOVERARROWSIZE - HOVERTEXTPAD : outerTop - tbb.top + HOVERARROWSIZE + HOVERTEXTPAD);
      lx = xa._offset + (c0.x0 + c0.x1) / 2;
      ly = ya._offset + (xa.side === 'top' ? 0 : ya._length);
      var halfWidth = tbb.width / 2 + HOVERTEXTPAD;
      var tooltipMidX = lx;
      if (lx < halfWidth) {
        tooltipMidX = halfWidth;
      } else if (lx > fullLayout.width - halfWidth) {
        tooltipMidX = fullLayout.width - halfWidth;
      }
      lpath.attr('d', 'M' + (lx - tooltipMidX) + ',0' + 'L' + (lx - tooltipMidX + HOVERARROWSIZE) + ',' + topsign + HOVERARROWSIZE + 'H' + halfWidth + 'v' + topsign + (HOVERTEXTPAD * 2 + tbb.height) + 'H' + -halfWidth + 'V' + topsign + HOVERARROWSIZE + 'H' + (lx - tooltipMidX - HOVERARROWSIZE) + 'Z');
      lx = tooltipMidX;
      commonLabelRect.minX = lx - halfWidth;
      commonLabelRect.maxX = lx + halfWidth;
      if (xa.side === 'top') {
        // label on negative y side
        commonLabelRect.minY = ly - (HOVERTEXTPAD * 2 + tbb.height);
        commonLabelRect.maxY = ly - HOVERTEXTPAD;
      } else {
        commonLabelRect.minY = ly + HOVERTEXTPAD;
        commonLabelRect.maxY = ly + (HOVERTEXTPAD * 2 + tbb.height);
      }
    } else {
      var anchor;
      var sgn;
      var leftsign;
      if (ya.side === 'right') {
        anchor = 'start';
        sgn = 1;
        leftsign = '';
        lx = xa._offset + xa._length;
      } else {
        anchor = 'end';
        sgn = -1;
        leftsign = '-';
        lx = xa._offset;
      }
      ly = ya._offset + (c0.y0 + c0.y1) / 2;
      ltext.attr('text-anchor', anchor);
      lpath.attr('d', 'M0,0' + 'L' + leftsign + HOVERARROWSIZE + ',' + HOVERARROWSIZE + 'V' + (HOVERTEXTPAD + tbb.height / 2) + 'h' + leftsign + (HOVERTEXTPAD * 2 + tbb.width) + 'V-' + (HOVERTEXTPAD + tbb.height / 2) + 'H' + leftsign + HOVERARROWSIZE + 'V-' + HOVERARROWSIZE + 'Z');
      commonLabelRect.minY = ly - (HOVERTEXTPAD + tbb.height / 2);
      commonLabelRect.maxY = ly + (HOVERTEXTPAD + tbb.height / 2);
      if (ya.side === 'right') {
        commonLabelRect.minX = lx + HOVERARROWSIZE;
        commonLabelRect.maxX = lx + HOVERARROWSIZE + (HOVERTEXTPAD * 2 + tbb.width);
      } else {
        // label on negative x side
        commonLabelRect.minX = lx - HOVERARROWSIZE - (HOVERTEXTPAD * 2 + tbb.width);
        commonLabelRect.maxX = lx - HOVERARROWSIZE;
      }
      var halfHeight = tbb.height / 2;
      var lty = outerTop - tbb.top - halfHeight;
      var clipId = 'clip' + fullLayout._uid + 'commonlabel' + ya._id;
      var clipPath;
      if (lx < tbb.width + 2 * HOVERTEXTPAD + HOVERARROWSIZE) {
        clipPath = 'M-' + (HOVERARROWSIZE + HOVERTEXTPAD) + '-' + halfHeight + 'h-' + (tbb.width - HOVERTEXTPAD) + 'V' + halfHeight + 'h' + (tbb.width - HOVERTEXTPAD) + 'Z';
        var ltx = tbb.width - lx + HOVERTEXTPAD;
        svgTextUtils.positionText(ltext, ltx, lty);

        // shift each line (except the longest) so that start-of-line
        // is always visible
        if (anchor === 'end') {
          ltext.selectAll('tspan').each(function () {
            var s = d3.select(this);
            var dummy = Drawing.tester.append('text').text(s.text()).call(Drawing.font, commonLabelFont);
            var dummyBB = getBoundingClientRect(gd, dummy.node());
            if (Math.round(dummyBB.width) < Math.round(tbb.width)) {
              s.attr('x', ltx - dummyBB.width);
            }
            dummy.remove();
          });
        }
      } else {
        svgTextUtils.positionText(ltext, sgn * (HOVERTEXTPAD + HOVERARROWSIZE), lty);
        clipPath = null;
      }
      var textClip = fullLayout._topclips.selectAll('#' + clipId).data(clipPath ? [0] : []);
      textClip.enter().append('clipPath').attr('id', clipId).append('path');
      textClip.exit().remove();
      textClip.select('path').attr('d', clipPath);
      Drawing.setClipUrl(ltext, clipPath ? clipId : null, gd);
    }
    label.attr('transform', strTranslate(lx, ly));
  });

  // Show a single hover label
  if (helpers.isUnifiedHover(hovermode)) {
    // Delete leftover hover labels from other hovermodes
    container.selectAll('g.hovertext').remove();
    var groupedHoverData = hoverData.filter(function (data) {
      return data.hoverinfo !== 'none';
    });
    // Return early if nothing is hovered on
    if (groupedHoverData.length === 0) return [];

    // mock legend
    var hoverlabel = fullLayout.hoverlabel;
    var font = hoverlabel.font;
    var mockLayoutIn = {
      showlegend: true,
      legend: {
        title: {
          text: t0,
          font: font
        },
        font: font,
        bgcolor: hoverlabel.bgcolor,
        bordercolor: hoverlabel.bordercolor,
        borderwidth: 1,
        tracegroupgap: 7,
        traceorder: fullLayout.legend ? fullLayout.legend.traceorder : undefined,
        orientation: 'v'
      }
    };
    var mockLayoutOut = {
      font: font
    };
    legendSupplyDefaults(mockLayoutIn, mockLayoutOut, gd._fullData);
    var mockLegend = mockLayoutOut.legend;

    // prepare items for the legend
    mockLegend.entries = [];
    for (var j = 0; j < groupedHoverData.length; j++) {
      var pt = groupedHoverData[j];
      if (pt.hoverinfo === 'none') continue;
      var texts = getHoverLabelText(pt, true, hovermode, fullLayout, t0);
      var text = texts[0];
      var name = texts[1];
      pt.name = name;
      if (name !== '') {
        pt.text = name + ' : ' + text;
      } else {
        pt.text = text;
      }

      // pass through marker's calcdata to style legend items
      var cd = pt.cd[pt.index];
      if (cd) {
        if (cd.mc) pt.mc = cd.mc;
        if (cd.mcc) pt.mc = cd.mcc;
        if (cd.mlc) pt.mlc = cd.mlc;
        if (cd.mlcc) pt.mlc = cd.mlcc;
        if (cd.mlw) pt.mlw = cd.mlw;
        if (cd.mrc) pt.mrc = cd.mrc;
        if (cd.dir) pt.dir = cd.dir;
      }
      pt._distinct = true;
      mockLegend.entries.push([pt]);
    }
    mockLegend.entries.sort(function (a, b) {
      return a[0].trace.index - b[0].trace.index;
    });
    mockLegend.layer = container;

    // Draw unified hover label
    mockLegend._inHover = true;
    mockLegend._groupTitleFont = hoverlabel.grouptitlefont;
    legendDraw(gd, mockLegend);

    // Position the hover
    var legendContainer = container.select('g.legend');
    var tbb = getBoundingClientRect(gd, legendContainer.node());
    var tWidth = tbb.width + 2 * HOVERTEXTPAD;
    var tHeight = tbb.height + 2 * HOVERTEXTPAD;
    var winningPoint = groupedHoverData[0];
    var avgX = (winningPoint.x0 + winningPoint.x1) / 2;
    var avgY = (winningPoint.y0 + winningPoint.y1) / 2;
    // When a scatter (or e.g. heatmap) point wins, it's OK for the hovelabel to occlude the bar and other points.
    var pointWon = !(Registry.traceIs(winningPoint.trace, 'bar-like') || Registry.traceIs(winningPoint.trace, 'box-violin'));
    var lyBottom, lyTop;
    if (axLetter === 'y') {
      if (pointWon) {
        lyTop = avgY - HOVERTEXTPAD;
        lyBottom = avgY + HOVERTEXTPAD;
      } else {
        lyTop = Math.min.apply(null, groupedHoverData.map(function (c) {
          return Math.min(c.y0, c.y1);
        }));
        lyBottom = Math.max.apply(null, groupedHoverData.map(function (c) {
          return Math.max(c.y0, c.y1);
        }));
      }
    } else {
      lyTop = lyBottom = Lib.mean(groupedHoverData.map(function (c) {
        return (c.y0 + c.y1) / 2;
      })) - tHeight / 2;
    }
    var lxRight, lxLeft;
    if (axLetter === 'x') {
      if (pointWon) {
        lxRight = avgX + HOVERTEXTPAD;
        lxLeft = avgX - HOVERTEXTPAD;
      } else {
        lxRight = Math.max.apply(null, groupedHoverData.map(function (c) {
          return Math.max(c.x0, c.x1);
        }));
        lxLeft = Math.min.apply(null, groupedHoverData.map(function (c) {
          return Math.min(c.x0, c.x1);
        }));
      }
    } else {
      lxRight = lxLeft = Lib.mean(groupedHoverData.map(function (c) {
        return (c.x0 + c.x1) / 2;
      })) - tWidth / 2;
    }
    var xOffset = xa._offset;
    var yOffset = ya._offset;
    lyBottom += yOffset;
    lxRight += xOffset;
    lxLeft += xOffset - tWidth;
    lyTop += yOffset - tHeight;
    var lx, ly; // top and left positions of the hover box

    // horizontal alignment to end up on screen
    if (lxRight + tWidth < outerWidth && lxRight >= 0) {
      lx = lxRight;
    } else if (lxLeft + tWidth < outerWidth && lxLeft >= 0) {
      lx = lxLeft;
    } else if (xOffset + tWidth < outerWidth) {
      lx = xOffset; // subplot left corner
    } else {
      // closest left or right side of the paper
      if (lxRight - avgX < avgX - lxLeft + tWidth) {
        lx = outerWidth - tWidth;
      } else {
        lx = 0;
      }
    }
    lx += HOVERTEXTPAD;

    // vertical alignement to end up on screen
    if (lyBottom + tHeight < outerHeight && lyBottom >= 0) {
      ly = lyBottom;
    } else if (lyTop + tHeight < outerHeight && lyTop >= 0) {
      ly = lyTop;
    } else if (yOffset + tHeight < outerHeight) {
      ly = yOffset; // subplot top corner
    } else {
      // closest top or bottom side of the paper
      if (lyBottom - avgY < avgY - lyTop + tHeight) {
        ly = outerHeight - tHeight;
      } else {
        ly = 0;
      }
    }
    ly += HOVERTEXTPAD;
    legendContainer.attr('transform', strTranslate(lx - 1, ly - 1));
    return legendContainer;
  }

  // show all the individual labels

  // first create the objects
  var hoverLabels = container.selectAll('g.hovertext').data(hoverData, function (d) {
    // N.B. when multiple items have the same result key-function value,
    // only the first of those items in hoverData gets rendered
    return hoverDataKey(d);
  });
  hoverLabels.enter().append('g').classed('hovertext', true).each(function () {
    var g = d3.select(this);
    // trace name label (rect and text.name)
    g.append('rect').call(Color.fill, Color.addOpacity(bgColor, 0.8));
    g.append('text').classed('name', true);
    // trace data label (path and text.nums)
    g.append('path').style('stroke-width', '1px');
    g.append('text').classed('nums', true).call(Drawing.font, {
      weight: fontWeight,
      style: fontStyle,
      variant: fontVariant,
      family: fontFamily,
      size: fontSize
    });
  });
  hoverLabels.exit().remove();

  // then put the text in, position the pointer to the data,
  // and figure out sizes
  hoverLabels.each(function (d) {
    var g = d3.select(this).attr('transform', '');
    var dColor = d.color;
    if (Array.isArray(dColor)) {
      dColor = dColor[d.eventData[0].pointNumber];
    }

    // combine possible non-opaque trace color with bgColor
    var color0 = d.bgcolor || dColor;
    // color for 'nums' part of the label
    var numsColor = Color.combine(Color.opacity(color0) ? color0 : Color.defaultLine, bgColor);
    // color for 'name' part of the label
    var nameColor = Color.combine(Color.opacity(dColor) ? dColor : Color.defaultLine, bgColor);
    // find a contrasting color for border and text
    var contrastColor = d.borderColor || Color.contrast(numsColor);
    var texts = getHoverLabelText(d, showCommonLabel, hovermode, fullLayout, t0, g);
    var text = texts[0];
    var name = texts[1];

    // main label
    var tx = g.select('text.nums').call(Drawing.font, {
      family: d.fontFamily || fontFamily,
      size: d.fontSize || fontSize,
      color: d.fontColor || contrastColor,
      weight: d.fontWeight || fontWeight,
      style: d.fontStyle || fontStyle,
      variant: d.fontVariant || fontVariant
    }).text(text).attr('data-notex', 1).call(svgTextUtils.positionText, 0, 0).call(svgTextUtils.convertToTspans, gd);
    var tx2 = g.select('text.name');
    var tx2width = 0;
    var tx2height = 0;

    // secondary label for non-empty 'name'
    if (name && name !== text) {
      tx2.call(Drawing.font, {
        family: d.fontFamily || fontFamily,
        size: d.fontSize || fontSize,
        color: nameColor,
        weight: d.fontWeight || fontWeight,
        style: d.fontStyle || fontStyle,
        variant: d.fontVariant || fontVariant
      }).text(name).attr('data-notex', 1).call(svgTextUtils.positionText, 0, 0).call(svgTextUtils.convertToTspans, gd);
      var t2bb = getBoundingClientRect(gd, tx2.node());
      tx2width = t2bb.width + 2 * HOVERTEXTPAD;
      tx2height = t2bb.height + 2 * HOVERTEXTPAD;
    } else {
      tx2.remove();
      g.select('rect').remove();
    }
    g.select('path').style({
      fill: numsColor,
      stroke: contrastColor
    });
    var htx = d.xa._offset + (d.x0 + d.x1) / 2;
    var hty = d.ya._offset + (d.y0 + d.y1) / 2;
    var dx = Math.abs(d.x1 - d.x0);
    var dy = Math.abs(d.y1 - d.y0);
    var tbb = getBoundingClientRect(gd, tx.node());
    var tbbWidth = tbb.width / fullLayout._invScaleX;
    var tbbHeight = tbb.height / fullLayout._invScaleY;
    d.ty0 = (outerTop - tbb.top) / fullLayout._invScaleY;
    d.bx = tbbWidth + 2 * HOVERTEXTPAD;
    d.by = Math.max(tbbHeight + 2 * HOVERTEXTPAD, tx2height);
    d.anchor = 'start';
    d.txwidth = tbbWidth;
    d.tx2width = tx2width;
    d.offset = 0;
    var txTotalWidth = (tbbWidth + HOVERARROWSIZE + HOVERTEXTPAD + tx2width) * fullLayout._invScaleX;
    var anchorStartOK, anchorEndOK;
    if (rotateLabels) {
      d.pos = htx;
      anchorStartOK = hty + dy / 2 + txTotalWidth <= outerHeight;
      anchorEndOK = hty - dy / 2 - txTotalWidth >= 0;
      if ((d.idealAlign === 'top' || !anchorStartOK) && anchorEndOK) {
        hty -= dy / 2;
        d.anchor = 'end';
      } else if (anchorStartOK) {
        hty += dy / 2;
        d.anchor = 'start';
      } else {
        d.anchor = 'middle';
      }
      d.crossPos = hty;
    } else {
      d.pos = hty;
      anchorStartOK = htx + dx / 2 + txTotalWidth <= outerWidth;
      anchorEndOK = htx - dx / 2 - txTotalWidth >= 0;
      if ((d.idealAlign === 'left' || !anchorStartOK) && anchorEndOK) {
        htx -= dx / 2;
        d.anchor = 'end';
      } else if (anchorStartOK) {
        htx += dx / 2;
        d.anchor = 'start';
      } else {
        d.anchor = 'middle';
        var txHalfWidth = txTotalWidth / 2;
        var overflowR = htx + txHalfWidth - outerWidth;
        var overflowL = htx - txHalfWidth;
        if (overflowR > 0) htx -= overflowR;
        if (overflowL < 0) htx += -overflowL;
      }
      d.crossPos = htx;
    }
    tx.attr('text-anchor', d.anchor);
    if (tx2width) tx2.attr('text-anchor', d.anchor);
    g.attr('transform', strTranslate(htx, hty) + (rotateLabels ? strRotate(YANGLE) : ''));
  });
  return {
    hoverLabels: hoverLabels,
    commonLabelBoundingBox: commonLabelRect
  };
}
function getHoverLabelText(d, showCommonLabel, hovermode, fullLayout, t0, g) {
  var name = '';
  var text = '';
  // to get custom 'name' labels pass cleanPoint
  if (d.nameOverride !== undefined) d.name = d.nameOverride;
  if (d.name) {
    if (d.trace._meta) {
      d.name = Lib.templateString(d.name, d.trace._meta);
    }
    name = plainText(d.name, d.nameLength);
  }
  var h0 = hovermode.charAt(0);
  var h1 = h0 === 'x' ? 'y' : 'x';
  if (d.zLabel !== undefined) {
    if (d.xLabel !== undefined) text += 'x: ' + d.xLabel + '<br>';
    if (d.yLabel !== undefined) text += 'y: ' + d.yLabel + '<br>';
    if (d.trace.type !== 'choropleth' && d.trace.type !== 'choroplethmapbox') {
      text += (text ? 'z: ' : '') + d.zLabel;
    }
  } else if (showCommonLabel && d[h0 + 'Label'] === t0) {
    text = d[h1 + 'Label'] || '';
  } else if (d.xLabel === undefined) {
    if (d.yLabel !== undefined && d.trace.type !== 'scattercarpet') {
      text = d.yLabel;
    }
  } else if (d.yLabel === undefined) text = d.xLabel;else text = '(' + d.xLabel + ', ' + d.yLabel + ')';
  if ((d.text || d.text === 0) && !Array.isArray(d.text)) {
    text += (text ? '<br>' : '') + d.text;
  }

  // used by other modules (initially just ternary) that
  // manage their own hoverinfo independent of cleanPoint
  // the rest of this will still apply, so such modules
  // can still put things in (x|y|z)Label, text, and name
  // and hoverinfo will still determine their visibility
  if (d.extraText !== undefined) text += (text ? '<br>' : '') + d.extraText;

  // if 'text' is empty at this point,
  // and hovertemplate is not defined,
  // put 'name' in main label and don't show secondary label
  if (g && text === '' && !d.hovertemplate) {
    // if 'name' is also empty, remove entire label
    if (name === '') g.remove();
    text = name;
  }

  // hovertemplate
  var hovertemplate = d.hovertemplate || false;
  if (hovertemplate) {
    var labels = d.hovertemplateLabels || d;
    if (d[h0 + 'Label'] !== t0) {
      labels[h0 + 'other'] = labels[h0 + 'Val'];
      labels[h0 + 'otherLabel'] = labels[h0 + 'Label'];
    }
    text = Lib.hovertemplateString(hovertemplate, labels, fullLayout._d3locale, d.eventData[0] || {}, d.trace._meta);
    text = text.replace(EXTRA_STRING_REGEX, function (match, extra) {
      // assign name for secondary text label
      name = plainText(extra, d.nameLength);
      // remove from main text label
      return '';
    });
  }
  return [text, name];
}

// Make groups of touching points, and within each group
// move each point so that no labels overlap, but the average
// label position is the same as it was before moving. Incidentally,
// this is equivalent to saying all the labels are on equal linear
// springs about their initial position. Initially, each point is
// its own group, but as we find overlaps we will clump the points.
//
// Also, there are hard constraints at the edges of the graphs,
// that push all groups to the middle so they are visible. I don't
// know what happens if the group spans all the way from one edge to
// the other, though it hardly matters - there's just too much
// information then.
function hoverAvoidOverlaps(hoverLabels, rotateLabels, fullLayout, commonLabelBoundingBox) {
  var axKey = rotateLabels ? 'xa' : 'ya';
  var crossAxKey = rotateLabels ? 'ya' : 'xa';
  var nummoves = 0;
  var axSign = 1;
  var nLabels = hoverLabels.size();

  // make groups of touching points
  var pointgroups = new Array(nLabels);
  var k = 0;

  // get extent of axis hover label
  var axisLabelMinX = commonLabelBoundingBox.minX;
  var axisLabelMaxX = commonLabelBoundingBox.maxX;
  var axisLabelMinY = commonLabelBoundingBox.minY;
  var axisLabelMaxY = commonLabelBoundingBox.maxY;
  var pX = function (x) {
    return x * fullLayout._invScaleX;
  };
  var pY = function (y) {
    return y * fullLayout._invScaleY;
  };
  hoverLabels.each(function (d) {
    var ax = d[axKey];
    var crossAx = d[crossAxKey];
    var axIsX = ax._id.charAt(0) === 'x';
    var rng = ax.range;
    if (k === 0 && rng && rng[0] > rng[1] !== axIsX) {
      axSign = -1;
    }
    var pmin = 0;
    var pmax = axIsX ? fullLayout.width : fullLayout.height;
    // in hovermode avoid overlap between hover labels and axis label
    if (fullLayout.hovermode === 'x' || fullLayout.hovermode === 'y') {
      // extent of rect behind hover label on cross axis:
      var offsets = getHoverLabelOffsets(d, rotateLabels);
      var anchor = d.anchor;
      var horzSign = anchor === 'end' ? -1 : 1;
      var labelMin;
      var labelMax;
      if (anchor === 'middle') {
        // use extent of centered rect either on x or y axis depending on current axis
        labelMin = d.crossPos + (axIsX ? pY(offsets.y - d.by / 2) : pX(d.bx / 2 + d.tx2width / 2));
        labelMax = labelMin + (axIsX ? pY(d.by) : pX(d.bx));
      } else {
        // use extend of path (see alignHoverText function) without arrow
        if (axIsX) {
          labelMin = d.crossPos + pY(HOVERARROWSIZE + offsets.y) - pY(d.by / 2 - HOVERARROWSIZE);
          labelMax = labelMin + pY(d.by);
        } else {
          var startX = pX(horzSign * HOVERARROWSIZE + offsets.x);
          var endX = startX + pX(horzSign * d.bx);
          labelMin = d.crossPos + Math.min(startX, endX);
          labelMax = d.crossPos + Math.max(startX, endX);
        }
      }
      if (axIsX) {
        if (axisLabelMinY !== undefined && axisLabelMaxY !== undefined && Math.min(labelMax, axisLabelMaxY) - Math.max(labelMin, axisLabelMinY) > 1) {
          // has at least 1 pixel overlap with axis label
          if (crossAx.side === 'left') {
            pmin = crossAx._mainLinePosition;
            pmax = fullLayout.width;
          } else {
            pmax = crossAx._mainLinePosition;
          }
        }
      } else {
        if (axisLabelMinX !== undefined && axisLabelMaxX !== undefined && Math.min(labelMax, axisLabelMaxX) - Math.max(labelMin, axisLabelMinX) > 1) {
          // has at least 1 pixel overlap with axis label
          if (crossAx.side === 'top') {
            pmin = crossAx._mainLinePosition;
            pmax = fullLayout.height;
          } else {
            pmax = crossAx._mainLinePosition;
          }
        }
      }
    }
    pointgroups[k++] = [{
      datum: d,
      traceIndex: d.trace.index,
      dp: 0,
      pos: d.pos,
      posref: d.posref,
      size: d.by * (axIsX ? YFACTOR : 1) / 2,
      pmin: pmin,
      pmax: pmax
    }];
  });
  pointgroups.sort(function (a, b) {
    return a[0].posref - b[0].posref ||
    // for equal positions, sort trace indices increasing or decreasing
    // depending on whether the axis is reversed or not... so stacked
    // traces will generally keep their order even if one trace adds
    // nothing to the stack.
    axSign * (b[0].traceIndex - a[0].traceIndex);
  });
  var donepositioning, topOverlap, bottomOverlap, i, j, pti, sumdp;
  function constrainGroup(grp) {
    var minPt = grp[0];
    var maxPt = grp[grp.length - 1];

    // overlap with the top - positive vals are overlaps
    topOverlap = minPt.pmin - minPt.pos - minPt.dp + minPt.size;

    // overlap with the bottom - positive vals are overlaps
    bottomOverlap = maxPt.pos + maxPt.dp + maxPt.size - minPt.pmax;

    // check for min overlap first, so that we always
    // see the largest labels
    // allow for .01px overlap, so we don't get an
    // infinite loop from rounding errors
    if (topOverlap > 0.01) {
      for (j = grp.length - 1; j >= 0; j--) grp[j].dp += topOverlap;
      donepositioning = false;
    }
    if (bottomOverlap < 0.01) return;
    if (topOverlap < -0.01) {
      // make sure we're not pushing back and forth
      for (j = grp.length - 1; j >= 0; j--) grp[j].dp -= bottomOverlap;
      donepositioning = false;
    }
    if (!donepositioning) return;

    // no room to fix positioning, delete off-screen points

    // first see how many points we need to delete
    var deleteCount = 0;
    for (i = 0; i < grp.length; i++) {
      pti = grp[i];
      if (pti.pos + pti.dp + pti.size > minPt.pmax) deleteCount++;
    }

    // start by deleting points whose data is off screen
    for (i = grp.length - 1; i >= 0; i--) {
      if (deleteCount <= 0) break;
      pti = grp[i];

      // pos has already been constrained to [pmin,pmax]
      // so look for points close to that to delete
      if (pti.pos > minPt.pmax - 1) {
        pti.del = true;
        deleteCount--;
      }
    }
    for (i = 0; i < grp.length; i++) {
      if (deleteCount <= 0) break;
      pti = grp[i];

      // pos has already been constrained to [pmin,pmax]
      // so look for points close to that to delete
      if (pti.pos < minPt.pmin + 1) {
        pti.del = true;
        deleteCount--;

        // shift the whole group minus into this new space
        bottomOverlap = pti.size * 2;
        for (j = grp.length - 1; j >= 0; j--) grp[j].dp -= bottomOverlap;
      }
    }
    // then delete points that go off the bottom
    for (i = grp.length - 1; i >= 0; i--) {
      if (deleteCount <= 0) break;
      pti = grp[i];
      if (pti.pos + pti.dp + pti.size > minPt.pmax) {
        pti.del = true;
        deleteCount--;
      }
    }
  }

  // loop through groups, combining them if they overlap,
  // until nothing moves
  while (!donepositioning && nummoves <= nLabels) {
    // to avoid infinite loops, don't move more times
    // than there are traces
    nummoves++;

    // assume nothing will move in this iteration,
    // reverse this if it does
    donepositioning = true;
    i = 0;
    while (i < pointgroups.length - 1) {
      // the higher (g0) and lower (g1) point group
      var g0 = pointgroups[i];
      var g1 = pointgroups[i + 1];

      // the lowest point in the higher group (p0)
      // the highest point in the lower group (p1)
      var p0 = g0[g0.length - 1];
      var p1 = g1[0];
      topOverlap = p0.pos + p0.dp + p0.size - p1.pos - p1.dp + p1.size;

      // Only group points that lie on the same axes
      if (topOverlap > 0.01 && p0.pmin === p1.pmin && p0.pmax === p1.pmax) {
        // push the new point(s) added to this group out of the way
        for (j = g1.length - 1; j >= 0; j--) g1[j].dp += topOverlap;

        // add them to the group
        g0.push.apply(g0, g1);
        pointgroups.splice(i + 1, 1);

        // adjust for minimum average movement
        sumdp = 0;
        for (j = g0.length - 1; j >= 0; j--) sumdp += g0[j].dp;
        bottomOverlap = sumdp / g0.length;
        for (j = g0.length - 1; j >= 0; j--) g0[j].dp -= bottomOverlap;
        donepositioning = false;
      } else i++;
    }

    // check if we're going off the plot on either side and fix
    pointgroups.forEach(constrainGroup);
  }

  // now put these offsets into hoverData
  for (i = pointgroups.length - 1; i >= 0; i--) {
    var grp = pointgroups[i];
    for (j = grp.length - 1; j >= 0; j--) {
      var pt = grp[j];
      var hoverPt = pt.datum;
      hoverPt.offset = pt.dp;
      hoverPt.del = pt.del;
    }
  }
}
function getHoverLabelOffsets(hoverLabel, rotateLabels) {
  var offsetX = 0;
  var offsetY = hoverLabel.offset;
  if (rotateLabels) {
    offsetY *= -YSHIFTY;
    offsetX = hoverLabel.offset * YSHIFTX;
  }
  return {
    x: offsetX,
    y: offsetY
  };
}

/**
 * Calculate the shift in x for text and text2 elements
 */
function getTextShiftX(hoverLabel) {
  var alignShift = {
    start: 1,
    end: -1,
    middle: 0
  }[hoverLabel.anchor];
  var textShiftX = alignShift * (HOVERARROWSIZE + HOVERTEXTPAD);
  var text2ShiftX = textShiftX + alignShift * (hoverLabel.txwidth + HOVERTEXTPAD);
  var isMiddle = hoverLabel.anchor === 'middle';
  if (isMiddle) {
    textShiftX -= hoverLabel.tx2width / 2;
    text2ShiftX += hoverLabel.txwidth / 2 + HOVERTEXTPAD;
  }
  return {
    alignShift: alignShift,
    textShiftX: textShiftX,
    text2ShiftX: text2ShiftX
  };
}
function alignHoverText(hoverLabels, rotateLabels, scaleX, scaleY) {
  var pX = function (x) {
    return x * scaleX;
  };
  var pY = function (y) {
    return y * scaleY;
  };

  // finally set the text positioning relative to the data and draw the
  // box around it
  hoverLabels.each(function (d) {
    var g = d3.select(this);
    if (d.del) return g.remove();
    var tx = g.select('text.nums');
    var anchor = d.anchor;
    var horzSign = anchor === 'end' ? -1 : 1;
    var shiftX = getTextShiftX(d);
    var offsets = getHoverLabelOffsets(d, rotateLabels);
    var offsetX = offsets.x;
    var offsetY = offsets.y;
    var isMiddle = anchor === 'middle';
    g.select('path').attr('d', isMiddle ?
    // middle aligned: rect centered on data
    'M-' + pX(d.bx / 2 + d.tx2width / 2) + ',' + pY(offsetY - d.by / 2) + 'h' + pX(d.bx) + 'v' + pY(d.by) + 'h-' + pX(d.bx) + 'Z' :
    // left or right aligned: side rect with arrow to data
    'M0,0L' + pX(horzSign * HOVERARROWSIZE + offsetX) + ',' + pY(HOVERARROWSIZE + offsetY) + 'v' + pY(d.by / 2 - HOVERARROWSIZE) + 'h' + pX(horzSign * d.bx) + 'v-' + pY(d.by) + 'H' + pX(horzSign * HOVERARROWSIZE + offsetX) + 'V' + pY(offsetY - HOVERARROWSIZE) + 'Z');
    var posX = offsetX + shiftX.textShiftX;
    var posY = offsetY + d.ty0 - d.by / 2 + HOVERTEXTPAD;
    var textAlign = d.textAlign || 'auto';
    if (textAlign !== 'auto') {
      if (textAlign === 'left' && anchor !== 'start') {
        tx.attr('text-anchor', 'start');
        posX = isMiddle ? -d.bx / 2 - d.tx2width / 2 + HOVERTEXTPAD : -d.bx - HOVERTEXTPAD;
      } else if (textAlign === 'right' && anchor !== 'end') {
        tx.attr('text-anchor', 'end');
        posX = isMiddle ? d.bx / 2 - d.tx2width / 2 - HOVERTEXTPAD : d.bx + HOVERTEXTPAD;
      }
    }
    tx.call(svgTextUtils.positionText, pX(posX), pY(posY));
    if (d.tx2width) {
      g.select('text.name').call(svgTextUtils.positionText, pX(shiftX.text2ShiftX + shiftX.alignShift * HOVERTEXTPAD + offsetX), pY(offsetY + d.ty0 - d.by / 2 + HOVERTEXTPAD));
      g.select('rect').call(Drawing.setRect, pX(shiftX.text2ShiftX + (shiftX.alignShift - 1) * d.tx2width / 2 + offsetX), pY(offsetY - d.by / 2 - 1), pX(d.tx2width), pY(d.by + 2));
    }
  });
}
function cleanPoint(d, hovermode) {
  var index = d.index;
  var trace = d.trace || {};
  var cd0 = d.cd[0];
  var cd = d.cd[index] || {};
  function pass(v) {
    return v || isNumeric(v) && v === 0;
  }
  var getVal = Array.isArray(index) ? function (calcKey, traceKey) {
    var v = Lib.castOption(cd0, index, calcKey);
    return pass(v) ? v : Lib.extractOption({}, trace, '', traceKey);
  } : function (calcKey, traceKey) {
    return Lib.extractOption(cd, trace, calcKey, traceKey);
  };
  function fill(key, calcKey, traceKey) {
    var val = getVal(calcKey, traceKey);
    if (pass(val)) d[key] = val;
  }
  fill('hoverinfo', 'hi', 'hoverinfo');
  fill('bgcolor', 'hbg', 'hoverlabel.bgcolor');
  fill('borderColor', 'hbc', 'hoverlabel.bordercolor');
  fill('fontFamily', 'htf', 'hoverlabel.font.family');
  fill('fontSize', 'hts', 'hoverlabel.font.size');
  fill('fontColor', 'htc', 'hoverlabel.font.color');
  fill('fontWeight', 'htw', 'hoverlabel.font.weight');
  fill('fontStyle', 'hty', 'hoverlabel.font.style');
  fill('fontVariant', 'htv', 'hoverlabel.font.variant');
  fill('nameLength', 'hnl', 'hoverlabel.namelength');
  fill('textAlign', 'hta', 'hoverlabel.align');
  d.posref = hovermode === 'y' || hovermode === 'closest' && trace.orientation === 'h' ? d.xa._offset + (d.x0 + d.x1) / 2 : d.ya._offset + (d.y0 + d.y1) / 2;

  // then constrain all the positions to be on the plot
  d.x0 = Lib.constrain(d.x0, 0, d.xa._length);
  d.x1 = Lib.constrain(d.x1, 0, d.xa._length);
  d.y0 = Lib.constrain(d.y0, 0, d.ya._length);
  d.y1 = Lib.constrain(d.y1, 0, d.ya._length);

  // and convert the x and y label values into formatted text
  if (d.xLabelVal !== undefined) {
    d.xLabel = 'xLabel' in d ? d.xLabel : Axes.hoverLabelText(d.xa, d.xLabelVal, trace.xhoverformat);
    d.xVal = d.xa.c2d(d.xLabelVal);
  }
  if (d.yLabelVal !== undefined) {
    d.yLabel = 'yLabel' in d ? d.yLabel : Axes.hoverLabelText(d.ya, d.yLabelVal, trace.yhoverformat);
    d.yVal = d.ya.c2d(d.yLabelVal);
  }

  // Traces like heatmaps generate the zLabel in their hoverPoints function
  if (d.zLabelVal !== undefined && d.zLabel === undefined) {
    d.zLabel = String(d.zLabelVal);
  }

  // for box means and error bars, add the range to the label
  if (!isNaN(d.xerr) && !(d.xa.type === 'log' && d.xerr <= 0)) {
    var xeText = Axes.tickText(d.xa, d.xa.c2l(d.xerr), 'hover').text;
    if (d.xerrneg !== undefined) {
      d.xLabel += ' +' + xeText + ' / -' + Axes.tickText(d.xa, d.xa.c2l(d.xerrneg), 'hover').text;
    } else d.xLabel += ' ± ' + xeText;

    // small distance penalty for error bars, so that if there are
    // traces with errors and some without, the error bar label will
    // hoist up to the point
    if (hovermode === 'x') d.distance += 1;
  }
  if (!isNaN(d.yerr) && !(d.ya.type === 'log' && d.yerr <= 0)) {
    var yeText = Axes.tickText(d.ya, d.ya.c2l(d.yerr), 'hover').text;
    if (d.yerrneg !== undefined) {
      d.yLabel += ' +' + yeText + ' / -' + Axes.tickText(d.ya, d.ya.c2l(d.yerrneg), 'hover').text;
    } else d.yLabel += ' ± ' + yeText;
    if (hovermode === 'y') d.distance += 1;
  }
  var infomode = d.hoverinfo || d.trace.hoverinfo;
  if (infomode && infomode !== 'all') {
    infomode = Array.isArray(infomode) ? infomode : infomode.split('+');
    if (infomode.indexOf('x') === -1) d.xLabel = undefined;
    if (infomode.indexOf('y') === -1) d.yLabel = undefined;
    if (infomode.indexOf('z') === -1) d.zLabel = undefined;
    if (infomode.indexOf('text') === -1) d.text = undefined;
    if (infomode.indexOf('name') === -1) d.name = undefined;
  }
  return d;
}
function createSpikelines(gd, closestPoints, opts) {
  var container = opts.container;
  var fullLayout = opts.fullLayout;
  var gs = fullLayout._size;
  var evt = opts.event;
  var showY = !!closestPoints.hLinePoint;
  var showX = !!closestPoints.vLinePoint;
  var xa, ya;

  // Remove old spikeline items
  container.selectAll('.spikeline').remove();
  if (!(showX || showY)) return;
  var contrastColor = Color.combine(fullLayout.plot_bgcolor, fullLayout.paper_bgcolor);

  // Horizontal line (to y-axis)
  if (showY) {
    var hLinePoint = closestPoints.hLinePoint;
    var hLinePointX, hLinePointY;
    xa = hLinePoint && hLinePoint.xa;
    ya = hLinePoint && hLinePoint.ya;
    var ySnap = ya.spikesnap;
    if (ySnap === 'cursor') {
      hLinePointX = evt.pointerX;
      hLinePointY = evt.pointerY;
    } else {
      hLinePointX = xa._offset + hLinePoint.x;
      hLinePointY = ya._offset + hLinePoint.y;
    }
    var dfltHLineColor = tinycolor.readability(hLinePoint.color, contrastColor) < 1.5 ? Color.contrast(contrastColor) : hLinePoint.color;
    var yMode = ya.spikemode;
    var yThickness = ya.spikethickness;
    var yColor = ya.spikecolor || dfltHLineColor;
    var xEdge = Axes.getPxPosition(gd, ya);
    var xBase, xEndSpike;
    if (yMode.indexOf('toaxis') !== -1 || yMode.indexOf('across') !== -1) {
      if (yMode.indexOf('toaxis') !== -1) {
        xBase = xEdge;
        xEndSpike = hLinePointX;
      }
      if (yMode.indexOf('across') !== -1) {
        var xAcross0 = ya._counterDomainMin;
        var xAcross1 = ya._counterDomainMax;
        if (ya.anchor === 'free') {
          xAcross0 = Math.min(xAcross0, ya.position);
          xAcross1 = Math.max(xAcross1, ya.position);
        }
        xBase = gs.l + xAcross0 * gs.w;
        xEndSpike = gs.l + xAcross1 * gs.w;
      }

      // Foreground horizontal line (to y-axis)
      container.insert('line', ':first-child').attr({
        x1: xBase,
        x2: xEndSpike,
        y1: hLinePointY,
        y2: hLinePointY,
        'stroke-width': yThickness,
        stroke: yColor,
        'stroke-dasharray': Drawing.dashStyle(ya.spikedash, yThickness)
      }).classed('spikeline', true).classed('crisp', true);

      // Background horizontal Line (to y-axis)
      container.insert('line', ':first-child').attr({
        x1: xBase,
        x2: xEndSpike,
        y1: hLinePointY,
        y2: hLinePointY,
        'stroke-width': yThickness + 2,
        stroke: contrastColor
      }).classed('spikeline', true).classed('crisp', true);
    }
    // Y axis marker
    if (yMode.indexOf('marker') !== -1) {
      container.insert('circle', ':first-child').attr({
        cx: xEdge + (ya.side !== 'right' ? yThickness : -yThickness),
        cy: hLinePointY,
        r: yThickness,
        fill: yColor
      }).classed('spikeline', true);
    }
  }
  if (showX) {
    var vLinePoint = closestPoints.vLinePoint;
    var vLinePointX, vLinePointY;
    xa = vLinePoint && vLinePoint.xa;
    ya = vLinePoint && vLinePoint.ya;
    var xSnap = xa.spikesnap;
    if (xSnap === 'cursor') {
      vLinePointX = evt.pointerX;
      vLinePointY = evt.pointerY;
    } else {
      vLinePointX = xa._offset + vLinePoint.x;
      vLinePointY = ya._offset + vLinePoint.y;
    }
    var dfltVLineColor = tinycolor.readability(vLinePoint.color, contrastColor) < 1.5 ? Color.contrast(contrastColor) : vLinePoint.color;
    var xMode = xa.spikemode;
    var xThickness = xa.spikethickness;
    var xColor = xa.spikecolor || dfltVLineColor;
    var yEdge = Axes.getPxPosition(gd, xa);
    var yBase, yEndSpike;
    if (xMode.indexOf('toaxis') !== -1 || xMode.indexOf('across') !== -1) {
      if (xMode.indexOf('toaxis') !== -1) {
        yBase = yEdge;
        yEndSpike = vLinePointY;
      }
      if (xMode.indexOf('across') !== -1) {
        var yAcross0 = xa._counterDomainMin;
        var yAcross1 = xa._counterDomainMax;
        if (xa.anchor === 'free') {
          yAcross0 = Math.min(yAcross0, xa.position);
          yAcross1 = Math.max(yAcross1, xa.position);
        }
        yBase = gs.t + (1 - yAcross1) * gs.h;
        yEndSpike = gs.t + (1 - yAcross0) * gs.h;
      }

      // Foreground vertical line (to x-axis)
      container.insert('line', ':first-child').attr({
        x1: vLinePointX,
        x2: vLinePointX,
        y1: yBase,
        y2: yEndSpike,
        'stroke-width': xThickness,
        stroke: xColor,
        'stroke-dasharray': Drawing.dashStyle(xa.spikedash, xThickness)
      }).classed('spikeline', true).classed('crisp', true);

      // Background vertical line (to x-axis)
      container.insert('line', ':first-child').attr({
        x1: vLinePointX,
        x2: vLinePointX,
        y1: yBase,
        y2: yEndSpike,
        'stroke-width': xThickness + 2,
        stroke: contrastColor
      }).classed('spikeline', true).classed('crisp', true);
    }

    // X axis marker
    if (xMode.indexOf('marker') !== -1) {
      container.insert('circle', ':first-child').attr({
        cx: vLinePointX,
        cy: yEdge - (xa.side !== 'top' ? xThickness : -xThickness),
        r: xThickness,
        fill: xColor
      }).classed('spikeline', true);
    }
  }
}
function hoverChanged(gd, evt, oldhoverdata) {
  // don't emit any events if nothing changed
  if (!oldhoverdata || oldhoverdata.length !== gd._hoverdata.length) return true;
  for (var i = oldhoverdata.length - 1; i >= 0; i--) {
    var oldPt = oldhoverdata[i];
    var newPt = gd._hoverdata[i];
    if (oldPt.curveNumber !== newPt.curveNumber || String(oldPt.pointNumber) !== String(newPt.pointNumber) || String(oldPt.pointNumbers) !== String(newPt.pointNumbers)) {
      return true;
    }
  }
  return false;
}
function spikesChanged(gd, oldspikepoints) {
  // don't relayout the plot because of new spikelines if spikelines points didn't change
  if (!oldspikepoints) return true;
  if (oldspikepoints.vLinePoint !== gd._spikepoints.vLinePoint || oldspikepoints.hLinePoint !== gd._spikepoints.hLinePoint) return true;
  return false;
}
function plainText(s, len) {
  return svgTextUtils.plainText(s || '', {
    len: len,
    allowedTags: ['br', 'sub', 'sup', 'b', 'i', 'em']
  });
}
function orderRangePoints(hoverData, hovermode) {
  var axLetter = hovermode.charAt(0);
  var first = [];
  var second = [];
  var last = [];
  for (var i = 0; i < hoverData.length; i++) {
    var d = hoverData[i];
    if (Registry.traceIs(d.trace, 'bar-like') || Registry.traceIs(d.trace, 'box-violin')) {
      last.push(d);
    } else if (d.trace[axLetter + 'period']) {
      second.push(d);
    } else {
      first.push(d);
    }
  }
  return first.concat(second).concat(last);
}
function getCoord(axLetter, winningPoint, fullLayout) {
  var ax = winningPoint[axLetter + 'a'];
  var val = winningPoint[axLetter + 'Val'];
  var cd0 = winningPoint.cd[0];
  if (ax.type === 'category' || ax.type === 'multicategory') val = ax._categoriesMap[val];else if (ax.type === 'date') {
    var periodalignment = winningPoint.trace[axLetter + 'periodalignment'];
    if (periodalignment) {
      var d = winningPoint.cd[winningPoint.index];
      var start = d[axLetter + 'Start'];
      if (start === undefined) start = d[axLetter];
      var end = d[axLetter + 'End'];
      if (end === undefined) end = d[axLetter];
      var diff = end - start;
      if (periodalignment === 'end') {
        val += diff;
      } else if (periodalignment === 'middle') {
        val += diff / 2;
      }
    }
    val = ax.d2c(val);
  }
  if (cd0 && cd0.t && cd0.t.posLetter === ax._id) {
    if (fullLayout.boxmode === 'group' || fullLayout.violinmode === 'group') {
      val += cd0.t.dPos;
    }
  }
  return val;
}

// Top/left hover offsets relative to graph div. As long as hover content is
// a sibling of the graph div, it will be positioned correctly relative to
// the offset parent, whatever that may be.
function getTopOffset(gd) {
  return gd.offsetTop + gd.clientTop;
}
function getLeftOffset(gd) {
  return gd.offsetLeft + gd.clientLeft;
}
function getBoundingClientRect(gd, node) {
  var fullLayout = gd._fullLayout;
  var rect = node.getBoundingClientRect();
  var x0 = rect.left;
  var y0 = rect.top;
  var x1 = x0 + rect.width;
  var y1 = y0 + rect.height;
  var A = Lib.apply3DTransform(fullLayout._invTransform)(x0, y0);
  var B = Lib.apply3DTransform(fullLayout._invTransform)(x1, y1);
  var Ax = A[0];
  var Ay = A[1];
  var Bx = B[0];
  var By = B[1];
  return {
    x: Ax,
    y: Ay,
    width: Bx - Ax,
    height: By - Ay,
    top: Math.min(Ay, By),
    left: Math.min(Ax, Bx),
    right: Math.max(Ax, Bx),
    bottom: Math.max(Ay, By)
  };
}

/***/ }),

/***/ 6132:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Color = __webpack_require__(6308);
var isUnifiedHover = (__webpack_require__(624).isUnifiedHover);
module.exports = function handleHoverLabelDefaults(contIn, contOut, coerce, opts) {
  opts = opts || {};
  var hasLegend = contOut.legend;
  function inheritFontAttr(attr) {
    if (!opts.font[attr]) {
      opts.font[attr] = hasLegend ? contOut.legend.font[attr] : contOut.font[attr];
    }
  }

  // In unified hover, inherit from layout.legend if available or layout
  if (contOut && isUnifiedHover(contOut.hovermode)) {
    if (!opts.font) opts.font = {};
    inheritFontAttr('size');
    inheritFontAttr('family');
    inheritFontAttr('color');
    inheritFontAttr('weight');
    inheritFontAttr('style');
    inheritFontAttr('variant');
    if (hasLegend) {
      if (!opts.bgcolor) opts.bgcolor = Color.combine(contOut.legend.bgcolor, contOut.paper_bgcolor);
      if (!opts.bordercolor) opts.bordercolor = contOut.legend.bordercolor;
    } else {
      if (!opts.bgcolor) opts.bgcolor = contOut.paper_bgcolor;
    }
  }
  coerce('hoverlabel.bgcolor', opts.bgcolor);
  coerce('hoverlabel.bordercolor', opts.bordercolor);
  coerce('hoverlabel.namelength', opts.namelength);
  Lib.coerceFont(coerce, 'hoverlabel.font', opts.font);
  coerce('hoverlabel.align', opts.align);
};

/***/ }),

/***/ 1008:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var layoutAttributes = __webpack_require__(5460);
module.exports = function handleHoverModeDefaults(layoutIn, layoutOut) {
  function coerce(attr, dflt) {
    // don't coerce if it is already coerced in other place e.g. in cartesian defaults
    if (layoutOut[attr] !== undefined) return layoutOut[attr];
    return Lib.coerce(layoutIn, layoutOut, layoutAttributes, attr, dflt);
  }
  coerce('clickmode');
  coerce('hoversubplots');
  return coerce('hovermode');
};

/***/ }),

/***/ 3024:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var Lib = __webpack_require__(3400);
var dragElement = __webpack_require__(6476);
var helpers = __webpack_require__(624);
var layoutAttributes = __webpack_require__(5460);
var hoverModule = __webpack_require__(3292);
module.exports = {
  moduleType: 'component',
  name: 'fx',
  constants: __webpack_require__(2456),
  schema: {
    layout: layoutAttributes
  },
  attributes: __webpack_require__(5756),
  layoutAttributes: layoutAttributes,
  supplyLayoutGlobalDefaults: __webpack_require__(1976),
  supplyDefaults: __webpack_require__(5448),
  supplyLayoutDefaults: __webpack_require__(8336),
  calc: __webpack_require__(5056),
  getDistanceFunction: helpers.getDistanceFunction,
  getClosest: helpers.getClosest,
  inbox: helpers.inbox,
  quadrature: helpers.quadrature,
  appendArrayPointValue: helpers.appendArrayPointValue,
  castHoverOption: castHoverOption,
  castHoverinfo: castHoverinfo,
  hover: hoverModule.hover,
  unhover: dragElement.unhover,
  loneHover: hoverModule.loneHover,
  loneUnhover: loneUnhover,
  click: __webpack_require__(2376)
};
function loneUnhover(containerOrSelection) {
  // duck type whether the arg is a d3 selection because ie9 doesn't
  // handle instanceof like modern browsers do.
  var selection = Lib.isD3Selection(containerOrSelection) ? containerOrSelection : d3.select(containerOrSelection);
  selection.selectAll('g.hovertext').remove();
  selection.selectAll('.spikeline').remove();
}

// helpers for traces that use Fx.loneHover

function castHoverOption(trace, ptNumber, attr) {
  return Lib.castOption(trace, ptNumber, 'hoverlabel.' + attr);
}
function castHoverinfo(trace, fullLayout, ptNumber) {
  function _coerce(val) {
    return Lib.coerceHoverinfo({
      hoverinfo: val
    }, {
      _module: trace._module
    }, fullLayout);
  }
  return Lib.castOption(trace, ptNumber, 'hoverinfo', _coerce);
}

/***/ }),

/***/ 5460:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var constants = __webpack_require__(2456);
var fontAttrs = __webpack_require__(5376);
var font = fontAttrs({
  editType: 'none'
});
font.family.dflt = constants.HOVERFONT;
font.size.dflt = constants.HOVERFONTSIZE;
module.exports = {
  clickmode: {
    valType: 'flaglist',
    flags: ['event', 'select'],
    dflt: 'event',
    editType: 'plot',
    extras: ['none']
  },
  dragmode: {
    valType: 'enumerated',
    values: ['zoom', 'pan', 'select', 'lasso', 'drawclosedpath', 'drawopenpath', 'drawline', 'drawrect', 'drawcircle', 'orbit', 'turntable', false],
    dflt: 'zoom',
    editType: 'modebar'
  },
  hovermode: {
    valType: 'enumerated',
    values: ['x', 'y', 'closest', false, 'x unified', 'y unified'],
    dflt: 'closest',
    editType: 'modebar'
  },
  hoversubplots: {
    valType: 'enumerated',
    values: ['single', 'overlaying', 'axis'],
    dflt: 'overlaying',
    editType: 'none'
  },
  hoverdistance: {
    valType: 'integer',
    min: -1,
    dflt: 20,
    editType: 'none'
  },
  spikedistance: {
    valType: 'integer',
    min: -1,
    dflt: -1,
    editType: 'none'
  },
  hoverlabel: {
    bgcolor: {
      valType: 'color',
      editType: 'none'
    },
    bordercolor: {
      valType: 'color',
      editType: 'none'
    },
    font: font,
    grouptitlefont: fontAttrs({
      editType: 'none'
    }),
    align: {
      valType: 'enumerated',
      values: ['left', 'right', 'auto'],
      dflt: 'auto',
      editType: 'none'
    },
    namelength: {
      valType: 'integer',
      min: -1,
      dflt: 15,
      editType: 'none'
    },
    editType: 'none'
  },
  selectdirection: {
    valType: 'enumerated',
    values: ['h', 'v', 'd', 'any'],
    dflt: 'any',
    editType: 'none'
  }
};

/***/ }),

/***/ 8336:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var layoutAttributes = __webpack_require__(5460);
var handleHoverModeDefaults = __webpack_require__(1008);
var handleHoverLabelDefaults = __webpack_require__(6132);
module.exports = function supplyLayoutDefaults(layoutIn, layoutOut) {
  function coerce(attr, dflt) {
    return Lib.coerce(layoutIn, layoutOut, layoutAttributes, attr, dflt);
  }
  var hoverMode = handleHoverModeDefaults(layoutIn, layoutOut);
  if (hoverMode) {
    coerce('hoverdistance');
    coerce('spikedistance');
  }
  var dragMode = coerce('dragmode');
  if (dragMode === 'select') coerce('selectdirection');

  // if only mapbox or geo subplots is present on graph,
  // reset 'zoom' dragmode to 'pan' until 'zoom' is implemented,
  // so that the correct modebar button is active
  var hasMapbox = layoutOut._has('mapbox');
  var hasGeo = layoutOut._has('geo');
  var len = layoutOut._basePlotModules.length;
  if (layoutOut.dragmode === 'zoom' && ((hasMapbox || hasGeo) && len === 1 || hasMapbox && hasGeo && len === 2)) {
    layoutOut.dragmode = 'pan';
  }
  handleHoverLabelDefaults(layoutIn, layoutOut, coerce);
  Lib.coerceFont(coerce, 'hoverlabel.grouptitlefont', layoutOut.hoverlabel.font);
};

/***/ }),

/***/ 1976:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var handleHoverLabelDefaults = __webpack_require__(6132);
var layoutAttributes = __webpack_require__(5460);
module.exports = function supplyLayoutGlobalDefaults(layoutIn, layoutOut) {
  function coerce(attr, dflt) {
    return Lib.coerce(layoutIn, layoutOut, layoutAttributes, attr, dflt);
  }
  handleHoverLabelDefaults(layoutIn, layoutOut, coerce);
};

/***/ }),

/***/ 2704:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var counterRegex = (__webpack_require__(3756).counter);
var domainAttrs = (__webpack_require__(6968)/* .attributes */ .u);
var cartesianIdRegex = (__webpack_require__(3816).idRegex);
var Template = __webpack_require__(1780);
var gridAttrs = {
  rows: {
    valType: 'integer',
    min: 1,
    editType: 'plot'
  },
  roworder: {
    valType: 'enumerated',
    values: ['top to bottom', 'bottom to top'],
    dflt: 'top to bottom',
    editType: 'plot'
  },
  columns: {
    valType: 'integer',
    min: 1,
    editType: 'plot'
  },
  subplots: {
    valType: 'info_array',
    freeLength: true,
    dimensions: 2,
    items: {
      valType: 'enumerated',
      values: [counterRegex('xy').toString(), ''],
      editType: 'plot'
    },
    editType: 'plot'
  },
  xaxes: {
    valType: 'info_array',
    freeLength: true,
    items: {
      valType: 'enumerated',
      values: [cartesianIdRegex.x.toString(), ''],
      editType: 'plot'
    },
    editType: 'plot'
  },
  yaxes: {
    valType: 'info_array',
    freeLength: true,
    items: {
      valType: 'enumerated',
      values: [cartesianIdRegex.y.toString(), ''],
      editType: 'plot'
    },
    editType: 'plot'
  },
  pattern: {
    valType: 'enumerated',
    values: ['independent', 'coupled'],
    dflt: 'coupled',
    editType: 'plot'
  },
  xgap: {
    valType: 'number',
    min: 0,
    max: 1,
    editType: 'plot'
  },
  ygap: {
    valType: 'number',
    min: 0,
    max: 1,
    editType: 'plot'
  },
  domain: domainAttrs({
    name: 'grid',
    editType: 'plot',
    noGridCell: true
  }, {}),
  xside: {
    valType: 'enumerated',
    values: ['bottom', 'bottom plot', 'top plot', 'top'],
    dflt: 'bottom plot',
    editType: 'plot'
  },
  yside: {
    valType: 'enumerated',
    values: ['left', 'left plot', 'right plot', 'right'],
    dflt: 'left plot',
    editType: 'plot'
  },
  editType: 'plot'
};
function getAxes(layout, grid, axLetter) {
  var gridVal = grid[axLetter + 'axes'];
  var splomVal = Object.keys((layout._splomAxes || {})[axLetter] || {});
  if (Array.isArray(gridVal)) return gridVal;
  if (splomVal.length) return splomVal;
}

// the shape of the grid - this needs to be done BEFORE supplyDataDefaults
// so that non-subplot traces can place themselves in the grid
function sizeDefaults(layoutIn, layoutOut) {
  var gridIn = layoutIn.grid || {};
  var xAxes = getAxes(layoutOut, gridIn, 'x');
  var yAxes = getAxes(layoutOut, gridIn, 'y');
  if (!layoutIn.grid && !xAxes && !yAxes) return;
  var hasSubplotGrid = Array.isArray(gridIn.subplots) && Array.isArray(gridIn.subplots[0]);
  var hasXaxes = Array.isArray(xAxes);
  var hasYaxes = Array.isArray(yAxes);
  var isSplomGenerated = hasXaxes && xAxes !== gridIn.xaxes && hasYaxes && yAxes !== gridIn.yaxes;
  var dfltRows, dfltColumns;
  if (hasSubplotGrid) {
    dfltRows = gridIn.subplots.length;
    dfltColumns = gridIn.subplots[0].length;
  } else {
    if (hasYaxes) dfltRows = yAxes.length;
    if (hasXaxes) dfltColumns = xAxes.length;
  }
  var gridOut = Template.newContainer(layoutOut, 'grid');
  function coerce(attr, dflt) {
    return Lib.coerce(gridIn, gridOut, gridAttrs, attr, dflt);
  }
  var rows = coerce('rows', dfltRows);
  var columns = coerce('columns', dfltColumns);
  if (!(rows * columns > 1)) {
    delete layoutOut.grid;
    return;
  }
  if (!hasSubplotGrid && !hasXaxes && !hasYaxes) {
    var useDefaultSubplots = coerce('pattern') === 'independent';
    if (useDefaultSubplots) hasSubplotGrid = true;
  }
  gridOut._hasSubplotGrid = hasSubplotGrid;
  var rowOrder = coerce('roworder');
  var reversed = rowOrder === 'top to bottom';
  var dfltGapX = hasSubplotGrid ? 0.2 : 0.1;
  var dfltGapY = hasSubplotGrid ? 0.3 : 0.1;
  var dfltSideX, dfltSideY;
  if (isSplomGenerated && layoutOut._splomGridDflt) {
    dfltSideX = layoutOut._splomGridDflt.xside;
    dfltSideY = layoutOut._splomGridDflt.yside;
  }
  gridOut._domains = {
    x: fillGridPositions('x', coerce, dfltGapX, dfltSideX, columns),
    y: fillGridPositions('y', coerce, dfltGapY, dfltSideY, rows, reversed)
  };
}

// coerce x or y sizing attributes and return an array of domains for this direction
function fillGridPositions(axLetter, coerce, dfltGap, dfltSide, len, reversed) {
  var dirGap = coerce(axLetter + 'gap', dfltGap);
  var domain = coerce('domain.' + axLetter);
  coerce(axLetter + 'side', dfltSide);
  var out = new Array(len);
  var start = domain[0];
  var step = (domain[1] - start) / (len - dirGap);
  var cellDomain = step * (1 - dirGap);
  for (var i = 0; i < len; i++) {
    var cellStart = start + step * i;
    out[reversed ? len - 1 - i : i] = [cellStart, cellStart + cellDomain];
  }
  return out;
}

// the (cartesian) contents of the grid - this needs to happen AFTER supplyDataDefaults
// so that we know what cartesian subplots are available
function contentDefaults(layoutIn, layoutOut) {
  var gridOut = layoutOut.grid;
  // make sure we got to the end of handleGridSizing
  if (!gridOut || !gridOut._domains) return;
  var gridIn = layoutIn.grid || {};
  var subplots = layoutOut._subplots;
  var hasSubplotGrid = gridOut._hasSubplotGrid;
  var rows = gridOut.rows;
  var columns = gridOut.columns;
  var useDefaultSubplots = gridOut.pattern === 'independent';
  var i, j, xId, yId, subplotId, subplotsOut, yPos;
  var axisMap = gridOut._axisMap = {};
  if (hasSubplotGrid) {
    var subplotsIn = gridIn.subplots || [];
    subplotsOut = gridOut.subplots = new Array(rows);
    var index = 1;
    for (i = 0; i < rows; i++) {
      var rowOut = subplotsOut[i] = new Array(columns);
      var rowIn = subplotsIn[i] || [];
      for (j = 0; j < columns; j++) {
        if (useDefaultSubplots) {
          subplotId = index === 1 ? 'xy' : 'x' + index + 'y' + index;
          index++;
        } else subplotId = rowIn[j];
        rowOut[j] = '';
        if (subplots.cartesian.indexOf(subplotId) !== -1) {
          yPos = subplotId.indexOf('y');
          xId = subplotId.slice(0, yPos);
          yId = subplotId.slice(yPos);
          if (axisMap[xId] !== undefined && axisMap[xId] !== j || axisMap[yId] !== undefined && axisMap[yId] !== i) {
            continue;
          }
          rowOut[j] = subplotId;
          axisMap[xId] = j;
          axisMap[yId] = i;
        }
      }
    }
  } else {
    var xAxes = getAxes(layoutOut, gridIn, 'x');
    var yAxes = getAxes(layoutOut, gridIn, 'y');
    gridOut.xaxes = fillGridAxes(xAxes, subplots.xaxis, columns, axisMap, 'x');
    gridOut.yaxes = fillGridAxes(yAxes, subplots.yaxis, rows, axisMap, 'y');
  }
  var anchors = gridOut._anchors = {};
  var reversed = gridOut.roworder === 'top to bottom';
  for (var axisId in axisMap) {
    var axLetter = axisId.charAt(0);
    var side = gridOut[axLetter + 'side'];
    var i0, inc, iFinal;
    if (side.length < 8) {
      // grid edge -  ie not "* plot" - make these as free axes
      // since we're not guaranteed to have a subplot there at all
      anchors[axisId] = 'free';
    } else if (axLetter === 'x') {
      if (side.charAt(0) === 't' === reversed) {
        i0 = 0;
        inc = 1;
        iFinal = rows;
      } else {
        i0 = rows - 1;
        inc = -1;
        iFinal = -1;
      }
      if (hasSubplotGrid) {
        var column = axisMap[axisId];
        for (i = i0; i !== iFinal; i += inc) {
          subplotId = subplotsOut[i][column];
          if (!subplotId) continue;
          yPos = subplotId.indexOf('y');
          if (subplotId.slice(0, yPos) === axisId) {
            anchors[axisId] = subplotId.slice(yPos);
            break;
          }
        }
      } else {
        for (i = i0; i !== iFinal; i += inc) {
          yId = gridOut.yaxes[i];
          if (subplots.cartesian.indexOf(axisId + yId) !== -1) {
            anchors[axisId] = yId;
            break;
          }
        }
      }
    } else {
      if (side.charAt(0) === 'l') {
        i0 = 0;
        inc = 1;
        iFinal = columns;
      } else {
        i0 = columns - 1;
        inc = -1;
        iFinal = -1;
      }
      if (hasSubplotGrid) {
        var row = axisMap[axisId];
        for (i = i0; i !== iFinal; i += inc) {
          subplotId = subplotsOut[row][i];
          if (!subplotId) continue;
          yPos = subplotId.indexOf('y');
          if (subplotId.slice(yPos) === axisId) {
            anchors[axisId] = subplotId.slice(0, yPos);
            break;
          }
        }
      } else {
        for (i = i0; i !== iFinal; i += inc) {
          xId = gridOut.xaxes[i];
          if (subplots.cartesian.indexOf(xId + axisId) !== -1) {
            anchors[axisId] = xId;
            break;
          }
        }
      }
    }
  }
}
function fillGridAxes(axesIn, axesAllowed, len, axisMap, axLetter) {
  var out = new Array(len);
  var i;
  function fillOneAxis(i, axisId) {
    if (axesAllowed.indexOf(axisId) !== -1 && axisMap[axisId] === undefined) {
      out[i] = axisId;
      axisMap[axisId] = i;
    } else out[i] = '';
  }
  if (Array.isArray(axesIn)) {
    for (i = 0; i < len; i++) {
      fillOneAxis(i, axesIn[i]);
    }
  } else {
    // default axis list is the first `len` axis ids
    fillOneAxis(0, axLetter);
    for (i = 1; i < len; i++) {
      fillOneAxis(i, axLetter + (i + 1));
    }
  }
  return out;
}
module.exports = {
  moduleType: 'component',
  name: 'grid',
  schema: {
    layout: {
      grid: gridAttrs
    }
  },
  layoutAttributes: gridAttrs,
  sizeDefaults: sizeDefaults,
  contentDefaults: contentDefaults
};

/***/ }),

/***/ 5760:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var cartesianConstants = __webpack_require__(3816);
var templatedArray = (__webpack_require__(1780).templatedArray);
var axisPlaceableObjs = __webpack_require__(6208);
module.exports = templatedArray('image', {
  visible: {
    valType: 'boolean',
    dflt: true,
    editType: 'arraydraw'
  },
  source: {
    valType: 'string',
    editType: 'arraydraw'
  },
  layer: {
    valType: 'enumerated',
    values: ['below', 'above'],
    dflt: 'above',
    editType: 'arraydraw'
  },
  sizex: {
    valType: 'number',
    dflt: 0,
    editType: 'arraydraw'
  },
  sizey: {
    valType: 'number',
    dflt: 0,
    editType: 'arraydraw'
  },
  sizing: {
    valType: 'enumerated',
    values: ['fill', 'contain', 'stretch'],
    dflt: 'contain',
    editType: 'arraydraw'
  },
  opacity: {
    valType: 'number',
    min: 0,
    max: 1,
    dflt: 1,
    editType: 'arraydraw'
  },
  x: {
    valType: 'any',
    dflt: 0,
    editType: 'arraydraw'
  },
  y: {
    valType: 'any',
    dflt: 0,
    editType: 'arraydraw'
  },
  xanchor: {
    valType: 'enumerated',
    values: ['left', 'center', 'right'],
    dflt: 'left',
    editType: 'arraydraw'
  },
  yanchor: {
    valType: 'enumerated',
    values: ['top', 'middle', 'bottom'],
    dflt: 'top',
    editType: 'arraydraw'
  },
  xref: {
    valType: 'enumerated',
    values: ['paper', cartesianConstants.idRegex.x.toString()],
    dflt: 'paper',
    editType: 'arraydraw'
  },
  yref: {
    valType: 'enumerated',
    values: ['paper', cartesianConstants.idRegex.y.toString()],
    dflt: 'paper',
    editType: 'arraydraw'
  },
  editType: 'arraydraw'
});

/***/ }),

/***/ 3556:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isNumeric = __webpack_require__(8248);
var toLogRange = __webpack_require__(6896);

/*
 * convertCoords: when converting an axis between log and linear
 * you need to alter any images on that axis to keep them
 * pointing at the same data point.
 * In v3.0 this will become obsolete (or perhaps size will still need conversion?)
 * we convert size by declaring that the maximum extent *in data units* should be
 * the same, assuming the image is anchored by its center (could remove that restriction
 * if we think it's important) even though the actual left and right values will not be
 * quite the same since the scale becomes nonlinear (and central anchor means the pixel
 * center of the image, not the data units center)
 *
 * gd: the plot div
 * ax: the axis being changed
 * newType: the type it's getting
 * doExtra: function(attr, val) from inside relayout that sets the attribute.
 *     Use this to make the changes as it's aware if any other changes in the
 *     same relayout call should override this conversion.
 */
module.exports = function convertCoords(gd, ax, newType, doExtra) {
  ax = ax || {};
  var toLog = newType === 'log' && ax.type === 'linear';
  var fromLog = newType === 'linear' && ax.type === 'log';
  if (!(toLog || fromLog)) return;
  var images = gd._fullLayout.images;
  var axLetter = ax._id.charAt(0);
  var image;
  var attrPrefix;
  for (var i = 0; i < images.length; i++) {
    image = images[i];
    attrPrefix = 'images[' + i + '].';
    if (image[axLetter + 'ref'] === ax._id) {
      var currentPos = image[axLetter];
      var currentSize = image['size' + axLetter];
      var newPos = null;
      var newSize = null;
      if (toLog) {
        newPos = toLogRange(currentPos, ax.range);

        // this is the inverse of the conversion we do in fromLog below
        // so that the conversion is reversible (notice the fromLog conversion
        // is like sinh, and this one looks like arcsinh)
        var dx = currentSize / Math.pow(10, newPos) / 2;
        newSize = 2 * Math.log(dx + Math.sqrt(1 + dx * dx)) / Math.LN10;
      } else {
        newPos = Math.pow(10, currentPos);
        newSize = newPos * (Math.pow(10, currentSize / 2) - Math.pow(10, -currentSize / 2));
      }

      // if conversion failed, delete the value so it can get a default later on
      if (!isNumeric(newPos)) {
        newPos = null;
        newSize = null;
      } else if (!isNumeric(newSize)) newSize = null;
      doExtra(attrPrefix + axLetter, newPos);
      doExtra(attrPrefix + 'size' + axLetter, newSize);
    }
  }
};

/***/ }),

/***/ 7404:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Axes = __webpack_require__(4460);
var handleArrayContainerDefaults = __webpack_require__(1272);
var attributes = __webpack_require__(5760);
var name = 'images';
module.exports = function supplyLayoutDefaults(layoutIn, layoutOut) {
  var opts = {
    name: name,
    handleItemDefaults: imageDefaults
  };
  handleArrayContainerDefaults(layoutIn, layoutOut, opts);
};
function imageDefaults(imageIn, imageOut, fullLayout) {
  function coerce(attr, dflt) {
    return Lib.coerce(imageIn, imageOut, attributes, attr, dflt);
  }
  var source = coerce('source');
  var visible = coerce('visible', !!source);
  if (!visible) return imageOut;
  coerce('layer');
  coerce('xanchor');
  coerce('yanchor');
  coerce('sizex');
  coerce('sizey');
  coerce('sizing');
  coerce('opacity');
  var gdMock = {
    _fullLayout: fullLayout
  };
  var axLetters = ['x', 'y'];
  for (var i = 0; i < 2; i++) {
    // 'paper' is the fallback axref
    var axLetter = axLetters[i];
    var axRef = Axes.coerceRef(imageIn, imageOut, gdMock, axLetter, 'paper', undefined);
    if (axRef !== 'paper') {
      var ax = Axes.getFromId(gdMock, axRef);
      ax._imgIndices.push(imageOut._index);
    }
    Axes.coercePosition(imageOut, gdMock, coerce, axRef, axLetter, 0);
  }
  return imageOut;
}

/***/ }),

/***/ 963:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var Drawing = __webpack_require__(3616);
var Axes = __webpack_require__(4460);
var axisIds = __webpack_require__(9811);
var xmlnsNamespaces = __webpack_require__(9616);
module.exports = function draw(gd) {
  var fullLayout = gd._fullLayout;
  var imageDataAbove = [];
  var imageDataSubplot = {};
  var imageDataBelow = [];
  var subplot;
  var i;

  // Sort into top, subplot, and bottom layers
  for (i = 0; i < fullLayout.images.length; i++) {
    var img = fullLayout.images[i];
    if (img.visible) {
      if (img.layer === 'below' && img.xref !== 'paper' && img.yref !== 'paper') {
        subplot = axisIds.ref2id(img.xref) + axisIds.ref2id(img.yref);
        var plotinfo = fullLayout._plots[subplot];
        if (!plotinfo) {
          // Fall back to _imageLowerLayer in case the requested subplot doesn't exist.
          // This can happen if you reference the image to an x / y axis combination
          // that doesn't have any data on it (and layer is below)
          imageDataBelow.push(img);
          continue;
        }
        if (plotinfo.mainplot) {
          subplot = plotinfo.mainplot.id;
        }
        if (!imageDataSubplot[subplot]) {
          imageDataSubplot[subplot] = [];
        }
        imageDataSubplot[subplot].push(img);
      } else if (img.layer === 'above') {
        imageDataAbove.push(img);
      } else {
        imageDataBelow.push(img);
      }
    }
  }
  var anchors = {
    x: {
      left: {
        sizing: 'xMin',
        offset: 0
      },
      center: {
        sizing: 'xMid',
        offset: -1 / 2
      },
      right: {
        sizing: 'xMax',
        offset: -1
      }
    },
    y: {
      top: {
        sizing: 'YMin',
        offset: 0
      },
      middle: {
        sizing: 'YMid',
        offset: -1 / 2
      },
      bottom: {
        sizing: 'YMax',
        offset: -1
      }
    }
  };

  // Images must be converted to dataURL's for exporting.
  function setImage(d) {
    var thisImage = d3.select(this);
    if (this._imgSrc === d.source) {
      return;
    }
    thisImage.attr('xmlns', xmlnsNamespaces.svg);
    if (d.source && d.source.slice(0, 5) === 'data:') {
      thisImage.attr('xlink:href', d.source);
      this._imgSrc = d.source;
    } else {
      var imagePromise = new Promise(function (resolve) {
        var img = new Image();
        this.img = img;

        // If not set, a `tainted canvas` error is thrown
        img.setAttribute('crossOrigin', 'anonymous');
        img.onerror = errorHandler;
        img.onload = function () {
          var canvas = document.createElement('canvas');
          canvas.width = this.width;
          canvas.height = this.height;
          var ctx = canvas.getContext('2d', {
            willReadFrequently: true
          });
          ctx.drawImage(this, 0, 0);
          var dataURL = canvas.toDataURL('image/png');
          thisImage.attr('xlink:href', dataURL);

          // resolve promise in onload handler instead of on 'load' to support IE11
          // see https://github.com/plotly/plotly.js/issues/1685
          // for more details
          resolve();
        };
        thisImage.on('error', errorHandler);
        img.src = d.source;
        this._imgSrc = d.source;
        function errorHandler() {
          thisImage.remove();
          resolve();
        }
      }.bind(this));
      gd._promises.push(imagePromise);
    }
  }
  function applyAttributes(d) {
    var thisImage = d3.select(this);

    // Axes if specified
    var xa = Axes.getFromId(gd, d.xref);
    var ya = Axes.getFromId(gd, d.yref);
    var xIsDomain = Axes.getRefType(d.xref) === 'domain';
    var yIsDomain = Axes.getRefType(d.yref) === 'domain';
    var size = fullLayout._size;
    var width, height;
    if (xa !== undefined) {
      width = typeof d.xref === 'string' && xIsDomain ? xa._length * d.sizex : Math.abs(xa.l2p(d.sizex) - xa.l2p(0));
    } else {
      width = d.sizex * size.w;
    }
    if (ya !== undefined) {
      height = typeof d.yref === 'string' && yIsDomain ? ya._length * d.sizey : Math.abs(ya.l2p(d.sizey) - ya.l2p(0));
    } else {
      height = d.sizey * size.h;
    }

    // Offsets for anchor positioning
    var xOffset = width * anchors.x[d.xanchor].offset;
    var yOffset = height * anchors.y[d.yanchor].offset;
    var sizing = anchors.x[d.xanchor].sizing + anchors.y[d.yanchor].sizing;

    // Final positions
    var xPos, yPos;
    if (xa !== undefined) {
      xPos = typeof d.xref === 'string' && xIsDomain ? xa._length * d.x + xa._offset : xa.r2p(d.x) + xa._offset;
    } else {
      xPos = d.x * size.w + size.l;
    }
    xPos += xOffset;
    if (ya !== undefined) {
      yPos = typeof d.yref === 'string' && yIsDomain ?
      // consistent with "paper" yref value, where positive values
      // move up the page
      ya._length * (1 - d.y) + ya._offset : ya.r2p(d.y) + ya._offset;
    } else {
      yPos = size.h - d.y * size.h + size.t;
    }
    yPos += yOffset;

    // Construct the proper aspectRatio attribute
    switch (d.sizing) {
      case 'fill':
        sizing += ' slice';
        break;
      case 'stretch':
        sizing = 'none';
        break;
    }
    thisImage.attr({
      x: xPos,
      y: yPos,
      width: width,
      height: height,
      preserveAspectRatio: sizing,
      opacity: d.opacity
    });

    // Set proper clipping on images
    var xId = xa && Axes.getRefType(d.xref) !== 'domain' ? xa._id : '';
    var yId = ya && Axes.getRefType(d.yref) !== 'domain' ? ya._id : '';
    var clipAxes = xId + yId;
    Drawing.setClipUrl(thisImage, clipAxes ? 'clip' + fullLayout._uid + clipAxes : null, gd);
  }
  var imagesBelow = fullLayout._imageLowerLayer.selectAll('image').data(imageDataBelow);
  var imagesAbove = fullLayout._imageUpperLayer.selectAll('image').data(imageDataAbove);
  imagesBelow.enter().append('image');
  imagesAbove.enter().append('image');
  imagesBelow.exit().remove();
  imagesAbove.exit().remove();
  imagesBelow.each(function (d) {
    setImage.bind(this)(d);
    applyAttributes.bind(this)(d);
  });
  imagesAbove.each(function (d) {
    setImage.bind(this)(d);
    applyAttributes.bind(this)(d);
  });
  var allSubplots = Object.keys(fullLayout._plots);
  for (i = 0; i < allSubplots.length; i++) {
    subplot = allSubplots[i];
    var subplotObj = fullLayout._plots[subplot];

    // filter out overlaid plots (which have their images on the main plot)
    // and gl2d plots (which don't support below images, at least not yet)
    if (!subplotObj.imagelayer) continue;
    var imagesOnSubplot = subplotObj.imagelayer.selectAll('image')
    // even if there are no images on this subplot, we need to run
    // enter and exit in case there were previously
    .data(imageDataSubplot[subplot] || []);
    imagesOnSubplot.enter().append('image');
    imagesOnSubplot.exit().remove();
    imagesOnSubplot.each(function (d) {
      setImage.bind(this)(d);
      applyAttributes.bind(this)(d);
    });
  }
};

/***/ }),

/***/ 7402:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = {
  moduleType: 'component',
  name: 'images',
  layoutAttributes: __webpack_require__(5760),
  supplyLayoutDefaults: __webpack_require__(7404),
  includeBasePlot: __webpack_require__(6632)('images'),
  draw: __webpack_require__(963),
  convertCoords: __webpack_require__(3556)
};

/***/ }),

/***/ 3800:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var fontAttrs = __webpack_require__(5376);
var colorAttrs = __webpack_require__(2548);
module.exports = {
  // not really a 'subplot' attribute container,
  // but this is the flag we use to denote attributes that
  // support yaxis, yaxis2, yaxis3, ... counters
  _isSubplotObj: true,
  visible: {
    valType: 'boolean',
    dflt: true,
    editType: 'legend'
  },
  bgcolor: {
    valType: 'color',
    editType: 'legend'
  },
  bordercolor: {
    valType: 'color',
    dflt: colorAttrs.defaultLine,
    editType: 'legend'
  },
  borderwidth: {
    valType: 'number',
    min: 0,
    dflt: 0,
    editType: 'legend'
  },
  font: fontAttrs({
    editType: 'legend'
  }),
  grouptitlefont: fontAttrs({
    editType: 'legend'
  }),
  orientation: {
    valType: 'enumerated',
    values: ['v', 'h'],
    dflt: 'v',
    editType: 'legend'
  },
  traceorder: {
    valType: 'flaglist',
    flags: ['reversed', 'grouped'],
    extras: ['normal'],
    editType: 'legend'
  },
  tracegroupgap: {
    valType: 'number',
    min: 0,
    dflt: 10,
    editType: 'legend'
  },
  entrywidth: {
    valType: 'number',
    min: 0,
    editType: 'legend'
  },
  entrywidthmode: {
    valType: 'enumerated',
    values: ['fraction', 'pixels'],
    dflt: 'pixels',
    editType: 'legend'
  },
  indentation: {
    valType: 'number',
    min: -15,
    dflt: 0,
    editType: 'legend'
  },
  itemsizing: {
    valType: 'enumerated',
    values: ['trace', 'constant'],
    dflt: 'trace',
    editType: 'legend'
  },
  itemwidth: {
    valType: 'number',
    min: 30,
    dflt: 30,
    editType: 'legend'
  },
  itemclick: {
    valType: 'enumerated',
    values: ['toggle', 'toggleothers', false],
    dflt: 'toggle',
    editType: 'legend'
  },
  itemdoubleclick: {
    valType: 'enumerated',
    values: ['toggle', 'toggleothers', false],
    dflt: 'toggleothers',
    editType: 'legend'
  },
  groupclick: {
    valType: 'enumerated',
    values: ['toggleitem', 'togglegroup'],
    dflt: 'togglegroup',
    editType: 'legend'
  },
  x: {
    valType: 'number',
    editType: 'legend'
  },
  xref: {
    valType: 'enumerated',
    dflt: 'paper',
    values: ['container', 'paper'],
    editType: 'layoutstyle'
  },
  xanchor: {
    valType: 'enumerated',
    values: ['auto', 'left', 'center', 'right'],
    dflt: 'left',
    editType: 'legend'
  },
  y: {
    valType: 'number',
    editType: 'legend'
  },
  yref: {
    valType: 'enumerated',
    dflt: 'paper',
    values: ['container', 'paper'],
    editType: 'layoutstyle'
  },
  yanchor: {
    valType: 'enumerated',
    values: ['auto', 'top', 'middle', 'bottom'],
    editType: 'legend'
  },
  uirevision: {
    valType: 'any',
    editType: 'none'
  },
  valign: {
    valType: 'enumerated',
    values: ['top', 'middle', 'bottom'],
    dflt: 'middle',
    editType: 'legend'
  },
  title: {
    text: {
      valType: 'string',
      dflt: '',
      editType: 'legend'
    },
    font: fontAttrs({
      editType: 'legend'
    }),
    side: {
      valType: 'enumerated',
      values: ['top', 'left', 'top left', 'top center', 'top right'],
      editType: 'legend'
    },
    editType: 'legend'
  },
  editType: 'legend'
};

/***/ }),

/***/ 5196:
/***/ (function(module) {

"use strict";


module.exports = {
  scrollBarWidth: 6,
  scrollBarMinHeight: 20,
  scrollBarColor: '#808BA4',
  scrollBarMargin: 4,
  scrollBarEnterAttrs: {
    rx: 20,
    ry: 3,
    width: 0,
    height: 0
  },
  // number of px between legend title and (left) side of legend (always in x direction and from inner border)
  titlePad: 2,
  // number of px between each legend item (x and/or y direction)
  itemGap: 5
};

/***/ }),

/***/ 7864:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Registry = __webpack_require__(4040);
var Lib = __webpack_require__(3400);
var Template = __webpack_require__(1780);
var plotsAttrs = __webpack_require__(5464);
var attributes = __webpack_require__(3800);
var basePlotLayoutAttributes = __webpack_require__(4859);
var helpers = __webpack_require__(2451);
function groupDefaults(legendId, layoutIn, layoutOut, fullData) {
  var containerIn = layoutIn[legendId] || {};
  var containerOut = Template.newContainer(layoutOut, legendId);
  function coerce(attr, dflt) {
    return Lib.coerce(containerIn, containerOut, attributes, attr, dflt);
  }

  // N.B. unified hover needs to inherit from font, bgcolor & bordercolor even when legend.visible is false
  var itemFont = Lib.coerceFont(coerce, 'font', layoutOut.font);
  coerce('bgcolor', layoutOut.paper_bgcolor);
  coerce('bordercolor');
  var visible = coerce('visible');
  if (!visible) return;
  var trace;
  var traceCoerce = function (attr, dflt) {
    var traceIn = trace._input;
    var traceOut = trace;
    return Lib.coerce(traceIn, traceOut, plotsAttrs, attr, dflt);
  };
  var globalFont = layoutOut.font || {};
  var grouptitlefont = Lib.coerceFont(coerce, 'grouptitlefont', Lib.extendFlat({}, globalFont, {
    size: Math.round(globalFont.size * 1.1)
  }));
  var legendTraceCount = 0;
  var legendReallyHasATrace = false;
  var defaultOrder = 'normal';
  var shapesWithLegend = (layoutOut.shapes || []).filter(function (d) {
    return d.showlegend;
  });
  var allLegendItems = fullData.concat(shapesWithLegend).filter(function (d) {
    return legendId === (d.legend || 'legend');
  });
  for (var i = 0; i < allLegendItems.length; i++) {
    trace = allLegendItems[i];
    if (!trace.visible) continue;
    var isShape = trace._isShape;

    // Note that we explicitly count any trace that is either shown or
    // *would* be shown by default, toward the two traces you need to
    // ensure the legend is shown by default, because this can still help
    // disambiguate.
    if (trace.showlegend || trace._dfltShowLegend && !(trace._module && trace._module.attributes && trace._module.attributes.showlegend && trace._module.attributes.showlegend.dflt === false)) {
      legendTraceCount++;
      if (trace.showlegend) {
        legendReallyHasATrace = true;
        // Always show the legend by default if there's a pie,
        // or if there's only one trace but it's explicitly shown
        if (!isShape && Registry.traceIs(trace, 'pie-like') || trace._input.showlegend === true) {
          legendTraceCount++;
        }
      }
      Lib.coerceFont(traceCoerce, 'legendgrouptitle.font', grouptitlefont);
    }
    if (!isShape && Registry.traceIs(trace, 'bar') && layoutOut.barmode === 'stack' || ['tonextx', 'tonexty'].indexOf(trace.fill) !== -1) {
      defaultOrder = helpers.isGrouped({
        traceorder: defaultOrder
      }) ? 'grouped+reversed' : 'reversed';
    }
    if (trace.legendgroup !== undefined && trace.legendgroup !== '') {
      defaultOrder = helpers.isReversed({
        traceorder: defaultOrder
      }) ? 'reversed+grouped' : 'grouped';
    }
  }
  var showLegend = Lib.coerce(layoutIn, layoutOut, basePlotLayoutAttributes, 'showlegend', legendReallyHasATrace && legendTraceCount > (legendId === 'legend' ? 1 : 0));

  // delete legend
  if (showLegend === false) layoutOut[legendId] = undefined;
  if (showLegend === false && !containerIn.uirevision) return;
  coerce('uirevision', layoutOut.uirevision);
  if (showLegend === false) return;
  coerce('borderwidth');
  var orientation = coerce('orientation');
  var yref = coerce('yref');
  var xref = coerce('xref');
  var isHorizontal = orientation === 'h';
  var isPaperY = yref === 'paper';
  var isPaperX = xref === 'paper';
  var defaultX, defaultY, defaultYAnchor;
  var defaultXAnchor = 'left';
  if (isHorizontal) {
    defaultX = 0;
    if (Registry.getComponentMethod('rangeslider', 'isVisible')(layoutIn.xaxis)) {
      if (isPaperY) {
        defaultY = 1.1;
        defaultYAnchor = 'bottom';
      } else {
        defaultY = 1;
        defaultYAnchor = 'top';
      }
    } else {
      // maybe use y=1.1 / yanchor=bottom as above
      //   to avoid https://github.com/plotly/plotly.js/issues/1199
      //   in v3
      if (isPaperY) {
        defaultY = -0.1;
        defaultYAnchor = 'top';
      } else {
        defaultY = 0;
        defaultYAnchor = 'bottom';
      }
    }
  } else {
    defaultY = 1;
    defaultYAnchor = 'auto';
    if (isPaperX) {
      defaultX = 1.02;
    } else {
      defaultX = 1;
      defaultXAnchor = 'right';
    }
  }
  Lib.coerce(containerIn, containerOut, {
    x: {
      valType: 'number',
      editType: 'legend',
      min: isPaperX ? -2 : 0,
      max: isPaperX ? 3 : 1,
      dflt: defaultX
    }
  }, 'x');
  Lib.coerce(containerIn, containerOut, {
    y: {
      valType: 'number',
      editType: 'legend',
      min: isPaperY ? -2 : 0,
      max: isPaperY ? 3 : 1,
      dflt: defaultY
    }
  }, 'y');
  coerce('traceorder', defaultOrder);
  if (helpers.isGrouped(layoutOut[legendId])) coerce('tracegroupgap');
  coerce('entrywidth');
  coerce('entrywidthmode');
  coerce('indentation');
  coerce('itemsizing');
  coerce('itemwidth');
  coerce('itemclick');
  coerce('itemdoubleclick');
  coerce('groupclick');
  coerce('xanchor', defaultXAnchor);
  coerce('yanchor', defaultYAnchor);
  coerce('valign');
  Lib.noneOrAll(containerIn, containerOut, ['x', 'y']);
  var titleText = coerce('title.text');
  if (titleText) {
    coerce('title.side', isHorizontal ? 'left' : 'top');
    var dfltTitleFont = Lib.extendFlat({}, itemFont, {
      size: Lib.bigFont(itemFont.size)
    });
    Lib.coerceFont(coerce, 'title.font', dfltTitleFont);
  }
}
module.exports = function legendDefaults(layoutIn, layoutOut, fullData) {
  var i;
  var allLegendsData = fullData.slice();

  // shapes could also show up in legends
  var shapes = layoutOut.shapes;
  if (shapes) {
    for (i = 0; i < shapes.length; i++) {
      var shape = shapes[i];
      if (!shape.showlegend) continue;
      var mockTrace = {
        _input: shape._input,
        visible: shape.visible,
        showlegend: shape.showlegend,
        legend: shape.legend
      };
      allLegendsData.push(mockTrace);
    }
  }
  var legends = ['legend'];
  for (i = 0; i < allLegendsData.length; i++) {
    Lib.pushUnique(legends, allLegendsData[i].legend);
  }
  layoutOut._legends = [];
  for (i = 0; i < legends.length; i++) {
    var legendId = legends[i];
    groupDefaults(legendId, layoutIn, layoutOut, allLegendsData);
    if (layoutOut[legendId] && layoutOut[legendId].visible) {
      layoutOut[legendId]._id = legendId;
    }
    layoutOut._legends.push(legendId);
  }
};

/***/ }),

/***/ 1140:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var Lib = __webpack_require__(3400);
var Plots = __webpack_require__(7316);
var Registry = __webpack_require__(4040);
var Events = __webpack_require__(5924);
var dragElement = __webpack_require__(6476);
var Drawing = __webpack_require__(3616);
var Color = __webpack_require__(6308);
var svgTextUtils = __webpack_require__(2736);
var handleClick = __webpack_require__(3048);
var constants = __webpack_require__(5196);
var alignmentConstants = __webpack_require__(4284);
var LINE_SPACING = alignmentConstants.LINE_SPACING;
var FROM_TL = alignmentConstants.FROM_TL;
var FROM_BR = alignmentConstants.FROM_BR;
var getLegendData = __webpack_require__(3076);
var style = __webpack_require__(2012);
var helpers = __webpack_require__(2451);
var MAIN_TITLE = 1;
var LEGEND_PATTERN = /^legend[0-9]*$/;
module.exports = function draw(gd, opts) {
  if (opts) {
    drawOne(gd, opts);
  } else {
    var fullLayout = gd._fullLayout;
    var newLegends = fullLayout._legends;

    // remove old legends that won't stay on the graph
    var oldLegends = fullLayout._infolayer.selectAll('[class^="legend"]');
    oldLegends.each(function () {
      var el = d3.select(this);
      var classes = el.attr('class');
      var cls = classes.split(' ')[0];
      if (cls.match(LEGEND_PATTERN) && newLegends.indexOf(cls) === -1) {
        el.remove();
      }
    });

    // draw/update new legends
    for (var i = 0; i < newLegends.length; i++) {
      var legendId = newLegends[i];
      var legendObj = gd._fullLayout[legendId];
      drawOne(gd, legendObj);
    }
  }
};

// After legend dimensions are calculated the title can be aligned horizontally left, center, right
function horizontalAlignTitle(titleEl, legendObj, bw) {
  if (legendObj.title.side !== 'top center' && legendObj.title.side !== 'top right') return;
  var font = legendObj.title.font;
  var lineHeight = font.size * LINE_SPACING;
  var titleOffset = 0;
  var textNode = titleEl.node();
  var width = Drawing.bBox(textNode).width; // width of the title text

  if (legendObj.title.side === 'top center') {
    titleOffset = 0.5 * (legendObj._width - 2 * bw - 2 * constants.titlePad - width);
  } else if (legendObj.title.side === 'top right') {
    titleOffset = legendObj._width - 2 * bw - 2 * constants.titlePad - width;
  }
  svgTextUtils.positionText(titleEl, bw + constants.titlePad + titleOffset, bw + lineHeight);
}
function drawOne(gd, opts) {
  var legendObj = opts || {};
  var fullLayout = gd._fullLayout;
  var legendId = getId(legendObj);
  var clipId, layer;
  var inHover = legendObj._inHover;
  if (inHover) {
    layer = legendObj.layer;
    clipId = 'hover';
  } else {
    layer = fullLayout._infolayer;
    clipId = legendId;
  }
  if (!layer) return;
  clipId += fullLayout._uid;
  if (!gd._legendMouseDownTime) gd._legendMouseDownTime = 0;
  var legendData;
  if (!inHover) {
    var calcdata = (gd.calcdata || []).slice();
    var shapes = fullLayout.shapes;
    for (var i = 0; i < shapes.length; i++) {
      var shape = shapes[i];
      if (!shape.showlegend) continue;
      var shapeLegend = {
        _isShape: true,
        _fullInput: shape,
        index: shape._index,
        name: shape.name || shape.label.text || 'shape ' + shape._index,
        legend: shape.legend,
        legendgroup: shape.legendgroup,
        legendgrouptitle: shape.legendgrouptitle,
        legendrank: shape.legendrank,
        legendwidth: shape.legendwidth,
        showlegend: shape.showlegend,
        visible: shape.visible,
        opacity: shape.opacity,
        mode: shape.type === 'line' ? 'lines' : 'markers',
        line: shape.line,
        marker: {
          line: shape.line,
          color: shape.fillcolor,
          size: 12,
          symbol: shape.type === 'rect' ? 'square' : shape.type === 'circle' ? 'circle' :
          // case of path
          'hexagon2'
        }
      };
      calcdata.push([{
        trace: shapeLegend
      }]);
    }
    legendData = fullLayout.showlegend && getLegendData(calcdata, legendObj, fullLayout._legends.length > 1);
  } else {
    if (!legendObj.entries) return;
    legendData = getLegendData(legendObj.entries, legendObj);
  }
  var hiddenSlices = fullLayout.hiddenlabels || [];
  if (!inHover && (!fullLayout.showlegend || !legendData.length)) {
    layer.selectAll('.' + legendId).remove();
    fullLayout._topdefs.select('#' + clipId).remove();
    return Plots.autoMargin(gd, legendId);
  }
  var legend = Lib.ensureSingle(layer, 'g', legendId, function (s) {
    if (!inHover) s.attr('pointer-events', 'all');
  });
  var clipPath = Lib.ensureSingleById(fullLayout._topdefs, 'clipPath', clipId, function (s) {
    s.append('rect');
  });
  var bg = Lib.ensureSingle(legend, 'rect', 'bg', function (s) {
    s.attr('shape-rendering', 'crispEdges');
  });
  bg.call(Color.stroke, legendObj.bordercolor).call(Color.fill, legendObj.bgcolor).style('stroke-width', legendObj.borderwidth + 'px');
  var scrollBox = Lib.ensureSingle(legend, 'g', 'scrollbox');
  var title = legendObj.title;
  legendObj._titleWidth = 0;
  legendObj._titleHeight = 0;
  var titleEl;
  if (title.text) {
    titleEl = Lib.ensureSingle(scrollBox, 'text', legendId + 'titletext');
    titleEl.attr('text-anchor', 'start').call(Drawing.font, title.font).text(title.text);
    textLayout(titleEl, scrollBox, gd, legendObj, MAIN_TITLE); // handle mathjax or multi-line text and compute title height
  } else {
    scrollBox.selectAll('.' + legendId + 'titletext').remove();
  }
  var scrollBar = Lib.ensureSingle(legend, 'rect', 'scrollbar', function (s) {
    s.attr(constants.scrollBarEnterAttrs).call(Color.fill, constants.scrollBarColor);
  });
  var groups = scrollBox.selectAll('g.groups').data(legendData);
  groups.enter().append('g').attr('class', 'groups');
  groups.exit().remove();
  var traces = groups.selectAll('g.traces').data(Lib.identity);
  traces.enter().append('g').attr('class', 'traces');
  traces.exit().remove();
  traces.style('opacity', function (d) {
    var trace = d[0].trace;
    if (Registry.traceIs(trace, 'pie-like')) {
      return hiddenSlices.indexOf(d[0].label) !== -1 ? 0.5 : 1;
    } else {
      return trace.visible === 'legendonly' ? 0.5 : 1;
    }
  }).each(function () {
    d3.select(this).call(drawTexts, gd, legendObj);
  }).call(style, gd, legendObj).each(function () {
    if (!inHover) d3.select(this).call(setupTraceToggle, gd, legendId);
  });
  Lib.syncOrAsync([Plots.previousPromises, function () {
    return computeLegendDimensions(gd, groups, traces, legendObj);
  }, function () {
    var gs = fullLayout._size;
    var bw = legendObj.borderwidth;
    var isPaperX = legendObj.xref === 'paper';
    var isPaperY = legendObj.yref === 'paper';

    // re-calculate title position after legend width is derived. To allow for horizontal alignment
    if (title.text) {
      horizontalAlignTitle(titleEl, legendObj, bw);
    }
    if (!inHover) {
      var lx, ly;
      if (isPaperX) {
        lx = gs.l + gs.w * legendObj.x - FROM_TL[getXanchor(legendObj)] * legendObj._width;
      } else {
        lx = fullLayout.width * legendObj.x - FROM_TL[getXanchor(legendObj)] * legendObj._width;
      }
      if (isPaperY) {
        ly = gs.t + gs.h * (1 - legendObj.y) - FROM_TL[getYanchor(legendObj)] * legendObj._effHeight;
      } else {
        ly = fullLayout.height * (1 - legendObj.y) - FROM_TL[getYanchor(legendObj)] * legendObj._effHeight;
      }
      var expMargin = expandMargin(gd, legendId, lx, ly);

      // IF expandMargin return a Promise (which is truthy),
      // we're under a doAutoMargin redraw, so we don't have to
      // draw the remaining pieces below
      if (expMargin) return;
      if (fullLayout.margin.autoexpand) {
        var lx0 = lx;
        var ly0 = ly;
        lx = isPaperX ? Lib.constrain(lx, 0, fullLayout.width - legendObj._width) : lx0;
        ly = isPaperY ? Lib.constrain(ly, 0, fullLayout.height - legendObj._effHeight) : ly0;
        if (lx !== lx0) {
          Lib.log('Constrain ' + legendId + '.x to make legend fit inside graph');
        }
        if (ly !== ly0) {
          Lib.log('Constrain ' + legendId + '.y to make legend fit inside graph');
        }
      }

      // Set size and position of all the elements that make up a legend:
      // legend, background and border, scroll box and scroll bar as well as title
      Drawing.setTranslate(legend, lx, ly);
    }

    // to be safe, remove previous listeners
    scrollBar.on('.drag', null);
    legend.on('wheel', null);
    if (inHover || legendObj._height <= legendObj._maxHeight || gd._context.staticPlot) {
      // if scrollbar should not be shown.
      var height = legendObj._effHeight;

      // if unified hover, let it be its full size
      if (inHover) height = legendObj._height;
      bg.attr({
        width: legendObj._width - bw,
        height: height - bw,
        x: bw / 2,
        y: bw / 2
      });
      Drawing.setTranslate(scrollBox, 0, 0);
      clipPath.select('rect').attr({
        width: legendObj._width - 2 * bw,
        height: height - 2 * bw,
        x: bw,
        y: bw
      });
      Drawing.setClipUrl(scrollBox, clipId, gd);
      Drawing.setRect(scrollBar, 0, 0, 0, 0);
      delete legendObj._scrollY;
    } else {
      var scrollBarHeight = Math.max(constants.scrollBarMinHeight, legendObj._effHeight * legendObj._effHeight / legendObj._height);
      var scrollBarYMax = legendObj._effHeight - scrollBarHeight - 2 * constants.scrollBarMargin;
      var scrollBoxYMax = legendObj._height - legendObj._effHeight;
      var scrollRatio = scrollBarYMax / scrollBoxYMax;
      var scrollBoxY = Math.min(legendObj._scrollY || 0, scrollBoxYMax);

      // increase the background and clip-path width
      // by the scrollbar width and margin
      bg.attr({
        width: legendObj._width - 2 * bw + constants.scrollBarWidth + constants.scrollBarMargin,
        height: legendObj._effHeight - bw,
        x: bw / 2,
        y: bw / 2
      });
      clipPath.select('rect').attr({
        width: legendObj._width - 2 * bw + constants.scrollBarWidth + constants.scrollBarMargin,
        height: legendObj._effHeight - 2 * bw,
        x: bw,
        y: bw + scrollBoxY
      });
      Drawing.setClipUrl(scrollBox, clipId, gd);
      scrollHandler(scrollBoxY, scrollBarHeight, scrollRatio);

      // scroll legend by mousewheel or touchpad swipe up/down
      legend.on('wheel', function () {
        scrollBoxY = Lib.constrain(legendObj._scrollY + d3.event.deltaY / scrollBarYMax * scrollBoxYMax, 0, scrollBoxYMax);
        scrollHandler(scrollBoxY, scrollBarHeight, scrollRatio);
        if (scrollBoxY !== 0 && scrollBoxY !== scrollBoxYMax) {
          d3.event.preventDefault();
        }
      });
      var eventY0, eventY1, scrollBoxY0;
      var getScrollBarDragY = function (scrollBoxY0, eventY0, eventY1) {
        var y = (eventY1 - eventY0) / scrollRatio + scrollBoxY0;
        return Lib.constrain(y, 0, scrollBoxYMax);
      };
      var getNaturalDragY = function (scrollBoxY0, eventY0, eventY1) {
        var y = (eventY0 - eventY1) / scrollRatio + scrollBoxY0;
        return Lib.constrain(y, 0, scrollBoxYMax);
      };

      // scroll legend by dragging scrollBAR
      var scrollBarDrag = d3.behavior.drag().on('dragstart', function () {
        var e = d3.event.sourceEvent;
        if (e.type === 'touchstart') {
          eventY0 = e.changedTouches[0].clientY;
        } else {
          eventY0 = e.clientY;
        }
        scrollBoxY0 = scrollBoxY;
      }).on('drag', function () {
        var e = d3.event.sourceEvent;
        if (e.buttons === 2 || e.ctrlKey) return;
        if (e.type === 'touchmove') {
          eventY1 = e.changedTouches[0].clientY;
        } else {
          eventY1 = e.clientY;
        }
        scrollBoxY = getScrollBarDragY(scrollBoxY0, eventY0, eventY1);
        scrollHandler(scrollBoxY, scrollBarHeight, scrollRatio);
      });
      scrollBar.call(scrollBarDrag);

      // scroll legend by touch-dragging scrollBOX
      var scrollBoxTouchDrag = d3.behavior.drag().on('dragstart', function () {
        var e = d3.event.sourceEvent;
        if (e.type === 'touchstart') {
          eventY0 = e.changedTouches[0].clientY;
          scrollBoxY0 = scrollBoxY;
        }
      }).on('drag', function () {
        var e = d3.event.sourceEvent;
        if (e.type === 'touchmove') {
          eventY1 = e.changedTouches[0].clientY;
          scrollBoxY = getNaturalDragY(scrollBoxY0, eventY0, eventY1);
          scrollHandler(scrollBoxY, scrollBarHeight, scrollRatio);
        }
      });
      scrollBox.call(scrollBoxTouchDrag);
    }
    function scrollHandler(scrollBoxY, scrollBarHeight, scrollRatio) {
      legendObj._scrollY = gd._fullLayout[legendId]._scrollY = scrollBoxY;
      Drawing.setTranslate(scrollBox, 0, -scrollBoxY);
      Drawing.setRect(scrollBar, legendObj._width, constants.scrollBarMargin + scrollBoxY * scrollRatio, constants.scrollBarWidth, scrollBarHeight);
      clipPath.select('rect').attr('y', bw + scrollBoxY);
    }
    if (gd._context.edits.legendPosition) {
      var xf, yf, x0, y0;
      legend.classed('cursor-move', true);
      dragElement.init({
        element: legend.node(),
        gd: gd,
        prepFn: function () {
          var transform = Drawing.getTranslate(legend);
          x0 = transform.x;
          y0 = transform.y;
        },
        moveFn: function (dx, dy) {
          var newX = x0 + dx;
          var newY = y0 + dy;
          Drawing.setTranslate(legend, newX, newY);
          xf = dragElement.align(newX, legendObj._width, gs.l, gs.l + gs.w, legendObj.xanchor);
          yf = dragElement.align(newY + legendObj._height, -legendObj._height, gs.t + gs.h, gs.t, legendObj.yanchor);
        },
        doneFn: function () {
          if (xf !== undefined && yf !== undefined) {
            var obj = {};
            obj[legendId + '.x'] = xf;
            obj[legendId + '.y'] = yf;
            Registry.call('_guiRelayout', gd, obj);
          }
        },
        clickFn: function (numClicks, e) {
          var clickedTrace = layer.selectAll('g.traces').filter(function () {
            var bbox = this.getBoundingClientRect();
            return e.clientX >= bbox.left && e.clientX <= bbox.right && e.clientY >= bbox.top && e.clientY <= bbox.bottom;
          });
          if (clickedTrace.size() > 0) {
            clickOrDoubleClick(gd, legend, clickedTrace, numClicks, e);
          }
        }
      });
    }
  }], gd);
}
function getTraceWidth(d, legendObj, textGap) {
  var legendItem = d[0];
  var legendWidth = legendItem.width;
  var mode = legendObj.entrywidthmode;
  var traceLegendWidth = legendItem.trace.legendwidth || legendObj.entrywidth;
  if (mode === 'fraction') return legendObj._maxWidth * traceLegendWidth;
  return textGap + (traceLegendWidth || legendWidth);
}
function clickOrDoubleClick(gd, legend, legendItem, numClicks, evt) {
  var trace = legendItem.data()[0][0].trace;
  var evtData = {
    event: evt,
    node: legendItem.node(),
    curveNumber: trace.index,
    expandedIndex: trace._expandedIndex,
    data: gd.data,
    layout: gd.layout,
    frames: gd._transitionData._frames,
    config: gd._context,
    fullData: gd._fullData,
    fullLayout: gd._fullLayout
  };
  if (trace._group) {
    evtData.group = trace._group;
  }
  if (Registry.traceIs(trace, 'pie-like')) {
    evtData.label = legendItem.datum()[0].label;
  }
  var clickVal = Events.triggerHandler(gd, 'plotly_legendclick', evtData);
  if (numClicks === 1) {
    if (clickVal === false) return;
    legend._clickTimeout = setTimeout(function () {
      if (!gd._fullLayout) return;
      handleClick(legendItem, gd, numClicks);
    }, gd._context.doubleClickDelay);
  } else if (numClicks === 2) {
    if (legend._clickTimeout) clearTimeout(legend._clickTimeout);
    gd._legendMouseDownTime = 0;
    var dblClickVal = Events.triggerHandler(gd, 'plotly_legenddoubleclick', evtData);
    // Activate default double click behaviour only when both single click and double click values are not false
    if (dblClickVal !== false && clickVal !== false) handleClick(legendItem, gd, numClicks);
  }
}
function drawTexts(g, gd, legendObj) {
  var legendId = getId(legendObj);
  var legendItem = g.data()[0][0];
  var trace = legendItem.trace;
  var isPieLike = Registry.traceIs(trace, 'pie-like');
  var isEditable = !legendObj._inHover && gd._context.edits.legendText && !isPieLike;
  var maxNameLength = legendObj._maxNameLength;
  var name, font;
  if (legendItem.groupTitle) {
    name = legendItem.groupTitle.text;
    font = legendItem.groupTitle.font;
  } else {
    font = legendObj.font;
    if (!legendObj.entries) {
      name = isPieLike ? legendItem.label : trace.name;
      if (trace._meta) {
        name = Lib.templateString(name, trace._meta);
      }
    } else {
      name = legendItem.text;
    }
  }
  var textEl = Lib.ensureSingle(g, 'text', legendId + 'text');
  textEl.attr('text-anchor', 'start').call(Drawing.font, font).text(isEditable ? ensureLength(name, maxNameLength) : name);
  var textGap = legendObj.indentation + legendObj.itemwidth + constants.itemGap * 2;
  svgTextUtils.positionText(textEl, textGap, 0);
  if (isEditable) {
    textEl.call(svgTextUtils.makeEditable, {
      gd: gd,
      text: name
    }).call(textLayout, g, gd, legendObj).on('edit', function (newName) {
      this.text(ensureLength(newName, maxNameLength)).call(textLayout, g, gd, legendObj);
      var fullInput = legendItem.trace._fullInput || {};
      var update = {};
      if (Registry.hasTransform(fullInput, 'groupby')) {
        var groupbyIndices = Registry.getTransformIndices(fullInput, 'groupby');
        var _index = groupbyIndices[groupbyIndices.length - 1];
        var kcont = Lib.keyedContainer(fullInput, 'transforms[' + _index + '].styles', 'target', 'value.name');
        kcont.set(legendItem.trace._group, newName);
        update = kcont.constructUpdate();
      } else {
        update.name = newName;
      }
      if (fullInput._isShape) {
        return Registry.call('_guiRelayout', gd, 'shapes[' + trace.index + '].name', update.name);
      } else {
        return Registry.call('_guiRestyle', gd, update, trace.index);
      }
    });
  } else {
    textLayout(textEl, g, gd, legendObj);
  }
}

/*
 * Make sure we have a reasonably clickable region.
 * If this string is missing or very short, pad it with spaces out to at least
 * 4 characters, up to the max length of other labels, on the assumption that
 * most characters are wider than spaces so a string of spaces will usually be
 * no wider than the real labels.
 */
function ensureLength(str, maxLength) {
  var targetLength = Math.max(4, maxLength);
  if (str && str.trim().length >= targetLength / 2) return str;
  str = str || '';
  for (var i = targetLength - str.length; i > 0; i--) str += ' ';
  return str;
}
function setupTraceToggle(g, gd, legendId) {
  var doubleClickDelay = gd._context.doubleClickDelay;
  var newMouseDownTime;
  var numClicks = 1;
  var traceToggle = Lib.ensureSingle(g, 'rect', legendId + 'toggle', function (s) {
    if (!gd._context.staticPlot) {
      s.style('cursor', 'pointer').attr('pointer-events', 'all');
    }
    s.call(Color.fill, 'rgba(0,0,0,0)');
  });
  if (gd._context.staticPlot) return;
  traceToggle.on('mousedown', function () {
    newMouseDownTime = new Date().getTime();
    if (newMouseDownTime - gd._legendMouseDownTime < doubleClickDelay) {
      // in a click train
      numClicks += 1;
    } else {
      // new click train
      numClicks = 1;
      gd._legendMouseDownTime = newMouseDownTime;
    }
  });
  traceToggle.on('mouseup', function () {
    if (gd._dragged || gd._editing) return;
    var legend = gd._fullLayout[legendId];
    if (new Date().getTime() - gd._legendMouseDownTime > doubleClickDelay) {
      numClicks = Math.max(numClicks - 1, 1);
    }
    clickOrDoubleClick(gd, legend, g, numClicks, d3.event);
  });
}
function textLayout(s, g, gd, legendObj, aTitle) {
  if (legendObj._inHover) s.attr('data-notex', true); // do not process MathJax for unified hover
  svgTextUtils.convertToTspans(s, gd, function () {
    computeTextDimensions(g, gd, legendObj, aTitle);
  });
}
function computeTextDimensions(g, gd, legendObj, aTitle) {
  var legendItem = g.data()[0][0];
  if (!legendObj._inHover && legendItem && !legendItem.trace.showlegend) {
    g.remove();
    return;
  }
  var mathjaxGroup = g.select('g[class*=math-group]');
  var mathjaxNode = mathjaxGroup.node();
  var legendId = getId(legendObj);
  if (!legendObj) {
    legendObj = gd._fullLayout[legendId];
  }
  var bw = legendObj.borderwidth;
  var font;
  if (aTitle === MAIN_TITLE) {
    font = legendObj.title.font;
  } else if (legendItem.groupTitle) {
    font = legendItem.groupTitle.font;
  } else {
    font = legendObj.font;
  }
  var lineHeight = font.size * LINE_SPACING;
  var height, width;
  if (mathjaxNode) {
    var mathjaxBB = Drawing.bBox(mathjaxNode);
    height = mathjaxBB.height;
    width = mathjaxBB.width;
    if (aTitle === MAIN_TITLE) {
      Drawing.setTranslate(mathjaxGroup, bw, bw + height * 0.75);
    } else {
      // legend item
      Drawing.setTranslate(mathjaxGroup, 0, height * 0.25);
    }
  } else {
    var cls = '.' + legendId + (aTitle === MAIN_TITLE ? 'title' : '') + 'text';
    var textEl = g.select(cls);
    var textLines = svgTextUtils.lineCount(textEl);
    var textNode = textEl.node();
    height = lineHeight * textLines;
    width = textNode ? Drawing.bBox(textNode).width : 0;

    // approximation to height offset to center the font
    // to avoid getBoundingClientRect
    if (aTitle === MAIN_TITLE) {
      if (legendObj.title.side === 'left') {
        // add extra space between legend title and itmes
        width += constants.itemGap * 2;
      }
      svgTextUtils.positionText(textEl, bw + constants.titlePad, bw + lineHeight);
    } else {
      // legend item
      var x = constants.itemGap * 2 + legendObj.indentation + legendObj.itemwidth;
      if (legendItem.groupTitle) {
        x = constants.itemGap;
        width -= legendObj.indentation + legendObj.itemwidth;
      }
      svgTextUtils.positionText(textEl, x, -lineHeight * ((textLines - 1) / 2 - 0.3));
    }
  }
  if (aTitle === MAIN_TITLE) {
    legendObj._titleWidth = width;
    legendObj._titleHeight = height;
  } else {
    // legend item
    legendItem.lineHeight = lineHeight;
    legendItem.height = Math.max(height, 16) + 3;
    legendItem.width = width;
  }
}
function getTitleSize(legendObj) {
  var w = 0;
  var h = 0;
  var side = legendObj.title.side;
  if (side) {
    if (side.indexOf('left') !== -1) {
      w = legendObj._titleWidth;
    }
    if (side.indexOf('top') !== -1) {
      h = legendObj._titleHeight;
    }
  }
  return [w, h];
}

/*
 * Computes in fullLayout[legendId]:
 *
 *  - _height: legend height including items past scrollbox height
 *  - _maxHeight: maximum legend height before scrollbox is required
 *  - _effHeight: legend height w/ or w/o scrollbox
 *
 *  - _width: legend width
 *  - _maxWidth (for orientation:h only): maximum width before starting new row
 */
function computeLegendDimensions(gd, groups, traces, legendObj) {
  var fullLayout = gd._fullLayout;
  var legendId = getId(legendObj);
  if (!legendObj) {
    legendObj = fullLayout[legendId];
  }
  var gs = fullLayout._size;
  var isVertical = helpers.isVertical(legendObj);
  var isGrouped = helpers.isGrouped(legendObj);
  var isFraction = legendObj.entrywidthmode === 'fraction';
  var bw = legendObj.borderwidth;
  var bw2 = 2 * bw;
  var itemGap = constants.itemGap;
  var textGap = legendObj.indentation + legendObj.itemwidth + itemGap * 2;
  var endPad = 2 * (bw + itemGap);
  var yanchor = getYanchor(legendObj);
  var isBelowPlotArea = legendObj.y < 0 || legendObj.y === 0 && yanchor === 'top';
  var isAbovePlotArea = legendObj.y > 1 || legendObj.y === 1 && yanchor === 'bottom';
  var traceGroupGap = legendObj.tracegroupgap;
  var legendGroupWidths = {};

  // - if below/above plot area, give it the maximum potential margin-push value
  // - otherwise, extend the height of the plot area
  legendObj._maxHeight = Math.max(isBelowPlotArea || isAbovePlotArea ? fullLayout.height / 2 : gs.h, 30);
  var toggleRectWidth = 0;
  legendObj._width = 0;
  legendObj._height = 0;
  var titleSize = getTitleSize(legendObj);
  if (isVertical) {
    traces.each(function (d) {
      var h = d[0].height;
      Drawing.setTranslate(this, bw + titleSize[0], bw + titleSize[1] + legendObj._height + h / 2 + itemGap);
      legendObj._height += h;
      legendObj._width = Math.max(legendObj._width, d[0].width);
    });
    toggleRectWidth = textGap + legendObj._width;
    legendObj._width += itemGap + textGap + bw2;
    legendObj._height += endPad;
    if (isGrouped) {
      groups.each(function (d, i) {
        Drawing.setTranslate(this, 0, i * legendObj.tracegroupgap);
      });
      legendObj._height += (legendObj._lgroupsLength - 1) * legendObj.tracegroupgap;
    }
  } else {
    var xanchor = getXanchor(legendObj);
    var isLeftOfPlotArea = legendObj.x < 0 || legendObj.x === 0 && xanchor === 'right';
    var isRightOfPlotArea = legendObj.x > 1 || legendObj.x === 1 && xanchor === 'left';
    var isBeyondPlotAreaY = isAbovePlotArea || isBelowPlotArea;
    var hw = fullLayout.width / 2;

    // - if placed within x-margins, extend the width of the plot area
    // - else if below/above plot area and anchored in the margin, extend to opposite margin,
    // - otherwise give it the maximum potential margin-push value
    legendObj._maxWidth = Math.max(isLeftOfPlotArea ? isBeyondPlotAreaY && xanchor === 'left' ? gs.l + gs.w : hw : isRightOfPlotArea ? isBeyondPlotAreaY && xanchor === 'right' ? gs.r + gs.w : hw : gs.w, 2 * textGap);
    var maxItemWidth = 0;
    var combinedItemWidth = 0;
    traces.each(function (d) {
      var w = getTraceWidth(d, legendObj, textGap);
      maxItemWidth = Math.max(maxItemWidth, w);
      combinedItemWidth += w;
    });
    toggleRectWidth = null;
    var maxRowWidth = 0;
    if (isGrouped) {
      var maxGroupHeightInRow = 0;
      var groupOffsetX = 0;
      var groupOffsetY = 0;
      groups.each(function () {
        var maxWidthInGroup = 0;
        var offsetY = 0;
        d3.select(this).selectAll('g.traces').each(function (d) {
          var w = getTraceWidth(d, legendObj, textGap);
          var h = d[0].height;
          Drawing.setTranslate(this, titleSize[0], titleSize[1] + bw + itemGap + h / 2 + offsetY);
          offsetY += h;
          maxWidthInGroup = Math.max(maxWidthInGroup, w);
          legendGroupWidths[d[0].trace.legendgroup] = maxWidthInGroup;
        });
        var next = maxWidthInGroup + itemGap;

        // horizontal_wrapping
        if (
        // not on the first column already
        groupOffsetX > 0 &&
        // goes beyound limit
        next + bw + groupOffsetX > legendObj._maxWidth) {
          maxRowWidth = Math.max(maxRowWidth, groupOffsetX);
          groupOffsetX = 0;
          groupOffsetY += maxGroupHeightInRow + traceGroupGap;
          maxGroupHeightInRow = offsetY;
        } else {
          maxGroupHeightInRow = Math.max(maxGroupHeightInRow, offsetY);
        }
        Drawing.setTranslate(this, groupOffsetX, groupOffsetY);
        groupOffsetX += next;
      });
      legendObj._width = Math.max(maxRowWidth, groupOffsetX) + bw;
      legendObj._height = groupOffsetY + maxGroupHeightInRow + endPad;
    } else {
      var nTraces = traces.size();
      var oneRowLegend = combinedItemWidth + bw2 + (nTraces - 1) * itemGap < legendObj._maxWidth;
      var maxItemHeightInRow = 0;
      var offsetX = 0;
      var offsetY = 0;
      var rowWidth = 0;
      traces.each(function (d) {
        var h = d[0].height;
        var w = getTraceWidth(d, legendObj, textGap, isGrouped);
        var next = oneRowLegend ? w : maxItemWidth;
        if (!isFraction) {
          next += itemGap;
        }
        if (next + bw + offsetX - itemGap >= legendObj._maxWidth) {
          maxRowWidth = Math.max(maxRowWidth, rowWidth);
          offsetX = 0;
          offsetY += maxItemHeightInRow;
          legendObj._height += maxItemHeightInRow;
          maxItemHeightInRow = 0;
        }
        Drawing.setTranslate(this, titleSize[0] + bw + offsetX, titleSize[1] + bw + offsetY + h / 2 + itemGap);
        rowWidth = offsetX + w + itemGap;
        offsetX += next;
        maxItemHeightInRow = Math.max(maxItemHeightInRow, h);
      });
      if (oneRowLegend) {
        legendObj._width = offsetX + bw2;
        legendObj._height = maxItemHeightInRow + endPad;
      } else {
        legendObj._width = Math.max(maxRowWidth, rowWidth) + bw2;
        legendObj._height += maxItemHeightInRow + endPad;
      }
    }
  }
  legendObj._width = Math.ceil(Math.max(legendObj._width + titleSize[0], legendObj._titleWidth + 2 * (bw + constants.titlePad)));
  legendObj._height = Math.ceil(Math.max(legendObj._height + titleSize[1], legendObj._titleHeight + 2 * (bw + constants.itemGap)));
  legendObj._effHeight = Math.min(legendObj._height, legendObj._maxHeight);
  var edits = gd._context.edits;
  var isEditable = edits.legendText || edits.legendPosition;
  traces.each(function (d) {
    var traceToggle = d3.select(this).select('.' + legendId + 'toggle');
    var h = d[0].height;
    var legendgroup = d[0].trace.legendgroup;
    var traceWidth = getTraceWidth(d, legendObj, textGap);
    if (isGrouped && legendgroup !== '') {
      traceWidth = legendGroupWidths[legendgroup];
    }
    var w = isEditable ? textGap : toggleRectWidth || traceWidth;
    if (!isVertical && !isFraction) {
      w += itemGap / 2;
    }
    Drawing.setRect(traceToggle, 0, -h / 2, w, h);
  });
}
function expandMargin(gd, legendId, lx, ly) {
  var fullLayout = gd._fullLayout;
  var legendObj = fullLayout[legendId];
  var xanchor = getXanchor(legendObj);
  var yanchor = getYanchor(legendObj);
  var isPaperX = legendObj.xref === 'paper';
  var isPaperY = legendObj.yref === 'paper';
  gd._fullLayout._reservedMargin[legendId] = {};
  var sideY = legendObj.y < 0.5 ? 'b' : 't';
  var sideX = legendObj.x < 0.5 ? 'l' : 'r';
  var possibleReservedMargins = {
    r: fullLayout.width - lx,
    l: lx + legendObj._width,
    b: fullLayout.height - ly,
    t: ly + legendObj._effHeight
  };
  if (isPaperX && isPaperY) {
    return Plots.autoMargin(gd, legendId, {
      x: legendObj.x,
      y: legendObj.y,
      l: legendObj._width * FROM_TL[xanchor],
      r: legendObj._width * FROM_BR[xanchor],
      b: legendObj._effHeight * FROM_BR[yanchor],
      t: legendObj._effHeight * FROM_TL[yanchor]
    });
  } else if (isPaperX) {
    gd._fullLayout._reservedMargin[legendId][sideY] = possibleReservedMargins[sideY];
  } else if (isPaperY) {
    gd._fullLayout._reservedMargin[legendId][sideX] = possibleReservedMargins[sideX];
  } else {
    if (legendObj.orientation === 'v') {
      gd._fullLayout._reservedMargin[legendId][sideX] = possibleReservedMargins[sideX];
    } else {
      gd._fullLayout._reservedMargin[legendId][sideY] = possibleReservedMargins[sideY];
    }
  }
}
function getXanchor(legendObj) {
  return Lib.isRightAnchor(legendObj) ? 'right' : Lib.isCenterAnchor(legendObj) ? 'center' : 'left';
}
function getYanchor(legendObj) {
  return Lib.isBottomAnchor(legendObj) ? 'bottom' : Lib.isMiddleAnchor(legendObj) ? 'middle' : 'top';
}
function getId(legendObj) {
  return legendObj._id || 'legend';
}

/***/ }),

/***/ 3076:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Registry = __webpack_require__(4040);
var helpers = __webpack_require__(2451);
module.exports = function getLegendData(calcdata, opts, hasMultipleLegends) {
  var inHover = opts._inHover;
  var grouped = helpers.isGrouped(opts);
  var reversed = helpers.isReversed(opts);
  var lgroupToTraces = {};
  var lgroups = [];
  var hasOneNonBlankGroup = false;
  var slicesShown = {};
  var lgroupi = 0;
  var maxNameLength = 0;
  var i, j;
  function addOneItem(legendId, legendGroup, legendItem) {
    if (opts.visible === false) return;
    if (hasMultipleLegends && legendId !== opts._id) return;

    // each '' legend group is treated as a separate group
    if (legendGroup === '' || !helpers.isGrouped(opts)) {
      // TODO: check this against fullData legendgroups?
      var uniqueGroup = '~~i' + lgroupi;
      lgroups.push(uniqueGroup);
      lgroupToTraces[uniqueGroup] = [legendItem];
      lgroupi++;
    } else if (lgroups.indexOf(legendGroup) === -1) {
      lgroups.push(legendGroup);
      hasOneNonBlankGroup = true;
      lgroupToTraces[legendGroup] = [legendItem];
    } else {
      lgroupToTraces[legendGroup].push(legendItem);
    }
  }

  // build an { legendgroup: [cd0, cd0], ... } object
  for (i = 0; i < calcdata.length; i++) {
    var cd = calcdata[i];
    var cd0 = cd[0];
    var trace = cd0.trace;
    var lid = trace.legend;
    var lgroup = trace.legendgroup;
    if (!inHover && (!trace.visible || !trace.showlegend)) continue;
    if (Registry.traceIs(trace, 'pie-like')) {
      if (!slicesShown[lgroup]) slicesShown[lgroup] = {};
      for (j = 0; j < cd.length; j++) {
        var labelj = cd[j].label;
        if (!slicesShown[lgroup][labelj]) {
          addOneItem(lid, lgroup, {
            label: labelj,
            color: cd[j].color,
            i: cd[j].i,
            trace: trace,
            pts: cd[j].pts
          });
          slicesShown[lgroup][labelj] = true;
          maxNameLength = Math.max(maxNameLength, (labelj || '').length);
        }
      }
    } else {
      addOneItem(lid, lgroup, cd0);
      maxNameLength = Math.max(maxNameLength, (trace.name || '').length);
    }
  }

  // won't draw a legend in this case
  if (!lgroups.length) return [];

  // collapse all groups into one if all groups are blank
  var shouldCollapse = !hasOneNonBlankGroup || !grouped;
  var legendData = [];
  for (i = 0; i < lgroups.length; i++) {
    var t = lgroupToTraces[lgroups[i]];
    if (shouldCollapse) {
      legendData.push(t[0]);
    } else {
      legendData.push(t);
    }
  }
  if (shouldCollapse) legendData = [legendData];
  for (i = 0; i < legendData.length; i++) {
    // find minimum rank within group
    var groupMinRank = Infinity;
    for (j = 0; j < legendData[i].length; j++) {
      var rank = legendData[i][j].trace.legendrank;
      if (groupMinRank > rank) groupMinRank = rank;
    }

    // record on first group element
    legendData[i][0]._groupMinRank = groupMinRank;
    legendData[i][0]._preGroupSort = i;
  }
  var orderFn1 = function (a, b) {
    return a[0]._groupMinRank - b[0]._groupMinRank || a[0]._preGroupSort - b[0]._preGroupSort // fallback for old Chrome < 70 https://bugs.chromium.org/p/v8/issues/detail?id=90
    ;
  };

  var orderFn2 = function (a, b) {
    return a.trace.legendrank - b.trace.legendrank || a._preSort - b._preSort // fallback for old Chrome < 70 https://bugs.chromium.org/p/v8/issues/detail?id=90
    ;
  };

  // sort considering minimum group legendrank
  legendData.forEach(function (a, k) {
    a[0]._preGroupSort = k;
  });
  legendData.sort(orderFn1);
  for (i = 0; i < legendData.length; i++) {
    // sort considering trace.legendrank and legend.traceorder
    legendData[i].forEach(function (a, k) {
      a._preSort = k;
    });
    legendData[i].sort(orderFn2);
    var firstItemTrace = legendData[i][0].trace;
    var groupTitle = null;
    // get group title text
    for (j = 0; j < legendData[i].length; j++) {
      var gt = legendData[i][j].trace.legendgrouptitle;
      if (gt && gt.text) {
        groupTitle = gt;
        if (inHover) gt.font = opts._groupTitleFont;
        break;
      }
    }

    // reverse order
    if (reversed) legendData[i].reverse();
    if (groupTitle) {
      var hasPieLike = false;
      for (j = 0; j < legendData[i].length; j++) {
        if (Registry.traceIs(legendData[i][j].trace, 'pie-like')) {
          hasPieLike = true;
          break;
        }
      }

      // set group title text
      legendData[i].unshift({
        i: -1,
        groupTitle: groupTitle,
        noClick: hasPieLike,
        trace: {
          showlegend: firstItemTrace.showlegend,
          legendgroup: firstItemTrace.legendgroup,
          visible: opts.groupclick === 'toggleitem' ? true : firstItemTrace.visible
        }
      });
    }

    // rearrange lgroupToTraces into a d3-friendly array of arrays
    for (j = 0; j < legendData[i].length; j++) {
      legendData[i][j] = [legendData[i][j]];
    }
  }

  // number of legend groups - needed in legend/draw.js
  opts._lgroupsLength = legendData.length;
  // maximum name/label length - needed in legend/draw.js
  opts._maxNameLength = maxNameLength;
  return legendData;
};

/***/ }),

/***/ 3048:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Registry = __webpack_require__(4040);
var Lib = __webpack_require__(3400);
var pushUnique = Lib.pushUnique;
var SHOWISOLATETIP = true;
module.exports = function handleClick(g, gd, numClicks) {
  var fullLayout = gd._fullLayout;
  if (gd._dragged || gd._editing) return;
  var itemClick = fullLayout.legend.itemclick;
  var itemDoubleClick = fullLayout.legend.itemdoubleclick;
  var groupClick = fullLayout.legend.groupclick;
  if (numClicks === 1 && itemClick === 'toggle' && itemDoubleClick === 'toggleothers' && SHOWISOLATETIP && gd.data && gd._context.showTips) {
    Lib.notifier(Lib._(gd, 'Double-click on legend to isolate one trace'), 'long');
    SHOWISOLATETIP = false;
  } else {
    SHOWISOLATETIP = false;
  }
  var mode;
  if (numClicks === 1) mode = itemClick;else if (numClicks === 2) mode = itemDoubleClick;
  if (!mode) return;
  var toggleGroup = groupClick === 'togglegroup';
  var hiddenSlices = fullLayout.hiddenlabels ? fullLayout.hiddenlabels.slice() : [];
  var legendItem = g.data()[0][0];
  if (legendItem.groupTitle && legendItem.noClick) return;
  var fullData = gd._fullData;
  var shapesWithLegend = (fullLayout.shapes || []).filter(function (d) {
    return d.showlegend;
  });
  var allLegendItems = fullData.concat(shapesWithLegend);
  var fullTrace = legendItem.trace;
  if (fullTrace._isShape) {
    fullTrace = fullTrace._fullInput;
  }
  var legendgroup = fullTrace.legendgroup;
  var i, j, kcont, key, keys, val;
  var dataUpdate = {};
  var dataIndices = [];
  var carrs = [];
  var carrIdx = [];
  function insertDataUpdate(traceIndex, value) {
    var attrIndex = dataIndices.indexOf(traceIndex);
    var valueArray = dataUpdate.visible;
    if (!valueArray) {
      valueArray = dataUpdate.visible = [];
    }
    if (dataIndices.indexOf(traceIndex) === -1) {
      dataIndices.push(traceIndex);
      attrIndex = dataIndices.length - 1;
    }
    valueArray[attrIndex] = value;
    return attrIndex;
  }
  var updatedShapes = (fullLayout.shapes || []).map(function (d) {
    return d._input;
  });
  var shapesUpdated = false;
  function insertShapesUpdate(shapeIndex, value) {
    updatedShapes[shapeIndex].visible = value;
    shapesUpdated = true;
  }
  function setVisibility(fullTrace, visibility) {
    if (legendItem.groupTitle && !toggleGroup) return;
    var fullInput = fullTrace._fullInput || fullTrace;
    var isShape = fullInput._isShape;
    var index = fullInput.index;
    if (index === undefined) index = fullInput._index;
    if (Registry.hasTransform(fullInput, 'groupby')) {
      var kcont = carrs[index];
      if (!kcont) {
        var groupbyIndices = Registry.getTransformIndices(fullInput, 'groupby');
        var lastGroupbyIndex = groupbyIndices[groupbyIndices.length - 1];
        kcont = Lib.keyedContainer(fullInput, 'transforms[' + lastGroupbyIndex + '].styles', 'target', 'value.visible');
        carrs[index] = kcont;
      }
      var curState = kcont.get(fullTrace._group);

      // If not specified, assume visible. This happens if there are other style
      // properties set for a group but not the visibility. There are many similar
      // ways to do this (e.g. why not just `curState = fullTrace.visible`??? The
      // answer is: because it breaks other things like groupby trace names in
      // subtle ways.)
      if (curState === undefined) {
        curState = true;
      }
      if (curState !== false) {
        // true -> legendonly. All others toggle to true:
        kcont.set(fullTrace._group, visibility);
      }
      carrIdx[index] = insertDataUpdate(index, fullInput.visible === false ? false : true);
    } else {
      // false -> false (not possible since will not be visible in legend)
      // true -> legendonly
      // legendonly -> true
      var nextVisibility = fullInput.visible === false ? false : visibility;
      if (isShape) {
        insertShapesUpdate(index, nextVisibility);
      } else {
        insertDataUpdate(index, nextVisibility);
      }
    }
  }
  var thisLegend = fullTrace.legend;
  var fullInput = fullTrace._fullInput;
  var isShape = fullInput && fullInput._isShape;
  if (!isShape && Registry.traceIs(fullTrace, 'pie-like')) {
    var thisLabel = legendItem.label;
    var thisLabelIndex = hiddenSlices.indexOf(thisLabel);
    if (mode === 'toggle') {
      if (thisLabelIndex === -1) hiddenSlices.push(thisLabel);else hiddenSlices.splice(thisLabelIndex, 1);
    } else if (mode === 'toggleothers') {
      var changed = thisLabelIndex !== -1;
      var unhideList = [];
      for (i = 0; i < gd.calcdata.length; i++) {
        var cdi = gd.calcdata[i];
        for (j = 0; j < cdi.length; j++) {
          var d = cdi[j];
          var dLabel = d.label;

          // ensure we toggle slices that are in this legend)
          if (thisLegend === cdi[0].trace.legend) {
            if (thisLabel !== dLabel) {
              if (hiddenSlices.indexOf(dLabel) === -1) changed = true;
              pushUnique(hiddenSlices, dLabel);
              unhideList.push(dLabel);
            }
          }
        }
      }
      if (!changed) {
        for (var q = 0; q < unhideList.length; q++) {
          var pos = hiddenSlices.indexOf(unhideList[q]);
          if (pos !== -1) {
            hiddenSlices.splice(pos, 1);
          }
        }
      }
    }
    Registry.call('_guiRelayout', gd, 'hiddenlabels', hiddenSlices);
  } else {
    var hasLegendgroup = legendgroup && legendgroup.length;
    var traceIndicesInGroup = [];
    var tracei;
    if (hasLegendgroup) {
      for (i = 0; i < allLegendItems.length; i++) {
        tracei = allLegendItems[i];
        if (!tracei.visible) continue;
        if (tracei.legendgroup === legendgroup) {
          traceIndicesInGroup.push(i);
        }
      }
    }
    if (mode === 'toggle') {
      var nextVisibility;
      switch (fullTrace.visible) {
        case true:
          nextVisibility = 'legendonly';
          break;
        case false:
          nextVisibility = false;
          break;
        case 'legendonly':
          nextVisibility = true;
          break;
      }
      if (hasLegendgroup) {
        if (toggleGroup) {
          for (i = 0; i < allLegendItems.length; i++) {
            var item = allLegendItems[i];
            if (item.visible !== false && item.legendgroup === legendgroup) {
              setVisibility(item, nextVisibility);
            }
          }
        } else {
          setVisibility(fullTrace, nextVisibility);
        }
      } else {
        setVisibility(fullTrace, nextVisibility);
      }
    } else if (mode === 'toggleothers') {
      // Compute the clicked index. expandedIndex does what we want for expanded traces
      // but also culls hidden traces. That means we have some work to do.
      var isClicked, isInGroup, notInLegend, otherState, _item;
      var isIsolated = true;
      for (i = 0; i < allLegendItems.length; i++) {
        _item = allLegendItems[i];
        isClicked = _item === fullTrace;
        notInLegend = _item.showlegend !== true;
        if (isClicked || notInLegend) continue;
        isInGroup = hasLegendgroup && _item.legendgroup === legendgroup;
        if (!isInGroup && _item.legend === thisLegend && _item.visible === true && !Registry.traceIs(_item, 'notLegendIsolatable')) {
          isIsolated = false;
          break;
        }
      }
      for (i = 0; i < allLegendItems.length; i++) {
        _item = allLegendItems[i];

        // False is sticky; we don't change it. Also ensure we don't change states of itmes in other legend
        if (_item.visible === false || _item.legend !== thisLegend) continue;
        if (Registry.traceIs(_item, 'notLegendIsolatable')) {
          continue;
        }
        switch (fullTrace.visible) {
          case 'legendonly':
            setVisibility(_item, true);
            break;
          case true:
            otherState = isIsolated ? true : 'legendonly';
            isClicked = _item === fullTrace;
            // N.B. consider traces that have a set legendgroup as toggleable
            notInLegend = _item.showlegend !== true && !_item.legendgroup;
            isInGroup = isClicked || hasLegendgroup && _item.legendgroup === legendgroup;
            setVisibility(_item, isInGroup || notInLegend ? true : otherState);
            break;
        }
      }
    }
    for (i = 0; i < carrs.length; i++) {
      kcont = carrs[i];
      if (!kcont) continue;
      var update = kcont.constructUpdate();
      var updateKeys = Object.keys(update);
      for (j = 0; j < updateKeys.length; j++) {
        key = updateKeys[j];
        val = dataUpdate[key] = dataUpdate[key] || [];
        val[carrIdx[i]] = update[key];
      }
    }

    // The length of the value arrays should be equal and any unspecified
    // values should be explicitly undefined for them to get properly culled
    // as updates and not accidentally reset to the default value. This fills
    // out sparse arrays with the required number of undefined values:
    keys = Object.keys(dataUpdate);
    for (i = 0; i < keys.length; i++) {
      key = keys[i];
      for (j = 0; j < dataIndices.length; j++) {
        // Use hasOwnProperty to protect against falsy values:
        if (!dataUpdate[key].hasOwnProperty(j)) {
          dataUpdate[key][j] = undefined;
        }
      }
    }
    if (shapesUpdated) {
      Registry.call('_guiUpdate', gd, dataUpdate, {
        shapes: updatedShapes
      }, dataIndices);
    } else {
      Registry.call('_guiRestyle', gd, dataUpdate, dataIndices);
    }
  }
};

/***/ }),

/***/ 2451:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


exports.isGrouped = function isGrouped(legendLayout) {
  return (legendLayout.traceorder || '').indexOf('grouped') !== -1;
};
exports.isVertical = function isVertical(legendLayout) {
  return legendLayout.orientation !== 'h';
};
exports.isReversed = function isReversed(legendLayout) {
  return (legendLayout.traceorder || '').indexOf('reversed') !== -1;
};

/***/ }),

/***/ 2780:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = {
  moduleType: 'component',
  name: 'legend',
  layoutAttributes: __webpack_require__(3800),
  supplyLayoutDefaults: __webpack_require__(7864),
  draw: __webpack_require__(1140),
  style: __webpack_require__(2012)
};

/***/ }),

/***/ 2012:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var Registry = __webpack_require__(4040);
var Lib = __webpack_require__(3400);
var strTranslate = Lib.strTranslate;
var Drawing = __webpack_require__(3616);
var Color = __webpack_require__(6308);
var extractOpts = (__webpack_require__(4288).extractOpts);
var subTypes = __webpack_require__(3028);
var stylePie = __webpack_require__(528);
var pieCastOption = (__webpack_require__(9656).castOption);
var constants = __webpack_require__(5196);
var CST_MARKER_SIZE = 12;
var CST_LINE_WIDTH = 5;
var CST_MARKER_LINE_WIDTH = 2;
var MAX_LINE_WIDTH = 10;
var MAX_MARKER_LINE_WIDTH = 5;
module.exports = function style(s, gd, legend) {
  var fullLayout = gd._fullLayout;
  if (!legend) legend = fullLayout.legend;
  var constantItemSizing = legend.itemsizing === 'constant';
  var itemWidth = legend.itemwidth;
  var centerPos = (itemWidth + constants.itemGap * 2) / 2;
  var centerTransform = strTranslate(centerPos, 0);
  var boundLineWidth = function (mlw, cont, max, cst) {
    var v;
    if (mlw + 1) {
      v = mlw;
    } else if (cont && cont.width > 0) {
      v = cont.width;
    } else {
      return 0;
    }
    return constantItemSizing ? cst : Math.min(v, max);
  };
  s.each(function (d) {
    var traceGroup = d3.select(this);
    var layers = Lib.ensureSingle(traceGroup, 'g', 'layers');
    layers.style('opacity', d[0].trace.opacity);
    var indentation = legend.indentation;
    var valign = legend.valign;
    var lineHeight = d[0].lineHeight;
    var height = d[0].height;
    if (valign === 'middle' && indentation === 0 || !lineHeight || !height) {
      layers.attr('transform', null);
    } else {
      var factor = {
        top: 1,
        bottom: -1
      }[valign];
      var markerOffsetY = factor * (0.5 * (lineHeight - height + 3)) || 0;
      var markerOffsetX = legend.indentation;
      layers.attr('transform', strTranslate(markerOffsetX, markerOffsetY));
    }
    var fill = layers.selectAll('g.legendfill').data([d]);
    fill.enter().append('g').classed('legendfill', true);
    var line = layers.selectAll('g.legendlines').data([d]);
    line.enter().append('g').classed('legendlines', true);
    var symbol = layers.selectAll('g.legendsymbols').data([d]);
    symbol.enter().append('g').classed('legendsymbols', true);
    symbol.selectAll('g.legendpoints').data([d]).enter().append('g').classed('legendpoints', true);
  }).each(styleSpatial).each(styleWaterfalls).each(styleFunnels).each(styleBars).each(styleBoxes).each(styleFunnelareas).each(stylePies).each(styleLines).each(stylePoints).each(styleCandles).each(styleOHLC);
  function styleLines(d) {
    var styleGuide = getStyleGuide(d);
    var showFill = styleGuide.showFill;
    var showLine = styleGuide.showLine;
    var showGradientLine = styleGuide.showGradientLine;
    var showGradientFill = styleGuide.showGradientFill;
    var anyFill = styleGuide.anyFill;
    var anyLine = styleGuide.anyLine;
    var d0 = d[0];
    var trace = d0.trace;
    var dMod, tMod;
    var cOpts = extractOpts(trace);
    var colorscale = cOpts.colorscale;
    var reversescale = cOpts.reversescale;
    var fillStyle = function (s) {
      if (s.size()) {
        if (showFill) {
          Drawing.fillGroupStyle(s, gd, true);
        } else {
          var gradientID = 'legendfill-' + trace.uid;
          Drawing.gradient(s, gd, gradientID, getGradientDirection(reversescale), colorscale, 'fill');
        }
      }
    };
    var lineGradient = function (s) {
      if (s.size()) {
        var gradientID = 'legendline-' + trace.uid;
        Drawing.lineGroupStyle(s);
        Drawing.gradient(s, gd, gradientID, getGradientDirection(reversescale), colorscale, 'stroke');
      }
    };

    // with fill and no markers or text, move the line and fill up a bit
    // so it's more centered

    var pathStart = subTypes.hasMarkers(trace) || !anyFill ? 'M5,0' :
    // with a line leave it slightly below center, to leave room for the
    // line thickness and because the line is usually more prominent
    anyLine ? 'M5,-2' : 'M5,-3';
    var this3 = d3.select(this);
    var fill = this3.select('.legendfill').selectAll('path').data(showFill || showGradientFill ? [d] : []);
    fill.enter().append('path').classed('js-fill', true);
    fill.exit().remove();
    fill.attr('d', pathStart + 'h' + itemWidth + 'v6h-' + itemWidth + 'z').call(fillStyle);
    if (showLine || showGradientLine) {
      var lw = boundLineWidth(undefined, trace.line, MAX_LINE_WIDTH, CST_LINE_WIDTH);
      tMod = Lib.minExtend(trace, {
        line: {
          width: lw
        }
      });
      dMod = [Lib.minExtend(d0, {
        trace: tMod
      })];
    }
    var line = this3.select('.legendlines').selectAll('path').data(showLine || showGradientLine ? [dMod] : []);
    line.enter().append('path').classed('js-line', true);
    line.exit().remove();

    // this is ugly... but you can't apply a gradient to a perfectly
    // horizontal or vertical line. Presumably because then
    // the system doesn't know how to scale vertical variation, even
    // though there *is* no vertical variation in this case.
    // so add an invisibly small angle to the line
    // This issue (and workaround) exist across (Mac) Chrome, FF, and Safari
    line.attr('d', pathStart + (showGradientLine ? 'l' + itemWidth + ',0.0001' : 'h' + itemWidth)).call(showLine ? Drawing.lineGroupStyle : lineGradient);
  }
  function stylePoints(d) {
    var styleGuide = getStyleGuide(d);
    var anyFill = styleGuide.anyFill;
    var anyLine = styleGuide.anyLine;
    var showLine = styleGuide.showLine;
    var showMarker = styleGuide.showMarker;
    var d0 = d[0];
    var trace = d0.trace;
    var showText = !showMarker && !anyLine && !anyFill && subTypes.hasText(trace);
    var dMod, tMod;

    // 'scatter3d' don't use gd.calcdata,
    // use d0.trace to infer arrayOk attributes

    function boundVal(attrIn, arrayToValFn, bounds, cst) {
      var valIn = Lib.nestedProperty(trace, attrIn).get();
      var valToBound = Lib.isArrayOrTypedArray(valIn) && arrayToValFn ? arrayToValFn(valIn) : valIn;
      if (constantItemSizing && valToBound && cst !== undefined) {
        valToBound = cst;
      }
      if (bounds) {
        if (valToBound < bounds[0]) return bounds[0];else if (valToBound > bounds[1]) return bounds[1];
      }
      return valToBound;
    }
    function pickFirst(array) {
      if (d0._distinct && d0.index && array[d0.index]) return array[d0.index];
      return array[0];
    }

    // constrain text, markers, etc so they'll fit on the legend
    if (showMarker || showText || showLine) {
      var dEdit = {};
      var tEdit = {};
      if (showMarker) {
        dEdit.mc = boundVal('marker.color', pickFirst);
        dEdit.mx = boundVal('marker.symbol', pickFirst);
        dEdit.mo = boundVal('marker.opacity', Lib.mean, [0.2, 1]);
        dEdit.mlc = boundVal('marker.line.color', pickFirst);
        dEdit.mlw = boundVal('marker.line.width', Lib.mean, [0, 5], CST_MARKER_LINE_WIDTH);
        tEdit.marker = {
          sizeref: 1,
          sizemin: 1,
          sizemode: 'diameter'
        };
        var ms = boundVal('marker.size', Lib.mean, [2, 16], CST_MARKER_SIZE);
        dEdit.ms = ms;
        tEdit.marker.size = ms;
      }
      if (showLine) {
        tEdit.line = {
          width: boundVal('line.width', pickFirst, [0, 10], CST_LINE_WIDTH)
        };
      }
      if (showText) {
        dEdit.tx = 'Aa';
        dEdit.tp = boundVal('textposition', pickFirst);
        dEdit.ts = 10;
        dEdit.tc = boundVal('textfont.color', pickFirst);
        dEdit.tf = boundVal('textfont.family', pickFirst);
        dEdit.tw = boundVal('textfont.weight', pickFirst);
        dEdit.ty = boundVal('textfont.style', pickFirst);
        dEdit.tv = boundVal('textfont.variant', pickFirst);
      }
      dMod = [Lib.minExtend(d0, dEdit)];
      tMod = Lib.minExtend(trace, tEdit);

      // always show legend items in base state
      tMod.selectedpoints = null;

      // never show texttemplate
      tMod.texttemplate = null;
    }
    var ptgroup = d3.select(this).select('g.legendpoints');
    var pts = ptgroup.selectAll('path.scatterpts').data(showMarker ? dMod : []);
    // make sure marker is on the bottom, in case it enters after text
    pts.enter().insert('path', ':first-child').classed('scatterpts', true).attr('transform', centerTransform);
    pts.exit().remove();
    pts.call(Drawing.pointStyle, tMod, gd);

    // 'mrc' is set in pointStyle and used in textPointStyle:
    // constrain it here
    if (showMarker) dMod[0].mrc = 3;
    var txt = ptgroup.selectAll('g.pointtext').data(showText ? dMod : []);
    txt.enter().append('g').classed('pointtext', true).append('text').attr('transform', centerTransform);
    txt.exit().remove();
    txt.selectAll('text').call(Drawing.textPointStyle, tMod, gd);
  }
  function styleWaterfalls(d) {
    var trace = d[0].trace;
    var isWaterfall = trace.type === 'waterfall';
    if (d[0]._distinct && isWaterfall) {
      var cont = d[0].trace[d[0].dir].marker;
      d[0].mc = cont.color;
      d[0].mlw = cont.line.width;
      d[0].mlc = cont.line.color;
      return styleBarLike(d, this, 'waterfall');
    }
    var ptsData = [];
    if (trace.visible && isWaterfall) {
      ptsData = d[0].hasTotals ? [['increasing', 'M-6,-6V6H0Z'], ['totals', 'M6,6H0L-6,-6H-0Z'], ['decreasing', 'M6,6V-6H0Z']] : [['increasing', 'M-6,-6V6H6Z'], ['decreasing', 'M6,6V-6H-6Z']];
    }
    var pts = d3.select(this).select('g.legendpoints').selectAll('path.legendwaterfall').data(ptsData);
    pts.enter().append('path').classed('legendwaterfall', true).attr('transform', centerTransform).style('stroke-miterlimit', 1);
    pts.exit().remove();
    pts.each(function (dd) {
      var pt = d3.select(this);
      var cont = trace[dd[0]].marker;
      var lw = boundLineWidth(undefined, cont.line, MAX_MARKER_LINE_WIDTH, CST_MARKER_LINE_WIDTH);
      pt.attr('d', dd[1]).style('stroke-width', lw + 'px').call(Color.fill, cont.color);
      if (lw) {
        pt.call(Color.stroke, cont.line.color);
      }
    });
  }
  function styleBars(d) {
    styleBarLike(d, this);
  }
  function styleFunnels(d) {
    styleBarLike(d, this, 'funnel');
  }
  function styleBarLike(d, lThis, desiredType) {
    var trace = d[0].trace;
    var marker = trace.marker || {};
    var markerLine = marker.line || {};

    // If bar has rounded corners, round corners of legend icon
    var pathStr = marker.cornerradius ? 'M6,3a3,3,0,0,1-3,3H-3a3,3,0,0,1-3-3V-3a3,3,0,0,1,3-3H3a3,3,0,0,1,3,3Z' :
    // Square with rounded corners
    'M6,6H-6V-6H6Z'; // Normal square

    var isVisible = !desiredType ? Registry.traceIs(trace, 'bar') : trace.visible && trace.type === desiredType;
    var barpath = d3.select(lThis).select('g.legendpoints').selectAll('path.legend' + desiredType).data(isVisible ? [d] : []);
    barpath.enter().append('path').classed('legend' + desiredType, true).attr('d', pathStr).attr('transform', centerTransform);
    barpath.exit().remove();
    barpath.each(function (d) {
      var p = d3.select(this);
      var d0 = d[0];
      var w = boundLineWidth(d0.mlw, marker.line, MAX_MARKER_LINE_WIDTH, CST_MARKER_LINE_WIDTH);
      p.style('stroke-width', w + 'px');
      var mcc = d0.mcc;
      if (!legend._inHover && 'mc' in d0) {
        // not in unified hover but
        // for legend use the color in the middle of scale
        var cOpts = extractOpts(marker);
        var mid = cOpts.mid;
        if (mid === undefined) mid = (cOpts.max + cOpts.min) / 2;
        mcc = Drawing.tryColorscale(marker, '')(mid);
      }
      var fillColor = mcc || d0.mc || marker.color;
      var markerPattern = marker.pattern;
      var patternShape = markerPattern && Drawing.getPatternAttr(markerPattern.shape, 0, '');
      if (patternShape) {
        var patternBGColor = Drawing.getPatternAttr(markerPattern.bgcolor, 0, null);
        var patternFGColor = Drawing.getPatternAttr(markerPattern.fgcolor, 0, null);
        var patternFGOpacity = markerPattern.fgopacity;
        var patternSize = dimAttr(markerPattern.size, 8, 10);
        var patternSolidity = dimAttr(markerPattern.solidity, 0.5, 1);
        var patternID = 'legend-' + trace.uid;
        p.call(Drawing.pattern, 'legend', gd, patternID, patternShape, patternSize, patternSolidity, mcc, markerPattern.fillmode, patternBGColor, patternFGColor, patternFGOpacity);
      } else {
        p.call(Color.fill, fillColor);
      }
      if (w) Color.stroke(p, d0.mlc || markerLine.color);
    });
  }
  function styleBoxes(d) {
    var trace = d[0].trace;
    var pts = d3.select(this).select('g.legendpoints').selectAll('path.legendbox').data(trace.visible && Registry.traceIs(trace, 'box-violin') ? [d] : []);
    pts.enter().append('path').classed('legendbox', true)
    // if we want the median bar, prepend M6,0H-6
    .attr('d', 'M6,6H-6V-6H6Z').attr('transform', centerTransform);
    pts.exit().remove();
    pts.each(function () {
      var p = d3.select(this);
      if ((trace.boxpoints === 'all' || trace.points === 'all') && Color.opacity(trace.fillcolor) === 0 && Color.opacity((trace.line || {}).color) === 0) {
        var tMod = Lib.minExtend(trace, {
          marker: {
            size: constantItemSizing ? CST_MARKER_SIZE : Lib.constrain(trace.marker.size, 2, 16),
            sizeref: 1,
            sizemin: 1,
            sizemode: 'diameter'
          }
        });
        pts.call(Drawing.pointStyle, tMod, gd);
      } else {
        var w = boundLineWidth(undefined, trace.line, MAX_MARKER_LINE_WIDTH, CST_MARKER_LINE_WIDTH);
        p.style('stroke-width', w + 'px').call(Color.fill, trace.fillcolor);
        if (w) Color.stroke(p, trace.line.color);
      }
    });
  }
  function styleCandles(d) {
    var trace = d[0].trace;
    var pts = d3.select(this).select('g.legendpoints').selectAll('path.legendcandle').data(trace.visible && trace.type === 'candlestick' ? [d, d] : []);
    pts.enter().append('path').classed('legendcandle', true).attr('d', function (_, i) {
      if (i) return 'M-15,0H-8M-8,6V-6H8Z'; // increasing
      return 'M15,0H8M8,-6V6H-8Z'; // decreasing
    }).attr('transform', centerTransform).style('stroke-miterlimit', 1);
    pts.exit().remove();
    pts.each(function (_, i) {
      var p = d3.select(this);
      var cont = trace[i ? 'increasing' : 'decreasing'];
      var w = boundLineWidth(undefined, cont.line, MAX_MARKER_LINE_WIDTH, CST_MARKER_LINE_WIDTH);
      p.style('stroke-width', w + 'px').call(Color.fill, cont.fillcolor);
      if (w) Color.stroke(p, cont.line.color);
    });
  }
  function styleOHLC(d) {
    var trace = d[0].trace;
    var pts = d3.select(this).select('g.legendpoints').selectAll('path.legendohlc').data(trace.visible && trace.type === 'ohlc' ? [d, d] : []);
    pts.enter().append('path').classed('legendohlc', true).attr('d', function (_, i) {
      if (i) return 'M-15,0H0M-8,-6V0'; // increasing
      return 'M15,0H0M8,6V0'; // decreasing
    }).attr('transform', centerTransform).style('stroke-miterlimit', 1);
    pts.exit().remove();
    pts.each(function (_, i) {
      var p = d3.select(this);
      var cont = trace[i ? 'increasing' : 'decreasing'];
      var w = boundLineWidth(undefined, cont.line, MAX_MARKER_LINE_WIDTH, CST_MARKER_LINE_WIDTH);
      p.style('fill', 'none').call(Drawing.dashLine, cont.line.dash, w);
      if (w) Color.stroke(p, cont.line.color);
    });
  }
  function stylePies(d) {
    stylePieLike(d, this, 'pie');
  }
  function styleFunnelareas(d) {
    stylePieLike(d, this, 'funnelarea');
  }
  function stylePieLike(d, lThis, desiredType) {
    var d0 = d[0];
    var trace = d0.trace;
    var isVisible = !desiredType ? Registry.traceIs(trace, desiredType) : trace.visible && trace.type === desiredType;
    var pts = d3.select(lThis).select('g.legendpoints').selectAll('path.legend' + desiredType).data(isVisible ? [d] : []);
    pts.enter().append('path').classed('legend' + desiredType, true).attr('d', 'M6,6H-6V-6H6Z').attr('transform', centerTransform);
    pts.exit().remove();
    if (pts.size()) {
      var cont = trace.marker || {};
      var lw = boundLineWidth(pieCastOption(cont.line.width, d0.pts), cont.line, MAX_MARKER_LINE_WIDTH, CST_MARKER_LINE_WIDTH);
      var opt = 'pieLike';
      var tMod = Lib.minExtend(trace, {
        marker: {
          line: {
            width: lw
          }
        }
      }, opt);
      var d0Mod = Lib.minExtend(d0, {
        trace: tMod
      }, opt);
      stylePie(pts, d0Mod, tMod, gd);
    }
  }
  function styleSpatial(d) {
    // i.e. maninly traces having z and colorscale
    var trace = d[0].trace;
    var useGradient;
    var ptsData = [];
    if (trace.visible) {
      switch (trace.type) {
        case 'histogram2d':
        case 'heatmap':
          ptsData = [['M-15,-2V4H15V-2Z'] // similar to contour
          ];

          useGradient = true;
          break;
        case 'choropleth':
        case 'choroplethmapbox':
          ptsData = [['M-6,-6V6H6V-6Z']];
          useGradient = true;
          break;
        case 'densitymapbox':
          ptsData = [['M-6,0 a6,6 0 1,0 12,0 a 6,6 0 1,0 -12,0']];
          useGradient = 'radial';
          break;
        case 'cone':
          ptsData = [['M-6,2 A2,2 0 0,0 -6,6 V6L6,4Z'], ['M-6,-6 A2,2 0 0,0 -6,-2 L6,-4Z'], ['M-6,-2 A2,2 0 0,0 -6,2 L6,0Z']];
          useGradient = false;
          break;
        case 'streamtube':
          ptsData = [['M-6,2 A2,2 0 0,0 -6,6 H6 A2,2 0 0,1 6,2 Z'], ['M-6,-6 A2,2 0 0,0 -6,-2 H6 A2,2 0 0,1 6,-6 Z'], ['M-6,-2 A2,2 0 0,0 -6,2 H6 A2,2 0 0,1 6,-2 Z']];
          useGradient = false;
          break;
        case 'surface':
          ptsData = [['M-6,-6 A2,3 0 0,0 -6,0 H6 A2,3 0 0,1 6,-6 Z'], ['M-6,1 A2,3 0 0,1 -6,6 H6 A2,3 0 0,0 6,0 Z']];
          useGradient = true;
          break;
        case 'mesh3d':
          ptsData = [['M-6,6H0L-6,-6Z'], ['M6,6H0L6,-6Z'], ['M-6,-6H6L0,6Z']];
          useGradient = false;
          break;
        case 'volume':
          ptsData = [['M-6,6H0L-6,-6Z'], ['M6,6H0L6,-6Z'], ['M-6,-6H6L0,6Z']];
          useGradient = true;
          break;
        case 'isosurface':
          ptsData = [['M-6,6H0L-6,-6Z'], ['M6,6H0L6,-6Z'], ['M-6,-6 A12,24 0 0,0 6,-6 L0,6Z']];
          useGradient = false;
          break;
      }
    }
    var pts = d3.select(this).select('g.legendpoints').selectAll('path.legend3dandfriends').data(ptsData);
    pts.enter().append('path').classed('legend3dandfriends', true).attr('transform', centerTransform).style('stroke-miterlimit', 1);
    pts.exit().remove();
    pts.each(function (dd, i) {
      var pt = d3.select(this);
      var cOpts = extractOpts(trace);
      var colorscale = cOpts.colorscale;
      var reversescale = cOpts.reversescale;
      var fillGradient = function (s) {
        if (s.size()) {
          var gradientID = 'legendfill-' + trace.uid;
          Drawing.gradient(s, gd, gradientID, getGradientDirection(reversescale, useGradient === 'radial'), colorscale, 'fill');
        }
      };
      var fillColor;
      if (!colorscale) {
        var color = trace.vertexcolor || trace.facecolor || trace.color;
        fillColor = Lib.isArrayOrTypedArray(color) ? color[i] || color[0] : color;
      } else {
        if (!useGradient) {
          var len = colorscale.length;
          fillColor = i === 0 ? colorscale[reversescale ? len - 1 : 0][1] :
          // minimum
          i === 1 ? colorscale[reversescale ? 0 : len - 1][1] :
          // maximum
          colorscale[Math.floor((len - 1) / 2)][1]; // middle
        }
      }

      pt.attr('d', dd[0]);
      if (fillColor) {
        pt.call(Color.fill, fillColor);
      } else {
        pt.call(fillGradient);
      }
    });
  }
};
function getGradientDirection(reversescale, isRadial) {
  var str = isRadial ? 'radial' : 'horizontal';
  return str + (reversescale ? '' : 'reversed');
}
function getStyleGuide(d) {
  var trace = d[0].trace;
  var contours = trace.contours;
  var showLine = subTypes.hasLines(trace);
  var showMarker = subTypes.hasMarkers(trace);
  var showFill = trace.visible && trace.fill && trace.fill !== 'none';
  var showGradientLine = false;
  var showGradientFill = false;
  if (contours) {
    var coloring = contours.coloring;
    if (coloring === 'lines') {
      showGradientLine = true;
    } else {
      showLine = coloring === 'none' || coloring === 'heatmap' || contours.showlines;
    }
    if (contours.type === 'constraint') {
      showFill = contours._operation !== '=';
    } else if (coloring === 'fill' || coloring === 'heatmap') {
      showGradientFill = true;
    }
  }
  return {
    showMarker: showMarker,
    showLine: showLine,
    showFill: showFill,
    showGradientLine: showGradientLine,
    showGradientFill: showGradientFill,
    anyLine: showLine || showGradientLine,
    anyFill: showFill || showGradientFill
  };
}
function dimAttr(v, dflt, max) {
  if (v && Lib.isArrayOrTypedArray(v)) return dflt;
  if (v > max) return max;
  return v;
}

/***/ }),

/***/ 6540:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var constants = __webpack_require__(6052);
module.exports = {
  editType: 'modebar',
  orientation: {
    valType: 'enumerated',
    values: ['v', 'h'],
    dflt: 'h',
    editType: 'modebar'
  },
  bgcolor: {
    valType: 'color',
    editType: 'modebar'
  },
  color: {
    valType: 'color',
    editType: 'modebar'
  },
  activecolor: {
    valType: 'color',
    editType: 'modebar'
  },
  uirevision: {
    valType: 'any',
    editType: 'none'
  },
  add: {
    valType: 'string',
    arrayOk: true,
    dflt: '',
    editType: 'modebar'
  },
  remove: {
    valType: 'string',
    arrayOk: true,
    dflt: '',
    editType: 'modebar'
  }
};

/***/ }),

/***/ 1868:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Registry = __webpack_require__(4040);
var Plots = __webpack_require__(7316);
var axisIds = __webpack_require__(9811);
var Icons = __webpack_require__(9224);
var eraseActiveShape = (__webpack_require__(4016).eraseActiveShape);
var Lib = __webpack_require__(3400);
var _ = Lib._;
var modeBarButtons = module.exports = {};

/**
 * ModeBar buttons configuration
 *
 * @param {string} name
 *      name / id of the buttons (for tracking)
 * @param {string} title
 *      text that appears while hovering over the button,
 *      enter null, false or '' for no hover text
 * @param {string} icon
 *      svg icon object associated with the button
 *      can be linked to Plotly.Icons to use the default plotly icons
 * @param {string} [gravity]
 *      icon positioning
 * @param {function} click
 *      click handler associated with the button, a function of
 *      'gd' (the main graph object) and
 *      'ev' (the event object)
 * @param {string} [attr]
 *      attribute associated with button,
 *      use this with 'val' to keep track of the state
 * @param {*} [val]
 *      initial 'attr' value, can be a function of gd
 * @param {boolean} [toggle]
 *      is the button a toggle button?
 */
modeBarButtons.toImage = {
  name: 'toImage',
  title: function (gd) {
    var opts = gd._context.toImageButtonOptions || {};
    var format = opts.format || 'png';
    return format === 'png' ? _(gd, 'Download plot as a png') :
    // legacy text
    _(gd, 'Download plot'); // generic non-PNG text
  },

  icon: Icons.camera,
  click: function (gd) {
    var toImageButtonOptions = gd._context.toImageButtonOptions;
    var opts = {
      format: toImageButtonOptions.format || 'png'
    };
    Lib.notifier(_(gd, 'Taking snapshot - this may take a few seconds'), 'long');
    if (opts.format !== 'svg' && Lib.isIE()) {
      Lib.notifier(_(gd, 'IE only supports svg.  Changing format to svg.'), 'long');
      opts.format = 'svg';
    }
    ['filename', 'width', 'height', 'scale'].forEach(function (key) {
      if (key in toImageButtonOptions) {
        opts[key] = toImageButtonOptions[key];
      }
    });
    Registry.call('downloadImage', gd, opts).then(function (filename) {
      Lib.notifier(_(gd, 'Snapshot succeeded') + ' - ' + filename, 'long');
    }).catch(function () {
      Lib.notifier(_(gd, 'Sorry, there was a problem downloading your snapshot!'), 'long');
    });
  }
};
modeBarButtons.sendDataToCloud = {
  name: 'sendDataToCloud',
  title: function (gd) {
    return _(gd, 'Edit in Chart Studio');
  },
  icon: Icons.disk,
  click: function (gd) {
    Plots.sendDataToCloud(gd);
  }
};
modeBarButtons.editInChartStudio = {
  name: 'editInChartStudio',
  title: function (gd) {
    return _(gd, 'Edit in Chart Studio');
  },
  icon: Icons.pencil,
  click: function (gd) {
    Plots.sendDataToCloud(gd);
  }
};
modeBarButtons.zoom2d = {
  name: 'zoom2d',
  _cat: 'zoom',
  title: function (gd) {
    return _(gd, 'Zoom');
  },
  attr: 'dragmode',
  val: 'zoom',
  icon: Icons.zoombox,
  click: handleCartesian
};
modeBarButtons.pan2d = {
  name: 'pan2d',
  _cat: 'pan',
  title: function (gd) {
    return _(gd, 'Pan');
  },
  attr: 'dragmode',
  val: 'pan',
  icon: Icons.pan,
  click: handleCartesian
};
modeBarButtons.select2d = {
  name: 'select2d',
  _cat: 'select',
  title: function (gd) {
    return _(gd, 'Box Select');
  },
  attr: 'dragmode',
  val: 'select',
  icon: Icons.selectbox,
  click: handleCartesian
};
modeBarButtons.lasso2d = {
  name: 'lasso2d',
  _cat: 'lasso',
  title: function (gd) {
    return _(gd, 'Lasso Select');
  },
  attr: 'dragmode',
  val: 'lasso',
  icon: Icons.lasso,
  click: handleCartesian
};
modeBarButtons.drawclosedpath = {
  name: 'drawclosedpath',
  title: function (gd) {
    return _(gd, 'Draw closed freeform');
  },
  attr: 'dragmode',
  val: 'drawclosedpath',
  icon: Icons.drawclosedpath,
  click: handleCartesian
};
modeBarButtons.drawopenpath = {
  name: 'drawopenpath',
  title: function (gd) {
    return _(gd, 'Draw open freeform');
  },
  attr: 'dragmode',
  val: 'drawopenpath',
  icon: Icons.drawopenpath,
  click: handleCartesian
};
modeBarButtons.drawline = {
  name: 'drawline',
  title: function (gd) {
    return _(gd, 'Draw line');
  },
  attr: 'dragmode',
  val: 'drawline',
  icon: Icons.drawline,
  click: handleCartesian
};
modeBarButtons.drawrect = {
  name: 'drawrect',
  title: function (gd) {
    return _(gd, 'Draw rectangle');
  },
  attr: 'dragmode',
  val: 'drawrect',
  icon: Icons.drawrect,
  click: handleCartesian
};
modeBarButtons.drawcircle = {
  name: 'drawcircle',
  title: function (gd) {
    return _(gd, 'Draw circle');
  },
  attr: 'dragmode',
  val: 'drawcircle',
  icon: Icons.drawcircle,
  click: handleCartesian
};
modeBarButtons.eraseshape = {
  name: 'eraseshape',
  title: function (gd) {
    return _(gd, 'Erase active shape');
  },
  icon: Icons.eraseshape,
  click: eraseActiveShape
};
modeBarButtons.zoomIn2d = {
  name: 'zoomIn2d',
  _cat: 'zoomin',
  title: function (gd) {
    return _(gd, 'Zoom in');
  },
  attr: 'zoom',
  val: 'in',
  icon: Icons.zoom_plus,
  click: handleCartesian
};
modeBarButtons.zoomOut2d = {
  name: 'zoomOut2d',
  _cat: 'zoomout',
  title: function (gd) {
    return _(gd, 'Zoom out');
  },
  attr: 'zoom',
  val: 'out',
  icon: Icons.zoom_minus,
  click: handleCartesian
};
modeBarButtons.autoScale2d = {
  name: 'autoScale2d',
  _cat: 'autoscale',
  title: function (gd) {
    return _(gd, 'Autoscale');
  },
  attr: 'zoom',
  val: 'auto',
  icon: Icons.autoscale,
  click: handleCartesian
};
modeBarButtons.resetScale2d = {
  name: 'resetScale2d',
  _cat: 'resetscale',
  title: function (gd) {
    return _(gd, 'Reset axes');
  },
  attr: 'zoom',
  val: 'reset',
  icon: Icons.home,
  click: handleCartesian
};
modeBarButtons.hoverClosestCartesian = {
  name: 'hoverClosestCartesian',
  _cat: 'hoverclosest',
  title: function (gd) {
    return _(gd, 'Show closest data on hover');
  },
  attr: 'hovermode',
  val: 'closest',
  icon: Icons.tooltip_basic,
  gravity: 'ne',
  click: handleCartesian
};
modeBarButtons.hoverCompareCartesian = {
  name: 'hoverCompareCartesian',
  _cat: 'hoverCompare',
  title: function (gd) {
    return _(gd, 'Compare data on hover');
  },
  attr: 'hovermode',
  val: function (gd) {
    return gd._fullLayout._isHoriz ? 'y' : 'x';
  },
  icon: Icons.tooltip_compare,
  gravity: 'ne',
  click: handleCartesian
};
function handleCartesian(gd, ev) {
  var button = ev.currentTarget;
  var astr = button.getAttribute('data-attr');
  var val = button.getAttribute('data-val') || true;
  var fullLayout = gd._fullLayout;
  var aobj = {};
  var axList = axisIds.list(gd, null, true);
  var allSpikesEnabled = fullLayout._cartesianSpikesEnabled;
  var ax, i;
  if (astr === 'zoom') {
    var mag = val === 'in' ? 0.5 : 2;
    var r0 = (1 + mag) / 2;
    var r1 = (1 - mag) / 2;
    var axName;
    for (i = 0; i < axList.length; i++) {
      ax = axList[i];
      if (!ax.fixedrange) {
        axName = ax._name;
        if (val === 'auto') {
          aobj[axName + '.autorange'] = true;
        } else if (val === 'reset') {
          if (ax._rangeInitial0 === undefined && ax._rangeInitial1 === undefined) {
            aobj[axName + '.autorange'] = true;
          } else if (ax._rangeInitial0 === undefined) {
            aobj[axName + '.autorange'] = ax._autorangeInitial;
            aobj[axName + '.range'] = [null, ax._rangeInitial1];
          } else if (ax._rangeInitial1 === undefined) {
            aobj[axName + '.range'] = [ax._rangeInitial0, null];
            aobj[axName + '.autorange'] = ax._autorangeInitial;
          } else {
            aobj[axName + '.range'] = [ax._rangeInitial0, ax._rangeInitial1];
          }

          // N.B. "reset" also resets showspikes
          if (ax._showSpikeInitial !== undefined) {
            aobj[axName + '.showspikes'] = ax._showSpikeInitial;
            if (allSpikesEnabled === 'on' && !ax._showSpikeInitial) {
              allSpikesEnabled = 'off';
            }
          }
        } else {
          var rangeNow = [ax.r2l(ax.range[0]), ax.r2l(ax.range[1])];
          var rangeNew = [r0 * rangeNow[0] + r1 * rangeNow[1], r0 * rangeNow[1] + r1 * rangeNow[0]];
          aobj[axName + '.range[0]'] = ax.l2r(rangeNew[0]);
          aobj[axName + '.range[1]'] = ax.l2r(rangeNew[1]);
        }
      }
    }
  } else {
    // if ALL traces have orientation 'h', 'hovermode': 'x' otherwise: 'y'
    if (astr === 'hovermode' && (val === 'x' || val === 'y')) {
      val = fullLayout._isHoriz ? 'y' : 'x';
      button.setAttribute('data-val', val);
    }
    aobj[astr] = val;
  }
  fullLayout._cartesianSpikesEnabled = allSpikesEnabled;
  Registry.call('_guiRelayout', gd, aobj);
}
modeBarButtons.zoom3d = {
  name: 'zoom3d',
  _cat: 'zoom',
  title: function (gd) {
    return _(gd, 'Zoom');
  },
  attr: 'scene.dragmode',
  val: 'zoom',
  icon: Icons.zoombox,
  click: handleDrag3d
};
modeBarButtons.pan3d = {
  name: 'pan3d',
  _cat: 'pan',
  title: function (gd) {
    return _(gd, 'Pan');
  },
  attr: 'scene.dragmode',
  val: 'pan',
  icon: Icons.pan,
  click: handleDrag3d
};
modeBarButtons.orbitRotation = {
  name: 'orbitRotation',
  title: function (gd) {
    return _(gd, 'Orbital rotation');
  },
  attr: 'scene.dragmode',
  val: 'orbit',
  icon: Icons['3d_rotate'],
  click: handleDrag3d
};
modeBarButtons.tableRotation = {
  name: 'tableRotation',
  title: function (gd) {
    return _(gd, 'Turntable rotation');
  },
  attr: 'scene.dragmode',
  val: 'turntable',
  icon: Icons['z-axis'],
  click: handleDrag3d
};
function handleDrag3d(gd, ev) {
  var button = ev.currentTarget;
  var attr = button.getAttribute('data-attr');
  var val = button.getAttribute('data-val') || true;
  var sceneIds = gd._fullLayout._subplots.gl3d || [];
  var layoutUpdate = {};
  var parts = attr.split('.');
  for (var i = 0; i < sceneIds.length; i++) {
    layoutUpdate[sceneIds[i] + '.' + parts[1]] = val;
  }

  // for multi-type subplots
  var val2d = val === 'pan' ? val : 'zoom';
  layoutUpdate.dragmode = val2d;
  Registry.call('_guiRelayout', gd, layoutUpdate);
}
modeBarButtons.resetCameraDefault3d = {
  name: 'resetCameraDefault3d',
  _cat: 'resetCameraDefault',
  title: function (gd) {
    return _(gd, 'Reset camera to default');
  },
  attr: 'resetDefault',
  icon: Icons.home,
  click: handleCamera3d
};
modeBarButtons.resetCameraLastSave3d = {
  name: 'resetCameraLastSave3d',
  _cat: 'resetCameraLastSave',
  title: function (gd) {
    return _(gd, 'Reset camera to last save');
  },
  attr: 'resetLastSave',
  icon: Icons.movie,
  click: handleCamera3d
};
function handleCamera3d(gd, ev) {
  var button = ev.currentTarget;
  var attr = button.getAttribute('data-attr');
  var resetLastSave = attr === 'resetLastSave';
  var resetDefault = attr === 'resetDefault';
  var fullLayout = gd._fullLayout;
  var sceneIds = fullLayout._subplots.gl3d || [];
  var aobj = {};
  for (var i = 0; i < sceneIds.length; i++) {
    var sceneId = sceneIds[i];
    var camera = sceneId + '.camera';
    var aspectratio = sceneId + '.aspectratio';
    var aspectmode = sceneId + '.aspectmode';
    var scene = fullLayout[sceneId]._scene;
    var didUpdate;
    if (resetLastSave) {
      aobj[camera + '.up'] = scene.viewInitial.up;
      aobj[camera + '.eye'] = scene.viewInitial.eye;
      aobj[camera + '.center'] = scene.viewInitial.center;
      didUpdate = true;
    } else if (resetDefault) {
      aobj[camera + '.up'] = null;
      aobj[camera + '.eye'] = null;
      aobj[camera + '.center'] = null;
      didUpdate = true;
    }
    if (didUpdate) {
      aobj[aspectratio + '.x'] = scene.viewInitial.aspectratio.x;
      aobj[aspectratio + '.y'] = scene.viewInitial.aspectratio.y;
      aobj[aspectratio + '.z'] = scene.viewInitial.aspectratio.z;
      aobj[aspectmode] = scene.viewInitial.aspectmode;
    }
  }
  Registry.call('_guiRelayout', gd, aobj);
}
modeBarButtons.hoverClosest3d = {
  name: 'hoverClosest3d',
  _cat: 'hoverclosest',
  title: function (gd) {
    return _(gd, 'Toggle show closest data on hover');
  },
  attr: 'hovermode',
  val: null,
  toggle: true,
  icon: Icons.tooltip_basic,
  gravity: 'ne',
  click: handleHover3d
};
function getNextHover3d(gd, ev) {
  var button = ev.currentTarget;
  var val = button._previousVal;
  var fullLayout = gd._fullLayout;
  var sceneIds = fullLayout._subplots.gl3d || [];
  var axes = ['xaxis', 'yaxis', 'zaxis'];

  // initialize 'current spike' object to be stored in the DOM
  var currentSpikes = {};
  var layoutUpdate = {};
  if (val) {
    layoutUpdate = val;
    button._previousVal = null;
  } else {
    for (var i = 0; i < sceneIds.length; i++) {
      var sceneId = sceneIds[i];
      var sceneLayout = fullLayout[sceneId];
      var hovermodeAStr = sceneId + '.hovermode';
      currentSpikes[hovermodeAStr] = sceneLayout.hovermode;
      layoutUpdate[hovermodeAStr] = false;

      // copy all the current spike attrs
      for (var j = 0; j < 3; j++) {
        var axis = axes[j];
        var spikeAStr = sceneId + '.' + axis + '.showspikes';
        layoutUpdate[spikeAStr] = false;
        currentSpikes[spikeAStr] = sceneLayout[axis].showspikes;
      }
    }
    button._previousVal = currentSpikes;
  }
  return layoutUpdate;
}
function handleHover3d(gd, ev) {
  var layoutUpdate = getNextHover3d(gd, ev);
  Registry.call('_guiRelayout', gd, layoutUpdate);
}
modeBarButtons.zoomInGeo = {
  name: 'zoomInGeo',
  _cat: 'zoomin',
  title: function (gd) {
    return _(gd, 'Zoom in');
  },
  attr: 'zoom',
  val: 'in',
  icon: Icons.zoom_plus,
  click: handleGeo
};
modeBarButtons.zoomOutGeo = {
  name: 'zoomOutGeo',
  _cat: 'zoomout',
  title: function (gd) {
    return _(gd, 'Zoom out');
  },
  attr: 'zoom',
  val: 'out',
  icon: Icons.zoom_minus,
  click: handleGeo
};
modeBarButtons.resetGeo = {
  name: 'resetGeo',
  _cat: 'reset',
  title: function (gd) {
    return _(gd, 'Reset');
  },
  attr: 'reset',
  val: null,
  icon: Icons.autoscale,
  click: handleGeo
};
modeBarButtons.hoverClosestGeo = {
  name: 'hoverClosestGeo',
  _cat: 'hoverclosest',
  title: function (gd) {
    return _(gd, 'Toggle show closest data on hover');
  },
  attr: 'hovermode',
  val: null,
  toggle: true,
  icon: Icons.tooltip_basic,
  gravity: 'ne',
  click: toggleHover
};
function handleGeo(gd, ev) {
  var button = ev.currentTarget;
  var attr = button.getAttribute('data-attr');
  var val = button.getAttribute('data-val') || true;
  var fullLayout = gd._fullLayout;
  var geoIds = fullLayout._subplots.geo || [];
  for (var i = 0; i < geoIds.length; i++) {
    var id = geoIds[i];
    var geoLayout = fullLayout[id];
    if (attr === 'zoom') {
      var scale = geoLayout.projection.scale;
      var newScale = val === 'in' ? 2 * scale : 0.5 * scale;
      Registry.call('_guiRelayout', gd, id + '.projection.scale', newScale);
    }
  }
  if (attr === 'reset') {
    resetView(gd, 'geo');
  }
}
modeBarButtons.hoverClosestGl2d = {
  name: 'hoverClosestGl2d',
  _cat: 'hoverclosest',
  title: function (gd) {
    return _(gd, 'Toggle show closest data on hover');
  },
  attr: 'hovermode',
  val: null,
  toggle: true,
  icon: Icons.tooltip_basic,
  gravity: 'ne',
  click: toggleHover
};
modeBarButtons.hoverClosestPie = {
  name: 'hoverClosestPie',
  _cat: 'hoverclosest',
  title: function (gd) {
    return _(gd, 'Toggle show closest data on hover');
  },
  attr: 'hovermode',
  val: 'closest',
  icon: Icons.tooltip_basic,
  gravity: 'ne',
  click: toggleHover
};
function getNextHover(gd) {
  var fullLayout = gd._fullLayout;
  if (fullLayout.hovermode) return false;
  if (fullLayout._has('cartesian')) {
    return fullLayout._isHoriz ? 'y' : 'x';
  }
  return 'closest';
}
function toggleHover(gd) {
  var newHover = getNextHover(gd);
  Registry.call('_guiRelayout', gd, 'hovermode', newHover);
}
modeBarButtons.resetViewSankey = {
  name: 'resetSankeyGroup',
  title: function (gd) {
    return _(gd, 'Reset view');
  },
  icon: Icons.home,
  click: function (gd) {
    var aObj = {
      'node.groups': [],
      'node.x': [],
      'node.y': []
    };
    for (var i = 0; i < gd._fullData.length; i++) {
      var viewInitial = gd._fullData[i]._viewInitial;
      aObj['node.groups'].push(viewInitial.node.groups.slice());
      aObj['node.x'].push(viewInitial.node.x.slice());
      aObj['node.y'].push(viewInitial.node.y.slice());
    }
    Registry.call('restyle', gd, aObj);
  }
};

// buttons when more then one plot types are present

modeBarButtons.toggleHover = {
  name: 'toggleHover',
  title: function (gd) {
    return _(gd, 'Toggle show closest data on hover');
  },
  attr: 'hovermode',
  val: null,
  toggle: true,
  icon: Icons.tooltip_basic,
  gravity: 'ne',
  click: function (gd, ev) {
    var layoutUpdate = getNextHover3d(gd, ev);
    layoutUpdate.hovermode = getNextHover(gd);
    Registry.call('_guiRelayout', gd, layoutUpdate);
  }
};
modeBarButtons.resetViews = {
  name: 'resetViews',
  title: function (gd) {
    return _(gd, 'Reset views');
  },
  icon: Icons.home,
  click: function (gd, ev) {
    var button = ev.currentTarget;
    button.setAttribute('data-attr', 'zoom');
    button.setAttribute('data-val', 'reset');
    handleCartesian(gd, ev);
    button.setAttribute('data-attr', 'resetLastSave');
    handleCamera3d(gd, ev);
    resetView(gd, 'geo');
    resetView(gd, 'mapbox');
  }
};
modeBarButtons.toggleSpikelines = {
  name: 'toggleSpikelines',
  title: function (gd) {
    return _(gd, 'Toggle Spike Lines');
  },
  icon: Icons.spikeline,
  attr: '_cartesianSpikesEnabled',
  val: 'on',
  click: function (gd) {
    var fullLayout = gd._fullLayout;
    var allSpikesEnabled = fullLayout._cartesianSpikesEnabled;
    fullLayout._cartesianSpikesEnabled = allSpikesEnabled === 'on' ? 'off' : 'on';
    Registry.call('_guiRelayout', gd, setSpikelineVisibility(gd));
  }
};
function setSpikelineVisibility(gd) {
  var fullLayout = gd._fullLayout;
  var areSpikesOn = fullLayout._cartesianSpikesEnabled === 'on';
  var axList = axisIds.list(gd, null, true);
  var aobj = {};
  for (var i = 0; i < axList.length; i++) {
    var ax = axList[i];
    aobj[ax._name + '.showspikes'] = areSpikesOn ? true : ax._showSpikeInitial;
  }
  return aobj;
}
modeBarButtons.resetViewMapbox = {
  name: 'resetViewMapbox',
  _cat: 'resetView',
  title: function (gd) {
    return _(gd, 'Reset view');
  },
  attr: 'reset',
  icon: Icons.home,
  click: function (gd) {
    resetView(gd, 'mapbox');
  }
};
modeBarButtons.zoomInMapbox = {
  name: 'zoomInMapbox',
  _cat: 'zoomin',
  title: function (gd) {
    return _(gd, 'Zoom in');
  },
  attr: 'zoom',
  val: 'in',
  icon: Icons.zoom_plus,
  click: handleMapboxZoom
};
modeBarButtons.zoomOutMapbox = {
  name: 'zoomOutMapbox',
  _cat: 'zoomout',
  title: function (gd) {
    return _(gd, 'Zoom out');
  },
  attr: 'zoom',
  val: 'out',
  icon: Icons.zoom_minus,
  click: handleMapboxZoom
};
function handleMapboxZoom(gd, ev) {
  var button = ev.currentTarget;
  var val = button.getAttribute('data-val');
  var fullLayout = gd._fullLayout;
  var subplotIds = fullLayout._subplots.mapbox || [];
  var scalar = 1.05;
  var aObj = {};
  for (var i = 0; i < subplotIds.length; i++) {
    var id = subplotIds[i];
    var current = fullLayout[id].zoom;
    var next = val === 'in' ? scalar * current : current / scalar;
    aObj[id + '.zoom'] = next;
  }
  Registry.call('_guiRelayout', gd, aObj);
}
function resetView(gd, subplotType) {
  var fullLayout = gd._fullLayout;
  var subplotIds = fullLayout._subplots[subplotType] || [];
  var aObj = {};
  for (var i = 0; i < subplotIds.length; i++) {
    var id = subplotIds[i];
    var subplotObj = fullLayout[id]._subplot;
    var viewInitial = subplotObj.viewInitial;
    var viewKeys = Object.keys(viewInitial);
    for (var j = 0; j < viewKeys.length; j++) {
      var key = viewKeys[j];
      aObj[id + '.' + key] = viewInitial[key];
    }
  }
  Registry.call('_guiRelayout', gd, aObj);
}

/***/ }),

/***/ 6052:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var modeBarButtons = __webpack_require__(1868);
var buttonList = Object.keys(modeBarButtons);
var DRAW_MODES = ['drawline', 'drawopenpath', 'drawclosedpath', 'drawcircle', 'drawrect', 'eraseshape'];
var backButtons = ['v1hovermode', 'hoverclosest', 'hovercompare', 'togglehover', 'togglespikelines'].concat(DRAW_MODES);
var foreButtons = [];
var addToForeButtons = function (b) {
  if (backButtons.indexOf(b._cat || b.name) !== -1) return;
  // for convenience add lowercase shotname e.g. zoomin as well fullname zoomInGeo
  var name = b.name;
  var _cat = (b._cat || b.name).toLowerCase();
  if (foreButtons.indexOf(name) === -1) foreButtons.push(name);
  if (foreButtons.indexOf(_cat) === -1) foreButtons.push(_cat);
};
buttonList.forEach(function (k) {
  addToForeButtons(modeBarButtons[k]);
});
foreButtons.sort();
module.exports = {
  DRAW_MODES: DRAW_MODES,
  backButtons: backButtons,
  foreButtons: foreButtons
};

/***/ }),

/***/ 824:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Color = __webpack_require__(6308);
var Template = __webpack_require__(1780);
var attributes = __webpack_require__(6540);
module.exports = function supplyLayoutDefaults(layoutIn, layoutOut) {
  var containerIn = layoutIn.modebar || {};
  var containerOut = Template.newContainer(layoutOut, 'modebar');
  function coerce(attr, dflt) {
    return Lib.coerce(containerIn, containerOut, attributes, attr, dflt);
  }
  coerce('orientation');
  coerce('bgcolor', Color.addOpacity(layoutOut.paper_bgcolor, 0.5));
  var defaultColor = Color.contrast(Color.rgb(layoutOut.modebar.bgcolor));
  coerce('color', Color.addOpacity(defaultColor, 0.3));
  coerce('activecolor', Color.addOpacity(defaultColor, 0.7));
  coerce('uirevision', layoutOut.uirevision);
  coerce('add');
  coerce('remove');
};

/***/ }),

/***/ 3080:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = {
  moduleType: 'component',
  name: 'modebar',
  layoutAttributes: __webpack_require__(6540),
  supplyLayoutDefaults: __webpack_require__(824),
  manage: __webpack_require__(8816)
};

/***/ }),

/***/ 8816:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var axisIds = __webpack_require__(9811);
var scatterSubTypes = __webpack_require__(3028);
var Registry = __webpack_require__(4040);
var isUnifiedHover = (__webpack_require__(624).isUnifiedHover);
var createModeBar = __webpack_require__(6400);
var modeBarButtons = __webpack_require__(1868);
var DRAW_MODES = (__webpack_require__(6052).DRAW_MODES);
var extendDeep = (__webpack_require__(3400).extendDeep);

/**
 * ModeBar wrapper around 'create' and 'update',
 * chooses buttons to pass to ModeBar constructor based on
 * plot type and plot config.
 *
 * @param {object} gd main plot object
 *
 */
module.exports = function manageModeBar(gd) {
  var fullLayout = gd._fullLayout;
  var context = gd._context;
  var modeBar = fullLayout._modeBar;
  if (!context.displayModeBar && !context.watermark) {
    if (modeBar) {
      modeBar.destroy();
      delete fullLayout._modeBar;
    }
    return;
  }
  if (!Array.isArray(context.modeBarButtonsToRemove)) {
    throw new Error(['*modeBarButtonsToRemove* configuration options', 'must be an array.'].join(' '));
  }
  if (!Array.isArray(context.modeBarButtonsToAdd)) {
    throw new Error(['*modeBarButtonsToAdd* configuration options', 'must be an array.'].join(' '));
  }
  var customButtons = context.modeBarButtons;
  var buttonGroups;
  if (Array.isArray(customButtons) && customButtons.length) {
    buttonGroups = fillCustomButton(customButtons);
  } else if (!context.displayModeBar && context.watermark) {
    buttonGroups = [];
  } else {
    buttonGroups = getButtonGroups(gd);
  }
  if (modeBar) modeBar.update(gd, buttonGroups);else fullLayout._modeBar = createModeBar(gd, buttonGroups);
};

// logic behind which buttons are displayed by default
function getButtonGroups(gd) {
  var fullLayout = gd._fullLayout;
  var fullData = gd._fullData;
  var context = gd._context;
  function match(name, B) {
    if (typeof B === 'string') {
      if (B.toLowerCase() === name.toLowerCase()) return true;
    } else {
      var v0 = B.name;
      var v1 = B._cat || B.name;
      if (v0 === name || v1 === name.toLowerCase()) return true;
    }
    return false;
  }
  var layoutAdd = fullLayout.modebar.add;
  if (typeof layoutAdd === 'string') layoutAdd = [layoutAdd];
  var layoutRemove = fullLayout.modebar.remove;
  if (typeof layoutRemove === 'string') layoutRemove = [layoutRemove];
  var buttonsToAdd = context.modeBarButtonsToAdd.concat(layoutAdd.filter(function (e) {
    for (var i = 0; i < context.modeBarButtonsToRemove.length; i++) {
      if (match(e, context.modeBarButtonsToRemove[i])) return false;
    }
    return true;
  }));
  var buttonsToRemove = context.modeBarButtonsToRemove.concat(layoutRemove.filter(function (e) {
    for (var i = 0; i < context.modeBarButtonsToAdd.length; i++) {
      if (match(e, context.modeBarButtonsToAdd[i])) return false;
    }
    return true;
  }));
  var hasCartesian = fullLayout._has('cartesian');
  var hasGL3D = fullLayout._has('gl3d');
  var hasGeo = fullLayout._has('geo');
  var hasPie = fullLayout._has('pie');
  var hasFunnelarea = fullLayout._has('funnelarea');
  var hasGL2D = fullLayout._has('gl2d');
  var hasTernary = fullLayout._has('ternary');
  var hasMapbox = fullLayout._has('mapbox');
  var hasPolar = fullLayout._has('polar');
  var hasSmith = fullLayout._has('smith');
  var hasSankey = fullLayout._has('sankey');
  var allAxesFixed = areAllAxesFixed(fullLayout);
  var hasUnifiedHoverLabel = isUnifiedHover(fullLayout.hovermode);
  var groups = [];
  function addGroup(newGroup) {
    if (!newGroup.length) return;
    var out = [];
    for (var i = 0; i < newGroup.length; i++) {
      var name = newGroup[i];
      var B = modeBarButtons[name];
      var v0 = B.name.toLowerCase();
      var v1 = (B._cat || B.name).toLowerCase();
      var found = false;
      for (var q = 0; q < buttonsToRemove.length; q++) {
        var t = buttonsToRemove[q].toLowerCase();
        if (t === v0 || t === v1) {
          found = true;
          break;
        }
      }
      if (found) continue;
      out.push(modeBarButtons[name]);
    }
    groups.push(out);
  }

  // buttons common to all plot types
  var commonGroup = ['toImage'];
  if (context.showEditInChartStudio) commonGroup.push('editInChartStudio');else if (context.showSendToCloud) commonGroup.push('sendDataToCloud');
  addGroup(commonGroup);
  var zoomGroup = [];
  var hoverGroup = [];
  var resetGroup = [];
  var dragModeGroup = [];
  if ((hasCartesian || hasGL2D || hasPie || hasFunnelarea || hasTernary) + hasGeo + hasGL3D + hasMapbox + hasPolar + hasSmith > 1) {
    // graphs with more than one plot types get 'union buttons'
    // which reset the view or toggle hover labels across all subplots.
    hoverGroup = ['toggleHover'];
    resetGroup = ['resetViews'];
  } else if (hasGeo) {
    zoomGroup = ['zoomInGeo', 'zoomOutGeo'];
    hoverGroup = ['hoverClosestGeo'];
    resetGroup = ['resetGeo'];
  } else if (hasGL3D) {
    hoverGroup = ['hoverClosest3d'];
    resetGroup = ['resetCameraDefault3d', 'resetCameraLastSave3d'];
  } else if (hasMapbox) {
    zoomGroup = ['zoomInMapbox', 'zoomOutMapbox'];
    hoverGroup = ['toggleHover'];
    resetGroup = ['resetViewMapbox'];
  } else if (hasGL2D) {
    hoverGroup = ['hoverClosestGl2d'];
  } else if (hasPie) {
    hoverGroup = ['hoverClosestPie'];
  } else if (hasSankey) {
    hoverGroup = ['hoverClosestCartesian', 'hoverCompareCartesian'];
    resetGroup = ['resetViewSankey'];
  } else {
    // hasPolar, hasSmith, hasTernary
    // always show at least one hover icon.
    hoverGroup = ['toggleHover'];
  }
  // if we have cartesian, allow switching between closest and compare
  // regardless of what other types are on the plot, since they'll all
  // just treat any truthy hovermode as 'closest'
  if (hasCartesian) {
    hoverGroup = ['toggleSpikelines', 'hoverClosestCartesian', 'hoverCompareCartesian'];
  }
  if (hasNoHover(fullData) || hasUnifiedHoverLabel) {
    hoverGroup = [];
  }
  if ((hasCartesian || hasGL2D) && !allAxesFixed) {
    zoomGroup = ['zoomIn2d', 'zoomOut2d', 'autoScale2d'];
    if (resetGroup[0] !== 'resetViews') resetGroup = ['resetScale2d'];
  }
  if (hasGL3D) {
    dragModeGroup = ['zoom3d', 'pan3d', 'orbitRotation', 'tableRotation'];
  } else if ((hasCartesian || hasGL2D) && !allAxesFixed || hasTernary) {
    dragModeGroup = ['zoom2d', 'pan2d'];
  } else if (hasMapbox || hasGeo) {
    dragModeGroup = ['pan2d'];
  } else if (hasPolar) {
    dragModeGroup = ['zoom2d'];
  }
  if (isSelectable(fullData)) {
    dragModeGroup.push('select2d', 'lasso2d');
  }
  var enabledHoverGroup = [];
  var enableHover = function (a) {
    // return if already added
    if (enabledHoverGroup.indexOf(a) !== -1) return;
    // should be in hoverGroup
    if (hoverGroup.indexOf(a) !== -1) {
      enabledHoverGroup.push(a);
    }
  };
  if (Array.isArray(buttonsToAdd)) {
    var newList = [];
    for (var i = 0; i < buttonsToAdd.length; i++) {
      var b = buttonsToAdd[i];
      if (typeof b === 'string') {
        b = b.toLowerCase();
        if (DRAW_MODES.indexOf(b) !== -1) {
          // accept pre-defined drag modes i.e. shape drawing features as string
          if (fullLayout._has('mapbox') ||
          // draw shapes in paper coordinate (could be improved in future to support data coordinate, when there is no pitch)
          fullLayout._has('cartesian') // draw shapes in data coordinate
          ) {
            dragModeGroup.push(b);
          }
        } else if (b === 'togglespikelines') {
          enableHover('toggleSpikelines');
        } else if (b === 'togglehover') {
          enableHover('toggleHover');
        } else if (b === 'hovercompare') {
          enableHover('hoverCompareCartesian');
        } else if (b === 'hoverclosest') {
          enableHover('hoverClosestCartesian');
          enableHover('hoverClosestGeo');
          enableHover('hoverClosest3d');
          enableHover('hoverClosestGl2d');
          enableHover('hoverClosestPie');
        } else if (b === 'v1hovermode') {
          enableHover('toggleHover');
          enableHover('hoverClosestCartesian');
          enableHover('hoverCompareCartesian');
          enableHover('hoverClosestGeo');
          enableHover('hoverClosest3d');
          enableHover('hoverClosestGl2d');
          enableHover('hoverClosestPie');
        }
      } else newList.push(b);
    }
    buttonsToAdd = newList;
  }
  addGroup(dragModeGroup);
  addGroup(zoomGroup.concat(resetGroup));
  addGroup(enabledHoverGroup);
  return appendButtonsToGroups(groups, buttonsToAdd);
}
function areAllAxesFixed(fullLayout) {
  var axList = axisIds.list({
    _fullLayout: fullLayout
  }, null, true);
  for (var i = 0; i < axList.length; i++) {
    if (!axList[i].fixedrange) {
      return false;
    }
  }
  return true;
}

// look for traces that support selection
// to be updated as we add more selectPoints handlers
function isSelectable(fullData) {
  var selectable = false;
  for (var i = 0; i < fullData.length; i++) {
    if (selectable) break;
    var trace = fullData[i];
    if (!trace._module || !trace._module.selectPoints) continue;
    if (Registry.traceIs(trace, 'scatter-like')) {
      if (scatterSubTypes.hasMarkers(trace) || scatterSubTypes.hasText(trace)) {
        selectable = true;
      }
    } else if (Registry.traceIs(trace, 'box-violin')) {
      if (trace.boxpoints === 'all' || trace.points === 'all') {
        selectable = true;
      }
    } else {
      // assume that in general if the trace module has selectPoints,
      // then it's selectable. Scatter is an exception to this because it must
      // have markers or text, not just be a scatter type.

      selectable = true;
    }
  }
  return selectable;
}

// check whether all trace are 'noHover'
function hasNoHover(fullData) {
  for (var i = 0; i < fullData.length; i++) {
    if (!Registry.traceIs(fullData[i], 'noHover')) return false;
  }
  return true;
}
function appendButtonsToGroups(groups, buttons) {
  if (buttons.length) {
    if (Array.isArray(buttons[0])) {
      for (var i = 0; i < buttons.length; i++) {
        groups.push(buttons[i]);
      }
    } else groups.push(buttons);
  }
  return groups;
}

// fill in custom buttons referring to default mode bar buttons
function fillCustomButton(originalModeBarButtons) {
  var customButtons = extendDeep([], originalModeBarButtons);
  for (var i = 0; i < customButtons.length; i++) {
    var buttonGroup = customButtons[i];
    for (var j = 0; j < buttonGroup.length; j++) {
      var button = buttonGroup[j];
      if (typeof button === 'string') {
        if (modeBarButtons[button] !== undefined) {
          customButtons[i][j] = modeBarButtons[button];
        } else {
          throw new Error(['*modeBarButtons* configuration options', 'invalid button name'].join(' '));
        }
      }
    }
  }
  return customButtons;
}

/***/ }),

/***/ 6400:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var isNumeric = __webpack_require__(8248);
var Lib = __webpack_require__(3400);
var Icons = __webpack_require__(9224);
var version = (__webpack_require__(5788).version);
var Parser = new DOMParser();

/**
 * UI controller for interactive plots
 * @Class
 * @Param {object} opts
 * @Param {object} opts.buttons    nested arrays of grouped buttons config objects
 * @Param {object} opts.container  container div to append modeBar
 * @Param {object} opts.graphInfo  primary plot object containing data and layout
 */
function ModeBar(opts) {
  this.container = opts.container;
  this.element = document.createElement('div');
  this.update(opts.graphInfo, opts.buttons);
  this.container.appendChild(this.element);
}
var proto = ModeBar.prototype;

/**
 * Update modeBar (buttons and logo)
 *
 * @param {object} graphInfo  primary plot object containing data and layout
 * @param {array of arrays} buttons nested arrays of grouped buttons to initialize
 *
 */
proto.update = function (graphInfo, buttons) {
  this.graphInfo = graphInfo;
  var context = this.graphInfo._context;
  var fullLayout = this.graphInfo._fullLayout;
  var modeBarId = 'modebar-' + fullLayout._uid;
  this.element.setAttribute('id', modeBarId);
  this._uid = modeBarId;
  this.element.className = 'modebar';
  if (context.displayModeBar === 'hover') this.element.className += ' modebar--hover ease-bg';
  if (fullLayout.modebar.orientation === 'v') {
    this.element.className += ' vertical';
    buttons = buttons.reverse();
  }
  var style = fullLayout.modebar;
  var bgSelector = context.displayModeBar === 'hover' ? '.js-plotly-plot .plotly:hover ' : '';
  Lib.deleteRelatedStyleRule(modeBarId);
  Lib.addRelatedStyleRule(modeBarId, bgSelector + '#' + modeBarId + ' .modebar-group', 'background-color: ' + style.bgcolor);
  Lib.addRelatedStyleRule(modeBarId, '#' + modeBarId + ' .modebar-btn .icon path', 'fill: ' + style.color);
  Lib.addRelatedStyleRule(modeBarId, '#' + modeBarId + ' .modebar-btn:hover .icon path', 'fill: ' + style.activecolor);
  Lib.addRelatedStyleRule(modeBarId, '#' + modeBarId + ' .modebar-btn.active .icon path', 'fill: ' + style.activecolor);

  // if buttons or logo have changed, redraw modebar interior
  var needsNewButtons = !this.hasButtons(buttons);
  var needsNewLogo = this.hasLogo !== context.displaylogo;
  var needsNewLocale = this.locale !== context.locale;
  this.locale = context.locale;
  if (needsNewButtons || needsNewLogo || needsNewLocale) {
    this.removeAllButtons();
    this.updateButtons(buttons);
    if (context.watermark || context.displaylogo) {
      var logoGroup = this.getLogo();
      if (context.watermark) {
        logoGroup.className = logoGroup.className + ' watermark';
      }
      if (fullLayout.modebar.orientation === 'v') {
        this.element.insertBefore(logoGroup, this.element.childNodes[0]);
      } else {
        this.element.appendChild(logoGroup);
      }
      this.hasLogo = true;
    }
  }
  this.updateActiveButton();
};
proto.updateButtons = function (buttons) {
  var _this = this;
  this.buttons = buttons;
  this.buttonElements = [];
  this.buttonsNames = [];
  this.buttons.forEach(function (buttonGroup) {
    var group = _this.createGroup();
    buttonGroup.forEach(function (buttonConfig) {
      var buttonName = buttonConfig.name;
      if (!buttonName) {
        throw new Error('must provide button \'name\' in button config');
      }
      if (_this.buttonsNames.indexOf(buttonName) !== -1) {
        throw new Error('button name \'' + buttonName + '\' is taken');
      }
      _this.buttonsNames.push(buttonName);
      var button = _this.createButton(buttonConfig);
      _this.buttonElements.push(button);
      group.appendChild(button);
    });
    _this.element.appendChild(group);
  });
};

/**
 * Empty div for containing a group of buttons
 * @Return {HTMLelement}
 */
proto.createGroup = function () {
  var group = document.createElement('div');
  group.className = 'modebar-group';
  return group;
};

/**
 * Create a new button div and set constant and configurable attributes
 * @Param {object} config (see ./buttons.js for more info)
 * @Return {HTMLelement}
 */
proto.createButton = function (config) {
  var _this = this;
  var button = document.createElement('a');
  button.setAttribute('rel', 'tooltip');
  button.className = 'modebar-btn';
  var title = config.title;
  if (title === undefined) title = config.name;
  // for localization: allow title to be a callable that takes gd as arg
  else if (typeof title === 'function') title = title(this.graphInfo);
  if (title || title === 0) button.setAttribute('data-title', title);
  if (config.attr !== undefined) button.setAttribute('data-attr', config.attr);
  var val = config.val;
  if (val !== undefined) {
    if (typeof val === 'function') val = val(this.graphInfo);
    button.setAttribute('data-val', val);
  }
  var click = config.click;
  if (typeof click !== 'function') {
    throw new Error('must provide button \'click\' function in button config');
  } else {
    button.addEventListener('click', function (ev) {
      config.click(_this.graphInfo, ev);

      // only needed for 'hoverClosestGeo' which does not call relayout
      _this.updateActiveButton(ev.currentTarget);
    });
  }
  button.setAttribute('data-toggle', config.toggle || false);
  if (config.toggle) d3.select(button).classed('active', true);
  var icon = config.icon;
  if (typeof icon === 'function') {
    button.appendChild(icon());
  } else {
    button.appendChild(this.createIcon(icon || Icons.question));
  }
  button.setAttribute('data-gravity', config.gravity || 'n');
  return button;
};

/**
 * Add an icon to a button
 * @Param {object} thisIcon
 * @Param {number} thisIcon.width
 * @Param {string} thisIcon.path
 * @Param {string} thisIcon.color
 * @Return {HTMLelement}
 */
proto.createIcon = function (thisIcon) {
  var iconHeight = isNumeric(thisIcon.height) ? Number(thisIcon.height) : thisIcon.ascent - thisIcon.descent;
  var svgNS = 'http://www.w3.org/2000/svg';
  var icon;
  if (thisIcon.path) {
    icon = document.createElementNS(svgNS, 'svg');
    icon.setAttribute('viewBox', [0, 0, thisIcon.width, iconHeight].join(' '));
    icon.setAttribute('class', 'icon');
    var path = document.createElementNS(svgNS, 'path');
    path.setAttribute('d', thisIcon.path);
    if (thisIcon.transform) {
      path.setAttribute('transform', thisIcon.transform);
    } else if (thisIcon.ascent !== undefined) {
      // Legacy icon transform calculation
      path.setAttribute('transform', 'matrix(1 0 0 -1 0 ' + thisIcon.ascent + ')');
    }
    icon.appendChild(path);
  }
  if (thisIcon.svg) {
    var svgDoc = Parser.parseFromString(thisIcon.svg, 'application/xml');
    icon = svgDoc.childNodes[0];
  }
  icon.setAttribute('height', '1em');
  icon.setAttribute('width', '1em');
  return icon;
};

/**
 * Updates active button with attribute specified in layout
 * @Param {object} graphInfo plot object containing data and layout
 * @Return {HTMLelement}
 */
proto.updateActiveButton = function (buttonClicked) {
  var fullLayout = this.graphInfo._fullLayout;
  var dataAttrClicked = buttonClicked !== undefined ? buttonClicked.getAttribute('data-attr') : null;
  this.buttonElements.forEach(function (button) {
    var thisval = button.getAttribute('data-val') || true;
    var dataAttr = button.getAttribute('data-attr');
    var isToggleButton = button.getAttribute('data-toggle') === 'true';
    var button3 = d3.select(button);

    // Use 'data-toggle' and 'buttonClicked' to toggle buttons
    // that have no one-to-one equivalent in fullLayout
    if (isToggleButton) {
      if (dataAttr === dataAttrClicked) {
        button3.classed('active', !button3.classed('active'));
      }
    } else {
      var val = dataAttr === null ? dataAttr : Lib.nestedProperty(fullLayout, dataAttr).get();
      button3.classed('active', val === thisval);
    }
  });
};

/**
 * Check if modeBar is configured as button configuration argument
 *
 * @Param {object} buttons 2d array of grouped button config objects
 * @Return {boolean}
 */
proto.hasButtons = function (buttons) {
  var currentButtons = this.buttons;
  if (!currentButtons) return false;
  if (buttons.length !== currentButtons.length) return false;
  for (var i = 0; i < buttons.length; ++i) {
    if (buttons[i].length !== currentButtons[i].length) return false;
    for (var j = 0; j < buttons[i].length; j++) {
      if (buttons[i][j].name !== currentButtons[i][j].name) return false;
    }
  }
  return true;
};
function jsVersion(str) {
  return str + ' (v' + version + ')';
}

/**
 * @return {HTMLDivElement} The logo image wrapped in a group
 */
proto.getLogo = function () {
  var group = this.createGroup();
  var a = document.createElement('a');
  a.href = 'https://plotly.com/';
  a.target = '_blank';
  a.setAttribute('data-title', jsVersion(Lib._(this.graphInfo, 'Produced with Plotly.js')));
  a.className = 'modebar-btn plotlyjsicon modebar-btn--logo';
  a.appendChild(this.createIcon(Icons.newplotlylogo));
  group.appendChild(a);
  return group;
};
proto.removeAllButtons = function () {
  while (this.element.firstChild) {
    this.element.removeChild(this.element.firstChild);
  }
  this.hasLogo = false;
};
proto.destroy = function () {
  Lib.removeElement(this.container.querySelector('.modebar'));
  Lib.deleteRelatedStyleRule(this._uid);
};
function createModeBar(gd, buttons) {
  var fullLayout = gd._fullLayout;
  var modeBar = new ModeBar({
    graphInfo: gd,
    container: fullLayout._modebardiv.node(),
    buttons: buttons
  });
  if (fullLayout._privateplot) {
    d3.select(modeBar.element).append('span').classed('badge-private float--left', true).text('PRIVATE');
  }
  return modeBar;
}
module.exports = createModeBar;

/***/ }),

/***/ 6680:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var fontAttrs = __webpack_require__(5376);
var colorAttrs = __webpack_require__(2548);
var templatedArray = (__webpack_require__(1780).templatedArray);
var buttonAttrs = templatedArray('button', {
  visible: {
    valType: 'boolean',
    dflt: true,
    editType: 'plot'
  },
  step: {
    valType: 'enumerated',
    values: ['month', 'year', 'day', 'hour', 'minute', 'second', 'all'],
    dflt: 'month',
    editType: 'plot'
  },
  stepmode: {
    valType: 'enumerated',
    values: ['backward', 'todate'],
    dflt: 'backward',
    editType: 'plot'
  },
  count: {
    valType: 'number',
    min: 0,
    dflt: 1,
    editType: 'plot'
  },
  label: {
    valType: 'string',
    editType: 'plot'
  },
  editType: 'plot'
});
module.exports = {
  visible: {
    valType: 'boolean',
    editType: 'plot'
  },
  buttons: buttonAttrs,
  x: {
    valType: 'number',
    min: -2,
    max: 3,
    editType: 'plot'
  },
  xanchor: {
    valType: 'enumerated',
    values: ['auto', 'left', 'center', 'right'],
    dflt: 'left',
    editType: 'plot'
  },
  y: {
    valType: 'number',
    min: -2,
    max: 3,
    editType: 'plot'
  },
  yanchor: {
    valType: 'enumerated',
    values: ['auto', 'top', 'middle', 'bottom'],
    dflt: 'bottom',
    editType: 'plot'
  },
  font: fontAttrs({
    editType: 'plot'
  }),
  bgcolor: {
    valType: 'color',
    dflt: colorAttrs.lightLine,
    editType: 'plot'
  },
  activecolor: {
    valType: 'color',
    editType: 'plot'
  },
  bordercolor: {
    valType: 'color',
    dflt: colorAttrs.defaultLine,
    editType: 'plot'
  },
  borderwidth: {
    valType: 'number',
    min: 0,
    dflt: 0,
    editType: 'plot'
  },
  editType: 'plot'
};

/***/ }),

/***/ 5984:
/***/ (function(module) {

"use strict";


module.exports = {
  // 'y' position pad above counter axis domain
  yPad: 0.02,
  // minimum button width (regardless of text size)
  minButtonWidth: 30,
  // buttons rect radii
  rx: 3,
  ry: 3,
  // light fraction used to compute the 'activecolor' default
  lightAmount: 25,
  darkAmount: 10
};

/***/ }),

/***/ 2148:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Color = __webpack_require__(6308);
var Template = __webpack_require__(1780);
var handleArrayContainerDefaults = __webpack_require__(1272);
var attributes = __webpack_require__(6680);
var constants = __webpack_require__(5984);
module.exports = function handleDefaults(containerIn, containerOut, layout, counterAxes, calendar) {
  var selectorIn = containerIn.rangeselector || {};
  var selectorOut = Template.newContainer(containerOut, 'rangeselector');
  function coerce(attr, dflt) {
    return Lib.coerce(selectorIn, selectorOut, attributes, attr, dflt);
  }
  var buttons = handleArrayContainerDefaults(selectorIn, selectorOut, {
    name: 'buttons',
    handleItemDefaults: buttonDefaults,
    calendar: calendar
  });
  var visible = coerce('visible', buttons.length > 0);
  if (visible) {
    var posDflt = getPosDflt(containerOut, layout, counterAxes);
    coerce('x', posDflt[0]);
    coerce('y', posDflt[1]);
    Lib.noneOrAll(containerIn, containerOut, ['x', 'y']);
    coerce('xanchor');
    coerce('yanchor');
    Lib.coerceFont(coerce, 'font', layout.font);
    var bgColor = coerce('bgcolor');
    coerce('activecolor', Color.contrast(bgColor, constants.lightAmount, constants.darkAmount));
    coerce('bordercolor');
    coerce('borderwidth');
  }
};
function buttonDefaults(buttonIn, buttonOut, selectorOut, opts) {
  var calendar = opts.calendar;
  function coerce(attr, dflt) {
    return Lib.coerce(buttonIn, buttonOut, attributes.buttons, attr, dflt);
  }
  var visible = coerce('visible');
  if (visible) {
    var step = coerce('step');
    if (step !== 'all') {
      if (calendar && calendar !== 'gregorian' && (step === 'month' || step === 'year')) {
        buttonOut.stepmode = 'backward';
      } else {
        coerce('stepmode');
      }
      coerce('count');
    }
    coerce('label');
  }
}
function getPosDflt(containerOut, layout, counterAxes) {
  var anchoredList = counterAxes.filter(function (ax) {
    return layout[ax].anchor === containerOut._id;
  });
  var posY = 0;
  for (var i = 0; i < anchoredList.length; i++) {
    var domain = layout[anchoredList[i]].domain;
    if (domain) posY = Math.max(domain[1], posY);
  }
  return [containerOut.domain[0], posY + constants.yPad];
}

/***/ }),

/***/ 216:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var Registry = __webpack_require__(4040);
var Plots = __webpack_require__(7316);
var Color = __webpack_require__(6308);
var Drawing = __webpack_require__(3616);
var Lib = __webpack_require__(3400);
var strTranslate = Lib.strTranslate;
var svgTextUtils = __webpack_require__(2736);
var axisIds = __webpack_require__(9811);
var alignmentConstants = __webpack_require__(4284);
var LINE_SPACING = alignmentConstants.LINE_SPACING;
var FROM_TL = alignmentConstants.FROM_TL;
var FROM_BR = alignmentConstants.FROM_BR;
var constants = __webpack_require__(5984);
var getUpdateObject = __webpack_require__(8040);
module.exports = function draw(gd) {
  var fullLayout = gd._fullLayout;
  var selectors = fullLayout._infolayer.selectAll('.rangeselector').data(makeSelectorData(gd), selectorKeyFunc);
  selectors.enter().append('g').classed('rangeselector', true);
  selectors.exit().remove();
  selectors.style({
    cursor: 'pointer',
    'pointer-events': 'all'
  });
  selectors.each(function (d) {
    var selector = d3.select(this);
    var axisLayout = d;
    var selectorLayout = axisLayout.rangeselector;
    var buttons = selector.selectAll('g.button').data(Lib.filterVisible(selectorLayout.buttons));
    buttons.enter().append('g').classed('button', true);
    buttons.exit().remove();
    buttons.each(function (d) {
      var button = d3.select(this);
      var update = getUpdateObject(axisLayout, d);
      d._isActive = isActive(axisLayout, d, update);
      button.call(drawButtonRect, selectorLayout, d);
      button.call(drawButtonText, selectorLayout, d, gd);
      button.on('click', function () {
        if (gd._dragged) return;
        Registry.call('_guiRelayout', gd, update);
      });
      button.on('mouseover', function () {
        d._isHovered = true;
        button.call(drawButtonRect, selectorLayout, d);
      });
      button.on('mouseout', function () {
        d._isHovered = false;
        button.call(drawButtonRect, selectorLayout, d);
      });
    });
    reposition(gd, buttons, selectorLayout, axisLayout._name, selector);
  });
};
function makeSelectorData(gd) {
  var axes = axisIds.list(gd, 'x', true);
  var data = [];
  for (var i = 0; i < axes.length; i++) {
    var axis = axes[i];
    if (axis.rangeselector && axis.rangeselector.visible) {
      data.push(axis);
    }
  }
  return data;
}
function selectorKeyFunc(d) {
  return d._id;
}
function isActive(axisLayout, opts, update) {
  if (opts.step === 'all') {
    return axisLayout.autorange === true;
  } else {
    var keys = Object.keys(update);
    return axisLayout.range[0] === update[keys[0]] && axisLayout.range[1] === update[keys[1]];
  }
}
function drawButtonRect(button, selectorLayout, d) {
  var rect = Lib.ensureSingle(button, 'rect', 'selector-rect', function (s) {
    s.attr('shape-rendering', 'crispEdges');
  });
  rect.attr({
    rx: constants.rx,
    ry: constants.ry
  });
  rect.call(Color.stroke, selectorLayout.bordercolor).call(Color.fill, getFillColor(selectorLayout, d)).style('stroke-width', selectorLayout.borderwidth + 'px');
}
function getFillColor(selectorLayout, d) {
  return d._isActive || d._isHovered ? selectorLayout.activecolor : selectorLayout.bgcolor;
}
function drawButtonText(button, selectorLayout, d, gd) {
  function textLayout(s) {
    svgTextUtils.convertToTspans(s, gd);
  }
  var text = Lib.ensureSingle(button, 'text', 'selector-text', function (s) {
    s.attr('text-anchor', 'middle');
  });
  text.call(Drawing.font, selectorLayout.font).text(getLabel(d, gd._fullLayout._meta)).call(textLayout);
}
function getLabel(opts, _meta) {
  if (opts.label) {
    return _meta ? Lib.templateString(opts.label, _meta) : opts.label;
  }
  if (opts.step === 'all') return 'all';
  return opts.count + opts.step.charAt(0);
}
function reposition(gd, buttons, opts, axName, selector) {
  var width = 0;
  var height = 0;
  var borderWidth = opts.borderwidth;
  buttons.each(function () {
    var button = d3.select(this);
    var text = button.select('.selector-text');
    var tHeight = opts.font.size * LINE_SPACING;
    var hEff = Math.max(tHeight * svgTextUtils.lineCount(text), 16) + 3;
    height = Math.max(height, hEff);
  });
  buttons.each(function () {
    var button = d3.select(this);
    var rect = button.select('.selector-rect');
    var text = button.select('.selector-text');
    var tWidth = text.node() && Drawing.bBox(text.node()).width;
    var tHeight = opts.font.size * LINE_SPACING;
    var tLines = svgTextUtils.lineCount(text);
    var wEff = Math.max(tWidth + 10, constants.minButtonWidth);

    // TODO add MathJax support

    // TODO add buttongap attribute

    button.attr('transform', strTranslate(borderWidth + width, borderWidth));
    rect.attr({
      x: 0,
      y: 0,
      width: wEff,
      height: height
    });
    svgTextUtils.positionText(text, wEff / 2, height / 2 - (tLines - 1) * tHeight / 2 + 3);
    width += wEff + 5;
  });
  var graphSize = gd._fullLayout._size;
  var lx = graphSize.l + graphSize.w * opts.x;
  var ly = graphSize.t + graphSize.h * (1 - opts.y);
  var xanchor = 'left';
  if (Lib.isRightAnchor(opts)) {
    lx -= width;
    xanchor = 'right';
  }
  if (Lib.isCenterAnchor(opts)) {
    lx -= width / 2;
    xanchor = 'center';
  }
  var yanchor = 'top';
  if (Lib.isBottomAnchor(opts)) {
    ly -= height;
    yanchor = 'bottom';
  }
  if (Lib.isMiddleAnchor(opts)) {
    ly -= height / 2;
    yanchor = 'middle';
  }
  width = Math.ceil(width);
  height = Math.ceil(height);
  lx = Math.round(lx);
  ly = Math.round(ly);
  Plots.autoMargin(gd, axName + '-range-selector', {
    x: opts.x,
    y: opts.y,
    l: width * FROM_TL[xanchor],
    r: width * FROM_BR[xanchor],
    b: height * FROM_BR[yanchor],
    t: height * FROM_TL[yanchor]
  });
  selector.attr('transform', strTranslate(lx, ly));
}

/***/ }),

/***/ 8040:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3Time = __webpack_require__(3220);
var titleCase = (__webpack_require__(3400).titleCase);
module.exports = function getUpdateObject(axisLayout, buttonLayout) {
  var axName = axisLayout._name;
  var update = {};
  if (buttonLayout.step === 'all') {
    update[axName + '.autorange'] = true;
  } else {
    var xrange = getXRange(axisLayout, buttonLayout);
    update[axName + '.range[0]'] = xrange[0];
    update[axName + '.range[1]'] = xrange[1];
  }
  return update;
};
function getXRange(axisLayout, buttonLayout) {
  var currentRange = axisLayout.range;
  var base = new Date(axisLayout.r2l(currentRange[1]));
  var step = buttonLayout.step;
  var utcStep = d3Time['utc' + titleCase(step)];
  var count = buttonLayout.count;
  var range0;
  switch (buttonLayout.stepmode) {
    case 'backward':
      range0 = axisLayout.l2r(+utcStep.offset(base, -count));
      break;
    case 'todate':
      var base2 = utcStep.offset(base, -count);
      range0 = axisLayout.l2r(+utcStep.ceil(base2));
      break;
  }
  var range1 = currentRange[1];
  return [range0, range1];
}

/***/ }),

/***/ 1152:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = {
  moduleType: 'component',
  name: 'rangeselector',
  schema: {
    subplots: {
      xaxis: {
        rangeselector: __webpack_require__(6680)
      }
    }
  },
  layoutAttributes: __webpack_require__(6680),
  handleDefaults: __webpack_require__(2148),
  draw: __webpack_require__(216)
};

/***/ }),

/***/ 8820:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var colorAttributes = __webpack_require__(2548);
module.exports = {
  bgcolor: {
    valType: 'color',
    dflt: colorAttributes.background,
    editType: 'plot'
  },
  bordercolor: {
    valType: 'color',
    dflt: colorAttributes.defaultLine,
    editType: 'plot'
  },
  borderwidth: {
    valType: 'integer',
    dflt: 0,
    min: 0,
    editType: 'plot'
  },
  autorange: {
    valType: 'boolean',
    dflt: true,
    editType: 'calc',
    impliedEdits: {
      'range[0]': undefined,
      'range[1]': undefined
    }
  },
  range: {
    valType: 'info_array',
    items: [{
      valType: 'any',
      editType: 'calc',
      impliedEdits: {
        '^autorange': false
      }
    }, {
      valType: 'any',
      editType: 'calc',
      impliedEdits: {
        '^autorange': false
      }
    }],
    editType: 'calc',
    impliedEdits: {
      autorange: false
    }
  },
  thickness: {
    valType: 'number',
    dflt: 0.15,
    min: 0,
    max: 1,
    editType: 'plot'
  },
  visible: {
    valType: 'boolean',
    dflt: true,
    editType: 'calc'
  },
  editType: 'calc'
};

/***/ }),

/***/ 6652:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var listAxes = (__webpack_require__(9811).list);
var getAutoRange = (__webpack_require__(9280).getAutoRange);
var constants = __webpack_require__(4636);
module.exports = function calcAutorange(gd) {
  var axes = listAxes(gd, 'x', true);

  // Compute new slider range using axis autorange if necessary.
  //
  // Copy back range to input range slider container to skip
  // this step in subsequent draw calls.

  for (var i = 0; i < axes.length; i++) {
    var ax = axes[i];
    var opts = ax[constants.name];
    if (opts && opts.visible && opts.autorange) {
      opts._input.autorange = true;
      opts._input.range = opts.range = getAutoRange(gd, ax);
    }
  }
};

/***/ }),

/***/ 4636:
/***/ (function(module) {

"use strict";


module.exports = {
  // attribute container name
  name: 'rangeslider',
  // class names

  containerClassName: 'rangeslider-container',
  bgClassName: 'rangeslider-bg',
  rangePlotClassName: 'rangeslider-rangeplot',
  maskMinClassName: 'rangeslider-mask-min',
  maskMaxClassName: 'rangeslider-mask-max',
  slideBoxClassName: 'rangeslider-slidebox',
  grabberMinClassName: 'rangeslider-grabber-min',
  grabAreaMinClassName: 'rangeslider-grabarea-min',
  handleMinClassName: 'rangeslider-handle-min',
  grabberMaxClassName: 'rangeslider-grabber-max',
  grabAreaMaxClassName: 'rangeslider-grabarea-max',
  handleMaxClassName: 'rangeslider-handle-max',
  maskMinOppAxisClassName: 'rangeslider-mask-min-opp-axis',
  maskMaxOppAxisClassName: 'rangeslider-mask-max-opp-axis',
  // style constants

  maskColor: 'rgba(0,0,0,0.4)',
  maskOppAxisColor: 'rgba(0,0,0,0.2)',
  slideBoxFill: 'transparent',
  slideBoxCursor: 'ew-resize',
  grabAreaFill: 'transparent',
  grabAreaCursor: 'col-resize',
  grabAreaWidth: 10,
  handleWidth: 4,
  handleRadius: 1,
  handleStrokeWidth: 1,
  extraPad: 15
};

/***/ }),

/***/ 1659:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Template = __webpack_require__(1780);
var axisIds = __webpack_require__(9811);
var attributes = __webpack_require__(8820);
var oppAxisAttrs = __webpack_require__(936);
module.exports = function handleDefaults(layoutIn, layoutOut, axName) {
  var axIn = layoutIn[axName];
  var axOut = layoutOut[axName];
  if (!(axIn.rangeslider || layoutOut._requestRangeslider[axOut._id])) return;

  // not super proud of this (maybe store _ in axis object instead
  if (!Lib.isPlainObject(axIn.rangeslider)) {
    axIn.rangeslider = {};
  }
  var containerIn = axIn.rangeslider;
  var containerOut = Template.newContainer(axOut, 'rangeslider');
  function coerce(attr, dflt) {
    return Lib.coerce(containerIn, containerOut, attributes, attr, dflt);
  }
  var rangeContainerIn, rangeContainerOut;
  function coerceRange(attr, dflt) {
    return Lib.coerce(rangeContainerIn, rangeContainerOut, oppAxisAttrs, attr, dflt);
  }
  var visible = coerce('visible');
  if (!visible) return;
  coerce('bgcolor', layoutOut.plot_bgcolor);
  coerce('bordercolor');
  coerce('borderwidth');
  coerce('thickness');
  coerce('autorange', !axOut.isValidRange(containerIn.range));
  coerce('range');
  var subplots = layoutOut._subplots;
  if (subplots) {
    var yIds = subplots.cartesian.filter(function (subplotId) {
      return subplotId.substr(0, subplotId.indexOf('y')) === axisIds.name2id(axName);
    }).map(function (subplotId) {
      return subplotId.substr(subplotId.indexOf('y'), subplotId.length);
    });
    var yNames = Lib.simpleMap(yIds, axisIds.id2name);
    for (var i = 0; i < yNames.length; i++) {
      var yName = yNames[i];
      rangeContainerIn = containerIn[yName] || {};
      rangeContainerOut = Template.newContainer(containerOut, yName, 'yaxis');
      var yAxOut = layoutOut[yName];
      var rangemodeDflt;
      if (rangeContainerIn.range && yAxOut.isValidRange(rangeContainerIn.range)) {
        rangemodeDflt = 'fixed';
      }
      var rangeMode = coerceRange('rangemode', rangemodeDflt);
      if (rangeMode !== 'match') {
        coerceRange('range', yAxOut.range.slice());
      }
    }
  }

  // to map back range slider (auto) range
  containerOut._input = containerIn;
};

/***/ }),

/***/ 60:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var Registry = __webpack_require__(4040);
var Plots = __webpack_require__(7316);
var Lib = __webpack_require__(3400);
var strTranslate = Lib.strTranslate;
var Drawing = __webpack_require__(3616);
var Color = __webpack_require__(6308);
var Titles = __webpack_require__(1668);
var Cartesian = __webpack_require__(7952);
var axisIDs = __webpack_require__(9811);
var dragElement = __webpack_require__(6476);
var setCursor = __webpack_require__(3972);
var constants = __webpack_require__(4636);
module.exports = function (gd) {
  var fullLayout = gd._fullLayout;
  var rangeSliderData = fullLayout._rangeSliderData;
  for (var i = 0; i < rangeSliderData.length; i++) {
    var opts = rangeSliderData[i][constants.name];
    // fullLayout._uid may not exist when we call makeData
    opts._clipId = opts._id + '-' + fullLayout._uid;
  }

  /*
   * <g container />
   *  <rect bg />
   *  < .... range plot />
   *  <rect mask-min />
   *  <rect mask-max />
   *  <rect slidebox />
   *  <g grabber-min />
   *      <rect handle-min />
   *      <rect grabare-min />
   *  <g grabber-max />
   *      <rect handle-max />
   *      <rect grabare-max />
   *
   *  ...
   */

  function keyFunction(axisOpts) {
    return axisOpts._name;
  }
  var rangeSliders = fullLayout._infolayer.selectAll('g.' + constants.containerClassName).data(rangeSliderData, keyFunction);

  // remove exiting sliders and their corresponding clip paths
  rangeSliders.exit().each(function (axisOpts) {
    var opts = axisOpts[constants.name];
    fullLayout._topdefs.select('#' + opts._clipId).remove();
  }).remove();

  // return early if no range slider is visible
  if (rangeSliderData.length === 0) return;
  rangeSliders.enter().append('g').classed(constants.containerClassName, true).attr('pointer-events', 'all');

  // for all present range sliders
  rangeSliders.each(function (axisOpts) {
    var rangeSlider = d3.select(this);
    var opts = axisOpts[constants.name];
    var oppAxisOpts = fullLayout[axisIDs.id2name(axisOpts.anchor)];
    var oppAxisRangeOpts = opts[axisIDs.id2name(axisOpts.anchor)];

    // update range
    // Expand slider range to the axis range
    if (opts.range) {
      var rng = Lib.simpleMap(opts.range, axisOpts.r2l);
      var axRng = Lib.simpleMap(axisOpts.range, axisOpts.r2l);
      var newRng;
      if (axRng[0] < axRng[1]) {
        newRng = [Math.min(rng[0], axRng[0]), Math.max(rng[1], axRng[1])];
      } else {
        newRng = [Math.max(rng[0], axRng[0]), Math.min(rng[1], axRng[1])];
      }
      opts.range = opts._input.range = Lib.simpleMap(newRng, axisOpts.l2r);
    }
    axisOpts.cleanRange('rangeslider.range');

    // update range slider dimensions

    var gs = fullLayout._size;
    var domain = axisOpts.domain;
    opts._width = gs.w * (domain[1] - domain[0]);
    var x = Math.round(gs.l + gs.w * domain[0]);
    var y = Math.round(gs.t + gs.h * (1 - axisOpts._counterDomainMin) + (axisOpts.side === 'bottom' ? axisOpts._depth : 0) + opts._offsetShift + constants.extraPad);
    rangeSlider.attr('transform', strTranslate(x, y));

    // update data <--> pixel coordinate conversion methods

    opts._rl = Lib.simpleMap(opts.range, axisOpts.r2l);
    var rl0 = opts._rl[0];
    var rl1 = opts._rl[1];
    var drl = rl1 - rl0;
    opts.p2d = function (v) {
      return v / opts._width * drl + rl0;
    };
    opts.d2p = function (v) {
      return (v - rl0) / drl * opts._width;
    };
    if (axisOpts.rangebreaks) {
      var rsBreaks = axisOpts.locateBreaks(rl0, rl1);
      if (rsBreaks.length) {
        var j, brk;
        var lBreaks = 0;
        for (j = 0; j < rsBreaks.length; j++) {
          brk = rsBreaks[j];
          lBreaks += brk.max - brk.min;
        }

        // TODO fix for reversed-range axes !!!

        // compute slope and piecewise offsets
        var m2 = opts._width / (rl1 - rl0 - lBreaks);
        var _B = [-m2 * rl0];
        for (j = 0; j < rsBreaks.length; j++) {
          brk = rsBreaks[j];
          _B.push(_B[_B.length - 1] - m2 * (brk.max - brk.min));
        }
        opts.d2p = function (v) {
          var b = _B[0];
          for (var j = 0; j < rsBreaks.length; j++) {
            var brk = rsBreaks[j];
            if (v >= brk.max) b = _B[j + 1];else if (v < brk.min) break;
          }
          return b + m2 * v;
        };

        // fill pixel (i.e. 'p') min/max here,
        // to not have to loop through the _rangebreaks twice during `p2d`
        for (j = 0; j < rsBreaks.length; j++) {
          brk = rsBreaks[j];
          brk.pmin = opts.d2p(brk.min);
          brk.pmax = opts.d2p(brk.max);
        }
        opts.p2d = function (v) {
          var b = _B[0];
          for (var j = 0; j < rsBreaks.length; j++) {
            var brk = rsBreaks[j];
            if (v >= brk.pmax) b = _B[j + 1];else if (v < brk.pmin) break;
          }
          return (v - b) / m2;
        };
      }
    }
    if (oppAxisRangeOpts.rangemode !== 'match') {
      var range0OppAxis = oppAxisOpts.r2l(oppAxisRangeOpts.range[0]);
      var range1OppAxis = oppAxisOpts.r2l(oppAxisRangeOpts.range[1]);
      var distOppAxis = range1OppAxis - range0OppAxis;
      opts.d2pOppAxis = function (v) {
        return (v - range0OppAxis) / distOppAxis * opts._height;
      };
    }

    // update inner nodes

    rangeSlider.call(drawBg, gd, axisOpts, opts).call(addClipPath, gd, axisOpts, opts).call(drawRangePlot, gd, axisOpts, opts).call(drawMasks, gd, axisOpts, opts, oppAxisRangeOpts).call(drawSlideBox, gd, axisOpts, opts).call(drawGrabbers, gd, axisOpts, opts);

    // setup drag element
    setupDragElement(rangeSlider, gd, axisOpts, opts);

    // update current range
    setPixelRange(rangeSlider, gd, axisOpts, opts, oppAxisOpts, oppAxisRangeOpts);

    // title goes next to range slider instead of tick labels, so
    // just take it over and draw it from here
    if (axisOpts.side === 'bottom') {
      Titles.draw(gd, axisOpts._id + 'title', {
        propContainer: axisOpts,
        propName: axisOpts._name + '.title',
        placeholder: fullLayout._dfltTitle.x,
        attributes: {
          x: axisOpts._offset + axisOpts._length / 2,
          y: y + opts._height + opts._offsetShift + 10 + 1.5 * axisOpts.title.font.size,
          'text-anchor': 'middle'
        }
      });
    }
  });
};
function eventX(event) {
  if (typeof event.clientX === 'number') {
    return event.clientX;
  }
  if (event.touches && event.touches.length > 0) {
    return event.touches[0].clientX;
  }
  return 0;
}
function setupDragElement(rangeSlider, gd, axisOpts, opts) {
  if (gd._context.staticPlot) return;
  var slideBox = rangeSlider.select('rect.' + constants.slideBoxClassName).node();
  var grabAreaMin = rangeSlider.select('rect.' + constants.grabAreaMinClassName).node();
  var grabAreaMax = rangeSlider.select('rect.' + constants.grabAreaMaxClassName).node();
  function mouseDownHandler() {
    var event = d3.event;
    var target = event.target;
    var startX = eventX(event);
    var offsetX = startX - rangeSlider.node().getBoundingClientRect().left;
    var minVal = opts.d2p(axisOpts._rl[0]);
    var maxVal = opts.d2p(axisOpts._rl[1]);
    var dragCover = dragElement.coverSlip();
    this.addEventListener('touchmove', mouseMove);
    this.addEventListener('touchend', mouseUp);
    dragCover.addEventListener('mousemove', mouseMove);
    dragCover.addEventListener('mouseup', mouseUp);
    function mouseMove(e) {
      var clientX = eventX(e);
      var delta = +clientX - startX;
      var pixelMin, pixelMax, cursor;
      switch (target) {
        case slideBox:
          cursor = 'ew-resize';
          if (minVal + delta > axisOpts._length || maxVal + delta < 0) {
            return;
          }
          pixelMin = minVal + delta;
          pixelMax = maxVal + delta;
          break;
        case grabAreaMin:
          cursor = 'col-resize';
          if (minVal + delta > axisOpts._length) {
            return;
          }
          pixelMin = minVal + delta;
          pixelMax = maxVal;
          break;
        case grabAreaMax:
          cursor = 'col-resize';
          if (maxVal + delta < 0) {
            return;
          }
          pixelMin = minVal;
          pixelMax = maxVal + delta;
          break;
        default:
          cursor = 'ew-resize';
          pixelMin = offsetX;
          pixelMax = offsetX + delta;
          break;
      }
      if (pixelMax < pixelMin) {
        var tmp = pixelMax;
        pixelMax = pixelMin;
        pixelMin = tmp;
      }
      opts._pixelMin = pixelMin;
      opts._pixelMax = pixelMax;
      setCursor(d3.select(dragCover), cursor);
      setDataRange(rangeSlider, gd, axisOpts, opts);
    }
    function mouseUp() {
      dragCover.removeEventListener('mousemove', mouseMove);
      dragCover.removeEventListener('mouseup', mouseUp);
      this.removeEventListener('touchmove', mouseMove);
      this.removeEventListener('touchend', mouseUp);
      Lib.removeElement(dragCover);
    }
  }
  rangeSlider.on('mousedown', mouseDownHandler);
  rangeSlider.on('touchstart', mouseDownHandler);
}
function setDataRange(rangeSlider, gd, axisOpts, opts) {
  function clamp(v) {
    return axisOpts.l2r(Lib.constrain(v, opts._rl[0], opts._rl[1]));
  }
  var dataMin = clamp(opts.p2d(opts._pixelMin));
  var dataMax = clamp(opts.p2d(opts._pixelMax));
  window.requestAnimationFrame(function () {
    Registry.call('_guiRelayout', gd, axisOpts._name + '.range', [dataMin, dataMax]);
  });
}
function setPixelRange(rangeSlider, gd, axisOpts, opts, oppAxisOpts, oppAxisRangeOpts) {
  var hw2 = constants.handleWidth / 2;
  function clamp(v) {
    return Lib.constrain(v, 0, opts._width);
  }
  function clampOppAxis(v) {
    return Lib.constrain(v, 0, opts._height);
  }
  function clampHandle(v) {
    return Lib.constrain(v, -hw2, opts._width + hw2);
  }
  var pixelMin = clamp(opts.d2p(axisOpts._rl[0]));
  var pixelMax = clamp(opts.d2p(axisOpts._rl[1]));
  rangeSlider.select('rect.' + constants.slideBoxClassName).attr('x', pixelMin).attr('width', pixelMax - pixelMin);
  rangeSlider.select('rect.' + constants.maskMinClassName).attr('width', pixelMin);
  rangeSlider.select('rect.' + constants.maskMaxClassName).attr('x', pixelMax).attr('width', opts._width - pixelMax);
  if (oppAxisRangeOpts.rangemode !== 'match') {
    var pixelMinOppAxis = opts._height - clampOppAxis(opts.d2pOppAxis(oppAxisOpts._rl[1]));
    var pixelMaxOppAxis = opts._height - clampOppAxis(opts.d2pOppAxis(oppAxisOpts._rl[0]));
    rangeSlider.select('rect.' + constants.maskMinOppAxisClassName).attr('x', pixelMin).attr('height', pixelMinOppAxis).attr('width', pixelMax - pixelMin);
    rangeSlider.select('rect.' + constants.maskMaxOppAxisClassName).attr('x', pixelMin).attr('y', pixelMaxOppAxis).attr('height', opts._height - pixelMaxOppAxis).attr('width', pixelMax - pixelMin);
    rangeSlider.select('rect.' + constants.slideBoxClassName).attr('y', pixelMinOppAxis).attr('height', pixelMaxOppAxis - pixelMinOppAxis);
  }

  // add offset for crispier corners
  // https://github.com/plotly/plotly.js/pull/1409
  var offset = 0.5;
  var xMin = Math.round(clampHandle(pixelMin - hw2)) - offset;
  var xMax = Math.round(clampHandle(pixelMax - hw2)) + offset;
  rangeSlider.select('g.' + constants.grabberMinClassName).attr('transform', strTranslate(xMin, offset));
  rangeSlider.select('g.' + constants.grabberMaxClassName).attr('transform', strTranslate(xMax, offset));
}
function drawBg(rangeSlider, gd, axisOpts, opts) {
  var bg = Lib.ensureSingle(rangeSlider, 'rect', constants.bgClassName, function (s) {
    s.attr({
      x: 0,
      y: 0,
      'shape-rendering': 'crispEdges'
    });
  });
  var borderCorrect = opts.borderwidth % 2 === 0 ? opts.borderwidth : opts.borderwidth - 1;
  var offsetShift = -opts._offsetShift;
  var lw = Drawing.crispRound(gd, opts.borderwidth);
  bg.attr({
    width: opts._width + borderCorrect,
    height: opts._height + borderCorrect,
    transform: strTranslate(offsetShift, offsetShift),
    'stroke-width': lw
  }).call(Color.stroke, opts.bordercolor).call(Color.fill, opts.bgcolor);
}
function addClipPath(rangeSlider, gd, axisOpts, opts) {
  var fullLayout = gd._fullLayout;
  var clipPath = Lib.ensureSingleById(fullLayout._topdefs, 'clipPath', opts._clipId, function (s) {
    s.append('rect').attr({
      x: 0,
      y: 0
    });
  });
  clipPath.select('rect').attr({
    width: opts._width,
    height: opts._height
  });
}
function drawRangePlot(rangeSlider, gd, axisOpts, opts) {
  var calcData = gd.calcdata;
  var rangePlots = rangeSlider.selectAll('g.' + constants.rangePlotClassName).data(axisOpts._subplotsWith, Lib.identity);
  rangePlots.enter().append('g').attr('class', function (id) {
    return constants.rangePlotClassName + ' ' + id;
  }).call(Drawing.setClipUrl, opts._clipId, gd);
  rangePlots.order();
  rangePlots.exit().remove();
  var mainplotinfo;
  rangePlots.each(function (id, i) {
    var plotgroup = d3.select(this);
    var isMainPlot = i === 0;
    var oppAxisOpts = axisIDs.getFromId(gd, id, 'y');
    var oppAxisName = oppAxisOpts._name;
    var oppAxisRangeOpts = opts[oppAxisName];
    var mockFigure = {
      data: [],
      layout: {
        xaxis: {
          type: axisOpts.type,
          domain: [0, 1],
          range: opts.range.slice(),
          calendar: axisOpts.calendar
        },
        width: opts._width,
        height: opts._height,
        margin: {
          t: 0,
          b: 0,
          l: 0,
          r: 0
        }
      },
      _context: gd._context
    };
    if (axisOpts.rangebreaks) {
      mockFigure.layout.xaxis.rangebreaks = axisOpts.rangebreaks;
    }
    mockFigure.layout[oppAxisName] = {
      type: oppAxisOpts.type,
      domain: [0, 1],
      range: oppAxisRangeOpts.rangemode !== 'match' ? oppAxisRangeOpts.range.slice() : oppAxisOpts.range.slice(),
      calendar: oppAxisOpts.calendar
    };
    if (oppAxisOpts.rangebreaks) {
      mockFigure.layout[oppAxisName].rangebreaks = oppAxisOpts.rangebreaks;
    }
    Plots.supplyDefaults(mockFigure);
    var xa = mockFigure._fullLayout.xaxis;
    var ya = mockFigure._fullLayout[oppAxisName];
    xa.clearCalc();
    xa.setScale();
    ya.clearCalc();
    ya.setScale();
    var plotinfo = {
      id: id,
      plotgroup: plotgroup,
      xaxis: xa,
      yaxis: ya,
      isRangePlot: true
    };
    if (isMainPlot) mainplotinfo = plotinfo;else {
      plotinfo.mainplot = 'xy';
      plotinfo.mainplotinfo = mainplotinfo;
    }
    Cartesian.rangePlot(gd, plotinfo, filterRangePlotCalcData(calcData, id));
  });
}
function filterRangePlotCalcData(calcData, subplotId) {
  var out = [];
  for (var i = 0; i < calcData.length; i++) {
    var calcTrace = calcData[i];
    var trace = calcTrace[0].trace;
    if (trace.xaxis + trace.yaxis === subplotId) {
      out.push(calcTrace);
    }
  }
  return out;
}
function drawMasks(rangeSlider, gd, axisOpts, opts, oppAxisRangeOpts) {
  var maskMin = Lib.ensureSingle(rangeSlider, 'rect', constants.maskMinClassName, function (s) {
    s.attr({
      x: 0,
      y: 0,
      'shape-rendering': 'crispEdges'
    });
  });
  maskMin.attr('height', opts._height).call(Color.fill, constants.maskColor);
  var maskMax = Lib.ensureSingle(rangeSlider, 'rect', constants.maskMaxClassName, function (s) {
    s.attr({
      y: 0,
      'shape-rendering': 'crispEdges'
    });
  });
  maskMax.attr('height', opts._height).call(Color.fill, constants.maskColor);

  // masks used for oppAxis zoom
  if (oppAxisRangeOpts.rangemode !== 'match') {
    var maskMinOppAxis = Lib.ensureSingle(rangeSlider, 'rect', constants.maskMinOppAxisClassName, function (s) {
      s.attr({
        y: 0,
        'shape-rendering': 'crispEdges'
      });
    });
    maskMinOppAxis.attr('width', opts._width).call(Color.fill, constants.maskOppAxisColor);
    var maskMaxOppAxis = Lib.ensureSingle(rangeSlider, 'rect', constants.maskMaxOppAxisClassName, function (s) {
      s.attr({
        y: 0,
        'shape-rendering': 'crispEdges'
      });
    });
    maskMaxOppAxis.attr('width', opts._width).style('border-top', constants.maskOppBorder).call(Color.fill, constants.maskOppAxisColor);
  }
}
function drawSlideBox(rangeSlider, gd, axisOpts, opts) {
  if (gd._context.staticPlot) return;
  var slideBox = Lib.ensureSingle(rangeSlider, 'rect', constants.slideBoxClassName, function (s) {
    s.attr({
      y: 0,
      cursor: constants.slideBoxCursor,
      'shape-rendering': 'crispEdges'
    });
  });
  slideBox.attr({
    height: opts._height,
    fill: constants.slideBoxFill
  });
}
function drawGrabbers(rangeSlider, gd, axisOpts, opts) {
  // <g grabber />
  var grabberMin = Lib.ensureSingle(rangeSlider, 'g', constants.grabberMinClassName);
  var grabberMax = Lib.ensureSingle(rangeSlider, 'g', constants.grabberMaxClassName);

  // <g handle />
  var handleFixAttrs = {
    x: 0,
    width: constants.handleWidth,
    rx: constants.handleRadius,
    fill: Color.background,
    stroke: Color.defaultLine,
    'stroke-width': constants.handleStrokeWidth,
    'shape-rendering': 'crispEdges'
  };
  var handleDynamicAttrs = {
    y: Math.round(opts._height / 4),
    height: Math.round(opts._height / 2)
  };
  var handleMin = Lib.ensureSingle(grabberMin, 'rect', constants.handleMinClassName, function (s) {
    s.attr(handleFixAttrs);
  });
  handleMin.attr(handleDynamicAttrs);
  var handleMax = Lib.ensureSingle(grabberMax, 'rect', constants.handleMaxClassName, function (s) {
    s.attr(handleFixAttrs);
  });
  handleMax.attr(handleDynamicAttrs);

  // <g grabarea />
  var grabAreaFixAttrs = {
    width: constants.grabAreaWidth,
    x: 0,
    y: 0,
    fill: constants.grabAreaFill,
    cursor: !gd._context.staticPlot ? constants.grabAreaCursor : undefined
  };
  var grabAreaMin = Lib.ensureSingle(grabberMin, 'rect', constants.grabAreaMinClassName, function (s) {
    s.attr(grabAreaFixAttrs);
  });
  grabAreaMin.attr('height', opts._height);
  var grabAreaMax = Lib.ensureSingle(grabberMax, 'rect', constants.grabAreaMaxClassName, function (s) {
    s.attr(grabAreaFixAttrs);
  });
  grabAreaMax.attr('height', opts._height);
}

/***/ }),

/***/ 7944:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var axisIDs = __webpack_require__(9811);
var svgTextUtils = __webpack_require__(2736);
var constants = __webpack_require__(4636);
var LINE_SPACING = (__webpack_require__(4284).LINE_SPACING);
var name = constants.name;
function isVisible(ax) {
  var rangeSlider = ax && ax[name];
  return rangeSlider && rangeSlider.visible;
}
exports.isVisible = isVisible;
exports.makeData = function (fullLayout) {
  var axes = axisIDs.list({
    _fullLayout: fullLayout
  }, 'x', true);
  var margin = fullLayout.margin;
  var rangeSliderData = [];
  if (!fullLayout._has('gl2d')) {
    for (var i = 0; i < axes.length; i++) {
      var ax = axes[i];
      if (isVisible(ax)) {
        rangeSliderData.push(ax);
        var opts = ax[name];
        opts._id = name + ax._id;
        opts._height = (fullLayout.height - margin.b - margin.t) * opts.thickness;
        opts._offsetShift = Math.floor(opts.borderwidth / 2);
      }
    }
  }
  fullLayout._rangeSliderData = rangeSliderData;
};
exports.autoMarginOpts = function (gd, ax) {
  var fullLayout = gd._fullLayout;
  var opts = ax[name];
  var axLetter = ax._id.charAt(0);
  var bottomDepth = 0;
  var titleHeight = 0;
  if (ax.side === 'bottom') {
    bottomDepth = ax._depth;
    if (ax.title.text !== fullLayout._dfltTitle[axLetter]) {
      // as in rangeslider/draw.js
      titleHeight = 1.5 * ax.title.font.size + 10 + opts._offsetShift;
      // multi-line extra bump
      var extraLines = (ax.title.text.match(svgTextUtils.BR_TAG_ALL) || []).length;
      titleHeight += extraLines * ax.title.font.size * LINE_SPACING;
    }
  }
  return {
    x: 0,
    y: ax._counterDomainMin,
    l: 0,
    r: 0,
    t: 0,
    b: opts._height + bottomDepth + Math.max(fullLayout.margin.b, titleHeight),
    pad: constants.extraPad + opts._offsetShift * 2
  };
};

/***/ }),

/***/ 9692:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var attrs = __webpack_require__(8820);
var oppAxisAttrs = __webpack_require__(936);
var helpers = __webpack_require__(7944);
module.exports = {
  moduleType: 'component',
  name: 'rangeslider',
  schema: {
    subplots: {
      xaxis: {
        rangeslider: Lib.extendFlat({}, attrs, {
          yaxis: oppAxisAttrs
        })
      }
    }
  },
  layoutAttributes: __webpack_require__(8820),
  handleDefaults: __webpack_require__(1659),
  calcAutorange: __webpack_require__(6652),
  draw: __webpack_require__(60),
  isVisible: helpers.isVisible,
  makeData: helpers.makeData,
  autoMarginOpts: helpers.autoMarginOpts
};

/***/ }),

/***/ 936:
/***/ (function(module) {

"use strict";


module.exports = {
  // not really a 'subplot' attribute container,
  // but this is the flag we use to denote attributes that
  // support yaxis, yaxis2, yaxis3, ... counters
  _isSubplotObj: true,
  rangemode: {
    valType: 'enumerated',
    values: ['auto', 'fixed', 'match'],
    dflt: 'match',
    editType: 'calc'
  },
  range: {
    valType: 'info_array',
    items: [{
      valType: 'any',
      editType: 'plot'
    }, {
      valType: 'any',
      editType: 'plot'
    }],
    editType: 'plot'
  },
  editType: 'calc'
};

/***/ }),

/***/ 3956:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var annAttrs = __webpack_require__(3916);
var scatterLineAttrs = (__webpack_require__(2904).line);
var dash = (__webpack_require__(8192)/* .dash */ .u);
var extendFlat = (__webpack_require__(2880).extendFlat);
var overrideAll = (__webpack_require__(7824).overrideAll);
var templatedArray = (__webpack_require__(1780).templatedArray);
var axisPlaceableObjs = __webpack_require__(6208);
module.exports = overrideAll(templatedArray('selection', {
  type: {
    valType: 'enumerated',
    values: ['rect', 'path']
  },
  xref: extendFlat({}, annAttrs.xref, {}),
  yref: extendFlat({}, annAttrs.yref, {}),
  x0: {
    valType: 'any'
  },
  x1: {
    valType: 'any'
  },
  y0: {
    valType: 'any'
  },
  y1: {
    valType: 'any'
  },
  path: {
    valType: 'string',
    editType: 'arraydraw'
  },
  opacity: {
    valType: 'number',
    min: 0,
    max: 1,
    dflt: 0.7,
    editType: 'arraydraw'
  },
  line: {
    color: scatterLineAttrs.color,
    width: extendFlat({}, scatterLineAttrs.width, {
      min: 1,
      dflt: 1
    }),
    dash: extendFlat({}, dash, {
      dflt: 'dot'
    })
  }
}), 'arraydraw', 'from-root');

/***/ }),

/***/ 3280:
/***/ (function(module) {

"use strict";


module.exports = {
  // max pixels off straight before a lasso select line counts as bent
  BENDPX: 1.5,
  // smallest dimension allowed for a select box
  MINSELECT: 12,
  // throttling limit (ms) for selectPoints calls
  SELECTDELAY: 100,
  // cache ID suffix for throttle
  SELECTID: '-select'
};

/***/ }),

/***/ 4224:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Axes = __webpack_require__(4460);
var handleArrayContainerDefaults = __webpack_require__(1272);
var attributes = __webpack_require__(3956);
var helpers = __webpack_require__(5152);
module.exports = function supplyLayoutDefaults(layoutIn, layoutOut) {
  handleArrayContainerDefaults(layoutIn, layoutOut, {
    name: 'selections',
    handleItemDefaults: handleSelectionDefaults
  });

  // Drop rect selections with undefined x0, y0, x1, x1 values.
  // In future we may accept partially defined rects e.g.
  // a case with only x0 and x1 may be used to define
  // [-Infinity, +Infinity] range on the y axis, etc.
  var selections = layoutOut.selections;
  for (var i = 0; i < selections.length; i++) {
    var selection = selections[i];
    if (!selection) continue;
    if (selection.path === undefined) {
      if (selection.x0 === undefined || selection.x1 === undefined || selection.y0 === undefined || selection.y1 === undefined) {
        layoutOut.selections[i] = null;
      }
    }
  }
};
function handleSelectionDefaults(selectionIn, selectionOut, fullLayout) {
  function coerce(attr, dflt) {
    return Lib.coerce(selectionIn, selectionOut, attributes, attr, dflt);
  }
  var path = coerce('path');
  var dfltType = path ? 'path' : 'rect';
  var selectionType = coerce('type', dfltType);
  var noPath = selectionType !== 'path';
  if (noPath) delete selectionOut.path;
  coerce('opacity');
  coerce('line.color');
  coerce('line.width');
  coerce('line.dash');

  // positioning
  var axLetters = ['x', 'y'];
  for (var i = 0; i < 2; i++) {
    var axLetter = axLetters[i];
    var gdMock = {
      _fullLayout: fullLayout
    };
    var ax;
    var pos2r;
    var r2pos;

    // xref, yref
    var axRef = Axes.coerceRef(selectionIn, selectionOut, gdMock, axLetter);

    // axRefType is 'range' for selections
    ax = Axes.getFromId(gdMock, axRef);
    ax._selectionIndices.push(selectionOut._index);
    r2pos = helpers.rangeToShapePosition(ax);
    pos2r = helpers.shapePositionToRange(ax);

    // Coerce x0, x1, y0, y1
    if (noPath) {
      // hack until V3.0 when log has regular range behavior - make it look like other
      // ranges to send to coerce, then put it back after
      // this is all to give reasonable default position behavior on log axes, which is
      // a pretty unimportant edge case so we could just ignore this.
      var attr0 = axLetter + '0';
      var attr1 = axLetter + '1';
      var in0 = selectionIn[attr0];
      var in1 = selectionIn[attr1];
      selectionIn[attr0] = pos2r(selectionIn[attr0], true);
      selectionIn[attr1] = pos2r(selectionIn[attr1], true);
      Axes.coercePosition(selectionOut, gdMock, coerce, axRef, attr0);
      Axes.coercePosition(selectionOut, gdMock, coerce, axRef, attr1);
      var p0 = selectionOut[attr0];
      var p1 = selectionOut[attr1];
      if (p0 !== undefined && p1 !== undefined) {
        // hack part 2
        selectionOut[attr0] = r2pos(p0);
        selectionOut[attr1] = r2pos(p1);
        selectionIn[attr0] = in0;
        selectionIn[attr1] = in1;
      }
    }
  }
  if (noPath) {
    Lib.noneOrAll(selectionIn, selectionOut, ['x0', 'x1', 'y0', 'y1']);
  }
}

/***/ }),

/***/ 3640:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var readPaths = (__webpack_require__(9856).readPaths);
var displayOutlines = __webpack_require__(5496);
var clearOutlineControllers = (__webpack_require__(1936).clearOutlineControllers);
var Color = __webpack_require__(6308);
var Drawing = __webpack_require__(3616);
var arrayEditor = (__webpack_require__(1780).arrayEditor);
var helpers = __webpack_require__(5152);
var getPathString = helpers.getPathString;

// Selections are stored in gd.layout.selections, an array of objects
// index can point to one item in this array,
//  or non-numeric to simply add a new one
//  or -1 to modify all existing
// opt can be the full options object, or one key (to be set to value)
//  or undefined to simply redraw
// if opt is blank, val can be 'add' or a full options object to add a new
//  annotation at that point in the array, or 'remove' to delete this one

module.exports = {
  draw: draw,
  drawOne: drawOne,
  activateLastSelection: activateLastSelection
};
function draw(gd) {
  var fullLayout = gd._fullLayout;
  clearOutlineControllers(gd);

  // Remove previous selections before drawing new selections in fullLayout.selections
  fullLayout._selectionLayer.selectAll('path').remove();
  for (var k in fullLayout._plots) {
    var selectionLayer = fullLayout._plots[k].selectionLayer;
    if (selectionLayer) selectionLayer.selectAll('path').remove();
  }
  for (var i = 0; i < fullLayout.selections.length; i++) {
    drawOne(gd, i);
  }
}
function couldHaveActiveSelection(gd) {
  return gd._context.editSelection;
}
function drawOne(gd, index) {
  // remove the existing selection if there is one.
  // because indices can change, we need to look in all selection layers
  gd._fullLayout._paperdiv.selectAll('.selectionlayer [data-index="' + index + '"]').remove();
  var o = helpers.makeSelectionsOptionsAndPlotinfo(gd, index);
  var options = o.options;
  var plotinfo = o.plotinfo;

  // this selection is gone - quit now after deleting it
  // TODO: use d3 idioms instead of deleting and redrawing every time
  if (!options._input) return;
  drawSelection(gd._fullLayout._selectionLayer);
  function drawSelection(selectionLayer) {
    var d = getPathString(gd, options);
    var attrs = {
      'data-index': index,
      'fill-rule': 'evenodd',
      d: d
    };
    var opacity = options.opacity;
    var fillColor = 'rgba(0,0,0,0)';
    var lineColor = options.line.color || Color.contrast(gd._fullLayout.plot_bgcolor);
    var lineWidth = options.line.width;
    var lineDash = options.line.dash;
    if (!lineWidth) {
      // ensure invisible border to activate the selection
      lineWidth = 5;
      lineDash = 'solid';
    }
    var isActiveSelection = couldHaveActiveSelection(gd) && gd._fullLayout._activeSelectionIndex === index;
    if (isActiveSelection) {
      fillColor = gd._fullLayout.activeselection.fillcolor;
      opacity = gd._fullLayout.activeselection.opacity;
    }
    var allPaths = [];
    for (var sensory = 1; sensory >= 0; sensory--) {
      var path = selectionLayer.append('path').attr(attrs).style('opacity', sensory ? 0.1 : opacity).call(Color.stroke, lineColor).call(Color.fill, fillColor)
      // make it easier to select senory background path
      .call(Drawing.dashLine, sensory ? 'solid' : lineDash, sensory ? 4 + lineWidth : lineWidth);
      setClipPath(path, gd, options);
      if (isActiveSelection) {
        var editHelpers = arrayEditor(gd.layout, 'selections', options);
        path.style({
          cursor: 'move'
        });
        var dragOptions = {
          element: path.node(),
          plotinfo: plotinfo,
          gd: gd,
          editHelpers: editHelpers,
          isActiveSelection: true // i.e. to enable controllers
        };

        var polygons = readPaths(d, gd);
        // display polygons on the screen
        displayOutlines(polygons, path, dragOptions);
      } else {
        path.style('pointer-events', sensory ? 'all' : 'none');
      }
      allPaths[sensory] = path;
    }
    var forePath = allPaths[0];
    var backPath = allPaths[1];
    backPath.node().addEventListener('click', function () {
      return activateSelection(gd, forePath);
    });
  }
}
function setClipPath(selectionPath, gd, selectionOptions) {
  var clipAxes = selectionOptions.xref + selectionOptions.yref;
  Drawing.setClipUrl(selectionPath, 'clip' + gd._fullLayout._uid + clipAxes, gd);
}
function activateSelection(gd, path) {
  if (!couldHaveActiveSelection(gd)) return;
  var element = path.node();
  var id = +element.getAttribute('data-index');
  if (id >= 0) {
    // deactivate if already active
    if (id === gd._fullLayout._activeSelectionIndex) {
      deactivateSelection(gd);
      return;
    }
    gd._fullLayout._activeSelectionIndex = id;
    gd._fullLayout._deactivateSelection = deactivateSelection;
    draw(gd);
  }
}
function activateLastSelection(gd) {
  if (!couldHaveActiveSelection(gd)) return;
  var id = gd._fullLayout.selections.length - 1;
  gd._fullLayout._activeSelectionIndex = id;
  gd._fullLayout._deactivateSelection = deactivateSelection;
  draw(gd);
}
function deactivateSelection(gd) {
  if (!couldHaveActiveSelection(gd)) return;
  var id = gd._fullLayout._activeSelectionIndex;
  if (id >= 0) {
    clearOutlineControllers(gd);
    delete gd._fullLayout._activeSelectionIndex;
    draw(gd);
  }
}

/***/ }),

/***/ 4200:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var dash = (__webpack_require__(8192)/* .dash */ .u);
var extendFlat = (__webpack_require__(2880).extendFlat);
module.exports = {
  newselection: {
    mode: {
      valType: 'enumerated',
      values: ['immediate', 'gradual'],
      dflt: 'immediate',
      editType: 'none'
    },
    line: {
      color: {
        valType: 'color',
        editType: 'none'
      },
      width: {
        valType: 'number',
        min: 1,
        dflt: 1,
        editType: 'none'
      },
      dash: extendFlat({}, dash, {
        dflt: 'dot',
        editType: 'none'
      }),
      editType: 'none'
    },
    // no drawdirection here noting that layout.selectdirection is used instead.

    editType: 'none'
  },
  activeselection: {
    fillcolor: {
      valType: 'color',
      dflt: 'rgba(0,0,0,0)',
      editType: 'none'
    },
    opacity: {
      valType: 'number',
      min: 0,
      max: 1,
      dflt: 0.5,
      editType: 'none'
    },
    editType: 'none'
  }
};

/***/ }),

/***/ 1004:
/***/ (function(module) {

"use strict";


module.exports = function supplyDrawNewSelectionDefaults(layoutIn, layoutOut, coerce) {
  coerce('newselection.mode');
  var newselectionLineWidth = coerce('newselection.line.width');
  if (newselectionLineWidth) {
    coerce('newselection.line.color');
    coerce('newselection.line.dash');
  }
  coerce('activeselection.fillcolor');
  coerce('activeselection.opacity');
};

/***/ }),

/***/ 5968:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var dragHelpers = __webpack_require__(2760);
var selectMode = dragHelpers.selectMode;
var handleOutline = __webpack_require__(1936);
var clearOutline = handleOutline.clearOutline;
var helpers = __webpack_require__(9856);
var readPaths = helpers.readPaths;
var writePaths = helpers.writePaths;
var fixDatesForPaths = helpers.fixDatesForPaths;
module.exports = function newSelections(outlines, dragOptions) {
  if (!outlines.length) return;
  var e = outlines[0][0]; // pick first
  if (!e) return;
  var d = e.getAttribute('d');
  var gd = dragOptions.gd;
  var newStyle = gd._fullLayout.newselection;
  var plotinfo = dragOptions.plotinfo;
  var xaxis = plotinfo.xaxis;
  var yaxis = plotinfo.yaxis;
  var isActiveSelection = dragOptions.isActiveSelection;
  var dragmode = dragOptions.dragmode;
  var selections = (gd.layout || {}).selections || [];
  if (!selectMode(dragmode) && isActiveSelection !== undefined) {
    var id = gd._fullLayout._activeSelectionIndex;
    if (id < selections.length) {
      switch (gd._fullLayout.selections[id].type) {
        case 'rect':
          dragmode = 'select';
          break;
        case 'path':
          dragmode = 'lasso';
          break;
      }
    }
  }
  var polygons = readPaths(d, gd, plotinfo, isActiveSelection);
  var newSelection = {
    xref: xaxis._id,
    yref: yaxis._id,
    opacity: newStyle.opacity,
    line: {
      color: newStyle.line.color,
      width: newStyle.line.width,
      dash: newStyle.line.dash
    }
  };
  var cell;
  // rect can be in one cell
  // only define cell if there is single cell
  if (polygons.length === 1) cell = polygons[0];
  if (cell && cell.length === 5 &&
  // ensure we only have 4 corners for a rect
  dragmode === 'select') {
    newSelection.type = 'rect';
    newSelection.x0 = cell[0][1];
    newSelection.y0 = cell[0][2];
    newSelection.x1 = cell[2][1];
    newSelection.y1 = cell[2][2];
  } else {
    newSelection.type = 'path';
    if (xaxis && yaxis) fixDatesForPaths(polygons, xaxis, yaxis);
    newSelection.path = writePaths(polygons);
    cell = null;
  }
  clearOutline(gd);
  var editHelpers = dragOptions.editHelpers;
  var modifyItem = (editHelpers || {}).modifyItem;
  var allSelections = [];
  for (var q = 0; q < selections.length; q++) {
    var beforeEdit = gd._fullLayout.selections[q];
    if (!beforeEdit) {
      allSelections[q] = beforeEdit;
      continue;
    }
    allSelections[q] = beforeEdit._input;
    if (isActiveSelection !== undefined && q === gd._fullLayout._activeSelectionIndex) {
      var afterEdit = newSelection;
      switch (beforeEdit.type) {
        case 'rect':
          modifyItem('x0', afterEdit.x0);
          modifyItem('x1', afterEdit.x1);
          modifyItem('y0', afterEdit.y0);
          modifyItem('y1', afterEdit.y1);
          break;
        case 'path':
          modifyItem('path', afterEdit.path);
          break;
      }
    }
  }
  if (isActiveSelection === undefined) {
    allSelections.push(newSelection); // add new selection
    return allSelections;
  }
  return editHelpers ? editHelpers.getUpdateObj() : {};
};

/***/ }),

/***/ 5840:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var strTranslate = (__webpack_require__(3400).strTranslate);

// in v3 (once log ranges are fixed),
// we'll be able to p2r here for all axis types
function p2r(ax, v) {
  switch (ax.type) {
    case 'log':
      return ax.p2d(v);
    case 'date':
      return ax.p2r(v, 0, ax.calendar);
    default:
      return ax.p2r(v);
  }
}
function r2p(ax, v) {
  switch (ax.type) {
    case 'log':
      return ax.d2p(v);
    case 'date':
      return ax.r2p(v, 0, ax.calendar);
    default:
      return ax.r2p(v);
  }
}
function axValue(ax) {
  var index = ax._id.charAt(0) === 'y' ? 1 : 0;
  return function (v) {
    return p2r(ax, v[index]);
  };
}
function getTransform(plotinfo) {
  return strTranslate(plotinfo.xaxis._offset, plotinfo.yaxis._offset);
}
module.exports = {
  p2r: p2r,
  r2p: r2p,
  axValue: axValue,
  getTransform: getTransform
};

/***/ }),

/***/ 2676:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var drawModule = __webpack_require__(3640);
var select = __webpack_require__(3156);
module.exports = {
  moduleType: 'component',
  name: 'selections',
  layoutAttributes: __webpack_require__(3956),
  supplyLayoutDefaults: __webpack_require__(4224),
  supplyDrawNewSelectionDefaults: __webpack_require__(1004),
  includeBasePlot: __webpack_require__(6632)('selections'),
  draw: drawModule.draw,
  drawOne: drawModule.drawOne,
  reselect: select.reselect,
  prepSelect: select.prepSelect,
  clearOutline: select.clearOutline,
  clearSelectionsCache: select.clearSelectionsCache,
  selectOnClick: select.selectOnClick
};

/***/ }),

/***/ 3156:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var polybool = __webpack_require__(4756);
var pointInPolygon = __webpack_require__(1456); // could we use contains lib/polygon instead?

var Registry = __webpack_require__(4040);
var dashStyle = (__webpack_require__(3616).dashStyle);
var Color = __webpack_require__(6308);
var Fx = __webpack_require__(3024);
var makeEventData = (__webpack_require__(624).makeEventData);
var dragHelpers = __webpack_require__(2760);
var freeMode = dragHelpers.freeMode;
var rectMode = dragHelpers.rectMode;
var drawMode = dragHelpers.drawMode;
var openMode = dragHelpers.openMode;
var selectMode = dragHelpers.selectMode;
var shapeHelpers = __webpack_require__(5152);
var shapeConstants = __webpack_require__(3068);
var displayOutlines = __webpack_require__(5496);
var clearOutline = (__webpack_require__(1936).clearOutline);
var newShapeHelpers = __webpack_require__(9856);
var handleEllipse = newShapeHelpers.handleEllipse;
var readPaths = newShapeHelpers.readPaths;
var newShapes = (__webpack_require__(3940).newShapes);
var newSelections = __webpack_require__(5968);
var activateLastSelection = (__webpack_require__(3640).activateLastSelection);
var Lib = __webpack_require__(3400);
var ascending = Lib.sorterAsc;
var libPolygon = __webpack_require__(2065);
var throttle = __webpack_require__(1200);
var getFromId = (__webpack_require__(9811).getFromId);
var clearGlCanvases = __webpack_require__(3696);
var redrawReglTraces = (__webpack_require__(9172).redrawReglTraces);
var constants = __webpack_require__(3280);
var MINSELECT = constants.MINSELECT;
var filteredPolygon = libPolygon.filter;
var polygonTester = libPolygon.tester;
var helpers = __webpack_require__(5840);
var p2r = helpers.p2r;
var axValue = helpers.axValue;
var getTransform = helpers.getTransform;
function hasSubplot(dragOptions) {
  // N.B. subplot may be falsy e.g zero sankey index!
  return dragOptions.subplot !== undefined;
}
function prepSelect(evt, startX, startY, dragOptions, mode) {
  var isCartesian = !hasSubplot(dragOptions);
  var isFreeMode = freeMode(mode);
  var isRectMode = rectMode(mode);
  var isOpenMode = openMode(mode);
  var isDrawMode = drawMode(mode);
  var isSelectMode = selectMode(mode);
  var isLine = mode === 'drawline';
  var isEllipse = mode === 'drawcircle';
  var isLineOrEllipse = isLine || isEllipse; // cases with two start & end positions

  var gd = dragOptions.gd;
  var fullLayout = gd._fullLayout;
  var immediateSelect = isSelectMode && fullLayout.newselection.mode === 'immediate' && isCartesian; // N.B. only cartesian subplots have persistent selection

  var zoomLayer = fullLayout._zoomlayer;
  var dragBBox = dragOptions.element.getBoundingClientRect();
  var plotinfo = dragOptions.plotinfo;
  var transform = getTransform(plotinfo);
  var x0 = startX - dragBBox.left;
  var y0 = startY - dragBBox.top;
  fullLayout._calcInverseTransform(gd);
  var transformedCoords = Lib.apply3DTransform(fullLayout._invTransform)(x0, y0);
  x0 = transformedCoords[0];
  y0 = transformedCoords[1];
  var scaleX = fullLayout._invScaleX;
  var scaleY = fullLayout._invScaleY;
  var x1 = x0;
  var y1 = y0;
  var path0 = 'M' + x0 + ',' + y0;
  var xAxis = dragOptions.xaxes[0];
  var yAxis = dragOptions.yaxes[0];
  var pw = xAxis._length;
  var ph = yAxis._length;
  var subtract = evt.altKey && !(drawMode(mode) && isOpenMode);
  var filterPoly, selectionTesters, mergedPolygons, currentPolygon;
  var i, searchInfo, eventData;
  coerceSelectionsCache(evt, gd, dragOptions);
  if (isFreeMode) {
    filterPoly = filteredPolygon([[x0, y0]], constants.BENDPX);
  }
  var outlines = zoomLayer.selectAll('path.select-outline-' + plotinfo.id).data([1]);
  var newStyle = isDrawMode ? fullLayout.newshape : fullLayout.newselection;
  if (isDrawMode) {
    dragOptions.hasText = newStyle.label.text || newStyle.label.texttemplate;
  }
  var fillC = isDrawMode && !isOpenMode ? newStyle.fillcolor : 'rgba(0,0,0,0)';
  var strokeC = newStyle.line.color || (isCartesian ? Color.contrast(gd._fullLayout.plot_bgcolor) : '#7f7f7f' // non-cartesian subplot
  );

  outlines.enter().append('path').attr('class', 'select-outline select-outline-' + plotinfo.id).style({
    opacity: isDrawMode ? newStyle.opacity / 2 : 1,
    'stroke-dasharray': dashStyle(newStyle.line.dash, newStyle.line.width),
    'stroke-width': newStyle.line.width + 'px',
    'shape-rendering': 'crispEdges'
  }).call(Color.stroke, strokeC).call(Color.fill, fillC).attr('fill-rule', 'evenodd').classed('cursor-move', isDrawMode ? true : false).attr('transform', transform).attr('d', path0 + 'Z');
  var corners = zoomLayer.append('path').attr('class', 'zoombox-corners').style({
    fill: Color.background,
    stroke: Color.defaultLine,
    'stroke-width': 1
  }).attr('transform', transform).attr('d', 'M0,0Z');

  // create & style group for text label
  if (isDrawMode && dragOptions.hasText) {
    var shapeGroup = zoomLayer.select('.label-temp');
    if (shapeGroup.empty()) {
      shapeGroup = zoomLayer.append('g').classed('label-temp', true).classed('select-outline', true).style({
        opacity: 0.8
      });
    }
  }
  var throttleID = fullLayout._uid + constants.SELECTID;
  var selection = [];

  // find the traces to search for selection points
  var searchTraces = determineSearchTraces(gd, dragOptions.xaxes, dragOptions.yaxes, dragOptions.subplot);
  if (immediateSelect && !evt.shiftKey) {
    dragOptions._clearSubplotSelections = function () {
      if (!isCartesian) return;
      var xRef = xAxis._id;
      var yRef = yAxis._id;
      deselectSubplot(gd, xRef, yRef, searchTraces);
      var selections = (gd.layout || {}).selections || [];
      var list = [];
      var selectionErased = false;
      for (var q = 0; q < selections.length; q++) {
        var s = fullLayout.selections[q];
        if (s.xref !== xRef || s.yref !== yRef) {
          list.push(selections[q]);
        } else {
          selectionErased = true;
        }
      }
      if (selectionErased) {
        gd._fullLayout._noEmitSelectedAtStart = true;
        Registry.call('_guiRelayout', gd, {
          selections: list
        });
      }
    };
  }
  var fillRangeItems = getFillRangeItems(dragOptions);
  dragOptions.moveFn = function (dx0, dy0) {
    if (dragOptions._clearSubplotSelections) {
      dragOptions._clearSubplotSelections();
      dragOptions._clearSubplotSelections = undefined;
    }
    x1 = Math.max(0, Math.min(pw, scaleX * dx0 + x0));
    y1 = Math.max(0, Math.min(ph, scaleY * dy0 + y0));
    var dx = Math.abs(x1 - x0);
    var dy = Math.abs(y1 - y0);
    if (isRectMode) {
      var direction;
      var start, end;
      if (isSelectMode) {
        var q = fullLayout.selectdirection;
        if (q === 'any') {
          if (dy < Math.min(dx * 0.6, MINSELECT)) {
            direction = 'h';
          } else if (dx < Math.min(dy * 0.6, MINSELECT)) {
            direction = 'v';
          } else {
            direction = 'd';
          }
        } else {
          direction = q;
        }
        switch (direction) {
          case 'h':
            start = isEllipse ? ph / 2 : 0;
            end = ph;
            break;
          case 'v':
            start = isEllipse ? pw / 2 : 0;
            end = pw;
            break;
        }
      }
      if (isDrawMode) {
        switch (fullLayout.newshape.drawdirection) {
          case 'vertical':
            direction = 'h';
            start = isEllipse ? ph / 2 : 0;
            end = ph;
            break;
          case 'horizontal':
            direction = 'v';
            start = isEllipse ? pw / 2 : 0;
            end = pw;
            break;
          case 'ortho':
            if (dx < dy) {
              direction = 'h';
              start = y0;
              end = y1;
            } else {
              direction = 'v';
              start = x0;
              end = x1;
            }
            break;
          default:
            // i.e. case of 'diagonal'
            direction = 'd';
        }
      }
      if (direction === 'h') {
        // horizontal motion
        currentPolygon = isLineOrEllipse ? handleEllipse(isEllipse, [x1, start], [x1, end]) :
        // using x1 instead of x0 allows adjusting the line while drawing
        [[x0, start], [x0, end], [x1, end], [x1, start]]; // make a vertical box

        currentPolygon.xmin = isLineOrEllipse ? x1 : Math.min(x0, x1);
        currentPolygon.xmax = isLineOrEllipse ? x1 : Math.max(x0, x1);
        currentPolygon.ymin = Math.min(start, end);
        currentPolygon.ymax = Math.max(start, end);
        // extras to guide users in keeping a straight selection
        corners.attr('d', 'M' + currentPolygon.xmin + ',' + (y0 - MINSELECT) + 'h-4v' + 2 * MINSELECT + 'h4Z' + 'M' + (currentPolygon.xmax - 1) + ',' + (y0 - MINSELECT) + 'h4v' + 2 * MINSELECT + 'h-4Z');
      } else if (direction === 'v') {
        // vertical motion
        currentPolygon = isLineOrEllipse ? handleEllipse(isEllipse, [start, y1], [end, y1]) :
        // using y1 instead of y0 allows adjusting the line while drawing
        [[start, y0], [start, y1], [end, y1], [end, y0]]; // make a horizontal box

        currentPolygon.xmin = Math.min(start, end);
        currentPolygon.xmax = Math.max(start, end);
        currentPolygon.ymin = isLineOrEllipse ? y1 : Math.min(y0, y1);
        currentPolygon.ymax = isLineOrEllipse ? y1 : Math.max(y0, y1);
        corners.attr('d', 'M' + (x0 - MINSELECT) + ',' + currentPolygon.ymin + 'v-4h' + 2 * MINSELECT + 'v4Z' + 'M' + (x0 - MINSELECT) + ',' + (currentPolygon.ymax - 1) + 'v4h' + 2 * MINSELECT + 'v-4Z');
      } else if (direction === 'd') {
        // diagonal motion
        currentPolygon = isLineOrEllipse ? handleEllipse(isEllipse, [x0, y0], [x1, y1]) : [[x0, y0], [x0, y1], [x1, y1], [x1, y0]];
        currentPolygon.xmin = Math.min(x0, x1);
        currentPolygon.xmax = Math.max(x0, x1);
        currentPolygon.ymin = Math.min(y0, y1);
        currentPolygon.ymax = Math.max(y0, y1);
        corners.attr('d', 'M0,0Z');
      }
    } else if (isFreeMode) {
      filterPoly.addPt([x1, y1]);
      currentPolygon = filterPoly.filtered;
    }

    // create outline & tester
    if (dragOptions.selectionDefs && dragOptions.selectionDefs.length) {
      mergedPolygons = mergePolygons(dragOptions.mergedPolygons, currentPolygon, subtract);
      currentPolygon.subtract = subtract;
      selectionTesters = multiTester(dragOptions.selectionDefs.concat([currentPolygon]));
    } else {
      mergedPolygons = [currentPolygon];
      selectionTesters = polygonTester(currentPolygon);
    }

    // display polygons on the screen
    displayOutlines(convertPoly(mergedPolygons, isOpenMode), outlines, dragOptions);
    if (isSelectMode) {
      var _res = reselect(gd, false);
      var extraPoints = _res.eventData ? _res.eventData.points.slice() : [];
      _res = reselect(gd, false, selectionTesters, searchTraces, dragOptions);
      selectionTesters = _res.selectionTesters;
      eventData = _res.eventData;
      var poly;
      if (filterPoly) {
        poly = filterPoly.filtered;
      } else {
        poly = castMultiPolygon(mergedPolygons);
      }
      throttle.throttle(throttleID, constants.SELECTDELAY, function () {
        selection = _doSelect(selectionTesters, searchTraces);
        var newPoints = selection.slice();
        for (var w = 0; w < extraPoints.length; w++) {
          var p = extraPoints[w];
          var found = false;
          for (var u = 0; u < newPoints.length; u++) {
            if (newPoints[u].curveNumber === p.curveNumber && newPoints[u].pointNumber === p.pointNumber) {
              found = true;
              break;
            }
          }
          if (!found) newPoints.push(p);
        }
        if (newPoints.length) {
          if (!eventData) eventData = {};
          eventData.points = newPoints;
        }
        fillRangeItems(eventData, poly);
        emitSelecting(gd, eventData);
      });
    }
  };
  dragOptions.clickFn = function (numClicks, evt) {
    corners.remove();
    if (gd._fullLayout._activeShapeIndex >= 0) {
      gd._fullLayout._deactivateShape(gd);
      return;
    }
    if (isDrawMode) return;
    var clickmode = fullLayout.clickmode;
    throttle.done(throttleID).then(function () {
      throttle.clear(throttleID);
      if (numClicks === 2) {
        // clear selection on doubleclick
        outlines.remove();
        for (i = 0; i < searchTraces.length; i++) {
          searchInfo = searchTraces[i];
          searchInfo._module.selectPoints(searchInfo, false);
        }
        updateSelectedState(gd, searchTraces);
        clearSelectionsCache(dragOptions);
        emitDeselect(gd);
        if (searchTraces.length) {
          var clickedXaxis = searchTraces[0].xaxis;
          var clickedYaxis = searchTraces[0].yaxis;
          if (clickedXaxis && clickedYaxis) {
            // drop selections in the clicked subplot
            var subSelections = [];
            var allSelections = gd._fullLayout.selections;
            for (var k = 0; k < allSelections.length; k++) {
              var s = allSelections[k];
              if (!s) continue; // also drop null selections if any

              if (s.xref !== clickedXaxis._id || s.yref !== clickedYaxis._id) {
                subSelections.push(s);
              }
            }
            if (subSelections.length < allSelections.length) {
              gd._fullLayout._noEmitSelectedAtStart = true;
              Registry.call('_guiRelayout', gd, {
                selections: subSelections
              });
            }
          }
        }
      } else {
        if (clickmode.indexOf('select') > -1) {
          selectOnClick(evt, gd, dragOptions.xaxes, dragOptions.yaxes, dragOptions.subplot, dragOptions, outlines);
        }
        if (clickmode === 'event') {
          // TODO: remove in v3 - this was probably never intended to work as it does,
          // but in case anyone depends on it we don't want to break it now.
          // Note that click-to-select introduced pre v3 also emitts proper
          // event data when clickmode is having 'select' in its flag list.
          emitSelected(gd, undefined);
        }
      }
      Fx.click(gd, evt, plotinfo.id);
    }).catch(Lib.error);
  };
  dragOptions.doneFn = function () {
    corners.remove();
    throttle.done(throttleID).then(function () {
      throttle.clear(throttleID);
      if (!immediateSelect && currentPolygon && dragOptions.selectionDefs) {
        // save last polygons
        currentPolygon.subtract = subtract;
        dragOptions.selectionDefs.push(currentPolygon);

        // we have to keep reference to arrays container
        dragOptions.mergedPolygons.length = 0;
        [].push.apply(dragOptions.mergedPolygons, mergedPolygons);
      }
      if (immediateSelect || isDrawMode) {
        clearSelectionsCache(dragOptions, immediateSelect);
      }
      if (dragOptions.doneFnCompleted) {
        dragOptions.doneFnCompleted(selection);
      }
      if (isSelectMode) {
        emitSelected(gd, eventData);
      }
    }).catch(Lib.error);
  };
}
function selectOnClick(evt, gd, xAxes, yAxes, subplot, dragOptions, polygonOutlines) {
  var hoverData = gd._hoverdata;
  var fullLayout = gd._fullLayout;
  var clickmode = fullLayout.clickmode;
  var sendEvents = clickmode.indexOf('event') > -1;
  var selection = [];
  var searchTraces, searchInfo, currentSelectionDef, selectionTesters, traceSelection;
  var thisTracesSelection, pointOrBinSelected, subtract, eventData, i;
  if (isHoverDataSet(hoverData)) {
    coerceSelectionsCache(evt, gd, dragOptions);
    searchTraces = determineSearchTraces(gd, xAxes, yAxes, subplot);
    var clickedPtInfo = extractClickedPtInfo(hoverData, searchTraces);
    var isBinnedTrace = clickedPtInfo.pointNumbers.length > 0;

    // Note: potentially costly operation isPointOrBinSelected is
    // called as late as possible through the use of an assignment
    // in an if condition.
    if (isBinnedTrace ? isOnlyThisBinSelected(searchTraces, clickedPtInfo) : isOnlyOnePointSelected(searchTraces) && (pointOrBinSelected = isPointOrBinSelected(clickedPtInfo))) {
      if (polygonOutlines) polygonOutlines.remove();
      for (i = 0; i < searchTraces.length; i++) {
        searchInfo = searchTraces[i];
        searchInfo._module.selectPoints(searchInfo, false);
      }
      updateSelectedState(gd, searchTraces);
      clearSelectionsCache(dragOptions);
      if (sendEvents) {
        emitDeselect(gd);
      }
    } else {
      subtract = evt.shiftKey && (pointOrBinSelected !== undefined ? pointOrBinSelected : isPointOrBinSelected(clickedPtInfo));
      currentSelectionDef = newPointSelectionDef(clickedPtInfo.pointNumber, clickedPtInfo.searchInfo, subtract);
      var allSelectionDefs = dragOptions.selectionDefs.concat([currentSelectionDef]);
      selectionTesters = multiTester(allSelectionDefs, selectionTesters);
      for (i = 0; i < searchTraces.length; i++) {
        traceSelection = searchTraces[i]._module.selectPoints(searchTraces[i], selectionTesters);
        thisTracesSelection = fillSelectionItem(traceSelection, searchTraces[i]);
        if (selection.length) {
          for (var j = 0; j < thisTracesSelection.length; j++) {
            selection.push(thisTracesSelection[j]);
          }
        } else selection = thisTracesSelection;
      }
      eventData = {
        points: selection
      };
      updateSelectedState(gd, searchTraces, eventData);
      if (currentSelectionDef && dragOptions) {
        dragOptions.selectionDefs.push(currentSelectionDef);
      }
      if (polygonOutlines) {
        var polygons = dragOptions.mergedPolygons;
        var isOpenMode = openMode(dragOptions.dragmode);

        // display polygons on the screen
        displayOutlines(convertPoly(polygons, isOpenMode), polygonOutlines, dragOptions);
      }
      if (sendEvents) {
        emitSelected(gd, eventData);
      }
    }
  }
}

/**
 * Constructs a new point selection definition object.
 */
function newPointSelectionDef(pointNumber, searchInfo, subtract) {
  return {
    pointNumber: pointNumber,
    searchInfo: searchInfo,
    subtract: !!subtract
  };
}
function isPointSelectionDef(o) {
  return 'pointNumber' in o && 'searchInfo' in o;
}

/*
 * Constructs a new point number tester.
 */
function newPointNumTester(pointSelectionDef) {
  return {
    xmin: 0,
    xmax: 0,
    ymin: 0,
    ymax: 0,
    pts: [],
    contains: function (pt, omitFirstEdge, pointNumber, searchInfo) {
      var idxWantedTrace = pointSelectionDef.searchInfo.cd[0].trace._expandedIndex;
      var idxActualTrace = searchInfo.cd[0].trace._expandedIndex;
      return idxActualTrace === idxWantedTrace && pointNumber === pointSelectionDef.pointNumber;
    },
    isRect: false,
    degenerate: false,
    subtract: !!pointSelectionDef.subtract
  };
}

/**
 * Wraps multiple selection testers.
 *
 * @param {Array} list - An array of selection testers.
 *
 * @return a selection tester object with a contains function
 * that can be called to evaluate a point against all wrapped
 * selection testers that were passed in list.
 */
function multiTester(list) {
  if (!list.length) return;
  var testers = [];
  var xmin = isPointSelectionDef(list[0]) ? 0 : list[0][0][0];
  var xmax = xmin;
  var ymin = isPointSelectionDef(list[0]) ? 0 : list[0][0][1];
  var ymax = ymin;
  for (var i = 0; i < list.length; i++) {
    if (isPointSelectionDef(list[i])) {
      testers.push(newPointNumTester(list[i]));
    } else {
      var tester = polygonTester(list[i]);
      tester.subtract = !!list[i].subtract;
      testers.push(tester);
      xmin = Math.min(xmin, tester.xmin);
      xmax = Math.max(xmax, tester.xmax);
      ymin = Math.min(ymin, tester.ymin);
      ymax = Math.max(ymax, tester.ymax);
    }
  }

  /**
   * Tests if the given point is within this tester.
   *
   * @param {Array} pt - [0] is the x coordinate, [1] is the y coordinate of the point.
   * @param {*} arg - An optional parameter to pass down to wrapped testers.
   * @param {number} pointNumber - The point number of the point within the underlying data array.
   * @param {number} searchInfo - An object identifying the trace the point is contained in.
   *
   * @return {boolean} true if point is considered to be selected, false otherwise.
   */
  function contains(pt, arg, pointNumber, searchInfo) {
    var contained = false;
    for (var i = 0; i < testers.length; i++) {
      if (testers[i].contains(pt, arg, pointNumber, searchInfo)) {
        // if contained by subtract tester - exclude the point
        contained = !testers[i].subtract;
      }
    }
    return contained;
  }
  return {
    xmin: xmin,
    xmax: xmax,
    ymin: ymin,
    ymax: ymax,
    pts: [],
    contains: contains,
    isRect: false,
    degenerate: false
  };
}
function coerceSelectionsCache(evt, gd, dragOptions) {
  var fullLayout = gd._fullLayout;
  var plotinfo = dragOptions.plotinfo;
  var dragmode = dragOptions.dragmode;
  var selectingOnSameSubplot = fullLayout._lastSelectedSubplot && fullLayout._lastSelectedSubplot === plotinfo.id;
  var hasModifierKey = (evt.shiftKey || evt.altKey) && !(drawMode(dragmode) && openMode(dragmode));
  if (selectingOnSameSubplot && hasModifierKey && plotinfo.selection && plotinfo.selection.selectionDefs && !dragOptions.selectionDefs) {
    // take over selection definitions from prev mode, if any
    dragOptions.selectionDefs = plotinfo.selection.selectionDefs;
    dragOptions.mergedPolygons = plotinfo.selection.mergedPolygons;
  } else if (!hasModifierKey || !plotinfo.selection) {
    clearSelectionsCache(dragOptions);
  }

  // clear selection outline when selecting a different subplot
  if (!selectingOnSameSubplot) {
    clearOutline(gd);
    fullLayout._lastSelectedSubplot = plotinfo.id;
  }
}
function hasActiveShape(gd) {
  return gd._fullLayout._activeShapeIndex >= 0;
}
function hasActiveSelection(gd) {
  return gd._fullLayout._activeSelectionIndex >= 0;
}
function clearSelectionsCache(dragOptions, immediateSelect) {
  var dragmode = dragOptions.dragmode;
  var plotinfo = dragOptions.plotinfo;
  var gd = dragOptions.gd;
  if (hasActiveShape(gd)) {
    gd._fullLayout._deactivateShape(gd);
  }
  if (hasActiveSelection(gd)) {
    gd._fullLayout._deactivateSelection(gd);
  }
  var fullLayout = gd._fullLayout;
  var zoomLayer = fullLayout._zoomlayer;
  var isDrawMode = drawMode(dragmode);
  var isSelectMode = selectMode(dragmode);
  if (isDrawMode || isSelectMode) {
    var outlines = zoomLayer.selectAll('.select-outline-' + plotinfo.id);
    if (outlines && gd._fullLayout._outlining) {
      // add shape
      var shapes;
      if (isDrawMode) {
        shapes = newShapes(outlines, dragOptions);
      }
      if (shapes) {
        Registry.call('_guiRelayout', gd, {
          shapes: shapes
        });
      }

      // add selection
      var selections;
      if (isSelectMode && !hasSubplot(dragOptions) // only allow cartesian - no mapbox for now
      ) {
        selections = newSelections(outlines, dragOptions);
      }
      if (selections) {
        gd._fullLayout._noEmitSelectedAtStart = true;
        Registry.call('_guiRelayout', gd, {
          selections: selections
        }).then(function () {
          if (immediateSelect) {
            activateLastSelection(gd);
          }
        });
      }
      gd._fullLayout._outlining = false;
    }
  }
  plotinfo.selection = {};
  plotinfo.selection.selectionDefs = dragOptions.selectionDefs = [];
  plotinfo.selection.mergedPolygons = dragOptions.mergedPolygons = [];
}
function getAxId(ax) {
  return ax._id;
}
function determineSearchTraces(gd, xAxes, yAxes, subplot) {
  if (!gd.calcdata) return [];
  var searchTraces = [];
  var xAxisIds = xAxes.map(getAxId);
  var yAxisIds = yAxes.map(getAxId);
  var cd, trace, i;
  for (i = 0; i < gd.calcdata.length; i++) {
    cd = gd.calcdata[i];
    trace = cd[0].trace;
    if (trace.visible !== true || !trace._module || !trace._module.selectPoints) continue;
    if (hasSubplot({
      subplot: subplot
    }) && (trace.subplot === subplot || trace.geo === subplot)) {
      searchTraces.push(createSearchInfo(trace._module, cd, xAxes[0], yAxes[0]));
    } else if (trace.type === 'splom') {
      // FIXME: make sure we don't have more than single axis for splom
      if (trace._xaxes[xAxisIds[0]] && trace._yaxes[yAxisIds[0]]) {
        var info = createSearchInfo(trace._module, cd, xAxes[0], yAxes[0]);
        info.scene = gd._fullLayout._splomScenes[trace.uid];
        searchTraces.push(info);
      }
    } else if (trace.type === 'sankey') {
      var sankeyInfo = createSearchInfo(trace._module, cd, xAxes[0], yAxes[0]);
      searchTraces.push(sankeyInfo);
    } else {
      if (xAxisIds.indexOf(trace.xaxis) === -1 && (!trace._xA || !trace._xA.overlaying)) continue;
      if (yAxisIds.indexOf(trace.yaxis) === -1 && (!trace._yA || !trace._yA.overlaying)) continue;
      searchTraces.push(createSearchInfo(trace._module, cd, getFromId(gd, trace.xaxis), getFromId(gd, trace.yaxis)));
    }
  }
  return searchTraces;
}
function createSearchInfo(module, calcData, xaxis, yaxis) {
  return {
    _module: module,
    cd: calcData,
    xaxis: xaxis,
    yaxis: yaxis
  };
}
function isHoverDataSet(hoverData) {
  return hoverData && Array.isArray(hoverData) && hoverData[0].hoverOnBox !== true;
}
function extractClickedPtInfo(hoverData, searchTraces) {
  var hoverDatum = hoverData[0];
  var pointNumber = -1;
  var pointNumbers = [];
  var searchInfo, i;
  for (i = 0; i < searchTraces.length; i++) {
    searchInfo = searchTraces[i];
    if (hoverDatum.fullData._expandedIndex === searchInfo.cd[0].trace._expandedIndex) {
      // Special case for box (and violin)
      if (hoverDatum.hoverOnBox === true) {
        break;
      }

      // Hint: in some traces like histogram, one graphical element
      // doesn't correspond to one particular data point, but to
      // bins of data points. Thus, hoverDatum can have a binNumber
      // property instead of pointNumber.
      if (hoverDatum.pointNumber !== undefined) {
        pointNumber = hoverDatum.pointNumber;
      } else if (hoverDatum.binNumber !== undefined) {
        pointNumber = hoverDatum.binNumber;
        pointNumbers = hoverDatum.pointNumbers;
      }
      break;
    }
  }
  return {
    pointNumber: pointNumber,
    pointNumbers: pointNumbers,
    searchInfo: searchInfo
  };
}
function isPointOrBinSelected(clickedPtInfo) {
  var trace = clickedPtInfo.searchInfo.cd[0].trace;
  var ptNum = clickedPtInfo.pointNumber;
  var ptNums = clickedPtInfo.pointNumbers;
  var ptNumsSet = ptNums.length > 0;

  // When pointsNumbers is set (e.g. histogram's binning),
  // it is assumed that when the first point of
  // a bin is selected, all others are as well
  var ptNumToTest = ptNumsSet ? ptNums[0] : ptNum;

  // TODO potential performance improvement
  // Primarily we need this function to determine if a click adds
  // or subtracts from a selection.
  // In cases `trace.selectedpoints` is a huge array, indexOf
  // might be slow. One remedy would be to introduce a hash somewhere.
  return trace.selectedpoints ? trace.selectedpoints.indexOf(ptNumToTest) > -1 : false;
}
function isOnlyThisBinSelected(searchTraces, clickedPtInfo) {
  var tracesWithSelectedPts = [];
  var searchInfo, trace, isSameTrace, i;
  for (i = 0; i < searchTraces.length; i++) {
    searchInfo = searchTraces[i];
    if (searchInfo.cd[0].trace.selectedpoints && searchInfo.cd[0].trace.selectedpoints.length > 0) {
      tracesWithSelectedPts.push(searchInfo);
    }
  }
  if (tracesWithSelectedPts.length === 1) {
    isSameTrace = tracesWithSelectedPts[0] === clickedPtInfo.searchInfo;
    if (isSameTrace) {
      trace = clickedPtInfo.searchInfo.cd[0].trace;
      if (trace.selectedpoints.length === clickedPtInfo.pointNumbers.length) {
        for (i = 0; i < clickedPtInfo.pointNumbers.length; i++) {
          if (trace.selectedpoints.indexOf(clickedPtInfo.pointNumbers[i]) < 0) {
            return false;
          }
        }
        return true;
      }
    }
  }
  return false;
}
function isOnlyOnePointSelected(searchTraces) {
  var len = 0;
  var searchInfo, trace, i;
  for (i = 0; i < searchTraces.length; i++) {
    searchInfo = searchTraces[i];
    trace = searchInfo.cd[0].trace;
    if (trace.selectedpoints) {
      if (trace.selectedpoints.length > 1) return false;
      len += trace.selectedpoints.length;
      if (len > 1) return false;
    }
  }
  return len === 1;
}
function updateSelectedState(gd, searchTraces, eventData) {
  var i;

  // before anything else, update preGUI if necessary
  for (i = 0; i < searchTraces.length; i++) {
    var fullInputTrace = searchTraces[i].cd[0].trace._fullInput;
    var tracePreGUI = gd._fullLayout._tracePreGUI[fullInputTrace.uid] || {};
    if (tracePreGUI.selectedpoints === undefined) {
      tracePreGUI.selectedpoints = fullInputTrace._input.selectedpoints || null;
    }
  }
  var trace;
  if (eventData) {
    var pts = eventData.points || [];
    for (i = 0; i < searchTraces.length; i++) {
      trace = searchTraces[i].cd[0].trace;
      trace._input.selectedpoints = trace._fullInput.selectedpoints = [];
      if (trace._fullInput !== trace) trace.selectedpoints = [];
    }
    for (var k = 0; k < pts.length; k++) {
      var pt = pts[k];
      var data = pt.data;
      var fullData = pt.fullData;
      var pointIndex = pt.pointIndex;
      var pointIndices = pt.pointIndices;
      if (pointIndices) {
        [].push.apply(data.selectedpoints, pointIndices);
        if (trace._fullInput !== trace) {
          [].push.apply(fullData.selectedpoints, pointIndices);
        }
      } else {
        data.selectedpoints.push(pointIndex);
        if (trace._fullInput !== trace) {
          fullData.selectedpoints.push(pointIndex);
        }
      }
    }
  } else {
    for (i = 0; i < searchTraces.length; i++) {
      trace = searchTraces[i].cd[0].trace;
      delete trace.selectedpoints;
      delete trace._input.selectedpoints;
      if (trace._fullInput !== trace) {
        delete trace._fullInput.selectedpoints;
      }
    }
  }
  updateReglSelectedState(gd, searchTraces);
}
function updateReglSelectedState(gd, searchTraces) {
  var hasRegl = false;
  for (var i = 0; i < searchTraces.length; i++) {
    var searchInfo = searchTraces[i];
    var cd = searchInfo.cd;
    if (Registry.traceIs(cd[0].trace, 'regl')) {
      hasRegl = true;
    }
    var _module = searchInfo._module;
    var fn = _module.styleOnSelect || _module.style;
    if (fn) {
      fn(gd, cd, cd[0].node3);
      if (cd[0].nodeRangePlot3) fn(gd, cd, cd[0].nodeRangePlot3);
    }
  }
  if (hasRegl) {
    clearGlCanvases(gd);
    redrawReglTraces(gd);
  }
}
function mergePolygons(list, poly, subtract) {
  var fn = subtract ? polybool.difference : polybool.union;
  var res = fn({
    regions: list
  }, {
    regions: [poly]
  });
  var allPolygons = res.regions.reverse();
  for (var i = 0; i < allPolygons.length; i++) {
    var polygon = allPolygons[i];
    polygon.subtract = getSubtract(polygon, allPolygons.slice(0, i));
  }
  return allPolygons;
}
function fillSelectionItem(selection, searchInfo) {
  if (Array.isArray(selection)) {
    var cd = searchInfo.cd;
    var trace = searchInfo.cd[0].trace;
    for (var i = 0; i < selection.length; i++) {
      selection[i] = makeEventData(selection[i], trace, cd);
    }
  }
  return selection;
}
function convertPoly(polygonsIn, isOpenMode) {
  // add M and L command to draft positions
  var polygonsOut = [];
  for (var i = 0; i < polygonsIn.length; i++) {
    polygonsOut[i] = [];
    for (var j = 0; j < polygonsIn[i].length; j++) {
      polygonsOut[i][j] = [];
      polygonsOut[i][j][0] = j ? 'L' : 'M';
      for (var k = 0; k < polygonsIn[i][j].length; k++) {
        polygonsOut[i][j].push(polygonsIn[i][j][k]);
      }
    }
    if (!isOpenMode) {
      polygonsOut[i].push(['Z', polygonsOut[i][0][1],
      // initial x
      polygonsOut[i][0][2] // initial y
      ]);
    }
  }

  return polygonsOut;
}
function _doSelect(selectionTesters, searchTraces) {
  var allSelections = [];
  var thisSelection;
  var traceSelections = [];
  var traceSelection;
  for (var i = 0; i < searchTraces.length; i++) {
    var searchInfo = searchTraces[i];
    traceSelection = searchInfo._module.selectPoints(searchInfo, selectionTesters);
    traceSelections.push(traceSelection);
    thisSelection = fillSelectionItem(traceSelection, searchInfo);
    allSelections = allSelections.concat(thisSelection);
  }
  return allSelections;
}
function reselect(gd, mayEmitSelected, selectionTesters, searchTraces, dragOptions) {
  var hadSearchTraces = !!searchTraces;
  var plotinfo, xRef, yRef;
  if (dragOptions) {
    plotinfo = dragOptions.plotinfo;
    xRef = dragOptions.xaxes[0]._id;
    yRef = dragOptions.yaxes[0]._id;
  }
  var allSelections = [];
  var allSearchTraces = [];

  // select layout.selection polygons
  var layoutPolygons = getLayoutPolygons(gd);

  // add draft outline polygons to layoutPolygons
  var fullLayout = gd._fullLayout;
  if (plotinfo) {
    var zoomLayer = fullLayout._zoomlayer;
    var mode = fullLayout.dragmode;
    var isDrawMode = drawMode(mode);
    var isSelectMode = selectMode(mode);
    if (isDrawMode || isSelectMode) {
      var xaxis = getFromId(gd, xRef, 'x');
      var yaxis = getFromId(gd, yRef, 'y');
      if (xaxis && yaxis) {
        var outlines = zoomLayer.selectAll('.select-outline-' + plotinfo.id);
        if (outlines && gd._fullLayout._outlining) {
          if (outlines.length) {
            var e = outlines[0][0]; // pick first
            var d = e.getAttribute('d');
            var outlinePolys = readPaths(d, gd, plotinfo);
            var draftPolygons = [];
            for (var u = 0; u < outlinePolys.length; u++) {
              var p = outlinePolys[u];
              var polygon = [];
              for (var t = 0; t < p.length; t++) {
                polygon.push([convert(xaxis, p[t][1]), convert(yaxis, p[t][2])]);
              }
              polygon.xref = xRef;
              polygon.yref = yRef;
              polygon.subtract = getSubtract(polygon, draftPolygons);
              draftPolygons.push(polygon);
            }
            layoutPolygons = layoutPolygons.concat(draftPolygons);
          }
        }
      }
    }
  }
  var subplots = xRef && yRef ? [xRef + yRef] : fullLayout._subplots.cartesian;
  epmtySplomSelectionBatch(gd);
  var seenSplom = {};
  for (var i = 0; i < subplots.length; i++) {
    var subplot = subplots[i];
    var yAt = subplot.indexOf('y');
    var _xRef = subplot.slice(0, yAt);
    var _yRef = subplot.slice(yAt);
    var _selectionTesters = xRef && yRef ? selectionTesters : undefined;
    _selectionTesters = addTester(layoutPolygons, _xRef, _yRef, _selectionTesters);
    if (_selectionTesters) {
      var _searchTraces = searchTraces;
      if (!hadSearchTraces) {
        var _xA = getFromId(gd, _xRef, 'x');
        var _yA = getFromId(gd, _yRef, 'y');
        _searchTraces = determineSearchTraces(gd, [_xA], [_yA], subplot);
        for (var w = 0; w < _searchTraces.length; w++) {
          var s = _searchTraces[w];
          var cd0 = s.cd[0];
          var trace = cd0.trace;
          if (s._module.name === 'scattergl' && !cd0.t.xpx) {
            var x = trace.x;
            var y = trace.y;
            var len = trace._length;
            // generate stash for scattergl
            cd0.t.xpx = [];
            cd0.t.ypx = [];
            for (var j = 0; j < len; j++) {
              cd0.t.xpx[j] = _xA.c2p(x[j]);
              cd0.t.ypx[j] = _yA.c2p(y[j]);
            }
          }
          if (s._module.name === 'splom') {
            if (!seenSplom[trace.uid]) {
              seenSplom[trace.uid] = true;
            }
          }
        }
      }
      var selection = _doSelect(_selectionTesters, _searchTraces);
      allSelections = allSelections.concat(selection);
      allSearchTraces = allSearchTraces.concat(_searchTraces);
    }
  }
  var eventData = {
    points: allSelections
  };
  updateSelectedState(gd, allSearchTraces, eventData);
  var clickmode = fullLayout.clickmode;
  var sendEvents = clickmode.indexOf('event') > -1 && mayEmitSelected;
  if (!plotinfo &&
  // get called from plot_api & plots
  mayEmitSelected) {
    var activePolygons = getLayoutPolygons(gd, true);
    if (activePolygons.length) {
      var xref = activePolygons[0].xref;
      var yref = activePolygons[0].yref;
      if (xref && yref) {
        var poly = castMultiPolygon(activePolygons);
        var fillRangeItems = makeFillRangeItems([getFromId(gd, xref, 'x'), getFromId(gd, yref, 'y')]);
        fillRangeItems(eventData, poly);
      }
    }
    if (gd._fullLayout._noEmitSelectedAtStart) {
      gd._fullLayout._noEmitSelectedAtStart = false;
    } else {
      if (sendEvents) emitSelected(gd, eventData);
    }
    fullLayout._reselect = false;
  }
  if (!plotinfo &&
  // get called from plot_api & plots
  fullLayout._deselect) {
    var deselect = fullLayout._deselect;
    xRef = deselect.xref;
    yRef = deselect.yref;
    if (!subplotSelected(xRef, yRef, allSearchTraces)) {
      deselectSubplot(gd, xRef, yRef, searchTraces);
    }
    if (sendEvents) {
      if (eventData.points.length) {
        emitSelected(gd, eventData);
      } else {
        emitDeselect(gd);
      }
    }
    fullLayout._deselect = false;
  }
  return {
    eventData: eventData,
    selectionTesters: selectionTesters
  };
}
function epmtySplomSelectionBatch(gd) {
  var cd = gd.calcdata;
  if (!cd) return;
  for (var i = 0; i < cd.length; i++) {
    var cd0 = cd[i][0];
    var trace = cd0.trace;
    var splomScenes = gd._fullLayout._splomScenes;
    if (splomScenes) {
      var scene = splomScenes[trace.uid];
      if (scene) {
        scene.selectBatch = [];
      }
    }
  }
}
function subplotSelected(xRef, yRef, searchTraces) {
  for (var i = 0; i < searchTraces.length; i++) {
    var s = searchTraces[i];
    if (s.xaxis && s.xaxis._id === xRef && s.yaxis && s.yaxis._id === yRef) {
      return true;
    }
  }
  return false;
}
function deselectSubplot(gd, xRef, yRef, searchTraces) {
  searchTraces = determineSearchTraces(gd, [getFromId(gd, xRef, 'x')], [getFromId(gd, yRef, 'y')], xRef + yRef);
  for (var k = 0; k < searchTraces.length; k++) {
    var searchInfo = searchTraces[k];
    searchInfo._module.selectPoints(searchInfo, false);
  }
  updateSelectedState(gd, searchTraces);
}
function addTester(layoutPolygons, xRef, yRef, selectionTesters) {
  var mergedPolygons;
  for (var i = 0; i < layoutPolygons.length; i++) {
    var currentPolygon = layoutPolygons[i];
    if (xRef !== currentPolygon.xref || yRef !== currentPolygon.yref) continue;
    if (mergedPolygons) {
      var subtract = !!currentPolygon.subtract;
      mergedPolygons = mergePolygons(mergedPolygons, currentPolygon, subtract);
      selectionTesters = multiTester(mergedPolygons);
    } else {
      mergedPolygons = [currentPolygon];
      selectionTesters = polygonTester(currentPolygon);
    }
  }
  return selectionTesters;
}
function getLayoutPolygons(gd, onlyActiveOnes) {
  var allPolygons = [];
  var fullLayout = gd._fullLayout;
  var allSelections = fullLayout.selections;
  var len = allSelections.length;
  for (var i = 0; i < len; i++) {
    if (onlyActiveOnes && i !== fullLayout._activeSelectionIndex) continue;
    var selection = allSelections[i];
    if (!selection) continue;
    var xref = selection.xref;
    var yref = selection.yref;
    var xaxis = getFromId(gd, xref, 'x');
    var yaxis = getFromId(gd, yref, 'y');
    var xmin, xmax, ymin, ymax;
    var polygon;
    if (selection.type === 'rect') {
      polygon = [];
      var x0 = convert(xaxis, selection.x0);
      var x1 = convert(xaxis, selection.x1);
      var y0 = convert(yaxis, selection.y0);
      var y1 = convert(yaxis, selection.y1);
      polygon = [[x0, y0], [x0, y1], [x1, y1], [x1, y0]];
      xmin = Math.min(x0, x1);
      xmax = Math.max(x0, x1);
      ymin = Math.min(y0, y1);
      ymax = Math.max(y0, y1);
      polygon.xmin = xmin;
      polygon.xmax = xmax;
      polygon.ymin = ymin;
      polygon.ymax = ymax;
      polygon.xref = xref;
      polygon.yref = yref;
      polygon.subtract = false;
      polygon.isRect = true;
      allPolygons.push(polygon);
    } else if (selection.type === 'path') {
      var segments = selection.path.split('Z');
      var multiPolygons = [];
      for (var j = 0; j < segments.length; j++) {
        var path = segments[j];
        if (!path) continue;
        path += 'Z';
        var allX = shapeHelpers.extractPathCoords(path, shapeConstants.paramIsX, 'raw');
        var allY = shapeHelpers.extractPathCoords(path, shapeConstants.paramIsY, 'raw');
        xmin = Infinity;
        xmax = -Infinity;
        ymin = Infinity;
        ymax = -Infinity;
        polygon = [];
        for (var k = 0; k < allX.length; k++) {
          var x = convert(xaxis, allX[k]);
          var y = convert(yaxis, allY[k]);
          polygon.push([x, y]);
          xmin = Math.min(x, xmin);
          xmax = Math.max(x, xmax);
          ymin = Math.min(y, ymin);
          ymax = Math.max(y, ymax);
        }
        polygon.xmin = xmin;
        polygon.xmax = xmax;
        polygon.ymin = ymin;
        polygon.ymax = ymax;
        polygon.xref = xref;
        polygon.yref = yref;
        polygon.subtract = getSubtract(polygon, multiPolygons);
        multiPolygons.push(polygon);
        allPolygons.push(polygon);
      }
    }
  }
  return allPolygons;
}
function getSubtract(polygon, previousPolygons) {
  var subtract = false;
  for (var i = 0; i < previousPolygons.length; i++) {
    var previousPolygon = previousPolygons[i];

    // find out if a point of polygon is inside previous polygons
    for (var k = 0; k < polygon.length; k++) {
      if (pointInPolygon(polygon[k], previousPolygon)) {
        subtract = !subtract;
        break;
      }
    }
  }
  return subtract;
}
function convert(ax, d) {
  if (ax.type === 'date') d = d.replace('_', ' ');
  return ax.type === 'log' ? ax.c2p(d) : ax.r2p(d, null, ax.calendar);
}
function castMultiPolygon(allPolygons) {
  var len = allPolygons.length;

  // descibe multi polygons in one polygon
  var p = [];
  for (var i = 0; i < len; i++) {
    var polygon = allPolygons[i];
    p = p.concat(polygon);

    // add starting vertex to close
    // which indicates next polygon
    p = p.concat([polygon[0]]);
  }
  return computeRectAndRanges(p);
}
function computeRectAndRanges(poly) {
  poly.isRect = poly.length === 5 && poly[0][0] === poly[4][0] && poly[0][1] === poly[4][1] && poly[0][0] === poly[1][0] && poly[2][0] === poly[3][0] && poly[0][1] === poly[3][1] && poly[1][1] === poly[2][1] || poly[0][1] === poly[1][1] && poly[2][1] === poly[3][1] && poly[0][0] === poly[3][0] && poly[1][0] === poly[2][0];
  if (poly.isRect) {
    poly.xmin = Math.min(poly[0][0], poly[2][0]);
    poly.xmax = Math.max(poly[0][0], poly[2][0]);
    poly.ymin = Math.min(poly[0][1], poly[2][1]);
    poly.ymax = Math.max(poly[0][1], poly[2][1]);
  }
  return poly;
}
function makeFillRangeItems(allAxes) {
  return function (eventData, poly) {
    var range;
    var lassoPoints;
    for (var i = 0; i < allAxes.length; i++) {
      var ax = allAxes[i];
      var id = ax._id;
      var axLetter = id.charAt(0);
      if (poly.isRect) {
        if (!range) range = {};
        var min = poly[axLetter + 'min'];
        var max = poly[axLetter + 'max'];
        if (min !== undefined && max !== undefined) {
          range[id] = [p2r(ax, min), p2r(ax, max)].sort(ascending);
        }
      } else {
        if (!lassoPoints) lassoPoints = {};
        lassoPoints[id] = poly.map(axValue(ax));
      }
    }
    if (range) {
      eventData.range = range;
    }
    if (lassoPoints) {
      eventData.lassoPoints = lassoPoints;
    }
  };
}
function getFillRangeItems(dragOptions) {
  var plotinfo = dragOptions.plotinfo;
  return plotinfo.fillRangeItems ||
  // allow subplots (i.e. geo, mapbox, sankey) to override fillRangeItems routine
  makeFillRangeItems(dragOptions.xaxes.concat(dragOptions.yaxes));
}
function emitSelecting(gd, eventData) {
  gd.emit('plotly_selecting', eventData);
}
function emitSelected(gd, eventData) {
  if (eventData) {
    eventData.selections = (gd.layout || {}).selections || [];
  }
  gd.emit('plotly_selected', eventData);
}
function emitDeselect(gd) {
  gd.emit('plotly_deselect', null);
}
module.exports = {
  reselect: reselect,
  prepSelect: prepSelect,
  clearOutline: clearOutline,
  clearSelectionsCache: clearSelectionsCache,
  selectOnClick: selectOnClick
};

/***/ }),

/***/ 6056:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var annAttrs = __webpack_require__(3916);
var fontAttrs = __webpack_require__(5376);
var scatterLineAttrs = (__webpack_require__(2904).line);
var dash = (__webpack_require__(8192)/* .dash */ .u);
var extendFlat = (__webpack_require__(2880).extendFlat);
var templatedArray = (__webpack_require__(1780).templatedArray);
var axisPlaceableObjs = __webpack_require__(6208);
var basePlotAttributes = __webpack_require__(5464);
var shapeTexttemplateAttrs = (__webpack_require__(1776)/* .shapeTexttemplateAttrs */ .ye);
var shapeLabelTexttemplateVars = __webpack_require__(7728);
module.exports = templatedArray('shape', {
  visible: extendFlat({}, basePlotAttributes.visible, {
    editType: 'calc+arraydraw'
  }),
  showlegend: {
    valType: 'boolean',
    dflt: false,
    editType: 'calc+arraydraw'
  },
  legend: extendFlat({}, basePlotAttributes.legend, {
    editType: 'calc+arraydraw'
  }),
  legendgroup: extendFlat({}, basePlotAttributes.legendgroup, {
    editType: 'calc+arraydraw'
  }),
  legendgrouptitle: {
    text: extendFlat({}, basePlotAttributes.legendgrouptitle.text, {
      editType: 'calc+arraydraw'
    }),
    font: fontAttrs({
      editType: 'calc+arraydraw'
    }),
    editType: 'calc+arraydraw'
  },
  legendrank: extendFlat({}, basePlotAttributes.legendrank, {
    editType: 'calc+arraydraw'
  }),
  legendwidth: extendFlat({}, basePlotAttributes.legendwidth, {
    editType: 'calc+arraydraw'
  }),
  type: {
    valType: 'enumerated',
    values: ['circle', 'rect', 'path', 'line'],
    editType: 'calc+arraydraw'
  },
  layer: {
    valType: 'enumerated',
    values: ['below', 'above', 'between'],
    dflt: 'above',
    editType: 'arraydraw'
  },
  xref: extendFlat({}, annAttrs.xref, {}),
  xsizemode: {
    valType: 'enumerated',
    values: ['scaled', 'pixel'],
    dflt: 'scaled',
    editType: 'calc+arraydraw'
  },
  xanchor: {
    valType: 'any',
    editType: 'calc+arraydraw'
  },
  x0: {
    valType: 'any',
    editType: 'calc+arraydraw'
  },
  x1: {
    valType: 'any',
    editType: 'calc+arraydraw'
  },
  yref: extendFlat({}, annAttrs.yref, {}),
  ysizemode: {
    valType: 'enumerated',
    values: ['scaled', 'pixel'],
    dflt: 'scaled',
    editType: 'calc+arraydraw'
  },
  yanchor: {
    valType: 'any',
    editType: 'calc+arraydraw'
  },
  y0: {
    valType: 'any',
    editType: 'calc+arraydraw'
  },
  y1: {
    valType: 'any',
    editType: 'calc+arraydraw'
  },
  path: {
    valType: 'string',
    editType: 'calc+arraydraw'
  },
  opacity: {
    valType: 'number',
    min: 0,
    max: 1,
    dflt: 1,
    editType: 'arraydraw'
  },
  line: {
    color: extendFlat({}, scatterLineAttrs.color, {
      editType: 'arraydraw'
    }),
    width: extendFlat({}, scatterLineAttrs.width, {
      editType: 'calc+arraydraw'
    }),
    dash: extendFlat({}, dash, {
      editType: 'arraydraw'
    }),
    editType: 'calc+arraydraw'
  },
  fillcolor: {
    valType: 'color',
    dflt: 'rgba(0,0,0,0)',
    editType: 'arraydraw'
  },
  fillrule: {
    valType: 'enumerated',
    values: ['evenodd', 'nonzero'],
    dflt: 'evenodd',
    editType: 'arraydraw'
  },
  editable: {
    valType: 'boolean',
    dflt: false,
    editType: 'calc+arraydraw'
  },
  label: {
    text: {
      valType: 'string',
      dflt: '',
      editType: 'arraydraw'
    },
    texttemplate: shapeTexttemplateAttrs({}, {
      keys: Object.keys(shapeLabelTexttemplateVars)
    }),
    font: fontAttrs({
      editType: 'calc+arraydraw',
      colorEditType: 'arraydraw'
    }),
    textposition: {
      valType: 'enumerated',
      values: ['top left', 'top center', 'top right', 'middle left', 'middle center', 'middle right', 'bottom left', 'bottom center', 'bottom right', 'start', 'middle', 'end'],
      editType: 'arraydraw'
    },
    textangle: {
      valType: 'angle',
      dflt: 'auto',
      editType: 'calc+arraydraw'
    },
    xanchor: {
      valType: 'enumerated',
      values: ['auto', 'left', 'center', 'right'],
      dflt: 'auto',
      editType: 'calc+arraydraw'
    },
    yanchor: {
      valType: 'enumerated',
      values: ['top', 'middle', 'bottom'],
      editType: 'calc+arraydraw'
    },
    padding: {
      valType: 'number',
      dflt: 3,
      min: 0,
      editType: 'arraydraw'
    },
    editType: 'arraydraw'
  },
  editType: 'arraydraw'
});

/***/ }),

/***/ 6084:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Axes = __webpack_require__(4460);
var constants = __webpack_require__(3068);
var helpers = __webpack_require__(5152);
module.exports = function calcAutorange(gd) {
  var fullLayout = gd._fullLayout;
  var shapeList = Lib.filterVisible(fullLayout.shapes);
  if (!shapeList.length || !gd._fullData.length) return;
  for (var i = 0; i < shapeList.length; i++) {
    var shape = shapeList[i];
    shape._extremes = {};
    var ax;
    var bounds;
    var xRefType = Axes.getRefType(shape.xref);
    var yRefType = Axes.getRefType(shape.yref);

    // paper and axis domain referenced shapes don't affect autorange
    if (shape.xref !== 'paper' && xRefType !== 'domain') {
      var vx0 = shape.xsizemode === 'pixel' ? shape.xanchor : shape.x0;
      var vx1 = shape.xsizemode === 'pixel' ? shape.xanchor : shape.x1;
      ax = Axes.getFromId(gd, shape.xref);
      bounds = shapeBounds(ax, vx0, vx1, shape.path, constants.paramIsX);
      if (bounds) {
        shape._extremes[ax._id] = Axes.findExtremes(ax, bounds, calcXPaddingOptions(shape));
      }
    }
    if (shape.yref !== 'paper' && yRefType !== 'domain') {
      var vy0 = shape.ysizemode === 'pixel' ? shape.yanchor : shape.y0;
      var vy1 = shape.ysizemode === 'pixel' ? shape.yanchor : shape.y1;
      ax = Axes.getFromId(gd, shape.yref);
      bounds = shapeBounds(ax, vy0, vy1, shape.path, constants.paramIsY);
      if (bounds) {
        shape._extremes[ax._id] = Axes.findExtremes(ax, bounds, calcYPaddingOptions(shape));
      }
    }
  }
};
function calcXPaddingOptions(shape) {
  return calcPaddingOptions(shape.line.width, shape.xsizemode, shape.x0, shape.x1, shape.path, false);
}
function calcYPaddingOptions(shape) {
  return calcPaddingOptions(shape.line.width, shape.ysizemode, shape.y0, shape.y1, shape.path, true);
}
function calcPaddingOptions(lineWidth, sizeMode, v0, v1, path, isYAxis) {
  var ppad = lineWidth / 2;
  var axisDirectionReverted = isYAxis;
  if (sizeMode === 'pixel') {
    var coords = path ? helpers.extractPathCoords(path, isYAxis ? constants.paramIsY : constants.paramIsX) : [v0, v1];
    var maxValue = Lib.aggNums(Math.max, null, coords);
    var minValue = Lib.aggNums(Math.min, null, coords);
    var beforePad = minValue < 0 ? Math.abs(minValue) + ppad : ppad;
    var afterPad = maxValue > 0 ? maxValue + ppad : ppad;
    return {
      ppad: ppad,
      ppadplus: axisDirectionReverted ? beforePad : afterPad,
      ppadminus: axisDirectionReverted ? afterPad : beforePad
    };
  } else {
    return {
      ppad: ppad
    };
  }
}
function shapeBounds(ax, v0, v1, path, paramsToUse) {
  var convertVal = ax.type === 'category' || ax.type === 'multicategory' ? ax.r2c : ax.d2c;
  if (v0 !== undefined) return [convertVal(v0), convertVal(v1)];
  if (!path) return;
  var min = Infinity;
  var max = -Infinity;
  var segments = path.match(constants.segmentRE);
  var i;
  var segment;
  var drawnParam;
  var params;
  var val;
  if (ax.type === 'date') convertVal = helpers.decodeDate(convertVal);
  for (i = 0; i < segments.length; i++) {
    segment = segments[i];
    drawnParam = paramsToUse[segment.charAt(0)].drawn;
    if (drawnParam === undefined) continue;
    params = segments[i].substr(1).match(constants.paramRE);
    if (!params || params.length < drawnParam) continue;
    val = convertVal(params[drawnParam]);
    if (val < min) min = val;
    if (val > max) max = val;
  }
  if (max >= min) return [min, max];
}

/***/ }),

/***/ 3068:
/***/ (function(module) {

"use strict";


module.exports = {
  segmentRE: /[MLHVQCTSZ][^MLHVQCTSZ]*/g,
  paramRE: /[^\s,]+/g,
  // which numbers in each path segment are x (or y) values
  // drawn is which param is a drawn point, as opposed to a
  // control point (which doesn't count toward autorange.
  // TODO: this means curved paths could extend beyond the
  // autorange bounds. This is a bit tricky to get right
  // unless we revert to bounding boxes, but perhaps there's
  // a calculation we could do...)
  paramIsX: {
    M: {
      0: true,
      drawn: 0
    },
    L: {
      0: true,
      drawn: 0
    },
    H: {
      0: true,
      drawn: 0
    },
    V: {},
    Q: {
      0: true,
      2: true,
      drawn: 2
    },
    C: {
      0: true,
      2: true,
      4: true,
      drawn: 4
    },
    T: {
      0: true,
      drawn: 0
    },
    S: {
      0: true,
      2: true,
      drawn: 2
    },
    // A: {0: true, 5: true},
    Z: {}
  },
  paramIsY: {
    M: {
      1: true,
      drawn: 1
    },
    L: {
      1: true,
      drawn: 1
    },
    H: {},
    V: {
      0: true,
      drawn: 0
    },
    Q: {
      1: true,
      3: true,
      drawn: 3
    },
    C: {
      1: true,
      3: true,
      5: true,
      drawn: 5
    },
    T: {
      1: true,
      drawn: 1
    },
    S: {
      1: true,
      3: true,
      drawn: 5
    },
    // A: {1: true, 6: true},
    Z: {}
  },
  numParams: {
    M: 2,
    L: 2,
    H: 1,
    V: 1,
    Q: 4,
    C: 6,
    T: 2,
    S: 4,
    // A: 7,
    Z: 0
  }
};

/***/ }),

/***/ 3712:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Axes = __webpack_require__(4460);
var handleArrayContainerDefaults = __webpack_require__(1272);
var attributes = __webpack_require__(6056);
var helpers = __webpack_require__(5152);
module.exports = function supplyLayoutDefaults(layoutIn, layoutOut) {
  handleArrayContainerDefaults(layoutIn, layoutOut, {
    name: 'shapes',
    handleItemDefaults: handleShapeDefaults
  });
};
function dfltLabelYanchor(isLine, labelTextPosition) {
  // If shape is a line, default y-anchor is 'bottom' (so that text is above line by default)
  // Otherwise, default y-anchor is equal to y-component of `textposition`
  // (so that text is positioned inside shape bounding box by default)
  return isLine ? 'bottom' : labelTextPosition.indexOf('top') !== -1 ? 'top' : labelTextPosition.indexOf('bottom') !== -1 ? 'bottom' : 'middle';
}
function handleShapeDefaults(shapeIn, shapeOut, fullLayout) {
  function coerce(attr, dflt) {
    return Lib.coerce(shapeIn, shapeOut, attributes, attr, dflt);
  }
  shapeOut._isShape = true;
  var visible = coerce('visible');
  if (!visible) return;
  var showlegend = coerce('showlegend');
  if (showlegend) {
    coerce('legend');
    coerce('legendwidth');
    coerce('legendgroup');
    coerce('legendgrouptitle.text');
    Lib.coerceFont(coerce, 'legendgrouptitle.font');
    coerce('legendrank');
  }
  var path = coerce('path');
  var dfltType = path ? 'path' : 'rect';
  var shapeType = coerce('type', dfltType);
  var noPath = shapeType !== 'path';
  if (noPath) delete shapeOut.path;
  coerce('editable');
  coerce('layer');
  coerce('opacity');
  coerce('fillcolor');
  coerce('fillrule');
  var lineWidth = coerce('line.width');
  if (lineWidth) {
    coerce('line.color');
    coerce('line.dash');
  }
  var xSizeMode = coerce('xsizemode');
  var ySizeMode = coerce('ysizemode');

  // positioning
  var axLetters = ['x', 'y'];
  for (var i = 0; i < 2; i++) {
    var axLetter = axLetters[i];
    var attrAnchor = axLetter + 'anchor';
    var sizeMode = axLetter === 'x' ? xSizeMode : ySizeMode;
    var gdMock = {
      _fullLayout: fullLayout
    };
    var ax;
    var pos2r;
    var r2pos;

    // xref, yref
    var axRef = Axes.coerceRef(shapeIn, shapeOut, gdMock, axLetter, undefined, 'paper');
    var axRefType = Axes.getRefType(axRef);
    if (axRefType === 'range') {
      ax = Axes.getFromId(gdMock, axRef);
      ax._shapeIndices.push(shapeOut._index);
      r2pos = helpers.rangeToShapePosition(ax);
      pos2r = helpers.shapePositionToRange(ax);
    } else {
      pos2r = r2pos = Lib.identity;
    }

    // Coerce x0, x1, y0, y1
    if (noPath) {
      var dflt0 = 0.25;
      var dflt1 = 0.75;

      // hack until V3.0 when log has regular range behavior - make it look like other
      // ranges to send to coerce, then put it back after
      // this is all to give reasonable default position behavior on log axes, which is
      // a pretty unimportant edge case so we could just ignore this.
      var attr0 = axLetter + '0';
      var attr1 = axLetter + '1';
      var in0 = shapeIn[attr0];
      var in1 = shapeIn[attr1];
      shapeIn[attr0] = pos2r(shapeIn[attr0], true);
      shapeIn[attr1] = pos2r(shapeIn[attr1], true);
      if (sizeMode === 'pixel') {
        coerce(attr0, 0);
        coerce(attr1, 10);
      } else {
        Axes.coercePosition(shapeOut, gdMock, coerce, axRef, attr0, dflt0);
        Axes.coercePosition(shapeOut, gdMock, coerce, axRef, attr1, dflt1);
      }

      // hack part 2
      shapeOut[attr0] = r2pos(shapeOut[attr0]);
      shapeOut[attr1] = r2pos(shapeOut[attr1]);
      shapeIn[attr0] = in0;
      shapeIn[attr1] = in1;
    }

    // Coerce xanchor and yanchor
    if (sizeMode === 'pixel') {
      // Hack for log axis described above
      var inAnchor = shapeIn[attrAnchor];
      shapeIn[attrAnchor] = pos2r(shapeIn[attrAnchor], true);
      Axes.coercePosition(shapeOut, gdMock, coerce, axRef, attrAnchor, 0.25);

      // Hack part 2
      shapeOut[attrAnchor] = r2pos(shapeOut[attrAnchor]);
      shapeIn[attrAnchor] = inAnchor;
    }
  }
  if (noPath) {
    Lib.noneOrAll(shapeIn, shapeOut, ['x0', 'x1', 'y0', 'y1']);
  }

  // Label options
  var isLine = shapeType === 'line';
  var labelTextTemplate, labelText;
  if (noPath) {
    labelTextTemplate = coerce('label.texttemplate');
  }
  if (!labelTextTemplate) {
    labelText = coerce('label.text');
  }
  if (labelText || labelTextTemplate) {
    coerce('label.textangle');
    var labelTextPosition = coerce('label.textposition', isLine ? 'middle' : 'middle center');
    coerce('label.xanchor');
    coerce('label.yanchor', dfltLabelYanchor(isLine, labelTextPosition));
    coerce('label.padding');
    Lib.coerceFont(coerce, 'label.font', fullLayout.font);
  }
}

/***/ }),

/***/ 728:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var Axes = __webpack_require__(4460);
var svgTextUtils = __webpack_require__(2736);
var Drawing = __webpack_require__(3616);
var readPaths = (__webpack_require__(9856).readPaths);
var helpers = __webpack_require__(5152);
var getPathString = helpers.getPathString;
var shapeLabelTexttemplateVars = __webpack_require__(7728);
var FROM_TL = (__webpack_require__(4284).FROM_TL);
module.exports = function drawLabel(gd, index, options, shapeGroup) {
  // Remove existing label
  shapeGroup.selectAll('.shape-label').remove();

  // If no label text or texttemplate, return
  if (!(options.label.text || options.label.texttemplate)) return;

  // Text template overrides text
  var text;
  if (options.label.texttemplate) {
    var templateValues = {};
    if (options.type !== 'path') {
      var _xa = Axes.getFromId(gd, options.xref);
      var _ya = Axes.getFromId(gd, options.yref);
      for (var key in shapeLabelTexttemplateVars) {
        var val = shapeLabelTexttemplateVars[key](options, _xa, _ya);
        if (val !== undefined) templateValues[key] = val;
      }
    }
    text = Lib.texttemplateStringForShapes(options.label.texttemplate, {}, gd._fullLayout._d3locale, templateValues);
  } else {
    text = options.label.text;
  }
  var labelGroupAttrs = {
    'data-index': index
  };
  var font = options.label.font;
  var labelTextAttrs = {
    'data-notex': 1
  };
  var labelGroup = shapeGroup.append('g').attr(labelGroupAttrs).classed('shape-label', true);
  var labelText = labelGroup.append('text').attr(labelTextAttrs).classed('shape-label-text', true).text(text);

  // Get x and y bounds of shape
  var shapex0, shapex1, shapey0, shapey1;
  if (options.path) {
    // If shape is defined as a path, get the
    // min and max bounds across all polygons in path
    var d = getPathString(gd, options);
    var polygons = readPaths(d, gd);
    shapex0 = Infinity;
    shapey0 = Infinity;
    shapex1 = -Infinity;
    shapey1 = -Infinity;
    for (var i = 0; i < polygons.length; i++) {
      for (var j = 0; j < polygons[i].length; j++) {
        var p = polygons[i][j];
        for (var k = 1; k < p.length; k += 2) {
          var _x = p[k];
          var _y = p[k + 1];
          shapex0 = Math.min(shapex0, _x);
          shapex1 = Math.max(shapex1, _x);
          shapey0 = Math.min(shapey0, _y);
          shapey1 = Math.max(shapey1, _y);
        }
      }
    }
  } else {
    // Otherwise, we use the x and y bounds defined in the shape options
    // and convert them to pixel coordinates
    // Setup conversion functions
    var xa = Axes.getFromId(gd, options.xref);
    var xRefType = Axes.getRefType(options.xref);
    var ya = Axes.getFromId(gd, options.yref);
    var yRefType = Axes.getRefType(options.yref);
    var x2p = helpers.getDataToPixel(gd, xa, false, xRefType);
    var y2p = helpers.getDataToPixel(gd, ya, true, yRefType);
    shapex0 = x2p(options.x0);
    shapex1 = x2p(options.x1);
    shapey0 = y2p(options.y0);
    shapey1 = y2p(options.y1);
  }

  // Handle `auto` angle
  var textangle = options.label.textangle;
  if (textangle === 'auto') {
    if (options.type === 'line') {
      // Auto angle for line is same angle as line
      textangle = calcTextAngle(shapex0, shapey0, shapex1, shapey1);
    } else {
      // Auto angle for all other shapes is 0
      textangle = 0;
    }
  }

  // Do an initial render so we can get the text bounding box height
  labelText.call(function (s) {
    s.call(Drawing.font, font).attr({});
    svgTextUtils.convertToTspans(s, gd);
    return s;
  });
  var textBB = Drawing.bBox(labelText.node());

  // Calculate correct (x,y) for text
  // We also determine true xanchor since xanchor depends on position when set to 'auto'
  var textPos = calcTextPosition(shapex0, shapey0, shapex1, shapey1, options, textangle, textBB);
  var textx = textPos.textx;
  var texty = textPos.texty;
  var xanchor = textPos.xanchor;

  // Update (x,y) position, xanchor, and angle
  labelText.attr({
    'text-anchor': {
      left: 'start',
      center: 'middle',
      right: 'end'
    }[xanchor],
    y: texty,
    x: textx,
    transform: 'rotate(' + textangle + ',' + textx + ',' + texty + ')'
  }).call(svgTextUtils.positionText, textx, texty);
};
function calcTextAngle(shapex0, shapey0, shapex1, shapey1) {
  var dy, dx;
  dx = Math.abs(shapex1 - shapex0);
  if (shapex1 >= shapex0) {
    dy = shapey0 - shapey1;
  } else {
    dy = shapey1 - shapey0;
  }
  return -180 / Math.PI * Math.atan2(dy, dx);
}
function calcTextPosition(shapex0, shapey0, shapex1, shapey1, shapeOptions, actualTextAngle, textBB) {
  var textPosition = shapeOptions.label.textposition;
  var textAngle = shapeOptions.label.textangle;
  var textPadding = shapeOptions.label.padding;
  var shapeType = shapeOptions.type;
  var textAngleRad = Math.PI / 180 * actualTextAngle;
  var sinA = Math.sin(textAngleRad);
  var cosA = Math.cos(textAngleRad);
  var xanchor = shapeOptions.label.xanchor;
  var yanchor = shapeOptions.label.yanchor;
  var textx, texty, paddingX, paddingY;

  // Text position functions differently for lines vs. other shapes
  if (shapeType === 'line') {
    // Set base position for start vs. center vs. end of line (default is 'center')
    if (textPosition === 'start') {
      textx = shapex0;
      texty = shapey0;
    } else if (textPosition === 'end') {
      textx = shapex1;
      texty = shapey1;
    } else {
      // Default: center
      textx = (shapex0 + shapex1) / 2;
      texty = (shapey0 + shapey1) / 2;
    }

    // Set xanchor if xanchor is 'auto'
    if (xanchor === 'auto') {
      if (textPosition === 'start') {
        if (textAngle === 'auto') {
          if (shapex1 > shapex0) xanchor = 'left';else if (shapex1 < shapex0) xanchor = 'right';else xanchor = 'center';
        } else {
          if (shapex1 > shapex0) xanchor = 'right';else if (shapex1 < shapex0) xanchor = 'left';else xanchor = 'center';
        }
      } else if (textPosition === 'end') {
        if (textAngle === 'auto') {
          if (shapex1 > shapex0) xanchor = 'right';else if (shapex1 < shapex0) xanchor = 'left';else xanchor = 'center';
        } else {
          if (shapex1 > shapex0) xanchor = 'left';else if (shapex1 < shapex0) xanchor = 'right';else xanchor = 'center';
        }
      } else {
        xanchor = 'center';
      }
    }

    // Special case for padding when angle is 'auto' for lines
    // Padding should be treated as an orthogonal offset in this case
    // Otherwise, padding is just a simple x and y offset
    var paddingConstantsX = {
      left: 1,
      center: 0,
      right: -1
    };
    var paddingConstantsY = {
      bottom: -1,
      middle: 0,
      top: 1
    };
    if (textAngle === 'auto') {
      // Set direction to apply padding (based on `yanchor` only)
      var paddingDirection = paddingConstantsY[yanchor];
      paddingX = -textPadding * sinA * paddingDirection;
      paddingY = textPadding * cosA * paddingDirection;
    } else {
      // Set direction to apply padding (based on `xanchor` and `yanchor`)
      var paddingDirectionX = paddingConstantsX[xanchor];
      var paddingDirectionY = paddingConstantsY[yanchor];
      paddingX = textPadding * paddingDirectionX;
      paddingY = textPadding * paddingDirectionY;
    }
    textx = textx + paddingX;
    texty = texty + paddingY;
  } else {
    // Text position for shapes that are not lines
    // calc horizontal position
    // Horizontal needs a little extra padding to look balanced
    paddingX = textPadding + 3;
    if (textPosition.indexOf('right') !== -1) {
      textx = Math.max(shapex0, shapex1) - paddingX;
      if (xanchor === 'auto') xanchor = 'right';
    } else if (textPosition.indexOf('left') !== -1) {
      textx = Math.min(shapex0, shapex1) + paddingX;
      if (xanchor === 'auto') xanchor = 'left';
    } else {
      // Default: center
      textx = (shapex0 + shapex1) / 2;
      if (xanchor === 'auto') xanchor = 'center';
    }

    // calc vertical position
    if (textPosition.indexOf('top') !== -1) {
      texty = Math.min(shapey0, shapey1);
    } else if (textPosition.indexOf('bottom') !== -1) {
      texty = Math.max(shapey0, shapey1);
    } else {
      texty = (shapey0 + shapey1) / 2;
    }
    // Apply padding
    paddingY = textPadding;
    if (yanchor === 'bottom') {
      texty = texty - paddingY;
    } else if (yanchor === 'top') {
      texty = texty + paddingY;
    }
  }

  // Shift vertical (& horizontal) position according to `yanchor`
  var shiftFraction = FROM_TL[yanchor];
  // Adjust so that text is anchored at top of first line rather than at baseline of first line
  var baselineAdjust = shapeOptions.label.font.size;
  var textHeight = textBB.height;
  var xshift = (textHeight * shiftFraction - baselineAdjust) * sinA;
  var yshift = -(textHeight * shiftFraction - baselineAdjust) * cosA;
  return {
    textx: textx + xshift,
    texty: texty + yshift,
    xanchor: xanchor
  };
}

/***/ }),

/***/ 5496:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var strTranslate = Lib.strTranslate;
var dragElement = __webpack_require__(6476);
var dragHelpers = __webpack_require__(2760);
var drawMode = dragHelpers.drawMode;
var selectMode = dragHelpers.selectMode;
var Registry = __webpack_require__(4040);
var Color = __webpack_require__(6308);
var constants = __webpack_require__(7000);
var i000 = constants.i000;
var i090 = constants.i090;
var i180 = constants.i180;
var i270 = constants.i270;
var handleOutline = __webpack_require__(1936);
var clearOutlineControllers = handleOutline.clearOutlineControllers;
var helpers = __webpack_require__(9856);
var pointsOnRectangle = helpers.pointsOnRectangle;
var pointsOnEllipse = helpers.pointsOnEllipse;
var writePaths = helpers.writePaths;
var newShapes = (__webpack_require__(3940).newShapes);
var createShapeObj = (__webpack_require__(3940).createShapeObj);
var newSelections = __webpack_require__(5968);
var drawLabel = __webpack_require__(728);
module.exports = function displayOutlines(polygons, outlines, dragOptions, nCalls) {
  if (!nCalls) nCalls = 0;
  var gd = dragOptions.gd;
  function redraw() {
    // recursive call
    displayOutlines(polygons, outlines, dragOptions, nCalls++);
    if (pointsOnEllipse(polygons[0]) || dragOptions.hasText) {
      update({
        redrawing: true
      });
    }
  }
  function update(opts) {
    var updateObject = {};
    if (dragOptions.isActiveShape !== undefined) {
      dragOptions.isActiveShape = false; // i.e. to disable shape controllers
      updateObject = newShapes(outlines, dragOptions);
    }
    if (dragOptions.isActiveSelection !== undefined) {
      dragOptions.isActiveSelection = false; // i.e. to disable selection controllers
      updateObject = newSelections(outlines, dragOptions);
      gd._fullLayout._reselect = true;
    }
    if (Object.keys(updateObject).length) {
      Registry.call((opts || {}).redrawing ? 'relayout' : '_guiRelayout', gd, updateObject);
    }
  }
  var fullLayout = gd._fullLayout;
  var zoomLayer = fullLayout._zoomlayer;
  var dragmode = dragOptions.dragmode;
  var isDrawMode = drawMode(dragmode);
  var isSelectMode = selectMode(dragmode);
  if (isDrawMode || isSelectMode) {
    gd._fullLayout._outlining = true;
  }
  clearOutlineControllers(gd);

  // make outline
  outlines.attr('d', writePaths(polygons));

  // add controllers
  var vertexDragOptions;
  var groupDragOptions;
  var indexI; // cell index
  var indexJ; // vertex or cell-controller index
  var copyPolygons;
  if (!nCalls && (dragOptions.isActiveShape || dragOptions.isActiveSelection)) {
    copyPolygons = recordPositions([], polygons);
    var g = zoomLayer.append('g').attr('class', 'outline-controllers');
    addVertexControllers(g);
    addGroupControllers();
  }

  // draw label
  if (isDrawMode && dragOptions.hasText) {
    var shapeGroup = zoomLayer.select('.label-temp');
    var shapeOptions = createShapeObj(outlines, dragOptions, dragOptions.dragmode);
    drawLabel(gd, 'label-temp', shapeOptions, shapeGroup);
  }
  function startDragVertex(evt) {
    indexI = +evt.srcElement.getAttribute('data-i');
    indexJ = +evt.srcElement.getAttribute('data-j');
    vertexDragOptions[indexI][indexJ].moveFn = moveVertexController;
  }
  function moveVertexController(dx, dy) {
    if (!polygons.length) return;
    var x0 = copyPolygons[indexI][indexJ][1];
    var y0 = copyPolygons[indexI][indexJ][2];
    var cell = polygons[indexI];
    var len = cell.length;
    if (pointsOnRectangle(cell)) {
      var _dx = dx;
      var _dy = dy;
      if (dragOptions.isActiveSelection) {
        // handle an edge contoller for rect selections
        var nextPoint = getNextPoint(cell, indexJ);
        if (nextPoint[1] === cell[indexJ][1]) {
          // a vertical edge
          _dy = 0;
        } else {
          // a horizontal edge
          _dx = 0;
        }
      }
      for (var q = 0; q < len; q++) {
        if (q === indexJ) continue;

        // move other corners of rectangle
        var pos = cell[q];
        if (pos[1] === cell[indexJ][1]) {
          pos[1] = x0 + _dx;
        }
        if (pos[2] === cell[indexJ][2]) {
          pos[2] = y0 + _dy;
        }
      }
      // move the corner
      cell[indexJ][1] = x0 + _dx;
      cell[indexJ][2] = y0 + _dy;
      if (!pointsOnRectangle(cell)) {
        // reject result to rectangles with ensure areas
        for (var j = 0; j < len; j++) {
          for (var k = 0; k < cell[j].length; k++) {
            cell[j][k] = copyPolygons[indexI][j][k];
          }
        }
      }
    } else {
      // other polylines
      cell[indexJ][1] = x0 + dx;
      cell[indexJ][2] = y0 + dy;
    }
    redraw();
  }
  function endDragVertexController() {
    update();
  }
  function removeVertex() {
    if (!polygons.length) return;
    if (!polygons[indexI]) return;
    if (!polygons[indexI].length) return;
    var newPolygon = [];
    for (var j = 0; j < polygons[indexI].length; j++) {
      if (j !== indexJ) {
        newPolygon.push(polygons[indexI][j]);
      }
    }
    if (newPolygon.length > 1 && !(newPolygon.length === 2 && newPolygon[1][0] === 'Z')) {
      if (indexJ === 0) {
        newPolygon[0][0] = 'M';
      }
      polygons[indexI] = newPolygon;
      redraw();
      update();
    }
  }
  function clickVertexController(numClicks, evt) {
    if (numClicks === 2) {
      indexI = +evt.srcElement.getAttribute('data-i');
      indexJ = +evt.srcElement.getAttribute('data-j');
      var cell = polygons[indexI];
      if (!pointsOnRectangle(cell) && !pointsOnEllipse(cell)) {
        removeVertex();
      }
    }
  }
  function addVertexControllers(g) {
    vertexDragOptions = [];
    for (var i = 0; i < polygons.length; i++) {
      var cell = polygons[i];
      var onRect = pointsOnRectangle(cell);
      var onEllipse = !onRect && pointsOnEllipse(cell);
      vertexDragOptions[i] = [];
      var len = cell.length;
      for (var j = 0; j < len; j++) {
        if (cell[j][0] === 'Z') continue;
        if (onEllipse && j !== i000 && j !== i090 && j !== i180 && j !== i270) {
          continue;
        }
        var rectSelection = onRect && dragOptions.isActiveSelection;
        var nextPoint;
        if (rectSelection) nextPoint = getNextPoint(cell, j);
        var x = cell[j][1];
        var y = cell[j][2];
        var vertex = g.append(rectSelection ? 'rect' : 'circle').attr('data-i', i).attr('data-j', j).style({
          fill: Color.background,
          stroke: Color.defaultLine,
          'stroke-width': 1,
          'shape-rendering': 'crispEdges'
        });
        if (rectSelection) {
          // convert a vertex controller to an edge controller for rect selections
          var dx = nextPoint[1] - x;
          var dy = nextPoint[2] - y;
          var width = dy ? 5 : Math.max(Math.min(25, Math.abs(dx) - 5), 5);
          var height = dx ? 5 : Math.max(Math.min(25, Math.abs(dy) - 5), 5);
          vertex.classed(dy ? 'cursor-ew-resize' : 'cursor-ns-resize', true).attr('width', width).attr('height', height).attr('x', x - width / 2).attr('y', y - height / 2).attr('transform', strTranslate(dx / 2, dy / 2));
        } else {
          vertex.classed('cursor-grab', true).attr('r', 5).attr('cx', x).attr('cy', y);
        }
        vertexDragOptions[i][j] = {
          element: vertex.node(),
          gd: gd,
          prepFn: startDragVertex,
          doneFn: endDragVertexController,
          clickFn: clickVertexController
        };
        dragElement.init(vertexDragOptions[i][j]);
      }
    }
  }
  function moveGroup(dx, dy) {
    if (!polygons.length) return;
    for (var i = 0; i < polygons.length; i++) {
      for (var j = 0; j < polygons[i].length; j++) {
        for (var k = 0; k + 2 < polygons[i][j].length; k += 2) {
          polygons[i][j][k + 1] = copyPolygons[i][j][k + 1] + dx;
          polygons[i][j][k + 2] = copyPolygons[i][j][k + 2] + dy;
        }
      }
    }
  }
  function moveGroupController(dx, dy) {
    moveGroup(dx, dy);
    redraw();
  }
  function startDragGroupController(evt) {
    indexI = +evt.srcElement.getAttribute('data-i');
    if (!indexI) indexI = 0; // ensure non-existing move button get zero index

    groupDragOptions[indexI].moveFn = moveGroupController;
  }
  function endDragGroupController() {
    update();
  }
  function clickGroupController(numClicks) {
    if (numClicks === 2) {
      eraseActiveSelection(gd);
    }
  }
  function addGroupControllers() {
    groupDragOptions = [];
    if (!polygons.length) return;
    var i = 0;
    groupDragOptions[i] = {
      element: outlines[0][0],
      gd: gd,
      prepFn: startDragGroupController,
      doneFn: endDragGroupController,
      clickFn: clickGroupController
    };
    dragElement.init(groupDragOptions[i]);
  }
};
function recordPositions(polygonsOut, polygonsIn) {
  for (var i = 0; i < polygonsIn.length; i++) {
    var cell = polygonsIn[i];
    polygonsOut[i] = [];
    for (var j = 0; j < cell.length; j++) {
      polygonsOut[i][j] = [];
      for (var k = 0; k < cell[j].length; k++) {
        polygonsOut[i][j][k] = cell[j][k];
      }
    }
  }
  return polygonsOut;
}
function getNextPoint(cell, j) {
  var x = cell[j][1];
  var y = cell[j][2];
  var len = cell.length;
  var nextJ, nextX, nextY;
  nextJ = (j + 1) % len;
  nextX = cell[nextJ][1];
  nextY = cell[nextJ][2];

  // avoid potential double points (closing points)
  if (nextX === x && nextY === y) {
    nextJ = (j + 2) % len;
    nextX = cell[nextJ][1];
    nextY = cell[nextJ][2];
  }
  return [nextJ, nextX, nextY];
}
function eraseActiveSelection(gd) {
  // Do not allow removal of selections on other dragmodes.
  // This ensures the user could still double click to
  // deselect all trace.selectedpoints,
  // if that's what they wanted.
  // Also double click to zoom back won't result in
  // any surprising selection removal.
  if (!selectMode(gd._fullLayout.dragmode)) return;
  clearOutlineControllers(gd);
  var id = gd._fullLayout._activeSelectionIndex;
  var selections = (gd.layout || {}).selections || [];
  if (id < selections.length) {
    var list = [];
    for (var q = 0; q < selections.length; q++) {
      if (q !== id) {
        list.push(selections[q]);
      }
    }
    delete gd._fullLayout._activeSelectionIndex;
    var erasedSelection = gd._fullLayout.selections[id];
    gd._fullLayout._deselect = {
      xref: erasedSelection.xref,
      yref: erasedSelection.yref
    };
    Registry.call('_guiRelayout', gd, {
      selections: list
    });
  }
}

/***/ }),

/***/ 4016:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var Registry = __webpack_require__(4040);
var Lib = __webpack_require__(3400);
var Axes = __webpack_require__(4460);
var readPaths = (__webpack_require__(9856).readPaths);
var displayOutlines = __webpack_require__(5496);
var drawLabel = __webpack_require__(728);
var clearOutlineControllers = (__webpack_require__(1936).clearOutlineControllers);
var Color = __webpack_require__(6308);
var Drawing = __webpack_require__(3616);
var arrayEditor = (__webpack_require__(1780).arrayEditor);
var dragElement = __webpack_require__(6476);
var setCursor = __webpack_require__(3972);
var constants = __webpack_require__(3068);
var helpers = __webpack_require__(5152);
var getPathString = helpers.getPathString;

// Shapes are stored in gd.layout.shapes, an array of objects
// index can point to one item in this array,
//  or non-numeric to simply add a new one
//  or -1 to modify all existing
// opt can be the full options object, or one key (to be set to value)
//  or undefined to simply redraw
// if opt is blank, val can be 'add' or a full options object to add a new
//  annotation at that point in the array, or 'remove' to delete this one

module.exports = {
  draw: draw,
  drawOne: drawOne,
  eraseActiveShape: eraseActiveShape,
  drawLabel: drawLabel
};
function draw(gd) {
  var fullLayout = gd._fullLayout;

  // Remove previous shapes before drawing new in shapes in fullLayout.shapes
  fullLayout._shapeUpperLayer.selectAll('path').remove();
  fullLayout._shapeLowerLayer.selectAll('path').remove();
  fullLayout._shapeUpperLayer.selectAll('text').remove();
  fullLayout._shapeLowerLayer.selectAll('text').remove();
  for (var k in fullLayout._plots) {
    var shapelayer = fullLayout._plots[k].shapelayer;
    if (shapelayer) {
      shapelayer.selectAll('path').remove();
      shapelayer.selectAll('text').remove();
    }
  }
  for (var i = 0; i < fullLayout.shapes.length; i++) {
    if (fullLayout.shapes[i].visible === true) {
      drawOne(gd, i);
    }
  }

  // may need to resurrect this if we put text (LaTeX) in shapes
  // return Plots.previousPromises(gd);
}

function shouldSkipEdits(gd) {
  return !!gd._fullLayout._outlining;
}
function couldHaveActiveShape(gd) {
  // for now keep config.editable: true as it was before shape-drawing PR
  return !gd._context.edits.shapePosition;
}
function drawOne(gd, index) {
  // remove the existing shape if there is one.
  // because indices can change, we need to look in all shape layers
  gd._fullLayout._paperdiv.selectAll('.shapelayer [data-index="' + index + '"]').remove();
  var o = helpers.makeShapesOptionsAndPlotinfo(gd, index);
  var options = o.options;
  var plotinfo = o.plotinfo;

  // this shape is gone - quit now after deleting it
  // TODO: use d3 idioms instead of deleting and redrawing every time
  if (!options._input || options.visible !== true) return;
  if (options.layer === 'above') {
    drawShape(gd._fullLayout._shapeUpperLayer);
  } else if (options.xref === 'paper' || options.yref === 'paper') {
    drawShape(gd._fullLayout._shapeLowerLayer);
  } else if (options.layer === 'between') {
    drawShape(plotinfo.shapelayerBetween);
  } else {
    if (plotinfo._hadPlotinfo) {
      var mainPlot = plotinfo.mainplotinfo || plotinfo;
      drawShape(mainPlot.shapelayer);
    } else {
      // Fall back to _shapeLowerLayer in case the requested subplot doesn't exist.
      // This can happen if you reference the shape to an x / y axis combination
      // that doesn't have any data on it (and layer is below)
      drawShape(gd._fullLayout._shapeLowerLayer);
    }
  }
  function drawShape(shapeLayer) {
    var d = getPathString(gd, options);
    var attrs = {
      'data-index': index,
      'fill-rule': options.fillrule,
      d: d
    };
    var opacity = options.opacity;
    var fillColor = options.fillcolor;
    var lineColor = options.line.width ? options.line.color : 'rgba(0,0,0,0)';
    var lineWidth = options.line.width;
    var lineDash = options.line.dash;
    if (!lineWidth && options.editable === true) {
      // ensure invisible border to activate the shape
      lineWidth = 5;
      lineDash = 'solid';
    }
    var isOpen = d[d.length - 1] !== 'Z';
    var isActiveShape = couldHaveActiveShape(gd) && options.editable && gd._fullLayout._activeShapeIndex === index;
    if (isActiveShape) {
      fillColor = isOpen ? 'rgba(0,0,0,0)' : gd._fullLayout.activeshape.fillcolor;
      opacity = gd._fullLayout.activeshape.opacity;
    }
    var shapeGroup = shapeLayer.append('g').classed('shape-group', true).attr({
      'data-index': index
    });
    var path = shapeGroup.append('path').attr(attrs).style('opacity', opacity).call(Color.stroke, lineColor).call(Color.fill, fillColor).call(Drawing.dashLine, lineDash, lineWidth);
    setClipPath(shapeGroup, gd, options);

    // Draw or clear the label
    drawLabel(gd, index, options, shapeGroup);
    var editHelpers;
    if (isActiveShape || gd._context.edits.shapePosition) editHelpers = arrayEditor(gd.layout, 'shapes', options);
    if (isActiveShape) {
      path.style({
        cursor: 'move'
      });
      var dragOptions = {
        element: path.node(),
        plotinfo: plotinfo,
        gd: gd,
        editHelpers: editHelpers,
        hasText: options.label.text || options.label.texttemplate,
        isActiveShape: true // i.e. to enable controllers
      };

      var polygons = readPaths(d, gd);
      // display polygons on the screen
      displayOutlines(polygons, path, dragOptions);
    } else {
      if (gd._context.edits.shapePosition) {
        setupDragElement(gd, path, options, index, shapeLayer, editHelpers);
      } else if (options.editable === true) {
        path.style('pointer-events', isOpen || Color.opacity(fillColor) * opacity <= 0.5 ? 'stroke' : 'all');
      }
    }
    path.node().addEventListener('click', function () {
      return activateShape(gd, path);
    });
  }
}
function setClipPath(shapePath, gd, shapeOptions) {
  // note that for layer="below" the clipAxes can be different from the
  // subplot we're drawing this in. This could cause problems if the shape
  // spans two subplots. See https://github.com/plotly/plotly.js/issues/1452
  //
  // if axis is 'paper' or an axis with " domain" appended, then there is no
  // clip axis
  var clipAxes = (shapeOptions.xref + shapeOptions.yref).replace(/paper/g, '').replace(/[xyz][1-9]* *domain/g, '');
  Drawing.setClipUrl(shapePath, clipAxes ? 'clip' + gd._fullLayout._uid + clipAxes : null, gd);
}
function setupDragElement(gd, shapePath, shapeOptions, index, shapeLayer, editHelpers) {
  var MINWIDTH = 10;
  var MINHEIGHT = 10;
  var xPixelSized = shapeOptions.xsizemode === 'pixel';
  var yPixelSized = shapeOptions.ysizemode === 'pixel';
  var isLine = shapeOptions.type === 'line';
  var isPath = shapeOptions.type === 'path';
  var modifyItem = editHelpers.modifyItem;
  var x0, y0, x1, y1, xAnchor, yAnchor;
  var n0, s0, w0, e0, optN, optS, optW, optE;
  var pathIn;
  var shapeGroup = d3.select(shapePath.node().parentNode);

  // setup conversion functions
  var xa = Axes.getFromId(gd, shapeOptions.xref);
  var xRefType = Axes.getRefType(shapeOptions.xref);
  var ya = Axes.getFromId(gd, shapeOptions.yref);
  var yRefType = Axes.getRefType(shapeOptions.yref);
  var x2p = helpers.getDataToPixel(gd, xa, false, xRefType);
  var y2p = helpers.getDataToPixel(gd, ya, true, yRefType);
  var p2x = helpers.getPixelToData(gd, xa, false, xRefType);
  var p2y = helpers.getPixelToData(gd, ya, true, yRefType);
  var sensoryElement = obtainSensoryElement();
  var dragOptions = {
    element: sensoryElement.node(),
    gd: gd,
    prepFn: startDrag,
    doneFn: endDrag,
    clickFn: abortDrag
  };
  var dragMode;
  dragElement.init(dragOptions);
  sensoryElement.node().onmousemove = updateDragMode;
  function obtainSensoryElement() {
    return isLine ? createLineDragHandles() : shapePath;
  }
  function createLineDragHandles() {
    var minSensoryWidth = 10;
    var sensoryWidth = Math.max(shapeOptions.line.width, minSensoryWidth);

    // Helper shapes group
    // Note that by setting the `data-index` attr, it is ensured that
    // the helper group is purged in this modules `draw` function
    var g = shapeLayer.append('g').attr('data-index', index).attr('drag-helper', true);

    // Helper path for moving
    g.append('path').attr('d', shapePath.attr('d')).style({
      cursor: 'move',
      'stroke-width': sensoryWidth,
      'stroke-opacity': '0' // ensure not visible
    });

    // Helper circles for resizing
    var circleStyle = {
      'fill-opacity': '0' // ensure not visible
    };

    var circleRadius = Math.max(sensoryWidth / 2, minSensoryWidth);
    g.append('circle').attr({
      'data-line-point': 'start-point',
      cx: xPixelSized ? x2p(shapeOptions.xanchor) + shapeOptions.x0 : x2p(shapeOptions.x0),
      cy: yPixelSized ? y2p(shapeOptions.yanchor) - shapeOptions.y0 : y2p(shapeOptions.y0),
      r: circleRadius
    }).style(circleStyle).classed('cursor-grab', true);
    g.append('circle').attr({
      'data-line-point': 'end-point',
      cx: xPixelSized ? x2p(shapeOptions.xanchor) + shapeOptions.x1 : x2p(shapeOptions.x1),
      cy: yPixelSized ? y2p(shapeOptions.yanchor) - shapeOptions.y1 : y2p(shapeOptions.y1),
      r: circleRadius
    }).style(circleStyle).classed('cursor-grab', true);
    return g;
  }
  function updateDragMode(evt) {
    if (shouldSkipEdits(gd)) {
      dragMode = null;
      return;
    }
    if (isLine) {
      if (evt.target.tagName === 'path') {
        dragMode = 'move';
      } else {
        dragMode = evt.target.attributes['data-line-point'].value === 'start-point' ? 'resize-over-start-point' : 'resize-over-end-point';
      }
    } else {
      // element might not be on screen at time of setup,
      // so obtain bounding box here
      var dragBBox = dragOptions.element.getBoundingClientRect();

      // choose 'move' or 'resize'
      // based on initial position of cursor within the drag element
      var w = dragBBox.right - dragBBox.left;
      var h = dragBBox.bottom - dragBBox.top;
      var x = evt.clientX - dragBBox.left;
      var y = evt.clientY - dragBBox.top;
      var cursor = !isPath && w > MINWIDTH && h > MINHEIGHT && !evt.shiftKey ? dragElement.getCursor(x / w, 1 - y / h) : 'move';
      setCursor(shapePath, cursor);

      // possible values 'move', 'sw', 'w', 'se', 'e', 'ne', 'n', 'nw' and 'w'
      dragMode = cursor.split('-')[0];
    }
  }
  function startDrag(evt) {
    if (shouldSkipEdits(gd)) return;

    // setup update strings and initial values
    if (xPixelSized) {
      xAnchor = x2p(shapeOptions.xanchor);
    }
    if (yPixelSized) {
      yAnchor = y2p(shapeOptions.yanchor);
    }
    if (shapeOptions.type === 'path') {
      pathIn = shapeOptions.path;
    } else {
      x0 = xPixelSized ? shapeOptions.x0 : x2p(shapeOptions.x0);
      y0 = yPixelSized ? shapeOptions.y0 : y2p(shapeOptions.y0);
      x1 = xPixelSized ? shapeOptions.x1 : x2p(shapeOptions.x1);
      y1 = yPixelSized ? shapeOptions.y1 : y2p(shapeOptions.y1);
    }
    if (x0 < x1) {
      w0 = x0;
      optW = 'x0';
      e0 = x1;
      optE = 'x1';
    } else {
      w0 = x1;
      optW = 'x1';
      e0 = x0;
      optE = 'x0';
    }

    // For fixed size shapes take opposing direction of y-axis into account.
    // Hint: For data sized shapes this is done by the y2p function.
    if (!yPixelSized && y0 < y1 || yPixelSized && y0 > y1) {
      n0 = y0;
      optN = 'y0';
      s0 = y1;
      optS = 'y1';
    } else {
      n0 = y1;
      optN = 'y1';
      s0 = y0;
      optS = 'y0';
    }

    // setup dragMode and the corresponding handler
    updateDragMode(evt);
    renderVisualCues(shapeLayer, shapeOptions);
    deactivateClipPathTemporarily(shapePath, shapeOptions, gd);
    dragOptions.moveFn = dragMode === 'move' ? moveShape : resizeShape;
    dragOptions.altKey = evt.altKey;
  }
  function endDrag() {
    if (shouldSkipEdits(gd)) return;
    setCursor(shapePath);
    removeVisualCues(shapeLayer);

    // Don't rely on clipPath being activated during re-layout
    setClipPath(shapePath, gd, shapeOptions);
    Registry.call('_guiRelayout', gd, editHelpers.getUpdateObj());
  }
  function abortDrag() {
    if (shouldSkipEdits(gd)) return;
    removeVisualCues(shapeLayer);
  }
  function moveShape(dx, dy) {
    if (shapeOptions.type === 'path') {
      var noOp = function (coord) {
        return coord;
      };
      var moveX = noOp;
      var moveY = noOp;
      if (xPixelSized) {
        modifyItem('xanchor', shapeOptions.xanchor = p2x(xAnchor + dx));
      } else {
        moveX = function moveX(x) {
          return p2x(x2p(x) + dx);
        };
        if (xa && xa.type === 'date') moveX = helpers.encodeDate(moveX);
      }
      if (yPixelSized) {
        modifyItem('yanchor', shapeOptions.yanchor = p2y(yAnchor + dy));
      } else {
        moveY = function moveY(y) {
          return p2y(y2p(y) + dy);
        };
        if (ya && ya.type === 'date') moveY = helpers.encodeDate(moveY);
      }
      modifyItem('path', shapeOptions.path = movePath(pathIn, moveX, moveY));
    } else {
      if (xPixelSized) {
        modifyItem('xanchor', shapeOptions.xanchor = p2x(xAnchor + dx));
      } else {
        modifyItem('x0', shapeOptions.x0 = p2x(x0 + dx));
        modifyItem('x1', shapeOptions.x1 = p2x(x1 + dx));
      }
      if (yPixelSized) {
        modifyItem('yanchor', shapeOptions.yanchor = p2y(yAnchor + dy));
      } else {
        modifyItem('y0', shapeOptions.y0 = p2y(y0 + dy));
        modifyItem('y1', shapeOptions.y1 = p2y(y1 + dy));
      }
    }
    shapePath.attr('d', getPathString(gd, shapeOptions));
    renderVisualCues(shapeLayer, shapeOptions);
    drawLabel(gd, index, shapeOptions, shapeGroup);
  }
  function resizeShape(dx, dy) {
    if (isPath) {
      // TODO: implement path resize, don't forget to update dragMode code
      var noOp = function (coord) {
        return coord;
      };
      var moveX = noOp;
      var moveY = noOp;
      if (xPixelSized) {
        modifyItem('xanchor', shapeOptions.xanchor = p2x(xAnchor + dx));
      } else {
        moveX = function moveX(x) {
          return p2x(x2p(x) + dx);
        };
        if (xa && xa.type === 'date') moveX = helpers.encodeDate(moveX);
      }
      if (yPixelSized) {
        modifyItem('yanchor', shapeOptions.yanchor = p2y(yAnchor + dy));
      } else {
        moveY = function moveY(y) {
          return p2y(y2p(y) + dy);
        };
        if (ya && ya.type === 'date') moveY = helpers.encodeDate(moveY);
      }
      modifyItem('path', shapeOptions.path = movePath(pathIn, moveX, moveY));
    } else if (isLine) {
      if (dragMode === 'resize-over-start-point') {
        var newX0 = x0 + dx;
        var newY0 = yPixelSized ? y0 - dy : y0 + dy;
        modifyItem('x0', shapeOptions.x0 = xPixelSized ? newX0 : p2x(newX0));
        modifyItem('y0', shapeOptions.y0 = yPixelSized ? newY0 : p2y(newY0));
      } else if (dragMode === 'resize-over-end-point') {
        var newX1 = x1 + dx;
        var newY1 = yPixelSized ? y1 - dy : y1 + dy;
        modifyItem('x1', shapeOptions.x1 = xPixelSized ? newX1 : p2x(newX1));
        modifyItem('y1', shapeOptions.y1 = yPixelSized ? newY1 : p2y(newY1));
      }
    } else {
      var has = function (str) {
        return dragMode.indexOf(str) !== -1;
      };
      var hasN = has('n');
      var hasS = has('s');
      var hasW = has('w');
      var hasE = has('e');
      var newN = hasN ? n0 + dy : n0;
      var newS = hasS ? s0 + dy : s0;
      var newW = hasW ? w0 + dx : w0;
      var newE = hasE ? e0 + dx : e0;
      if (yPixelSized) {
        // Do things in opposing direction for y-axis.
        // Hint: for data-sized shapes the reversal of axis direction is done in p2y.
        if (hasN) newN = n0 - dy;
        if (hasS) newS = s0 - dy;
      }

      // Update shape eventually. Again, be aware of the
      // opposing direction of the y-axis of fixed size shapes.
      if (!yPixelSized && newS - newN > MINHEIGHT || yPixelSized && newN - newS > MINHEIGHT) {
        modifyItem(optN, shapeOptions[optN] = yPixelSized ? newN : p2y(newN));
        modifyItem(optS, shapeOptions[optS] = yPixelSized ? newS : p2y(newS));
      }
      if (newE - newW > MINWIDTH) {
        modifyItem(optW, shapeOptions[optW] = xPixelSized ? newW : p2x(newW));
        modifyItem(optE, shapeOptions[optE] = xPixelSized ? newE : p2x(newE));
      }
    }
    shapePath.attr('d', getPathString(gd, shapeOptions));
    renderVisualCues(shapeLayer, shapeOptions);
    drawLabel(gd, index, shapeOptions, shapeGroup);
  }
  function renderVisualCues(shapeLayer, shapeOptions) {
    if (xPixelSized || yPixelSized) {
      renderAnchor();
    }
    function renderAnchor() {
      var isNotPath = shapeOptions.type !== 'path';

      // d3 join with dummy data to satisfy d3 data-binding
      var visualCues = shapeLayer.selectAll('.visual-cue').data([0]);

      // Enter
      var strokeWidth = 1;
      visualCues.enter().append('path').attr({
        fill: '#fff',
        'fill-rule': 'evenodd',
        stroke: '#000',
        'stroke-width': strokeWidth
      }).classed('visual-cue', true);

      // Update
      var posX = x2p(xPixelSized ? shapeOptions.xanchor : Lib.midRange(isNotPath ? [shapeOptions.x0, shapeOptions.x1] : helpers.extractPathCoords(shapeOptions.path, constants.paramIsX)));
      var posY = y2p(yPixelSized ? shapeOptions.yanchor : Lib.midRange(isNotPath ? [shapeOptions.y0, shapeOptions.y1] : helpers.extractPathCoords(shapeOptions.path, constants.paramIsY)));
      posX = helpers.roundPositionForSharpStrokeRendering(posX, strokeWidth);
      posY = helpers.roundPositionForSharpStrokeRendering(posY, strokeWidth);
      if (xPixelSized && yPixelSized) {
        var crossPath = 'M' + (posX - 1 - strokeWidth) + ',' + (posY - 1 - strokeWidth) + 'h-8v2h8 v8h2v-8 h8v-2h-8 v-8h-2 Z';
        visualCues.attr('d', crossPath);
      } else if (xPixelSized) {
        var vBarPath = 'M' + (posX - 1 - strokeWidth) + ',' + (posY - 9 - strokeWidth) + 'v18 h2 v-18 Z';
        visualCues.attr('d', vBarPath);
      } else {
        var hBarPath = 'M' + (posX - 9 - strokeWidth) + ',' + (posY - 1 - strokeWidth) + 'h18 v2 h-18 Z';
        visualCues.attr('d', hBarPath);
      }
    }
  }
  function removeVisualCues(shapeLayer) {
    shapeLayer.selectAll('.visual-cue').remove();
  }
  function deactivateClipPathTemporarily(shapePath, shapeOptions, gd) {
    var xref = shapeOptions.xref;
    var yref = shapeOptions.yref;
    var xa = Axes.getFromId(gd, xref);
    var ya = Axes.getFromId(gd, yref);
    var clipAxes = '';
    if (xref !== 'paper' && !xa.autorange) clipAxes += xref;
    if (yref !== 'paper' && !ya.autorange) clipAxes += yref;
    Drawing.setClipUrl(shapePath, clipAxes ? 'clip' + gd._fullLayout._uid + clipAxes : null, gd);
  }
}
function movePath(pathIn, moveX, moveY) {
  return pathIn.replace(constants.segmentRE, function (segment) {
    var paramNumber = 0;
    var segmentType = segment.charAt(0);
    var xParams = constants.paramIsX[segmentType];
    var yParams = constants.paramIsY[segmentType];
    var nParams = constants.numParams[segmentType];
    var paramString = segment.substr(1).replace(constants.paramRE, function (param) {
      if (paramNumber >= nParams) return param;
      if (xParams[paramNumber]) param = moveX(param);else if (yParams[paramNumber]) param = moveY(param);
      paramNumber++;
      return param;
    });
    return segmentType + paramString;
  });
}
function activateShape(gd, path) {
  if (!couldHaveActiveShape(gd)) return;
  var element = path.node();
  var id = +element.getAttribute('data-index');
  if (id >= 0) {
    // deactivate if already active
    if (id === gd._fullLayout._activeShapeIndex) {
      deactivateShape(gd);
      return;
    }
    gd._fullLayout._activeShapeIndex = id;
    gd._fullLayout._deactivateShape = deactivateShape;
    draw(gd);
  }
}
function deactivateShape(gd) {
  if (!couldHaveActiveShape(gd)) return;
  var id = gd._fullLayout._activeShapeIndex;
  if (id >= 0) {
    clearOutlineControllers(gd);
    delete gd._fullLayout._activeShapeIndex;
    draw(gd);
  }
}
function eraseActiveShape(gd) {
  if (!couldHaveActiveShape(gd)) return;
  clearOutlineControllers(gd);
  var id = gd._fullLayout._activeShapeIndex;
  var shapes = (gd.layout || {}).shapes || [];
  if (id < shapes.length) {
    var list = [];
    for (var q = 0; q < shapes.length; q++) {
      if (q !== id) {
        list.push(shapes[q]);
      }
    }
    delete gd._fullLayout._activeShapeIndex;
    return Registry.call('_guiRelayout', gd, {
      shapes: list
    });
  }
}

/***/ }),

/***/ 2872:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var overrideAll = (__webpack_require__(7824).overrideAll);
var basePlotAttributes = __webpack_require__(5464);
var fontAttrs = __webpack_require__(5376);
var dash = (__webpack_require__(8192)/* .dash */ .u);
var extendFlat = (__webpack_require__(2880).extendFlat);
var shapeTexttemplateAttrs = (__webpack_require__(1776)/* .shapeTexttemplateAttrs */ .ye);
var shapeLabelTexttemplateVars = __webpack_require__(7728);
module.exports = overrideAll({
  newshape: {
    visible: extendFlat({}, basePlotAttributes.visible, {}),
    showlegend: {
      valType: 'boolean',
      dflt: false
    },
    legend: extendFlat({}, basePlotAttributes.legend, {}),
    legendgroup: extendFlat({}, basePlotAttributes.legendgroup, {}),
    legendgrouptitle: {
      text: extendFlat({}, basePlotAttributes.legendgrouptitle.text, {}),
      font: fontAttrs({})
    },
    legendrank: extendFlat({}, basePlotAttributes.legendrank, {}),
    legendwidth: extendFlat({}, basePlotAttributes.legendwidth, {}),
    line: {
      color: {
        valType: 'color'
      },
      width: {
        valType: 'number',
        min: 0,
        dflt: 4
      },
      dash: extendFlat({}, dash, {
        dflt: 'solid'
      })
    },
    fillcolor: {
      valType: 'color',
      dflt: 'rgba(0,0,0,0)'
    },
    fillrule: {
      valType: 'enumerated',
      values: ['evenodd', 'nonzero'],
      dflt: 'evenodd'
    },
    opacity: {
      valType: 'number',
      min: 0,
      max: 1,
      dflt: 1
    },
    layer: {
      valType: 'enumerated',
      values: ['below', 'above', 'between'],
      dflt: 'above'
    },
    drawdirection: {
      valType: 'enumerated',
      values: ['ortho', 'horizontal', 'vertical', 'diagonal'],
      dflt: 'diagonal'
    },
    name: extendFlat({}, basePlotAttributes.name, {}),
    label: {
      text: {
        valType: 'string',
        dflt: ''
      },
      texttemplate: shapeTexttemplateAttrs({
        newshape: true
      }, {
        keys: Object.keys(shapeLabelTexttemplateVars)
      }),
      font: fontAttrs({}),
      textposition: {
        valType: 'enumerated',
        values: ['top left', 'top center', 'top right', 'middle left', 'middle center', 'middle right', 'bottom left', 'bottom center', 'bottom right', 'start', 'middle', 'end']
      },
      textangle: {
        valType: 'angle',
        dflt: 'auto'
      },
      xanchor: {
        valType: 'enumerated',
        values: ['auto', 'left', 'center', 'right'],
        dflt: 'auto'
      },
      yanchor: {
        valType: 'enumerated',
        values: ['top', 'middle', 'bottom']
      },
      padding: {
        valType: 'number',
        dflt: 3,
        min: 0
      }
    }
  },
  activeshape: {
    fillcolor: {
      valType: 'color',
      dflt: 'rgb(255,0,255)'
    },
    opacity: {
      valType: 'number',
      min: 0,
      max: 1,
      dflt: 0.5
    }
  }
}, 'none', 'from-root');

/***/ }),

/***/ 7000:
/***/ (function(module) {

"use strict";


var CIRCLE_SIDES = 32; // should be divisible by 4

module.exports = {
  CIRCLE_SIDES: CIRCLE_SIDES,
  i000: 0,
  i090: CIRCLE_SIDES / 4,
  i180: CIRCLE_SIDES / 2,
  i270: CIRCLE_SIDES / 4 * 3,
  cos45: Math.cos(Math.PI / 4),
  sin45: Math.sin(Math.PI / 4),
  SQRT2: Math.sqrt(2)
};

/***/ }),

/***/ 5144:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Color = __webpack_require__(6308);
var Lib = __webpack_require__(3400);
function dfltLabelYanchor(isLine, labelTextPosition) {
  // If shape is a line, default y-anchor is 'bottom' (so that text is above line by default)
  // Otherwise, default y-anchor is equal to y-component of `textposition`
  // (so that text is positioned inside shape bounding box by default)
  return isLine ? 'bottom' : labelTextPosition.indexOf('top') !== -1 ? 'top' : labelTextPosition.indexOf('bottom') !== -1 ? 'bottom' : 'middle';
}
module.exports = function supplyDrawNewShapeDefaults(layoutIn, layoutOut, coerce) {
  coerce('newshape.visible');
  coerce('newshape.name');
  coerce('newshape.showlegend');
  coerce('newshape.legend');
  coerce('newshape.legendwidth');
  coerce('newshape.legendgroup');
  coerce('newshape.legendgrouptitle.text');
  Lib.coerceFont(coerce, 'newshape.legendgrouptitle.font');
  coerce('newshape.legendrank');
  coerce('newshape.drawdirection');
  coerce('newshape.layer');
  coerce('newshape.fillcolor');
  coerce('newshape.fillrule');
  coerce('newshape.opacity');
  var newshapeLineWidth = coerce('newshape.line.width');
  if (newshapeLineWidth) {
    var bgcolor = (layoutIn || {}).plot_bgcolor || '#FFF';
    coerce('newshape.line.color', Color.contrast(bgcolor));
    coerce('newshape.line.dash');
  }
  var isLine = layoutIn.dragmode === 'drawline';
  var labelText = coerce('newshape.label.text');
  var labelTextTemplate = coerce('newshape.label.texttemplate');
  if (labelText || labelTextTemplate) {
    coerce('newshape.label.textangle');
    var labelTextPosition = coerce('newshape.label.textposition', isLine ? 'middle' : 'middle center');
    coerce('newshape.label.xanchor');
    coerce('newshape.label.yanchor', dfltLabelYanchor(isLine, labelTextPosition));
    coerce('newshape.label.padding');
    Lib.coerceFont(coerce, 'newshape.label.font', layoutOut.font);
  }
  coerce('activeshape.fillcolor');
  coerce('activeshape.opacity');
};

/***/ }),

/***/ 9856:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var parseSvgPath = __webpack_require__(9604);
var constants = __webpack_require__(7000);
var CIRCLE_SIDES = constants.CIRCLE_SIDES;
var SQRT2 = constants.SQRT2;
var cartesianHelpers = __webpack_require__(5840);
var p2r = cartesianHelpers.p2r;
var r2p = cartesianHelpers.r2p;
var iC = [0, 3, 4, 5, 6, 1, 2];
var iQS = [0, 3, 4, 1, 2];
exports.writePaths = function (polygons) {
  var nI = polygons.length;
  if (!nI) return 'M0,0Z';
  var str = '';
  for (var i = 0; i < nI; i++) {
    var nJ = polygons[i].length;
    for (var j = 0; j < nJ; j++) {
      var w = polygons[i][j][0];
      if (w === 'Z') {
        str += 'Z';
      } else {
        var nK = polygons[i][j].length;
        for (var k = 0; k < nK; k++) {
          var realK = k;
          if (w === 'Q' || w === 'S') {
            realK = iQS[k];
          } else if (w === 'C') {
            realK = iC[k];
          }
          str += polygons[i][j][realK];
          if (k > 0 && k < nK - 1) {
            str += ',';
          }
        }
      }
    }
  }
  return str;
};
exports.readPaths = function (str, gd, plotinfo, isActiveShape) {
  var cmd = parseSvgPath(str);
  var polys = [];
  var n = -1;
  var newPoly = function () {
    n++;
    polys[n] = [];
  };
  var k;
  var x = 0;
  var y = 0;
  var initX;
  var initY;
  var recStart = function () {
    initX = x;
    initY = y;
  };
  recStart();
  for (var i = 0; i < cmd.length; i++) {
    var newPos = [];
    var x1, x2, y1, y2; // i.e. extra params for curves

    var c = cmd[i][0];
    var w = c;
    switch (c) {
      case 'M':
        newPoly();
        x = +cmd[i][1];
        y = +cmd[i][2];
        newPos.push([w, x, y]);
        recStart();
        break;
      case 'Q':
      case 'S':
        x1 = +cmd[i][1];
        y1 = +cmd[i][2];
        x = +cmd[i][3];
        y = +cmd[i][4];
        newPos.push([w, x, y, x1, y1]); // -> iQS order
        break;
      case 'C':
        x1 = +cmd[i][1];
        y1 = +cmd[i][2];
        x2 = +cmd[i][3];
        y2 = +cmd[i][4];
        x = +cmd[i][5];
        y = +cmd[i][6];
        newPos.push([w, x, y, x1, y1, x2, y2]); // -> iC order
        break;
      case 'T':
      case 'L':
        x = +cmd[i][1];
        y = +cmd[i][2];
        newPos.push([w, x, y]);
        break;
      case 'H':
        w = 'L'; // convert to line (for now)
        x = +cmd[i][1];
        newPos.push([w, x, y]);
        break;
      case 'V':
        w = 'L'; // convert to line (for now)
        y = +cmd[i][1];
        newPos.push([w, x, y]);
        break;
      case 'A':
        w = 'L'; // convert to line to handle circle
        var rx = +cmd[i][1];
        var ry = +cmd[i][2];
        if (!+cmd[i][4]) {
          rx = -rx;
          ry = -ry;
        }
        var cenX = x - rx;
        var cenY = y;
        for (k = 1; k <= CIRCLE_SIDES / 2; k++) {
          var t = 2 * Math.PI * k / CIRCLE_SIDES;
          newPos.push([w, cenX + rx * Math.cos(t), cenY + ry * Math.sin(t)]);
        }
        break;
      case 'Z':
        if (x !== initX || y !== initY) {
          x = initX;
          y = initY;
          newPos.push([w, x, y]);
        }
        break;
    }
    var domain = (plotinfo || {}).domain;
    var size = gd._fullLayout._size;
    var xPixelSized = plotinfo && plotinfo.xsizemode === 'pixel';
    var yPixelSized = plotinfo && plotinfo.ysizemode === 'pixel';
    var noOffset = isActiveShape === false;
    for (var j = 0; j < newPos.length; j++) {
      for (k = 0; k + 2 < 7; k += 2) {
        var _x = newPos[j][k + 1];
        var _y = newPos[j][k + 2];
        if (_x === undefined || _y === undefined) continue;
        // keep track of end point for Z
        x = _x;
        y = _y;
        if (plotinfo) {
          if (plotinfo.xaxis && plotinfo.xaxis.p2r) {
            if (noOffset) _x -= plotinfo.xaxis._offset;
            if (xPixelSized) {
              _x = r2p(plotinfo.xaxis, plotinfo.xanchor) + _x;
            } else {
              _x = p2r(plotinfo.xaxis, _x);
            }
          } else {
            if (noOffset) _x -= size.l;
            if (domain) _x = domain.x[0] + _x / size.w;else _x = _x / size.w;
          }
          if (plotinfo.yaxis && plotinfo.yaxis.p2r) {
            if (noOffset) _y -= plotinfo.yaxis._offset;
            if (yPixelSized) {
              _y = r2p(plotinfo.yaxis, plotinfo.yanchor) - _y;
            } else {
              _y = p2r(plotinfo.yaxis, _y);
            }
          } else {
            if (noOffset) _y -= size.t;
            if (domain) _y = domain.y[1] - _y / size.h;else _y = 1 - _y / size.h;
          }
        }
        newPos[j][k + 1] = _x;
        newPos[j][k + 2] = _y;
      }
      polys[n].push(newPos[j].slice());
    }
  }
  return polys;
};
function almostEq(a, b) {
  return Math.abs(a - b) <= 1e-6;
}
function dist(a, b) {
  var dx = b[1] - a[1];
  var dy = b[2] - a[2];
  return Math.sqrt(dx * dx + dy * dy);
}
exports.pointsOnRectangle = function (cell) {
  var len = cell.length;
  if (len !== 5) return false;
  for (var j = 1; j < 3; j++) {
    var e01 = cell[0][j] - cell[1][j];
    var e32 = cell[3][j] - cell[2][j];
    if (!almostEq(e01, e32)) return false;
    var e03 = cell[0][j] - cell[3][j];
    var e12 = cell[1][j] - cell[2][j];
    if (!almostEq(e03, e12)) return false;
  }

  // N.B. rotated rectangles are not valid rects since rotation is not supported in shapes for now.
  if (!almostEq(cell[0][1], cell[1][1]) && !almostEq(cell[0][1], cell[3][1])) return false;

  // reject cases with zero area
  return !!(dist(cell[0], cell[1]) * dist(cell[0], cell[3]));
};
exports.pointsOnEllipse = function (cell) {
  var len = cell.length;
  if (len !== CIRCLE_SIDES + 1) return false;

  // opposite diagonals should be the same
  len = CIRCLE_SIDES;
  for (var i = 0; i < len; i++) {
    var k = (len * 2 - i) % len;
    var k2 = (len / 2 + k) % len;
    var i2 = (len / 2 + i) % len;
    if (!almostEq(dist(cell[i], cell[i2]), dist(cell[k], cell[k2]))) return false;
  }
  return true;
};
exports.handleEllipse = function (isEllipse, start, end) {
  if (!isEllipse) return [start, end]; // i.e. case of line

  var pos = exports.ellipseOver({
    x0: start[0],
    y0: start[1],
    x1: end[0],
    y1: end[1]
  });
  var cx = (pos.x1 + pos.x0) / 2;
  var cy = (pos.y1 + pos.y0) / 2;
  var rx = (pos.x1 - pos.x0) / 2;
  var ry = (pos.y1 - pos.y0) / 2;

  // make a circle when one dimension is zero
  if (!rx) rx = ry = ry / SQRT2;
  if (!ry) ry = rx = rx / SQRT2;
  var cell = [];
  for (var i = 0; i < CIRCLE_SIDES; i++) {
    var t = i * 2 * Math.PI / CIRCLE_SIDES;
    cell.push([cx + rx * Math.cos(t), cy + ry * Math.sin(t)]);
  }
  return cell;
};
exports.ellipseOver = function (pos) {
  var x0 = pos.x0;
  var y0 = pos.y0;
  var x1 = pos.x1;
  var y1 = pos.y1;
  var dx = x1 - x0;
  var dy = y1 - y0;
  x0 -= dx;
  y0 -= dy;
  var cx = (x0 + x1) / 2;
  var cy = (y0 + y1) / 2;
  var scale = SQRT2;
  dx *= scale;
  dy *= scale;
  return {
    x0: cx - dx,
    y0: cy - dy,
    x1: cx + dx,
    y1: cy + dy
  };
};
exports.fixDatesForPaths = function (polygons, xaxis, yaxis) {
  var xIsDate = xaxis.type === 'date';
  var yIsDate = yaxis.type === 'date';
  if (!xIsDate && !yIsDate) return polygons;
  for (var i = 0; i < polygons.length; i++) {
    for (var j = 0; j < polygons[i].length; j++) {
      for (var k = 0; k + 2 < polygons[i][j].length; k += 2) {
        if (xIsDate) polygons[i][j][k + 1] = polygons[i][j][k + 1].replace(' ', '_');
        if (yIsDate) polygons[i][j][k + 2] = polygons[i][j][k + 2].replace(' ', '_');
      }
    }
  }
  return polygons;
};

/***/ }),

/***/ 3940:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var dragHelpers = __webpack_require__(2760);
var drawMode = dragHelpers.drawMode;
var openMode = dragHelpers.openMode;
var constants = __webpack_require__(7000);
var i000 = constants.i000;
var i090 = constants.i090;
var i180 = constants.i180;
var i270 = constants.i270;
var cos45 = constants.cos45;
var sin45 = constants.sin45;
var cartesianHelpers = __webpack_require__(5840);
var p2r = cartesianHelpers.p2r;
var r2p = cartesianHelpers.r2p;
var handleOutline = __webpack_require__(1936);
var clearOutline = handleOutline.clearOutline;
var helpers = __webpack_require__(9856);
var readPaths = helpers.readPaths;
var writePaths = helpers.writePaths;
var ellipseOver = helpers.ellipseOver;
var fixDatesForPaths = helpers.fixDatesForPaths;
function newShapes(outlines, dragOptions) {
  if (!outlines.length) return;
  var e = outlines[0][0]; // pick first
  if (!e) return;
  var gd = dragOptions.gd;
  var isActiveShape = dragOptions.isActiveShape;
  var dragmode = dragOptions.dragmode;
  var shapes = (gd.layout || {}).shapes || [];
  if (!drawMode(dragmode) && isActiveShape !== undefined) {
    var id = gd._fullLayout._activeShapeIndex;
    if (id < shapes.length) {
      switch (gd._fullLayout.shapes[id].type) {
        case 'rect':
          dragmode = 'drawrect';
          break;
        case 'circle':
          dragmode = 'drawcircle';
          break;
        case 'line':
          dragmode = 'drawline';
          break;
        case 'path':
          var path = shapes[id].path || '';
          if (path[path.length - 1] === 'Z') {
            dragmode = 'drawclosedpath';
          } else {
            dragmode = 'drawopenpath';
          }
          break;
      }
    }
  }
  var newShape = createShapeObj(outlines, dragOptions, dragmode);
  clearOutline(gd);
  var editHelpers = dragOptions.editHelpers;
  var modifyItem = (editHelpers || {}).modifyItem;
  var allShapes = [];
  for (var q = 0; q < shapes.length; q++) {
    var beforeEdit = gd._fullLayout.shapes[q];
    allShapes[q] = beforeEdit._input;
    if (isActiveShape !== undefined && q === gd._fullLayout._activeShapeIndex) {
      var afterEdit = newShape;
      switch (beforeEdit.type) {
        case 'line':
        case 'rect':
        case 'circle':
          modifyItem('x0', afterEdit.x0);
          modifyItem('x1', afterEdit.x1);
          modifyItem('y0', afterEdit.y0);
          modifyItem('y1', afterEdit.y1);
          break;
        case 'path':
          modifyItem('path', afterEdit.path);
          break;
      }
    }
  }
  if (isActiveShape === undefined) {
    allShapes.push(newShape); // add new shape
    return allShapes;
  }
  return editHelpers ? editHelpers.getUpdateObj() : {};
}
function createShapeObj(outlines, dragOptions, dragmode) {
  var e = outlines[0][0]; // pick first outline
  var gd = dragOptions.gd;
  var d = e.getAttribute('d');
  var newStyle = gd._fullLayout.newshape;
  var plotinfo = dragOptions.plotinfo;
  var isActiveShape = dragOptions.isActiveShape;
  var xaxis = plotinfo.xaxis;
  var yaxis = plotinfo.yaxis;
  var xPaper = !!plotinfo.domain || !plotinfo.xaxis;
  var yPaper = !!plotinfo.domain || !plotinfo.yaxis;
  var isOpenMode = openMode(dragmode);
  var polygons = readPaths(d, gd, plotinfo, isActiveShape);
  var newShape = {
    editable: true,
    visible: newStyle.visible,
    name: newStyle.name,
    showlegend: newStyle.showlegend,
    legend: newStyle.legend,
    legendwidth: newStyle.legendwidth,
    legendgroup: newStyle.legendgroup,
    legendgrouptitle: {
      text: newStyle.legendgrouptitle.text,
      font: newStyle.legendgrouptitle.font
    },
    legendrank: newStyle.legendrank,
    label: newStyle.label,
    xref: xPaper ? 'paper' : xaxis._id,
    yref: yPaper ? 'paper' : yaxis._id,
    layer: newStyle.layer,
    opacity: newStyle.opacity,
    line: {
      color: newStyle.line.color,
      width: newStyle.line.width,
      dash: newStyle.line.dash
    }
  };
  if (!isOpenMode) {
    newShape.fillcolor = newStyle.fillcolor;
    newShape.fillrule = newStyle.fillrule;
  }
  var cell;
  // line, rect and circle can be in one cell
  // only define cell if there is single cell
  if (polygons.length === 1) cell = polygons[0];
  if (cell && cell.length === 5 &&
  // ensure we only have 4 corners for a rect
  dragmode === 'drawrect') {
    newShape.type = 'rect';
    newShape.x0 = cell[0][1];
    newShape.y0 = cell[0][2];
    newShape.x1 = cell[2][1];
    newShape.y1 = cell[2][2];
  } else if (cell && dragmode === 'drawline') {
    newShape.type = 'line';
    newShape.x0 = cell[0][1];
    newShape.y0 = cell[0][2];
    newShape.x1 = cell[1][1];
    newShape.y1 = cell[1][2];
  } else if (cell && dragmode === 'drawcircle') {
    newShape.type = 'circle'; // an ellipse!

    var xA = cell[i000][1];
    var xB = cell[i090][1];
    var xC = cell[i180][1];
    var xD = cell[i270][1];
    var yA = cell[i000][2];
    var yB = cell[i090][2];
    var yC = cell[i180][2];
    var yD = cell[i270][2];
    var xDateOrLog = plotinfo.xaxis && (plotinfo.xaxis.type === 'date' || plotinfo.xaxis.type === 'log');
    var yDateOrLog = plotinfo.yaxis && (plotinfo.yaxis.type === 'date' || plotinfo.yaxis.type === 'log');
    if (xDateOrLog) {
      xA = r2p(plotinfo.xaxis, xA);
      xB = r2p(plotinfo.xaxis, xB);
      xC = r2p(plotinfo.xaxis, xC);
      xD = r2p(plotinfo.xaxis, xD);
    }
    if (yDateOrLog) {
      yA = r2p(plotinfo.yaxis, yA);
      yB = r2p(plotinfo.yaxis, yB);
      yC = r2p(plotinfo.yaxis, yC);
      yD = r2p(plotinfo.yaxis, yD);
    }
    var x0 = (xB + xD) / 2;
    var y0 = (yA + yC) / 2;
    var rx = (xD - xB + xC - xA) / 2;
    var ry = (yD - yB + yC - yA) / 2;
    var pos = ellipseOver({
      x0: x0,
      y0: y0,
      x1: x0 + rx * cos45,
      y1: y0 + ry * sin45
    });
    if (xDateOrLog) {
      pos.x0 = p2r(plotinfo.xaxis, pos.x0);
      pos.x1 = p2r(plotinfo.xaxis, pos.x1);
    }
    if (yDateOrLog) {
      pos.y0 = p2r(plotinfo.yaxis, pos.y0);
      pos.y1 = p2r(plotinfo.yaxis, pos.y1);
    }
    newShape.x0 = pos.x0;
    newShape.y0 = pos.y0;
    newShape.x1 = pos.x1;
    newShape.y1 = pos.y1;
  } else {
    newShape.type = 'path';
    if (xaxis && yaxis) fixDatesForPaths(polygons, xaxis, yaxis);
    newShape.path = writePaths(polygons);
    cell = null;
  }
  return newShape;
}
module.exports = {
  newShapes: newShapes,
  createShapeObj: createShapeObj
};

/***/ }),

/***/ 1936:
/***/ (function(module) {

"use strict";


function clearOutlineControllers(gd) {
  var zoomLayer = gd._fullLayout._zoomlayer;
  if (zoomLayer) {
    zoomLayer.selectAll('.outline-controllers').remove();
  }
}
function clearOutline(gd) {
  var zoomLayer = gd._fullLayout._zoomlayer;
  if (zoomLayer) {
    // until we get around to persistent selections, remove the outline
    // here. The selection itself will be removed when the plot redraws
    // at the end.
    zoomLayer.selectAll('.select-outline').remove();
  }
  gd._fullLayout._outlining = false;
}
module.exports = {
  clearOutlineControllers: clearOutlineControllers,
  clearOutline: clearOutline
};

/***/ }),

/***/ 5152:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var constants = __webpack_require__(3068);
var Lib = __webpack_require__(3400);
var Axes = __webpack_require__(4460);

// special position conversion functions... category axis positions can't be
// specified by their data values, because they don't make a continuous mapping.
// so these have to be specified in terms of the category serial numbers,
// but can take fractional values. Other axis types we specify position based on
// the actual data values.
// TODO: in V3.0 (when log axis ranges are in data units) range and shape position
// will be identical, so rangeToShapePosition and shapePositionToRange can be
// removed entirely.

exports.rangeToShapePosition = function (ax) {
  return ax.type === 'log' ? ax.r2d : function (v) {
    return v;
  };
};
exports.shapePositionToRange = function (ax) {
  return ax.type === 'log' ? ax.d2r : function (v) {
    return v;
  };
};
exports.decodeDate = function (convertToPx) {
  return function (v) {
    if (v.replace) v = v.replace('_', ' ');
    return convertToPx(v);
  };
};
exports.encodeDate = function (convertToDate) {
  return function (v) {
    return convertToDate(v).replace(' ', '_');
  };
};
exports.extractPathCoords = function (path, paramsToUse, isRaw) {
  var extractedCoordinates = [];
  var segments = path.match(constants.segmentRE);
  segments.forEach(function (segment) {
    var relevantParamIdx = paramsToUse[segment.charAt(0)].drawn;
    if (relevantParamIdx === undefined) return;
    var params = segment.substr(1).match(constants.paramRE);
    if (!params || params.length < relevantParamIdx) return;
    var str = params[relevantParamIdx];
    var pos = isRaw ? str : Lib.cleanNumber(str);
    extractedCoordinates.push(pos);
  });
  return extractedCoordinates;
};
exports.getDataToPixel = function (gd, axis, isVertical, refType) {
  var gs = gd._fullLayout._size;
  var dataToPixel;
  if (axis) {
    if (refType === 'domain') {
      dataToPixel = function (v) {
        return axis._length * (isVertical ? 1 - v : v) + axis._offset;
      };
    } else {
      var d2r = exports.shapePositionToRange(axis);
      dataToPixel = function (v) {
        return axis._offset + axis.r2p(d2r(v, true));
      };
      if (axis.type === 'date') dataToPixel = exports.decodeDate(dataToPixel);
    }
  } else if (isVertical) {
    dataToPixel = function (v) {
      return gs.t + gs.h * (1 - v);
    };
  } else {
    dataToPixel = function (v) {
      return gs.l + gs.w * v;
    };
  }
  return dataToPixel;
};
exports.getPixelToData = function (gd, axis, isVertical, opt) {
  var gs = gd._fullLayout._size;
  var pixelToData;
  if (axis) {
    if (opt === 'domain') {
      pixelToData = function (p) {
        var q = (p - axis._offset) / axis._length;
        return isVertical ? 1 - q : q;
      };
    } else {
      var r2d = exports.rangeToShapePosition(axis);
      pixelToData = function (p) {
        return r2d(axis.p2r(p - axis._offset));
      };
    }
  } else if (isVertical) {
    pixelToData = function (p) {
      return 1 - (p - gs.t) / gs.h;
    };
  } else {
    pixelToData = function (p) {
      return (p - gs.l) / gs.w;
    };
  }
  return pixelToData;
};

/**
 * Based on the given stroke width, rounds the passed
 * position value to represent either a full or half pixel.
 *
 * In case of an odd stroke width (e.g. 1), this measure ensures
 * that a stroke positioned at the returned position isn't rendered
 * blurry due to anti-aliasing.
 *
 * In case of an even stroke width (e.g. 2), this measure ensures
 * that the position value is transformed to a full pixel value
 * so that anti-aliasing doesn't take effect either.
 *
 * @param {number} pos The raw position value to be transformed
 * @param {number} strokeWidth The stroke width
 * @returns {number} either an integer or a .5 decimal number
 */
exports.roundPositionForSharpStrokeRendering = function (pos, strokeWidth) {
  var strokeWidthIsOdd = Math.round(strokeWidth % 2) === 1;
  var posValAsInt = Math.round(pos);
  return strokeWidthIsOdd ? posValAsInt + 0.5 : posValAsInt;
};
exports.makeShapesOptionsAndPlotinfo = function (gd, index) {
  var options = gd._fullLayout.shapes[index] || {};
  var plotinfo = gd._fullLayout._plots[options.xref + options.yref];
  var hasPlotinfo = !!plotinfo;
  if (hasPlotinfo) {
    plotinfo._hadPlotinfo = true;
  } else {
    plotinfo = {};
    if (options.xref && options.xref !== 'paper') plotinfo.xaxis = gd._fullLayout[options.xref + 'axis'];
    if (options.yref && options.yref !== 'paper') plotinfo.yaxis = gd._fullLayout[options.yref + 'axis'];
  }
  plotinfo.xsizemode = options.xsizemode;
  plotinfo.ysizemode = options.ysizemode;
  plotinfo.xanchor = options.xanchor;
  plotinfo.yanchor = options.yanchor;
  return {
    options: options,
    plotinfo: plotinfo
  };
};

// TODO: move to selections helpers?
exports.makeSelectionsOptionsAndPlotinfo = function (gd, index) {
  var options = gd._fullLayout.selections[index] || {};
  var plotinfo = gd._fullLayout._plots[options.xref + options.yref];
  var hasPlotinfo = !!plotinfo;
  if (hasPlotinfo) {
    plotinfo._hadPlotinfo = true;
  } else {
    plotinfo = {};
    if (options.xref) plotinfo.xaxis = gd._fullLayout[options.xref + 'axis'];
    if (options.yref) plotinfo.yaxis = gd._fullLayout[options.yref + 'axis'];
  }
  return {
    options: options,
    plotinfo: plotinfo
  };
};
exports.getPathString = function (gd, options) {
  var type = options.type;
  var xRefType = Axes.getRefType(options.xref);
  var yRefType = Axes.getRefType(options.yref);
  var xa = Axes.getFromId(gd, options.xref);
  var ya = Axes.getFromId(gd, options.yref);
  var gs = gd._fullLayout._size;
  var x2r, x2p, y2r, y2p;
  var x0, x1, y0, y1;
  if (xa) {
    if (xRefType === 'domain') {
      x2p = function (v) {
        return xa._offset + xa._length * v;
      };
    } else {
      x2r = exports.shapePositionToRange(xa);
      x2p = function (v) {
        return xa._offset + xa.r2p(x2r(v, true));
      };
    }
  } else {
    x2p = function (v) {
      return gs.l + gs.w * v;
    };
  }
  if (ya) {
    if (yRefType === 'domain') {
      y2p = function (v) {
        return ya._offset + ya._length * (1 - v);
      };
    } else {
      y2r = exports.shapePositionToRange(ya);
      y2p = function (v) {
        return ya._offset + ya.r2p(y2r(v, true));
      };
    }
  } else {
    y2p = function (v) {
      return gs.t + gs.h * (1 - v);
    };
  }
  if (type === 'path') {
    if (xa && xa.type === 'date') x2p = exports.decodeDate(x2p);
    if (ya && ya.type === 'date') y2p = exports.decodeDate(y2p);
    return convertPath(options, x2p, y2p);
  }
  if (options.xsizemode === 'pixel') {
    var xAnchorPos = x2p(options.xanchor);
    x0 = xAnchorPos + options.x0;
    x1 = xAnchorPos + options.x1;
  } else {
    x0 = x2p(options.x0);
    x1 = x2p(options.x1);
  }
  if (options.ysizemode === 'pixel') {
    var yAnchorPos = y2p(options.yanchor);
    y0 = yAnchorPos - options.y0;
    y1 = yAnchorPos - options.y1;
  } else {
    y0 = y2p(options.y0);
    y1 = y2p(options.y1);
  }
  if (type === 'line') return 'M' + x0 + ',' + y0 + 'L' + x1 + ',' + y1;
  if (type === 'rect') return 'M' + x0 + ',' + y0 + 'H' + x1 + 'V' + y1 + 'H' + x0 + 'Z';

  // circle
  var cx = (x0 + x1) / 2;
  var cy = (y0 + y1) / 2;
  var rx = Math.abs(cx - x0);
  var ry = Math.abs(cy - y0);
  var rArc = 'A' + rx + ',' + ry;
  var rightPt = cx + rx + ',' + cy;
  var topPt = cx + ',' + (cy - ry);
  return 'M' + rightPt + rArc + ' 0 1,1 ' + topPt + rArc + ' 0 0,1 ' + rightPt + 'Z';
};
function convertPath(options, x2p, y2p) {
  var pathIn = options.path;
  var xSizemode = options.xsizemode;
  var ySizemode = options.ysizemode;
  var xAnchor = options.xanchor;
  var yAnchor = options.yanchor;
  return pathIn.replace(constants.segmentRE, function (segment) {
    var paramNumber = 0;
    var segmentType = segment.charAt(0);
    var xParams = constants.paramIsX[segmentType];
    var yParams = constants.paramIsY[segmentType];
    var nParams = constants.numParams[segmentType];
    var paramString = segment.substr(1).replace(constants.paramRE, function (param) {
      if (xParams[paramNumber]) {
        if (xSizemode === 'pixel') param = x2p(xAnchor) + Number(param);else param = x2p(param);
      } else if (yParams[paramNumber]) {
        if (ySizemode === 'pixel') param = y2p(yAnchor) - Number(param);else param = y2p(param);
      }
      paramNumber++;
      if (paramNumber > nParams) param = 'X';
      return param;
    });
    if (paramNumber > nParams) {
      paramString = paramString.replace(/[\s,]*X.*/, '');
      Lib.log('Ignoring extra params in segment ' + segment);
    }
    return segmentType + paramString;
  });
}

/***/ }),

/***/ 1592:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var drawModule = __webpack_require__(4016);
module.exports = {
  moduleType: 'component',
  name: 'shapes',
  layoutAttributes: __webpack_require__(6056),
  supplyLayoutDefaults: __webpack_require__(3712),
  supplyDrawNewShapeDefaults: __webpack_require__(5144),
  includeBasePlot: __webpack_require__(6632)('shapes'),
  calcAutorange: __webpack_require__(6084),
  draw: drawModule.draw,
  drawOne: drawModule.drawOne
};

/***/ }),

/***/ 7728:
/***/ (function(module) {

"use strict";


// Wrapper functions to handle paper-referenced shapes, which have no axis
function d2l(v, axis) {
  return axis ? axis.d2l(v) : v;
}
function l2d(v, axis) {
  return axis ? axis.l2d(v) : v;
}
function x0Fn(shape) {
  return shape.x0;
}
function x1Fn(shape) {
  return shape.x1;
}
function y0Fn(shape) {
  return shape.y0;
}
function y1Fn(shape) {
  return shape.y1;
}
function dxFn(shape, xa) {
  return d2l(shape.x1, xa) - d2l(shape.x0, xa);
}
function dyFn(shape, xa, ya) {
  return d2l(shape.y1, ya) - d2l(shape.y0, ya);
}
function widthFn(shape, xa) {
  return Math.abs(dxFn(shape, xa));
}
function heightFn(shape, xa, ya) {
  return Math.abs(dyFn(shape, xa, ya));
}
function lengthFn(shape, xa, ya) {
  return shape.type !== 'line' ? undefined : Math.sqrt(Math.pow(dxFn(shape, xa), 2) + Math.pow(dyFn(shape, xa, ya), 2));
}
function xcenterFn(shape, xa) {
  return l2d((d2l(shape.x1, xa) + d2l(shape.x0, xa)) / 2, xa);
}
function ycenterFn(shape, xa, ya) {
  return l2d((d2l(shape.y1, ya) + d2l(shape.y0, ya)) / 2, ya);
}
function slopeFn(shape, xa, ya) {
  return shape.type !== 'line' ? undefined : dyFn(shape, xa, ya) / dxFn(shape, xa);
}
module.exports = {
  x0: x0Fn,
  x1: x1Fn,
  y0: y0Fn,
  y1: y1Fn,
  slope: slopeFn,
  dx: dxFn,
  dy: dyFn,
  width: widthFn,
  height: heightFn,
  length: lengthFn,
  xcenter: xcenterFn,
  ycenter: ycenterFn
};

/***/ }),

/***/ 9861:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var fontAttrs = __webpack_require__(5376);
var padAttrs = __webpack_require__(6741);
var extendDeepAll = (__webpack_require__(2880).extendDeepAll);
var overrideAll = (__webpack_require__(7824).overrideAll);
var animationAttrs = __webpack_require__(5656);
var templatedArray = (__webpack_require__(1780).templatedArray);
var constants = __webpack_require__(876);
var stepsAttrs = templatedArray('step', {
  visible: {
    valType: 'boolean',
    dflt: true
  },
  method: {
    valType: 'enumerated',
    values: ['restyle', 'relayout', 'animate', 'update', 'skip'],
    dflt: 'restyle'
  },
  args: {
    valType: 'info_array',
    freeLength: true,
    items: [{
      valType: 'any'
    }, {
      valType: 'any'
    }, {
      valType: 'any'
    }]
  },
  label: {
    valType: 'string'
  },
  value: {
    valType: 'string'
  },
  execute: {
    valType: 'boolean',
    dflt: true
  }
});
module.exports = overrideAll(templatedArray('slider', {
  visible: {
    valType: 'boolean',
    dflt: true
  },
  active: {
    valType: 'number',
    min: 0,
    dflt: 0
  },
  steps: stepsAttrs,
  lenmode: {
    valType: 'enumerated',
    values: ['fraction', 'pixels'],
    dflt: 'fraction'
  },
  len: {
    valType: 'number',
    min: 0,
    dflt: 1
  },
  x: {
    valType: 'number',
    min: -2,
    max: 3,
    dflt: 0
  },
  pad: extendDeepAll(padAttrs({
    editType: 'arraydraw'
  }), {}, {
    t: {
      dflt: 20
    }
  }),
  xanchor: {
    valType: 'enumerated',
    values: ['auto', 'left', 'center', 'right'],
    dflt: 'left'
  },
  y: {
    valType: 'number',
    min: -2,
    max: 3,
    dflt: 0
  },
  yanchor: {
    valType: 'enumerated',
    values: ['auto', 'top', 'middle', 'bottom'],
    dflt: 'top'
  },
  transition: {
    duration: {
      valType: 'number',
      min: 0,
      dflt: 150
    },
    easing: {
      valType: 'enumerated',
      values: animationAttrs.transition.easing.values,
      dflt: 'cubic-in-out'
    }
  },
  currentvalue: {
    visible: {
      valType: 'boolean',
      dflt: true
    },
    xanchor: {
      valType: 'enumerated',
      values: ['left', 'center', 'right'],
      dflt: 'left'
    },
    offset: {
      valType: 'number',
      dflt: 10
    },
    prefix: {
      valType: 'string'
    },
    suffix: {
      valType: 'string'
    },
    font: fontAttrs({})
  },
  font: fontAttrs({}),
  activebgcolor: {
    valType: 'color',
    dflt: constants.gripBgActiveColor
  },
  bgcolor: {
    valType: 'color',
    dflt: constants.railBgColor
  },
  bordercolor: {
    valType: 'color',
    dflt: constants.railBorderColor
  },
  borderwidth: {
    valType: 'number',
    min: 0,
    dflt: constants.railBorderWidth
  },
  ticklen: {
    valType: 'number',
    min: 0,
    dflt: constants.tickLength
  },
  tickcolor: {
    valType: 'color',
    dflt: constants.tickColor
  },
  tickwidth: {
    valType: 'number',
    min: 0,
    dflt: 1
  },
  minorticklen: {
    valType: 'number',
    min: 0,
    dflt: constants.minorTickLength
  }
}), 'arraydraw', 'from-root');

/***/ }),

/***/ 876:
/***/ (function(module) {

"use strict";


module.exports = {
  // layout attribute name
  name: 'sliders',
  // class names
  containerClassName: 'slider-container',
  groupClassName: 'slider-group',
  inputAreaClass: 'slider-input-area',
  railRectClass: 'slider-rail-rect',
  railTouchRectClass: 'slider-rail-touch-rect',
  gripRectClass: 'slider-grip-rect',
  tickRectClass: 'slider-tick-rect',
  inputProxyClass: 'slider-input-proxy',
  labelsClass: 'slider-labels',
  labelGroupClass: 'slider-label-group',
  labelClass: 'slider-label',
  currentValueClass: 'slider-current-value',
  railHeight: 5,
  // DOM attribute name in button group keeping track
  // of active update menu
  menuIndexAttrName: 'slider-active-index',
  // id root pass to Plots.autoMargin
  autoMarginIdRoot: 'slider-',
  // min item width / height
  minWidth: 30,
  minHeight: 30,
  // padding around item text
  textPadX: 40,
  // arrow offset off right edge
  arrowOffsetX: 4,
  railRadius: 2,
  railWidth: 5,
  railBorder: 4,
  railBorderWidth: 1,
  railBorderColor: '#bec8d9',
  railBgColor: '#f8fafc',
  // The distance of the rail from the edge of the touchable area
  // Slightly less than the step inset because of the curved edges
  // of the rail
  railInset: 8,
  // The distance from the extremal tick marks to the edge of the
  // touchable area. This is basically the same as the grip radius,
  // but for other styles it wouldn't really need to be.
  stepInset: 10,
  gripRadius: 10,
  gripWidth: 20,
  gripHeight: 20,
  gripBorder: 20,
  gripBorderWidth: 1,
  gripBorderColor: '#bec8d9',
  gripBgColor: '#f6f8fa',
  gripBgActiveColor: '#dbdde0',
  labelPadding: 8,
  labelOffset: 0,
  tickWidth: 1,
  tickColor: '#333',
  tickOffset: 25,
  tickLength: 7,
  minorTickOffset: 25,
  minorTickColor: '#333',
  minorTickLength: 4,
  // Extra space below the current value label:
  currentValuePadding: 8,
  currentValueInset: 0
};

/***/ }),

/***/ 8132:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var handleArrayContainerDefaults = __webpack_require__(1272);
var attributes = __webpack_require__(9861);
var constants = __webpack_require__(876);
var name = constants.name;
var stepAttrs = attributes.steps;
module.exports = function slidersDefaults(layoutIn, layoutOut) {
  handleArrayContainerDefaults(layoutIn, layoutOut, {
    name: name,
    handleItemDefaults: sliderDefaults
  });
};
function sliderDefaults(sliderIn, sliderOut, layoutOut) {
  function coerce(attr, dflt) {
    return Lib.coerce(sliderIn, sliderOut, attributes, attr, dflt);
  }
  var steps = handleArrayContainerDefaults(sliderIn, sliderOut, {
    name: 'steps',
    handleItemDefaults: stepDefaults
  });
  var stepCount = 0;
  for (var i = 0; i < steps.length; i++) {
    if (steps[i].visible) stepCount++;
  }
  var visible;
  // If it has fewer than two options, it's not really a slider
  if (stepCount < 2) visible = sliderOut.visible = false;else visible = coerce('visible');
  if (!visible) return;
  sliderOut._stepCount = stepCount;
  var visSteps = sliderOut._visibleSteps = Lib.filterVisible(steps);
  var active = coerce('active');
  if (!(steps[active] || {}).visible) sliderOut.active = visSteps[0]._index;
  coerce('x');
  coerce('y');
  Lib.noneOrAll(sliderIn, sliderOut, ['x', 'y']);
  coerce('xanchor');
  coerce('yanchor');
  coerce('len');
  coerce('lenmode');
  coerce('pad.t');
  coerce('pad.r');
  coerce('pad.b');
  coerce('pad.l');
  Lib.coerceFont(coerce, 'font', layoutOut.font);
  var currentValueIsVisible = coerce('currentvalue.visible');
  if (currentValueIsVisible) {
    coerce('currentvalue.xanchor');
    coerce('currentvalue.prefix');
    coerce('currentvalue.suffix');
    coerce('currentvalue.offset');
    Lib.coerceFont(coerce, 'currentvalue.font', sliderOut.font);
  }
  coerce('transition.duration');
  coerce('transition.easing');
  coerce('bgcolor');
  coerce('activebgcolor');
  coerce('bordercolor');
  coerce('borderwidth');
  coerce('ticklen');
  coerce('tickwidth');
  coerce('tickcolor');
  coerce('minorticklen');
}
function stepDefaults(valueIn, valueOut) {
  function coerce(attr, dflt) {
    return Lib.coerce(valueIn, valueOut, stepAttrs, attr, dflt);
  }
  var visible;
  if (valueIn.method !== 'skip' && !Array.isArray(valueIn.args)) {
    visible = valueOut.visible = false;
  } else visible = coerce('visible');
  if (visible) {
    coerce('method');
    coerce('args');
    var label = coerce('label', 'step-' + valueOut._index);
    coerce('value', label);
    coerce('execute');
  }
}

/***/ }),

/***/ 9664:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var Plots = __webpack_require__(7316);
var Color = __webpack_require__(6308);
var Drawing = __webpack_require__(3616);
var Lib = __webpack_require__(3400);
var strTranslate = Lib.strTranslate;
var svgTextUtils = __webpack_require__(2736);
var arrayEditor = (__webpack_require__(1780).arrayEditor);
var constants = __webpack_require__(876);
var alignmentConstants = __webpack_require__(4284);
var LINE_SPACING = alignmentConstants.LINE_SPACING;
var FROM_TL = alignmentConstants.FROM_TL;
var FROM_BR = alignmentConstants.FROM_BR;
module.exports = function draw(gd) {
  var staticPlot = gd._context.staticPlot;
  var fullLayout = gd._fullLayout;
  var sliderData = makeSliderData(fullLayout, gd);

  // draw a container for *all* sliders:
  var sliders = fullLayout._infolayer.selectAll('g.' + constants.containerClassName).data(sliderData.length > 0 ? [0] : []);
  sliders.enter().append('g').classed(constants.containerClassName, true).style('cursor', staticPlot ? null : 'ew-resize');
  function clearSlider(sliderOpts) {
    if (sliderOpts._commandObserver) {
      sliderOpts._commandObserver.remove();
      delete sliderOpts._commandObserver;
    }

    // Most components don't need to explicitly remove autoMargin, because
    // marginPushers does this - but slider updates don't go through
    // a full replot so we need to explicitly remove it.
    Plots.autoMargin(gd, autoMarginId(sliderOpts));
  }
  sliders.exit().each(function () {
    d3.select(this).selectAll('g.' + constants.groupClassName).each(clearSlider);
  }).remove();

  // Return early if no menus visible:
  if (sliderData.length === 0) return;
  var sliderGroups = sliders.selectAll('g.' + constants.groupClassName).data(sliderData, keyFunction);
  sliderGroups.enter().append('g').classed(constants.groupClassName, true);
  sliderGroups.exit().each(clearSlider).remove();

  // Find the dimensions of the sliders:
  for (var i = 0; i < sliderData.length; i++) {
    var sliderOpts = sliderData[i];
    findDimensions(gd, sliderOpts);
  }
  sliderGroups.each(function (sliderOpts) {
    var gSlider = d3.select(this);
    computeLabelSteps(sliderOpts);
    Plots.manageCommandObserver(gd, sliderOpts, sliderOpts._visibleSteps, function (data) {
      // NB: Same as below. This is *not* always the same as sliderOpts since
      // if a new set of steps comes in, the reference in this callback would
      // be invalid. We need to refetch it from the slider group, which is
      // the join data that creates this slider. So if this slider still exists,
      // the group should be valid, *to the best of my knowledge.* If not,
      // we'd have to look it up by d3 data join index/key.
      var opts = gSlider.data()[0];
      if (opts.active === data.index) return;
      if (opts._dragging) return;
      setActive(gd, gSlider, opts, data.index, false, true);
    });
    drawSlider(gd, d3.select(this), sliderOpts);
  });
};
function autoMarginId(sliderOpts) {
  return constants.autoMarginIdRoot + sliderOpts._index;
}

// This really only just filters by visibility:
function makeSliderData(fullLayout, gd) {
  var contOpts = fullLayout[constants.name];
  var sliderData = [];
  for (var i = 0; i < contOpts.length; i++) {
    var item = contOpts[i];
    if (!item.visible) continue;
    item._gd = gd;
    sliderData.push(item);
  }
  return sliderData;
}

// This is set in the defaults step:
function keyFunction(opts) {
  return opts._index;
}

// Compute the dimensions (mutates sliderOpts):
function findDimensions(gd, sliderOpts) {
  var sliderLabels = Drawing.tester.selectAll('g.' + constants.labelGroupClass).data(sliderOpts._visibleSteps);
  sliderLabels.enter().append('g').classed(constants.labelGroupClass, true);

  // loop over fake buttons to find width / height
  var maxLabelWidth = 0;
  var labelHeight = 0;
  sliderLabels.each(function (stepOpts) {
    var labelGroup = d3.select(this);
    var text = drawLabel(labelGroup, {
      step: stepOpts
    }, sliderOpts);
    var textNode = text.node();
    if (textNode) {
      var bBox = Drawing.bBox(textNode);
      labelHeight = Math.max(labelHeight, bBox.height);
      maxLabelWidth = Math.max(maxLabelWidth, bBox.width);
    }
  });
  sliderLabels.remove();
  var dims = sliderOpts._dims = {};
  dims.inputAreaWidth = Math.max(constants.railWidth, constants.gripHeight);

  // calculate some overall dimensions - some of these are needed for
  // calculating the currentValue dimensions
  var graphSize = gd._fullLayout._size;
  dims.lx = graphSize.l + graphSize.w * sliderOpts.x;
  dims.ly = graphSize.t + graphSize.h * (1 - sliderOpts.y);
  if (sliderOpts.lenmode === 'fraction') {
    // fraction:
    dims.outerLength = Math.round(graphSize.w * sliderOpts.len);
  } else {
    // pixels:
    dims.outerLength = sliderOpts.len;
  }

  // The length of the rail, *excluding* padding on either end:
  dims.inputAreaStart = 0;
  dims.inputAreaLength = Math.round(dims.outerLength - sliderOpts.pad.l - sliderOpts.pad.r);
  var textableInputLength = dims.inputAreaLength - 2 * constants.stepInset;
  var availableSpacePerLabel = textableInputLength / (sliderOpts._stepCount - 1);
  var computedSpacePerLabel = maxLabelWidth + constants.labelPadding;
  dims.labelStride = Math.max(1, Math.ceil(computedSpacePerLabel / availableSpacePerLabel));
  dims.labelHeight = labelHeight;

  // loop over all possible values for currentValue to find the
  // area we need for it
  dims.currentValueMaxWidth = 0;
  dims.currentValueHeight = 0;
  dims.currentValueTotalHeight = 0;
  dims.currentValueMaxLines = 1;
  if (sliderOpts.currentvalue.visible) {
    // Get the dimensions of the current value label:
    var dummyGroup = Drawing.tester.append('g');
    sliderLabels.each(function (stepOpts) {
      var curValPrefix = drawCurrentValue(dummyGroup, sliderOpts, stepOpts.label);
      var curValSize = curValPrefix.node() && Drawing.bBox(curValPrefix.node()) || {
        width: 0,
        height: 0
      };
      var lines = svgTextUtils.lineCount(curValPrefix);
      dims.currentValueMaxWidth = Math.max(dims.currentValueMaxWidth, Math.ceil(curValSize.width));
      dims.currentValueHeight = Math.max(dims.currentValueHeight, Math.ceil(curValSize.height));
      dims.currentValueMaxLines = Math.max(dims.currentValueMaxLines, lines);
    });
    dims.currentValueTotalHeight = dims.currentValueHeight + sliderOpts.currentvalue.offset;
    dummyGroup.remove();
  }
  dims.height = dims.currentValueTotalHeight + constants.tickOffset + sliderOpts.ticklen + constants.labelOffset + dims.labelHeight + sliderOpts.pad.t + sliderOpts.pad.b;
  var xanchor = 'left';
  if (Lib.isRightAnchor(sliderOpts)) {
    dims.lx -= dims.outerLength;
    xanchor = 'right';
  }
  if (Lib.isCenterAnchor(sliderOpts)) {
    dims.lx -= dims.outerLength / 2;
    xanchor = 'center';
  }
  var yanchor = 'top';
  if (Lib.isBottomAnchor(sliderOpts)) {
    dims.ly -= dims.height;
    yanchor = 'bottom';
  }
  if (Lib.isMiddleAnchor(sliderOpts)) {
    dims.ly -= dims.height / 2;
    yanchor = 'middle';
  }
  dims.outerLength = Math.ceil(dims.outerLength);
  dims.height = Math.ceil(dims.height);
  dims.lx = Math.round(dims.lx);
  dims.ly = Math.round(dims.ly);
  var marginOpts = {
    y: sliderOpts.y,
    b: dims.height * FROM_BR[yanchor],
    t: dims.height * FROM_TL[yanchor]
  };
  if (sliderOpts.lenmode === 'fraction') {
    marginOpts.l = 0;
    marginOpts.xl = sliderOpts.x - sliderOpts.len * FROM_TL[xanchor];
    marginOpts.r = 0;
    marginOpts.xr = sliderOpts.x + sliderOpts.len * FROM_BR[xanchor];
  } else {
    marginOpts.x = sliderOpts.x;
    marginOpts.l = dims.outerLength * FROM_TL[xanchor];
    marginOpts.r = dims.outerLength * FROM_BR[xanchor];
  }
  Plots.autoMargin(gd, autoMarginId(sliderOpts), marginOpts);
}
function drawSlider(gd, sliderGroup, sliderOpts) {
  // This is related to the other long notes in this file regarding what happens
  // when slider steps disappear. This particular fix handles what happens when
  // the *current* slider step is removed. The drawing functions will error out
  // when they fail to find it, so the fix for now is that it will just draw the
  // slider in the first position but will not execute the command.
  if (!(sliderOpts.steps[sliderOpts.active] || {}).visible) {
    sliderOpts.active = sliderOpts._visibleSteps[0]._index;
  }

  // These are carefully ordered for proper z-ordering:
  sliderGroup.call(drawCurrentValue, sliderOpts).call(drawRail, sliderOpts).call(drawLabelGroup, sliderOpts).call(drawTicks, sliderOpts).call(drawTouchRect, gd, sliderOpts).call(drawGrip, gd, sliderOpts);
  var dims = sliderOpts._dims;

  // Position the rectangle:
  Drawing.setTranslate(sliderGroup, dims.lx + sliderOpts.pad.l, dims.ly + sliderOpts.pad.t);
  sliderGroup.call(setGripPosition, sliderOpts, false);
  sliderGroup.call(drawCurrentValue, sliderOpts);
}
function drawCurrentValue(sliderGroup, sliderOpts, valueOverride) {
  if (!sliderOpts.currentvalue.visible) return;
  var dims = sliderOpts._dims;
  var x0, textAnchor;
  switch (sliderOpts.currentvalue.xanchor) {
    case 'right':
      // This is anchored left and adjusted by the width of the longest label
      // so that the prefix doesn't move. The goal of this is to emphasize
      // what's actually changing and make the update less distracting.
      x0 = dims.inputAreaLength - constants.currentValueInset - dims.currentValueMaxWidth;
      textAnchor = 'left';
      break;
    case 'center':
      x0 = dims.inputAreaLength * 0.5;
      textAnchor = 'middle';
      break;
    default:
      x0 = constants.currentValueInset;
      textAnchor = 'left';
  }
  var text = Lib.ensureSingle(sliderGroup, 'text', constants.labelClass, function (s) {
    s.attr({
      'text-anchor': textAnchor,
      'data-notex': 1
    });
  });
  var str = sliderOpts.currentvalue.prefix ? sliderOpts.currentvalue.prefix : '';
  if (typeof valueOverride === 'string') {
    str += valueOverride;
  } else {
    var curVal = sliderOpts.steps[sliderOpts.active].label;
    var _meta = sliderOpts._gd._fullLayout._meta;
    if (_meta) curVal = Lib.templateString(curVal, _meta);
    str += curVal;
  }
  if (sliderOpts.currentvalue.suffix) {
    str += sliderOpts.currentvalue.suffix;
  }
  text.call(Drawing.font, sliderOpts.currentvalue.font).text(str).call(svgTextUtils.convertToTspans, sliderOpts._gd);
  var lines = svgTextUtils.lineCount(text);
  var y0 = (dims.currentValueMaxLines + 1 - lines) * sliderOpts.currentvalue.font.size * LINE_SPACING;
  svgTextUtils.positionText(text, x0, y0);
  return text;
}
function drawGrip(sliderGroup, gd, sliderOpts) {
  var grip = Lib.ensureSingle(sliderGroup, 'rect', constants.gripRectClass, function (s) {
    s.call(attachGripEvents, gd, sliderGroup, sliderOpts).style('pointer-events', 'all');
  });
  grip.attr({
    width: constants.gripWidth,
    height: constants.gripHeight,
    rx: constants.gripRadius,
    ry: constants.gripRadius
  }).call(Color.stroke, sliderOpts.bordercolor).call(Color.fill, sliderOpts.bgcolor).style('stroke-width', sliderOpts.borderwidth + 'px');
}
function drawLabel(item, data, sliderOpts) {
  var text = Lib.ensureSingle(item, 'text', constants.labelClass, function (s) {
    s.attr({
      'text-anchor': 'middle',
      'data-notex': 1
    });
  });
  var tx = data.step.label;
  var _meta = sliderOpts._gd._fullLayout._meta;
  if (_meta) tx = Lib.templateString(tx, _meta);
  text.call(Drawing.font, sliderOpts.font).text(tx).call(svgTextUtils.convertToTspans, sliderOpts._gd);
  return text;
}
function drawLabelGroup(sliderGroup, sliderOpts) {
  var labels = Lib.ensureSingle(sliderGroup, 'g', constants.labelsClass);
  var dims = sliderOpts._dims;
  var labelItems = labels.selectAll('g.' + constants.labelGroupClass).data(dims.labelSteps);
  labelItems.enter().append('g').classed(constants.labelGroupClass, true);
  labelItems.exit().remove();
  labelItems.each(function (d) {
    var item = d3.select(this);
    item.call(drawLabel, d, sliderOpts);
    Drawing.setTranslate(item, normalizedValueToPosition(sliderOpts, d.fraction), constants.tickOffset + sliderOpts.ticklen +
    // position is the baseline of the top line of text only, even
    // if the label spans multiple lines
    sliderOpts.font.size * LINE_SPACING + constants.labelOffset + dims.currentValueTotalHeight);
  });
}
function handleInput(gd, sliderGroup, sliderOpts, normalizedPosition, doTransition) {
  var quantizedPosition = Math.round(normalizedPosition * (sliderOpts._stepCount - 1));
  var quantizedIndex = sliderOpts._visibleSteps[quantizedPosition]._index;
  if (quantizedIndex !== sliderOpts.active) {
    setActive(gd, sliderGroup, sliderOpts, quantizedIndex, true, doTransition);
  }
}
function setActive(gd, sliderGroup, sliderOpts, index, doCallback, doTransition) {
  var previousActive = sliderOpts.active;
  sliderOpts.active = index;

  // due to templating, it's possible this slider doesn't even exist yet
  arrayEditor(gd.layout, constants.name, sliderOpts).applyUpdate('active', index);
  var step = sliderOpts.steps[sliderOpts.active];
  sliderGroup.call(setGripPosition, sliderOpts, doTransition);
  sliderGroup.call(drawCurrentValue, sliderOpts);
  gd.emit('plotly_sliderchange', {
    slider: sliderOpts,
    step: sliderOpts.steps[sliderOpts.active],
    interaction: doCallback,
    previousActive: previousActive
  });
  if (step && step.method && doCallback) {
    if (sliderGroup._nextMethod) {
      // If we've already queued up an update, just overwrite it with the most recent:
      sliderGroup._nextMethod.step = step;
      sliderGroup._nextMethod.doCallback = doCallback;
      sliderGroup._nextMethod.doTransition = doTransition;
    } else {
      sliderGroup._nextMethod = {
        step: step,
        doCallback: doCallback,
        doTransition: doTransition
      };
      sliderGroup._nextMethodRaf = window.requestAnimationFrame(function () {
        var _step = sliderGroup._nextMethod.step;
        if (!_step.method) return;
        if (_step.execute) {
          Plots.executeAPICommand(gd, _step.method, _step.args);
        }
        sliderGroup._nextMethod = null;
        sliderGroup._nextMethodRaf = null;
      });
    }
  }
}
function attachGripEvents(item, gd, sliderGroup) {
  if (gd._context.staticPlot) return;
  var node = sliderGroup.node();
  var $gd = d3.select(gd);

  // NB: This is *not* the same as sliderOpts itself! These callbacks
  // are in a closure so this array won't actually be correct if the
  // steps have changed since this was initialized. The sliderGroup,
  // however, has not changed since that *is* the slider, so it must
  // be present to receive mouse events.
  function getSliderOpts() {
    return sliderGroup.data()[0];
  }
  function mouseDownHandler() {
    var sliderOpts = getSliderOpts();
    gd.emit('plotly_sliderstart', {
      slider: sliderOpts
    });
    var grip = sliderGroup.select('.' + constants.gripRectClass);
    d3.event.stopPropagation();
    d3.event.preventDefault();
    grip.call(Color.fill, sliderOpts.activebgcolor);
    var normalizedPosition = positionToNormalizedValue(sliderOpts, d3.mouse(node)[0]);
    handleInput(gd, sliderGroup, sliderOpts, normalizedPosition, true);
    sliderOpts._dragging = true;
    function mouseMoveHandler() {
      var sliderOpts = getSliderOpts();
      var normalizedPosition = positionToNormalizedValue(sliderOpts, d3.mouse(node)[0]);
      handleInput(gd, sliderGroup, sliderOpts, normalizedPosition, false);
    }
    $gd.on('mousemove', mouseMoveHandler);
    $gd.on('touchmove', mouseMoveHandler);
    function mouseUpHandler() {
      var sliderOpts = getSliderOpts();
      sliderOpts._dragging = false;
      grip.call(Color.fill, sliderOpts.bgcolor);
      $gd.on('mouseup', null);
      $gd.on('mousemove', null);
      $gd.on('touchend', null);
      $gd.on('touchmove', null);
      gd.emit('plotly_sliderend', {
        slider: sliderOpts,
        step: sliderOpts.steps[sliderOpts.active]
      });
    }
    $gd.on('mouseup', mouseUpHandler);
    $gd.on('touchend', mouseUpHandler);
  }
  item.on('mousedown', mouseDownHandler);
  item.on('touchstart', mouseDownHandler);
}
function drawTicks(sliderGroup, sliderOpts) {
  var tick = sliderGroup.selectAll('rect.' + constants.tickRectClass).data(sliderOpts._visibleSteps);
  var dims = sliderOpts._dims;
  tick.enter().append('rect').classed(constants.tickRectClass, true);
  tick.exit().remove();
  tick.attr({
    width: sliderOpts.tickwidth + 'px',
    'shape-rendering': 'crispEdges'
  });
  tick.each(function (d, i) {
    var isMajor = i % dims.labelStride === 0;
    var item = d3.select(this);
    item.attr({
      height: isMajor ? sliderOpts.ticklen : sliderOpts.minorticklen
    }).call(Color.fill, isMajor ? sliderOpts.tickcolor : sliderOpts.tickcolor);
    Drawing.setTranslate(item, normalizedValueToPosition(sliderOpts, i / (sliderOpts._stepCount - 1)) - 0.5 * sliderOpts.tickwidth, (isMajor ? constants.tickOffset : constants.minorTickOffset) + dims.currentValueTotalHeight);
  });
}
function computeLabelSteps(sliderOpts) {
  var dims = sliderOpts._dims;
  dims.labelSteps = [];
  var nsteps = sliderOpts._stepCount;
  for (var i = 0; i < nsteps; i += dims.labelStride) {
    dims.labelSteps.push({
      fraction: i / (nsteps - 1),
      step: sliderOpts._visibleSteps[i]
    });
  }
}
function setGripPosition(sliderGroup, sliderOpts, doTransition) {
  var grip = sliderGroup.select('rect.' + constants.gripRectClass);
  var quantizedIndex = 0;
  for (var i = 0; i < sliderOpts._stepCount; i++) {
    if (sliderOpts._visibleSteps[i]._index === sliderOpts.active) {
      quantizedIndex = i;
      break;
    }
  }
  var x = normalizedValueToPosition(sliderOpts, quantizedIndex / (sliderOpts._stepCount - 1));

  // If this is true, then *this component* is already invoking its own command
  // and has triggered its own animation.
  if (sliderOpts._invokingCommand) return;
  var el = grip;
  if (doTransition && sliderOpts.transition.duration > 0) {
    el = el.transition().duration(sliderOpts.transition.duration).ease(sliderOpts.transition.easing);
  }

  // Drawing.setTranslate doesn't work here because of the transition duck-typing.
  // It's also not necessary because there are no other transitions to preserve.
  el.attr('transform', strTranslate(x - constants.gripWidth * 0.5, sliderOpts._dims.currentValueTotalHeight));
}

// Convert a number from [0-1] to a pixel position relative to the slider group container:
function normalizedValueToPosition(sliderOpts, normalizedPosition) {
  var dims = sliderOpts._dims;
  return dims.inputAreaStart + constants.stepInset + (dims.inputAreaLength - 2 * constants.stepInset) * Math.min(1, Math.max(0, normalizedPosition));
}

// Convert a position relative to the slider group to a nubmer in [0, 1]
function positionToNormalizedValue(sliderOpts, position) {
  var dims = sliderOpts._dims;
  return Math.min(1, Math.max(0, (position - constants.stepInset - dims.inputAreaStart) / (dims.inputAreaLength - 2 * constants.stepInset - 2 * dims.inputAreaStart)));
}
function drawTouchRect(sliderGroup, gd, sliderOpts) {
  var dims = sliderOpts._dims;
  var rect = Lib.ensureSingle(sliderGroup, 'rect', constants.railTouchRectClass, function (s) {
    s.call(attachGripEvents, gd, sliderGroup, sliderOpts).style('pointer-events', 'all');
  });
  rect.attr({
    width: dims.inputAreaLength,
    height: Math.max(dims.inputAreaWidth, constants.tickOffset + sliderOpts.ticklen + dims.labelHeight)
  }).call(Color.fill, sliderOpts.bgcolor).attr('opacity', 0);
  Drawing.setTranslate(rect, 0, dims.currentValueTotalHeight);
}
function drawRail(sliderGroup, sliderOpts) {
  var dims = sliderOpts._dims;
  var computedLength = dims.inputAreaLength - constants.railInset * 2;
  var rect = Lib.ensureSingle(sliderGroup, 'rect', constants.railRectClass);
  rect.attr({
    width: computedLength,
    height: constants.railWidth,
    rx: constants.railRadius,
    ry: constants.railRadius,
    'shape-rendering': 'crispEdges'
  }).call(Color.stroke, sliderOpts.bordercolor).call(Color.fill, sliderOpts.bgcolor).style('stroke-width', sliderOpts.borderwidth + 'px');
  Drawing.setTranslate(rect, constants.railInset, (dims.inputAreaWidth - constants.railWidth) * 0.5 + dims.currentValueTotalHeight);
}

/***/ }),

/***/ 7544:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var constants = __webpack_require__(876);
module.exports = {
  moduleType: 'component',
  name: constants.name,
  layoutAttributes: __webpack_require__(9861),
  supplyLayoutDefaults: __webpack_require__(8132),
  draw: __webpack_require__(9664)
};

/***/ }),

/***/ 1668:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var isNumeric = __webpack_require__(8248);
var Plots = __webpack_require__(7316);
var Registry = __webpack_require__(4040);
var Lib = __webpack_require__(3400);
var strTranslate = Lib.strTranslate;
var Drawing = __webpack_require__(3616);
var Color = __webpack_require__(6308);
var svgTextUtils = __webpack_require__(2736);
var interactConstants = __webpack_require__(3448);
var OPPOSITE_SIDE = (__webpack_require__(4284).OPPOSITE_SIDE);
var numStripRE = / [XY][0-9]* /;

/**
 * Titles - (re)draw titles on the axes and plot:
 * @param {DOM element} gd - the graphDiv
 * @param {string} titleClass - the css class of this title
 * @param {object} options - how and what to draw
 *      propContainer - the layout object containing `title` and `titlefont`
 *          attributes that apply to this title
 *      propName - the full name of the title property (for Plotly.relayout)
 *      [traceIndex] - include only if this property applies to one trace
 *          (such as a colorbar title) - then editing pipes to Plotly.restyle
 *          instead of Plotly.relayout
 *      placeholder - placeholder text for an empty editable title
 *      [avoid] {object} - include if this title should move to avoid other elements
 *          selection - d3 selection of elements to avoid
 *          side - which direction to move if there is a conflict
 *          [offsetLeft] - if these elements are subject to a translation
 *              wrt the title element
 *          [offsetTop]
 *      attributes {object} - position and alignment attributes
 *          x - pixels
 *          y - pixels
 *          text-anchor - start|middle|end
 *      transform {object} - how to transform the title after positioning
 *          rotate - degrees
 *          offset - shift up/down in the rotated frame (unused?)
 *      containerGroup - if an svg <g> element already exists to hold this
 *          title, include here. Otherwise it will go in fullLayout._infolayer
 *      _meta {object (optional} - meta key-value to for title with
 *          Lib.templateString, default to fullLayout._meta, if not provided
 *
 *  @return {selection} d3 selection of title container group
 */
function draw(gd, titleClass, options) {
  var cont = options.propContainer;
  var prop = options.propName;
  var placeholder = options.placeholder;
  var traceIndex = options.traceIndex;
  var avoid = options.avoid || {};
  var attributes = options.attributes;
  var transform = options.transform;
  var group = options.containerGroup;
  var fullLayout = gd._fullLayout;
  var opacity = 1;
  var isplaceholder = false;
  var title = cont.title;
  var txt = (title && title.text ? title.text : '').trim();
  var font = title && title.font ? title.font : {};
  var fontFamily = font.family;
  var fontSize = font.size;
  var fontColor = font.color;
  var fontWeight = font.weight;
  var fontStyle = font.style;
  var fontVariant = font.variant;

  // only make this title editable if we positively identify its property
  // as one that has editing enabled.
  var editAttr;
  if (prop === 'title.text') editAttr = 'titleText';else if (prop.indexOf('axis') !== -1) editAttr = 'axisTitleText';else if (prop.indexOf('colorbar' !== -1)) editAttr = 'colorbarTitleText';
  var editable = gd._context.edits[editAttr];
  if (txt === '') opacity = 0;
  // look for placeholder text while stripping out numbers from eg X2, Y3
  // this is just for backward compatibility with the old version that had
  // "Click to enter X2 title" and may have gotten saved in some old plots,
  // we don't want this to show up when these are displayed.
  else if (txt.replace(numStripRE, ' % ') === placeholder.replace(numStripRE, ' % ')) {
    opacity = 0.2;
    isplaceholder = true;
    if (!editable) txt = '';
  }
  if (options._meta) {
    txt = Lib.templateString(txt, options._meta);
  } else if (fullLayout._meta) {
    txt = Lib.templateString(txt, fullLayout._meta);
  }
  var elShouldExist = txt || editable;
  var hColorbarMoveTitle;
  if (!group) {
    group = Lib.ensureSingle(fullLayout._infolayer, 'g', 'g-' + titleClass);
    hColorbarMoveTitle = fullLayout._hColorbarMoveTitle;
  }
  var el = group.selectAll('text').data(elShouldExist ? [0] : []);
  el.enter().append('text');
  el.text(txt)
  // this is hacky, but convertToTspans uses the class
  // to determine whether to rotate mathJax...
  // so we need to clear out any old class and put the
  // correct one (only relevant for colorbars, at least
  // for now) - ie don't use .classed
  .attr('class', titleClass);
  el.exit().remove();
  if (!elShouldExist) return group;
  function titleLayout(titleEl) {
    Lib.syncOrAsync([drawTitle, scootTitle], titleEl);
  }
  function drawTitle(titleEl) {
    var transformVal;
    if (!transform && hColorbarMoveTitle) {
      transform = {};
    }
    if (transform) {
      transformVal = '';
      if (transform.rotate) {
        transformVal += 'rotate(' + [transform.rotate, attributes.x, attributes.y] + ')';
      }
      if (transform.offset || hColorbarMoveTitle) {
        transformVal += strTranslate(0, (transform.offset || 0) - (hColorbarMoveTitle || 0));
      }
    } else {
      transformVal = null;
    }
    titleEl.attr('transform', transformVal);
    titleEl.style({
      'font-family': fontFamily,
      'font-size': d3.round(fontSize, 2) + 'px',
      fill: Color.rgb(fontColor),
      opacity: opacity * Color.opacity(fontColor),
      'font-weight': fontWeight,
      'font-style': fontStyle,
      'font-variant': fontVariant
    }).attr(attributes).call(svgTextUtils.convertToTspans, gd);
    return Plots.previousPromises(gd);
  }
  function scootTitle(titleElIn) {
    var titleGroup = d3.select(titleElIn.node().parentNode);
    if (avoid && avoid.selection && avoid.side && txt) {
      titleGroup.attr('transform', null);

      // move toward avoid.side (= left, right, top, bottom) if needed
      // can include pad (pixels, default 2)
      var backside = OPPOSITE_SIDE[avoid.side];
      var shiftSign = avoid.side === 'left' || avoid.side === 'top' ? -1 : 1;
      var pad = isNumeric(avoid.pad) ? avoid.pad : 2;
      var titlebb = Drawing.bBox(titleGroup.node());

      // Account for reservedMargins
      var reservedMargins = {
        t: 0,
        b: 0,
        l: 0,
        r: 0
      };
      var margins = gd._fullLayout._reservedMargin;
      for (var key in margins) {
        for (var side in margins[key]) {
          var val = margins[key][side];
          reservedMargins[side] = Math.max(reservedMargins[side], val);
        }
      }
      var paperbb = {
        left: reservedMargins.l,
        top: reservedMargins.t,
        right: fullLayout.width - reservedMargins.r,
        bottom: fullLayout.height - reservedMargins.b
      };
      var maxshift = avoid.maxShift || shiftSign * (paperbb[avoid.side] - titlebb[avoid.side]);
      var shift = 0;

      // Prevent the title going off the paper
      if (maxshift < 0) {
        shift = maxshift;
      } else {
        // so we don't have to offset each avoided element,
        // give the title the opposite offset
        var offsetLeft = avoid.offsetLeft || 0;
        var offsetTop = avoid.offsetTop || 0;
        titlebb.left -= offsetLeft;
        titlebb.right -= offsetLeft;
        titlebb.top -= offsetTop;
        titlebb.bottom -= offsetTop;

        // iterate over a set of elements (avoid.selection)
        // to avoid collisions with
        avoid.selection.each(function () {
          var avoidbb = Drawing.bBox(this);
          if (Lib.bBoxIntersect(titlebb, avoidbb, pad)) {
            shift = Math.max(shift, shiftSign * (avoidbb[avoid.side] - titlebb[backside]) + pad);
          }
        });
        shift = Math.min(maxshift, shift);
        // Keeping track of this for calculation of full axis size if needed
        cont._titleScoot = Math.abs(shift);
      }
      if (shift > 0 || maxshift < 0) {
        var shiftTemplate = {
          left: [-shift, 0],
          right: [shift, 0],
          top: [0, -shift],
          bottom: [0, shift]
        }[avoid.side];
        titleGroup.attr('transform', strTranslate(shiftTemplate[0], shiftTemplate[1]));
      }
    }
  }
  el.call(titleLayout);
  function setPlaceholder() {
    opacity = 0;
    isplaceholder = true;
    el.text(placeholder).on('mouseover.opacity', function () {
      d3.select(this).transition().duration(interactConstants.SHOW_PLACEHOLDER).style('opacity', 1);
    }).on('mouseout.opacity', function () {
      d3.select(this).transition().duration(interactConstants.HIDE_PLACEHOLDER).style('opacity', 0);
    });
  }
  if (editable) {
    if (!txt) setPlaceholder();else el.on('.opacity', null);
    el.call(svgTextUtils.makeEditable, {
      gd: gd
    }).on('edit', function (text) {
      if (traceIndex !== undefined) {
        Registry.call('_guiRestyle', gd, prop, text, traceIndex);
      } else {
        Registry.call('_guiRelayout', gd, prop, text);
      }
    }).on('cancel', function () {
      this.text(this.attr('data-unformatted')).call(titleLayout);
    }).on('input', function (d) {
      this.text(d || ' ').call(svgTextUtils.positionText, attributes.x, attributes.y);
    });
  }
  el.classed('js-placeholder', isplaceholder);
  return group;
}
module.exports = {
  draw: draw
};

/***/ }),

/***/ 8444:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var fontAttrs = __webpack_require__(5376);
var colorAttrs = __webpack_require__(2548);
var extendFlat = (__webpack_require__(2880).extendFlat);
var overrideAll = (__webpack_require__(7824).overrideAll);
var padAttrs = __webpack_require__(6741);
var templatedArray = (__webpack_require__(1780).templatedArray);
var buttonsAttrs = templatedArray('button', {
  visible: {
    valType: 'boolean'
  },
  method: {
    valType: 'enumerated',
    values: ['restyle', 'relayout', 'animate', 'update', 'skip'],
    dflt: 'restyle'
  },
  args: {
    valType: 'info_array',
    freeLength: true,
    items: [{
      valType: 'any'
    }, {
      valType: 'any'
    }, {
      valType: 'any'
    }]
  },
  args2: {
    valType: 'info_array',
    freeLength: true,
    items: [{
      valType: 'any'
    }, {
      valType: 'any'
    }, {
      valType: 'any'
    }]
  },
  label: {
    valType: 'string',
    dflt: ''
  },
  execute: {
    valType: 'boolean',
    dflt: true
  }
});
module.exports = overrideAll(templatedArray('updatemenu', {
  _arrayAttrRegexps: [/^updatemenus\[(0|[1-9][0-9]+)\]\.buttons/],
  visible: {
    valType: 'boolean'
  },
  type: {
    valType: 'enumerated',
    values: ['dropdown', 'buttons'],
    dflt: 'dropdown'
  },
  direction: {
    valType: 'enumerated',
    values: ['left', 'right', 'up', 'down'],
    dflt: 'down'
  },
  active: {
    valType: 'integer',
    min: -1,
    dflt: 0
  },
  showactive: {
    valType: 'boolean',
    dflt: true
  },
  buttons: buttonsAttrs,
  x: {
    valType: 'number',
    min: -2,
    max: 3,
    dflt: -0.05
  },
  xanchor: {
    valType: 'enumerated',
    values: ['auto', 'left', 'center', 'right'],
    dflt: 'right'
  },
  y: {
    valType: 'number',
    min: -2,
    max: 3,
    dflt: 1
  },
  yanchor: {
    valType: 'enumerated',
    values: ['auto', 'top', 'middle', 'bottom'],
    dflt: 'top'
  },
  pad: extendFlat(padAttrs({
    editType: 'arraydraw'
  }), {}),
  font: fontAttrs({}),
  bgcolor: {
    valType: 'color'
  },
  bordercolor: {
    valType: 'color',
    dflt: colorAttrs.borderLine
  },
  borderwidth: {
    valType: 'number',
    min: 0,
    dflt: 1,
    editType: 'arraydraw'
  }
}), 'arraydraw', 'from-root');

/***/ }),

/***/ 1331:
/***/ (function(module) {

"use strict";


module.exports = {
  // layout attribute name
  name: 'updatemenus',
  // class names
  containerClassName: 'updatemenu-container',
  headerGroupClassName: 'updatemenu-header-group',
  headerClassName: 'updatemenu-header',
  headerArrowClassName: 'updatemenu-header-arrow',
  dropdownButtonGroupClassName: 'updatemenu-dropdown-button-group',
  dropdownButtonClassName: 'updatemenu-dropdown-button',
  buttonClassName: 'updatemenu-button',
  itemRectClassName: 'updatemenu-item-rect',
  itemTextClassName: 'updatemenu-item-text',
  // DOM attribute name in button group keeping track
  // of active update menu
  menuIndexAttrName: 'updatemenu-active-index',
  // id root pass to Plots.autoMargin
  autoMarginIdRoot: 'updatemenu-',
  // options when 'active: -1'
  blankHeaderOpts: {
    label: '  '
  },
  // min item width / height
  minWidth: 30,
  minHeight: 30,
  // padding around item text
  textPadX: 24,
  arrowPadX: 16,
  // item rect radii
  rx: 2,
  ry: 2,
  // item  text x offset off left edge
  textOffsetX: 12,
  // item  text y offset (w.r.t. middle)
  textOffsetY: 3,
  // arrow offset off right edge
  arrowOffsetX: 4,
  // gap between header and buttons
  gapButtonHeader: 5,
  // gap between between buttons
  gapButton: 2,
  // color given to active buttons
  activeColor: '#F4FAFF',
  // color given to hovered buttons
  hoverColor: '#F4FAFF',
  // symbol for menu open arrow
  arrowSymbol: {
    left: '◄',
    right: '►',
    up: '▲',
    down: '▼'
  }
};

/***/ }),

/***/ 1384:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var handleArrayContainerDefaults = __webpack_require__(1272);
var attributes = __webpack_require__(8444);
var constants = __webpack_require__(1331);
var name = constants.name;
var buttonAttrs = attributes.buttons;
module.exports = function updateMenusDefaults(layoutIn, layoutOut) {
  var opts = {
    name: name,
    handleItemDefaults: menuDefaults
  };
  handleArrayContainerDefaults(layoutIn, layoutOut, opts);
};
function menuDefaults(menuIn, menuOut, layoutOut) {
  function coerce(attr, dflt) {
    return Lib.coerce(menuIn, menuOut, attributes, attr, dflt);
  }
  var buttons = handleArrayContainerDefaults(menuIn, menuOut, {
    name: 'buttons',
    handleItemDefaults: buttonDefaults
  });
  var visible = coerce('visible', buttons.length > 0);
  if (!visible) return;
  coerce('active');
  coerce('direction');
  coerce('type');
  coerce('showactive');
  coerce('x');
  coerce('y');
  Lib.noneOrAll(menuIn, menuOut, ['x', 'y']);
  coerce('xanchor');
  coerce('yanchor');
  coerce('pad.t');
  coerce('pad.r');
  coerce('pad.b');
  coerce('pad.l');
  Lib.coerceFont(coerce, 'font', layoutOut.font);
  coerce('bgcolor', layoutOut.paper_bgcolor);
  coerce('bordercolor');
  coerce('borderwidth');
}
function buttonDefaults(buttonIn, buttonOut) {
  function coerce(attr, dflt) {
    return Lib.coerce(buttonIn, buttonOut, buttonAttrs, attr, dflt);
  }
  var visible = coerce('visible', buttonIn.method === 'skip' || Array.isArray(buttonIn.args));
  if (visible) {
    coerce('method');
    coerce('args');
    coerce('args2');
    coerce('label');
    coerce('execute');
  }
}

/***/ }),

/***/ 4420:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var Plots = __webpack_require__(7316);
var Color = __webpack_require__(6308);
var Drawing = __webpack_require__(3616);
var Lib = __webpack_require__(3400);
var svgTextUtils = __webpack_require__(2736);
var arrayEditor = (__webpack_require__(1780).arrayEditor);
var LINE_SPACING = (__webpack_require__(4284).LINE_SPACING);
var constants = __webpack_require__(1331);
var ScrollBox = __webpack_require__(7400);
module.exports = function draw(gd) {
  var fullLayout = gd._fullLayout;
  var menuData = Lib.filterVisible(fullLayout[constants.name]);

  /* Update menu data is bound to the header-group.
   * The items in the header group are always present.
   *
   * Upon clicking on a header its corresponding button
   * data is bound to the button-group.
   *
   * We draw all headers in one group before all buttons
   * so that the buttons *always* appear above the headers.
   *
   * Note that only one set of buttons are visible at once.
   *
   * <g container />
   *
   *     <g header-group />
   *         <g item header />
   *         <text item header-arrow />
   *     <g header-group />
   *         <g item header />
   *         <text item header-arrow />
   *     ...
   *
   *     <g button-group />
   *         <g item button />
   *         <g item button />
   *         ...
   */

  function clearAutoMargin(menuOpts) {
    Plots.autoMargin(gd, autoMarginId(menuOpts));
  }

  // draw update menu container
  var menus = fullLayout._menulayer.selectAll('g.' + constants.containerClassName).data(menuData.length > 0 ? [0] : []);
  menus.enter().append('g').classed(constants.containerClassName, true).style('cursor', 'pointer');
  menus.exit().each(function () {
    // Most components don't need to explicitly remove autoMargin, because
    // marginPushers does this - but updatemenu updates don't go through
    // a full replot so we need to explicitly remove it.
    // This is for removing *all* updatemenus, removing individuals is
    // handled below, in headerGroups.exit
    d3.select(this).selectAll('g.' + constants.headerGroupClassName).each(clearAutoMargin);
  }).remove();

  // return early if no update menus are visible
  if (menuData.length === 0) return;

  // join header group
  var headerGroups = menus.selectAll('g.' + constants.headerGroupClassName).data(menuData, keyFunction);
  headerGroups.enter().append('g').classed(constants.headerGroupClassName, true);

  // draw dropdown button container
  var gButton = Lib.ensureSingle(menus, 'g', constants.dropdownButtonGroupClassName, function (s) {
    s.style('pointer-events', 'all');
  });

  // find dimensions before plotting anything (this mutates menuOpts)
  for (var i = 0; i < menuData.length; i++) {
    var menuOpts = menuData[i];
    findDimensions(gd, menuOpts);
  }

  // setup scrollbox
  var scrollBoxId = 'updatemenus' + fullLayout._uid;
  var scrollBox = new ScrollBox(gd, gButton, scrollBoxId);

  // remove exiting header, remove dropped buttons and reset margins
  if (headerGroups.enter().size()) {
    // make sure gButton is on top of all headers
    gButton.node().parentNode.appendChild(gButton.node());
    gButton.call(removeAllButtons);
  }
  headerGroups.exit().each(function (menuOpts) {
    gButton.call(removeAllButtons);
    clearAutoMargin(menuOpts);
  }).remove();

  // draw headers!
  headerGroups.each(function (menuOpts) {
    var gHeader = d3.select(this);
    var _gButton = menuOpts.type === 'dropdown' ? gButton : null;
    Plots.manageCommandObserver(gd, menuOpts, menuOpts.buttons, function (data) {
      setActive(gd, menuOpts, menuOpts.buttons[data.index], gHeader, _gButton, scrollBox, data.index, true);
    });
    if (menuOpts.type === 'dropdown') {
      drawHeader(gd, gHeader, gButton, scrollBox, menuOpts);

      // if this menu is active, update the dropdown container
      if (isActive(gButton, menuOpts)) {
        drawButtons(gd, gHeader, gButton, scrollBox, menuOpts);
      }
    } else {
      drawButtons(gd, gHeader, null, null, menuOpts);
    }
  });
};

// Note that '_index' is set at the default step,
// it corresponds to the menu index in the user layout update menu container.
// Because a menu can be set invisible,
// this is a more 'consistent' field than the index in the menuData.
function keyFunction(menuOpts) {
  return menuOpts._index;
}
function isFolded(gButton) {
  return +gButton.attr(constants.menuIndexAttrName) === -1;
}
function isActive(gButton, menuOpts) {
  return +gButton.attr(constants.menuIndexAttrName) === menuOpts._index;
}
function setActive(gd, menuOpts, buttonOpts, gHeader, gButton, scrollBox, buttonIndex, isSilentUpdate) {
  // update 'active' attribute in menuOpts
  menuOpts.active = buttonIndex;

  // due to templating, it's possible this slider doesn't even exist yet
  arrayEditor(gd.layout, constants.name, menuOpts).applyUpdate('active', buttonIndex);
  if (menuOpts.type === 'buttons') {
    drawButtons(gd, gHeader, null, null, menuOpts);
  } else if (menuOpts.type === 'dropdown') {
    // fold up buttons and redraw header
    gButton.attr(constants.menuIndexAttrName, '-1');
    drawHeader(gd, gHeader, gButton, scrollBox, menuOpts);
    if (!isSilentUpdate) {
      drawButtons(gd, gHeader, gButton, scrollBox, menuOpts);
    }
  }
}
function drawHeader(gd, gHeader, gButton, scrollBox, menuOpts) {
  var header = Lib.ensureSingle(gHeader, 'g', constants.headerClassName, function (s) {
    s.style('pointer-events', 'all');
  });
  var dims = menuOpts._dims;
  var active = menuOpts.active;
  var headerOpts = menuOpts.buttons[active] || constants.blankHeaderOpts;
  var posOpts = {
    y: menuOpts.pad.t,
    yPad: 0,
    x: menuOpts.pad.l,
    xPad: 0,
    index: 0
  };
  var positionOverrides = {
    width: dims.headerWidth,
    height: dims.headerHeight
  };
  header.call(drawItem, menuOpts, headerOpts, gd).call(setItemPosition, menuOpts, posOpts, positionOverrides);

  // draw drop arrow at the right edge
  var arrow = Lib.ensureSingle(gHeader, 'text', constants.headerArrowClassName, function (s) {
    s.attr('text-anchor', 'end').call(Drawing.font, menuOpts.font).text(constants.arrowSymbol[menuOpts.direction]);
  });
  arrow.attr({
    x: dims.headerWidth - constants.arrowOffsetX + menuOpts.pad.l,
    y: dims.headerHeight / 2 + constants.textOffsetY + menuOpts.pad.t
  });
  header.on('click', function () {
    gButton.call(removeAllButtons, String(isActive(gButton, menuOpts) ? -1 : menuOpts._index));
    drawButtons(gd, gHeader, gButton, scrollBox, menuOpts);
  });
  header.on('mouseover', function () {
    header.call(styleOnMouseOver);
  });
  header.on('mouseout', function () {
    header.call(styleOnMouseOut, menuOpts);
  });

  // translate header group
  Drawing.setTranslate(gHeader, dims.lx, dims.ly);
}
function drawButtons(gd, gHeader, gButton, scrollBox, menuOpts) {
  // If this is a set of buttons, set pointer events = all since we play
  // some minor games with which container is which in order to simplify
  // the drawing of *either* buttons or menus
  if (!gButton) {
    gButton = gHeader;
    gButton.attr('pointer-events', 'all');
  }
  var buttonData = !isFolded(gButton) || menuOpts.type === 'buttons' ? menuOpts.buttons : [];
  var klass = menuOpts.type === 'dropdown' ? constants.dropdownButtonClassName : constants.buttonClassName;
  var buttons = gButton.selectAll('g.' + klass).data(Lib.filterVisible(buttonData));
  var enter = buttons.enter().append('g').classed(klass, true);
  var exit = buttons.exit();
  if (menuOpts.type === 'dropdown') {
    enter.attr('opacity', '0').transition().attr('opacity', '1');
    exit.transition().attr('opacity', '0').remove();
  } else {
    exit.remove();
  }
  var x0 = 0;
  var y0 = 0;
  var dims = menuOpts._dims;
  var isVertical = ['up', 'down'].indexOf(menuOpts.direction) !== -1;
  if (menuOpts.type === 'dropdown') {
    if (isVertical) {
      y0 = dims.headerHeight + constants.gapButtonHeader;
    } else {
      x0 = dims.headerWidth + constants.gapButtonHeader;
    }
  }
  if (menuOpts.type === 'dropdown' && menuOpts.direction === 'up') {
    y0 = -constants.gapButtonHeader + constants.gapButton - dims.openHeight;
  }
  if (menuOpts.type === 'dropdown' && menuOpts.direction === 'left') {
    x0 = -constants.gapButtonHeader + constants.gapButton - dims.openWidth;
  }
  var posOpts = {
    x: dims.lx + x0 + menuOpts.pad.l,
    y: dims.ly + y0 + menuOpts.pad.t,
    yPad: constants.gapButton,
    xPad: constants.gapButton,
    index: 0
  };
  var scrollBoxPosition = {
    l: posOpts.x + menuOpts.borderwidth,
    t: posOpts.y + menuOpts.borderwidth
  };
  buttons.each(function (buttonOpts, buttonIndex) {
    var button = d3.select(this);
    button.call(drawItem, menuOpts, buttonOpts, gd).call(setItemPosition, menuOpts, posOpts);
    button.on('click', function () {
      // skip `dragend` events
      if (d3.event.defaultPrevented) return;
      if (buttonOpts.execute) {
        if (buttonOpts.args2 && menuOpts.active === buttonIndex) {
          setActive(gd, menuOpts, buttonOpts, gHeader, gButton, scrollBox, -1);
          Plots.executeAPICommand(gd, buttonOpts.method, buttonOpts.args2);
        } else {
          setActive(gd, menuOpts, buttonOpts, gHeader, gButton, scrollBox, buttonIndex);
          Plots.executeAPICommand(gd, buttonOpts.method, buttonOpts.args);
        }
      }
      gd.emit('plotly_buttonclicked', {
        menu: menuOpts,
        button: buttonOpts,
        active: menuOpts.active
      });
    });
    button.on('mouseover', function () {
      button.call(styleOnMouseOver);
    });
    button.on('mouseout', function () {
      button.call(styleOnMouseOut, menuOpts);
      buttons.call(styleButtons, menuOpts);
    });
  });
  buttons.call(styleButtons, menuOpts);
  if (isVertical) {
    scrollBoxPosition.w = Math.max(dims.openWidth, dims.headerWidth);
    scrollBoxPosition.h = posOpts.y - scrollBoxPosition.t;
  } else {
    scrollBoxPosition.w = posOpts.x - scrollBoxPosition.l;
    scrollBoxPosition.h = Math.max(dims.openHeight, dims.headerHeight);
  }
  scrollBoxPosition.direction = menuOpts.direction;
  if (scrollBox) {
    if (buttons.size()) {
      drawScrollBox(gd, gHeader, gButton, scrollBox, menuOpts, scrollBoxPosition);
    } else {
      hideScrollBox(scrollBox);
    }
  }
}
function drawScrollBox(gd, gHeader, gButton, scrollBox, menuOpts, position) {
  // enable the scrollbox
  var direction = menuOpts.direction;
  var isVertical = direction === 'up' || direction === 'down';
  var dims = menuOpts._dims;
  var active = menuOpts.active;
  var translateX, translateY;
  var i;
  if (isVertical) {
    translateY = 0;
    for (i = 0; i < active; i++) {
      translateY += dims.heights[i] + constants.gapButton;
    }
  } else {
    translateX = 0;
    for (i = 0; i < active; i++) {
      translateX += dims.widths[i] + constants.gapButton;
    }
  }
  scrollBox.enable(position, translateX, translateY);
  if (scrollBox.hbar) {
    scrollBox.hbar.attr('opacity', '0').transition().attr('opacity', '1');
  }
  if (scrollBox.vbar) {
    scrollBox.vbar.attr('opacity', '0').transition().attr('opacity', '1');
  }
}
function hideScrollBox(scrollBox) {
  var hasHBar = !!scrollBox.hbar;
  var hasVBar = !!scrollBox.vbar;
  if (hasHBar) {
    scrollBox.hbar.transition().attr('opacity', '0').each('end', function () {
      hasHBar = false;
      if (!hasVBar) scrollBox.disable();
    });
  }
  if (hasVBar) {
    scrollBox.vbar.transition().attr('opacity', '0').each('end', function () {
      hasVBar = false;
      if (!hasHBar) scrollBox.disable();
    });
  }
}
function drawItem(item, menuOpts, itemOpts, gd) {
  item.call(drawItemRect, menuOpts).call(drawItemText, menuOpts, itemOpts, gd);
}
function drawItemRect(item, menuOpts) {
  var rect = Lib.ensureSingle(item, 'rect', constants.itemRectClassName, function (s) {
    s.attr({
      rx: constants.rx,
      ry: constants.ry,
      'shape-rendering': 'crispEdges'
    });
  });
  rect.call(Color.stroke, menuOpts.bordercolor).call(Color.fill, menuOpts.bgcolor).style('stroke-width', menuOpts.borderwidth + 'px');
}
function drawItemText(item, menuOpts, itemOpts, gd) {
  var text = Lib.ensureSingle(item, 'text', constants.itemTextClassName, function (s) {
    s.attr({
      'text-anchor': 'start',
      'data-notex': 1
    });
  });
  var tx = itemOpts.label;
  var _meta = gd._fullLayout._meta;
  if (_meta) tx = Lib.templateString(tx, _meta);
  text.call(Drawing.font, menuOpts.font).text(tx).call(svgTextUtils.convertToTspans, gd);
}
function styleButtons(buttons, menuOpts) {
  var active = menuOpts.active;
  buttons.each(function (buttonOpts, i) {
    var button = d3.select(this);
    if (i === active && menuOpts.showactive) {
      button.select('rect.' + constants.itemRectClassName).call(Color.fill, constants.activeColor);
    }
  });
}
function styleOnMouseOver(item) {
  item.select('rect.' + constants.itemRectClassName).call(Color.fill, constants.hoverColor);
}
function styleOnMouseOut(item, menuOpts) {
  item.select('rect.' + constants.itemRectClassName).call(Color.fill, menuOpts.bgcolor);
}

// find item dimensions (this mutates menuOpts)
function findDimensions(gd, menuOpts) {
  var dims = menuOpts._dims = {
    width1: 0,
    height1: 0,
    heights: [],
    widths: [],
    totalWidth: 0,
    totalHeight: 0,
    openWidth: 0,
    openHeight: 0,
    lx: 0,
    ly: 0
  };
  var fakeButtons = Drawing.tester.selectAll('g.' + constants.dropdownButtonClassName).data(Lib.filterVisible(menuOpts.buttons));
  fakeButtons.enter().append('g').classed(constants.dropdownButtonClassName, true);
  var isVertical = ['up', 'down'].indexOf(menuOpts.direction) !== -1;

  // loop over fake buttons to find width / height
  fakeButtons.each(function (buttonOpts, i) {
    var button = d3.select(this);
    button.call(drawItem, menuOpts, buttonOpts, gd);
    var text = button.select('.' + constants.itemTextClassName);

    // width is given by max width of all buttons
    var tWidth = text.node() && Drawing.bBox(text.node()).width;
    var wEff = Math.max(tWidth + constants.textPadX, constants.minWidth);

    // height is determined by item text
    var tHeight = menuOpts.font.size * LINE_SPACING;
    var tLines = svgTextUtils.lineCount(text);
    var hEff = Math.max(tHeight * tLines, constants.minHeight) + constants.textOffsetY;
    hEff = Math.ceil(hEff);
    wEff = Math.ceil(wEff);

    // Store per-item sizes since a row of horizontal buttons, for example,
    // don't all need to be the same width:
    dims.widths[i] = wEff;
    dims.heights[i] = hEff;

    // Height and width of individual element:
    dims.height1 = Math.max(dims.height1, hEff);
    dims.width1 = Math.max(dims.width1, wEff);
    if (isVertical) {
      dims.totalWidth = Math.max(dims.totalWidth, wEff);
      dims.openWidth = dims.totalWidth;
      dims.totalHeight += hEff + constants.gapButton;
      dims.openHeight += hEff + constants.gapButton;
    } else {
      dims.totalWidth += wEff + constants.gapButton;
      dims.openWidth += wEff + constants.gapButton;
      dims.totalHeight = Math.max(dims.totalHeight, hEff);
      dims.openHeight = dims.totalHeight;
    }
  });
  if (isVertical) {
    dims.totalHeight -= constants.gapButton;
  } else {
    dims.totalWidth -= constants.gapButton;
  }
  dims.headerWidth = dims.width1 + constants.arrowPadX;
  dims.headerHeight = dims.height1;
  if (menuOpts.type === 'dropdown') {
    if (isVertical) {
      dims.width1 += constants.arrowPadX;
      dims.totalHeight = dims.height1;
    } else {
      dims.totalWidth = dims.width1;
    }
    dims.totalWidth += constants.arrowPadX;
  }
  fakeButtons.remove();
  var paddedWidth = dims.totalWidth + menuOpts.pad.l + menuOpts.pad.r;
  var paddedHeight = dims.totalHeight + menuOpts.pad.t + menuOpts.pad.b;
  var graphSize = gd._fullLayout._size;
  dims.lx = graphSize.l + graphSize.w * menuOpts.x;
  dims.ly = graphSize.t + graphSize.h * (1 - menuOpts.y);
  var xanchor = 'left';
  if (Lib.isRightAnchor(menuOpts)) {
    dims.lx -= paddedWidth;
    xanchor = 'right';
  }
  if (Lib.isCenterAnchor(menuOpts)) {
    dims.lx -= paddedWidth / 2;
    xanchor = 'center';
  }
  var yanchor = 'top';
  if (Lib.isBottomAnchor(menuOpts)) {
    dims.ly -= paddedHeight;
    yanchor = 'bottom';
  }
  if (Lib.isMiddleAnchor(menuOpts)) {
    dims.ly -= paddedHeight / 2;
    yanchor = 'middle';
  }
  dims.totalWidth = Math.ceil(dims.totalWidth);
  dims.totalHeight = Math.ceil(dims.totalHeight);
  dims.lx = Math.round(dims.lx);
  dims.ly = Math.round(dims.ly);
  Plots.autoMargin(gd, autoMarginId(menuOpts), {
    x: menuOpts.x,
    y: menuOpts.y,
    l: paddedWidth * ({
      right: 1,
      center: 0.5
    }[xanchor] || 0),
    r: paddedWidth * ({
      left: 1,
      center: 0.5
    }[xanchor] || 0),
    b: paddedHeight * ({
      top: 1,
      middle: 0.5
    }[yanchor] || 0),
    t: paddedHeight * ({
      bottom: 1,
      middle: 0.5
    }[yanchor] || 0)
  });
}
function autoMarginId(menuOpts) {
  return constants.autoMarginIdRoot + menuOpts._index;
}

// set item positions (mutates posOpts)
function setItemPosition(item, menuOpts, posOpts, overrideOpts) {
  overrideOpts = overrideOpts || {};
  var rect = item.select('.' + constants.itemRectClassName);
  var text = item.select('.' + constants.itemTextClassName);
  var borderWidth = menuOpts.borderwidth;
  var index = posOpts.index;
  var dims = menuOpts._dims;
  Drawing.setTranslate(item, borderWidth + posOpts.x, borderWidth + posOpts.y);
  var isVertical = ['up', 'down'].indexOf(menuOpts.direction) !== -1;
  var finalHeight = overrideOpts.height || (isVertical ? dims.heights[index] : dims.height1);
  rect.attr({
    x: 0,
    y: 0,
    width: overrideOpts.width || (isVertical ? dims.width1 : dims.widths[index]),
    height: finalHeight
  });
  var tHeight = menuOpts.font.size * LINE_SPACING;
  var tLines = svgTextUtils.lineCount(text);
  var spanOffset = (tLines - 1) * tHeight / 2;
  svgTextUtils.positionText(text, constants.textOffsetX, finalHeight / 2 - spanOffset + constants.textOffsetY);
  if (isVertical) {
    posOpts.y += dims.heights[index] + posOpts.yPad;
  } else {
    posOpts.x += dims.widths[index] + posOpts.xPad;
  }
  posOpts.index++;
}
function removeAllButtons(gButton, newMenuIndexAttr) {
  gButton.attr(constants.menuIndexAttrName, newMenuIndexAttr || '-1').selectAll('g.' + constants.dropdownButtonClassName).remove();
}

/***/ }),

/***/ 6908:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var constants = __webpack_require__(1331);
module.exports = {
  moduleType: 'component',
  name: constants.name,
  layoutAttributes: __webpack_require__(8444),
  supplyLayoutDefaults: __webpack_require__(1384),
  draw: __webpack_require__(4420)
};

/***/ }),

/***/ 7400:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = ScrollBox;
var d3 = __webpack_require__(3428);
var Color = __webpack_require__(6308);
var Drawing = __webpack_require__(3616);
var Lib = __webpack_require__(3400);

/**
 * Helper class to setup a scroll box
 *
 * @class
 * @param           gd          Plotly's graph div
 * @param           container   Container to be scroll-boxed (as a D3 selection)
 * @param {string}  id          Id for the clip path to implement the scroll box
 */
function ScrollBox(gd, container, id) {
  this.gd = gd;
  this.container = container;
  this.id = id;

  // See ScrollBox.prototype.enable for further definition
  this.position = null; // scrollbox position
  this.translateX = null; // scrollbox horizontal translation
  this.translateY = null; // scrollbox vertical translation
  this.hbar = null; // horizontal scrollbar D3 selection
  this.vbar = null; // vertical scrollbar D3 selection

  // <rect> element to capture pointer events
  this.bg = this.container.selectAll('rect.scrollbox-bg').data([0]);
  this.bg.exit().on('.drag', null).on('wheel', null).remove();
  this.bg.enter().append('rect').classed('scrollbox-bg', true).style('pointer-events', 'all').attr({
    opacity: 0,
    x: 0,
    y: 0,
    width: 0,
    height: 0
  });
}

// scroll bar dimensions
ScrollBox.barWidth = 2;
ScrollBox.barLength = 20;
ScrollBox.barRadius = 2;
ScrollBox.barPad = 1;
ScrollBox.barColor = '#808BA4';

/**
 * If needed, setup a clip path and scrollbars
 *
 * @method
 * @param {Object}  position
 * @param {number}  position.l  Left side position (in pixels)
 * @param {number}  position.t  Top side (in pixels)
 * @param {number}  position.w  Width (in pixels)
 * @param {number}  position.h  Height (in pixels)
 * @param {string}  [position.direction='down']
 *                  Either 'down', 'left', 'right' or 'up'
 * @param {number}  [translateX=0]  Horizontal offset (in pixels)
 * @param {number}  [translateY=0]  Vertical offset (in pixels)
 */
ScrollBox.prototype.enable = function enable(position, translateX, translateY) {
  var fullLayout = this.gd._fullLayout;
  var fullWidth = fullLayout.width;
  var fullHeight = fullLayout.height;

  // compute position of scrollbox
  this.position = position;
  var l = this.position.l;
  var w = this.position.w;
  var t = this.position.t;
  var h = this.position.h;
  var direction = this.position.direction;
  var isDown = direction === 'down';
  var isLeft = direction === 'left';
  var isRight = direction === 'right';
  var isUp = direction === 'up';
  var boxW = w;
  var boxH = h;
  var boxL, boxR;
  var boxT, boxB;
  if (!isDown && !isLeft && !isRight && !isUp) {
    this.position.direction = 'down';
    isDown = true;
  }
  var isVertical = isDown || isUp;
  if (isVertical) {
    boxL = l;
    boxR = boxL + boxW;
    if (isDown) {
      // anchor to top side
      boxT = t;
      boxB = Math.min(boxT + boxH, fullHeight);
      boxH = boxB - boxT;
    } else {
      // anchor to bottom side
      boxB = t + boxH;
      boxT = Math.max(boxB - boxH, 0);
      boxH = boxB - boxT;
    }
  } else {
    boxT = t;
    boxB = boxT + boxH;
    if (isLeft) {
      // anchor to right side
      boxR = l + boxW;
      boxL = Math.max(boxR - boxW, 0);
      boxW = boxR - boxL;
    } else {
      // anchor to left side
      boxL = l;
      boxR = Math.min(boxL + boxW, fullWidth);
      boxW = boxR - boxL;
    }
  }
  this._box = {
    l: boxL,
    t: boxT,
    w: boxW,
    h: boxH
  };

  // compute position of horizontal scroll bar
  var needsHorizontalScrollBar = w > boxW;
  var hbarW = ScrollBox.barLength + 2 * ScrollBox.barPad;
  var hbarH = ScrollBox.barWidth + 2 * ScrollBox.barPad;
  // draw horizontal scrollbar on the bottom side
  var hbarL = l;
  var hbarT = t + h;
  if (hbarT + hbarH > fullHeight) hbarT = fullHeight - hbarH;
  var hbar = this.container.selectAll('rect.scrollbar-horizontal').data(needsHorizontalScrollBar ? [0] : []);
  hbar.exit().on('.drag', null).remove();
  hbar.enter().append('rect').classed('scrollbar-horizontal', true).call(Color.fill, ScrollBox.barColor);
  if (needsHorizontalScrollBar) {
    this.hbar = hbar.attr({
      rx: ScrollBox.barRadius,
      ry: ScrollBox.barRadius,
      x: hbarL,
      y: hbarT,
      width: hbarW,
      height: hbarH
    });

    // hbar center moves between hbarXMin and hbarXMin + hbarTranslateMax
    this._hbarXMin = hbarL + hbarW / 2;
    this._hbarTranslateMax = boxW - hbarW;
  } else {
    delete this.hbar;
    delete this._hbarXMin;
    delete this._hbarTranslateMax;
  }

  // compute position of vertical scroll bar
  var needsVerticalScrollBar = h > boxH;
  var vbarW = ScrollBox.barWidth + 2 * ScrollBox.barPad;
  var vbarH = ScrollBox.barLength + 2 * ScrollBox.barPad;
  // draw vertical scrollbar on the right side
  var vbarL = l + w;
  var vbarT = t;
  if (vbarL + vbarW > fullWidth) vbarL = fullWidth - vbarW;
  var vbar = this.container.selectAll('rect.scrollbar-vertical').data(needsVerticalScrollBar ? [0] : []);
  vbar.exit().on('.drag', null).remove();
  vbar.enter().append('rect').classed('scrollbar-vertical', true).call(Color.fill, ScrollBox.barColor);
  if (needsVerticalScrollBar) {
    this.vbar = vbar.attr({
      rx: ScrollBox.barRadius,
      ry: ScrollBox.barRadius,
      x: vbarL,
      y: vbarT,
      width: vbarW,
      height: vbarH
    });

    // vbar center moves between vbarYMin and vbarYMin + vbarTranslateMax
    this._vbarYMin = vbarT + vbarH / 2;
    this._vbarTranslateMax = boxH - vbarH;
  } else {
    delete this.vbar;
    delete this._vbarYMin;
    delete this._vbarTranslateMax;
  }

  // setup a clip path (if scroll bars are needed)
  var clipId = this.id;
  var clipL = boxL - 0.5;
  var clipR = needsVerticalScrollBar ? boxR + vbarW + 0.5 : boxR + 0.5;
  var clipT = boxT - 0.5;
  var clipB = needsHorizontalScrollBar ? boxB + hbarH + 0.5 : boxB + 0.5;
  var clipPath = fullLayout._topdefs.selectAll('#' + clipId).data(needsHorizontalScrollBar || needsVerticalScrollBar ? [0] : []);
  clipPath.exit().remove();
  clipPath.enter().append('clipPath').attr('id', clipId).append('rect');
  if (needsHorizontalScrollBar || needsVerticalScrollBar) {
    this._clipRect = clipPath.select('rect').attr({
      x: Math.floor(clipL),
      y: Math.floor(clipT),
      width: Math.ceil(clipR) - Math.floor(clipL),
      height: Math.ceil(clipB) - Math.floor(clipT)
    });
    this.container.call(Drawing.setClipUrl, clipId, this.gd);
    this.bg.attr({
      x: l,
      y: t,
      width: w,
      height: h
    });
  } else {
    this.bg.attr({
      width: 0,
      height: 0
    });
    this.container.on('wheel', null).on('.drag', null).call(Drawing.setClipUrl, null);
    delete this._clipRect;
  }

  // set up drag listeners (if scroll bars are needed)
  if (needsHorizontalScrollBar || needsVerticalScrollBar) {
    var onBoxDrag = d3.behavior.drag().on('dragstart', function () {
      d3.event.sourceEvent.preventDefault();
    }).on('drag', this._onBoxDrag.bind(this));
    this.container.on('wheel', null).on('wheel', this._onBoxWheel.bind(this)).on('.drag', null).call(onBoxDrag);
    var onBarDrag = d3.behavior.drag().on('dragstart', function () {
      d3.event.sourceEvent.preventDefault();
      d3.event.sourceEvent.stopPropagation();
    }).on('drag', this._onBarDrag.bind(this));
    if (needsHorizontalScrollBar) {
      this.hbar.on('.drag', null).call(onBarDrag);
    }
    if (needsVerticalScrollBar) {
      this.vbar.on('.drag', null).call(onBarDrag);
    }
  }

  // set scrollbox translation
  this.setTranslate(translateX, translateY);
};

/**
 * If present, remove clip-path and scrollbars
 *
 * @method
 */
ScrollBox.prototype.disable = function disable() {
  if (this.hbar || this.vbar) {
    this.bg.attr({
      width: 0,
      height: 0
    });
    this.container.on('wheel', null).on('.drag', null).call(Drawing.setClipUrl, null);
    delete this._clipRect;
  }
  if (this.hbar) {
    this.hbar.on('.drag', null);
    this.hbar.remove();
    delete this.hbar;
    delete this._hbarXMin;
    delete this._hbarTranslateMax;
  }
  if (this.vbar) {
    this.vbar.on('.drag', null);
    this.vbar.remove();
    delete this.vbar;
    delete this._vbarYMin;
    delete this._vbarTranslateMax;
  }
};

/**
 * Handles scroll box drag events
 *
 * @method
 */
ScrollBox.prototype._onBoxDrag = function _onBoxDrag() {
  var translateX = this.translateX;
  var translateY = this.translateY;
  if (this.hbar) {
    translateX -= d3.event.dx;
  }
  if (this.vbar) {
    translateY -= d3.event.dy;
  }
  this.setTranslate(translateX, translateY);
};

/**
 * Handles scroll box wheel events
 *
 * @method
 */
ScrollBox.prototype._onBoxWheel = function _onBoxWheel() {
  var translateX = this.translateX;
  var translateY = this.translateY;
  if (this.hbar) {
    translateX += d3.event.deltaY;
  }
  if (this.vbar) {
    translateY += d3.event.deltaY;
  }
  this.setTranslate(translateX, translateY);
};

/**
 * Handles scroll bar drag events
 *
 * @method
 */
ScrollBox.prototype._onBarDrag = function _onBarDrag() {
  var translateX = this.translateX;
  var translateY = this.translateY;
  if (this.hbar) {
    var xMin = translateX + this._hbarXMin;
    var xMax = xMin + this._hbarTranslateMax;
    var x = Lib.constrain(d3.event.x, xMin, xMax);
    var xf = (x - xMin) / (xMax - xMin);
    var translateXMax = this.position.w - this._box.w;
    translateX = xf * translateXMax;
  }
  if (this.vbar) {
    var yMin = translateY + this._vbarYMin;
    var yMax = yMin + this._vbarTranslateMax;
    var y = Lib.constrain(d3.event.y, yMin, yMax);
    var yf = (y - yMin) / (yMax - yMin);
    var translateYMax = this.position.h - this._box.h;
    translateY = yf * translateYMax;
  }
  this.setTranslate(translateX, translateY);
};

/**
 * Set clip path and scroll bar translate transform
 *
 * @method
 * @param {number}  [translateX=0]  Horizontal offset (in pixels)
 * @param {number}  [translateY=0]  Vertical offset (in pixels)
 */
ScrollBox.prototype.setTranslate = function setTranslate(translateX, translateY) {
  // store translateX and translateY (needed by mouse event handlers)
  var translateXMax = this.position.w - this._box.w;
  var translateYMax = this.position.h - this._box.h;
  translateX = Lib.constrain(translateX || 0, 0, translateXMax);
  translateY = Lib.constrain(translateY || 0, 0, translateYMax);
  this.translateX = translateX;
  this.translateY = translateY;
  this.container.call(Drawing.setTranslate, this._box.l - this.position.l - translateX, this._box.t - this.position.t - translateY);
  if (this._clipRect) {
    this._clipRect.attr({
      x: Math.floor(this.position.l + translateX - 0.5),
      y: Math.floor(this.position.t + translateY - 0.5)
    });
  }
  if (this.hbar) {
    var xf = translateX / translateXMax;
    this.hbar.call(Drawing.setTranslate, translateX + xf * this._hbarTranslateMax, translateY);
  }
  if (this.vbar) {
    var yf = translateY / translateYMax;
    this.vbar.call(Drawing.setTranslate, translateX, translateY + yf * this._vbarTranslateMax);
  }
};

/***/ }),

/***/ 4284:
/***/ (function(module) {

"use strict";


// fraction of some size to get to a named position
module.exports = {
  // from bottom left: this is the origin of our paper-reference
  // positioning system
  FROM_BL: {
    left: 0,
    center: 0.5,
    right: 1,
    bottom: 0,
    middle: 0.5,
    top: 1
  },
  // from top left: this is the screen pixel positioning origin
  FROM_TL: {
    left: 0,
    center: 0.5,
    right: 1,
    bottom: 1,
    middle: 0.5,
    top: 0
  },
  // from bottom right: sometimes you just need the opposite of ^^
  FROM_BR: {
    left: 1,
    center: 0.5,
    right: 0,
    bottom: 0,
    middle: 0.5,
    top: 1
  },
  // multiple of fontSize to get the vertical offset between lines
  LINE_SPACING: 1.3,
  // multiple of fontSize to shift from the baseline
  // to the cap (captical letter) line
  // (to use when we don't calculate this shift from Drawing.bBox)
  // This is an approximation since in reality cap height can differ
  // from font to font. However, according to Wikipedia
  //   an "average" font might have a cap height of 70% of the em
  // https://en.wikipedia.org/wiki/Em_(typography)#History
  CAP_SHIFT: 0.70,
  // half the cap height (distance between baseline and cap line)
  // of an "average" font (for more info see above).
  MID_SHIFT: 0.35,
  OPPOSITE_SIDE: {
    left: 'right',
    right: 'left',
    top: 'bottom',
    bottom: 'top'
  }
};

/***/ }),

/***/ 6208:
/***/ (function(module) {

"use strict";


module.exports = {
  axisRefDescription: function (axisname, lower, upper) {
    return ['If set to a', axisname, 'axis id (e.g. *' + axisname + '* or', '*' + axisname + '2*), the `' + axisname + '` position refers to a', axisname, 'coordinate. If set to *paper*, the `' + axisname + '`', 'position refers to the distance from the', lower, 'of the plotting', 'area in normalized coordinates where *0* (*1*) corresponds to the', lower, '(' + upper + '). If set to a', axisname, 'axis ID followed by', '*domain* (separated by a space), the position behaves like for', '*paper*, but refers to the distance in fractions of the domain', 'length from the', lower, 'of the domain of that axis: e.g.,', '*' + axisname + '2 domain* refers to the domain of the second', axisname, ' axis and a', axisname, 'position of 0.5 refers to the', 'point between the', lower, 'and the', upper, 'of the domain of the', 'second', axisname, 'axis.'].join(' ');
  }
};

/***/ }),

/***/ 6880:
/***/ (function(module) {

"use strict";


module.exports = {
  FORMAT_LINK: 'https://github.com/d3/d3-format/tree/v1.4.5#d3-format',
  DATE_FORMAT_LINK: 'https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format'
};

/***/ }),

/***/ 9104:
/***/ (function(module) {

"use strict";


module.exports = {
  COMPARISON_OPS: ['=', '!=', '<', '>=', '>', '<='],
  COMPARISON_OPS2: ['=', '<', '>=', '>', '<='],
  INTERVAL_OPS: ['[]', '()', '[)', '(]', '][', ')(', '](', ')['],
  SET_OPS: ['{}', '}{'],
  CONSTRAINT_REDUCTION: {
    // for contour constraints, open/closed endpoints are equivalent
    '=': '=',
    '<': '<',
    '<=': '<',
    '>': '>',
    '>=': '>',
    '[]': '[]',
    '()': '[]',
    '[)': '[]',
    '(]': '[]',
    '][': '][',
    ')(': '][',
    '](': '][',
    ')[': ']['
  }
};

/***/ }),

/***/ 3448:
/***/ (function(module) {

"use strict";


module.exports = {
  /**
   * Timing information for interactive elements
   */
  SHOW_PLACEHOLDER: 100,
  HIDE_PLACEHOLDER: 1000,
  // opacity dimming fraction for points that are not in selection
  DESELECTDIM: 0.2
};

/***/ }),

/***/ 9032:
/***/ (function(module) {

"use strict";


module.exports = {
  /**
   * Standardize all missing data in calcdata to use undefined
   * never null or NaN.
   * That way we can use !==undefined, or !== BADNUM,
   * to test for real data
   */
  BADNUM: undefined,
  /*
   * Limit certain operations to well below floating point max value
   * to avoid glitches: Make sure that even when you multiply it by the
   * number of pixels on a giant screen it still works
   */
  FP_SAFE: Number.MAX_VALUE * 1e-4,
  /*
   * conversion of date units to milliseconds
   * year and month constants are marked "AVG"
   * to remind us that not all years and months
   * have the same length
   */
  ONEMAXYEAR: 31622400000,
  // 366 * ONEDAY
  ONEAVGYEAR: 31557600000,
  // 365.25 days
  ONEMINYEAR: 31536000000,
  // 365 * ONEDAY
  ONEMAXQUARTER: 7948800000,
  // 92 * ONEDAY
  ONEAVGQUARTER: 7889400000,
  // 1/4 of ONEAVGYEAR
  ONEMINQUARTER: 7689600000,
  // 89 * ONEDAY
  ONEMAXMONTH: 2678400000,
  // 31 * ONEDAY
  ONEAVGMONTH: 2629800000,
  // 1/12 of ONEAVGYEAR
  ONEMINMONTH: 2419200000,
  // 28 * ONEDAY
  ONEWEEK: 604800000,
  // 7 * ONEDAY
  ONEDAY: 86400000,
  // 24 * ONEHOUR
  ONEHOUR: 3600000,
  ONEMIN: 60000,
  ONESEC: 1000,
  /*
   * For fast conversion btwn world calendars and epoch ms, the Julian Day Number
   * of the unix epoch. From calendars.instance().newDate(1970, 1, 1).toJD()
   */
  EPOCHJD: 2440587.5,
  /*
   * Are two values nearly equal? Compare to 1PPM
   */
  ALMOST_EQUAL: 1 - 1e-6,
  /*
   * If we're asked to clip a non-positive log value, how far off-screen
   * do we put it?
   */
  LOG_CLIP: 10,
  /*
   * not a number, but for displaying numbers: the "minus sign" symbol is
   * wider than the regular ascii dash "-"
   */
  MINUS_SIGN: '\u2212'
};

/***/ }),

/***/ 9616:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


exports.xmlns = 'http://www.w3.org/2000/xmlns/';
exports.svg = 'http://www.w3.org/2000/svg';
exports.xlink = 'http://www.w3.org/1999/xlink';

// the 'old' d3 quirk got fix in v3.5.7
// https://github.com/mbostock/d3/commit/a6f66e9dd37f764403fc7c1f26be09ab4af24fed
exports.svgAttrs = {
  xmlns: exports.svg,
  'xmlns:xlink': exports.xlink
};

/***/ }),

/***/ 4884:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


exports.version = __webpack_require__(5788).version;

// inject promise polyfill
__webpack_require__(8324);

// inject plot css
__webpack_require__(9288);

// include registry module and expose register method
var Registry = __webpack_require__(4040);
var register = exports.register = Registry.register;

// expose plot api methods
var plotApi = __webpack_require__(2448);
var methodNames = Object.keys(plotApi);
for (var i = 0; i < methodNames.length; i++) {
  var name = methodNames[i];
  // _ -> private API methods, but still registered for internal use
  if (name.charAt(0) !== '_') exports[name] = plotApi[name];
  register({
    moduleType: 'apiMethod',
    name: name,
    fn: plotApi[name]
  });
}

// scatter is the only trace included by default
register(__webpack_require__(5875));

// register all registrable components modules
register([__webpack_require__(9180), __webpack_require__(6864), __webpack_require__(2676), __webpack_require__(1592), __webpack_require__(7402), __webpack_require__(6908), __webpack_require__(7544), __webpack_require__(9692), __webpack_require__(1152), __webpack_require__(2704), __webpack_require__(4968), __webpack_require__(8932), __webpack_require__(5080), __webpack_require__(2780),
// legend needs to come after shape | legend defaults depends on shapes
__webpack_require__(3024),
// fx needs to come after legend | unified hover defaults depends on legends
__webpack_require__(3080)]);

// locales en and en-US are required for default behavior
register([__webpack_require__(6580), __webpack_require__(1680)]);

// locales that are present in the window should be loaded
if (window.PlotlyLocales && Array.isArray(window.PlotlyLocales)) {
  register(window.PlotlyLocales);
  delete window.PlotlyLocales;
}

// plot icons
exports.Icons = __webpack_require__(9224);

// unofficial 'beta' plot methods, use at your own risk
var Fx = __webpack_require__(3024);
var Plots = __webpack_require__(7316);
exports.Plots = {
  resize: Plots.resize,
  graphJson: Plots.graphJson,
  sendDataToCloud: Plots.sendDataToCloud
};
exports.Fx = {
  hover: Fx.hover,
  unhover: Fx.unhover,
  loneHover: Fx.loneHover,
  loneUnhover: Fx.loneUnhover
};
exports.Snapshot = __webpack_require__(8904);
exports.PlotSchema = __webpack_require__(3060);

/***/ }),

/***/ 9224:
/***/ (function(module) {

"use strict";


module.exports = {
  undo: {
    width: 857.1,
    height: 1000,
    path: 'm857 350q0-87-34-166t-91-137-137-92-166-34q-96 0-183 41t-147 114q-4 6-4 13t5 11l76 77q6 5 14 5 9-1 13-7 41-53 100-82t126-29q58 0 110 23t92 61 61 91 22 111-22 111-61 91-92 61-110 23q-55 0-105-20t-90-57l77-77q17-16 8-38-10-23-33-23h-250q-15 0-25 11t-11 25v250q0 24 22 33 22 10 39-8l72-72q60 57 137 88t159 31q87 0 166-34t137-92 91-137 34-166z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  home: {
    width: 928.6,
    height: 1000,
    path: 'm786 296v-267q0-15-11-26t-25-10h-214v214h-143v-214h-214q-15 0-25 10t-11 26v267q0 1 0 2t0 2l321 264 321-264q1-1 1-4z m124 39l-34-41q-5-5-12-6h-2q-7 0-12 3l-386 322-386-322q-7-4-13-4-7 2-12 7l-35 41q-4 5-3 13t6 12l401 334q18 15 42 15t43-15l136-114v109q0 8 5 13t13 5h107q8 0 13-5t5-13v-227l122-102q5-5 6-12t-4-13z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  'camera-retro': {
    width: 1000,
    height: 1000,
    path: 'm518 386q0 8-5 13t-13 5q-37 0-63-27t-26-63q0-8 5-13t13-5 12 5 5 13q0 23 16 38t38 16q8 0 13 5t5 13z m125-73q0-59-42-101t-101-42-101 42-42 101 42 101 101 42 101-42 42-101z m-572-320h858v71h-858v-71z m643 320q0 89-62 152t-152 62-151-62-63-152 63-151 151-63 152 63 62 151z m-571 358h214v72h-214v-72z m-72-107h858v143h-462l-36-71h-360v-72z m929 143v-714q0-30-21-51t-50-21h-858q-29 0-50 21t-21 51v714q0 30 21 51t50 21h858q29 0 50-21t21-51z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  zoombox: {
    width: 1000,
    height: 1000,
    path: 'm1000-25l-250 251c40 63 63 138 63 218 0 224-182 406-407 406-224 0-406-182-406-406s183-406 407-406c80 0 155 22 218 62l250-250 125 125z m-812 250l0 438 437 0 0-438-437 0z m62 375l313 0 0-312-313 0 0 312z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  pan: {
    width: 1000,
    height: 1000,
    path: 'm1000 350l-187 188 0-125-250 0 0 250 125 0-188 187-187-187 125 0 0-250-250 0 0 125-188-188 186-187 0 125 252 0 0-250-125 0 187-188 188 188-125 0 0 250 250 0 0-126 187 188z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  zoom_plus: {
    width: 875,
    height: 1000,
    path: 'm1 787l0-875 875 0 0 875-875 0z m687-500l-187 0 0-187-125 0 0 187-188 0 0 125 188 0 0 187 125 0 0-187 187 0 0-125z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  zoom_minus: {
    width: 875,
    height: 1000,
    path: 'm0 788l0-876 875 0 0 876-875 0z m688-500l-500 0 0 125 500 0 0-125z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  autoscale: {
    width: 1000,
    height: 1000,
    path: 'm250 850l-187 0-63 0 0-62 0-188 63 0 0 188 187 0 0 62z m688 0l-188 0 0-62 188 0 0-188 62 0 0 188 0 62-62 0z m-875-938l0 188-63 0 0-188 0-62 63 0 187 0 0 62-187 0z m875 188l0-188-188 0 0-62 188 0 62 0 0 62 0 188-62 0z m-125 188l-1 0-93-94-156 156 156 156 92-93 2 0 0 250-250 0 0-2 93-92-156-156-156 156 94 92 0 2-250 0 0-250 0 0 93 93 157-156-157-156-93 94 0 0 0-250 250 0 0 0-94 93 156 157 156-157-93-93 0 0 250 0 0 250z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  tooltip_basic: {
    width: 1500,
    height: 1000,
    path: 'm375 725l0 0-375-375 375-374 0-1 1125 0 0 750-1125 0z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  tooltip_compare: {
    width: 1125,
    height: 1000,
    path: 'm187 786l0 2-187-188 188-187 0 0 937 0 0 373-938 0z m0-499l0 1-187-188 188-188 0 0 937 0 0 376-938-1z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  plotlylogo: {
    width: 1542,
    height: 1000,
    path: 'm0-10h182v-140h-182v140z m228 146h183v-286h-183v286z m225 714h182v-1000h-182v1000z m225-285h182v-715h-182v715z m225 142h183v-857h-183v857z m231-428h182v-429h-182v429z m225-291h183v-138h-183v138z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  'z-axis': {
    width: 1000,
    height: 1000,
    path: 'm833 5l-17 108v41l-130-65 130-66c0 0 0 38 0 39 0-1 36-14 39-25 4-15-6-22-16-30-15-12-39-16-56-20-90-22-187-23-279-23-261 0-341 34-353 59 3 60 228 110 228 110-140-8-351-35-351-116 0-120 293-142 474-142 155 0 477 22 477 142 0 50-74 79-163 96z m-374 94c-58-5-99-21-99-40 0-24 65-43 144-43 79 0 143 19 143 43 0 19-42 34-98 40v216h87l-132 135-133-135h88v-216z m167 515h-136v1c16 16 31 34 46 52l84 109v54h-230v-71h124v-1c-16-17-28-32-44-51l-89-114v-51h245v72z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  '3d_rotate': {
    width: 1000,
    height: 1000,
    path: 'm922 660c-5 4-9 7-14 11-359 263-580-31-580-31l-102 28 58-400c0 1 1 1 2 2 118 108 351 249 351 249s-62 27-100 42c88 83 222 183 347 122 16-8 30-17 44-27-2 1-4 2-6 4z m36-329c0 0 64 229-88 296-62 27-124 14-175-11 157-78 225-208 249-266 8-19 11-31 11-31 2 5 6 15 11 32-5-13-8-20-8-20z m-775-239c70-31 117-50 198-32-121 80-199 346-199 346l-96-15-58-12c0 0 55-226 155-287z m603 133l-317-139c0 0 4-4 19-14 7-5 24-15 24-15s-177-147-389 4c235-287 536-112 536-112l31-22 100 299-4-1z m-298-153c6-4 14-9 24-15 0 0-17 10-24 15z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  camera: {
    width: 1000,
    height: 1000,
    path: 'm500 450c-83 0-150-67-150-150 0-83 67-150 150-150 83 0 150 67 150 150 0 83-67 150-150 150z m400 150h-120c-16 0-34 13-39 29l-31 93c-6 15-23 28-40 28h-340c-16 0-34-13-39-28l-31-94c-6-15-23-28-40-28h-120c-55 0-100-45-100-100v-450c0-55 45-100 100-100h800c55 0 100 45 100 100v450c0 55-45 100-100 100z m-400-550c-138 0-250 112-250 250 0 138 112 250 250 250 138 0 250-112 250-250 0-138-112-250-250-250z m365 380c-19 0-35 16-35 35 0 19 16 35 35 35 19 0 35-16 35-35 0-19-16-35-35-35z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  movie: {
    width: 1000,
    height: 1000,
    path: 'm938 413l-188-125c0 37-17 71-44 94 64 38 107 107 107 187 0 121-98 219-219 219-121 0-219-98-219-219 0-61 25-117 66-156h-115c30 33 49 76 49 125 0 103-84 187-187 187s-188-84-188-187c0-57 26-107 65-141-38-22-65-62-65-109v-250c0-70 56-126 125-126h500c69 0 125 56 125 126l188-126c34 0 62 28 62 63v375c0 35-28 63-62 63z m-750 0c-69 0-125 56-125 125s56 125 125 125 125-56 125-125-56-125-125-125z m406-1c-87 0-157 70-157 157 0 86 70 156 157 156s156-70 156-156-70-157-156-157z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  question: {
    width: 857.1,
    height: 1000,
    path: 'm500 82v107q0 8-5 13t-13 5h-107q-8 0-13-5t-5-13v-107q0-8 5-13t13-5h107q8 0 13 5t5 13z m143 375q0 49-31 91t-77 65-95 23q-136 0-207-119-9-14 4-24l74-55q4-4 10-4 9 0 14 7 30 38 48 51 19 14 48 14 27 0 48-15t21-33q0-21-11-34t-38-25q-35-16-65-48t-29-70v-20q0-8 5-13t13-5h107q8 0 13 5t5 13q0 10 12 27t30 28q18 10 28 16t25 19 25 27 16 34 7 45z m214-107q0-117-57-215t-156-156-215-58-216 58-155 156-58 215 58 215 155 156 216 58 215-58 156-156 57-215z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  disk: {
    width: 857.1,
    height: 1000,
    path: 'm214-7h429v214h-429v-214z m500 0h72v500q0 8-6 21t-11 20l-157 156q-5 6-19 12t-22 5v-232q0-22-15-38t-38-16h-322q-22 0-37 16t-16 38v232h-72v-714h72v232q0 22 16 38t37 16h465q22 0 38-16t15-38v-232z m-214 518v178q0 8-5 13t-13 5h-107q-7 0-13-5t-5-13v-178q0-8 5-13t13-5h107q7 0 13 5t5 13z m357-18v-518q0-22-15-38t-38-16h-750q-23 0-38 16t-16 38v750q0 22 16 38t38 16h517q23 0 50-12t42-26l156-157q16-15 27-42t11-49z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  drawopenpath: {
    width: 70,
    height: 70,
    path: 'M33.21,85.65a7.31,7.31,0,0,1-2.59-.48c-8.16-3.11-9.27-19.8-9.88-41.3-.1-3.58-.19-6.68-.35-9-.15-2.1-.67-3.48-1.43-3.79-2.13-.88-7.91,2.32-12,5.86L3,32.38c1.87-1.64,11.55-9.66,18.27-6.9,2.13.87,4.75,3.14,5.17,9,.17,2.43.26,5.59.36,9.25a224.17,224.17,0,0,0,1.5,23.4c1.54,10.76,4,12.22,4.48,12.4.84.32,2.79-.46,5.76-3.59L43,80.07C41.53,81.57,37.68,85.64,33.21,85.65ZM74.81,69a11.34,11.34,0,0,0,6.09-6.72L87.26,44.5,74.72,32,56.9,38.35c-2.37.86-5.57,3.42-6.61,6L38.65,72.14l8.42,8.43ZM55,46.27a7.91,7.91,0,0,1,3.64-3.17l14.8-5.3,8,8L76.11,60.6l-.06.19a6.37,6.37,0,0,1-3,3.43L48.25,74.59,44.62,71Zm16.57,7.82A6.9,6.9,0,1,0,64.64,61,6.91,6.91,0,0,0,71.54,54.09Zm-4.05,0a2.85,2.85,0,1,1-2.85-2.85A2.86,2.86,0,0,1,67.49,54.09Zm-4.13,5.22L60.5,56.45,44.26,72.7l2.86,2.86ZM97.83,35.67,84.14,22l-8.57,8.57L89.26,44.24Zm-13.69-8,8,8-2.85,2.85-8-8Z',
    transform: 'matrix(1 0 0 1 -15 -15)'
  },
  drawclosedpath: {
    width: 90,
    height: 90,
    path: 'M88.41,21.12a26.56,26.56,0,0,0-36.18,0l-2.07,2-2.07-2a26.57,26.57,0,0,0-36.18,0,23.74,23.74,0,0,0,0,34.8L48,90.12a3.22,3.22,0,0,0,4.42,0l36-34.21a23.73,23.73,0,0,0,0-34.79ZM84,51.24,50.16,83.35,16.35,51.25a17.28,17.28,0,0,1,0-25.47,20,20,0,0,1,27.3,0l4.29,4.07a3.23,3.23,0,0,0,4.44,0l4.29-4.07a20,20,0,0,1,27.3,0,17.27,17.27,0,0,1,0,25.46ZM66.76,47.68h-33v6.91h33ZM53.35,35H46.44V68h6.91Z',
    transform: 'matrix(1 0 0 1 -5 -5)'
  },
  lasso: {
    width: 1031,
    height: 1000,
    path: 'm1018 538c-36 207-290 336-568 286-277-48-473-256-436-463 10-57 36-108 76-151-13-66 11-137 68-183 34-28 75-41 114-42l-55-70 0 0c-2-1-3-2-4-3-10-14-8-34 5-45 14-11 34-8 45 4 1 1 2 3 2 5l0 0 113 140c16 11 31 24 45 40 4 3 6 7 8 11 48-3 100 0 151 9 278 48 473 255 436 462z m-624-379c-80 14-149 48-197 96 42 42 109 47 156 9 33-26 47-66 41-105z m-187-74c-19 16-33 37-39 60 50-32 109-55 174-68-42-25-95-24-135 8z m360 75c-34-7-69-9-102-8 8 62-16 128-68 170-73 59-175 54-244-5-9 20-16 40-20 61-28 159 121 317 333 354s407-60 434-217c28-159-121-318-333-355z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  selectbox: {
    width: 1000,
    height: 1000,
    path: 'm0 850l0-143 143 0 0 143-143 0z m286 0l0-143 143 0 0 143-143 0z m285 0l0-143 143 0 0 143-143 0z m286 0l0-143 143 0 0 143-143 0z m-857-286l0-143 143 0 0 143-143 0z m857 0l0-143 143 0 0 143-143 0z m-857-285l0-143 143 0 0 143-143 0z m857 0l0-143 143 0 0 143-143 0z m-857-286l0-143 143 0 0 143-143 0z m286 0l0-143 143 0 0 143-143 0z m285 0l0-143 143 0 0 143-143 0z m286 0l0-143 143 0 0 143-143 0z',
    transform: 'matrix(1 0 0 -1 0 850)'
  },
  drawline: {
    width: 70,
    height: 70,
    path: 'M60.64,62.3a11.29,11.29,0,0,0,6.09-6.72l6.35-17.72L60.54,25.31l-17.82,6.4c-2.36.86-5.57,3.41-6.6,6L24.48,65.5l8.42,8.42ZM40.79,39.63a7.89,7.89,0,0,1,3.65-3.17l14.79-5.31,8,8L61.94,54l-.06.19a6.44,6.44,0,0,1-3,3.43L34.07,68l-3.62-3.63Zm16.57,7.81a6.9,6.9,0,1,0-6.89,6.9A6.9,6.9,0,0,0,57.36,47.44Zm-4,0a2.86,2.86,0,1,1-2.85-2.85A2.86,2.86,0,0,1,53.32,47.44Zm-4.13,5.22L46.33,49.8,30.08,66.05l2.86,2.86ZM83.65,29,70,15.34,61.4,23.9,75.09,37.59ZM70,21.06l8,8-2.84,2.85-8-8ZM87,80.49H10.67V87H87Z',
    transform: 'matrix(1 0 0 1 -15 -15)'
  },
  drawrect: {
    width: 80,
    height: 80,
    path: 'M78,22V79H21V22H78m9-9H12V88H87V13ZM68,46.22H31V54H68ZM53,32H45.22V69H53Z',
    transform: 'matrix(1 0 0 1 -10 -10)'
  },
  drawcircle: {
    width: 80,
    height: 80,
    path: 'M50,84.72C26.84,84.72,8,69.28,8,50.3S26.84,15.87,50,15.87,92,31.31,92,50.3,73.16,84.72,50,84.72Zm0-60.59c-18.6,0-33.74,11.74-33.74,26.17S31.4,76.46,50,76.46,83.74,64.72,83.74,50.3,68.6,24.13,50,24.13Zm17.15,22h-34v7.11h34Zm-13.8-13H46.24v34h7.11Z',
    transform: 'matrix(1 0 0 1 -10 -10)'
  },
  eraseshape: {
    width: 80,
    height: 80,
    path: 'M82.77,78H31.85L6,49.57,31.85,21.14H82.77a8.72,8.72,0,0,1,8.65,8.77V69.24A8.72,8.72,0,0,1,82.77,78ZM35.46,69.84H82.77a.57.57,0,0,0,.49-.6V29.91a.57.57,0,0,0-.49-.61H35.46L17,49.57Zm32.68-34.7-24,24,5,5,24-24Zm-19,.53-5,5,24,24,5-5Z',
    transform: 'matrix(1 0 0 1 -10 -10)'
  },
  spikeline: {
    width: 1000,
    height: 1000,
    path: 'M512 409c0-57-46-104-103-104-57 0-104 47-104 104 0 57 47 103 104 103 57 0 103-46 103-103z m-327-39l92 0 0 92-92 0z m-185 0l92 0 0 92-92 0z m370-186l92 0 0 93-92 0z m0-184l92 0 0 92-92 0z',
    transform: 'matrix(1.5 0 0 -1.5 0 850)'
  },
  pencil: {
    width: 1792,
    height: 1792,
    path: 'M491 1536l91-91-235-235-91 91v107h128v128h107zm523-928q0-22-22-22-10 0-17 7l-542 542q-7 7-7 17 0 22 22 22 10 0 17-7l542-542q7-7 7-17zm-54-192l416 416-832 832h-416v-416zm683 96q0 53-37 90l-166 166-416-416 166-165q36-38 90-38 53 0 91 38l235 234q37 39 37 91z',
    transform: 'matrix(1 0 0 1 0 1)'
  },
  newplotlylogo: {
    name: 'newplotlylogo',
    svg: ['<svg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 132 132\'>', '<defs>', ' <style>', '  .cls-0{fill:#000;}', '  .cls-1{fill:#FFF;}', '  .cls-2{fill:#F26;}', '  .cls-3{fill:#D69;}', '  .cls-4{fill:#BAC;}', '  .cls-5{fill:#9EF;}', ' </style>', '</defs>', ' <title>plotly-logomark</title>', ' <g id=\'symbol\'>', '  <rect class=\'cls-0\' x=\'0\' y=\'0\' width=\'132\' height=\'132\' rx=\'18\' ry=\'18\'/>', '  <circle class=\'cls-5\' cx=\'102\' cy=\'30\' r=\'6\'/>', '  <circle class=\'cls-4\' cx=\'78\' cy=\'30\' r=\'6\'/>', '  <circle class=\'cls-4\' cx=\'78\' cy=\'54\' r=\'6\'/>', '  <circle class=\'cls-3\' cx=\'54\' cy=\'30\' r=\'6\'/>', '  <circle class=\'cls-2\' cx=\'30\' cy=\'30\' r=\'6\'/>', '  <circle class=\'cls-2\' cx=\'30\' cy=\'54\' r=\'6\'/>', '  <path class=\'cls-1\' d=\'M30,72a6,6,0,0,0-6,6v24a6,6,0,0,0,12,0V78A6,6,0,0,0,30,72Z\'/>', '  <path class=\'cls-1\' d=\'M78,72a6,6,0,0,0-6,6v24a6,6,0,0,0,12,0V78A6,6,0,0,0,78,72Z\'/>', '  <path class=\'cls-1\' d=\'M54,48a6,6,0,0,0-6,6v48a6,6,0,0,0,12,0V54A6,6,0,0,0,54,48Z\'/>', '  <path class=\'cls-1\' d=\'M102,48a6,6,0,0,0-6,6v48a6,6,0,0,0,12,0V54A6,6,0,0,0,102,48Z\'/>', ' </g>', '</svg>'].join('')
  }
};

/***/ }),

/***/ 8308:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


/**
 * Determine the position anchor property of x/y xanchor/yanchor components.
 *
 * - values < 1/3 align the low side at that fraction,
 * - values [1/3, 2/3] align the center at that fraction,
 * - values > 2/3 align the right at that fraction.
 */
exports.isLeftAnchor = function isLeftAnchor(opts) {
  return opts.xanchor === 'left' || opts.xanchor === 'auto' && opts.x <= 1 / 3;
};
exports.isCenterAnchor = function isCenterAnchor(opts) {
  return opts.xanchor === 'center' || opts.xanchor === 'auto' && opts.x > 1 / 3 && opts.x < 2 / 3;
};
exports.isRightAnchor = function isRightAnchor(opts) {
  return opts.xanchor === 'right' || opts.xanchor === 'auto' && opts.x >= 2 / 3;
};
exports.isTopAnchor = function isTopAnchor(opts) {
  return opts.yanchor === 'top' || opts.yanchor === 'auto' && opts.y >= 2 / 3;
};
exports.isMiddleAnchor = function isMiddleAnchor(opts) {
  return opts.yanchor === 'middle' || opts.yanchor === 'auto' && opts.y > 1 / 3 && opts.y < 2 / 3;
};
exports.isBottomAnchor = function isBottomAnchor(opts) {
  return opts.yanchor === 'bottom' || opts.yanchor === 'auto' && opts.y <= 1 / 3;
};

/***/ }),

/***/ 1864:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var modModule = __webpack_require__(435);
var mod = modModule.mod;
var modHalf = modModule.modHalf;
var PI = Math.PI;
var twoPI = 2 * PI;
function deg2rad(deg) {
  return deg / 180 * PI;
}
function rad2deg(rad) {
  return rad / PI * 180;
}

/**
 * is sector a full circle?
 * ... this comes up a lot in SVG path-drawing routines
 *
 * N.B. we consider all sectors that span more that 2pi 'full' circles
 *
 * @param {2-item array} aBnds : angular bounds in *radians*
 * @return {boolean}
 */
function isFullCircle(aBnds) {
  return Math.abs(aBnds[1] - aBnds[0]) > twoPI - 1e-14;
}

/**
 * angular delta between angle 'a' and 'b'
 * solution taken from: https://stackoverflow.com/a/2007279
 *
 * @param {number} a : first angle in *radians*
 * @param {number} b : second angle in *radians*
 * @return {number} angular delta in *radians*
 */
function angleDelta(a, b) {
  return modHalf(b - a, twoPI);
}

/**
 * angular distance between angle 'a' and 'b'
 *
 * @param {number} a : first angle in *radians*
 * @param {number} b : second angle in *radians*
 * @return {number} angular distance in *radians*
 */
function angleDist(a, b) {
  return Math.abs(angleDelta(a, b));
}

/**
 * is angle inside sector?
 *
 * @param {number} a : angle to test in *radians*
 * @param {2-item array} aBnds : sector's angular bounds in *radians*
 * @param {boolean}
 */
function isAngleInsideSector(a, aBnds) {
  if (isFullCircle(aBnds)) return true;
  var s0, s1;
  if (aBnds[0] < aBnds[1]) {
    s0 = aBnds[0];
    s1 = aBnds[1];
  } else {
    s0 = aBnds[1];
    s1 = aBnds[0];
  }
  s0 = mod(s0, twoPI);
  s1 = mod(s1, twoPI);
  if (s0 > s1) s1 += twoPI;
  var a0 = mod(a, twoPI);
  var a1 = a0 + twoPI;
  return a0 >= s0 && a0 <= s1 || a1 >= s0 && a1 <= s1;
}

/**
 * is pt (r,a) inside sector?
 *
 * @param {number} r : pt's radial coordinate
 * @param {number} a : pt's angular coordinate in *radians*
 * @param {2-item array} rBnds : sector's radial bounds
 * @param {2-item array} aBnds : sector's angular bounds in *radians*
 * @return {boolean}
 */
function isPtInsideSector(r, a, rBnds, aBnds) {
  if (!isAngleInsideSector(a, aBnds)) return false;
  var r0, r1;
  if (rBnds[0] < rBnds[1]) {
    r0 = rBnds[0];
    r1 = rBnds[1];
  } else {
    r0 = rBnds[1];
    r1 = rBnds[0];
  }
  return r >= r0 && r <= r1;
}

// common to pathArc, pathSector and pathAnnulus
function _path(r0, r1, a0, a1, cx, cy, isClosed) {
  cx = cx || 0;
  cy = cy || 0;
  var isCircle = isFullCircle([a0, a1]);
  var aStart, aMid, aEnd;
  var rStart, rEnd;
  if (isCircle) {
    aStart = 0;
    aMid = PI;
    aEnd = twoPI;
  } else {
    if (a0 < a1) {
      aStart = a0;
      aEnd = a1;
    } else {
      aStart = a1;
      aEnd = a0;
    }
  }
  if (r0 < r1) {
    rStart = r0;
    rEnd = r1;
  } else {
    rStart = r1;
    rEnd = r0;
  }

  // N.B. svg coordinates here, where y increases downward
  function pt(r, a) {
    return [r * Math.cos(a) + cx, cy - r * Math.sin(a)];
  }
  var largeArc = Math.abs(aEnd - aStart) <= PI ? 0 : 1;
  function arc(r, a, cw) {
    return 'A' + [r, r] + ' ' + [0, largeArc, cw] + ' ' + pt(r, a);
  }
  var p;
  if (isCircle) {
    if (rStart === null) {
      p = 'M' + pt(rEnd, aStart) + arc(rEnd, aMid, 0) + arc(rEnd, aEnd, 0) + 'Z';
    } else {
      p = 'M' + pt(rStart, aStart) + arc(rStart, aMid, 0) + arc(rStart, aEnd, 0) + 'Z' + 'M' + pt(rEnd, aStart) + arc(rEnd, aMid, 1) + arc(rEnd, aEnd, 1) + 'Z';
    }
  } else {
    if (rStart === null) {
      p = 'M' + pt(rEnd, aStart) + arc(rEnd, aEnd, 0);
      if (isClosed) p += 'L0,0Z';
    } else {
      p = 'M' + pt(rStart, aStart) + 'L' + pt(rEnd, aStart) + arc(rEnd, aEnd, 0) + 'L' + pt(rStart, aEnd) + arc(rStart, aStart, 1) + 'Z';
    }
  }
  return p;
}

/**
 * path an arc
 *
 * @param {number} r : radius
 * @param {number} a0 : first angular coordinate in *radians*
 * @param {number} a1 : second angular coordinate in *radians*
 * @param {number (optional)} cx : x coordinate of center
 * @param {number (optional)} cy : y coordinate of center
 * @return {string} svg path
 */
function pathArc(r, a0, a1, cx, cy) {
  return _path(null, r, a0, a1, cx, cy, 0);
}

/**
 * path a sector
 *
 * @param {number} r : radius
 * @param {number} a0 : first angular coordinate in *radians*
 * @param {number} a1 : second angular coordinate in *radians*
 * @param {number (optional)} cx : x coordinate of center
 * @param {number (optional)} cy : y coordinate of center
 * @return {string} svg path
 */
function pathSector(r, a0, a1, cx, cy) {
  return _path(null, r, a0, a1, cx, cy, 1);
}

/**
 * path an annulus
 *
 * @param {number} r0 : first radial coordinate
 * @param {number} r1 : second radial coordinate
 * @param {number} a0 : first angular coordinate in *radians*
 * @param {number} a1 : second angular coordinate in *radians*
 * @param {number (optional)} cx : x coordinate of center
 * @param {number (optional)} cy : y coordinate of center
 * @return {string} svg path
 */
function pathAnnulus(r0, r1, a0, a1, cx, cy) {
  return _path(r0, r1, a0, a1, cx, cy, 1);
}
module.exports = {
  deg2rad: deg2rad,
  rad2deg: rad2deg,
  angleDelta: angleDelta,
  angleDist: angleDist,
  isFullCircle: isFullCircle,
  isAngleInsideSector: isAngleInsideSector,
  isPtInsideSector: isPtInsideSector,
  pathArc: pathArc,
  pathSector: pathSector,
  pathAnnulus: pathAnnulus
};

/***/ }),

/***/ 8116:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var b64decode = (__webpack_require__(3160).decode);
var isPlainObject = __webpack_require__(3620);
var isArray = Array.isArray;
var ab = ArrayBuffer;
var dv = DataView;
function isTypedArray(a) {
  return ab.isView(a) && !(a instanceof dv);
}
exports.isTypedArray = isTypedArray;
function isArrayOrTypedArray(a) {
  return isArray(a) || isTypedArray(a);
}
exports.isArrayOrTypedArray = isArrayOrTypedArray;

/*
 * Test whether an input object is 1D.
 *
 * Assumes we already know the object is an array.
 *
 * Looks only at the first element, if the dimensionality is
 * not consistent we won't figure that out here.
 */
function isArray1D(a) {
  return !isArrayOrTypedArray(a[0]);
}
exports.isArray1D = isArray1D;

/*
 * Ensures an array has the right amount of storage space. If it doesn't
 * exist, it creates an array. If it does exist, it returns it if too
 * short or truncates it in-place.
 *
 * The goal is to just reuse memory to avoid a bit of excessive garbage
 * collection.
 */
exports.ensureArray = function (out, n) {
  // TODO: typed array support here? This is only used in
  // traces/carpet/compute_control_points
  if (!isArray(out)) out = [];

  // If too long, truncate. (If too short, it will grow
  // automatically so we don't care about that case)
  out.length = n;
  return out;
};
var typedArrays = {
  u1c: typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
  // not supported in numpy?

  i1: typeof Int8Array === 'undefined' ? undefined : Int8Array,
  u1: typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
  i2: typeof Int16Array === 'undefined' ? undefined : Int16Array,
  u2: typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
  i4: typeof Int32Array === 'undefined' ? undefined : Int32Array,
  u4: typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
  f4: typeof Float32Array === 'undefined' ? undefined : Float32Array,
  f8: typeof Float64Array === 'undefined' ? undefined : Float64Array

  /* TODO: potentially add Big Int
   i8: typeof BigInt64Array === 'undefined' ? undefined :
             BigInt64Array,
   u8: typeof BigUint64Array === 'undefined' ? undefined :
             BigUint64Array,
  */
};

typedArrays.uint8c = typedArrays.u1c;
typedArrays.uint8 = typedArrays.u1;
typedArrays.int8 = typedArrays.i1;
typedArrays.uint16 = typedArrays.u2;
typedArrays.int16 = typedArrays.i2;
typedArrays.uint32 = typedArrays.u4;
typedArrays.int32 = typedArrays.i4;
typedArrays.float32 = typedArrays.f4;
typedArrays.float64 = typedArrays.f8;
function isArrayBuffer(a) {
  return a.constructor === ArrayBuffer;
}
exports.isArrayBuffer = isArrayBuffer;
exports.decodeTypedArraySpec = function (vIn) {
  var out = [];
  var v = coerceTypedArraySpec(vIn);
  var dtype = v.dtype;
  var T = typedArrays[dtype];
  if (!T) throw new Error('Error in dtype: "' + dtype + '"');
  var BYTES_PER_ELEMENT = T.BYTES_PER_ELEMENT;
  var buffer = v.bdata;
  if (!isArrayBuffer(buffer)) {
    buffer = b64decode(buffer);
  }
  var shape = v.shape === undefined ?
  // detect 1-d length
  [buffer.byteLength / BYTES_PER_ELEMENT] :
  // convert number to string and split to array
  ('' + v.shape).split(',');
  shape.reverse(); // i.e. to match numpy order
  var ndim = shape.length;
  var nj, j;
  var ni = +shape[0];
  var rowBytes = BYTES_PER_ELEMENT * ni;
  var pos = 0;
  if (ndim === 1) {
    out = new T(buffer);
  } else if (ndim === 2) {
    nj = +shape[1];
    for (j = 0; j < nj; j++) {
      out[j] = new T(buffer, pos, ni);
      pos += rowBytes;
    }
  } else if (ndim === 3) {
    nj = +shape[1];
    var nk = +shape[2];
    for (var k = 0; k < nk; k++) {
      out[k] = [];
      for (j = 0; j < nj; j++) {
        out[k][j] = new T(buffer, pos, ni);
        pos += rowBytes;
      }
    }
  } else {
    throw new Error('ndim: ' + ndim + 'is not supported with the shape:"' + v.shape + '"');
  }

  // attach bdata, dtype & shape to array for json export
  out.bdata = v.bdata;
  out.dtype = v.dtype;
  out.shape = shape.reverse().join(',');
  vIn._inputArray = out;
  return out;
};
exports.isTypedArraySpec = function (v) {
  return isPlainObject(v) && v.hasOwnProperty('dtype') && typeof v.dtype === 'string' && v.hasOwnProperty('bdata') && (typeof v.bdata === 'string' || isArrayBuffer(v.bdata)) && (v.shape === undefined || v.hasOwnProperty('shape') && (typeof v.shape === 'string' || typeof v.shape === 'number'));
};
function coerceTypedArraySpec(v) {
  return {
    bdata: v.bdata,
    dtype: v.dtype,
    shape: v.shape
  };
}

/*
 * TypedArray-compatible concatenation of n arrays
 * if all arrays are the same type it will preserve that type,
 * otherwise it falls back on Array.
 * Also tries to avoid copying, in case one array has zero length
 * But never mutates an existing array
 */
exports.concat = function () {
  var args = [];
  var allArray = true;
  var totalLen = 0;
  var _constructor, arg0, i, argi, posi, leni, out, j;
  for (i = 0; i < arguments.length; i++) {
    argi = arguments[i];
    leni = argi.length;
    if (leni) {
      if (arg0) args.push(argi);else {
        arg0 = argi;
        posi = leni;
      }
      if (isArray(argi)) {
        _constructor = false;
      } else {
        allArray = false;
        if (!totalLen) {
          _constructor = argi.constructor;
        } else if (_constructor !== argi.constructor) {
          // TODO: in principle we could upgrade here,
          // ie keep typed array but convert all to Float64Array?
          _constructor = false;
        }
      }
      totalLen += leni;
    }
  }
  if (!totalLen) return [];
  if (!args.length) return arg0;
  if (allArray) return arg0.concat.apply(arg0, args);
  if (_constructor) {
    // matching typed arrays
    out = new _constructor(totalLen);
    out.set(arg0);
    for (i = 0; i < args.length; i++) {
      argi = args[i];
      out.set(argi, posi);
      posi += argi.length;
    }
    return out;
  }

  // mismatched types or Array + typed
  out = new Array(totalLen);
  for (j = 0; j < arg0.length; j++) out[j] = arg0[j];
  for (i = 0; i < args.length; i++) {
    argi = args[i];
    for (j = 0; j < argi.length; j++) out[posi + j] = argi[j];
    posi += j;
  }
  return out;
};
exports.maxRowLength = function (z) {
  return _rowLength(z, Math.max, 0);
};
exports.minRowLength = function (z) {
  return _rowLength(z, Math.min, Infinity);
};
function _rowLength(z, fn, len0) {
  if (isArrayOrTypedArray(z)) {
    if (isArrayOrTypedArray(z[0])) {
      var len = len0;
      for (var i = 0; i < z.length; i++) {
        len = fn(len, z[i].length);
      }
      return len;
    } else {
      return z.length;
    }
  }
  return 0;
}

/***/ }),

/***/ 4037:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isNumeric = __webpack_require__(8248);
var BADNUM = (__webpack_require__(9032).BADNUM);

// precompile for speed
var JUNK = /^['"%,$#\s']+|[, ]|['"%,$#\s']+$/g;

/**
 * cleanNumber: remove common leading and trailing cruft
 * Always returns either a number or BADNUM.
 */
module.exports = function cleanNumber(v) {
  if (typeof v === 'string') {
    v = v.replace(JUNK, '');
  }
  if (isNumeric(v)) return Number(v);
  return BADNUM;
};

/***/ }),

/***/ 3696:
/***/ (function(module) {

"use strict";


/**
 * Clear gl frame (if any). This is a common pattern as
 * we usually set `preserveDrawingBuffer: true` during
 * gl context creation (e.g. via `reglUtils.prepare`).
 *
 * @param {DOM node or object} gd : graph div object
 */
module.exports = function clearGlCanvases(gd) {
  var fullLayout = gd._fullLayout;
  if (fullLayout._glcanvas && fullLayout._glcanvas.size()) {
    fullLayout._glcanvas.each(function (d) {
      if (d.regl) d.regl.clear({
        color: true,
        depth: true
      });
    });
  }
};

/***/ }),

/***/ 5352:
/***/ (function(module) {

"use strict";


/**
 * Clear responsive handlers (if any).
 *
 * @param {DOM node or object} gd : graph div object
 */
module.exports = function clearResponsive(gd) {
  if (gd._responsiveChartHandler) {
    window.removeEventListener('resize', gd._responsiveChartHandler);
    delete gd._responsiveChartHandler;
  }
};

/***/ }),

/***/ 3064:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var isNumeric = __webpack_require__(8248);
var tinycolor = __webpack_require__(9760);
var baseTraceAttrs = __webpack_require__(5464);
var colorscales = __webpack_require__(8304);
var Color = __webpack_require__(6308);
var DESELECTDIM = (__webpack_require__(3448).DESELECTDIM);
var nestedProperty = __webpack_require__(2296);
var counterRegex = (__webpack_require__(3756).counter);
var modHalf = (__webpack_require__(435).modHalf);
var isArrayOrTypedArray = (__webpack_require__(8116).isArrayOrTypedArray);
var isTypedArraySpec = (__webpack_require__(8116).isTypedArraySpec);
var decodeTypedArraySpec = (__webpack_require__(8116).decodeTypedArraySpec);
exports.valObjectMeta = {
  data_array: {
    // You can use *dflt=[] to force said array to exist though.
    coerceFunction: function (v, propOut, dflt) {
      propOut.set(isArrayOrTypedArray(v) ? v : isTypedArraySpec(v) ? decodeTypedArraySpec(v) : dflt);
    }
  },
  enumerated: {
    coerceFunction: function (v, propOut, dflt, opts) {
      if (opts.coerceNumber) v = +v;
      if (opts.values.indexOf(v) === -1) propOut.set(dflt);else propOut.set(v);
    },
    validateFunction: function (v, opts) {
      if (opts.coerceNumber) v = +v;
      var values = opts.values;
      for (var i = 0; i < values.length; i++) {
        var k = String(values[i]);
        if (k.charAt(0) === '/' && k.charAt(k.length - 1) === '/') {
          var regex = new RegExp(k.substr(1, k.length - 2));
          if (regex.test(v)) return true;
        } else if (v === values[i]) return true;
      }
      return false;
    }
  },
  boolean: {
    coerceFunction: function (v, propOut, dflt) {
      if (v === true || v === false) propOut.set(v);else propOut.set(dflt);
    }
  },
  number: {
    coerceFunction: function (v, propOut, dflt, opts) {
      if (!isNumeric(v) || opts.min !== undefined && v < opts.min || opts.max !== undefined && v > opts.max) {
        propOut.set(dflt);
      } else propOut.set(+v);
    }
  },
  integer: {
    coerceFunction: function (v, propOut, dflt, opts) {
      if (v % 1 || !isNumeric(v) || opts.min !== undefined && v < opts.min || opts.max !== undefined && v > opts.max) {
        propOut.set(dflt);
      } else propOut.set(+v);
    }
  },
  string: {
    // TODO 'values shouldn't be in there (edge case: 'dash' in Scatter)
    coerceFunction: function (v, propOut, dflt, opts) {
      if (typeof v !== 'string') {
        var okToCoerce = typeof v === 'number';
        if (opts.strict === true || !okToCoerce) propOut.set(dflt);else propOut.set(String(v));
      } else if (opts.noBlank && !v) propOut.set(dflt);else propOut.set(v);
    }
  },
  color: {
    coerceFunction: function (v, propOut, dflt) {
      if (tinycolor(v).isValid()) propOut.set(v);else propOut.set(dflt);
    }
  },
  colorlist: {
    coerceFunction: function (v, propOut, dflt) {
      function isColor(color) {
        return tinycolor(color).isValid();
      }
      if (!Array.isArray(v) || !v.length) propOut.set(dflt);else if (v.every(isColor)) propOut.set(v);else propOut.set(dflt);
    }
  },
  colorscale: {
    coerceFunction: function (v, propOut, dflt) {
      propOut.set(colorscales.get(v, dflt));
    }
  },
  angle: {
    coerceFunction: function (v, propOut, dflt) {
      if (v === 'auto') propOut.set('auto');else if (!isNumeric(v)) propOut.set(dflt);else propOut.set(modHalf(+v, 360));
    }
  },
  subplotid: {
    coerceFunction: function (v, propOut, dflt, opts) {
      var regex = opts.regex || counterRegex(dflt);
      if (typeof v === 'string' && regex.test(v)) {
        propOut.set(v);
        return;
      }
      propOut.set(dflt);
    },
    validateFunction: function (v, opts) {
      var dflt = opts.dflt;
      if (v === dflt) return true;
      if (typeof v !== 'string') return false;
      if (counterRegex(dflt).test(v)) return true;
      return false;
    }
  },
  flaglist: {
    coerceFunction: function (v, propOut, dflt, opts) {
      if ((opts.extras || []).indexOf(v) !== -1) {
        propOut.set(v);
        return;
      }
      if (typeof v !== 'string') {
        propOut.set(dflt);
        return;
      }
      var vParts = v.split('+');
      var i = 0;
      while (i < vParts.length) {
        var vi = vParts[i];
        if (opts.flags.indexOf(vi) === -1 || vParts.indexOf(vi) < i) {
          vParts.splice(i, 1);
        } else i++;
      }
      if (!vParts.length) propOut.set(dflt);else propOut.set(vParts.join('+'));
    }
  },
  any: {
    coerceFunction: function (v, propOut, dflt) {
      if (v === undefined) {
        propOut.set(dflt);
      } else {
        propOut.set(isTypedArraySpec(v) ? decodeTypedArraySpec(v) : v);
      }
    }
  },
  info_array: {
    // set `dimensions=2` for a 2D array or '1-2' for either
    // `items` may be a single object instead of an array, in which case
    // `freeLength` must be true.
    // if `dimensions='1-2'` and items is a 1D array, then the value can
    // either be a matching 1D array or an array of such matching 1D arrays
    coerceFunction: function (v, propOut, dflt, opts) {
      // simplified coerce function just for array items
      function coercePart(v, opts, dflt) {
        var out;
        var propPart = {
          set: function (v) {
            out = v;
          }
        };
        if (dflt === undefined) dflt = opts.dflt;
        exports.valObjectMeta[opts.valType].coerceFunction(v, propPart, dflt, opts);
        return out;
      }
      if (isTypedArraySpec(v)) v = decodeTypedArraySpec(v);
      if (!isArrayOrTypedArray(v)) {
        propOut.set(dflt);
        return;
      }
      var twoD = opts.dimensions === 2 || opts.dimensions === '1-2' && Array.isArray(v) && isArrayOrTypedArray(v[0]);
      var items = opts.items;
      var vOut = [];
      var arrayItems = Array.isArray(items);
      var arrayItems2D = arrayItems && twoD && isArrayOrTypedArray(items[0]);
      var innerItemsOnly = twoD && arrayItems && !arrayItems2D;
      var len = arrayItems && !innerItemsOnly ? items.length : v.length;
      var i, j, row, item, len2, vNew;
      dflt = Array.isArray(dflt) ? dflt : [];
      if (twoD) {
        for (i = 0; i < len; i++) {
          vOut[i] = [];
          row = isArrayOrTypedArray(v[i]) ? v[i] : [];
          if (innerItemsOnly) len2 = items.length;else if (arrayItems) len2 = items[i].length;else len2 = row.length;
          for (j = 0; j < len2; j++) {
            if (innerItemsOnly) item = items[j];else if (arrayItems) item = items[i][j];else item = items;
            vNew = coercePart(row[j], item, (dflt[i] || [])[j]);
            if (vNew !== undefined) vOut[i][j] = vNew;
          }
        }
      } else {
        for (i = 0; i < len; i++) {
          vNew = coercePart(v[i], arrayItems ? items[i] : items, dflt[i]);
          if (vNew !== undefined) vOut[i] = vNew;
        }
      }
      propOut.set(vOut);
    },
    validateFunction: function (v, opts) {
      if (!isArrayOrTypedArray(v)) return false;
      var items = opts.items;
      var arrayItems = Array.isArray(items);
      var twoD = opts.dimensions === 2;

      // when free length is off, input and declared lengths must match
      if (!opts.freeLength && v.length !== items.length) return false;

      // valid when all input items are valid
      for (var i = 0; i < v.length; i++) {
        if (twoD) {
          if (!isArrayOrTypedArray(v[i]) || !opts.freeLength && v[i].length !== items[i].length) {
            return false;
          }
          for (var j = 0; j < v[i].length; j++) {
            if (!validate(v[i][j], arrayItems ? items[i][j] : items)) {
              return false;
            }
          }
        } else if (!validate(v[i], arrayItems ? items[i] : items)) return false;
      }
      return true;
    }
  }
};

/**
 * Ensures that container[attribute] has a valid value.
 *
 * attributes[attribute] is an object with possible keys:
 * - valType: data_array, enumerated, boolean, ... as in valObjectMeta
 * - values: (enumerated only) array of allowed vals
 * - min, max: (number, integer only) inclusive bounds on allowed vals
 *      either or both may be omitted
 * - dflt: if attribute is invalid or missing, use this default
 *      if dflt is provided as an argument to lib.coerce it takes precedence
 *      as a convenience, returns the value it finally set
 */
exports.coerce = function (containerIn, containerOut, attributes, attribute, dflt) {
  var opts = nestedProperty(attributes, attribute).get();
  var propIn = nestedProperty(containerIn, attribute);
  var propOut = nestedProperty(containerOut, attribute);
  var v = propIn.get();
  var template = containerOut._template;
  if (v === undefined && template) {
    v = nestedProperty(template, attribute).get();
    // already used the template value, so short-circuit the second check
    template = 0;
  }
  if (dflt === undefined) dflt = opts.dflt;
  if (opts.arrayOk) {
    if (isArrayOrTypedArray(v)) {
      /**
       * arrayOk: value MAY be an array, then we do no value checking
       * at this point, because it can be more complicated than the
       * individual form (eg. some array vals can be numbers, even if the
       * single values must be color strings)
       */

      propOut.set(v);
      return v;
    } else {
      if (isTypedArraySpec(v)) {
        v = decodeTypedArraySpec(v);
        propOut.set(v);
        return v;
      }
    }
  }
  var coerceFunction = exports.valObjectMeta[opts.valType].coerceFunction;
  coerceFunction(v, propOut, dflt, opts);
  var out = propOut.get();
  // in case v was provided but invalid, try the template again so it still
  // overrides the regular default
  if (template && out === dflt && !validate(v, opts)) {
    v = nestedProperty(template, attribute).get();
    coerceFunction(v, propOut, dflt, opts);
    out = propOut.get();
  }
  return out;
};

/**
 * Variation on coerce
 *
 * Uses coerce to get attribute value if user input is valid,
 * returns attribute default if user input it not valid or
 * returns false if there is no user input.
 */
exports.coerce2 = function (containerIn, containerOut, attributes, attribute, dflt) {
  var propIn = nestedProperty(containerIn, attribute);
  var propOut = exports.coerce(containerIn, containerOut, attributes, attribute, dflt);
  var valIn = propIn.get();
  return valIn !== undefined && valIn !== null ? propOut : false;
};

/*
 * Shortcut to coerce the three font attributes
 *
 * 'coerce' is a lib.coerce wrapper with implied first three arguments
 */
exports.coerceFont = function (coerce, attr, dfltObj, opts) {
  if (!opts) opts = {};
  var out = {};
  dfltObj = dfltObj || {};
  out.family = coerce(attr + '.family', dfltObj.family);
  out.size = coerce(attr + '.size', dfltObj.size);
  out.color = coerce(attr + '.color', dfltObj.color);
  out.weight = coerce(attr + '.weight', dfltObj.weight);
  out.style = coerce(attr + '.style', dfltObj.style);
  if (!opts.noFontVariant) out.variant = coerce(attr + '.variant', dfltObj.variant);
  return out;
};

/*
 * Shortcut to coerce the pattern attributes
 */
exports.coercePattern = function (coerce, attr, markerColor, hasMarkerColorscale) {
  var shape = coerce(attr + '.shape');
  if (shape) {
    coerce(attr + '.solidity');
    coerce(attr + '.size');
    var fillmode = coerce(attr + '.fillmode');
    var isOverlay = fillmode === 'overlay';
    if (!hasMarkerColorscale) {
      var bgcolor = coerce(attr + '.bgcolor', isOverlay ? markerColor : undefined);
      coerce(attr + '.fgcolor', isOverlay ? Color.contrast(bgcolor) : markerColor);
    }
    coerce(attr + '.fgopacity', isOverlay ? 0.5 : 1);
  }
};

/** Coerce shortcut for 'hoverinfo'
 * handling 1-vs-multi-trace dflt logic
 *
 * @param {object} traceIn : user trace object
 * @param {object} traceOut : full trace object (requires _module ref)
 * @param {object} layoutOut : full layout object (require _dataLength ref)
 * @return {any} : the coerced value
 */
exports.coerceHoverinfo = function (traceIn, traceOut, layoutOut) {
  var moduleAttrs = traceOut._module.attributes;
  var attrs = moduleAttrs.hoverinfo ? moduleAttrs : baseTraceAttrs;
  var valObj = attrs.hoverinfo;
  var dflt;
  if (layoutOut._dataLength === 1) {
    var flags = valObj.dflt === 'all' ? valObj.flags.slice() : valObj.dflt.split('+');
    flags.splice(flags.indexOf('name'), 1);
    dflt = flags.join('+');
  }
  return exports.coerce(traceIn, traceOut, attrs, 'hoverinfo', dflt);
};

/** Coerce shortcut for [un]selected.marker.opacity,
 *  which has special default logic, to ensure that it corresponds to the
 *  default selection behavior while allowing to be overtaken by any other
 *  [un]selected attribute.
 *
 *  N.B. This must be called *after* coercing all the other [un]selected attrs,
 *  to give the intended result.
 *
 * @param {object} traceOut : fullData item
 * @param {function} coerce : lib.coerce wrapper with implied first three arguments
 */
exports.coerceSelectionMarkerOpacity = function (traceOut, coerce) {
  if (!traceOut.marker) return;
  var mo = traceOut.marker.opacity;
  // you can still have a `marker` container with no markers if there's text
  if (mo === undefined) return;
  var smoDflt;
  var usmoDflt;

  // Don't give [un]selected.marker.opacity a default value if
  // marker.opacity is an array: handle this during style step.
  //
  // Only give [un]selected.marker.opacity a default value if you don't
  // set any other [un]selected attributes.
  if (!isArrayOrTypedArray(mo) && !traceOut.selected && !traceOut.unselected) {
    smoDflt = mo;
    usmoDflt = DESELECTDIM * mo;
  }
  coerce('selected.marker.opacity', smoDflt);
  coerce('unselected.marker.opacity', usmoDflt);
};
function validate(value, opts) {
  var valObjectDef = exports.valObjectMeta[opts.valType];
  if (opts.arrayOk && isArrayOrTypedArray(value)) return true;
  if (valObjectDef.validateFunction) {
    return valObjectDef.validateFunction(value, opts);
  }
  var failed = {};
  var out = failed;
  var propMock = {
    set: function (v) {
      out = v;
    }
  };

  // 'failed' just something mutable that won't be === anything else

  valObjectDef.coerceFunction(value, propMock, failed, opts);
  return out !== failed;
}
exports.validate = validate;

/***/ }),

/***/ 7555:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var timeFormat = (__webpack_require__(4336)/* .timeFormat */ .Yn);
var isNumeric = __webpack_require__(8248);
var Loggers = __webpack_require__(4248);
var mod = (__webpack_require__(435).mod);
var constants = __webpack_require__(9032);
var BADNUM = constants.BADNUM;
var ONEDAY = constants.ONEDAY;
var ONEHOUR = constants.ONEHOUR;
var ONEMIN = constants.ONEMIN;
var ONESEC = constants.ONESEC;
var EPOCHJD = constants.EPOCHJD;
var Registry = __webpack_require__(4040);
var utcFormat = (__webpack_require__(4336)/* .utcFormat */ .E9);
var DATETIME_REGEXP = /^\s*(-?\d\d\d\d|\d\d)(-(\d?\d)(-(\d?\d)([ Tt]([01]?\d|2[0-3])(:([0-5]\d)(:([0-5]\d(\.\d+)?))?(Z|z|[+\-]\d\d(:?\d\d)?)?)?)?)?)?\s*$/m;
// special regex for chinese calendars to support yyyy-mmi-dd etc for intercalary months
var DATETIME_REGEXP_CN = /^\s*(-?\d\d\d\d|\d\d)(-(\d?\di?)(-(\d?\d)([ Tt]([01]?\d|2[0-3])(:([0-5]\d)(:([0-5]\d(\.\d+)?))?(Z|z|[+\-]\d\d(:?\d\d)?)?)?)?)?)?\s*$/m;

// for 2-digit years, the first year we map them onto
var YFIRST = new Date().getFullYear() - 70;
function isWorldCalendar(calendar) {
  return calendar && Registry.componentsRegistry.calendars && typeof calendar === 'string' && calendar !== 'gregorian';
}

/*
 * dateTick0: get the canonical tick for this calendar
 *
 * integer weekdays : Saturday: 0, Sunday: 1, Monday: 2, etc.
 */
exports.dateTick0 = function (calendar, dayOfWeek) {
  var tick0 = _dateTick0(calendar, !!dayOfWeek);
  if (dayOfWeek < 2) return tick0;
  var v = exports.dateTime2ms(tick0, calendar);
  v += ONEDAY * (dayOfWeek - 1); // shift Sunday to Monday, etc.
  return exports.ms2DateTime(v, 0, calendar);
};

/*
 * _dateTick0: get the canonical tick for this calendar
 *
 * bool sunday is for week ticks, shift it to a Sunday.
 */
function _dateTick0(calendar, sunday) {
  if (isWorldCalendar(calendar)) {
    return sunday ? Registry.getComponentMethod('calendars', 'CANONICAL_SUNDAY')[calendar] : Registry.getComponentMethod('calendars', 'CANONICAL_TICK')[calendar];
  } else {
    return sunday ? '2000-01-02' : '2000-01-01';
  }
}

/*
 * dfltRange: for each calendar, give a valid default range
 */
exports.dfltRange = function (calendar) {
  if (isWorldCalendar(calendar)) {
    return Registry.getComponentMethod('calendars', 'DFLTRANGE')[calendar];
  } else {
    return ['2000-01-01', '2001-01-01'];
  }
};

// is an object a javascript date?
exports.isJSDate = function (v) {
  return typeof v === 'object' && v !== null && typeof v.getTime === 'function';
};

// The absolute limits of our date-time system
// This is a little weird: we use MIN_MS and MAX_MS in dateTime2ms
// but we use dateTime2ms to calculate them (after defining it!)
var MIN_MS, MAX_MS;

/**
 * dateTime2ms - turn a date object or string s into milliseconds
 * (relative to 1970-01-01, per javascript standard)
 * optional calendar (string) to use a non-gregorian calendar
 *
 * Returns BADNUM if it doesn't find a date
 *
 * strings should have the form:
 *
 *    -?YYYY-mm-dd<sep>HH:MM:SS.sss<tzInfo>?
 *
 * <sep>: space (our normal standard) or T or t (ISO-8601)
 * <tzInfo>: Z, z, [+\-]HH:?MM or [+\-]HH and we THROW IT AWAY
 * this format comes from https://tools.ietf.org/html/rfc3339#section-5.6
 * and 4.2.5.1 Difference between local time and UTC of day (ISO-8601)
 * but we allow it even with a space as the separator
 *
 * May truncate after any full field, and sss can be any length
 * even >3 digits, though javascript dates truncate to milliseconds,
 * we keep as much as javascript numeric precision can hold, but we only
 * report back up to 100 microsecond precision, because most dates support
 * this precision (close to 1970 support more, very far away support less)
 *
 * Expanded to support negative years to -9999 but you must always
 * give 4 digits, except for 2-digit positive years which we assume are
 * near the present time.
 * Note that we follow ISO 8601:2004: there *is* a year 0, which
 * is 1BC/BCE, and -1===2BC etc.
 *
 * World calendars: not all of these *have* agreed extensions to this full range,
 * if you have another calendar system but want a date range outside its validity,
 * you can use a gregorian date string prefixed with 'G' or 'g'.
 *
 * Where to cut off 2-digit years between 1900s and 2000s?
 * from https://docs.microsoft.com/en-us/office/troubleshoot/excel/two-digit-year-numbers#the-2029-rule:
 *   1930-2029 (the most retro of all...)
 * but in my mac chrome from eg. d=new Date(Date.parse('8/19/50')):
 *   1950-2049
 * by Java, from http://stackoverflow.com/questions/2024273/:
 *   now-80 - now+19
 * or FileMaker Pro, from
 *      https://fmhelp.filemaker.com/help/18/fmp/en/index.html#page/FMP_Help/dates-with-two-digit-years.html:
 *   now-70 - now+29
 * but python strptime etc, via
 *      http://docs.python.org/py3k/library/time.html:
 *   1969-2068 (super forward-looking, but static, not sliding!)
 *
 * lets go with now-70 to now+29, and if anyone runs into this problem
 * they can learn the hard way not to use 2-digit years, as no choice we
 * make now will cover all possibilities. mostly this will all be taken
 * care of in initial parsing, should only be an issue for hand-entered data
 * currently (2016) this range is:
 *   1946-2045
 */
exports.dateTime2ms = function (s, calendar) {
  // first check if s is a date object
  if (exports.isJSDate(s)) {
    // Convert to the UTC milliseconds that give the same
    // hours as this date has in the local timezone
    var tzOffset = s.getTimezoneOffset() * ONEMIN;
    var offsetTweak = (s.getUTCMinutes() - s.getMinutes()) * ONEMIN + (s.getUTCSeconds() - s.getSeconds()) * ONESEC + (s.getUTCMilliseconds() - s.getMilliseconds());
    if (offsetTweak) {
      var comb = 3 * ONEMIN;
      tzOffset = tzOffset - comb / 2 + mod(offsetTweak - tzOffset + comb / 2, comb);
    }
    s = Number(s) - tzOffset;
    if (s >= MIN_MS && s <= MAX_MS) return s;
    return BADNUM;
  }
  // otherwise only accept strings and numbers
  if (typeof s !== 'string' && typeof s !== 'number') return BADNUM;
  s = String(s);
  var isWorld = isWorldCalendar(calendar);

  // to handle out-of-range dates in international calendars, accept
  // 'G' as a prefix to force the built-in gregorian calendar.
  var s0 = s.charAt(0);
  if (isWorld && (s0 === 'G' || s0 === 'g')) {
    s = s.substr(1);
    calendar = '';
  }
  var isChinese = isWorld && calendar.substr(0, 7) === 'chinese';
  var match = s.match(isChinese ? DATETIME_REGEXP_CN : DATETIME_REGEXP);
  if (!match) return BADNUM;
  var y = match[1];
  var m = match[3] || '1';
  var d = Number(match[5] || 1);
  var H = Number(match[7] || 0);
  var M = Number(match[9] || 0);
  var S = Number(match[11] || 0);
  if (isWorld) {
    // disallow 2-digit years for world calendars
    if (y.length === 2) return BADNUM;
    y = Number(y);
    var cDate;
    try {
      var calInstance = Registry.getComponentMethod('calendars', 'getCal')(calendar);
      if (isChinese) {
        var isIntercalary = m.charAt(m.length - 1) === 'i';
        m = parseInt(m, 10);
        cDate = calInstance.newDate(y, calInstance.toMonthIndex(y, m, isIntercalary), d);
      } else {
        cDate = calInstance.newDate(y, Number(m), d);
      }
    } catch (e) {
      return BADNUM;
    } // Invalid ... date

    if (!cDate) return BADNUM;
    return (cDate.toJD() - EPOCHJD) * ONEDAY + H * ONEHOUR + M * ONEMIN + S * ONESEC;
  }
  if (y.length === 2) {
    y = (Number(y) + 2000 - YFIRST) % 100 + YFIRST;
  } else y = Number(y);

  // new Date uses months from 0; subtract 1 here just so we
  // don't have to do it again during the validity test below
  m -= 1;

  // javascript takes new Date(0..99,m,d) to mean 1900-1999, so
  // to support years 0-99 we need to use setFullYear explicitly
  // Note that 2000 is a leap year.
  var date = new Date(Date.UTC(2000, m, d, H, M));
  date.setUTCFullYear(y);
  if (date.getUTCMonth() !== m) return BADNUM;
  if (date.getUTCDate() !== d) return BADNUM;
  return date.getTime() + S * ONESEC;
};
MIN_MS = exports.MIN_MS = exports.dateTime2ms('-9999');
MAX_MS = exports.MAX_MS = exports.dateTime2ms('9999-12-31 23:59:59.9999');

// is string s a date? (see above)
exports.isDateTime = function (s, calendar) {
  return exports.dateTime2ms(s, calendar) !== BADNUM;
};

// pad a number with zeroes, to given # of digits before the decimal point
function lpad(val, digits) {
  return String(val + Math.pow(10, digits)).substr(1);
}

/**
 * Turn ms into string of the form YYYY-mm-dd HH:MM:SS.ssss
 * Crop any trailing zeros in time, except never stop right after hours
 * (we could choose to crop '-01' from date too but for now we always
 * show the whole date)
 * Optional range r is the data range that applies, also in ms.
 * If rng is big, the later parts of time will be omitted
 */
var NINETYDAYS = 90 * ONEDAY;
var THREEHOURS = 3 * ONEHOUR;
var FIVEMIN = 5 * ONEMIN;
exports.ms2DateTime = function (ms, r, calendar) {
  if (typeof ms !== 'number' || !(ms >= MIN_MS && ms <= MAX_MS)) return BADNUM;
  if (!r) r = 0;
  var msecTenths = Math.floor(mod(ms + 0.05, 1) * 10);
  var msRounded = Math.round(ms - msecTenths / 10);
  var dateStr, h, m, s, msec10, d;
  if (isWorldCalendar(calendar)) {
    var dateJD = Math.floor(msRounded / ONEDAY) + EPOCHJD;
    var timeMs = Math.floor(mod(ms, ONEDAY));
    try {
      dateStr = Registry.getComponentMethod('calendars', 'getCal')(calendar).fromJD(dateJD).formatDate('yyyy-mm-dd');
    } catch (e) {
      // invalid date in this calendar - fall back to Gyyyy-mm-dd
      dateStr = utcFormat('G%Y-%m-%d')(new Date(msRounded));
    }

    // yyyy does NOT guarantee 4-digit years. YYYY mostly does, but does
    // other things for a few calendars, so we can't trust it. Just pad
    // it manually (after the '-' if there is one)
    if (dateStr.charAt(0) === '-') {
      while (dateStr.length < 11) dateStr = '-0' + dateStr.substr(1);
    } else {
      while (dateStr.length < 10) dateStr = '0' + dateStr;
    }

    // TODO: if this is faster, we could use this block for extracting
    // the time components of regular gregorian too
    h = r < NINETYDAYS ? Math.floor(timeMs / ONEHOUR) : 0;
    m = r < NINETYDAYS ? Math.floor(timeMs % ONEHOUR / ONEMIN) : 0;
    s = r < THREEHOURS ? Math.floor(timeMs % ONEMIN / ONESEC) : 0;
    msec10 = r < FIVEMIN ? timeMs % ONESEC * 10 + msecTenths : 0;
  } else {
    d = new Date(msRounded);
    dateStr = utcFormat('%Y-%m-%d')(d);

    // <90 days: add hours and minutes - never *only* add hours
    h = r < NINETYDAYS ? d.getUTCHours() : 0;
    m = r < NINETYDAYS ? d.getUTCMinutes() : 0;
    // <3 hours: add seconds
    s = r < THREEHOURS ? d.getUTCSeconds() : 0;
    // <5 minutes: add ms (plus one extra digit, this is msec*10)
    msec10 = r < FIVEMIN ? d.getUTCMilliseconds() * 10 + msecTenths : 0;
  }
  return includeTime(dateStr, h, m, s, msec10);
};

// For converting old-style milliseconds to date strings,
// we use the local timezone rather than UTC like we use
// everywhere else, both for backward compatibility and
// because that's how people mostly use javasript date objects.
// Clip one extra day off our date range though so we can't get
// thrown beyond the range by the timezone shift.
exports.ms2DateTimeLocal = function (ms) {
  if (!(ms >= MIN_MS + ONEDAY && ms <= MAX_MS - ONEDAY)) return BADNUM;
  var msecTenths = Math.floor(mod(ms + 0.05, 1) * 10);
  var d = new Date(Math.round(ms - msecTenths / 10));
  var dateStr = timeFormat('%Y-%m-%d')(d);
  var h = d.getHours();
  var m = d.getMinutes();
  var s = d.getSeconds();
  var msec10 = d.getUTCMilliseconds() * 10 + msecTenths;
  return includeTime(dateStr, h, m, s, msec10);
};
function includeTime(dateStr, h, m, s, msec10) {
  // include each part that has nonzero data in or after it
  if (h || m || s || msec10) {
    dateStr += ' ' + lpad(h, 2) + ':' + lpad(m, 2);
    if (s || msec10) {
      dateStr += ':' + lpad(s, 2);
      if (msec10) {
        var digits = 4;
        while (msec10 % 10 === 0) {
          digits -= 1;
          msec10 /= 10;
        }
        dateStr += '.' + lpad(msec10, digits);
      }
    }
  }
  return dateStr;
}

// normalize date format to date string, in case it starts as
// a Date object or milliseconds
// optional dflt is the return value if cleaning fails
exports.cleanDate = function (v, dflt, calendar) {
  // let us use cleanDate to provide a missing default without an error
  if (v === BADNUM) return dflt;
  if (exports.isJSDate(v) || typeof v === 'number' && isFinite(v)) {
    // do not allow milliseconds (old) or jsdate objects (inherently
    // described as gregorian dates) with world calendars
    if (isWorldCalendar(calendar)) {
      Loggers.error('JS Dates and milliseconds are incompatible with world calendars', v);
      return dflt;
    }

    // NOTE: if someone puts in a year as a number rather than a string,
    // this will mistakenly convert it thinking it's milliseconds from 1970
    // that is: '2012' -> Jan. 1, 2012, but 2012 -> 2012 epoch milliseconds
    v = exports.ms2DateTimeLocal(+v);
    if (!v && dflt !== undefined) return dflt;
  } else if (!exports.isDateTime(v, calendar)) {
    Loggers.error('unrecognized date', v);
    return dflt;
  }
  return v;
};

/*
 *  Date formatting for ticks and hovertext
 */

/*
 * modDateFormat: Support world calendars, and add two items to
 * d3's vocabulary:
 * %{n}f where n is the max number of digits of fractional seconds
 * %h formats: half of the year as a decimal number [1,2]
 */
var fracMatch = /%\d?f/g;
var halfYearMatch = /%h/g;
var quarterToHalfYear = {
  1: '1',
  2: '1',
  3: '2',
  4: '2'
};
function modDateFormat(fmt, x, formatter, calendar) {
  fmt = fmt.replace(fracMatch, function (match) {
    var digits = Math.min(+match.charAt(1) || 6, 6);
    var fracSecs = (x / 1000 % 1 + 2).toFixed(digits).substr(2).replace(/0+$/, '') || '0';
    return fracSecs;
  });
  var d = new Date(Math.floor(x + 0.05));
  fmt = fmt.replace(halfYearMatch, function () {
    return quarterToHalfYear[formatter('%q')(d)];
  });
  if (isWorldCalendar(calendar)) {
    try {
      fmt = Registry.getComponentMethod('calendars', 'worldCalFmt')(fmt, x, calendar);
    } catch (e) {
      return 'Invalid';
    }
  }
  return formatter(fmt)(d);
}

/*
 * formatTime: create a time string from:
 *   x: milliseconds
 *   tr: tickround ('M', 'S', or # digits)
 * only supports UTC times (where every day is 24 hours and 0 is at midnight)
 */
var MAXSECONDS = [59, 59.9, 59.99, 59.999, 59.9999];
function formatTime(x, tr) {
  var timePart = mod(x + 0.05, ONEDAY);
  var timeStr = lpad(Math.floor(timePart / ONEHOUR), 2) + ':' + lpad(mod(Math.floor(timePart / ONEMIN), 60), 2);
  if (tr !== 'M') {
    if (!isNumeric(tr)) tr = 0; // should only be 'S'

    /*
     * this is a weird one - and shouldn't come up unless people
     * monkey with tick0 in weird ways, but we need to do something!
     * IN PARTICULAR we had better not display garbage (see below)
     * for numbers we always round to the nearest increment of the
     * precision we're showing, and this seems like the right way to
     * handle seconds and milliseconds, as they have a decimal point
     * and people will interpret that to mean rounding like numbers.
     * but for larger increments we floor the value: it's always
     * 2013 until the ball drops on the new year. We could argue about
     * which field it is where we start rounding (should 12:08:59
     * round to 12:09 if we're stopping at minutes?) but for now I'll
     * say we round seconds but floor everything else. BUT that means
     * we need to never round up to 60 seconds, ie 23:59:60
     */
    var sec = Math.min(mod(x / ONESEC, 60), MAXSECONDS[tr]);
    var secStr = (100 + sec).toFixed(tr).substr(1);
    if (tr > 0) {
      secStr = secStr.replace(/0+$/, '').replace(/[\.]$/, '');
    }
    timeStr += ':' + secStr;
  }
  return timeStr;
}

/*
 * formatDate: turn a date into tick or hover label text.
 *
 *   x: milliseconds, the value to convert
 *   fmt: optional, an explicit format string (d3 format, even for world calendars)
 *   tr: tickround ('y', 'm', 'd', 'M', 'S', or # digits)
 *      used if no explicit fmt is provided
 *   formatter: locale-aware d3 date formatter for standard gregorian calendars
 *      should be the result of exports.getD3DateFormat(gd)
 *   calendar: optional string, the world calendar system to use
 *
 * returns the date/time as a string, potentially with the leading portion
 * on a separate line (after '\n')
 * Note that this means if you provide an explicit format which includes '\n'
 * the axis may choose to strip things after it when they don't change from
 * one tick to the next (as it does with automatic formatting)
 */
exports.formatDate = function (x, fmt, tr, formatter, calendar, extraFormat) {
  calendar = isWorldCalendar(calendar) && calendar;
  if (!fmt) {
    if (tr === 'y') fmt = extraFormat.year;else if (tr === 'm') fmt = extraFormat.month;else if (tr === 'd') {
      fmt = extraFormat.dayMonth + '\n' + extraFormat.year;
    } else {
      return formatTime(x, tr) + '\n' + modDateFormat(extraFormat.dayMonthYear, x, formatter, calendar);
    }
  }
  return modDateFormat(fmt, x, formatter, calendar);
};

/*
 * incrementMonth: make a new milliseconds value from the given one,
 * having changed the month
 *
 * special case for world calendars: multiples of 12 are treated as years,
 * even for calendar systems that don't have (always or ever) 12 months/year
 * TODO: perhaps we need a different code for year increments to support this?
 *
 * ms (number): the initial millisecond value
 * dMonth (int): the (signed) number of months to shift
 * calendar (string): the calendar system to use
 *
 * changing month does not (and CANNOT) always preserve day, since
 * months have different lengths. The worst example of this is:
 *   d = new Date(1970,0,31); d.setMonth(1) -> Feb 31 turns into Mar 3
 *
 * But we want to be able to iterate over the last day of each month,
 * regardless of what its number is.
 * So shift 3 days forward, THEN set the new month, then unshift:
 *   1/31 -> 2/28 (or 29) -> 3/31 -> 4/30 -> ...
 *
 * Note that odd behavior still exists if you start from the 26th-28th:
 *   1/28 -> 2/28 -> 3/31
 * but at least you can't shift any dates into the wrong month,
 * and ticks on these days incrementing by month would be very unusual
 */
var THREEDAYS = 3 * ONEDAY;
exports.incrementMonth = function (ms, dMonth, calendar) {
  calendar = isWorldCalendar(calendar) && calendar;

  // pull time out and operate on pure dates, then add time back at the end
  // this gives maximum precision - not that we *normally* care if we're
  // incrementing by month, but better to be safe!
  var timeMs = mod(ms, ONEDAY);
  ms = Math.round(ms - timeMs);
  if (calendar) {
    try {
      var dateJD = Math.round(ms / ONEDAY) + EPOCHJD;
      var calInstance = Registry.getComponentMethod('calendars', 'getCal')(calendar);
      var cDate = calInstance.fromJD(dateJD);
      if (dMonth % 12) calInstance.add(cDate, dMonth, 'm');else calInstance.add(cDate, dMonth / 12, 'y');
      return (cDate.toJD() - EPOCHJD) * ONEDAY + timeMs;
    } catch (e) {
      Loggers.error('invalid ms ' + ms + ' in calendar ' + calendar);
      // then keep going in gregorian even though the result will be 'Invalid'
    }
  }

  var y = new Date(ms + THREEDAYS);
  return y.setUTCMonth(y.getUTCMonth() + dMonth) + timeMs - THREEDAYS;
};

/*
 * findExactDates: what fraction of data is exact days, months, or years?
 *
 * data: array of millisecond values
 * calendar (string) the calendar to test against
 */
exports.findExactDates = function (data, calendar) {
  var exactYears = 0;
  var exactMonths = 0;
  var exactDays = 0;
  var blankCount = 0;
  var d;
  var di;
  var calInstance = isWorldCalendar(calendar) && Registry.getComponentMethod('calendars', 'getCal')(calendar);
  for (var i = 0; i < data.length; i++) {
    di = data[i];

    // not date data at all
    if (!isNumeric(di)) {
      blankCount++;
      continue;
    }

    // not an exact date
    if (di % ONEDAY) continue;
    if (calInstance) {
      try {
        d = calInstance.fromJD(di / ONEDAY + EPOCHJD);
        if (d.day() === 1) {
          if (d.month() === 1) exactYears++;else exactMonths++;
        } else exactDays++;
      } catch (e) {
        // invalid date in this calendar - ignore it here.
      }
    } else {
      d = new Date(di);
      if (d.getUTCDate() === 1) {
        if (d.getUTCMonth() === 0) exactYears++;else exactMonths++;
      } else exactDays++;
    }
  }
  exactMonths += exactYears;
  exactDays += exactMonths;
  var dataCount = data.length - blankCount;
  return {
    exactYears: exactYears / dataCount,
    exactMonths: exactMonths / dataCount,
    exactDays: exactDays / dataCount
  };
};

/***/ }),

/***/ 2200:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var loggers = __webpack_require__(4248);
var matrix = __webpack_require__(2248);
var mat4X4 = __webpack_require__(6524);

/**
 * Allow referencing a graph DOM element either directly
 * or by its id string
 *
 * @param {HTMLDivElement|string} gd: a graph element or its id
 *
 * @returns {HTMLDivElement} the DOM element of the graph
 */
function getGraphDiv(gd) {
  var gdElement;
  if (typeof gd === 'string') {
    gdElement = document.getElementById(gd);
    if (gdElement === null) {
      throw new Error('No DOM element with id \'' + gd + '\' exists on the page.');
    }
    return gdElement;
  } else if (gd === null || gd === undefined) {
    throw new Error('DOM element provided is null or undefined');
  }

  // otherwise assume that gd is a DOM element
  return gd;
}
function isPlotDiv(el) {
  var el3 = d3.select(el);
  return el3.node() instanceof HTMLElement && el3.size() && el3.classed('js-plotly-plot');
}
function removeElement(el) {
  var elParent = el && el.parentNode;
  if (elParent) elParent.removeChild(el);
}

/**
 * for dynamically adding style rules
 * makes one stylesheet that contains all rules added
 * by all calls to this function
 */
function addStyleRule(selector, styleString) {
  addRelatedStyleRule('global', selector, styleString);
}

/**
 * for dynamically adding style rules
 * to a stylesheet uniquely identified by a uid
 */
function addRelatedStyleRule(uid, selector, styleString) {
  var id = 'plotly.js-style-' + uid;
  var style = document.getElementById(id);
  if (!style) {
    style = document.createElement('style');
    style.setAttribute('id', id);
    // WebKit hack :(
    style.appendChild(document.createTextNode(''));
    document.head.appendChild(style);
  }
  var styleSheet = style.sheet;
  if (styleSheet.insertRule) {
    styleSheet.insertRule(selector + '{' + styleString + '}', 0);
  } else if (styleSheet.addRule) {
    styleSheet.addRule(selector, styleString, 0);
  } else loggers.warn('addStyleRule failed');
}

/**
 * to remove from the page a stylesheet identified by a given uid
 */
function deleteRelatedStyleRule(uid) {
  var id = 'plotly.js-style-' + uid;
  var style = document.getElementById(id);
  if (style) removeElement(style);
}
function getFullTransformMatrix(element) {
  var allElements = getElementAndAncestors(element);
  // the identity matrix
  var out = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
  allElements.forEach(function (e) {
    var t = getElementTransformMatrix(e);
    if (t) {
      var m = matrix.convertCssMatrix(t);
      out = mat4X4.multiply(out, out, m);
    }
  });
  return out;
}

/**
 * extracts and parses the 2d css style transform matrix from some element
 */
function getElementTransformMatrix(element) {
  var style = window.getComputedStyle(element, null);
  var transform = style.getPropertyValue('-webkit-transform') || style.getPropertyValue('-moz-transform') || style.getPropertyValue('-ms-transform') || style.getPropertyValue('-o-transform') || style.getPropertyValue('transform');
  if (transform === 'none') return null;
  // the transform is a string in the form of matrix(a, b, ...) or matrix3d(...)
  return transform.replace('matrix', '').replace('3d', '').slice(1, -1).split(',').map(function (n) {
    return +n;
  });
}
/**
 * retrieve all DOM elements that are ancestors of the specified one (including itself)
 */
function getElementAndAncestors(element) {
  var allElements = [];
  while (isTransformableElement(element)) {
    allElements.push(element);
    element = element.parentNode;
  }
  return allElements;
}
function isTransformableElement(element) {
  return element && (element instanceof Element || element instanceof HTMLElement);
}
function equalDomRects(a, b) {
  return a && b && a.top === b.top && a.left === b.left && a.right === b.right && a.bottom === b.bottom;
}
module.exports = {
  getGraphDiv: getGraphDiv,
  isPlotDiv: isPlotDiv,
  removeElement: removeElement,
  addStyleRule: addStyleRule,
  addRelatedStyleRule: addRelatedStyleRule,
  deleteRelatedStyleRule: deleteRelatedStyleRule,
  getFullTransformMatrix: getFullTransformMatrix,
  getElementTransformMatrix: getElementTransformMatrix,
  getElementAndAncestors: getElementAndAncestors,
  equalDomRects: equalDomRects
};

/***/ }),

/***/ 5924:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


/* global jQuery:false */
var EventEmitter = (__webpack_require__(1252).EventEmitter);
var Events = {
  init: function (plotObj) {
    /*
     * If we have already instantiated an emitter for this plot
     * return early.
     */
    if (plotObj._ev instanceof EventEmitter) return plotObj;
    var ev = new EventEmitter();
    var internalEv = new EventEmitter();

    /*
     * Assign to plot._ev while we still live in a land
     * where plot is a DOM element with stuff attached to it.
     * In the future we can make plot the event emitter itself.
     */
    plotObj._ev = ev;

    /*
     * Create a second event handler that will manage events *internally*.
     * This allows parts of plotly to respond to thing like relayout without
     * having to use the user-facing event handler. They cannot peacefully
     * coexist on the same handler because a user invoking
     * plotObj.removeAllListeners() would detach internal events, breaking
     * plotly.
     */
    plotObj._internalEv = internalEv;

    /*
     * Assign bound methods from the ev to the plot object. These methods
     * will reference the 'this' of plot._ev even though they are methods
     * of plot. This will keep the event machinery away from the plot object
     * which currently is often a DOM element but presents an API that will
     * continue to function when plot becomes an emitter. Not all EventEmitter
     * methods have been bound to `plot` as some do not currently add value to
     * the Plotly event API.
     */
    plotObj.on = ev.on.bind(ev);
    plotObj.once = ev.once.bind(ev);
    plotObj.removeListener = ev.removeListener.bind(ev);
    plotObj.removeAllListeners = ev.removeAllListeners.bind(ev);

    /*
     * Create functions for managing internal events. These are *only* triggered
     * by the mirroring of external events via the emit function.
     */
    plotObj._internalOn = internalEv.on.bind(internalEv);
    plotObj._internalOnce = internalEv.once.bind(internalEv);
    plotObj._removeInternalListener = internalEv.removeListener.bind(internalEv);
    plotObj._removeAllInternalListeners = internalEv.removeAllListeners.bind(internalEv);

    /*
     * We must wrap emit to continue to support JQuery events. The idea
     * is to check to see if the user is using JQuery events, if they are
     * we emit JQuery events to trigger user handlers as well as the EventEmitter
     * events.
     */
    plotObj.emit = function (event, data) {
      if (typeof jQuery !== 'undefined') {
        jQuery(plotObj).trigger(event, data);
      }
      ev.emit(event, data);
      internalEv.emit(event, data);
    };
    return plotObj;
  },
  /*
   * This function behaves like jQuery's triggerHandler. It calls
   * all handlers for a particular event and returns the return value
   * of the LAST handler. This function also triggers jQuery's
   * triggerHandler for backwards compatibility.
   */
  triggerHandler: function (plotObj, event, data) {
    var jQueryHandlerValue;
    var nodeEventHandlerValue;

    /*
     * If jQuery exists run all its handlers for this event and
     * collect the return value of the LAST handler function
     */
    if (typeof jQuery !== 'undefined') {
      jQueryHandlerValue = jQuery(plotObj).triggerHandler(event, data);
    }

    /*
     * Now run all the node style event handlers
     */
    var ev = plotObj._ev;
    if (!ev) return jQueryHandlerValue;
    var handlers = ev._events[event];
    if (!handlers) return jQueryHandlerValue;

    // making sure 'this' is the EventEmitter instance
    function apply(handler) {
      // The 'once' case, we can't just call handler() as we need
      // the return value here. So,
      // - remove handler
      // - call listener and grab return value!
      // - stash 'fired' key to not call handler twice
      if (handler.listener) {
        ev.removeListener(event, handler.listener);
        if (!handler.fired) {
          handler.fired = true;
          return handler.listener.apply(ev, [data]);
        }
      } else {
        return handler.apply(ev, [data]);
      }
    }

    // handlers can be function or an array of functions
    handlers = Array.isArray(handlers) ? handlers : [handlers];
    var i;
    for (i = 0; i < handlers.length - 1; i++) {
      apply(handlers[i]);
    }
    // now call the final handler and collect its value
    nodeEventHandlerValue = apply(handlers[i]);

    /*
     * Return either the jQuery handler value if it exists or the
     * nodeEventHandler value. jQuery event value supersedes nodejs
     * events for backwards compatibility reasons.
     */
    return jQueryHandlerValue !== undefined ? jQueryHandlerValue : nodeEventHandlerValue;
  },
  purge: function (plotObj) {
    delete plotObj._ev;
    delete plotObj.on;
    delete plotObj.once;
    delete plotObj.removeListener;
    delete plotObj.removeAllListeners;
    delete plotObj.emit;
    delete plotObj._ev;
    delete plotObj._internalEv;
    delete plotObj._internalOn;
    delete plotObj._internalOnce;
    delete plotObj._removeInternalListener;
    delete plotObj._removeAllInternalListeners;
    return plotObj;
  }
};
module.exports = Events;

/***/ }),

/***/ 2880:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var isPlainObject = __webpack_require__(3620);
var isArray = Array.isArray;
function primitivesLoopSplice(source, target) {
  var i, value;
  for (i = 0; i < source.length; i++) {
    value = source[i];
    if (value !== null && typeof value === 'object') {
      return false;
    }
    if (value !== void 0) {
      target[i] = value;
    }
  }
  return true;
}
exports.extendFlat = function () {
  return _extend(arguments, false, false, false);
};
exports.extendDeep = function () {
  return _extend(arguments, true, false, false);
};
exports.extendDeepAll = function () {
  return _extend(arguments, true, true, false);
};
exports.extendDeepNoArrays = function () {
  return _extend(arguments, true, false, true);
};

/*
 * Inspired by https://github.com/justmoon/node-extend/blob/master/index.js
 * All credit to the jQuery authors for perfecting this amazing utility.
 *
 * API difference with jQuery version:
 * - No optional boolean (true -> deep extend) first argument,
 *   use `extendFlat` for first-level only extend and
 *   use `extendDeep` for a deep extend.
 *
 * Other differences with jQuery version:
 * - Uses a modern (and faster) isPlainObject routine.
 * - Expected to work with object {} and array [] arguments only.
 * - Does not check for circular structure.
 *   FYI: jQuery only does a check across one level.
 *   Warning: this might result in infinite loops.
 *
 */
function _extend(inputs, isDeep, keepAllKeys, noArrayCopies) {
  var target = inputs[0];
  var length = inputs.length;
  var input, key, src, copy, copyIsArray, clone, allPrimitives;

  // TODO does this do the right thing for typed arrays?

  if (length === 2 && isArray(target) && isArray(inputs[1]) && target.length === 0) {
    allPrimitives = primitivesLoopSplice(inputs[1], target);
    if (allPrimitives) {
      return target;
    } else {
      target.splice(0, target.length); // reset target and continue to next block
    }
  }

  for (var i = 1; i < length; i++) {
    input = inputs[i];
    for (key in input) {
      src = target[key];
      copy = input[key];
      if (noArrayCopies && isArray(copy)) {
        // Stop early and just transfer the array if array copies are disallowed:

        target[key] = copy;
      } else if (isDeep && copy && (isPlainObject(copy) || (copyIsArray = isArray(copy)))) {
        // recurse if we're merging plain objects or arrays

        if (copyIsArray) {
          copyIsArray = false;
          clone = src && isArray(src) ? src : [];
        } else {
          clone = src && isPlainObject(src) ? src : {};
        }

        // never move original objects, clone them
        target[key] = _extend([clone, copy], isDeep, keepAllKeys, noArrayCopies);
      } else if (typeof copy !== 'undefined' || keepAllKeys) {
        // don't bring in undefined values, except for extendDeepAll

        target[key] = copy;
      }
    }
  }
  return target;
}

/***/ }),

/***/ 8944:
/***/ (function(module) {

"use strict";


/**
 * Return news array containing only the unique items
 * found in input array.
 *
 * IMPORTANT: Note that items are considered unique
 * if `String({})` is unique. For example;
 *
 *  Lib.filterUnique([ { a: 1 }, { b: 2 } ])
 *
 *  returns [{ a: 1 }]
 *
 * and
 *
 *  Lib.filterUnique([ '1', 1 ])
 *
 *  returns ['1']
 *
 *
 * @param {array} array base array
 * @return {array} new filtered array
 */
module.exports = function filterUnique(array) {
  var seen = {};
  var out = [];
  var j = 0;
  for (var i = 0; i < array.length; i++) {
    var item = array[i];
    if (seen[item] !== 1) {
      seen[item] = 1;
      out[j++] = item;
    }
  }
  return out;
};

/***/ }),

/***/ 3880:
/***/ (function(module) {

"use strict";


/** Filter out object items with visible !== true
 *  insider array container.
 *
 *  @param {array of objects} container
 *  @return {array of objects} of length <= container
 *
 */
module.exports = function filterVisible(container) {
  var filterFn = isCalcData(container) ? calcDataFilter : baseFilter;
  var out = [];
  for (var i = 0; i < container.length; i++) {
    var item = container[i];
    if (filterFn(item)) out.push(item);
  }
  return out;
};
function baseFilter(item) {
  return item.visible === true;
}
function calcDataFilter(item) {
  var trace = item[0].trace;
  return trace.visible === true && trace._length !== 0;
}
function isCalcData(cont) {
  return Array.isArray(cont) && Array.isArray(cont[0]) && cont[0][0] && cont[0][0].trace;
}

/***/ }),

/***/ 7144:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var countryRegex = __webpack_require__(6116);
var turfArea = __webpack_require__(440);
var turfCentroid = __webpack_require__(7844);
var turfBbox = __webpack_require__(2428);
var identity = __webpack_require__(5536);
var loggers = __webpack_require__(4248);
var isPlainObject = __webpack_require__(3620);
var nestedProperty = __webpack_require__(2296);
var polygon = __webpack_require__(2065);

// make list of all country iso3 ids from at runtime
var countryIds = Object.keys(countryRegex);
var locationmodeToIdFinder = {
  'ISO-3': identity,
  'USA-states': identity,
  'country names': countryNameToISO3
};
function countryNameToISO3(countryName) {
  for (var i = 0; i < countryIds.length; i++) {
    var iso3 = countryIds[i];
    var regex = new RegExp(countryRegex[iso3]);
    if (regex.test(countryName.trim().toLowerCase())) return iso3;
  }
  loggers.log('Unrecognized country name: ' + countryName + '.');
  return false;
}
function locationToFeature(locationmode, location, features) {
  if (!location || typeof location !== 'string') return false;
  var locationId = locationmodeToIdFinder[locationmode](location);
  var filteredFeatures;
  var f, i;
  if (locationId) {
    if (locationmode === 'USA-states') {
      // Filter out features out in USA
      //
      // This is important as the Natural Earth files
      // include state/provinces from USA, Canada, Australia and Brazil
      // which have some overlay in their two-letter ids. For example,
      // 'WA' is used for both Washington state and Western Australia.
      filteredFeatures = [];
      for (i = 0; i < features.length; i++) {
        f = features[i];
        if (f.properties && f.properties.gu && f.properties.gu === 'USA') {
          filteredFeatures.push(f);
        }
      }
    } else {
      filteredFeatures = features;
    }
    for (i = 0; i < filteredFeatures.length; i++) {
      f = filteredFeatures[i];
      if (f.id === locationId) return f;
    }
    loggers.log(['Location with id', locationId, 'does not have a matching topojson feature at this resolution.'].join(' '));
  }
  return false;
}
function feature2polygons(feature) {
  var geometry = feature.geometry;
  var coords = geometry.coordinates;
  var loc = feature.id;
  var polygons = [];
  var appendPolygon, j, k, m;
  function doesCrossAntiMerdian(pts) {
    for (var l = 0; l < pts.length - 1; l++) {
      if (pts[l][0] > 0 && pts[l + 1][0] < 0) return l;
    }
    return null;
  }
  if (loc === 'RUS' || loc === 'FJI') {
    // Russia and Fiji have landmasses that cross the antimeridian,
    // we need to add +360 to their longitude coordinates, so that
    // polygon 'contains' doesn't get confused when crossing the antimeridian.
    //
    // Note that other countries have polygons on either side of the antimeridian
    // (e.g. some Aleutian island for the USA), but those don't confuse
    // the 'contains' method; these are skipped here.
    appendPolygon = function (_pts) {
      var pts;
      if (doesCrossAntiMerdian(_pts) === null) {
        pts = _pts;
      } else {
        pts = new Array(_pts.length);
        for (m = 0; m < _pts.length; m++) {
          // do not mutate calcdata[i][j].geojson !!
          pts[m] = [_pts[m][0] < 0 ? _pts[m][0] + 360 : _pts[m][0], _pts[m][1]];
        }
      }
      polygons.push(polygon.tester(pts));
    };
  } else if (loc === 'ATA') {
    // Antarctica has a landmass that wraps around every longitudes which
    // confuses the 'contains' methods.
    appendPolygon = function (pts) {
      var crossAntiMeridianIndex = doesCrossAntiMerdian(pts);

      // polygon that do not cross anti-meridian need no special handling
      if (crossAntiMeridianIndex === null) {
        return polygons.push(polygon.tester(pts));
      }

      // stitch polygon by adding pt over South Pole,
      // so that it covers the projected region covers all latitudes
      //
      // Note that the algorithm below only works for polygons that
      // start and end on longitude -180 (like the ones built by
      // https://github.com/etpinard/sane-topojson).
      var stitch = new Array(pts.length + 1);
      var si = 0;
      for (m = 0; m < pts.length; m++) {
        if (m > crossAntiMeridianIndex) {
          stitch[si++] = [pts[m][0] + 360, pts[m][1]];
        } else if (m === crossAntiMeridianIndex) {
          stitch[si++] = pts[m];
          stitch[si++] = [pts[m][0], -90];
        } else {
          stitch[si++] = pts[m];
        }
      }

      // polygon.tester by default appends pt[0] to the points list,
      // we must remove it here, to avoid a jump in longitude from 180 to -180,
      // that would confuse the 'contains' method
      var tester = polygon.tester(stitch);
      tester.pts.pop();
      polygons.push(tester);
    };
  } else {
    // otherwise using same array ref is fine
    appendPolygon = function (pts) {
      polygons.push(polygon.tester(pts));
    };
  }
  switch (geometry.type) {
    case 'MultiPolygon':
      for (j = 0; j < coords.length; j++) {
        for (k = 0; k < coords[j].length; k++) {
          appendPolygon(coords[j][k]);
        }
      }
      break;
    case 'Polygon':
      for (j = 0; j < coords.length; j++) {
        appendPolygon(coords[j]);
      }
      break;
  }
  return polygons;
}
function getTraceGeojson(trace) {
  var g = trace.geojson;
  var PlotlyGeoAssets = window.PlotlyGeoAssets || {};
  var geojsonIn = typeof g === 'string' ? PlotlyGeoAssets[g] : g;

  // This should not happen, but just in case something goes
  // really wrong when fetching the GeoJSON
  if (!isPlainObject(geojsonIn)) {
    loggers.error('Oops ... something went wrong when fetching ' + g);
    return false;
  }
  return geojsonIn;
}
function extractTraceFeature(calcTrace) {
  var trace = calcTrace[0].trace;
  var geojsonIn = getTraceGeojson(trace);
  if (!geojsonIn) return false;
  var lookup = {};
  var featuresOut = [];
  var i;
  for (i = 0; i < trace._length; i++) {
    var cdi = calcTrace[i];
    if (cdi.loc || cdi.loc === 0) {
      lookup[cdi.loc] = cdi;
    }
  }
  function appendFeature(fIn) {
    var id = nestedProperty(fIn, trace.featureidkey || 'id').get();
    var cdi = lookup[id];
    if (cdi) {
      var geometry = fIn.geometry;
      if (geometry.type === 'Polygon' || geometry.type === 'MultiPolygon') {
        var fOut = {
          type: 'Feature',
          id: id,
          geometry: geometry,
          properties: {}
        };

        // Compute centroid, add it to the properties
        fOut.properties.ct = findCentroid(fOut);

        // Mutate in in/out features into calcdata
        cdi.fIn = fIn;
        cdi.fOut = fOut;
        featuresOut.push(fOut);
      } else {
        loggers.log(['Location', cdi.loc, 'does not have a valid GeoJSON geometry.', 'Traces with locationmode *geojson-id* only support', '*Polygon* and *MultiPolygon* geometries.'].join(' '));
      }
    }

    // remove key from lookup, so that we can track (if any)
    // the locations that did not have a corresponding GeoJSON feature
    delete lookup[id];
  }
  switch (geojsonIn.type) {
    case 'FeatureCollection':
      var featuresIn = geojsonIn.features;
      for (i = 0; i < featuresIn.length; i++) {
        appendFeature(featuresIn[i]);
      }
      break;
    case 'Feature':
      appendFeature(geojsonIn);
      break;
    default:
      loggers.warn(['Invalid GeoJSON type', (geojsonIn.type || 'none') + '.', 'Traces with locationmode *geojson-id* only support', '*FeatureCollection* and *Feature* types.'].join(' '));
      return false;
  }
  for (var loc in lookup) {
    loggers.log(['Location *' + loc + '*', 'does not have a matching feature with id-key', '*' + trace.featureidkey + '*.'].join(' '));
  }
  return featuresOut;
}

// TODO this find the centroid of the polygon of maxArea
// (just like we currently do for geo choropleth polygons),
// maybe instead it would make more sense to compute the centroid
// of each polygon and consider those on hover/select
function findCentroid(feature) {
  var geometry = feature.geometry;
  var poly;
  if (geometry.type === 'MultiPolygon') {
    var coords = geometry.coordinates;
    var maxArea = 0;
    for (var i = 0; i < coords.length; i++) {
      var polyi = {
        type: 'Polygon',
        coordinates: coords[i]
      };
      var area = turfArea.default(polyi);
      if (area > maxArea) {
        maxArea = area;
        poly = polyi;
      }
    }
  } else {
    poly = geometry;
  }
  return turfCentroid.default(poly).geometry.coordinates;
}
function fetchTraceGeoData(calcData) {
  var PlotlyGeoAssets = window.PlotlyGeoAssets || {};
  var promises = [];
  function fetch(url) {
    return new Promise(function (resolve, reject) {
      d3.json(url, function (err, d) {
        if (err) {
          delete PlotlyGeoAssets[url];
          var msg = err.status === 404 ? 'GeoJSON at URL "' + url + '" does not exist.' : 'Unexpected error while fetching from ' + url;
          return reject(new Error(msg));
        }
        PlotlyGeoAssets[url] = d;
        return resolve(d);
      });
    });
  }
  function wait(url) {
    return new Promise(function (resolve, reject) {
      var cnt = 0;
      var interval = setInterval(function () {
        if (PlotlyGeoAssets[url] && PlotlyGeoAssets[url] !== 'pending') {
          clearInterval(interval);
          return resolve(PlotlyGeoAssets[url]);
        }
        if (cnt > 100) {
          clearInterval(interval);
          return reject('Unexpected error while fetching from ' + url);
        }
        cnt++;
      }, 50);
    });
  }
  for (var i = 0; i < calcData.length; i++) {
    var trace = calcData[i][0].trace;
    var url = trace.geojson;
    if (typeof url === 'string') {
      if (!PlotlyGeoAssets[url]) {
        PlotlyGeoAssets[url] = 'pending';
        promises.push(fetch(url));
      } else if (PlotlyGeoAssets[url] === 'pending') {
        promises.push(wait(url));
      }
    }
  }
  return promises;
}

// TODO `turf/bbox` gives wrong result when the input feature/geometry
// crosses the anti-meridian. We should try to implement our own bbox logic.
function computeBbox(d) {
  return turfBbox.default(d);
}
module.exports = {
  locationToFeature: locationToFeature,
  feature2polygons: feature2polygons,
  getTraceGeojson: getTraceGeojson,
  extractTraceFeature: extractTraceFeature,
  fetchTraceGeoData: fetchTraceGeoData,
  computeBbox: computeBbox
};

/***/ }),

/***/ 4808:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var BADNUM = (__webpack_require__(9032).BADNUM);

/**
 * Convert calcTrace to GeoJSON 'MultiLineString' coordinate arrays
 *
 * @param {object} calcTrace
 *  gd.calcdata item.
 *  Note that calcTrace[i].lonlat is assumed to be defined
 *
 * @return {array}
 *  return line coords array (or array of arrays)
 *
 */
exports.calcTraceToLineCoords = function (calcTrace) {
  var trace = calcTrace[0].trace;
  var connectgaps = trace.connectgaps;
  var coords = [];
  var lineString = [];
  for (var i = 0; i < calcTrace.length; i++) {
    var calcPt = calcTrace[i];
    var lonlat = calcPt.lonlat;
    if (lonlat[0] !== BADNUM) {
      lineString.push(lonlat);
    } else if (!connectgaps && lineString.length > 0) {
      coords.push(lineString);
      lineString = [];
    }
  }
  if (lineString.length > 0) {
    coords.push(lineString);
  }
  return coords;
};

/**
 * Make line ('LineString' or 'MultiLineString') GeoJSON
 *
 * @param {array} coords
 *  results form calcTraceToLineCoords
 * @return {object} out
 *  GeoJSON object
 *
 */
exports.makeLine = function (coords) {
  if (coords.length === 1) {
    return {
      type: 'LineString',
      coordinates: coords[0]
    };
  } else {
    return {
      type: 'MultiLineString',
      coordinates: coords
    };
  }
};

/**
 * Make polygon ('Polygon' or 'MultiPolygon') GeoJSON
 *
 * @param {array} coords
 *  results form calcTraceToLineCoords
 * @return {object} out
 *  GeoJSON object
 */
exports.makePolygon = function (coords) {
  if (coords.length === 1) {
    return {
      type: 'Polygon',
      coordinates: coords
    };
  } else {
    var _coords = new Array(coords.length);
    for (var i = 0; i < coords.length; i++) {
      _coords[i] = [coords[i]];
    }
    return {
      type: 'MultiPolygon',
      coordinates: _coords
    };
  }
};

/**
 * Make blank GeoJSON
 *
 * @return {object}
 *  Blank GeoJSON object
 *
 */
exports.makeBlank = function () {
  return {
    type: 'Point',
    coordinates: []
  };
};

/***/ }),

/***/ 2348:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var mod = (__webpack_require__(435).mod);

/*
 * look for intersection of two line segments
 *   (1->2 and 3->4) - returns array [x,y] if they do, null if not
 */
exports.segmentsIntersect = segmentsIntersect;
function segmentsIntersect(x1, y1, x2, y2, x3, y3, x4, y4) {
  var a = x2 - x1;
  var b = x3 - x1;
  var c = x4 - x3;
  var d = y2 - y1;
  var e = y3 - y1;
  var f = y4 - y3;
  var det = a * f - c * d;
  // parallel lines? intersection is undefined
  // ignore the case where they are colinear
  if (det === 0) return null;
  var t = (b * f - c * e) / det;
  var u = (b * d - a * e) / det;
  // segments do not intersect?
  if (u < 0 || u > 1 || t < 0 || t > 1) return null;
  return {
    x: x1 + a * t,
    y: y1 + d * t
  };
}

/*
 * find the minimum distance between two line segments (1->2 and 3->4)
 */
exports.segmentDistance = function segmentDistance(x1, y1, x2, y2, x3, y3, x4, y4) {
  if (segmentsIntersect(x1, y1, x2, y2, x3, y3, x4, y4)) return 0;

  // the two segments and their lengths squared
  var x12 = x2 - x1;
  var y12 = y2 - y1;
  var x34 = x4 - x3;
  var y34 = y4 - y3;
  var ll12 = x12 * x12 + y12 * y12;
  var ll34 = x34 * x34 + y34 * y34;

  // calculate distance squared, then take the sqrt at the very end
  var dist2 = Math.min(perpDistance2(x12, y12, ll12, x3 - x1, y3 - y1), perpDistance2(x12, y12, ll12, x4 - x1, y4 - y1), perpDistance2(x34, y34, ll34, x1 - x3, y1 - y3), perpDistance2(x34, y34, ll34, x2 - x3, y2 - y3));
  return Math.sqrt(dist2);
};

/*
 * distance squared from segment ab to point c
 * [xab, yab] is the vector b-a
 * [xac, yac] is the vector c-a
 * llab is the length squared of (b-a), just to simplify calculation
 */
function perpDistance2(xab, yab, llab, xac, yac) {
  var fcAB = xac * xab + yac * yab;
  if (fcAB < 0) {
    // point c is closer to point a
    return xac * xac + yac * yac;
  } else if (fcAB > llab) {
    // point c is closer to point b
    var xbc = xac - xab;
    var ybc = yac - yab;
    return xbc * xbc + ybc * ybc;
  } else {
    // perpendicular distance is the shortest
    var crossProduct = xac * yab - yac * xab;
    return crossProduct * crossProduct / llab;
  }
}

// a very short-term cache for getTextLocation, just because
// we're often looping over the same locations multiple times
// invalidated as soon as we look at a different path
var locationCache, workingPath, workingTextWidth;

// turn a path and position along it into x, y, and angle for the given text
exports.getTextLocation = function getTextLocation(path, totalPathLen, positionOnPath, textWidth) {
  if (path !== workingPath || textWidth !== workingTextWidth) {
    locationCache = {};
    workingPath = path;
    workingTextWidth = textWidth;
  }
  if (locationCache[positionOnPath]) {
    return locationCache[positionOnPath];
  }

  // for the angle, use points on the path separated by the text width
  // even though due to curvature, the text will cover a bit more than that
  var p0 = path.getPointAtLength(mod(positionOnPath - textWidth / 2, totalPathLen));
  var p1 = path.getPointAtLength(mod(positionOnPath + textWidth / 2, totalPathLen));
  // note: atan handles 1/0 nicely
  var theta = Math.atan((p1.y - p0.y) / (p1.x - p0.x));
  // center the text at 2/3 of the center position plus 1/3 the p0/p1 midpoint
  // that's the average position of this segment, assuming it's roughly quadratic
  var pCenter = path.getPointAtLength(mod(positionOnPath, totalPathLen));
  var x = (pCenter.x * 4 + p0.x + p1.x) / 6;
  var y = (pCenter.y * 4 + p0.y + p1.y) / 6;
  var out = {
    x: x,
    y: y,
    theta: theta
  };
  locationCache[positionOnPath] = out;
  return out;
};
exports.clearLocationCache = function () {
  workingPath = null;
};

/*
 * Find the segment of `path` that's within the visible area
 * given by `bounds` {left, right, top, bottom}, to within a
 * precision of `buffer` px
 *
 * returns: undefined if nothing is visible, else object:
 * {
 *   min: position where the path first enters bounds, or 0 if it
 *        starts within bounds
 *   max: position where the path last exits bounds, or the path length
 *        if it finishes within bounds
 *   len: max - min, ie the length of visible path
 *   total: the total path length - just included so the caller doesn't
 *        need to call path.getTotalLength() again
 *   isClosed: true iff the start and end points of the path are both visible
 *        and are at the same point
 * }
 *
 * Works by starting from either end and repeatedly finding the distance from
 * that point to the plot area, and if it's outside the plot, moving along the
 * path by that distance (because the plot must be at least that far away on
 * the path). Note that if a path enters, exits, and re-enters the plot, we
 * will not capture this behavior.
 */
exports.getVisibleSegment = function getVisibleSegment(path, bounds, buffer) {
  var left = bounds.left;
  var right = bounds.right;
  var top = bounds.top;
  var bottom = bounds.bottom;
  var pMin = 0;
  var pTotal = path.getTotalLength();
  var pMax = pTotal;
  var pt0, ptTotal;
  function getDistToPlot(len) {
    var pt = path.getPointAtLength(len);

    // hold on to the start and end points for `closed`
    if (len === 0) pt0 = pt;else if (len === pTotal) ptTotal = pt;
    var dx = pt.x < left ? left - pt.x : pt.x > right ? pt.x - right : 0;
    var dy = pt.y < top ? top - pt.y : pt.y > bottom ? pt.y - bottom : 0;
    return Math.sqrt(dx * dx + dy * dy);
  }
  var distToPlot = getDistToPlot(pMin);
  while (distToPlot) {
    pMin += distToPlot + buffer;
    if (pMin > pMax) return;
    distToPlot = getDistToPlot(pMin);
  }
  distToPlot = getDistToPlot(pMax);
  while (distToPlot) {
    pMax -= distToPlot + buffer;
    if (pMin > pMax) return;
    distToPlot = getDistToPlot(pMax);
  }
  return {
    min: pMin,
    max: pMax,
    len: pMax - pMin,
    total: pTotal,
    isClosed: pMin === 0 && pMax === pTotal && Math.abs(pt0.x - ptTotal.x) < 0.1 && Math.abs(pt0.y - ptTotal.y) < 0.1
  };
};

/**
 * Find point on SVG path corresponding to a given constraint coordinate
 *
 * @param {SVGPathElement} path
 * @param {Number} val : constraint coordinate value
 * @param {String} coord : 'x' or 'y' the constraint coordinate
 * @param {Object} opts :
 *  - {Number} pathLength : supply total path length before hand
 *  - {Number} tolerance
 *  - {Number} iterationLimit
 * @return {SVGPoint}
 */
exports.findPointOnPath = function findPointOnPath(path, val, coord, opts) {
  opts = opts || {};
  var pathLength = opts.pathLength || path.getTotalLength();
  var tolerance = opts.tolerance || 1e-3;
  var iterationLimit = opts.iterationLimit || 30;

  // if path starts at a val greater than the path tail (like on vertical violins),
  // we must flip the sign of the computed diff.
  var mul = path.getPointAtLength(0)[coord] > path.getPointAtLength(pathLength)[coord] ? -1 : 1;
  var i = 0;
  var b0 = 0;
  var b1 = pathLength;
  var mid;
  var pt;
  var diff;
  while (i < iterationLimit) {
    mid = (b0 + b1) / 2;
    pt = path.getPointAtLength(mid);
    diff = pt[coord] - val;
    if (Math.abs(diff) < tolerance) {
      return pt;
    } else {
      if (mul * diff > 0) {
        b1 = mid;
      } else {
        b0 = mid;
      }
      i++;
    }
  }
  return pt;
};

/***/ }),

/***/ 5536:
/***/ (function(module) {

"use strict";


// Simple helper functions
// none of these need any external deps
module.exports = function identity(d) {
  return d;
};

/***/ }),

/***/ 1396:
/***/ (function(module) {

"use strict";


module.exports = function incrementNumeric(x, delta) {
  if (!delta) return x;

  // Note 1:
  // 0.3 != 0.1 + 0.2 == 0.30000000000000004
  // but 0.3 == (10 * 0.1 + 10 * 0.2) / 10
  // Attempt to use integer steps to increment
  var scale = 1 / Math.abs(delta);
  var newX = scale > 1 ? (scale * x + scale * delta) / scale : x + delta;

  // Note 2:
  // now we may also consider rounding to cover few more edge cases
  // e.g. 0.3 * 3 = 0.8999999999999999
  var lenX1 = String(newX).length;
  if (lenX1 > 16) {
    var lenDt = String(delta).length;
    var lenX0 = String(x).length;
    if (lenX1 >= lenX0 + lenDt) {
      // likely a rounding error!
      var s = parseFloat(newX).toPrecision(12);
      if (s.indexOf('e+') === -1) newX = +s;
    }
  }
  return newX;
};

/***/ }),

/***/ 3400:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var utcFormat = (__webpack_require__(4336)/* .utcFormat */ .E9);
var d3Format = (__webpack_require__(7624)/* .format */ .E9);
var isNumeric = __webpack_require__(8248);
var numConstants = __webpack_require__(9032);
var MAX_SAFE = numConstants.FP_SAFE;
var MIN_SAFE = -MAX_SAFE;
var BADNUM = numConstants.BADNUM;
var lib = module.exports = {};
lib.adjustFormat = function adjustFormat(formatStr) {
  if (!formatStr || /^\d[.]\df/.test(formatStr) || /[.]\d%/.test(formatStr)) return formatStr;
  if (formatStr === '0.f') return '~f';
  if (/^\d%/.test(formatStr)) return '~%';
  if (/^\ds/.test(formatStr)) return '~s';

  // try adding tilde to the start of format in order to trim
  if (!/^[~,.0$]/.test(formatStr) && /[&fps]/.test(formatStr)) return '~' + formatStr;
  return formatStr;
};
var seenBadFormats = {};
lib.warnBadFormat = function (f) {
  var key = String(f);
  if (!seenBadFormats[key]) {
    seenBadFormats[key] = 1;
    lib.warn('encountered bad format: "' + key + '"');
  }
};
lib.noFormat = function (value) {
  return String(value);
};
lib.numberFormat = function (formatStr) {
  var fn;
  try {
    fn = d3Format(lib.adjustFormat(formatStr));
  } catch (e) {
    lib.warnBadFormat(formatStr);
    return lib.noFormat;
  }
  return fn;
};
lib.nestedProperty = __webpack_require__(2296);
lib.keyedContainer = __webpack_require__(7804);
lib.relativeAttr = __webpack_require__(3193);
lib.isPlainObject = __webpack_require__(3620);
lib.toLogRange = __webpack_require__(6896);
lib.relinkPrivateKeys = __webpack_require__(1528);
var arrayModule = __webpack_require__(8116);
lib.isArrayBuffer = arrayModule.isArrayBuffer;
lib.isTypedArray = arrayModule.isTypedArray;
lib.isArrayOrTypedArray = arrayModule.isArrayOrTypedArray;
lib.isArray1D = arrayModule.isArray1D;
lib.ensureArray = arrayModule.ensureArray;
lib.concat = arrayModule.concat;
lib.maxRowLength = arrayModule.maxRowLength;
lib.minRowLength = arrayModule.minRowLength;
var modModule = __webpack_require__(435);
lib.mod = modModule.mod;
lib.modHalf = modModule.modHalf;
var coerceModule = __webpack_require__(3064);
lib.valObjectMeta = coerceModule.valObjectMeta;
lib.coerce = coerceModule.coerce;
lib.coerce2 = coerceModule.coerce2;
lib.coerceFont = coerceModule.coerceFont;
lib.coercePattern = coerceModule.coercePattern;
lib.coerceHoverinfo = coerceModule.coerceHoverinfo;
lib.coerceSelectionMarkerOpacity = coerceModule.coerceSelectionMarkerOpacity;
lib.validate = coerceModule.validate;
var datesModule = __webpack_require__(7555);
lib.dateTime2ms = datesModule.dateTime2ms;
lib.isDateTime = datesModule.isDateTime;
lib.ms2DateTime = datesModule.ms2DateTime;
lib.ms2DateTimeLocal = datesModule.ms2DateTimeLocal;
lib.cleanDate = datesModule.cleanDate;
lib.isJSDate = datesModule.isJSDate;
lib.formatDate = datesModule.formatDate;
lib.incrementMonth = datesModule.incrementMonth;
lib.dateTick0 = datesModule.dateTick0;
lib.dfltRange = datesModule.dfltRange;
lib.findExactDates = datesModule.findExactDates;
lib.MIN_MS = datesModule.MIN_MS;
lib.MAX_MS = datesModule.MAX_MS;
var searchModule = __webpack_require__(4952);
lib.findBin = searchModule.findBin;
lib.sorterAsc = searchModule.sorterAsc;
lib.sorterDes = searchModule.sorterDes;
lib.distinctVals = searchModule.distinctVals;
lib.roundUp = searchModule.roundUp;
lib.sort = searchModule.sort;
lib.findIndexOfMin = searchModule.findIndexOfMin;
lib.sortObjectKeys = __webpack_require__(2996);
var statsModule = __webpack_require__(3084);
lib.aggNums = statsModule.aggNums;
lib.len = statsModule.len;
lib.mean = statsModule.mean;
lib.median = statsModule.median;
lib.midRange = statsModule.midRange;
lib.variance = statsModule.variance;
lib.stdev = statsModule.stdev;
lib.interp = statsModule.interp;
var matrixModule = __webpack_require__(2248);
lib.init2dArray = matrixModule.init2dArray;
lib.transposeRagged = matrixModule.transposeRagged;
lib.dot = matrixModule.dot;
lib.translationMatrix = matrixModule.translationMatrix;
lib.rotationMatrix = matrixModule.rotationMatrix;
lib.rotationXYMatrix = matrixModule.rotationXYMatrix;
lib.apply3DTransform = matrixModule.apply3DTransform;
lib.apply2DTransform = matrixModule.apply2DTransform;
lib.apply2DTransform2 = matrixModule.apply2DTransform2;
lib.convertCssMatrix = matrixModule.convertCssMatrix;
lib.inverseTransformMatrix = matrixModule.inverseTransformMatrix;
var anglesModule = __webpack_require__(1864);
lib.deg2rad = anglesModule.deg2rad;
lib.rad2deg = anglesModule.rad2deg;
lib.angleDelta = anglesModule.angleDelta;
lib.angleDist = anglesModule.angleDist;
lib.isFullCircle = anglesModule.isFullCircle;
lib.isAngleInsideSector = anglesModule.isAngleInsideSector;
lib.isPtInsideSector = anglesModule.isPtInsideSector;
lib.pathArc = anglesModule.pathArc;
lib.pathSector = anglesModule.pathSector;
lib.pathAnnulus = anglesModule.pathAnnulus;
var anchorUtils = __webpack_require__(8308);
lib.isLeftAnchor = anchorUtils.isLeftAnchor;
lib.isCenterAnchor = anchorUtils.isCenterAnchor;
lib.isRightAnchor = anchorUtils.isRightAnchor;
lib.isTopAnchor = anchorUtils.isTopAnchor;
lib.isMiddleAnchor = anchorUtils.isMiddleAnchor;
lib.isBottomAnchor = anchorUtils.isBottomAnchor;
var geom2dModule = __webpack_require__(2348);
lib.segmentsIntersect = geom2dModule.segmentsIntersect;
lib.segmentDistance = geom2dModule.segmentDistance;
lib.getTextLocation = geom2dModule.getTextLocation;
lib.clearLocationCache = geom2dModule.clearLocationCache;
lib.getVisibleSegment = geom2dModule.getVisibleSegment;
lib.findPointOnPath = geom2dModule.findPointOnPath;
var extendModule = __webpack_require__(2880);
lib.extendFlat = extendModule.extendFlat;
lib.extendDeep = extendModule.extendDeep;
lib.extendDeepAll = extendModule.extendDeepAll;
lib.extendDeepNoArrays = extendModule.extendDeepNoArrays;
var loggersModule = __webpack_require__(4248);
lib.log = loggersModule.log;
lib.warn = loggersModule.warn;
lib.error = loggersModule.error;
var regexModule = __webpack_require__(3756);
lib.counterRegex = regexModule.counter;
var throttleModule = __webpack_require__(1200);
lib.throttle = throttleModule.throttle;
lib.throttleDone = throttleModule.done;
lib.clearThrottle = throttleModule.clear;
var domModule = __webpack_require__(2200);
lib.getGraphDiv = domModule.getGraphDiv;
lib.isPlotDiv = domModule.isPlotDiv;
lib.removeElement = domModule.removeElement;
lib.addStyleRule = domModule.addStyleRule;
lib.addRelatedStyleRule = domModule.addRelatedStyleRule;
lib.deleteRelatedStyleRule = domModule.deleteRelatedStyleRule;
lib.getFullTransformMatrix = domModule.getFullTransformMatrix;
lib.getElementTransformMatrix = domModule.getElementTransformMatrix;
lib.getElementAndAncestors = domModule.getElementAndAncestors;
lib.equalDomRects = domModule.equalDomRects;
lib.clearResponsive = __webpack_require__(5352);
lib.preserveDrawingBuffer = __webpack_require__(4296);
lib.makeTraceGroups = __webpack_require__(988);
lib._ = __webpack_require__(8356);
lib.notifier = __webpack_require__(1792);
lib.filterUnique = __webpack_require__(8944);
lib.filterVisible = __webpack_require__(3880);
lib.pushUnique = __webpack_require__(2416);
lib.increment = __webpack_require__(1396);
lib.cleanNumber = __webpack_require__(4037);
lib.ensureNumber = function ensureNumber(v) {
  if (!isNumeric(v)) return BADNUM;
  v = Number(v);
  return v > MAX_SAFE || v < MIN_SAFE ? BADNUM : v;
};

/**
 * Is v a valid array index? Accepts numeric strings as well as numbers.
 *
 * @param {any} v: the value to test
 * @param {Optional[integer]} len: the array length we are indexing
 *
 * @return {bool}: v is a valid array index
 */
lib.isIndex = function (v, len) {
  if (len !== undefined && v >= len) return false;
  return isNumeric(v) && v >= 0 && v % 1 === 0;
};
lib.noop = __webpack_require__(6628);
lib.identity = __webpack_require__(5536);

/**
 * create an array of length 'cnt' filled with 'v' at all indices
 *
 * @param {any} v
 * @param {number} cnt
 * @return {array}
 */
lib.repeat = function (v, cnt) {
  var out = new Array(cnt);
  for (var i = 0; i < cnt; i++) {
    out[i] = v;
  }
  return out;
};

/**
 * swap x and y of the same attribute in container cont
 * specify attr with a ? in place of x/y
 * you can also swap other things than x/y by providing part1 and part2
 */
lib.swapAttrs = function (cont, attrList, part1, part2) {
  if (!part1) part1 = 'x';
  if (!part2) part2 = 'y';
  for (var i = 0; i < attrList.length; i++) {
    var attr = attrList[i];
    var xp = lib.nestedProperty(cont, attr.replace('?', part1));
    var yp = lib.nestedProperty(cont, attr.replace('?', part2));
    var temp = xp.get();
    xp.set(yp.get());
    yp.set(temp);
  }
};

/**
 * SVG painter's algo worked around with reinsertion
 */
lib.raiseToTop = function raiseToTop(elem) {
  elem.parentNode.appendChild(elem);
};

/**
 * cancel a possibly pending transition; returned selection may be used by caller
 */
lib.cancelTransition = function (selection) {
  return selection.transition().duration(0);
};

// constrain - restrict a number v to be between v0 and v1
lib.constrain = function (v, v0, v1) {
  if (v0 > v1) return Math.max(v1, Math.min(v0, v));
  return Math.max(v0, Math.min(v1, v));
};

/**
 * do two bounding boxes from getBoundingClientRect,
 * ie {left,right,top,bottom,width,height}, overlap?
 * takes optional padding pixels
 */
lib.bBoxIntersect = function (a, b, pad) {
  pad = pad || 0;
  return a.left <= b.right + pad && b.left <= a.right + pad && a.top <= b.bottom + pad && b.top <= a.bottom + pad;
};

/*
 * simpleMap: alternative to Array.map that only
 * passes on the element and up to 2 extra args you
 * provide (but not the array index or the whole array)
 *
 * array: the array to map it to
 * func: the function to apply
 * x1, x2: optional extra args
 */
lib.simpleMap = function (array, func, x1, x2, opts) {
  var len = array.length;
  var out = new Array(len);
  for (var i = 0; i < len; i++) out[i] = func(array[i], x1, x2, opts);
  return out;
};

/**
 * Random string generator
 *
 * @param {object} existing
 *     pass in strings to avoid as keys with truthy values
 * @param {int} bits
 *     bits of information in the output string, default 24
 * @param {int} base
 *     base of string representation, default 16. Should be a power of 2.
 */
lib.randstr = function randstr(existing, bits, base, _recursion) {
  if (!base) base = 16;
  if (bits === undefined) bits = 24;
  if (bits <= 0) return '0';
  var digits = Math.log(Math.pow(2, bits)) / Math.log(base);
  var res = '';
  var i, b, x;
  for (i = 2; digits === Infinity; i *= 2) {
    digits = Math.log(Math.pow(2, bits / i)) / Math.log(base) * i;
  }
  var rem = digits - Math.floor(digits);
  for (i = 0; i < Math.floor(digits); i++) {
    x = Math.floor(Math.random() * base).toString(base);
    res = x + res;
  }
  if (rem) {
    b = Math.pow(base, rem);
    x = Math.floor(Math.random() * b).toString(base);
    res = x + res;
  }
  var parsed = parseInt(res, base);
  if (existing && existing[res] || parsed !== Infinity && parsed >= Math.pow(2, bits)) {
    if (_recursion > 10) {
      lib.warn('randstr failed uniqueness');
      return res;
    }
    return randstr(existing, bits, base, (_recursion || 0) + 1);
  } else return res;
};
lib.OptionControl = function (opt, optname) {
  /*
   * An environment to contain all option setters and
   * getters that collectively modify opts.
   *
   * You can call up opts from any function in new object
   * as this.optname || this.opt
   *
   * See FitOpts for example of usage
   */
  if (!opt) opt = {};
  if (!optname) optname = 'opt';
  var self = {};
  self.optionList = [];
  self._newoption = function (optObj) {
    optObj[optname] = opt;
    self[optObj.name] = optObj;
    self.optionList.push(optObj);
  };
  self['_' + optname] = opt;
  return self;
};

/**
 * lib.smooth: smooth arrayIn by convolving with
 * a hann window with given full width at half max
 * bounce the ends in, so the output has the same length as the input
 */
lib.smooth = function (arrayIn, FWHM) {
  FWHM = Math.round(FWHM) || 0; // only makes sense for integers
  if (FWHM < 2) return arrayIn;
  var alen = arrayIn.length;
  var alen2 = 2 * alen;
  var wlen = 2 * FWHM - 1;
  var w = new Array(wlen);
  var arrayOut = new Array(alen);
  var i;
  var j;
  var k;
  var v;

  // first make the window array
  for (i = 0; i < wlen; i++) {
    w[i] = (1 - Math.cos(Math.PI * (i + 1) / FWHM)) / (2 * FWHM);
  }

  // now do the convolution
  for (i = 0; i < alen; i++) {
    v = 0;
    for (j = 0; j < wlen; j++) {
      k = i + j + 1 - FWHM;

      // multibounce
      if (k < -alen) k -= alen2 * Math.round(k / alen2);else if (k >= alen2) k -= alen2 * Math.floor(k / alen2);

      // single bounce
      if (k < 0) k = -1 - k;else if (k >= alen) k = alen2 - 1 - k;
      v += arrayIn[k] * w[j];
    }
    arrayOut[i] = v;
  }
  return arrayOut;
};

/**
 * syncOrAsync: run a sequence of functions synchronously
 * as long as its returns are not promises (ie have no .then)
 * includes one argument arg to send to all functions...
 * this is mainly just to prevent us having to make wrapper functions
 * when the only purpose of the wrapper is to reference gd
 * and a final step to be executed at the end
 * TODO: if there's an error and everything is sync,
 * this doesn't happen yet because we want to make sure
 * that it gets reported
 */
lib.syncOrAsync = function (sequence, arg, finalStep) {
  var ret, fni;
  function continueAsync() {
    return lib.syncOrAsync(sequence, arg, finalStep);
  }
  while (sequence.length) {
    fni = sequence.splice(0, 1)[0];
    ret = fni(arg);
    if (ret && ret.then) {
      return ret.then(continueAsync);
    }
  }
  return finalStep && finalStep(arg);
};

/**
 * Helper to strip trailing slash, from
 * http://stackoverflow.com/questions/6680825/return-string-without-trailing-slash
 */
lib.stripTrailingSlash = function (str) {
  if (str.substr(-1) === '/') return str.substr(0, str.length - 1);
  return str;
};
lib.noneOrAll = function (containerIn, containerOut, attrList) {
  /**
   * some attributes come together, so if you have one of them
   * in the input, you should copy the default values of the others
   * to the input as well.
   */
  if (!containerIn) return;
  var hasAny = false;
  var hasAll = true;
  var i;
  var val;
  for (i = 0; i < attrList.length; i++) {
    val = containerIn[attrList[i]];
    if (val !== undefined && val !== null) hasAny = true;else hasAll = false;
  }
  if (hasAny && !hasAll) {
    for (i = 0; i < attrList.length; i++) {
      containerIn[attrList[i]] = containerOut[attrList[i]];
    }
  }
};

/** merges calcdata field (given by cdAttr) with traceAttr values
 *
 * N.B. Loop over minimum of cd.length and traceAttr.length
 * i.e. it does not try to fill in beyond traceAttr.length-1
 *
 * @param {array} traceAttr : trace attribute
 * @param {object} cd : calcdata trace
 * @param {string} cdAttr : calcdata key
 */
lib.mergeArray = function (traceAttr, cd, cdAttr, fn) {
  var hasFn = typeof fn === 'function';
  if (lib.isArrayOrTypedArray(traceAttr)) {
    var imax = Math.min(traceAttr.length, cd.length);
    for (var i = 0; i < imax; i++) {
      var v = traceAttr[i];
      cd[i][cdAttr] = hasFn ? fn(v) : v;
    }
  }
};

// cast numbers to positive numbers, returns 0 if not greater than 0
lib.mergeArrayCastPositive = function (traceAttr, cd, cdAttr) {
  return lib.mergeArray(traceAttr, cd, cdAttr, function (v) {
    var w = +v;
    return !isFinite(w) ? 0 : w > 0 ? w : 0;
  });
};

/** fills calcdata field (given by cdAttr) with traceAttr values
 *  or function of traceAttr values (e.g. some fallback)
 *
 * N.B. Loops over all cd items.
 *
 * @param {array} traceAttr : trace attribute
 * @param {object} cd : calcdata trace
 * @param {string} cdAttr : calcdata key
 * @param {function} [fn] : optional function to apply to each array item
 */
lib.fillArray = function (traceAttr, cd, cdAttr, fn) {
  fn = fn || lib.identity;
  if (lib.isArrayOrTypedArray(traceAttr)) {
    for (var i = 0; i < cd.length; i++) {
      cd[i][cdAttr] = fn(traceAttr[i]);
    }
  }
};

/** Handler for trace-wide vs per-point options
 *
 * @param {object} trace : (full) trace object
 * @param {number} ptNumber : index of the point in question
 * @param {string} astr : attribute string
 * @param {function} [fn] : optional function to apply to each array item
 *
 * @return {any}
 */
lib.castOption = function (trace, ptNumber, astr, fn) {
  fn = fn || lib.identity;
  var val = lib.nestedProperty(trace, astr).get();
  if (lib.isArrayOrTypedArray(val)) {
    if (Array.isArray(ptNumber) && lib.isArrayOrTypedArray(val[ptNumber[0]])) {
      return fn(val[ptNumber[0]][ptNumber[1]]);
    } else {
      return fn(val[ptNumber]);
    }
  } else {
    return val;
  }
};

/** Extract option from calcdata item, correctly falling back to
 *  trace value if not found.
 *
 *  @param {object} calcPt : calcdata[i][j] item
 *  @param {object} trace : (full) trace object
 *  @param {string} calcKey : calcdata key
 *  @param {string} traceKey : aka trace attribute string
 *  @return {any}
 */
lib.extractOption = function (calcPt, trace, calcKey, traceKey) {
  if (calcKey in calcPt) return calcPt[calcKey];

  // fallback to trace value,
  //   must check if value isn't itself an array
  //   which means the trace attribute has a corresponding
  //   calcdata key, but its value is falsy
  var traceVal = lib.nestedProperty(trace, traceKey).get();
  if (!Array.isArray(traceVal)) return traceVal;
};
function makePtIndex2PtNumber(indexToPoints) {
  var ptIndex2ptNumber = {};
  for (var k in indexToPoints) {
    var pts = indexToPoints[k];
    for (var j = 0; j < pts.length; j++) {
      ptIndex2ptNumber[pts[j]] = +k;
    }
  }
  return ptIndex2ptNumber;
}

/** Tag selected calcdata items
 *
 * N.B. note that point 'index' corresponds to input data array index
 *  whereas 'number' is its post-transform version.
 *
 * @param {array} calcTrace
 * @param {object} trace
 *  - selectedpoints {array}
 *  - _indexToPoints {object}
 * @param {ptNumber2cdIndex} ptNumber2cdIndex (optional)
 *  optional map object for trace types that do not have 1-to-1 point number to
 *  calcdata item index correspondence (e.g. histogram)
 */
lib.tagSelected = function (calcTrace, trace, ptNumber2cdIndex) {
  var selectedpoints = trace.selectedpoints;
  var indexToPoints = trace._indexToPoints;
  var ptIndex2ptNumber;

  // make pt index-to-number map object, which takes care of transformed traces
  if (indexToPoints) {
    ptIndex2ptNumber = makePtIndex2PtNumber(indexToPoints);
  }
  function isCdIndexValid(v) {
    return v !== undefined && v < calcTrace.length;
  }
  for (var i = 0; i < selectedpoints.length; i++) {
    var ptIndex = selectedpoints[i];
    if (lib.isIndex(ptIndex) || lib.isArrayOrTypedArray(ptIndex) && lib.isIndex(ptIndex[0]) && lib.isIndex(ptIndex[1])) {
      var ptNumber = ptIndex2ptNumber ? ptIndex2ptNumber[ptIndex] : ptIndex;
      var cdIndex = ptNumber2cdIndex ? ptNumber2cdIndex[ptNumber] : ptNumber;
      if (isCdIndexValid(cdIndex)) {
        calcTrace[cdIndex].selected = 1;
      }
    }
  }
};
lib.selIndices2selPoints = function (trace) {
  var selectedpoints = trace.selectedpoints;
  var indexToPoints = trace._indexToPoints;
  if (indexToPoints) {
    var ptIndex2ptNumber = makePtIndex2PtNumber(indexToPoints);
    var out = [];
    for (var i = 0; i < selectedpoints.length; i++) {
      var ptIndex = selectedpoints[i];
      if (lib.isIndex(ptIndex)) {
        var ptNumber = ptIndex2ptNumber[ptIndex];
        if (lib.isIndex(ptNumber)) {
          out.push(ptNumber);
        }
      }
    }
    return out;
  } else {
    return selectedpoints;
  }
};

/** Returns target as set by 'target' transform attribute
 *
 * @param {object} trace : full trace object
 * @param {object} transformOpts : transform option object
 *  - target (string} :
 *      either an attribute string referencing an array in the trace object, or
 *      a set array.
 *
 * @return {array or false} : the target array (NOT a copy!!) or false if invalid
 */
lib.getTargetArray = function (trace, transformOpts) {
  var target = transformOpts.target;
  if (typeof target === 'string' && target) {
    var array = lib.nestedProperty(trace, target).get();
    return lib.isArrayOrTypedArray(array) ? array : false;
  } else if (lib.isArrayOrTypedArray(target)) {
    return target;
  }
  return false;
};

/**
 * modified version of jQuery's extend to strip out private objs and functions,
 * and cut arrays down to first <arraylen> or 1 elements
 * because extend-like algorithms are hella slow
 * obj2 is assumed to already be clean of these things (including no arrays)
 */
function minExtend(obj1, obj2, opt) {
  var objOut = {};
  if (typeof obj2 !== 'object') obj2 = {};
  var arrayLen = opt === 'pieLike' ? -1 : 3;
  var keys = Object.keys(obj1);
  var i, k, v;
  for (i = 0; i < keys.length; i++) {
    k = keys[i];
    v = obj1[k];
    if (k.charAt(0) === '_' || typeof v === 'function') continue;else if (k === 'module') objOut[k] = v;else if (Array.isArray(v)) {
      if (k === 'colorscale' || arrayLen === -1) {
        objOut[k] = v.slice();
      } else {
        objOut[k] = v.slice(0, arrayLen);
      }
    } else if (lib.isTypedArray(v)) {
      if (arrayLen === -1) {
        objOut[k] = v.subarray();
      } else {
        objOut[k] = v.subarray(0, arrayLen);
      }
    } else if (v && typeof v === 'object') objOut[k] = minExtend(obj1[k], obj2[k], opt);else objOut[k] = v;
  }
  keys = Object.keys(obj2);
  for (i = 0; i < keys.length; i++) {
    k = keys[i];
    v = obj2[k];
    if (typeof v !== 'object' || !(k in objOut) || typeof objOut[k] !== 'object') {
      objOut[k] = v;
    }
  }
  return objOut;
}
lib.minExtend = minExtend;
lib.titleCase = function (s) {
  return s.charAt(0).toUpperCase() + s.substr(1);
};
lib.containsAny = function (s, fragments) {
  for (var i = 0; i < fragments.length; i++) {
    if (s.indexOf(fragments[i]) !== -1) return true;
  }
  return false;
};
lib.isIE = function () {
  return typeof window.navigator.msSaveBlob !== 'undefined';
};
var IS_SAFARI_REGEX = /Version\/[\d\.]+.*Safari/;
lib.isSafari = function () {
  return IS_SAFARI_REGEX.test(window.navigator.userAgent);
};
var IS_IOS_REGEX = /iPad|iPhone|iPod/;
lib.isIOS = function () {
  return IS_IOS_REGEX.test(window.navigator.userAgent);
};
var FIREFOX_VERSION_REGEX = /Firefox\/(\d+)\.\d+/;
lib.getFirefoxVersion = function () {
  var match = FIREFOX_VERSION_REGEX.exec(window.navigator.userAgent);
  if (match && match.length === 2) {
    var versionInt = parseInt(match[1]);
    if (!isNaN(versionInt)) {
      return versionInt;
    }
  }
  return null;
};
lib.isD3Selection = function (obj) {
  return obj instanceof d3.selection;
};

/**
 * Append element to DOM only if not present.
 *
 * @param {d3 selection} parent : parent selection of the element in question
 * @param {string} nodeType : node type of element to append
 * @param {string} className (optional) : class name of element in question
 * @param {fn} enterFn (optional) : optional fn applied to entering elements only
 * @return {d3 selection} selection of new layer
 *
 * Previously, we were using the following pattern:
 *
 * ```
 * var sel = parent.selectAll('.' + className)
 *     .data([0]);
 *
 * sel.enter().append(nodeType)
 *     .classed(className, true);
 *
 * return sel;
 * ```
 *
 * in numerous places in our codebase to achieve the same behavior.
 *
 * The logic below performs much better, mostly as we are using
 * `.select` instead `.selectAll` that is `querySelector` instead of
 * `querySelectorAll`.
 *
 */
lib.ensureSingle = function (parent, nodeType, className, enterFn) {
  var sel = parent.select(nodeType + (className ? '.' + className : ''));
  if (sel.size()) return sel;
  var layer = parent.append(nodeType);
  if (className) layer.classed(className, true);
  if (enterFn) layer.call(enterFn);
  return layer;
};

/**
 * Same as Lib.ensureSingle, but using id as selector.
 * This version is mostly used for clipPath nodes.
 *
 * @param {d3 selection} parent : parent selection of the element in question
 * @param {string} nodeType : node type of element to append
 * @param {string} id : id of element in question
 * @param {fn} enterFn (optional) : optional fn applied to entering elements only
 * @return {d3 selection} selection of new layer
 */
lib.ensureSingleById = function (parent, nodeType, id, enterFn) {
  var sel = parent.select(nodeType + '#' + id);
  if (sel.size()) return sel;
  var layer = parent.append(nodeType).attr('id', id);
  if (enterFn) layer.call(enterFn);
  return layer;
};

/**
 * Converts a string path to an object.
 *
 * When given a string containing an array element, it will create a `null`
 * filled array of the given size.
 *
 * @example
 * lib.objectFromPath('nested.test[2].path', 'value');
 * // returns { nested: { test: [null, null, { path: 'value' }]}
 *
 * @param   {string}    path to nested value
 * @param   {*}         any value to be set
 *
 * @return {Object} the constructed object with a full nested path
 */
lib.objectFromPath = function (path, value) {
  var keys = path.split('.');
  var tmpObj;
  var obj = tmpObj = {};
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    var el = null;
    var parts = keys[i].match(/(.*)\[([0-9]+)\]/);
    if (parts) {
      key = parts[1];
      el = parts[2];
      tmpObj = tmpObj[key] = [];
      if (i === keys.length - 1) {
        tmpObj[el] = value;
      } else {
        tmpObj[el] = {};
      }
      tmpObj = tmpObj[el];
    } else {
      if (i === keys.length - 1) {
        tmpObj[key] = value;
      } else {
        tmpObj[key] = {};
      }
      tmpObj = tmpObj[key];
    }
  }
  return obj;
};

/**
 * Iterate through an object in-place, converting dotted properties to objects.
 *
 * Examples:
 *
 *   lib.expandObjectPaths({'nested.test.path': 'value'});
 *     => { nested: { test: {path: 'value'}}}
 *
 * It also handles array notation, e.g.:
 *
 *   lib.expandObjectPaths({'foo[1].bar': 'value'});
 *     => { foo: [null, {bar: value}] }
 *
 * It handles merges the results when two properties are specified in parallel:
 *
 *   lib.expandObjectPaths({'foo[1].bar': 10, 'foo[0].bar': 20});
 *     => { foo: [{bar: 10}, {bar: 20}] }
 *
 * It does NOT, however, merge multiple multiply-nested arrays::
 *
 *   lib.expandObjectPaths({'marker[1].range[1]': 5, 'marker[1].range[0]': 4})
 *     => { marker: [null, {range: 4}] }
 */

// Store this to avoid recompiling regex on *every* prop since this may happen many
// many times for animations. Could maybe be inside the function. Not sure about
// scoping vs. recompilation tradeoff, but at least it's not just inlining it into
// the inner loop.
var dottedPropertyRegex = /^([^\[\.]+)\.(.+)?/;
var indexedPropertyRegex = /^([^\.]+)\[([0-9]+)\](\.)?(.+)?/;
function notValid(prop) {
  // guard against polluting __proto__ and other internals getters and setters
  return prop.slice(0, 2) === '__';
}
lib.expandObjectPaths = function (data) {
  var match, key, prop, datum, idx, dest, trailingPath;
  if (typeof data === 'object' && !Array.isArray(data)) {
    for (key in data) {
      if (data.hasOwnProperty(key)) {
        if (match = key.match(dottedPropertyRegex)) {
          datum = data[key];
          prop = match[1];
          if (notValid(prop)) continue;
          delete data[key];
          data[prop] = lib.extendDeepNoArrays(data[prop] || {}, lib.objectFromPath(key, lib.expandObjectPaths(datum))[prop]);
        } else if (match = key.match(indexedPropertyRegex)) {
          datum = data[key];
          prop = match[1];
          if (notValid(prop)) continue;
          idx = parseInt(match[2]);
          delete data[key];
          data[prop] = data[prop] || [];
          if (match[3] === '.') {
            // This is the case where theere are subsequent properties into which
            // we must recurse, e.g. transforms[0].value
            trailingPath = match[4];
            dest = data[prop][idx] = data[prop][idx] || {};

            // NB: Extend deep no arrays prevents this from working on multiple
            // nested properties in the same object, e.g.
            //
            // {
            //   foo[0].bar[1].range
            //   foo[0].bar[0].range
            // }
            //
            // In this case, the extendDeepNoArrays will overwrite one array with
            // the other, so that both properties *will not* be present in the
            // result. Fixing this would require a more intelligent tracking
            // of changes and merging than extendDeepNoArrays currently accomplishes.
            lib.extendDeepNoArrays(dest, lib.objectFromPath(trailingPath, lib.expandObjectPaths(datum)));
          } else {
            // This is the case where this property is the end of the line,
            // e.g. xaxis.range[0]

            if (notValid(prop)) continue;
            data[prop][idx] = lib.expandObjectPaths(datum);
          }
        } else {
          if (notValid(key)) continue;
          data[key] = lib.expandObjectPaths(data[key]);
        }
      }
    }
  }
  return data;
};

/**
 * Converts value to string separated by the provided separators.
 *
 * @example
 * lib.numSeparate(2016, '.,');
 * // returns '2016'
 *
 * @example
 * lib.numSeparate(3000, '.,', true);
 * // returns '3,000'
 *
 * @example
 * lib.numSeparate(1234.56, '|,')
 * // returns '1,234|56'
 *
 * @param   {string|number} value       the value to be converted
 * @param   {string}    separators  string of decimal, then thousands separators
 * @param   {boolean}    separatethousands  boolean, 4-digit integers are separated if true
 *
 * @return  {string}    the value that has been separated
 */
lib.numSeparate = function (value, separators, separatethousands) {
  if (!separatethousands) separatethousands = false;
  if (typeof separators !== 'string' || separators.length === 0) {
    throw new Error('Separator string required for formatting!');
  }
  if (typeof value === 'number') {
    value = String(value);
  }
  var thousandsRe = /(\d+)(\d{3})/;
  var decimalSep = separators.charAt(0);
  var thouSep = separators.charAt(1);
  var x = value.split('.');
  var x1 = x[0];
  var x2 = x.length > 1 ? decimalSep + x[1] : '';

  // Years are ignored for thousands separators
  if (thouSep && (x.length > 1 || x1.length > 4 || separatethousands)) {
    while (thousandsRe.test(x1)) {
      x1 = x1.replace(thousandsRe, '$1' + thouSep + '$2');
    }
  }
  return x1 + x2;
};
lib.TEMPLATE_STRING_REGEX = /%{([^\s%{}:]*)([:|\|][^}]*)?}/g;
var SIMPLE_PROPERTY_REGEX = /^\w*$/;

/**
 * Substitute values from an object into a string
 *
 * Examples:
 *  Lib.templateString('name: %{trace}', {trace: 'asdf'}) --> 'name: asdf'
 *  Lib.templateString('name: %{trace[0].name}', {trace: [{name: 'asdf'}]}) --> 'name: asdf'
 *
 * @param {string}  input string containing %{...} template strings
 * @param {obj}     data object containing substitution values
 *
 * @return {string} templated string
 */
lib.templateString = function (string, obj) {
  // Not all that useful, but cache nestedProperty instantiation
  // just in case it speeds things up *slightly*:
  var getterCache = {};
  return string.replace(lib.TEMPLATE_STRING_REGEX, function (dummy, key) {
    var v;
    if (SIMPLE_PROPERTY_REGEX.test(key)) {
      v = obj[key];
    } else {
      getterCache[key] = getterCache[key] || lib.nestedProperty(obj, key).get;
      v = getterCache[key]();
    }
    return lib.isValidTextValue(v) ? v : '';
  });
};
var hovertemplateWarnings = {
  max: 10,
  count: 0,
  name: 'hovertemplate'
};
lib.hovertemplateString = function () {
  return templateFormatString.apply(hovertemplateWarnings, arguments);
};
var texttemplateWarnings = {
  max: 10,
  count: 0,
  name: 'texttemplate'
};
lib.texttemplateString = function () {
  return templateFormatString.apply(texttemplateWarnings, arguments);
};

// Regex for parsing multiplication and division operations applied to a template key
// Used for shape.label.texttemplate
// Matches a key name (non-whitespace characters), followed by a * or / character, followed by a number
// For example, the following strings are matched: `x0*2`, `slope/1.60934`, `y1*2.54`
var MULT_DIV_REGEX = /^(\S+)([\*\/])(-?\d+(\.\d+)?)$/;
function multDivParser(inputStr) {
  var match = inputStr.match(MULT_DIV_REGEX);
  if (match) return {
    key: match[1],
    op: match[2],
    number: Number(match[3])
  };
  return {
    key: inputStr,
    op: null,
    number: null
  };
}
var texttemplateWarningsForShapes = {
  max: 10,
  count: 0,
  name: 'texttemplate',
  parseMultDiv: true
};
lib.texttemplateStringForShapes = function () {
  return templateFormatString.apply(texttemplateWarningsForShapes, arguments);
};
var TEMPLATE_STRING_FORMAT_SEPARATOR = /^[:|\|]/;
/**
 * Substitute values from an object into a string and optionally formats them using d3-format,
 * or fallback to associated labels.
 *
 * Examples:
 *  Lib.hovertemplateString('name: %{trace}', {trace: 'asdf'}) --> 'name: asdf'
 *  Lib.hovertemplateString('name: %{trace[0].name}', {trace: [{name: 'asdf'}]}) --> 'name: asdf'
 *  Lib.hovertemplateString('price: %{y:$.2f}', {y: 1}) --> 'price: $1.00'
 *
 * @param {string}  input string containing %{...:...} template strings
 * @param {obj}     data object containing fallback text when no formatting is specified, ex.: {yLabel: 'formattedYValue'}
 * @param {obj}     d3 locale
 * @param {obj}     data objects containing substitution values
 *
 * @return {string} templated string
 */
function templateFormatString(string, labels, d3locale) {
  var opts = this;
  var args = arguments;
  if (!labels) labels = {};
  // Not all that useful, but cache nestedProperty instantiation
  // just in case it speeds things up *slightly*:
  var getterCache = {};
  return string.replace(lib.TEMPLATE_STRING_REGEX, function (match, rawKey, format) {
    var isOther = rawKey === 'xother' || rawKey === 'yother';
    var isSpaceOther = rawKey === '_xother' || rawKey === '_yother';
    var isSpaceOtherSpace = rawKey === '_xother_' || rawKey === '_yother_';
    var isOtherSpace = rawKey === 'xother_' || rawKey === 'yother_';
    var hasOther = isOther || isSpaceOther || isOtherSpace || isSpaceOtherSpace;
    var key = rawKey;
    if (isSpaceOther || isSpaceOtherSpace) key = key.substring(1);
    if (isOtherSpace || isSpaceOtherSpace) key = key.substring(0, key.length - 1);

    // Shape labels support * and / operators in template string
    // Parse these if the parseMultDiv param is set to true
    var parsedOp = null;
    var parsedNumber = null;
    if (opts.parseMultDiv) {
      var _match = multDivParser(key);
      key = _match.key;
      parsedOp = _match.op;
      parsedNumber = _match.number;
    }
    var value;
    if (hasOther) {
      value = labels[key];
      if (value === undefined) return '';
    } else {
      var obj, i;
      for (i = 3; i < args.length; i++) {
        obj = args[i];
        if (!obj) continue;
        if (obj.hasOwnProperty(key)) {
          value = obj[key];
          break;
        }
        if (!SIMPLE_PROPERTY_REGEX.test(key)) {
          value = lib.nestedProperty(obj, key).get();
          value = getterCache[key] || lib.nestedProperty(obj, key).get();
          if (value) getterCache[key] = value;
        }
        if (value !== undefined) break;
      }
    }

    // Apply mult/div operation (if applicable)
    if (value !== undefined) {
      if (parsedOp === '*') value *= parsedNumber;
      if (parsedOp === '/') value /= parsedNumber;
    }
    if (value === undefined && opts) {
      if (opts.count < opts.max) {
        lib.warn('Variable \'' + key + '\' in ' + opts.name + ' could not be found!');
        value = match;
      }
      if (opts.count === opts.max) {
        lib.warn('Too many ' + opts.name + ' warnings - additional warnings will be suppressed');
      }
      opts.count++;
      return match;
    }
    if (format) {
      var fmt;
      if (format[0] === ':') {
        fmt = d3locale ? d3locale.numberFormat : lib.numberFormat;
        if (value !== '') {
          // e.g. skip missing data on heatmap
          value = fmt(format.replace(TEMPLATE_STRING_FORMAT_SEPARATOR, ''))(value);
        }
      }
      if (format[0] === '|') {
        fmt = d3locale ? d3locale.timeFormat : utcFormat;
        var ms = lib.dateTime2ms(value);
        value = lib.formatDate(ms, format.replace(TEMPLATE_STRING_FORMAT_SEPARATOR, ''), false, fmt);
      }
    } else {
      var keyLabel = key + 'Label';
      if (labels.hasOwnProperty(keyLabel)) value = labels[keyLabel];
    }
    if (hasOther) {
      value = '(' + value + ')';
      if (isSpaceOther || isSpaceOtherSpace) value = ' ' + value;
      if (isOtherSpace || isSpaceOtherSpace) value = value + ' ';
    }
    return value;
  });
}

/*
 * alphanumeric string sort, tailored for subplot IDs like scene2, scene10, x10y13 etc
 */
var char0 = 48;
var char9 = 57;
lib.subplotSort = function (a, b) {
  var l = Math.min(a.length, b.length) + 1;
  var numA = 0;
  var numB = 0;
  for (var i = 0; i < l; i++) {
    var charA = a.charCodeAt(i) || 0;
    var charB = b.charCodeAt(i) || 0;
    var isNumA = charA >= char0 && charA <= char9;
    var isNumB = charB >= char0 && charB <= char9;
    if (isNumA) numA = 10 * numA + charA - char0;
    if (isNumB) numB = 10 * numB + charB - char0;
    if (!isNumA || !isNumB) {
      if (numA !== numB) return numA - numB;
      if (charA !== charB) return charA - charB;
    }
  }
  return numB - numA;
};

// repeatable pseudorandom generator
var randSeed = 2000000000;
lib.seedPseudoRandom = function () {
  randSeed = 2000000000;
};
lib.pseudoRandom = function () {
  var lastVal = randSeed;
  randSeed = (69069 * randSeed + 1) % 4294967296;
  // don't let consecutive vals be too close together
  // gets away from really trying to be random, in favor of better local uniformity
  if (Math.abs(randSeed - lastVal) < 429496729) return lib.pseudoRandom();
  return randSeed / 4294967296;
};

/** Fill hover 'pointData' container with 'correct' hover text value
 *
 * - If trace hoverinfo contains a 'text' flag and hovertext is not set,
 *   the text elements will be seen in the hover labels.
 *
 * - If trace hoverinfo contains a 'text' flag and hovertext is set,
 *   hovertext takes precedence over text
 *   i.e. the hoverinfo elements will be seen in the hover labels
 *
 *  @param {object} calcPt
 *  @param {object} trace
 *  @param {object || array} contOut (mutated here)
 */
lib.fillText = function (calcPt, trace, contOut) {
  var fill = Array.isArray(contOut) ? function (v) {
    contOut.push(v);
  } : function (v) {
    contOut.text = v;
  };
  var htx = lib.extractOption(calcPt, trace, 'htx', 'hovertext');
  if (lib.isValidTextValue(htx)) return fill(htx);
  var tx = lib.extractOption(calcPt, trace, 'tx', 'text');
  if (lib.isValidTextValue(tx)) return fill(tx);
};

// accept all truthy values and 0 (which gets cast to '0' in the hover labels)
lib.isValidTextValue = function (v) {
  return v || v === 0;
};

/**
 * @param {number} ratio
 * @param {number} n (number of decimal places)
 */
lib.formatPercent = function (ratio, n) {
  n = n || 0;
  var str = (Math.round(100 * ratio * Math.pow(10, n)) * Math.pow(0.1, n)).toFixed(n) + '%';
  for (var i = 0; i < n; i++) {
    if (str.indexOf('.') !== -1) {
      str = str.replace('0%', '%');
      str = str.replace('.%', '%');
    }
  }
  return str;
};
lib.isHidden = function (gd) {
  var display = window.getComputedStyle(gd).display;
  return !display || display === 'none';
};
lib.strTranslate = function (x, y) {
  return x || y ? 'translate(' + x + ',' + y + ')' : '';
};
lib.strRotate = function (a) {
  return a ? 'rotate(' + a + ')' : '';
};
lib.strScale = function (s) {
  return s !== 1 ? 'scale(' + s + ')' : '';
};

/** Return transform text for bar bar-like rectangles and pie-like slices
 *  @param {object} transform
 *  - targetX: desired position on the x-axis
 *  - targetY: desired position on the y-axis
 *  - textX: text middle position on the x-axis
 *  - textY: text middle position on the y-axis
 *  - anchorX: (optional) text anchor position on the x-axis (computed from textX), zero for middle anchor
 *  - anchorY: (optional) text anchor position on the y-axis (computed from textY), zero for middle anchor
 *  - scale: (optional) scale applied after translate
 *  - rotate: (optional) rotation applied after scale
 *  - noCenter: when defined no extra arguments needed in rotation
 */
lib.getTextTransform = function (transform) {
  var noCenter = transform.noCenter;
  var textX = transform.textX;
  var textY = transform.textY;
  var targetX = transform.targetX;
  var targetY = transform.targetY;
  var anchorX = transform.anchorX || 0;
  var anchorY = transform.anchorY || 0;
  var rotate = transform.rotate;
  var scale = transform.scale;
  if (!scale) scale = 0;else if (scale > 1) scale = 1;
  return lib.strTranslate(targetX - scale * (textX + anchorX), targetY - scale * (textY + anchorY)) + lib.strScale(scale) + (rotate ? 'rotate(' + rotate + (noCenter ? '' : ' ' + textX + ' ' + textY) + ')' : '');
};
lib.setTransormAndDisplay = function (s, transform) {
  s.attr('transform', lib.getTextTransform(transform));
  s.style('display', transform.scale ? null : 'none');
};
lib.ensureUniformFontSize = function (gd, baseFont) {
  var out = lib.extendFlat({}, baseFont);
  out.size = Math.max(baseFont.size, gd._fullLayout.uniformtext.minsize || 0);
  return out;
};

/**
 * provide a human-readable list e.g. "A, B, C and D" with an ending separator
 *
 * @param {array} arr : the array to join
 * @param {string} mainSeparator : main separator
 * @param {string} lastSeparator : last separator
 *
 * @return {string} : joined list
 */
lib.join2 = function (arr, mainSeparator, lastSeparator) {
  var len = arr.length;
  if (len > 1) {
    return arr.slice(0, -1).join(mainSeparator) + lastSeparator + arr[len - 1];
  }
  return arr.join(mainSeparator);
};
lib.bigFont = function (size) {
  return Math.round(1.2 * size);
};
var firefoxVersion = lib.getFirefoxVersion();
// see https://bugzilla.mozilla.org/show_bug.cgi?id=1684973
var isProblematicFirefox = firefoxVersion !== null && firefoxVersion < 86;

/**
 * Return the mouse position from the last event registered by D3.
 * @returns An array with two numbers, representing the x and y coordinates of the mouse pointer
 *   at the event relative to the targeted node.
 */
lib.getPositionFromD3Event = function () {
  if (isProblematicFirefox) {
    // layerX and layerY are non-standard, so we only fallback to them when we have to:
    return [d3.event.layerX, d3.event.layerY];
  } else {
    return [d3.event.offsetX, d3.event.offsetY];
  }
};

/***/ }),

/***/ 3620:
/***/ (function(module) {

"use strict";


// more info: http://stackoverflow.com/questions/18531624/isplainobject-thing
module.exports = function isPlainObject(obj) {
  // We need to be a little less strict in the `imagetest` container because
  // of how async image requests are handled.
  //
  // N.B. isPlainObject(new Constructor()) will return true in `imagetest`
  if (window && window.process && window.process.versions) {
    return Object.prototype.toString.call(obj) === '[object Object]';
  }
  return Object.prototype.toString.call(obj) === '[object Object]' && Object.getPrototypeOf(obj).hasOwnProperty('hasOwnProperty');
};

/***/ }),

/***/ 7804:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var nestedProperty = __webpack_require__(2296);
var SIMPLE_PROPERTY_REGEX = /^\w*$/;

// bitmask for deciding what's updated. Sometimes the name needs to be updated,
// sometimes the value needs to be updated, and sometimes both do. This is just
// a simple way to track what's updated such that it's a simple OR operation to
// assimilate new updates.
//
// The only exception is the UNSET bit that tracks when we need to explicitly
// unset and remove the property. This concrn arises because of the special
// way in which nestedProperty handles null/undefined. When you specify `null`,
// it prunes any unused items in the tree. I ran into some issues with it getting
// null vs undefined confused, so UNSET is just a bit that forces the property
// update to send `null`, removing the property explicitly rather than setting
// it to undefined.
var NONE = 0;
var NAME = 1;
var VALUE = 2;
var BOTH = 3;
var UNSET = 4;
module.exports = function keyedContainer(baseObj, path, keyName, valueName) {
  keyName = keyName || 'name';
  valueName = valueName || 'value';
  var i, arr, baseProp;
  var changeTypes = {};
  if (path && path.length) {
    baseProp = nestedProperty(baseObj, path);
    arr = baseProp.get();
  } else {
    arr = baseObj;
  }
  path = path || '';

  // Construct an index:
  var indexLookup = {};
  if (arr) {
    for (i = 0; i < arr.length; i++) {
      indexLookup[arr[i][keyName]] = i;
    }
  }
  var isSimpleValueProp = SIMPLE_PROPERTY_REGEX.test(valueName);
  var obj = {
    set: function (name, value) {
      var changeType = value === null ? UNSET : NONE;

      // create the base array if necessary
      if (!arr) {
        if (!baseProp || changeType === UNSET) return;
        arr = [];
        baseProp.set(arr);
      }
      var idx = indexLookup[name];
      if (idx === undefined) {
        if (changeType === UNSET) return;
        changeType = changeType | BOTH;
        idx = arr.length;
        indexLookup[name] = idx;
      } else if (value !== (isSimpleValueProp ? arr[idx][valueName] : nestedProperty(arr[idx], valueName).get())) {
        changeType = changeType | VALUE;
      }
      var newValue = arr[idx] = arr[idx] || {};
      newValue[keyName] = name;
      if (isSimpleValueProp) {
        newValue[valueName] = value;
      } else {
        nestedProperty(newValue, valueName).set(value);
      }

      // If it's not an unset, force that bit to be unset. This is all related to the fact
      // that undefined and null are a bit specially implemented in nestedProperties.
      if (value !== null) {
        changeType = changeType & ~UNSET;
      }
      changeTypes[idx] = changeTypes[idx] | changeType;
      return obj;
    },
    get: function (name) {
      if (!arr) return;
      var idx = indexLookup[name];
      if (idx === undefined) {
        return undefined;
      } else if (isSimpleValueProp) {
        return arr[idx][valueName];
      } else {
        return nestedProperty(arr[idx], valueName).get();
      }
    },
    rename: function (name, newName) {
      var idx = indexLookup[name];
      if (idx === undefined) return obj;
      changeTypes[idx] = changeTypes[idx] | NAME;
      indexLookup[newName] = idx;
      delete indexLookup[name];
      arr[idx][keyName] = newName;
      return obj;
    },
    remove: function (name) {
      var idx = indexLookup[name];
      if (idx === undefined) return obj;
      var object = arr[idx];
      if (Object.keys(object).length > 2) {
        // This object contains more than just the key/value, so unset
        // the value without modifying the entry otherwise:
        changeTypes[idx] = changeTypes[idx] | VALUE;
        return obj.set(name, null);
      }
      if (isSimpleValueProp) {
        for (i = idx; i < arr.length; i++) {
          changeTypes[i] = changeTypes[i] | BOTH;
        }
        for (i = idx; i < arr.length; i++) {
          indexLookup[arr[i][keyName]]--;
        }
        arr.splice(idx, 1);
        delete indexLookup[name];
      } else {
        // Perform this update *strictly* so we can check whether the result's
        // been pruned. If so, it's a removal. If not, it's a value unset only.
        nestedProperty(object, valueName).set(null);

        // Now check if the top level nested property has any keys left. If so,
        // the object still has values so we only want to unset the key. If not,
        // the entire object can be removed since there's no other data.
        // var topLevelKeys = Object.keys(object[valueName.split('.')[0]] || []);

        changeTypes[idx] = changeTypes[idx] | VALUE | UNSET;
      }
      return obj;
    },
    constructUpdate: function () {
      var astr, idx;
      var update = {};
      var changed = Object.keys(changeTypes);
      for (var i = 0; i < changed.length; i++) {
        idx = changed[i];
        astr = path + '[' + idx + ']';
        if (arr[idx]) {
          if (changeTypes[idx] & NAME) {
            update[astr + '.' + keyName] = arr[idx][keyName];
          }
          if (changeTypes[idx] & VALUE) {
            if (isSimpleValueProp) {
              update[astr + '.' + valueName] = changeTypes[idx] & UNSET ? null : arr[idx][valueName];
            } else {
              update[astr + '.' + valueName] = changeTypes[idx] & UNSET ? null : nestedProperty(arr[idx], valueName).get();
            }
          }
        } else {
          update[astr] = null;
        }
      }
      return update;
    }
  };
  return obj;
};

/***/ }),

/***/ 8356:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Registry = __webpack_require__(4040);

/**
 * localize: translate a string for the current locale
 *
 * @param {object} gd: the graphDiv for context
 *  gd._context.locale determines the language (& optional region/country)
 *  the dictionary for each locale may either be supplied in
 *  gd._context.locales or globally via Plotly.register
 * @param {string} s: the string to translate
 */
module.exports = function localize(gd, s) {
  var locale = gd._context.locale;

  /*
   * Priority of lookup:
   *     contextDicts[locale],
   *     registeredDicts[locale],
   *     contextDicts[baseLocale], (if baseLocale is distinct)
   *     registeredDicts[baseLocale]
   * Return the first translation we find.
   * This way if you have a regionalization you are allowed to specify
   * only what's different from the base locale, everything else will
   * fall back on the base.
   */
  for (var i = 0; i < 2; i++) {
    var locales = gd._context.locales;
    for (var j = 0; j < 2; j++) {
      var dict = (locales[locale] || {}).dictionary;
      if (dict) {
        var out = dict[s];
        if (out) return out;
      }
      locales = Registry.localeRegistry;
    }
    var baseLocale = locale.split('-')[0];
    if (baseLocale === locale) break;
    locale = baseLocale;
  }
  return s;
};

/***/ }),

/***/ 4248:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


/* eslint-disable no-console */
var dfltConfig = (__webpack_require__(556).dfltConfig);
var notifier = __webpack_require__(1792);
var loggers = module.exports = {};

/**
 * ------------------------------------------
 * debugging tools
 * ------------------------------------------
 */

loggers.log = function () {
  var i;
  if (dfltConfig.logging > 1) {
    var messages = ['LOG:'];
    for (i = 0; i < arguments.length; i++) {
      messages.push(arguments[i]);
    }
    console.trace.apply(console, messages);
  }
  if (dfltConfig.notifyOnLogging > 1) {
    var lines = [];
    for (i = 0; i < arguments.length; i++) {
      lines.push(arguments[i]);
    }
    notifier(lines.join('<br>'), 'long');
  }
};
loggers.warn = function () {
  var i;
  if (dfltConfig.logging > 0) {
    var messages = ['WARN:'];
    for (i = 0; i < arguments.length; i++) {
      messages.push(arguments[i]);
    }
    console.trace.apply(console, messages);
  }
  if (dfltConfig.notifyOnLogging > 0) {
    var lines = [];
    for (i = 0; i < arguments.length; i++) {
      lines.push(arguments[i]);
    }
    notifier(lines.join('<br>'), 'stick');
  }
};
loggers.error = function () {
  var i;
  if (dfltConfig.logging > 0) {
    var messages = ['ERROR:'];
    for (i = 0; i < arguments.length; i++) {
      messages.push(arguments[i]);
    }
    console.error.apply(console, messages);
  }
  if (dfltConfig.notifyOnLogging > 0) {
    var lines = [];
    for (i = 0; i < arguments.length; i++) {
      lines.push(arguments[i]);
    }
    notifier(lines.join('<br>'), 'stick');
  }
};

/***/ }),

/***/ 988:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);

/**
 * General helper to manage trace groups based on calcdata
 *
 * @param {d3.selection} traceLayer: a selection containing a single group
 *     to draw these traces into
 * @param {array} cdModule: array of calcdata items for this
 *     module and subplot combination. Assumes the calcdata item for each
 *     trace is an array with the fullData trace attached to the first item.
 * @param {string} cls: the class attribute to give each trace group
 *     so you can give multiple classes separated by spaces
 */
module.exports = function makeTraceGroups(traceLayer, cdModule, cls) {
  var traces = traceLayer.selectAll('g.' + cls.replace(/\s/g, '.')).data(cdModule, function (cd) {
    return cd[0].trace.uid;
  });
  traces.exit().remove();
  traces.enter().append('g').attr('class', cls);
  traces.order();

  // stash ref node to trace group in calcdata,
  // useful for (fast) styleOnSelect
  var k = traceLayer.classed('rangeplot') ? 'nodeRangePlot3' : 'node3';
  traces.each(function (cd) {
    cd[0][k] = d3.select(this);
  });
  return traces;
};

/***/ }),

/***/ 2248:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var mat4X4 = __webpack_require__(6524);
exports.init2dArray = function (rowLength, colLength) {
  var array = new Array(rowLength);
  for (var i = 0; i < rowLength; i++) array[i] = new Array(colLength);
  return array;
};

/**
 * transpose a (possibly ragged) 2d array z. inspired by
 * http://stackoverflow.com/questions/17428587/
 * transposing-a-2d-array-in-javascript
 */
exports.transposeRagged = function (z) {
  var maxlen = 0;
  var zlen = z.length;
  var i, j;
  // Maximum row length:
  for (i = 0; i < zlen; i++) maxlen = Math.max(maxlen, z[i].length);
  var t = new Array(maxlen);
  for (i = 0; i < maxlen; i++) {
    t[i] = new Array(zlen);
    for (j = 0; j < zlen; j++) t[i][j] = z[j][i];
  }
  return t;
};

// our own dot function so that we don't need to include numeric
exports.dot = function (x, y) {
  if (!(x.length && y.length) || x.length !== y.length) return null;
  var len = x.length;
  var out;
  var i;
  if (x[0].length) {
    // mat-vec or mat-mat
    out = new Array(len);
    for (i = 0; i < len; i++) out[i] = exports.dot(x[i], y);
  } else if (y[0].length) {
    // vec-mat
    var yTranspose = exports.transposeRagged(y);
    out = new Array(yTranspose.length);
    for (i = 0; i < yTranspose.length; i++) out[i] = exports.dot(x, yTranspose[i]);
  } else {
    // vec-vec
    out = 0;
    for (i = 0; i < len; i++) out += x[i] * y[i];
  }
  return out;
};

// translate by (x,y)
exports.translationMatrix = function (x, y) {
  return [[1, 0, x], [0, 1, y], [0, 0, 1]];
};

// rotate by alpha around (0,0)
exports.rotationMatrix = function (alpha) {
  var a = alpha * Math.PI / 180;
  return [[Math.cos(a), -Math.sin(a), 0], [Math.sin(a), Math.cos(a), 0], [0, 0, 1]];
};

// rotate by alpha around (x,y)
exports.rotationXYMatrix = function (a, x, y) {
  return exports.dot(exports.dot(exports.translationMatrix(x, y), exports.rotationMatrix(a)), exports.translationMatrix(-x, -y));
};

// applies a 3D transformation matrix to either x, y and z params
// Note: z is optional
exports.apply3DTransform = function (transform) {
  return function () {
    var args = arguments;
    var xyz = arguments.length === 1 ? args[0] : [args[0], args[1], args[2] || 0];
    return exports.dot(transform, [xyz[0], xyz[1], xyz[2], 1]).slice(0, 3);
  };
};

// applies a 2D transformation matrix to either x and y params or an [x,y] array
exports.apply2DTransform = function (transform) {
  return function () {
    var args = arguments;
    if (args.length === 3) {
      args = args[0];
    } // from map
    var xy = arguments.length === 1 ? args[0] : [args[0], args[1]];
    return exports.dot(transform, [xy[0], xy[1], 1]).slice(0, 2);
  };
};

// applies a 2D transformation matrix to an [x1,y1,x2,y2] array (to transform a segment)
exports.apply2DTransform2 = function (transform) {
  var at = exports.apply2DTransform(transform);
  return function (xys) {
    return at(xys.slice(0, 2)).concat(at(xys.slice(2, 4)));
  };
};
exports.convertCssMatrix = function (m) {
  if (m) {
    var len = m.length;
    if (len === 16) return m;
    if (len === 6) {
      // converts a 2x3 css transform matrix to a 4x4 matrix see https://developer.mozilla.org/en-US/docs/Web/CSS/transform-function/matrix
      return [m[0], m[1], 0, 0, m[2], m[3], 0, 0, 0, 0, 1, 0, m[4], m[5], 0, 1];
    }
  }
  return [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
};

// find the inverse for a 4x4 affine transform matrix
exports.inverseTransformMatrix = function (m) {
  var out = [];
  mat4X4.invert(out, m);
  return [[out[0], out[1], out[2], out[3]], [out[4], out[5], out[6], out[7]], [out[8], out[9], out[10], out[11]], [out[12], out[13], out[14], out[15]]];
};

/***/ }),

/***/ 435:
/***/ (function(module) {

"use strict";


/**
 * sanitized modulus function that always returns in the range [0, d)
 * rather than (-d, 0] if v is negative
 */
function mod(v, d) {
  var out = v % d;
  return out < 0 ? out + d : out;
}

/**
 * sanitized modulus function that always returns in the range [-d/2, d/2]
 * rather than (-d, 0] if v is negative
 */
function modHalf(v, d) {
  return Math.abs(v) > d / 2 ? v - Math.round(v / d) * d : v;
}
module.exports = {
  mod: mod,
  modHalf: modHalf
};

/***/ }),

/***/ 2296:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isNumeric = __webpack_require__(8248);
var isArrayOrTypedArray = (__webpack_require__(8116).isArrayOrTypedArray);

/**
 * convert a string s (such as 'xaxis.range[0]')
 * representing a property of nested object into set and get methods
 * also return the string and object so we don't have to keep track of them
 * allows [-1] for an array index, to set a property inside all elements
 * of an array
 * eg if obj = {arr: [{a: 1}, {a: 2}]}
 * you can do p = nestedProperty(obj, 'arr[-1].a')
 * but you cannot set the array itself this way, to do that
 * just set the whole array.
 * eg if obj = {arr: [1, 2, 3]}
 * you can't do nestedProperty(obj, 'arr[-1]').set(5)
 * but you can do nestedProperty(obj, 'arr').set([5, 5, 5])
 */
module.exports = function nestedProperty(container, propStr) {
  if (isNumeric(propStr)) propStr = String(propStr);else if (typeof propStr !== 'string' || propStr.substr(propStr.length - 4) === '[-1]') {
    throw 'bad property string';
  }
  var propParts = propStr.split('.');
  var indexed;
  var indices;
  var i, j;
  for (j = 0; j < propParts.length; j++) {
    // guard against polluting __proto__ and other internals
    if (String(propParts[j]).slice(0, 2) === '__') {
      throw 'bad property string';
    }
  }

  // check for parts of the nesting hierarchy that are numbers (ie array elements)
  j = 0;
  while (j < propParts.length) {
    // look for non-bracket chars, then any number of [##] blocks
    indexed = String(propParts[j]).match(/^([^\[\]]*)((\[\-?[0-9]*\])+)$/);
    if (indexed) {
      if (indexed[1]) propParts[j] = indexed[1];
      // allow propStr to start with bracketed array indices
      else if (j === 0) propParts.splice(0, 1);else throw 'bad property string';
      indices = indexed[2].substr(1, indexed[2].length - 2).split('][');
      for (i = 0; i < indices.length; i++) {
        j++;
        propParts.splice(j, 0, Number(indices[i]));
      }
    }
    j++;
  }
  if (typeof container !== 'object') {
    return badContainer(container, propStr, propParts);
  }
  return {
    set: npSet(container, propParts, propStr),
    get: npGet(container, propParts),
    astr: propStr,
    parts: propParts,
    obj: container
  };
};
function npGet(cont, parts) {
  return function () {
    var curCont = cont;
    var curPart;
    var allSame;
    var out;
    var i;
    var j;
    for (i = 0; i < parts.length - 1; i++) {
      curPart = parts[i];
      if (curPart === -1) {
        allSame = true;
        out = [];
        for (j = 0; j < curCont.length; j++) {
          out[j] = npGet(curCont[j], parts.slice(i + 1))();
          if (out[j] !== out[0]) allSame = false;
        }
        return allSame ? out[0] : out;
      }
      if (typeof curPart === 'number' && !isArrayOrTypedArray(curCont)) {
        return undefined;
      }
      curCont = curCont[curPart];
      if (typeof curCont !== 'object' || curCont === null) {
        return undefined;
      }
    }

    // only hit this if parts.length === 1
    if (typeof curCont !== 'object' || curCont === null) return undefined;
    out = curCont[parts[i]];
    if (out === null) return undefined;
    return out;
  };
}

/*
 * Can this value be deleted? We can delete `undefined`, and `null` except INSIDE an
 * *args* array.
 *
 * Previously we also deleted some `{}` and `[]`, in order to try and make set/unset
 * a net noop; but this causes far more complication than it's worth, and still had
 * lots of exceptions. See https://github.com/plotly/plotly.js/issues/1410
 *
 * *args* arrays get passed directly to API methods and we should respect null if
 * the user put it there, but otherwise null is deleted as we use it as code
 * in restyle/relayout/update for "delete this value" whereas undefined means
 * "ignore this edit"
 */
var ARGS_PATTERN = /(^|\.)args\[/;
function isDeletable(val, propStr) {
  return val === undefined || val === null && !propStr.match(ARGS_PATTERN);
}
function npSet(cont, parts, propStr) {
  return function (val) {
    var curCont = cont;
    var propPart = '';
    var containerLevels = [[cont, propPart]];
    var toDelete = isDeletable(val, propStr);
    var curPart;
    var i;
    for (i = 0; i < parts.length - 1; i++) {
      curPart = parts[i];
      if (typeof curPart === 'number' && !isArrayOrTypedArray(curCont)) {
        throw 'array index but container is not an array';
      }

      // handle special -1 array index
      if (curPart === -1) {
        toDelete = !setArrayAll(curCont, parts.slice(i + 1), val, propStr);
        if (toDelete) break;else return;
      }
      if (!checkNewContainer(curCont, curPart, parts[i + 1], toDelete)) {
        break;
      }
      curCont = curCont[curPart];
      if (typeof curCont !== 'object' || curCont === null) {
        throw 'container is not an object';
      }
      propPart = joinPropStr(propPart, curPart);
      containerLevels.push([curCont, propPart]);
    }
    if (toDelete) {
      if (i === parts.length - 1) {
        delete curCont[parts[i]];

        // The one bit of pruning we still do: drop `undefined` from the end of arrays.
        // In case someone has already unset previous items, continue until we hit a
        // non-undefined value.
        if (Array.isArray(curCont) && +parts[i] === curCont.length - 1) {
          while (curCont.length && curCont[curCont.length - 1] === undefined) {
            curCont.pop();
          }
        }
      }
    } else curCont[parts[i]] = val;
  };
}
function joinPropStr(propStr, newPart) {
  var toAdd = newPart;
  if (isNumeric(newPart)) toAdd = '[' + newPart + ']';else if (propStr) toAdd = '.' + newPart;
  return propStr + toAdd;
}

// handle special -1 array index
function setArrayAll(containerArray, innerParts, val, propStr) {
  var arrayVal = isArrayOrTypedArray(val);
  var allSet = true;
  var thisVal = val;
  var thisPropStr = propStr.replace('-1', 0);
  var deleteThis = arrayVal ? false : isDeletable(val, thisPropStr);
  var firstPart = innerParts[0];
  var i;
  for (i = 0; i < containerArray.length; i++) {
    thisPropStr = propStr.replace('-1', i);
    if (arrayVal) {
      thisVal = val[i % val.length];
      deleteThis = isDeletable(thisVal, thisPropStr);
    }
    if (deleteThis) allSet = false;
    if (!checkNewContainer(containerArray, i, firstPart, deleteThis)) {
      continue;
    }
    npSet(containerArray[i], innerParts, propStr.replace('-1', i))(thisVal);
  }
  return allSet;
}

/**
 * make new sub-container as needed.
 * returns false if there's no container and none is needed
 * because we're only deleting an attribute
 */
function checkNewContainer(container, part, nextPart, toDelete) {
  if (container[part] === undefined) {
    if (toDelete) return false;
    if (typeof nextPart === 'number') container[part] = [];else container[part] = {};
  }
  return true;
}
function badContainer(container, propStr, propParts) {
  return {
    set: function () {
      throw 'bad container';
    },
    get: function () {},
    astr: propStr,
    parts: propParts,
    obj: container
  };
}

/***/ }),

/***/ 6628:
/***/ (function(module) {

"use strict";


// Simple helper functions
// none of these need any external deps
module.exports = function noop() {};

/***/ }),

/***/ 1792:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var d3 = __webpack_require__(3428);
var isNumeric = __webpack_require__(8248);
var NOTEDATA = [];

/**
 * notifier
 * @param {String} text The person's user name
 * @param {Number} [delay=1000] The delay time in milliseconds
 *          or 'long' which provides 2000 ms delay time.
 * @return {undefined} this function does not return a value
 */
module.exports = function (text, displayLength) {
  if (NOTEDATA.indexOf(text) !== -1) return;
  NOTEDATA.push(text);
  var ts = 1000;
  if (isNumeric(displayLength)) ts = displayLength;else if (displayLength === 'long') ts = 3000;
  var notifierContainer = d3.select('body').selectAll('.plotly-notifier').data([0]);
  notifierContainer.enter().append('div').classed('plotly-notifier', true);
  var notes = notifierContainer.selectAll('.notifier-note').data(NOTEDATA);
  function killNote(transition) {
    transition.duration(700).style('opacity', 0).each('end', function (thisText) {
      var thisIndex = NOTEDATA.indexOf(thisText);
      if (thisIndex !== -1) NOTEDATA.splice(thisIndex, 1);
      d3.select(this).remove();
    });
  }
  notes.enter().append('div').classed('notifier-note', true).style('opacity', 0).each(function (thisText) {
    var note = d3.select(this);
    note.append('button').classed('notifier-close', true).html('&times;').on('click', function () {
      note.transition().call(killNote);
    });
    var p = note.append('p');
    var lines = thisText.split(/<br\s*\/?>/g);
    for (var i = 0; i < lines.length; i++) {
      if (i) p.append('br');
      p.append('span').text(lines[i]);
    }
    if (displayLength === 'stick') {
      note.transition().duration(350).style('opacity', 1);
    } else {
      note.transition().duration(700).style('opacity', 1).transition().delay(ts).call(killNote);
    }
  });
};

/***/ }),

/***/ 2213:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var setCursor = __webpack_require__(3972);
var STASHATTR = 'data-savedcursor';
var NO_CURSOR = '!!';

/*
 * works with our CSS cursor classes (see css/_cursor.scss)
 * to override a previous cursor set on d3 single-element selections,
 * by moving the name of the original cursor to the data-savedcursor attr.
 * omit cursor to revert to the previously set value.
 */
module.exports = function overrideCursor(el3, csr) {
  var savedCursor = el3.attr(STASHATTR);
  if (csr) {
    if (!savedCursor) {
      var classes = (el3.attr('class') || '').split(' ');
      for (var i = 0; i < classes.length; i++) {
        var cls = classes[i];
        if (cls.indexOf('cursor-') === 0) {
          el3.attr(STASHATTR, cls.substr(7)).classed(cls, false);
        }
      }
      if (!el3.attr(STASHATTR)) {
        el3.attr(STASHATTR, NO_CURSOR);
      }
    }
    setCursor(el3, csr);
  } else if (savedCursor) {
    el3.attr(STASHATTR, null);
    if (savedCursor === NO_CURSOR) setCursor(el3);else setCursor(el3, savedCursor);
  }
};

/***/ }),

/***/ 2065:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var dot = (__webpack_require__(2248).dot);
var BADNUM = (__webpack_require__(9032).BADNUM);
var polygon = module.exports = {};

/**
 * Turn an array of [x, y] pairs into a polygon object
 * that can test if points are inside it
 *
 * @param ptsIn Array of [x, y] pairs
 *
 * @returns polygon Object {xmin, xmax, ymin, ymax, pts, contains}
 *      (x|y)(min|max) are the bounding rect of the polygon
 *      pts is the original array, with the first pair repeated at the end
 *      contains is a function: (pt, omitFirstEdge)
 *          pt is the [x, y] pair to test
 *          omitFirstEdge truthy means points exactly on the first edge don't
 *              count. This is for use adding one polygon to another so we
 *              don't double-count the edge where they meet.
 *          returns boolean: is pt inside the polygon (including on its edges)
 */
polygon.tester = function tester(ptsIn) {
  var pts = ptsIn.slice();
  var xmin = pts[0][0];
  var xmax = xmin;
  var ymin = pts[0][1];
  var ymax = ymin;
  var i;
  if (pts[pts.length - 1][0] !== pts[0][0] || pts[pts.length - 1][1] !== pts[0][1]) {
    // close the polygon
    pts.push(pts[0]);
  }
  for (i = 1; i < pts.length; i++) {
    xmin = Math.min(xmin, pts[i][0]);
    xmax = Math.max(xmax, pts[i][0]);
    ymin = Math.min(ymin, pts[i][1]);
    ymax = Math.max(ymax, pts[i][1]);
  }

  // do we have a rectangle? Handle this here, so we can use the same
  // tester for the rectangular case without sacrificing speed

  var isRect = false;
  var rectFirstEdgeTest;
  if (pts.length === 5) {
    if (pts[0][0] === pts[1][0]) {
      // vert, horz, vert, horz
      if (pts[2][0] === pts[3][0] && pts[0][1] === pts[3][1] && pts[1][1] === pts[2][1]) {
        isRect = true;
        rectFirstEdgeTest = function (pt) {
          return pt[0] === pts[0][0];
        };
      }
    } else if (pts[0][1] === pts[1][1]) {
      // horz, vert, horz, vert
      if (pts[2][1] === pts[3][1] && pts[0][0] === pts[3][0] && pts[1][0] === pts[2][0]) {
        isRect = true;
        rectFirstEdgeTest = function (pt) {
          return pt[1] === pts[0][1];
        };
      }
    }
  }
  function rectContains(pt, omitFirstEdge) {
    var x = pt[0];
    var y = pt[1];
    if (x === BADNUM || x < xmin || x > xmax || y === BADNUM || y < ymin || y > ymax) {
      // pt is outside the bounding box of polygon
      return false;
    }
    if (omitFirstEdge && rectFirstEdgeTest(pt)) return false;
    return true;
  }
  function contains(pt, omitFirstEdge) {
    var x = pt[0];
    var y = pt[1];
    if (x === BADNUM || x < xmin || x > xmax || y === BADNUM || y < ymin || y > ymax) {
      // pt is outside the bounding box of polygon
      return false;
    }
    var imax = pts.length;
    var x1 = pts[0][0];
    var y1 = pts[0][1];
    var crossings = 0;
    var i;
    var x0;
    var y0;
    var xmini;
    var ycross;
    for (i = 1; i < imax; i++) {
      // find all crossings of a vertical line upward from pt with
      // polygon segments
      // crossings exactly at xmax don't count, unless the point is
      // exactly on the segment, then it counts as inside.
      x0 = x1;
      y0 = y1;
      x1 = pts[i][0];
      y1 = pts[i][1];
      xmini = Math.min(x0, x1);
      if (x < xmini || x > Math.max(x0, x1) || y > Math.max(y0, y1)) {
        // outside the bounding box of this segment, it's only a crossing
        // if it's below the box.

        continue;
      } else if (y < Math.min(y0, y1)) {
        // don't count the left-most point of the segment as a crossing
        // because we don't want to double-count adjacent crossings
        // UNLESS the polygon turns past vertical at exactly this x
        // Note that this is repeated below, but we can't factor it out
        // because
        if (x !== xmini) crossings++;
      } else {
        // inside the bounding box, check the actual line intercept

        // vertical segment - we know already that the point is exactly
        // on the segment, so mark the crossing as exactly at the point.
        if (x1 === x0) ycross = y;
        // any other angle
        else ycross = y0 + (x - x0) * (y1 - y0) / (x1 - x0);

        // exactly on the edge: counts as inside the polygon, unless it's the
        // first edge and we're omitting it.
        if (y === ycross) {
          if (i === 1 && omitFirstEdge) return false;
          return true;
        }
        if (y <= ycross && x !== xmini) crossings++;
      }
    }

    // if we've gotten this far, odd crossings means inside, even is outside
    return crossings % 2 === 1;
  }

  // detect if poly is degenerate
  var degenerate = true;
  var lastPt = pts[0];
  for (i = 1; i < pts.length; i++) {
    if (lastPt[0] !== pts[i][0] || lastPt[1] !== pts[i][1]) {
      degenerate = false;
      break;
    }
  }
  return {
    xmin: xmin,
    xmax: xmax,
    ymin: ymin,
    ymax: ymax,
    pts: pts,
    contains: isRect ? rectContains : contains,
    isRect: isRect,
    degenerate: degenerate
  };
};

/**
 * Test if a segment of a points array is bent or straight
 *
 * @param pts Array of [x, y] pairs
 * @param start the index of the proposed start of the straight section
 * @param end the index of the proposed end point
 * @param tolerance the max distance off the line connecting start and end
 *      before the line counts as bent
 * @returns boolean: true means this segment is bent, false means straight
 */
polygon.isSegmentBent = function isSegmentBent(pts, start, end, tolerance) {
  var startPt = pts[start];
  var segment = [pts[end][0] - startPt[0], pts[end][1] - startPt[1]];
  var segmentSquared = dot(segment, segment);
  var segmentLen = Math.sqrt(segmentSquared);
  var unitPerp = [-segment[1] / segmentLen, segment[0] / segmentLen];
  var i;
  var part;
  var partParallel;
  for (i = start + 1; i < end; i++) {
    part = [pts[i][0] - startPt[0], pts[i][1] - startPt[1]];
    partParallel = dot(part, segment);
    if (partParallel < 0 || partParallel > segmentSquared || Math.abs(dot(part, unitPerp)) > tolerance) return true;
  }
  return false;
};

/**
 * Make a filtering polygon, to minimize the number of segments
 *
 * @param pts Array of [x, y] pairs (must start with at least 1 pair)
 * @param tolerance the maximum deviation from straight allowed for
 *      removing points to simplify the polygon
 *
 * @returns Object {addPt, raw, filtered}
 *      addPt is a function(pt: [x, y] pair) to add a raw point and
 *          continue filtering
 *      raw is all the input points
 *      filtered is the resulting filtered Array of [x, y] pairs
 */
polygon.filter = function filter(pts, tolerance) {
  var ptsFiltered = [pts[0]];
  var doneRawIndex = 0;
  var doneFilteredIndex = 0;
  function addPt(pt) {
    pts.push(pt);
    var prevFilterLen = ptsFiltered.length;
    var iLast = doneRawIndex;
    ptsFiltered.splice(doneFilteredIndex + 1);
    for (var i = iLast + 1; i < pts.length; i++) {
      if (i === pts.length - 1 || polygon.isSegmentBent(pts, iLast, i + 1, tolerance)) {
        ptsFiltered.push(pts[i]);
        if (ptsFiltered.length < prevFilterLen - 2) {
          doneRawIndex = i;
          doneFilteredIndex = ptsFiltered.length - 1;
        }
        iLast = i;
      }
    }
  }
  if (pts.length > 1) {
    var lastPt = pts.pop();
    addPt(lastPt);
  }
  return {
    addPt: addPt,
    raw: pts,
    filtered: ptsFiltered
  };
};

/***/ }),

/***/ 4296:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isNumeric = __webpack_require__(8248);
var isMobileOrTablet = __webpack_require__(5928);
module.exports = function preserveDrawingBuffer(opts) {
  var ua;
  if (opts && opts.hasOwnProperty('userAgent')) {
    ua = opts.userAgent;
  } else {
    ua = getUserAgent();
  }
  if (typeof ua !== 'string') return true;
  var enable = isMobileOrTablet({
    ua: {
      headers: {
        'user-agent': ua
      }
    },
    tablet: true,
    featureDetect: false
  });
  if (!enable) {
    var allParts = ua.split(' ');
    for (var i = 1; i < allParts.length; i++) {
      var part = allParts[i];
      if (part.indexOf('Safari') !== -1) {
        // find Safari version
        for (var k = i - 1; k > -1; k--) {
          var prevPart = allParts[k];
          if (prevPart.substr(0, 8) === 'Version/') {
            var v = prevPart.substr(8).split('.')[0];
            if (isNumeric(v)) v = +v;
            if (v >= 13) return true;
          }
        }
      }
    }
  }
  return enable;
};
function getUserAgent() {
  // similar to https://github.com/juliangruber/is-mobile/blob/91ca39ccdd4cfc5edfb5391e2515b923a730fbea/index.js#L14-L17
  var ua;
  if (typeof navigator !== 'undefined') {
    ua = navigator.userAgent;
  }
  if (ua && ua.headers && typeof ua.headers['user-agent'] === 'string') {
    ua = ua.headers['user-agent'];
  }
  return ua;
}

/***/ }),

/***/ 2416:
/***/ (function(module) {

"use strict";


/**
 * Push array with unique items
 *
 * Ignores falsy items, except 0 so we can use it to construct arrays of indices.
 *
 * @param {array} array
 *  array to be filled
 * @param {any} item
 *  item to be or not to be inserted
 * @return {array}
 *  ref to array (now possibly containing one more item)
 *
 */
module.exports = function pushUnique(array, item) {
  if (item instanceof RegExp) {
    var itemStr = item.toString();
    for (var i = 0; i < array.length; i++) {
      if (array[i] instanceof RegExp && array[i].toString() === itemStr) {
        return array;
      }
    }
    array.push(item);
  } else if ((item || item === 0) && array.indexOf(item) === -1) array.push(item);
  return array;
};

/***/ }),

/***/ 4552:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Lib = __webpack_require__(3400);
var dfltConfig = (__webpack_require__(556).dfltConfig);

/**
 * Copy arg array *without* removing `undefined` values from objects.
 *
 * @param gd
 * @param args
 * @returns {Array}
 */
function copyArgArray(gd, args) {
  var copy = [];
  var arg;
  for (var i = 0; i < args.length; i++) {
    arg = args[i];
    if (arg === gd) copy[i] = arg;else if (typeof arg === 'object') {
      copy[i] = Array.isArray(arg) ? Lib.extendDeep([], arg) : Lib.extendDeepAll({}, arg);
    } else copy[i] = arg;
  }
  return copy;
}

// -----------------------------------------------------
// Undo/Redo queue for plots
// -----------------------------------------------------

var queue = {};

// TODO: disable/enable undo and redo buttons appropriately

/**
 * Add an item to the undoQueue for a graphDiv
 *
 * @param gd
 * @param undoFunc Function undo this operation
 * @param undoArgs Args to supply undoFunc with
 * @param redoFunc Function to redo this operation
 * @param redoArgs Args to supply redoFunc with
 */
queue.add = function (gd, undoFunc, undoArgs, redoFunc, redoArgs) {
  var queueObj, queueIndex;

  // make sure we have the queue and our position in it
  gd.undoQueue = gd.undoQueue || {
    index: 0,
    queue: [],
    sequence: false
  };
  queueIndex = gd.undoQueue.index;

  // if we're already playing an undo or redo, or if this is an auto operation
  // (like pane resize... any others?) then we don't save this to the undo queue
  if (gd.autoplay) {
    if (!gd.undoQueue.inSequence) gd.autoplay = false;
    return;
  }

  // if we're not in a sequence or are just starting, we need a new queue item
  if (!gd.undoQueue.sequence || gd.undoQueue.beginSequence) {
    queueObj = {
      undo: {
        calls: [],
        args: []
      },
      redo: {
        calls: [],
        args: []
      }
    };
    gd.undoQueue.queue.splice(queueIndex, gd.undoQueue.queue.length - queueIndex, queueObj);
    gd.undoQueue.index += 1;
  } else {
    queueObj = gd.undoQueue.queue[queueIndex - 1];
  }
  gd.undoQueue.beginSequence = false;

  // we unshift to handle calls for undo in a forward for loop later
  if (queueObj) {
    queueObj.undo.calls.unshift(undoFunc);
    queueObj.undo.args.unshift(undoArgs);
    queueObj.redo.calls.push(redoFunc);
    queueObj.redo.args.push(redoArgs);
  }
  if (gd.undoQueue.queue.length > dfltConfig.queueLength) {
    gd.undoQueue.queue.shift();
    gd.undoQueue.index--;
  }
};

/**
 * Begin a sequence of undoQueue changes
 *
 * @param gd
 */
queue.startSequence = function (gd) {
  gd.undoQueue = gd.undoQueue || {
    index: 0,
    queue: [],
    sequence: false
  };
  gd.undoQueue.sequence = true;
  gd.undoQueue.beginSequence = true;
};

/**
 * Stop a sequence of undoQueue changes
 *
 * Call this *after* you're sure your undo chain has ended
 *
 * @param gd
 */
queue.stopSequence = function (gd) {
  gd.undoQueue = gd.undoQueue || {
    index: 0,
    queue: [],
    sequence: false
  };
  gd.undoQueue.sequence = false;
  gd.undoQueue.beginSequence = false;
};

/**
 * Move one step back in the undo queue, and undo the object there.
 *
 * @param gd
 */
queue.undo = function undo(gd) {
  var queueObj, i;
  if (gd.undoQueue === undefined || isNaN(gd.undoQueue.index) || gd.undoQueue.index <= 0) {
    return;
  }

  // index is pointing to next *forward* queueObj, point to the one we're undoing
  gd.undoQueue.index--;

  // get the queueObj for instructions on how to undo
  queueObj = gd.undoQueue.queue[gd.undoQueue.index];

  // this sequence keeps things from adding to the queue during undo/redo
  gd.undoQueue.inSequence = true;
  for (i = 0; i < queueObj.undo.calls.length; i++) {
    queue.plotDo(gd, queueObj.undo.calls[i], queueObj.undo.args[i]);
  }
  gd.undoQueue.inSequence = false;
  gd.autoplay = false;
};

/**
 * Redo the current object in the undo, then move forward in the queue.
 *
 * @param gd
 */
queue.redo = function redo(gd) {
  var queueObj, i;
  if (gd.undoQueue === undefined || isNaN(gd.undoQueue.index) || gd.undoQueue.index >= gd.undoQueue.queue.length) {
    return;
  }

  // get the queueObj for instructions on how to undo
  queueObj = gd.undoQueue.queue[gd.undoQueue.index];

  // this sequence keeps things from adding to the queue during undo/redo
  gd.undoQueue.inSequence = true;
  for (i = 0; i < queueObj.redo.calls.length; i++) {
    queue.plotDo(gd, queueObj.redo.calls[i], queueObj.redo.args[i]);
  }
  gd.undoQueue.inSequence = false;
  gd.autoplay = false;

  // index is pointing to the thing we just redid, move it
  gd.undoQueue.index++;
};

/**
 * Called by undo/redo to make the actual changes.
 *
 * Not meant to be called publically, but included for mocking out in tests.
 *
 * @param gd
 * @param func
 * @param args
 */
queue.plotDo = function (gd, func, args) {
  gd.autoplay = true;

  // this *won't* copy gd and it preserves `undefined` properties!
  args = copyArgArray(gd, args);

  // call the supplied function
  func.apply(null, args);
};
module.exports = queue;

/***/ }),

/***/ 3756:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


/*
 * make a regex for matching counter ids/names ie xaxis, xaxis2, xaxis10...
 *
 * @param {string} head: the head of the pattern, eg 'x' matches 'x', 'x2', 'x10' etc.
 *      'xy' is a special case for cartesian subplots: it matches 'x2y3' etc
 * @param {Optional(string)} tail: a fixed piece after the id
 *      eg counterRegex('scene', '.annotations') for scene2.annotations etc.
 * @param {boolean} openEnded: if true, the string may continue past the match.
 * @param {boolean} matchBeginning: if false, the string may start before the match.
 */
exports.counter = function (head, tail, openEnded, matchBeginning) {
  var fullTail = (tail || '') + (openEnded ? '' : '$');
  var startWithPrefix = matchBeginning === false ? '' : '^';
  if (head === 'xy') {
    return new RegExp(startWithPrefix + 'x([2-9]|[1-9][0-9]+)?y([2-9]|[1-9][0-9]+)?' + fullTail);
  }
  return new RegExp(startWithPrefix + head + '([2-9]|[1-9][0-9]+)?' + fullTail);
};

/***/ }),

/***/ 3193:
/***/ (function(module) {

"use strict";


// ASCEND: chop off the last nesting level - either [<n>] or .<key> - to ascend
// the attribute tree. the remaining attrString is in match[1]
var ASCEND = /^(.*)(\.[^\.\[\]]+|\[\d\])$/;

// SIMPLEATTR: is this an un-nested attribute? (no dots or brackets)
var SIMPLEATTR = /^[^\.\[\]]+$/;

/*
 * calculate a relative attribute string, similar to a relative path
 *
 * @param {string} baseAttr:
 *   an attribute string, such as 'annotations[3].x'. The "current location"
 *   is the attribute string minus the last component ('annotations[3]')
 * @param {string} relativeAttr:
 *   a route to the desired attribute string, using '^' to ascend
 *
 * @return {string} attrString:
 *   for example:
 *     relativeAttr('annotations[3].x', 'y') = 'annotations[3].y'
 *     relativeAttr('annotations[3].x', '^[2].z') = 'annotations[2].z'
 *     relativeAttr('annotations[3].x', '^^margin') = 'margin'
 *     relativeAttr('annotations[3].x', '^^margin.r') = 'margin.r'
 */
module.exports = function (baseAttr, relativeAttr) {
  while (relativeAttr) {
    var match = baseAttr.match(ASCEND);
    if (match) baseAttr = match[1];else if (baseAttr.match(SIMPLEATTR)) baseAttr = '';else throw new Error('bad relativeAttr call:' + [baseAttr, relativeAttr]);
    if (relativeAttr.charAt(0) === '^') relativeAttr = relativeAttr.slice(1);else break;
  }
  if (baseAttr && relativeAttr.charAt(0) !== '[') {
    return baseAttr + '.' + relativeAttr;
  }
  return baseAttr + relativeAttr;
};

/***/ }),

/***/ 1528:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isArrayOrTypedArray = (__webpack_require__(8116).isArrayOrTypedArray);
var isPlainObject = __webpack_require__(3620);

/**
 * Relink private _keys and keys with a function value from one container
 * to the new container.
 * Relink means copying if object is pass-by-value and adding a reference
 * if object is pass-by-ref.
 * This prevents deepCopying massive structures like a webgl context.
 */
module.exports = function relinkPrivateKeys(toContainer, fromContainer) {
  for (var k in fromContainer) {
    var fromVal = fromContainer[k];
    var toVal = toContainer[k];
    if (toVal === fromVal) continue;
    if (k.charAt(0) === '_' || typeof fromVal === 'function') {
      // if it already exists at this point, it's something
      // that we recreate each time around, so ignore it
      if (k in toContainer) continue;
      toContainer[k] = fromVal;
    } else if (isArrayOrTypedArray(fromVal) && isArrayOrTypedArray(toVal) && isPlainObject(fromVal[0])) {
      // filter out data_array items that can contain user objects
      // most of the time the toVal === fromVal check will catch these early
      // but if the user makes new ones we also don't want to recurse in.
      if (k === 'customdata' || k === 'ids') continue;

      // recurse into arrays containers
      var minLen = Math.min(fromVal.length, toVal.length);
      for (var j = 0; j < minLen; j++) {
        if (toVal[j] !== fromVal[j] && isPlainObject(fromVal[j]) && isPlainObject(toVal[j])) {
          relinkPrivateKeys(toVal[j], fromVal[j]);
        }
      }
    } else if (isPlainObject(fromVal) && isPlainObject(toVal)) {
      // recurse into objects, but only if they still exist
      relinkPrivateKeys(toVal, fromVal);
      if (!Object.keys(toVal).length) delete toContainer[k];
    }
  }
};

/***/ }),

/***/ 4952:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var isNumeric = __webpack_require__(8248);
var loggers = __webpack_require__(4248);
var identity = __webpack_require__(5536);
var BADNUM = (__webpack_require__(9032).BADNUM);

// don't trust floating point equality - fraction of bin size to call
// "on the line" and ensure that they go the right way specified by
// linelow
var roundingError = 1e-9;

/**
 * findBin - find the bin for val - note that it can return outside the
 * bin range any pos. or neg. integer for linear bins, or -1 or
 * bins.length-1 for explicit.
 * bins is either an object {start,size,end} or an array length #bins+1
 * bins can be either increasing or decreasing but must be monotonic
 * for linear bins, we can just calculate. For listed bins, run a binary
 * search linelow (truthy) says the bin boundary should be attributed to
 * the lower bin rather than the default upper bin
 */
exports.findBin = function (val, bins, linelow) {
  if (isNumeric(bins.start)) {
    return linelow ? Math.ceil((val - bins.start) / bins.size - roundingError) - 1 : Math.floor((val - bins.start) / bins.size + roundingError);
  } else {
    var n1 = 0;
    var n2 = bins.length;
    var c = 0;
    var binSize = n2 > 1 ? (bins[n2 - 1] - bins[0]) / (n2 - 1) : 1;
    var n, test;
    if (binSize >= 0) {
      test = linelow ? lessThan : lessOrEqual;
    } else {
      test = linelow ? greaterOrEqual : greaterThan;
    }
    val += binSize * roundingError * (linelow ? -1 : 1) * (binSize >= 0 ? 1 : -1);
    // c is just to avoid infinite loops if there's an error
    while (n1 < n2 && c++ < 100) {
      n = Math.floor((n1 + n2) / 2);
      if (test(bins[n], val)) n1 = n + 1;else n2 = n;
    }
    if (c > 90) loggers.log('Long binary search...');
    return n1 - 1;
  }
};
function lessThan(a, b) {
  return a < b;
}
function lessOrEqual(a, b) {
  return a <= b;
}
function greaterThan(a, b) {
  return a > b;
}
function greaterOrEqual(a, b) {
  return a >= b;
}
exports.sorterAsc = function (a, b) {
  return a - b;
};
exports.sorterDes = function (a, b) {
  return b - a;
};

/**
 * find distinct values in an array, lumping together ones that appear to
 * just be off by a rounding error
 * return the distinct values and the minimum difference between any two
 */
exports.distinctVals = function (valsIn) {
  var vals = valsIn.slice(); // otherwise we sort the original array...
  vals.sort(exports.sorterAsc); // undefined listed in the end - also works on IE11

  var last;
  for (last = vals.length - 1; last > -1; last--) {
    if (vals[last] !== BADNUM) break;
  }
  var minDiff = vals[last] - vals[0] || 1;
  var errDiff = minDiff / (last || 1) / 10000;
  var newVals = [];
  var preV;
  for (var i = 0; i <= last; i++) {
    var v = vals[i];

    // make sure values aren't just off by a rounding error
    var diff = v - preV;
    if (preV === undefined) {
      newVals.push(v);
      preV = v;
    } else if (diff > errDiff) {
      minDiff = Math.min(minDiff, diff);
      newVals.push(v);
      preV = v;
    }
  }
  return {
    vals: newVals,
    minDiff: minDiff
  };
};

/**
 * return the smallest element from (sorted) array arrayIn that's bigger than val,
 * or (reverse) the largest element smaller than val
 * used to find the best tick given the minimum (non-rounded) tick
 * particularly useful for date/time where things are not powers of 10
 * binary search is probably overkill here...
 */
exports.roundUp = function (val, arrayIn, reverse) {
  var low = 0;
  var high = arrayIn.length - 1;
  var mid;
  var c = 0;
  var dlow = reverse ? 0 : 1;
  var dhigh = reverse ? 1 : 0;
  var rounded = reverse ? Math.ceil : Math.floor;
  // c is just to avoid infinite loops if there's an error
  while (low < high && c++ < 100) {
    mid = rounded((low + high) / 2);
    if (arrayIn[mid] <= val) low = mid + dlow;else high = mid - dhigh;
  }
  return arrayIn[low];
};

/**
 * Tweak to Array.sort(sortFn) that improves performance for pre-sorted arrays
 *
 * Note that newer browsers (such as Chrome v70+) are starting to pick up
 * on pre-sorted arrays which may render the following optimization unnecessary
 * in the future.
 *
 * Motivation: sometimes we need to sort arrays but the input is likely to
 * already be sorted. Browsers don't seem to pick up on pre-sorted arrays,
 * and in fact Chrome is actually *slower* sorting pre-sorted arrays than purely
 * random arrays. FF is at least faster if the array is pre-sorted, but still
 * not as fast as it could be.
 * Here's how this plays out sorting a length-1e6 array:
 *
 * Calls to Sort FN  |  Chrome bare  |  FF bare  |  Chrome tweak  |  FF tweak
 *                   |  v68.0 Mac    |  v61.0 Mac|                |
 * ------------------+---------------+-----------+----------------+------------
 * ordered           |  30.4e6       |  10.1e6   |  1e6           |  1e6
 * reversed          |  29.4e6       |  9.9e6    |  1e6 + reverse |  1e6 + reverse
 * random            |  ~21e6        |  ~18.7e6  |  ~21e6         |  ~18.7e6
 *
 * So this is a substantial win for pre-sorted (ordered or exactly reversed)
 * arrays. Including this wrapper on an unsorted array adds a penalty that will
 * in general be only a few calls to the sort function. The only case this
 * penalty will be significant is if the array is mostly sorted but there are
 * a few unsorted items near the end, but the penalty is still at most N calls
 * out of (for N=1e6) ~20N total calls
 *
 * @param {Array} array: the array, to be sorted in place
 * @param {function} sortFn: As in Array.sort, function(a, b) that puts
 *     item a before item b if the return is negative, a after b if positive,
 *     and no change if zero.
 * @return {Array}: the original array, sorted in place.
 */
exports.sort = function (array, sortFn) {
  var notOrdered = 0;
  var notReversed = 0;
  for (var i = 1; i < array.length; i++) {
    var pairOrder = sortFn(array[i], array[i - 1]);
    if (pairOrder < 0) notOrdered = 1;else if (pairOrder > 0) notReversed = 1;
    if (notOrdered && notReversed) return array.sort(sortFn);
  }
  return notReversed ? array : array.reverse();
};

/**
 * find index in array 'arr' that minimizes 'fn'
 *
 * @param {array} arr : array where to search
 * @param {fn (optional)} fn : function to minimize,
 *   if not given, fn is the identity function
 * @return {integer}
 */
exports.findIndexOfMin = function (arr, fn) {
  fn = fn || identity;
  var min = Infinity;
  var ind;
  for (var i = 0; i < arr.length; i++) {
    var v = fn(arr[i]);
    if (v < min) {
      min = v;
      ind = i;
    }
  }
  return ind;
};

/***/ }),

/***/ 3972:
/***/ (function(module) {

"use strict";


// works with our CSS cursor classes (see css/_cursor.scss)
// to apply cursors to d3 single-element selections.
// omit cursor to revert to the default.
module.exports = function setCursor(el3, csr) {
  (el3.attr('class') || '').split(' ').forEach(function (cls) {
    if (cls.indexOf('cursor-') === 0) el3.classed(cls, false);
  });
  if (csr) el3.classed('cursor-' + csr, true);
};

/***/ }),

/***/ 2996:
/***/ (function(module) {

"use strict";


module.exports = function sortObjectKeys(obj) {
  return Object.keys(obj).sort();
};

/***/ }),

/***/ 3084:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var isNumeric = __webpack_require__(8248);
var isArrayOrTypedArray = (__webpack_require__(8116).isArrayOrTypedArray);

/**
 * aggNums() returns the result of an aggregate function applied to an array of
 * values, where non-numerical values have been tossed out.
 *
 * @param {function} f - aggregation function (e.g., Math.min)
 * @param {Number} v - initial value (continuing from previous calls)
 *      if there's no continuing value, use null for selector-type
 *      functions (max,min), or 0 for summations
 * @param {Array} a - array to aggregate (may be nested, we will recurse,
 *                    but all elements must have the same dimension)
 * @param {Number} len - maximum length of a to aggregate
 * @return {Number} - result of f applied to a starting from v
 */
exports.aggNums = function (f, v, a, len) {
  var i, b;
  if (!len || len > a.length) len = a.length;
  if (!isNumeric(v)) v = false;
  if (isArrayOrTypedArray(a[0])) {
    b = new Array(len);
    for (i = 0; i < len; i++) b[i] = exports.aggNums(f, v, a[i]);
    a = b;
  }
  for (i = 0; i < len; i++) {
    if (!isNumeric(v)) v = a[i];else if (isNumeric(a[i])) v = f(+v, +a[i]);
  }
  return v;
};

/**
 * mean & std dev functions using aggNums, so it handles non-numerics nicely
 * even need to use aggNums instead of .length, to toss out non-numerics
 */
exports.len = function (data) {
  return exports.aggNums(function (a) {
    return a + 1;
  }, 0, data);
};
exports.mean = function (data, len) {
  if (!len) len = exports.len(data);
  return exports.aggNums(function (a, b) {
    return a + b;
  }, 0, data) / len;
};
exports.midRange = function (numArr) {
  if (numArr === undefined || numArr.length === 0) return undefined;
  return (exports.aggNums(Math.max, null, numArr) + exports.aggNums(Math.min, null, numArr)) / 2;
};
exports.variance = function (data, len, mean) {
  if (!len) len = exports.len(data);
  if (!isNumeric(mean)) mean = exports.mean(data, len);
  return exports.aggNums(function (a, b) {
    return a + Math.pow(b - mean, 2);
  }, 0, data) / len;
};
exports.stdev = function (data, len, mean) {
  return Math.sqrt(exports.variance(data, len, mean));
};

/**
 * median of a finite set of numbers
 * reference page: https://en.wikipedia.org/wiki/Median#Finite_set_of_numbers
**/
exports.median = function (data) {
  var b = data.slice().sort();
  return exports.interp(b, 0.5);
};

/**
 * interp() computes a percentile (quantile) for a given distribution.
 * We interpolate the distribution (to compute quantiles, we follow method #10 here:
 * http://jse.amstat.org/v14n3/langford.html).
 * Typically the index or rank (n * arr.length) may be non-integer.
 * For reference: ends are clipped to the extreme values in the array;
 * For box plots: index you get is half a point too high (see
 * http://en.wikipedia.org/wiki/Percentile#Nearest_rank) but note that this definition
 * indexes from 1 rather than 0, so we subtract 1/2 (instead of add).
 *
 * @param {Array} arr - This array contains the values that make up the distribution.
 * @param {Number} n - Between 0 and 1, n = p/100 is such that we compute the p^th percentile.
 * For example, the 50th percentile (or median) corresponds to n = 0.5
 * @return {Number} - percentile
 */
exports.interp = function (arr, n) {
  if (!isNumeric(n)) throw 'n should be a finite number';
  n = n * arr.length - 0.5;
  if (n < 0) return arr[0];
  if (n > arr.length - 1) return arr[arr.length - 1];
  var frac = n % 1;
  return frac * arr[Math.ceil(n)] + (1 - frac) * arr[Math.floor(n)];
};

/***/ }),

/***/ 2736:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


/* global MathJax:false */
var d3 = __webpack_require__(3428);
var Lib = __webpack_require__(3400);
var strTranslate = Lib.strTranslate;
var xmlnsNamespaces = __webpack_require__(9616);
var LINE_SPACING = (__webpack_require__(4284).LINE_SPACING);

// text converter

var FIND_TEX = /([^$]*)([$]+[^$]*[$]+)([^$]*)/;
exports.convertToTspans = function (_context, gd, _callback) {
  var str = _context.text();

  // Until we get tex integrated more fully (so it can be used along with non-tex)
  // allow some elements to prohibit it by attaching 'data-notex' to the original
  var tex = !_context.attr('data-notex') && gd && gd._context.typesetMath && typeof MathJax !== 'undefined' && str.match(FIND_TEX);
  var parent = d3.select(_context.node().parentNode);
  if (parent.empty()) return;
  var svgClass = _context.attr('class') ? _context.attr('class').split(' ')[0] : 'text';
  svgClass += '-math';
  parent.selectAll('svg.' + svgClass).remove();
  parent.selectAll('g.' + svgClass + '-group').remove();
  _context.style('display', null).attr({
    // some callers use data-unformatted *from the <text> element* in 'cancel'
    // so we need it here even if we're going to turn it into math
    // these two (plus style and text-anchor attributes) form the key we're
    // going to use for Drawing.bBox
    'data-unformatted': str,
    'data-math': 'N'
  });
  function showText() {
    if (!parent.empty()) {
      svgClass = _context.attr('class') + '-math';
      parent.select('svg.' + svgClass).remove();
    }
    _context.text('').style('white-space', 'pre');
    var hasLink = buildSVGText(_context.node(), str);
    if (hasLink) {
      // at least in Chrome, pointer-events does not seem
      // to be honored in children of <text> elements
      // so if we have an anchor, we have to make the
      // whole element respond
      _context.style('pointer-events', 'all');
    }
    exports.positionText(_context);
    if (_callback) _callback.call(_context);
  }
  if (tex) {
    (gd && gd._promises || []).push(new Promise(function (resolve) {
      _context.style('display', 'none');
      var fontSize = parseInt(_context.node().style.fontSize, 10);
      var config = {
        fontSize: fontSize
      };
      texToSVG(tex[2], config, function (_svgEl, _glyphDefs, _svgBBox) {
        parent.selectAll('svg.' + svgClass).remove();
        parent.selectAll('g.' + svgClass + '-group').remove();
        var newSvg = _svgEl && _svgEl.select('svg');
        if (!newSvg || !newSvg.node()) {
          showText();
          resolve();
          return;
        }
        var mathjaxGroup = parent.append('g').classed(svgClass + '-group', true).attr({
          'pointer-events': 'none',
          'data-unformatted': str,
          'data-math': 'Y'
        });
        mathjaxGroup.node().appendChild(newSvg.node());

        // stitch the glyph defs
        if (_glyphDefs && _glyphDefs.node()) {
          newSvg.node().insertBefore(_glyphDefs.node().cloneNode(true), newSvg.node().firstChild);
        }
        var w0 = _svgBBox.width;
        var h0 = _svgBBox.height;
        newSvg.attr({
          class: svgClass,
          height: h0,
          preserveAspectRatio: 'xMinYMin meet'
        }).style({
          overflow: 'visible',
          'pointer-events': 'none'
        });
        var fill = _context.node().style.fill || 'black';
        var g = newSvg.select('g');
        g.attr({
          fill: fill,
          stroke: fill
        });
        var bb = g.node().getBoundingClientRect();
        var w = bb.width;
        var h = bb.height;
        if (w > w0 || h > h0) {
          // this happen in firefox v82+ | see https://bugzilla.mozilla.org/show_bug.cgi?id=1709251 addressed
          // temporary fix:
          newSvg.style('overflow', 'hidden');
          bb = newSvg.node().getBoundingClientRect();
          w = bb.width;
          h = bb.height;
        }
        var x = +_context.attr('x');
        var y = +_context.attr('y');

        // font baseline is about 1/4 fontSize below centerline
        var textHeight = fontSize || _context.node().getBoundingClientRect().height;
        var dy = -textHeight / 4;
        if (svgClass[0] === 'y') {
          mathjaxGroup.attr({
            transform: 'rotate(' + [-90, x, y] + ')' + strTranslate(-w / 2, dy - h / 2)
          });
        } else if (svgClass[0] === 'l') {
          y = dy - h / 2;
        } else if (svgClass[0] === 'a' && svgClass.indexOf('atitle') !== 0) {
          x = 0;
          y = dy;
        } else {
          var anchor = _context.attr('text-anchor');
          x = x - w * (anchor === 'middle' ? 0.5 : anchor === 'end' ? 1 : 0);
          y = y + dy - h / 2;
        }
        newSvg.attr({
          x: x,
          y: y
        });
        if (_callback) _callback.call(_context, mathjaxGroup);
        resolve(mathjaxGroup);
      });
    }));
  } else showText();
  return _context;
};

// MathJax

var LT_MATCH = /(<|&lt;|&#60;)/g;
var GT_MATCH = /(>|&gt;|&#62;)/g;
function cleanEscapesForTex(s) {
  return s.replace(LT_MATCH, '\\lt ').replace(GT_MATCH, '\\gt ');
}
var inlineMath = [['$', '$'], ['\\(', '\\)']];
function texToSVG(_texString, _config, _callback) {
  var MathJaxVersion = parseInt((MathJax.version || '').split('.')[0]);
  if (MathJaxVersion !== 2 && MathJaxVersion !== 3) {
    Lib.warn('No MathJax version:', MathJax.version);
    return;
  }
  var originalRenderer, originalConfig, originalProcessSectionDelay, tmpDiv;
  var setConfig2 = function () {
    originalConfig = Lib.extendDeepAll({}, MathJax.Hub.config);
    originalProcessSectionDelay = MathJax.Hub.processSectionDelay;
    if (MathJax.Hub.processSectionDelay !== undefined) {
      // MathJax 2.5+ but not 3+
      MathJax.Hub.processSectionDelay = 0;
    }
    return MathJax.Hub.Config({
      messageStyle: 'none',
      tex2jax: {
        inlineMath: inlineMath
      },
      displayAlign: 'left'
    });
  };
  var setConfig3 = function () {
    originalConfig = Lib.extendDeepAll({}, MathJax.config);
    if (!MathJax.config.tex) {
      MathJax.config.tex = {};
    }
    MathJax.config.tex.inlineMath = inlineMath;
  };
  var setRenderer2 = function () {
    originalRenderer = MathJax.Hub.config.menuSettings.renderer;
    if (originalRenderer !== 'SVG') {
      return MathJax.Hub.setRenderer('SVG');
    }
  };
  var setRenderer3 = function () {
    originalRenderer = MathJax.config.startup.output;
    if (originalRenderer !== 'svg') {
      MathJax.config.startup.output = 'svg';
    }
  };
  var initiateMathJax = function () {
    var randomID = 'math-output-' + Lib.randstr({}, 64);
    tmpDiv = d3.select('body').append('div').attr({
      id: randomID
    }).style({
      visibility: 'hidden',
      position: 'absolute',
      'font-size': _config.fontSize + 'px'
    }).text(cleanEscapesForTex(_texString));
    var tmpNode = tmpDiv.node();
    return MathJaxVersion === 2 ? MathJax.Hub.Typeset(tmpNode) : MathJax.typeset([tmpNode]);
  };
  var finalizeMathJax = function () {
    var sel = tmpDiv.select(MathJaxVersion === 2 ? '.MathJax_SVG' : '.MathJax');
    var node = !sel.empty() && tmpDiv.select('svg').node();
    if (!node) {
      Lib.log('There was an error in the tex syntax.', _texString);
      _callback();
    } else {
      var nodeBBox = node.getBoundingClientRect();
      var glyphDefs;
      if (MathJaxVersion === 2) {
        glyphDefs = d3.select('body').select('#MathJax_SVG_glyphs');
      } else {
        glyphDefs = sel.select('defs');
      }
      _callback(sel, glyphDefs, nodeBBox);
    }
    tmpDiv.remove();
  };
  var resetRenderer2 = function () {
    if (originalRenderer !== 'SVG') {
      return MathJax.Hub.setRenderer(originalRenderer);
    }
  };
  var resetRenderer3 = function () {
    if (originalRenderer !== 'svg') {
      MathJax.config.startup.output = originalRenderer;
    }
  };
  var resetConfig2 = function () {
    if (originalProcessSectionDelay !== undefined) {
      MathJax.Hub.processSectionDelay = originalProcessSectionDelay;
    }
    return MathJax.Hub.Config(originalConfig);
  };
  var resetConfig3 = function () {
    MathJax.config = originalConfig;
  };
  if (MathJaxVersion === 2) {
    MathJax.Hub.Queue(setConfig2, setRenderer2, initiateMathJax, finalizeMathJax, resetRenderer2, resetConfig2);
  } else if (MathJaxVersion === 3) {
    setConfig3();
    setRenderer3();
    MathJax.startup.defaultReady();
    MathJax.startup.promise.then(function () {
      initiateMathJax();
      finalizeMathJax();
      resetRenderer3();
      resetConfig3();
    });
  }
}
var TAG_STYLES = {
  // would like to use baseline-shift for sub/sup but FF doesn't support it
  // so we need to use dy along with the uber hacky shift-back-to
  // baseline below
  sup: 'font-size:70%',
  sub: 'font-size:70%',
  b: 'font-weight:bold',
  i: 'font-style:italic',
  a: 'cursor:pointer',
  span: '',
  em: 'font-style:italic;font-weight:bold'
};

// baseline shifts for sub and sup
var SHIFT_DY = {
  sub: '0.3em',
  sup: '-0.6em'
};
// reset baseline by adding a tspan (empty except for a zero-width space)
// with dy of -70% * SHIFT_DY (because font-size=70%)
var RESET_DY = {
  sub: '-0.21em',
  sup: '0.42em'
};
var ZERO_WIDTH_SPACE = '\u200b';

/*
 * Whitelist of protocols in user-supplied urls. Mostly we want to avoid javascript
 * and related attack vectors. The empty items are there for IE, that in various
 * versions treats relative paths as having different flavors of no protocol, while
 * other browsers have these explicitly inherit the protocol of the page they're in.
 */
var PROTOCOLS = ['http:', 'https:', 'mailto:', '', undefined, ':'];
var NEWLINES = exports.NEWLINES = /(\r\n?|\n)/g;
var SPLIT_TAGS = /(<[^<>]*>)/;
var ONE_TAG = /<(\/?)([^ >]*)(\s+(.*))?>/i;
var BR_TAG = /<br(\s+.*)?>/i;
exports.BR_TAG_ALL = /<br(\s+.*)?>/gi;

/*
 * style and href: pull them out of either single or double quotes. Also
 * - target: (_blank|_self|_parent|_top|framename)
 *     note that you can't use target to get a popup but if you use popup,
 *     a `framename` will be passed along as the name of the popup window.
 *     per the spec, cannot contain whitespace.
 *     for backward compatibility we default to '_blank'
 * - popup: a custom one for us to enable popup (new window) links. String
 *     for window.open -> strWindowFeatures, like 'menubar=yes,width=500,height=550'
 *     note that at least in Chrome, you need to give at least one property
 *     in this string or the page will open in a new tab anyway. We follow this
 *     convention and will not make a popup if this string is empty.
 *     per the spec, cannot contain whitespace.
 *
 * Because we hack in other attributes with style (sub & sup), drop any trailing
 * semicolon in user-supplied styles so we can consistently append the tag-dependent style
 *
 * These are for tag attributes; Chrome anyway will convert entities in
 * attribute values, but not in attribute names
 * you can test this by for example:
 * > p = document.createElement('p')
 * > p.innerHTML = '<span styl&#x65;="font-color:r&#x65;d;">Hi</span>'
 * > p.innerHTML
 * <- '<span styl&#x65;="font-color:red;">Hi</span>'
 */
var STYLEMATCH = /(^|[\s"'])style\s*=\s*("([^"]*);?"|'([^']*);?')/i;
var HREFMATCH = /(^|[\s"'])href\s*=\s*("([^"]*)"|'([^']*)')/i;
var TARGETMATCH = /(^|[\s"'])target\s*=\s*("([^"\s]*)"|'([^'\s]*)')/i;
var POPUPMATCH = /(^|[\s"'])popup\s*=\s*("([\w=,]*)"|'([\w=,]*)')/i;

// dedicated matcher for these quoted regexes, that can return their results
// in two different places
function getQuotedMatch(_str, re) {
  if (!_str) return null;
  var match = _str.match(re);
  var result = match && (match[3] || match[4]);
  return result && convertEntities(result);
}
var COLORMATCH = /(^|;)\s*color:/;

/**
 * Strip string of tags
 *
 * @param {string} _str : input string
 * @param {object} opts :
 * - len {number} max length of output string
 * - allowedTags {array} list of pseudo-html tags to NOT strip
 * @return {string}
 */
exports.plainText = function (_str, opts) {
  opts = opts || {};
  var len = opts.len !== undefined && opts.len !== -1 ? opts.len : Infinity;
  var allowedTags = opts.allowedTags !== undefined ? opts.allowedTags : ['br'];
  var ellipsis = '...';
  var eLen = ellipsis.length;
  var oldParts = _str.split(SPLIT_TAGS);
  var newParts = [];
  var prevTag = '';
  var l = 0;
  for (var i = 0; i < oldParts.length; i++) {
    var p = oldParts[i];
    var match = p.match(ONE_TAG);
    var tagType = match && match[2].toLowerCase();
    if (tagType) {
      // N.B. tags do not count towards string length
      if (allowedTags.indexOf(tagType) !== -1) {
        newParts.push(p);
        prevTag = tagType;
      }
    } else {
      var pLen = p.length;
      if (l + pLen < len) {
        newParts.push(p);
        l += pLen;
      } else if (l < len) {
        var pLen2 = len - l;
        if (prevTag && (prevTag !== 'br' || pLen2 <= eLen || pLen <= eLen)) {
          newParts.pop();
        }
        if (len > eLen) {
          newParts.push(p.substr(0, pLen2 - eLen) + ellipsis);
        } else {
          newParts.push(p.substr(0, pLen2));
        }
        break;
      }
      prevTag = '';
    }
  }
  return newParts.join('');
};

/*
 * N.B. HTML entities are listed without the leading '&' and trailing ';'
 * https://www.freeformatter.com/html-entities.html
 *
 * FWIW if we wanted to support the full set, it has 2261 entries:
 * https://www.w3.org/TR/html5/entities.json
 * though I notice that some of these are duplicates and/or are missing ";"
 * eg: "&amp;", "&amp", "&AMP;", and "&AMP" all map to "&"
 * We no longer need to include numeric entities here, these are now handled
 * by String.fromCodePoint/fromCharCode
 *
 * Anyway the only ones that are really important to allow are the HTML special
 * chars <, >, and &, because these ones can trigger special processing if not
 * replaced by the corresponding entity.
 */
var entityToUnicode = {
  mu: 'μ',
  amp: '&',
  lt: '<',
  gt: '>',
  nbsp: ' ',
  times: '×',
  plusmn: '±',
  deg: '°'
};

// NOTE: in general entities can contain uppercase too (so [a-zA-Z]) but all the
// ones we support use only lowercase. If we ever change that, update the regex.
var ENTITY_MATCH = /&(#\d+|#x[\da-fA-F]+|[a-z]+);/g;
function convertEntities(_str) {
  return _str.replace(ENTITY_MATCH, function (fullMatch, innerMatch) {
    var outChar;
    if (innerMatch.charAt(0) === '#') {
      // cannot use String.fromCodePoint in IE
      outChar = fromCodePoint(innerMatch.charAt(1) === 'x' ? parseInt(innerMatch.substr(2), 16) : parseInt(innerMatch.substr(1), 10));
    } else outChar = entityToUnicode[innerMatch];

    // as in regular HTML, if we didn't decode the entity just
    // leave the raw text in place.
    return outChar || fullMatch;
  });
}
exports.convertEntities = convertEntities;
function fromCodePoint(code) {
  // Don't allow overflow. In Chrome this turns into � but I feel like it's
  // more useful to just not convert it at all.
  if (code > 0x10FFFF) return;
  var stringFromCodePoint = String.fromCodePoint;
  if (stringFromCodePoint) return stringFromCodePoint(code);

  // IE doesn't have String.fromCodePoint
  // see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/fromCodePoint
  var stringFromCharCode = String.fromCharCode;
  if (code <= 0xFFFF) return stringFromCharCode(code);
  return stringFromCharCode((code >> 10) + 0xD7C0, code % 0x400 + 0xDC00);
}

/*
 * buildSVGText: convert our pseudo-html into SVG tspan elements, and attach these
 * to containerNode
 *
 * @param {svg text element} containerNode: the <text> node to insert this text into
 * @param {string} str: the pseudo-html string to convert to svg
 *
 * @returns {bool}: does the result contain any links? We need to handle the text element
 *   somewhat differently if it does, so just keep track of this when it happens.
 */
function buildSVGText(containerNode, str) {
  /*
   * Normalize behavior between IE and others wrt newlines and whitespace:pre
   * this combination makes IE barf https://github.com/plotly/plotly.js/issues/746
   * Chrome and FF display \n, \r, or \r\n as a space in this mode.
   * I feel like at some point we turned these into <br> but currently we don't so
   * I'm just going to cement what we do now in Chrome and FF
   */
  str = str.replace(NEWLINES, ' ');
  var hasLink = false;

  // as we're building the text, keep track of what elements we're nested inside
  // nodeStack will be an array of {node, type, style, href, target, popup}
  // where only type: 'a' gets the last 3 and node is only added when it's created
  var nodeStack = [];
  var currentNode;
  var currentLine = -1;
  function newLine() {
    currentLine++;
    var lineNode = document.createElementNS(xmlnsNamespaces.svg, 'tspan');
    d3.select(lineNode).attr({
      class: 'line',
      dy: currentLine * LINE_SPACING + 'em'
    });
    containerNode.appendChild(lineNode);
    currentNode = lineNode;
    var oldNodeStack = nodeStack;
    nodeStack = [{
      node: lineNode
    }];
    if (oldNodeStack.length > 1) {
      for (var i = 1; i < oldNodeStack.length; i++) {
        enterNode(oldNodeStack[i]);
      }
    }
  }
  function enterNode(nodeSpec) {
    var type = nodeSpec.type;
    var nodeAttrs = {};
    var nodeType;
    if (type === 'a') {
      nodeType = 'a';
      var target = nodeSpec.target;
      var href = nodeSpec.href;
      var popup = nodeSpec.popup;
      if (href) {
        nodeAttrs = {
          'xlink:xlink:show': target === '_blank' || target.charAt(0) !== '_' ? 'new' : 'replace',
          target: target,
          'xlink:xlink:href': href
        };
        if (popup) {
          // security: href and target are not inserted as code but
          // as attributes. popup is, but limited to /[A-Za-z0-9_=,]/
          nodeAttrs.onclick = 'window.open(this.href.baseVal,this.target.baseVal,"' + popup + '");return false;';
        }
      }
    } else nodeType = 'tspan';
    if (nodeSpec.style) nodeAttrs.style = nodeSpec.style;
    var newNode = document.createElementNS(xmlnsNamespaces.svg, nodeType);
    if (type === 'sup' || type === 'sub') {
      addTextNode(currentNode, ZERO_WIDTH_SPACE);
      currentNode.appendChild(newNode);
      var resetter = document.createElementNS(xmlnsNamespaces.svg, 'tspan');
      addTextNode(resetter, ZERO_WIDTH_SPACE);
      d3.select(resetter).attr('dy', RESET_DY[type]);
      nodeAttrs.dy = SHIFT_DY[type];
      currentNode.appendChild(newNode);
      currentNode.appendChild(resetter);
    } else {
      currentNode.appendChild(newNode);
    }
    d3.select(newNode).attr(nodeAttrs);
    currentNode = nodeSpec.node = newNode;
    nodeStack.push(nodeSpec);
  }
  function addTextNode(node, text) {
    node.appendChild(document.createTextNode(text));
  }
  function exitNode(type) {
    // A bare closing tag can't close the root node. If we encounter this it
    // means there's an extra closing tag that can just be ignored:
    if (nodeStack.length === 1) {
      Lib.log('Ignoring unexpected end tag </' + type + '>.', str);
      return;
    }
    var innerNode = nodeStack.pop();
    if (type !== innerNode.type) {
      Lib.log('Start tag <' + innerNode.type + '> doesnt match end tag <' + type + '>. Pretending it did match.', str);
    }
    currentNode = nodeStack[nodeStack.length - 1].node;
  }
  var hasLines = BR_TAG.test(str);
  if (hasLines) newLine();else {
    currentNode = containerNode;
    nodeStack = [{
      node: containerNode
    }];
  }
  var parts = str.split(SPLIT_TAGS);
  for (var i = 0; i < parts.length; i++) {
    var parti = parts[i];
    var match = parti.match(ONE_TAG);
    var tagType = match && match[2].toLowerCase();
    var tagStyle = TAG_STYLES[tagType];
    if (tagType === 'br') {
      newLine();
    } else if (tagStyle === undefined) {
      addTextNode(currentNode, convertEntities(parti));
    } else {
      // tag - open or close
      if (match[1]) {
        exitNode(tagType);
      } else {
        var extra = match[4];
        var nodeSpec = {
          type: tagType
        };

        // now add style, from both the tag name and any extra css
        // Most of the svg css that users will care about is just like html,
        // but font color is different (uses fill). Let our users ignore this.
        var css = getQuotedMatch(extra, STYLEMATCH);
        if (css) {
          css = css.replace(COLORMATCH, '$1 fill:');
          if (tagStyle) css += ';' + tagStyle;
        } else if (tagStyle) css = tagStyle;
        if (css) nodeSpec.style = css;
        if (tagType === 'a') {
          hasLink = true;
          var href = getQuotedMatch(extra, HREFMATCH);
          if (href) {
            var safeHref = sanitizeHref(href);
            if (safeHref) {
              nodeSpec.href = safeHref;
              nodeSpec.target = getQuotedMatch(extra, TARGETMATCH) || '_blank';
              nodeSpec.popup = getQuotedMatch(extra, POPUPMATCH);
            }
          }
        }
        enterNode(nodeSpec);
      }
    }
  }
  return hasLink;
}
function sanitizeHref(href) {
  var decodedHref = encodeURI(decodeURI(href));
  var dummyAnchor1 = document.createElement('a');
  var dummyAnchor2 = document.createElement('a');
  dummyAnchor1.href = href;
  dummyAnchor2.href = decodedHref;
  var p1 = dummyAnchor1.protocol;
  var p2 = dummyAnchor2.protocol;

  // check safe protocols
  if (PROTOCOLS.indexOf(p1) !== -1 && PROTOCOLS.indexOf(p2) !== -1) {
    return decodedHref;
  } else {
    return '';
  }
}

/*
 * sanitizeHTML: port of buildSVGText aimed at providing a clean subset of HTML
 * @param {string} str: the html string to clean
 * @returns {string}: a cleaned and normalized version of the input,
 *     supporting only a small subset of html
 */
exports.sanitizeHTML = function sanitizeHTML(str) {
  str = str.replace(NEWLINES, ' ');
  var rootNode = document.createElement('p');
  var currentNode = rootNode;
  var nodeStack = [];
  var parts = str.split(SPLIT_TAGS);
  for (var i = 0; i < parts.length; i++) {
    var parti = parts[i];
    var match = parti.match(ONE_TAG);
    var tagType = match && match[2].toLowerCase();
    if (tagType in TAG_STYLES) {
      if (match[1]) {
        if (nodeStack.length) {
          currentNode = nodeStack.pop();
        }
      } else {
        var extra = match[4];
        var css = getQuotedMatch(extra, STYLEMATCH);
        var nodeAttrs = css ? {
          style: css
        } : {};
        if (tagType === 'a') {
          var href = getQuotedMatch(extra, HREFMATCH);
          if (href) {
            var safeHref = sanitizeHref(href);
            if (safeHref) {
              nodeAttrs.href = safeHref;
              var target = getQuotedMatch(extra, TARGETMATCH);
              if (target) {
                nodeAttrs.target = target;
              }
            }
          }
        }
        var newNode = document.createElement(tagType);
        currentNode.appendChild(newNode);
        d3.select(newNode).attr(nodeAttrs);
        currentNode = newNode;
        nodeStack.push(newNode);
      }
    } else {
      currentNode.appendChild(document.createTextNode(convertEntities(parti)));
    }
  }
  var key = 'innerHTML'; // i.e. to avoid pass test-syntax
  return rootNode[key];
};
exports.lineCount = function lineCount(s) {
  return s.selectAll('tspan.line').size() || 1;
};
exports.positionText = function positionText(s, x, y) {
  return s.each(function () {
    var text = d3.select(this);
    function setOrGet(attr, val) {
      if (val === undefined) {
        val = text.attr(attr);
        if (val === null) {
          text.attr(attr, 0);
          val = 0;
        }
      } else text.attr(attr, val);
      return val;
    }
    var thisX = setOrGet('x', x);
    var thisY = setOrGet('y', y);
    if (this.nodeName === 'text') {
      text.selectAll('tspan.line').attr({
        x: thisX,
        y: thisY
      });
    }
  });
};
function alignHTMLWith(_base, container, options) {
  var alignH = options.horizontalAlign;
  var alignV = options.verticalAlign || 'top';
  var bRect = _base.node().getBoundingClientRect();
  var cRect = container.node().getBoundingClientRect();
  var thisRect;
  var getTop;
  var getLeft;
  if (alignV === 'bottom') {
    getTop = function () {
      return bRect.bottom - thisRect.height;
    };
  } else if (alignV === 'middle') {
    getTop = function () {
      return bRect.top + (bRect.height - thisRect.height) / 2;
    };
  } else {
    // default: top
    getTop = function () {
      return bRect.top;
    };
  }
  if (alignH === 'right') {
    getLeft = function () {
      return bRect.right - thisRect.width;
    };
  } else if (alignH === 'center') {
    getLeft = function () {
      return bRect.left + (bRect.width - thisRect.width) / 2;
    };
  } else {
    // default: left
    getLeft = function () {
      return bRect.left;
    };
  }
  return function () {
    thisRect = this.node().getBoundingClientRect();
    var x0 = getLeft() - cRect.left;
    var y0 = getTop() - cRect.top;
    var gd = options.gd || {};
    if (options.gd) {
      gd._fullLayout._calcInverseTransform(gd);
      var transformedCoords = Lib.apply3DTransform(gd._fullLayout._invTransform)(x0, y0);
      x0 = transformedCoords[0];
      y0 = transformedCoords[1];
    }
    this.style({
      top: y0 + 'px',
      left: x0 + 'px',
      'z-index': 1000
    });
    return this;
  };
}
var onePx = '1px ';
exports.makeTextShadow = function (color) {
  var x = onePx;
  var y = onePx;
  var b = onePx;
  return x + y + b + color + ', ' + '-' + x + '-' + y + b + color + ', ' + x + '-' + y + b + color + ', ' + '-' + x + y + b + color;
};

/*
 * Editable title
 * @param {d3.selection} context: the element being edited. Normally text,
 *   but if it isn't, you should provide the styling options
 * @param {object} options:
 *   @param {div} options.gd: graphDiv
 *   @param {d3.selection} options.delegate: item to bind events to if not this
 *   @param {boolean} options.immediate: start editing now (true) or on click (false, default)
 *   @param {string} options.fill: font color if not as shown
 *   @param {string} options.background: background color if not as shown
 *   @param {string} options.text: initial text, if not as shown
 *   @param {string} options.horizontalAlign: alignment of the edit box wrt. the bound element
 *   @param {string} options.verticalAlign: alignment of the edit box wrt. the bound element
 */

exports.makeEditable = function (context, options) {
  var gd = options.gd;
  var _delegate = options.delegate;
  var dispatch = d3.dispatch('edit', 'input', 'cancel');
  var handlerElement = _delegate || context;
  context.style({
    'pointer-events': _delegate ? 'none' : 'all'
  });
  if (context.size() !== 1) throw new Error('boo');
  function handleClick() {
    appendEditable();
    context.style({
      opacity: 0
    });
    // also hide any mathjax svg
    var svgClass = handlerElement.attr('class');
    var mathjaxClass;
    if (svgClass) mathjaxClass = '.' + svgClass.split(' ')[0] + '-math-group';else mathjaxClass = '[class*=-math-group]';
    if (mathjaxClass) {
      d3.select(context.node().parentNode).select(mathjaxClass).style({
        opacity: 0
      });
    }
  }
  function selectElementContents(_el) {
    var el = _el.node();
    var range = document.createRange();
    range.selectNodeContents(el);
    var sel = window.getSelection();
    sel.removeAllRanges();
    sel.addRange(range);
    el.focus();
  }
  function appendEditable() {
    var plotDiv = d3.select(gd);
    var container = plotDiv.select('.svg-container');
    var div = container.append('div');
    var cStyle = context.node().style;
    var fontSize = parseFloat(cStyle.fontSize || 12);
    var initialText = options.text;
    if (initialText === undefined) initialText = context.attr('data-unformatted');
    div.classed('plugin-editable editable', true).style({
      position: 'absolute',
      'font-family': cStyle.fontFamily || 'Arial',
      'font-size': fontSize,
      color: options.fill || cStyle.fill || 'black',
      opacity: 1,
      'background-color': options.background || 'transparent',
      outline: '#ffffff33 1px solid',
      margin: [-fontSize / 8 + 1, 0, 0, -1].join('px ') + 'px',
      padding: '0',
      'box-sizing': 'border-box'
    }).attr({
      contenteditable: true
    }).text(initialText).call(alignHTMLWith(context, container, options)).on('blur', function () {
      gd._editing = false;
      context.text(this.textContent).style({
        opacity: 1
      });
      var svgClass = d3.select(this).attr('class');
      var mathjaxClass;
      if (svgClass) mathjaxClass = '.' + svgClass.split(' ')[0] + '-math-group';else mathjaxClass = '[class*=-math-group]';
      if (mathjaxClass) {
        d3.select(context.node().parentNode).select(mathjaxClass).style({
          opacity: 0
        });
      }
      var text = this.textContent;
      d3.select(this).transition().duration(0).remove();
      d3.select(document).on('mouseup', null);
      dispatch.edit.call(context, text);
    }).on('focus', function () {
      var editDiv = this;
      gd._editing = true;
      d3.select(document).on('mouseup', function () {
        if (d3.event.target === editDiv) return false;
        if (document.activeElement === div.node()) div.node().blur();
      });
    }).on('keyup', function () {
      if (d3.event.which === 27) {
        gd._editing = false;
        context.style({
          opacity: 1
        });
        d3.select(this).style({
          opacity: 0
        }).on('blur', function () {
          return false;
        }).transition().remove();
        dispatch.cancel.call(context, this.textContent);
      } else {
        dispatch.input.call(context, this.textContent);
        d3.select(this).call(alignHTMLWith(context, container, options));
      }
    }).on('keydown', function () {
      if (d3.event.which === 13) this.blur();
    }).call(selectElementContents);
  }
  if (options.immediate) handleClick();else handlerElement.on('click', handleClick);
  return d3.rebind(context, dispatch, 'on');
};

/***/ }),

/***/ 1200:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


var timerCache = {};

/**
 * Throttle a callback. `callback` executes synchronously only if
 * more than `minInterval` milliseconds have already elapsed since the latest
 * call (if any). Otherwise we wait until `minInterval` is over and execute the
 * last callback received while waiting.
 * So the first and last events in a train are always executed (eventually)
 * but some of the events in the middle can be dropped.
 *
 * @param {string} id: an identifier to mark events to throttle together
 * @param {number} minInterval: minimum time, in milliseconds, between
 *   invocations of `callback`
 * @param {function} callback: the function to throttle. `callback` itself
 *   should be a purely synchronous function.
 */
exports.throttle = function throttle(id, minInterval, callback) {
  var cache = timerCache[id];
  var now = Date.now();
  if (!cache) {
    /*
     * Throw out old items before making a new one, to prevent the cache
     * getting overgrown, for example from old plots that have been replaced.
     * 1 minute age is arbitrary.
     */
    for (var idi in timerCache) {
      if (timerCache[idi].ts < now - 60000) {
        delete timerCache[idi];
      }
    }
    cache = timerCache[id] = {
      ts: 0,
      timer: null
    };
  }
  _clearTimeout(cache);
  function exec() {
    callback();
    cache.ts = Date.now();
    if (cache.onDone) {
      cache.onDone();
      cache.onDone = null;
    }
  }
  if (now > cache.ts + minInterval) {
    exec();
    return;
  }
  cache.timer = setTimeout(function () {
    exec();
    cache.timer = null;
  }, minInterval);
};
exports.done = function (id) {
  var cache = timerCache[id];
  if (!cache || !cache.timer) return Promise.resolve();
  return new Promise(function (resolve) {
    var previousOnDone = cache.onDone;
    cache.onDone = function onDone() {
      if (previousOnDone) previousOnDone();
      resolve();
      cache.onDone = null;
    };
  });
};

/**
 * Clear the throttle cache for one or all timers
 * @param {optional string} id:
 *   if provided, clear just this timer
 *   if omitted, clear all timers (mainly useful for testing)
 */
exports.clear = function (id) {
  if (id) {
    _clearTimeout(timerCache[id]);
    delete timerCache[id];
  } else {
    for (var idi in timerCache) exports.clear(idi);
  }
};
function _clearTimeout(cache) {
  if (cache && cache.timer !== null) {
    clearTimeout(cache.timer);
    cache.timer = null;
  }
}

/***/ }),

/***/ 6896:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isNumeric = __webpack_require__(8248);

/**
 * convert a linear value into a logged value, folding negative numbers into
 * the given range
 */
module.exports = function toLogRange(val, range) {
  if (val > 0) return Math.log(val) / Math.LN10;

  // move a negative value reference to a log axis - just put the
  // result at the lowest range value on the plot (or if the range also went negative,
  // one millionth of the top of the range)
  var newVal = Math.log(Math.min(range[0], range[1])) / Math.LN10;
  if (!isNumeric(newVal)) newVal = Math.log(Math.max(range[0], range[1])) / Math.LN10 - 6;
  return newVal;
};

/***/ }),

/***/ 9972:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var topojsonUtils = module.exports = {};
var locationmodeToLayer = (__webpack_require__(9552).locationmodeToLayer);
var topojsonFeature = (__webpack_require__(5712)/* .feature */ .NO);
topojsonUtils.getTopojsonName = function (geoLayout) {
  return [geoLayout.scope.replace(/ /g, '-'), '_', geoLayout.resolution.toString(), 'm'].join('');
};
topojsonUtils.getTopojsonPath = function (topojsonURL, topojsonName) {
  return topojsonURL + topojsonName + '.json';
};
topojsonUtils.getTopojsonFeatures = function (trace, topojson) {
  var layer = locationmodeToLayer[trace.locationmode];
  var obj = topojson.objects[layer];
  return topojsonFeature(topojson, obj).features;
};

/***/ }),

/***/ 1680:
/***/ (function(module) {

"use strict";


module.exports = {
  moduleType: 'locale',
  name: 'en-US',
  dictionary: {
    'Click to enter Colorscale title': 'Click to enter Colorscale title'
  },
  format: {
    date: '%m/%d/%Y'
  }
};

/***/ }),

/***/ 6580:
/***/ (function(module) {

"use strict";


module.exports = {
  moduleType: 'locale',
  name: 'en',
  dictionary: {
    'Click to enter Colorscale title': 'Click to enter Colourscale title'
  },
  format: {
    days: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
    shortDays: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
    months: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
    shortMonths: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
    periods: ['AM', 'PM'],
    dateTime: '%a %b %e %X %Y',
    date: '%d/%m/%Y',
    time: '%H:%M:%S',
    decimal: '.',
    thousands: ',',
    grouping: [3],
    currency: ['$', ''],
    year: '%Y',
    month: '%b %Y',
    dayMonth: '%b %-d',
    dayMonthYear: '%b %-d, %Y'
  }
};

/***/ }),

/***/ 9820:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var Registry = __webpack_require__(4040);

/*
 * containerArrayMatch: does this attribute string point into a
 * layout container array?
 *
 * @param {String} astr: an attribute string, like *annotations[2].text*
 *
 * @returns {Object | false} Returns false if `astr` doesn't match a container
 *  array. If it does, returns:
 *     {array: {String}, index: {Number}, property: {String}}
 *  ie the attribute string for the array, the index within the array (or ''
 *  if the whole array) and the property within that (or '' if the whole array
 *  or the whole object)
 */
module.exports = function containerArrayMatch(astr) {
  var rootContainers = Registry.layoutArrayContainers;
  var regexpContainers = Registry.layoutArrayRegexes;
  var rootPart = astr.split('[')[0];
  var arrayStr;
  var match;

  // look for regexp matches first, because they may be nested inside root matches
  // eg updatemenus[i].buttons is nested inside updatemenus
  for (var i = 0; i < regexpContainers.length; i++) {
    match = astr.match(regexpContainers[i]);
    if (match && match.index === 0) {
      arrayStr = match[0];
      break;
    }
  }

  // now look for root matches
  if (!arrayStr) arrayStr = rootContainers[rootContainers.indexOf(rootPart)];
  if (!arrayStr) return false;
  var tail = astr.substr(arrayStr.length);
  if (!tail) return {
    array: arrayStr,
    index: '',
    property: ''
  };
  match = tail.match(/^\[(0|[1-9][0-9]*)\](\.(.+))?$/);
  if (!match) return false;
  return {
    array: arrayStr,
    index: Number(match[1]),
    property: match[3] || ''
  };
};

/***/ }),

/***/ 7824:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var extendFlat = (__webpack_require__(2880).extendFlat);
var isPlainObject = __webpack_require__(3620);
var traceOpts = {
  valType: 'flaglist',
  extras: ['none'],
  flags: ['calc', 'clearAxisTypes', 'plot', 'style', 'markerSize', 'colorbars']
};
var layoutOpts = {
  valType: 'flaglist',
  extras: ['none'],
  flags: ['calc', 'plot', 'legend', 'ticks', 'axrange', 'layoutstyle', 'modebar', 'camera', 'arraydraw', 'colorbars']
};

// flags for inside restyle/relayout include a few extras
// that shouldn't be used in attributes, to deal with certain
// combinations and conditionals efficiently
var traceEditTypeFlags = traceOpts.flags.slice().concat(['fullReplot']);
var layoutEditTypeFlags = layoutOpts.flags.slice().concat('layoutReplot');
module.exports = {
  traces: traceOpts,
  layout: layoutOpts,
  /*
   * default (all false) edit flags for restyle (traces)
   * creates a new object each call, so the caller can mutate freely
   */
  traceFlags: function () {
    return falseObj(traceEditTypeFlags);
  },
  /*
   * default (all false) edit flags for relayout
   * creates a new object each call, so the caller can mutate freely
   */
  layoutFlags: function () {
    return falseObj(layoutEditTypeFlags);
  },
  /*
   * update `flags` with the `editType` values found in `attr`
   */
  update: function (flags, attr) {
    var editType = attr.editType;
    if (editType && editType !== 'none') {
      var editTypeParts = editType.split('+');
      for (var i = 0; i < editTypeParts.length; i++) {
        flags[editTypeParts[i]] = true;
      }
    }
  },
  overrideAll: overrideAll
};
function falseObj(keys) {
  var out = {};
  for (var i = 0; i < keys.length; i++) out[keys[i]] = false;
  return out;
}

/**
 * For attributes that are largely copied from elsewhere into a plot type that doesn't
 * support partial redraws - overrides the editType field of all attributes in the object
 *
 * @param {object} attrs: the attributes to override. Will not be mutated.
 * @param {string} editTypeOverride: the new editType to use
 * @param {'nested'|'from-root'} overrideContainers:
 *   - 'nested' will override editType for nested containers but not the root.
 *   - 'from-root' will also override editType of the root container.
 *   Containers below the absolute top level (trace or layout root) 