import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [account](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsaccounts.html).
 *
 * @experimental
 */
export declare class Account extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to disable a region.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetRegion()
     *
     * @experimental
     */
    toDisableRegion(): this;
    /**
     * (experimental) Grants permission to enable a region.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetRegion()
     *
     * @experimental
     */
    toEnableRegion(): this;
    /**
     * (experimental) Grants permission to list regions.
     *
     * Access Level: List
     *
     * @experimental
     */
    toListRegions(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Filters access by a list of regions.
     *
     * Applies to actions:
     * - .toDisableRegion()
     * - .toEnableRegion()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifTargetRegion(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Statement provider for service [account](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsaccounts.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
