import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [es](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonelasticsearchservice.html).
 *
 * @experimental
 */
export declare class Es extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to the destination domain owner to accept an inbound cross-cluster search connection request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-acceptinboundcrossclustersearchconnection
     *
     * @experimental
     */
    toAcceptInboundCrossClusterSearchConnection(): this;
    /**
     * (experimental) Grants permission to attach resource tags to an Amazon ES domain.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-addtags
     *
     * @experimental
     */
    toAddTags(): this;
    /**
     * (experimental) Grants permission to associate a package with an Amazon ES domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-associatepackage
     *
     * @experimental
     */
    toAssociatePackage(): this;
    /**
     * (experimental) Grants permission to cancel elastic search software update of a domain to given version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-stopupdate
     *
     * @experimental
     */
    toCancelElasticsearchServiceSoftwareUpdate(): this;
    /**
     * (experimental) Grants permission to create an Amazon ES domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-createelasticsearchdomain
     *
     * @experimental
     */
    toCreateElasticsearchDomain(): this;
    /**
     * (experimental) Grants permission to create the service-linked role required for Amazon ES domains that use VPC access.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-createelasticsearchservicerole
     *
     * @experimental
     */
    toCreateElasticsearchServiceRole(): this;
    /**
     * (experimental) Grants permission to create a new cross-cluster search connection from a source domain to a destination domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-createoutboundcrossclustersearchconnection
     *
     * @experimental
     */
    toCreateOutboundCrossClusterSearchConnection(): this;
    /**
     * (experimental) Grants permission to add a package for use with Amazon ES domains.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-createpackage
     *
     * @experimental
     */
    toCreatePackage(): this;
    /**
     * (experimental) Grants permission to delete an Amazon ES domain and all of its data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-deleteelasticsearchdomain
     *
     * @experimental
     */
    toDeleteElasticsearchDomain(): this;
    /**
     * (experimental) Grants permission to delete the service-linked role required for Amazon ES domains that use VPC access.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-deleteelasticsearchservicerole
     *
     * @experimental
     */
    toDeleteElasticsearchServiceRole(): this;
    /**
     * (experimental) Grants permission to the destination domain owner to delete an existing inbound cross-cluster search connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-deleteinboundcrossclustersearchconnection
     *
     * @experimental
     */
    toDeleteInboundCrossClusterSearchConnection(): this;
    /**
     * (experimental) Grants permission to the source domain owner to delete an existing outbound cross-cluster search connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-deleteoutboundcrossclustersearchconnection
     *
     * @experimental
     */
    toDeleteOutboundCrossClusterSearchConnection(): this;
    /**
     * (experimental) Grants permission to delete a package from Amazon ES.
     *
     * The package must not be associated with any Amazon ES domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-deletepackage
     *
     * @experimental
     */
    toDeletePackage(): this;
    /**
     * (experimental) Grants permission to view a description of the domain configuration for the specified Amazon ES domain, including the domain ID, domain service endpoint, and domain ARN.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-describeelasticsearchdomain
     *
     * @experimental
     */
    toDescribeElasticsearchDomain(): this;
    /**
     * (experimental) Grants permission to view a description of the configuration options and status of an Amazon ES domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-describeelasticsearchdomainconfig
     *
     * @experimental
     */
    toDescribeElasticsearchDomainConfig(): this;
    /**
     * (experimental) Grants permission to view a description of the domain configuration for up to five specified Amazon ES domains.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-describeelasticsearchdomain
     *
     * @experimental
     */
    toDescribeElasticsearchDomains(): this;
    /**
     * (experimental) Grants permission to view the instance count, storage, and master node limits for a given Elasticsearch version and instance type.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-describeinstancetypelimits
     *
     * @experimental
     */
    toDescribeElasticsearchInstanceTypeLimits(): this;
    /**
     * (experimental) Grants permission to list all the inbound cross-cluster search connections for a destination domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-describeinboundcrossclustersearchconnections
     *
     * @experimental
     */
    toDescribeInboundCrossClusterSearchConnections(): this;
    /**
     * (experimental) Grants permission to list all the outbound cross-cluster search connections for a source domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-describeoutboundcrossclustersearchconnections
     *
     * @experimental
     */
    toDescribeOutboundCrossClusterSearchConnections(): this;
    /**
     * (experimental) Grants permission to describe all packages available to Amazon ES domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-describepackages
     *
     * @experimental
     */
    toDescribePackages(): this;
    /**
     * (experimental) Grants permission to fetch reserved instance offerings for ES.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-describereservedelasticsearchinstanceofferings
     *
     * @experimental
     */
    toDescribeReservedElasticsearchInstanceOfferings(): this;
    /**
     * (experimental) Grants permission to fetch ES reserved instances already purchased by customer.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-describereservedelasticsearchinstances
     *
     * @experimental
     */
    toDescribeReservedElasticsearchInstances(): this;
    /**
     * (experimental) Grants permission to remove a package from the specified Amazon ES domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-dissociatepackage
     *
     * @experimental
     */
    toDissociatePackage(): this;
    /**
     * (experimental) Grants permission to send cross-cluster requests to a destination domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-ac.html#es-ac-reference
     *
     * @experimental
     */
    toESCrossClusterGet(): this;
    /**
     * (experimental) Grants permission to send HTTP DELETE requests to the Elasticsearch APIs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-ac.html#es-ac-reference
     *
     * @experimental
     */
    toESHttpDelete(): this;
    /**
     * (experimental) Grants permission to send HTTP GET requests to the Elasticsearch APIs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-ac.html#es-ac-reference
     *
     * @experimental
     */
    toESHttpGet(): this;
    /**
     * (experimental) Grants permission to send HTTP HEAD requests to the Elasticsearch APIs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-ac.html#es-ac-reference
     *
     * @experimental
     */
    toESHttpHead(): this;
    /**
     * (experimental) Grants permission to send HTTP PATCH requests to the Elasticsearch APIs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-ac.html#es-ac-reference
     *
     * @experimental
     */
    toESHttpPatch(): this;
    /**
     * (experimental) Grants permission to send HTTP POST requests to the Elasticsearch APIs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-ac.html#es-ac-reference
     *
     * @experimental
     */
    toESHttpPost(): this;
    /**
     * (experimental) Grants permission to send HTTP PUT requests to the Elasticsearch APIs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-ac.html#es-ac-reference
     *
     * @experimental
     */
    toESHttpPut(): this;
    /**
     * (experimental) Grants permission to fetch list of compatible elastic search versions to which Amazon ES domain can be upgraded.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-getcompatibleelasticsearchversions
     *
     * @experimental
     */
    toGetCompatibleElasticsearchVersions(): this;
    /**
     * (experimental) Grants permission to fetch the version history for a package.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-get-pac-ver-hist
     *
     * @experimental
     */
    toGetPackageVersionHistory(): this;
    /**
     * (experimental) Grants permission to fetch upgrade history for given ES domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-getupgradehistory
     *
     * @experimental
     */
    toGetUpgradeHistory(): this;
    /**
     * (experimental) Grants permission to fetch upgrade status for given ES domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-getupgradestatus
     *
     * @experimental
     */
    toGetUpgradeStatus(): this;
    /**
     * (experimental) Grants permission to display the names of all Amazon ES domains that the current user owns.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-listdomainnames
     *
     * @experimental
     */
    toListDomainNames(): this;
    /**
     * (experimental) Grants permission to list all Amazon ES domains that a package is associated with.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-listdomainsforpackage
     *
     * @experimental
     */
    toListDomainsForPackage(): this;
    /**
     * (experimental) Grants permission to list all instance types and available features for a given Elasticsearch version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-listelasticsearchinstancetypedetails
     *
     * @experimental
     */
    toListElasticsearchInstanceTypeDetails(): this;
    /**
     * (experimental) Grants permission to list all Elasticsearch instance types that are supported for a given Elasticsearch version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-listelasticsearchinstancetypes
     *
     * @experimental
     */
    toListElasticsearchInstanceTypes(): this;
    /**
     * (experimental) Grants permission to list all supported Elasticsearch versions on Amazon ES.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-listelasticsearchversions
     *
     * @experimental
     */
    toListElasticsearchVersions(): this;
    /**
     * (experimental) Grants permission to list all packages associated with the Amazon ES domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-listpackagesfordomain
     *
     * @experimental
     */
    toListPackagesForDomain(): this;
    /**
     * (experimental) Grants permission to display all of the tags for an Amazon ES domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-listtags
     *
     * @experimental
     */
    toListTags(): this;
    /**
     * (experimental) Grants permission to purchase ES reserved instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-purchasereservedelasticsearchinstance
     *
     * @experimental
     */
    toPurchaseReservedElasticsearchInstanceOffering(): this;
    /**
     * (experimental) Grants permission to the destination domain owner to reject an inbound cross-cluster search connection request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-rejectinboundcrossclustersearchconnection
     *
     * @experimental
     */
    toRejectInboundCrossClusterSearchConnection(): this;
    /**
     * (experimental) Grants permission to remove tags from Amazon ES domains.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-listtags
     *
     * @experimental
     */
    toRemoveTags(): this;
    /**
     * (experimental) Grants permission to start elastic search software update of a domain to given version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-startupdate
     *
     * @experimental
     */
    toStartElasticsearchServiceSoftwareUpdate(): this;
    /**
     * (experimental) Grants permission to modify the configuration of an Amazon ES domain, such as the instance type or number of instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-updateelasticsearchdomainconfig
     *
     * @experimental
     */
    toUpdateElasticsearchDomainConfig(): this;
    /**
     * (experimental) Grants permission to update a package for use with Amazon ES domains.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-updatepackage
     *
     * @experimental
     */
    toUpdatePackage(): this;
    /**
     * (experimental) Grants permission to initiate upgrade of elastic search domain to given version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-api.html#es-configuration-api-actions-upgradeelasticsearchdomain
     *
     * @experimental
     */
    toUpgradeElasticsearchDomain(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type domain to the statement.
     *
     * https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-ac.html
     *
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDomain(domainName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [es](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonelasticsearchservice.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
