import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [opsworks-cm](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsopsworksconfigurationmanagement.html).
 *
 * @experimental
 */
export declare class OpsworksCm extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to associate a node to a configuration management server.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_AssociateNode.html
     *
     * @experimental
     */
    toAssociateNode(): this;
    /**
     * (experimental) Grants permission to create a backup for the specified server.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_CreateBackup.html
     *
     * @experimental
     */
    toCreateBackup(): this;
    /**
     * (experimental) Grants permission to create a new server.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_CreateServer.html
     *
     * @experimental
     */
    toCreateServer(): this;
    /**
     * (experimental) Grants permission to delete the specified backup and possibly its S3 bucket.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DeleteBackup.html
     *
     * @experimental
     */
    toDeleteBackup(): this;
    /**
     * (experimental) Grants permission to delete the specified server with its corresponding CloudFormation stack and possibly the S3 bucket.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DeleteServer.html
     *
     * @experimental
     */
    toDeleteServer(): this;
    /**
     * (experimental) Grants permission to describe the service limits for the user's account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeAccountAttributes.html
     *
     * @experimental
     */
    toDescribeAccountAttributes(): this;
    /**
     * (experimental) Grants permission to describe a single backup, all backups of a specified server or all backups of the user's account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeBackups.html
     *
     * @experimental
     */
    toDescribeBackups(): this;
    /**
     * (experimental) Grants permission to describe all events of the specified server.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeEvents.html
     *
     * @experimental
     */
    toDescribeEvents(): this;
    /**
     * (experimental) Grants permission to describe the association status for the specified node token and the specified server.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeNodeAssociationStatus.html
     *
     * @experimental
     */
    toDescribeNodeAssociationStatus(): this;
    /**
     * (experimental) Grants permission to describe the specified server or all servers of the user's account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeServers.html
     *
     * @experimental
     */
    toDescribeServers(): this;
    /**
     * (experimental) Grants permission to disassociate a specified node from a server.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DisassociateNode.html
     *
     * @experimental
     */
    toDisassociateNode(): this;
    /**
     * (experimental) Grants permission to export an engine attribute from a server.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_ExportServerEngineAttribute.html
     *
     * @experimental
     */
    toExportServerEngineAttribute(): this;
    /**
     * (experimental) Grants permission to list the tags that are applied to the specified server or backup.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to apply a backup to specified server. Possibly swaps out the ec2-instance if specified.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_RestoreServer.html
     *
     * @experimental
     */
    toRestoreServer(): this;
    /**
     * (experimental) Grants permission to start the server maintenance immediately.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_StartMaintenance.html
     *
     * @experimental
     */
    toStartMaintenance(): this;
    /**
     * (experimental) Grants permission to apply tags to the specified server or backup.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from the specified server or backup.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update general server settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_UpdateServer.html
     *
     * @experimental
     */
    toUpdateServer(): this;
    /**
     * (experimental) Grants permission to update server settings specific to the configuration management type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_UpdateServerEngineAttributes.html
     *
     * @experimental
     */
    toUpdateServerEngineAttributes(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type server to the statement.
     *
     * @param serverName - Identifier for the serverName.
     * @param uniqueId - Identifier for the uniqueId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onServer(serverName: string, uniqueId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type backup to the statement.
     *
     * @param serverName - Identifier for the serverName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onBackup(serverName: string, account?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [opsworks-cm](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsopsworksconfigurationmanagement.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
