"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithCDKPrincipal = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// @ts-ignore only available after swapping 1-base
const iam = require("@aws-cdk/aws-iam");
const _6_principals_1 = require("./6-principals");
/**
 * (experimental) Adds CDK specific "principal" functionality to the Policy Statement.
 *
 * @experimental
 */
class PolicyStatementWithCDKPrincipal extends _6_principals_1.PolicyStatementWithPrincipal {
    constructor() {
        super(...arguments);
        /**
         * @experimental
         */
        this.cdkPrincipals = [];
        this.cdkPrincipalsApplied = false;
    }
    /**
     * (experimental) Adds any number of CDK principals to the statement.
     *
     * @param principals Principals to add to the statement.
     * @experimental
     */
    forCdkPrincipal(...principals) {
        this.skipAutoResource = true;
        this.cdkPrincipals.push(...principals);
        return this;
    }
    /**
     * @experimental
     */
    cdkApplyPrincipals() {
        if (!this.cdkPrincipalsApplied) {
            const mode = this.useNotPrincipals ? 'addNotPrincipals' : 'addPrincipals';
            // @ts-ignore only available after swapping 1-base
            this[mode](...this.cdkPrincipals);
            if (this.hasPrincipals()) {
                Object.keys(this.principals).forEach((prefix) => {
                    switch (prefix) {
                        case _6_principals_1.PrincipalType.AWS:
                            this.principals[prefix].forEach((arn) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new iam.ArnPrincipal(arn));
                            });
                            break;
                        case _6_principals_1.PrincipalType.CANONICAL_USER:
                            this.principals[prefix].forEach((userId) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new iam.CanonicalUserPrincipal(userId));
                            });
                            break;
                        case _6_principals_1.PrincipalType.FEDERATED:
                            this.principals[prefix].forEach((provider) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new iam.FederatedPrincipal(provider, {}));
                            });
                            break;
                        case _6_principals_1.PrincipalType.SERVICE:
                            this.principals[prefix].forEach((service) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new iam.ServicePrincipal(service));
                            });
                            break;
                        default:
                            throw Error(`Unhandled principal type: ${prefix}`);
                    }
                });
            }
            this.cdkPrincipalsApplied = true;
        }
    }
}
exports.PolicyStatementWithCDKPrincipal = PolicyStatementWithCDKPrincipal;
_a = JSII_RTTI_SYMBOL_1;
PolicyStatementWithCDKPrincipal[_a] = { fqn: "cdk-iam-floyd.PolicyStatementWithCDKPrincipal", version: "0.203.0" };
//# sourceMappingURL=data:application/json;base64,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