import { IEventBus } from 'aws-cdk-lib/aws-events';
import { Function } from 'aws-cdk-lib/aws-lambda';
import { ISecret } from 'aws-cdk-lib/aws-secretsmanager';
import { Construct } from 'constructs';
import { InvocationAlarm } from './Util';
export interface GitHubProps {
    /**
     * SM Secret containing the secret string used to validate webhook events.
     */
    readonly gitHubWebhookSecret: ISecret;
    /**
     * Eventbus to send GitHub events to.
     */
    readonly eventBus: IEventBus;
    /**
     * Maximum number of concurrent invocations on the fURL function before triggering the alarm.
     */
    readonly lambdaInvocationAlarmThreshold: number;
}
/**
 * CDK wrapper for the GitHub Eventbridge processor.
 * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-saas-furls.html#furls-connection-github
 */
export declare class GitHubEventProcessor extends Construct {
    githubEventsFunction: Function;
    invocationAlarm: InvocationAlarm;
    constructor(scope: Construct, id: string, props: GitHubProps);
}
