"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHubEventProcessor = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
const Util_1 = require("./Util");
/**
 * CDK wrapper for the GitHub Eventbridge processor.
 * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-saas-furls.html#furls-connection-github
 */
class GitHubEventProcessor extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.githubEventsFunction = new aws_lambda_1.Function(this, 'GitHubEventsFunction', {
            code: aws_lambda_1.Code.fromBucket(aws_s3_1.Bucket.fromBucketName(this, 'AWSFunctionBucket', `eventbridge-inbound-webhook-templates-prod-${aws_cdk_lib_1.Stack.of(this).region}`), 'lambda-templates/github-lambdasrc.zip'),
            handler: 'app.handler',
            runtime: aws_lambda_1.Runtime.PYTHON_3_7,
            memorySize: 128,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            reservedConcurrentExecutions: 10,
            environment: {
                GITHUB_WEBHOOK_SECRET_ARN: props.gitHubWebhookSecret.secretArn,
                EVENT_BUS_NAME: props.eventBus.eventBusName,
            },
        });
        this.invocationAlarm = new Util_1.InvocationAlarm(this, 'GitHubInvocationAlarm', {
            threshold: props.lambdaInvocationAlarmThreshold,
            eventFunction: this.githubEventsFunction,
        });
        const fURL = this.githubEventsFunction.addFunctionUrl({ authType: aws_lambda_1.FunctionUrlAuthType.NONE });
        props.gitHubWebhookSecret.grantRead(this.githubEventsFunction);
        props.eventBus.grantPutEventsTo(this.githubEventsFunction);
        new aws_cdk_lib_1.CfnOutput(this, 'GitHubFunctionUrl', { value: fURL.url });
    }
}
exports.GitHubEventProcessor = GitHubEventProcessor;
_a = JSII_RTTI_SYMBOL_1;
GitHubEventProcessor[_a] = { fqn: "cdk-eventbridge-partner-processors.GitHubEventProcessor", version: "0.0.3" };
//# sourceMappingURL=data:application/json;base64,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