import re
import sys

from uao import register_uao

from . import log

register_uao()


class Target:
    MainMenu = [
        '離開，再見',
        '人, 我是',
        '[呼叫器]',
    ]

    MainMenu_Exiting = [
        '【主功能表】',
        '您確定要離開',
    ]

    PTT1_QueryPost = [
        '請按任意鍵繼續',
        '文章代碼(AID):',
        '文章網址:'
    ]

    PTT2_QueryPost = [
        '請按任意鍵繼續',
        '文章代碼(AID):'
    ]

    InBoard = [
        '看板資訊/設定',
        '文章選讀',
        '相關主題'
    ]

    InBoardWithCursor = [
        '【',
        '看板資訊/設定',
    ]
    InBoardWithCursorLen = len(InBoardWithCursor)

    # (h)說明 (←/q)離開
    # (y)回應(X%)推文(h)說明(←)離開
    # (y)回應(X/%)推文 (←)離開

    InPost = [
        '瀏覽',
        '頁',
        ')離開'
    ]

    PostEnd = [
        '瀏覽',
        '頁 (100%)',
        ')離開'
    ]

    InWaterBallList = [
        '瀏覽',
        '頁',
        '說明',
    ]

    WaterBallListEnd = [
        '瀏覽',
        '頁 (100%)',
        '說明'
    ]

    PostIP_New = [
        '※ 發信站: 批踢踢實業坊(ptt.cc), 來自:'
    ]

    PostIP_Old = [
        '◆ From:'
    ]

    Edit = [
        '※ 編輯'
    ]

    PostURL = [
        '※ 文章網址'
    ]

    Vote_Type1 = [
        '◆ 投票名稱',
        '◆ 投票中止於',
        '◆ 票選題目描述'
    ]

    Vote_Type2 = [
        '投票名稱',
        '◆ 預知投票紀事',
    ]

    AnyKey = '任意鍵'

    InTalk = [
        '【聊天說話】',
        '線上使用者列表',
        '查詢網友',
        '顯示上幾次熱訊'
    ]

    InUserList = [
        '休閒聊天',
        '聊天/寫信',
        '說明',
    ]

    InMailBox = [
        '【郵件選單】',
        '[~]資源回收筒',
        '鴻雁往返'
    ]

    InMailBoxWithCursor = [
        '【郵件選單】',
        '[~]資源回收筒',
    ]
    InMailBoxWithCursorLen = len(InMailBoxWithCursor)

    InMailMenu = [
        '【電子郵件】',
        '我的信箱',
        '把所有私人資料打包回去',
        '寄信給帳號站長',
    ]

    PostNoContent = [
        '◆ 此文章無內容',
        AnyKey
    ]

    InBoardList = [
        '【看板列表】',
        '選擇看板',
        '只列最愛',
        '已讀/未讀'
    ]

    use_too_many_resources = [
        '程式耗用過多計算資源'
    ]

    Animation = [
        '★ 這份文件是可播放的文字動畫，要開始播放嗎？'
    ]

    CursorToGoodbye = MainMenu.copy()

    content_start = '─── ── ── ── ── ── ── ── ── ── ── ── ── ── ── ── ── ── ──'
    content_end_list = [
        '--\n※ 發信站: 批踢踢實業坊',
        '--\n※ 發信站: 批踢踢兔(ptt2.cc)',
        '--\n※ 發信站: 新批踢踢(ptt2.twbbs.org.tw)'
    ]

    OnlineUser = [
        '編號',
        '日 期'
    ]


def show(config, screen_queue, function_name=None):
    if config.log_level != log.DEBUG:
        return

    if isinstance(screen_queue, list):
        for Screen in screen_queue:
            print('-' * 50)
            try:
                print(
                    Screen.encode(
                        sys.stdin.encoding, "replace").decode(
                        sys.stdin.encoding))
            except Exception:
                print(Screen.encode('utf-8', "replace").decode('utf-8'))
    else:
        print('-' * 50)
        try:
            print(screen_queue.encode(
                sys.stdin.encoding, "replace").decode(
                sys.stdin.encoding))
        except Exception:
            print(screen_queue.encode('utf-8', "replace").decode('utf-8'))

        print('len:' + str(len(screen_queue)))
    if function_name is not None:
        print('錯誤在 ' + function_name + ' 函式發生')
    print('-' * 50)


xy_pattern_h = re.compile(r'^=ESC=\[[\d]+;[\d]+H')
xy_pattern_s = re.compile(r'^=ESC=\[[\d]+;[\d]+s')


class VT100Parser:
    def _h(self):
        self._cursor_x = 0
        self._cursor_y = 0

    def _2j(self):
        self.screen = [''] * 24
        self.screen_length = dict()

    def _move(self, x, y):
        self._cursor_x = x
        self._cursor_y = y

    def _newline(self):
        self._cursor_x = 0
        self._cursor_y += 1

    def _k(self):
        if self._cursor_x == 0:
            # nothing happen but cause error
            return
        self.screen[self._cursor_y] = self.screen[self._cursor_y][:self._cursor_x]

    def __init__(self, bytes_data, encoding):
        # self._data = data
        # https://www.csie.ntu.edu.tw/~r88009/Java/html/Network/vt100.htm

        self._cursor_x = 0
        self._cursor_y = 0
        self.screen = [''] * 24
        self.screen_length = dict()

        data = bytes_data.decode(encoding, errors='replace')

        # remove color
        data = re.sub(r'\x1B\[[\d+;]*m', '', data)
        data = re.sub(r'[\x1B]', '=ESC=', data)
        data = re.sub(r'[\r]', '', data)
        while ' \x08' in data:
            data = re.sub(r' \x08', '', data)

        if '=ESC=[2J' in data:
            data = data[data.rfind('=ESC=[2J') + len('=ESC=[2J'):]

        count = 0
        while data:
            count += 1
            while True:
                if not data.startswith('=ESC='):
                    break
                if data.startswith('=ESC=[H'):
                    data = data[len('=ESC=[H'):]
                    self._h()
                    continue
                elif data.startswith('=ESC=[K'):
                    data = data[len('=ESC=[K'):]
                    self._k()
                    continue
                elif data.startswith('=ESC=[s'):
                    data = data[len('=ESC=[s'):]
                    continue
                break

            xy_result = None
            xy_result_h = xy_pattern_h.search(data)
            if not xy_result_h:
                xy_result_s = xy_pattern_s.search(data)
                if xy_result_s:
                    xy_result = xy_result_s
            else:
                xy_result = xy_result_h

            if xy_result:
                xy_part = xy_result.group(0)

                new_y = int(xy_part[6:xy_part.find(';')]) - 1
                new_x = int(xy_part[xy_part.find(';') + 1: -1])
                # log.py.info('xy', xy_part, new_x, new_y)
                self._move(new_x, new_y)

                data = data[len(xy_part):]

            else:
                if data.startswith('\n'):
                    data = data[1:]
                    self._newline()
                    continue

                # print(f'-{data[:1]}-{len(data[:1].encode("big5-uao", "replace"))}')

                if self._cursor_y not in self.screen_length:
                    self.screen_length[self._cursor_y] = len(self.screen[self._cursor_y].encode(encoding, 'replace'))

                current_line_length = self.screen_length[self._cursor_y]
                replace_mode = False
                if current_line_length < self._cursor_x:
                    append_space = ' ' * (self._cursor_x - current_line_length)
                    self.screen[self._cursor_y] += append_space
                elif current_line_length > self._cursor_x:
                    replace_mode = True

                next_newline = data.find('\n')
                next_newline = 1920 if next_newline < 0 else next_newline

                next_esc = data.find('=ESC=')
                next_esc = 1920 if next_esc < 0 else next_esc
                if next_esc == 0:
                    break

                current_index = min(next_newline, next_esc)

                current_data = data[:current_index]
                current_data_length = len(current_data.encode(encoding, 'replace'))
                # print('=', current_data, '=', current_data_length)
                if replace_mode:
                    current_line = self.screen[self._cursor_y][:self._cursor_x]
                    current_line += current_data
                    current_line += self.screen[self._cursor_y][self._cursor_x + len(current_data):]

                    self.screen[self._cursor_y] = current_line
                else:
                    self.screen[self._cursor_y] += current_data
                    self._cursor_x += current_data_length
                    self.screen_length[self._cursor_y] = self._cursor_x

                data = data[current_index:]

                # print('\n'.join(self.screen))
        # print('\n'.join(self._screen))
        # print('=' * 20)
        # print(data)

        # print('Spend', count, 'cycle')
        self.screen = '\n'.join(self.screen)


if __name__ == '__main__':
    # post list
    screen = b"\x1b[H\x1b[2J\x1b[1;37;44m\xe3\x80\x90\xe4\xb8\xbb\xe5\x8a\x9f\xe8\x83\xbd\xe8\xa1\xa8\xe3\x80\x91                     \x1b[33m\xe6\x89\xb9\xe8\xb8\xa2\xe8\xb8\xa2\xe5\xaf\xa6\xe6\xa5\xad\xe5\x9d\x8a\x1b[0;1;37;44m                                  \r\n  \x08\x08\x1b[47m\xe2\x96\x88\x1b[2;3H  \x08\x08\xe2\x96\x88\x1b[2;5H  \x08\x08\xe2\x96\x88\x1b[2;7H  \x08\x08\xe2\x96\x88\x1b[2;9H  \x08\x08\xe2\x96\x88\x1b[2;11H  \x08\x08\xe2\x96\x88\x1b[2;13H  \x08\x08\xe2\x96\x88\x1b[2;15H  \x08\x08\xe2\x96\x88\x1b[2;17H  \x08\x08\xe2\x96\x88\x1b[2;19H  \x08\x08\xe2\x96\x88\x1b[2;21H  \x08\x08\xe2\x96\x88\x1b[2;23H  \x08\x08\xe2\x96\x88\x1b[2;25H  \x08\x08\xe2\x96\x88\x1b[2;27H  \x08\x08\xe2\x96\x88\x1b[2;29H  \x08\x08\xe2\x96\x88\x1b[2;31H  \x08\x08\xe2\x96\x88\x1b[2;33H  \x08\x08\xe2\x96\x88\x1b[2;35H  \x08\x08\xe2\x96\x88\x1b[2;37H  \x08\x08\xe2\x96\x88\x1b[2;39H  \x08\x08\xe2\x96\x88\x1b[2;41H  \x08\x08\xe2\x96\x88\x1b[2;43H  \x08\x08\xe2\x96\x88\x1b[2;45H  \x08\x08\xe2\x96\x88\x1b[2;47H  \x08\x08\xe2\x96\x88\x1b[2;49H  \x08\x08\xe2\x96\x88\x1b[2;51H  \x08\x08\xe2\x96\x88\x1b[2;53H  \x08\x08\xe2\x96\x88\x1b[2;55H  \x08\x08\xe2\x96\x88\x1b[2;57H  \x08\x08\xe2\x96\x88\x1b[2;59H  \x08\x08\xe2\x96\x88\x1b[2;61H  \x08\x08\xe2\x96\x88\x1b[2;63H  \x08\x08\xe2\x96\x88\x1b[2;65H  \x08\x08\xe2\x96\x88\x1b[2;67H  \x08\x08\xe2\x96\x88\x1b[2;69H  \x08\x08\xe2\x96\x88\x1b[2;71H  \x08\x08\xe2\x96\x88\x1b[2;73H  \x08\x08\xe2\x96\x88\x1b[2;75H  \x08\x08\xe2\x96\x88\x1b[2;77H  \x08\x08\xe2\x96\x88\x1b[2;79H\r\n  \x08\x08\x1b[0;33;47m\xe2\x96\x85\x1b[3;3H  \x08\x08\xe2\x96\x86\x1b[3;5H  \x08\x08\xe2\x96\x86\x1b[3;7H  \x08\x08\x1b[1;36;43m\xe2\x97\xa5\x1b[3;9H  \x08\x08\x1b[47m\xe2\x96\x88\x1b[3;11H  \x08\x08\xe2\x96\x88\x1b[3;13H  \x08\x08\xe2\x96\x88\x1b[3;15H  \x08\x08\xe2\x96\x88\x1b[3;17H  \x08\x08\xe2\x96\x88\x1b[3;19H  \x08\x08\xe2\x96\x88\x1b[3;21H  \x08\x08\xe2\x96\x88\x1b[3;23H  \x08\x08\xe2\x96\x88\x1b[3;25H  \x08\x08\xe2\x96\x88\x1b[3;27H  \x08\x08\xe2\x96\x88\x1b[3;29H  \x08\x08\xe2\x96\x88\x1b[3;31H  \x08\x08\xe2\x96\x88\x1b[3;33H  \x08\x08\xe2\x96\x88\x1b[3;35H  \x08\x08\xe2\x96\x88\x1b[3;37H  \x08\x08\xe2\x96\x88\x1b[3;39H  \x08\x08\xe2\x96\x88\x1b[3;41H  \x08\x08\xe2\x96\x88\x1b[3;43H  \x08\x08\xe2\x96\x88\x1b[3;45H  \x08\x08\xe2\x96\x88\x1b[3;47H  \x08\x08\xe2\x96\x88\x1b[3;49H  \x08\x08\xe2\x96\x88\x1b[3;51H  \x08\x08\xe2\x96\x88\x1b[3;53H  \x08\x08\xe2\x96\x88\x1b[3;55H  \x08\x08\xe2\x96\x88\x1b[3;57H  \x08\x08\xe2\x96\x88\x1b[3;59H  \x08\x08\xe2\x96\x88\x1b[3;61H  \x08\x08\xe2\x96\x88\x1b[3;63H  \x08\x08\xe2\x96\x88\x1b[3;65H  \x08\x08\xe2\x96\x88\x1b[3;67H  \x08\x08\xe2\x96\x88\x1b[3;69H  \x08\x08\xe2\x96\x88\x1b[3;71H  \x08\x08\xe2\x96\x88\x1b[3;73H  \x08\x08\xe2\x96\x88\x1b[3;75H  \x08\x08\xe2\x96\x88\x1b[3;77H  \x08\x08\xe2\x96\x88\x1b[3;79H\r\n\x1b[0;30;43m     -  \x08\x08\xe2\x94\x80\x1b[4;9H`     \x1b[1;36m\xef\xbf\xa3\xef\xbf\xa3\xef\xbf\xa3      \xef\xbf\xa3\xef\xbf\xa3\xef\xbf\xa3    \xef\xbf\xa3\xef\xbf\xa3                  \xef\xbf\xa3\xef\xbf\xa3\xef\xbf\xa3\x1b[30m\xef\xbf\xa3\xef\xbf\xa3\x1b[36m\xef\xbf\xa3        \r\n\x1b[0;43m              \x08\x08\x1b[31m\xe2\x96\x82\x1b[5;15H  \x08\x08\xe2\x96\x83\x1b[5;17H\x1b[1;30m     \xef\xb8\xb1       \xef\xbd\x9c        \xef\xb9\xa8     \x1b[0;30;43m\xef\xbd\x9c     \\                     \x08\x08\xe2\x88\xa3\x1b[5;77H  \r\n \\_     \x08\x08\xe2\x88\x95\x1b[6;9H   \x08\x08\x1b[33;41m\xe2\x97\xa4\x1b[6;12H  \x08\x08\x1b[0;41m\xe2\x96\x82\x1b[6;14H   \x08\x08\x1b[31;43m\xe2\x96\x8a\x1b[6;17H\x1b[34m\xe3\x80\x82\x1b[30m   /    \x08\x08\xe2\x88\x95\x1b[6;27H  \xef\xb9\x8d \xef\xb9\xa8  \x1b[1mL_         \x1b[0;30;43m|        |    \x08\x08\xe2\x8a\xa5\x1b[6;61H       \x1b[1m\xef\xbd\x9c   \x1b[0;30;43m.  \x08\x08\xe2\x88\xa0\x1b[6;76H   \r\n     \x08\x08\xe2\x95\xb3\x1b[7;6H      \x08\x08\x1b[31;47m\xe2\x96\x8a\x1b[7;12H  \x08\x08\x1b[30m\xcb\x99\x1b[7;14H  \x08\x08\x1b[0;41m\xe2\x96\x8e\x1b[7;16H  \x08\x08\x1b[33m\xe2\x97\xa4\x1b[7;18H  \x08\x08\x1b[31;43m\xe2\x96\x8e\x1b[7;20H\x1b[30m`  \x08\x08\xe2\x94\x90\x1b[7;23H   \x08\x08\xe2\x94\x82\x1b[7;26H,   \xef\xb8\xb3  \x08\x08\xe2\x96\x81\x1b[7;34H     \x08\x08\xe2\x95\x93\x1b[7;39H-.\xef\xb8\xbf     \x08\x08\xe2\x88\x95\x1b[7;48H  ` _\xef\xb8\xb3   \x08\x08\xe2\x88\xa3\x1b[7;58H .  _x_    \\   \xef\xbd\x9c   \x08\x08\xe2\x95\xb2\x1b[7;78H \r\n L  \x1b[36m_  \x08\x08\xe2\x96\x84\x1b[8;8H  \x08\x08\x1b[41m\xe2\x96\x8a\x1b[8;10H\x1b[30m\\   \x08\x08\x1b[31;47m\xe2\x96\x86\x1b[8;14H\x1b[1;36;41m'    \x1b[0;30;43m N \xef\xbc\xbc_7_\xef\xb8\xb7-+  \x08\x08\xe2\x94\xa4\x1b[8;33H   \x08\x08\xe2\x86\x96\x1b[8;36H  \x08\x08\xe2\x95\xb3\x1b[8;38H   \xe3\x80\x89  \x08\x08\xe2\x94\xac\x1b[8;45H'  \x08\x08\xe2\x94\x8c\x1b[8;48H  \x08\x08\xe2\x80\xb5\x1b[8;50H  \x08\x08\xe2\x88\x9a\x1b[8;52H 7\xe2\x95\xb4.-\xef\xbc\x81  \x08\x08\xe2\x80\xb2\x1b[8;62H   `  \x08\x08\xe2\x94\xac\x1b[8;68H+  \x08\x08\xe2\x94\xbc\x1b[8;71H=.  \x08\x08\xe2\x88\x95\x1b[8;75H= \xe2\x95\xb4\r\n  \x08\x08\xe2\x94\xa4\x1b[9;3H   \x08\x08\x1b[33;46m\xe2\x96\x84\x1b[9;6H   \x08\x08\x1b[31m\xe2\x96\x84\x1b[9;9H\x1b[30;41m,   \x08\x08\xe2\x95\xb2\x1b[9;13H,_    \x08\x08\x1b[33m\xe2\x97\xa2\x1b[9;19H  \x08\x08\x1b[30;43m\xe2\x94\x82\x1b[9;21H\\_  \x08\x08\xe2\x95\xb1\x1b[9;25H  \x08\x08\xe2\x96\x8f\x1b[9;27H\\_  \x08\x08\xe2\x88\x95\x1b[9;31H_\xef\xb9\x80  _;}  \x08\x08\xe2\x80\x94\x1b[9;41HL    \x08\x08\xe2\x86\x98\x1b[9;46H_\xe3\x80\x95-_  \x08\x08\xe2\x95\xb3\x1b[9;53H  |   \xef\xbc\xbc__F   \x08\x08\xe2\x86\x99\x1b[9;67H  \xef\xb9\x8d]   \x08\x08\xe2\x96\x8f\x1b[9;75H_  \x08\x08\xe2\x88\x95\x1b[9;78H \r\n   \x08\x08\xe2\x95\xb2\x1b[10;4H\x1b[32mr  \x08\x08\x1b[46m\xe2\x96\x8e\x1b[10;7H  \x08\x08\x1b[31m\xe2\x97\xa5\x1b[10;9H\x1b[30;41m\xe3\x80\x83  \x08\x08\xe2\x94\x94\x1b[10;13H\x1b[34m_  \x08\x08\x1b[36m\xe2\x96\x84\x1b[10;16H\x1b[31;43m\xe3\x80\x9e  \x08\x08\x1b[30m\xe2\x86\x97\x1b[10;20H  \x08\x08\xe2\x95\xb3\x1b[10;22H   \x08\x08\xe2\x96\x95\x1b[10;25H_   \x08\x08\xe2\x94\x98\x1b[10;29H  \x08\x08\xe2\x95\xb3\x1b[10;31H   \x08\x08\xe2\x95\xb2\x1b[10;34H_  \x08\x08\xe2\x86\x99\x1b[10;37H  \x08\x08\xe2\x96\x8e\x1b[10;39H  \x08\x08\xe2\x86\x99\x1b[10;41H  \x08\x08\xe2\x86\x91\x1b[10;43H_  \x08\x08\xe2\x96\x95\x1b[10;46H  ,  \x08\x08\xe2\x94\xbc\x1b[10;51H  \x08\x08\xe2\x96\x95\x1b[10;53H  \xef\xb9\xa8  \xef\xb9\x80`    \x08\x08\xe2\x96\x8e\x1b[10;66H`\xef\xbf\xa3    \x08\x08\xe2\x86\x96\x1b[10;73H\xef\xbf\xa3}   \x08\x08\xe2\x95\xb2\x1b[10;79H\r\n r  \x08\x08\xe2\x94\x98\x1b[11;5H   \x08\x08\x1b[33;46m\xe2\x96\x84\x1b[11;8H   \x08\x08\x1b[31m\xe2\x97\xa5\x1b[11;11H  \x08\x08\x1b[33m\xe2\x96\x83\x1b[11;13H  \x08\x08\xe2\x96\x86\x1b[11;15H  \x08\x08\x1b[30;43m\xe2\x94\xac\x1b[11;17H  \x08\x08\xe2\x95\x9d\x1b[11;19H  \x08\x08\xe2\x94\x94\x1b[11;21H   \x08\x08\xe2\x96\x8e\x1b[11;24H    \x08\x08\xe2\x95\xb2\x1b[11;28H `   \x08\x08\xe2\x96\x8f\x1b[11;33H  \x08\x08\xe2\x94\x9c\x1b[11;35H  \xef\xbf\xa3\\    \x08\x08\xe2\x80\x99\x1b[11;44H\xef\xb8\xba  \x08\x08\xe2\x96\x8f\x1b[11;48H\x1b[35m\xe5\x8f\xaf\xe4\xb8\x8d\xe5\x8f\xaf\xe4\xbb\xa5\xe5\x81\xb6\xe7\x88\xbe\xe4\xb8\x8b\xe9\x9b\xa8\xe4\xb8\x8d\xe5\xbf\x85\xe6\xb0\xb8\xe9\x81\xa0\xe6\x99\xb4\xe5\xa4\xa9...\x1b[13;23H\x1b[m(\x1b[1;36mA\x1b[m)nnounce     \xe3\x80\x90 \xe7\xb2\xbe\xe8\x8f\xaf\xe5\x85\xac\xe4\xbd\x88\xe6\xac\x84 \xe3\x80\x91\x1b[14;23H(\x1b[1;36mF\x1b[m)avorite     \xe3\x80\x90 \xe6\x88\x91 \xe7\x9a\x84 \xe6\x9c\x80\xe6\x84\x9b \xe3\x80\x91\x1b[15;21H> (\x1b[1;36mC\x1b[m)lass\x1b[15;38H\xe3\x80\x90 \xe5\x88\x86\xe7\xb5\x84\xe8\xa8\x8e\xe8\xab\x96\xe5\x8d\x80 \xe3\x80\x91\x1b[16;23H(\x1b[1;36mM\x1b[m)ail\x1b[16;38H\xe3\x80\x90 \xe7\xa7\x81\xe4\xba\xba\xe4\xbf\xa1\xe4\xbb\xb6\xe5\x8d\x80 \xe3\x80\x91\x1b[17;23H(\x1b[1;36mT\x1b[m)alk\x1b[17;38H\xe3\x80\x90 \xe4\xbc\x91\xe9\x96\x92\xe8\x81\x8a\xe5\xa4\xa9\xe5\x8d\x80 \xe3\x80\x91\x1b[18;23H(\x1b[1;36mU\x1b[m)ser\x1b[18;38H\xe3\x80\x90 \xe5\x80\x8b\xe4\xba\xba\xe8\xa8\xad\xe5\xae\x9a\xe5\x8d\x80 \xe3\x80\x91\x1b[19;23H(\x1b[1;36mX\x1b[m)yz\x1b[19;38H\xe3\x80\x90 \xe7\xb3\xbb\xe7\xb5\xb1\xe8\xb3\x87\xe8\xa8\x8a\xe5\x8d\x80 \xe3\x80\x91\x1b[20;23H(\x1b[1;36mP\x1b[m)lay\x1b[20;38H\xe3\x80\x90 \xe5\xa8\x9b\xe6\xa8\x82\xe8\x88\x87\xe4\xbc\x91\xe9\x96\x92 \xe3\x80\x91\x1b[21;23H(\x1b[1;36mN\x1b[m)amelist     \xe3\x80\x90 \xe7\xb7\xa8\xe7\x89\xb9\xe5\x88\xa5\xe5\x90\x8d\xe5\x96\xae \xe3\x80\x91\x1b[22;23H(\x1b[1;36mG\x1b[m)oodbye\x1b[22;41H\xe9\x9b\xa2\xe9\x96\x8b\xef\xbc\x8c\xe5\x86\x8d\xe8\xa6\x8b  \x08\x08\xe2\x80\xa6\x1b[22;53H\r\n\n\x1b[34;46m[12/4 \xe6\x98\x9f\xe6\x9c\x9f\xe5\x85\xad 14:26]\x1b[1;33;45m [ \xe9\x9b\x99\xe9\xad\x9a\xe6\x99\x82 ]   \x1b[30;47m \xe7\xb7\x9a\xe4\xb8\x8a\x1b[31m66391\x1b[30m\xe4\xba\xba, \xe6\x88\x91\xe6\x98\xaf\x1b[31mCodingMan\x1b[30m      [\xe5\x91\xbc\xe5\x8f\xab\xe5\x99\xa8]\x1b[31m\xe9\x97\x9c\xe9\x96\x89 \x1b[m\x1b[15;21H\x1b[H\x1b[2J\x1b[1;37;44m\xe3\x80\x90\xe4\xb8\xbb\xe5\x8a\x9f\xe8\x83\xbd\xe8\xa1\xa8\xe3\x80\x91                     \x1b[33m\xe6\x89\xb9\xe8\xb8\xa2\xe8\xb8\xa2\xe5\xaf\xa6\xe6\xa5\xad\xe5\x9d\x8a\x1b[0;1;37;44m                                  \r\n  \x08\x08\x1b[47m\xe2\x96\x88\x1b[2;3H  \x08\x08\xe2\x96\x88\x1b[2;5H  \x08\x08\xe2\x96\x88\x1b[2;7H  \x08\x08\xe2\x96\x88\x1b[2;9H  \x08\x08\xe2\x96\x88\x1b[2;11H  \x08\x08\xe2\x96\x88\x1b[2;13H  \x08\x08\xe2\x96\x88\x1b[2;15H  \x08\x08\xe2\x96\x88\x1b[2;17H  \x08\x08\xe2\x96\x88\x1b[2;19H  \x08\x08\xe2\x96\x88\x1b[2;21H  \x08\x08\xe2\x96\x88\x1b[2;23H  \x08\x08\xe2\x96\x88\x1b[2;25H  \x08\x08\xe2\x96\x88\x1b[2;27H  \x08\x08\xe2\x96\x88\x1b[2;29H  \x08\x08\xe2\x96\x88\x1b[2;31H  \x08\x08\xe2\x96\x88\x1b[2;33H  \x08\x08\xe2\x96\x88\x1b[2;35H  \x08\x08\xe2\x96\x88\x1b[2;37H  \x08\x08\xe2\x96\x88\x1b[2;39H  \x08\x08\xe2\x96\x88\x1b[2;41H  \x08\x08\xe2\x96\x88\x1b[2;43H  \x08\x08\xe2\x96\x88\x1b[2;45H  \x08\x08\xe2\x96\x88\x1b[2;47H  \x08\x08\xe2\x96\x88\x1b[2;49H  \x08\x08\xe2\x96\x88\x1b[2;51H  \x08\x08\xe2\x96\x88\x1b[2;53H  \x08\x08\xe2\x96\x88\x1b[2;55H  \x08\x08\xe2\x96\x88\x1b[2;57H  \x08\x08\xe2\x96\x88\x1b[2;59H  \x08\x08\xe2\x96\x88\x1b[2;61H  \x08\x08\xe2\x96\x88\x1b[2;63H  \x08\x08\xe2\x96\x88\x1b[2;65H  \x08\x08\xe2\x96\x88\x1b[2;67H  \x08\x08\xe2\x96\x88\x1b[2;69H  \x08\x08\xe2\x96\x88\x1b[2;71H  \x08\x08\xe2\x96\x88\x1b[2;73H  \x08\x08\xe2\x96\x88\x1b[2;75H  \x08\x08\xe2\x96\x88\x1b[2;77H  \x08\x08\xe2\x96\x88\x1b[2;79H\r\n  \x08\x08\x1b[0;33;47m\xe2\x96\x85\x1b[3;3H  \x08\x08\xe2\x96\x86\x1b[3;5H  \x08\x08\xe2\x96\x86\x1b[3;7H  \x08\x08\x1b[1;36;43m\xe2\x97\xa5\x1b[3;9H  \x08\x08\x1b[47m\xe2\x96\x88\x1b[3;11H  \x08\x08\xe2\x96\x88\x1b[3;13H  \x08\x08\xe2\x96\x88\x1b[3;15H  \x08\x08\xe2\x96\x88\x1b[3;17H  \x08\x08\xe2\x96\x88\x1b[3;19H  \x08\x08\xe2\x96\x88\x1b[3;21H  \x08\x08\xe2\x96\x88\x1b[3;23H  \x08\x08\xe2\x96\x88\x1b[3;25H  \x08\x08\xe2\x96\x88\x1b[3;27H  \x08\x08\xe2\x96\x88\x1b[3;29H  \x08\x08\xe2\x96\x88\x1b[3;31H  \x08\x08\xe2\x96\x88\x1b[3;33H  \x08\x08\xe2\x96\x88\x1b[3;35H  \x08\x08\xe2\x96\x88\x1b[3;37H  \x08\x08\xe2\x96\x88\x1b[3;39H  \x08\x08\xe2\x96\x88\x1b[3;41H  \x08\x08\xe2\x96\x88\x1b[3;43H  \x08\x08\xe2\x96\x88\x1b[3;45H  \x08\x08\xe2\x96\x88\x1b[3;47H  \x08\x08\xe2\x96\x88\x1b[3;49H  \x08\x08\xe2\x96\x88\x1b[3;51H  \x08\x08\xe2\x96\x88\x1b[3;53H  \x08\x08\xe2\x96\x88\x1b[3;55H  \x08\x08\xe2\x96\x88\x1b[3;57H  \x08\x08\xe2\x96\x88\x1b[3;59H  \x08\x08\xe2\x96\x88\x1b[3;61H  \x08\x08\xe2\x96\x88\x1b[3;63H  \x08\x08\xe2\x96\x88\x1b[3;65H  \x08\x08\xe2\x96\x88\x1b[3;67H  \x08\x08\xe2\x96\x88\x1b[3;69H  \x08\x08\xe2\x96\x88\x1b[3;71H  \x08\x08\xe2\x96\x88\x1b[3;73H  \x08\x08\xe2\x96\x88\x1b[3;75H  \x08\x08\xe2\x96\x88\x1b[3;77H  \x08\x08\xe2\x96\x88\x1b[3;79H\r\n\x1b[0;30;43m     -  \x08\x08\xe2\x94\x80\x1b[4;9H`     \x1b[1;36m\xef\xbf\xa3\xef\xbf\xa3\xef\xbf\xa3      \xef\xbf\xa3\xef\xbf\xa3\xef\xbf\xa3    \xef\xbf\xa3\xef\xbf\xa3                  \xef\xbf\xa3\xef\xbf\xa3\xef\xbf\xa3\x1b[30m\xef\xbf\xa3\xef\xbf\xa3\x1b[36m\xef\xbf\xa3        \r\n\x1b[0;43m              \x08\x08\x1b[31m\xe2\x96\x82\x1b[5;15H  \x08\x08\xe2\x96\x83\x1b[5;17H\x1b[1;30m     \xef\xb8\xb1       \xef\xbd\x9c        \xef\xb9\xa8     \x1b[0;30;43m\xef\xbd\x9c     \\                     \x08\x08\xe2\x88\xa3\x1b[5;77H  \r\n \\_     \x08\x08\xe2\x88\x95\x1b[6;9H   \x08\x08\x1b[33;41m\xe2\x97\xa4\x1b[6;12H  \x08\x08\x1b[0;41m\xe2\x96\x82\x1b[6;14H   \x08\x08\x1b[31;43m\xe2\x96\x8a\x1b[6;17H\x1b[34m\xe3\x80\x82\x1b[30m   /    \x08\x08\xe2\x88\x95\x1b[6;27H  \xef\xb9\x8d \xef\xb9\xa8  \x1b[1mL_         \x1b[0;30;43m|        |    \x08\x08\xe2\x8a\xa5\x1b[6;61H       \x1b[1m\xef\xbd\x9c   \x1b[0;30;43m.  \x08\x08\xe2\x88\xa0\x1b[6;76H   \r\n     \x08\x08\xe2\x95\xb3\x1b[7;6H      \x08\x08\x1b[31;47m\xe2\x96\x8a\x1b[7;12H  \x08\x08\x1b[30m\xcb\x99\x1b[7;14H  \x08\x08\x1b[0;41m\xe2\x96\x8e\x1b[7;16H  \x08\x08\x1b[33m\xe2\x97\xa4\x1b[7;18H  \x08\x08\x1b[31;43m\xe2\x96\x8e\x1b[7;20H\x1b[30m`  \x08\x08\xe2\x94\x90\x1b[7;23H   \x08\x08\xe2\x94\x82\x1b[7;26H,   \xef\xb8\xb3  \x08\x08\xe2\x96\x81\x1b[7;34H     \x08\x08\xe2\x95\x93\x1b[7;39H-.\xef\xb8\xbf     \x08\x08\xe2\x88\x95\x1b[7;48H  ` _\xef\xb8\xb3   \x08\x08\xe2\x88\xa3\x1b[7;58H .  _x_    \\   \xef\xbd\x9c   \x08\x08\xe2\x95\xb2\x1b[7;78H \r\n L  \x1b[36m_  \x08\x08\xe2\x96\x84\x1b[8;8H  \x08\x08\x1b[41m\xe2\x96\x8a\x1b[8;10H\x1b[30m\\   \x08\x08\x1b[31;47m\xe2\x96\x86\x1b[8;14H\x1b[1;36;41m'    \x1b[0;30;43m N \xef\xbc\xbc_7_\xef\xb8\xb7-+  \x08\x08\xe2\x94\xa4\x1b[8;33H   \x08\x08\xe2\x86\x96\x1b[8;36H  \x08\x08\xe2\x95\xb3\x1b[8;38H   \xe3\x80\x89  \x08\x08\xe2\x94\xac\x1b[8;45H'  \x08\x08\xe2\x94\x8c\x1b[8;48H  \x08\x08\xe2\x80\xb5\x1b[8;50H  \x08\x08\xe2\x88\x9a\x1b[8;52H 7\xe2\x95\xb4.-\xef\xbc\x81  \x08\x08\xe2\x80\xb2\x1b[8;62H   `  \x08\x08\xe2\x94\xac\x1b[8;68H+  \x08\x08\xe2\x94\xbc\x1b[8;71H=.  \x08\x08\xe2\x88\x95\x1b[8;75H= \xe2\x95\xb4\r\n  \x08\x08\xe2\x94\xa4\x1b[9;3H   \x08\x08\x1b[33;46m\xe2\x96\x84\x1b[9;6H   \x08\x08\x1b[31m\xe2\x96\x84\x1b[9;9H\x1b[30;41m,   \x08\x08\xe2\x95\xb2\x1b[9;13H,_    \x08\x08\x1b[33m\xe2\x97\xa2\x1b[9;19H  \x08\x08\x1b[30;43m\xe2\x94\x82\x1b[9;21H\\_  \x08\x08\xe2\x95\xb1\x1b[9;25H  \x08\x08\xe2\x96\x8f\x1b[9;27H\\_  \x08\x08\xe2\x88\x95\x1b[9;31H_\xef\xb9\x80  _;}  \x08\x08\xe2\x80\x94\x1b[9;41HL    \x08\x08\xe2\x86\x98\x1b[9;46H_\xe3\x80\x95-_  \x08\x08\xe2\x95\xb3\x1b[9;53H  |   \xef\xbc\xbc__F   \x08\x08\xe2\x86\x99\x1b[9;67H  \xef\xb9\x8d]   \x08\x08\xe2\x96\x8f\x1b[9;75H_  \x08\x08\xe2\x88\x95\x1b[9;78H \r\n   \x08\x08\xe2\x95\xb2\x1b[10;4H\x1b[32mr  \x08\x08\x1b[46m\xe2\x96\x8e\x1b[10;7H  \x08\x08\x1b[31m\xe2\x97\xa5\x1b[10;9H\x1b[30;41m\xe3\x80\x83  \x08\x08\xe2\x94\x94\x1b[10;13H\x1b[34m_  \x08\x08\x1b[36m\xe2\x96\x84\x1b[10;16H\x1b[31;43m\xe3\x80\x9e  \x08\x08\x1b[30m\xe2\x86\x97\x1b[10;20H  \x08\x08\xe2\x95\xb3\x1b[10;22H   \x08\x08\xe2\x96\x95\x1b[10;25H_   \x08\x08\xe2\x94\x98\x1b[10;29H  \x08\x08\xe2\x95\xb3\x1b[10;31H   \x08\x08\xe2\x95\xb2\x1b[10;34H_  \x08\x08\xe2\x86\x99\x1b[10;37H  \x08\x08\xe2\x96\x8e\x1b[10;39H  \x08\x08\xe2\x86\x99\x1b[10;41H  \x08\x08\xe2\x86\x91\x1b[10;43H_  \x08\x08\xe2\x96\x95\x1b[10;46H  ,  \x08\x08\xe2\x94\xbc\x1b[10;51H  \x08\x08\xe2\x96\x95\x1b[10;53H  \xef\xb9\xa8  \xef\xb9\x80`    \x08\x08\xe2\x96\x8e\x1b[10;66H`\xef\xbf\xa3    \x08\x08\xe2\x86\x96\x1b[10;73H\xef\xbf\xa3}   \x08\x08\xe2\x95\xb2\x1b[10;79H\r\n r  \x08\x08\xe2\x94\x98\x1b[11;5H   \x08\x08\x1b[33;46m\xe2\x96\x84\x1b[11;8H   \x08\x08\x1b[31m\xe2\x97\xa5\x1b[11;11H  \x08\x08\x1b[33m\xe2\x96\x83\x1b[11;13H  \x08\x08\xe2\x96\x86\x1b[11;15H  \x08\x08\x1b[30;43m\xe2\x94\xac\x1b[11;17H  \x08\x08\xe2\x95\x9d\x1b[11;19H  \x08\x08\xe2\x94\x94\x1b[11;21H   \x08\x08\xe2\x96\x8e\x1b[11;24H    \x08\x08\xe2\x95\xb2\x1b[11;28H `   \x08\x08\xe2\x96\x8f\x1b[11;33H  \x08\x08\xe2\x94\x9c\x1b[11;35H  \xef\xbf\xa3\\    \x08\x08\xe2\x80\x99\x1b[11;44H\xef\xb8\xba  \x08\x08\xe2\x96\x8f\x1b[11;48H\x1b[35m\xe5\x8f\xaf\xe4\xb8\x8d\xe5\x8f\xaf\xe4\xbb\xa5\xe5\x81\xb6\xe7\x88\xbe\xe4\xb8\x8b\xe9\x9b\xa8\xe4\xb8\x8d\xe5\xbf\x85\xe6\xb0\xb8\xe9\x81\xa0\xe6\x99\xb4\xe5\xa4\xa9...\x1b[13;23H\x1b[m(\x1b[1;36mA\x1b[m)nnounce     \xe3\x80\x90 \xe7\xb2\xbe\xe8\x8f\xaf\xe5\x85\xac\xe4\xbd\x88\xe6\xac\x84 \xe3\x80\x91\x1b[14;23H(\x1b[1;36mF\x1b[m)avorite     \xe3\x80\x90 \xe6\x88\x91 \xe7\x9a\x84 \xe6\x9c\x80\xe6\x84\x9b \xe3\x80\x91\x1b[15;21H> (\x1b[1;36mC\x1b[m)lass\x1b[15;38H\xe3\x80\x90 \xe5\x88\x86\xe7\xb5\x84\xe8\xa8\x8e\xe8\xab\x96\xe5\x8d\x80 \xe3\x80\x91\x1b[16;23H(\x1b[1;36mM\x1b[m)ail\x1b[16;38H\xe3\x80\x90 \xe7\xa7\x81\xe4\xba\xba\xe4\xbf\xa1\xe4\xbb\xb6\xe5\x8d\x80 \xe3\x80\x91\x1b[17;23H(\x1b[1;36mT\x1b[m)alk\x1b[17;38H\xe3\x80\x90 \xe4\xbc\x91\xe9\x96\x92\xe8\x81\x8a\xe5\xa4\xa9\xe5\x8d\x80 \xe3\x80\x91\x1b[18;23H(\x1b[1;36mU\x1b[m)ser\x1b[18;38H\xe3\x80\x90 \xe5\x80\x8b\xe4\xba\xba\xe8\xa8\xad\xe5\xae\x9a\xe5\x8d\x80 \xe3\x80\x91\x1b[19;23H(\x1b[1;36mX\x1b[m)yz\x1b[19;38H\xe3\x80\x90 \xe7\xb3\xbb\xe7\xb5\xb1\xe8\xb3\x87\xe8\xa8\x8a\xe5\x8d\x80 \xe3\x80\x91\x1b[20;23H(\x1b[1;36mP\x1b[m)lay\x1b[20;38H\xe3\x80\x90 \xe5\xa8\x9b\xe6\xa8\x82\xe8\x88\x87\xe4\xbc\x91\xe9\x96\x92 \xe3\x80\x91\x1b[21;23H(\x1b[1;36mN\x1b[m)amelist     \xe3\x80\x90 \xe7\xb7\xa8\xe7\x89\xb9\xe5\x88\xa5\xe5\x90\x8d\xe5\x96\xae \xe3\x80\x91\x1b[22;23H(\x1b[1;36mG\x1b[m)oodbye\x1b[22;41H\xe9\x9b\xa2\xe9\x96\x8b\xef\xbc\x8c\xe5\x86\x8d\xe8\xa6\x8b  \x08\x08\xe2\x80\xa6\x1b[22;53H\r\n\n\x1b[34;46m[12/4 \xe6\x98\x9f\xe6\x9c\x9f\xe5\x85\xad 14:26]\x1b[1;33;45m [ \xe9\x9b\x99\xe9\xad\x9a\xe6\x99\x82 ]   \x1b[30;47m \xe7\xb7\x9a\xe4\xb8\x8a\x1b[31m66391\x1b[30m\xe4\xba\xba, \xe6\x88\x91\xe6\x98\xaf\x1b[31mCodingMan\x1b[30m      [\xe5\x91\xbc\xe5\x8f\xab\xe5\x99\xa8]\x1b[31m\xe9\x97\x9c\xe9\x96\x89 \x1b[m\x1b[15;21H\x1b[H\x1b[2J\x1b[1;37;44m\xe3\x80\x90\xe6\x9d\xbf\xe4\xb8\xbb:catcatcatcat\xe3\x80\x91           \x1b[33mPython \xe7\xa8\x8b\xe5\xbc\x8f\xe8\xaa\x9e\xe8\xa8\x80\x1b[0;1;37;44m                  \xe7\x9c\x8b\xe6\x9d\xbf\xe3\x80\x8aPython\xe3\x80\x8b\r\n\x1b[m[  \x08\x08\xe2\x86\x90\x1b[2;4H]\xe9\x9b\xa2\xe9\x96\x8b [  \x08\x08\xe2\x86\x92\x1b[2;13H]\xe9\x96\xb1\xe8\xae\x80 [Ctrl-P]\xe7\x99\xbc\xe8\xa1\xa8\xe6\x96\x87\xe7\xab\xa0 [d]\xe5\x88\xaa\xe9\x99\xa4 [z]\xe7\xb2\xbe\xe8\x8f\xaf\xe5\x8d\x80 [i]\xe7\x9c\x8b\xe6\x9d\xbf\xe8\xb3\x87\xe8\xa8\x8a/\xe8\xa8\xad\xe5\xae\x9a [h]\xe8\xaa\xaa\xe6\x98\x8e\r\n\x1b[30;47m   \xe7\xb7\xa8\xe8\x99\x9f    \xe6\x97\xa5 \xe6\x9c\x9f \xe4\xbd\x9c  \xe8\x80\x85       \xe6\x96\x87  \xe7\xab\xa0  \xe6\xa8\x99  \xe9\xa1\x8c                           \xe4\xba\xba\xe6\xb0\xa3:5  \x1b[4;4H\x1b[m8861 +\x1b[1;32m 2\x1b[m11/18 zj4gjcl6       \x08\x08\xe2\x96\xa1\x1b[4;33H [\xe5\x95\x8f\xe9\xa1\x8c] \xe7\xb0\xa1\xe5\x96\xae\xe7\x9a\x84\xe6\xad\xa3\xe5\x89\x87\xe8\xa1\xa8\xe9\x81\x94\xe5\xbc\x8f\xe8\xa8\x98\xe6\xb3\x95?\x1b[5;4H8862 +\x1b[1;32m 1\x1b[m11/18 d8888\x1b[5;31HR: [\xe9\x96\x92\xe8\x81\x8a] \xe6\x95\xb8\xe5\xad\xb8\xe4\xb8\x8d\xe5\xa5\xbd\xe6\x80\x8e\xe9\xba\xbc\xe7\x8e\xa9AI??\x1b[6;4H8863 +\x1b[1;32m 7\x1b[m11/18 \x1b[1;37mVivianAnn      \x08\x08\x1b[m\xe2\x96\xa1\x1b[6;33H [\xe5\x95\x8f\xe9\xa1\x8c] \xe7\x94\xa8pip\xe7\x84\xa1\xe6\xb3\x95\xe5\xae\x89\xe8\xa3\x9dlibyang\x1b[7;4H8864 +\x1b[1;30m  \x1b[m11/18 garlic774      \x08\x08\xe2\x96\xa1\x1b[7;33H [\xe9\x96\x92\xe8\x81\x8a] \xe8\xab\x8b\xe6\x95\x99\xe5\xa6\x82\xe4\xbd\x95\xe6\x8a\x93class\xe4\xb8\x8b\xe9\x9d\xa2\xe7\x9a\x84\xe8\xb3\x87\xe8\xa8\x8a\x1b[8;4H8865 +\x1b[1;30m  \x1b[m11/20 garlic774      \x08\x08\xe2\x96\xa1\x1b[8;33H [\xe5\x95\x8f\xe9\xa1\x8c] Xpath\xe6\x8a\x93\xe4\xb8\x8d\xe5\x88\xb0\xe5\x85\xa7\xe5\xae\xb9\x1b[9;4H8866 +\x1b[1;32m 1\x1b[m11/22 g919233        \x08\x08\xe2\x96\xa1\x1b[9;33H [\xe6\x95\x99\xe5\xad\xb8] \xe7\x80\x8f\xe8\xa6\xbd\xe5\x99\xa8\xe8\x87\xaa\xe5\x8b\x95\xe5\x8c\x96\xe5\xb7\xa5\xe5\x85\xb7 Playwright\xef\xbc\x8c\xe7\x94\xa8\xe6\x96\xbc\xe7\xb6\xb2\x1b[10;4H8867 ~\x1b[1;32m 3\x1b[m11/23 ajjj840569     \x08\x08\xe2\x96\xa1\x1b[10;33H [\xe5\x95\x8f\xe9\xa1\x8c] \xe5\xa6\x82\xe6\x9e\x9c\xe8\xae\x93\xe7\x84\xa1\xe9\x96\x93\xe9\x9a\x94\xe7\x9a\x84\xe9\x80\xa3\xe7\xba\x8c\xe5\xad\x97 \xe6\x8e\xa8\xe5\xbe\x97\xe5\xad\x97\xe5\x85\xb8\xe5\xb0\x8d\xe6\x87\x89\xe5\x80\xbc\xef\xbc\x9f\x1b[11;4H8868 +\x1b[1;32m 2\x1b[m11/23 giuk0717       \x08\x08\xe2\x96\xa1\x1b[11;33H [\xe5\x95\x8f\xe9\xa1\x8c] \xe6\x89\xbe\xe5\x87\xba\xe6\x9c\x80\xe9\x95\xb7\xe9\x9b\x86\xe5\x90\x88\x1b[12;4H8869 +\x1b[1;30m  \x1b[m11/23 areyo\x1b[12;31H  \x08\x08\xe2\x96\xa1\x1b[12;33H [\xe5\x95\x8f\xe9\xa1\x8c] django + apache print\xe4\xb8\xad\xe6\x96\x87\x1b[13;4H8870 +\x1b[1;32m 3\x1b[m11/24 dreambegins    \x08\x08\xe2\x96\xa1\x1b[13;33H [\xe5\x95\x8f\xe9\xa1\x8c] Robot Framework\xe7\x9a\x84\xe8\xaa\x9e\xe6\xb3\x95\xe5\x95\x8f\xe9\xa1\x8c\x1b[14;4H8871 +\x1b[1;30m  \x1b[m11/27 DiamondAse     \x08\x08\xe2\x96\xa1\x1b[14;33H [\xe5\x95\x8f\xe9\xa1\x8c] selenium\xe6\x8a\x93chrom\xe9\x96\x8b\xe8\xb5\xb7\xe7\x9a\x84pdf\xe7\xb6\xb2\xe9\xa0\x81\xe5\x85\x83\xe7\xb4\xa0\xe6\x8a\x93\xe4\xb8\x8d\xe5\x88\xb0\x1b[15;4H8872 +\x1b[1;32m 1\x1b[m11/28 garlic774      \x08\x08\xe2\x96\xa1\x1b[15;33H [\xe5\x95\x8f\xe9\xa1\x8c] \xe5\xa6\x82\xe4\xbd\x95\xe5\x9c\xa8chrome\xe6\x93\xb4\xe5\x85\x85\xe5\xbe\x97\xe5\x88\xb0\xe6\xaa\xa2\xe8\xa6\x96\xe5\x85\x83\xe7\xb4\xa0\xef\xbc\x9f\x1b[16;4H8873 +\x1b[1;30m  \x1b[m11/28 ruthertw       \x08\x08\xe2\x96\xa1\x1b[16;33H [\xe5\x95\x8f\xe9\xa1\x8c] np.transpose\xe7\x9a\x84\xe7\x94\xa8\xe6\xb3\x95\x1b[17;4H8874 +\x1b[1;30m  \x1b[m11/28 nicha115       \x08\x08\xe2\x96\xa1\x1b[17;33H [\xe5\x95\x8f\xe9\xa1\x8c] \xe8\xab\x8b\xe5\x95\x8ftrace\xe5\x8e\x9f\xe5\xa7\x8b\xe7\xa2\xbc\xe5\x95\x8f\xe9\xa1\x8c\x1b[18;4H8875 +\x1b[1;33m10\x1b[m11/29 \x1b[1;37mVivianAnn      \x08\x08\x1b[m\xe2\x96\xa1\x1b[18;33H [\xe5\x95\x8f\xe9\xa1\x8c] leetcode 2029 (Hard) \xe7\x9a\x84\xe5\x95\x8f\xe9\xa1\x8c\x1b[19;4H8876 +\x1b[1;32m 3\x1b[m11/29 a199111222     \x08\x08\xe2\x96\xa1\x1b[19;33H [\xe5\x95\x8f\xe9\xa1\x8c] \xe7\x88\xac\xe8\x9f\xb2\xe7\xaa\x81\xe7\x84\xb6\xe4\xb8\x8d\xe8\x83\xbd\xe8\xb7\x91\xef\xbc\x8c\xe6\xb1\x82\xe8\xa7\xa3\x1b[20;4H8877 +\x1b[1;32m 1\x1b[m11/30 Rasin\x1b[20;31H  \x08\x08\xe2\x96\xa1\x1b[20;33H [\xe5\x95\x8f\xe9\xa1\x8c] numpy dimension\x1b[21;4H8878 +\x1b[1;32m 3\x1b[m11/30 Moonmoon0827   \x08\x08\xe2\x96\xa1\x1b[21;33H [\xe5\x95\x8f\xe9\xa1\x8c] \xe6\x96\xb0\xe6\x89\x8b list to string \xe7\x9a\x84\xe5\x95\x8f\xe9\xa1\x8c\x1b[22;4H8879 +\x1b[1;32m 3\x1b[m12/01 m0911182606    \x08\x08\xe2\x96\xa1\x1b[22;33H [\xe5\x95\x8f\xe9\xa1\x8c] \xe8\xae\x80\xe5\x8f\x96/\xe4\xbf\xae\xe6\x94\xb9\xe6\xaa\x94\xe6\xa1\x88\xe5\x85\xa7\xe5\xae\xb9\xe6\x8c\x87\xe5\xae\x9a\xe5\x8d\x80\xe9\x96\x93\xe6\x96\x87\xe5\xad\x97\r\n>  8880 ~\x1b[1;32m 4\x1b[m12/02 stepfish       \x08\x08\xe2\x96\xa1\x1b[23;33H [\xe8\xb3\x87\xe8\xa8\x8a] \xe5\xb0\x88\xe5\xb1\xac\xe5\xa5\xb3\xe7\x94\x9f\xe7\x9a\x84Python\xe5\x85\xa5\xe9\x96\x80\xe8\xaa\xb2\xef\xbc\x88Pyladies\xe4\xb8\xbb\xe8\xbe\xa6\xef\xbc\x89\r\n\x1b[34;46m \xe6\x96\x87\xe7\xab\xa0\xe9\x81\xb8\xe8\xae\x80 \x1b[30;47m \x1b[31m(y)\x1b[30m\xe5\x9b\x9e\xe6\x87\x89\x1b[31m(X)\x1b[30m\xe6\x8e\xa8\xe6\x96\x87\x1b[31m(^X)\x1b[30m\xe8\xbd\x89\xe9\x8c\x84 \x1b[31m(=[]<>)\x1b[30m\xe7\x9b\xb8\xe9\x97\x9c\xe4\xb8\xbb\xe9\xa1\x8c\x1b[31m(/?a)\x1b[30m\xe6\x89\xbe\xe6\xa8\x99\xe9\xa1\x8c/\xe4\xbd\x9c\xe8\x80\x85 \x1b[31m(b)\x1b[30m\xe9\x80\xb2\xe6\x9d\xbf\xe7\x95\xab\xe9\x9d\xa2  \x1b[m\x1b[23;1H"

    # main menu
    screen = b'7;61H    \x08\x08\x1b[m\xe2\x97\xa4\x1b[7;65H        \x08\x08\xe2\x80\x94\x1b[7;73H\xef\xbc\x8b\x1b[8;17H1   \xe5\xb8\x82\xe6\xb0\x91\xe5\xbb\xa3\xe5\xa0\xb4     \xe5\xa0\xb1\xe5\x91\x8a\xe7\xab\x99\xe9\x95\xb7 PTT\xe5\x92\xac\xe6\x88\x91\x1b[9;17H2   \xe8\x87\xba\xe7\x81\xa3\xe5\xa4\xa7\xe5\xad\xb8     \xe8\x87\xba\xe5\xa4\xa7, \xe8\x87\xba\xe5\xa4\xa7, \xe8\x87\xba\xe5\xa4\xa7\x1b[9;62H[paullai/s75\x1b[10;17H3   \xe6\x94\xbf\xe6\xb2\xbb\xe5\xa4\xa7\xe5\xad\xb8     \xe6\x94\xbf\xe5\xa4\xa7, \xe6\x94\xbf\xe5\xa4\xa7, \xe6\x94\xbf\xe5\xa4\xa7\x1b[10;62H[steve1121/s\x1b[11;17H4   \xe9\x9d\x92\xe8\x98\x8b\xe6\x9e\x9c\xe6\xa8\xb9     \xe6\xa0\xa1\xe5\x9c\x92, \xe7\x8f\xad\xe6\x9d\xbf, \xe7\xa4\xbe\xe5\x9c\x98\x1b[11;62H[dreamwave/f\x1b[12;17H5   \xe6\xb4\xbb\xe5\x8b\x95\xe4\xb8\xad\xe5\xbf\x83     \xe7\xa4\xbe\xe5\x9c\x98, \xe8\x81\x9a\xe6\x9c\x83, \xe5\x9c\x98\xe9\xab\x94\x1b[12;62H[dreamwave/s\x1b[13;17H6   \xe8\xa6\x96\xe8\x81\xbd\xe5\x8a\x87\xe5\xa0\xb4     \xe5\x81\xb6\xe5\x83\x8f, \xe9\x9f\xb3\xe6\xa8\x82, \xe5\xbb\xa3\xe9\x9b\xbb\x1b[13;62H[mousepad\xe4\xbb\xa3]\x1b[14;17H7   \xe6\x88\xb0\xe7\x95\xa5\xe9\xab\x98\xe6\x89\x8b     \xe9\x81\x8a\xe6\x88\xb2, \xe6\x95\xb8\xe4\xbd\x8d, \xe7\xa8\x8b\xe8\xa8\xad\x1b[14;62H[a3225737]\x1b[15;17H8   \xe5\x8d\xa1\xe6\xbc\xab\xe5\xa4\xa2\xe5\xb7\xa5\xe5\xbb\xa0   \xe5\x8d\xa1\xe9\x80\x9a, \xe6\xbc\xab\xe7\x95\xab, \xe5\x8b\x95\xe7\x95\xab\x1b[15;62H[hay955940/k\x1b[16;17H9   \xe7\x94\x9f\xe6\xb4\xbb\xe5\xa8\x9b\xe6\xa8\x82\xe9\xa4\xa8   \xe7\x94\x9f\xe6\xb4\xbb, \xe5\xa8\x9b\xe6\xa8\x82, \xe5\xbf\x83\xe6\x83\x85\x1b[16;62H[Bignana/sky\x1b[17;16H10   \xe5\x9c\x8b\xe5\xae\xb6\xe7\xa0\x94\xe7\xa9\xb6\xe9\x99\xa2   \xe6\x94\xbf\xe6\xb2\xbb, \xe6\x96\x87\xe5\xad\xb8, \xe5\xad\xb8\xe8\xa1\x93\x1b[17;62H[JosephChen/\x1b[18;16H11   \xe5\x9c\x8b\xe5\xae\xb6\xe9\xab\x94\xe8\x82\xb2\xe5\xa0\xb4   \xe6\xb1\x97\xe6\xb0\xb4, \xe9\xac\xa5\xe5\xbf\x97, \xe8\x86\xbd\xe8\xad\x98\x1b[18;62H[JUNstudio]\x1b[19;16H12   \x08\x08\x1b[1;31m\xcb\x87\x1b[19;21H\x1b[m[\xe4\xb8\x89\xe9\x87\x91] \xe9\x87\x91\xe9\xa6\xac58 \xe7\x80\x91\xe5\xb8\x83 \xe5\x9b\x9b\xe7\x8d\x8e\xe5\xa4\xa7\xe8\xb4\x8f\xe5\xae\xb6\x1b[19;62HFelix76116/s\x1b[20;16H13   \x08\x08\x1b[1;31m\xcb\x87\x1b[20;21H\x1b[m[\xe6\xad\xa6\xe6\xbc\xa2\xe8\x82\xba\xe7\x82\x8e] \xe5\x85\xa8\xe5\x9c\x8b\xe4\xba\x8c\xe7\xb4\x9a\xe8\xad\xa6\xe6\x88\x92\x1b[20;62Hswattw/flyin\x1b[21;16H14   \x08\x08\x1b[1;31m\xcb\x87\x1b[21;21H\x1b[m\xe3\x80\x8aQuestCenter\xe3\x80\x8b\xe7\x9c\x8b\xe6\x9d\xbf\xe8\xb3\x87\xe8\xa8\x8a\xe5\x85\xac\xe5\xb8\x83\xe6\xac\x84\x1b[21;62Hzhibb/inhuma\x1b[22;16H15       --> \xe5\x8d\xb3\xe6\x99\x82\xe7\x86\xb1\xe9\x96\x80\xe7\x9c\x8b\xe6\x9d\xbf <--\x1b[23;11H>    16   \x08\x08\x1b[1;31m\xcb\x87\x1b[23;21H\x1b[m[\xe6\xb4\xbb\xe5\x8b\x95] \xe6\x9c\x8d\xe5\x8b\x99\xe8\xad\x89\xe6\x9b\xb8\xe7\x94\xb3\xe8\xab\x8b 12/1-12/10\x1b[23;62HVal/chuo/han\x1b[23;11H\x1b[H\x1b[2J\x1b[1;37;44m\xe3\x80\x90\xe4\xb8\xbb\xe5\x8a\x9f\xe8\x83\xbd\xe8\xa1\xa8\xe3\x80\x91                     \x1b[33m\xe6\x89\xb9\xe8\xb8\xa2\xe8\xb8\xa2\xe5\xaf\xa6\xe6\xa5\xad\xe5\x9d\x8a\x1b[0;1;37;44m                                  \x1b[2;7H  \x08\x08\x1b[0;1;37m\xe2\x97\x8f\x1b[2;9H\x1b[41m      \x08\x08\xe2\x97\xa2\x1b[2;15H  \x08\x08\x1b[47m\xe2\x97\xa4\x1b[2;17H  \x08\x08\x1b[0;30;47m\xe2\x96\x85\x1b[2;19H  \x08\x08\xe2\x96\x85\x1b[2;21H  \x08\x08\x1b[m\xe2\x97\xa3\x1b[2;23H        \x08\x08\x1b[1;37m\xe2\x97\xa2\x1b[2;31H  \x08\x08\xe2\x96\x88\x1b[2;33H  \x08\x08\xe2\x96\x88\x1b[2;35H  \x08\x08\xe2\x96\x88\x1b[2;37H  \x08\x08\xe2\x96\x88\x1b[2;39H  \x08\x08\xe2\x96\x88\x1b[2;41H  \x08\x08\xe2\x96\x88\x1b[2;43H  \x08\x08\xe2\x96\x88\x1b[2;45H  \x08\x08\xe2\x97\xa3\x1b[2;47H      \x08\x08\xe2\x97\xa2\x1b[2;53H  \x08\x08\xe2\x97\xa3\x1b[2;55H      \x08\x08\xe2\x97\xa2\x1b[2;61H  \x08\x08\xe2\x97\xa3\x1b[2;63H      \x08\x08\xe2\x97\xa2\x1b[2;69H  \x08\x08\xe2\x96\x88\x1b[2;71H  \x08\x08\xe2\x96\x88\x1b[2;73H  \x08\x08\xe2\x96\x88\x1b[2;75H  \x08\x08\xe2\x96\x88\x1b[2;77H  \x08\x08\xe2\x96\x88\x1b[2;79H\x1b[3;3H  \x08\x08\xe2\x97\xa2\x1b[3;5H  \x08\x08\xe2\x97\xa3\x1b[3;7H    \x08\x08\x1b[0;31m\xe2\x97\xa5\x1b[3;11H  \x08\x08\x1b[0;1;37;41m\xe2\x97\xa2\x1b[3;13H  \x08\x08\x1b[47m\xe2\x97\xa4\x1b[3;15H     \x08\x08\x1b[0;30;47m\xe2\x97\x8f\x1b[3;20H     \x08\x08\x1b[0;1;31m\xe2\x97\xa3\x1b[3;25H    \x08\x08\x1b[0;1;37m\xe2\x97\xa2\x1b[3;29H  \x08\x08\x1b[46m\xe2\x97\xa4\x1b[3;31H  \x08\x08\x1b[0;1;37m\xe2\x96\x88\x1b[3;33H  \x08\x08\x1b[46m\xe2\x97\xa4\x1b[3;35H  \x08\x08\xe2\x97\xa5\x1b[3;37H  \x08\x08\x1b[0;1;37m\xe2\x96\x88\x1b[3;39H  \x08\x08\x1b[46m\xe2\x97\xa5\x1b[3;41H  \x08\x08\x1b[0;1;37m\xe2\x96\x88\x1b[3;43H  \x08\x08\x1b[46m\xe2\x97\xa5\x1b[3;45H  \x08\x08\x1b[0;1;37m\xe2\x96\x88\x1b[3;47H  \x08\x08\xe2\x97\xa3\x1b[3;49H  \x08\x08\xe2\x97\xa2\x1b[3;51H  \x08\x08\xe2\x96\x88\x1b[3;53H  \x08\x08\xe2\x96\x88\x1b[3;55H  \x08\x08\xe2\x97\xa3\x1b[3;57H  \x08\x08\xe2\x97\xa2\x1b[3;59H  \x08\x08\xe2\x96\x88\x1b[3;61H  \x08\x08\xe2\x96\x88\x1b[3;63H  \x08\x08\xe2\x97\xa3\x1b[3;65H  \x08\x08\xe2\x97\xa2\x1b[3;67H  \x08\x08\x1b[46m\xe2\x97\xa4\x1b[3;69H  \x08\x08\x1b[0;1;37m\xe2\x96\x88\x1b[3;71H  \x08\x08\x1b[46m\xe2\x97\xa4\x1b[3;73H  \x08\x08\xe2\x97\xa5\x1b[3;75H  \x08\x08\x1b[0;1;37m\xe2\x96\x88\x1b[3;77H  \x08\x08\x1b[46m\xe2\x97\xa5\x1b[3;79H\r\n  \x08\x08\x1b[0;1;37m\xe2\x97\xa2\x1b[4;3H  \x08\x08\xe2\x96\x88\x1b[4;5H  \x08\x08\xe2\x96\x88\x1b[4;7H  \x08\x08\xe2\x97\xa3\x1b[4;9H    \x08\x08\x1b[47m\xe2\x97\xa4\x1b[4;13H          \x1b[0;36m    \x08\x08\xe2\x97\xa2\x1b[4;27H  \x08\x08\x1b[0;1;37;46m\xe2\x97\xa4\x1b[4;29H    \x08\x08\xe2\x97\xa4\x1b[4;33H      \x08\x08\xe2\x97\xa5\x1b[4;39H    \x08\x08\xe2\x97\xa5\x1b[4;43H    \x08\x08\xe2\x97\xa5\x1b[4;47H  \x08\x08\xe2\x97\xa5\x1b[4;49H  \x08\x08\xe2\x97\xa4\x1b[4;51H  \x08\x08\xe2\x97\xa4\x1b[4;53H  \x08\x08\xe2\x97\xa4\x1b[4;55H  \x08\x08\xe2\x97\xa5\x1b[4;57H  \x08\x08\xe2\x97\xa4\x1b[4;59H  \x08\x08\xe2\x97\xa4\x1b[4;61H  \x08\x08\xe2\x97\xa4\x1b[4;63H  \x08\x08\xe2\x97\xa5\x1b[4;65H  \x08\x08\xe2\x97\xa4\x1b[4;67H    \x08\x08\xe2\x97\xa4\x1b[4;71H      \x08\x08\xe2\x97\xa5\x1b[4;77H  \x08\x08\x1b[0;36m\xe2\x96\x88\x1b[4;79H\r\n  \x08\x08\x1b[0;1;37;46m\xe2\x97\xa4\x1b[5;3H  \x08\x08\xe2\x97\xa4\x1b[5;5H  \x08\x08\xe2\x97\xa4\x1b[5;7H  \x08\x08\xe2\x97\xa5\x1b[5;9H  \x08\x08\x1b[0;36m\xe2\x97\xa3\x1b[5;11H  \x08\x08\x1b[m\xe2\x97\xa5\x1b[5;13H\x1b[31;47m       \x08\x08\xe2\x97\xa5\x1b[5;20H\x1b[0;41m_  \x08\x08\x1b[0;31m\xe2\x97\xa4\x1b[5;23H  \x08\x08\x1b[36m\xe2\x97\xa2\x1b[5;25H\x1b[0;1;37;46m      \x08\x08\xe2\x95\xad\x1b[5;31H  \x08\x08\xe2\x95\xae\x1b[5;33H  \x08\x08\xe2\x94\x82\x1b[5;35H      \x08\x08\xe2\x95\xad\x1b[5;41H  \x08\x08\xe2\x95\xae\x1b[5;43H                \x08\x08\xe2\x94\x82\x1b[5;59H                  \x08\x08\xe2\x94\x82\x1b[5;77H  \r\n\x1b[0;46m          \x08\x08\x1b[0;36m\xe2\x97\xa4\x1b[6;11H  \x08\x08\x1b[31m\xe2\x97\xa2\x1b[6;13H\x1b[41m        \x1b[0;31m  \x1b[0;1;37;46m        \x08\x08\xe2\x94\x82\x1b[6;31H  \x08\x08\xe2\x94\x82\x1b[6;33H  \x08\x08\xe2\x94\x82\x1b[6;35H  \x08\x08\xe2\x88\x95\x1b[6;37H\xe3\x80\x82  \x08\x08\xe2\x94\x82\x1b[6;41H  \x08\x08\xe2\x94\x82\x1b[6;43H  \x08\x08\xe2\x95\xad\x1b[6;45H  \x08\x08\xe2\x95\xae\x1b[6;47H  \x08\x08\xe2\x95\xad\x1b[6;49H  \x08\x08\xe2\x95\xae\x1b[6;51H  \x08\x08\xe2\x94\x82\x1b[6;53H    \x08\x08\xe2\x94\x82\x1b[6;57H  \x08\x08\xe2\x94\x9c\x1b[6;59H  \x08\x08\xe2\x95\xae\x1b[6;61H  \x08\x08\xe2\x95\xad\x1b[6;63H  \x08\x08\xe2\x95\xae\x1b[6;65H  \x08\x08\xe2\x95\xad\x1b[6;67H  \x08\x08\xe2\x95\xae\x1b[6;69H  \x08\x08\xe2\x95\xad\x1b[6;71H  \x08\x08\xe2\x95\xad\x1b[6;73H  \x08\x08\xe2\x95\xad\x1b[6;75H  \x08\x08\xe2\x94\xa4\x1b[6;77H  \x1b[7;9H  \x08\x08\x1b[m\xe2\x97\xa2\x1b[7;11H  \x08\x08\x1b[31;47m\xe2\x97\xa2\x1b[7;13H  \x08\x08\xe2\x97\xa4\x1b[7;15H  \x08\x08\x1b[30m\xe2\x95\xb2\x1b[7;17H_     \x08\x08\x1b[m\xe2\x97\xa3\x1b[7;23H        \x08\x08\x1b[1;37m\xe2\x95\xb0\x1b[7;31H  \x08\x08\xe2\x95\xae\x1b[7;33H  \x08\x08\xe2\x94\x9c\x1b[7;35H  \x08\x08\xe2\x95\xae\x1b[7;37H  \x08\x08\xe2\x94\x82\x1b[7;39H  \x08\x08\xe2\x95\xb0\x1b[7;41H  \x08\x08\xe2\x95\xae\x1b[7;43H  \x08\x08\xe2\x94\x82\x1b[7;45H  \x08\x08\xe2\x94\x82\x1b[7;47H  \x08\x08\xe2\x94\x82\x1b[7;49H  \x08\x08\xe2\x94\x82\x1b[7;51H  \x08\x08\xe2\x94\x82\x1b[7;53H  \x08\x08\xe2\x94\x82\x1b[7;55H  \x08\x08\xe2\x94\x82\x1b[7;57H  \x08\x08\xe2\x94\x82\x1b[7;59H  \x08\x08\xe2\x94\x82\x1b[7;61H  \x08\x08\xe2\x94\x82\x1b[7;63H  \x08\x08\xe2\x94\x82\x1b[7;65H  \x08\x08\xe2\x95\xad\x1b[7;67H  \x08\x08\xe2\x94\xa4\x1b[7;69H  \x08\x08\xe2\x94\x9c\x1b[7;71H  \x08\x08\xe2\x95\xaf\x1b[7;73H  \x08\x08\xe2\x94\x82\x1b[7;75H  \x08\x08\xe2\x94\x82\x1b[7;77H\r\n  \x08\x08\x1b[30m\xe2\x95\xad\x1b[8;3H  \x08\x08\xe2\x94\x80\x1b[8;5H  \x08\x08\xe2\x94\x80\x1b[8;7H  \x08\x08\xe2\x94\x80\x1b[8;9H  \x08\x08\x1b[0;31;47m\xe2\x97\xa2\x1b[8;11H  \x08\x08\xe2\x97\xa4\x1b[8;13H       \x08\x08\x1b[30m\xe2\x97\xa5\x1b[8;20H  \x08\x08\xe2\x96\x8e\x1b[8;22H \x1b[0;30m  \x1b[0;1;37;44m      \x08\x08\xe2\x94\x82\x1b[8;31H  \x08\x08\xe2\x94\x82\x1b[8;33H  \x08\x08\xe2\x94\x82\x1b[8;35H  \x08\x08\xe2\x94\x82\x1b[8;37H    \x08\x08\xe2\x94\x82\x1b[8;41H  \x08\x08\xe2\x94\x82\x1b[8;43H  \x08\x08\xe2\x94\x82\x1b[8;45H  \x08\x08\xe2\x94\x82\x1b[8;47H  \x08\x08\xe2\x95\xb0\x1b[8;49H  \x08\x08\xe2\x95\xaf\x1b[8;51H  \x08\x08\xe2\x95\xb0\x1b[8;53H  \x08\x08\xe2\x94\xb4\x1b[8;55H  \x08\x08\xe2\x95\xaf\x1b[8;57H  \x08\x08\xe2\x94\x9c\x1b[8;59H  \x08\x08\xe2\x95\xaf\x1b[8;61H  \x08\x08\xe2\x95\xb0\x1b[8;63H  \x08\x08\xe2\x95\xaf\x1b[8;65H  \x08\x08\xe2\x95\xb0\x1b[8;67H  \x08\x08\xe2\x94\xa4\x1b[8;69H  \x08\x08\xe2\x94\x82\x1b[8;71H    \x08\x08\xe2\x95\xb0\x1b[8;75H  \x08\x08\xe2\x94\xa4\x1b[8;77H  \r\n  \x08\x08\x1b[0;1;30m\xe2\x95\xb0\x1b[9;3H  \x08\x08\xe2\x94\x80\x1b[9;5H  \x08\x08\xe2\x94\x80\x1b[9;7H  \x08\x08\xe2\x94\x80\x1b[9;9H\x1b[0;30;47m     ____  \x08\x08\xe2\x95\xb1\x1b[9;20H   \x1b[0;30m  \x1b[0;1;37;44m      \x08\x08\xe2\x95\xb0\x1b[9;31H  \x08\x08\xe2\x95\xaf\x1b[9;33H    \x08\x08\xe2\x94\x82\x1b[9;37H    \x08\x08\xe2\x95\xb0\x1b[9;41H  \x08\x08\xe2\x95\xaf\x1b[9;43H                                    \r\n  \x08\x08\x1b[0;34m\xe2\x96\x84\x1b[10;3H  \x08\x08\xe2\x96\x84\x1b[10;5H  \x08\x08\xe2\x96\x84\x1b[10;7H  \x1b[30;47m      \x08\x08\xe2\x97\xa2\x1b[10;15H  \x08\x08\xe2\x97\xa4\x1b[10;17H      \x1b[0;30m      \x1b[0;1;37;44m        \x08\x08\xe2\x94\x82\x1b[10;37H  \x1b[36m\xe6\xad\xa1 \xe8\xbf\x8e \xe5\xa4\xa7 \xe5\xae\xb6 \xe4\xbe\x86 \xe6\xbb\x91 \xe9\x9b\xaa \xe6\x9d\xbf \xe9\x80\x9b \xe9\x80\x9b \xe5\x93\xa6 !      \x1b[11;9H  \x08\x08\x1b[m\xe2\x97\xa5\x1b[11;11H  \x08\x08\x1b[30;47m\xe2\x97\xa2\x1b[11;13H  \x08\x08\xe2\x97\xa4\x1b[11;15H        \x08\x08\x1b[m\xe2\x97\xa4\x1b[11;23H  \x08\x08\x1b[33m\xe2\x97\xa2\x1b[11;25H\x1b[43m  \x1b[0;33m  \x1b[44m                                                  \x1b[12;2H\x1b[1;30;43mby fuxk  \x08\x08\x1b[0;30;43m\xe2\x97\xa2\x1b[12;11H  \x08\x08\xe2\x97\xa4\x1b[12;13H\x1b[1mfuxk fuxk   \x08\x08\x1b[0;33m\xe2\x97\xa4\x1b[12;25H    \x1b[1;44m\xe3\x80\x90\xe5\x9c\x8b\xe5\xae\xb6\xe9\xab\x94\xe8\x82\xb2\xe5\xa0\xb4\xe3\x80\x91   \x08\x08\xe2\x86\x92\x1b[12;46H \xe3\x80\x90PttSport\xe3\x80\x91   \x08\x08\xe2\x86\x92\x1b[12;62H \xe3\x80\x90SkiSnowboard\xe3\x80\x91\x1b[13;23H\x1b[m(\x1b[1;36mA\x1b[m)nnounce     \xe3\x80\x90 \xe7\xb2\xbe\xe8\x8f\xaf\xe5\x85\xac\xe4\xbd\x88\xe6\xac\x84 \xe3\x80\x91\x1b[14;23H(\x1b[1;36mF\x1b[m)avorite     \xe3\x80\x90 \xe6\x88\x91 \xe7\x9a\x84 \xe6\x9c\x80\xe6\x84\x9b \xe3\x80\x91\x1b[15;23H(\x1b[1;36mC\x1b[m)lass\x1b[15;38H\xe3\x80\x90 \xe5\x88\x86\xe7\xb5\x84\xe8\xa8\x8e\xe8\xab\x96\xe5\x8d\x80 \xe3\x80\x91\x1b[16;23H(\x1b[1;36mM\x1b[m)ail\x1b[16;38H\xe3\x80\x90 \xe7\xa7\x81\xe4\xba\xba\xe4\xbf\xa1\xe4\xbb\xb6\xe5\x8d\x80 \xe3\x80\x91\x1b[17;23H(\x1b[1;36mT\x1b[m)alk\x1b[17;38H\xe3\x80\x90 \xe4\xbc\x91\xe9\x96\x92\xe8\x81\x8a\xe5\xa4\xa9\xe5\x8d\x80 \xe3\x80\x91\x1b[18;23H(\x1b[1;36mU\x1b[m)ser\x1b[18;38H\xe3\x80\x90 \xe5\x80\x8b\xe4\xba\xba\xe8\xa8\xad\xe5\xae\x9a\xe5\x8d\x80 \xe3\x80\x91\x1b[19;23H(\x1b[1;36mX\x1b[m)yz\x1b[19;38H\xe3\x80\x90 \xe7\xb3\xbb\xe7\xb5\xb1\xe8\xb3\x87\xe8\xa8\x8a\xe5\x8d\x80 \xe3\x80\x91\x1b[20;23H(\x1b[1;36mP\x1b[m)lay\x1b[20;38H\xe3\x80\x90 \xe5\xa8\x9b\xe6\xa8\x82\xe8\x88\x87\xe4\xbc\x91\xe9\x96\x92 \xe3\x80\x91\x1b[21;23H(\x1b[1;36mN\x1b[m)amelist     \xe3\x80\x90 \xe7\xb7\xa8\xe7\x89\xb9\xe5\x88\xa5\xe5\x90\x8d\xe5\x96\xae \xe3\x80\x91\x1b[22;21H> (\x1b[1;36mG\x1b[m)oodbye\x1b[22;41H\xe9\x9b\xa2\xe9\x96\x8b\xef\xbc\x8c\xe5\x86\x8d\xe8\xa6\x8b  \x08\x08\xe2\x80\xa6\x1b[22;53H\r\n\n\x1b[34;46m[12/4 \xe6\x98\x9f\xe6\x9c\x9f\xe5\x85\xad 16:24]\x1b[1;33;45m [ \xe5\xb0\x84\xe6\x89\x8b\xe6\x99\x82 ]   \x1b[30;47m \xe7\xb7\x9a\xe4\xb8\x8a\x1b[31m66945\x1b[30m\xe4\xba\xba, \xe6\x88\x91\xe6\x98\xaf\x1b[31mCodingMan\x1b[30m      [\xe5\x91\xbc\xe5\x8f\xab\xe5\x99\xa8]\x1b[31m\xe9\x97\x9c\xe9\x96\x89 \x1b[m\x1b[22;21H'

    # query post
    screen = b'\x1b[H\x1b[2J\x1b[1;30m\xe3\x80\x90\xe6\x9d\xbf\xe4\xb8\xbb:catcatcatcat\xe3\x80\x91           Python \xe7\xa8\x8b\xe5\xbc\x8f\xe8\xaa\x9e\xe8\xa8\x80                  \xe7\x9c\x8b\xe6\x9d\xbf\xe3\x80\x8aPython\xe3\x80\x8b \r\n[  \x08\x08\xe2\x86\x90\x1b[2;4H]\xe9\x9b\xa2\xe9\x96\x8b [  \x08\x08\xe2\x86\x92\x1b[2;13H]\xe9\x96\xb1\xe8\xae\x80 [Ctrl-P]\xe7\x99\xbc\xe8\xa1\xa8\xe6\x96\x87\xe7\xab\xa0 [d]\xe5\x88\xaa\xe9\x99\xa4 [z]\xe7\xb2\xbe\xe8\x8f\xaf\xe5\x8d\x80 [i]\xe7\x9c\x8b\xe6\x9d\xbf\xe8\xb3\x87\xe8\xa8\x8a/\xe8\xa8\xad\xe5\xae\x9a [h]\xe8\xaa\xaa\xe6\x98\x8e   \r\n\n\x1b[0;1;37m>     1   112/09 ericsk         \x08\x08\xe2\x96\xa1\x1b[4;33H [\xe5\xbf\x83\xe5\xbe\x97] \xe7\xb5\x82\xe6\x96\xbc\xe9\x96\x8b\xe6\x9d\xbf\xe4\xba\x86                              \r\n  \x08\x08\x1b[m\xe2\x94\x8c\x1b[5;3H  \x08\x08\xe2\x94\x80\x1b[5;5H  \x08\x08\xe2\x94\x80\x1b[5;7H  \x08\x08\xe2\x94\x80\x1b[5;9H  \x08\x08\xe2\x94\x80\x1b[5;11H  \x08\x08\xe2\x94\x80\x1b[5;13H  \x08\x08\xe2\x94\x80\x1b[5;15H  \x08\x08\xe2\x94\x80\x1b[5;17H  \x08\x08\xe2\x94\x80\x1b[5;19H  \x08\x08\xe2\x94\x80\x1b[5;21H  \x08\x08\xe2\x94\x80\x1b[5;23H  \x08\x08\xe2\x94\x80\x1b[5;25H  \x08\x08\xe2\x94\x80\x1b[5;27H  \x08\x08\xe2\x94\x80\x1b[5;29H  \x08\x08\xe2\x94\x80\x1b[5;31H  \x08\x08\xe2\x94\x80\x1b[5;33H  \x08\x08\xe2\x94\x80\x1b[5;35H  \x08\x08\xe2\x94\x80\x1b[5;37H  \x08\x08\xe2\x94\x80\x1b[5;39H  \x08\x08\xe2\x94\x80\x1b[5;41H  \x08\x08\xe2\x94\x80\x1b[5;43H  \x08\x08\xe2\x94\x80\x1b[5;45H  \x08\x08\xe2\x94\x80\x1b[5;47H  \x08\x08\xe2\x94\x80\x1b[5;49H  \x08\x08\xe2\x94\x80\x1b[5;51H  \x08\x08\xe2\x94\x80\x1b[5;53H  \x08\x08\xe2\x94\x80\x1b[5;55H  \x08\x08\xe2\x94\x80\x1b[5;57H  \x08\x08\xe2\x94\x80\x1b[5;59H  \x08\x08\xe2\x94\x80\x1b[5;61H  \x08\x08\xe2\x94\x80\x1b[5;63H  \x08\x08\xe2\x94\x80\x1b[5;65H  \x08\x08\xe2\x94\x80\x1b[5;67H  \x08\x08\xe2\x94\x80\x1b[5;69H  \x08\x08\xe2\x94\x80\x1b[5;71H  \x08\x08\xe2\x94\x80\x1b[5;73H  \x08\x08\xe2\x94\x80\x1b[5;75H  \x08\x08\xe2\x94\x80\x1b[5;77H  \x08\x08\xe2\x94\x90\x1b[5;79H\r\n  \x08\x08\xe2\x94\x82\x1b[6;3H \xe6\x96\x87\xe7\xab\xa0\xe4\xbb\xa3\xe7\xa2\xbc(AID): \x1b[1;37m#13cPSYOX \x1b[m(Python) [ptt.cc] [\xe5\xbf\x83\xe5\xbe\x97] \xe7\xb5\x82\xe6\x96\xbc\xe9\x96\x8b\xe6\x9d\xbf\xe4\xba\x86\x1b[6;77H  \x08\x08\xe2\x94\x82\x1b[6;79H\r\n  \x08\x08\xe2\x94\x82\x1b[7;3H \xe6\x96\x87\xe7\xab\xa0\xe7\xb6\xb2\xe5\x9d\x80: \x1b[1;37mhttps://www.ptt.cc/bbs/Python/M.1134139170.A.621.html\x1b[7;77H  \x08\x08\x1b[m\xe2\x94\x82\x1b[7;79H\r\n  \x08\x08\xe2\x94\x82\x1b[8;3H \xe9\x80\x99\xe4\xb8\x80\xe7\xaf\x87\xe6\x96\x87\xe7\xab\xa0\xe5\x80\xbc 2 Ptt\xe5\xb9\xa3\x1b[8;77H  \x08\x08\xe2\x94\x82\x1b[8;79H\r\n  \x08\x08\xe2\x94\x94\x1b[9;3H  \x08\x08\xe2\x94\x80\x1b[9;5H  \x08\x08\xe2\x94\x80\x1b[9;7H  \x08\x08\xe2\x94\x80\x1b[9;9H  \x08\x08\xe2\x94\x80\x1b[9;11H  \x08\x08\xe2\x94\x80\x1b[9;13H  \x08\x08\xe2\x94\x80\x1b[9;15H  \x08\x08\xe2\x94\x80\x1b[9;17H  \x08\x08\xe2\x94\x80\x1b[9;19H  \x08\x08\xe2\x94\x80\x1b[9;21H  \x08\x08\xe2\x94\x80\x1b[9;23H  \x08\x08\xe2\x94\x80\x1b[9;25H  \x08\x08\xe2\x94\x80\x1b[9;27H  \x08\x08\xe2\x94\x80\x1b[9;29H  \x08\x08\xe2\x94\x80\x1b[9;31H  \x08\x08\xe2\x94\x80\x1b[9;33H  \x08\x08\xe2\x94\x80\x1b[9;35H  \x08\x08\xe2\x94\x80\x1b[9;37H  \x08\x08\xe2\x94\x80\x1b[9;39H  \x08\x08\xe2\x94\x80\x1b[9;41H  \x08\x08\xe2\x94\x80\x1b[9;43H  \x08\x08\xe2\x94\x80\x1b[9;45H  \x08\x08\xe2\x94\x80\x1b[9;47H  \x08\x08\xe2\x94\x80\x1b[9;49H  \x08\x08\xe2\x94\x80\x1b[9;51H  \x08\x08\xe2\x94\x80\x1b[9;53H  \x08\x08\xe2\x94\x80\x1b[9;55H  \x08\x08\xe2\x94\x80\x1b[9;57H  \x08\x08\xe2\x94\x80\x1b[9;59H  \x08\x08\xe2\x94\x80\x1b[9;61H  \x08\x08\xe2\x94\x80\x1b[9;63H  \x08\x08\xe2\x94\x80\x1b[9;65H  \x08\x08\xe2\x94\x80\x1b[9;67H  \x08\x08\xe2\x94\x80\x1b[9;69H  \x08\x08\xe2\x94\x80\x1b[9;71H  \x08\x08\xe2\x94\x80\x1b[9;73H  \x08\x08\xe2\x94\x80\x1b[9;75H  \x08\x08\xe2\x94\x80\x1b[9;77H  \x08\x08\xe2\x94\x98\x1b[9;79H\r\n\n\x1b[1;30m      8    12/10 Fenikso        \x08\x08\xe2\x96\xa1\x1b[11;33H \xe8\xb3\x80                                             \r\n      9    12/10 asf423         \x08\x08\xe2\x96\xa1\x1b[12;33H \xe8\xb3\x80\xe9\x96\x8b\xe7\x89\x88                                         \r\n     10    12/10 rofu           \x08\x08\xe2\x96\xa1\x1b[13;33H \xe8\xb3\x80\xe9\x96\x8b\xe7\x89\x88                                         \r\n     11    12/10 NewYork        \x08\x08\xe2\x96\xa1\x1b[14;33H \xe8\xb3\x80                                             \r\n     12    12/10 abacada        \x08\x08\xe2\x96\xa1\x1b[15;33H \xe6\x81\xad\xe5\x96\x9c\xe9\x96\x8b\xe6\x9d\xbf                                       \r\n     13    12/10 jftsai         \x08\x08\xe2\x96\xa1\x1b[16;33H \xe6\x81\xad\xe5\x96\x9c                                           \r\n     14    12/11 aceace         \x08\x08\xe2\x96\xa1\x1b[17;33H \xe8\xbb\x8a\xe8\xbb\x8a\xe8\xbb\x8a\xe8\xbb\x8a\xe8\xbb\x8a\xe8\xbb\x8a\xe8\xbb\x8a\xe8\xbb\x8a\xe8\xbb\x8a\xe8\xbb\x8a\xe8\xbb\x8a\xe8\xbb\x8a\xe8\xbb\x8a\xe8\xbb\x8a\xe8\xbb\x8a\xe4\xbe\x86\xe4\xba\x86             \r\n     15    12/11 polaristin     \x08\x08\xe2\x96\xa1\x1b[18;33H \xe8\xb3\x80\xe9\x96\x8b\xe6\x9d\xbf XD                                      \r\n     16    12/11 jingel         \x08\x08\xe2\x96\xa1\x1b[19;33H \xe6\x81\xad\xe5\x96\x9c\xe9\x96\x8b\xe6\x9d\xbf                                       \r\n     17    12/11 milen          \x08\x08\xe2\x96\xa1\x1b[20;33H \xe6\x81\xad\xe5\x96\x9c\xe9\x96\x8b\xe6\x9d\xbf!!~~^^~~                               \r\n     18    12/12 littlebear     \x08\x08\xe2\x96\xa1\x1b[21;33H \xe6\x81\xad\xe5\x96\x9c\xe9\x96\x8b\xe6\x9d\xbf...........^^^^                        \r\n     19    12/12 zhouer         \x08\x08\xe2\x96\xa1\x1b[22;33H [\xe9\x87\x8e\xe4\xba\xba\xe7\x8d\xbb\xe6\x9b\x9d] List Comprehensions                 \r\n     20    12/12 tippy          \x08\x08\xe2\x96\xa1\x1b[23;33H [\xe5\xbf\x83\xe5\xbe\x97] httplib                                 \r\n\x1b[34;44m   \x08\x08\xe2\x96\x84\x1b[24;4H  \x08\x08\xe2\x96\x84\x1b[24;6H  \x08\x08\xe2\x96\x84\x1b[24;8H  \x08\x08\xe2\x96\x84\x1b[24;10H  \x08\x08\xe2\x96\x84\x1b[24;12H  \x08\x08\xe2\x96\x84\x1b[24;14H  \x08\x08\xe2\x96\x84\x1b[24;16H  \x08\x08\xe2\x96\x84\x1b[24;18H  \x08\x08\xe2\x96\x84\x1b[24;20H  \x08\x08\xe2\x96\x84\x1b[24;22H  \x08\x08\xe2\x96\x84\x1b[24;24H  \x08\x08\xe2\x96\x84\x1b[24;26H  \x08\x08\xe2\x96\x84\x1b[24;28H  \x08\x08\xe2\x96\x84\x1b[24;30H  \x08\x08\xe2\x96\x84\x1b[24;32H\x1b[0;1;37;44m \xe8\xab\x8b\xe6\x8c\x89\xe4\xbb\xbb\xe6\x84\x8f\xe9\x8d\xb5\xe7\xb9\xbc\xe7\xba\x8c   \x08\x08\x1b[34m\xe2\x96\x84\x1b[24;50H  \x08\x08\xe2\x96\x84\x1b[24;52H  \x08\x08\xe2\x96\x84\x1b[24;54H  \x08\x08\xe2\x96\x84\x1b[24;56H  \x08\x08\xe2\x96\x84\x1b[24;58H  \x08\x08\xe2\x96\x84\x1b[24;60H  \x08\x08\xe2\x96\x84\x1b[24;62H  \x08\x08\xe2\x96\x84\x1b[24;64H  \x08\x08\xe2\x96\x84\x1b[24;66H  \x08\x08\xe2\x96\x84\x1b[24;68H  \x08\x08\xe2\x96\x84\x1b[24;70H  \x08\x08\xe2\x96\x84\x1b[24;72H  \x08\x08\xe2\x96\x84\x1b[24;74H  \x08\x08\xe2\x96\x84\x1b[24;76H  \x08\x08\xe2\x96\x84\x1b[24;78H  \x1b[m'

    # test post
    screen = b'\x1b[H\x1b[2J\x1b[24;1H\n\x1b[K\x1b[H\n\xe5\xa6\x82\xe6\x9e\x9c\xe4\xbd\xa0\xe9\x82\x84\xe4\xb8\x8d\xe7\x9f\xa5\xe9\x81\x93\xe5\xa6\x82\xe4\xbd\x95\xe4\xbd\xbf\xe7\x94\xa8 Python \xe6\x93\x8d\xe4\xbd\x9c PTT\r\n\xe9\x82\xa3 PTT Library \xe6\x9c\x83\xe6\x98\xaf\xe4\xbd\xa0\xe4\xb8\x8d\xe9\x8c\xaf\xe7\x9a\x84\xe9\x81\xb8\xe6\x93\x87\xe3\x80\x82\r\n\nPTT Library \xe6\x95\xb4\xe7\x90\x86\xe4\xba\x86\xe7\xb6\xb2\xe8\xb7\xaf\xe4\xb8\x8a\xe8\xb7\x9f PTT \xe6\x89\x93\xe4\xba\xa4\xe9\x81\x93\xe7\x9a\x84\xe7\xa8\x8b\xe5\xbc\x8f\xe7\xa2\xbc\r\n\xe6\x9c\x9f\xe6\x9c\x9b\xe5\x9c\xa8 Python \xe5\x8f\xaf\xe4\xbb\xa5\xe6\x8f\x90\xe4\xbe\x9b\xe4\xb8\x80\xe5\x80\x8b\xe7\xa9\xa9\xe5\xae\x9a\xe5\xae\x8c\xe6\x95\xb4\xe7\x9a\x84\xe6\x9c\x8d\xe5\x8b\x99\r\n\n\xe5\xa6\x82\xe6\x9e\x9c\xe4\xbd\xa0\xe6\x9c\x89 PTT Library \xe5\xb0\x9a\xe6\x9c\xaa\xe6\x94\xb6\xe8\x97\x8f\xe7\x9a\x84\xe5\x8a\x9f\xe8\x83\xbd\r\n\xe6\xad\xa1\xe8\xbf\x8e\xe6\x8f\x90\xe5\x87\xba pull request :D\r\n\n\xe4\xbb\xa5\xe4\xb8\x8b\xe6\x98\xaf\xe6\x88\x91\xe6\x9c\x80\xe8\xbf\x91\xe6\x94\xb9\xe7\x89\x88\xe7\x9a\x84\xe9\x87\x8d\xe9\xbb\x9e\r\n\n1. \xe6\x9e\xb6\xe6\xa7\x8b\xe6\x89\x93\xe6\x8e\x89\xe9\x87\x8d\xe7\xb7\xb4\xef\xbc\x8c\xe4\xbb\xa5\xe6\x8f\x90\xe5\x8d\x87\xe9\x96\xb1\xe8\xae\x80\xe8\x88\x87\xe7\xb6\xad\xe8\xad\xb7\xe6\x80\xa7\xef\xbc\x8c\xe7\xac\xa6\xe5\x90\x88 PEP8 \xe9\xa2\xa8\xe6\xa0\xbc\xe8\xa6\x8f\xe7\xaf\x84\r\n2. \xe6\x94\xaf\xe6\x8f\xb4\xe6\x9c\x80\xe6\x96\xb0 WebSocket \xe9\x80\xa3\xe7\xb7\x9a\xe6\xa8\xa1\xe5\xbc\x8f\r\n3. \xe6\x94\xaf\xe6\x8f\xb4\xe5\xa4\x9a\xe5\x9c\x8b\xe8\xaa\x9e\xe7\xb3\xbb\xef\xbc\x8c\xe8\x8b\xb1\xe6\x96\x87\xe8\x88\x87\xe7\xb9\x81\xe9\xab\x94\xe4\xb8\xad\xe6\x96\x87\r\n4. \xe6\x96\xbc Windows 10, Ubuntu 18.04 and MacOS 10.14 \xe6\xb8\xac\xe8\xa9\xa6\r\n5. \xe4\xbf\xae\xe6\xad\xa3\xe5\x9c\xa8\xe5\x89\x8d\xe4\xb8\x80\xe7\x89\x88\xe6\x94\xb6\xe9\x9b\x86\xe5\x88\xb0\xe7\x9a\x84\xe5\x95\x8f\xe9\xa1\x8c\r\n\ngithub: https://github.com/Truth0906/PTTLibrary\r\n\n\xe5\xa6\x82\xe6\x9e\x9c\xe4\xbd\xa0\xe5\x96\x9c\xe6\xad\xa1\xef\xbc\x8c\xe6\xad\xa1\xe8\xbf\x8e\xe7\xb5\xa6\xe6\x88\x91\xe5\x80\x8b\xe6\x98\x9f\xe6\x98\x9f :D\r\n--\r\n  \x08\x08\x1b[32m\xe2\x80\xbb\x1b[23;3H \xe7\x99\xbc\xe4\xbf\xa1\xe7\xab\x99: \xe6\x89\xb9\xe8\xb8\xa2\xe8\xb8\xa2\xe5\xaf\xa6\xe6\xa5\xad\xe5\x9d\x8a(ptt.cc), \xe4\xbe\x86\xe8\x87\xaa: 111.243.146.98 (\xe8\x87\xba\xe7\x81\xa3)\r\n\x1b[34;46m  \xe7\x80\x8f\xe8\xa6\xbd \xe7\xac\xac 1/2 \xe9\xa0\x81 ( 34%) \x1b[1;30;47m \xe7\x9b\xae\xe5\x89\x8d\xe9\xa1\xaf\xe7\xa4\xba: \xe7\xac\xac 06~28 \xe8\xa1\x8c\x1b[0;47m  \x1b[31m(y)\x1b[30m\xe5\x9b\x9e\xe6\x87\x89\x1b[31m(X%)\x1b[30m\xe6\x8e\xa8\xe6\x96\x87\x1b[31m(h)\x1b[30m\xe8\xaa\xaa\xe6\x98\x8e\x1b[31m(  \x08\x08\xe2\x86\x90\x1b[24;74H)\x1b[30m\xe9\x9b\xa2\xe9\x96\x8b \x1b[m'

    p = VT100Parser(screen, 'utf-8')
    print(p.screen)
