"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from friendli.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class ParametersTypedDict(TypedDict):
    r"""The parameters the functions accepts, described as a JSON Schema object.
    To represent a function with no parameters, use the value `{\"type\": \"object\", \"properties\": {}}`.

    """


class Parameters(BaseModel):
    r"""The parameters the functions accepts, described as a JSON Schema object.
    To represent a function with no parameters, use the value `{\"type\": \"object\", \"properties\": {}}`.

    """


class FunctionTypedDict(TypedDict):
    name: str
    r"""The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""
    parameters: ParametersTypedDict
    r"""The parameters the functions accepts, described as a JSON Schema object.
    To represent a function with no parameters, use the value `{\"type\": \"object\", \"properties\": {}}`.

    """
    description: NotRequired[Nullable[str]]
    r"""A description of what the function does, used by the model to choose when and how to call the function."""


class Function(BaseModel):
    name: str
    r"""The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""

    parameters: Parameters
    r"""The parameters the functions accepts, described as a JSON Schema object.
    To represent a function with no parameters, use the value `{\"type\": \"object\", \"properties\": {}}`.

    """

    description: OptionalNullable[str] = UNSET
    r"""A description of what the function does, used by the model to choose when and how to call the function."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description"]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
