"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from friendli.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


Type = Literal["text", "json_object", "regex"]
r"""Type of the response format."""


class ResponseFormatTypedDict(TypedDict):
    r"""The enforced format of the model's output.

    Note that the content of the output message may be truncated if it exceeds the `max_tokens`.
    You can check this by verifying that the `finish_reason` of the output message is `length`.

    ***Important***
    You must explicitly instruct the model to produce the desired output format using a system prompt or user message (e.g., `You are an API generating a valid JSON as output.`).
    Otherwise, the model may result in an unending stream of whitespace or other characters.

    """

    type: Type
    r"""Type of the response format."""
    schema_: NotRequired[str]
    r"""The schema of the output. For `{ \"type\": \"json_object\" }`, `schema` should be a serialized string of JSON schema. For `{ \"type\": \"regex\" }`, `schema` should be a regex pattern.

    ***Caveat***
    For the JSON object type, recursive definitions are not supported. Optional properties are also not supported; all properties of `{ \"type\": \"object\" }` are generated regardless of whether they are listed in the `required` field.
    For the regex type, lookaheads/lookbehinds (e.g., `\a`, `\z`, `^`, `$`, `(?=)`, `(?!)`, `(?<=...)`, `(?<!...)`) are not supported. Group specials (e.g., `\w`, `\W`, `\d`, `\D`, `\s`, `\S`) do not support non-ASCII characters. Unicode escape patterns (e.g., `\N`, `\p`, `\P`) are not supported. Additionally, conditional matching (`(?(`) and back-references can cause inefficiency.

    """


class ResponseFormat(BaseModel):
    r"""The enforced format of the model's output.

    Note that the content of the output message may be truncated if it exceeds the `max_tokens`.
    You can check this by verifying that the `finish_reason` of the output message is `length`.

    ***Important***
    You must explicitly instruct the model to produce the desired output format using a system prompt or user message (e.g., `You are an API generating a valid JSON as output.`).
    Otherwise, the model may result in an unending stream of whitespace or other characters.

    """

    type: Type
    r"""Type of the response format."""

    schema_: Annotated[Optional[str], pydantic.Field(alias="schema")] = None
    r"""The schema of the output. For `{ \"type\": \"json_object\" }`, `schema` should be a serialized string of JSON schema. For `{ \"type\": \"regex\" }`, `schema` should be a regex pattern.

    ***Caveat***
    For the JSON object type, recursive definitions are not supported. Optional properties are also not supported; all properties of `{ \"type\": \"object\" }` are generated regardless of whether they are listed in the `required` field.
    For the regex type, lookaheads/lookbehinds (e.g., `\a`, `\z`, `^`, `$`, `(?=)`, `(?!)`, `(?<=...)`, `(?<!...)`) are not supported. Group specials (e.g., `\w`, `\W`, `\d`, `\D`, `\s`, `\S`) do not support non-ASCII characters. Unicode escape patterns (e.g., `\N`, `\p`, `\P`) are not supported. Additionally, conditional matching (`(?(`) and back-references can cause inefficiency.

    """
