"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from friendli.types import BaseModel
from friendli.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


Name = Literal[
    "math:calculator",
    "math:statistics",
    "math:calendar",
    "web:search",
    "web:url",
    "code:python-interpreter",
    "file:text",
    "rag:knowledge-base",
]
r"""The name of the built-in tool."""

Status = Literal["STARTED", "UPDATING", "ENDED", "ERRORED"]
r"""Indicates the current execution status of the tool."""


class StreamedToolAssistedChatToolStatusParametersTypedDict(TypedDict):
    name: str
    r"""The name of the tool’s function parameter."""
    value: str
    r"""The value of the tool’s function parameter."""


class StreamedToolAssistedChatToolStatusParameters(BaseModel):
    name: str
    r"""The name of the tool’s function parameter."""

    value: str
    r"""The value of the tool’s function parameter."""


class FilesTypedDict(TypedDict):
    name: str
    r"""The name of the file generated by the tool’s execution."""
    url: str
    r"""URL of the file generated by the tool’s execution."""


class Files(BaseModel):
    name: str
    r"""The name of the file generated by the tool’s execution."""

    url: str
    r"""URL of the file generated by the tool’s execution."""


class ErrorTypedDict(TypedDict):
    type: str
    r"""The type of error encountered during the tool’s execution."""
    msg: str
    r"""The message of error."""


class Error(BaseModel):
    type: str
    r"""The type of error encountered during the tool’s execution."""

    msg: str
    r"""The message of error."""


class StreamedToolAssistedChatToolStatusDataTypedDict(TypedDict):
    tool_call_id: str
    r"""The ID of the tool call."""
    name: Name
    r"""The name of the built-in tool."""
    status: Status
    r"""Indicates the current execution status of the tool."""
    parameters: List[StreamedToolAssistedChatToolStatusParametersTypedDict]
    timestamp: float
    r"""The Unix timestamp (in seconds) for when the event occurred."""
    result: NotRequired[str]
    r"""The output from the tool’s execution."""
    files: NotRequired[List[FilesTypedDict]]
    message: NotRequired[str]
    r"""Message generated by the tool’s execution."""
    error: NotRequired[ErrorTypedDict]


class StreamedToolAssistedChatToolStatusData(BaseModel):
    tool_call_id: str
    r"""The ID of the tool call."""

    name: Name
    r"""The name of the built-in tool."""

    status: Status
    r"""Indicates the current execution status of the tool."""

    parameters: List[StreamedToolAssistedChatToolStatusParameters]

    timestamp: float
    r"""The Unix timestamp (in seconds) for when the event occurred."""

    result: Optional[str] = None
    r"""The output from the tool’s execution."""

    files: Optional[List[Files]] = None

    message: Optional[str] = None
    r"""Message generated by the tool’s execution."""

    error: Optional[Error] = None


class StreamedToolAssistedChatToolStatusTypedDict(TypedDict):
    data: StreamedToolAssistedChatToolStatusDataTypedDict
    event: Literal["tool_status"]


class StreamedToolAssistedChatToolStatus(BaseModel):
    data: StreamedToolAssistedChatToolStatusData

    EVENT: Annotated[
        Annotated[
            Literal["tool_status"], AfterValidator(validate_const("tool_status"))
        ],
        pydantic.Field(alias="event"),
    ] = "tool_status"
