def get_element_type_by_value(value):
    element__mapping = {
        0: "Any",
        1: "Other",
        2: "Application",
        3: "Group",
        4: "Window",
        5: "Sheet",
        6: "Drawer",
        7: "Alert",
        8: "Dialog",
        9: "Button",
        10: "RadioButton",
        11: "RadioGroup",
        12: "CheckBox",
        13: "DisclosureTriangle",
        14: "PopUpButton",
        15: "ComboBox",
        16: "MenuButton",
        17: "ToolbarButton",
        18: "Popover",
        19: "Keyboard",
        20: "Key",
        21: "NavigationBar",
        22: "TabBar",
        23: "TabGroup",
        24: "Toolbar",
        25: "StatusBar",
        26: "Table",
        27: "TableRow",
        28: "TableColumn",
        29: "Outline",
        30: "OutlineRow",
        31: "Browser",
        32: "CollectionView",
        33: "Slider",
        34: "PageIndicator",
        35: "ProgressIndicator",
        36: "ActivityIndicator",
        37: "SegmentedControl",
        38: "Picker",
        39: "PickerWheel",
        40: "Switch",
        41: "Toggle",
        42: "Link",
        43: "Image",
        44: "Icon",
        45: "SearchField",
        46: "ScrollView",
        47: "ScrollBar",
        48: "StaticText",
        49: "TextField",
        50: "SecureTextField",
        51: "DatePicker",
        52: "TextView",
        53: "Menu",
        54: "MenuItem",
        55: "MenuBar",
        56: "MenuBarItem",
        57: "Map",
        58: "WebView",
        59: "IncrementArrow",
        60: "DecrementArrow",
        61: "Timeline",
        62: "RatingIndicator",
        63: "ValueIndicator",
        64: "SplitGroup",
        65: "Splitter",
        66: "RelevanceIndicator",
        67: "ColorWell",
        68: "HelpTag",
        69: "Matte",
        70: "DockItem",
        71: "Ruler",
        72: "RulerMarker",
        73: "Grid",
        74: "LevelIndicator",
        75: "Cell",
        76: "LayoutArea",
        77: "LayoutItem",
        78: "Handle",
        79: "Stepper",
        80: "Tab",
        81: "TouchBar",
        82: "StatusItem",
    }
    return element__mapping.get(value, None)

def get_value_by_element_type(element_type):
    element_mapping = {
        "Any": 0,
        "Other": 1,
        "Application": 2,
        "Group": 3,
        "Window": 4,
        "Sheet": 5,
        "Drawer": 6,
        "Alert": 7,
        "Dialog": 8,
        "Button": 9,
        "RadioButton": 10,
        "RadioGroup": 11,
        "CheckBox": 12,
        "DisclosureTriangle": 13,
        "PopUpButton": 14,
        "ComboBox": 15,
        "MenuButton": 16,
        "ToolbarButton": 17,
        "Popover": 18,
        "Keyboard": 19,
        "Key": 20,
        "NavigationBar": 21,
        "TabBar": 22,
        "TabGroup": 23,
        "Toolbar": 24,
        "StatusBar": 25,
        "Table": 26,
        "TableRow": 27,
        "TableColumn": 28,
        "Outline": 29,
        "OutlineRow": 30,
        "Browser": 31,
        "CollectionView": 32,
        "Slider": 33,
        "PageIndicator": 34,
        "ProgressIndicator": 35,
        "ActivityIndicator": 36,
        "SegmentedControl": 37,
        "Picker": 38,
        "PickerWheel": 39,
        "Switch": 40,
        "Toggle": 41,
        "Link": 42,
        "Image": 43,
        "Icon": 44,
        "SearchField": 45,
        "ScrollView": 46,
        "ScrollBar": 47,
        "StaticText": 48,
        "TextField": 49,
        "SecureTextField": 50,
        "DatePicker": 51,
        "TextView": 52,
        "Menu": 53,
        "MenuItem": 54,
        "MenuBar": 55,
        "MenuBarItem": 56,
        "Map": 57,
        "WebView": 58,
        "IncrementArrow": 59,
        "DecrementArrow": 60,
        "Timeline": 61,
        "RatingIndicator": 62,
        "ValueIndicator": 63,
        "SplitGroup": 64,
        "Splitter": 65,
        "RelevanceIndicator": 66,
        "ColorWell": 67,
        "HelpTag": 68,
        "Matte": 69,
        "DockItem": 70,
        "Ruler": 71,
        "RulerMarker": 72,
        "Grid": 73,
        "LevelIndicator": 74,
        "Cell": 75,
        "LayoutArea": 76,
        "LayoutItem": 77,
        "Handle": 78,
        "Stepper": 79,
        "Tab": 80,
        "TouchBar": 81,
        "StatusItem": 82,
    }
    return element_mapping.get(element_type, None)