# AUTOGENERATED! DO NOT EDIT! File to edit: ../00_file.ipynb.

# %% auto 0
__all__ = ['read_patterns']

# %% ../00_file.ipynb 3
from collections.abc import Iterable, Sequence
import re

# %% ../00_file.ipynb 5
def read_patterns(
    lines: Iterable[str] # e.g. open('hyph-fi.tex').readlines()
) -> tuple[Sequence[str], Sequence[str]]: # patterns and exceptions
    """Read a TeX hyphenation pattern file; not a complete parser but hopefully enough
    for hyph-*.tex"""
    comment = re.compile(r' *%.*')
    state = 0
    patterns = []
    exceptions = []
    for line in lines:
        line = line.strip()
        line = comment.sub('', line)
        nextstate = state
        if line == r'\patterns{':
            state = 1
            continue
        if line == r'\hyphenation{':
            state = 2
            continue
        if '}' in line:
            line = re.sub(r'}.*', '', line)
            nextstate = 0
        if not line:
            continue           
        if state == 1:
            patterns.extend(line.split())
        elif state == 2:
            exceptions.extend(line.split())
        state = nextstate
    return patterns, exceptions
