# AUTOGENERATED! DO NOT EDIT! File to edit: ../04_main.ipynb.

# %% auto 0
__all__ = ['hyphenate_html_file']

# %% ../04_main.ipynb 3
from shyster.file import read_patterns
from shyster.pattern import convert_patterns, convert_exceptions
from shyster.hyphenation import hyphenator
from shyster.html import hyphenate_soup
import bs4

from collections.abc import Callable, Set
from typing import Type

# %% ../04_main.ipynb 5
def hyphenate_html_file(
    html_filename: str,  # to be read
    output_filename: str,  # to be written
    patterns_filename: str,  # e.g. hyphen.tex or hyph-fi.tex
    hyphen: str='\N{SOFT HYPHEN}',  # what hyphen character to use
    lefthyphenmin: int=2,  # at least this many characters before the first hyphen
    righthyphenmin: int=3,  # at least this many characters after the last hyphen
    exclude_classes: tuple[Type[bs4.element.PageElement],...]=()  # exclude these bs4 elements (empty to use default)
) -> None:
    """Read html_filename and output output_filename, inserting hyphens in words."""
    hyph = hyphenator(patterns_filename, hyphen=hyphen, lefthyphenmin=lefthyphenmin, righthyphenmin=righthyphenmin)
    with open(html_filename, 'rt') as f:
        soup = bs4.BeautifulSoup(f, 'lxml')
    kwargs = {'exclude_classes': exclude_classes} if exclude_classes else {}
    hyphenate_soup(soup, hyph, **kwargs)
    with open(output_filename, 'wt') as f:
        f.write(str(soup))
